import type { InteractionRange } from 'ag-charts-types';
import { BaseProperties } from '../../util/properties';
import type { SeriesTooltip } from './seriesTooltip';
export declare class SeriesItemHighlightStyle extends BaseProperties {
    fill?: string;
    fillOpacity?: number;
    stroke?: string;
    strokeWidth?: number;
    strokeOpacity?: number;
    lineDash?: number[];
    lineDashOffset?: number;
}
declare class SeriesHighlightStyle extends BaseProperties {
    strokeWidth?: number;
    dimOpacity?: number;
    enabled?: boolean;
}
declare class TextHighlightStyle extends BaseProperties {
    color?: string;
}
export declare class HighlightProperties extends BaseProperties {
    enabled: boolean;
}
export declare class HighlightStyle extends BaseProperties {
    readonly item: SeriesItemHighlightStyle;
    readonly series: SeriesHighlightStyle;
    readonly text: TextHighlightStyle;
}
export declare abstract class SeriesProperties<T extends object> extends BaseProperties<T> {
    id?: string;
    protected readonly visible: boolean;
    focusPriority?: number;
    showInLegend: boolean;
    cursor: string;
    nodeClickRange: InteractionRange;
    readonly highlight: HighlightProperties;
    readonly highlightStyle: HighlightStyle;
    abstract tooltip: SeriesTooltip<never>;
}
export {};
