import type { Point } from '../../scene/point';
import type { Series, SeriesNodePickIntent } from './series';
import type { SeriesNodeDatum } from './seriesTypes';
type PickedNode = {
    series: Series<any, any>;
    datum: SeriesNodeDatum;
    distance: number;
};
export declare function pickNode(inputSeries: Series<any, any>[], point: Point, intent: SeriesNodePickIntent, exactMatchOnly?: boolean): PickedNode | undefined;
export declare function datumStylerProperties<TDatum extends {
    xValue: any;
    yValue: any;
}>(datum: TDatum, xKey: string, yKey: string, xDomain: any[], yDomain: any[]): {
    datum: TDatum;
    xKey: string;
    yKey: string;
    xValue: any;
    yValue: any;
    first: boolean;
    last: boolean;
    min: boolean;
    max: boolean;
};
export declare function visibleRangeIndices(length: number, [range0, range1]: [number, number], xRange: (index: number) => [number, number] | undefined): number[];
export {};
