import type { AgChartTheme, AgChartThemePalette, AgPaletteColors, AgPresetOverrides } from 'ag-charts-types';
import { type PaletteType } from '../../module/coreModulesTypes';
import { CARTESIAN_POSITION, FONT_SIZE } from './constants';
import { type DefaultColors } from './defaultColors';
export declare class ChartTheme {
    readonly palette: Required<AgChartThemePalette> & {
        altUp: AgPaletteColors;
        altDown: AgPaletteColors;
        altNeutral: AgPaletteColors;
    };
    readonly paletteType: PaletteType;
    readonly config: any;
    readonly presets: AgPresetOverrides;
    private static getAxisDefaults;
    protected getChartDefaults(): {
        minHeight: number;
        minWidth: number;
        background: {
            visible: boolean;
            fill: string;
        };
        padding: {
            top: string;
            right: string;
            bottom: string;
            left: string;
        };
        keyboard: {
            enabled: boolean;
        };
        title: {
            enabled: boolean;
            text: string;
            fontWeight: "normal";
            fontSize: FONT_SIZE;
            fontFamily: string;
            color: string;
            wrapping: string;
            layoutStyle: string;
            textAlign: string;
        };
        subtitle: {
            enabled: boolean;
            text: string;
            spacing: number;
            fontSize: FONT_SIZE;
            fontFamily: string;
            color: string;
            wrapping: string;
            layoutStyle: string;
            textAlign: string;
        };
        footnote: {
            enabled: boolean;
            text: string;
            spacing: number;
            fontSize: FONT_SIZE;
            fontFamily: string;
            color: string;
            wrapping: string;
            layoutStyle: string;
            textAlign: string;
        };
        legend: {
            position: CARTESIAN_POSITION;
            spacing: number;
            listeners: {};
            toggleSeries: boolean;
            item: {
                paddingX: number;
                paddingY: number;
                marker: {
                    size: number;
                    padding: number;
                };
                showSeriesStroke: boolean;
                label: {
                    color: string;
                    fontSize: FONT_SIZE;
                    fontFamily: string;
                };
            };
            reverseOrder: boolean;
            pagination: {
                marker: {
                    size: number;
                };
                activeStyle: {
                    fill: string;
                };
                inactiveStyle: {
                    fill: string;
                };
                highlightStyle: {
                    fill: string;
                };
                label: {
                    color: string;
                };
            };
        };
        tooltip: {
            enabled: boolean;
            darkTheme: boolean;
            delay: number;
        };
        overlays: {
            darkTheme: boolean;
        };
        listeners: {};
    };
    private static readonly cartesianAxisDefault;
    constructor(options?: AgChartTheme);
    private mergeOverrides;
    private createChartConfigPerChartType;
    private getDefaults;
    private static applyTemplateTheme;
    templateTheme<T>(themeTemplate: T, clone?: boolean): T;
    protected getDefaultColors(): DefaultColors;
    getTemplateParameters(): Map<any, any>;
}
