import type { BBox } from '../scene/bbox';
import { Listeners } from '../util/listeners';
import { ChartUpdateType } from './chartUpdateType';
import type { ISeries } from './series/seriesTypes';
export type UpdateCallback = (type: ChartUpdateType, opts?: UpdateOpts) => void;
export interface UpdateCompleteEvent {
    type: 'update-complete';
    minRect?: BBox;
    minVisibleRect?: BBox;
}
export interface PreSceneRenderEvent {
    type: 'pre-scene-render';
    minRect?: BBox;
    minVisibleRect?: BBox;
}
export interface PreDomUpdateEvent {
    type: 'pre-dom-update';
    minRect?: never;
    minVisibleRect?: never;
}
export interface PreSceneRenderEvent {
    type: 'pre-scene-render';
    minRect?: BBox;
    minVisibleRect?: BBox;
}
export type UpdateOpts = {
    forceNodeDataRefresh?: boolean;
    skipAnimations?: boolean;
    newAnimationBatch?: boolean;
    seriesToUpdate?: Iterable<ISeries<any, any>>;
    backOffMs?: number;
    skipSync?: boolean;
};
type UpdateEventTypes = 'update-complete' | 'pre-dom-update' | 'pre-scene-render';
type UpdateEvents = UpdateCompleteEvent | PreDomUpdateEvent | PreSceneRenderEvent;
export declare class UpdateService extends Listeners<UpdateEventTypes, (event: UpdateEvents) => void> {
    private readonly updateCallback;
    constructor(updateCallback: UpdateCallback);
    update(type?: ChartUpdateType, options?: UpdateOpts): void;
    dispatchUpdateComplete(rects?: {
        minRect: BBox;
        minVisibleRect: BBox;
    }): void;
    dispatchPreDomUpdate(): void;
    dispatchPreSceneRender(rects?: {
        minRect: BBox;
        minVisibleRect: BBox;
    }): void;
}
export {};
