import { BBox } from '../scene/bbox';
import { BaseManager } from '../util/baseManager';
import { type Size } from '../util/sizeMonitor';
declare const DOM_ELEMENT_CLASSES: readonly ["styles", "canvas", "canvas-center", "canvas-container", "canvas-overlay", "canvas-proxy", "series-area"];
type DOMElementClass = (typeof DOM_ELEMENT_CLASSES)[number];
type DOMInsertOption = {
    where: InsertPosition;
    query: string;
};
type Events = {
    type: 'hidden';
} | {
    type: 'resize';
} | {
    type: 'container-changed';
};
export declare class DOMManager extends BaseManager<Events['type'], Events> {
    private readonly rootElements;
    private readonly styles;
    private readonly element;
    private readonly styleRootElement?;
    private container?;
    containerSize?: Size;
    private readonly tabGuards;
    private readonly observer?;
    private readonly sizeMonitor;
    constructor(container?: HTMLElement, styleContainer?: HTMLElement);
    destroy(): void;
    setSizeOptions(minWidth?: number, minHeight?: number, optionsWidth?: number, optionsHeight?: number): void;
    private updateContainerSize;
    setTabGuardIndex(tabIndex: number): void;
    setContainer(newContainer: HTMLElement): void;
    setThemeClass(themeClassName: string): void;
    updateCanvasLabel(ariaLabel: string): void;
    private getEventElement;
    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;
    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;
    /** Get the main chart area client bound rect. */
    getBoundingClientRect(): DOMRect;
    /**
     * Get the client bounding rect for overlay elements that might float outside the bounds of the
     * main chart area.
     */
    getOverlayClientRect(): DOMRect;
    private getRawOverlayClientRect;
    getShadowDocumentRoot(current?: HTMLElement | undefined): HTMLElement | undefined;
    getParent(domElementClass: DOMElementClass): HTMLElement;
    getChildBoundingClientRect(type: DOMElementClass): BBox;
    calculateCanvasPosition(el: HTMLElement): {
        x: number;
        y: number;
    };
    isManagedChildDOMElement(el: HTMLElement, domElementClass: DOMElementClass, id: string): boolean;
    contains(element: HTMLElement, domElementClass?: DOMElementClass): boolean;
    addStyles(id: string, styles: string): void;
    removeStyles(id: string): void;
    updateCursor(style: string): void;
    getCursor(): string;
    addChild(domElementClass: DOMElementClass, id: string, child?: HTMLElement, insert?: DOMInsertOption): HTMLElement;
    removeChild(domElementClass: DOMElementClass, id: string): void;
    incrementDataCounter(name: string): void;
    setDataBoolean(name: string, value: boolean): void;
}
export {};
