import type { AgCartesianAxisPosition } from 'ag-charts-types';
import type { ChartAxisDirection } from '../chart/chartAxisDirection';
import type { Scale } from '../scale/scale';
import type { Node } from '../scene/node';
import type { BBoxValues } from '../util/bboxinterface';
export interface AxisContext {
    axisId: string;
    continuous: boolean;
    direction: ChartAxisDirection;
    position?: AgCartesianAxisPosition;
    scale: Scale<any, any, any>;
    getCanvasBounds(): BBoxValues | undefined;
    seriesKeyProperties(): string[];
    scaleInvert(position: number): any;
    scaleInvertNearest(position: number): any;
    scaleValueFormatter(specifier?: string): (x: any) => string;
    attachLabel(node: Node): void;
    inRange(x: number, tolerance?: number): boolean;
}
