import type { DataController } from '../chart/data/dataController';
import type { BBox } from '../scene/bbox';
export interface LayoutContext {
    width: number;
    height: number;
    layoutBox: BBox;
}
export interface ModuleInstance {
    processData?: (dataController: DataController) => Promise<void>;
    updateData?: (data: any) => void;
    destroy(): void;
}
export type ChartTypes = 'cartesian' | 'polar' | 'hierarchy' | 'topology' | 'flow-proportion' | 'standalone' | 'gauge';
export interface BaseModule<T extends ChartTypes = ChartTypes> {
    packageType: 'community' | 'enterprise';
    chartTypes: T[];
    identifier?: string;
    dependencies?: string[];
}
export interface BaseOptionsModule<T extends ChartTypes = ChartTypes> extends BaseModule<T> {
    optionsKey: string;
}
