import type { Scale } from './scale';
export declare abstract class ContinuousScale<D extends number | Date, I = number> implements Scale<D, number, I> {
    static is(value: unknown): value is ContinuousScale<any, any>;
    static readonly defaultTickCount = 5;
    static readonly defaultMaxTickCount = 6;
    abstract type: Scale<D, number, I>['type'];
    protected invalid: boolean;
    domain: D[];
    range: number[];
    nice: boolean;
    interval?: I;
    tickCount: number;
    minTickCount: number;
    maxTickCount: number;
    niceDomain: any[];
    protected defaultClamp: boolean;
    protected constructor(domain: D[], range: number[]);
    protected transform(x: D): D;
    protected transformInvert(x: D): D;
    calcBandwidth(smallestInterval?: number): number;
    abstract toDomain(d: number): D;
    getDomain(): any[];
    convert(x: D, clamp?: boolean): number;
    invert(x: number, clamp?: boolean): D;
    abstract update(): void;
    protected abstract updateNiceDomain(): void;
    protected refresh(): void;
    protected getPixelRange(): number;
}
