import { TimeInterval } from '../util/time/interval';
import { ContinuousScale } from './continuousScale';
export declare class TimeScale extends ContinuousScale<Date, TimeInterval | number> {
    readonly type = "time";
    constructor();
    toDomain(d: number): Date;
    convert(value: Date, clamp?: boolean): number;
    invert(value: number): Date;
    /**
     * Returns uniformly-spaced dates that represent the scale's domain.
     */
    ticks(): Date[];
    static getDefaultTicks({ start, stop, tickCount, minTickCount, maxTickCount, }: {
        start: number;
        stop: number;
        tickCount: number;
        minTickCount: number;
        maxTickCount: number;
    }): Date[];
    static getTicksForInterval({ start, stop, interval, availableRange, }: {
        start: number;
        stop: number;
        interval: number | TimeInterval;
        availableRange: number;
    }): Date[] | undefined;
    /**
     * Returns a time format function suitable for displaying tick values.
     *
     * @param ticks Optional array of tick values for custom formatting.
     * @param domain Optional array representing the [min, max] values of the time axis.
     * @param specifier Optional format specifier string for custom date formatting (e.g., `%Y`, `%m`, `%d`).
     * @param formatOffset Optional number for applying an offset to the format (e.g., timezone shifts).
     * @returns A function that formats a `Date` object into a string based on the provided specifier or default format.
     */
    tickFormat({ ticks, domain, specifier, formatOffset, }: {
        ticks?: any[];
        domain?: any[];
        specifier?: string;
        formatOffset?: number;
    }): (date: Date) => string;
    update(): void;
    /**
     * Extends the domain so that it starts and ends on nice round values.
     * This method typically modifies the scale’s domain, and may only extend the bounds to the nearest round value.
     */
    protected updateNiceDomain(): void;
    protected updateNiceDomainIteration(d0: Date, d1: Date): void;
}
