import { BBox } from './bbox';
import type { LayersManager } from './layersManager';
import type { ChildNodeCounts, RenderContext } from './node';
import { Node } from './node';
import type { CanvasContext } from './shape/shape';
import { type ZIndex } from './zIndex';
export declare class Group extends Node {
    static className: string;
    static is(value: unknown): value is Group;
    static computeChildrenBBox(nodes: Iterable<Node>, skipInvisible?: boolean): BBox;
    private static compareChildren;
    private clipRect?;
    opacity: number;
    private layer;
    renderToOffscreenCanvas: boolean;
    constructor(opts?: {
        readonly name?: string;
        readonly zIndex?: ZIndex;
        readonly renderToOffscreenCanvas?: boolean;
    });
    containsPoint(_x: number, _y: number): boolean;
    protected computeBBox(): BBox;
    private isDirty;
    preRender(): ChildNodeCounts;
    render(renderCtx: RenderContext): void;
    private skipRender;
    protected applyClip(ctx: CanvasContext, clipRect: BBox): void;
    private renderInContext;
    /**
     * Transforms bbox given in the canvas coordinate space to bbox in this group's coordinate space and
     * sets this group's clipRect to the transformed bbox.
     * @param bbox clipRect bbox in the canvas coordinate space.
     */
    setClipRect(bbox?: BBox): void;
    /**
     * Set the clip rect within the canvas coordinate space.
     * @param bbox clipRect bbox in the canvas coordinate space.
     */
    setClipRectCanvasSpace(bbox?: BBox): void;
    _setLayerManager(layersManager?: LayersManager): void;
    private getVisibility;
    toSVG(): {
        elements: SVGElement[];
        defs?: SVGElement[];
    } | undefined;
}
declare const ScalableGroup_base: new (...args: any[]) => import("./transformable").ScalableType<Group>;
export declare class ScalableGroup extends ScalableGroup_base {
}
declare const RotatableGroup_base: new (...args: any[]) => import("./transformable").RotatableType<Group>;
export declare class RotatableGroup extends RotatableGroup_base {
}
declare const TranslatableGroup_base: new (...args: any[]) => import("./transformable").TranslatableType<Group>;
export declare class TranslatableGroup extends TranslatableGroup_base {
}
declare const TransformableGroup_base: new (...args: any[]) => import("./transformable").RotatableType<import("./transformable").TranslatableType<Group>>;
export declare class TransformableGroup extends TransformableGroup_base {
}
export {};
