import { BBox } from '../bbox';
import type { NodeOptions, RenderContext } from '../node';
import { Shape } from './shape';
export declare class Range extends Shape {
    static readonly className = "Range";
    protected static defaultStyles: {
        strokeWidth: number;
        fill?: string | undefined;
        stroke?: string | undefined;
        lineDash?: number[] | undefined;
        lineDashOffset: number;
        lineCap?: import("./shape").ShapeLineCap | undefined;
        lineJoin?: import("./shape").ShapeLineJoin | undefined;
        opacity: number;
        fillShadow?: import("../dropShadow").DropShadow | undefined;
    };
    constructor(opts?: NodeOptions);
    x1: number;
    y1: number;
    x2: number;
    y2: number;
    startLine: boolean;
    endLine: boolean;
    isRange: boolean;
    protected computeBBox(): BBox;
    isPointInPath(_x: number, _y: number): boolean;
    render(renderCtx: RenderContext): void;
}
