import type { FontFamily, FontSize, FontStyle, FontWeight } from 'ag-charts-types';
import { type MeasureOptions } from '../../util/textMeasurer';
import { BBox } from '../bbox';
import type { RenderContext } from '../node';
import { Shape } from './shape';
export interface TextSizeProperties {
    fontFamily?: FontFamily;
    fontSize?: FontSize;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    lineHeight?: number;
    textBaseline?: CanvasTextBaseline;
    textAlign?: CanvasTextAlign;
}
export declare class Text extends Shape {
    static readonly className = "Text";
    static readonly defaultStyles: {
        textAlign: CanvasTextAlign;
        fontStyle: undefined;
        fontWeight: undefined;
        fontSize: number;
        fontFamily: string;
        textBaseline: CanvasTextBaseline;
        fill?: string | undefined;
        stroke?: string | undefined;
        strokeWidth: number;
        lineDash?: number[] | undefined;
        lineDashOffset: number;
        lineCap?: import("./shape").ShapeLineCap | undefined;
        lineJoin?: import("./shape").ShapeLineJoin | undefined;
        opacity: number;
        fillShadow?: import("../dropShadow").DropShadow | undefined;
    };
    x: number;
    y: number;
    private lines;
    private onTextChange;
    text?: string;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    fontSize?: number;
    fontFamily?: string;
    textAlign: CanvasTextAlign;
    textBaseline: CanvasTextBaseline;
    lineHeight?: number;
    static computeBBox(lines: string | string[], x: number, y: number, opts: MeasureOptions): BBox;
    protected computeBBox(): BBox;
    isPointInPath(x: number, y: number): boolean;
    render(renderCtx: RenderContext): void;
    private renderLines;
    setFont(props: TextSizeProperties): void;
    setAlign(props: {
        textAlign: CanvasTextAlign;
        textBaseline: CanvasTextBaseline;
    }): void;
    toSVG(): {
        elements: SVGElement[];
        defs?: SVGElement[];
    } | undefined;
}
declare const RotatableText_base: new (...args: any[]) => import("../transformable").RotatableType<Text>;
export declare class RotatableText extends RotatableText_base {
}
declare const TransformableText_base: new (...args: any[]) => import("../transformable").RotatableType<import("../transformable").TranslatableType<Text>>;
export declare class TransformableText extends TransformableText_base {
}
export {};
