import type { Node } from './node';
type RenderSpriteOptions = {
    scale: number;
    translateX: number;
    translateY: number;
};
export type SpriteDimensions = {
    spritePixelRatio: number;
    spriteAAPadding: number;
    spriteWidth: number;
    spriteHeight: number;
    markerWidth: number;
};
export declare class SpriteRenderer {
    static offscreenCanvasCount: number;
    private readonly offscreenCanvas;
    private readonly renderCtx;
    constructor();
    resize({ spritePixelRatio, spriteWidth, spriteHeight }: SpriteDimensions): void;
    renderSprite(nodes: Node | Iterable<Node>, opts?: RenderSpriteOptions): ImageBitmap;
}
export {};
