/**
 * Normalize the given angle to be in the [0, 2π) interval.
 * @param radians Angle in radians.
 */
export declare function normalizeAngle360(radians: number): number;
export declare function normalizeAngle360Inclusive(radians: number): number;
/**
 * Normalize the given angle to be in the [-π, π) interval.
 * @param radians Angle in radians.
 */
export declare function normalizeAngle180(radians: number): number;
export declare function isBetweenAngles(targetAngle: number, startAngle: number, endAngle: number): boolean;
export declare function toRadians(degrees: number): number;
export declare function toDegrees(radians: number): number;
export declare function angleDiff(angle0: number, angle1: number, counterClockwise: boolean): number;
/**
 * Returns a rotation angle between two other angles.
 * @param angle0 Angle in radians.
 * @param angle1 Angle in radians.
 * @returns Angle in radians.
 */
export declare function angleBetween(angle0: number, angle1: number): number;
export declare function displacePointFromVector(centerX: number, centerY: number, radius: number, angle: number): {
    x: number;
    y: number;
};
export declare function clockwiseAngle(angle: number, relativeToStartAngle: number): number;
export declare function clockwiseAngles(startAngle: number, endAngle: number, relativeToStartAngle?: number): {
    startAngle: number;
    endAngle: number;
};
/**
 * Calculates the ratio of an angle in radians based on its proximity to 0, π/2, π, or 3π/2.
 *
 * - 0 and π return ratios decreasing linearly to 0 at these angles.
 * - π/2 and 3π/2 return ratios increasing linearly to 1 at these angles.
 *
 * @param angle - The input angle in radians.
 * @returns The ratio (a number between 0 and 1).
 */
export declare function getAngleRatioRadians(angle: number): number;
