import type { AgIconName } from 'ag-charts-types';
import { BBoxValues } from './bboxinterface';
export declare function getDocument<E>(): Document & E;
export declare function getDocument<K extends keyof Document>(propertyName: K): Document[K];
export declare function getWindow<E>(): Window & E;
export declare function getWindow<K extends keyof Window>(propertyName: K): Window[K];
export declare function getWindow<R = unknown>(propertyName: string): R;
export declare function createElement<K extends keyof HTMLElementTagNameMap>(tagName: K, style?: Partial<CSSStyleDeclaration>): HTMLElementTagNameMap[K];
export declare function createElement<K extends keyof HTMLElementTagNameMap>(tagName: K, className?: string, style?: Partial<CSSStyleDeclaration>): HTMLElementTagNameMap[K];
export declare function createElementNS<K extends keyof SVGElementTagNameMap>(namespaceURI: 'http://www.w3.org/2000/svg', qualifiedName: K): SVGElementTagNameMap[K];
export declare function downloadUrl(dataUrl: string, fileName: string): void;
export declare function setDocument(document: Document): void;
export declare function setWindow(window: Window): void;
export declare function setElementBBox(element: HTMLElement | undefined, bbox: Partial<BBoxValues>): void;
export declare function getElementBBox(element: HTMLElement): BBoxValues;
export declare function focusCursorAtEnd(element: HTMLElement): void;
export declare function createElementId(label?: string): string;
export declare function isInputPending(): false | void;
export declare function getIconClassNames(icon: AgIconName): string;
