import { type BaseAttributeTypeMap, type BaseStyleTypeMap } from '../util/attributeUtil';
import type { BBoxValues } from '../util/bboxinterface';
import { type WidgetEventMap } from './widgetEvents';
import { WidgetListenerHTML } from './widgetListenerHTML';
import { WidgetListenerInternal } from './widgetListenerInternal';
type EventMap = WidgetEventMap;
type EventType = keyof WidgetEventMap;
interface IWidget<TElement extends HTMLElement> {
    index: number;
    domIndex?: number;
    parent?: Widget<HTMLElement, IWidget<HTMLElement>>;
    destroy(): void;
    getElement(): TElement;
}
export type BeforeWidget<T extends IWidget<HTMLElement>> = T & {
    domIndex: number;
};
declare abstract class WidgetBounds {
    protected readonly elem: HTMLElement;
    protected elemContainer?: HTMLDivElement;
    constructor(elem: HTMLElement);
    setBounds(bounds: Partial<BBoxValues>): void;
    getBounds(): BBoxValues;
    protected static setElementContainer(widget: WidgetBounds, elemContainer: HTMLDivElement): void;
}
export declare abstract class Widget<TElement extends HTMLElement = HTMLElement, TChildWidget extends IWidget<HTMLElement> = IWidget<HTMLElement>> extends WidgetBounds implements IWidget<TElement> {
    protected readonly elem: TElement;
    index: number;
    domIndex?: number;
    parent?: Widget<HTMLElement, IWidget<HTMLElement>>;
    protected readonly children: TChildWidget[];
    protected htmlListener?: WidgetListenerHTML;
    protected internalListener?: WidgetListenerInternal;
    constructor(elem: TElement);
    protected abstract destructor(): void;
    getElement(): TElement;
    get clientWidth(): number;
    get clientHeight(): number;
    destroy(): void;
    setHidden(hidden: boolean): void;
    isHidden(): boolean;
    setCursor(cursor: BaseStyleTypeMap['cursor'] | undefined): void;
    setTextContent(textContent: string | undefined): void;
    setAriaDescribedBy(ariaDescribedBy: BaseAttributeTypeMap['aria-describedby'] | undefined): void;
    setAriaHidden(ariaHidden: BaseAttributeTypeMap['aria-hidden'] | undefined): void;
    setAriaLabel(ariaLabel: BaseAttributeTypeMap['aria-label'] | undefined): void;
    setInnerHTML(html: string): void;
    isDisabled(): boolean;
    private parseFloat;
    cssLeft(): number;
    cssTop(): number;
    focus(): void;
    setPreventsDefault(preventDefault: boolean): void;
    setTabIndex(tabIndex: BaseAttributeTypeMap['tabindex']): void;
    addChild(child: TChildWidget): void;
    removeChild(child: TChildWidget): void;
    addClass(...tokens: string[]): void;
    removeClass(...tokens: string[]): void;
    toggleClass(token: string, force?: boolean): void;
    protected appendOrInsert(child: HTMLElement, before: TChildWidget | undefined): void;
    protected addChildToDOM(child: TChildWidget, before: TChildWidget | undefined): void;
    protected removeChildFromDOM(child: TChildWidget): void;
    protected onChildAdded(_child: TChildWidget): void;
    protected onChildRemoved(_child: TChildWidget): void;
    private getBefore;
    addListener<K extends EventType>(type: K, listener: (ev: EventMap[K], current: typeof this) => unknown): void;
    removeListener<K extends EventType>(type: K, listener: (ev: EventMap[K], current: typeof this) => unknown): void;
}
export {};
