type FocusWidgetEventType = 'blur' | 'focus';
type KeyboardWidgetEventType = 'keyup' | 'keydown';
type MouseWidgetEventType = 'contextmenu' | 'click' | 'dblclick' | 'mouseenter' | 'mousemove' | 'mouseleave';
type DragWidgetEventType = 'drag-start' | 'drag-move' | 'drag-end';
export type WidgetEvent = {
    type: keyof WidgetEventMap;
    sourceEvent: Event;
};
export type FocusWidgetEvent<T extends FocusWidgetEventType = FocusWidgetEventType> = {
    type: T;
    sourceEvent: FocusEvent;
};
export type KeyboardWidgetEvent<T extends KeyboardWidgetEventType = KeyboardWidgetEventType> = {
    type: T;
    sourceEvent: KeyboardEvent;
};
export type MouseWidgetEvent<T extends MouseWidgetEventType = MouseWidgetEventType> = {
    type: T;
    offsetX: number;
    offsetY: number;
    clientX: number;
    clientY: number;
    sourceEvent: MouseEvent;
};
export type WheelWidgetEvent = {
    type: 'wheel';
    offsetX: number;
    offsetY: number;
    clientX: number;
    clientY: number;
    deltaX: number;
    deltaY: number;
    sourceEvent: WheelEvent;
};
export type DragWidgetEvent<T extends DragWidgetEventType = DragWidgetEventType> = {
    type: T;
    offsetX: number;
    offsetY: number;
    clientX: number;
    clientY: number;
    originDeltaX: number;
    originDeltaY: number;
    sourceEvent: MouseEvent | TouchEvent;
};
export type WidgetEventMap = {
    'drag-start': DragWidgetEvent<'drag-start'>;
    'drag-move': DragWidgetEvent<'drag-move'>;
    'drag-end': DragWidgetEvent<'drag-end'>;
    blur: FocusWidgetEvent<'blur'>;
    change: WidgetEvent;
    contextmenu: MouseWidgetEvent<'contextmenu'>;
    focus: FocusWidgetEvent<'focus'>;
    keydown: KeyboardWidgetEvent<'keydown'>;
    keyup: KeyboardWidgetEvent<'keyup'>;
    click: MouseWidgetEvent<'click'>;
    dblclick: MouseWidgetEvent<'dblclick'>;
    mouseenter: MouseWidgetEvent<'mouseenter'>;
    mousemove: MouseWidgetEvent<'mousemove'>;
    mouseleave: MouseWidgetEvent<'mouseleave'>;
    wheel: WheelWidgetEvent;
};
export declare const WIDGET_HTML_EVENTS: readonly (keyof WidgetEventMap & keyof HTMLElementEventMap)[];
export type WidgetSourceEventMap = {
    [K in keyof WidgetEventMap]: WidgetEventMap[K]['sourceEvent'];
};
export type WidgetEventMap_HTML = Pick<WidgetEventMap, (typeof WIDGET_HTML_EVENTS)[number]>;
export type WidgetEventMap_Internal = Omit<WidgetEventMap, (typeof WIDGET_HTML_EVENTS)[number]>;
export type WidgetSourceEventMap_HTML = Pick<WidgetSourceEventMap, (typeof WIDGET_HTML_EVENTS)[number]>;
export type WidgetSourceEventMap_Internal = Omit<WidgetSourceEventMap, (typeof WIDGET_HTML_EVENTS)[number]>;
export declare class WidgetEventUtil {
    static alloc<K extends keyof WidgetEventMap_HTML>(type: K, sourceEvent: WidgetSourceEventMap_HTML[K]): WidgetEventMap_HTML[K];
    static isHTMLEvent(type: keyof WidgetEventMap): type is keyof WidgetEventMap & keyof HTMLElementEventMap;
}
export {};
