import type { WidgetEventMap_Internal } from './widgetEvents';
type EventMap = WidgetEventMap_Internal;
type EventType = keyof WidgetEventMap_Internal;
type EventHandler<T, K extends EventType = EventType> = (event: EventMap[K], current: T) => unknown;
type Targetable = {
    getElement(): HTMLElement;
};
type DragCallbacks = {
    down: (event: MouseEvent) => void;
    move: (event: MouseEvent) => void;
    up: (event: MouseEvent) => void;
};
export declare class WidgetListenerInternal {
    private dragTriggerRemovers?;
    private dragStartListeners?;
    private dragMoveListeners?;
    private dragEndListeners?;
    static globalDragCallbacks?: DragCallbacks;
    private localDragCallbacks?;
    destroy(): void;
    add<T extends Targetable, K extends EventType>(type: K, target: T, handler: EventHandler<T, K>): void;
    remove<T extends Targetable, K extends EventType>(type: K, _target: T, handler: EventHandler<T, K>): void;
    private removeHandler;
    private registerDragTrigger;
    private startDrag;
    private endDrag;
    private dispatch;
}
export {};
