// Type definitions for ag-grid-community v19.1.1
// Project: http://www.ag-grid.com/
// Definitions by: Niall Crosby <https://github.com/ag-grid/>
import { RowNode } from "./entities/rowNode";
import { GetContextMenuItems, GetMainMenuItems, GetRowNodeIdFunc, GridOptions, IsRowMaster, IsRowSelectable, NavigateToNextCellParams, NodeChildDetails, PaginationNumberFormatterParams, PostProcessPopupParams, ProcessDataFromClipboardParams, TabToNextCellParams } from "./entities/gridOptions";
import { GridApi } from "./gridApi";
import { ColDef, ColGroupDef, IAggFunc } from "./entities/colDef";
import { ColumnApi } from "./columnController/columnApi";
import { IViewportDatasource } from "./interfaces/iViewportDatasource";
import { IDatasource } from "./rowModels/iDatasource";
import { GridCellDef } from "./entities/gridCell";
import { IServerSideDatasource } from "./interfaces/iServerSideDatasource";
import { BaseExportParams, ProcessCellForExportParams, ProcessHeaderForExportParams } from "./exporter/exportParams";
import { AgEvent } from "./events";
import { SideBarDef } from "./entities/sideBar";
export interface PropertyChangedEvent extends AgEvent {
    currentValue: any;
    previousValue: any;
}
export declare class GridOptionsWrapper {
    private static MIN_COL_WIDTH;
    static PROP_HEADER_HEIGHT: string;
    static PROP_GROUP_REMOVE_SINGLE_CHILDREN: string;
    static PROP_GROUP_REMOVE_LOWEST_SINGLE_CHILDREN: string;
    static PROP_PIVOT_HEADER_HEIGHT: string;
    static PROP_SUPPRESS_CLIPBOARD_PASTE: string;
    static PROP_GROUP_HEADER_HEIGHT: string;
    static PROP_PIVOT_GROUP_HEADER_HEIGHT: string;
    static PROP_FLOATING_FILTERS_HEIGHT: string;
    static PROP_SUPPRESS_ROW_DRAG: string;
    static PROP_POPUP_PARENT: string;
    static PROP_DOM_LAYOUT: string;
    private gridOptions;
    private columnController;
    private eventService;
    private enterprise;
    private frameworkFactory;
    private gridApi;
    private columnApi;
    private environment;
    private autoHeightCalculator;
    private propertyEventService;
    private domDataKey;
    private layoutElements;
    private agWire;
    private destroy;
    init(): void;
    private checkColumnDefProperties;
    private checkGridOptionsProperties;
    private checkProperties;
    getDomData(element: Node, key: string): any;
    setDomData(element: Element, key: string, value: any): any;
    isEnterprise(): boolean;
    isRowSelection(): boolean;
    isRowDeselection(): boolean;
    isRowSelectionMulti(): boolean;
    isRowMultiSelectWithClick(): boolean;
    getContext(): any;
    isPivotMode(): boolean;
    isPivotTotals(): boolean;
    getPivotColumnGroupTotals(): string;
    getPivotRowTotals(): string;
    isRowModelInfinite(): boolean;
    isRowModelViewport(): boolean;
    isRowModelServerSide(): boolean;
    isRowModelDefault(): boolean;
    isFullRowEdit(): boolean;
    isSuppressFocusAfterRefresh(): boolean;
    isShowToolPanel(): boolean;
    getSideBar(): SideBarDef;
    isSuppressTouch(): boolean;
    isSuppressRowTransform(): boolean;
    isSuppressSetColumnStateEvents(): boolean;
    useAsyncEvents(): boolean;
    isEnableCellChangeFlash(): boolean;
    isGroupSelectsChildren(): boolean;
    isSuppressRowHoverHighlight(): boolean;
    isGroupSelectsFiltered(): boolean;
    isGroupHideOpenParents(): boolean;
    isGroupMultiAutoColumn(): boolean;
    isGroupRemoveSingleChildren(): boolean;
    isGroupRemoveLowestSingleChildren(): boolean;
    isGroupIncludeFooter(): boolean;
    isGroupIncludeTotalFooter(): boolean;
    isGroupSuppressBlankHeader(): boolean;
    isSuppressRowClickSelection(): boolean;
    isSuppressCellSelection(): boolean;
    isSuppressMultiSort(): boolean;
    isMultiSortKeyCtrl(): boolean;
    isGroupSuppressAutoColumn(): boolean;
    isSuppressDragLeaveHidesColumns(): boolean;
    isSuppressScrollOnNewData(): boolean;
    isRowDragManaged(): boolean;
    isSuppressRowDrag(): boolean;
    getDomLayout(): string;
    isSuppressHorizontalScroll(): boolean;
    isSuppressLoadingOverlay(): boolean;
    isSuppressNoRowsOverlay(): boolean;
    isSuppressFieldDotNotation(): boolean;
    getPinnedTopRowData(): any[];
    getPinnedBottomRowData(): any[];
    isFunctionsPassive(): boolean;
    isSuppressTabbing(): boolean;
    isSuppressChangeDetection(): boolean;
    isSuppressAnimationFrame(): boolean;
    getQuickFilterText(): string;
    isCacheQuickFilter(): boolean;
    isUnSortIcon(): boolean;
    isSuppressMenuHide(): boolean;
    isEnterMovesDownAfterEdit(): boolean;
    isEnterMovesDown(): boolean;
    getRowStyle(): any;
    getRowClass(): string | string[];
    getRowStyleFunc(): Function;
    getRowClassFunc(): (params: any) => string | string[];
    rowClassRules(): {
        [cssClassName: string]: string | ((params: any) => boolean);
    };
    getPopupParent(): HTMLElement;
    getBlockLoadDebounceMillis(): number;
    getPostProcessPopupFunc(): (params: PostProcessPopupParams) => void;
    getDoesDataFlowerFunc(): (data: any) => boolean;
    getPaginationNumberFormatterFunc(): (params: PaginationNumberFormatterParams) => string;
    getChildCountFunc(): (dataItem: any) => number;
    getDefaultGroupSortComparator(): (nodeA: RowNode, nodeB: RowNode) => number;
    getIsFullWidthCellFunc(): (rowNode: RowNode) => boolean;
    getFullWidthCellRendererParams(): any;
    isEmbedFullWidthRows(): boolean;
    getBusinessKeyForNodeFunc(): (node: RowNode) => string;
    getApi(): GridApi;
    getColumnApi(): ColumnApi;
    isDeltaRowDataMode(): boolean;
    isEnsureDomOrder(): boolean;
    isEnableColResize(): boolean;
    getColResizeDefault(): string;
    isSingleClickEdit(): boolean;
    isSuppressClickEdit(): boolean;
    isStopEditingWhenGridLosesFocus(): boolean;
    getGroupDefaultExpanded(): number;
    getMaxConcurrentDatasourceRequests(): number;
    getMaxBlocksInCache(): number;
    getCacheOverflowSize(): number;
    getPaginationPageSize(): number;
    getCacheBlockSize(): number;
    getInfiniteInitialRowCount(): number;
    isPurgeClosedRowNodes(): boolean;
    isSuppressPaginationPanel(): boolean;
    getRowData(): any[];
    isGroupUseEntireRow(): boolean;
    isEnableRtl(): boolean;
    getAutoGroupColumnDef(): ColDef;
    isGroupSuppressRow(): boolean;
    getRowGroupPanelShow(): string;
    getPivotPanelShow(): string;
    isAngularCompileRows(): boolean;
    isAngularCompileFilters(): boolean;
    isAngularCompileHeaders(): boolean;
    isDebug(): boolean;
    getColumnDefs(): (ColDef | ColGroupDef)[];
    getColumnTypes(): {
        [key: string]: ColDef;
    };
    getDatasource(): IDatasource;
    getViewportDatasource(): IViewportDatasource;
    getServerSideDatasource(): IServerSideDatasource;
    isEnableSorting(): boolean;
    isAccentedSort(): boolean;
    isEnableCellExpressions(): boolean;
    isEnableGroupEdit(): boolean;
    isSuppressMiddleClickScrolls(): boolean;
    isSuppressPreventDefaultOnMouseWheel(): boolean;
    isSuppressColumnVirtualisation(): boolean;
    isSuppressContextMenu(): boolean;
    isAllowContextMenuWithControlKey(): boolean;
    isSuppressCopyRowsToClipboard(): boolean;
    isSuppressClipboardPaste(): boolean;
    isEnableFilter(): boolean;
    isPagination(): boolean;
    isSuppressEnterpriseResetOnNewColumns(): boolean;
    getProcessDataFromClipboardFunc(): ((params: ProcessDataFromClipboardParams) => string[][]);
    getBatchUpdateWaitMillis(): number;
    isEnableServerSideFilter(): boolean;
    isEnableServerSideSorting(): boolean;
    isSuppressMovableColumns(): boolean;
    isAnimateRows(): boolean;
    isSuppressColumnMoveAnimation(): boolean;
    isSuppressAggFuncInHeader(): boolean;
    isSuppressAggAtRootLevel(): boolean;
    isEnableRangeSelection(): boolean;
    isSuppressMultiRangeSelection(): boolean;
    isPaginationAutoPageSize(): boolean;
    isRememberGroupStateWhenNewData(): boolean;
    getIcons(): any;
    getAggFuncs(): {
        [key: string]: IAggFunc;
    };
    getSortingOrder(): string[];
    getAlignedGrids(): GridOptions[];
    isMasterDetail(): boolean;
    getIsRowMasterFunc(): IsRowMaster;
    getIsRowSelectableFunc(): IsRowSelectable;
    getGroupRowRendererParams(): any;
    getOverlayLoadingTemplate(): string;
    getOverlayNoRowsTemplate(): string;
    isSuppressAutoSize(): boolean;
    isSuppressParentsInRowNodes(): boolean;
    isFunctionsReadOnly(): boolean;
    isFloatingFilter(): boolean;
    isEnableOldSetFilterModel(): boolean;
    getDefaultColDef(): ColDef;
    getDefaultColGroupDef(): ColGroupDef;
    getDefaultExportParams(): BaseExportParams;
    isSuppressCsvExport(): boolean;
    isSuppressExcelExport(): boolean;
    isSuppressMakeColumnVisibleAfterUnGroup(): boolean;
    getNodeChildDetailsFunc(): ((dataItem: any) => NodeChildDetails);
    getDataPathFunc(): ((dataItem: any) => string[]);
    getIsServerSideGroupFunc(): ((dataItem: any) => boolean);
    getServerSideGroupKeyFunc(): ((dataItem: any) => string);
    getGroupRowAggNodesFunc(): (nodes: RowNode[]) => any;
    getContextMenuItemsFunc(): GetContextMenuItems;
    getMainMenuItemsFunc(): GetMainMenuItems;
    getRowNodeIdFunc(): GetRowNodeIdFunc;
    getNavigateToNextCellFunc(): (params: NavigateToNextCellParams) => GridCellDef;
    getTabToNextCellFunc(): (params: TabToNextCellParams) => GridCellDef;
    isTreeData(): boolean;
    isValueCache(): boolean;
    isValueCacheNeverExpires(): boolean;
    isAggregateOnlyChangedColumns(): boolean;
    getProcessSecondaryColDefFunc(): (colDef: ColDef) => void;
    getProcessSecondaryColGroupDefFunc(): (colGroupDef: ColGroupDef) => void;
    getSendToClipboardFunc(): (params: any) => void;
    getProcessRowPostCreateFunc(): any;
    getProcessCellForClipboardFunc(): (params: ProcessCellForExportParams) => any;
    getProcessHeaderForClipboardFunc(): (params: ProcessHeaderForExportParams) => any;
    getProcessCellFromClipboardFunc(): (params: ProcessCellForExportParams) => any;
    getViewportRowModelPageSize(): number;
    getViewportRowModelBufferSize(): number;
    isServerSideSortingAlwaysResets(): boolean;
    getPostSortFunc(): (rowNodes: RowNode[]) => void;
    getClipboardDeliminator(): string;
    setProperty(key: string, value: any): void;
    addLayoutElement(element: HTMLElement): void;
    private updateLayoutClasses;
    addEventListener(key: string, listener: Function): void;
    static checkEventDeprecation(eventName: string): void;
    removeEventListener(key: string, listener: Function): void;
    getAutoSizePadding(): number;
    getHeaderHeight(): number;
    getFloatingFiltersHeight(): number;
    getGroupHeaderHeight(): number;
    getPivotHeaderHeight(): number;
    getPivotGroupHeaderHeight(): number;
    isExternalFilterPresent(): boolean;
    doesExternalFilterPass(node: RowNode): boolean;
    getDocument(): Document;
    getMinColWidth(): number;
    getMaxColWidth(): number;
    getColWidth(): number;
    getRowBuffer(): number;
    getScrollbarWidth(): number;
    private checkForDeprecated;
    private checkForViolations;
    private treeDataViolations;
    getLocaleTextFunc(): Function;
    globalEventHandler(eventName: string, event?: any): void;
    getRowHeightAsNumber(): number;
    getRowHeightForNode(rowNode: RowNode): number;
    isDynamicRowHeight(): boolean;
    getVirtualItemHeight(): number;
    private isNumeric;
    private specialForNewMaterial;
    private getDefaultRowHeight;
}
//# sourceMappingURL=gridOptionsWrapper.d.ts.map