/**
 * ag-grid-community - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components
 * @version v20.1.0
 * @link http://www.ag-grid.com/
 * @license MIT
 */
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var globalObj = typeof global === 'undefined' ? {} : global;
globalObj.HTMLElement = typeof HTMLElement === 'undefined' ? {} : HTMLElement;
globalObj.HTMLButtonElement = typeof HTMLButtonElement === 'undefined' ? {} : HTMLButtonElement;
globalObj.HTMLSelectElement = typeof HTMLSelectElement === 'undefined' ? {} : HTMLSelectElement;
globalObj.HTMLInputElement = typeof HTMLInputElement === 'undefined' ? {} : HTMLInputElement;
globalObj.Node = typeof Node === 'undefined' ? {} : Node;
globalObj.MouseEvent = typeof MouseEvent === 'undefined' ? {} : MouseEvent;
// columnController
var columnFactory_1 = require("./columnController/columnFactory");
exports.ColumnFactory = columnFactory_1.ColumnFactory;
var columnController_1 = require("./columnController/columnController");
exports.ColumnController = columnController_1.ColumnController;
var columnKeyCreator_1 = require("./columnController/columnKeyCreator");
exports.ColumnKeyCreator = columnKeyCreator_1.ColumnKeyCreator;
var columnUtils_1 = require("./columnController/columnUtils");
exports.ColumnUtils = columnUtils_1.ColumnUtils;
var displayedGroupCreator_1 = require("./columnController/displayedGroupCreator");
exports.DisplayedGroupCreator = displayedGroupCreator_1.DisplayedGroupCreator;
var groupInstanceIdCreator_1 = require("./columnController/groupInstanceIdCreator");
exports.GroupInstanceIdCreator = groupInstanceIdCreator_1.GroupInstanceIdCreator;
// components
var componentUtil_1 = require("./components/componentUtil");
exports.ComponentUtil = componentUtil_1.ComponentUtil;
var colDefUtil_1 = require("./components/colDefUtil");
exports.ColDefUtil = colDefUtil_1.ColDefUtil;
var componentProvider_1 = require("./components/framework/componentProvider");
exports.ComponentProvider = componentProvider_1.ComponentProvider;
var componentResolver_1 = require("./components/framework/componentResolver");
exports.ComponentResolver = componentResolver_1.ComponentResolver;
var agGridNg1_1 = require("./components/agGridNg1");
exports.initialiseAgGridWithAngular1 = agGridNg1_1.initialiseAgGridWithAngular1;
var agGridWebComponent_1 = require("./components/agGridWebComponent");
exports.initialiseAgGridWithWebComponents = agGridWebComponent_1.initialiseAgGridWithWebComponents;
// context
var beanStub_1 = require("./context/beanStub");
exports.BeanStub = beanStub_1.BeanStub;
var context_1 = require("./context/context");
exports.Context = context_1.Context;
exports.Autowired = context_1.Autowired;
exports.PostConstruct = context_1.PostConstruct;
exports.PreConstruct = context_1.PreConstruct;
exports.Optional = context_1.Optional;
exports.Bean = context_1.Bean;
exports.Qualifier = context_1.Qualifier;
exports.PreDestroy = context_1.PreDestroy;
var componentAnnotations_1 = require("./widgets/componentAnnotations");
exports.QuerySelector = componentAnnotations_1.QuerySelector;
exports.Listener = componentAnnotations_1.Listener;
exports.RefSelector = componentAnnotations_1.RefSelector;
// dragAndDrop
var dragAndDropService_1 = require("./dragAndDrop/dragAndDropService");
exports.DragAndDropService = dragAndDropService_1.DragAndDropService;
exports.DragSourceType = dragAndDropService_1.DragSourceType;
exports.HDirection = dragAndDropService_1.HDirection;
exports.VDirection = dragAndDropService_1.VDirection;
var dragService_1 = require("./dragAndDrop/dragService");
exports.DragService = dragService_1.DragService;
// entities
var column_1 = require("./entities/column");
exports.Column = column_1.Column;
var columnGroup_1 = require("./entities/columnGroup");
exports.ColumnGroup = columnGroup_1.ColumnGroup;
var gridCell_1 = require("./entities/gridCell");
exports.GridCell = gridCell_1.GridCell;
var gridRow_1 = require("./entities/gridRow");
exports.GridRow = gridRow_1.GridRow;
var originalColumnGroup_1 = require("./entities/originalColumnGroup");
exports.OriginalColumnGroup = originalColumnGroup_1.OriginalColumnGroup;
var rowNode_1 = require("./entities/rowNode");
exports.RowNode = rowNode_1.RowNode;
// filter
var baseFilter_1 = require("./filter/baseFilter");
exports.BaseFilter = baseFilter_1.BaseFilter;
var dateFilter_1 = require("./filter/dateFilter");
exports.DateFilter = dateFilter_1.DateFilter;
var filterManager_1 = require("./filter/filterManager");
exports.FilterManager = filterManager_1.FilterManager;
var numberFilter_1 = require("./filter/numberFilter");
exports.NumberFilter = numberFilter_1.NumberFilter;
var textFilter_1 = require("./filter/textFilter");
exports.TextFilter = textFilter_1.TextFilter;
// gridPanel
var gridPanel_1 = require("./gridPanel/gridPanel");
exports.GridPanel = gridPanel_1.GridPanel;
var scrollVisibleService_1 = require("./gridPanel/scrollVisibleService");
exports.ScrollVisibleService = scrollVisibleService_1.ScrollVisibleService;
var mouseEventService_1 = require("./gridPanel/mouseEventService");
exports.MouseEventService = mouseEventService_1.MouseEventService;
// headerRendering
var bodyDropPivotTarget_1 = require("./headerRendering/bodyDropPivotTarget");
exports.BodyDropPivotTarget = bodyDropPivotTarget_1.BodyDropPivotTarget;
var bodyDropTarget_1 = require("./headerRendering/bodyDropTarget");
exports.BodyDropTarget = bodyDropTarget_1.BodyDropTarget;
var cssClassApplier_1 = require("./headerRendering/cssClassApplier");
exports.CssClassApplier = cssClassApplier_1.CssClassApplier;
var headerContainer_1 = require("./headerRendering/headerContainer");
exports.HeaderContainer = headerContainer_1.HeaderContainer;
var headerRootComp_1 = require("./headerRendering/headerRootComp");
exports.HeaderRootComp = headerRootComp_1.HeaderRootComp;
var headerRowComp_1 = require("./headerRendering/headerRowComp");
exports.HeaderRowComp = headerRowComp_1.HeaderRowComp;
var horizontalResizeService_1 = require("./headerRendering/horizontalResizeService");
exports.HorizontalResizeService = horizontalResizeService_1.HorizontalResizeService;
var moveColumnController_1 = require("./headerRendering/moveColumnController");
exports.MoveColumnController = moveColumnController_1.MoveColumnController;
var standardMenu_1 = require("./headerRendering/standardMenu");
exports.StandardMenuFactory = standardMenu_1.StandardMenuFactory;
// layout
var tabbedLayout_1 = require("./layout/tabbedLayout");
exports.TabbedLayout = tabbedLayout_1.TabbedLayout;
var verticalStack_1 = require("./layout/verticalStack");
exports.VerticalStack = verticalStack_1.VerticalStack;
// misc
var simpleHttpRequest_1 = require("./misc/simpleHttpRequest");
exports.simpleHttpRequest = simpleHttpRequest_1.simpleHttpRequest;
var largeTextCellEditor_1 = require("./rendering/cellEditors/largeTextCellEditor");
exports.LargeTextCellEditor = largeTextCellEditor_1.LargeTextCellEditor;
var popupEditorWrapper_1 = require("./rendering/cellEditors/popupEditorWrapper");
exports.PopupEditorWrapper = popupEditorWrapper_1.PopupEditorWrapper;
var popupSelectCellEditor_1 = require("./rendering/cellEditors/popupSelectCellEditor");
exports.PopupSelectCellEditor = popupSelectCellEditor_1.PopupSelectCellEditor;
var popupTextCellEditor_1 = require("./rendering/cellEditors/popupTextCellEditor");
exports.PopupTextCellEditor = popupTextCellEditor_1.PopupTextCellEditor;
var selectCellEditor_1 = require("./rendering/cellEditors/selectCellEditor");
exports.SelectCellEditor = selectCellEditor_1.SelectCellEditor;
var textCellEditor_1 = require("./rendering/cellEditors/textCellEditor");
exports.TextCellEditor = textCellEditor_1.TextCellEditor;
var animateShowChangeCellRenderer_1 = require("./rendering/cellRenderers/animateShowChangeCellRenderer");
exports.AnimateShowChangeCellRenderer = animateShowChangeCellRenderer_1.AnimateShowChangeCellRenderer;
var animateSlideCellRenderer_1 = require("./rendering/cellRenderers/animateSlideCellRenderer");
exports.AnimateSlideCellRenderer = animateSlideCellRenderer_1.AnimateSlideCellRenderer;
var groupCellRenderer_1 = require("./rendering/cellRenderers/groupCellRenderer");
exports.GroupCellRenderer = groupCellRenderer_1.GroupCellRenderer;
// features
var setLeftFeature_1 = require("./rendering/features/setLeftFeature");
exports.SetLeftFeature = setLeftFeature_1.SetLeftFeature;
// rendering
var autoWidthCalculator_1 = require("./rendering/autoWidthCalculator");
exports.AutoWidthCalculator = autoWidthCalculator_1.AutoWidthCalculator;
var cellEditorFactory_1 = require("./rendering/cellEditorFactory");
exports.CellEditorFactory = cellEditorFactory_1.CellEditorFactory;
var cellRendererFactory_1 = require("./rendering/cellRendererFactory");
exports.CellRendererFactory = cellRendererFactory_1.CellRendererFactory;
var cellRendererService_1 = require("./rendering/cellRendererService");
exports.CellRendererService = cellRendererService_1.CellRendererService;
var checkboxSelectionComponent_1 = require("./rendering/checkboxSelectionComponent");
exports.CheckboxSelectionComponent = checkboxSelectionComponent_1.CheckboxSelectionComponent;
var cellComp_1 = require("./rendering/cellComp");
exports.CellComp = cellComp_1.CellComp;
var rowComp_1 = require("./rendering/rowComp");
exports.RowComp = rowComp_1.RowComp;
var rowRenderer_1 = require("./rendering/rowRenderer");
exports.RowRenderer = rowRenderer_1.RowRenderer;
var valueFormatterService_1 = require("./rendering/valueFormatterService");
exports.ValueFormatterService = valueFormatterService_1.ValueFormatterService;
// rowControllers/inMemory
var filterStage_1 = require("./rowModels/clientSide/filterStage");
exports.FilterStage = filterStage_1.FilterStage;
var flattenStage_1 = require("./rowModels/clientSide/flattenStage");
exports.FlattenStage = flattenStage_1.FlattenStage;
var sortStage_1 = require("./rowModels/clientSide/sortStage");
exports.SortStage = sortStage_1.SortStage;
// row models
var pinnedRowModel_1 = require("./rowModels/pinnedRowModel");
exports.PinnedRowModel = pinnedRowModel_1.PinnedRowModel;
var clientSideRowModel_1 = require("./rowModels/clientSide/clientSideRowModel");
exports.ClientSideRowModel = clientSideRowModel_1.ClientSideRowModel;
var changedPath_1 = require("./rowModels/clientSide/changedPath");
exports.ChangedPath = changedPath_1.ChangedPath;
var clientSideNodeManager_1 = require("./rowModels/clientSide/clientSideNodeManager");
exports.ClientSideNodeManager = clientSideNodeManager_1.ClientSideNodeManager;
var infiniteRowModel_1 = require("./rowModels/infinite/infiniteRowModel");
exports.InfiniteRowModel = infiniteRowModel_1.InfiniteRowModel;
var rowNodeBlock_1 = require("./rowModels/cache/rowNodeBlock");
exports.RowNodeBlock = rowNodeBlock_1.RowNodeBlock;
var rowNodeBlockLoader_1 = require("./rowModels/cache/rowNodeBlockLoader");
exports.RowNodeBlockLoader = rowNodeBlockLoader_1.RowNodeBlockLoader;
var paginationProxy_1 = require("./rowModels/paginationProxy");
exports.PaginationProxy = paginationProxy_1.PaginationProxy;
var rowNodeCache_1 = require("./rowModels/cache/rowNodeCache");
exports.RowNodeCache = rowNodeCache_1.RowNodeCache;
//styling
var stylingService_1 = require("./styling/stylingService");
exports.StylingService = stylingService_1.StylingService;
// widgets
var agCheckbox_1 = require("./widgets/agCheckbox");
exports.AgCheckbox = agCheckbox_1.AgCheckbox;
var popupWindow_1 = require("./widgets/popupWindow");
exports.PopupWindow = popupWindow_1.PopupWindow;
var popupMessageBox_1 = require("./widgets/popupMessageBox");
exports.PopupMessageBox = popupMessageBox_1.PopupMessageBox;
var component_1 = require("./widgets/component");
exports.Component = component_1.Component;
var popupComponent_1 = require("./widgets/popupComponent");
exports.PopupComponent = popupComponent_1.PopupComponent;
var popupService_1 = require("./widgets/popupService");
exports.PopupService = popupService_1.PopupService;
var touchListener_1 = require("./widgets/touchListener");
exports.TouchListener = touchListener_1.TouchListener;
// exporter
var csvCreator_1 = require("./exporter/csvCreator");
exports.CsvCreator = csvCreator_1.CsvCreator;
exports.BaseCreator = csvCreator_1.BaseCreator;
var downloader_1 = require("./exporter/downloader");
exports.Downloader = downloader_1.Downloader;
var xmlFactory_1 = require("./exporter/xmlFactory");
exports.XmlFactory = xmlFactory_1.XmlFactory;
var gridSerializer_1 = require("./exporter/gridSerializer");
exports.BaseGridSerializingSession = gridSerializer_1.BaseGridSerializingSession;
exports.GridSerializer = gridSerializer_1.GridSerializer;
var gridSerializer_2 = require("./exporter/gridSerializer");
exports.RowType = gridSerializer_2.RowType;
var zipContainer_1 = require("./exporter/files/zip/zipContainer");
exports.ZipContainer = zipContainer_1.ZipContainer;
// root
var baseFrameworkFactory_1 = require("./baseFrameworkFactory");
exports.BaseFrameworkFactory = baseFrameworkFactory_1.BaseFrameworkFactory;
var cellNavigationService_1 = require("./cellNavigationService");
exports.CellNavigationService = cellNavigationService_1.CellNavigationService;
var alignedGridsService_1 = require("./alignedGridsService");
exports.AlignedGridsService = alignedGridsService_1.AlignedGridsService;
var constants_1 = require("./constants");
exports.Constants = constants_1.Constants;
var grid_1 = require("./grid");
exports.Grid = grid_1.Grid;
var gridApi_1 = require("./gridApi");
exports.GridApi = gridApi_1.GridApi;
var eventKeys_1 = require("./eventKeys");
exports.Events = eventKeys_1.Events;
var focusedCellController_1 = require("./focusedCellController");
exports.FocusedCellController = focusedCellController_1.FocusedCellController;
var functions_1 = require("./functions");
exports.defaultGroupComparator = functions_1.defaultGroupComparator;
var gridOptionsWrapper_1 = require("./gridOptionsWrapper");
exports.GridOptionsWrapper = gridOptionsWrapper_1.GridOptionsWrapper;
var eventService_1 = require("./eventService");
exports.EventService = eventService_1.EventService;
var selectableService_1 = require("./rowNodes/selectableService");
exports.SelectableService = selectableService_1.SelectableService;
var gridCore_1 = require("./gridCore");
exports.GridCore = gridCore_1.GridCore;
var logger_1 = require("./logger");
exports.Logger = logger_1.Logger;
var selectionController_1 = require("./selectionController");
exports.SelectionController = selectionController_1.SelectionController;
var sortController_1 = require("./sortController");
exports.SortController = sortController_1.SortController;
var templateService_1 = require("./templateService");
exports.TemplateService = templateService_1.TemplateService;
var utils_1 = require("./utils");
exports.Utils = utils_1.Utils;
exports.NumberSequence = utils_1.NumberSequence;
exports._ = utils_1._;
exports.Promise = utils_1.Promise;
var valueService_1 = require("./valueService/valueService");
exports.ValueService = valueService_1.ValueService;
var expressionService_1 = require("./valueService/expressionService");
exports.ExpressionService = expressionService_1.ExpressionService;
var logger_2 = require("./logger");
exports.LoggerFactory = logger_2.LoggerFactory;
var columnApi_1 = require("./columnController/columnApi");
exports.ColumnApi = columnApi_1.ColumnApi;
var frameworkComponentWrapper_1 = require("./components/framework/frameworkComponentWrapper");
exports.BaseComponentWrapper = frameworkComponentWrapper_1.BaseComponentWrapper;
var environment_1 = require("./environment");
exports.Environment = environment_1.Environment;
var tooltipManager_1 = require("./widgets/tooltipManager");
exports.TooltipManager = tooltipManager_1.TooltipManager;
