import { Beans } from "./../beans";
import { Column } from "../../entities/column";
import { CellChangedEvent, RowNode } from "../../entities/rowNode";
import { CellPosition } from "../../entities/cellPosition";
import { CellEvent, CellFocusedEvent, FlashCellsEvent } from "../../events";
import { BeanStub } from "../../context/beanStub";
import { RowPosition } from "../../entities/rowPosition";
import { RowCtrl } from "../row/rowCtrl";
import { ICellRenderer } from "../cellRenderers/iCellRenderer";
import { ICellEditor } from "../../interfaces/iCellEditor";
import { UserCompDetails } from "../../components/framework/userComponentFactory";
import { CheckboxSelectionComponent } from "../checkboxSelectionComponent";
import { DndSourceComp } from "../dndSourceComp";
import { RowDragComp } from "../row/rowDragComp";
export interface ICellComp {
    addOrRemoveCssClass(cssClassName: string, on: boolean): void;
    setUserStyles(styles: any): void;
    setAriaSelected(selected: boolean | undefined): void;
    setAriaExpanded(expanded: boolean): void;
    getFocusableElement(): HTMLElement;
    setLeft(left: string): void;
    setWidth(width: string): void;
    setAriaColIndex(index: number): void;
    setHeight(height: string): void;
    setZIndex(zIndex: string): void;
    setTabIndex(tabIndex: number): void;
    setRole(role: string): void;
    setColId(colId: string): void;
    setTitle(title: string | undefined): void;
    setUnselectable(value: 'on' | null): void;
    setTransition(value: string | undefined): void;
    setIncludeSelection(include: boolean): void;
    setIncludeRowDrag(include: boolean): void;
    setIncludeDndSource(include: boolean): void;
    setForceWrapper(force: boolean): void;
    getCellEditor(): ICellEditor | null;
    getCellRenderer(): ICellRenderer | null;
    getParentOfValue(): HTMLElement | null;
    setRenderDetails(compDetails: UserCompDetails | undefined, valueToDisplay: any, forceNewCellRendererInstance: boolean): void;
    setEditDetails(compDetails?: UserCompDetails, popup?: boolean, position?: string): void;
}
export declare class CellCtrl extends BeanStub {
    static DOM_DATA_KEY_CELL_CTRL: string;
    private instanceId;
    private eGui;
    private cellComp;
    private beans;
    private gow;
    private column;
    private rowNode;
    private rowCtrl;
    private printLayout;
    private value;
    private valueFormatted;
    private scope;
    private cellRangeFeature;
    private cellPositionFeature;
    private cellCustomStyleFeature;
    private cellTooltipFeature;
    private cellMouseListenerFeature;
    private cellKeyboardListenerFeature;
    private cellPosition;
    private editing;
    private editingInPopup;
    private includeSelection;
    private includeDndSource;
    private includeRowDrag;
    private suppressRefreshCell;
    private destroyAutoHeight;
    private autoHeightElement;
    private customRowDragComp;
    constructor(column: Column, rowNode: RowNode, beans: Beans, rowCtrl: RowCtrl);
    private addFeatures;
    setComp(comp: ICellComp, scope: any, eGui: HTMLElement, printLayout: boolean, startEditing: boolean): void;
    setupAutoHeight(eParentOfValue: HTMLElement | undefined): void;
    getInstanceId(): string;
    private showValue;
    private setupControlComps;
    private isIncludeControl;
    private setupAriaExpanded;
    refreshShouldDestroy(): boolean;
    startEditing(keyPress?: number | null, charPress?: string | null, cellStartedEdit?: boolean): void;
    private setEditing;
    stopRowOrCellEdit(cancel?: boolean): void;
    onPopupEditorClosed(): void;
    private takeValueFromCellEditor;
    private saveNewValue;
    stopEditing(cancel?: boolean): void;
    private dispatchEditingStoppedEvent;
    private setInlineEditingClass;
    hackSayEditingInPopup(): void;
    private createCellEditorParams;
    private createCellRendererParams;
    private parseValue;
    setFocusOutOnEditor(): void;
    setFocusInOnEditor(): void;
    onCellChanged(event: CellChangedEvent): void;
    refreshCell(params?: {
        suppressFlash?: boolean;
        newData?: boolean;
        forceRefresh?: boolean;
    }): void;
    stopEditingAndFocus(suppressNavigateAfterEdit?: boolean): void;
    private navigateAfterEdit;
    flashCell(delays?: {
        flashDelay?: number | null;
        fadeDelay?: number | null;
    }): void;
    private animateCell;
    onFlashCells(event: FlashCellsEvent): void;
    isCellEditable(): boolean;
    private formatValue;
    private callValueFormatter;
    updateAndFormatValue(force?: boolean): boolean;
    private valuesAreEqual;
    getComp(): ICellComp;
    getValueFromValueService(): any;
    getValue(): any;
    getValueFormatted(): string;
    private addDomData;
    createEvent(domEvent: Event | null, eventType: string): CellEvent;
    onKeyPress(event: KeyboardEvent): void;
    onKeyDown(event: KeyboardEvent): void;
    onMouseEvent(eventName: string, mouseEvent: MouseEvent): void;
    getGui(): HTMLElement;
    refreshToolTip(): void;
    getColSpanningList(): Column[];
    onLeftChanged(): void;
    private refreshAriaIndex;
    isSuppressNavigable(): boolean;
    onWidthChanged(): void;
    getColumn(): Column;
    getRowNode(): RowNode;
    getBeans(): Beans;
    isPrintLayout(): boolean;
    appendChild(htmlElement: HTMLElement): void;
    refreshHandle(): void;
    getCellPosition(): CellPosition;
    isEditing(): boolean;
    startRowOrCellEdit(keyPress?: number | null, charPress?: string | null): void;
    getRowCtrl(): RowCtrl;
    getRowPosition(): RowPosition;
    updateRangeBordersIfRangeCount(): void;
    onRangeSelectionChanged(): void;
    isRangeSelectionEnabled(): boolean;
    focusCell(forceBrowserFocus?: boolean): void;
    onRowIndexChanged(): void;
    onFirstRightPinnedChanged(): void;
    onLastLeftPinnedChanged(): void;
    onCellFocused(event?: CellFocusedEvent): void;
    private createCellPosition;
    private applyStaticCssClasses;
    onColumnHover(): void;
    onNewColumnsLoaded(): void;
    private setWrapText;
    dispatchCellContextMenuEvent(event: Event | null): void;
    getCellRenderer(): ICellRenderer | null;
    getCellEditor(): ICellEditor | null;
    destroy(): void;
    createSelectionCheckbox(): CheckboxSelectionComponent;
    createDndSource(): DndSourceComp;
    registerRowDragger(customElement: HTMLElement, dragStartPixels?: number): void;
    createRowDragComp(customElement?: HTMLElement, dragStartPixels?: number): RowDragComp | undefined;
}
