import type { NamedBean } from './context/bean';
import { BeanStub } from './context/beanStub';
import type { BeanCollection } from './context/context';
import type { AgColumn } from './entities/agColumn';
import type { RowNode } from './entities/rowNode';
import type { CellFocusedParams } from './events';
import type { HeaderCellCtrl } from './headerRendering/cells/column/headerCellCtrl';
import type { TabToNextHeaderParams } from './interfaces/iCallbackParams';
import type { CellPosition } from './interfaces/iCellPosition';
import type { WithoutGridCommon } from './interfaces/iCommon';
import type { HeaderPosition } from './interfaces/iHeaderPosition';
import type { RowPinnedType } from './interfaces/iRowNode';
export declare class FocusService extends BeanStub implements NamedBean {
    beanName: "focusSvc";
    private colModel;
    private visibleCols;
    private rowRenderer;
    private navigation?;
    private filterManager?;
    private overlays?;
    wireBeans(beans: BeanCollection): void;
    private focusedCell;
    private restoredFocusedCell;
    focusedHeader: HeaderPosition | null;
    /** the column that had focus before it moved into the advanced filter */
    private advFilterFocusColumn;
    private awaitRestoreFocusedCell;
    postConstruct(): void;
    onColumnEverythingChanged(): void;
    getFocusCellToUseAfterRefresh(): CellPosition | null;
    getFocusHeaderToUseAfterRefresh(): HeaderPosition | null;
    private isDomDataMissingInHierarchy;
    getFocusedCell(): CellPosition | null;
    shouldRestoreFocus(cell: CellPosition): boolean;
    clearRestoreFocus(): void;
    restoreFocusedCell(cellPosition: CellPosition, setFocusCallback: () => void): void;
    private isCellRestoreFocused;
    setRestoreFocusedCell(cellPosition: CellPosition): void;
    private getFocusEventParams;
    clearFocusedCell(): void;
    setFocusedCell(params: CellFocusedParams): void;
    isCellFocused(cellPosition: CellPosition): boolean;
    isRowNodeFocused(rowNode: RowNode): boolean;
    isHeaderWrapperFocused(headerCtrl: HeaderCellCtrl): boolean;
    focusHeaderPosition(params: {
        headerPosition: HeaderPosition | null;
        direction?: 'Before' | 'After' | null;
        fromTab?: boolean;
        allowUserOverride?: boolean;
        event?: KeyboardEvent;
        fromCell?: boolean;
        rowWithoutSpanValue?: number;
    }): boolean;
    focusHeaderPositionFromUserFunc(params: {
        userFunc: (params: WithoutGridCommon<TabToNextHeaderParams>) => boolean | HeaderPosition;
        headerPosition: HeaderPosition | null;
        direction?: 'Before' | 'After' | null;
        event?: KeyboardEvent;
    }): boolean;
    private getHeaderPositionFromUserFunc;
    private focusProvidedHeaderPosition;
    focusFirstHeader(): boolean;
    focusLastHeader(event?: KeyboardEvent): boolean;
    focusPreviousFromFirstCell(event?: KeyboardEvent): boolean;
    isAnyCellFocused(): boolean;
    isRowFocused(rowIndex: number, rowPinnedType: RowPinnedType): boolean;
    focusOverlay(backwards?: boolean): boolean;
    focusGridView(column?: AgColumn, backwards?: boolean, canFocusOverlay?: boolean): boolean;
    private focusAdvancedFilter;
    focusNextFromAdvancedFilter(backwards?: boolean, forceFirstColumn?: boolean): boolean;
    clearAdvancedFilterColumn(): void;
}
