import type { NamedBean } from '../context/bean';
import { BeanStub } from '../context/beanStub';
import type { BeanCollection } from '../context/context';
import type { AgColumn } from '../entities/agColumn';
import type { RowNode } from '../entities/rowNode';
import type { IRowNode } from '../interfaces/iRowNode';
export declare class ValueService extends BeanStub implements NamedBean {
    beanName: "valueSvc";
    private expressionSvc?;
    private colModel;
    private valueCache?;
    private dataTypeSvc?;
    wireBeans(beans: BeanCollection): void;
    private cellExpressions;
    private isTreeData;
    private initialised;
    private isSsrm;
    private executeValueGetter;
    postConstruct(): void;
    private init;
    /**
     * Use this function to get a displayable cell value.
     *
     * The values from this function are not used for sorting, filtering, or aggregation purposes.
     *
     * Handles: groupHideOpenParents, showOpenedGroup and groupSuppressBlankHeader behaviours
     */
    getValueForDisplay(column: AgColumn, node: IRowNode): any;
    getValue(column: AgColumn, rowNode?: IRowNode | null, ignoreAggData?: boolean): any;
    parseValue(column: AgColumn, rowNode: IRowNode | null, newValue: any, oldValue: any): any;
    getDeleteValue(column: AgColumn, rowNode: IRowNode): any;
    formatValue(column: AgColumn, node: IRowNode | null, value: any, suppliedFormatter?: (value: any) => string, useFormatterFromColumn?: boolean): string | null;
    /**
     * Checks if the node has a value to inherit from the parent node for display in the given column
     *
     * This is used when [groupHideOpenParents] or [showOpenedGroup] are enabled
     *
     * @param node node to check for preferential nodes to display
     * @param column column to get the displayed node for
     * @returns a parent node of node to display the value from, or undefined if no value will be inherited
     */
    getDisplayedNode(node: IRowNode, column: AgColumn, onlyHideOpenParents?: boolean): RowNode | undefined;
    /**
     * Sets the value of a GridCell
     * @param rowNode The `RowNode` to be updated
     * @param colKey The `Column` to be updated
     * @param newValue The new value to be set
     * @param eventSource The event source
     * @returns `True` if the value has been updated, otherwise`False`.
     */
    setValue(rowNode: IRowNode, colKey: string | AgColumn, newValue: any, eventSource?: string): boolean;
    private callColumnCellValueChangedHandler;
    private setValueUsingField;
    private executeValueGetterWithValueCache;
    private executeValueGetterWithoutValueCache;
    getValueCallback(node: IRowNode, field: string | AgColumn): any;
    getKeyForNode(col: AgColumn, rowNode: IRowNode): any;
}
