(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["agGrid"] = factory();
	else
		root["agGrid"] = factory();
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 2074:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AlignedGridsModule = void 0;
const version_1 = __webpack_require__(7205);
const alignedGridsService_1 = __webpack_require__(8963);
/**
 * @feature Other -> Aligned Grids
 * @gridOption alignedGrids
 */
exports.AlignedGridsModule = {
    moduleName: 'AlignedGrids',
    version: version_1.VERSION,
    beans: [alignedGridsService_1.AlignedGridsService],
};


/***/ }),

/***/ 8963:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AlignedGridsService = void 0;
const columnStateUtils_1 = __webpack_require__(2885);
const beanStub_1 = __webpack_require__(8731);
const logging_1 = __webpack_require__(7764);
class AlignedGridsService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'alignedGridsSvc';
        // flag to mark if we are consuming. to avoid cyclic events (ie other grid firing back to master
        // while processing a master event) we mark this if consuming an event, and if we are, then
        // we don't fire back any events.
        this.consuming = false;
    }
    getAlignedGridApis() {
        let alignedGrids = this.gos.get('alignedGrids') ?? [];
        const isCallbackConfig = typeof alignedGrids === 'function';
        if (typeof alignedGrids === 'function') {
            alignedGrids = alignedGrids();
        }
        const apis = alignedGrids
            .map((alignedGrid) => {
            if (!alignedGrid) {
                (0, logging_1._error)(18);
                if (!isCallbackConfig) {
                    (0, logging_1._error)(20);
                }
                return;
            }
            if (this.isGridApi(alignedGrid)) {
                return alignedGrid;
            }
            // Extract the GridApi from a ref or component
            const refOrComp = alignedGrid;
            if ('current' in refOrComp) {
                return refOrComp.current?.api;
            }
            if (!refOrComp.api) {
                (0, logging_1._error)(19);
            }
            return refOrComp.api;
        })
            .filter((api) => !!api && !api.isDestroyed());
        return apis;
    }
    isGridApi(ref) {
        return !!ref && !!ref.dispatchEvent;
    }
    postConstruct() {
        const fireColumnEvent = this.fireColumnEvent.bind(this);
        this.addManagedEventListeners({
            columnMoved: fireColumnEvent,
            columnVisible: fireColumnEvent,
            columnPinned: fireColumnEvent,
            columnGroupOpened: fireColumnEvent,
            columnResized: fireColumnEvent,
            bodyScroll: this.fireScrollEvent.bind(this),
            alignedGridColumn: ({ event }) => this.onColumnEvent(event),
            alignedGridScroll: ({ event }) => this.onScrollEvent(event),
        });
    }
    // common logic across all the fire methods
    fireEvent(event) {
        // if we are already consuming, then we are acting on an event from a master,
        // so we don't cause a cyclic firing of events
        if (this.consuming) {
            return;
        }
        this.getAlignedGridApis().forEach((api) => {
            if (api.isDestroyed()) {
                return;
            }
            api.dispatchEvent(event);
        });
    }
    // common logic across all consume methods. very little common logic, however extracting
    // guarantees consistency across the methods.
    onEvent(callback) {
        this.consuming = true;
        callback();
        this.consuming = false;
    }
    fireColumnEvent(columnEvent) {
        this.fireEvent({
            type: 'alignedGridColumn',
            event: columnEvent,
        });
    }
    fireScrollEvent(scrollEvent) {
        if (scrollEvent.direction !== 'horizontal') {
            return;
        }
        this.fireEvent({
            type: 'alignedGridScroll',
            event: scrollEvent,
        });
    }
    onScrollEvent(event) {
        this.onEvent(() => {
            this.beans.ctrlsSvc.getScrollFeature().setHorizontalScrollPosition(event.left, true);
        });
    }
    extractDataFromEvent(event, func) {
        const result = [];
        if (event.columns) {
            event.columns.forEach((column) => {
                result.push(func(column));
            });
        }
        else if (event.column) {
            result.push(func(event.column));
        }
        return result;
    }
    getMasterColumns(event) {
        return this.extractDataFromEvent(event, (col) => col);
    }
    getColumnIds(event) {
        return this.extractDataFromEvent(event, (col) => col.getColId());
    }
    onColumnEvent(event) {
        this.onEvent(() => {
            switch (event.type) {
                case 'columnMoved':
                case 'columnVisible':
                case 'columnPinned':
                case 'columnResized': {
                    this.processColumnEvent(event);
                    break;
                }
                case 'columnGroupOpened': {
                    this.processGroupOpenedEvent(event);
                    break;
                }
                case 'columnPivotChanged':
                    // we cannot support pivoting with aligned grids as the columns will be out of sync as the
                    // grids will have columns created based on the row data of the grid.
                    (0, logging_1._warn)(21);
                    break;
            }
        });
    }
    processGroupOpenedEvent(groupOpenedEvent) {
        const { colGroupSvc } = this.beans;
        if (!colGroupSvc) {
            return;
        }
        groupOpenedEvent.columnGroups.forEach((masterGroup) => {
            // likewise for column group
            let otherColumnGroup = null;
            if (masterGroup) {
                otherColumnGroup = colGroupSvc.getProvidedColGroup(masterGroup.getGroupId());
            }
            if (masterGroup && !otherColumnGroup) {
                return;
            }
            colGroupSvc.setColumnGroupOpened(otherColumnGroup, masterGroup.isExpanded(), 'alignedGridChanged');
        });
    }
    processColumnEvent(colEvent) {
        // the column in the event is from the master grid. need to
        // look up the equivalent from this (other) grid
        const masterColumn = colEvent.column;
        let otherColumn = null;
        const beans = this.beans;
        const { colResize, ctrlsSvc, colModel } = beans;
        if (masterColumn) {
            otherColumn = colModel.getColDefCol(masterColumn.getColId());
        }
        // if event was with respect to a master column, that is not present in this
        // grid, then we ignore the event
        if (masterColumn && !otherColumn) {
            return;
        }
        // in time, all the methods below should use the column ids, it's a more generic way
        // of handling columns, and also allows for single or multi column events
        const masterColumns = this.getMasterColumns(colEvent);
        switch (colEvent.type) {
            case 'columnMoved':
                // when the user moves columns via applyColumnState, we can't depend on moving specific columns
                // to an index, as there maybe be many indexes columns moved to (as wasn't result of a mouse drag).
                // so only way to be sure is match the order of all columns using Column State.
                {
                    const srcColState = colEvent.api.getColumnState();
                    const destColState = srcColState.map((s) => ({ colId: s.colId }));
                    (0, columnStateUtils_1._applyColumnState)(beans, { state: destColState, applyOrder: true }, 'alignedGridChanged');
                }
                break;
            case 'columnVisible':
                // when the user changes visibility via applyColumnState, we can't depend on visibility flag in event
                // as there maybe be mix of true/false (as wasn't result of a mouse click to set visiblity).
                // so only way to be sure is match the visibility of all columns using Column State.
                {
                    const srcColState = colEvent.api.getColumnState();
                    const destColState = srcColState.map((s) => ({ colId: s.colId, hide: s.hide }));
                    (0, columnStateUtils_1._applyColumnState)(beans, { state: destColState }, 'alignedGridChanged');
                }
                break;
            case 'columnPinned':
                {
                    const srcColState = colEvent.api.getColumnState();
                    const destColState = srcColState.map((s) => ({ colId: s.colId, pinned: s.pinned }));
                    (0, columnStateUtils_1._applyColumnState)(beans, { state: destColState }, 'alignedGridChanged');
                }
                break;
            case 'columnResized': {
                const resizedEvent = colEvent;
                const columnWidths = {};
                masterColumns.forEach((column) => {
                    columnWidths[column.getId()] = { key: column.getColId(), newWidth: column.getActualWidth() };
                });
                // don't set flex columns width
                resizedEvent.flexColumns?.forEach((col) => {
                    if (columnWidths[col.getId()]) {
                        delete columnWidths[col.getId()];
                    }
                });
                colResize?.setColumnWidths(Object.values(columnWidths), false, resizedEvent.finished, 'alignedGridChanged');
                break;
            }
        }
        const gridBodyCon = ctrlsSvc.getGridBodyCtrl();
        const isVerticalScrollShowing = gridBodyCon.isVerticalScrollShowing();
        this.getAlignedGridApis().forEach((api) => {
            api.setGridOption('alwaysShowVerticalScroll', isVerticalScrollShowing);
        });
    }
}
exports.AlignedGridsService = AlignedGridsService;


/***/ }),

/***/ 1621:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AllCommunityModule = void 0;
const alignedGridsModule_1 = __webpack_require__(2074);
const apiModule_1 = __webpack_require__(9642);
const clientSideRowModelModule_1 = __webpack_require__(9722);
const clientSideRowModelModule_2 = __webpack_require__(9722);
const columnAutosizeModule_1 = __webpack_require__(3856);
const columnHoverModule_1 = __webpack_require__(1690);
const columnModule_1 = __webpack_require__(2027);
const csvExportModule_1 = __webpack_require__(9734);
const dragModule_1 = __webpack_require__(4388);
const editModule_1 = __webpack_require__(4652);
const filterModule_1 = __webpack_require__(5432);
const infiniteRowModelModule_1 = __webpack_require__(4002);
const apiEventModule_1 = __webpack_require__(9410);
const localeModule_1 = __webpack_require__(9519);
const stateModule_1 = __webpack_require__(6989);
const paginationModule_1 = __webpack_require__(1824);
const pinnedRowModule_1 = __webpack_require__(5423);
const highlightChangesModule_1 = __webpack_require__(3498);
const renderModule_1 = __webpack_require__(6964);
const rowAutoHeightModule_1 = __webpack_require__(4577);
const cellSpanModule_1 = __webpack_require__(4265);
const rowSelectionModule_1 = __webpack_require__(3352);
const stylingModule_1 = __webpack_require__(8594);
const tooltipModule_1 = __webpack_require__(4658);
const validationModule_1 = __webpack_require__(5010);
const valueModule_1 = __webpack_require__(6431);
const version_1 = __webpack_require__(7205);
/**
 * @feature All Community Features
 */
exports.AllCommunityModule = {
    moduleName: 'AllCommunity',
    version: version_1.VERSION,
    dependsOn: [
        clientSideRowModelModule_1.ClientSideRowModelModule,
        csvExportModule_1.CsvExportModule,
        infiniteRowModelModule_1.InfiniteRowModelModule,
        validationModule_1.ValidationModule,
        editModule_1.TextEditorModule,
        editModule_1.NumberEditorModule,
        editModule_1.DateEditorModule,
        editModule_1.CheckboxEditorModule,
        editModule_1.SelectEditorModule,
        editModule_1.LargeTextEditorModule,
        editModule_1.CustomEditorModule,
        editModule_1.UndoRedoEditModule,
        filterModule_1.TextFilterModule,
        filterModule_1.NumberFilterModule,
        filterModule_1.DateFilterModule,
        filterModule_1.CustomFilterModule,
        filterModule_1.QuickFilterModule,
        filterModule_1.ExternalFilterModule,
        stateModule_1.GridStateModule,
        alignedGridsModule_1.AlignedGridsModule,
        paginationModule_1.PaginationModule,
        columnModule_1.ColumnApiModule,
        apiModule_1.RowApiModule,
        apiModule_1.ScrollApiModule,
        renderModule_1.RenderApiModule,
        columnAutosizeModule_1.ColumnAutoSizeModule,
        dragModule_1.RowDragModule,
        pinnedRowModule_1.PinnedRowModule,
        rowSelectionModule_1.RowSelectionModule,
        valueModule_1.ValueCacheModule,
        stylingModule_1.CellStyleModule,
        columnHoverModule_1.ColumnHoverModule,
        stylingModule_1.RowStyleModule,
        apiEventModule_1.EventApiModule,
        valueModule_1.CellApiModule,
        highlightChangesModule_1.HighlightChangesModule,
        tooltipModule_1.TooltipModule,
        localeModule_1.LocaleModule,
        rowAutoHeightModule_1.RowAutoHeightModule,
        dragModule_1.DragAndDropModule,
        clientSideRowModelModule_2.ClientSideRowModelApiModule,
        cellSpanModule_1.CellSpanModule,
    ],
};


/***/ }),

/***/ 3907:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ApiFunctionService = void 0;
const beanStub_1 = __webpack_require__(8731);
const logging_1 = __webpack_require__(7764);
const gridApiFunctions_1 = __webpack_require__(7689);
const defaultFns = {
    isDestroyed: () => true,
    destroy() { },
    preConstruct() { },
    postConstruct() { },
    preWireBeans() { },
    wireBeans() { },
};
const dispatchEvent = (beans, event) => beans.eventSvc.dispatchEvent(event);
// We use a class for AGGridApi so in stack traces calling grid.api.xxx() if an error is thrown it will print "GridApi.xxx"
class GridApiClass {
}
Reflect.defineProperty(GridApiClass, 'name', { value: 'GridApi' });
class ApiFunctionService extends beanStub_1.BeanStub {
    constructor() {
        super();
        this.beanName = 'apiFunctionSvc';
        this.api = new GridApiClass();
        this.fns = {
            ...defaultFns,
            // dispatchEvent is used by frameworks, also used by aligned grids to identify a grid api instance
            dispatchEvent,
        };
        this.preDestroyLink = '';
        const { api } = this;
        for (const key of Object.keys(gridApiFunctions_1.gridApiFunctionsMap)) {
            api[key] = this.makeApi(key)[key];
        }
    }
    postConstruct() {
        this.preDestroyLink = this.beans.frameworkOverrides.getDocLink('grid-lifecycle/#grid-pre-destroyed');
    }
    addFunction(functionName, func) {
        const { fns, beans } = this;
        if (fns !== defaultFns) {
            fns[functionName] = beans?.validation?.validateApiFunction(functionName, func) ?? func;
        }
    }
    makeApi(apiName) {
        // We return an object here to be sure the function name is properly applied,
        // in this way error stack trace are correct and gridApi.xxx.name === 'xxx'
        // This is generally faster than using Object.defineProperty(gridApi, apiName, { value: apiName, configurable: true });
        // Keep this function as light and simple as possible.
        return {
            [apiName]: (...args) => {
                const { beans, fns: { [apiName]: fn }, } = this;
                return fn ? fn(beans, ...args) : this.apiNotFound(apiName);
            },
        };
    }
    apiNotFound(fnName) {
        const { beans, gos, preDestroyLink } = this;
        if (!beans) {
            (0, logging_1._warn)(26, { fnName, preDestroyLink });
        }
        else {
            const module = gridApiFunctions_1.gridApiFunctionsMap[fnName];
            if (gos.assertModuleRegistered(module, `api.${fnName}`)) {
                (0, logging_1._warn)(27, { fnName, module });
            }
        }
    }
    destroy() {
        super.destroy();
        this.fns = defaultFns;
        this.beans = null;
    }
}
exports.ApiFunctionService = ApiFunctionService;


/***/ }),

/***/ 9642:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScrollApiModule = exports.RowApiModule = void 0;
const version_1 = __webpack_require__(7205);
const rowApi_1 = __webpack_require__(8192);
const scrollApi_1 = __webpack_require__(1765);
/**
 * @feature Rows
 */
exports.RowApiModule = {
    moduleName: 'RowApi',
    version: version_1.VERSION,
    apiFunctions: {
        redrawRows: rowApi_1.redrawRows,
        setRowNodeExpanded: rowApi_1.setRowNodeExpanded,
        getRowNode: rowApi_1.getRowNode,
        addRenderedRowListener: rowApi_1.addRenderedRowListener,
        getRenderedNodes: rowApi_1.getRenderedNodes,
        forEachNode: rowApi_1.forEachNode,
        getFirstDisplayedRowIndex: rowApi_1.getFirstDisplayedRowIndex,
        getLastDisplayedRowIndex: rowApi_1.getLastDisplayedRowIndex,
        getDisplayedRowAtIndex: rowApi_1.getDisplayedRowAtIndex,
        getDisplayedRowCount: rowApi_1.getDisplayedRowCount,
    },
};
/**
 * @feature Scrolling
 */
exports.ScrollApiModule = {
    moduleName: 'ScrollApi',
    version: version_1.VERSION,
    apiFunctions: {
        getVerticalPixelRange: scrollApi_1.getVerticalPixelRange,
        getHorizontalPixelRange: scrollApi_1.getHorizontalPixelRange,
        ensureColumnVisible: scrollApi_1.ensureColumnVisible,
        ensureIndexVisible: scrollApi_1.ensureIndexVisible,
        ensureNodeVisible: scrollApi_1.ensureNodeVisible,
    },
};


/***/ }),

/***/ 6433:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createGridApi = void 0;
function createGridApi(context) {
    return {
        beanName: 'gridApi',
        bean: context.getBean('apiFunctionSvc').api,
    };
}
exports.createGridApi = createGridApi;


/***/ }),

/***/ 9875:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isModuleRegistered = exports.updateGridOptions = exports.setGridOption = exports.getGridOption = exports.isDestroyed = exports.destroy = exports.getGridId = void 0;
function getGridId(beans) {
    return beans.context.getGridId();
}
exports.getGridId = getGridId;
function destroy(beans) {
    beans.gridDestroySvc.destroy();
}
exports.destroy = destroy;
function isDestroyed(beans) {
    return beans.gridDestroySvc.destroyCalled;
}
exports.isDestroyed = isDestroyed;
function getGridOption(beans, key) {
    return beans.gos.get(key);
}
exports.getGridOption = getGridOption;
function setGridOption(beans, key, value) {
    updateGridOptions(beans, { [key]: value });
}
exports.setGridOption = setGridOption;
function updateGridOptions(beans, options) {
    // NOTE: The TDataUpdate generic is used to ensure that the update options match the generic passed into the GridApi above as TData.
    // This is required because if we just use TData directly then Typescript will get into an infinite loop due to callbacks which recursively include the GridApi.
    beans.gos.updateGridOptions({ options });
}
exports.updateGridOptions = updateGridOptions;
function isModuleRegistered(beans, moduleName) {
    const withoutSuffix = moduleName.replace(/Module$/, '');
    return beans.gos.isModuleRegistered(withoutSuffix);
}
exports.isModuleRegistered = isModuleRegistered;


/***/ }),

/***/ 9513:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.onRowHeightChanged = exports.collapseAll = exports.expandAll = void 0;
const rowModelApiUtils_1 = __webpack_require__(6876);
function expandAll(beans) {
    beans.expansionSvc?.expandAll(true);
}
exports.expandAll = expandAll;
function collapseAll(beans) {
    beans.expansionSvc?.expandAll(false);
}
exports.collapseAll = collapseAll;
function onRowHeightChanged(beans) {
    const clientSideRowModel = (0, rowModelApiUtils_1._getClientSideRowModel)(beans);
    const serverSideRowModel = (0, rowModelApiUtils_1._getServerSideRowModel)(beans);
    if (clientSideRowModel) {
        clientSideRowModel.onRowHeightChanged();
    }
    else if (serverSideRowModel) {
        serverSideRowModel.onRowHeightChanged();
    }
}
exports.onRowHeightChanged = onRowHeightChanged;


/***/ }),

/***/ 7689:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.gridApiFunctionsMap = void 0;
const mod = (moduleName, input) => {
    for (const key of Object.keys(input)) {
        input[key] = moduleName;
    }
    return input;
};
exports.gridApiFunctionsMap = {
    dispatchEvent: 'CommunityCore',
    ...mod('CommunityCore', {
        destroy: 0,
        getGridId: 0,
        getGridOption: 0,
        isDestroyed: 0,
        setGridOption: 0,
        updateGridOptions: 0,
        isModuleRegistered: 0,
    }),
    ...mod('GridState', {
        getState: 0,
        setState: 0,
    }),
    ...mod('SharedRowSelection', {
        setNodesSelected: 0,
        selectAll: 0,
        deselectAll: 0,
        selectAllFiltered: 0,
        deselectAllFiltered: 0,
        selectAllOnCurrentPage: 0,
        deselectAllOnCurrentPage: 0,
        getSelectedNodes: 0,
        getSelectedRows: 0,
    }),
    ...mod('RowApi', {
        redrawRows: 0,
        setRowNodeExpanded: 0,
        getRowNode: 0,
        addRenderedRowListener: 0,
        getRenderedNodes: 0,
        forEachNode: 0,
        getFirstDisplayedRowIndex: 0,
        getLastDisplayedRowIndex: 0,
        getDisplayedRowAtIndex: 0,
        getDisplayedRowCount: 0,
    }),
    ...mod('ScrollApi', {
        getVerticalPixelRange: 0,
        getHorizontalPixelRange: 0,
        ensureColumnVisible: 0,
        ensureIndexVisible: 0,
        ensureNodeVisible: 0,
    }),
    ...mod('KeyboardNavigation', {
        getFocusedCell: 0,
        clearFocusedCell: 0,
        setFocusedCell: 0,
        tabToNextCell: 0,
        tabToPreviousCell: 0,
        setFocusedHeader: 0,
    }),
    ...mod('EventApi', {
        addEventListener: 0,
        addGlobalListener: 0,
        removeEventListener: 0,
        removeGlobalListener: 0,
    }),
    ...mod('ValueCache', {
        expireValueCache: 0,
    }),
    ...mod('CellApi', {
        getCellValue: 0,
    }),
    ...mod('SharedMenu', {
        showColumnMenu: 0,
        hidePopupMenu: 0,
    }),
    ...mod('Sort', {
        onSortChanged: 0,
    }),
    ...mod('PinnedRow', {
        getPinnedTopRowCount: 0,
        getPinnedBottomRowCount: 0,
        getPinnedTopRow: 0,
        getPinnedBottomRow: 0,
        forEachPinnedRow: 0,
    }),
    ...mod('Overlay', {
        showLoadingOverlay: 0,
        showNoRowsOverlay: 0,
        hideOverlay: 0,
    }),
    ...mod('RenderApi', {
        setGridAriaProperty: 0,
        refreshCells: 0,
        refreshHeader: 0,
        isAnimationFrameQueueEmpty: 0,
        flushAllAnimationFrames: 0,
        getSizesForCurrentTheme: 0,
        getCellRendererInstances: 0,
    }),
    ...mod('HighlightChanges', {
        flashCells: 0,
    }),
    ...mod('RowDrag', {
        addRowDropZone: 0,
        removeRowDropZone: 0,
        getRowDropZoneParams: 0,
        getRowDropPositionIndicator: 0,
        setRowDropPositionIndicator: 0,
    }),
    ...mod('ColumnApi', {
        getColumnDefs: 0,
        getColumnDef: 0,
        getDisplayNameForColumn: 0,
        getColumn: 0,
        getColumns: 0,
        applyColumnState: 0,
        getColumnState: 0,
        resetColumnState: 0,
        isPinning: 0,
        isPinningLeft: 0,
        isPinningRight: 0,
        getDisplayedColAfter: 0,
        getDisplayedColBefore: 0,
        setColumnsVisible: 0,
        setColumnsPinned: 0,
        getAllGridColumns: 0,
        getDisplayedLeftColumns: 0,
        getDisplayedCenterColumns: 0,
        getDisplayedRightColumns: 0,
        getAllDisplayedColumns: 0,
        getAllDisplayedVirtualColumns: 0,
    }),
    ...mod('ColumnAutoSize', {
        sizeColumnsToFit: 0,
        autoSizeColumns: 0,
        autoSizeAllColumns: 0,
    }),
    ...mod('ColumnGroup', {
        setColumnGroupOpened: 0,
        getColumnGroup: 0,
        getProvidedColumnGroup: 0,
        getDisplayNameForColumnGroup: 0,
        getColumnGroupState: 0,
        setColumnGroupState: 0,
        resetColumnGroupState: 0,
        getLeftDisplayedColumnGroups: 0,
        getCenterDisplayedColumnGroups: 0,
        getRightDisplayedColumnGroups: 0,
        getAllDisplayedColumnGroups: 0,
    }),
    ...mod('ColumnMove', {
        moveColumnByIndex: 0,
        moveColumns: 0,
    }),
    ...mod('ColumnResize', {
        setColumnWidths: 0,
    }),
    ...mod('ColumnHover', {
        isColumnHovered: 0,
    }),
    ...mod('EditCore', {
        getCellEditorInstances: 0,
        getEditingCells: 0,
        stopEditing: 0,
        startEditingCell: 0,
        isEditing: 0,
        validateEdit: 0,
    }),
    ...mod('BatchEdit', {
        startBatchEdit: 0,
        cancelBatchEdit: 0,
        commitBatchEdit: 0,
        isBatchEditing: 0,
    }),
    ...mod('UndoRedoEdit', {
        undoCellEditing: 0,
        redoCellEditing: 0,
        getCurrentUndoSize: 0,
        getCurrentRedoSize: 0,
    }),
    ...mod('FilterCore', {
        isAnyFilterPresent: 0,
        onFilterChanged: 0,
    }),
    ...mod('ColumnFilter', {
        isColumnFilterPresent: 0,
        getColumnFilterInstance: 0,
        destroyFilter: 0,
        setFilterModel: 0,
        getFilterModel: 0,
        getColumnFilterModel: 0,
        setColumnFilterModel: 0,
        showColumnFilter: 0,
        getColumnFilterHandler: 0,
        doFilterAction: 0,
    }),
    ...mod('QuickFilter', {
        isQuickFilterPresent: 0,
        getQuickFilter: 0,
        resetQuickFilter: 0,
    }),
    ...mod('Find', {
        findGetActiveMatch: 0,
        findGetTotalMatches: 0,
        findGoTo: 0,
        findNext: 0,
        findPrevious: 0,
        findGetNumMatches: 0,
        findGetParts: 0,
        findClearActive: 0,
        findRefresh: 0,
    }),
    ...mod('Pagination', {
        paginationIsLastPageFound: 0,
        paginationGetPageSize: 0,
        paginationGetCurrentPage: 0,
        paginationGetTotalPages: 0,
        paginationGetRowCount: 0,
        paginationGoToNextPage: 0,
        paginationGoToPreviousPage: 0,
        paginationGoToFirstPage: 0,
        paginationGoToLastPage: 0,
        paginationGoToPage: 0,
    }),
    ...mod('CsrmSsrmSharedApi', {
        expandAll: 0,
        collapseAll: 0,
        onRowHeightChanged: 0,
    }),
    ...mod('SsrmInfiniteSharedApi', {
        setRowCount: 0,
        getCacheBlockState: 0,
        isLastRowIndexKnown: 0,
    }),
    ...mod('ClientSideRowModelApi', {
        onGroupExpandedOrCollapsed: 0,
        refreshClientSideRowModel: 0,
        isRowDataEmpty: 0,
        forEachLeafNode: 0,
        forEachNodeAfterFilter: 0,
        forEachNodeAfterFilterAndSort: 0,
        resetRowHeights: 0,
        applyTransaction: 0,
        applyTransactionAsync: 0,
        flushAsyncTransactions: 0,
        getBestCostNodeSelection: 0,
    }),
    ...mod('CsvExport', {
        getDataAsCsv: 0,
        exportDataAsCsv: 0,
    }),
    ...mod('InfiniteRowModel', {
        refreshInfiniteCache: 0,
        purgeInfiniteCache: 0,
        getInfiniteRowCount: 0,
    }),
    ...mod('AdvancedFilter', {
        getAdvancedFilterModel: 0,
        setAdvancedFilterModel: 0,
        showAdvancedFilterBuilder: 0,
        hideAdvancedFilterBuilder: 0,
    }),
    ...mod('IntegratedCharts', {
        getChartModels: 0,
        getChartRef: 0,
        getChartImageDataURL: 0,
        downloadChart: 0,
        openChartToolPanel: 0,
        closeChartToolPanel: 0,
        createRangeChart: 0,
        createPivotChart: 0,
        createCrossFilterChart: 0,
        updateChart: 0,
        restoreChart: 0,
    }),
    ...mod('Clipboard', {
        copyToClipboard: 0,
        cutToClipboard: 0,
        copySelectedRowsToClipboard: 0,
        copySelectedRangeToClipboard: 0,
        copySelectedRangeDown: 0,
        pasteFromClipboard: 0,
    }),
    ...mod('ExcelExport', {
        getDataAsExcel: 0,
        exportDataAsExcel: 0,
        getSheetDataForExcel: 0,
        getMultipleSheetsAsExcel: 0,
        exportMultipleSheetsAsExcel: 0,
    }),
    ...mod('SharedMasterDetail', {
        addDetailGridInfo: 0,
        removeDetailGridInfo: 0,
        getDetailGridInfo: 0,
        forEachDetailGridInfo: 0,
    }),
    ...mod('ContextMenu', {
        showContextMenu: 0,
    }),
    ...mod('ColumnMenu', {
        showColumnChooser: 0,
        hideColumnChooser: 0,
    }),
    ...mod('CellSelection', {
        getCellRanges: 0,
        addCellRange: 0,
        clearRangeSelection: 0,
        clearCellSelection: 0,
    }),
    ...mod('SharedRowGrouping', {
        setRowGroupColumns: 0,
        removeRowGroupColumns: 0,
        addRowGroupColumns: 0,
        getRowGroupColumns: 0,
        moveRowGroupColumn: 0,
    }),
    ...mod('SharedAggregation', {
        addAggFuncs: 0,
        clearAggFuncs: 0,
        setColumnAggFunc: 0,
    }),
    ...mod('SharedPivot', {
        isPivotMode: 0,
        getPivotResultColumn: 0,
        setValueColumns: 0,
        getValueColumns: 0,
        removeValueColumns: 0,
        addValueColumns: 0,
        setPivotColumns: 0,
        removePivotColumns: 0,
        addPivotColumns: 0,
        getPivotColumns: 0,
        setPivotResultColumns: 0,
        getPivotResultColumns: 0,
    }),
    ...mod('ServerSideRowModelApi', {
        getServerSideSelectionState: 0,
        setServerSideSelectionState: 0,
        applyServerSideTransaction: 0,
        applyServerSideTransactionAsync: 0,
        applyServerSideRowData: 0,
        retryServerSideLoads: 0,
        flushServerSideAsyncTransactions: 0,
        refreshServerSide: 0,
        getServerSideGroupLevelState: 0,
    }),
    ...mod('SideBar', {
        isSideBarVisible: 0,
        setSideBarVisible: 0,
        setSideBarPosition: 0,
        openToolPanel: 0,
        closeToolPanel: 0,
        getOpenedToolPanel: 0,
        refreshToolPanel: 0,
        isToolPanelShowing: 0,
        getToolPanelInstance: 0,
        getSideBar: 0,
    }),
    ...mod('StatusBar', {
        getStatusPanel: 0,
    }),
};


/***/ }),

/***/ 8192:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getDisplayedRowCount = exports.getDisplayedRowAtIndex = exports.getLastDisplayedRowIndex = exports.getFirstDisplayedRowIndex = exports.forEachNode = exports.getRenderedNodes = exports.addRenderedRowListener = exports.getRowNode = exports.setRowNodeExpanded = exports.redrawRows = void 0;
function redrawRows(beans, params = {}) {
    const rowNodes = params ? params.rowNodes : undefined;
    beans.frameworkOverrides.wrapIncoming(() => beans.rowRenderer.redrawRows(rowNodes));
}
exports.redrawRows = redrawRows;
function setRowNodeExpanded(beans, rowNode, expanded, expandParents, forceSync) {
    if (rowNode) {
        // expand all parents recursively, except root node.
        if (expandParents && rowNode.parent && rowNode.parent.level !== -1) {
            setRowNodeExpanded(beans, rowNode.parent, expanded, expandParents, forceSync);
        }
        rowNode.setExpanded(expanded, undefined, forceSync);
    }
}
exports.setRowNodeExpanded = setRowNodeExpanded;
function getRowNode(beans, id) {
    return beans.rowModel.getRowNode(id);
}
exports.getRowNode = getRowNode;
function addRenderedRowListener(beans, eventName, rowIndex, callback) {
    beans.rowRenderer.addRenderedRowListener(eventName, rowIndex, callback);
}
exports.addRenderedRowListener = addRenderedRowListener;
function getRenderedNodes(beans) {
    return beans.rowRenderer.getRenderedNodes();
}
exports.getRenderedNodes = getRenderedNodes;
function forEachNode(beans, callback, includeFooterNodes) {
    beans.rowModel.forEachNode(callback, includeFooterNodes);
}
exports.forEachNode = forEachNode;
function getFirstDisplayedRowIndex(beans) {
    return beans.rowRenderer.firstRenderedRow;
}
exports.getFirstDisplayedRowIndex = getFirstDisplayedRowIndex;
function getLastDisplayedRowIndex(beans) {
    return beans.rowRenderer.lastRenderedRow;
}
exports.getLastDisplayedRowIndex = getLastDisplayedRowIndex;
function getDisplayedRowAtIndex(beans, index) {
    return beans.rowModel.getRow(index);
}
exports.getDisplayedRowAtIndex = getDisplayedRowAtIndex;
function getDisplayedRowCount(beans) {
    return beans.rowModel.getRowCount();
}
exports.getDisplayedRowCount = getDisplayedRowCount;


/***/ }),

/***/ 6876:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getServerSideRowModel = exports._getInfiniteRowModel = exports._getClientSideRowModel = void 0;
function _getClientSideRowModel(beans) {
    const rowModel = beans.rowModel;
    return rowModel.getType() === 'clientSide' ? rowModel : undefined;
}
exports._getClientSideRowModel = _getClientSideRowModel;
function _getInfiniteRowModel(beans) {
    const rowModel = beans.rowModel;
    return rowModel.getType() === 'infinite' ? rowModel : undefined;
}
exports._getInfiniteRowModel = _getInfiniteRowModel;
function _getServerSideRowModel(beans) {
    const rowModel = beans.rowModel;
    return rowModel.getType() === 'serverSide' ? rowModel : undefined;
}
exports._getServerSideRowModel = _getServerSideRowModel;


/***/ }),

/***/ 1765:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ensureNodeVisible = exports.ensureIndexVisible = exports.ensureColumnVisible = exports.getHorizontalPixelRange = exports.getVerticalPixelRange = void 0;
function getVerticalPixelRange(beans) {
    return beans.ctrlsSvc.getScrollFeature().getVScrollPosition();
}
exports.getVerticalPixelRange = getVerticalPixelRange;
function getHorizontalPixelRange(beans) {
    return beans.ctrlsSvc.getScrollFeature().getHScrollPosition();
}
exports.getHorizontalPixelRange = getHorizontalPixelRange;
function ensureColumnVisible(beans, key, position = 'auto') {
    beans.frameworkOverrides.wrapIncoming(() => beans.ctrlsSvc.getScrollFeature().ensureColumnVisible(key, position), 'ensureVisible');
}
exports.ensureColumnVisible = ensureColumnVisible;
function ensureIndexVisible(beans, index, position) {
    beans.frameworkOverrides.wrapIncoming(() => beans.ctrlsSvc.getScrollFeature().ensureIndexVisible(index, position), 'ensureVisible');
}
exports.ensureIndexVisible = ensureIndexVisible;
function ensureNodeVisible(beans, nodeSelector, position = null) {
    beans.frameworkOverrides.wrapIncoming(() => beans.ctrlsSvc.getScrollFeature().ensureNodeVisible(nodeSelector, position), 'ensureVisible');
}
exports.ensureNodeVisible = ensureNodeVisible;


/***/ }),

/***/ 6437:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SsrmInfiniteSharedApiModule = exports.CsrmSsrmSharedApiModule = void 0;
const version_1 = __webpack_require__(7205);
const csrmSsrmSharedApi_1 = __webpack_require__(9513);
const ssrmInfiniteSharedApi_1 = __webpack_require__(8496);
// these modules are not used in core, but are shared between multiple other modules
/**
 * @internal
 */
exports.CsrmSsrmSharedApiModule = {
    moduleName: 'CsrmSsrmSharedApi',
    version: version_1.VERSION,
    apiFunctions: {
        expandAll: csrmSsrmSharedApi_1.expandAll,
        collapseAll: csrmSsrmSharedApi_1.collapseAll,
        onRowHeightChanged: csrmSsrmSharedApi_1.onRowHeightChanged,
    },
};
/**
 * @internal
 */
exports.SsrmInfiniteSharedApiModule = {
    moduleName: 'SsrmInfiniteSharedApi',
    version: version_1.VERSION,
    apiFunctions: {
        setRowCount: ssrmInfiniteSharedApi_1.setRowCount,
        getCacheBlockState: ssrmInfiniteSharedApi_1.getCacheBlockState,
        isLastRowIndexKnown: ssrmInfiniteSharedApi_1.isLastRowIndexKnown,
    },
};


/***/ }),

/***/ 8496:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isLastRowIndexKnown = exports.getCacheBlockState = exports.setRowCount = void 0;
const gridOptionsUtils_1 = __webpack_require__(7274);
const logging_1 = __webpack_require__(7764);
const rowModelApiUtils_1 = __webpack_require__(6876);
function setRowCount(beans, rowCount, maxRowFound) {
    const serverSideRowModel = (0, rowModelApiUtils_1._getServerSideRowModel)(beans);
    if (serverSideRowModel) {
        if (beans.rowGroupColsSvc?.columns.length === 0) {
            if (rowCount < 0) {
                (0, logging_1._error)(238);
                return;
            }
            serverSideRowModel.setRowCount(rowCount, maxRowFound);
            return;
        }
        (0, logging_1._error)(28);
        return;
    }
    const infiniteRowModel = (0, rowModelApiUtils_1._getInfiniteRowModel)(beans);
    if (infiniteRowModel) {
        infiniteRowModel.setRowCount(rowCount, maxRowFound);
        return;
    }
}
exports.setRowCount = setRowCount;
function getCacheBlockState(beans) {
    if ((0, gridOptionsUtils_1._isServerSideRowModel)(beans.gos)) {
        const ssrm = beans.rowModel;
        return ssrm.getBlockStates();
    }
    return beans.rowNodeBlockLoader?.getBlockState() ?? {};
}
exports.getCacheBlockState = getCacheBlockState;
function isLastRowIndexKnown(beans) {
    return beans.rowModel.isLastRowIndexKnown();
}
exports.isLastRowIndexKnown = isLastRowIndexKnown;


/***/ }),

/***/ 5628:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoScrollService = void 0;
class AutoScrollService {
    constructor(params) {
        this.tickingInterval = null;
        this.onScrollCallback = null;
        this.scrollContainer = params.scrollContainer;
        this.scrollHorizontally = params.scrollAxis.indexOf('x') !== -1;
        this.scrollVertically = params.scrollAxis.indexOf('y') !== -1;
        this.scrollByTick = params.scrollByTick != null ? params.scrollByTick : 20;
        if (params.onScrollCallback) {
            this.onScrollCallback = params.onScrollCallback;
        }
        if (this.scrollVertically) {
            this.getVerticalPosition = params.getVerticalPosition;
            this.setVerticalPosition = params.setVerticalPosition;
        }
        if (this.scrollHorizontally) {
            this.getHorizontalPosition = params.getHorizontalPosition;
            this.setHorizontalPosition = params.setHorizontalPosition;
        }
        this.shouldSkipVerticalScroll = params.shouldSkipVerticalScroll || (() => false);
        this.shouldSkipHorizontalScroll = params.shouldSkipHorizontalScroll || (() => false);
    }
    check(mouseEvent, forceSkipVerticalScroll = false) {
        const skipVerticalScroll = forceSkipVerticalScroll || this.shouldSkipVerticalScroll();
        if (skipVerticalScroll && this.shouldSkipHorizontalScroll()) {
            return;
        }
        const rect = this.scrollContainer.getBoundingClientRect();
        const scrollTick = this.scrollByTick;
        this.tickLeft = mouseEvent.clientX < rect.left + scrollTick;
        this.tickRight = mouseEvent.clientX > rect.right - scrollTick;
        this.tickUp = mouseEvent.clientY < rect.top + scrollTick && !skipVerticalScroll;
        this.tickDown = mouseEvent.clientY > rect.bottom - scrollTick && !skipVerticalScroll;
        if (this.tickLeft || this.tickRight || this.tickUp || this.tickDown) {
            this.ensureTickingStarted();
        }
        else {
            this.ensureCleared();
        }
    }
    ensureTickingStarted() {
        if (this.tickingInterval === null) {
            this.tickingInterval = window.setInterval(this.doTick.bind(this), 100);
            this.tickCount = 0;
        }
    }
    doTick() {
        this.tickCount++;
        const tickAmount = this.tickCount > 20 ? 200 : this.tickCount > 10 ? 80 : 40;
        if (this.scrollVertically) {
            const vScrollPosition = this.getVerticalPosition();
            if (this.tickUp) {
                this.setVerticalPosition(vScrollPosition - tickAmount);
            }
            if (this.tickDown) {
                this.setVerticalPosition(vScrollPosition + tickAmount);
            }
        }
        if (this.scrollHorizontally) {
            const hScrollPosition = this.getHorizontalPosition();
            if (this.tickLeft) {
                this.setHorizontalPosition(hScrollPosition - tickAmount);
            }
            if (this.tickRight) {
                this.setHorizontalPosition(hScrollPosition + tickAmount);
            }
        }
        if (this.onScrollCallback) {
            this.onScrollCallback();
        }
    }
    ensureCleared() {
        if (this.tickingInterval) {
            window.clearInterval(this.tickingInterval);
            this.tickingInterval = null;
        }
    }
}
exports.AutoScrollService = AutoScrollService;


/***/ }),

/***/ 3263:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BASE_URL = void 0;
// DO NOT UPDATE MANUALLY: Generated from script during build time
exports.BASE_URL = 'https://www.ag-grid.com';


/***/ }),

/***/ 1954:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AbstractClientSideNodeManager = void 0;
const beanStub_1 = __webpack_require__(8731);
const rowNode_1 = __webpack_require__(3373);
const gridOptionsUtils_1 = __webpack_require__(7274);
const logging_1 = __webpack_require__(7764);
const ROOT_NODE_ID = 'ROOT_NODE_ID';
class AbstractClientSideNodeManager extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.nextId = 0;
        this.allNodesMap = {};
        this.rootNode = null;
    }
    getRowNode(id) {
        return this.allNodesMap[id];
    }
    extractRowData() {
        return this.rootNode?.allLeafChildren?.map((node) => node.data);
    }
    activate(rootNode) {
        this.rootNode = rootNode;
        rootNode.group = true;
        rootNode.level = -1;
        rootNode.id = ROOT_NODE_ID;
        rootNode.allLeafChildren = [];
        rootNode.childrenAfterGroup = [];
        rootNode.childrenAfterSort = [];
        rootNode.childrenAfterAggFilter = [];
        rootNode.childrenAfterFilter = [];
        this.updateRootSiblingArrays(rootNode);
    }
    deactivate() {
        if (this.rootNode) {
            this.allNodesMap = {};
            this.rootNode = null;
        }
    }
    destroy() {
        super.destroy();
        // Forcefully deallocate memory
        this.allNodesMap = {};
        this.rootNode = null;
    }
    setNewRowData(rowData) {
        const rootNode = this.rootNode;
        if (!rootNode) {
            return;
        }
        this.dispatchRowDataUpdateStartedEvent(rowData);
        rootNode.childrenAfterFilter = null;
        rootNode.childrenAfterGroup = null;
        rootNode.childrenAfterAggFilter = null;
        rootNode.childrenAfterSort = null;
        rootNode.childrenMapped = null;
        rootNode.updateHasChildren();
        // Clear internal maps
        this.allNodesMap = {};
        this.nextId = 0;
        this.loadNewRowData(rowData);
        this.updateRootSiblingArrays(rootNode);
    }
    updateRootSiblingArrays(rootNode) {
        const sibling = rootNode.sibling;
        if (sibling) {
            sibling.childrenAfterFilter = rootNode.childrenAfterFilter;
            sibling.childrenAfterGroup = rootNode.childrenAfterGroup;
            sibling.childrenAfterAggFilter = rootNode.childrenAfterAggFilter;
            sibling.childrenAfterSort = rootNode.childrenAfterSort;
            sibling.childrenMapped = rootNode.childrenMapped;
            sibling.allLeafChildren = rootNode.allLeafChildren;
        }
    }
    loadNewRowData(rowData) {
        this.rootNode.allLeafChildren = rowData?.map((dataItem, index) => this.createRowNode(dataItem, index)) ?? [];
    }
    setImmutableRowData(params, rowData) {
        const getRowIdFunc = (0, gridOptionsUtils_1._getRowIdCallback)(this.gos);
        const reorder = !this.gos.get('suppressMaintainUnsortedOrder');
        const changedRowNodes = params.changedRowNodes;
        const processedNodes = new Set();
        const rootNode = this.rootNode;
        const oldAllLeafChildren = rootNode.allLeafChildren;
        const oldAllLeafChildrenLen = oldAllLeafChildren.length;
        let nodesAdded = false;
        let nodesRemoved = false;
        let nodesUpdated = false;
        let orderChanged = false;
        for (let i = 0, prevSourceRowIndex = -1, len = rowData.length; i < len; i++) {
            const data = rowData[i];
            let node = this.getRowNode(getRowIdFunc({ data, level: 0 }));
            if (!node) {
                nodesAdded = true;
                node = this.createRowNode(data, -1);
                changedRowNodes.add(node);
            }
            else {
                if (reorder) {
                    const sourceRowIndex = node.sourceRowIndex;
                    orderChanged || (orderChanged = sourceRowIndex <= prevSourceRowIndex || // A node was moved up, so order changed
                        nodesAdded); // A node was inserted not at the end
                    prevSourceRowIndex = sourceRowIndex;
                }
                if (node.data !== data) {
                    nodesUpdated = true;
                    node.updateData(data);
                    changedRowNodes.update(node);
                }
            }
            processedNodes.add(node);
        }
        // Destroy the remaining unprocessed node and collect the removed that were selected.
        const nodesToUnselect = [];
        for (let i = 0; i < oldAllLeafChildrenLen; i++) {
            const node = oldAllLeafChildren[i];
            if (!processedNodes.has(node)) {
                nodesRemoved = true;
                if (node.isSelected()) {
                    nodesToUnselect.push(node);
                }
                if (node.pinnedSibling) {
                    this.beans.pinnedRowModel?.pinRow(node.pinnedSibling, null);
                }
                this.rowNodeDeleted(node);
                changedRowNodes.remove(node);
            }
        }
        if (nodesAdded || nodesRemoved || orderChanged) {
            const newAllLeafChildren = new Array(processedNodes.size); // Preallocate
            let writeIdx = 0;
            if (!reorder) {
                // All the old nodes will be in the new array in the order they were in the old array
                // At the end of this loop, processedNodes will contain only the new appended nodes
                for (let i = 0; i < oldAllLeafChildrenLen; ++i) {
                    const node = oldAllLeafChildren[i];
                    if (processedNodes.delete(node)) {
                        node.sourceRowIndex = writeIdx;
                        newAllLeafChildren[writeIdx++] = node;
                    }
                }
            }
            for (const node of processedNodes) {
                node.sourceRowIndex = writeIdx;
                newAllLeafChildren[writeIdx++] = node;
            }
            rootNode.allLeafChildren = newAllLeafChildren;
            const sibling = rootNode.sibling;
            if (sibling) {
                sibling.allLeafChildren = newAllLeafChildren;
            }
            params.rowNodesOrderChanged || (params.rowNodesOrderChanged = orderChanged);
        }
        if (nodesAdded || nodesRemoved || orderChanged || nodesUpdated) {
            this.deselectNodes(nodesToUnselect);
            params.rowDataUpdated = true;
        }
    }
    /** Called when a node needs to be deleted */
    rowNodeDeleted(node) {
        node.clearRowTopAndRowIndex(); // so row renderer knows to fade row out (and not reposition it)
        const id = node.id;
        const allNodesMap = this.allNodesMap;
        if (allNodesMap[id] === node) {
            delete allNodesMap[id];
        }
    }
    updateRowData(rowDataTran, changedRowNodes) {
        this.dispatchRowDataUpdateStartedEvent(rowDataTran.add);
        const updateRowDataResult = {
            changedRowNodes,
            rowNodeTransaction: { remove: [], update: [], add: [] },
            rowsInserted: false,
        };
        const nodesToUnselect = [];
        const getRowIdFunc = (0, gridOptionsUtils_1._getRowIdCallback)(this.gos);
        this.executeRemove(getRowIdFunc, rowDataTran, updateRowDataResult, nodesToUnselect);
        this.executeUpdate(getRowIdFunc, rowDataTran, updateRowDataResult, nodesToUnselect);
        this.executeAdd(rowDataTran, updateRowDataResult);
        this.deselectNodes(nodesToUnselect);
        return updateRowDataResult;
    }
    executeAdd(rowDataTran, result) {
        const add = rowDataTran.add;
        if (!add?.length) {
            return;
        }
        let allLeafChildren = this.rootNode.allLeafChildren;
        let addIndex = allLeafChildren.length;
        if (typeof rowDataTran.addIndex === 'number') {
            addIndex = this.sanitizeAddIndex(rowDataTran.addIndex);
            if (addIndex > 0) {
                // TODO: this code should not be here, see AG-12602
                // This was a fix for AG-6231, but is not the correct fix
                // We enable it only for trees that use getDataPath and not the new children field
                const getDataPath = this.gos.get('treeData') && this.gos.get('getDataPath');
                if (getDataPath) {
                    for (let i = 0; i < allLeafChildren.length; i++) {
                        const node = allLeafChildren[i];
                        if (node?.rowIndex == addIndex - 1) {
                            addIndex = i + 1;
                            break;
                        }
                    }
                }
            }
        }
        const addLength = add.length;
        const changedRowNodes = result.changedRowNodes;
        // create new row nodes for each data item
        const newNodes = new Array(addLength);
        for (let i = 0; i < addLength; i++) {
            const newNode = this.createRowNode(add[i], addIndex + i);
            changedRowNodes.add(newNode);
            newNodes[i] = newNode;
        }
        const rootNode = this.rootNode;
        if (addIndex < allLeafChildren.length) {
            // Insert at the specified index
            const nodesBeforeIndex = allLeafChildren.slice(0, addIndex);
            const nodesAfterIndex = allLeafChildren.slice(addIndex, allLeafChildren.length);
            // update latter row indexes
            const nodesAfterIndexFirstIndex = nodesBeforeIndex.length + newNodes.length;
            for (let index = 0, length = nodesAfterIndex.length; index < length; ++index) {
                nodesAfterIndex[index].sourceRowIndex = nodesAfterIndexFirstIndex + index;
            }
            allLeafChildren = [...nodesBeforeIndex, ...newNodes, ...nodesAfterIndex];
            // Mark the result as rows inserted
            result.rowsInserted = true;
        }
        else {
            // Just append at the end
            allLeafChildren = allLeafChildren.concat(newNodes);
        }
        rootNode.allLeafChildren = allLeafChildren;
        const sibling = rootNode.sibling;
        if (sibling) {
            sibling.allLeafChildren = allLeafChildren;
        }
        // add new row nodes to the transaction add items
        result.rowNodeTransaction.add = newNodes;
    }
    executeRemove(getRowIdFunc, rowDataTran, { changedRowNodes, rowNodeTransaction }, nodesToUnselect) {
        const { remove } = rowDataTran;
        if (!remove?.length) {
            return;
        }
        const rowIdsRemoved = {};
        remove.forEach((item) => {
            const rowNode = this.lookupRowNode(getRowIdFunc, item);
            if (!rowNode) {
                return;
            }
            if (rowNode.isSelected()) {
                nodesToUnselect.push(rowNode);
            }
            // If a row has been manually pinned, ensure its sibling is also removed
            if (rowNode.pinnedSibling) {
                this.beans.pinnedRowModel?.pinRow(rowNode.pinnedSibling, null);
            }
            // so row renderer knows to fade row out (and not reposition it)
            rowNode.clearRowTopAndRowIndex();
            // NOTE: were we could remove from allLeaveChildren, however removeFromArray() is expensive, especially
            // if called multiple times (eg deleting lots of rows) and if allLeafChildren is a large list
            rowIdsRemoved[rowNode.id] = true;
            // removeFromArray(this.rootNode.allLeafChildren, rowNode);
            delete this.allNodesMap[rowNode.id];
            rowNodeTransaction.remove.push(rowNode);
            changedRowNodes.remove(rowNode);
        });
        const rootNode = this.rootNode;
        rootNode.allLeafChildren = rootNode.allLeafChildren?.filter((rowNode) => !rowIdsRemoved[rowNode.id]) ?? null;
        // after rows have been removed, all following rows need the position index updated
        rootNode.allLeafChildren?.forEach((node, idx) => {
            node.sourceRowIndex = idx;
        });
        const sibling = rootNode.sibling;
        if (sibling) {
            sibling.allLeafChildren = rootNode.allLeafChildren;
        }
    }
    executeUpdate(getRowIdFunc, rowDataTran, { changedRowNodes, rowNodeTransaction }, nodesToUnselect) {
        const { update } = rowDataTran;
        if (!update?.length) {
            return;
        }
        update.forEach((item) => {
            const rowNode = this.lookupRowNode(getRowIdFunc, item);
            if (!rowNode) {
                return;
            }
            rowNode.updateData(item);
            if (!rowNode.selectable && rowNode.isSelected()) {
                nodesToUnselect.push(rowNode);
            }
            rowNodeTransaction.update.push(rowNode);
            changedRowNodes.update(rowNode);
        });
    }
    dispatchRowDataUpdateStartedEvent(rowData) {
        this.eventSvc.dispatchEvent({
            type: 'rowDataUpdateStarted',
            firstRowData: rowData?.length ? rowData[0] : null,
        });
    }
    deselectNodes(nodesToUnselect) {
        const source = 'rowDataChanged';
        const selectionSvc = this.beans.selectionSvc;
        const selectionChanged = nodesToUnselect.length > 0;
        if (selectionChanged) {
            selectionSvc?.setNodesSelected({
                newValue: false,
                nodes: nodesToUnselect,
                suppressFinishActions: true,
                source,
            });
        }
        // we do this regardless of nodes to unselect or not, as it's possible
        // a new node was inserted, so a parent that was previously selected (as all
        // children were selected) should not be tri-state (as new one unselected against
        // all other selected children).
        selectionSvc?.updateGroupsFromChildrenSelections?.(source);
        if (selectionChanged) {
            this.eventSvc.dispatchEvent({
                type: 'selectionChanged',
                source: source,
                selectedNodes: selectionSvc?.getSelectedNodes() ?? null,
                serverSideState: null,
            });
        }
    }
    sanitizeAddIndex(addIndex) {
        const allChildrenCount = this.rootNode.allLeafChildren?.length ?? 0;
        if (addIndex < 0 || addIndex >= allChildrenCount || Number.isNaN(addIndex)) {
            return allChildrenCount; // Append. Also for negative values, as it was historically the behavior.
        }
        // Ensure index is a whole number and not a floating point.
        // Use case: the user want to add a row in the middle, doing addIndex = array.length / 2.
        // If the array has an odd number of elements, the addIndex need to be rounded up.
        // Consider that array.slice does round up internally, but we are setting this value to node.sourceRowIndex.
        return Math.ceil(addIndex);
    }
    createRowNode(data, sourceRowIndex) {
        const node = new rowNode_1.RowNode(this.beans);
        node.parent = this.rootNode;
        node.level = 0;
        node.group = false;
        node.expanded = false;
        node.sourceRowIndex = sourceRowIndex;
        node.setDataAndId(data, String(this.nextId));
        if (this.allNodesMap[node.id]) {
            (0, logging_1._warn)(2, { nodeId: node.id });
        }
        this.allNodesMap[node.id] = node;
        this.nextId++;
        return node;
    }
    lookupRowNode(getRowIdFunc, data) {
        let rowNode;
        if (getRowIdFunc) {
            // find rowNode using id
            const id = getRowIdFunc({ data, level: 0 });
            rowNode = this.allNodesMap[id];
            if (!rowNode) {
                (0, logging_1._error)(4, { id });
                return null;
            }
        }
        else {
            // find rowNode using object references
            rowNode = this.rootNode?.allLeafChildren?.find((node) => node.data === data);
            if (!rowNode) {
                (0, logging_1._error)(5, { data });
                return null;
            }
        }
        return rowNode || null;
    }
}
exports.AbstractClientSideNodeManager = AbstractClientSideNodeManager;


/***/ }),

/***/ 2106:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangedRowNodes = void 0;
class ChangedRowNodes {
    constructor() {
        this.removals = new Set();
        this.updates = new Set();
        this.adds = new Set();
    }
    /** Marks a row as removed. Order of operations is: remove, update, add */
    remove(node) {
        if (!this.adds.delete(node)) {
            this.updates.delete(node);
            this.removals.add(node);
        }
    }
    /** Marks a row as updated. Order of operations is: remove, update, add */
    update(node) {
        if (!this.adds.has(node)) {
            this.updates.add(node);
        }
    }
    /** Marks a row as added. Order of operation is: remove, update, add */
    add(node) {
        this.adds.add(node);
    }
}
exports.ChangedRowNodes = ChangedRowNodes;


/***/ }),

/***/ 8128:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientSideNodeManager = void 0;
const abstractClientSideNodeManager_1 = __webpack_require__(1954);
class ClientSideNodeManager extends abstractClientSideNodeManager_1.AbstractClientSideNodeManager {
    constructor() {
        super(...arguments);
        this.beanName = 'csrmNodeSvc';
    }
}
exports.ClientSideNodeManager = ClientSideNodeManager;


/***/ }),

/***/ 3278:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientSideRowModel = void 0;
const beanStub_1 = __webpack_require__(8731);
const rowNode_1 = __webpack_require__(3373);
const gridOptionsUtils_1 = __webpack_require__(7274);
const array_1 = __webpack_require__(1502);
const changedPath_1 = __webpack_require__(6800);
const function_1 = __webpack_require__(2043);
const logging_1 = __webpack_require__(7764);
const changedRowNodes_1 = __webpack_require__(2106);
const filterStage_1 = __webpack_require__(8287);
const sortStage_1 = __webpack_require__(9849);
class ClientSideRowModel extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'rowModel';
        // top most node of the tree. the children are the user provided data.
        this.rootNode = null;
        this.rowsToDisplay = []; // the rows mapped to rows to display
        this.lastHighlightedRow = null;
        /** Has the start method been called */
        this.started = false;
        /**
         * This is to prevent refresh model being called when it's already being called.
         * E.g. the group stage can trigger initial state filter model to be applied. This fires onFilterChanged,
         * which then triggers the listener here that calls refresh model again but at the filter stage
         * (which is about to be run by the original call).
         */
        this.isRefreshingModel = false;
        this.rowNodesCountReady = false;
        this.rowCountReady = false;
        this.onRowHeightChanged_debounced = (0, function_1._debounce)(this, this.onRowHeightChanged.bind(this), 100);
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.valueCache = beans.valueCache;
        this.filterStage = beans.filterStage;
        this.sortStage = beans.sortStage;
        this.flattenStage = beans.flattenStage;
        this.groupStage = beans.groupStage;
        this.aggStage = beans.aggStage;
        this.pivotStage = beans.pivotStage;
        this.filterAggStage = beans.filterAggStage;
    }
    postConstruct() {
        this.orderedStages = [
            this.groupStage,
            this.filterStage,
            this.pivotStage,
            this.aggStage,
            this.sortStage,
            this.filterAggStage,
            this.flattenStage,
        ].filter((stage) => !!stage);
        const refreshEverythingFunc = this.refreshModel.bind(this, { step: 'group' });
        const refreshEverythingAfterColsChangedFunc = this.refreshModel.bind(this, {
            step: 'group',
            afterColumnsChanged: true,
            keepRenderedRows: true,
            // we want animations cos sorting or filtering could be applied
            animate: !this.gos.get('suppressAnimationFrame'),
        });
        this.addManagedEventListeners({
            newColumnsLoaded: refreshEverythingAfterColsChangedFunc,
            columnRowGroupChanged: refreshEverythingFunc,
            columnValueChanged: this.onValueChanged.bind(this),
            columnPivotChanged: this.refreshModel.bind(this, { step: 'pivot' }),
            filterChanged: this.onFilterChanged.bind(this),
            sortChanged: this.onSortChanged.bind(this),
            columnPivotModeChanged: refreshEverythingFunc,
            gridStylesChanged: this.onGridStylesChanges.bind(this),
            gridReady: this.onGridReady.bind(this),
        });
        // doesn't need done if doing full reset
        // Property listeners which call `refreshModel` at different stages
        this.addPropertyListeners();
        this.rootNode = new rowNode_1.RowNode(this.beans);
        const nodeManager = this.getNewNodeManager();
        this.nodeManager = nodeManager;
        nodeManager.activate(this.rootNode);
    }
    getNewNodeManager() {
        const { gos, beans } = this;
        return ((0, gridOptionsUtils_1._getGroupingApproach)(gos) === 'treeNested' && beans.csrmChildrenTreeNodeSvc) || beans.csrmNodeSvc;
    }
    addPropertyListeners() {
        // Omitted Properties
        //
        // We do not act reactively on all functional properties, as it's possible the application is React and
        // has not memoised the property and it's getting set every render.
        //
        // ** LIST OF NON REACTIVE, NO ARGUMENT
        //
        // getDataPath, getRowId -- these are called once for each Node when the Node is created.
        //                       -- these are immutable Node properties (ie a Node ID cannot be changed)
        //
        // isRowMaster           -- called when masterDetail is true and the Node is created or the property was changed
        //
        // getRowHeight - this is called once when Node is created, if a new getRowHeight function is provided,
        //              - we do not revisit the heights of each node.
        //
        // pivotDefaultExpanded - relevant for initial pivot column creation, no impact on existing pivot columns.
        //
        // deltaSort - this changes the type of algorithm used only, it doesn't change the sort order. so no point
        //           - in doing the sort again as the same result will be got. the new Prop will be used next time we sort.
        //
        // ** LIST OF NON REACTIVE, SOME ARGUMENT
        // ** For these, they could be reactive, but not convinced the business argument is strong enough,
        // ** so leaving as non-reactive for now, and see if anyone complains.
        //
        // processPivotResultColDef, processPivotResultColGroupDef
        //                       - there is an argument for having these reactive, that if the application changes
        //                       - these props, we should re-create the Pivot Columns, however it's highly unlikely
        //                       - the application would change these functions, far more likely the functions were
        //                       - non memoised correctly.
        const allProps = [
            'treeData',
            'treeDataChildrenField',
            ...this.orderedStages.flatMap(({ refreshProps }) => [...refreshProps]),
        ];
        this.addManagedPropertyListeners(allProps, (params) => {
            const properties = params.changeSet?.properties;
            if (properties) {
                this.onPropChange(properties);
            }
        });
        // TODO: HACK: rowData should be in the list of allProps instead of being registered separately.
        // but due to AG-13498, the columnModel will execute AFTER the previous listeners if properties
        // the column model listen to together with the previous listener are changed together.
        // So this is a temporary solution to make sure rowData is processed after the columnModel is ready.
        // Unfortunately this can result in double refresh when multiple properties are changed together, as it was before version 33.
        this.addManagedPropertyListener('rowData', () => this.onPropChange(['rowData']));
        this.addManagedPropertyListener('rowHeight', () => this.resetRowHeights());
    }
    start() {
        this.started = true;
        if (this.rowNodesCountReady) {
            this.refreshModel({ step: 'group', rowDataUpdated: true, newData: true });
        }
        else {
            this.setInitialData();
        }
    }
    setInitialData() {
        const rowData = this.gos.get('rowData');
        if (rowData) {
            this.onPropChange(['rowData']);
        }
    }
    ensureRowHeightsValid(startPixel, endPixel, startLimitIndex, endLimitIndex) {
        let atLeastOneChange;
        let res = false;
        // we do this multiple times as changing the row heights can also change the first and last rows,
        // so the first pass can make lots of rows smaller, which means the second pass we end up changing
        // more rows.
        do {
            atLeastOneChange = false;
            const rowAtStartPixel = this.getRowIndexAtPixel(startPixel);
            const rowAtEndPixel = this.getRowIndexAtPixel(endPixel);
            // keep check to current page if doing pagination
            const firstRow = Math.max(rowAtStartPixel, startLimitIndex);
            const lastRow = Math.min(rowAtEndPixel, endLimitIndex);
            for (let rowIndex = firstRow; rowIndex <= lastRow; rowIndex++) {
                const rowNode = this.getRow(rowIndex);
                if (rowNode.rowHeightEstimated) {
                    const rowHeight = (0, gridOptionsUtils_1._getRowHeightForNode)(this.beans, rowNode);
                    rowNode.setRowHeight(rowHeight.height);
                    atLeastOneChange = true;
                    res = true;
                }
            }
            if (atLeastOneChange) {
                this.setRowTopAndRowIndex();
            }
        } while (atLeastOneChange);
        return res;
    }
    onPropChange(properties) {
        if (!this.rootNode) {
            return; // Destroyed.
        }
        const gos = this.gos;
        const changedProps = new Set(properties);
        const params = {
            step: 'nothing',
            changedProps,
        };
        const rowDataChanged = changedProps.has('rowData');
        const oldNodeManager = this.nodeManager;
        const nodeManager = this.getNewNodeManager();
        const reset = oldNodeManager !== nodeManager ||
            (rowDataChanged && changedProps.has('treeData') && gos.get('treeData')) ||
            (changedProps.has('treeDataChildrenField') && gos.get('treeData'));
        let newRowData;
        if (reset || rowDataChanged) {
            newRowData = gos.get('rowData');
            if (newRowData != null && !Array.isArray(newRowData)) {
                newRowData = null;
                (0, logging_1._warn)(1);
            }
        }
        if (reset) {
            // If we are here, it means that the row manager need to be changed or fully reloaded
            if (!rowDataChanged) {
                // No new rowData was passed, so to include user executed transaction we need to extract
                // the row data from the node manager as it might be different from the original rowData
                newRowData = oldNodeManager?.extractRowData() ?? newRowData;
            }
            if (oldNodeManager !== nodeManager) {
                oldNodeManager?.deactivate();
                this.nodeManager = nodeManager;
            }
            nodeManager.activate(this.rootNode);
        }
        if (newRowData) {
            const immutable = !reset &&
                !this.isEmpty() &&
                newRowData.length > 0 &&
                gos.exists('getRowId') &&
                // this property is a backwards compatibility property, for those who want
                // the old behaviour of Row IDs but NOT Immutable Data.
                !gos.get('resetRowDataOnUpdate');
            if (immutable) {
                params.keepRenderedRows = true;
                params.animate = !this.gos.get('suppressAnimationFrame');
                params.changedRowNodes = new changedRowNodes_1.ChangedRowNodes();
                nodeManager.setImmutableRowData(params, newRowData);
            }
            else {
                params.rowDataUpdated = true;
                params.newData = true;
                // no need to invalidate cache, as the cache is stored on the rowNode,
                // so new rowNodes means the cache is wiped anyway.
                const { selectionSvc, pinnedRowModel } = this.beans;
                // - clears selection, done before we set row data to ensure it isn't readded via `selectionSvc.syncInOldRowNode`
                selectionSvc?.reset('rowDataChanged');
                // only clear pinned rows if using manual pinning
                if (pinnedRowModel?.isManual()) {
                    pinnedRowModel.reset();
                }
                this.rowNodesCountReady = true;
                nodeManager.setNewRowData(newRowData);
            }
        }
        if (params.rowDataUpdated) {
            params.step = 'group';
        }
        else if (params.step === 'nothing') {
            for (const { refreshProps, step } of this.orderedStages) {
                if (properties.some((prop) => refreshProps.has(prop))) {
                    params.step = step;
                    break;
                }
            }
        }
        if (params.step !== 'nothing') {
            this.refreshModel(params);
        }
    }
    setRowTopAndRowIndex() {
        const { beans, rowsToDisplay } = this;
        const defaultRowHeight = beans.environment.getDefaultRowHeight();
        let nextRowTop = 0;
        // mapping displayed rows is not needed for this method, however it's used in
        // clearRowTopAndRowIndex(), and given we are looping through this.rowsToDisplay here,
        // we create the map here for performance reasons, so we don't loop a second time
        // in clearRowTopAndRowIndex()
        const displayedRowsMapped = new Set();
        // we don't estimate if doing fullHeight or autoHeight, as all rows get rendered all the time
        // with these two layouts.
        const allowEstimate = (0, gridOptionsUtils_1._isDomLayout)(this.gos, 'normal');
        for (let i = 0, len = rowsToDisplay.length; i < len; ++i) {
            const rowNode = rowsToDisplay[i];
            if (rowNode.id != null) {
                displayedRowsMapped.add(rowNode.id);
            }
            if (rowNode.rowHeight == null) {
                const rowHeight = (0, gridOptionsUtils_1._getRowHeightForNode)(beans, rowNode, allowEstimate, defaultRowHeight);
                rowNode.setRowHeight(rowHeight.height, rowHeight.estimated);
            }
            rowNode.setRowTop(nextRowTop);
            rowNode.setRowIndex(i);
            nextRowTop += rowNode.rowHeight;
        }
        return displayedRowsMapped;
    }
    clearRowTopAndRowIndex(changedPath, displayedRowsMapped) {
        const changedPathActive = changedPath.active;
        const clearIfNotDisplayed = (rowNode) => {
            if (rowNode && rowNode.id != null && !displayedRowsMapped.has(rowNode.id)) {
                rowNode.clearRowTopAndRowIndex();
            }
        };
        const recurse = (rowNode) => {
            if (rowNode === null) {
                return;
            }
            clearIfNotDisplayed(rowNode);
            clearIfNotDisplayed(rowNode.detailNode);
            clearIfNotDisplayed(rowNode.sibling);
            if (rowNode.hasChildren()) {
                if (rowNode.childrenAfterGroup) {
                    // if a changedPath is active, it means we are here because of a transaction update or
                    // a change detection. neither of these impacts the open/closed state of groups. so if
                    // a group is not open this time, it was not open last time. so we know all closed groups
                    // already have their top positions cleared. so there is no need to traverse all the way
                    // when changedPath is active and the rowNode is not expanded.
                    const isRootNode = rowNode.level == -1; // we need to give special consideration for root node,
                    // as expanded=undefined for root node
                    const skipChildren = changedPathActive && !isRootNode && !rowNode.expanded;
                    if (!skipChildren) {
                        rowNode.childrenAfterGroup.forEach(recurse);
                    }
                }
            }
        };
        recurse(this.rootNode);
    }
    isLastRowIndexKnown() {
        return true;
    }
    getRowCount() {
        if (this.rowsToDisplay) {
            return this.rowsToDisplay.length;
        }
        return 0;
    }
    /**
     * Returns the number of rows with level === 1
     */
    getTopLevelRowCount() {
        const rootNode = this.rootNode;
        if (!rootNode) {
            return 0;
        }
        if (this.rowsToDisplay.length === 0) {
            return 0;
        }
        // exception to func comment, if showing root node, then we return that
        const showingRootNode = this.rowsToDisplay && this.rowsToDisplay[0] === rootNode;
        if (showingRootNode) {
            return 1;
        }
        // we use the childrenAfterSort as postSortRows is occasionally used to reduce row count.
        const filteredChildren = rootNode.childrenAfterSort;
        const totalFooterInc = rootNode.sibling ? 1 : 0;
        return (filteredChildren ? filteredChildren.length : 0) + totalFooterInc;
    }
    /**
     * Get the row display index by the top level index
     * top level index is the index of rows with level === 1
     */
    getTopLevelRowDisplayedIndex(topLevelIndex) {
        const { rootNode, rowsToDisplay } = this;
        const showingRootNode = !rootNode || !rowsToDisplay.length || rowsToDisplay[0] === rootNode;
        // exception to function comment, if showing footer node (level === -1) return 0.
        if (showingRootNode) {
            return topLevelIndex;
        }
        const { childrenAfterSort } = rootNode;
        const getDefaultIndex = (adjustedIndex) => {
            let rowNode = childrenAfterSort[adjustedIndex];
            if (this.gos.get('groupHideOpenParents')) {
                // if hideOpenParents, then get lowest displayed descendent
                while (rowNode.expanded && rowNode.childrenAfterSort && rowNode.childrenAfterSort.length > 0) {
                    rowNode = rowNode.childrenAfterSort[0];
                }
            }
            return rowNode.rowIndex;
        };
        const { footerSvc } = this.beans;
        if (footerSvc) {
            return footerSvc.getTopDisplayIndex(rowsToDisplay, topLevelIndex, childrenAfterSort, getDefaultIndex);
        }
        else {
            return getDefaultIndex(topLevelIndex);
        }
    }
    /**
     * The opposite of `getTopLevelRowDisplayedIndex`
     */
    getTopLevelIndexFromDisplayedIndex(displayedIndex) {
        const { rootNode, rowsToDisplay } = this;
        const showingRootNode = !rootNode || !rowsToDisplay.length || rowsToDisplay[0] === rootNode;
        if (showingRootNode) {
            return displayedIndex;
        }
        let node = this.getRow(displayedIndex);
        if (node.footer) {
            node = node.sibling;
        }
        // find the top level node
        while (node.parent && node.parent !== rootNode) {
            node = node.parent;
        }
        const topLevelIndex = rootNode.childrenAfterSort?.findIndex((childNode) => childNode === node);
        return topLevelIndex === -1 ? displayedIndex : topLevelIndex ?? displayedIndex;
    }
    getRowBounds(index) {
        const rowNode = this.rowsToDisplay[index];
        if (rowNode) {
            return {
                rowTop: rowNode.rowTop,
                rowHeight: rowNode.rowHeight,
            };
        }
        return null;
    }
    onRowGroupOpened() {
        const animate = (0, gridOptionsUtils_1._isAnimateRows)(this.gos);
        this.refreshModel({ step: 'map', keepRenderedRows: true, animate: animate });
    }
    onFilterChanged(event) {
        if (event.afterDataChange) {
            return;
        }
        const animate = (0, gridOptionsUtils_1._isAnimateRows)(this.gos);
        const primaryOrQuickFilterChanged = event.columns.length === 0 || event.columns.some((col) => col.isPrimary());
        const step = primaryOrQuickFilterChanged ? 'filter' : 'filter_aggregates';
        this.refreshModel({ step: step, keepRenderedRows: true, animate: animate });
    }
    onSortChanged() {
        const animate = (0, gridOptionsUtils_1._isAnimateRows)(this.gos);
        this.refreshModel({
            step: 'sort',
            keepRenderedRows: true,
            animate: animate,
        });
    }
    getType() {
        return 'clientSide';
    }
    onValueChanged() {
        this.refreshModel({ step: this.colModel.isPivotActive() ? 'pivot' : 'aggregate' });
    }
    createChangePath(enabled) {
        // for updates, if the row is updated at all, then we re-calc all the values
        // in that row. we could compare each value to each old value, however if we
        // did this, we would be calling the valueSvc twice, once on the old value
        // and once on the new value. so it's less valueGetter calls if we just assume
        // each column is different. that way the changedPath is used so that only
        // the impacted parent rows are recalculated, parents who's children have
        // not changed are not impacted.
        const changedPath = new changedPath_1.ChangedPath(false, this.rootNode);
        if (!enabled) {
            changedPath.active = false;
        }
        return changedPath;
    }
    isSuppressModelUpdateAfterUpdateTransaction(params) {
        if (!this.gos.get('suppressModelUpdateAfterUpdateTransaction')) {
            return false; // Not suppressed
        }
        const { changedRowNodes, newData, rowDataUpdated } = params;
        if (!changedRowNodes || newData || !rowDataUpdated) {
            return false; // Not a transaction update
        }
        if (changedRowNodes.removals.size || changedRowNodes.adds.size) {
            return false; // There are added rows or removed rows, not just updates
        }
        return true; // Nothing changed, or only updates with no new rows and no removals
    }
    beforeRefreshModel(params, groupsChanged = false) {
        this.eventSvc.dispatchEvent({ type: 'beforeRefreshModel', params, groupsChanged });
        if (this.started && params.rowDataUpdated) {
            this.eventSvc.dispatchEvent({ type: 'rowDataUpdated' });
        }
    }
    refreshModel(params) {
        if (!this.rootNode) {
            return; // Destroyed
        }
        // this goes through the pipeline of stages. what's in my head is similar
        // to the diagram on this page:
        // http://commons.apache.org/sandbox/commons-pipeline/pipeline_basics.html
        // however we want to keep the results of each stage, hence we manually call
        // each step rather than have them chain each other.
        // fallthrough in below switch is on purpose,
        // eg if STEP_FILTER, then all steps below this
        // step get done
        // let start: number;
        // console.log('======= start =======');
        const changedPath = (params.changedPath ?? (params.changedPath = this.createChangePath(!params.newData && !!params.rowDataUpdated)));
        if (!this.started ||
            this.isRefreshingModel ||
            this.colModel.changeEventsDispatching ||
            this.isSuppressModelUpdateAfterUpdateTransaction(params)) {
            this.beforeRefreshModel(params);
            return;
        }
        this.isRefreshingModel = true;
        if (params.step !== 'group') {
            this.beforeRefreshModel(params);
        }
        /* eslint-disable no-fallthrough */
        switch (params.step) {
            case 'group': {
                const groupingChanged = this.doRowGrouping(params);
                this.beforeRefreshModel(params, groupingChanged); // Do this after grouping, so the parent field is correct
                if (params.step === 'group' && this.rowNodesCountReady) {
                    this.rowCountReady = true; // only if row data has been set
                    this.eventSvc.dispatchEventOnce({ type: 'rowCountReady' });
                }
            }
            case 'filter':
                this.doFilter(changedPath);
            case 'pivot':
                this.doPivot(changedPath);
            case 'aggregate': // depends on agg fields
                this.doAggregate(changedPath);
            case 'filter_aggregates':
                this.doFilterAggregates(changedPath);
            case 'sort':
                this.doSort(params.changedRowNodes, changedPath);
            case 'map':
                this.doRowsToDisplay();
        }
        /* eslint-enable no-fallthrough */
        // set all row tops to null, then set row tops on all visible rows. if we don't
        // do this, then the algorithm below only sets row tops, old row tops from old rows
        // will still lie around
        const displayedNodesMapped = this.setRowTopAndRowIndex();
        this.clearRowTopAndRowIndex(changedPath, displayedNodesMapped);
        this.isRefreshingModel = false;
        this.eventSvc.dispatchEvent({
            type: 'modelUpdated',
            animate: params.animate,
            keepRenderedRows: params.keepRenderedRows,
            newData: params.newData,
            newPage: false,
            keepUndoRedoStack: params.keepUndoRedoStack,
        });
    }
    isEmpty() {
        return !this.rootNode?.allLeafChildren?.length || !this.colModel?.ready;
    }
    isRowsToRender() {
        return this.rowsToDisplay.length > 0;
    }
    getNodesInRangeForSelection(firstInRange, lastInRange) {
        let started = false;
        let finished = false;
        const result = [];
        const groupsSelectChildren = (0, gridOptionsUtils_1._getGroupSelectsDescendants)(this.gos);
        this.forEachNodeAfterFilterAndSort((rowNode) => {
            // range has been closed, skip till end
            if (finished) {
                return;
            }
            if (started) {
                if (rowNode === lastInRange || rowNode === firstInRange) {
                    // check if this is the last node we're going to be adding
                    finished = true;
                    // if the final node was a group node, and we're doing groupSelectsChildren
                    // make the exception to select all of it's descendants too
                    if (rowNode.group && groupsSelectChildren) {
                        result.push(...rowNode.allLeafChildren);
                        return;
                    }
                }
            }
            if (!started) {
                if (rowNode !== lastInRange && rowNode !== firstInRange) {
                    // still haven't hit a boundary node, keep searching
                    return;
                }
                started = true;
            }
            // only select leaf nodes if groupsSelectChildren
            const includeThisNode = !rowNode.group || !groupsSelectChildren;
            if (includeThisNode) {
                result.push(rowNode);
                return;
            }
        });
        return result;
    }
    getTopLevelNodes() {
        return this.rootNode?.childrenAfterGroup ?? null;
    }
    getRow(index) {
        return this.rowsToDisplay[index];
    }
    isRowPresent(rowNode) {
        return this.rowsToDisplay.indexOf(rowNode) >= 0;
    }
    getRowIndexAtPixel(pixelToMatch) {
        const rowsToDisplay = this.rowsToDisplay;
        if (this.isEmpty() || rowsToDisplay.length === 0) {
            return -1;
        }
        // do binary search of tree
        // http://oli.me.uk/2013/06/08/searching-javascript-arrays-with-a-binary-search/
        let bottomPointer = 0;
        let topPointer = rowsToDisplay.length - 1;
        // quick check, if the pixel is out of bounds, then return last row
        if (pixelToMatch <= 0) {
            // if pixel is less than or equal zero, it's always the first row
            return 0;
        }
        const lastNode = (0, array_1._last)(rowsToDisplay);
        if (lastNode.rowTop <= pixelToMatch) {
            return rowsToDisplay.length - 1;
        }
        let oldBottomPointer = -1;
        let oldTopPointer = -1;
        while (true) {
            const midPointer = Math.floor((bottomPointer + topPointer) / 2);
            const currentRowNode = rowsToDisplay[midPointer];
            if (this.isRowInPixel(currentRowNode, pixelToMatch)) {
                return midPointer;
            }
            if (currentRowNode.rowTop < pixelToMatch) {
                bottomPointer = midPointer + 1;
            }
            else if (currentRowNode.rowTop > pixelToMatch) {
                topPointer = midPointer - 1;
            }
            // infinite loops happen when there is space between rows. this can happen
            // when Auto Height is active, cos we re-calculate row tops asynchronously
            // when row heights change, which can temporarily result in gaps between rows.
            const caughtInInfiniteLoop = oldBottomPointer === bottomPointer && oldTopPointer === topPointer;
            if (caughtInInfiniteLoop) {
                return midPointer;
            }
            oldBottomPointer = bottomPointer;
            oldTopPointer = topPointer;
        }
    }
    isRowInPixel(rowNode, pixelToMatch) {
        const topPixel = rowNode.rowTop;
        const bottomPixel = rowNode.rowTop + rowNode.rowHeight;
        const pixelInRow = topPixel <= pixelToMatch && bottomPixel > pixelToMatch;
        return pixelInRow;
    }
    forEachLeafNode(callback) {
        this.rootNode?.allLeafChildren?.forEach((rowNode, index) => callback(rowNode, index));
    }
    forEachNode(callback, includeFooterNodes = false) {
        this.depthFirstSearchRowNodes(callback, includeFooterNodes);
    }
    forEachDisplayedNode(callback) {
        this.rowsToDisplay.forEach(callback);
    }
    forEachNodeAfterFilter(callback, includeFooterNodes = false) {
        this.depthFirstSearchRowNodes(callback, includeFooterNodes, (node) => node.childrenAfterAggFilter);
    }
    forEachNodeAfterFilterAndSort(callback, includeFooterNodes = false) {
        this.depthFirstSearchRowNodes(callback, includeFooterNodes, (node) => node.childrenAfterSort);
    }
    forEachPivotNode(callback, includeFooterNodes = false, afterSort = false) {
        const { colModel, rowGroupColsSvc } = this.beans;
        if (!colModel.isPivotMode()) {
            return;
        }
        // if no row grouping, then only row is root node
        if (!rowGroupColsSvc?.columns.length) {
            callback(this.rootNode, 0);
            return;
        }
        const childrenField = afterSort ? 'childrenAfterSort' : 'childrenAfterGroup';
        // for pivot, we don't go below leafGroup levels
        this.depthFirstSearchRowNodes(callback, includeFooterNodes, (node) => !node.leafGroup ? node[childrenField] : null);
    }
    /**
     * Iterate through each node and all of its children
     * @param callback the function to execute for each node
     * @param includeFooterNodes whether to also iterate over footer nodes
     * @param nodes the nodes to start iterating over
     * @param getChildren a function to determine the recursion strategy
     * @param startIndex the index to start from
     * @returns the index ended at
     */
    depthFirstSearchRowNodes(callback, includeFooterNodes = false, getChildren = (node) => node.childrenAfterGroup, node = this.rootNode, startIndex = 0) {
        let index = startIndex;
        if (!node) {
            return index;
        }
        const isRootNode = node === this.rootNode;
        if (!isRootNode) {
            callback(node, index++);
        }
        const { footerSvc } = this.beans;
        if (node.hasChildren() && !node.footer) {
            const children = getChildren(node);
            if (children) {
                index = footerSvc?.addTotalRows(index, node, callback, includeFooterNodes, isRootNode, 'top') ?? index;
                for (const node of children) {
                    index = this.depthFirstSearchRowNodes(callback, includeFooterNodes, getChildren, node, index);
                }
                return (footerSvc?.addTotalRows(index, node, callback, includeFooterNodes, isRootNode, 'bottom') ?? index);
            }
        }
        return index;
    }
    // it's possible to recompute the aggregate without doing the other parts
    // + api.refreshClientSideRowModel('aggregate')
    doAggregate(changedPath) {
        const rootNode = this.rootNode;
        if (rootNode) {
            this.aggStage?.execute({ rowNode: rootNode, changedPath: changedPath });
        }
    }
    doFilterAggregates(changedPath) {
        const rootNode = this.rootNode;
        if (this.filterAggStage) {
            this.filterAggStage.execute({ rowNode: rootNode, changedPath: changedPath });
        }
        else {
            // If filterAggStage is undefined, then so is the grouping stage, so all children should be on the rootNode.
            rootNode.childrenAfterAggFilter = rootNode.childrenAfterFilter;
        }
    }
    doSort(changedRowNodes, changedPath) {
        if (this.sortStage) {
            this.sortStage.execute({
                rowNode: this.rootNode,
                changedRowNodes,
                changedPath: changedPath,
            });
        }
        else {
            changedPath.forEachChangedNodeDepthFirst((rowNode) => {
                rowNode.childrenAfterSort = rowNode.childrenAfterAggFilter.slice(0);
                (0, sortStage_1.updateRowNodeAfterSort)(rowNode);
            });
        }
    }
    doRowGrouping(params) {
        const rootNode = this.rootNode;
        const groupStageExecuted = this.groupStage?.execute({
            rowNode: rootNode,
            changedRowNodes: params.changedRowNodes,
            changedPath: params.changedPath,
            rowNodesOrderChanged: !!params.rowNodesOrderChanged,
            afterColumnsChanged: !!params.afterColumnsChanged,
        });
        if (groupStageExecuted !== undefined) {
            return groupStageExecuted;
        }
        const sibling = rootNode.sibling;
        rootNode.childrenAfterGroup = rootNode.allLeafChildren;
        if (sibling) {
            sibling.childrenAfterGroup = rootNode.childrenAfterGroup;
        }
        rootNode.updateHasChildren();
        return false;
    }
    doFilter(changedPath) {
        if (this.filterStage) {
            this.filterStage.execute({ rowNode: this.rootNode, changedPath: changedPath });
        }
        else {
            changedPath.forEachChangedNodeDepthFirst((rowNode) => {
                rowNode.childrenAfterFilter = rowNode.childrenAfterGroup;
                (0, filterStage_1.updateRowNodeAfterFilter)(rowNode);
            }, true);
        }
    }
    doPivot(changedPath) {
        this.pivotStage?.execute({ rowNode: this.rootNode, changedPath: changedPath });
    }
    getRowNode(id) {
        const found = this.nodeManager.getRowNode(id);
        if (typeof found === 'object') {
            return found; // we check for typeof object to avoid returning things from Object.prototype
        }
        // although id is typed a string, this could be called by the user, and they could have passed a number
        const idIsGroup = typeof id == 'string' && id.indexOf(rowNode_1.ROW_ID_PREFIX_ROW_GROUP) === 0;
        return idIsGroup ? this.groupStage?.getNode(id) : undefined;
    }
    batchUpdateRowData(rowDataTransaction, callback) {
        if (this.applyAsyncTransactionsTimeout == null) {
            this.rowDataTransactionBatch = [];
            const waitMillis = this.gos.get('asyncTransactionWaitMillis');
            this.applyAsyncTransactionsTimeout = window.setTimeout(() => {
                if (this.isAlive()) {
                    // Handle case where grid is destroyed before timeout is triggered
                    this.executeBatchUpdateRowData();
                }
            }, waitMillis);
        }
        this.rowDataTransactionBatch.push({ rowDataTransaction: rowDataTransaction, callback });
    }
    flushAsyncTransactions() {
        if (this.applyAsyncTransactionsTimeout != null) {
            clearTimeout(this.applyAsyncTransactionsTimeout);
            this.executeBatchUpdateRowData();
        }
    }
    executeBatchUpdateRowData() {
        this.valueCache?.onDataChanged();
        const callbackFuncsBound = [];
        const rowNodeTrans = [];
        const changedRowNodes = new changedRowNodes_1.ChangedRowNodes();
        let orderChanged = false;
        this.rowDataTransactionBatch?.forEach((tranItem) => {
            this.rowNodesCountReady = true;
            const { rowNodeTransaction, rowsInserted } = this.nodeManager.updateRowData(tranItem.rowDataTransaction, changedRowNodes);
            if (rowsInserted) {
                orderChanged = true;
            }
            rowNodeTrans.push(rowNodeTransaction);
            if (tranItem.callback) {
                callbackFuncsBound.push(tranItem.callback.bind(null, rowNodeTransaction));
            }
        });
        this.commitTransactions(orderChanged, changedRowNodes);
        // do callbacks in next VM turn so it's async
        if (callbackFuncsBound.length > 0) {
            window.setTimeout(() => {
                callbackFuncsBound.forEach((func) => func());
            }, 0);
        }
        if (rowNodeTrans.length > 0) {
            this.eventSvc.dispatchEvent({
                type: 'asyncTransactionsFlushed',
                results: rowNodeTrans,
            });
        }
        this.rowDataTransactionBatch = null;
        this.applyAsyncTransactionsTimeout = undefined;
    }
    /**
     * Used to apply transaction changes.
     * Called by gridApi & rowDragFeature
     */
    updateRowData(rowDataTran) {
        this.valueCache?.onDataChanged();
        this.rowNodesCountReady = true;
        const changedRowNodes = new changedRowNodes_1.ChangedRowNodes();
        const { rowNodeTransaction, rowsInserted } = this.nodeManager.updateRowData(rowDataTran, changedRowNodes);
        this.commitTransactions(rowsInserted, changedRowNodes);
        return rowNodeTransaction;
    }
    /**
     * Common to:
     * - executeBatchUpdateRowData (batch transactions)
     * - updateRowData (single transaction)
     * - setImmutableRowData (generated transaction)
     *
     * @param rowNodeTrans - the transactions to apply
     * @param orderChanged - whether the order of the rows has changed, either via generated transaction or user provided addIndex
     */
    commitTransactions(rowNodesOrderChanged, changedRowNodes) {
        this.refreshModel({
            step: 'group',
            rowDataUpdated: true,
            rowNodesOrderChanged,
            keepRenderedRows: true,
            animate: !this.gos.get('suppressAnimationFrame'),
            changedRowNodes,
            changedPath: this.createChangePath(true),
        });
    }
    doRowsToDisplay() {
        const { flattenStage, rootNode } = this;
        let rowsToDisplay;
        if (flattenStage) {
            rowsToDisplay = flattenStage.execute({ rowNode: rootNode });
        }
        else {
            rowsToDisplay = rootNode?.childrenAfterSort ?? [];
            for (const row of rowsToDisplay) {
                row.setUiLevel(0);
            }
        }
        this.rowsToDisplay = rowsToDisplay;
    }
    onRowHeightChanged() {
        this.refreshModel({
            step: 'map',
            keepRenderedRows: true,
            keepUndoRedoStack: true,
        });
    }
    resetRowHeights() {
        const rootNode = this.rootNode;
        if (!rootNode) {
            return;
        }
        const atLeastOne = this.resetRowHeightsForAllRowNodes();
        rootNode.setRowHeight(rootNode.rowHeight, true);
        if (rootNode.sibling) {
            rootNode.sibling.setRowHeight(rootNode.sibling.rowHeight, true);
        }
        // when pivotMode but pivot not active, root node is displayed on its own
        // because it's only ever displayed alone, refreshing the model (onRowHeightChanged) is not required
        if (atLeastOne) {
            this.onRowHeightChanged();
        }
    }
    resetRowHeightsForAllRowNodes() {
        let atLeastOne = false;
        this.forEachNode((rowNode) => {
            rowNode.setRowHeight(rowNode.rowHeight, true);
            // we keep the height each row is at, however we set estimated=true rather than clear the height.
            // this means the grid will not reset the row heights back to defaults, rather it will re-calc
            // the height for each row as the row is displayed. otherwise the scroll will jump when heights are reset.
            const detailNode = rowNode.detailNode;
            if (detailNode) {
                detailNode.setRowHeight(detailNode.rowHeight, true);
            }
            if (rowNode.sibling) {
                rowNode.sibling.setRowHeight(rowNode.sibling.rowHeight, true);
            }
            atLeastOne = true;
        });
        return atLeastOne;
    }
    onGridStylesChanges(e) {
        if (e.rowHeightChanged) {
            if (this.beans.rowAutoHeight?.active) {
                return;
            }
            this.resetRowHeights();
        }
    }
    onGridReady() {
        if (!this.started) {
            // App can start using API to add transactions, so need to add data into the node manager if not started
            this.setInitialData();
        }
    }
    isRowDataLoaded() {
        return this.rowCountReady;
    }
    destroy() {
        super.destroy();
        // Forcefully deallocate memory
        this.started = false;
        this.rootNode = null;
        this.nodeManager = null;
        this.rowDataTransactionBatch = null;
        this.orderedStages = array_1._EmptyArray;
        this.rowsToDisplay = array_1._EmptyArray;
    }
    /**
     * @deprecated v33.1
     */
    onRowHeightChangedDebounced() {
        this.onRowHeightChanged_debounced();
    }
}
exports.ClientSideRowModel = ClientSideRowModel;


/***/ }),

/***/ 4452:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getBestCostNodeSelection = exports.flushAsyncTransactions = exports.applyTransactionAsync = exports.applyTransaction = exports.resetRowHeights = exports.forEachNodeAfterFilterAndSort = exports.forEachNodeAfterFilter = exports.forEachLeafNode = exports.isRowDataEmpty = exports.refreshClientSideRowModel = exports.onGroupExpandedOrCollapsed = void 0;
const rowModelApiUtils_1 = __webpack_require__(6876);
const logging_1 = __webpack_require__(7764);
function onGroupExpandedOrCollapsed(beans) {
    beans.expansionSvc?.onGroupExpandedOrCollapsed();
}
exports.onGroupExpandedOrCollapsed = onGroupExpandedOrCollapsed;
function refreshClientSideRowModel(beans, step) {
    const clientSideRowModel = (0, rowModelApiUtils_1._getClientSideRowModel)(beans);
    if (clientSideRowModel) {
        if (!step || step === 'everything') {
            step = 'group';
        }
        clientSideRowModel.refreshModel({
            step,
            keepRenderedRows: true,
            animate: !beans.gos.get('suppressAnimationFrame'),
        });
    }
}
exports.refreshClientSideRowModel = refreshClientSideRowModel;
function isRowDataEmpty(beans) {
    return (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.isEmpty() ?? true;
}
exports.isRowDataEmpty = isRowDataEmpty;
function forEachLeafNode(beans, callback) {
    (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.forEachLeafNode(callback);
}
exports.forEachLeafNode = forEachLeafNode;
function forEachNodeAfterFilter(beans, callback) {
    (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.forEachNodeAfterFilter(callback);
}
exports.forEachNodeAfterFilter = forEachNodeAfterFilter;
function forEachNodeAfterFilterAndSort(beans, callback) {
    (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.forEachNodeAfterFilterAndSort(callback);
}
exports.forEachNodeAfterFilterAndSort = forEachNodeAfterFilterAndSort;
function resetRowHeights(beans) {
    if (beans.rowAutoHeight?.active) {
        (0, logging_1._warn)(3);
        return;
    }
    (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.resetRowHeights();
}
exports.resetRowHeights = resetRowHeights;
function applyTransaction(beans, rowDataTransaction) {
    return beans.frameworkOverrides.wrapIncoming(() => (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.updateRowData(rowDataTransaction));
}
exports.applyTransaction = applyTransaction;
function applyTransactionAsync(beans, rowDataTransaction, callback) {
    beans.frameworkOverrides.wrapIncoming(() => (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.batchUpdateRowData(rowDataTransaction, callback));
}
exports.applyTransactionAsync = applyTransactionAsync;
function flushAsyncTransactions(beans) {
    beans.frameworkOverrides.wrapIncoming(() => (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.flushAsyncTransactions());
}
exports.flushAsyncTransactions = flushAsyncTransactions;
function getBestCostNodeSelection(beans) {
    return beans.selectionSvc?.getBestCostNodeSelection();
}
exports.getBestCostNodeSelection = getBestCostNodeSelection;


/***/ }),

/***/ 9722:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientSideRowModelApiModule = exports.ClientSideRowModelModule = void 0;
const sharedApiModule_1 = __webpack_require__(6437);
const sortModule_1 = __webpack_require__(6620);
const version_1 = __webpack_require__(7205);
const clientSideNodeManager_1 = __webpack_require__(8128);
const clientSideRowModel_1 = __webpack_require__(3278);
const clientSideRowModelApi_1 = __webpack_require__(4452);
const sortStage_1 = __webpack_require__(9849);
/**
 * @feature Client-Side Row Model
 */
exports.ClientSideRowModelModule = {
    moduleName: 'ClientSideRowModel',
    version: version_1.VERSION,
    rowModels: ['clientSide'],
    beans: [clientSideNodeManager_1.ClientSideNodeManager, clientSideRowModel_1.ClientSideRowModel, sortStage_1.SortStage],
    dependsOn: [sortModule_1.SortModule],
};
/**
 * @feature Client-Side Row Model
 */
exports.ClientSideRowModelApiModule = {
    moduleName: 'ClientSideRowModelApi',
    version: version_1.VERSION,
    apiFunctions: {
        onGroupExpandedOrCollapsed: clientSideRowModelApi_1.onGroupExpandedOrCollapsed,
        refreshClientSideRowModel: clientSideRowModelApi_1.refreshClientSideRowModel,
        isRowDataEmpty: clientSideRowModelApi_1.isRowDataEmpty,
        forEachLeafNode: clientSideRowModelApi_1.forEachLeafNode,
        forEachNodeAfterFilter: clientSideRowModelApi_1.forEachNodeAfterFilter,
        forEachNodeAfterFilterAndSort: clientSideRowModelApi_1.forEachNodeAfterFilterAndSort,
        resetRowHeights: clientSideRowModelApi_1.resetRowHeights,
        applyTransaction: clientSideRowModelApi_1.applyTransaction,
        applyTransactionAsync: clientSideRowModelApi_1.applyTransactionAsync,
        flushAsyncTransactions: clientSideRowModelApi_1.flushAsyncTransactions,
        getBestCostNodeSelection: clientSideRowModelApi_1.getBestCostNodeSelection,
    },
    dependsOn: [sharedApiModule_1.CsrmSsrmSharedApiModule],
};


/***/ }),

/***/ 8287:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterStage = exports.updateRowNodeAfterFilter = void 0;
const beanStub_1 = __webpack_require__(8731);
function updateRowNodeAfterFilter(rowNode) {
    if (rowNode.sibling) {
        rowNode.sibling.childrenAfterFilter = rowNode.childrenAfterFilter;
    }
}
exports.updateRowNodeAfterFilter = updateRowNodeAfterFilter;
class FilterStage extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'filterStage';
        this.refreshProps = new Set(['excludeChildrenWhenTreeDataFiltering']);
        this.step = 'filter';
    }
    wireBeans(beans) {
        this.filterManager = beans.filterManager;
    }
    execute(params) {
        const { changedPath } = params;
        this.filter(changedPath);
    }
    filter(changedPath) {
        const filterActive = !!this.filterManager?.isChildFilterPresent();
        this.filterNodes(filterActive, changedPath);
    }
    filterNodes(filterActive, changedPath) {
        const filterCallback = (rowNode, includeChildNodes) => {
            // recursively get all children that are groups to also filter
            if (rowNode.hasChildren()) {
                // result of filter for this node. when filtering tree data, includeChildNodes = true when parent passes
                if (filterActive && !includeChildNodes) {
                    rowNode.childrenAfterFilter = rowNode.childrenAfterGroup.filter((childNode) => {
                        // a group is included in the result if it has any children of it's own.
                        // by this stage, the child groups are already filtered
                        const passBecauseChildren = childNode.childrenAfterFilter && childNode.childrenAfterFilter.length > 0;
                        // both leaf level nodes and tree data nodes have data. these get added if
                        // the data passes the filter
                        const passBecauseDataPasses = childNode.data && this.filterManager.doesRowPassFilter({ rowNode: childNode });
                        // note - tree data nodes pass either if a) they pass themselves or b) any children of that node pass
                        return passBecauseChildren || passBecauseDataPasses;
                    });
                }
                else {
                    // if not filtering, the result is the original list
                    rowNode.childrenAfterFilter = rowNode.childrenAfterGroup;
                }
            }
            else {
                rowNode.childrenAfterFilter = rowNode.childrenAfterGroup;
            }
            updateRowNodeAfterFilter(rowNode);
        };
        if (this.doingTreeDataFiltering()) {
            const treeDataDepthFirstFilter = (rowNode, alreadyFoundInParent) => {
                // tree data filter traverses the hierarchy depth first and includes child nodes if parent passes
                // filter, and parent nodes will be include if any children exist.
                if (rowNode.childrenAfterGroup) {
                    for (let i = 0; i < rowNode.childrenAfterGroup.length; i++) {
                        const childNode = rowNode.childrenAfterGroup[i];
                        // first check if current node passes filter before invoking child nodes
                        const foundInParent = alreadyFoundInParent || this.filterManager.doesRowPassFilter({ rowNode: childNode });
                        if (childNode.childrenAfterGroup) {
                            treeDataDepthFirstFilter(rowNode.childrenAfterGroup[i], foundInParent);
                        }
                        else {
                            filterCallback(childNode, foundInParent);
                        }
                    }
                }
                filterCallback(rowNode, alreadyFoundInParent);
            };
            const treeDataFilterCallback = (rowNode) => treeDataDepthFirstFilter(rowNode, false);
            changedPath.executeFromRootNode(treeDataFilterCallback);
        }
        else {
            const defaultFilterCallback = (rowNode) => filterCallback(rowNode, false);
            changedPath.forEachChangedNodeDepthFirst(defaultFilterCallback, true);
        }
    }
    doingTreeDataFiltering() {
        return this.gos.get('treeData') && !this.gos.get('excludeChildrenWhenTreeDataFiltering');
    }
}
exports.FilterStage = FilterStage;


/***/ }),

/***/ 9849:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SortStage = exports.updateRowNodeAfterSort = void 0;
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
const generic_1 = __webpack_require__(4422);
function updateChildIndexes(rowNode) {
    if ((0, generic_1._missing)(rowNode.childrenAfterSort)) {
        return;
    }
    const listToSort = rowNode.childrenAfterSort;
    for (let i = 0; i < listToSort.length; i++) {
        const child = listToSort[i];
        const firstChild = i === 0;
        const lastChild = i === rowNode.childrenAfterSort.length - 1;
        child.setFirstChild(firstChild);
        if (child.lastChild !== lastChild) {
            child.lastChild = lastChild;
            child.dispatchRowEvent('lastChildChanged');
        }
        if (child.childIndex !== i) {
            child.childIndex = i;
            child.dispatchRowEvent('childIndexChanged');
        }
    }
}
function updateRowNodeAfterSort(rowNode) {
    if (rowNode.sibling) {
        rowNode.sibling.childrenAfterSort = rowNode.childrenAfterSort;
    }
    updateChildIndexes(rowNode);
}
exports.updateRowNodeAfterSort = updateRowNodeAfterSort;
class SortStage extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'sortStage';
        this.refreshProps = new Set(['postSortRows', 'groupDisplayType', 'accentedSort']);
        this.step = 'sort';
    }
    execute(params) {
        const beans = this.beans;
        const sortOptions = beans.sortSvc.getSortOptions();
        const sortActive = (0, generic_1._exists)(sortOptions) && sortOptions.length > 0;
        const deltaSort = sortActive &&
            !!params.changedRowNodes &&
            // in time we can remove this check, so that delta sort is always
            // on if transactions are present. it's off for now so that we can
            // selectively turn it on and test it with some select users before
            // rolling out to everyone.
            this.gos.get('deltaSort');
        const sortContainsGroupColumns = sortOptions.some(({ column }) => {
            const isSortingCoupled = (0, gridOptionsUtils_1._isColumnsSortingCoupledToGroup)(beans.gos);
            if (isSortingCoupled) {
                return column.isPrimary() && column.isRowGroupActive();
            }
            return !!column.getColDef().showRowGroup;
        });
        this.sort(beans, sortOptions, sortActive, deltaSort, params.changedRowNodes, params.changedPath, sortContainsGroupColumns);
    }
    sort(beans, sortOptions, sortActive, useDeltaSort, changedRowNodes, changedPath, sortContainsGroupColumns) {
        const { gos, colModel, rowGroupColsSvc, rowNodeSorter, rowRenderer, showRowGroupCols } = beans;
        const groupMaintainOrder = gos.get('groupMaintainOrder');
        const groupColumnsPresent = colModel.getCols().some((c) => c.isRowGroupActive());
        const isPivotMode = colModel.isPivotMode();
        const postSortFunc = gos.getCallback('postSortRows');
        let hasAnyFirstChildChanged = false;
        const callback = (rowNode) => {
            // It's pointless to sort rows which aren't being displayed. in pivot mode we don't need to sort the leaf group children.
            const skipSortingPivotLeafs = isPivotMode && rowNode.leafGroup;
            // Javascript sort is non deterministic when all the array items are equals, ie Comparator always returns 0,
            // so to ensure the array keeps its order, add an additional sorting condition manually, in this case we
            // are going to inspect the original array position. This is what sortedRowNodes is for.
            const skipSortingGroups = groupMaintainOrder && groupColumnsPresent && !rowNode.leafGroup && !sortContainsGroupColumns;
            let newChildrenAfterSort;
            if (skipSortingGroups) {
                const nextGroup = rowGroupColsSvc?.columns?.[rowNode.level + 1];
                // if the sort is null, then sort was explicitly removed, so remove sort from this group.
                const wasSortExplicitlyRemoved = nextGroup?.getSort() === null;
                const childrenToBeSorted = rowNode.childrenAfterAggFilter.slice(0);
                if (rowNode.childrenAfterSort && !wasSortExplicitlyRemoved) {
                    const indexedOrders = {};
                    rowNode.childrenAfterSort.forEach((node, idx) => {
                        indexedOrders[node.id] = idx;
                    });
                    childrenToBeSorted.sort((row1, row2) => (indexedOrders[row1.id] ?? 0) - (indexedOrders[row2.id] ?? 0));
                }
                newChildrenAfterSort = childrenToBeSorted;
            }
            else if (!sortActive || skipSortingPivotLeafs) {
                // if there's no sort to make, skip this step
                newChildrenAfterSort = rowNode.childrenAfterAggFilter.slice(0);
            }
            else if (useDeltaSort && changedRowNodes) {
                newChildrenAfterSort = doDeltaSort(rowNodeSorter, rowNode, changedRowNodes, changedPath, sortOptions);
            }
            else {
                newChildrenAfterSort = rowNodeSorter.doFullSort(rowNode.childrenAfterAggFilter, sortOptions);
            }
            hasAnyFirstChildChanged || (hasAnyFirstChildChanged = rowNode.childrenAfterSort?.[0] !== newChildrenAfterSort[0]);
            rowNode.childrenAfterSort = newChildrenAfterSort;
            updateRowNodeAfterSort(rowNode);
            if (postSortFunc) {
                const params = { nodes: rowNode.childrenAfterSort };
                postSortFunc(params);
            }
        };
        changedPath?.forEachChangedNodeDepthFirst(callback);
        // if using group hide open parents and a sort has happened, refresh the group cells as the first child
        // displays the parent grouping - it's cheaper here to refresh all cells in col rather than fire events for every potential
        // child cell
        if (hasAnyFirstChildChanged && this.gos.get('groupHideOpenParents')) {
            const columns = showRowGroupCols?.getShowRowGroupCols();
            if (columns?.length) {
                rowRenderer.refreshCells({ columns, force: true });
            }
        }
    }
}
exports.SortStage = SortStage;
function doDeltaSort(rowNodeSorter, rowNode, changedRowNodes, changedPath, sortOptions) {
    const unsortedRows = rowNode.childrenAfterAggFilter;
    const oldSortedRows = rowNode.childrenAfterSort;
    if (!oldSortedRows) {
        return rowNodeSorter.doFullSort(unsortedRows, sortOptions);
    }
    const untouchedRows = new Set();
    const touchedRows = [];
    const { updates, adds } = changedRowNodes;
    for (let i = 0, len = unsortedRows.length; i < len; ++i) {
        const row = unsortedRows[i];
        if (updates.has(row) || adds.has(row) || (changedPath && !changedPath.canSkip(row))) {
            touchedRows.push({
                currentPos: touchedRows.length,
                rowNode: row,
            });
        }
        else {
            untouchedRows.add(row.id);
        }
    }
    const sortedUntouchedRows = oldSortedRows
        .filter((child) => untouchedRows.has(child.id))
        .map((rowNode, currentPos) => ({ currentPos, rowNode }));
    touchedRows.sort((a, b) => rowNodeSorter.compareRowNodes(sortOptions, a, b));
    return mergeSortedArrays(rowNodeSorter, sortOptions, touchedRows, sortedUntouchedRows);
}
// Merge two sorted arrays into each other
function mergeSortedArrays(rowNodeSorter, sortOptions, arr1, arr2) {
    const res = [];
    let i = 0;
    let j = 0;
    const arr1Length = arr1.length;
    const arr2Length = arr2.length;
    // Traverse both array, adding them in order
    while (i < arr1Length && j < arr2Length) {
        const a = arr1[i];
        const b = arr2[j];
        // Check if current element of first array is smaller than current element
        // of second array. If yes, store first array element and increment first array index.
        // Otherwise do same with second array
        const compareResult = rowNodeSorter.compareRowNodes(sortOptions, a, b);
        let chosen;
        if (compareResult < 0) {
            chosen = a;
            ++i;
        }
        else {
            chosen = b;
            ++j;
        }
        res.push(chosen.rowNode);
    }
    // add remaining from arr1
    while (i < arr1Length) {
        res.push(arr1[i++].rowNode);
    }
    // add remaining from arr2
    while (j < arr2Length) {
        res.push(arr2[j++].rowNode);
    }
    return res;
}


/***/ }),

/***/ 3218:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.autoSizeAllColumns = exports.autoSizeColumns = exports.sizeColumnsToFit = void 0;
function sizeColumnsToFit(beans, paramsOrGridWidth) {
    if (typeof paramsOrGridWidth === 'number') {
        beans.colAutosize?.sizeColumnsToFit(paramsOrGridWidth, 'api');
    }
    else {
        beans.colAutosize?.sizeColumnsToFitGridBody(paramsOrGridWidth);
    }
}
exports.sizeColumnsToFit = sizeColumnsToFit;
function autoSizeColumns({ colAutosize, visibleCols }, keysOrParams, skipHeader) {
    if (Array.isArray(keysOrParams)) {
        colAutosize?.autoSizeCols({ colKeys: keysOrParams, skipHeader, source: 'api' });
    }
    else {
        colAutosize?.autoSizeCols({
            colKeys: keysOrParams.colIds ?? visibleCols.allCols,
            skipHeader: keysOrParams.skipHeader,
            defaultMaxWidth: keysOrParams.defaultMaxWidth,
            defaultMinWidth: keysOrParams.defaultMinWidth,
            columnLimits: keysOrParams.columnLimits,
            source: 'api',
        });
    }
}
exports.autoSizeColumns = autoSizeColumns;
function autoSizeAllColumns(beans, paramsOrSkipHeader) {
    if (paramsOrSkipHeader && typeof paramsOrSkipHeader === 'object') {
        autoSizeColumns(beans, paramsOrSkipHeader);
    }
    else {
        beans.colAutosize?.autoSizeAllColumns({ source: 'api', skipHeader: paramsOrSkipHeader });
    }
}
exports.autoSizeAllColumns = autoSizeAllColumns;


/***/ }),

/***/ 3856:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnAutoSizeModule = void 0;
const autoWidthModule_1 = __webpack_require__(447);
const version_1 = __webpack_require__(7205);
const columnAutosizeApi_1 = __webpack_require__(3218);
const columnAutosizeService_1 = __webpack_require__(4817);
/**
 * @feature Columns -> Column Sizing
 * @gridOption autoSizeStrategy
 */
exports.ColumnAutoSizeModule = {
    moduleName: 'ColumnAutoSize',
    version: version_1.VERSION,
    beans: [columnAutosizeService_1.ColumnAutosizeService],
    apiFunctions: {
        sizeColumnsToFit: columnAutosizeApi_1.sizeColumnsToFit,
        autoSizeColumns: columnAutosizeApi_1.autoSizeColumns,
        autoSizeAllColumns: columnAutosizeApi_1.autoSizeAllColumns,
    },
    dependsOn: [autoWidthModule_1.AutoWidthModule],
};


/***/ }),

/***/ 4817:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnAutosizeService = void 0;
const columnEventUtils_1 = __webpack_require__(2934);
const columnUtils_1 = __webpack_require__(3146);
const beanStub_1 = __webpack_require__(8731);
const array_1 = __webpack_require__(1502);
const dom_1 = __webpack_require__(3507);
const logging_1 = __webpack_require__(7764);
const touchListener_1 = __webpack_require__(9644);
class ColumnAutosizeService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colAutosize';
        this.timesDelayed = 0;
        // when we're waiting for cell data types to be inferred, we need to defer column resizing
        this.shouldQueueResizeOperations = false;
        this.resizeOperationQueue = [];
    }
    postConstruct() {
        this.addManagedEventListeners({ firstDataRendered: () => this.onFirstDataRendered() });
    }
    autoSizeCols(params) {
        if (this.shouldQueueResizeOperations) {
            this.pushResizeOperation(() => this.autoSizeCols(params));
            return;
        }
        const { colKeys, skipHeader, skipHeaderGroups, stopAtGroup, defaultMaxWidth, defaultMinWidth, columnLimits = [], source = 'api', } = params;
        // because of column virtualisation, we can only do this function on columns that are
        // actually rendered, as non-rendered columns (outside the viewport and not rendered
        // due to column virtualisation) are not present. this can result in all rendered columns
        // getting narrowed, which in turn introduces more rendered columns on the RHS which
        // did not get autoSized in the original run, leaving the visible grid with columns on
        // the LHS sized, but RHS no. so we keep looping through the visible columns until
        // no more cols are available (rendered) to be resized
        const { animationFrameSvc, renderStatus, colModel, autoWidthCalc, visibleCols } = this.beans;
        // we autosize after animation frames finish in case any cell renderers need to complete first. this can
        // happen eg if client code is calling api.autoSizeAllColumns() straight after grid is initialised, but grid
        // hasn't fully drawn out all the cells yet (due to cell renderers in animation frames).
        animationFrameSvc?.flushAllFrames();
        if (this.timesDelayed < 5 && renderStatus && !renderStatus.areHeaderCellsRendered()) {
            // This is needed for React, as it doesn't render the headers synchronously all the time.
            // Added a defensive check to avoid infinite loop in case headers are never rendered.
            this.timesDelayed++;
            setTimeout(() => {
                if (this.isAlive()) {
                    this.autoSizeCols(params);
                }
            });
            return;
        }
        this.timesDelayed = 0;
        // keep track of which cols we have resized in here
        const columnsAutoSized = [];
        // initialise with anything except 0 so that while loop executes at least once
        let changesThisTimeAround = -1;
        const columnLimitsIndex = Object.fromEntries(columnLimits.map(({ colId, maxWidth, minWidth }) => [colId, { maxWidth, minWidth }]));
        const shouldSkipHeader = skipHeader != null ? skipHeader : this.gos.get('skipHeaderOnAutoSize');
        const shouldSkipHeaderGroups = skipHeaderGroups != null ? skipHeaderGroups : shouldSkipHeader;
        while (changesThisTimeAround !== 0) {
            changesThisTimeAround = 0;
            const updatedColumns = [];
            colKeys.forEach((key) => {
                if (!key || (0, columnUtils_1.isColumnSelectionCol)(key)) {
                    return;
                }
                const column = colModel.getCol(key);
                if (!column || (0, columnUtils_1.isRowNumberCol)(column)) {
                    return;
                }
                // if already autoSized, skip it
                if (columnsAutoSized.indexOf(column) >= 0) {
                    return;
                }
                // get how wide this col should be
                const preferredWidth = autoWidthCalc.getPreferredWidthForColumn(column, shouldSkipHeader);
                // preferredWidth = -1 if this col is not on the screen
                if (preferredWidth > 0) {
                    const columnLimit = columnLimitsIndex[column.colId] ?? {};
                    columnLimit.minWidth ?? (columnLimit.minWidth = defaultMinWidth);
                    columnLimit.maxWidth ?? (columnLimit.maxWidth = defaultMaxWidth);
                    const newWidth = normaliseColumnWidth(column, preferredWidth, columnLimit);
                    column.setActualWidth(newWidth, source);
                    columnsAutoSized.push(column);
                    changesThisTimeAround++;
                }
                updatedColumns.push(column);
            });
            if (!updatedColumns.length) {
                continue;
            }
            visibleCols.refresh(source);
        }
        if (!shouldSkipHeaderGroups) {
            this.autoSizeColumnGroupsByColumns(colKeys, source, stopAtGroup);
        }
        (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, columnsAutoSized, true, 'autosizeColumns');
    }
    autoSizeColumn(key, source, skipHeader) {
        if (key) {
            this.autoSizeCols({ colKeys: [key], skipHeader, skipHeaderGroups: true, source });
        }
    }
    autoSizeColumnGroupsByColumns(keys, source, stopAtGroup) {
        const { colModel, ctrlsSvc } = this.beans;
        const columnGroups = new Set();
        const columns = colModel.getColsForKeys(keys);
        columns.forEach((col) => {
            let parent = col.getParent();
            while (parent && parent != stopAtGroup) {
                if (!parent.isPadding()) {
                    columnGroups.add(parent);
                }
                parent = parent.getParent();
            }
        });
        let headerGroupCtrl;
        const resizedColumns = [];
        for (const columnGroup of columnGroups) {
            for (const headerContainerCtrl of ctrlsSvc.getHeaderRowContainerCtrls()) {
                headerGroupCtrl = headerContainerCtrl.getHeaderCtrlForColumn(columnGroup);
                if (headerGroupCtrl) {
                    break;
                }
            }
            if (headerGroupCtrl) {
                headerGroupCtrl.resizeLeafColumnsToFit(source);
            }
        }
        return resizedColumns;
    }
    autoSizeAllColumns(params) {
        if (this.shouldQueueResizeOperations) {
            this.pushResizeOperation(() => this.autoSizeAllColumns(params));
            return;
        }
        const allDisplayedColumns = this.beans.visibleCols.allCols;
        this.autoSizeCols({ colKeys: allDisplayedColumns, ...params });
    }
    addColumnAutosize(element, column) {
        const skipHeaderOnAutoSize = this.gos.get('skipHeaderOnAutoSize');
        const autoSizeColListener = () => {
            this.autoSizeColumn(column, 'uiColumnResized', skipHeaderOnAutoSize);
        };
        element.addEventListener('dblclick', autoSizeColListener);
        const touchListener = new touchListener_1.TouchListener(element);
        touchListener.addEventListener('doubleTap', autoSizeColListener);
        return () => {
            element.removeEventListener('dblclick', autoSizeColListener);
            touchListener.removeEventListener('doubleTap', autoSizeColListener);
            touchListener.destroy();
        };
    }
    addColumnGroupResize(element, columnGroup, callback) {
        const skipHeaderOnAutoSize = this.gos.get('skipHeaderOnAutoSize');
        const listener = () => {
            // get list of all the column keys we are responsible for
            const keys = [];
            const leafCols = columnGroup.getDisplayedLeafColumns();
            leafCols.forEach((column) => {
                // not all cols in the group may be participating with auto-resize
                if (!column.getColDef().suppressAutoSize) {
                    keys.push(column.getColId());
                }
            });
            if (keys.length > 0) {
                this.autoSizeCols({
                    colKeys: keys,
                    skipHeader: skipHeaderOnAutoSize,
                    stopAtGroup: columnGroup,
                    source: 'uiColumnResized',
                });
            }
            callback();
        };
        element.addEventListener('dblclick', listener);
        return () => element.removeEventListener('dblclick', listener);
    }
    // method will call itself if no available width. this covers if the grid
    // isn't visible, but is just about to be visible.
    sizeColumnsToFitGridBody(params, nextTimeout) {
        if (!this.isAlive()) {
            return;
        }
        const { ctrlsSvc, scrollVisibleSvc } = this.beans;
        const gridBodyCtrl = ctrlsSvc.getGridBodyCtrl();
        const removeScrollWidth = gridBodyCtrl.isVerticalScrollShowing();
        const scrollWidthToRemove = removeScrollWidth ? scrollVisibleSvc.getScrollbarWidth() : 0;
        // bodyViewportWidth should be calculated from eGridBody, not eBodyViewport
        // because we change the width of the bodyViewport to hide the real browser scrollbar
        const bodyViewportWidth = (0, dom_1._getInnerWidth)(gridBodyCtrl.eGridBody);
        const availableWidth = bodyViewportWidth - scrollWidthToRemove;
        if (availableWidth > 0) {
            this.sizeColumnsToFit(availableWidth, 'sizeColumnsToFit', false, params);
            return;
        }
        if (nextTimeout === undefined) {
            window.setTimeout(() => {
                this.sizeColumnsToFitGridBody(params, 100);
            }, 0);
        }
        else if (nextTimeout === 100) {
            window.setTimeout(() => {
                this.sizeColumnsToFitGridBody(params, 500);
            }, 100);
        }
        else if (nextTimeout === 500) {
            window.setTimeout(() => {
                this.sizeColumnsToFitGridBody(params, -1);
            }, 500);
        }
        else {
            // Grid coming back with zero width, maybe the grid is not visible yet on the screen?
            (0, logging_1._warn)(29);
        }
    }
    // called from api
    sizeColumnsToFit(gridWidth, source = 'sizeColumnsToFit', silent, params) {
        if (this.shouldQueueResizeOperations) {
            this.pushResizeOperation(() => this.sizeColumnsToFit(gridWidth, source, silent, params));
            return;
        }
        const limitsMap = {};
        if (params) {
            params?.columnLimits?.forEach(({ key, ...dimensions }) => {
                limitsMap[typeof key === 'string' ? key : key.getColId()] = dimensions;
            });
        }
        // avoid divide by zero
        const allDisplayedColumns = this.beans.visibleCols.allCols;
        if (gridWidth <= 0 || !allDisplayedColumns.length) {
            return;
        }
        const doColumnsAlreadyFit = gridWidth === (0, columnUtils_1.getWidthOfColsInList)(allDisplayedColumns);
        if (doColumnsAlreadyFit) {
            // if all columns fit, check they are within the min and max widths - if so, can quit early.
            const doAllColumnsSatisfyConstraints = allDisplayedColumns.every((column) => {
                if (column.colDef.suppressSizeToFit) {
                    return true;
                }
                const widthOverride = limitsMap?.[column.getId()];
                const minWidth = widthOverride?.minWidth ?? params?.defaultMinWidth;
                const maxWidth = widthOverride?.maxWidth ?? params?.defaultMaxWidth;
                const colWidth = column.getActualWidth();
                return (minWidth == null || colWidth >= minWidth) && (maxWidth == null || colWidth <= maxWidth);
            });
            if (doAllColumnsSatisfyConstraints) {
                return;
            }
        }
        const colsToSpread = [];
        const colsToNotSpread = [];
        allDisplayedColumns.forEach((column) => {
            if (column.getColDef().suppressSizeToFit === true) {
                colsToNotSpread.push(column);
            }
            else {
                colsToSpread.push(column);
            }
        });
        // make a copy of the cols that are going to be resized
        const colsToDispatchEventFor = colsToSpread.slice(0);
        let finishedResizing = false;
        const moveToNotSpread = (column) => {
            (0, array_1._removeFromArray)(colsToSpread, column);
            colsToNotSpread.push(column);
        };
        // resetting cols to their original width makes the sizeColumnsToFit more deterministic,
        // rather than depending on the current size of the columns. most users call sizeColumnsToFit
        // immediately after grid is created, so will make no difference. however if application is calling
        // sizeColumnsToFit repeatedly (eg after column group is opened / closed repeatedly) we don't want
        // the columns to start shrinking / growing over time.
        //
        // NOTE: the process below will assign values to `this.actualWidth` of each column without firing events
        // for this reason we need to manually dispatch resize events after the resize has been done for each column.
        colsToSpread.forEach((column) => {
            column.resetActualWidth(source);
            const widthOverride = limitsMap?.[column.getId()];
            const minOverride = widthOverride?.minWidth ?? params?.defaultMinWidth;
            const maxOverride = widthOverride?.maxWidth ?? params?.defaultMaxWidth;
            const colWidth = column.getActualWidth();
            if (typeof minOverride === 'number' && colWidth < minOverride) {
                column.setActualWidth(minOverride, source, true);
            }
            else if (typeof maxOverride === 'number' && colWidth > maxOverride) {
                column.setActualWidth(maxOverride, source, true);
            }
        });
        while (!finishedResizing) {
            finishedResizing = true;
            const availablePixels = gridWidth - (0, columnUtils_1.getWidthOfColsInList)(colsToNotSpread);
            if (availablePixels <= 0) {
                // no width, set everything to minimum
                colsToSpread.forEach((column) => {
                    const widthOverride = limitsMap?.[column.getId()]?.minWidth ?? params?.defaultMinWidth;
                    if (typeof widthOverride === 'number') {
                        column.setActualWidth(widthOverride, source, true);
                        return;
                    }
                    column.setActualWidth(column.minWidth, source);
                });
            }
            else {
                const scale = availablePixels / (0, columnUtils_1.getWidthOfColsInList)(colsToSpread);
                // we set the pixels for the last col based on what's left, as otherwise
                // we could be a pixel or two short or extra because of rounding errors.
                let pixelsForLastCol = availablePixels;
                // backwards through loop, as we are removing items as we go
                for (let i = colsToSpread.length - 1; i >= 0; i--) {
                    const column = colsToSpread[i];
                    const widthOverride = limitsMap?.[column.getId()];
                    const minOverride = widthOverride?.minWidth ?? params?.defaultMinWidth;
                    const maxOverride = widthOverride?.maxWidth ?? params?.defaultMaxWidth;
                    const colMinWidth = column.getMinWidth();
                    const colMaxWidth = column.getMaxWidth();
                    const minWidth = typeof minOverride === 'number' && minOverride > colMinWidth ? minOverride : colMinWidth;
                    const maxWidth = typeof maxOverride === 'number' && maxOverride < colMaxWidth ? maxOverride : colMaxWidth;
                    let newWidth = Math.round(column.getActualWidth() * scale);
                    if (newWidth < minWidth) {
                        newWidth = minWidth;
                        moveToNotSpread(column);
                        finishedResizing = false;
                    }
                    else if (newWidth > maxWidth) {
                        newWidth = maxWidth;
                        moveToNotSpread(column);
                        finishedResizing = false;
                    }
                    else if (i === 0) {
                        // if this is the last column
                        newWidth = pixelsForLastCol;
                    }
                    column.setActualWidth(newWidth, source, true);
                    pixelsForLastCol -= newWidth;
                }
            }
        }
        // see notes above
        colsToDispatchEventFor.forEach((col) => {
            col.fireColumnWidthChangedEvent(source);
        });
        const visibleCols = this.beans.visibleCols;
        visibleCols.setLeftValues(source);
        visibleCols.updateBodyWidths();
        if (silent) {
            return;
        }
        (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, colsToDispatchEventFor, true, source);
    }
    applyAutosizeStrategy() {
        const autoSizeStrategy = this.gos.get('autoSizeStrategy');
        if (!autoSizeStrategy) {
            return;
        }
        const { type } = autoSizeStrategy;
        // ensure things like aligned grids have linked first
        setTimeout(() => {
            if (type === 'fitGridWidth') {
                const { columnLimits: propColumnLimits, defaultMinWidth, defaultMaxWidth } = autoSizeStrategy;
                const columnLimits = propColumnLimits?.map(({ colId: key, minWidth, maxWidth }) => ({
                    key,
                    minWidth,
                    maxWidth,
                }));
                this.sizeColumnsToFitGridBody({
                    defaultMinWidth,
                    defaultMaxWidth,
                    columnLimits,
                });
            }
            else if (type === 'fitProvidedWidth') {
                this.sizeColumnsToFit(autoSizeStrategy.width, 'sizeColumnsToFit');
            }
        });
    }
    onFirstDataRendered() {
        const autoSizeStrategy = this.gos.get('autoSizeStrategy');
        if (autoSizeStrategy?.type !== 'fitCellContents') {
            return;
        }
        const { colIds: columns, skipHeader, defaultMaxWidth, defaultMinWidth, columnLimits } = autoSizeStrategy;
        // ensure render has finished
        setTimeout(() => {
            const params = {
                skipHeader,
                source: 'autosizeColumns',
                defaultMaxWidth,
                defaultMinWidth,
                columnLimits,
            };
            if (columns) {
                this.autoSizeCols({ colKeys: columns, ...params });
            }
            else {
                this.autoSizeAllColumns(params);
            }
        });
    }
    processResizeOperations() {
        this.shouldQueueResizeOperations = false;
        this.resizeOperationQueue.forEach((resizeOperation) => resizeOperation());
        this.resizeOperationQueue = [];
    }
    pushResizeOperation(func) {
        this.resizeOperationQueue.push(func);
    }
    destroy() {
        this.resizeOperationQueue.length = 0;
        super.destroy();
    }
}
exports.ColumnAutosizeService = ColumnAutosizeService;
/** returns the width we can set to this col, taking into consideration min and max widths */
function normaliseColumnWidth(column, newWidth, limits = {}) {
    const minWidth = limits.minWidth ?? column.getMinWidth();
    if (newWidth < minWidth) {
        newWidth = minWidth;
    }
    const maxWidth = limits.maxWidth ?? column.getMaxWidth();
    if (newWidth > maxWidth) {
        newWidth = maxWidth;
    }
    return newWidth;
}


/***/ }),

/***/ 9607:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.columnMovingCSS = void 0;
exports.columnMovingCSS = `:where(.ag-ltr) :where(.ag-column-moving){.ag-cell,.ag-header-cell,.ag-spanned-cell-wrapper{transition:left .2s}.ag-header-group-cell{transition:left .2s,width .2s}}:where(.ag-rtl) :where(.ag-column-moving){.ag-cell,.ag-header-cell,.ag-spanned-cell-wrapper{transition:right .2s}.ag-header-group-cell{transition:right .2s,width .2s}}`;


/***/ }),

/***/ 9122:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnAnimationService = void 0;
const beanStub_1 = __webpack_require__(8731);
class ColumnAnimationService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colAnimation';
        this.executeNextFuncs = [];
        this.executeLaterFuncs = [];
        this.active = false;
        // activeNext starts with active but it is reset earlier after the nextFuncs are cleared
        // to prevent calls made to executeNextVMTurn from queuing functions after executeNextFuncs has already been flushed,
        this.activeNext = false;
        this.suppressAnimation = false;
        this.animationThreadCount = 0;
    }
    postConstruct() {
        this.beans.ctrlsSvc.whenReady(this, (p) => (this.gridBodyCtrl = p.gridBodyCtrl));
    }
    isActive() {
        return this.active && !this.suppressAnimation;
    }
    setSuppressAnimation(suppress) {
        this.suppressAnimation = suppress;
    }
    start() {
        if (this.active) {
            return;
        }
        const { gos } = this;
        if (gos.get('suppressColumnMoveAnimation')) {
            return;
        }
        // if doing RTL, we don't animate open / close as due to how the pixels are inverted,
        // the animation moves all the row the the right rather than to the left (ie it's the static
        // columns that actually get their coordinates updated)
        if (gos.get('enableRtl')) {
            return;
        }
        this.ensureAnimationCssClassPresent();
        this.active = true;
        this.activeNext = true;
    }
    finish() {
        if (!this.active) {
            return;
        }
        this.flush(() => (this.activeNext = false), () => (this.active = false));
    }
    executeNextVMTurn(func) {
        if (this.activeNext) {
            this.executeNextFuncs.push(func);
        }
        else {
            func();
        }
    }
    executeLaterVMTurn(func) {
        if (this.active) {
            this.executeLaterFuncs.push(func);
        }
        else {
            func();
        }
    }
    ensureAnimationCssClassPresent() {
        // up the count, so we can tell if someone else has updated the count
        // by the time the 'wait' func executes
        this.animationThreadCount++;
        const animationThreadCountCopy = this.animationThreadCount;
        const { gridBodyCtrl } = this;
        gridBodyCtrl.setColumnMovingCss(true);
        this.executeLaterFuncs.push(() => {
            // only remove the class if this thread was the last one to update it
            if (this.animationThreadCount === animationThreadCountCopy) {
                gridBodyCtrl.setColumnMovingCss(false);
            }
        });
    }
    flush(callbackNext, callbackLater) {
        const { executeNextFuncs, executeLaterFuncs } = this;
        if (executeNextFuncs.length === 0 && executeLaterFuncs.length === 0) {
            callbackNext();
            callbackLater();
            return;
        }
        const runFuncs = (queue) => {
            while (queue.length) {
                const func = queue.pop();
                if (func) {
                    func();
                }
            }
        };
        this.beans.frameworkOverrides.wrapIncoming(() => {
            window.setTimeout(() => {
                callbackNext();
                runFuncs(executeNextFuncs);
            }, 0);
            window.setTimeout(() => {
                // run the callback before executeLaterFuncs
                // because some functions being executed later
                // check if this service is `active`.
                callbackLater();
                runFuncs(executeLaterFuncs);
            }, 200);
        });
    }
}
exports.ColumnAnimationService = ColumnAnimationService;


/***/ }),

/***/ 3052:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BodyDropPivotTarget = void 0;
const beanStub_1 = __webpack_require__(8731);
class BodyDropPivotTarget extends beanStub_1.BeanStub {
    constructor(pinned) {
        super();
        this.pinned = pinned;
        this.columnsToAggregate = [];
        this.columnsToGroup = [];
        this.columnsToPivot = [];
    }
    /** Callback for when drag enters */
    onDragEnter(draggingEvent) {
        this.clearColumnsList();
        // in pivot mode, we don't accept any drops if functions are read only
        if (this.gos.get('functionsReadOnly')) {
            return;
        }
        const dragColumns = draggingEvent.dragItem.columns;
        if (!dragColumns) {
            return;
        }
        dragColumns.forEach((column) => {
            // we don't allow adding secondary columns
            if (!column.isPrimary()) {
                return;
            }
            if (column.isAnyFunctionActive()) {
                return;
            }
            if (column.isAllowValue()) {
                this.columnsToAggregate.push(column);
            }
            else if (column.isAllowRowGroup()) {
                this.columnsToGroup.push(column);
            }
            else if (column.isAllowPivot()) {
                this.columnsToPivot.push(column);
            }
        });
    }
    getIconName() {
        const totalColumns = this.columnsToAggregate.length + this.columnsToGroup.length + this.columnsToPivot.length;
        if (totalColumns > 0) {
            return this.pinned ? 'pinned' : 'move';
        }
        return null;
    }
    /** Callback for when drag leaves */
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onDragLeave(draggingEvent) {
        // if we are taking columns out of the center, then we remove them from the report
        this.clearColumnsList();
    }
    clearColumnsList() {
        this.columnsToAggregate.length = 0;
        this.columnsToGroup.length = 0;
        this.columnsToPivot.length = 0;
    }
    /** Callback for when dragging */
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onDragging(draggingEvent) { }
    /** Callback for when drag stops */
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onDragStop(draggingEvent) {
        const { valueColsSvc, rowGroupColsSvc, pivotColsSvc } = this.beans;
        if (this.columnsToAggregate.length > 0) {
            valueColsSvc?.addColumns(this.columnsToAggregate, 'toolPanelDragAndDrop');
        }
        if (this.columnsToGroup.length > 0) {
            rowGroupColsSvc?.addColumns(this.columnsToGroup, 'toolPanelDragAndDrop');
        }
        if (this.columnsToPivot.length > 0) {
            pivotColsSvc?.addColumns(this.columnsToPivot, 'toolPanelDragAndDrop');
        }
    }
    onDragCancel() {
        this.clearColumnsList();
    }
}
exports.BodyDropPivotTarget = BodyDropPivotTarget;


/***/ }),

/***/ 7912:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BodyDropTarget = void 0;
const beanStub_1 = __webpack_require__(8731);
const dragAndDropService_1 = __webpack_require__(2903);
const bodyDropPivotTarget_1 = __webpack_require__(3052);
const moveColumnFeature_1 = __webpack_require__(2909);
class BodyDropTarget extends beanStub_1.BeanStub {
    constructor(pinned, eContainer) {
        super();
        this.pinned = pinned;
        this.eContainer = eContainer;
    }
    postConstruct() {
        const { ctrlsSvc, dragAndDrop } = this.beans;
        const pinned = this.pinned;
        ctrlsSvc.whenReady(this, (p) => {
            let eSecondaryContainers;
            const eBodyViewport = p.gridBodyCtrl.eBodyViewport;
            switch (pinned) {
                case 'left':
                    eSecondaryContainers = [
                        [eBodyViewport, p.left.eContainer],
                        [p.bottomLeft.eContainer],
                        [p.topLeft.eContainer],
                    ];
                    break;
                case 'right':
                    eSecondaryContainers = [
                        [eBodyViewport, p.right.eContainer],
                        [p.bottomRight.eContainer],
                        [p.topRight.eContainer],
                    ];
                    break;
                default:
                    eSecondaryContainers = [
                        [eBodyViewport, p.center.eViewport],
                        [p.bottomCenter.eViewport],
                        [p.topCenter.eViewport],
                    ];
                    break;
            }
            this.eSecondaryContainers = eSecondaryContainers;
        });
        this.moveColumnFeature = this.createManagedBean(new moveColumnFeature_1.MoveColumnFeature(pinned));
        this.bodyDropPivotTarget = this.createManagedBean(new bodyDropPivotTarget_1.BodyDropPivotTarget(pinned));
        dragAndDrop.addDropTarget(this);
        this.addDestroyFunc(() => dragAndDrop.removeDropTarget(this));
    }
    isInterestedIn(type) {
        return (type === dragAndDropService_1.DragSourceType.HeaderCell ||
            (type === dragAndDropService_1.DragSourceType.ToolPanel && this.gos.get('allowDragFromColumnsToolPanel')));
    }
    getSecondaryContainers() {
        return this.eSecondaryContainers;
    }
    getContainer() {
        return this.eContainer;
    }
    getIconName() {
        return this.currentDropListener.getIconName();
    }
    // we want to use the bodyPivotTarget if the user is dragging columns in from the toolPanel
    // and we are in pivot mode, as it has to logic to set pivot/value/group on the columns when
    // dropped into the grid's body.
    isDropColumnInPivotMode(draggingEvent) {
        // in pivot mode, then if moving a column (ie didn't come from toolpanel) then it's
        // a standard column move, however if it came from the toolpanel, then we are introducing
        // dimensions or values to the grid
        return this.beans.colModel.isPivotMode() && draggingEvent.dragSource.type === dragAndDropService_1.DragSourceType.ToolPanel;
    }
    onDragEnter(draggingEvent) {
        // we pick the drop listener depending on whether we are in pivot mode are not. if we are
        // in pivot mode, then dropping cols changes the row group, pivot, value stats. otherwise
        // we change visibility state and position.
        this.currentDropListener = this.isDropColumnInPivotMode(draggingEvent)
            ? this.bodyDropPivotTarget
            : this.moveColumnFeature;
        this.currentDropListener.onDragEnter(draggingEvent);
    }
    onDragLeave(params) {
        this.currentDropListener.onDragLeave(params);
    }
    onDragging(params) {
        this.currentDropListener.onDragging(params);
    }
    onDragStop(params) {
        this.currentDropListener.onDragStop(params);
    }
    onDragCancel() {
        this.currentDropListener.onDragCancel();
    }
}
exports.BodyDropTarget = BodyDropTarget;


/***/ }),

/***/ 2909:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MoveColumnFeature = void 0;
const beanStub_1 = __webpack_require__(8731);
const dragAndDropService_1 = __webpack_require__(2903);
const iColumn_1 = __webpack_require__(2783);
const array_1 = __webpack_require__(1502);
const generic_1 = __webpack_require__(4422);
const internalColumnMoveUtils_1 = __webpack_require__(5446);
const MOVE_FAIL_THRESHOLD = 7;
const SCROLL_MOVE_WIDTH = 100;
const SCROLL_GAP_NEEDED_BEFORE_MOVE = SCROLL_MOVE_WIDTH / 2;
const SCROLL_ACCELERATION_RATE = 5;
const SCROLL_TIME_INTERVAL = 100;
class MoveColumnFeature extends beanStub_1.BeanStub {
    constructor(pinned) {
        super();
        this.pinned = pinned;
        this.needToMoveLeft = false;
        this.needToMoveRight = false;
        this.lastMovedInfo = null;
        this.isCenterContainer = !(0, generic_1._exists)(pinned);
    }
    postConstruct() {
        this.beans.ctrlsSvc.whenReady(this, (p) => {
            this.gridBodyCon = p.gridBodyCtrl;
        });
    }
    getIconName() {
        const { pinned, lastDraggingEvent } = this;
        const { dragItem } = lastDraggingEvent || {};
        const columns = dragItem?.columns ?? [];
        for (const col of columns) {
            const colPinned = col.getPinned();
            // when the column is lockPinned, only moves within pinned section
            if (col.getColDef().lockPinned) {
                if (colPinned == pinned) {
                    return 'move';
                }
                continue;
            }
            // if the column pinned state is the same as the container's, or
            // when `unpinning` a column, set the icon to move
            const initialPinnedState = dragItem?.containerType;
            if (initialPinnedState === pinned || !pinned) {
                return 'move';
            }
            // moving an unpinned column to a pinned container
            // set the icon to pinned
            if (pinned && (!colPinned || initialPinnedState !== pinned)) {
                return 'pinned';
            }
        }
        return 'notAllowed';
    }
    onDragEnter(draggingEvent) {
        // we do dummy drag, so make sure column appears in the right location when first placed
        const dragItem = draggingEvent.dragItem;
        const columns = dragItem.columns;
        const dragCameFromToolPanel = draggingEvent.dragSource.type === dragAndDropService_1.DragSourceType.ToolPanel;
        if (dragCameFromToolPanel) {
            // the if statement doesn't work if drag leaves grid, then enters again
            this.setColumnsVisible(columns, true, 'uiColumnDragged');
        }
        else {
            // restore previous state of visible columns upon re-entering. this means if the user drags
            // a group out, and then drags the group back in, only columns that were originally visible
            // will be visible again. otherwise a group with three columns (but only two visible) could
            // be dragged out, then when it's dragged in again, all three are visible. this stops that.
            const visibleState = dragItem.visibleState;
            const visibleColumns = (columns || []).filter((column) => visibleState[column.getId()]);
            this.setColumnsVisible(visibleColumns, true, 'uiColumnDragged');
        }
        if (!this.gos.get('suppressMoveWhenColumnDragging')) {
            this.attemptToPinColumns(columns, this.pinned);
        }
        this.onDragging(draggingEvent, true, true);
    }
    onDragging(draggingEvent = this.lastDraggingEvent, fromEnter = false, fakeEvent = false, finished = false) {
        const { gos, ctrlsSvc } = this.beans;
        const isSuppressMoveWhenDragging = gos.get('suppressMoveWhenColumnDragging');
        if (finished && !isSuppressMoveWhenDragging) {
            this.finishColumnMoving();
            return;
        }
        this.lastDraggingEvent = draggingEvent;
        // if moving up or down (ie not left or right) then do nothing
        if (!draggingEvent || (!finished && (0, generic_1._missing)(draggingEvent.hDirection))) {
            return;
        }
        const mouseX = (0, internalColumnMoveUtils_1.normaliseX)({
            x: draggingEvent.x,
            pinned: this.pinned,
            gos,
            ctrlsSvc,
        });
        // if the user is dragging into the panel, ie coming from the side panel into the main grid,
        // we don't want to scroll the grid this time, it would appear like the table is jumping
        // each time a column is dragged in.
        if (!fromEnter) {
            this.checkCenterForScrolling(mouseX);
        }
        if (isSuppressMoveWhenDragging) {
            this.handleColumnDragWhileSuppressingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished);
        }
        else {
            this.handleColumnDragWhileAllowingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished);
        }
    }
    onDragLeave() {
        this.ensureIntervalCleared();
        this.clearHighlighted();
        this.updateDragItemContainerType();
        this.lastMovedInfo = null;
    }
    onDragStop() {
        this.onDragging(this.lastDraggingEvent, false, true, true);
        this.ensureIntervalCleared();
        this.lastMovedInfo = null;
    }
    onDragCancel() {
        this.clearHighlighted();
        this.ensureIntervalCleared();
        this.lastMovedInfo = null;
    }
    setColumnsVisible(columns, visible, source) {
        if (!columns) {
            return;
        }
        const allowedCols = columns.filter((c) => !c.getColDef().lockVisible);
        this.beans.colModel.setColsVisible(allowedCols, visible, source);
    }
    finishColumnMoving() {
        this.clearHighlighted();
        const lastMovedInfo = this.lastMovedInfo;
        if (!lastMovedInfo) {
            return;
        }
        const { columns, toIndex } = lastMovedInfo;
        this.beans.colMoves.moveColumns(columns, toIndex, 'uiColumnMoved', true);
    }
    updateDragItemContainerType() {
        const { lastDraggingEvent } = this;
        if (this.gos.get('suppressMoveWhenColumnDragging') || !lastDraggingEvent) {
            return;
        }
        const dragItem = lastDraggingEvent.dragItem;
        if (!dragItem) {
            return;
        }
        dragItem.containerType = this.pinned;
    }
    handleColumnDragWhileSuppressingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished) {
        const allMovingColumns = this.getAllMovingColumns(draggingEvent, true);
        if (finished) {
            // first we handle pinning, then move columns
            const isAttemptingToPin = this.isAttemptingToPin(allMovingColumns);
            if (isAttemptingToPin) {
                this.attemptToPinColumns(allMovingColumns, undefined, true);
            }
            const { fromLeft, xPosition } = this.getNormalisedXPositionInfo(allMovingColumns, isAttemptingToPin) || {};
            if (fromLeft == null || xPosition == null) {
                this.finishColumnMoving();
                return;
            }
            this.moveColumnsAfterHighlight({
                allMovingColumns,
                xPosition,
                fromEnter,
                fakeEvent,
                fromLeft,
            });
        }
        else {
            if (!this.beans.dragAndDrop.isDropZoneWithinThisGrid(draggingEvent)) {
                return;
            }
            this.highlightHoveredColumn(allMovingColumns, mouseX);
        }
    }
    handleColumnDragWhileAllowingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished) {
        const allMovingColumns = this.getAllMovingColumns(draggingEvent);
        const fromLeft = this.normaliseDirection(draggingEvent.hDirection) === 'right';
        const isFromHeader = draggingEvent.dragSource.type === dragAndDropService_1.DragSourceType.HeaderCell;
        const params = this.getMoveColumnParams({
            allMovingColumns,
            isFromHeader,
            xPosition: mouseX,
            fromLeft,
            fromEnter,
            fakeEvent,
        });
        const lastMovedInfo = (0, internalColumnMoveUtils_1.attemptMoveColumns)({ ...params, finished });
        if (lastMovedInfo) {
            this.lastMovedInfo = lastMovedInfo;
        }
    }
    getAllMovingColumns(draggingEvent, useSplit = false) {
        const dragItem = draggingEvent.dragSource.getDragItem();
        let columns = null;
        if (useSplit) {
            columns = dragItem.columnsInSplit;
            if (!columns) {
                columns = dragItem.columns;
            }
        }
        else {
            columns = dragItem.columns;
        }
        // if locked return true only if both col and container are same pin type.
        // double equals (==) here on purpose so that null==undefined is true (for not pinned options)
        // if not pin locked, then always allowed to be in this container
        const conditionCallback = (col) => col.getColDef().lockPinned ? col.getPinned() == this.pinned : true;
        if (!columns) {
            return [];
        }
        return columns.filter(conditionCallback);
    }
    getMoveColumnParams(params) {
        const { allMovingColumns, isFromHeader, xPosition, fromLeft, fromEnter, fakeEvent } = params;
        const { gos, colModel, colMoves, visibleCols } = this.beans;
        return {
            allMovingColumns,
            isFromHeader,
            fromLeft,
            xPosition,
            pinned: this.pinned,
            fromEnter,
            fakeEvent,
            gos,
            colModel,
            colMoves: colMoves,
            visibleCols,
        };
    }
    highlightHoveredColumn(movingColumns, mouseX) {
        const { gos, colModel } = this.beans;
        const isRtl = gos.get('enableRtl');
        const consideredColumns = colModel
            .getCols()
            .filter((col) => col.isVisible() && col.getPinned() === this.pinned);
        let start = null;
        let width = null;
        let targetColumn = null;
        for (const col of consideredColumns) {
            width = col.getActualWidth();
            start = this.getNormalisedColumnLeft(col, 0, isRtl);
            if (start != null) {
                const end = start + width;
                if (start <= mouseX && end >= mouseX) {
                    targetColumn = col;
                    break;
                }
            }
            start = null;
            width = null;
        }
        if (!targetColumn) {
            // we fall into this condition if no columns are being hover
            // (e.g. hovering an empty area of the column header beyond all columns)
            for (let i = consideredColumns.length - 1; i >= 0; i--) {
                const currentColumn = consideredColumns[i];
                const parent = consideredColumns[i].getParent();
                if (!parent) {
                    targetColumn = currentColumn;
                    break;
                }
                const leafDisplayedCols = parent?.getDisplayedLeafColumns();
                if (leafDisplayedCols.length) {
                    targetColumn = (0, array_1._last)(leafDisplayedCols);
                    break;
                }
            }
            if (!targetColumn) {
                return;
            }
            start = this.getNormalisedColumnLeft(targetColumn, 0, isRtl);
            width = targetColumn.getActualWidth();
        }
        else if (movingColumns.indexOf(targetColumn) !== -1) {
            targetColumn = null;
        }
        if (this.lastHighlightedColumn?.column !== targetColumn) {
            this.clearHighlighted();
        }
        if (targetColumn == null || start == null || width == null) {
            return;
        }
        let position;
        if (mouseX - start < width / 2 !== isRtl) {
            position = iColumn_1.ColumnHighlightPosition.Before;
        }
        else {
            position = iColumn_1.ColumnHighlightPosition.After;
        }
        setColumnHighlighted(targetColumn, position);
        this.lastHighlightedColumn = { column: targetColumn, position };
    }
    getNormalisedXPositionInfo(allMovingColumns, isAttemptingToPin) {
        const { gos, visibleCols } = this.beans;
        const isRtl = gos.get('enableRtl');
        const { firstMovingCol, column, position } = this.getColumnMoveAndTargetInfo(allMovingColumns, isAttemptingToPin, isRtl);
        if (!firstMovingCol || !column || position == null) {
            return;
        }
        const visibleColumns = visibleCols.allCols;
        const movingColIndex = visibleColumns.indexOf(firstMovingCol);
        const targetIndex = visibleColumns.indexOf(column);
        const isBefore = (position === iColumn_1.ColumnHighlightPosition.Before) !== isRtl;
        const fromLeft = movingColIndex < targetIndex || (movingColIndex === targetIndex && !isBefore);
        let diff = 0;
        if (isBefore) {
            if (fromLeft) {
                diff -= 1;
            }
        }
        else {
            if (!fromLeft) {
                diff += 1;
            }
        }
        if (targetIndex + diff === movingColIndex) {
            return;
        }
        const targetColumn = visibleColumns[targetIndex + diff];
        if (!targetColumn) {
            return;
        }
        const xPosition = this.getNormalisedColumnLeft(targetColumn, 20, isRtl);
        return { fromLeft, xPosition };
    }
    getColumnMoveAndTargetInfo(allMovingColumns, isAttemptingToPin, isRtl) {
        const lastHighlightedColumn = this.lastHighlightedColumn || {};
        const { firstMovingCol, lastMovingCol } = findFirstAndLastMovingColumns(allMovingColumns);
        if (!firstMovingCol || !lastMovingCol || lastHighlightedColumn.column || !isAttemptingToPin) {
            return {
                firstMovingCol,
                ...lastHighlightedColumn,
            };
        }
        const pinned = this.getPinDirection();
        const isLeft = pinned === 'left';
        return {
            firstMovingCol,
            position: isLeft ? iColumn_1.ColumnHighlightPosition.After : iColumn_1.ColumnHighlightPosition.Before,
            column: isLeft !== isRtl ? firstMovingCol : lastMovingCol,
        };
    }
    normaliseDirection(hDirection) {
        if (this.gos.get('enableRtl')) {
            switch (hDirection) {
                case 'left':
                    return 'right';
                case 'right':
                    return 'left';
            }
        }
        return hDirection;
    }
    getNormalisedColumnLeft(col, padding, isRtl) {
        const { gos, ctrlsSvc } = this.beans;
        const left = col.getLeft();
        if (left == null) {
            return null;
        }
        const width = col.getActualWidth();
        return (0, internalColumnMoveUtils_1.normaliseX)({
            x: isRtl ? left + width - padding : left + padding,
            pinned: col.getPinned(),
            useHeaderRow: isRtl,
            skipScrollPadding: true,
            gos,
            ctrlsSvc,
        });
    }
    isAttemptingToPin(columns) {
        const isMovingHorizontally = this.needToMoveLeft || this.needToMoveRight;
        const isFailedMoreThanThreshold = this.failedMoveAttempts > MOVE_FAIL_THRESHOLD;
        return ((isMovingHorizontally && isFailedMoreThanThreshold) ||
            columns.some((col) => col.getPinned() !== this.pinned));
    }
    moveColumnsAfterHighlight(params) {
        const { allMovingColumns, xPosition, fromEnter, fakeEvent, fromLeft } = params;
        const columnMoveParams = this.getMoveColumnParams({
            allMovingColumns,
            isFromHeader: true,
            xPosition,
            fromLeft,
            fromEnter,
            fakeEvent,
        });
        const { columns, toIndex } = (0, internalColumnMoveUtils_1.getBestColumnMoveIndexFromXPosition)(columnMoveParams) || {};
        if (columns && toIndex != null) {
            this.lastMovedInfo = {
                columns,
                toIndex,
            };
        }
        this.finishColumnMoving();
    }
    clearHighlighted() {
        const { lastHighlightedColumn } = this;
        if (!lastHighlightedColumn) {
            return;
        }
        setColumnHighlighted(lastHighlightedColumn.column, null);
        this.lastHighlightedColumn = null;
    }
    checkCenterForScrolling(xAdjustedForScroll) {
        if (!this.isCenterContainer) {
            return;
        }
        // scroll if the mouse has gone outside the grid (or just outside the scrollable part if pinning)
        // putting in 50 buffer, so even if user gets to edge of grid, a scroll will happen
        const centerCtrl = this.beans.ctrlsSvc.get('center');
        const firstVisiblePixel = centerCtrl.getCenterViewportScrollLeft();
        const lastVisiblePixel = firstVisiblePixel + centerCtrl.getCenterWidth();
        let needToMoveRight;
        let needToMoveLeft;
        if (this.gos.get('enableRtl')) {
            needToMoveRight = xAdjustedForScroll < firstVisiblePixel + SCROLL_GAP_NEEDED_BEFORE_MOVE;
            needToMoveLeft = xAdjustedForScroll > lastVisiblePixel - SCROLL_GAP_NEEDED_BEFORE_MOVE;
        }
        else {
            needToMoveLeft = xAdjustedForScroll < firstVisiblePixel + SCROLL_GAP_NEEDED_BEFORE_MOVE;
            needToMoveRight = xAdjustedForScroll > lastVisiblePixel - SCROLL_GAP_NEEDED_BEFORE_MOVE;
        }
        this.needToMoveRight = needToMoveRight;
        this.needToMoveLeft = needToMoveLeft;
        if (needToMoveLeft || needToMoveRight) {
            this.ensureIntervalStarted();
        }
        else {
            this.ensureIntervalCleared();
        }
    }
    ensureIntervalStarted() {
        if (this.movingIntervalId) {
            return;
        }
        this.intervalCount = 0;
        this.failedMoveAttempts = 0;
        this.movingIntervalId = window.setInterval(this.moveInterval.bind(this), SCROLL_TIME_INTERVAL);
        this.beans.dragAndDrop.getDragAndDropImageComponent()?.setIcon(this.needToMoveLeft ? 'left' : 'right', true);
    }
    ensureIntervalCleared() {
        if (!this.movingIntervalId) {
            return;
        }
        window.clearInterval(this.movingIntervalId);
        this.movingIntervalId = null;
        this.failedMoveAttempts = 0;
        this.beans.dragAndDrop.getDragAndDropImageComponent()?.setIcon(this.getIconName(), false);
    }
    moveInterval() {
        // the amounts we move get bigger at each interval, so the speed accelerates, starting a bit slow
        // and getting faster. this is to give smoother user experience. we max at `SCROLL_MOVE_WIDTH` to limit the speed.
        let pixelsToMove;
        this.intervalCount++;
        pixelsToMove = 10 + this.intervalCount * SCROLL_ACCELERATION_RATE;
        if (pixelsToMove > SCROLL_MOVE_WIDTH) {
            pixelsToMove = SCROLL_MOVE_WIDTH;
        }
        let pixelsMoved = null;
        const scrollFeature = this.gridBodyCon.scrollFeature;
        if (this.needToMoveLeft) {
            pixelsMoved = scrollFeature.scrollHorizontally(-pixelsToMove);
        }
        else if (this.needToMoveRight) {
            pixelsMoved = scrollFeature.scrollHorizontally(pixelsToMove);
        }
        if (pixelsMoved !== 0) {
            this.onDragging(this.lastDraggingEvent);
            this.failedMoveAttempts = 0;
        }
        else {
            // we count the failed move attempts. if we fail to move `MOVE_FAIL_THRESHOLD` times, then we pin the column.
            // this is how we achieve pining by dragging the column to the edge of the grid.
            this.failedMoveAttempts++;
            const { pinnedCols, dragAndDrop, gos } = this.beans;
            if (this.failedMoveAttempts <= MOVE_FAIL_THRESHOLD + 1 || !pinnedCols) {
                return;
            }
            dragAndDrop.getDragAndDropImageComponent()?.setIcon('pinned', false);
            if (!gos.get('suppressMoveWhenColumnDragging')) {
                const columns = this.lastDraggingEvent?.dragItem.columns;
                this.attemptToPinColumns(columns, undefined, true);
            }
        }
    }
    getPinDirection() {
        if (this.needToMoveLeft || this.pinned === 'left') {
            return 'left';
        }
        if (this.needToMoveRight || this.pinned === 'right') {
            return 'right';
        }
    }
    attemptToPinColumns(columns, pinned, fromMoving = false) {
        const allowedCols = (columns || []).filter((c) => !c.getColDef().lockPinned);
        if (!allowedCols.length) {
            return 0;
        }
        if (fromMoving) {
            pinned = this.getPinDirection();
        }
        const { pinnedCols, dragAndDrop } = this.beans;
        pinnedCols?.setColsPinned(allowedCols, pinned, 'uiColumnDragged');
        if (fromMoving) {
            dragAndDrop.nudge();
        }
        return allowedCols.length;
    }
    destroy() {
        super.destroy();
        this.lastDraggingEvent = null;
        this.clearHighlighted();
        this.lastMovedInfo = null;
    }
}
exports.MoveColumnFeature = MoveColumnFeature;
function setColumnHighlighted(column, highlighted) {
    if (column.highlighted === highlighted) {
        return;
    }
    column.highlighted = highlighted;
    column.dispatchColEvent('headerHighlightChanged', 'uiColumnMoved');
}
function findFirstAndLastMovingColumns(allMovingColumns) {
    const moveLen = allMovingColumns.length;
    let firstMovingCol;
    let lastMovingCol;
    for (let i = 0; i < moveLen; i++) {
        if (!firstMovingCol) {
            const leftCol = allMovingColumns[i];
            if (leftCol.getLeft() != null) {
                firstMovingCol = leftCol;
            }
        }
        if (!lastMovingCol) {
            const rightCol = allMovingColumns[moveLen - 1 - i];
            if (rightCol.getLeft() != null) {
                lastMovingCol = rightCol;
            }
        }
        if (firstMovingCol && lastMovingCol) {
            break;
        }
    }
    return { firstMovingCol, lastMovingCol };
}


/***/ }),

/***/ 852:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.moveColumns = exports.moveColumnByIndex = void 0;
function moveColumnByIndex(beans, fromIndex, toIndex) {
    beans.colMoves?.moveColumnByIndex(fromIndex, toIndex, 'api');
}
exports.moveColumnByIndex = moveColumnByIndex;
function moveColumns(beans, columnsToMoveKeys, toIndex) {
    beans.colMoves?.moveColumns(columnsToMoveKeys, toIndex, 'api');
}
exports.moveColumns = moveColumns;


/***/ }),

/***/ 4074:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnMoveModule = void 0;
const dragModule_1 = __webpack_require__(4388);
const version_1 = __webpack_require__(7205);
const column_moving_css_GENERATED_1 = __webpack_require__(9607);
const columnAnimationService_1 = __webpack_require__(9122);
const columnMoveApi_1 = __webpack_require__(852);
const columnMoveService_1 = __webpack_require__(4067);
/**
 * @feature Columns -> Column Moving
 */
exports.ColumnMoveModule = {
    moduleName: 'ColumnMove',
    version: version_1.VERSION,
    beans: [columnMoveService_1.ColumnMoveService, columnAnimationService_1.ColumnAnimationService],
    apiFunctions: {
        moveColumnByIndex: columnMoveApi_1.moveColumnByIndex,
        moveColumns: columnMoveApi_1.moveColumns,
    },
    dependsOn: [dragModule_1.SharedDragAndDropModule],
    css: [column_moving_css_GENERATED_1.columnMovingCSS],
};


/***/ }),

/***/ 4067:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnMoveService = void 0;
const beanStub_1 = __webpack_require__(8731);
const dragAndDropService_1 = __webpack_require__(2903);
const agColumnGroup_1 = __webpack_require__(6908);
const array_1 = __webpack_require__(1502);
const logging_1 = __webpack_require__(7764);
const bodyDropTarget_1 = __webpack_require__(7912);
const columnMoveUtils_1 = __webpack_require__(3505);
const internalColumnMoveUtils_1 = __webpack_require__(5446);
var MoveDirection;
(function (MoveDirection) {
    MoveDirection[MoveDirection["LEFT"] = -1] = "LEFT";
    MoveDirection[MoveDirection["NONE"] = 0] = "NONE";
    MoveDirection[MoveDirection["RIGHT"] = 1] = "RIGHT";
})(MoveDirection || (MoveDirection = {}));
class ColumnMoveService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colMoves';
    }
    moveColumnByIndex(fromIndex, toIndex, source) {
        const gridColumns = this.beans.colModel.getCols();
        if (!gridColumns) {
            return;
        }
        const column = gridColumns[fromIndex];
        this.moveColumns([column], toIndex, source);
    }
    moveColumns(columnsToMoveKeys, toIndex, source, finished = true) {
        const { colModel, colAnimation, visibleCols, eventSvc } = this.beans;
        const gridColumns = colModel.getCols();
        if (!gridColumns) {
            return;
        }
        if (toIndex > gridColumns.length - columnsToMoveKeys.length) {
            // Trying to insert in invalid position
            (0, logging_1._warn)(30, { toIndex });
            return;
        }
        colAnimation?.start();
        // we want to pull all the columns out first and put them into an ordered list
        const movedColumns = colModel.getColsForKeys(columnsToMoveKeys);
        if (this.doesMovePassRules(movedColumns, toIndex)) {
            (0, array_1._moveInArray)(colModel.getCols(), movedColumns, toIndex);
            visibleCols.refresh(source);
            eventSvc.dispatchEvent({
                type: 'columnMoved',
                columns: movedColumns,
                column: movedColumns.length === 1 ? movedColumns[0] : null,
                toIndex,
                finished,
                source,
            });
        }
        colAnimation?.finish();
    }
    doesMovePassRules(columnsToMove, toIndex) {
        // make a copy of what the grid columns would look like after the move
        const proposedColumnOrder = this.getProposedColumnOrder(columnsToMove, toIndex);
        return this.doesOrderPassRules(proposedColumnOrder);
    }
    doesOrderPassRules(gridOrder) {
        const { colModel, gos } = this.beans;
        if (!(0, columnMoveUtils_1.doesMovePassMarryChildren)(gridOrder, colModel.getColTree())) {
            return false;
        }
        const doesMovePassLockedPositions = (proposedColumnOrder) => {
            const lockPositionToPlacement = (position) => {
                if (!position) {
                    return MoveDirection.NONE;
                }
                return position === 'left' || position === true ? MoveDirection.LEFT : MoveDirection.RIGHT;
            };
            const isRtl = gos.get('enableRtl');
            let lastPlacement = isRtl ? MoveDirection.RIGHT : MoveDirection.LEFT;
            let rulePassed = true;
            proposedColumnOrder.forEach((col) => {
                const placement = lockPositionToPlacement(col.getColDef().lockPosition);
                if (isRtl) {
                    if (placement > lastPlacement) {
                        // If placement goes up, we're not in the correct order
                        rulePassed = false;
                    }
                }
                else {
                    if (placement < lastPlacement) {
                        // If placement goes down, we're not in the correct order
                        rulePassed = false;
                    }
                }
                lastPlacement = placement;
            });
            return rulePassed;
        };
        if (!doesMovePassLockedPositions(gridOrder)) {
            return false;
        }
        return true;
    }
    getProposedColumnOrder(columnsToMove, toIndex) {
        const gridColumns = this.beans.colModel.getCols();
        const proposedColumnOrder = gridColumns.slice();
        (0, array_1._moveInArray)(proposedColumnOrder, columnsToMove, toIndex);
        return proposedColumnOrder;
    }
    createBodyDropTarget(pinned, dropContainer) {
        return new bodyDropTarget_1.BodyDropTarget(pinned, dropContainer);
    }
    moveHeader(hDirection, eGui, column, pinned, bean) {
        const { ctrlsSvc, gos, colModel, visibleCols, focusSvc } = this.beans;
        const rect = eGui.getBoundingClientRect();
        const left = rect.left;
        const isGroup = (0, agColumnGroup_1.isColumnGroup)(column);
        const width = isGroup ? rect.width : column.getActualWidth();
        const isLeft = (hDirection === 'left') !== gos.get('enableRtl');
        const xPosition = (0, internalColumnMoveUtils_1.normaliseX)({
            x: isLeft ? left - 20 : left + width + 20,
            pinned,
            fromKeyboard: true,
            gos,
            ctrlsSvc,
        });
        const headerPosition = focusSvc.focusedHeader;
        (0, internalColumnMoveUtils_1.attemptMoveColumns)({
            allMovingColumns: isGroup ? column.getLeafColumns() : [column],
            isFromHeader: true,
            fromLeft: hDirection === 'right',
            xPosition,
            pinned,
            fromEnter: false,
            fakeEvent: false,
            gos,
            colModel,
            colMoves: this,
            visibleCols,
            finished: true,
        });
        let targetColumn;
        if (isGroup) {
            const displayedLeafColumns = column.getDisplayedLeafColumns();
            targetColumn = isLeft ? displayedLeafColumns[0] : (0, array_1._last)(displayedLeafColumns);
        }
        else {
            targetColumn = column;
        }
        ctrlsSvc.getScrollFeature().ensureColumnVisible(targetColumn, 'auto');
        if ((!bean.isAlive() || gos.get('ensureDomOrder')) && headerPosition) {
            let restoreFocusColumn;
            if (isGroup) {
                const groupId = column.getGroupId();
                const leafCols = column.getLeafColumns();
                if (!leafCols.length) {
                    return;
                }
                const parent = leafCols[0].getParent();
                if (!parent) {
                    return;
                }
                restoreFocusColumn = findGroupWidthId(parent, groupId);
            }
            else {
                restoreFocusColumn = column;
            }
            if (restoreFocusColumn) {
                focusSvc.focusHeaderPosition({
                    headerPosition: {
                        ...headerPosition,
                        column: restoreFocusColumn,
                    },
                });
            }
        }
    }
    setDragSourceForHeader(eSource, column, displayName) {
        const { gos, colModel, dragAndDrop, visibleCols } = this.beans;
        let hideColumnOnExit = !gos.get('suppressDragLeaveHidesColumns');
        const isGroup = (0, agColumnGroup_1.isColumnGroup)(column);
        const columns = isGroup ? column.getProvidedColumnGroup().getLeafColumns() : [column];
        const getDragItem = isGroup
            ? () => createDragItemForGroup(column, visibleCols.allCols)
            : () => createDragItem(column);
        const dragSource = {
            type: dragAndDropService_1.DragSourceType.HeaderCell,
            eElement: eSource,
            getDefaultIconName: () => (hideColumnOnExit ? 'hide' : 'notAllowed'),
            getDragItem,
            dragItemName: displayName,
            onDragStarted: () => {
                hideColumnOnExit = !gos.get('suppressDragLeaveHidesColumns');
                (0, internalColumnMoveUtils_1.setColumnsMoving)(columns, true);
            },
            onDragStopped: () => (0, internalColumnMoveUtils_1.setColumnsMoving)(columns, false),
            onDragCancelled: () => (0, internalColumnMoveUtils_1.setColumnsMoving)(columns, false),
            onGridEnter: (dragItem) => {
                if (hideColumnOnExit) {
                    const { columns = [], visibleState } = dragItem ?? {};
                    const hasVisibleState = isGroup
                        ? (col) => !visibleState || visibleState[col.getColId()]
                        : () => true;
                    const unlockedColumns = columns.filter((col) => !col.getColDef().lockVisible && hasVisibleState(col));
                    colModel.setColsVisible(unlockedColumns, true, 'uiColumnMoved');
                }
            },
            onGridExit: (dragItem) => {
                if (hideColumnOnExit) {
                    const unlockedColumns = dragItem?.columns?.filter((col) => !col.getColDef().lockVisible) || [];
                    colModel.setColsVisible(unlockedColumns, false, 'uiColumnMoved');
                }
            },
        };
        dragAndDrop.addDragSource(dragSource, true);
        return dragSource;
    }
}
exports.ColumnMoveService = ColumnMoveService;
function findGroupWidthId(columnGroup, id) {
    while (columnGroup) {
        if (columnGroup.getGroupId() === id) {
            return columnGroup;
        }
        columnGroup = columnGroup.getParent();
    }
    return undefined;
}
function createDragItem(column) {
    const visibleState = {};
    visibleState[column.getId()] = column.isVisible();
    return {
        columns: [column],
        visibleState: visibleState,
        containerType: column.pinned,
    };
}
// when moving the columns, we want to move all the columns (contained within the DragItem) in this group in one go,
// and in the order they are currently in the screen.
function createDragItemForGroup(columnGroup, allCols) {
    const allColumnsOriginalOrder = columnGroup.getProvidedColumnGroup().getLeafColumns();
    // capture visible state, used when re-entering grid to dictate which columns should be visible
    const visibleState = {};
    allColumnsOriginalOrder.forEach((column) => (visibleState[column.getId()] = column.isVisible()));
    const allColumnsCurrentOrder = [];
    allCols.forEach((column) => {
        if (allColumnsOriginalOrder.indexOf(column) >= 0) {
            allColumnsCurrentOrder.push(column);
            (0, array_1._removeFromArray)(allColumnsOriginalOrder, column);
        }
    });
    // we are left with non-visible columns, stick these in at the end
    allColumnsOriginalOrder.forEach((column) => allColumnsCurrentOrder.push(column));
    const columnsInSplit = [];
    const columnGroupColumns = columnGroup.getLeafColumns();
    for (const col of allColumnsCurrentOrder) {
        if (columnGroupColumns.indexOf(col) !== -1) {
            columnsInSplit.push(col);
        }
    }
    // create and return dragItem
    return {
        columns: allColumnsCurrentOrder,
        columnsInSplit,
        visibleState: visibleState,
        containerType: columnsInSplit[0]?.pinned,
    };
}


/***/ }),

/***/ 3505:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.doesMovePassMarryChildren = exports.placeLockedColumns = void 0;
const columnFactoryUtils_1 = __webpack_require__(2716);
const agProvidedColumnGroup_1 = __webpack_require__(9409);
function placeLockedColumns(cols, gos) {
    const left = [];
    const normal = [];
    const right = [];
    cols.forEach((col) => {
        const position = col.getColDef().lockPosition;
        if (position === 'right') {
            right.push(col);
        }
        else if (position === 'left' || position === true) {
            left.push(col);
        }
        else {
            normal.push(col);
        }
    });
    const isRtl = gos.get('enableRtl');
    if (isRtl) {
        return [...right, ...normal, ...left];
    }
    return [...left, ...normal, ...right];
}
exports.placeLockedColumns = placeLockedColumns;
function doesMovePassMarryChildren(allColumnsCopy, gridBalancedTree) {
    let rulePassed = true;
    (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, gridBalancedTree, (child) => {
        if (!(0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
            return;
        }
        const columnGroup = child;
        const colGroupDef = columnGroup.getColGroupDef();
        const marryChildren = colGroupDef && colGroupDef.marryChildren;
        if (!marryChildren) {
            return;
        }
        const newIndexes = [];
        columnGroup.getLeafColumns().forEach((col) => {
            const newColIndex = allColumnsCopy.indexOf(col);
            newIndexes.push(newColIndex);
        });
        // eslint-disable-next-line prefer-spread
        const maxIndex = Math.max.apply(Math, newIndexes);
        // eslint-disable-next-line prefer-spread
        const minIndex = Math.min.apply(Math, newIndexes);
        // spread is how far the first column in this group is away from the last column
        const spread = maxIndex - minIndex;
        const maxSpread = columnGroup.getLeafColumns().length - 1;
        // if the columns
        if (spread > maxSpread) {
            rulePassed = false;
        }
        // console.log(`maxIndex = ${maxIndex}, minIndex = ${minIndex}, spread = ${spread}, maxSpread = ${maxSpread}, fail = ${spread > (count-1)}`)
        // console.log(allColumnsCopy.map( col => col.getColDef().field).join(','));
    });
    return rulePassed;
}
exports.doesMovePassMarryChildren = doesMovePassMarryChildren;


/***/ }),

/***/ 5446:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.setColumnsMoving = exports.normaliseX = exports.attemptMoveColumns = exports.getBestColumnMoveIndexFromXPosition = void 0;
const array_1 = __webpack_require__(1502);
// returns the provided cols sorted in same order as they appear in this.cols, eg if this.cols
// contains [a,b,c,d,e] and col passed is [e,a] then the passed cols are sorted into [a,e]
function sortColsLikeCols(colsList, cols) {
    if (!cols || cols.length <= 1) {
        return;
    }
    const notAllColsPresent = cols.filter((c) => colsList.indexOf(c) < 0).length > 0;
    if (notAllColsPresent) {
        return;
    }
    cols.sort((a, b) => {
        const indexA = colsList.indexOf(a);
        const indexB = colsList.indexOf(b);
        return indexA - indexB;
    });
}
function getBestColumnMoveIndexFromXPosition(params) {
    const { isFromHeader, fromLeft, xPosition, fromEnter, fakeEvent, pinned, gos, colModel, colMoves, visibleCols } = params;
    let { allMovingColumns } = params;
    if (isFromHeader) {
        // If the columns we're dragging are the only visible columns of their group, move the hidden ones too
        const newCols = [];
        allMovingColumns.forEach((col) => {
            let movingGroup = null;
            let parent = col.getParent();
            while (parent != null && parent.getDisplayedLeafColumns().length === 1) {
                movingGroup = parent;
                parent = parent.getParent();
            }
            if (movingGroup != null) {
                const isMarryChildren = !!movingGroup.getColGroupDef()?.marryChildren;
                const columnsToMove = isMarryChildren
                    ? // when marry children is true, we also have to move hidden
                        // columns within the group, so grab them from the `providedColumnGroup`
                        movingGroup.getProvidedColumnGroup().getLeafColumns()
                    : movingGroup.getLeafColumns();
                columnsToMove.forEach((newCol) => {
                    if (!newCols.includes(newCol)) {
                        newCols.push(newCol);
                    }
                });
            }
            else if (!newCols.includes(col)) {
                newCols.push(col);
            }
        });
        allMovingColumns = newCols;
    }
    // it is important to sort the moving columns as they are in grid columns, as the list of moving columns
    // could themselves be part of 'married children' groups, which means we need to maintain the order within
    // the moving list.
    const allMovingColumnsOrdered = allMovingColumns.slice();
    sortColsLikeCols(colModel.getCols(), allMovingColumnsOrdered);
    const validMoves = calculateValidMoves({
        movingCols: allMovingColumnsOrdered,
        draggingRight: fromLeft,
        xPosition,
        pinned,
        gos,
        colModel,
        visibleCols,
    });
    // if cols are not adjacent, then this returns null. when moving, we constrain the direction of the move
    // (ie left or right) to the mouse direction. however
    const oldIndex = calculateOldIndex(allMovingColumnsOrdered, colModel);
    if (validMoves.length === 0) {
        return;
    }
    const firstValidMove = validMoves[0];
    // the two check below stop an error when the user grabs a group my a middle column, then
    // it is possible the mouse pointer is to the right of a column while been dragged left.
    // so we need to make sure that the mouse pointer is actually left of the left most column
    // if moving left, and right of the right most column if moving right
    // we check 'fromEnter' below so we move the column to the new spot if the mouse is coming from
    // outside the grid, eg if the column is moving from side panel, mouse is moving left, then we should
    // place the column to the RHS even if the mouse is moving left and the column is already on
    // the LHS. otherwise we stick to the rule described above.
    let constrainDirection = oldIndex !== null && !fromEnter;
    // don't consider 'fromEnter' when dragging header cells, otherwise group can jump to opposite direction of drag
    if (isFromHeader) {
        constrainDirection = oldIndex !== null;
    }
    // if the event was faked by a change in column pin state, then the original location of the column
    // is not reliable for dictating where the column may now be placed.
    if (constrainDirection && !fakeEvent) {
        // only allow left drag if this column is moving left
        if (!fromLeft && firstValidMove >= oldIndex) {
            return;
        }
        // only allow right drag if this column is moving right
        if (fromLeft && firstValidMove <= oldIndex) {
            return;
        }
    }
    // From when we find a move that passes all the rules
    // Remember what that move would look like in terms of displayed cols
    // keep going with further moves until we find a different result in displayed output
    // In this way potentialMoves contains all potential moves over 'hidden' columns
    const displayedCols = visibleCols.allCols;
    const potentialMoves = [];
    let targetOrder = null;
    for (let i = 0; i < validMoves.length; i++) {
        const move = validMoves[i];
        const order = colMoves.getProposedColumnOrder(allMovingColumnsOrdered, move);
        if (!colMoves.doesOrderPassRules(order)) {
            continue;
        }
        const displayedOrder = order.filter((col) => displayedCols.includes(col));
        if (targetOrder === null) {
            targetOrder = displayedOrder;
        }
        else if (!(0, array_1._areEqual)(displayedOrder, targetOrder)) {
            break; // Stop looking for potential moves if the displayed result changes from the target
        }
        const fragCount = groupFragCount(order);
        potentialMoves.push({ move, fragCount });
    }
    if (potentialMoves.length === 0) {
        return;
    }
    // The best move is the move with least group fragmentation
    potentialMoves.sort((a, b) => a.fragCount - b.fragCount);
    const toIndex = potentialMoves[0].move;
    if (toIndex > colModel.getCols().length - allMovingColumns.length) {
        return;
    }
    return { columns: allMovingColumns, toIndex };
}
exports.getBestColumnMoveIndexFromXPosition = getBestColumnMoveIndexFromXPosition;
function attemptMoveColumns(params) {
    const { columns, toIndex } = getBestColumnMoveIndexFromXPosition(params) || {};
    const { finished, colMoves } = params;
    if (!columns || toIndex == null) {
        return null;
    }
    colMoves.moveColumns(columns, toIndex, 'uiColumnMoved', finished);
    return finished ? null : { columns, toIndex };
}
exports.attemptMoveColumns = attemptMoveColumns;
// returns the index of the first column in the list ONLY if the cols are all beside
// each other. if the cols are not beside each other, then returns null
function calculateOldIndex(movingCols, colModel) {
    const gridCols = colModel.getCols();
    const indexes = movingCols.map((col) => gridCols.indexOf(col)).sort((a, b) => a - b);
    const firstIndex = indexes[0];
    const lastIndex = (0, array_1._last)(indexes);
    const spread = lastIndex - firstIndex;
    const gapsExist = spread !== indexes.length - 1;
    return gapsExist ? null : firstIndex;
}
// A measure of how fragmented in terms of groups an order of columns is
function groupFragCount(columns) {
    function parents(col) {
        const result = [];
        let parent = col.getOriginalParent();
        while (parent != null) {
            result.push(parent);
            parent = parent.getOriginalParent();
        }
        return result;
    }
    let count = 0;
    for (let i = 0; i < columns.length - 1; i++) {
        let a = parents(columns[i]);
        let b = parents(columns[i + 1]);
        // iterate over the longest one
        [a, b] = a.length > b.length ? [a, b] : [b, a];
        a.forEach((parent) => {
            if (b.indexOf(parent) === -1) {
                count++; // More fragmented if other column doesn't share the parent
            }
        });
    }
    return count;
}
function getDisplayedColumns(visibleCols, type) {
    switch (type) {
        case 'left':
            return visibleCols.leftCols;
        case 'right':
            return visibleCols.rightCols;
        default:
            return visibleCols.centerCols;
    }
}
function calculateValidMoves(params) {
    const { movingCols, draggingRight, xPosition, pinned, gos, colModel, visibleCols } = params;
    const isMoveBlocked = gos.get('suppressMovableColumns') || movingCols.some((col) => col.getColDef().suppressMovable);
    if (isMoveBlocked) {
        return [];
    }
    // this is the list of cols on the screen, so it's these we use when comparing the x mouse position
    const allDisplayedCols = getDisplayedColumns(visibleCols, pinned);
    // but this list is the list of all cols, when we move a col it's the index within this list that gets used,
    // so the result we return has to be and index location for this list
    const allGridCols = colModel.getCols();
    const movingDisplayedCols = allDisplayedCols.filter((col) => movingCols.includes(col));
    const otherDisplayedCols = allDisplayedCols.filter((col) => !movingCols.includes(col));
    const otherGridCols = allGridCols.filter((col) => !movingCols.includes(col));
    // work out how many DISPLAYED columns fit before the 'x' position. this gives us the displayIndex.
    // for example, if cols are a,b,c,d and we find a,b fit before 'x', then we want to place the moving
    // col between b and c (so that it is under the mouse position).
    let displayIndex = 0;
    let availableWidth = xPosition;
    // if we are dragging right, then the columns will be to the left of the mouse, so we also want to
    // include the width of the moving columns
    if (draggingRight) {
        let widthOfMovingDisplayedCols = 0;
        movingDisplayedCols.forEach((col) => (widthOfMovingDisplayedCols += col.getActualWidth()));
        availableWidth -= widthOfMovingDisplayedCols;
    }
    if (availableWidth > 0) {
        // now count how many of the displayed columns will fit to the left
        for (let i = 0; i < otherDisplayedCols.length; i++) {
            const col = otherDisplayedCols[i];
            availableWidth -= col.getActualWidth();
            if (availableWidth < 0) {
                break;
            }
            displayIndex++;
        }
        // trial and error, if going right, we adjust by one, i didn't manage to quantify why, but it works
        if (draggingRight) {
            displayIndex++;
        }
    }
    // the display index is with respect to all the showing columns, however when we move, it's with
    // respect to all grid columns, so we need to translate from display index to grid index
    let firstValidMove;
    if (displayIndex > 0) {
        const leftColumn = otherDisplayedCols[displayIndex - 1];
        firstValidMove = otherGridCols.indexOf(leftColumn) + 1;
    }
    else {
        firstValidMove = otherGridCols.indexOf(otherDisplayedCols[0]);
        if (firstValidMove === -1) {
            firstValidMove = 0;
        }
    }
    const validMoves = [firstValidMove];
    const numberComparator = (a, b) => a - b;
    // add in other valid moves due to hidden columns and married children. for example, a particular
    // move might break a group that has married children (so move isn't valid), however there could
    // be hidden columns (not displayed) that we could jump over to make the move valid. because
    // they are hidden, user doesn't see any different, however it allows moves that would otherwise
    // not work. for example imagine a group with 9 columns and all columns are hidden except the
    // middle one (so 4 hidden to left, 4 hidden to right), then when moving 'firstValidMove' will
    // be relative to the not-shown column, however we need to consider the move jumping over all the
    // hidden children. if we didn't do this, then if the group just described was at the end (RHS) of the
    // grid, there would be no way to put a column after it (as the grid would only consider beside the
    // visible column, which would fail valid move rules).
    if (draggingRight) {
        // if dragging right, then we add all the additional moves to the right. so in other words
        // if the next move is not valid, find the next move to the right that is valid.
        let pointer = firstValidMove + 1;
        const lastIndex = allGridCols.length - 1;
        while (pointer <= lastIndex) {
            validMoves.push(pointer);
            pointer++;
        }
        // adding columns here means the order is now messed up
        validMoves.sort(numberComparator);
    }
    else {
        // if dragging left we do the reverse of dragging right, we add in all the valid moves to the
        // left. however we also have to consider moves to the right for all hidden columns first.
        // (this logic is hard to reason with, it was worked out with trial and error,
        // more observation rather than science).
        // add moves to the right
        let pointer = firstValidMove;
        const lastIndex = allGridCols.length - 1;
        let displacedCol = allGridCols[pointer];
        // takes into account visible=false and group=closed, ie it is not displayed
        while (pointer <= lastIndex && allDisplayedCols.indexOf(displacedCol) < 0) {
            pointer++;
            validMoves.push(pointer);
            displacedCol = allGridCols[pointer];
        }
        // add moves to the left
        pointer = firstValidMove - 1;
        const firstDisplayIndex = 0;
        while (pointer >= firstDisplayIndex) {
            validMoves.push(pointer);
            pointer--;
        }
        // adding columns here means the order is now messed up
        validMoves.sort(numberComparator).reverse();
    }
    return validMoves;
}
function normaliseX(params) {
    const { pinned, fromKeyboard, gos, ctrlsSvc, useHeaderRow, skipScrollPadding } = params;
    let eViewport = ctrlsSvc.getHeaderRowContainerCtrl(pinned)?.eViewport;
    let { x } = params;
    if (!eViewport) {
        return 0;
    }
    if (fromKeyboard) {
        x -= eViewport.getBoundingClientRect().left;
    }
    // flip the coordinate if doing RTL
    if (gos.get('enableRtl')) {
        if (useHeaderRow) {
            eViewport = eViewport.querySelector('.ag-header-row');
        }
        x = eViewport.clientWidth - x;
    }
    // adjust for scroll only if centre container (the pinned containers don't scroll)
    if (pinned == null && !skipScrollPadding) {
        x += ctrlsSvc.get('center').getCenterViewportScrollLeft();
    }
    return x;
}
exports.normaliseX = normaliseX;
function setColumnsMoving(columns, isMoving) {
    for (const column of columns) {
        column.moving = isMoving;
        column.dispatchColEvent('movingChanged', 'uiColumnMoved');
    }
}
exports.setColumnsMoving = setColumnsMoving;


/***/ }),

/***/ 9686:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.setColumnWidths = void 0;
function setColumnWidths(beans, columnWidths, finished = true, source = 'api') {
    beans.colResize?.setColumnWidths(columnWidths, false, finished, source);
}
exports.setColumnWidths = setColumnWidths;


/***/ }),

/***/ 6924:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnResizeModule = void 0;
const dragModule_1 = __webpack_require__(4388);
const autoWidthModule_1 = __webpack_require__(447);
const version_1 = __webpack_require__(7205);
const columnResizeApi_1 = __webpack_require__(9686);
const columnResizeService_1 = __webpack_require__(9677);
/**
 * @feature Columns -> Column Sizing
 */
exports.ColumnResizeModule = {
    moduleName: 'ColumnResize',
    version: version_1.VERSION,
    beans: [columnResizeService_1.ColumnResizeService],
    apiFunctions: {
        setColumnWidths: columnResizeApi_1.setColumnWidths,
    },
    dependsOn: [dragModule_1.HorizontalResizeModule, autoWidthModule_1.AutoWidthModule],
};


/***/ }),

/***/ 9677:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnResizeService = void 0;
const columnEventUtils_1 = __webpack_require__(2934);
const beanStub_1 = __webpack_require__(8731);
const logging_1 = __webpack_require__(7764);
const groupResizeFeature_1 = __webpack_require__(9033);
const resizeFeature_1 = __webpack_require__(7438);
class ColumnResizeService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colResize';
    }
    setColumnWidths(columnWidths, shiftKey, // @takeFromAdjacent - if user has 'shift' pressed, then pixels are taken from adjacent column
    finished, // @finished - ends up in the event, tells the user if more events are to come
    source) {
        const sets = [];
        const { colModel, gos, visibleCols } = this.beans;
        columnWidths.forEach((columnWidth) => {
            const col = colModel.getColDefCol(columnWidth.key) || colModel.getCol(columnWidth.key);
            if (!col) {
                return;
            }
            sets.push({
                width: columnWidth.newWidth,
                ratios: [1],
                columns: [col],
            });
            // if user wants to do shift resize by default, then we invert the shift operation
            const defaultIsShift = gos.get('colResizeDefault') === 'shift';
            if (defaultIsShift) {
                shiftKey = !shiftKey;
            }
            if (shiftKey) {
                const otherCol = visibleCols.getColAfter(col);
                if (!otherCol) {
                    return;
                }
                const widthDiff = col.getActualWidth() - columnWidth.newWidth;
                const otherColWidth = otherCol.getActualWidth() + widthDiff;
                sets.push({
                    width: otherColWidth,
                    ratios: [1],
                    columns: [otherCol],
                });
            }
        });
        if (sets.length === 0) {
            return;
        }
        this.resizeColumnSets({
            resizeSets: sets,
            finished,
            source,
        });
    }
    // method takes sets of columns and resizes them. either all sets will be resized, or nothing
    // be resized. this is used for example when user tries to resize a group and holds shift key,
    // then both the current group (grows), and the adjacent group (shrinks), will get resized,
    // so that's two sets for this method.
    resizeColumnSets(params) {
        const { resizeSets, finished, source } = params;
        const passMinMaxCheck = !resizeSets || resizeSets.every((columnResizeSet) => checkMinAndMaxWidthsForSet(columnResizeSet));
        if (!passMinMaxCheck) {
            // even though we are not going to resize beyond min/max size, we still need to dispatch event when finished
            if (finished) {
                const columns = resizeSets && resizeSets.length > 0 ? resizeSets[0].columns : null;
                (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, columns, finished, source);
            }
            return; // don't resize!
        }
        const changedCols = [];
        const allResizedCols = [];
        resizeSets.forEach((set) => {
            const { width, columns, ratios } = set;
            // keep track of pixels used, and last column gets the remaining,
            // to cater for rounding errors, and min width adjustments
            const newWidths = {};
            const finishedCols = {};
            columns.forEach((col) => allResizedCols.push(col));
            // the loop below goes through each col. if a col exceeds it's min/max width,
            // it then gets set to its min/max width and the column is removed marked as 'finished'
            // and the calculation is done again leaving this column out. take for example columns
            // {A, width: 50, maxWidth: 100}
            // {B, width: 50}
            // {C, width: 50}
            // and then the set is set to width 600 - on the first pass the grid tries to set each column
            // to 200. it checks A and sees 200 > 100 and so sets the width to 100. col A is then marked
            // as 'finished' and the calculation is done again with the remaining cols B and C, which end up
            // splitting the remaining 500 pixels.
            let finishedColsGrew = true;
            let loopCount = 0;
            while (finishedColsGrew) {
                loopCount++;
                if (loopCount > 1000) {
                    // this should never happen, but in the future, someone might introduce a bug here,
                    // so we stop the browser from hanging and report bug properly
                    (0, logging_1._error)(31);
                    break;
                }
                finishedColsGrew = false;
                const subsetCols = [];
                let subsetRatioTotal = 0;
                let pixelsToDistribute = width;
                columns.forEach((col, index) => {
                    const thisColFinished = finishedCols[col.getId()];
                    if (thisColFinished) {
                        pixelsToDistribute -= newWidths[col.getId()];
                    }
                    else {
                        subsetCols.push(col);
                        const ratioThisCol = ratios[index];
                        subsetRatioTotal += ratioThisCol;
                    }
                });
                // because we are not using all of the ratios (cols can be missing),
                // we scale the ratio. if all columns are included, then subsetRatioTotal=1,
                // and so the ratioScale will be 1.
                const ratioScale = 1 / subsetRatioTotal;
                subsetCols.forEach((col, index) => {
                    const lastCol = index === subsetCols.length - 1;
                    let colNewWidth;
                    if (lastCol) {
                        colNewWidth = pixelsToDistribute;
                    }
                    else {
                        colNewWidth = Math.round(ratios[index] * width * ratioScale);
                        pixelsToDistribute -= colNewWidth;
                    }
                    const minWidth = col.getMinWidth();
                    const maxWidth = col.getMaxWidth();
                    if (colNewWidth < minWidth) {
                        colNewWidth = minWidth;
                        finishedCols[col.getId()] = true;
                        finishedColsGrew = true;
                    }
                    else if (maxWidth > 0 && colNewWidth > maxWidth) {
                        colNewWidth = maxWidth;
                        finishedCols[col.getId()] = true;
                        finishedColsGrew = true;
                    }
                    newWidths[col.getId()] = colNewWidth;
                });
            }
            columns.forEach((col) => {
                const newWidth = newWidths[col.getId()];
                const actualWidth = col.getActualWidth();
                if (actualWidth !== newWidth) {
                    col.setActualWidth(newWidth, source);
                    changedCols.push(col);
                }
            });
        });
        // if no cols changed, then no need to update more or send event.
        const atLeastOneColChanged = changedCols.length > 0;
        let flexedCols = [];
        if (atLeastOneColChanged) {
            const { colFlex, visibleCols, colViewport } = this.beans;
            flexedCols =
                colFlex?.refreshFlexedColumns({
                    resizingCols: allResizedCols,
                    skipSetLeft: true,
                }) ?? [];
            visibleCols.setLeftValues(source);
            visibleCols.updateBodyWidths();
            colViewport.checkViewportColumns();
        }
        // check for change first, to avoid unnecessary firing of events
        // however we always dispatch 'finished' events. this is important
        // when groups are resized, as if the group is changing slowly,
        // eg 1 pixel at a time, then each change will dispatch change events
        // in all the columns in the group, but only one with get the pixel.
        const colsForEvent = allResizedCols.concat(flexedCols);
        if (atLeastOneColChanged || finished) {
            (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, colsForEvent, finished, source, flexedCols);
        }
    }
    resizeHeader(column, delta, shiftKey) {
        if (!column.isResizable()) {
            return;
        }
        const actualWidth = column.getActualWidth();
        const minWidth = column.getMinWidth();
        const maxWidth = column.getMaxWidth();
        const newWidth = Math.min(Math.max(actualWidth + delta, minWidth), maxWidth);
        this.setColumnWidths([{ key: column, newWidth }], shiftKey, true, 'uiColumnResized');
    }
    createResizeFeature(pinned, column, eResize, comp, ctrl) {
        return new resizeFeature_1.ResizeFeature(pinned, column, eResize, comp, ctrl);
    }
    createGroupResizeFeature(comp, eResize, pinned, columnGroup) {
        return new groupResizeFeature_1.GroupResizeFeature(comp, eResize, pinned, columnGroup);
    }
}
exports.ColumnResizeService = ColumnResizeService;
function checkMinAndMaxWidthsForSet(columnResizeSet) {
    const { columns, width } = columnResizeSet;
    // every col has a min width, so sum them all up and see if we have enough room
    // for all the min widths
    let minWidthAccumulated = 0;
    let maxWidthAccumulated = 0;
    let maxWidthActive = true;
    columns.forEach((col) => {
        const minWidth = col.getMinWidth();
        minWidthAccumulated += minWidth || 0;
        const maxWidth = col.getMaxWidth();
        if (maxWidth > 0) {
            maxWidthAccumulated += maxWidth;
        }
        else {
            // if at least one columns has no max width, it means the group of columns
            // then has no max width, as at least one column can take as much width as possible
            maxWidthActive = false;
        }
    });
    const minWidthPasses = width >= minWidthAccumulated;
    const maxWidthPasses = !maxWidthActive || width <= maxWidthAccumulated;
    return minWidthPasses && maxWidthPasses;
}


/***/ }),

/***/ 9033:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GroupResizeFeature = void 0;
const beanStub_1 = __webpack_require__(8731);
class GroupResizeFeature extends beanStub_1.BeanStub {
    constructor(comp, eResize, pinned, columnGroup) {
        super();
        this.comp = comp;
        this.eResize = eResize;
        this.pinned = pinned;
        this.columnGroup = columnGroup;
    }
    postConstruct() {
        if (!this.columnGroup.isResizable()) {
            this.comp.setResizableDisplayed(false);
            return;
        }
        const { horizontalResizeSvc, gos, colAutosize } = this.beans;
        const finishedWithResizeFunc = horizontalResizeSvc.addResizeBar({
            eResizeBar: this.eResize,
            onResizeStart: this.onResizeStart.bind(this),
            onResizing: this.onResizing.bind(this, false),
            onResizeEnd: this.onResizing.bind(this, true),
        });
        this.addDestroyFunc(finishedWithResizeFunc);
        if (!gos.get('suppressAutoSize') && colAutosize) {
            this.addDestroyFunc(colAutosize.addColumnGroupResize(this.eResize, this.columnGroup, () => this.resizeLeafColumnsToFit('uiColumnResized')));
        }
    }
    onResizeStart(shiftKey) {
        const { columnsToResize, resizeStartWidth, resizeRatios, groupAfterColumns, groupAfterStartWidth, groupAfterRatios, } = this.getInitialValues(shiftKey);
        this.resizeCols = columnsToResize;
        this.resizeStartWidth = resizeStartWidth;
        this.resizeRatios = resizeRatios;
        this.resizeTakeFromCols = groupAfterColumns;
        this.resizeTakeFromStartWidth = groupAfterStartWidth;
        this.resizeTakeFromRatios = groupAfterRatios;
        this.toggleColumnResizing(true);
    }
    onResizing(finished, resizeAmount, source = 'uiColumnResized') {
        const resizeAmountNormalised = this.normaliseDragChange(resizeAmount);
        const width = this.resizeStartWidth + resizeAmountNormalised;
        this.resizeColumnsFromLocalValues(width, source, finished);
    }
    getInitialValues(shiftKey) {
        const getInitialSizeOfColumns = (columns) => columns.reduce((totalWidth, column) => totalWidth + column.getActualWidth(), 0);
        const getSizeRatiosOfColumns = (columns, initialSizeOfColumns) => columns.map((column) => column.getActualWidth() / initialSizeOfColumns);
        const columnsToResize = this.getColumnsToResize();
        const resizeStartWidth = getInitialSizeOfColumns(columnsToResize);
        const resizeRatios = getSizeRatiosOfColumns(columnsToResize, resizeStartWidth);
        const columnSizeAndRatios = {
            columnsToResize,
            resizeStartWidth,
            resizeRatios,
        };
        let groupAfter = null;
        if (shiftKey) {
            groupAfter = this.beans.colGroupSvc?.getGroupAtDirection(this.columnGroup, 'After') ?? null;
        }
        if (groupAfter) {
            const takeFromLeafCols = groupAfter.getDisplayedLeafColumns();
            const groupAfterColumns = (columnSizeAndRatios.groupAfterColumns = takeFromLeafCols.filter((col) => col.isResizable()));
            const groupAfterStartWidth = (columnSizeAndRatios.groupAfterStartWidth =
                getInitialSizeOfColumns(groupAfterColumns));
            columnSizeAndRatios.groupAfterRatios = getSizeRatiosOfColumns(groupAfterColumns, groupAfterStartWidth);
        }
        else {
            columnSizeAndRatios.groupAfterColumns = undefined;
            columnSizeAndRatios.groupAfterStartWidth = undefined;
            columnSizeAndRatios.groupAfterRatios = undefined;
        }
        return columnSizeAndRatios;
    }
    resizeLeafColumnsToFit(source) {
        const preferredSize = this.beans.autoWidthCalc.getPreferredWidthForColumnGroup(this.columnGroup);
        const initialValues = this.getInitialValues();
        if (preferredSize > initialValues.resizeStartWidth) {
            this.resizeColumns(initialValues, preferredSize, source, true);
        }
    }
    resizeColumnsFromLocalValues(totalWidth, source, finished = true) {
        if (!this.resizeCols || !this.resizeRatios) {
            return;
        }
        const initialValues = {
            columnsToResize: this.resizeCols,
            resizeStartWidth: this.resizeStartWidth,
            resizeRatios: this.resizeRatios,
            groupAfterColumns: this.resizeTakeFromCols,
            groupAfterStartWidth: this.resizeTakeFromStartWidth,
            groupAfterRatios: this.resizeTakeFromRatios,
        };
        this.resizeColumns(initialValues, totalWidth, source, finished);
    }
    resizeColumns(initialValues, totalWidth, source, finished = true) {
        const { columnsToResize, resizeStartWidth, resizeRatios, groupAfterColumns, groupAfterStartWidth, groupAfterRatios, } = initialValues;
        const resizeSets = [];
        resizeSets.push({
            columns: columnsToResize,
            ratios: resizeRatios,
            width: totalWidth,
        });
        if (groupAfterColumns) {
            const diff = totalWidth - resizeStartWidth;
            resizeSets.push({
                columns: groupAfterColumns,
                ratios: groupAfterRatios,
                width: groupAfterStartWidth - diff,
            });
        }
        this.beans.colResize?.resizeColumnSets({
            resizeSets,
            finished,
            source: source,
        });
        if (finished) {
            this.toggleColumnResizing(false);
        }
    }
    toggleColumnResizing(resizing) {
        this.comp.toggleCss('ag-column-resizing', resizing);
    }
    getColumnsToResize() {
        const leafCols = this.columnGroup.getDisplayedLeafColumns();
        return leafCols.filter((col) => col.isResizable());
    }
    // optionally inverts the drag, depending on pinned and RTL
    // note - this method is duplicated in RenderedHeaderCell - should refactor out?
    normaliseDragChange(dragChange) {
        let result = dragChange;
        if (this.gos.get('enableRtl')) {
            // for RTL, dragging left makes the col bigger, except when pinning left
            if (this.pinned !== 'left') {
                result *= -1;
            }
        }
        else if (this.pinned === 'right') {
            // for LTR (ie normal), dragging left makes the col smaller, except when pinning right
            result *= -1;
        }
        return result;
    }
    destroy() {
        super.destroy();
        this.resizeCols = undefined;
        this.resizeRatios = undefined;
        this.resizeTakeFromCols = undefined;
        this.resizeTakeFromRatios = undefined;
    }
}
exports.GroupResizeFeature = GroupResizeFeature;


/***/ }),

/***/ 7438:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ResizeFeature = void 0;
const beanStub_1 = __webpack_require__(8731);
const dom_1 = __webpack_require__(3507);
class ResizeFeature extends beanStub_1.BeanStub {
    constructor(pinned, column, eResize, comp, ctrl) {
        super();
        this.pinned = pinned;
        this.column = column;
        this.eResize = eResize;
        this.comp = comp;
        this.ctrl = ctrl;
    }
    postConstruct() {
        const destroyResizeFuncs = [];
        let canResize;
        let canAutosize;
        const addResize = () => {
            (0, dom_1._setDisplayed)(this.eResize, canResize);
            if (!canResize) {
                return;
            }
            const { horizontalResizeSvc, colAutosize } = this.beans;
            const finishedWithResizeFunc = horizontalResizeSvc.addResizeBar({
                eResizeBar: this.eResize,
                onResizeStart: this.onResizeStart.bind(this),
                onResizing: this.onResizing.bind(this, false),
                onResizeEnd: this.onResizing.bind(this, true),
            });
            destroyResizeFuncs.push(finishedWithResizeFunc);
            if (canAutosize && colAutosize) {
                destroyResizeFuncs.push(colAutosize.addColumnAutosize(this.eResize, this.column));
            }
        };
        const removeResize = () => {
            destroyResizeFuncs.forEach((f) => f());
            destroyResizeFuncs.length = 0;
        };
        const refresh = () => {
            const resize = this.column.isResizable();
            const autoSize = !this.gos.get('suppressAutoSize') && !this.column.getColDef().suppressAutoSize;
            const propertyChange = resize !== canResize || autoSize !== canAutosize;
            if (propertyChange) {
                canResize = resize;
                canAutosize = autoSize;
                removeResize();
                addResize();
            }
        };
        refresh();
        this.addDestroyFunc(removeResize);
        this.ctrl.setRefreshFunction('resize', refresh);
    }
    onResizing(finished, resizeAmount) {
        const { column: key, lastResizeAmount, resizeStartWidth, beans } = this;
        const resizeAmountNormalised = this.normaliseResizeAmount(resizeAmount);
        const newWidth = resizeStartWidth + resizeAmountNormalised;
        const columnWidths = [{ key, newWidth }];
        const { pinnedCols, ctrlsSvc, colResize } = beans;
        if (this.column.getPinned()) {
            const leftWidth = pinnedCols?.leftWidth ?? 0;
            const rightWidth = pinnedCols?.rightWidth ?? 0;
            const bodyWidth = (0, dom_1._getInnerWidth)(ctrlsSvc.getGridBodyCtrl().eBodyViewport) - 50;
            if (leftWidth + rightWidth + (resizeAmountNormalised - lastResizeAmount) > bodyWidth) {
                return;
            }
        }
        this.lastResizeAmount = resizeAmountNormalised;
        colResize?.setColumnWidths(columnWidths, this.resizeWithShiftKey, finished, 'uiColumnResized');
        if (finished) {
            this.toggleColumnResizing(false);
        }
    }
    onResizeStart(shiftKey) {
        this.resizeStartWidth = this.column.getActualWidth();
        this.lastResizeAmount = 0;
        this.resizeWithShiftKey = shiftKey;
        this.toggleColumnResizing(true);
    }
    toggleColumnResizing(resizing) {
        this.comp.toggleCss('ag-column-resizing', resizing);
    }
    // optionally inverts the drag, depending on pinned and RTL
    // note - this method is duplicated in RenderedHeaderGroupCell - should refactor out?
    normaliseResizeAmount(dragChange) {
        let result = dragChange;
        const notPinningLeft = this.pinned !== 'left';
        const pinningRight = this.pinned === 'right';
        if (this.gos.get('enableRtl')) {
            // for RTL, dragging left makes the col bigger, except when pinning left
            if (notPinningLeft) {
                result *= -1;
            }
        }
        else {
            // for LTR (ie normal), dragging left makes the col smaller, except when pinning right
            if (pinningRight) {
                result *= -1;
            }
        }
        return result;
    }
}
exports.ResizeFeature = ResizeFeature;


/***/ }),

/***/ 3600:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseColsService = void 0;
const beanStub_1 = __webpack_require__(8731);
const array_1 = __webpack_require__(1502);
const generic_1 = __webpack_require__(4422);
const columnEventUtils_1 = __webpack_require__(2934);
class BaseColsService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.dispatchColumnChangedEvent = columnEventUtils_1.dispatchColumnChangedEvent;
        this.columns = [];
        this.columnIndexMap = {};
        this.updateIndexMap = () => {
            this.columnIndexMap = {};
            this.columns.forEach((col, index) => (this.columnIndexMap[col.getId()] = index));
        };
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.aggFuncSvc = beans.aggFuncSvc;
        this.visibleCols = beans.visibleCols;
    }
    sortColumns(compareFn) {
        this.columns.sort(compareFn);
        this.updateIndexMap();
    }
    setColumns(colKeys, source) {
        this.setColList(colKeys, this.columns, this.eventName, true, true, this.columnProcessors.set, source);
    }
    addColumns(colKeys, source) {
        this.updateColList(colKeys, this.columns, true, true, this.columnProcessors.add, this.eventName, source);
    }
    removeColumns(colKeys, source) {
        this.updateColList(colKeys, this.columns, false, true, this.columnProcessors.remove, this.eventName, source);
    }
    getColumnIndex(colId) {
        return this.columnIndexMap[colId];
    }
    setColList(colKeys = [], masterList, eventName, detectOrderChange, autoGroupsNeedBuilding, columnCallback, source) {
        const gridColumns = this.colModel.getCols();
        if (!gridColumns || gridColumns.length === 0) {
            return;
        }
        const changes = new Map();
        // store all original cols and their index.
        masterList.forEach((col, idx) => changes.set(col, idx));
        masterList.length = 0;
        if ((0, generic_1._exists)(colKeys)) {
            colKeys.forEach((key) => {
                const column = this.colModel.getColDefCol(key);
                if (column) {
                    masterList.push(column);
                }
            });
        }
        masterList.forEach((col, idx) => {
            const oldIndex = changes.get(col);
            // if the column was not in the list, we add it as it's a change
            // idx is irrelevant now.
            if (oldIndex === undefined) {
                changes.set(col, 0);
                return;
            }
            if (detectOrderChange && oldIndex !== idx) {
                // if we're detecting order changes, and the indexes differ, we retain this as it's changed
                return;
            }
            // otherwise remove this col, as it's unchanged.
            changes.delete(col);
        });
        this.updateIndexMap();
        const primaryCols = this.colModel.getColDefCols();
        (primaryCols || []).forEach((column) => {
            const added = masterList.indexOf(column) >= 0;
            columnCallback(column, added, source);
        });
        autoGroupsNeedBuilding && this.colModel.refreshCols(false);
        this.visibleCols.refresh(source);
        this.dispatchColumnChangedEvent(this.eventSvc, eventName, [...changes.keys()], source);
    }
    updateColList(keys = [], masterList, actionIsAdd, autoGroupsNeedBuilding, columnCallback, eventType, source) {
        if (!keys || keys.length === 0) {
            return;
        }
        let atLeastOne = false;
        const updatedCols = new Set();
        keys.forEach((key) => {
            if (!key) {
                return;
            }
            const columnToAdd = this.colModel.getColDefCol(key);
            if (!columnToAdd) {
                return;
            }
            updatedCols.add(columnToAdd);
            if (actionIsAdd) {
                if (masterList.indexOf(columnToAdd) >= 0) {
                    return;
                }
                masterList.push(columnToAdd);
            }
            else {
                const currentIndex = masterList.indexOf(columnToAdd);
                if (currentIndex < 0) {
                    return;
                }
                for (let i = currentIndex + 1; i < masterList.length; i++) {
                    // row indexes of subsequent columns have changed
                    updatedCols.add(masterList[i]);
                }
                (0, array_1._removeFromArray)(masterList, columnToAdd);
            }
            columnCallback(columnToAdd, actionIsAdd, source);
            atLeastOne = true;
        });
        if (!atLeastOne) {
            return;
        }
        this.updateIndexMap();
        if (autoGroupsNeedBuilding) {
            this.colModel.refreshCols(false);
        }
        this.visibleCols.refresh(source);
        const eventColumns = Array.from(updatedCols);
        this.eventSvc.dispatchEvent({
            type: eventType,
            columns: eventColumns,
            column: eventColumns.length === 1 ? eventColumns[0] : null,
            source,
        });
    }
    extractCols(source, oldProvidedCols = []) {
        const previousCols = this.columns;
        const colsWithIndex = [];
        const colsWithValue = [];
        const { setFlagFunc, getIndexFunc, getInitialIndexFunc, getValueFunc, getInitialValueFunc } = this.columnExtractors;
        const primaryCols = this.colModel.getColDefCols() || [];
        // go though all cols.
        // if value, change
        // if default only, change only if new
        primaryCols.forEach((col) => {
            const colIsNew = oldProvidedCols.indexOf(col) < 0;
            const colDef = col.getColDef();
            const value = getValueFunc(colDef);
            const initialValue = getInitialValueFunc(colDef);
            const index = getIndexFunc(colDef);
            const initialIndex = getInitialIndexFunc(colDef);
            let include;
            const valuePresent = value !== undefined;
            const indexPresent = index !== undefined;
            const initialValuePresent = initialValue !== undefined;
            const initialIndexPresent = initialIndex !== undefined;
            if (valuePresent) {
                include = value; // boolean value is guaranteed as attrToBoolean() is used above
            }
            else if (indexPresent) {
                if (index === null) {
                    // if col is new we don't want to use the default / initial if index is set to null. Similarly,
                    // we don't want to include the property for existing columns, i.e. we want to 'clear' it.
                    include = false;
                }
                else {
                    // note that 'null >= 0' evaluates to true which means 'rowGroupIndex = null' would enable row
                    // grouping if the null check didn't exist above.
                    include = index >= 0;
                }
            }
            else {
                if (colIsNew) {
                    // as no value or index is 'present' we use the default / initial when col is new
                    if (initialValuePresent) {
                        include = initialValue;
                    }
                    else if (initialIndexPresent) {
                        include = initialIndex != null && initialIndex >= 0;
                    }
                    else {
                        include = false;
                    }
                }
                else {
                    // otherwise include it if included last time, e.g. if we are extracting row group cols and this col
                    // is an existing row group col (i.e. it exists in 'previousCols') then we should include it.
                    include = previousCols.indexOf(col) >= 0;
                }
            }
            if (include) {
                const useIndex = colIsNew ? index != null || initialIndex != null : index != null;
                useIndex ? colsWithIndex.push(col) : colsWithValue.push(col);
            }
        });
        const getIndexForCol = (col) => {
            const index = getIndexFunc(col.getColDef());
            const defaultIndex = getInitialIndexFunc(col.getColDef());
            return index != null ? index : defaultIndex;
        };
        // sort cols with index, and add these first
        colsWithIndex.sort((colA, colB) => {
            const indexA = getIndexForCol(colA);
            const indexB = getIndexForCol(colB);
            if (indexA === indexB) {
                return 0;
            }
            if (indexA < indexB) {
                return -1;
            }
            return 1;
        });
        const res = [].concat(colsWithIndex);
        // second add columns that were there before and in the same order as they were before,
        // so we are preserving order of current grouping of columns that simply have rowGroup=true
        previousCols.forEach((col) => {
            if (colsWithValue.indexOf(col) >= 0) {
                res.push(col);
            }
        });
        // lastly put in all remaining cols
        colsWithValue.forEach((col) => {
            if (res.indexOf(col) < 0) {
                res.push(col);
            }
        });
        // set flag=false for removed cols
        previousCols.forEach((col) => {
            if (res.indexOf(col) < 0) {
                setFlagFunc(col, false, source);
            }
        });
        // set flag=true for newly added cols
        res.forEach((col) => {
            if (previousCols.indexOf(col) < 0) {
                setFlagFunc(col, true, source);
            }
        });
        this.columns = res;
        this.updateIndexMap();
        return this.columns;
    }
    restoreColumnOrder(columnStateAccumulator, incomingColumnState) {
        const colList = this.columns;
        const primaryCols = this.colModel.getColDefCols();
        if (!colList.length || !primaryCols) {
            return columnStateAccumulator;
        }
        const updatedColIdArray = Object.keys(incomingColumnState);
        const updatedColIds = new Set(updatedColIdArray);
        const newColIds = new Set(updatedColIdArray);
        const allColIds = new Set(colList
            .map((column) => {
            const colId = column.getColId();
            newColIds.delete(colId);
            return colId;
        })
            .concat(updatedColIdArray));
        const colIdsInOriginalOrder = [];
        const originalOrderMap = {};
        let orderIndex = 0;
        for (let i = 0; i < primaryCols.length; i++) {
            const colId = primaryCols[i].getColId();
            if (allColIds.has(colId)) {
                colIdsInOriginalOrder.push(colId);
                originalOrderMap[colId] = orderIndex++;
            }
        }
        // follow approach in `resetColumnState`
        let index = 1000;
        let hasAddedNewCols = false;
        let lastIndex = 0;
        const enableProp = this.columnOrdering.enableProp;
        const initialEnableProp = this.columnOrdering.initialEnableProp;
        const indexProp = this.columnOrdering.indexProp;
        const initialIndexProp = this.columnOrdering.initialIndexProp;
        const processPrecedingNewCols = (colId) => {
            const originalOrderIndex = originalOrderMap[colId];
            for (let i = lastIndex; i < originalOrderIndex; i++) {
                const newColId = colIdsInOriginalOrder[i];
                if (newColIds.has(newColId)) {
                    incomingColumnState[newColId][indexProp] = index++;
                    newColIds.delete(newColId);
                }
            }
            lastIndex = originalOrderIndex;
        };
        colList.forEach((column) => {
            const colId = column.getColId();
            if (updatedColIds.has(colId)) {
                // New col already exists. Add any other new cols that should be before it.
                processPrecedingNewCols(colId);
                incomingColumnState[colId][indexProp] = index++;
            }
            else {
                const colDef = column.getColDef();
                const missingIndex = colDef[indexProp] === null || (colDef[indexProp] === undefined && colDef[initialIndexProp] == null);
                if (missingIndex) {
                    if (!hasAddedNewCols) {
                        const propEnabled = colDef[enableProp] || (colDef[enableProp] === undefined && colDef[initialEnableProp]);
                        if (propEnabled) {
                            processPrecedingNewCols(colId);
                        }
                        else {
                            // Reached the first manually added column. Add all the new columns now.
                            newColIds.forEach((newColId) => {
                                // Rather than increment the index, just use the original order index - doesn't need to be contiguous.
                                incomingColumnState[newColId][indexProp] = index + originalOrderMap[newColId];
                            });
                            index += colIdsInOriginalOrder.length;
                            hasAddedNewCols = true;
                        }
                    }
                    if (!columnStateAccumulator[colId]) {
                        columnStateAccumulator[colId] = { colId };
                    }
                    columnStateAccumulator[colId][indexProp] = index++;
                }
            }
        });
        return columnStateAccumulator;
    }
}
exports.BaseColsService = BaseColsService;


/***/ }),

/***/ 1144:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getAllDisplayedVirtualColumns = exports.getAllDisplayedColumns = exports.getDisplayedRightColumns = exports.getDisplayedCenterColumns = exports.getDisplayedLeftColumns = exports.getAllGridColumns = exports.setColumnsPinned = exports.setColumnsVisible = exports.getDisplayedColBefore = exports.getDisplayedColAfter = exports.isPinningRight = exports.isPinningLeft = exports.isPinning = exports.resetColumnState = exports.getColumnState = exports.applyColumnState = exports.getColumns = exports.getColumn = exports.getDisplayNameForColumn = exports.getColumnDefs = exports.getColumnDef = void 0;
const columnStateUtils_1 = __webpack_require__(2885);
function getColumnDef(beans, key) {
    const column = beans.colModel.getColDefCol(key);
    if (column) {
        return column.getColDef();
    }
    return null;
}
exports.getColumnDef = getColumnDef;
function getColumnDefs(beans) {
    return beans.colModel.getColumnDefs();
}
exports.getColumnDefs = getColumnDefs;
function getDisplayNameForColumn(beans, column, location) {
    return beans.colNames.getDisplayNameForColumn(column, location) || '';
}
exports.getDisplayNameForColumn = getDisplayNameForColumn;
function getColumn(beans, key) {
    return beans.colModel.getColDefCol(key);
}
exports.getColumn = getColumn;
function getColumns(beans) {
    return beans.colModel.getColDefCols();
}
exports.getColumns = getColumns;
function applyColumnState(beans, params) {
    return (0, columnStateUtils_1._applyColumnState)(beans, params, 'api');
}
exports.applyColumnState = applyColumnState;
function getColumnState(beans) {
    return (0, columnStateUtils_1._getColumnState)(beans);
}
exports.getColumnState = getColumnState;
function resetColumnState(beans) {
    (0, columnStateUtils_1._resetColumnState)(beans, 'api');
}
exports.resetColumnState = resetColumnState;
function isPinning(beans) {
    return beans.visibleCols.isPinningLeft() || beans.visibleCols.isPinningRight();
}
exports.isPinning = isPinning;
function isPinningLeft(beans) {
    return beans.visibleCols.isPinningLeft();
}
exports.isPinningLeft = isPinningLeft;
function isPinningRight(beans) {
    return beans.visibleCols.isPinningRight();
}
exports.isPinningRight = isPinningRight;
function getDisplayedColAfter(beans, col) {
    return beans.visibleCols.getColAfter(col);
}
exports.getDisplayedColAfter = getDisplayedColAfter;
function getDisplayedColBefore(beans, col) {
    return beans.visibleCols.getColBefore(col);
}
exports.getDisplayedColBefore = getDisplayedColBefore;
function setColumnsVisible(beans, keys, visible) {
    beans.colModel.setColsVisible(keys, visible, 'api');
}
exports.setColumnsVisible = setColumnsVisible;
function setColumnsPinned(beans, keys, pinned) {
    beans.pinnedCols?.setColsPinned(keys, pinned, 'api');
}
exports.setColumnsPinned = setColumnsPinned;
function getAllGridColumns(beans) {
    return beans.colModel.getCols();
}
exports.getAllGridColumns = getAllGridColumns;
function getDisplayedLeftColumns(beans) {
    return beans.visibleCols.leftCols;
}
exports.getDisplayedLeftColumns = getDisplayedLeftColumns;
function getDisplayedCenterColumns(beans) {
    return beans.visibleCols.centerCols;
}
exports.getDisplayedCenterColumns = getDisplayedCenterColumns;
function getDisplayedRightColumns(beans) {
    return beans.visibleCols.rightCols;
}
exports.getDisplayedRightColumns = getDisplayedRightColumns;
function getAllDisplayedColumns(beans) {
    return beans.visibleCols.allCols;
}
exports.getAllDisplayedColumns = getAllDisplayedColumns;
function getAllDisplayedVirtualColumns(beans) {
    return beans.colViewport.getViewportColumns();
}
exports.getAllDisplayedVirtualColumns = getAllDisplayedVirtualColumns;


/***/ }),

/***/ 4604:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnDefFactory = exports._deepCloneDefinition = void 0;
const beanStub_1 = __webpack_require__(8731);
const object_1 = __webpack_require__(6996);
// returns copy of an object, doing a deep clone of any objects with that object.
// this is used for eg creating copies of Column Definitions, where we want to
// deep copy all objects, but do not want to deep copy functions (eg when user provides
// a function or class for colDef.cellRenderer)
function _deepCloneDefinition(object, keysToSkip) {
    if (!object) {
        return;
    }
    const obj = object;
    const res = {};
    Object.keys(obj).forEach((key) => {
        if ((keysToSkip && keysToSkip.indexOf(key) >= 0) || object_1.SKIP_JS_BUILTINS.has(key)) {
            return;
        }
        const value = obj[key];
        // 'simple object' means a bunch of key/value pairs, eg {filter: 'myFilter'}. it does
        // NOT include the following:
        // 1) arrays
        // 2) functions or classes (eg api instance)
        const sourceIsSimpleObject = typeof value === 'object' && value !== null && value.constructor === Object;
        if (sourceIsSimpleObject) {
            res[key] = _deepCloneDefinition(value);
        }
        else {
            res[key] = value;
        }
    });
    return res;
}
exports._deepCloneDefinition = _deepCloneDefinition;
class ColumnDefFactory extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colDefFactory';
    }
    wireBeans(beans) {
        this.rowGroupColsSvc = beans.rowGroupColsSvc;
        this.pivotColsSvc = beans.pivotColsSvc;
    }
    getColumnDefs(colDefColsList, showingPivotResult, lastOrder, colsList) {
        const cols = colDefColsList.slice();
        if (showingPivotResult) {
            cols.sort((a, b) => lastOrder.indexOf(a) - lastOrder.indexOf(b));
        }
        else if (lastOrder) {
            cols.sort((a, b) => colsList.indexOf(a) - colsList.indexOf(b));
        }
        const rowGroupColumns = this.rowGroupColsSvc?.columns;
        const pivotColumns = this.pivotColsSvc?.columns;
        return this.buildColumnDefs(cols, rowGroupColumns, pivotColumns);
    }
    buildColumnDefs(cols, rowGroupColumns = [], pivotColumns = []) {
        const res = [];
        const colGroupDefs = {};
        cols.forEach((col) => {
            const colDef = this.createDefFromColumn(col, rowGroupColumns, pivotColumns);
            let addToResult = true;
            let childDef = colDef;
            let pointer = col.getOriginalParent();
            let lastPointer = null;
            while (pointer) {
                let parentDef = null;
                // we don't include padding groups, as the column groups provided
                // by application didn't have these. the whole point of padding groups
                // is to balance the column tree that the user provided.
                if (pointer.isPadding()) {
                    pointer = pointer.getOriginalParent();
                    continue;
                }
                // if colDef for this group already exists, use it
                const existingParentDef = colGroupDefs[pointer.getGroupId()];
                if (existingParentDef) {
                    existingParentDef.children.push(childDef);
                    // if we added to result, it would be the second time we did it
                    addToResult = false;
                    // we don't want to continue up the tree, as it has already been
                    // done for this group
                    break;
                }
                parentDef = this.createDefFromGroup(pointer);
                if (parentDef) {
                    parentDef.children = [childDef];
                    colGroupDefs[parentDef.groupId] = parentDef;
                    childDef = parentDef;
                    pointer = pointer.getOriginalParent();
                }
                if (pointer != null && lastPointer === pointer) {
                    addToResult = false;
                    break;
                }
                // Ensure we don't get stuck in an infinite loop
                lastPointer = pointer;
            }
            if (addToResult) {
                res.push(childDef);
            }
        });
        return res;
    }
    createDefFromGroup(group) {
        const defCloned = _deepCloneDefinition(group.getColGroupDef(), ['children']);
        if (defCloned) {
            defCloned.groupId = group.getGroupId();
        }
        return defCloned;
    }
    createDefFromColumn(col, rowGroupColumns, pivotColumns) {
        const colDefCloned = _deepCloneDefinition(col.getColDef());
        colDefCloned.colId = col.getColId();
        colDefCloned.width = col.getActualWidth();
        colDefCloned.rowGroup = col.isRowGroupActive();
        colDefCloned.rowGroupIndex = col.isRowGroupActive() ? rowGroupColumns.indexOf(col) : null;
        colDefCloned.pivot = col.isPivotActive();
        colDefCloned.pivotIndex = col.isPivotActive() ? pivotColumns.indexOf(col) : null;
        colDefCloned.aggFunc = col.isValueActive() ? col.getAggFunc() : null;
        colDefCloned.hide = col.isVisible() ? undefined : true;
        colDefCloned.pinned = col.isPinned() ? col.getPinned() : null;
        colDefCloned.sort = col.getSort() ? col.getSort() : null;
        colDefCloned.sortIndex = col.getSortIndex() != null ? col.getSortIndex() : null;
        return colDefCloned;
    }
}
exports.ColumnDefFactory = ColumnDefFactory;


/***/ }),

/***/ 2934:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.dispatchColumnResizedEvent = exports.dispatchColumnChangedEvent = exports.dispatchColumnVisibleEvent = exports.dispatchColumnPinnedEvent = void 0;
function getCommonValue(cols, valueGetter) {
    if (!cols || cols.length == 0) {
        return undefined;
    }
    // compare each value to the first value. if nothing differs, then value is common so return it.
    const firstValue = valueGetter(cols[0]);
    for (let i = 1; i < cols.length; i++) {
        if (firstValue !== valueGetter(cols[i])) {
            // values differ, no common value
            return undefined;
        }
    }
    return firstValue;
}
function dispatchColumnPinnedEvent(eventSvc, changedColumns, source) {
    if (!changedColumns.length) {
        return;
    }
    // if just one column, we use this, otherwise we don't include the col
    const column = changedColumns.length === 1 ? changedColumns[0] : null;
    // only include pinned if it's common in all columns
    const pinned = getCommonValue(changedColumns, (col) => col.getPinned());
    eventSvc.dispatchEvent({
        type: 'columnPinned',
        // mistake in typing, 'undefined' should be allowed, as 'null' means 'not pinned'
        pinned: pinned != null ? pinned : null,
        columns: changedColumns,
        column,
        source,
    });
}
exports.dispatchColumnPinnedEvent = dispatchColumnPinnedEvent;
function dispatchColumnVisibleEvent(eventSvc, changedColumns, source) {
    if (!changedColumns.length) {
        return;
    }
    // if just one column, we use this, otherwise we don't include the col
    const column = changedColumns.length === 1 ? changedColumns[0] : null;
    // only include visible if it's common in all columns
    const visible = getCommonValue(changedColumns, (col) => col.isVisible());
    eventSvc.dispatchEvent({
        type: 'columnVisible',
        visible,
        columns: changedColumns,
        column,
        source,
    });
}
exports.dispatchColumnVisibleEvent = dispatchColumnVisibleEvent;
function dispatchColumnChangedEvent(eventSvc, type, columns, source) {
    eventSvc.dispatchEvent({
        type,
        columns,
        column: columns && columns.length == 1 ? columns[0] : null,
        source,
    });
}
exports.dispatchColumnChangedEvent = dispatchColumnChangedEvent;
function dispatchColumnResizedEvent(eventSvc, columns, finished, source, flexColumns = null) {
    if (columns?.length) {
        eventSvc.dispatchEvent({
            type: 'columnResized',
            columns,
            column: columns.length === 1 ? columns[0] : null,
            flexColumns,
            finished,
            source,
        });
    }
}
exports.dispatchColumnResizedEvent = dispatchColumnResizedEvent;


/***/ }),

/***/ 2716:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.depthFirstOriginalTreeSearch = exports._addColumnDefaultAndTypes = exports._updateColumnState = exports.updateSomeColumnState = exports._recursivelyCreateColumns = exports._createColumnTree = exports._createColumnTreeWithIds = void 0;
const agColumn_1 = __webpack_require__(3355);
const agProvidedColumnGroup_1 = __webpack_require__(9409);
const defaultColumnTypes_1 = __webpack_require__(5449);
const gridOptionsUtils_1 = __webpack_require__(7274);
const object_1 = __webpack_require__(6996);
const logging_1 = __webpack_require__(7764);
const columnGroupUtils_1 = __webpack_require__(820);
const columnKeyCreator_1 = __webpack_require__(2294);
const columnUtils_1 = __webpack_require__(3146);
/**
 * A performant approach to _createColumnTree where the function assumes all defs have an ID.
 * Used for Pivoting.
 */
function _createColumnTreeWithIds(beans, defs = null, primaryColumns, existingTree, source) {
    const { existingCols, existingGroups } = extractExistingTreeData(existingTree);
    const colIdMap = new Map(existingCols.map((col) => [col.getId(), col]));
    const colGroupIdMap = new Map(existingGroups.map((group) => [group.getId(), group]));
    let maxDepth = 0;
    const recursivelyProcessColDef = (def, level) => {
        maxDepth = Math.max(maxDepth, level);
        if (isColumnGroupDef(def)) {
            if (!beans.colGroupSvc) {
                return null;
            }
            const groupId = def.groupId;
            const group = colGroupIdMap.get(groupId);
            const colGroupDef = (0, columnGroupUtils_1.createMergedColGroupDef)(beans, def, groupId);
            const newGroup = new agProvidedColumnGroup_1.AgProvidedColumnGroup(colGroupDef, groupId, false, level);
            beans.context.createBean(newGroup);
            if (group) {
                newGroup.setExpanded(group.isExpanded());
            }
            newGroup.setChildren(def.children.map((child) => recursivelyProcessColDef(child, level + 1)));
            return newGroup;
        }
        const colId = def.colId;
        let column = colIdMap.get(colId);
        if (!column) {
            // no existing column, need to create one
            const colDefMerged = _addColumnDefaultAndTypes(beans, def, colId);
            column = new agColumn_1.AgColumn(colDefMerged, def, colId, primaryColumns);
            beans.context.createBean(column);
        }
        else {
            const colDefMerged = _addColumnDefaultAndTypes(beans, def, column.getColId());
            column.setColDef(colDefMerged, def, source);
            _updateColumnState(beans, column, colDefMerged, source);
        }
        beans.dataTypeSvc?.addColumnListeners(column);
        return column;
    };
    const root = defs?.map((def) => recursivelyProcessColDef(def, 0)) ?? [];
    let counter = 0;
    const keyCreator = {
        getUniqueKey: (_colId, _field) => String(++counter),
    };
    const columnTree = beans.colGroupSvc ? beans.colGroupSvc.balanceColumnTree(root, 0, maxDepth, keyCreator) : root;
    const depthFirstCallback = (child, parent) => {
        if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
            child.setupExpandable();
        }
        // we set the original parents at the end, rather than when we go along, as balancing the tree
        // adds extra levels into the tree. so we can only set parents when balancing is done.
        child.originalParent = parent;
    };
    depthFirstOriginalTreeSearch(null, columnTree, depthFirstCallback);
    return {
        columnTree,
        treeDepth: maxDepth,
    };
}
exports._createColumnTreeWithIds = _createColumnTreeWithIds;
function _createColumnTree(beans, defs = null, primaryColumns, existingTree, source) {
    // column key creator dishes out unique column id's in a deterministic way,
    // so if we have two grids (that could be master/slave) with same column definitions,
    // then this ensures the two grids use identical id's.
    const columnKeyCreator = new columnKeyCreator_1.ColumnKeyCreator();
    const { existingCols, existingGroups, existingColKeys } = extractExistingTreeData(existingTree);
    columnKeyCreator.addExistingKeys(existingColKeys);
    // create am unbalanced tree that maps the provided definitions
    const unbalancedTree = _recursivelyCreateColumns(beans, defs, 0, primaryColumns, existingCols, columnKeyCreator, existingGroups, source);
    const { colGroupSvc } = beans;
    const treeDepth = colGroupSvc?.findMaxDepth(unbalancedTree, 0) ?? 0;
    const columnTree = colGroupSvc
        ? colGroupSvc.balanceColumnTree(unbalancedTree, 0, treeDepth, columnKeyCreator)
        : unbalancedTree;
    const depthFirstCallback = (child, parent) => {
        if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
            child.setupExpandable();
        }
        // we set the original parents at the end, rather than when we go along, as balancing the tree
        // adds extra levels into the tree. so we can only set parents when balancing is done.
        child.originalParent = parent;
    };
    depthFirstOriginalTreeSearch(null, columnTree, depthFirstCallback);
    return {
        columnTree,
        treeDepth,
    };
}
exports._createColumnTree = _createColumnTree;
function extractExistingTreeData(existingTree) {
    const existingCols = [];
    const existingGroups = [];
    const existingColKeys = [];
    if (existingTree) {
        depthFirstOriginalTreeSearch(null, existingTree, (item) => {
            if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(item)) {
                const group = item;
                existingGroups.push(group);
            }
            else {
                const col = item;
                existingColKeys.push(col.getId());
                existingCols.push(col);
            }
        });
    }
    return { existingCols, existingGroups, existingColKeys };
}
function _recursivelyCreateColumns(beans, defs, level, primaryColumns, existingColsCopy, columnKeyCreator, existingGroups, source) {
    if (!defs)
        return [];
    const { colGroupSvc } = beans;
    const result = new Array(defs.length);
    for (let i = 0; i < result.length; i++) {
        const def = defs[i];
        if (colGroupSvc && isColumnGroupDef(def)) {
            result[i] = colGroupSvc.createProvidedColumnGroup(primaryColumns, def, level, existingColsCopy, columnKeyCreator, existingGroups, source);
        }
        else {
            result[i] = createColumn(beans, primaryColumns, def, existingColsCopy, columnKeyCreator, source);
        }
    }
    return result;
}
exports._recursivelyCreateColumns = _recursivelyCreateColumns;
function createColumn(beans, primaryColumns, colDef, existingColsCopy, columnKeyCreator, source) {
    // see if column already exists
    const existingColAndIndex = findExistingColumn(colDef, existingColsCopy);
    // make sure we remove, so if user provided duplicate id, then we don't have more than
    // one column instance for colDef with common id
    if (existingColAndIndex) {
        existingColsCopy?.splice(existingColAndIndex.idx, 1);
    }
    let column = existingColAndIndex?.column;
    if (!column) {
        // no existing column, need to create one
        const colId = columnKeyCreator.getUniqueKey(colDef.colId, colDef.field);
        const colDefMerged = _addColumnDefaultAndTypes(beans, colDef, colId);
        column = new agColumn_1.AgColumn(colDefMerged, colDef, colId, primaryColumns);
        beans.context.createBean(column);
    }
    else {
        const colDefMerged = _addColumnDefaultAndTypes(beans, colDef, column.getColId());
        column.setColDef(colDefMerged, colDef, source);
        _updateColumnState(beans, column, colDefMerged, source);
    }
    beans.dataTypeSvc?.addColumnListeners(column);
    return column;
}
/** Updates hide, sort, sortIndex, pinned and flex */
function updateSomeColumnState(beans, column, hide, sort, sortIndex, pinned, flex, source) {
    const { sortSvc, pinnedCols, colFlex } = beans;
    // hide - anything but undefined, thus null will clear the hide
    if (hide !== undefined) {
        column.setVisible(!hide, source);
    }
    if (sortSvc) {
        // sort - anything but undefined will set sort, thus null or empty string will clear the sort
        sortSvc.updateColSort(column, sort, source);
        // sorted at - anything but undefined, thus null will clear the sortIndex
        if (sortIndex !== undefined) {
            sortSvc.setColSortIndex(column, sortIndex);
        }
    }
    // pinned - anything but undefined, thus null or empty string will remove pinned
    if (pinned !== undefined) {
        pinnedCols?.setColPinned(column, pinned);
    }
    // flex
    if (flex !== undefined) {
        colFlex?.setColFlex(column, flex);
    }
}
exports.updateSomeColumnState = updateSomeColumnState;
function _updateColumnState(beans, column, colDef, source) {
    updateSomeColumnState(beans, column, colDef.hide, colDef.sort, colDef.sortIndex, colDef.pinned, colDef.flex, source);
    const colFlex = column.getFlex();
    // width - we only set width if column is not flexing
    if (colFlex != null && colFlex > 0) {
        return;
    }
    // both null and undefined means we skip, as it's not possible to 'clear' width (a column must have a width)
    if (colDef.width != null) {
        column.setActualWidth(colDef.width, source);
    }
    else {
        // otherwise set the width again, in case min or max width has changed,
        // and width needs to be adjusted.
        const widthBeforeUpdate = column.getActualWidth();
        column.setActualWidth(widthBeforeUpdate, source);
    }
}
exports._updateColumnState = _updateColumnState;
function findExistingColumn(newColDef, existingColsCopy) {
    if (!existingColsCopy)
        return undefined;
    for (let i = 0; i < existingColsCopy.length; i++) {
        const def = existingColsCopy[i].getUserProvidedColDef();
        if (!def)
            continue;
        const newHasId = newColDef.colId != null;
        if (newHasId) {
            if (existingColsCopy[i].getId() === newColDef.colId) {
                return { idx: i, column: existingColsCopy[i] };
            }
            continue;
        }
        const newHasField = newColDef.field != null;
        if (newHasField) {
            if (def.field === newColDef.field) {
                return { idx: i, column: existingColsCopy[i] };
            }
            continue;
        }
        if (def === newColDef) {
            return { idx: i, column: existingColsCopy[i] };
        }
    }
    return undefined;
}
function _addColumnDefaultAndTypes(beans, colDef, colId, isAutoCol) {
    const { gos, dataTypeSvc } = beans;
    // start with empty merged definition
    const res = {};
    // merge properties from default column definitions
    const defaultColDef = gos.get('defaultColDef');
    (0, object_1._mergeDeep)(res, defaultColDef, false, true);
    const columnType = updateColDefAndGetColumnType(beans, res, colDef, colId);
    if (columnType) {
        assignColumnTypes(beans, columnType, res);
    }
    const cellDataType = res.cellDataType;
    // merge properties from column definitions
    (0, object_1._mergeDeep)(res, colDef, false, true);
    if (cellDataType !== undefined) {
        // `cellDataType: true` in provided def will overwrite inferred result type otherwise
        res.cellDataType = cellDataType;
    }
    const autoGroupColDef = gos.get('autoGroupColumnDef');
    const isSortingCoupled = (0, gridOptionsUtils_1._isColumnsSortingCoupledToGroup)(gos);
    if (colDef.rowGroup && autoGroupColDef && isSortingCoupled) {
        // override the sort for row group columns where the autoGroupColDef defines these values.
        (0, object_1._mergeDeep)(res, { sort: autoGroupColDef.sort, initialSort: autoGroupColDef.initialSort }, false, true);
    }
    if (dataTypeSvc) {
        dataTypeSvc.postProcess(res);
        dataTypeSvc.validateColDef(res);
    }
    gos.validateColDef(res, colId, isAutoCol);
    return res;
}
exports._addColumnDefaultAndTypes = _addColumnDefaultAndTypes;
function updateColDefAndGetColumnType(beans, colDef, userColDef, colId) {
    const dataTypeDefinitionColumnType = beans.dataTypeSvc?.updateColDefAndGetColumnType(colDef, userColDef, colId);
    const columnTypes = userColDef.type ?? dataTypeDefinitionColumnType ?? colDef.type;
    colDef.type = columnTypes;
    return columnTypes ? (0, columnUtils_1.convertColumnTypes)(columnTypes) : undefined;
}
function assignColumnTypes(beans, typeKeys, colDefMerged) {
    if (!typeKeys.length) {
        return;
    }
    // merge user defined with default column types
    const allColumnTypes = Object.assign({}, defaultColumnTypes_1.DefaultColumnTypes);
    const userTypes = beans.gos.get('columnTypes') || {};
    for (const key of Object.keys(userTypes)) {
        const value = userTypes[key];
        if (key in allColumnTypes) {
            // default column types cannot be overridden
            (0, logging_1._warn)(34, { key });
        }
        else {
            const colType = value;
            if (colType.type) {
                // type should not be defined in column types
                (0, logging_1._warn)(35);
            }
            allColumnTypes[key] = value;
        }
    }
    typeKeys.forEach((t) => {
        const typeColDef = allColumnTypes[t.trim()];
        if (typeColDef) {
            (0, object_1._mergeDeep)(colDefMerged, typeColDef, false, true);
        }
        else {
            (0, logging_1._warn)(36, { t });
        }
    });
}
// if object has children, we assume it's a group
function isColumnGroupDef(abstractColDef) {
    return abstractColDef.children !== undefined;
}
function depthFirstOriginalTreeSearch(parent, tree, callback) {
    if (!tree) {
        return;
    }
    for (let i = 0; i < tree.length; i++) {
        const child = tree[i];
        if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
            depthFirstOriginalTreeSearch(child, child.getChildren(), callback);
        }
        callback(child, parent);
    }
}
exports.depthFirstOriginalTreeSearch = depthFirstOriginalTreeSearch;


/***/ }),

/***/ 2849:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnFlexService = void 0;
const beanStub_1 = __webpack_require__(8731);
const columnEventUtils_1 = __webpack_require__(2934);
class ColumnFlexService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colFlex';
    }
    refreshFlexedColumns(params = {}) {
        const source = params.source ?? 'flex';
        if (params.viewportWidth != null) {
            this.flexViewportWidth = params.viewportWidth;
        }
        const totalSpace = this.flexViewportWidth;
        if (!totalSpace) {
            return [];
        }
        const { visibleCols } = this.beans;
        const visibleCenterCols = visibleCols.centerCols;
        let flexAfterDisplayIndex = -1;
        if (params.resizingCols) {
            const allResizingCols = new Set(params.resizingCols);
            // find the last resizing col, as only cols after this one are affected by the resizing
            for (let i = visibleCenterCols.length - 1; i >= 0; i--) {
                if (allResizingCols.has(visibleCenterCols[i])) {
                    flexAfterDisplayIndex = i;
                    break;
                }
            }
        }
        // NOTE this is an implementation of the "Resolve Flexible Lengths" part
        // of the flex spec, simplified because we only support flex growing not
        // shrinking, and don't support flex-basis.
        // https://www.w3.org/TR/css-flexbox-1/#resolve-flexible-lengths
        let hasFlexItems = false;
        const items = visibleCenterCols.map((col, i) => {
            const flex = col.getFlex();
            const isFlex = flex != null && flex > 0 && i > flexAfterDisplayIndex;
            hasFlexItems || (hasFlexItems = isFlex);
            return {
                col,
                isFlex,
                flex: Math.max(0, flex ?? 0),
                initialSize: col.getActualWidth(),
                min: col.getMinWidth(),
                max: col.getMaxWidth(),
                targetSize: 0,
            };
        });
        if (!hasFlexItems) {
            return [];
        }
        let unfrozenItemCount = items.length;
        let unfrozenFlex = items.reduce((acc, item) => acc + item.flex, 0);
        let unfrozenSpace = totalSpace;
        const freeze = (item, width) => {
            item.frozenSize = width;
            item.col.setActualWidth(width, source);
            unfrozenSpace -= width;
            unfrozenFlex -= item.flex;
            unfrozenItemCount -= 1;
        };
        const isFrozen = (item) => item.frozenSize != null;
        // Freeze inflexible columns
        for (const item of items) {
            if (!item.isFlex) {
                freeze(item, item.initialSize);
            }
        }
        // a. Check for flexible items. If all the flex items on the line are
        // frozen, free space has been distributed; exit this loop.
        while (unfrozenItemCount > 0) {
            // b. Calculate the remaining free space as for initial free space,
            // above. If the sum of the unfrozen flex items’ flex factors is
            // less than one, multiply the initial free space by this sum.
            const spaceToFill = Math.round(unfrozenFlex < 1 ? unfrozenSpace * unfrozenFlex : unfrozenSpace);
            // c. Distribute free space proportional to the flex factors.
            let lastUnfrozenItem;
            let actualLeft = 0;
            let idealRight = 0;
            for (const item of items) {
                if (isFrozen(item)) {
                    continue;
                }
                lastUnfrozenItem = item;
                idealRight += spaceToFill * (item.flex / unfrozenFlex);
                const idealSize = idealRight - actualLeft;
                const roundedSize = Math.round(idealSize);
                item.targetSize = roundedSize;
                actualLeft += roundedSize;
            }
            if (lastUnfrozenItem) {
                // Correct cumulative rounding errors: adjust the size of the
                // last item to fill any remaining space
                lastUnfrozenItem.targetSize += spaceToFill - actualLeft;
            }
            // d. Fix min/max violations. Clamp each non-frozen item’s target
            // main size by its used min and max main sizes... If the item’s
            // target main size was made smaller by this, it’s a max violation.
            // If the item’s target main size was made larger by this, it’s a
            // min violation.
            let totalViolation = 0;
            for (const item of items) {
                if (isFrozen(item)) {
                    continue;
                }
                const unclampedSize = item.targetSize;
                const clampedSize = Math.min(Math.max(unclampedSize, item.min), item.max);
                totalViolation += clampedSize - unclampedSize;
                item.violationType =
                    clampedSize === unclampedSize ? undefined : clampedSize < unclampedSize ? 'max' : 'min';
                item.targetSize = clampedSize;
            }
            // e. Freeze over-flexed items. The total violation is the sum of
            // the adjustments from the previous step.
            // If the total violation is:
            //     - Zero, Freeze all items
            //     - Positive, Freeze all the items with min violations
            //     - Negative, Freeze all the items with max violations
            const freezeType = totalViolation === 0 ? 'all' : totalViolation > 0 ? 'min' : 'max';
            for (const item of items) {
                if (isFrozen(item)) {
                    continue;
                }
                if (freezeType === 'all' || item.violationType === freezeType) {
                    freeze(item, item.targetSize);
                }
            }
        }
        if (!params.skipSetLeft) {
            visibleCols.setLeftValues(source);
        }
        if (params.updateBodyWidths) {
            visibleCols.updateBodyWidths();
        }
        const unconstrainedFlexColumns = items
            .filter((item) => item.isFlex && !item.violationType)
            .map((item) => item.col);
        if (params.fireResizedEvent) {
            const changedColumns = items.filter((item) => item.initialSize !== item.frozenSize).map((item) => item.col);
            const flexingColumns = items.filter((item) => item.flex).map((item) => item.col);
            (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, changedColumns, true, source, flexingColumns);
        }
        return unconstrainedFlexColumns;
    }
    initCol(column) {
        const { flex, initialFlex } = column.colDef;
        if (flex !== undefined) {
            column.flex = flex;
        }
        else if (initialFlex !== undefined) {
            column.flex = initialFlex;
        }
    }
    // this method should only be used by the colModel to
    // change flex when required by the applyColumnState method.
    setColFlex(column, flex) {
        column.flex = flex ?? null;
        column.dispatchStateUpdatedEvent('flex');
    }
}
exports.ColumnFlexService = ColumnFlexService;


/***/ }),

/***/ 6641:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getAllDisplayedColumnGroups = exports.getRightDisplayedColumnGroups = exports.getCenterDisplayedColumnGroups = exports.getLeftDisplayedColumnGroups = exports.resetColumnGroupState = exports.setColumnGroupState = exports.getColumnGroupState = exports.getDisplayNameForColumnGroup = exports.getProvidedColumnGroup = exports.getColumnGroup = exports.setColumnGroupOpened = void 0;
function setColumnGroupOpened(beans, group, newValue) {
    beans.colGroupSvc?.setColumnGroupOpened(group, newValue, 'api');
}
exports.setColumnGroupOpened = setColumnGroupOpened;
function getColumnGroup(beans, name, instanceId) {
    return beans.colGroupSvc?.getColumnGroup(name, instanceId) ?? null;
}
exports.getColumnGroup = getColumnGroup;
function getProvidedColumnGroup(beans, name) {
    return beans.colGroupSvc?.getProvidedColGroup(name) ?? null;
}
exports.getProvidedColumnGroup = getProvidedColumnGroup;
function getDisplayNameForColumnGroup(beans, columnGroup, location) {
    return beans.colNames.getDisplayNameForColumnGroup(columnGroup, location) || '';
}
exports.getDisplayNameForColumnGroup = getDisplayNameForColumnGroup;
function getColumnGroupState(beans) {
    return beans.colGroupSvc?.getColumnGroupState() ?? [];
}
exports.getColumnGroupState = getColumnGroupState;
function setColumnGroupState(beans, stateItems) {
    beans.colGroupSvc?.setColumnGroupState(stateItems, 'api');
}
exports.setColumnGroupState = setColumnGroupState;
function resetColumnGroupState(beans) {
    beans.colGroupSvc?.resetColumnGroupState('api');
}
exports.resetColumnGroupState = resetColumnGroupState;
function getLeftDisplayedColumnGroups(beans) {
    return beans.visibleCols.treeLeft;
}
exports.getLeftDisplayedColumnGroups = getLeftDisplayedColumnGroups;
function getCenterDisplayedColumnGroups(beans) {
    return beans.visibleCols.treeCenter;
}
exports.getCenterDisplayedColumnGroups = getCenterDisplayedColumnGroups;
function getRightDisplayedColumnGroups(beans) {
    return beans.visibleCols.treeRight;
}
exports.getRightDisplayedColumnGroups = getRightDisplayedColumnGroups;
function getAllDisplayedColumnGroups(beans) {
    return beans.visibleCols.getAllTrees();
}
exports.getAllDisplayedColumnGroups = getAllDisplayedColumnGroups;


/***/ }),

/***/ 6041:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnGroupModule = void 0;
const headerGroupCellCtrl_1 = __webpack_require__(84);
const version_1 = __webpack_require__(7205);
const columnGroupApi_1 = __webpack_require__(6641);
const columnGroupService_1 = __webpack_require__(6266);
/**
 * @feature Columns -> Column Groups
 * @colGroupDef
 */
exports.ColumnGroupModule = {
    moduleName: 'ColumnGroup',
    version: version_1.VERSION,
    dynamicBeans: { headerGroupCellCtrl: headerGroupCellCtrl_1.HeaderGroupCellCtrl },
    beans: [columnGroupService_1.ColumnGroupService],
    apiFunctions: {
        getAllDisplayedColumnGroups: columnGroupApi_1.getAllDisplayedColumnGroups,
        getCenterDisplayedColumnGroups: columnGroupApi_1.getCenterDisplayedColumnGroups,
        getColumnGroup: columnGroupApi_1.getColumnGroup,
        getColumnGroupState: columnGroupApi_1.getColumnGroupState,
        getDisplayNameForColumnGroup: columnGroupApi_1.getDisplayNameForColumnGroup,
        getLeftDisplayedColumnGroups: columnGroupApi_1.getLeftDisplayedColumnGroups,
        getProvidedColumnGroup: columnGroupApi_1.getProvidedColumnGroup,
        getRightDisplayedColumnGroups: columnGroupApi_1.getRightDisplayedColumnGroups,
        resetColumnGroupState: columnGroupApi_1.resetColumnGroupState,
        setColumnGroupOpened: columnGroupApi_1.setColumnGroupOpened,
        setColumnGroupState: columnGroupApi_1.setColumnGroupState,
    },
};


/***/ }),

/***/ 6266:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnGroupService = void 0;
const beanStub_1 = __webpack_require__(8731);
const agColumnGroup_1 = __webpack_require__(6908);
const agColumnGroup_2 = __webpack_require__(6908);
const agProvidedColumnGroup_1 = __webpack_require__(9409);
const agProvidedColumnGroup_2 = __webpack_require__(9409);
const array_1 = __webpack_require__(1502);
const generic_1 = __webpack_require__(4422);
const columnFactoryUtils_1 = __webpack_require__(2716);
const visibleColsService_1 = __webpack_require__(6869);
const columnGroupUtils_1 = __webpack_require__(820);
class ColumnGroupService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colGroupSvc';
    }
    getColumnGroupState() {
        const columnGroupState = [];
        const gridBalancedTree = this.beans.colModel.getColTree();
        (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, gridBalancedTree, (node) => {
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(node)) {
                columnGroupState.push({
                    groupId: node.getGroupId(),
                    open: node.isExpanded(),
                });
            }
        });
        return columnGroupState;
    }
    resetColumnGroupState(source) {
        const primaryColumnTree = this.beans.colModel.getColDefColTree();
        if (!primaryColumnTree) {
            return;
        }
        const stateItems = [];
        (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, primaryColumnTree, (child) => {
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(child)) {
                const colGroupDef = child.getColGroupDef();
                const groupState = {
                    groupId: child.getGroupId(),
                    open: !colGroupDef ? undefined : colGroupDef.openByDefault,
                };
                stateItems.push(groupState);
            }
        });
        this.setColumnGroupState(stateItems, source);
    }
    setColumnGroupState(stateItems, source) {
        const { colModel, colAnimation, visibleCols, eventSvc } = this.beans;
        const gridBalancedTree = colModel.getColTree();
        if (!gridBalancedTree.length) {
            return;
        }
        colAnimation?.start();
        const impactedGroups = [];
        stateItems.forEach((stateItem) => {
            const groupKey = stateItem.groupId;
            const newValue = stateItem.open;
            const providedColumnGroup = this.getProvidedColGroup(groupKey);
            if (!providedColumnGroup) {
                return;
            }
            if (providedColumnGroup.isExpanded() === newValue) {
                return;
            }
            providedColumnGroup.setExpanded(newValue);
            impactedGroups.push(providedColumnGroup);
        });
        visibleCols.refresh(source, true);
        if (impactedGroups.length) {
            eventSvc.dispatchEvent({
                type: 'columnGroupOpened',
                columnGroup: impactedGroups.length === 1 ? impactedGroups[0] : undefined,
                columnGroups: impactedGroups,
            });
        }
        colAnimation?.finish();
    }
    // called by headerRenderer - when a header is opened or closed
    setColumnGroupOpened(key, newValue, source) {
        let keyAsString;
        if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(key)) {
            keyAsString = key.getId();
        }
        else {
            keyAsString = key || '';
        }
        this.setColumnGroupState([{ groupId: keyAsString, open: newValue }], source);
    }
    getProvidedColGroup(key) {
        let res = null;
        (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, this.beans.colModel.getColTree(), (node) => {
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(node)) {
                if (node.getId() === key) {
                    res = node;
                }
            }
        });
        return res;
    }
    getGroupAtDirection(columnGroup, direction) {
        // pick the last displayed column in this group
        const requiredLevel = columnGroup.getProvidedColumnGroup().getLevel() + columnGroup.getPaddingLevel();
        const colGroupLeafColumns = columnGroup.getDisplayedLeafColumns();
        const col = direction === 'After' ? (0, array_1._last)(colGroupLeafColumns) : colGroupLeafColumns[0];
        const getDisplayColMethod = `getCol${direction}`;
        while (true) {
            // keep moving to the next col, until we get to another group
            const column = this.beans.visibleCols[getDisplayColMethod](col);
            if (!column) {
                return null;
            }
            const groupPointer = this.getColGroupAtLevel(column, requiredLevel);
            if (groupPointer !== columnGroup) {
                return groupPointer;
            }
        }
    }
    getColGroupAtLevel(column, level) {
        // get group at same level as the one we are looking for
        let groupPointer = column.getParent();
        let originalGroupLevel;
        let groupPointerLevel;
        while (true) {
            const groupPointerProvidedColumnGroup = groupPointer.getProvidedColumnGroup();
            originalGroupLevel = groupPointerProvidedColumnGroup.getLevel();
            groupPointerLevel = groupPointer.getPaddingLevel();
            if (originalGroupLevel + groupPointerLevel <= level) {
                break;
            }
            groupPointer = groupPointer.getParent();
        }
        return groupPointer;
    }
    updateOpenClosedVisibility() {
        const allColumnGroups = this.beans.visibleCols.getAllTrees();
        (0, visibleColsService_1.depthFirstAllColumnTreeSearch)(allColumnGroups, false, (child) => {
            if ((0, agColumnGroup_1.isColumnGroup)(child)) {
                child.calculateDisplayedColumns();
            }
        });
    }
    // returns the group with matching colId and instanceId. If instanceId is missing,
    // matches only on the colId.
    getColumnGroup(colId, partId) {
        if (!colId) {
            return null;
        }
        if ((0, agColumnGroup_1.isColumnGroup)(colId)) {
            return colId;
        }
        const allColumnGroups = this.beans.visibleCols.getAllTrees();
        const checkPartId = typeof partId === 'number';
        let result = null;
        (0, visibleColsService_1.depthFirstAllColumnTreeSearch)(allColumnGroups, false, (child) => {
            if ((0, agColumnGroup_1.isColumnGroup)(child)) {
                const columnGroup = child;
                let matched;
                if (checkPartId) {
                    matched = colId === columnGroup.getGroupId() && partId === columnGroup.getPartId();
                }
                else {
                    matched = colId === columnGroup.getGroupId();
                }
                if (matched) {
                    result = columnGroup;
                }
            }
        });
        return result;
    }
    createColumnGroups(params) {
        const { columns, idCreator, pinned, oldDisplayedGroups, isStandaloneStructure } = params;
        const oldColumnsMapped = this.mapOldGroupsById(oldDisplayedGroups);
        /**
         * The following logic starts at the leaf level of columns, iterating through them to build their parent
         * groups when the parents match.
         *
         * The created groups are then added to an array, and similarly iterated on until we reach the top level.
         *
         * When row groups have no original parent, it's added to the result.
         */
        const topLevelResultCols = [];
        // this is an array of cols or col groups at one level of depth, starting from leaf and ending at root
        let groupsOrColsAtCurrentLevel = columns;
        while (groupsOrColsAtCurrentLevel.length) {
            // store what's currently iterating so the function can build the next level of col groups
            const currentlyIterating = groupsOrColsAtCurrentLevel;
            groupsOrColsAtCurrentLevel = [];
            // store the index of the last row which was different from the previous row, this is used as a slice
            // index for finding the children to group together
            let lastGroupedColIdx = 0;
            // create a group of children from lastGroupedColIdx to the provided `to` parameter
            const createGroupToIndex = (to) => {
                const from = lastGroupedColIdx;
                lastGroupedColIdx = to;
                const previousNode = currentlyIterating[from];
                const previousNodeProvided = (0, agColumnGroup_1.isColumnGroup)(previousNode)
                    ? previousNode.getProvidedColumnGroup()
                    : previousNode;
                const previousNodeParent = previousNodeProvided.getOriginalParent();
                if (previousNodeParent == null) {
                    // if the last node was different, and had a null parent, then we add all the nodes to the final
                    // results)
                    for (let i = from; i < to; i++) {
                        topLevelResultCols.push(currentlyIterating[i]);
                    }
                    return;
                }
                // the parent differs from the previous node, so we create a group from the previous node
                // and add all to the result array, except the current node.
                const newGroup = this.createColumnGroup(previousNodeParent, idCreator, oldColumnsMapped, pinned, isStandaloneStructure);
                for (let i = from; i < to; i++) {
                    newGroup.addChild(currentlyIterating[i]);
                }
                groupsOrColsAtCurrentLevel.push(newGroup);
            };
            for (let i = 1; i < currentlyIterating.length; i++) {
                const thisNode = currentlyIterating[i];
                const thisNodeProvided = (0, agColumnGroup_1.isColumnGroup)(thisNode) ? thisNode.getProvidedColumnGroup() : thisNode;
                const thisNodeParent = thisNodeProvided.getOriginalParent();
                const previousNode = currentlyIterating[lastGroupedColIdx];
                const previousNodeProvided = (0, agColumnGroup_1.isColumnGroup)(previousNode)
                    ? previousNode.getProvidedColumnGroup()
                    : previousNode;
                const previousNodeParent = previousNodeProvided.getOriginalParent();
                if (thisNodeParent !== previousNodeParent) {
                    createGroupToIndex(i);
                }
            }
            if (lastGroupedColIdx < currentlyIterating.length) {
                createGroupToIndex(currentlyIterating.length);
            }
        }
        if (!isStandaloneStructure) {
            this.setupParentsIntoCols(topLevelResultCols, null);
        }
        return topLevelResultCols;
    }
    createProvidedColumnGroup(primaryColumns, colGroupDef, level, existingColumns, columnKeyCreator, existingGroups, source) {
        const groupId = columnKeyCreator.getUniqueKey(colGroupDef.groupId || null, null);
        const colGroupDefMerged = (0, columnGroupUtils_1.createMergedColGroupDef)(this.beans, colGroupDef, groupId);
        const providedGroup = new agProvidedColumnGroup_1.AgProvidedColumnGroup(colGroupDefMerged, groupId, false, level);
        this.createBean(providedGroup);
        const existingGroupAndIndex = this.findExistingGroup(colGroupDef, existingGroups);
        // make sure we remove, so if user provided duplicate id, then we don't have more than
        // one column instance for colDef with common id
        if (existingGroupAndIndex) {
            existingGroups.splice(existingGroupAndIndex.idx, 1);
        }
        const existingGroup = existingGroupAndIndex?.group;
        if (existingGroup) {
            providedGroup.setExpanded(existingGroup.isExpanded());
        }
        const children = (0, columnFactoryUtils_1._recursivelyCreateColumns)(this.beans, colGroupDefMerged.children, level + 1, primaryColumns, existingColumns, columnKeyCreator, existingGroups, source);
        providedGroup.setChildren(children);
        return providedGroup;
    }
    balanceColumnTree(unbalancedTree, currentDepth, columnDepth, columnKeyCreator) {
        const result = [];
        // go through each child, for groups, recurse a level deeper,
        // for columns we need to pad
        for (let i = 0; i < unbalancedTree.length; i++) {
            const child = unbalancedTree[i];
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(child)) {
                // child is a group, all we do is go to the next level of recursion
                const originalGroup = child;
                const newChildren = this.balanceColumnTree(originalGroup.getChildren(), currentDepth + 1, columnDepth, columnKeyCreator);
                originalGroup.setChildren(newChildren);
                result.push(originalGroup);
            }
            else {
                // child is a column - so here we add in the padded column groups if needed
                let firstPaddedGroup;
                let currentPaddedGroup;
                // this for loop will NOT run any loops if no padded column groups are needed
                for (let j = columnDepth - 1; j >= currentDepth; j--) {
                    const newColId = columnKeyCreator.getUniqueKey(null, null);
                    const colGroupDefMerged = (0, columnGroupUtils_1.createMergedColGroupDef)(this.beans, null, newColId);
                    const paddedGroup = new agProvidedColumnGroup_1.AgProvidedColumnGroup(colGroupDefMerged, newColId, true, currentDepth);
                    this.createBean(paddedGroup);
                    if (currentPaddedGroup) {
                        currentPaddedGroup.setChildren([paddedGroup]);
                    }
                    currentPaddedGroup = paddedGroup;
                    if (!firstPaddedGroup) {
                        firstPaddedGroup = currentPaddedGroup;
                    }
                }
                // likewise this if statement will not run if no padded groups
                if (firstPaddedGroup && currentPaddedGroup) {
                    result.push(firstPaddedGroup);
                    const hasGroups = unbalancedTree.some((leaf) => (0, agProvidedColumnGroup_2.isProvidedColumnGroup)(leaf));
                    if (hasGroups) {
                        currentPaddedGroup.setChildren([child]);
                        continue;
                    }
                    else {
                        currentPaddedGroup.setChildren(unbalancedTree);
                        break;
                    }
                }
                result.push(child);
            }
        }
        return result;
    }
    findDepth(balancedColumnTree) {
        let depth = 0;
        let pointer = balancedColumnTree;
        while (pointer && pointer[0] && (0, agProvidedColumnGroup_2.isProvidedColumnGroup)(pointer[0])) {
            depth++;
            pointer = pointer[0].getChildren();
        }
        return depth;
    }
    findMaxDepth(treeChildren, depth) {
        let maxDepthThisLevel = depth;
        for (let i = 0; i < treeChildren.length; i++) {
            const abstractColumn = treeChildren[i];
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(abstractColumn)) {
                const originalGroup = abstractColumn;
                const newDepth = this.findMaxDepth(originalGroup.getChildren(), depth + 1);
                if (maxDepthThisLevel < newDepth) {
                    maxDepthThisLevel = newDepth;
                }
            }
        }
        return maxDepthThisLevel;
    }
    /**
     * Inserts dummy group columns in the hierarchy above auto-generated columns
     * in order to ensure auto-generated columns are leaf nodes (and therefore are
     * displayed correctly)
     */
    balanceTreeForAutoCols(autoCols, depth) {
        const tree = [];
        autoCols.forEach((col) => {
            // at the end, this will be the top of the tree item.
            let nextChild = col;
            for (let i = depth - 1; i >= 0; i--) {
                const autoGroup = new agProvidedColumnGroup_1.AgProvidedColumnGroup(null, `FAKE_PATH_${col.getId()}}_${i}`, true, i);
                this.createBean(autoGroup);
                autoGroup.setChildren([nextChild]);
                nextChild.originalParent = autoGroup;
                nextChild = autoGroup;
            }
            if (depth === 0) {
                col.originalParent = null;
            }
            // at this point, the nextChild is the top most item in the tree
            tree.push(nextChild);
        });
        return tree;
    }
    findExistingGroup(newGroupDef, existingGroups) {
        const newHasId = newGroupDef.groupId != null;
        if (!newHasId) {
            return undefined;
        }
        for (let i = 0; i < existingGroups.length; i++) {
            const existingGroup = existingGroups[i];
            const existingDef = existingGroup.getColGroupDef();
            if (!existingDef) {
                continue;
            }
            if (existingGroup.getId() === newGroupDef.groupId) {
                return { idx: i, group: existingGroup };
            }
        }
        return undefined;
    }
    createColumnGroup(providedGroup, groupInstanceIdCreator, oldColumnsMapped, pinned, isStandaloneStructure) {
        const groupId = providedGroup.getGroupId();
        const instanceId = groupInstanceIdCreator.getInstanceIdForKey(groupId);
        const uniqueId = (0, agColumnGroup_1.createUniqueColumnGroupId)(groupId, instanceId);
        let columnGroup = oldColumnsMapped[uniqueId];
        // if the user is setting new colDefs, it is possible that the id's overlap, and we
        // would have a false match from above. so we double check we are talking about the
        // same original column group.
        if (columnGroup && columnGroup.getProvidedColumnGroup() !== providedGroup) {
            columnGroup = null;
        }
        if ((0, generic_1._exists)(columnGroup)) {
            // clean out the old column group here, as we will be adding children into it again
            columnGroup.reset();
        }
        else {
            columnGroup = new agColumnGroup_2.AgColumnGroup(providedGroup, groupId, instanceId, pinned);
            if (!isStandaloneStructure) {
                this.createBean(columnGroup);
            }
        }
        return columnGroup;
    }
    // returns back a 2d map of ColumnGroup as follows: groupId -> instanceId -> ColumnGroup
    mapOldGroupsById(displayedGroups) {
        const result = {};
        const recursive = (columnsOrGroups) => {
            columnsOrGroups.forEach((columnOrGroup) => {
                if ((0, agColumnGroup_1.isColumnGroup)(columnOrGroup)) {
                    const columnGroup = columnOrGroup;
                    result[columnOrGroup.getUniqueId()] = columnGroup;
                    recursive(columnGroup.getChildren());
                }
            });
        };
        if (displayedGroups) {
            recursive(displayedGroups);
        }
        return result;
    }
    setupParentsIntoCols(columnsOrGroups, parent) {
        columnsOrGroups.forEach((columnsOrGroup) => {
            columnsOrGroup.parent = parent;
            if ((0, agColumnGroup_1.isColumnGroup)(columnsOrGroup)) {
                const columnGroup = columnsOrGroup;
                this.setupParentsIntoCols(columnGroup.getChildren(), columnGroup);
            }
        });
    }
}
exports.ColumnGroupService = ColumnGroupService;


/***/ }),

/***/ 820:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createMergedColGroupDef = void 0;
function createMergedColGroupDef(beans, colGroupDef, groupId) {
    const colGroupDefMerged = {};
    const gos = beans.gos;
    Object.assign(colGroupDefMerged, gos.get('defaultColGroupDef'));
    Object.assign(colGroupDefMerged, colGroupDef);
    gos.validateColDef(colGroupDefMerged, groupId);
    return colGroupDefMerged;
}
exports.createMergedColGroupDef = createMergedColGroupDef;


/***/ }),

/***/ 3156:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isColumnHovered = void 0;
function isColumnHovered(beans, column) {
    return !!beans.colHover?.isHovered(column);
}
exports.isColumnHovered = isColumnHovered;


/***/ }),

/***/ 1690:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnHoverModule = void 0;
const version_1 = __webpack_require__(7205);
const columnHoverApi_1 = __webpack_require__(3156);
const columnHoverService_1 = __webpack_require__(7683);
/**
 * @feature Rows -> Styling Rows
 * @gridOption columnHoverHighlight
 */
exports.ColumnHoverModule = {
    moduleName: 'ColumnHover',
    version: version_1.VERSION,
    beans: [columnHoverService_1.ColumnHoverService],
    apiFunctions: {
        isColumnHovered: columnHoverApi_1.isColumnHovered,
    },
};


/***/ }),

/***/ 7683:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnHoverService = void 0;
const beanStub_1 = __webpack_require__(8731);
const hoverFeature_1 = __webpack_require__(5788);
const CSS_COLUMN_HOVER = 'ag-column-hover';
class ColumnHoverService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colHover';
    }
    postConstruct() {
        this.addManagedPropertyListener('columnHoverHighlight', ({ currentValue }) => {
            if (!currentValue) {
                this.clearMouseOver();
            }
        });
    }
    setMouseOver(columns) {
        this.updateState(columns);
    }
    clearMouseOver() {
        this.updateState(null);
    }
    isHovered(column) {
        if (!this.gos.get('columnHoverHighlight')) {
            return false;
        }
        const selectedColumns = this.selectedColumns;
        return !!selectedColumns && selectedColumns.indexOf(column) >= 0;
    }
    addHeaderColumnHoverListener(compBean, comp, column) {
        const listener = () => {
            const isHovered = this.isHovered(column);
            comp.toggleCss('ag-column-hover', isHovered);
        };
        compBean.addManagedEventListeners({ columnHoverChanged: listener });
        listener();
    }
    onCellColumnHover(column, cellComp) {
        if (!cellComp) {
            return;
        }
        const isHovered = this.isHovered(column);
        cellComp.toggleCss(CSS_COLUMN_HOVER, isHovered);
    }
    addHeaderFilterColumnHoverListener(compBean, comp, column, eGui) {
        this.createHoverFeature(compBean, [column], eGui);
        const listener = () => {
            const hovered = this.isHovered(column);
            comp.toggleCss('ag-column-hover', hovered);
        };
        compBean.addManagedEventListeners({ columnHoverChanged: listener });
        listener();
    }
    createHoverFeature(compBean, columns, eGui) {
        compBean.createManagedBean(new hoverFeature_1.HoverFeature(columns, eGui));
    }
    updateState(columns) {
        this.selectedColumns = columns;
        this.eventSvc.dispatchEvent({
            type: 'columnHoverChanged',
        });
    }
}
exports.ColumnHoverService = ColumnHoverService;


/***/ }),

/***/ 5788:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HoverFeature = void 0;
const beanStub_1 = __webpack_require__(8731);
class HoverFeature extends beanStub_1.BeanStub {
    constructor(columns, element) {
        super();
        this.columns = columns;
        this.element = element;
        this.destroyManagedListeners = [];
        this.enableFeature = (enabled) => {
            const { beans, gos, element, columns } = this;
            const colHover = beans.colHover;
            const active = enabled ?? !!gos.get('columnHoverHighlight');
            if (active) {
                this.destroyManagedListeners = this.addManagedElementListeners(element, {
                    mouseover: colHover.setMouseOver.bind(colHover, columns),
                    mouseout: colHover.clearMouseOver.bind(colHover),
                });
            }
            else {
                this.destroyManagedListeners.forEach((fn) => fn());
                this.destroyManagedListeners = [];
            }
        };
    }
    postConstruct() {
        this.addManagedPropertyListener('columnHoverHighlight', ({ currentValue }) => {
            this.enableFeature(currentValue);
        });
        this.enableFeature();
    }
    destroy() {
        super.destroy();
        this.destroyManagedListeners = null;
    }
}
exports.HoverFeature = HoverFeature;


/***/ }),

/***/ 2294:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnKeyCreator = void 0;
// class returns a unique id to use for the column. it checks the existing columns, and if the requested
// id is already taken, it will start appending numbers until it gets a unique id.
// eg, if the col field is 'name', it will try ids: {name, name_1, name_2...}
// if no field or id provided in the col, it will try the ids of natural numbers
const generic_1 = __webpack_require__(4422);
const logging_1 = __webpack_require__(7764);
class ColumnKeyCreator {
    constructor() {
        this.existingKeys = {};
    }
    addExistingKeys(keys) {
        for (let i = 0; i < keys.length; i++) {
            this.existingKeys[keys[i]] = true;
        }
    }
    getUniqueKey(colId, colField) {
        // in case user passed in number for colId, convert to string
        colId = (0, generic_1._toStringOrNull)(colId);
        let count = 0;
        while (true) {
            let idToTry = colId ?? colField;
            if (idToTry) {
                if (count !== 0) {
                    idToTry += '_' + count;
                }
            }
            else {
                // no point in stringing this, object treats it the same anyway.
                idToTry = count;
            }
            if (!this.existingKeys[idToTry]) {
                const usedId = String(idToTry);
                if (colId && count > 0) {
                    (0, logging_1._warn)(273, { providedId: colId, usedId });
                }
                this.existingKeys[usedId] = true;
                return usedId;
            }
            count++;
        }
    }
}
exports.ColumnKeyCreator = ColumnKeyCreator;


/***/ }),

/***/ 2986:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnModel = void 0;
const columnMoveUtils_1 = __webpack_require__(3505);
const beanStub_1 = __webpack_require__(8731);
const agColumn_1 = __webpack_require__(3355);
const gridOptionsUtils_1 = __webpack_require__(7274);
const array_1 = __webpack_require__(1502);
const columnFactoryUtils_1 = __webpack_require__(2716);
const columnStateUtils_1 = __webpack_require__(2885);
const columnUtils_1 = __webpack_require__(3146);
class ColumnModel extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colModel';
        // if pivotMode is on, however pivot results are NOT shown if no pivot columns are set
        this.pivotMode = false;
        this.ready = false;
        this.changeEventsDispatching = false;
    }
    postConstruct() {
        this.pivotMode = this.gos.get('pivotMode');
        this.addManagedPropertyListeners(['groupDisplayType', 'treeData', 'treeDataDisplayType', 'groupHideOpenParents'], (event) => this.refreshAll((0, columnUtils_1._convertColumnEventSourceType)(event.source)));
        this.addManagedPropertyListeners(['defaultColDef', 'defaultColGroupDef', 'columnTypes', 'suppressFieldDotNotation'], this.recreateColumnDefs.bind(this));
        this.addManagedPropertyListener('pivotMode', (event) => this.setPivotMode(this.gos.get('pivotMode'), (0, columnUtils_1._convertColumnEventSourceType)(event.source)));
    }
    // called from SyncService, when grid has finished initialising
    createColsFromColDefs(source) {
        const { beans } = this;
        const { valueCache, colAutosize, rowGroupColsSvc, pivotColsSvc, valueColsSvc, visibleCols, colViewport, eventSvc, } = beans;
        // only need to dispatch before/after events if updating columns, never if setting columns for first time
        const dispatchEventsFunc = this.colDefs ? (0, columnStateUtils_1._compareColumnStatesAndDispatchEvents)(beans, source) : undefined;
        // always invalidate cache on changing columns, as the column id's for the new columns
        // could overlap with the old id's, so the cache would return old values for new columns.
        valueCache?.expire();
        const oldCols = this.colDefCols?.list;
        const oldTree = this.colDefCols?.tree;
        const newTree = (0, columnFactoryUtils_1._createColumnTree)(beans, this.colDefs, true, oldTree, source);
        (0, columnUtils_1._destroyColumnTree)(beans, this.colDefCols?.tree, newTree.columnTree);
        const tree = newTree.columnTree;
        const treeDepth = newTree.treeDepth;
        const list = (0, columnUtils_1._getColumnsFromTree)(tree);
        const map = {};
        list.forEach((col) => (map[col.getId()] = col));
        this.colDefCols = { tree, treeDepth, list, map };
        rowGroupColsSvc?.extractCols(source, oldCols);
        pivotColsSvc?.extractCols(source, oldCols);
        valueColsSvc?.extractCols(source, oldCols);
        this.ready = true;
        this.refreshCols(true);
        visibleCols.refresh(source);
        colViewport.checkViewportColumns();
        // this event is not used by AG Grid, but left here for backwards compatibility,
        // in case applications use it
        eventSvc.dispatchEvent({
            type: 'columnEverythingChanged',
            source,
        });
        // Row Models react to all of these events as well as new columns loaded,
        // this flag instructs row model to ignore these events to reduce refreshes.
        if (dispatchEventsFunc) {
            this.changeEventsDispatching = true;
            dispatchEventsFunc();
            this.changeEventsDispatching = false;
        }
        eventSvc.dispatchEvent({
            type: 'newColumnsLoaded',
            source,
        });
        if (source === 'gridInitializing') {
            colAutosize?.applyAutosizeStrategy();
        }
    }
    // called from: buildAutoGroupColumns (events 'groupDisplayType', 'treeData', 'treeDataDisplayType', 'groupHideOpenParents')
    // createColsFromColDefs (recreateColumnDefs, setColumnsDefs),
    // setPivotMode, applyColumnState,
    // functionColsService.setPrimaryColList, functionColsService.updatePrimaryColList,
    // pivotResultCols.setPivotResultCols
    refreshCols(newColDefs) {
        if (!this.colDefCols) {
            return;
        }
        const prevColTree = this.cols?.tree;
        this.saveColOrder();
        const { autoColSvc, selectionColSvc, rowNumbersSvc, quickFilter, pivotResultCols, showRowGroupCols, rowAutoHeight, visibleCols, colViewport, eventSvc, } = this.beans;
        const cols = this.selectCols(pivotResultCols, this.colDefCols);
        this.createColumnsForService([autoColSvc, selectionColSvc, rowNumbersSvc], cols);
        const shouldSortNewColDefs = (0, gridOptionsUtils_1._shouldMaintainColumnOrder)(this.gos, this.showingPivotResult);
        if (!newColDefs || shouldSortNewColDefs) {
            this.restoreColOrder(cols);
        }
        this.positionLockedCols(cols);
        showRowGroupCols?.refresh();
        quickFilter?.refreshCols();
        this.setColSpanActive();
        rowAutoHeight?.setAutoHeightActive(cols);
        // make sure any part of the gui that tries to draw, eg the header,
        // will get empty lists of columns rather than stale columns.
        // for example, the header will received gridColumnsChanged event, so will try and draw,
        // but it will draw successfully when it acts on the virtualColumnsChanged event
        visibleCols.clear();
        colViewport.clear();
        const dispatchChangedEvent = !(0, array_1._areEqual)(prevColTree, this.cols.tree);
        if (dispatchChangedEvent) {
            eventSvc.dispatchEvent({
                type: 'gridColumnsChanged',
            });
        }
    }
    createColumnsForService(services, cols) {
        for (const service of services) {
            if (!service) {
                continue;
            }
            service.createColumns(cols, (updateOrder) => {
                this.lastOrder = updateOrder(this.lastOrder);
                this.lastPivotOrder = updateOrder(this.lastPivotOrder);
            });
            service.addColumns(cols);
        }
    }
    selectCols(pivotResultColsSvc, colDefCols) {
        const pivotResultCols = pivotResultColsSvc?.getPivotResultCols() ?? null;
        this.showingPivotResult = pivotResultCols != null;
        const { map, list, tree, treeDepth } = pivotResultCols ?? colDefCols;
        this.cols = {
            list: list.slice(),
            map: { ...map },
            tree: tree.slice(),
            treeDepth,
        };
        if (pivotResultCols) {
            // If the current columns are the same or a subset of the previous
            // we keep the previous order, otherwise we go back to the order the pivot
            // cols are generated in
            const hasSameColumns = pivotResultCols.list.some((col) => this.cols?.map[col.getColId()] !== undefined);
            if (!hasSameColumns) {
                this.lastPivotOrder = null;
            }
        }
        return this.cols;
    }
    getColsToShow() {
        if (!this.cols) {
            return [];
        }
        // pivot mode is on, but we are not pivoting, so we only
        // show columns we are aggregating on
        const showAutoGroupAndValuesOnly = this.isPivotMode() && !this.showingPivotResult;
        const valueColumns = this.beans.valueColsSvc?.columns;
        const res = this.cols.list.filter((col) => {
            const isAutoGroupCol = (0, columnUtils_1.isColumnGroupAutoCol)(col);
            if (showAutoGroupAndValuesOnly) {
                const isValueCol = valueColumns?.includes(col);
                return isAutoGroupCol || isValueCol;
            }
            else {
                // keep col if a) it's auto-group or b) it's visible
                return isAutoGroupCol || col.isVisible();
            }
        });
        return res;
    }
    // on events 'groupDisplayType', 'treeData', 'treeDataDisplayType', 'groupHideOpenParents'
    refreshAll(source) {
        if (!this.ready) {
            return;
        }
        this.refreshCols(false);
        this.beans.visibleCols.refresh(source);
    }
    setColsVisible(keys, visible = false, source) {
        (0, columnStateUtils_1._applyColumnState)(this.beans, {
            state: keys.map((key) => ({
                colId: typeof key === 'string' ? key : key.getColId(),
                hide: !visible,
            })),
        }, source);
    }
    /**
     * Restores provided columns order to the previous order in this.lastPivotOrder / this.lastOrder
     * If columns are not in the last order:
     *  - Check column groups, and apply column after the last column in the lowest shared group
     *  - If no sibling is found, apply the column at the end of the cols
     */
    restoreColOrder(cols) {
        const lastOrder = this.showingPivotResult ? this.lastPivotOrder : this.lastOrder;
        if (!lastOrder) {
            return;
        }
        // get the cols present in both new list and last order, according to the last order
        const preservedOrder = lastOrder.filter((col) => cols.map[col.getId()] != null);
        // if no cols in last order are in the new, then order is already correct
        if (preservedOrder.length === 0) {
            return;
        }
        // if after removing all the cols that are not in the new set, we have no cols left,
        // then we don't need to do anything further, as the new order is correct.
        if (preservedOrder.length === cols.list.length) {
            cols.list = preservedOrder;
            return;
        }
        const hasSiblings = (col) => {
            const ancestor = col.getOriginalParent();
            if (!ancestor) {
                return false;
            }
            const children = ancestor.getChildren();
            if (children.length > 1) {
                return true;
            }
            return hasSiblings(ancestor);
        };
        // if none of the preserved cols have siblings; shortcut, as all new cols can be added to the end
        // this is a common scenario due to generated cols.
        if (!preservedOrder.some((col) => hasSiblings(col))) {
            const preservedOrderSet = new Set(preservedOrder);
            for (const col of cols.list) {
                if (!preservedOrderSet.has(col)) {
                    preservedOrder.push(col);
                }
            }
            cols.list = preservedOrder;
            return;
        }
        // create map of known col positions and their indices
        const colPositionMap = new Map();
        for (let i = 0; i < preservedOrder.length; i++) {
            const col = preservedOrder[i];
            colPositionMap.set(col, i);
        }
        // find any cols that have been introduced that are not in the last order
        const additionalCols = cols.list.filter((col) => !colPositionMap.has(col));
        // no additional cols to be inserted, probably means cols were removed, but preserved order is correct.
        if (additionalCols.length === 0) {
            cols.list = preservedOrder;
            return;
        }
        // Function finds the sibling with the lowest shared parent and highest index in last order
        const getPreviousSibling = (col, group) => {
            const parent = group ? group.getOriginalParent() : col.getOriginalParent();
            if (!parent) {
                return null;
            }
            let highestIdx = null;
            let highestSibling = null;
            for (const child of parent.getChildren()) {
                // shortcut - skip the group that has already been processed
                if (child === group || child === col) {
                    continue;
                }
                if (child instanceof agColumn_1.AgColumn) {
                    const colIdx = colPositionMap.get(child);
                    // if col does not exist in last order, skip
                    if (colIdx == null) {
                        continue;
                    }
                    if (highestIdx == null || highestIdx < colIdx) {
                        highestIdx = colIdx;
                        highestSibling = child;
                    }
                    continue;
                }
                child.forEachLeafColumn((leafCol) => {
                    const colIdx = colPositionMap.get(leafCol);
                    // if col does not exist in last order, skip
                    if (colIdx == null) {
                        return;
                    }
                    if (highestIdx == null || highestIdx < colIdx) {
                        highestIdx = colIdx;
                        highestSibling = leafCol;
                    }
                });
            }
            if (highestSibling == null) {
                return getPreviousSibling(col, parent);
            }
            return highestSibling;
        };
        // array of cols that have no siblings in the last order, to be added at the tail of the results
        const noSiblingsAvailable = [];
        // map is keyed by cols in last order, and values are the cols that should be added after them
        // in results array
        const previousSiblingPosMap = new Map();
        // for each new col, find the col it needs inserted after and store for when array is constructed
        for (const col of additionalCols) {
            const prevSiblingIdx = getPreviousSibling(col, null);
            if (prevSiblingIdx == null) {
                noSiblingsAvailable.push(col);
                continue;
            }
            const prev = previousSiblingPosMap.get(prevSiblingIdx);
            if (prev === undefined) {
                previousSiblingPosMap.set(prevSiblingIdx, col);
            }
            else if (Array.isArray(prev)) {
                prev.push(col);
            }
            else {
                // if we have a single col, then we need to add the new col to the array
                previousSiblingPosMap.set(prevSiblingIdx, [prev, col]);
            }
        }
        // the following code starts at the tail of the array and works backwards.
        // first it applies all of the cols with no siblings (so no location in last order)
        // then it works backwards through the preserved order - when a col has siblings, it adds
        // them to the array and then adds the col itself.
        const result = new Array(cols.list.length);
        let resultPointer = result.length - 1;
        // work backwards, first adding no siblings to end
        for (let i = noSiblingsAvailable.length - 1; i >= 0; i--) {
            result[resultPointer--] = noSiblingsAvailable[i];
        }
        for (let i = preservedOrder.length - 1; i >= 0; i--) {
            const nextCol = preservedOrder[i];
            const extraCols = previousSiblingPosMap.get(nextCol);
            if (extraCols) {
                if (Array.isArray(extraCols)) {
                    // add the extra cols backwards.
                    for (let x = extraCols.length - 1; x >= 0; x--) {
                        const col = extraCols[x];
                        result[resultPointer--] = col;
                    }
                }
                else {
                    result[resultPointer--] = extraCols;
                }
            }
            result[resultPointer--] = nextCol;
        }
        cols.list = result;
    }
    positionLockedCols(cols) {
        cols.list = (0, columnMoveUtils_1.placeLockedColumns)(cols.list, this.gos);
    }
    saveColOrder() {
        if (this.showingPivotResult) {
            this.lastPivotOrder = this.cols?.list ?? null;
        }
        else {
            this.lastOrder = this.cols?.list ?? null;
        }
    }
    getColumnDefs() {
        return this.colDefCols
            ? this.beans.colDefFactory?.getColumnDefs(this.colDefCols.list, this.showingPivotResult, this.lastOrder, this.cols?.list ?? [])
            : undefined;
    }
    setColSpanActive() {
        this.colSpanActive = !!this.cols?.list.some((col) => col.getColDef().colSpan != null);
    }
    isPivotMode() {
        return this.pivotMode;
    }
    setPivotMode(pivotMode, source) {
        if (pivotMode === this.pivotMode) {
            return;
        }
        this.pivotMode = pivotMode;
        if (!this.ready) {
            return;
        }
        // we need to update grid columns to cover the scenario where user has groupDisplayType = 'custom', as
        // this means we don't use auto group column UNLESS we are in pivot mode (it's mandatory in pivot mode),
        // so need to updateCols() to check it autoGroupCol needs to be added / removed
        this.refreshCols(false);
        const { visibleCols, eventSvc } = this.beans;
        visibleCols.refresh(source);
        eventSvc.dispatchEvent({
            type: 'columnPivotModeChanged',
        });
    }
    // + clientSideRowModel
    isPivotActive() {
        const pivotColumns = this.beans.pivotColsSvc?.columns;
        return this.pivotMode && !!pivotColumns?.length;
    }
    // called when dataTypes change
    recreateColumnDefs(e) {
        if (!this.cols) {
            return;
        }
        // if we aren't going to force, update the auto cols in place
        this.beans.autoColSvc?.updateColumns(e);
        const source = (0, columnUtils_1._convertColumnEventSourceType)(e.source);
        this.createColsFromColDefs(source);
    }
    setColumnDefs(columnDefs, source) {
        this.colDefs = columnDefs;
        this.createColsFromColDefs(source);
    }
    destroy() {
        (0, columnUtils_1._destroyColumnTree)(this.beans, this.colDefCols?.tree);
        super.destroy();
    }
    getColTree() {
        return this.cols?.tree ?? [];
    }
    // + columnSelectPanel
    getColDefColTree() {
        return this.colDefCols?.tree ?? [];
    }
    // + clientSideRowController -> sorting, building quick filter text
    // + headerRenderer -> sorting (clearing icon)
    getColDefCols() {
        return this.colDefCols?.list ?? null;
    }
    // + moveColumnController
    getCols() {
        return this.cols?.list ?? [];
    }
    forAllCols(callback) {
        const { pivotResultCols, autoColSvc, selectionColSvc } = this.beans;
        (0, array_1._forAll)(this.colDefCols?.list, callback);
        (0, array_1._forAll)(autoColSvc?.columns?.list, callback);
        (0, array_1._forAll)(selectionColSvc?.columns?.list, callback);
        (0, array_1._forAll)(pivotResultCols?.getPivotResultCols()?.list, callback);
    }
    getColsForKeys(keys) {
        if (!keys) {
            return [];
        }
        return keys.map((key) => this.getCol(key)).filter((col) => col != null);
    }
    getColDefCol(key) {
        if (!this.colDefCols?.list) {
            return null;
        }
        return this.getColFromCollection(key, this.colDefCols);
    }
    getCol(key) {
        if (key == null) {
            return null;
        }
        return this.getColFromCollection(key, this.cols);
    }
    /**
     * Get column exclusively by ID.
     *
     * Note getCol/getColFromCollection have poor performance when col has been removed.
     */
    getColById(key) {
        return this.cols?.map[key] ?? null;
    }
    getColFromCollection(key, cols) {
        if (cols == null) {
            return null;
        }
        const { map, list } = cols;
        // most of the time this method gets called the key is a string, so we put this shortcut in
        // for performance reasons, to see if we can match for ID (it doesn't do auto columns, that's done below)
        if (typeof key == 'string' && map[key]) {
            return map[key];
        }
        for (let i = 0; i < list.length; i++) {
            if ((0, columnUtils_1._columnsMatch)(list[i], key)) {
                return list[i];
            }
        }
        return this.beans.autoColSvc?.getColumn(key) ?? this.beans.selectionColSvc?.getColumn(key) ?? null;
    }
}
exports.ColumnModel = ColumnModel;


/***/ }),

/***/ 2027:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnApiModule = exports.ColumnFlexModule = exports.DataTypeModule = void 0;
const cellRendererModule_1 = __webpack_require__(7358);
const version_1 = __webpack_require__(7205);
const columnApi_1 = __webpack_require__(1144);
const columnDefFactory_1 = __webpack_require__(4604);
const columnFlexService_1 = __webpack_require__(2849);
const dataTypeService_1 = __webpack_require__(6350);
/**
 * @internal
 */
exports.DataTypeModule = {
    moduleName: 'DataType',
    version: version_1.VERSION,
    beans: [dataTypeService_1.DataTypeService],
    dependsOn: [cellRendererModule_1.CheckboxCellRendererModule],
};
/**
 * @internal
 */
exports.ColumnFlexModule = {
    moduleName: 'ColumnFlex',
    version: version_1.VERSION,
    beans: [columnFlexService_1.ColumnFlexService],
};
/**
 * @feature Columns
 */
exports.ColumnApiModule = {
    moduleName: 'ColumnApi',
    version: version_1.VERSION,
    beans: [columnDefFactory_1.ColumnDefFactory],
    apiFunctions: {
        getColumnDef: columnApi_1.getColumnDef,
        getDisplayNameForColumn: columnApi_1.getDisplayNameForColumn,
        getColumn: columnApi_1.getColumn,
        getColumns: columnApi_1.getColumns,
        applyColumnState: columnApi_1.applyColumnState,
        getColumnState: columnApi_1.getColumnState,
        resetColumnState: columnApi_1.resetColumnState,
        isPinning: columnApi_1.isPinning,
        isPinningLeft: columnApi_1.isPinningLeft,
        isPinningRight: columnApi_1.isPinningRight,
        getDisplayedColAfter: columnApi_1.getDisplayedColAfter,
        getDisplayedColBefore: columnApi_1.getDisplayedColBefore,
        setColumnsVisible: columnApi_1.setColumnsVisible,
        setColumnsPinned: columnApi_1.setColumnsPinned,
        getAllGridColumns: columnApi_1.getAllGridColumns,
        getDisplayedLeftColumns: columnApi_1.getDisplayedLeftColumns,
        getDisplayedCenterColumns: columnApi_1.getDisplayedCenterColumns,
        getDisplayedRightColumns: columnApi_1.getDisplayedRightColumns,
        getAllDisplayedColumns: columnApi_1.getAllDisplayedColumns,
        getAllDisplayedVirtualColumns: columnApi_1.getAllDisplayedVirtualColumns,
        getColumnDefs: columnApi_1.getColumnDefs,
    },
};


/***/ }),

/***/ 8997:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnNameService = exports._camelCaseToHumanText = void 0;
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
/**
 * Converts a camelCase string into startCase
 * @param {string} camelCase
 * @returns {string}
 */
function _camelCaseToHumanText(camelCase) {
    if (!camelCase || camelCase == null) {
        return null;
    }
    // either split on a lowercase followed by uppercase ie  asHereTo -> as Here To
    const rex = /([a-z])([A-Z])/g;
    // or starts with uppercase and we take all expect the last which is assumed to be part of next word if followed by lowercase HEREToThere -> HERE To There
    const rexCaps = /([A-Z]+)([A-Z])([a-z])/g;
    const words = camelCase.replace(rex, '$1 $2').replace(rexCaps, '$1 $2$3').replace(/\./g, ' ').split(' ');
    return words
        .map((word) => word.substring(0, 1).toUpperCase() + (word.length > 1 ? word.substring(1, word.length) : ''))
        .join(' ');
}
exports._camelCaseToHumanText = _camelCaseToHumanText;
class ColumnNameService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colNames';
    }
    getDisplayNameForColumn(column, location, includeAggFunc = false) {
        if (!column) {
            return null;
        }
        const headerName = this.getHeaderName(column.getColDef(), column, null, null, location);
        const { aggColNameSvc } = this.beans;
        if (includeAggFunc && aggColNameSvc) {
            return aggColNameSvc.getHeaderName(column, headerName);
        }
        return headerName;
    }
    getDisplayNameForProvidedColumnGroup(columnGroup, providedColumnGroup, location) {
        const colGroupDef = providedColumnGroup?.getColGroupDef();
        if (colGroupDef) {
            return this.getHeaderName(colGroupDef, null, columnGroup, providedColumnGroup, location);
        }
        return null;
    }
    getDisplayNameForColumnGroup(columnGroup, location) {
        return this.getDisplayNameForProvidedColumnGroup(columnGroup, columnGroup.getProvidedColumnGroup(), location);
    }
    // location is where the column is going to appear, ie who is calling us
    getHeaderName(colDef, column, columnGroup, providedColumnGroup, location) {
        const headerValueGetter = colDef.headerValueGetter;
        if (headerValueGetter) {
            const params = (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
                colDef: colDef,
                column: column,
                columnGroup: columnGroup,
                providedColumnGroup: providedColumnGroup,
                location: location,
            });
            if (typeof headerValueGetter === 'function') {
                // valueGetter is a function, so just call it
                return headerValueGetter(params);
            }
            else if (typeof headerValueGetter === 'string') {
                // valueGetter is an expression, so execute the expression
                return this.beans.expressionSvc?.evaluate(headerValueGetter, params) ?? null;
            }
            return '';
        }
        else if (colDef.headerName != null) {
            return colDef.headerName;
        }
        else if (colDef.field) {
            return _camelCaseToHumanText(colDef.field);
        }
        return '';
    }
}
exports.ColumnNameService = ColumnNameService;


/***/ }),

/***/ 2885:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getColumnStateFromColDef = exports._getColumnState = exports._compareColumnStatesAndDispatchEvents = exports._resetColumnState = exports._applyColumnState = void 0;
const columnMoveUtils_1 = __webpack_require__(3505);
const gridOptionsUtils_1 = __webpack_require__(7274);
const array_1 = __webpack_require__(1502);
const generic_1 = __webpack_require__(4422);
const logging_1 = __webpack_require__(7764);
const columnEventUtils_1 = __webpack_require__(2934);
const columnFactoryUtils_1 = __webpack_require__(2716);
const columnUtils_1 = __webpack_require__(3146);
function _applyColumnState(beans, params, source) {
    const { colModel, rowGroupColsSvc, pivotColsSvc, autoColSvc, selectionColSvc, colAnimation, visibleCols, pivotResultCols, environment, valueColsSvc, eventSvc, gos, } = beans;
    const providedCols = colModel.getColDefCols() ?? [];
    const selectionCols = selectionColSvc?.getColumns();
    if (!providedCols?.length && !selectionCols?.length) {
        return false;
    }
    if (params?.state && !params.state.forEach) {
        // state is not an array
        (0, logging_1._warn)(32);
        return false;
    }
    const syncColumnWithStateItem = (column, stateItem, rowGroupIndexes, pivotIndexes, autoCol) => {
        if (!column) {
            return;
        }
        const getValue = (0, columnUtils_1.getValueFactory)(stateItem, params.defaultState);
        const flex = getValue('flex').value1;
        (0, columnFactoryUtils_1.updateSomeColumnState)(beans, column, getValue('hide').value1, getValue('sort').value1, getValue('sortIndex').value1, getValue('pinned').value1, flex, source);
        // if flex is null or undefined, fall back to setting width
        if (flex == null) {
            // if no flex, then use width if it's there
            const width = getValue('width').value1;
            if (width != null) {
                // if width provided and valid, use it, otherwise stick with the old width
                const minColWidth = column.getColDef().minWidth ?? environment.getDefaultColumnMinWidth();
                if (minColWidth != null && width >= minColWidth) {
                    column.setActualWidth(width, source);
                }
            }
        }
        // we do not do aggFunc, rowGroup or pivot for auto cols or secondary cols
        if (autoCol || !column.isPrimary()) {
            return;
        }
        valueColsSvc?.syncColumnWithState(column, source, getValue);
        rowGroupColsSvc?.syncColumnWithState(column, source, getValue, rowGroupIndexes);
        pivotColsSvc?.syncColumnWithState(column, source, getValue, pivotIndexes);
    };
    const applyStates = (states, existingColumns, getById) => {
        const dispatchEventsFunc = _compareColumnStatesAndDispatchEvents(beans, source);
        // at the end below, this list will have all columns we got no state for
        const columnsWithNoState = existingColumns.slice();
        const rowGroupIndexes = {};
        const pivotIndexes = {};
        const autoColStates = [];
        const selectionColStates = [];
        // If pivoting is modified, these are the states we try to reapply after
        // the pivot result cols are re-generated
        const unmatchedAndAutoStates = [];
        let unmatchedCount = 0;
        const previousRowGroupCols = rowGroupColsSvc?.columns.slice() ?? [];
        const previousPivotCols = pivotColsSvc?.columns.slice() ?? [];
        states.forEach((state) => {
            const colId = state.colId;
            // auto group columns are re-created so deferring syncing with ColumnState
            const isAutoGroupColumn = colId.startsWith(columnUtils_1.GROUP_AUTO_COLUMN_ID);
            if (isAutoGroupColumn) {
                autoColStates.push(state);
                unmatchedAndAutoStates.push(state);
                return;
            }
            if ((0, columnUtils_1.isColumnSelectionCol)(colId)) {
                selectionColStates.push(state);
                unmatchedAndAutoStates.push(state);
                return;
            }
            const column = getById(colId);
            if (!column) {
                unmatchedAndAutoStates.push(state);
                unmatchedCount += 1;
            }
            else {
                syncColumnWithStateItem(column, state, rowGroupIndexes, pivotIndexes, false);
                (0, array_1._removeFromArray)(columnsWithNoState, column);
            }
        });
        // anything left over, we got no data for, so add in the column as non-value, non-rowGroup and hidden
        const applyDefaultsFunc = (col) => syncColumnWithStateItem(col, null, rowGroupIndexes, pivotIndexes, false);
        columnsWithNoState.forEach(applyDefaultsFunc);
        rowGroupColsSvc?.sortColumns(comparatorByIndex.bind(rowGroupColsSvc, rowGroupIndexes, previousRowGroupCols));
        pivotColsSvc?.sortColumns(comparatorByIndex.bind(pivotColsSvc, pivotIndexes, previousPivotCols));
        colModel.refreshCols(false);
        const syncColStates = (getCol, colStates, columns = []) => {
            colStates.forEach((stateItem) => {
                const col = getCol(stateItem.colId);
                (0, array_1._removeFromArray)(columns, col);
                syncColumnWithStateItem(col, stateItem, null, null, true);
            });
            columns.forEach(applyDefaultsFunc);
        };
        // sync newly created auto group columns with ColumnState
        syncColStates((colId) => autoColSvc?.getColumn(colId) ?? null, autoColStates, autoColSvc?.getColumns()?.slice());
        // sync selection columns with ColumnState
        syncColStates((colId) => selectionColSvc?.getColumn(colId) ?? null, selectionColStates, selectionColSvc?.getColumns()?.slice());
        orderLiveColsLikeState(params, colModel, gos);
        visibleCols.refresh(source);
        eventSvc.dispatchEvent({
            type: 'columnEverythingChanged',
            source,
        });
        dispatchEventsFunc(); // Will trigger pivot result col changes if pivoting modified
        return { unmatchedAndAutoStates, unmatchedCount };
    };
    colAnimation?.start();
    let { unmatchedAndAutoStates, unmatchedCount } = applyStates(params.state || [], providedCols, (id) => colModel.getColDefCol(id));
    // If there are still states left over, see if we can apply them to newly generated
    // pivot result cols or auto cols. Also if defaults exist, ensure they are applied to pivot resul cols
    if (unmatchedAndAutoStates.length > 0 || (0, generic_1._exists)(params.defaultState)) {
        const pivotResultColsList = pivotResultCols?.getPivotResultCols()?.list ?? [];
        unmatchedCount = applyStates(unmatchedAndAutoStates, pivotResultColsList, (id) => pivotResultCols?.getPivotResultCol(id) ?? null).unmatchedCount;
    }
    colAnimation?.finish();
    return unmatchedCount === 0; // Successful if no states unaccounted for
}
exports._applyColumnState = _applyColumnState;
function _resetColumnState(beans, source) {
    const { colModel, autoColSvc, selectionColSvc, eventSvc, gos } = beans;
    const primaryCols = colModel.getColDefCols();
    if (!primaryCols?.length) {
        return;
    }
    // NOTE = there is one bug here that no customer has noticed - if a column has colDef.lockPosition,
    // this is ignored  below when ordering the cols. to work, we should always put lockPosition cols first.
    // As a work around, developers should just put lockPosition columns first in their colDef list.
    // we can't use 'allColumns' as the order might of messed up, so get the primary ordered list
    const primaryColumnTree = colModel.getColDefColTree();
    const primaryColumns = (0, columnUtils_1._getColumnsFromTree)(primaryColumnTree);
    const columnStates = [];
    // we start at 1000, so if user has mix of rowGroup and group specified, it will work with both.
    // eg IF user has ColA.rowGroupIndex=0, ColB.rowGroupIndex=1, ColC.rowGroup=true,
    // THEN result will be ColA.rowGroupIndex=0, ColB.rowGroupIndex=1, ColC.rowGroup=1000
    let letRowGroupIndex = 1000;
    let letPivotIndex = 1000;
    const addColState = (col) => {
        const stateItem = getColumnStateFromColDef(col);
        if ((0, generic_1._missing)(stateItem.rowGroupIndex) && stateItem.rowGroup) {
            stateItem.rowGroupIndex = letRowGroupIndex++;
        }
        if ((0, generic_1._missing)(stateItem.pivotIndex) && stateItem.pivot) {
            stateItem.pivotIndex = letPivotIndex++;
        }
        columnStates.push(stateItem);
    };
    autoColSvc?.getColumns()?.forEach(addColState);
    selectionColSvc?.getColumns()?.forEach(addColState);
    primaryColumns?.forEach(addColState);
    // apply state before ordering, as changes in row grouping will introduce new columns
    _applyColumnState(beans, { state: columnStates }, source);
    const autoCols = autoColSvc?.getColumns() ?? [];
    const selectionCols = selectionColSvc?.getColumns() ?? [];
    const orderedCols = [...selectionCols, ...autoCols, ...primaryCols];
    const orderedColState = orderedCols.map((col) => ({ colId: col.colId }));
    // apply the new order when all the cols have been created & are available
    _applyColumnState(beans, { state: orderedColState, applyOrder: true }, source);
    eventSvc.dispatchEvent((0, gridOptionsUtils_1._addGridCommonParams)(gos, { type: 'columnsReset', source }));
}
exports._resetColumnState = _resetColumnState;
/**
 * calculates what events to fire between column state changes. gets used when:
 * a) apply column state
 * b) apply new column definitions (so changes from old cols)
 */
function _compareColumnStatesAndDispatchEvents(beans, source) {
    const { rowGroupColsSvc, pivotColsSvc, valueColsSvc, colModel, sortSvc, eventSvc } = beans;
    const startState = {
        rowGroupColumns: rowGroupColsSvc?.columns.slice() ?? [],
        pivotColumns: pivotColsSvc?.columns.slice() ?? [],
        valueColumns: valueColsSvc?.columns.slice() ?? [],
    };
    const columnStateBefore = _getColumnState(beans);
    const columnStateBeforeMap = {};
    columnStateBefore.forEach((col) => {
        columnStateBeforeMap[col.colId] = col;
    });
    return () => {
        // dispatches generic ColumnEvents where all columns are returned rather than what has changed
        const dispatchWhenListsDifferent = (eventType, colsBefore, colsAfter, idMapper) => {
            const beforeList = colsBefore.map(idMapper);
            const afterList = colsAfter.map(idMapper);
            const unchanged = (0, array_1._areEqual)(beforeList, afterList);
            if (unchanged) {
                return;
            }
            const changes = new Set(colsBefore);
            colsAfter.forEach((id) => {
                // if the first list had it, delete it, as it's unchanged.
                if (!changes.delete(id)) {
                    // if the second list has it, and first doesn't, add it.
                    changes.add(id);
                }
            });
            const changesArr = [...changes];
            eventSvc.dispatchEvent({
                type: eventType,
                columns: changesArr,
                column: changesArr.length === 1 ? changesArr[0] : null,
                source: source,
            });
        };
        // determines which columns have changed according to supplied predicate
        const getChangedColumns = (changedPredicate) => {
            const changedColumns = [];
            colModel.forAllCols((column) => {
                const colStateBefore = columnStateBeforeMap[column.getColId()];
                if (colStateBefore && changedPredicate(colStateBefore, column)) {
                    changedColumns.push(column);
                }
            });
            return changedColumns;
        };
        const columnIdMapper = (c) => c.getColId();
        dispatchWhenListsDifferent('columnRowGroupChanged', startState.rowGroupColumns, rowGroupColsSvc?.columns ?? [], columnIdMapper);
        dispatchWhenListsDifferent('columnPivotChanged', startState.pivotColumns, pivotColsSvc?.columns ?? [], columnIdMapper);
        const valueChangePredicate = (cs, c) => {
            const oldActive = cs.aggFunc != null;
            const activeChanged = oldActive != c.isValueActive();
            // we only check aggFunc if the agg is active
            const aggFuncChanged = oldActive && cs.aggFunc != c.getAggFunc();
            return activeChanged || aggFuncChanged;
        };
        const changedValues = getChangedColumns(valueChangePredicate);
        if (changedValues.length > 0) {
            (0, columnEventUtils_1.dispatchColumnChangedEvent)(eventSvc, 'columnValueChanged', changedValues, source);
        }
        const resizeChangePredicate = (cs, c) => cs.width != c.getActualWidth();
        (0, columnEventUtils_1.dispatchColumnResizedEvent)(eventSvc, getChangedColumns(resizeChangePredicate), true, source);
        const pinnedChangePredicate = (cs, c) => cs.pinned != c.getPinned();
        (0, columnEventUtils_1.dispatchColumnPinnedEvent)(eventSvc, getChangedColumns(pinnedChangePredicate), source);
        const visibilityChangePredicate = (cs, c) => cs.hide == c.isVisible();
        (0, columnEventUtils_1.dispatchColumnVisibleEvent)(eventSvc, getChangedColumns(visibilityChangePredicate), source);
        const sortChangePredicate = (cs, c) => cs.sort != c.getSort() || cs.sortIndex != c.getSortIndex();
        const changedColumns = getChangedColumns(sortChangePredicate);
        if (changedColumns.length > 0) {
            sortSvc?.dispatchSortChangedEvents(source, changedColumns);
        }
        const colStateAfter = _getColumnState(beans);
        // special handling for moved column events
        normaliseColumnMovedEventForColumnState(columnStateBefore, colStateAfter, source, colModel, eventSvc);
    };
}
exports._compareColumnStatesAndDispatchEvents = _compareColumnStatesAndDispatchEvents;
function _getColumnState(beans) {
    const { colModel, rowGroupColsSvc, pivotColsSvc } = beans;
    const primaryCols = colModel.getColDefCols();
    if ((0, generic_1._missing)(primaryCols) || !colModel.isAlive()) {
        return [];
    }
    const rowGroupColumns = rowGroupColsSvc?.columns;
    const pivotColumns = pivotColsSvc?.columns;
    const res = [];
    const createStateItemFromColumn = (column) => {
        const rowGroupIndex = column.isRowGroupActive() && rowGroupColumns ? rowGroupColumns.indexOf(column) : null;
        const pivotIndex = column.isPivotActive() && pivotColumns ? pivotColumns.indexOf(column) : null;
        const aggFunc = column.isValueActive() ? column.getAggFunc() : null;
        const sort = column.getSort() != null ? column.getSort() : null;
        const sortIndex = column.getSortIndex() != null ? column.getSortIndex() : null;
        res.push({
            colId: column.getColId(),
            width: column.getActualWidth(),
            hide: !column.isVisible(),
            pinned: column.getPinned(),
            sort,
            sortIndex,
            aggFunc,
            rowGroup: column.isRowGroupActive(),
            rowGroupIndex,
            pivot: column.isPivotActive(),
            pivotIndex: pivotIndex,
            flex: column.getFlex() ?? null,
        });
    };
    colModel.forAllCols((col) => createStateItemFromColumn(col));
    // for fast looking, store the index of each column
    const colIdToGridIndexMap = new Map(colModel.getCols().map((col, index) => [col.getColId(), index]));
    res.sort((itemA, itemB) => {
        const posA = colIdToGridIndexMap.has(itemA.colId) ? colIdToGridIndexMap.get(itemA.colId) : -1;
        const posB = colIdToGridIndexMap.has(itemB.colId) ? colIdToGridIndexMap.get(itemB.colId) : -1;
        return posA - posB;
    });
    return res;
}
exports._getColumnState = _getColumnState;
function getColumnStateFromColDef(column) {
    const getValueOrNull = (a, b) => (a != null ? a : b != null ? b : null);
    const colDef = column.getColDef();
    const sort = getValueOrNull(colDef.sort, colDef.initialSort);
    const sortIndex = getValueOrNull(colDef.sortIndex, colDef.initialSortIndex);
    const hide = getValueOrNull(colDef.hide, colDef.initialHide);
    const pinned = getValueOrNull(colDef.pinned, colDef.initialPinned);
    const width = getValueOrNull(colDef.width, colDef.initialWidth);
    const flex = getValueOrNull(colDef.flex, colDef.initialFlex);
    let rowGroupIndex = getValueOrNull(colDef.rowGroupIndex, colDef.initialRowGroupIndex);
    let rowGroup = getValueOrNull(colDef.rowGroup, colDef.initialRowGroup);
    if (rowGroupIndex == null && (rowGroup == null || rowGroup == false)) {
        rowGroupIndex = null;
        rowGroup = null;
    }
    let pivotIndex = getValueOrNull(colDef.pivotIndex, colDef.initialPivotIndex);
    let pivot = getValueOrNull(colDef.pivot, colDef.initialPivot);
    if (pivotIndex == null && (pivot == null || pivot == false)) {
        pivotIndex = null;
        pivot = null;
    }
    const aggFunc = getValueOrNull(colDef.aggFunc, colDef.initialAggFunc);
    return {
        colId: column.getColId(),
        sort,
        sortIndex,
        hide,
        pinned,
        width,
        flex,
        rowGroup,
        rowGroupIndex,
        pivot,
        pivotIndex,
        aggFunc,
    };
}
exports.getColumnStateFromColDef = getColumnStateFromColDef;
function orderLiveColsLikeState(params, colModel, gos) {
    if (!params.applyOrder || !params.state) {
        return;
    }
    const colIds = [];
    params.state.forEach((item) => {
        if (item.colId != null) {
            colIds.push(item.colId);
        }
    });
    sortColsLikeKeys(colModel.cols, colIds, colModel, gos);
}
function sortColsLikeKeys(cols, colIds, colModel, gos) {
    if (cols == null) {
        return;
    }
    let newOrder = [];
    const processedColIds = {};
    colIds.forEach((colId) => {
        if (processedColIds[colId]) {
            return;
        }
        const col = cols.map[colId];
        if (col) {
            newOrder.push(col);
            processedColIds[colId] = true;
        }
    });
    // add in all other columns
    let autoGroupInsertIndex = 0;
    cols.list.forEach((col) => {
        const colId = col.getColId();
        const alreadyProcessed = processedColIds[colId] != null;
        if (alreadyProcessed) {
            return;
        }
        const isAutoGroupCol = colId.startsWith(columnUtils_1.GROUP_AUTO_COLUMN_ID);
        if (isAutoGroupCol) {
            // auto group columns, if missing from state list, are added to the start.
            // it's common to have autoGroup missing, as grouping could be on by default
            // on a column, but the user could of since removed the grouping via the UI.
            // if we don't inc the insert index, autoGroups will be inserted in reverse order
            newOrder.splice(autoGroupInsertIndex++, 0, col);
        }
        else {
            // normal columns, if missing from state list, are added at the end
            newOrder.push(col);
        }
    });
    // this is already done in updateCols, however we changed the order above (to match the order of the state
    // columns) so we need to do it again. we could of put logic into the order above to take into account fixed
    // columns, however if we did then we would have logic for updating fixed columns twice. reusing the logic here
    // is less sexy for the code here, but it keeps consistency.
    newOrder = (0, columnMoveUtils_1.placeLockedColumns)(newOrder, gos);
    if (!(0, columnMoveUtils_1.doesMovePassMarryChildren)(newOrder, colModel.getColTree())) {
        (0, logging_1._warn)(39);
        return;
    }
    cols.list = newOrder;
}
function normaliseColumnMovedEventForColumnState(colStateBefore, colStateAfter, source, colModel, eventSvc) {
    // we are only interested in columns that were both present and visible before and after
    const colStateAfterMapped = {};
    colStateAfter.forEach((s) => (colStateAfterMapped[s.colId] = s));
    // get id's of cols in both before and after lists
    const colsIntersectIds = {};
    colStateBefore.forEach((s) => {
        if (colStateAfterMapped[s.colId]) {
            colsIntersectIds[s.colId] = true;
        }
    });
    // filter state lists, so we only have cols that were present before and after
    const beforeFiltered = colStateBefore.filter((c) => colsIntersectIds[c.colId]);
    const afterFiltered = colStateAfter.filter((c) => colsIntersectIds[c.colId]);
    // see if any cols are in a different location
    const movedColumns = [];
    afterFiltered.forEach((csAfter, index) => {
        const csBefore = beforeFiltered && beforeFiltered[index];
        if (csBefore && csBefore.colId !== csAfter.colId) {
            const gridCol = colModel.getCol(csBefore.colId);
            if (gridCol) {
                movedColumns.push(gridCol);
            }
        }
    });
    if (!movedColumns.length) {
        return;
    }
    eventSvc.dispatchEvent({
        type: 'columnMoved',
        columns: movedColumns,
        column: movedColumns.length === 1 ? movedColumns[0] : null,
        finished: true,
        source,
    });
}
// sort the lists according to the indexes that were provided
const comparatorByIndex = (indexes, oldList, colA, colB) => {
    const indexA = indexes[colA.getId()];
    const indexB = indexes[colB.getId()];
    const aHasIndex = indexA != null;
    const bHasIndex = indexB != null;
    if (aHasIndex && bHasIndex) {
        // both a and b are new cols with index, so sort on index
        return indexA - indexB;
    }
    if (aHasIndex) {
        // a has an index, so it should be before a
        return -1;
    }
    if (bHasIndex) {
        // b has an index, so it should be before a
        return 1;
    }
    const oldIndexA = oldList.indexOf(colA);
    const oldIndexB = oldList.indexOf(colB);
    const aHasOldIndex = oldIndexA >= 0;
    const bHasOldIndex = oldIndexB >= 0;
    if (aHasOldIndex && bHasOldIndex) {
        // both a and b are old cols, so sort based on last order
        return oldIndexA - oldIndexB;
    }
    if (aHasOldIndex) {
        // a is old, b is new, so b is first
        return -1;
    }
    // this bit does matter, means both are new cols
    // but without index or that b is old and a is new
    return 1;
};


/***/ }),

/***/ 3146:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getValueFactory = exports._columnsMatch = exports._convertColumnEventSourceType = exports._updateColsMap = exports._areColIdsEqual = exports.convertColumnTypes = exports.isRowNumberCol = exports.isColumnSelectionCol = exports.isColumnGroupAutoCol = exports._destroyColumnTree = exports.getWidthOfColsInList = exports._getColumnsFromTree = exports.ROW_NUMBERS_COLUMN_ID = exports.SELECTION_COLUMN_ID = exports.GROUP_AUTO_COLUMN_ID = void 0;
const agColumn_1 = __webpack_require__(3355);
const agProvidedColumnGroup_1 = __webpack_require__(9409);
const array_1 = __webpack_require__(1502);
const generic_1 = __webpack_require__(4422);
const columnFactoryUtils_1 = __webpack_require__(2716);
exports.GROUP_AUTO_COLUMN_ID = 'ag-Grid-AutoColumn';
exports.SELECTION_COLUMN_ID = 'ag-Grid-SelectionColumn';
exports.ROW_NUMBERS_COLUMN_ID = 'ag-Grid-RowNumbersColumn';
// Possible candidate for reuse (alot of recursive traversal duplication)
function _getColumnsFromTree(rootColumns) {
    const result = [];
    const recursiveFindColumns = (childColumns) => {
        for (let i = 0; i < childColumns.length; i++) {
            const child = childColumns[i];
            if ((0, agColumn_1.isColumn)(child)) {
                result.push(child);
            }
            else if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
                recursiveFindColumns(child.getChildren());
            }
        }
    };
    recursiveFindColumns(rootColumns);
    return result;
}
exports._getColumnsFromTree = _getColumnsFromTree;
function getWidthOfColsInList(columnList) {
    return columnList.reduce((width, col) => width + col.getActualWidth(), 0);
}
exports.getWidthOfColsInList = getWidthOfColsInList;
function _destroyColumnTree(beans, oldTree, newTree) {
    const oldObjectsById = {};
    if (!oldTree) {
        return;
    }
    // add in all old columns to be destroyed
    (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, oldTree, (child) => {
        oldObjectsById[child.getInstanceId()] = child;
    });
    // however we don't destroy anything in the new tree. if destroying the grid, there is no new tree
    if (newTree) {
        (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, newTree, (child) => {
            oldObjectsById[child.getInstanceId()] = null;
        });
    }
    // what's left can be destroyed
    const colsToDestroy = Object.values(oldObjectsById).filter((item) => item != null);
    beans.context.destroyBeans(colsToDestroy);
}
exports._destroyColumnTree = _destroyColumnTree;
function isColumnGroupAutoCol(col) {
    const colId = col.getId();
    return colId.startsWith(exports.GROUP_AUTO_COLUMN_ID);
}
exports.isColumnGroupAutoCol = isColumnGroupAutoCol;
function isColumnSelectionCol(col) {
    const id = typeof col === 'string' ? col : 'getColId' in col ? col.getColId() : col.colId;
    return id?.startsWith(exports.SELECTION_COLUMN_ID) ?? false;
}
exports.isColumnSelectionCol = isColumnSelectionCol;
function isRowNumberCol(col) {
    const id = typeof col === 'string' ? col : 'getColId' in col ? col.getColId() : col.colId;
    return id?.startsWith(exports.ROW_NUMBERS_COLUMN_ID) ?? false;
}
exports.isRowNumberCol = isRowNumberCol;
function convertColumnTypes(type) {
    let typeKeys = [];
    if (type instanceof Array) {
        typeKeys = type;
    }
    else if (typeof type === 'string') {
        typeKeys = type.split(',');
    }
    return typeKeys;
}
exports.convertColumnTypes = convertColumnTypes;
function _areColIdsEqual(colsA, colsB) {
    return (0, array_1._areEqual)(colsA, colsB, (a, b) => a.getColId() === b.getColId());
}
exports._areColIdsEqual = _areColIdsEqual;
function _updateColsMap(cols) {
    cols.map = {};
    cols.list.forEach((col) => (cols.map[col.getId()] = col));
}
exports._updateColsMap = _updateColsMap;
function _convertColumnEventSourceType(source) {
    // unfortunately they do not match so need to perform conversion
    return source === 'gridOptionsUpdated' ? 'gridOptionsChanged' : source;
}
exports._convertColumnEventSourceType = _convertColumnEventSourceType;
function _columnsMatch(column, key) {
    const columnMatches = column === key;
    const colDefMatches = column.getColDef() === key;
    const idMatches = column.getColId() == key;
    return columnMatches || colDefMatches || idMatches;
}
exports._columnsMatch = _columnsMatch;
const getValueFactory = (stateItem, defaultState) => (key1, key2) => {
    const obj = {
        value1: undefined,
        value2: undefined,
    };
    let calculated = false;
    if (stateItem) {
        if (stateItem[key1] !== undefined) {
            obj.value1 = stateItem[key1];
            calculated = true;
        }
        if ((0, generic_1._exists)(key2) && stateItem[key2] !== undefined) {
            obj.value2 = stateItem[key2];
            calculated = true;
        }
    }
    if (!calculated && defaultState) {
        if (defaultState[key1] !== undefined) {
            obj.value1 = defaultState[key1];
        }
        if ((0, generic_1._exists)(key2) && defaultState[key2] !== undefined) {
            obj.value2 = defaultState[key2];
        }
    }
    return obj;
};
exports.getValueFactory = getValueFactory;


/***/ }),

/***/ 5034:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnViewportService = void 0;
const beanStub_1 = __webpack_require__(8731);
const agColumn_1 = __webpack_require__(3355);
const generic_1 = __webpack_require__(4422);
class ColumnViewportService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colViewport';
        // cols in center that are in the viewport
        this.colsWithinViewport = [];
        // same as colsWithinViewport, except we always include columns with headerAutoHeight
        this.headerColsWithinViewport = [];
        // A hash key to keep track of changes in viewport columns
        this.colsWithinViewportHash = '';
        // all columns & groups to be rendered, index by row.
        // used by header rows to get all items to render for that row.
        this.rowsOfHeadersToRenderLeft = {};
        this.rowsOfHeadersToRenderRight = {};
        this.rowsOfHeadersToRenderCenter = {};
    }
    wireBeans(beans) {
        this.visibleCols = beans.visibleCols;
        this.colModel = beans.colModel;
    }
    postConstruct() {
        this.suppressColumnVirtualisation = this.gos.get('suppressColumnVirtualisation');
    }
    setScrollPosition(scrollWidth, scrollPosition, afterScroll = false) {
        const { visibleCols } = this;
        const bodyWidthDirty = visibleCols.isBodyWidthDirty;
        const noChange = scrollWidth === this.scrollWidth && scrollPosition === this.scrollPosition && !bodyWidthDirty;
        if (noChange) {
            return;
        }
        this.scrollWidth = scrollWidth;
        this.scrollPosition = scrollPosition;
        // we need to call setVirtualViewportLeftAndRight() at least once after the body width changes,
        // as the viewport can stay the same, but in RTL, if body width changes, we need to work out the
        // virtual columns again
        visibleCols.isBodyWidthDirty = true;
        if (this.gos.get('enableRtl')) {
            const bodyWidth = visibleCols.bodyWidth;
            this.viewportLeft = bodyWidth - scrollPosition - scrollWidth;
            this.viewportRight = bodyWidth - scrollPosition;
        }
        else {
            this.viewportLeft = scrollPosition;
            this.viewportRight = scrollWidth + scrollPosition;
        }
        if (this.colModel.ready) {
            this.checkViewportColumns(afterScroll);
        }
    }
    getHeadersToRender(type, depth) {
        let result;
        switch (type) {
            case 'left':
                result = this.rowsOfHeadersToRenderLeft[depth];
                break;
            case 'right':
                result = this.rowsOfHeadersToRenderRight[depth];
                break;
            default:
                result = this.rowsOfHeadersToRenderCenter[depth];
                break;
        }
        return result || [];
    }
    extractViewportColumns() {
        const displayedColumnsCenter = this.visibleCols.centerCols;
        if (this.isColumnVirtualisationSuppressed()) {
            // no virtualisation, so don't filter
            this.colsWithinViewport = displayedColumnsCenter;
            this.headerColsWithinViewport = displayedColumnsCenter;
        }
        else {
            // filter out what should be visible
            this.colsWithinViewport = displayedColumnsCenter.filter(this.isColumnInRowViewport.bind(this));
            this.headerColsWithinViewport = displayedColumnsCenter.filter(this.isColumnInHeaderViewport.bind(this));
        }
    }
    isColumnVirtualisationSuppressed() {
        // When running within jsdom the viewportRight is always 0, so we need to return true to allow
        // tests to validate all the columns.
        return this.suppressColumnVirtualisation || this.viewportRight === 0;
    }
    clear(suppressHashClear) {
        this.rowsOfHeadersToRenderLeft = {};
        this.rowsOfHeadersToRenderRight = {};
        this.rowsOfHeadersToRenderCenter = {};
        if (!suppressHashClear) {
            this.colsWithinViewportHash = '';
        }
    }
    isColumnInHeaderViewport(col) {
        // for headers, we never filter out autoHeaderHeight columns, if calculating
        if (col.isAutoHeaderHeight() || isAnyParentAutoHeaderHeight(col)) {
            return true;
        }
        return this.isColumnInRowViewport(col);
    }
    isColumnInRowViewport(col) {
        // we never filter out autoHeight columns, as we need them in the DOM for calculating Auto Height
        if (col.isAutoHeight()) {
            return true;
        }
        const columnLeft = col.getLeft() || 0;
        const columnRight = columnLeft + col.getActualWidth();
        // adding 200 for buffer size, so some cols off viewport are rendered.
        // this helps horizontal scrolling so user rarely sees white space (unless
        // they scroll horizontally fast). however we are conservative, as the more
        // buffer the slower the vertical redraw speed
        const leftBounds = this.viewportLeft - 200;
        const rightBounds = this.viewportRight + 200;
        const columnToMuchLeft = columnLeft < leftBounds && columnRight < leftBounds;
        const columnToMuchRight = columnLeft > rightBounds && columnRight > rightBounds;
        return !columnToMuchLeft && !columnToMuchRight;
    }
    // used by Grid API only
    getViewportColumns() {
        const { leftCols, rightCols } = this.visibleCols;
        const res = this.colsWithinViewport.concat(leftCols).concat(rightCols);
        return res;
    }
    // + rowRenderer
    // if we are not column spanning, this just returns back the virtual centre columns,
    // however if we are column spanning, then different rows can have different virtual
    // columns, so we have to work out the list for each individual row.
    getColsWithinViewport(rowNode) {
        if (!this.colModel.colSpanActive) {
            return this.colsWithinViewport;
        }
        const emptySpaceBeforeColumn = (col) => {
            const left = col.getLeft();
            return (0, generic_1._exists)(left) && left > this.viewportLeft;
        };
        // if doing column virtualisation, then we filter based on the viewport.
        const inViewportCallback = this.isColumnVirtualisationSuppressed()
            ? undefined
            : this.isColumnInRowViewport.bind(this);
        const { visibleCols } = this;
        const displayedColumnsCenter = visibleCols.centerCols;
        return visibleCols.getColsForRow(rowNode, displayedColumnsCenter, inViewportCallback, emptySpaceBeforeColumn);
    }
    // checks what columns are currently displayed due to column virtualisation. dispatches an event
    // if the list of columns has changed.
    // + setColumnWidth(), setViewportPosition(), setColumnDefs(), sizeColumnsToFit()
    checkViewportColumns(afterScroll = false) {
        const viewportColumnsChanged = this.extractViewport();
        if (viewportColumnsChanged) {
            this.eventSvc.dispatchEvent({
                type: 'virtualColumnsChanged',
                afterScroll,
            });
        }
    }
    calculateHeaderRows() {
        // go through each group, see if any of it's cols are displayed, and if yes,
        // then this group is included
        this.clear(true);
        // for easy lookup when building the groups.
        const renderedColIds = {};
        const { leftCols, rightCols, treeLeft, treeRight, treeCenter } = this.visibleCols;
        const allRenderedCols = this.headerColsWithinViewport.concat(leftCols).concat(rightCols);
        allRenderedCols.forEach((col) => (renderedColIds[col.getId()] = true));
        const testGroup = (children, result, depth) => {
            let returnValue = false;
            for (let i = 0; i < children.length; i++) {
                // see if this item is within viewport
                const child = children[i];
                let addThisItem = false;
                if ((0, agColumn_1.isColumn)(child)) {
                    // for column, test if column is included
                    addThisItem = renderedColIds[child.getId()] === true;
                }
                else {
                    // if group, base decision on children
                    const columnGroup = child;
                    const displayedChildren = columnGroup.getDisplayedChildren();
                    if (displayedChildren) {
                        addThisItem = testGroup(displayedChildren, result, depth + 1);
                    }
                }
                if (addThisItem) {
                    returnValue = true;
                    if (!result[depth]) {
                        result[depth] = [];
                    }
                    result[depth].push(child);
                }
            }
            return returnValue;
        };
        testGroup(treeLeft, this.rowsOfHeadersToRenderLeft, 0);
        testGroup(treeRight, this.rowsOfHeadersToRenderRight, 0);
        testGroup(treeCenter, this.rowsOfHeadersToRenderCenter, 0);
    }
    extractViewport() {
        const hashColumn = (c) => `${c.getId()}-${c.getPinned() || 'normal'}`;
        this.extractViewportColumns();
        const newHash = this.getViewportColumns().map(hashColumn).join('#');
        const changed = this.colsWithinViewportHash !== newHash;
        if (changed) {
            this.colsWithinViewportHash = newHash;
            this.calculateHeaderRows();
        }
        return changed;
    }
}
exports.ColumnViewportService = ColumnViewportService;
function isAnyParentAutoHeaderHeight(col) {
    while (col) {
        if (col.isAutoHeaderHeight()) {
            return true;
        }
        col = col.getParent();
    }
    return false;
}


/***/ }),

/***/ 6350:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataTypeService = void 0;
const keyCode_1 = __webpack_require__(9853);
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
const date_1 = __webpack_require__(9827);
const generic_1 = __webpack_require__(4422);
const object_1 = __webpack_require__(6996);
const logging_1 = __webpack_require__(7764);
const columnFactoryUtils_1 = __webpack_require__(2716);
const columnStateUtils_1 = __webpack_require__(2885);
const columnUtils_1 = __webpack_require__(3146);
/**
 *  We are missing object and dateTime here.
 *  This is because dateTime has a lower priority than date and gives us no way to distinguish between the two, and
 *  object type is the default type for all other types.
 *
 *  dateTimeString has higher priority than dateString, since it includes serialized time and isValidDate() considers datetime a valid date.
 */
const SORTED_CELL_DATA_TYPES_FOR_MATCHING = [
    'dateTimeString',
    'dateString',
    'text',
    'number',
    'boolean',
    'date',
];
class DataTypeService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'dataTypeSvc';
        this.dataTypeDefinitions = {};
        this.isPendingInference = false;
        this.isColumnTypeOverrideInDataTypeDefinitions = false;
        // keep track of any column state updates whilst waiting for data types to be inferred
        this.columnStateUpdatesPendingInference = {};
        this.columnStateUpdateListenerDestroyFuncs = [];
        // using an object here to enforce dev to not forget to implement new types as they are added
        this.columnDefinitionPropsPerDataType = {
            number() {
                return { cellEditor: 'agNumberCellEditor' };
            },
            boolean() {
                return {
                    cellEditor: 'agCheckboxCellEditor',
                    cellRenderer: 'agCheckboxCellRenderer',
                    getFindText: () => null,
                    suppressKeyboardEvent: (params) => !!params.colDef.editable && params.event.key === keyCode_1.KeyCode.SPACE,
                };
            },
            date({ formatValue }) {
                return { cellEditor: 'agDateCellEditor', keyCreator: formatValue };
            },
            dateString({ formatValue }) {
                return { cellEditor: 'agDateStringCellEditor', keyCreator: formatValue };
            },
            dateTime(args) {
                return this.date(args);
            },
            dateTimeString(args) {
                return this.dateString(args);
            },
            object({ formatValue, colModel, colId }) {
                return {
                    cellEditorParams: {
                        useFormatter: true,
                    },
                    comparator: (a, b) => {
                        const column = colModel.getColDefCol(colId);
                        const colDef = column?.getColDef();
                        if (!column || !colDef) {
                            return 0;
                        }
                        const valA = a == null ? '' : formatValue({ column, node: null, value: a });
                        const valB = b == null ? '' : formatValue({ column, node: null, value: b });
                        if (valA === valB)
                            return 0;
                        return valA > valB ? 1 : -1;
                    },
                    keyCreator: formatValue,
                };
            },
            text() {
                return {};
            },
        };
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
    }
    postConstruct() {
        this.processDataTypeDefinitions();
        this.addManagedPropertyListener('dataTypeDefinitions', (event) => {
            this.processDataTypeDefinitions();
            this.colModel.recreateColumnDefs(event);
        });
    }
    processDataTypeDefinitions() {
        const defaultDataTypes = this.getDefaultDataTypes();
        const newDataTypeDefinitions = {};
        const newFormatValueFuncs = {};
        const generateFormatValueFunc = (dataTypeDefinition) => {
            return (params) => {
                const { column, node, value } = params;
                let valueFormatter = column.getColDef().valueFormatter;
                if (valueFormatter === dataTypeDefinition.groupSafeValueFormatter) {
                    valueFormatter = dataTypeDefinition.valueFormatter;
                }
                return this.beans.valueSvc.formatValue(column, node, value, valueFormatter);
            };
        };
        for (const cellDataType of Object.keys(defaultDataTypes)) {
            const defaultDataTypeDef = defaultDataTypes[cellDataType];
            const mergedDataTypeDefinition = {
                ...defaultDataTypeDef,
                groupSafeValueFormatter: createGroupSafeValueFormatter(defaultDataTypeDef, this.gos),
            };
            newDataTypeDefinitions[cellDataType] = mergedDataTypeDefinition;
            newFormatValueFuncs[cellDataType] = generateFormatValueFunc(mergedDataTypeDefinition);
        }
        const userDataTypeDefs = this.gos.get('dataTypeDefinitions') ?? {};
        const newDataTypeMatchers = {};
        for (const cellDataType of Object.keys(userDataTypeDefs)) {
            const userDataTypeDef = userDataTypeDefs[cellDataType];
            const mergedDataTypeDefinition = this.processDataTypeDefinition(userDataTypeDef, userDataTypeDefs, [cellDataType], defaultDataTypes);
            if (mergedDataTypeDefinition) {
                newDataTypeDefinitions[cellDataType] = mergedDataTypeDefinition;
                if (userDataTypeDef.dataTypeMatcher) {
                    newDataTypeMatchers[cellDataType] = userDataTypeDef.dataTypeMatcher;
                }
                newFormatValueFuncs[cellDataType] = generateFormatValueFunc(mergedDataTypeDefinition);
            }
        }
        const { valueParser: defaultValueParser, valueFormatter: defaultValueFormatter } = defaultDataTypes.object;
        const { valueParser: userValueParser, valueFormatter: userValueFormatter } = newDataTypeDefinitions.object;
        this.hasObjectValueParser = userValueParser !== defaultValueParser;
        this.hasObjectValueFormatter = userValueFormatter !== defaultValueFormatter;
        this.formatValueFuncs = newFormatValueFuncs;
        this.dataTypeDefinitions = newDataTypeDefinitions;
        this.dataTypeMatchers = this.sortKeysInMatchers(newDataTypeMatchers, defaultDataTypes);
    }
    /**
     * Sorts the keys in the matchers object.
     * Does not mutate the original object, creates a copy of it with sorted keys instead.
     */
    sortKeysInMatchers(matchers, dataTypes) {
        const sortedMatchers = { ...matchers };
        for (const cellDataType of SORTED_CELL_DATA_TYPES_FOR_MATCHING) {
            delete sortedMatchers[cellDataType];
            sortedMatchers[cellDataType] = matchers[cellDataType] ?? dataTypes[cellDataType].dataTypeMatcher;
        }
        return sortedMatchers;
    }
    processDataTypeDefinition(userDataTypeDef, userDataTypeDefs, alreadyProcessedDataTypes, defaultDataTypes) {
        let mergedDataTypeDefinition;
        const extendsCellDataType = userDataTypeDef.extendsDataType;
        if (userDataTypeDef.columnTypes) {
            this.isColumnTypeOverrideInDataTypeDefinitions = true;
        }
        if (userDataTypeDef.extendsDataType === userDataTypeDef.baseDataType) {
            let baseDataTypeDefinition = defaultDataTypes[extendsCellDataType];
            const overriddenBaseDataTypeDefinition = userDataTypeDefs[extendsCellDataType];
            if (baseDataTypeDefinition && overriddenBaseDataTypeDefinition) {
                // only if it's valid do we override with a provided one
                baseDataTypeDefinition = overriddenBaseDataTypeDefinition;
            }
            if (!validateDataTypeDefinition(userDataTypeDef, baseDataTypeDefinition, extendsCellDataType)) {
                return undefined;
            }
            mergedDataTypeDefinition = mergeDataTypeDefinitions(baseDataTypeDefinition, userDataTypeDef);
        }
        else {
            if (alreadyProcessedDataTypes.includes(extendsCellDataType)) {
                (0, logging_1._warn)(44);
                return undefined;
            }
            const extendedDataTypeDefinition = userDataTypeDefs[extendsCellDataType];
            if (!validateDataTypeDefinition(userDataTypeDef, extendedDataTypeDefinition, extendsCellDataType)) {
                return undefined;
            }
            const mergedExtendedDataTypeDefinition = this.processDataTypeDefinition(extendedDataTypeDefinition, userDataTypeDefs, [...alreadyProcessedDataTypes, extendsCellDataType], defaultDataTypes);
            if (!mergedExtendedDataTypeDefinition) {
                return undefined;
            }
            mergedDataTypeDefinition = mergeDataTypeDefinitions(mergedExtendedDataTypeDefinition, userDataTypeDef);
        }
        return {
            ...mergedDataTypeDefinition,
            groupSafeValueFormatter: createGroupSafeValueFormatter(mergedDataTypeDefinition, this.gos),
        };
    }
    updateColDefAndGetColumnType(colDef, userColDef, colId) {
        let { cellDataType } = userColDef;
        const { field } = userColDef;
        if (cellDataType === undefined) {
            cellDataType = colDef.cellDataType;
        }
        if (cellDataType == null || cellDataType === true) {
            cellDataType = this.canInferCellDataType(colDef, userColDef) ? this.inferCellDataType(field, colId) : false;
        }
        if (!cellDataType) {
            colDef.cellDataType = false;
            return undefined;
        }
        const dataTypeDefinition = this.dataTypeDefinitions[cellDataType];
        if (!dataTypeDefinition) {
            (0, logging_1._warn)(47, { cellDataType });
            return undefined;
        }
        colDef.cellDataType = cellDataType;
        if (dataTypeDefinition.groupSafeValueFormatter) {
            colDef.valueFormatter = dataTypeDefinition.groupSafeValueFormatter;
        }
        if (dataTypeDefinition.valueParser) {
            colDef.valueParser = dataTypeDefinition.valueParser;
        }
        if (!dataTypeDefinition.suppressDefaultProperties) {
            this.setColDefPropertiesForBaseDataType(colDef, cellDataType, dataTypeDefinition, colId);
        }
        return dataTypeDefinition.columnTypes;
    }
    addColumnListeners(column) {
        if (!this.isPendingInference) {
            return;
        }
        const columnStateUpdates = this.columnStateUpdatesPendingInference[column.getColId()];
        if (!columnStateUpdates) {
            return;
        }
        const columnListener = (event) => {
            columnStateUpdates.add(event.key);
        };
        column.__addEventListener('columnStateUpdated', columnListener);
        this.columnStateUpdateListenerDestroyFuncs.push(() => column.__removeEventListener('columnStateUpdated', columnListener));
    }
    canInferCellDataType(colDef, userColDef) {
        const { gos } = this;
        if (!(0, gridOptionsUtils_1._isClientSideRowModel)(gos)) {
            return false;
        }
        const propsToCheckForInference = { cellRenderer: true, valueGetter: true, valueParser: true, refData: true };
        if (doColDefPropsPreventInference(userColDef, propsToCheckForInference)) {
            return false;
        }
        const columnTypes = userColDef.type === null ? colDef.type : userColDef.type;
        if (columnTypes) {
            const columnTypeDefs = gos.get('columnTypes') ?? {};
            const hasPropsPreventingInference = (0, columnUtils_1.convertColumnTypes)(columnTypes).some((columnType) => {
                const columnTypeDef = columnTypeDefs[columnType.trim()];
                return columnTypeDef && doColDefPropsPreventInference(columnTypeDef, propsToCheckForInference);
            });
            if (hasPropsPreventingInference) {
                return false;
            }
        }
        return !doColDefPropsPreventInference(colDef, propsToCheckForInference);
    }
    inferCellDataType(field, colId) {
        if (!field) {
            return undefined;
        }
        let value;
        const initialData = this.getInitialData();
        if (initialData) {
            const fieldContainsDots = field.indexOf('.') >= 0 && !this.gos.get('suppressFieldDotNotation');
            value = (0, object_1._getValueUsingField)(initialData, field, fieldContainsDots);
        }
        else {
            this.initWaitForRowData(colId);
        }
        if (value == null) {
            return undefined;
        }
        const matchedType = Object.keys(this.dataTypeMatchers).find((_cellDataType) => this.dataTypeMatchers[_cellDataType](value));
        return matchedType ?? 'object';
    }
    getInitialData() {
        const rowData = this.gos.get('rowData');
        if (rowData?.length) {
            return rowData[0];
        }
        else if (this.initialData) {
            return this.initialData;
        }
        else {
            const rowNodes = this.beans.rowModel.rootNode?.allLeafChildren;
            if (rowNodes?.length) {
                return rowNodes[0].data;
            }
        }
        return null;
    }
    initWaitForRowData(colId) {
        this.columnStateUpdatesPendingInference[colId] = new Set();
        if (this.isPendingInference) {
            return;
        }
        this.isPendingInference = true;
        const columnTypeOverridesExist = this.isColumnTypeOverrideInDataTypeDefinitions;
        const { colAutosize, eventSvc } = this.beans;
        if (columnTypeOverridesExist && colAutosize) {
            colAutosize.shouldQueueResizeOperations = true;
        }
        const [destroyFunc] = this.addManagedEventListeners({
            rowDataUpdateStarted: (event) => {
                const { firstRowData } = event;
                if (!firstRowData) {
                    return;
                }
                destroyFunc?.();
                this.isPendingInference = false;
                this.processColumnsPendingInference(firstRowData, columnTypeOverridesExist);
                this.columnStateUpdatesPendingInference = {};
                if (columnTypeOverridesExist) {
                    colAutosize?.processResizeOperations();
                }
                eventSvc.dispatchEvent({
                    type: 'dataTypesInferred',
                });
            },
        });
    }
    processColumnsPendingInference(firstRowData, columnTypeOverridesExist) {
        this.initialData = firstRowData;
        const state = [];
        this.destroyColumnStateUpdateListeners();
        const newRowGroupColumnStateWithoutIndex = {};
        const newPivotColumnStateWithoutIndex = {};
        for (const colId of Object.keys(this.columnStateUpdatesPendingInference)) {
            const columnStateUpdates = this.columnStateUpdatesPendingInference[colId];
            const column = this.colModel.getCol(colId);
            if (!column) {
                return;
            }
            const oldColDef = column.getColDef();
            if (!this.resetColDefIntoCol(column, 'cellDataTypeInferred')) {
                return;
            }
            const newColDef = column.getColDef();
            if (columnTypeOverridesExist && newColDef.type && newColDef.type !== oldColDef.type) {
                const updatedColumnState = getUpdatedColumnState(column, columnStateUpdates);
                if (updatedColumnState.rowGroup && updatedColumnState.rowGroupIndex == null) {
                    newRowGroupColumnStateWithoutIndex[colId] = updatedColumnState;
                }
                if (updatedColumnState.pivot && updatedColumnState.pivotIndex == null) {
                    newPivotColumnStateWithoutIndex[colId] = updatedColumnState;
                }
                state.push(updatedColumnState);
            }
        }
        if (columnTypeOverridesExist) {
            state.push(...this.generateColumnStateForRowGroupAndPivotIndexes(newRowGroupColumnStateWithoutIndex, newPivotColumnStateWithoutIndex));
        }
        if (state.length) {
            (0, columnStateUtils_1._applyColumnState)(this.beans, { state }, 'cellDataTypeInferred');
        }
        this.initialData = null;
    }
    generateColumnStateForRowGroupAndPivotIndexes(updatedRowGroupColumnState, updatedPivotColumnState) {
        // Generally columns should appear in the order they were before. For any new columns, these should appear in the original col def order.
        // The exception is for columns that were added via `addGroupColumns`. These should appear at the end.
        // We don't have to worry about full updates, as in this case the arrays are correct, and they won't appear in the updated lists.
        const existingColumnStateUpdates = {};
        const { rowGroupColsSvc, pivotColsSvc } = this.beans;
        rowGroupColsSvc?.restoreColumnOrder(existingColumnStateUpdates, updatedRowGroupColumnState);
        pivotColsSvc?.restoreColumnOrder(existingColumnStateUpdates, updatedPivotColumnState);
        return Object.values(existingColumnStateUpdates);
    }
    resetColDefIntoCol(column, source) {
        const userColDef = column.getUserProvidedColDef();
        if (!userColDef) {
            return false;
        }
        const newColDef = (0, columnFactoryUtils_1._addColumnDefaultAndTypes)(this.beans, userColDef, column.getColId());
        column.setColDef(newColDef, userColDef, source);
        return true;
    }
    getDateStringTypeDefinition(column) {
        const { dateString } = this.dataTypeDefinitions;
        if (!column) {
            return dateString;
        }
        return (this.getDataTypeDefinition(column) ?? dateString);
    }
    getDateParserFunction(column) {
        return this.getDateStringTypeDefinition(column).dateParser;
    }
    getDateFormatterFunction(column) {
        return this.getDateStringTypeDefinition(column).dateFormatter;
    }
    getDateIncludesTimeFlag(cellDataType) {
        return cellDataType === 'dateTime' || cellDataType === 'dateTimeString';
    }
    getDataTypeDefinition(column) {
        const colDef = column.getColDef();
        if (!colDef.cellDataType) {
            return undefined;
        }
        return this.dataTypeDefinitions[colDef.cellDataType];
    }
    getBaseDataType(column) {
        return this.getDataTypeDefinition(column)?.baseDataType;
    }
    checkType(column, value) {
        if (value == null) {
            return true;
        }
        const dataTypeMatcher = this.getDataTypeDefinition(column)?.dataTypeMatcher;
        if (!dataTypeMatcher) {
            return true;
        }
        return dataTypeMatcher(value);
    }
    validateColDef(colDef) {
        const warning = (property) => (0, logging_1._warn)(48, { property });
        if (colDef.cellDataType === 'object') {
            const { object } = this.dataTypeDefinitions;
            if (colDef.valueFormatter === object.groupSafeValueFormatter && !this.hasObjectValueFormatter) {
                warning('Formatter');
            }
            if (colDef.editable && colDef.valueParser === object.valueParser && !this.hasObjectValueParser) {
                warning('Parser');
            }
        }
    }
    postProcess(colDef) {
        const cellDataType = colDef.cellDataType;
        if (!cellDataType || typeof cellDataType !== 'string') {
            return;
        }
        const { dataTypeDefinitions, beans, formatValueFuncs } = this;
        const dataTypeDefinition = dataTypeDefinitions[cellDataType];
        beans.colFilter?.setColDefPropsForDataType(colDef, dataTypeDefinition, formatValueFuncs[cellDataType]);
    }
    // noinspection JSUnusedGlobalSymbols
    getFormatValue(cellDataType) {
        return this.formatValueFuncs[cellDataType];
    }
    isColPendingInference(colId) {
        return this.isPendingInference && !!this.columnStateUpdatesPendingInference[colId];
    }
    setColDefPropertiesForBaseDataType(colDef, cellDataType, dataTypeDefinition, colId) {
        const formatValue = this.formatValueFuncs[cellDataType];
        const partialColDef = this.columnDefinitionPropsPerDataType[dataTypeDefinition.baseDataType]({
            colDef,
            cellDataType,
            colModel: this.colModel,
            dataTypeDefinition,
            colId,
            formatValue,
        });
        Object.assign(colDef, partialColDef);
    }
    getDateObjectTypeDef(baseDataType) {
        const translate = this.getLocaleTextFunc();
        const includeTime = this.getDateIncludesTimeFlag(baseDataType);
        return {
            baseDataType,
            valueParser: (params) => (0, date_1._parseDateTimeFromString)(params.newValue && String(params.newValue)),
            valueFormatter: (params) => {
                if (params.value == null) {
                    return '';
                }
                if (!(params.value instanceof Date) || isNaN(params.value.getTime())) {
                    return translate('invalidDate', 'Invalid Date');
                }
                return (0, date_1._serialiseDate)(params.value, includeTime) ?? '';
            },
            dataTypeMatcher: (value) => value instanceof Date,
        };
    }
    getDateStringTypeDef(baseDataType) {
        const includeTime = this.getDateIncludesTimeFlag(baseDataType);
        return {
            baseDataType,
            dateParser: (value) => (0, date_1._parseDateTimeFromString)(value) ?? undefined,
            dateFormatter: (value) => (0, date_1._serialiseDate)(value ?? null, includeTime) ?? undefined,
            valueParser: (params) => (0, date_1._isValidDate)(String(params.newValue)) ? params.newValue : null,
            valueFormatter: (params) => (0, date_1._isValidDate)(String(params.value)) ? String(params.value) : '',
            dataTypeMatcher: (value) => typeof value === 'string' && (0, date_1._isValidDate)(value),
        };
    }
    getDefaultDataTypes() {
        const translate = this.getLocaleTextFunc();
        return {
            number: {
                baseDataType: 'number',
                // can be empty space with legacy copy
                valueParser: (params) => params.newValue?.trim?.() === '' ? null : Number(params.newValue),
                valueFormatter: (params) => {
                    if (params.value == null) {
                        return '';
                    }
                    if (typeof params.value !== 'number' || isNaN(params.value)) {
                        return translate('invalidNumber', 'Invalid Number');
                    }
                    return String(params.value);
                },
                dataTypeMatcher: (value) => typeof value === 'number',
            },
            text: {
                baseDataType: 'text',
                valueParser: (params) => params.newValue === '' ? null : (0, generic_1._toStringOrNull)(params.newValue),
                dataTypeMatcher: (value) => typeof value === 'string',
            },
            boolean: {
                baseDataType: 'boolean',
                valueParser: (params) => {
                    if (params.newValue == null) {
                        return params.newValue;
                    }
                    // can be empty space with legacy copy
                    return params.newValue?.trim?.() === '' ? null : String(params.newValue).toLowerCase() === 'true';
                },
                valueFormatter: (params) => params.value == null ? '' : String(params.value),
                dataTypeMatcher: (value) => typeof value === 'boolean',
            },
            date: this.getDateObjectTypeDef('date'),
            dateString: this.getDateStringTypeDef('dateString'),
            dateTime: this.getDateObjectTypeDef('dateTime'),
            dateTimeString: {
                ...this.getDateStringTypeDef('dateTimeString'),
                dataTypeMatcher: (value) => typeof value === 'string' && (0, date_1._isValidDateTime)(value),
            },
            object: {
                baseDataType: 'object',
                valueParser: () => null,
                valueFormatter: (params) => (0, generic_1._toStringOrNull)(params.value) ?? '',
            },
        };
    }
    destroyColumnStateUpdateListeners() {
        this.columnStateUpdateListenerDestroyFuncs.forEach((destroyFunc) => destroyFunc());
        this.columnStateUpdateListenerDestroyFuncs = [];
    }
    destroy() {
        this.dataTypeDefinitions = {};
        this.dataTypeMatchers = {};
        this.formatValueFuncs = {};
        this.columnStateUpdatesPendingInference = {};
        this.destroyColumnStateUpdateListeners();
        super.destroy();
    }
}
exports.DataTypeService = DataTypeService;
function mergeDataTypeDefinitions(parentDataTypeDefinition, childDataTypeDefinition) {
    const mergedDataTypeDefinition = {
        ...parentDataTypeDefinition,
        ...childDataTypeDefinition,
    };
    if (parentDataTypeDefinition.columnTypes &&
        childDataTypeDefinition.columnTypes &&
        childDataTypeDefinition.appendColumnTypes) {
        mergedDataTypeDefinition.columnTypes = [
            ...(0, columnUtils_1.convertColumnTypes)(parentDataTypeDefinition.columnTypes),
            ...(0, columnUtils_1.convertColumnTypes)(childDataTypeDefinition.columnTypes),
        ];
    }
    return mergedDataTypeDefinition;
}
function validateDataTypeDefinition(dataTypeDefinition, parentDataTypeDefinition, parentCellDataType) {
    if (!parentDataTypeDefinition) {
        (0, logging_1._warn)(45, { parentCellDataType });
        return false;
    }
    if (parentDataTypeDefinition.baseDataType !== dataTypeDefinition.baseDataType) {
        (0, logging_1._warn)(46);
        return false;
    }
    return true;
}
function createGroupSafeValueFormatter(dataTypeDefinition, gos) {
    if (!dataTypeDefinition.valueFormatter) {
        return undefined;
    }
    return (params) => {
        if (params.node?.group) {
            const aggFunc = (params.colDef.pivotValueColumn ?? params.column).getAggFunc();
            if (aggFunc) {
                // the resulting type of these will be the same, so we call valueFormatter anyway
                if (aggFunc === 'first' || aggFunc === 'last') {
                    return dataTypeDefinition.valueFormatter(params);
                }
                if (dataTypeDefinition.baseDataType === 'number' && aggFunc !== 'count') {
                    if (typeof params.value === 'number') {
                        return dataTypeDefinition.valueFormatter(params);
                    }
                    if (typeof params.value === 'object') {
                        if (!params.value) {
                            return undefined;
                        }
                        if ('toNumber' in params.value) {
                            return dataTypeDefinition.valueFormatter({
                                ...params,
                                value: params.value.toNumber(),
                            });
                        }
                        if ('value' in params.value) {
                            return dataTypeDefinition.valueFormatter({
                                ...params,
                                value: params.value.value,
                            });
                        }
                    }
                }
                // by default don't use value formatter for agg func as type may have changed
                return undefined;
            }
        }
        else if (gos.get('groupHideOpenParents') && params.column.isRowGroupActive()) {
            // `groupHideOpenParents` passes leaf values in the group column, so need to format still.
            // If it's not a string, we know it hasn't been formatted. Otherwise check the data type matcher.
            if (typeof params.value === 'string' && !dataTypeDefinition.dataTypeMatcher?.(params.value)) {
                return undefined;
            }
        }
        return dataTypeDefinition.valueFormatter(params);
    };
}
function doesColDefPropPreventInference(colDef, checkProps, prop, comparisonValue) {
    if (!checkProps[prop]) {
        return false;
    }
    const value = colDef[prop];
    if (value === null) {
        checkProps[prop] = false;
        return false;
    }
    else {
        return comparisonValue === undefined ? !!value : value === comparisonValue;
    }
}
function doColDefPropsPreventInference(colDef, propsToCheckForInference) {
    return [
        ['cellRenderer', 'agSparklineCellRenderer'],
        ['valueGetter', undefined],
        ['valueParser', undefined],
        ['refData', undefined],
    ].some(([prop, comparisonValue]) => doesColDefPropPreventInference(colDef, propsToCheckForInference, prop, comparisonValue));
}
function getUpdatedColumnState(column, columnStateUpdates) {
    const columnState = (0, columnStateUtils_1.getColumnStateFromColDef)(column);
    columnStateUpdates.forEach((key) => {
        // if the column state has been updated, don't update again
        delete columnState[key];
        if (key === 'rowGroup') {
            delete columnState.rowGroupIndex;
        }
        else if (key === 'pivot') {
            delete columnState.pivotIndex;
        }
    });
    return columnState;
}


/***/ }),

/***/ 6034:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GroupInstanceIdCreator = void 0;
// class returns unique instance id's for columns.
// eg, the following calls (in this order) will result in:
//
// getInstanceIdForKey('country') => 0
// getInstanceIdForKey('country') => 1
// getInstanceIdForKey('country') => 2
// getInstanceIdForKey('country') => 3
// getInstanceIdForKey('age') => 0
// getInstanceIdForKey('age') => 1
// getInstanceIdForKey('country') => 4
class GroupInstanceIdCreator {
    constructor() {
        // this map contains keys to numbers, so we remember what the last call was
        this.existingIds = {};
    }
    getInstanceIdForKey(key) {
        const lastResult = this.existingIds[key];
        let result;
        if (typeof lastResult !== 'number') {
            // first time this key
            result = 0;
        }
        else {
            result = lastResult + 1;
        }
        this.existingIds[key] = result;
        return result;
    }
}
exports.GroupInstanceIdCreator = GroupInstanceIdCreator;


/***/ }),

/***/ 3245:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectionColService = void 0;
const beanStub_1 = __webpack_require__(8731);
const agColumn_1 = __webpack_require__(3355);
const gridOptionsUtils_1 = __webpack_require__(7274);
const array_1 = __webpack_require__(1502);
const columnStateUtils_1 = __webpack_require__(2885);
const columnUtils_1 = __webpack_require__(3146);
class SelectionColService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'selectionColSvc';
    }
    postConstruct() {
        this.addManagedPropertyListener('rowSelection', (event) => {
            this.onSelectionOptionsChanged(event.currentValue, event.previousValue, (0, columnUtils_1._convertColumnEventSourceType)(event.source));
        });
        this.addManagedPropertyListener('selectionColumnDef', this.updateColumns.bind(this));
    }
    addColumns(cols) {
        const selectionCols = this.columns;
        if (selectionCols == null) {
            return;
        }
        cols.list = selectionCols.list.concat(cols.list);
        cols.tree = selectionCols.tree.concat(cols.tree);
        (0, columnUtils_1._updateColsMap)(cols);
    }
    createColumns(cols, updateOrders) {
        const destroyCollection = () => {
            (0, columnUtils_1._destroyColumnTree)(this.beans, this.columns?.tree);
            this.columns = null;
        };
        const newTreeDepth = cols.treeDepth;
        const oldTreeDepth = this.columns?.treeDepth ?? -1;
        const treeDepthSame = oldTreeDepth == newTreeDepth;
        const list = this.generateSelectionCols();
        const areSame = (0, columnUtils_1._areColIdsEqual)(list, this.columns?.list ?? []);
        if (areSame && treeDepthSame) {
            return;
        }
        destroyCollection();
        const { colGroupSvc } = this.beans;
        const treeDepth = colGroupSvc?.findDepth(cols.tree) ?? 0;
        const tree = colGroupSvc?.balanceTreeForAutoCols(list, treeDepth) ?? [];
        this.columns = {
            list,
            tree,
            treeDepth,
            map: {},
        };
        const putSelectionColsFirstInList = (cols) => {
            if (!cols) {
                return null;
            }
            // we use colId, and not instance, to remove old selectionCols
            const colsFiltered = cols.filter((col) => !(0, columnUtils_1.isColumnSelectionCol)(col));
            return [...list, ...colsFiltered];
        };
        updateOrders(putSelectionColsFirstInList);
    }
    updateColumns(event) {
        const source = (0, columnUtils_1._convertColumnEventSourceType)(event.source);
        this.columns?.list.forEach((col) => {
            const newColDef = this.createSelectionColDef(event.currentValue);
            col.setColDef(newColDef, null, source);
            (0, columnStateUtils_1._applyColumnState)(this.beans, { state: [{ ...newColDef, colId: col.getColId() }] }, source);
        });
    }
    getColumn(key) {
        return this.columns?.list.find((col) => (0, columnUtils_1._columnsMatch)(col, key)) ?? null;
    }
    getColumns() {
        return this.columns?.list ?? null;
    }
    isSelectionColumnEnabled() {
        const { gos, beans } = this;
        const rowSelection = gos.get('rowSelection');
        if (typeof rowSelection !== 'object' || !(0, gridOptionsUtils_1._isRowSelection)(gos)) {
            return false;
        }
        const hasAutoCols = (beans.autoColSvc?.getColumns()?.length ?? 0) > 0;
        if (rowSelection.checkboxLocation === 'autoGroupColumn' && hasAutoCols) {
            return false;
        }
        const checkboxes = !!(0, gridOptionsUtils_1._getCheckboxes)(rowSelection);
        const headerCheckbox = (0, gridOptionsUtils_1._getHeaderCheckbox)(rowSelection);
        return checkboxes || headerCheckbox;
    }
    createSelectionColDef(def) {
        const { gos } = this.beans;
        const selectionColumnDef = def ?? gos.get('selectionColumnDef');
        const enableRTL = gos.get('enableRtl');
        // We don't support row spanning in the selection column
        const { rowSpan: _, spanRows: __, ...filteredSelColDef } = (selectionColumnDef ?? {});
        return {
            // overridable properties
            width: 50,
            resizable: false,
            suppressHeaderMenuButton: true,
            sortable: false,
            suppressMovable: true,
            lockPosition: enableRTL ? 'right' : 'left',
            comparator(valueA, valueB, nodeA, nodeB) {
                const aSelected = nodeA.isSelected();
                const bSelected = nodeB.isSelected();
                return aSelected === bSelected ? 0 : aSelected ? 1 : -1;
            },
            editable: false,
            suppressFillHandle: true,
            pinned: null,
            // overrides
            ...filteredSelColDef,
            // non-overridable properties
            colId: columnUtils_1.SELECTION_COLUMN_ID,
            chartDataType: 'excluded',
        };
    }
    generateSelectionCols() {
        if (!this.isSelectionColumnEnabled()) {
            return [];
        }
        const colDef = this.createSelectionColDef();
        const colId = colDef.colId;
        this.gos.validateColDef(colDef, colId, true);
        const col = new agColumn_1.AgColumn(colDef, null, colId, false);
        this.createBean(col);
        return [col];
    }
    onSelectionOptionsChanged(current, prev, source) {
        const prevCheckbox = prev && typeof prev !== 'string' ? (0, gridOptionsUtils_1._getCheckboxes)(prev) : undefined;
        const currCheckbox = current && typeof current !== 'string' ? (0, gridOptionsUtils_1._getCheckboxes)(current) : undefined;
        const checkboxHasChanged = prevCheckbox !== currCheckbox;
        const prevHeaderCheckbox = prev && typeof prev !== 'string' ? (0, gridOptionsUtils_1._getHeaderCheckbox)(prev) : undefined;
        const currHeaderCheckbox = current && typeof current !== 'string' ? (0, gridOptionsUtils_1._getHeaderCheckbox)(current) : undefined;
        const headerCheckboxHasChanged = prevHeaderCheckbox !== currHeaderCheckbox;
        const currLocation = (0, gridOptionsUtils_1._getCheckboxLocation)(current);
        const prevLocation = (0, gridOptionsUtils_1._getCheckboxLocation)(prev);
        const locationChanged = currLocation !== prevLocation;
        if (checkboxHasChanged || headerCheckboxHasChanged || locationChanged) {
            this.beans.colModel.refreshAll(source);
        }
    }
    destroy() {
        (0, columnUtils_1._destroyColumnTree)(this.beans, this.columns?.tree);
        super.destroy();
    }
    /**
     * Refreshes visibility of the selection column based on which columns are currently visible.
     * Called by the VisibleColsService with the columns that are currently visible in left/center/right
     * containers. This method *MUTATES* those arrays directly.
     *
     * The selection column should be visible if all of the following are true
     * - The selection column is not disabled
     * - The number of visible columns excluding the selection column and row numbers column is greater than 0
     * @param leftCols Visible columns in the left-pinned container
     * @param centerCols Visible columns in the center viewport
     * @param rightCols Visible columns in the right-pinned container
     */
    refreshVisibility(leftCols, centerCols, rightCols) {
        // columns list will only be populated if selection column is enabled
        if (!this.columns?.list.length) {
            return;
        }
        const numVisibleCols = leftCols.length + centerCols.length + rightCols.length;
        if (numVisibleCols === 0) {
            return;
        }
        // There's only one selection column
        const column = this.columns.list[0];
        // If it's deliberately hidden, we needn't do anything
        if (!column.isVisible())
            return;
        const hideSelectionCol = () => {
            let cols;
            switch (column.pinned) {
                case 'left':
                case true:
                    cols = leftCols;
                    break;
                case 'right':
                    cols = rightCols;
                    break;
                default:
                    cols = centerCols;
            }
            cols && (0, array_1._removeFromArray)(cols, column);
        };
        const rowNumbersCol = this.beans.rowNumbersSvc?.getColumn(columnUtils_1.ROW_NUMBERS_COLUMN_ID);
        // two conditions for which we hide selection column:
        //   1. Only selection column and row numbers column are visible
        //   2. Only selection column is visible
        const expectedNumCols = rowNumbersCol ? 2 : 1;
        if (expectedNumCols === numVisibleCols) {
            hideSelectionCol();
        }
    }
}
exports.SelectionColService = SelectionColService;


/***/ }),

/***/ 6869:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.depthFirstAllColumnTreeSearch = exports.VisibleColsService = void 0;
const beanStub_1 = __webpack_require__(8731);
const agColumn_1 = __webpack_require__(3355);
const agColumnGroup_1 = __webpack_require__(6908);
const array_1 = __webpack_require__(1502);
const columnUtils_1 = __webpack_require__(3146);
const groupInstanceIdCreator_1 = __webpack_require__(6034);
function _removeAllFromUnorderedArray(array, toRemove) {
    for (let i = 0; i < toRemove.length; i++) {
        const index = array.indexOf(toRemove[i]);
        if (index >= 0) {
            // preserve the last element, then shorten array length by 1 to delete index
            array[index] = array[array.length - 1];
            array.pop();
        }
    }
}
// takes in a list of columns, as specified by the column definitions, and returns column groups
class VisibleColsService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'visibleCols';
        // for fast lookup, to see if a column or group is still visible
        this.colsAndGroupsMap = {};
        // leave level columns of the displayed trees
        this.leftCols = [];
        this.rightCols = [];
        this.centerCols = [];
        // all three lists above combined
        this.allCols = [];
        // used by:
        // + angularGrid -> for setting body width
        // + rowController -> setting main row widths (when inserting and resizing)
        // need to cache this
        this.bodyWidth = 0;
        this.leftWidth = 0;
        this.rightWidth = 0;
        this.isBodyWidthDirty = true;
    }
    refresh(source, skipTreeBuild = false) {
        const { colFlex, colModel, colGroupSvc, colViewport, selectionColSvc } = this.beans;
        // when we open/close col group, skipTreeBuild=false, as we know liveCols haven't changed
        if (!skipTreeBuild) {
            this.buildTrees(colModel, colGroupSvc);
        }
        colGroupSvc?.updateOpenClosedVisibility();
        this.leftCols = pickDisplayedCols(this.treeLeft);
        this.centerCols = pickDisplayedCols(this.treeCenter);
        this.rightCols = pickDisplayedCols(this.treeRight);
        selectionColSvc?.refreshVisibility(this.leftCols, this.centerCols, this.rightCols);
        this.joinColsAriaOrder(colModel);
        this.joinCols();
        this.setLeftValues(source);
        this.autoHeightCols = this.allCols.filter((col) => col.isAutoHeight());
        colFlex?.refreshFlexedColumns();
        this.updateBodyWidths();
        colViewport.checkViewportColumns(false);
        this.setFirstRightAndLastLeftPinned(colModel, this.leftCols, this.rightCols, source);
        this.eventSvc.dispatchEvent({
            type: 'displayedColumnsChanged',
            source,
        });
    }
    // after setColumnWidth or updateGroupsAndPresentedCols
    updateBodyWidths() {
        const newBodyWidth = (0, columnUtils_1.getWidthOfColsInList)(this.centerCols);
        const newLeftWidth = (0, columnUtils_1.getWidthOfColsInList)(this.leftCols);
        const newRightWidth = (0, columnUtils_1.getWidthOfColsInList)(this.rightCols);
        // this is used by virtual col calculation, for RTL only, as a change to body width can impact displayed
        // columns, due to RTL inverting the y coordinates
        this.isBodyWidthDirty = this.bodyWidth !== newBodyWidth;
        const atLeastOneChanged = this.bodyWidth !== newBodyWidth || this.leftWidth !== newLeftWidth || this.rightWidth !== newRightWidth;
        if (atLeastOneChanged) {
            this.bodyWidth = newBodyWidth;
            this.leftWidth = newLeftWidth;
            this.rightWidth = newRightWidth;
            // this event is fired to allow the grid viewport to resize before the
            // scrollbar tries to update its visibility.
            this.eventSvc.dispatchEvent({
                type: 'columnContainerWidthChanged',
            });
            // when this fires, it is picked up by the gridPanel, which ends up in
            // gridPanel calling setWidthAndScrollPosition(), which in turn calls setViewportPosition()
            this.eventSvc.dispatchEvent({
                type: 'displayedColumnsWidthChanged',
            });
        }
    }
    // sets the left pixel position of each column
    setLeftValues(source) {
        this.setLeftValuesOfCols(source);
        this.setLeftValuesOfGroups();
    }
    setFirstRightAndLastLeftPinned(colModel, leftCols, rightCols, source) {
        let lastLeft;
        let firstRight;
        if (this.gos.get('enableRtl')) {
            lastLeft = leftCols ? leftCols[0] : null;
            firstRight = rightCols ? (0, array_1._last)(rightCols) : null;
        }
        else {
            lastLeft = leftCols ? (0, array_1._last)(leftCols) : null;
            firstRight = rightCols ? rightCols[0] : null;
        }
        colModel.getCols().forEach((col) => {
            col.setLastLeftPinned(col === lastLeft, source);
            col.setFirstRightPinned(col === firstRight, source);
        });
    }
    buildTrees(colModel, columnGroupSvc) {
        const cols = colModel.getColsToShow();
        const leftCols = cols.filter((col) => col.getPinned() == 'left');
        const rightCols = cols.filter((col) => col.getPinned() == 'right');
        const centerCols = cols.filter((col) => col.getPinned() != 'left' && col.getPinned() != 'right');
        const idCreator = new groupInstanceIdCreator_1.GroupInstanceIdCreator();
        const createGroups = (params) => {
            return columnGroupSvc ? columnGroupSvc.createColumnGroups(params) : params.columns;
        };
        this.treeLeft = createGroups({
            columns: leftCols,
            idCreator,
            pinned: 'left',
            oldDisplayedGroups: this.treeLeft,
        });
        this.treeRight = createGroups({
            columns: rightCols,
            idCreator,
            pinned: 'right',
            oldDisplayedGroups: this.treeRight,
        });
        this.treeCenter = createGroups({
            columns: centerCols,
            idCreator,
            pinned: null,
            oldDisplayedGroups: this.treeCenter,
        });
        this.updateColsAndGroupsMap();
    }
    clear() {
        this.leftCols = [];
        this.rightCols = [];
        this.centerCols = [];
        this.allCols = [];
        this.ariaOrderColumns = [];
    }
    joinColsAriaOrder(colModel) {
        const allColumns = colModel.getCols();
        const pinnedLeft = [];
        const center = [];
        const pinnedRight = [];
        for (const col of allColumns) {
            const pinned = col.getPinned();
            if (!pinned) {
                center.push(col);
            }
            else if (pinned === true || pinned === 'left') {
                pinnedLeft.push(col);
            }
            else {
                pinnedRight.push(col);
            }
        }
        this.ariaOrderColumns = pinnedLeft.concat(center).concat(pinnedRight);
    }
    getAriaColIndex(colOrGroup) {
        let col;
        if ((0, agColumnGroup_1.isColumnGroup)(colOrGroup)) {
            col = colOrGroup.getLeafColumns()[0];
        }
        else {
            col = colOrGroup;
        }
        return this.ariaOrderColumns.indexOf(col) + 1;
    }
    setLeftValuesOfGroups() {
        // a groups left value is the lest left value of it's children
        [this.treeLeft, this.treeRight, this.treeCenter].forEach((columns) => {
            columns.forEach((column) => {
                if ((0, agColumnGroup_1.isColumnGroup)(column)) {
                    const columnGroup = column;
                    columnGroup.checkLeft();
                }
            });
        });
    }
    setLeftValuesOfCols(source) {
        const { colModel } = this.beans;
        const primaryCols = colModel.getColDefCols();
        if (!primaryCols) {
            return;
        }
        // go through each list of displayed columns
        const allColumns = colModel.getCols().slice(0);
        // let totalColumnWidth = this.getWidthOfColsInList()
        const doingRtl = this.gos.get('enableRtl');
        [this.leftCols, this.rightCols, this.centerCols].forEach((columns) => {
            if (doingRtl) {
                // when doing RTL, we start at the top most pixel (ie RHS) and work backwards
                let left = (0, columnUtils_1.getWidthOfColsInList)(columns);
                columns.forEach((column) => {
                    left -= column.getActualWidth();
                    column.setLeft(left, source);
                });
            }
            else {
                // otherwise normal LTR, we start at zero
                let left = 0;
                columns.forEach((column) => {
                    column.setLeft(left, source);
                    left += column.getActualWidth();
                });
            }
            _removeAllFromUnorderedArray(allColumns, columns);
        });
        // items left in allColumns are columns not displayed, so remove the left position. this is
        // important for the rows, as if a col is made visible, then taken out, then made visible again,
        // we don't want the animation of the cell floating in from the old position, whatever that was.
        allColumns.forEach((column) => {
            column.setLeft(null, source);
        });
    }
    joinCols() {
        if (this.gos.get('enableRtl')) {
            this.allCols = this.rightCols.concat(this.centerCols).concat(this.leftCols);
        }
        else {
            this.allCols = this.leftCols.concat(this.centerCols).concat(this.rightCols);
        }
    }
    getAllTrees() {
        if (this.treeLeft && this.treeRight && this.treeCenter) {
            return this.treeLeft.concat(this.treeCenter).concat(this.treeRight);
        }
        return null;
    }
    // gridPanel -> ensureColumnVisible
    isColDisplayed(column) {
        return this.allCols.indexOf(column) >= 0;
    }
    getLeftColsForRow(rowNode) {
        const { leftCols, beans: { colModel }, } = this;
        const colSpanActive = colModel.colSpanActive;
        if (!colSpanActive) {
            return leftCols;
        }
        return this.getColsForRow(rowNode, leftCols);
    }
    getRightColsForRow(rowNode) {
        const { rightCols, beans: { colModel }, } = this;
        const colSpanActive = colModel.colSpanActive;
        if (!colSpanActive) {
            return rightCols;
        }
        return this.getColsForRow(rowNode, rightCols);
    }
    getColsForRow(rowNode, displayedColumns, filterCallback, emptySpaceBeforeColumn) {
        const result = [];
        let lastConsideredCol = null;
        for (let i = 0; i < displayedColumns.length; i++) {
            const col = displayedColumns[i];
            const maxAllowedColSpan = displayedColumns.length - i;
            const colSpan = Math.min(col.getColSpan(rowNode), maxAllowedColSpan);
            const columnsToCheckFilter = [col];
            if (colSpan > 1) {
                const colsToRemove = colSpan - 1;
                for (let j = 1; j <= colsToRemove; j++) {
                    columnsToCheckFilter.push(displayedColumns[i + j]);
                }
                i += colsToRemove;
            }
            // see which cols we should take out for column virtualisation
            let filterPasses;
            if (filterCallback) {
                // if user provided a callback, means some columns may not be in the viewport.
                // the user will NOT provide a callback if we are talking about pinned areas,
                // as pinned areas have no horizontal scroll and do not virtualise the columns.
                // if lots of columns, that means column spanning, and we set filterPasses = true
                // if one or more of the columns spanned pass the filter.
                filterPasses = false;
                columnsToCheckFilter.forEach((colForFilter) => {
                    if (filterCallback(colForFilter)) {
                        filterPasses = true;
                    }
                });
            }
            else {
                filterPasses = true;
            }
            if (filterPasses) {
                if (result.length === 0 && lastConsideredCol) {
                    const gapBeforeColumn = emptySpaceBeforeColumn ? emptySpaceBeforeColumn(col) : false;
                    if (gapBeforeColumn) {
                        result.push(lastConsideredCol);
                    }
                }
                result.push(col);
            }
            lastConsideredCol = col;
        }
        return result;
    }
    getContainerWidth(pinned) {
        switch (pinned) {
            case 'left':
                return this.leftWidth;
            case 'right':
                return this.rightWidth;
            default:
                return this.bodyWidth;
        }
    }
    getColBefore(col) {
        const allDisplayedColumns = this.allCols;
        const oldIndex = allDisplayedColumns.indexOf(col);
        if (oldIndex > 0) {
            return allDisplayedColumns[oldIndex - 1];
        }
        return null;
    }
    isPinningLeft() {
        return this.leftCols.length > 0;
    }
    isPinningRight() {
        return this.rightCols.length > 0;
    }
    updateColsAndGroupsMap() {
        this.colsAndGroupsMap = {};
        const func = (child) => {
            this.colsAndGroupsMap[child.getUniqueId()] = child;
        };
        depthFirstAllColumnTreeSearch(this.treeCenter, false, func);
        depthFirstAllColumnTreeSearch(this.treeLeft, false, func);
        depthFirstAllColumnTreeSearch(this.treeRight, false, func);
    }
    isVisible(item) {
        const fromMap = this.colsAndGroupsMap[item.getUniqueId()];
        // check for reference, in case new column / group with same id is now present
        return fromMap === item;
    }
    getFirstColumn() {
        const isRtl = this.gos.get('enableRtl');
        const queryOrder = ['leftCols', 'centerCols', 'rightCols'];
        if (isRtl) {
            queryOrder.reverse();
        }
        for (let i = 0; i < queryOrder.length; i++) {
            const container = this[queryOrder[i]];
            if (container.length) {
                return isRtl ? (0, array_1._last)(container) : container[0];
            }
        }
        return null;
    }
    // used by:
    // + rowRenderer -> for navigation
    getColAfter(col) {
        const allDisplayedColumns = this.allCols;
        const oldIndex = allDisplayedColumns.indexOf(col);
        if (oldIndex < allDisplayedColumns.length - 1) {
            return allDisplayedColumns[oldIndex + 1];
        }
        return null;
    }
    // used by:
    // + angularGrid -> setting pinned body width
    // note: this should be cached
    getColsLeftWidth() {
        return (0, columnUtils_1.getWidthOfColsInList)(this.leftCols);
    }
    // note: this should be cached
    getDisplayedColumnsRightWidth() {
        return (0, columnUtils_1.getWidthOfColsInList)(this.rightCols);
    }
    isColAtEdge(col, edge) {
        const allColumns = this.allCols;
        if (!allColumns.length) {
            return false;
        }
        const isFirst = edge === 'first';
        let columnToCompare;
        if ((0, agColumnGroup_1.isColumnGroup)(col)) {
            const leafColumns = col.getDisplayedLeafColumns();
            if (!leafColumns.length) {
                return false;
            }
            columnToCompare = isFirst ? leafColumns[0] : (0, array_1._last)(leafColumns);
        }
        else {
            columnToCompare = col;
        }
        return (isFirst ? allColumns[0] : (0, array_1._last)(allColumns)) === columnToCompare;
    }
}
exports.VisibleColsService = VisibleColsService;
function depthFirstAllColumnTreeSearch(tree, useDisplayedChildren, callback) {
    if (!tree) {
        return;
    }
    for (let i = 0; i < tree.length; i++) {
        const child = tree[i];
        if ((0, agColumnGroup_1.isColumnGroup)(child)) {
            const childTree = useDisplayedChildren ? child.getDisplayedChildren() : child.getChildren();
            depthFirstAllColumnTreeSearch(childTree, useDisplayedChildren, callback);
        }
        callback(child);
    }
}
exports.depthFirstAllColumnTreeSearch = depthFirstAllColumnTreeSearch;
function pickDisplayedCols(tree) {
    const res = [];
    depthFirstAllColumnTreeSearch(tree, true, (child) => {
        if ((0, agColumn_1.isColumn)(child)) {
            res.push(child);
        }
    });
    return res;
}


/***/ }),

/***/ 3789:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.setupCompBean = exports.EmptyBean = void 0;
const beanStub_1 = __webpack_require__(8731);
/**
 * An EmptyBean can be used to manage the lifecycle of event handlers that are tied to a component instead of a controller.
 * Used in React to avoid duplicating listeners and setup logic while React is running in StrictMode where setComp will be called multiple times.
 * This is only required for the Components where the ctrl is managed by AG Grid and passed into the React component.
 * Both React and the Ctrl can decide to destroy the EmptyBean which will clean up listeners setup against it.
 */
class EmptyBean extends beanStub_1.BeanStub {
}
exports.EmptyBean = EmptyBean;
/**
 * Sets up the logic for managing the lifecycle of a compBean against a ctrl so that we always cleanup
 * our listeners and destroy the compBean when the ctrl is destroyed no matter which is destroyed first.
 * Closely related to React StrictMode as the compBean is provided from React so it can double render
 * and correctly cleanup listeners from the first render.
 * @param ctrl Ctrl that has setComp called against it
 * @param ctx  Context to use to destroy the compBean
 * @param compBean Optional compBean to use, if not provided, the ctrl will be used
 * @returns The compBean if provided, otherwise the ctrl
 */
function setupCompBean(ctrl, ctx, compBean) {
    if (compBean) {
        // If the ctrl is destroyed first, we need to destroy the compBean
        ctrl.addDestroyFunc(() => ctx.destroyBean(compBean));
    }
    return compBean ?? ctrl;
}
exports.setupCompBean = setupCompBean;


/***/ }),

/***/ 4309:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgComponentUtils = void 0;
const beanStub_1 = __webpack_require__(8731);
const dom_1 = __webpack_require__(3507);
class AgComponentUtils extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'agCompUtils';
    }
    adaptFunction(type, jsCompFunc) {
        if (!type.cellRenderer) {
            return null;
        }
        class Adapter {
            refresh() {
                return false;
            }
            getGui() {
                return this.eGui;
            }
            init(params) {
                const callbackResult = jsCompFunc(params);
                const type = typeof callbackResult;
                if (type === 'string' || type === 'number' || type === 'boolean') {
                    this.eGui = (0, dom_1._loadTemplate)('<span>' + callbackResult + '</span>');
                    return;
                }
                if (callbackResult == null) {
                    this.eGui = (0, dom_1._createElement)({ tag: 'span' });
                    return;
                }
                this.eGui = callbackResult;
            }
        }
        return Adapter;
    }
}
exports.AgComponentUtils = AgComponentUtils;


/***/ }),

/***/ 8414:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CellRendererFunctionModule = void 0;
const version_1 = __webpack_require__(7205);
const agComponentUtils_1 = __webpack_require__(4309);
/**
 * @internal
 */
exports.CellRendererFunctionModule = {
    moduleName: 'CellRendererFunction',
    version: version_1.VERSION,
    beans: [agComponentUtils_1.AgComponentUtils],
};


/***/ }),

/***/ 8759:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseComponentWrapper = void 0;
const logging_1 = __webpack_require__(7764);
class BaseComponentWrapper {
    wrap(OriginalConstructor, mandatoryMethods, optionalMethods, componentType) {
        const wrapper = this.createWrapper(OriginalConstructor, componentType);
        mandatoryMethods?.forEach((methodName) => {
            this.createMethod(wrapper, methodName, true);
        });
        optionalMethods?.forEach((methodName) => {
            this.createMethod(wrapper, methodName, false);
        });
        return wrapper;
    }
    createMethod(wrapper, methodName, mandatory) {
        wrapper.addMethod(methodName, this.createMethodProxy(wrapper, methodName, mandatory));
    }
    createMethodProxy(wrapper, methodName, mandatory) {
        return function () {
            if (wrapper.hasMethod(methodName)) {
                // eslint-disable-next-line
                return wrapper.callMethod(methodName, arguments);
            }
            if (mandatory) {
                (0, logging_1._warn)(49, { methodName });
            }
            // multiple features rely on this returning `null` rather than `undefined`,
            // so that they can differentiate whether the underlying component has implemented a void method or not
            return null;
        };
    }
}
exports.BaseComponentWrapper = BaseComponentWrapper;


/***/ }),

/***/ 4110:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Registry = void 0;
const beanStub_1 = __webpack_require__(8731);
const context_1 = __webpack_require__(2342);
const logging_1 = __webpack_require__(7764);
class Registry extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'registry';
        this.agGridDefaults = {};
        this.agGridDefaultOverrides = {};
        this.jsComps = {};
        this.selectors = {};
        this.icons = {};
    }
    postConstruct() {
        const comps = this.gos.get('components');
        if (comps != null) {
            for (const key of Object.keys(comps)) {
                this.jsComps[key] = comps[key];
            }
        }
    }
    registerModule(module) {
        const { icons, userComponents, dynamicBeans, selectors } = module;
        if (userComponents) {
            const registerUserComponent = (name, component, params, processParams) => {
                this.agGridDefaults[name] = component;
                if (params || processParams) {
                    this.agGridDefaultOverrides[name] = { params, processParams };
                }
            };
            for (const name of Object.keys(userComponents)) {
                let comp = userComponents[name];
                if ((0, context_1.isComponentMetaFunc)(comp)) {
                    comp = comp.getComp(this.beans);
                }
                if (typeof comp === 'object') {
                    const { classImp, params, processParams } = comp;
                    registerUserComponent(name, classImp, params, processParams);
                }
                else {
                    registerUserComponent(name, comp);
                }
            }
        }
        if (dynamicBeans) {
            // initialise the dynamic beans registry on first use
            this.dynamicBeans ?? (this.dynamicBeans = {});
            for (const name of Object.keys(dynamicBeans)) {
                this.dynamicBeans[name] = dynamicBeans[name];
            }
        }
        selectors?.forEach((selector) => {
            this.selectors[selector.selector] = selector;
        });
        if (icons) {
            for (const name of Object.keys(icons)) {
                this.icons[name] = icons[name];
            }
        }
    }
    getUserComponent(propertyName, name) {
        const createResult = (component, componentFromFramework, params, processParams) => ({
            componentFromFramework,
            component,
            params,
            processParams,
        });
        const { frameworkOverrides } = this.beans;
        // FrameworkOverrides.frameworkComponent() is used in two locations:
        // 1) for Vue, user provided components get registered via a framework specific way.
        // 2) for React, it's how the React UI provides alternative default components (eg GroupCellRenderer and DetailCellRenderer)
        const registeredViaFrameworkComp = frameworkOverrides.frameworkComponent(name, this.gos.get('components'));
        if (registeredViaFrameworkComp != null) {
            return createResult(registeredViaFrameworkComp, true);
        }
        const jsComponent = this.jsComps[name];
        if (jsComponent) {
            const isFwkComp = frameworkOverrides.isFrameworkComponent(jsComponent);
            return createResult(jsComponent, isFwkComp);
        }
        const defaultComponent = this.agGridDefaults[name];
        if (defaultComponent) {
            const overrides = this.agGridDefaultOverrides[name];
            return createResult(defaultComponent, false, overrides?.params, overrides?.processParams);
        }
        this.beans.validation?.missingUserComponent(propertyName, name, this.agGridDefaults, this.jsComps);
        return null;
    }
    createDynamicBean(name, mandatory, ...args) {
        if (!this.dynamicBeans) {
            // this happens when a module tries to init a dynamic bean during module initialization lifecycle
            throw new Error((0, logging_1._errMsg)(279, { name }));
        }
        const BeanClass = this.dynamicBeans[name];
        if (BeanClass == null) {
            if (mandatory) {
                throw new Error(this.beans.validation?.missingDynamicBean(name) ?? (0, logging_1._errMsg)(256));
            }
            return undefined;
        }
        return new BeanClass(...args);
    }
    getSelector(name) {
        return this.selectors[name];
    }
    getIcon(name) {
        return this.icons[name];
    }
}
exports.Registry = Registry;


/***/ }),

/***/ 4126:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._unwrapUserComp = void 0;
function _unwrapUserComp(comp) {
    const compAsAny = comp;
    const isProxy = compAsAny != null && compAsAny.getFrameworkComponentInstance != null;
    return isProxy ? compAsAny.getFrameworkComponentInstance() : comp;
}
exports._unwrapUserComp = _unwrapUserComp;


/***/ }),

/***/ 2036:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._mergeFilterParamsWithApplicationProvidedParams = exports._getFilterCompKeys = exports._getFloatingFilterCompDetails = exports._getTooltipCompDetails = exports._getNoRowsOverlayCompDetails = exports._getLoadingOverlayCompDetails = exports._getDateCompDetails = exports._getFilterDetails = exports._getCellEditorDetails = exports._getLoadingCellRendererDetails = exports._getEditorRendererDetails = exports._getCellRendererDetails = exports._getFullWidthDetailCellRendererDetails = exports._getFullWidthGroupCellRendererDetails = exports._getFullWidthLoadingCellRendererDetails = exports._getFullWidthCellRendererDetails = exports._getInnerHeaderGroupCompDetails = exports._getHeaderGroupCompDetails = exports._getInnerHeaderCompDetails = exports._getHeaderCompDetails = exports._getInnerCellRendererDetails = exports._getDragAndDropImageCompDetails = void 0;
const iFilter_1 = __webpack_require__(5679);
const userComponentFactory_1 = __webpack_require__(1585);
const DateComponent = {
    name: 'dateComponent',
    mandatoryMethods: ['getDate', 'setDate'],
    optionalMethods: ['afterGuiAttached', 'setInputPlaceholder', 'setInputAriaLabel', 'setDisabled', 'refresh'],
};
const DragAndDropImageComponent = {
    name: 'dragAndDropImageComponent',
    mandatoryMethods: ['setIcon', 'setLabel'],
};
const HeaderComponent = { name: 'headerComponent', optionalMethods: ['refresh'] };
const InnerHeaderComponent = { name: 'innerHeaderComponent' };
const InnerHeaderGroupComponent = { name: 'innerHeaderGroupComponent' };
const HeaderGroupComponent = { name: 'headerGroupComponent' };
const InnerCellRendererComponent = {
    name: 'innerRenderer',
    cellRenderer: true,
    optionalMethods: ['afterGuiAttached'],
};
const CellRendererComponent = {
    name: 'cellRenderer',
    optionalMethods: ['refresh', 'afterGuiAttached'],
    cellRenderer: true,
};
const EditorRendererComponent = {
    name: 'cellRenderer',
    optionalMethods: ['refresh', 'afterGuiAttached'],
};
const LoadingCellRendererComponent = { name: 'loadingCellRenderer', cellRenderer: true };
const CellEditorComponent = {
    name: 'cellEditor',
    mandatoryMethods: ['getValue'],
    optionalMethods: [
        'isPopup',
        'isCancelBeforeStart',
        'isCancelAfterEnd',
        'getPopupPosition',
        'focusIn',
        'focusOut',
        'afterGuiAttached',
        'refresh',
    ],
};
const LoadingOverlayComponent = { name: 'loadingOverlayComponent', optionalMethods: ['refresh'] };
const NoRowsOverlayComponent = { name: 'noRowsOverlayComponent', optionalMethods: ['refresh'] };
const TooltipComponent = { name: 'tooltipComponent' };
const FilterComponent = {
    name: 'filter',
    mandatoryMethods: ['isFilterActive', 'doesFilterPass', 'getModel', 'setModel'],
    optionalMethods: [
        'afterGuiAttached',
        'afterGuiDetached',
        'onNewRowsLoaded',
        'getModelAsString',
        'onFloatingFilterChanged',
        'onAnyFilterChanged',
        'refresh',
    ],
};
const FloatingFilterComponent = {
    name: 'floatingFilterComponent',
    mandatoryMethods: ['onParentModelChanged'],
    optionalMethods: ['afterGuiAttached', 'refresh'],
};
const FullWidth = {
    name: 'fullWidthCellRenderer',
    optionalMethods: ['refresh', 'afterGuiAttached'],
    cellRenderer: true,
};
const FullWidthLoading = { name: 'loadingCellRenderer', cellRenderer: true };
const FullWidthGroup = {
    name: 'groupRowRenderer',
    optionalMethods: ['afterGuiAttached'],
    cellRenderer: true,
};
const FullWidthDetail = { name: 'detailCellRenderer', optionalMethods: ['refresh'], cellRenderer: true };
function _getDragAndDropImageCompDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(DragAndDropImageComponent, 'agDragAndDropImage', params, true);
}
exports._getDragAndDropImageCompDetails = _getDragAndDropImageCompDetails;
function _getInnerCellRendererDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, InnerCellRendererComponent, undefined, params);
}
exports._getInnerCellRendererDetails = _getInnerCellRendererDetails;
function _getHeaderCompDetails(userCompFactory, colDef, params) {
    return userCompFactory.getCompDetails(colDef, HeaderComponent, 'agColumnHeader', params);
}
exports._getHeaderCompDetails = _getHeaderCompDetails;
function _getInnerHeaderCompDetails(userCompFactory, headerCompParams, params) {
    return userCompFactory.getCompDetails(headerCompParams, InnerHeaderComponent, undefined, params);
}
exports._getInnerHeaderCompDetails = _getInnerHeaderCompDetails;
function _getHeaderGroupCompDetails(userCompFactory, params) {
    const colGroupDef = params.columnGroup.getColGroupDef();
    return userCompFactory.getCompDetails(colGroupDef, HeaderGroupComponent, 'agColumnGroupHeader', params);
}
exports._getHeaderGroupCompDetails = _getHeaderGroupCompDetails;
function _getInnerHeaderGroupCompDetails(userCompFactory, headerGroupCompParams, params) {
    return userCompFactory.getCompDetails(headerGroupCompParams, InnerHeaderGroupComponent, undefined, params);
}
exports._getInnerHeaderGroupCompDetails = _getInnerHeaderGroupCompDetails;
// this one is unusual, as it can be LoadingCellRenderer, DetailCellRenderer, FullWidthCellRenderer or GroupRowRenderer.
// so we have to pass the type in.
function _getFullWidthCellRendererDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(FullWidth, undefined, params, true);
}
exports._getFullWidthCellRendererDetails = _getFullWidthCellRendererDetails;
function _getFullWidthLoadingCellRendererDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(FullWidthLoading, 'agLoadingCellRenderer', params, true);
}
exports._getFullWidthLoadingCellRendererDetails = _getFullWidthLoadingCellRendererDetails;
function _getFullWidthGroupCellRendererDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(FullWidthGroup, 'agGroupRowRenderer', params, true);
}
exports._getFullWidthGroupCellRendererDetails = _getFullWidthGroupCellRendererDetails;
function _getFullWidthDetailCellRendererDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(FullWidthDetail, 'agDetailCellRenderer', params, true);
}
exports._getFullWidthDetailCellRendererDetails = _getFullWidthDetailCellRendererDetails;
// CELL RENDERER
function _getCellRendererDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, CellRendererComponent, undefined, params);
}
exports._getCellRendererDetails = _getCellRendererDetails;
function _getEditorRendererDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, EditorRendererComponent, undefined, params);
}
exports._getEditorRendererDetails = _getEditorRendererDetails;
function _getLoadingCellRendererDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, LoadingCellRendererComponent, 'agSkeletonCellRenderer', params, true);
}
exports._getLoadingCellRendererDetails = _getLoadingCellRendererDetails;
// CELL EDITOR
function _getCellEditorDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, CellEditorComponent, 'agCellEditor', params, true);
}
exports._getCellEditorDetails = _getCellEditorDetails;
// FILTER
/**
 * @param defaultFilter provided filters only
 */
function _getFilterDetails(userCompFactory, def, params, defaultFilter) {
    const filter = def.filter;
    if ((0, iFilter_1.isColumnFilterComp)(filter)) {
        def = {
            filter: filter.component,
            filterParams: def.filterParams,
        };
    }
    return userCompFactory.getCompDetails(def, FilterComponent, defaultFilter, params, true);
}
exports._getFilterDetails = _getFilterDetails;
function _getDateCompDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, DateComponent, 'agDateInput', params, true);
}
exports._getDateCompDetails = _getDateCompDetails;
function _getLoadingOverlayCompDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(LoadingOverlayComponent, 'agLoadingOverlay', params, true);
}
exports._getLoadingOverlayCompDetails = _getLoadingOverlayCompDetails;
function _getNoRowsOverlayCompDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(NoRowsOverlayComponent, 'agNoRowsOverlay', params, true);
}
exports._getNoRowsOverlayCompDetails = _getNoRowsOverlayCompDetails;
function _getTooltipCompDetails(userCompFactory, params) {
    return userCompFactory.getCompDetails(params.colDef, TooltipComponent, 'agTooltipComponent', params, true);
}
exports._getTooltipCompDetails = _getTooltipCompDetails;
/**
 * @param defaultFloatingFilter provided floating filters only
 */
function _getFloatingFilterCompDetails(userCompFactory, def, params, defaultFloatingFilter) {
    return userCompFactory.getCompDetails(def, FloatingFilterComponent, defaultFloatingFilter, params);
}
exports._getFloatingFilterCompDetails = _getFloatingFilterCompDetails;
function _getFilterCompKeys(frameworkOverrides, def) {
    return (0, userComponentFactory_1._getUserCompKeys)(frameworkOverrides, def, FilterComponent);
}
exports._getFilterCompKeys = _getFilterCompKeys;
function _mergeFilterParamsWithApplicationProvidedParams(userCompFactory, defObject, paramsFromGrid) {
    return userCompFactory.mergeParams(defObject, FilterComponent, paramsFromGrid);
}
exports._mergeFilterParamsWithApplicationProvidedParams = _mergeFilterParamsWithApplicationProvidedParams;


/***/ }),

/***/ 1585:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserComponentFactory = exports._getUserCompKeys = void 0;
const beanStub_1 = __webpack_require__(8731);
const object_1 = __webpack_require__(6996);
const promise_1 = __webpack_require__(7990);
const logging_1 = __webpack_require__(7764);
function doesImplementIComponent(candidate) {
    if (!candidate) {
        return false;
    }
    return candidate.prototype && 'getGui' in candidate.prototype;
}
function _getUserCompKeys(frameworkOverrides, defObject, type, params) {
    const { name } = type;
    let compName;
    let jsComp;
    let fwComp;
    let paramsFromSelector;
    let popupFromSelector;
    let popupPositionFromSelector;
    // there are two types of js comps, class based and func based. we can only check for
    // class based, by checking if getGui() exists. no way to differentiate js func based vs eg react func based
    // const isJsClassComp = (comp: any) => doesImplementIComponent(comp);
    // const fwActive = this.frameworkCompWrapper != null;
    // pull from defObject if available
    if (defObject) {
        const defObjectAny = defObject;
        // if selector, use this
        const selectorFunc = defObjectAny[name + 'Selector'];
        const selectorRes = selectorFunc ? selectorFunc(params) : null;
        const assignComp = (providedJsComp) => {
            if (typeof providedJsComp === 'string') {
                compName = providedJsComp;
            }
            else if (providedJsComp != null && providedJsComp !== true) {
                const isFwkComp = frameworkOverrides.isFrameworkComponent(providedJsComp);
                if (isFwkComp) {
                    fwComp = providedJsComp;
                }
                else {
                    jsComp = providedJsComp;
                }
            }
        };
        if (selectorRes) {
            assignComp(selectorRes.component);
            paramsFromSelector = selectorRes.params;
            popupFromSelector = selectorRes.popup;
            popupPositionFromSelector = selectorRes.popupPosition;
        }
        else {
            // if no selector, or result of selector is empty, take from defObject
            assignComp(defObjectAny[name]);
        }
    }
    return { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector };
}
exports._getUserCompKeys = _getUserCompKeys;
class UserComponentFactory extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'userCompFactory';
    }
    wireBeans(beans) {
        this.agCompUtils = beans.agCompUtils;
        this.registry = beans.registry;
        this.frameworkCompWrapper = beans.frameworkCompWrapper;
        this.gridOptions = beans.gridOptions;
    }
    getCompDetailsFromGridOptions(type, defaultName, params, mandatory = false) {
        return this.getCompDetails(this.gridOptions, type, defaultName, params, mandatory);
    }
    getCompDetails(defObject, type, defaultName, params, mandatory = false) {
        const { name, cellRenderer } = type;
        let { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector } = _getUserCompKeys(this.beans.frameworkOverrides, defObject, type, params);
        // for grid-provided comps only
        let defaultCompParams;
        let defaultCompProcessParams;
        const lookupFromRegistry = (key) => {
            const item = this.registry.getUserComponent(name, key);
            if (item) {
                jsComp = !item.componentFromFramework ? item.component : undefined;
                fwComp = item.componentFromFramework ? item.component : undefined;
                defaultCompParams = item.params;
                defaultCompProcessParams = item.processParams;
            }
        };
        // if compOption is a string, means we need to look the item up
        if (compName != null) {
            lookupFromRegistry(compName);
        }
        // if lookup brought nothing back, and we have a default, lookup the default
        if (jsComp == null && fwComp == null && defaultName != null) {
            lookupFromRegistry(defaultName);
        }
        // if we have a comp option, and it's a function, replace it with an object equivalent adaptor
        if (jsComp && cellRenderer && !doesImplementIComponent(jsComp)) {
            jsComp = this.agCompUtils?.adaptFunction(type, jsComp);
        }
        if (!jsComp && !fwComp) {
            const { validation } = this.beans;
            if (mandatory && (compName !== defaultName || !defaultName)) {
                // expecting the user to provide a component with this name
                if (compName) {
                    // If we have validation and this is a grid comp without a default (e.g. filters tool panel),
                    // we will have already warned about this
                    if (!validation?.isProvidedUserComp(compName)) {
                        (0, logging_1._error)(50, { compName });
                    }
                }
                else {
                    if (defaultName) {
                        // validation will have already warned about this
                        if (!validation) {
                            (0, logging_1._error)(260, {
                                ...this.gos.getModuleErrorParams(),
                                propName: name,
                                compName: defaultName,
                            });
                        }
                    }
                    else {
                        (0, logging_1._error)(216, { name });
                    }
                }
            }
            else if (defaultName && !validation) {
                // Grid should be providing this component.
                // Validation service will have already warned about this with the correct module name if it was present.
                (0, logging_1._error)(146, { comp: defaultName });
            }
            return;
        }
        const paramsMerged = this.mergeParams(defObject, type, params, paramsFromSelector, defaultCompParams, defaultCompProcessParams);
        const componentFromFramework = jsComp == null;
        const componentClass = jsComp ?? fwComp;
        return {
            componentFromFramework,
            componentClass,
            params: paramsMerged,
            type: type,
            popupFromSelector,
            popupPositionFromSelector,
            newAgStackInstance: () => this.newAgStackInstance(componentClass, componentFromFramework, paramsMerged, type),
        };
    }
    newAgStackInstance(ComponentClass, componentFromFramework, params, type) {
        const jsComponent = !componentFromFramework;
        // using javascript component
        let instance;
        if (jsComponent) {
            instance = new ComponentClass();
        }
        else {
            // Using framework component
            instance = this.frameworkCompWrapper.wrap(ComponentClass, type.mandatoryMethods, type.optionalMethods, type);
        }
        this.createBean(instance);
        const deferredInit = instance.init?.(params);
        if (deferredInit == null) {
            return promise_1.AgPromise.resolve(instance);
        }
        return deferredInit.then(() => instance);
    }
    /**
     * merges params with application provided params
     * used by Floating Filter
     */
    mergeParams(defObject, type, paramsFromGrid, paramsFromSelector = null, defaultCompParams, defaultCompProcessParams) {
        const params = { ...paramsFromGrid, ...defaultCompParams };
        // pull user params from the defObject
        const defObjectAny = defObject;
        const userParams = defObjectAny && defObjectAny[type.name + 'Params'];
        if (typeof userParams === 'function') {
            const userParamsFromFunc = userParams(paramsFromGrid);
            (0, object_1._mergeDeep)(params, userParamsFromFunc);
        }
        else if (typeof userParams === 'object') {
            (0, object_1._mergeDeep)(params, userParams);
        }
        (0, object_1._mergeDeep)(params, paramsFromSelector);
        return defaultCompProcessParams ? defaultCompProcessParams(params) : params;
    }
}
exports.UserComponentFactory = UserComponentFactory;


/***/ }),

/***/ 9853:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KeyCode = void 0;
exports.KeyCode = {
    BACKSPACE: 'Backspace',
    TAB: 'Tab',
    ENTER: 'Enter',
    ESCAPE: 'Escape',
    SPACE: ' ',
    LEFT: 'ArrowLeft',
    UP: 'ArrowUp',
    RIGHT: 'ArrowRight',
    DOWN: 'ArrowDown',
    DELETE: 'Delete',
    F2: 'F2',
    PAGE_UP: 'PageUp',
    PAGE_DOWN: 'PageDown',
    PAGE_HOME: 'Home',
    PAGE_END: 'End',
    // these should be used with `event.code` instead of `event.key`
    // as `event.key` changes when non-latin keyboards are used
    A: 'KeyA',
    C: 'KeyC',
    D: 'KeyD',
    V: 'KeyV',
    X: 'KeyX',
    Y: 'KeyY',
    Z: 'KeyZ',
};


/***/ }),

/***/ 8731:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BeanStub = void 0;
const localEventService_1 = __webpack_require__(5889);
const localeUtils_1 = __webpack_require__(7230);
const event_1 = __webpack_require__(2979);
class BeanStub {
    constructor() {
        this.destroyFunctions = [];
        this.destroyed = false;
        // for vue 3 - prevents Vue from trying to make this (and obviously any sub classes) from being reactive
        // prevents vue from creating proxies for created objects and prevents identity related issues
        this.__v_skip = true;
        this.propertyListenerId = 0;
        // Enable multiple grid properties to be updated together by the user but only trigger shared logic once.
        // Closely related to logic in GridOptionsUtils.ts _processOnChange
        this.lastChangeSetIdLookup = {};
        this.isAlive = () => !this.destroyed;
    }
    preWireBeans(beans) {
        this.beans = beans;
        this.stubContext = beans.context;
        this.eventSvc = beans.eventSvc;
        this.gos = beans.gos;
    }
    // this was a test constructor niall built, when active, it prints after 5 seconds all beans/components that are
    // not destroyed. to use, create a new grid, then api.destroy() before 5 seconds. then anything that gets printed
    // points to a bean or component that was not properly disposed of.
    // constructor() {
    //     setTimeout(()=> {
    //         if (this.isAlive()) {
    //             let prototype: any = Object.getPrototypeOf(this);
    //             const constructor: any = prototype.constructor;
    //             const constructorString = constructor.toString();
    //             const beanName = constructorString.substring(9, constructorString.indexOf("("));
    //             console.log('is alive ' + beanName);
    //         }
    //     }, 5000);
    // }
    destroy() {
        const { destroyFunctions } = this;
        for (let i = 0; i < destroyFunctions.length; i++) {
            destroyFunctions[i]();
        }
        destroyFunctions.length = 0;
        this.destroyed = true;
        // cast destroy type as we do not want to expose destroy event type to the dispatchLocalEvent method
        // as no one else should be firing destroyed at the bean stub.
        this.dispatchLocalEvent({ type: 'destroyed' });
    }
    // The typing of AgEventListener<any, any, any> is not ideal, but it's the best we can do at the moment to enable
    // eventSvc to have the best typing at the expense of BeanStub local events
    /** Add a local event listener against this BeanStub */
    addEventListener(eventType, listener, async) {
        if (!this.localEventService) {
            this.localEventService = new localEventService_1.LocalEventService();
        }
        this.localEventService.addEventListener(eventType, listener, async);
    }
    /** Remove a local event listener from this BeanStub */
    removeEventListener(eventType, listener, async) {
        this.localEventService?.removeEventListener(eventType, listener, async);
    }
    dispatchLocalEvent(event) {
        this.localEventService?.dispatchEvent(event);
    }
    addManagedElementListeners(object, handlers) {
        return this._setupListeners(object, handlers);
    }
    addManagedEventListeners(handlers) {
        return this._setupListeners(this.eventSvc, handlers);
    }
    addManagedListeners(object, handlers) {
        return this._setupListeners(object, handlers);
    }
    _setupListeners(object, handlers) {
        const destroyFuncs = [];
        for (const k of Object.keys(handlers)) {
            const handler = handlers[k];
            if (handler) {
                destroyFuncs.push(this._setupListener(object, k, handler));
            }
        }
        return destroyFuncs;
    }
    _setupListener(object, event, listener) {
        if (this.destroyed) {
            return () => null;
        }
        let destroyFunc;
        if (isAgEventEmitter(object)) {
            object.__addEventListener(event, listener);
            destroyFunc = () => {
                object.__removeEventListener(event, listener);
                return null;
            };
        }
        else {
            if (object instanceof HTMLElement) {
                (0, event_1._addSafePassiveEventListener)(this.beans.frameworkOverrides, object, event, listener);
            }
            else {
                object.addEventListener(event, listener);
            }
            destroyFunc = () => {
                object.removeEventListener(event, listener);
                return null;
            };
        }
        this.destroyFunctions.push(destroyFunc);
        return () => {
            destroyFunc();
            // Only remove if manually called before bean is destroyed
            this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
            return null;
        };
    }
    /**
     * Setup a managed property listener for the given GridOption property.
     * However, stores the destroy function in the beanStub so that if this bean
     * is a component the destroy function will be called when the component is destroyed
     * as opposed to being cleaned up only when the GridOptionsService is destroyed.
     */
    setupGridOptionListener(event, listener) {
        const { gos } = this;
        gos.addPropertyEventListener(event, listener);
        const destroyFunc = () => {
            gos.removePropertyEventListener(event, listener);
            return null;
        };
        this.destroyFunctions.push(destroyFunc);
        return () => {
            destroyFunc();
            // Only remove if manually called before bean is destroyed
            this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
            return null;
        };
    }
    /**
     * Setup a managed property listener for the given GridOption property.
     * @param event GridOption property to listen to changes for.
     * @param listener Listener to run when property value changes
     */
    addManagedPropertyListener(event, listener) {
        if (this.destroyed) {
            return () => null;
        }
        return this.setupGridOptionListener(event, listener);
    }
    /**
     * Setup managed property listeners for the given set of GridOption properties.
     * The listener will be run if any of the property changes but will only run once if
     * multiple of the properties change within the same framework lifecycle event.
     * Works on the basis that GridOptionsService updates all properties *before* any property change events are fired.
     * @param events Array of GridOption properties to listen for changes too.
     * @param listener Shared listener to run if any of the properties change
     */
    addManagedPropertyListeners(events, listener) {
        if (this.destroyed) {
            return;
        }
        // Ensure each set of events can run for the same changeSetId
        const eventsKey = events.join('-') + this.propertyListenerId++;
        const wrappedListener = (event) => {
            if (event.changeSet) {
                // ChangeSet is only set when the property change is part of a group of changes from ComponentUtils
                // Direct api calls should always be run as
                if (event.changeSet && event.changeSet.id === this.lastChangeSetIdLookup[eventsKey]) {
                    // Already run the listener for this set of prop changes so don't run again
                    return;
                }
                this.lastChangeSetIdLookup[eventsKey] = event.changeSet.id;
            }
            // Don't expose the underlying event value changes to the group listener.
            const propertiesChangeEvent = {
                type: 'gridPropertyChanged',
                changeSet: event.changeSet,
                source: event.source,
            };
            listener(propertiesChangeEvent);
        };
        events.forEach((event) => this.setupGridOptionListener(event, wrappedListener));
    }
    getLocaleTextFunc() {
        return (0, localeUtils_1._getLocaleTextFunc)(this.beans.localeSvc);
    }
    addDestroyFunc(func) {
        // if we are already destroyed, we execute the func now
        if (this.isAlive()) {
            this.destroyFunctions.push(func);
        }
        else {
            func();
        }
    }
    /** doesn't throw an error if `bean` is undefined */
    createOptionalManagedBean(bean, context) {
        return bean ? this.createManagedBean(bean, context) : undefined;
    }
    createManagedBean(bean, context) {
        const res = this.createBean(bean, context);
        this.addDestroyFunc(this.destroyBean.bind(this, bean, context));
        return res;
    }
    createBean(bean, context, afterPreCreateCallback) {
        return (context || this.stubContext).createBean(bean, afterPreCreateCallback);
    }
    /**
     * Destroys a bean and returns undefined to support destruction and clean up in a single line.
     * this.dateComp = this.context.destroyBean(this.dateComp);
     */
    destroyBean(bean, context) {
        return (context || this.stubContext).destroyBean(bean);
    }
    /**
     * Destroys an array of beans and returns an empty array to support destruction and clean up in a single line.
     * this.dateComps = this.context.destroyBeans(this.dateComps);
     */
    destroyBeans(beans, context) {
        return (context || this.stubContext).destroyBeans(beans);
    }
}
exports.BeanStub = BeanStub;
// type guard for IAgEventEmitter
function isAgEventEmitter(object) {
    return object.__addEventListener !== undefined;
}


/***/ }),

/***/ 2342:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Context = exports.isComponentMetaFunc = void 0;
const moduleRegistry_1 = __webpack_require__(2132);
const genericContext_1 = __webpack_require__(569);
function isComponentMetaFunc(componentMeta) {
    return typeof componentMeta === 'object' && !!componentMeta.getComp;
}
exports.isComponentMetaFunc = isComponentMetaFunc;
class Context extends genericContext_1.GenericContext {
    init(params) {
        this.gridId = params.gridId;
        this.beans.context = this;
        this.destroyCallback = params.destroyCallback;
        super.init(params);
    }
    destroy() {
        super.destroy();
        (0, moduleRegistry_1._unRegisterGridModules)(this.gridId);
        this.destroyCallback?.();
    }
    getGridId() {
        return this.gridId;
    }
}
exports.Context = Context;


/***/ }),

/***/ 569:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GenericContext = void 0;
class GenericContext {
    constructor(params) {
        this.beans = {};
        this.createdBeans = [];
        this.destroyed = false;
        if (!params || !params.beanClasses) {
            return;
        }
        this.beanDestroyComparator = params.beanDestroyComparator;
        this.init(params);
    }
    init(params) {
        for (const beanName of Object.keys(params.providedBeanInstances)) {
            this.beans[beanName] = params.providedBeanInstances[beanName];
        }
        params.beanClasses.forEach((BeanClass) => {
            const instance = new BeanClass();
            if (instance.beanName) {
                this.beans[instance.beanName] = instance;
            }
            else {
                // eslint-disable-next-line no-console
                console.error(`Bean ${BeanClass.name} is missing beanName`);
            }
            this.createdBeans.push(instance);
        });
        params.derivedBeans?.forEach((beanFunc) => {
            const { beanName, bean } = beanFunc(this);
            this.beans[beanName] = bean;
            this.createdBeans.push(bean);
        });
        if (params.beanInitComparator) {
            // sort the beans so that they are in a consistent order
            this.createdBeans.sort(params.beanInitComparator);
        }
        this.initBeans(this.createdBeans);
    }
    getBeanInstances() {
        return Object.values(this.beans);
    }
    createBean(bean, afterPreCreateCallback) {
        this.initBeans([bean], afterPreCreateCallback);
        return bean;
    }
    initBeans(beanInstances, afterPreCreateCallback) {
        beanInstances.forEach((instance) => {
            // used by BaseBeans to avoid the need for calling super.wireBeans() in every subclasses
            instance.preWireBeans?.(this.beans);
            instance.wireBeans?.(this.beans);
        });
        // used by the component class
        beanInstances.forEach((instance) => instance.preConstruct?.());
        if (afterPreCreateCallback) {
            beanInstances.forEach(afterPreCreateCallback);
        }
        beanInstances.forEach((instance) => instance.postConstruct?.());
    }
    getBeans() {
        return this.beans;
    }
    getBean(name) {
        return this.beans[name];
    }
    destroy() {
        if (this.destroyed) {
            return;
        }
        // Set before doing the destroy, so if context.destroy() gets called via another bean
        // we are marked as destroyed already to prevent running destroy() twice
        this.destroyed = true;
        const beanInstances = this.getBeanInstances();
        if (this.beanDestroyComparator) {
            beanInstances.sort(this.beanDestroyComparator);
        }
        this.destroyBeans(beanInstances);
        this.beans = {};
        this.createdBeans = [];
    }
    /**
     * Destroys a bean and returns undefined to support destruction and clean up in a single line.
     * this.dateComp = this.context.destroyBean(this.dateComp);
     */
    destroyBean(bean) {
        bean?.destroy?.();
    }
    /**
     * Destroys an array of beans and returns an empty array to support destruction and clean up in a single line.
     * this.dateComps = this.context.destroyBeans(this.dateComps);
     */
    destroyBeans(beans) {
        if (beans) {
            for (let i = 0; i < beans.length; i++) {
                this.destroyBean(beans[i]);
            }
        }
        return [];
    }
    isDestroyed() {
        return this.destroyed;
    }
}
exports.GenericContext = GenericContext;


/***/ }),

/***/ 3943:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.gridBeanDestroyComparator = exports.gridBeanInitComparator = void 0;
/**
 * We know that there is a risk in a change of behaviour if beans are registered in a different order due to the way
 * that this means that their event listeners will be registered in a different order. If they fire in a different order
 * there is a risk that behaviour will be inconsistent.
 * As core beans are going to become optional and could be registered in unpredictable orders via feature modules,
 * we need to provide a consistent order for them to be registered in.
 *
 * We have not included beans from modules as they will be registered after the core beans in the order they are provided.
 */
const orderedCoreBeans = [
    // Validate license first
    'licenseManager',
    // core beans only
    'environment',
    'eventSvc',
    'gos',
    'paginationAutoPageSizeSvc',
    'apiFunctionSvc',
    'gridApi',
    'registry',
    'agCompUtils',
    'userCompFactory',
    'rowContainerHeight',
    'horizontalResizeSvc',
    'localeSvc',
    'pinnedRowModel',
    'dragSvc',
    'colGroupSvc',
    'visibleCols',
    'popupSvc',
    'selectionSvc',
    'colFilter',
    'quickFilter',
    'filterManager',
    'colModel',
    'headerNavigation',
    'pageBounds',
    'pagination',
    'pageBoundsListener',
    'rowSpanSvc',
    'stickyRowSvc',
    'rowRenderer',
    'expressionSvc',
    'alignedGridsSvc',
    'navigation',
    'valueCache',
    'valueSvc',
    'autoWidthCalc',
    'filterMenuFactory',
    'dragAndDrop',
    'focusSvc',
    'cellNavigation',
    'cellStyles',
    'scrollVisibleSvc',
    'sortSvc',
    'colHover',
    'colAnimation',
    'autoColSvc',
    'selectionColSvc',
    'changeDetectionSvc',
    'animationFrameSvc',
    'undoRedo',
    'colDefFactory',
    'rowStyleSvc',
    'rowNodeBlockLoader',
    'rowNodeSorter',
    'ctrlsSvc',
    'pinnedCols',
    'dataTypeSvc',
    'syncSvc',
    'overlays',
    'stateSvc',
    'expansionSvc',
    'apiEventSvc',
    'ariaAnnounce',
    'menuSvc',
    'colMoves',
    'colAutosize',
    'colFlex',
    'colResize',
    'pivotColsSvc',
    'valueColsSvc',
    'rowGroupColsSvc',
    'funcColsSvc',
    'colNames',
    'colViewport',
    'pivotResultCols',
    'showRowGroupCols',
    'validation', // Have validations run last
];
const beanNamePosition = Object.fromEntries(orderedCoreBeans.map((beanName, index) => [beanName, index]));
function gridBeanInitComparator(bean1, bean2) {
    // if the beans are not in the ordered list, just ensure they are after the ordered beans and stable to provided order
    const index1 = (bean1.beanName ? beanNamePosition[bean1.beanName] : undefined) ?? Number.MAX_SAFE_INTEGER;
    const index2 = (bean2.beanName ? beanNamePosition[bean2.beanName] : undefined) ?? Number.MAX_SAFE_INTEGER;
    return index1 - index2;
}
exports.gridBeanInitComparator = gridBeanInitComparator;
function gridBeanDestroyComparator(bean1, 
// eslint-disable-next-line @typescript-eslint/no-unused-vars
bean2) {
    if (bean1?.beanName === 'gridDestroySvc') {
        return -1;
    }
    if (bean2?.beanName === 'gridDestroySvc') {
        return 1;
    }
    return 0;
}
exports.gridBeanDestroyComparator = gridBeanDestroyComparator;


/***/ }),

/***/ 1310:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CsvCreator = void 0;
const baseCreator_1 = __webpack_require__(7331);
const downloader_1 = __webpack_require__(3885);
const gridOptionsUtils_1 = __webpack_require__(7274);
const logging_1 = __webpack_require__(7764);
const csvSerializingSession_1 = __webpack_require__(5308);
class CsvCreator extends baseCreator_1.BaseCreator {
    constructor() {
        super(...arguments);
        this.beanName = 'csvCreator';
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.colNames = beans.colNames;
        this.rowGroupColsSvc = beans.rowGroupColsSvc;
        this.valueSvc = beans.valueSvc;
    }
    getMergedParams(params) {
        const baseParams = this.gos.get('defaultCsvExportParams');
        return Object.assign({}, baseParams, params);
    }
    export(userParams) {
        if (this.isExportSuppressed()) {
            // Export cancelled.
            (0, logging_1._warn)(51);
            return;
        }
        const mergedParams = this.getMergedParams(userParams);
        const data = this.getData(mergedParams);
        const packagedFile = new Blob(['\ufeff', data], { type: 'text/plain' });
        const fileName = typeof mergedParams.fileName === 'function'
            ? mergedParams.fileName((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {}))
            : mergedParams.fileName;
        (0, downloader_1._downloadFile)(this.getFileName(fileName), packagedFile);
    }
    exportDataAsCsv(params) {
        this.export(params);
    }
    getDataAsCsv(params, skipDefaultParams = false) {
        const mergedParams = skipDefaultParams ? Object.assign({}, params) : this.getMergedParams(params);
        return this.getData(mergedParams);
    }
    getDefaultFileExtension() {
        return 'csv';
    }
    createSerializingSession(params) {
        const { colModel, colNames, rowGroupColsSvc, valueSvc, gos } = this;
        const { processCellCallback, processHeaderCallback, processGroupHeaderCallback, processRowGroupCallback, suppressQuotes, columnSeparator, } = params;
        return new csvSerializingSession_1.CsvSerializingSession({
            colModel,
            colNames,
            valueSvc,
            gos,
            processCellCallback: processCellCallback || undefined,
            processHeaderCallback: processHeaderCallback || undefined,
            processGroupHeaderCallback: processGroupHeaderCallback || undefined,
            processRowGroupCallback: processRowGroupCallback || undefined,
            suppressQuotes: suppressQuotes || false,
            columnSeparator: columnSeparator || ',',
            rowGroupColsSvc,
        });
    }
    isExportSuppressed() {
        return this.gos.get('suppressCsvExport');
    }
}
exports.CsvCreator = CsvCreator;


/***/ }),

/***/ 2984:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.exportDataAsCsv = exports.getDataAsCsv = void 0;
function getDataAsCsv(beans, params) {
    return beans.csvCreator?.getDataAsCsv(params);
}
exports.getDataAsCsv = getDataAsCsv;
function exportDataAsCsv(beans, params) {
    beans.csvCreator?.exportDataAsCsv(params);
}
exports.exportDataAsCsv = exportDataAsCsv;


/***/ }),

/***/ 9734:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CsvExportModule = void 0;
const exportModule_1 = __webpack_require__(2728);
const version_1 = __webpack_require__(7205);
const csvCreator_1 = __webpack_require__(1310);
const csvExportApi_1 = __webpack_require__(2984);
/**
 * @feature Import & Export -> CSV Export
 */
exports.CsvExportModule = {
    moduleName: 'CsvExport',
    version: version_1.VERSION,
    beans: [csvCreator_1.CsvCreator],
    apiFunctions: {
        getDataAsCsv: csvExportApi_1.getDataAsCsv,
        exportDataAsCsv: csvExportApi_1.exportDataAsCsv,
    },
    dependsOn: [exportModule_1.SharedExportModule],
};


/***/ }),

/***/ 5308:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CsvSerializingSession = void 0;
const baseGridSerializingSession_1 = __webpack_require__(8376);
const logging_1 = __webpack_require__(7764);
const LINE_SEPARATOR = '\r\n';
class CsvSerializingSession extends baseGridSerializingSession_1.BaseGridSerializingSession {
    constructor(config) {
        super(config);
        this.config = config;
        this.isFirstLine = true;
        this.result = '';
        const { suppressQuotes, columnSeparator } = config;
        this.suppressQuotes = suppressQuotes;
        this.columnSeparator = columnSeparator;
    }
    addCustomContent(content) {
        if (!content) {
            return;
        }
        if (typeof content === 'string') {
            if (!/^\s*\n/.test(content)) {
                this.beginNewLine();
            }
            // replace whatever newlines are supplied with the style we're using
            content = content.replace(/\r?\n/g, LINE_SEPARATOR);
            this.result += content;
        }
        else {
            content.forEach((row) => {
                this.beginNewLine();
                row.forEach((cell, index) => {
                    if (index !== 0) {
                        this.result += this.columnSeparator;
                    }
                    this.result += this.putInQuotes(cell.data.value || '');
                    if (cell.mergeAcross) {
                        this.appendEmptyCells(cell.mergeAcross);
                    }
                });
            });
        }
    }
    onNewHeaderGroupingRow() {
        this.beginNewLine();
        return {
            onColumn: this.onNewHeaderGroupingRowColumn.bind(this),
        };
    }
    onNewHeaderGroupingRowColumn(columnGroup, header, index, span) {
        if (index != 0) {
            this.result += this.columnSeparator;
        }
        this.result += this.putInQuotes(header);
        this.appendEmptyCells(span);
    }
    appendEmptyCells(count) {
        for (let i = 1; i <= count; i++) {
            this.result += this.columnSeparator + this.putInQuotes('');
        }
    }
    onNewHeaderRow() {
        this.beginNewLine();
        return {
            onColumn: this.onNewHeaderRowColumn.bind(this),
        };
    }
    onNewHeaderRowColumn(column, index) {
        if (index != 0) {
            this.result += this.columnSeparator;
        }
        this.result += this.putInQuotes(this.extractHeaderValue(column));
    }
    onNewBodyRow() {
        this.beginNewLine();
        return {
            onColumn: this.onNewBodyRowColumn.bind(this),
        };
    }
    onNewBodyRowColumn(column, index, node) {
        if (index != 0) {
            this.result += this.columnSeparator;
        }
        const rowCellValue = this.extractRowCellValue(column, index, index, 'csv', node);
        this.result += this.putInQuotes(rowCellValue.valueFormatted ?? rowCellValue.value);
    }
    putInQuotes(value) {
        if (this.suppressQuotes) {
            return value;
        }
        if (value === null || value === undefined) {
            return '""';
        }
        let stringValue;
        if (typeof value === 'string') {
            stringValue = value;
        }
        else if (typeof value.toString === 'function') {
            stringValue = value.toString();
        }
        else {
            (0, logging_1._warn)(53);
            stringValue = '';
        }
        // replace each " with "" (ie two sets of double quotes is how to do double quotes in csv)
        const valueEscaped = stringValue.replace(/"/g, '""');
        return '"' + valueEscaped + '"';
    }
    parse() {
        return this.result;
    }
    beginNewLine() {
        if (!this.isFirstLine) {
            this.result += LINE_SEPARATOR;
        }
        this.isFirstLine = false;
    }
}
exports.CsvSerializingSession = CsvSerializingSession;


/***/ }),

/***/ 20:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CtrlsService = void 0;
const beanStub_1 = __webpack_require__(8731);
/**
 * This is the number of controls defined above in `ReadyParams`.
 * This allows us to quickly know when all controls have been registered.
 */
const NUM_CTRLS = 23;
// for all controllers that are singletons, they can register here so other parts
// of the application can access them.
class CtrlsService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'ctrlsSvc';
        this.params = {};
        this.ready = false;
        this.readyCallbacks = [];
    }
    postConstruct() {
        // With React 19 StrictMode, ctrlService can be ready twice.
        // The first time after the first render cycle, and the second time after the second render cycle which is only done in StrictMode.
        // By making the local events async, we effectively debounce the first ready event until after the second render cycle has completed.
        // This means that the ready logic across the grid will run against the currently rendered components and controllers.
        // We make this async only for React 19 as StrictMode in React 19 double fires ref callbacks whereas previous versions of React do not.
        this.addEventListener('ready', () => {
            this.updateReady();
            if (this.ready) {
                this.readyCallbacks.forEach((c) => c(this.params));
                this.readyCallbacks.length = 0;
            }
        }, this.beans.frameworkOverrides.runWhenReadyAsync?.() ?? false);
    }
    updateReady() {
        const values = Object.values(this.params);
        // ready when all ctrls have been registered and are alive
        this.ready =
            values.length === NUM_CTRLS &&
                values.every((ctrl) => {
                    return ctrl?.isAlive() ?? false;
                });
    }
    whenReady(caller, callback) {
        if (this.ready) {
            callback(this.params);
        }
        else {
            this.readyCallbacks.push(callback);
        }
        caller.addDestroyFunc(() => {
            // remove the callback if the caller is destroyed so that we don't call it against a destroyed component
            const index = this.readyCallbacks.indexOf(callback);
            if (index >= 0) {
                this.readyCallbacks.splice(index, 1);
            }
        });
    }
    register(ctrlType, ctrl) {
        this.params[ctrlType] = ctrl;
        this.updateReady();
        if (this.ready) {
            this.dispatchLocalEvent({ type: 'ready' });
        }
        ctrl.addDestroyFunc(() => {
            // Ensure ready is false when a controller is destroyed
            // We do not clear them as a lot of code still runs during destroy logic which may need access to the controllers
            // NOTE: This is not ideal and we should look to stop logic using controllers during destroy
            this.updateReady();
        });
    }
    get(ctrlType) {
        return this.params[ctrlType];
    }
    getGridBodyCtrl() {
        return this.params.gridBodyCtrl;
    }
    getHeaderRowContainerCtrls() {
        const { leftHeader, centerHeader, rightHeader } = this.params;
        return [leftHeader, rightHeader, centerHeader];
    }
    getHeaderRowContainerCtrl(pinned) {
        const params = this.params;
        switch (pinned) {
            case 'left':
                return params.leftHeader;
            case 'right':
                return params.rightHeader;
            default:
                return params.centerHeader;
        }
    }
    getScrollFeature() {
        return this.getGridBodyCtrl().scrollFeature;
    }
}
exports.CtrlsService = CtrlsService;


/***/ }),

/***/ 2671:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.dragAndDropImageComponentCSS = void 0;
exports.dragAndDropImageComponentCSS = `.ag-dnd-ghost{align-items:center;background-color:var(--ag-drag-and-drop-image-background-color);border:var(--ag-drag-and-drop-image-border);border-radius:var(--ag-border-radius);box-shadow:var(--ag-drag-and-drop-image-shadow);color:var(--ag-text-color);cursor:move;display:flex;font-weight:500;gap:var(--ag-cell-widget-spacing);height:var(--ag-header-height);overflow:hidden;padding-left:var(--ag-cell-horizontal-padding);padding-right:var(--ag-cell-horizontal-padding);text-overflow:ellipsis;transform:translateY(calc(var(--ag-spacing)*2));white-space:nowrap}`;


/***/ }),

/***/ 3814:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragAndDropImageComponent = void 0;
const dom_1 = __webpack_require__(3507);
const icon_1 = __webpack_require__(9970);
const component_1 = __webpack_require__(8020);
const dragAndDropImageComponent_css_GENERATED_1 = __webpack_require__(2671);
// the wrapper div has no class - the drag and drop service adds the theme class to it
const DragAndDropElement = {
    tag: 'div',
    children: [
        {
            tag: 'div',
            ref: 'eGhost',
            cls: 'ag-dnd-ghost ag-unselectable',
            children: [
                { tag: 'span', ref: 'eIcon', cls: 'ag-dnd-ghost-icon ag-shake-left-to-right' },
                { tag: 'div', ref: 'eLabel', cls: 'ag-dnd-ghost-label' },
            ],
        },
    ],
};
class DragAndDropImageComponent extends component_1.Component {
    constructor() {
        super();
        this.dragSource = null;
        this.eIcon = component_1.RefPlaceholder;
        this.eLabel = component_1.RefPlaceholder;
        this.eGhost = component_1.RefPlaceholder;
        this.registerCSS(dragAndDropImageComponent_css_GENERATED_1.dragAndDropImageComponentCSS);
    }
    postConstruct() {
        const create = (iconName) => (0, icon_1._createIcon)(iconName, this.beans, null);
        this.dropIconMap = {
            pinned: create('columnMovePin'),
            hide: create('columnMoveHide'),
            move: create('columnMoveMove'),
            left: create('columnMoveLeft'),
            right: create('columnMoveRight'),
            group: create('columnMoveGroup'),
            aggregate: create('columnMoveValue'),
            pivot: create('columnMovePivot'),
            notAllowed: create('dropNotAllowed'),
        };
    }
    init(params) {
        this.dragSource = params.dragSource;
        this.setTemplate(DragAndDropElement);
        // also apply theme class to the ghost element for backwards compatibility
        // with themes that use .ag-theme-classname.ag-dnd-ghost, which used to be
        // required before the theme class was also set on the wrapper.
        this.beans.environment.applyThemeClasses(this.eGhost);
    }
    destroy() {
        this.dragSource = null;
        super.destroy();
    }
    setIcon(iconName, shake) {
        const { eIcon, dragSource, dropIconMap, gos } = this;
        (0, dom_1._clearElement)(eIcon);
        let eIconChild = null;
        if (!iconName) {
            iconName = dragSource?.getDefaultIconName ? dragSource.getDefaultIconName() : 'notAllowed';
        }
        eIconChild = dropIconMap[iconName];
        eIcon.classList.toggle('ag-shake-left-to-right', shake);
        if (eIconChild === dropIconMap['hide'] && gos.get('suppressDragLeaveHidesColumns')) {
            return;
        }
        if (eIconChild) {
            eIcon.appendChild(eIconChild);
        }
    }
    setLabel(label) {
        this.eLabel.textContent = label;
    }
}
exports.DragAndDropImageComponent = DragAndDropImageComponent;


/***/ }),

/***/ 2903:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragAndDropService = exports.DragSourceType = void 0;
const userCompUtils_1 = __webpack_require__(2036);
const beanStub_1 = __webpack_require__(8731);
const mouseEventUtils_1 = __webpack_require__(8399);
const gridOptionsUtils_1 = __webpack_require__(7274);
const array_1 = __webpack_require__(1502);
const logging_1 = __webpack_require__(7764);
var DragSourceType;
(function (DragSourceType) {
    DragSourceType[DragSourceType["ToolPanel"] = 0] = "ToolPanel";
    DragSourceType[DragSourceType["HeaderCell"] = 1] = "HeaderCell";
    DragSourceType[DragSourceType["RowDrag"] = 2] = "RowDrag";
    DragSourceType[DragSourceType["ChartPanel"] = 3] = "ChartPanel";
    DragSourceType[DragSourceType["AdvancedFilterBuilder"] = 4] = "AdvancedFilterBuilder";
})(DragSourceType || (exports.DragSourceType = DragSourceType = {}));
class DragAndDropService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'dragAndDrop';
        this.dragSourceAndParamsList = [];
        this.dropTargets = [];
    }
    wireBeans(beans) {
        this.ctrlsSvc = beans.ctrlsSvc;
        this.dragSvc = beans.dragSvc;
        this.environment = beans.environment;
        this.userCompFactory = beans.userCompFactory;
    }
    addDragSource(dragSource, allowTouch = false) {
        const params = {
            eElement: dragSource.eElement,
            dragStartPixels: dragSource.dragStartPixels,
            onDragStart: this.onDragStart.bind(this, dragSource),
            onDragStop: this.onDragStop.bind(this),
            onDragging: this.onDragging.bind(this),
            onDragCancel: this.onDragCancel.bind(this),
            includeTouch: allowTouch,
        };
        this.dragSourceAndParamsList.push({ params: params, dragSource: dragSource });
        this.dragSvc.addDragSource(params);
    }
    getDragAndDropImageComponent() {
        const { dragAndDropImageComp } = this;
        if (!dragAndDropImageComp || !dragAndDropImageComp.comp) {
            return null;
        }
        return dragAndDropImageComp.comp;
    }
    removeDragSource(dragSource) {
        const { dragSourceAndParamsList, dragSvc } = this;
        const sourceAndParams = dragSourceAndParamsList.find((item) => item.dragSource === dragSource);
        if (sourceAndParams) {
            dragSvc.removeDragSource(sourceAndParams.params);
            (0, array_1._removeFromArray)(dragSourceAndParamsList, sourceAndParams);
        }
    }
    destroy() {
        const { dragSourceAndParamsList, dragSvc, dropTargets } = this;
        dragSourceAndParamsList.forEach((sourceAndParams) => dragSvc.removeDragSource(sourceAndParams.params));
        dragSourceAndParamsList.length = 0;
        dropTargets.length = 0;
        this.clearDragAndDropProperties();
        super.destroy();
    }
    nudge() {
        if (this.dragging) {
            this.onDragging(this.eventLastTime, true);
        }
    }
    onDragStart(dragSource, mouseEvent) {
        this.dragging = true;
        this.dragSource = dragSource;
        this.eventLastTime = mouseEvent;
        this.dragItem = dragSource.getDragItem();
        dragSource.onDragStarted?.();
        this.createDragAndDropImageComponent();
    }
    onDragStop(mouseEvent) {
        this.dragSource?.onDragStopped?.();
        const { lastDropTarget } = this;
        if (lastDropTarget?.onDragStop) {
            const draggingEvent = this.createDropTargetEvent(lastDropTarget, mouseEvent, null, null, false);
            lastDropTarget.onDragStop(draggingEvent);
        }
        this.clearDragAndDropProperties();
    }
    onDragCancel() {
        const { dragSource, lastDropTarget } = this;
        dragSource?.onDragCancelled?.();
        if (lastDropTarget?.onDragCancel) {
            lastDropTarget.onDragCancel(this.createDropTargetEvent(lastDropTarget, this.eventLastTime, null, null, false));
        }
        this.clearDragAndDropProperties();
    }
    clearDragAndDropProperties() {
        this.eventLastTime = null;
        this.dragging = false;
        this.lastDropTarget = undefined;
        this.dragItem = null;
        this.dragSource = null;
        this.removeDragAndDropImageComponent();
    }
    onDragging(mouseEvent, fromNudge = false) {
        const hDirection = this.getHorizontalDirection(mouseEvent);
        const vDirection = this.getVerticalDirection(mouseEvent);
        this.eventLastTime = mouseEvent;
        this.positionDragAndDropImageComp(mouseEvent);
        // check if mouseEvent intersects with any of the drop targets
        const validDropTargets = this.dropTargets.filter((target) => this.isMouseOnDropTarget(mouseEvent, target));
        const dropTarget = this.findCurrentDropTarget(mouseEvent, validDropTargets);
        const { lastDropTarget, dragSource, dragAndDropImageComp, dragItem } = this;
        if (dropTarget !== lastDropTarget) {
            this.leaveLastTargetIfExists(mouseEvent, hDirection, vDirection, fromNudge);
            if (lastDropTarget !== null && dropTarget === null) {
                dragSource?.onGridExit?.(dragItem);
            }
            if (lastDropTarget === null && dropTarget !== null) {
                dragSource?.onGridEnter?.(dragItem);
            }
            this.enterDragTargetIfExists(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
            if (dropTarget && dragAndDropImageComp) {
                const { comp, promise } = dragAndDropImageComp;
                if (comp) {
                    comp.setIcon(dropTarget.getIconName ? dropTarget.getIconName() : null, false);
                }
                else {
                    promise.then((resolvedComponent) => {
                        if (resolvedComponent) {
                            resolvedComponent.setIcon(dropTarget.getIconName ? dropTarget.getIconName() : null, false);
                        }
                    });
                }
            }
            this.lastDropTarget = dropTarget;
        }
        else if (dropTarget && dropTarget.onDragging) {
            const draggingEvent = this.createDropTargetEvent(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
            dropTarget.onDragging(draggingEvent);
        }
    }
    getAllContainersFromDropTarget(dropTarget) {
        const secondaryContainers = dropTarget.getSecondaryContainers ? dropTarget.getSecondaryContainers() : null;
        const containers = [[dropTarget.getContainer()]];
        return secondaryContainers ? containers.concat(secondaryContainers) : containers;
    }
    // checks if the mouse is on the drop target. it checks eContainer and eSecondaryContainers
    isMouseOnDropTarget(mouseEvent, dropTarget) {
        const allContainersFromDropTarget = this.getAllContainersFromDropTarget(dropTarget);
        let mouseOverTarget = false;
        const allContainersIntersect = (mouseEvent, containers) => {
            for (const container of containers) {
                const { width, height, left, right, top, bottom } = container.getBoundingClientRect();
                // if element is not visible, then width and height are zero
                if (width === 0 || height === 0) {
                    return false;
                }
                const horizontalFit = mouseEvent.clientX >= left && mouseEvent.clientX < right;
                const verticalFit = mouseEvent.clientY >= top && mouseEvent.clientY < bottom;
                if (!horizontalFit || !verticalFit) {
                    return false;
                }
            }
            return true;
        };
        for (const currentContainers of allContainersFromDropTarget) {
            if (allContainersIntersect(mouseEvent, currentContainers)) {
                mouseOverTarget = true;
                break;
            }
        }
        const { eElement, type } = this.dragSource;
        if (dropTarget.targetContainsSource && !dropTarget.getContainer().contains(eElement)) {
            return false;
        }
        return mouseOverTarget && dropTarget.isInterestedIn(type, eElement);
    }
    findCurrentDropTarget(mouseEvent, validDropTargets) {
        const len = validDropTargets.length;
        if (len === 0) {
            return null;
        }
        if (len === 1) {
            return validDropTargets[0];
        }
        const rootNode = (0, gridOptionsUtils_1._getRootNode)(this.beans);
        // elementsFromPoint return a list of elements under
        // the mouseEvent sorted from topMost to bottomMost
        const elementStack = rootNode.elementsFromPoint(mouseEvent.clientX, mouseEvent.clientY);
        // loop over the sorted elementStack to find which dropTarget comes first
        for (const el of elementStack) {
            for (const dropTarget of validDropTargets) {
                const containers = this.getAllContainersFromDropTarget(dropTarget).flatMap((a) => a);
                if (containers.indexOf(el) !== -1) {
                    return dropTarget;
                }
            }
        }
        // we should never hit this point of the code because only
        // valid dropTargets should be provided to this method.
        return null;
    }
    enterDragTargetIfExists(dropTarget, mouseEvent, hDirection, vDirection, fromNudge) {
        if (!dropTarget) {
            return;
        }
        if (dropTarget.onDragEnter) {
            const dragEnterEvent = this.createDropTargetEvent(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
            dropTarget.onDragEnter(dragEnterEvent);
        }
    }
    leaveLastTargetIfExists(mouseEvent, hDirection, vDirection, fromNudge) {
        const { lastDropTarget } = this;
        if (!lastDropTarget) {
            return;
        }
        if (lastDropTarget.onDragLeave) {
            const dragLeaveEvent = this.createDropTargetEvent(lastDropTarget, mouseEvent, hDirection, vDirection, fromNudge);
            lastDropTarget.onDragLeave(dragLeaveEvent);
        }
        const dragAndDropImageComponent = this.getDragAndDropImageComponent();
        if (dragAndDropImageComponent) {
            dragAndDropImageComponent.setIcon(null, false);
        }
    }
    addDropTarget(dropTarget) {
        this.dropTargets.push(dropTarget);
    }
    removeDropTarget(dropTarget) {
        this.dropTargets = this.dropTargets.filter((target) => target.getContainer() !== dropTarget.getContainer());
    }
    hasExternalDropZones() {
        return this.dropTargets.some((zones) => zones.external);
    }
    findExternalZone(params) {
        const externalTargets = this.dropTargets.filter((target) => target.external);
        return externalTargets.find((zone) => zone.getContainer() === params.getContainer()) || null;
    }
    isDropZoneWithinThisGrid(draggingEvent) {
        const gridBodyCon = this.ctrlsSvc.getGridBodyCtrl();
        const gridGui = gridBodyCon.eGridBody;
        const { dropZoneTarget } = draggingEvent;
        return gridGui.contains(dropZoneTarget);
    }
    getHorizontalDirection(event) {
        const clientX = this.eventLastTime?.clientX;
        const eClientX = event.clientX;
        if (clientX === eClientX) {
            return null;
        }
        return clientX > eClientX ? 'left' : 'right';
    }
    getVerticalDirection(event) {
        const clientY = this.eventLastTime?.clientY;
        const eClientY = event.clientY;
        if (clientY === eClientY) {
            return null;
        }
        return clientY > eClientY ? 'up' : 'down';
    }
    createDropTargetEvent(dropTarget, event, hDirection, vDirection, fromNudge) {
        // localise x and y to the target
        const dropZoneTarget = dropTarget.getContainer();
        const rect = dropZoneTarget.getBoundingClientRect();
        const { dragItem, dragSource, gos } = this;
        const x = event.clientX - rect.left;
        const y = event.clientY - rect.top;
        return (0, gridOptionsUtils_1._addGridCommonParams)(gos, {
            event,
            x,
            y,
            vDirection,
            hDirection,
            dragSource: dragSource,
            fromNudge,
            dragItem: dragItem,
            dropZoneTarget,
        });
    }
    positionDragAndDropImageComp(event) {
        const dragAndDropImageComponent = this.getDragAndDropImageComponent();
        if (!dragAndDropImageComponent) {
            return;
        }
        (0, gridOptionsUtils_1._anchorElementToMouseMoveEvent)(dragAndDropImageComponent.getGui(), event, this.beans);
    }
    removeDragAndDropImageComponent() {
        const { dragAndDropImageComp } = this;
        if (dragAndDropImageComp) {
            const { comp } = dragAndDropImageComp;
            if (comp) {
                const eGui = comp.getGui();
                this.dragAndDropImageParent?.removeChild(eGui);
                this.destroyBean(comp);
            }
        }
        this.dragAndDropImageComp = null;
    }
    createDragAndDropImageComponent() {
        const { dragSource, gos, userCompFactory } = this;
        if (!dragSource) {
            return;
        }
        const userCompDetails = (0, userCompUtils_1._getDragAndDropImageCompDetails)(userCompFactory, (0, gridOptionsUtils_1._addGridCommonParams)(gos, {
            dragSource,
        }));
        if (!userCompDetails) {
            return;
        }
        const promise = userCompDetails.newAgStackInstance();
        this.dragAndDropImageComp = {
            promise,
        };
        promise.then((comp) => {
            if (!comp || !this.isAlive()) {
                return;
            }
            this.processDragAndDropImageComponent(comp);
            this.dragAndDropImageComp.comp = comp;
        });
    }
    processDragAndDropImageComponent(dragAndDropImageComponent) {
        const { dragSource, environment } = this;
        if (!dragSource) {
            return;
        }
        const eGui = dragAndDropImageComponent.getGui();
        eGui.style.setProperty('position', 'absolute');
        eGui.style.setProperty('z-index', '9999');
        (0, mouseEventUtils_1._stampTopLevelGridCompWithGridInstance)(this.gos, eGui);
        environment.applyThemeClasses(eGui);
        dragAndDropImageComponent.setIcon(null, false);
        let { dragItemName } = dragSource;
        if (typeof dragItemName === 'function') {
            dragItemName = dragItemName();
        }
        dragAndDropImageComponent.setLabel(dragItemName || '');
        eGui.style.top = '20px';
        eGui.style.left = '20px';
        const targetEl = (0, gridOptionsUtils_1._getPageBody)(this.beans);
        this.dragAndDropImageParent = targetEl;
        if (!targetEl) {
            (0, logging_1._warn)(54);
        }
        else {
            targetEl.appendChild(eGui);
        }
    }
    registerGridDropTarget(elementFn, ctrl) {
        // this drop target is just used to see if the drop event is inside the grid
        const dropTarget = {
            getContainer: elementFn,
            isInterestedIn: (type) => type === DragSourceType.HeaderCell || type === DragSourceType.ToolPanel,
            getIconName: () => 'notAllowed',
        };
        this.addDropTarget(dropTarget);
        ctrl.addDestroyFunc(() => this.removeDropTarget(dropTarget));
    }
}
exports.DragAndDropService = DragAndDropService;


/***/ }),

/***/ 2830:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.setRowDropPositionIndicator = exports.getRowDropPositionIndicator = exports.getRowDropZoneParams = exports.removeRowDropZone = exports.addRowDropZone = void 0;
function addRowDropZone(beans, params) {
    beans.rowDragSvc?.rowDragFeature?.addRowDropZone(params);
}
exports.addRowDropZone = addRowDropZone;
function removeRowDropZone(beans, params) {
    const activeDropTarget = beans.dragAndDrop?.findExternalZone(params);
    if (activeDropTarget) {
        beans.dragAndDrop?.removeDropTarget(activeDropTarget);
    }
}
exports.removeRowDropZone = removeRowDropZone;
function getRowDropZoneParams(beans, events) {
    return beans.rowDragSvc?.rowDragFeature?.getRowDropZone(events);
}
exports.getRowDropZoneParams = getRowDropZoneParams;
function getRowDropPositionIndicator(beans) {
    const rowDropHighlightSvc = beans.rowDropHighlightSvc;
    return rowDropHighlightSvc
        ? { row: rowDropHighlightSvc.row, dropIndicatorPosition: rowDropHighlightSvc.position }
        : { row: null, dropIndicatorPosition: 'none' };
}
exports.getRowDropPositionIndicator = getRowDropPositionIndicator;
function setRowDropPositionIndicator(beans, params) {
    const rowDropHighlightSvc = beans.rowDropHighlightSvc;
    if (!rowDropHighlightSvc) {
        return;
    }
    const rowNode = params?.row;
    let position = params?.dropIndicatorPosition;
    if (position !== 'above' && position !== 'below' && position !== 'inside') {
        position = 'none';
    }
    const rowIndex = rowNode?.rowIndex;
    if (rowIndex === null || rowIndex === undefined || position === 'none') {
        rowDropHighlightSvc.clear();
    }
    else {
        rowDropHighlightSvc.set(rowNode, position);
    }
}
exports.setRowDropPositionIndicator = setRowDropPositionIndicator;


/***/ }),

/***/ 4388:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HorizontalResizeModule = exports.RowDragModule = exports.SharedDragAndDropModule = exports.DragAndDropModule = exports.DragModule = void 0;
const dndSourceComp_1 = __webpack_require__(714);
const version_1 = __webpack_require__(7205);
const dragAndDropImageComponent_1 = __webpack_require__(3814);
const dragAndDropService_1 = __webpack_require__(2903);
const dragApi_1 = __webpack_require__(2830);
const dragApi_2 = __webpack_require__(2830);
const dragService_1 = __webpack_require__(2165);
const horizontalResizeService_1 = __webpack_require__(6843);
const rowDragService_1 = __webpack_require__(2895);
const rowDropHighlightService_1 = __webpack_require__(7406);
/**
 * @internal
 */
exports.DragModule = {
    moduleName: 'Drag',
    version: version_1.VERSION,
    beans: [dragService_1.DragService],
};
/**
 * @feature Import & Export -> Drag & Drop
 * @colDef dndSource, dndSourceOnRowDrag
 */
exports.DragAndDropModule = {
    moduleName: 'DragAndDrop',
    version: version_1.VERSION,
    dynamicBeans: {
        dndSourceComp: dndSourceComp_1.DndSourceComp,
    },
    icons: {
        // drag handle used to pick up draggable rows
        rowDrag: 'grip',
    },
};
/**
 * @internal
 */
exports.SharedDragAndDropModule = {
    moduleName: 'SharedDragAndDrop',
    version: version_1.VERSION,
    beans: [dragAndDropService_1.DragAndDropService],
    dependsOn: [exports.DragModule],
    userComponents: {
        agDragAndDropImage: dragAndDropImageComponent_1.DragAndDropImageComponent,
    },
    icons: {
        // shown on drag and drop image component icon while dragging column to the side of the grid to pin
        columnMovePin: 'pin',
        // shown on drag and drop image component icon while dragging over part of the page that is not a drop zone
        columnMoveHide: 'eye-slash',
        // shown on drag and drop image component icon while dragging columns to reorder
        columnMoveMove: 'arrows',
        // animating icon shown when dragging a column to the right of the grid causes horizontal scrolling
        columnMoveLeft: 'left',
        // animating icon shown when dragging a column to the left of the grid causes horizontal scrolling
        columnMoveRight: 'right',
        // shown on drag and drop image component icon while dragging over Row Groups drop zone
        columnMoveGroup: 'group',
        // shown on drag and drop image component icon while dragging over Values drop zone
        columnMoveValue: 'aggregation',
        // shown on drag and drop image component icon while dragging over pivot drop zone
        columnMovePivot: 'pivot',
        // shown on drag and drop image component icon while dragging over drop zone that doesn't support it, e.g.
        // string column over aggregation drop zone
        dropNotAllowed: 'not-allowed',
        // drag handle used to pick up draggable rows
        rowDrag: 'grip',
    },
};
/**
 * @feature Rows -> Row Dragging
 * @colDef rowDrag
 */
exports.RowDragModule = {
    moduleName: 'RowDrag',
    version: version_1.VERSION,
    beans: [rowDropHighlightService_1.RowDropHighlightService, rowDragService_1.RowDragService],
    apiFunctions: {
        addRowDropZone: dragApi_1.addRowDropZone,
        removeRowDropZone: dragApi_1.removeRowDropZone,
        getRowDropZoneParams: dragApi_1.getRowDropZoneParams,
        getRowDropPositionIndicator: dragApi_2.getRowDropPositionIndicator,
        setRowDropPositionIndicator: dragApi_2.setRowDropPositionIndicator,
    },
    dependsOn: [exports.SharedDragAndDropModule],
};
/**
 * @internal
 */
exports.HorizontalResizeModule = {
    moduleName: 'HorizontalResize',
    version: version_1.VERSION,
    beans: [horizontalResizeService_1.HorizontalResizeService],
    dependsOn: [exports.DragModule],
};


/***/ }),

/***/ 2165:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragService = void 0;
const keyCode_1 = __webpack_require__(9853);
const beanStub_1 = __webpack_require__(8731);
const mouseEventUtils_1 = __webpack_require__(8399);
const gridOptionsUtils_1 = __webpack_require__(7274);
const array_1 = __webpack_require__(1502);
const browser_1 = __webpack_require__(8667);
const dom_1 = __webpack_require__(3507);
const generic_1 = __webpack_require__(4422);
const mouse_1 = __webpack_require__(3276);
/** Adds drag listening onto an element. In AG Grid this is used twice, first is resizing columns,
 * second is moving the columns and column groups around (ie the 'drag' part of Drag and Drop. */
class DragService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'dragSvc';
        this.dragEndFunctions = [];
        this.dragSources = [];
    }
    destroy() {
        const { dragSources } = this;
        dragSources.forEach(this.removeListener.bind(this));
        dragSources.length = 0;
        super.destroy();
    }
    removeListener(dragSourceAndListener) {
        const element = dragSourceAndListener.dragSource.eElement;
        const mouseDownListener = dragSourceAndListener.mouseDownListener;
        element.removeEventListener('mousedown', mouseDownListener);
        // remove touch listener only if it exists
        if (dragSourceAndListener.touchEnabled) {
            const touchStartListener = dragSourceAndListener.touchStartListener;
            element.removeEventListener('touchstart', touchStartListener, { passive: true });
        }
    }
    removeDragSource(params) {
        const { dragSources } = this;
        const dragSourceAndListener = dragSources.find((item) => item.dragSource === params);
        if (!dragSourceAndListener) {
            return;
        }
        this.removeListener(dragSourceAndListener);
        (0, array_1._removeFromArray)(dragSources, dragSourceAndListener);
    }
    addDragSource(params) {
        const mouseListener = this.onMouseDown.bind(this, params);
        const { eElement, includeTouch, stopPropagationForTouch } = params;
        eElement.addEventListener('mousedown', mouseListener);
        let touchListener = null;
        const suppressTouch = this.gos.get('suppressTouch');
        if (includeTouch && !suppressTouch) {
            touchListener = (touchEvent) => {
                if ((0, dom_1._isFocusableFormField)(touchEvent.target)) {
                    return;
                }
                if (stopPropagationForTouch) {
                    touchEvent.stopPropagation();
                }
                this.onTouchStart(params, touchEvent);
            };
            // we set passive=false, as we want to prevent default on this event
            eElement.addEventListener('touchstart', touchListener, { passive: false });
        }
        this.dragSources.push({
            dragSource: params,
            mouseDownListener: mouseListener,
            touchStartListener: touchListener,
            touchEnabled: !!includeTouch,
        });
    }
    // gets called whenever mouse down on any drag source
    onTouchStart(params, touchEvent) {
        this.currentDragParams = params;
        this.dragging = false;
        const touch = touchEvent.touches[0];
        this.touchLastTime = touch;
        this.touchStart = touch;
        const touchMoveEvent = (e) => this.onTouchMove(e, params.eElement);
        const touchEndEvent = (e) => this.onTouchUp(e, params.eElement);
        const documentTouchMove = (e) => {
            if (e.cancelable) {
                e.preventDefault();
            }
        };
        const target = touchEvent.target;
        const events = [
            // Prevents the page document from moving while we are dragging items around.
            // preventDefault needs to be called in the touchmove listener and never inside the
            // touchstart, because using touchstart causes the click event to be cancelled on touch devices.
            {
                target: (0, gridOptionsUtils_1._getRootNode)(this.beans),
                type: 'touchmove',
                listener: documentTouchMove,
                options: { passive: false },
            },
            { target, type: 'touchmove', listener: touchMoveEvent, options: { passive: true } },
            { target, type: 'touchend', listener: touchEndEvent, options: { passive: true } },
            { target, type: 'touchcancel', listener: touchEndEvent, options: { passive: true } },
        ];
        // temporally add these listeners, for the duration of the drag
        this.addTemporaryEvents(events);
        // see if we want to start dragging straight away
        if (params.dragStartPixels === 0) {
            this.onCommonMove(touch, this.touchStart, params.eElement);
        }
    }
    // gets called whenever mouse down on any drag source
    onMouseDown(params, mouseEvent) {
        const e = mouseEvent;
        if (params.skipMouseEvent && params.skipMouseEvent(mouseEvent)) {
            return;
        }
        // if there are two elements with parent / child relationship, and both are draggable,
        // when we drag the child, we should NOT drag the parent. an example of this is row moving
        // and range selection - row moving should get preference when use drags the rowDrag component.
        if (e._alreadyProcessedByDragService) {
            return;
        }
        e._alreadyProcessedByDragService = true;
        // only interested in left button clicks
        if (mouseEvent.button !== 0) {
            return;
        }
        if (this.shouldPreventMouseEvent(mouseEvent)) {
            mouseEvent.preventDefault();
        }
        this.currentDragParams = params;
        this.dragging = false;
        this.mouseStartEvent = mouseEvent;
        this.startTarget = mouseEvent.target;
        const mouseMoveEvent = (event) => this.onMouseMove(event, params.eElement);
        const mouseUpEvent = (event) => this.onMouseUp(event, params.eElement);
        const contextEvent = (event) => event.preventDefault();
        const keydownEvent = (event) => {
            if (event.key === keyCode_1.KeyCode.ESCAPE) {
                this.cancelDrag(params.eElement);
            }
        };
        const target = (0, gridOptionsUtils_1._getRootNode)(this.beans);
        const events = [
            { target, type: 'mousemove', listener: mouseMoveEvent },
            { target, type: 'mouseup', listener: mouseUpEvent },
            { target, type: 'contextmenu', listener: contextEvent },
            { target, type: 'keydown', listener: keydownEvent },
        ];
        // temporally add these listeners, for the duration of the drag
        this.addTemporaryEvents(events);
        //see if we want to start dragging straight away
        if (params.dragStartPixels === 0) {
            this.onMouseMove(mouseEvent, params.eElement);
        }
    }
    addTemporaryEvents(events) {
        events.forEach((currentEvent) => {
            const { target, type, listener, options } = currentEvent;
            target.addEventListener(type, listener, options);
        });
        this.dragEndFunctions.push(() => {
            events.forEach((currentEvent) => {
                const { target, type, listener, options } = currentEvent;
                target.removeEventListener(type, listener, options);
            });
        });
    }
    // returns true if the event is close to the original event by X pixels either vertically or horizontally.
    // we only start dragging after X pixels so this allows us to know if we should start dragging yet.
    isEventNearStartEvent(currentEvent, startEvent) {
        // by default, we wait 4 pixels before starting the drag
        const { dragStartPixels } = this.currentDragParams;
        const requiredPixelDiff = (0, generic_1._exists)(dragStartPixels) ? dragStartPixels : 4;
        return (0, mouse_1._areEventsNear)(currentEvent, startEvent, requiredPixelDiff);
    }
    getFirstActiveTouch(touchList) {
        for (let i = 0; i < touchList.length; i++) {
            if (touchList[i].identifier === this.touchStart.identifier) {
                return touchList[i];
            }
        }
        return null;
    }
    onCommonMove(currentEvent, startEvent, el) {
        if (!this.dragging) {
            // if mouse hasn't travelled from the start position enough, do nothing
            if (this.isEventNearStartEvent(currentEvent, startEvent)) {
                return;
            }
            this.dragging = true;
            this.eventSvc.dispatchEvent({
                type: 'dragStarted',
                target: el,
            });
            this.currentDragParams.onDragStart(startEvent);
            // we need ONE drag action at the startEvent, so that we are guaranteed the drop target
            // at the start gets notified. this is because the drag can start outside of the element
            // that started it, as the mouse is allowed drag away from the mouse down before it's
            // considered a drag (the isEventNearStartEvent() above). if we didn't do this, then
            // it would be possible to click a column by the edge, then drag outside of the drop zone
            // in less than 4 pixels and the drag officially starts outside of the header but the header
            // wouldn't be notified of the dragging.
            // if currentDragParams is null here, it means that drag has been cancelled.
            if (!this.currentDragParams) {
                this.dragging = false;
                return;
            }
            this.currentDragParams.onDragging(startEvent);
        }
        this.currentDragParams?.onDragging(currentEvent);
    }
    onTouchMove(touchEvent, el) {
        const touch = this.getFirstActiveTouch(touchEvent.touches);
        if (!touch) {
            return;
        }
        // this.___statusPanel.setInfoText(Math.random() + ' onTouchMove preventDefault stopPropagation');
        this.onCommonMove(touch, this.touchStart, el);
    }
    // only gets called after a mouse down - as this is only added after mouseDown
    // and is removed when mouseUp happens
    onMouseMove(mouseEvent, el) {
        if ((0, browser_1._isBrowserSafari)()) {
            const eDocument = (0, gridOptionsUtils_1._getDocument)(this.beans);
            eDocument.getSelection()?.removeAllRanges();
        }
        if (this.shouldPreventMouseEvent(mouseEvent)) {
            mouseEvent.preventDefault();
        }
        this.onCommonMove(mouseEvent, this.mouseStartEvent, el);
    }
    shouldPreventMouseEvent(mouseEvent) {
        const { gos } = this;
        const isEnableCellTextSelect = gos.get('enableCellTextSelection');
        const isMouseMove = mouseEvent.type === 'mousemove';
        const isOverFormFieldElement = (mouseEvent) => {
            const el = mouseEvent.target;
            const tagName = el?.tagName.toLocaleLowerCase();
            return !!tagName?.match('^a$|textarea|input|select|button');
        };
        return (
        // when `isEnableCellTextSelect` is `true`, we need to preventDefault on mouseMove
        // to avoid the grid text being selected while dragging components.
        isEnableCellTextSelect &&
            isMouseMove &&
            mouseEvent.cancelable &&
            (0, mouseEventUtils_1._isEventFromThisGrid)(gos, mouseEvent) &&
            !isOverFormFieldElement(mouseEvent));
    }
    onTouchUp(touchEvent, el) {
        let touch = this.getFirstActiveTouch(touchEvent.changedTouches);
        // i haven't worked this out yet, but there is no matching touch
        // when we get the touch up event. to get around this, we swap in
        // the last touch. this is a hack to 'get it working' while we
        // figure out what's going on, why we are not getting a touch in
        // current event.
        if (!touch) {
            touch = this.touchLastTime;
        }
        // if mouse was left up before we started to move, then this is a tap.
        // we check this before onUpCommon as onUpCommon resets the dragging
        // let tap = !this.dragging;
        // let tapTarget = this.currentDragParams.eElement;
        this.onUpCommon(touch, el);
        // if tap, tell user
        // console.log(`${Math.random()} tap = ${tap}`);
        // if (tap) {
        //     tapTarget.click();
        // }
    }
    onMouseUp(mouseEvent, el) {
        this.onUpCommon(mouseEvent, el);
    }
    onUpCommon(eventOrTouch, el) {
        if (this.dragging) {
            this.dragging = false;
            this.currentDragParams.onDragStop(eventOrTouch);
            this.eventSvc.dispatchEvent({
                type: 'dragStopped',
                target: el,
            });
        }
        this.resetDragProperties();
    }
    cancelDrag(el) {
        this.eventSvc.dispatchEvent({
            type: 'dragCancelled',
            target: el,
        });
        this.currentDragParams?.onDragCancel?.();
        this.resetDragProperties();
    }
    resetDragProperties() {
        this.mouseStartEvent = null;
        this.startTarget = null;
        this.touchStart = null;
        this.touchLastTime = null;
        this.currentDragParams = null;
        const { dragEndFunctions } = this;
        dragEndFunctions.forEach((func) => func());
        dragEndFunctions.length = 0;
    }
}
exports.DragService = DragService;


/***/ }),

/***/ 6843:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HorizontalResizeService = void 0;
const beanStub_1 = __webpack_require__(8731);
class HorizontalResizeService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'horizontalResizeSvc';
    }
    addResizeBar(params) {
        const dragSource = {
            dragStartPixels: params.dragStartPixels || 0,
            eElement: params.eResizeBar,
            onDragStart: this.onDragStart.bind(this, params),
            onDragStop: this.onDragStop.bind(this, params),
            onDragging: this.onDragging.bind(this, params),
            onDragCancel: this.onDragStop.bind(this, params),
            includeTouch: true,
            stopPropagationForTouch: true,
        };
        const { dragSvc } = this.beans;
        dragSvc.addDragSource(dragSource);
        // we pass remove func back to the caller, so call can tell us when they
        // are finished, and then we remove the listener from the drag source
        const finishedWithResizeFunc = () => dragSvc.removeDragSource(dragSource);
        return finishedWithResizeFunc;
    }
    onDragStart(params, mouseEvent) {
        this.dragStartX = mouseEvent.clientX;
        this.setResizeIcons();
        const shiftKey = mouseEvent instanceof MouseEvent && mouseEvent.shiftKey === true;
        params.onResizeStart(shiftKey);
    }
    setResizeIcons() {
        const ctrl = this.beans.ctrlsSvc.get('gridCtrl');
        // change the body cursor, so when drag moves out of the drag bar, the cursor is still 'resize' (or 'move'
        ctrl.setResizeCursor(true);
        // we don't want text selection outside the grid (otherwise it looks weird as text highlights when we move)
        ctrl.disableUserSelect(true);
    }
    onDragStop(params) {
        params.onResizeEnd(this.resizeAmount);
        this.resetIcons();
    }
    resetIcons() {
        const ctrl = this.beans.ctrlsSvc.get('gridCtrl');
        ctrl.setResizeCursor(false);
        ctrl.disableUserSelect(false);
    }
    onDragging(params, mouseEvent) {
        this.resizeAmount = mouseEvent.clientX - this.dragStartX;
        params.onResizing(this.resizeAmount);
    }
}
exports.HorizontalResizeService = HorizontalResizeService;


/***/ }),

/***/ 1633:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowDragComp = void 0;
const beanStub_1 = __webpack_require__(8731);
const icon_1 = __webpack_require__(9970);
const component_1 = __webpack_require__(8020);
const dragAndDropService_1 = __webpack_require__(2903);
const RowDragElement = {
    tag: 'div',
    cls: 'ag-drag-handle ag-row-drag',
    attrs: { 'aria-hidden': 'true' },
};
class RowDragComp extends component_1.Component {
    constructor(cellValueFn, rowNode, column, customGui, dragStartPixels, suppressVisibilityChange) {
        super();
        this.cellValueFn = cellValueFn;
        this.rowNode = rowNode;
        this.column = column;
        this.customGui = customGui;
        this.dragStartPixels = dragStartPixels;
        this.suppressVisibilityChange = suppressVisibilityChange;
        this.dragSource = null;
    }
    isCustomGui() {
        return this.customGui != null;
    }
    postConstruct() {
        const { beans, rowNode, column, gos } = this;
        if (!this.customGui) {
            this.setTemplate(RowDragElement);
            this.getGui().appendChild((0, icon_1._createIconNoSpan)('rowDrag', beans, null));
            this.addDragSource();
        }
        else {
            this.setDragElement(this.customGui, this.dragStartPixels);
        }
        if (!this.suppressVisibilityChange) {
            const strategy = gos.get('rowDragManaged')
                ? new ManagedVisibilityStrategy(this, rowNode, column)
                : new NonManagedVisibilityStrategy(this, rowNode, column);
            this.createManagedBean(strategy, this.beans.context);
        }
    }
    setDragElement(dragElement, dragStartPixels) {
        // We set suppressDataRefValidation as the drag element could contain AG Grid comps with data references
        // that are not part of this row dragger's context. Maybe this should just setGui and not setTemplateFromElement?
        this.setTemplateFromElement(dragElement, undefined, undefined, true);
        this.addDragSource(dragStartPixels);
    }
    getSelectedNodes() {
        const rowNode = this.rowNode;
        const isRowDragMultiRow = this.gos.get('rowDragMultiRow');
        if (!isRowDragMultiRow) {
            return [rowNode];
        }
        const selection = this.beans.selectionSvc?.getSelectedNodes() ?? [];
        return selection.indexOf(rowNode) !== -1 ? selection : [rowNode];
    }
    getDragItem() {
        const { column, rowNode } = this;
        return {
            rowNode,
            rowNodes: this.getSelectedNodes(),
            columns: column ? [column] : undefined,
            defaultTextValue: this.cellValueFn(),
        };
    }
    getRowDragText(column) {
        if (column) {
            const colDef = column.getColDef();
            if (colDef.rowDragText) {
                return colDef.rowDragText;
            }
        }
        return this.gos.get('rowDragText');
    }
    addDragSource(dragStartPixels = 4) {
        // if this is changing the drag element, delete the previous dragSource
        if (this.dragSource) {
            this.removeDragSource();
        }
        if (this.gos.get('rowDragManaged') && this.rowNode.footer) {
            return; // Footer nodes in row drag managed mode are not draggable
        }
        const eGui = this.getGui();
        if (this.gos.get('enableCellTextSelection')) {
            this.removeMouseDownListener();
            this.mouseDownListener = this.addManagedElementListeners(eGui, {
                mousedown: (e) => {
                    e?.preventDefault();
                },
            })[0];
        }
        const translate = this.getLocaleTextFunc();
        this.dragSource = {
            type: dragAndDropService_1.DragSourceType.RowDrag,
            eElement: eGui,
            dragItemName: () => {
                const dragItem = this.getDragItem();
                const dragItemCount = dragItem.rowNodes?.length || 1;
                const rowDragText = this.getRowDragText(this.column);
                if (rowDragText) {
                    return rowDragText(dragItem, dragItemCount);
                }
                return dragItemCount === 1
                    ? this.cellValueFn()
                    : `${dragItemCount} ${translate('rowDragRows', 'rows')}`;
            },
            getDragItem: () => this.getDragItem(),
            dragStartPixels,
            dragSourceDomDataKey: this.gos.getDomDataKey(),
        };
        this.beans.dragAndDrop.addDragSource(this.dragSource, true);
    }
    destroy() {
        this.removeDragSource();
        this.removeMouseDownListener();
        super.destroy();
    }
    removeDragSource() {
        if (!this.dragSource) {
            return;
        }
        this.beans.dragAndDrop.removeDragSource(this.dragSource);
        this.dragSource = null;
    }
    removeMouseDownListener() {
        if (!this.mouseDownListener) {
            return;
        }
        this.mouseDownListener();
        this.mouseDownListener = undefined;
    }
}
exports.RowDragComp = RowDragComp;
class VisibilityStrategy extends beanStub_1.BeanStub {
    constructor(parent, rowNode, column) {
        super();
        this.parent = parent;
        this.rowNode = rowNode;
        this.column = column;
    }
    setDisplayedOrVisible(neverDisplayed, alwaysHidden = false) {
        const displayedOptions = { skipAriaHidden: true };
        if (neverDisplayed) {
            this.parent.setDisplayed(false, displayedOptions);
        }
        else {
            let shown = !alwaysHidden;
            let isShownSometimes = false;
            const { column, rowNode, parent } = this;
            if (column) {
                const rowDrag = column.getColDef().rowDrag;
                isShownSometimes = typeof rowDrag === 'function';
                shown = (alwaysHidden ? !!rowDrag : column.isRowDrag(rowNode)) || parent.isCustomGui();
            }
            // if shown sometimes, them some rows can have drag handle while other don't,
            // so we use setVisible to keep the handles horizontally aligned (as _setVisible
            // keeps the empty space, whereas setDisplayed looses the space)
            if (isShownSometimes) {
                parent.setDisplayed(true, displayedOptions);
                parent.setVisible(shown && !alwaysHidden, displayedOptions);
            }
            else {
                parent.setDisplayed(shown, displayedOptions);
                parent.setVisible(!alwaysHidden, displayedOptions);
            }
        }
    }
}
// when non managed, the visibility depends on suppressRowDrag property only
class NonManagedVisibilityStrategy extends VisibilityStrategy {
    postConstruct() {
        this.addManagedPropertyListener('suppressRowDrag', this.onSuppressRowDrag.bind(this));
        // in case data changes, then we need to update visibility of drag item
        const listener = this.workOutVisibility.bind(this);
        this.addManagedListeners(this.rowNode, {
            dataChanged: listener,
            cellChanged: listener,
        });
        this.addManagedListeners(this.beans.eventSvc, { newColumnsLoaded: listener });
        this.workOutVisibility();
    }
    onSuppressRowDrag() {
        this.workOutVisibility();
    }
    workOutVisibility() {
        // only show the drag if both sort and filter are not present
        const neverDisplayed = this.gos.get('suppressRowDrag');
        this.setDisplayedOrVisible(neverDisplayed);
    }
}
// when managed, the visibility depends on sort, filter and row group, as well as suppressRowDrag property
class ManagedVisibilityStrategy extends VisibilityStrategy {
    postConstruct() {
        const listener = this.workOutVisibility.bind(this);
        // we do not show the component if sort, filter or grouping is active
        this.addManagedListeners(this.beans.eventSvc, {
            sortChanged: listener,
            filterChanged: listener,
            columnRowGroupChanged: listener,
            newColumnsLoaded: listener,
        });
        // in case data changes, then we need to update visibility of drag item
        this.addManagedListeners(this.rowNode, {
            dataChanged: listener,
            cellChanged: listener,
        });
        this.addManagedPropertyListener('suppressRowDrag', this.onSuppressRowDrag.bind(this));
        this.workOutVisibility();
    }
    onSuppressRowDrag() {
        this.workOutVisibility();
    }
    workOutVisibility() {
        const { rowDragSvc, dragAndDrop, gos } = this.beans;
        // only show the drag if both sort and filter are not present
        const rowDragFeature = rowDragSvc.rowDragFeature;
        const shouldPreventRowMove = rowDragFeature && rowDragFeature.shouldPreventRowMove();
        const suppressRowDrag = gos.get('suppressRowDrag');
        const hasExternalDropZones = dragAndDrop.hasExternalDropZones();
        const neverDisplayed = (shouldPreventRowMove && !hasExternalDropZones) || suppressRowDrag;
        this.setDisplayedOrVisible(neverDisplayed, this.rowNode.footer);
    }
}


/***/ }),

/***/ 2254:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowDragFeature = void 0;
const autoScrollService_1 = __webpack_require__(5628);
const beanStub_1 = __webpack_require__(8731);
const positionUtils_1 = __webpack_require__(6257);
const mouseEventUtils_1 = __webpack_require__(8399);
const gridOptionsUtils_1 = __webpack_require__(7274);
const array_1 = __webpack_require__(1502);
const changedPath_1 = __webpack_require__(6800);
const logging_1 = __webpack_require__(7764);
const dragAndDropService_1 = __webpack_require__(2903);
class RowDragFeature extends beanStub_1.BeanStub {
    constructor(eContainer) {
        super();
        this.eContainer = null;
        this.lastDraggingEvent = null;
        this.autoScrollService = null;
        this.makeGroupThrottleTimer = null;
        this.makeGroupThrottleTarget = null;
        this.makeGroupThrottled = false;
        this.makeGroupThrottleCallback = () => {
            this.makeGroupThrottleTimer = null;
            const event = this.lastDraggingEvent;
            if (event) {
                this.makeGroupThrottled = true;
                this.doManagedDrag(event, false);
                this.makeGroupExpanded(this.makeGroupThrottleTarget);
            }
        };
        this.eContainer = eContainer;
    }
    postConstruct() {
        const { rowModel, gos, ctrlsSvc } = this.beans;
        if ((0, gridOptionsUtils_1._isClientSideRowModel)(gos, rowModel)) {
            this.clientSideRowModel = rowModel;
        }
        ctrlsSvc.whenReady(this, (p) => {
            const gridBodyCon = p.gridBodyCtrl;
            let oldVScroll = 0;
            const getVScroll = () => gridBodyCon.scrollFeature.getVScrollPosition().top;
            this.autoScrollService = new autoScrollService_1.AutoScrollService({
                scrollContainer: gridBodyCon.eBodyViewport,
                scrollAxis: 'y',
                getVerticalPosition: getVScroll,
                setVerticalPosition: (position) => gridBodyCon.scrollFeature.setVerticalScrollPosition(position),
                onScrollCallback: () => {
                    const newVScroll = getVScroll();
                    if (oldVScroll !== newVScroll) {
                        oldVScroll = newVScroll;
                        const lastDraggingEvent = this.lastDraggingEvent;
                        if (lastDraggingEvent) {
                            this.onDragging(lastDraggingEvent);
                        }
                    }
                },
            });
        });
    }
    destroy() {
        super.destroy();
        this.eContainer = null;
        this.lastDraggingEvent = null;
        this.makeGroupThrottleClear();
        const autoScrollService = this.autoScrollService;
        if (autoScrollService) {
            this.autoScrollService = null;
            autoScrollService?.ensureCleared();
        }
    }
    getContainer() {
        return this.eContainer;
    }
    isInterestedIn(type) {
        return type === dragAndDropService_1.DragSourceType.RowDrag;
    }
    getIconName() {
        const managedDrag = this.gos.get('rowDragManaged');
        if (managedDrag && this.shouldPreventRowMove()) {
            return 'notAllowed';
        }
        return 'move';
    }
    shouldPreventRowMove() {
        const { rowGroupColsSvc, filterManager, sortSvc } = this.beans;
        const rowGroupCols = rowGroupColsSvc?.columns ?? [];
        if (rowGroupCols.length) {
            return true;
        }
        const isFilterPresent = filterManager?.isAnyFilterPresent();
        if (isFilterPresent) {
            return true;
        }
        const isSortActive = sortSvc?.isSortActive();
        if (isSortActive) {
            return true;
        }
        return false;
    }
    getRowNodes(draggingEvent) {
        if (!this.isFromThisGrid(draggingEvent)) {
            return (draggingEvent.dragItem.rowNodes || []);
        }
        const currentNode = draggingEvent.dragItem.rowNode;
        const isRowDragMultiRow = this.gos.get('rowDragMultiRow');
        if (isRowDragMultiRow) {
            const selectedNodes = [...(this.beans.selectionSvc?.getSelectedNodes() ?? [])].sort((a, b) => {
                if (a.rowIndex == null || b.rowIndex == null) {
                    return 0;
                }
                return this.getRowIndexNumber(a) - this.getRowIndexNumber(b);
            });
            if (selectedNodes.indexOf(currentNode) !== -1) {
                return selectedNodes;
            }
        }
        return [currentNode];
    }
    onDragEnter(draggingEvent) {
        // builds a lits of all rows being dragged before firing events
        draggingEvent.dragItem.rowNodes = this.getRowNodes(draggingEvent);
        // when entering, we fire the enter event, then in onEnterOrDragging,
        // we also fire the move event. so we get both events when entering.
        this.dispatchGridEvent('rowDragEnter', draggingEvent);
        this.getRowNodes(draggingEvent).forEach((rowNode) => {
            this.setRowNodeDragging(rowNode, true);
        });
        this.onEnterOrDragging(draggingEvent);
    }
    onDragging(draggingEvent) {
        this.onEnterOrDragging(draggingEvent);
    }
    isFromThisGrid(draggingEvent) {
        const { dragSourceDomDataKey } = draggingEvent.dragSource;
        return dragSourceDomDataKey === this.gos.getDomDataKey();
    }
    onEnterOrDragging(draggingEvent) {
        if (!this.autoScrollService) {
            return; // destroyed
        }
        // this event is fired for enter and move
        this.dispatchGridEvent('rowDragMove', draggingEvent);
        this.lastDraggingEvent = draggingEvent;
        if (this.gos.get('rowDragManaged')) {
            this.doManagedDrag(draggingEvent, true);
        }
        this.autoScrollService.check(draggingEvent.event);
    }
    doManagedDrag(draggingEvent, throttleMakeGroup) {
        const { dragAndDrop, gos } = this.beans;
        const isFromThisGrid = this.isFromThisGrid(draggingEvent);
        const managedDrag = gos.get('rowDragManaged');
        if (managedDrag && this.shouldPreventRowMove()) {
            return;
        }
        if (gos.get('suppressMoveWhenRowDragging') || !isFromThisGrid) {
            if (dragAndDrop.isDropZoneWithinThisGrid(draggingEvent)) {
                const rowsDrop = this.managedRowsDrop(draggingEvent, throttleMakeGroup);
                const target = rowsDrop?.target;
                const rowDropHighlightSvc = this.beans.rowDropHighlightSvc;
                if (target && rowsDrop.rows.length) {
                    rowDropHighlightSvc.set(target, rowsDrop.position);
                }
                else {
                    rowDropHighlightSvc.clear();
                }
            }
        }
        else {
            const rowsDrop = this.managedRowsDrop(draggingEvent, throttleMakeGroup);
            if (rowsDrop) {
                this.dropRows(rowsDrop);
            }
        }
    }
    getRowIndexNumber(rowNode) {
        const rowIndexStr = rowNode.getRowIndexString();
        return parseInt((0, array_1._last)(rowIndexStr.split('-')), 10);
    }
    managedRowsDrop(draggingEvent, throttleMakeGroup) {
        const { rowNode, rowNodes: rows } = draggingEvent.dragItem;
        const rowsLen = rows?.length;
        const source = rowsLen && (rowNode ?? rows[0]);
        if (!source) {
            this.makeGroupThrottleClear();
            return null; // Nothing to move
        }
        const { beans, gos, clientSideRowModel } = this;
        const rootNode = clientSideRowModel.rootNode;
        const y = (0, mouseEventUtils_1._getNormalisedMousePosition)(beans, draggingEvent).y;
        let targetRowIndex = clientSideRowModel.getRowIndexAtPixel(y);
        let target = clientSideRowModel.getRow(targetRowIndex) ?? null;
        const moved = source !== target;
        let yDelta = target ? (y - target.rowTop - target.rowHeight / 2) / target.rowHeight || 0 : 1;
        const sameGrid = this.isFromThisGrid(draggingEvent);
        const groupingApproach = (0, gridOptionsUtils_1._getGroupingApproach)(gos);
        const canSetParent = 
        // We don't yet support drag and drop with grouping
        groupingApproach !== 'group' &&
            // We don't yet support moving tree rows from a different grid in a structured way
            sameGrid;
        let newParent = null;
        if (canSetParent && target?.footer) {
            // Footer row. Get the real parent, that is the sibling of the footer
            newParent = target.sibling ?? rootNode;
            const found = getPrevOrNext(clientSideRowModel, -1, target) ?? getPrevOrNext(clientSideRowModel, 1, target);
            yDelta = found && found.rowIndex > target.rowIndex ? -0.5 : 0.5;
            target = found ?? null;
        }
        let above = yDelta < 0;
        let targetInRows = false;
        if (sameGrid && target) {
            if (!moved) {
                if (Math.abs(yDelta) <= 0.5) {
                    this.makeGroupThrottleClear();
                    return null; // Nothing to move
                }
                targetInRows = true;
            }
            else {
                targetInRows = rows.indexOf(target) >= 0;
                if (targetInRows) {
                    const newTarget = getRowsPrevOrNext(clientSideRowModel, targetRowIndex < source.rowIndex, rows);
                    if (newTarget?.parent === target.parent) {
                        target = newTarget; // Delta dragging, the user moved to a selected row above or below
                        targetRowIndex = target.rowIndex;
                    }
                }
            }
            if (targetInRows || (!canSetParent && Math.abs(targetRowIndex - source.rowIndex) === 1)) {
                above = targetRowIndex < source.rowIndex; // Select the row above or below without the mid point if the diff is 1
            }
        }
        const makeGroupThrottleTarget = this.makeGroupThrottleTarget;
        if (makeGroupThrottleTarget !== null && makeGroupThrottleTarget !== target) {
            this.makeGroupThrottleClear();
        }
        if (target?.expanded && target.childrenAfterSort?.length) {
            this.makeGroupThrottled = true;
            this.makeGroupThrottleTarget = target;
        }
        if (newParent === null && canSetParent) {
            if (!target || (yDelta >= 0.5 && target.rowIndex === beans.pageBounds.getLastRow())) {
                newParent = rootNode; // Dragging outside of the rows, move to last row at the root level
            }
            else if (this.targetShouldBeParent(target, yDelta, targetInRows, rows)) {
                if (this.makeGroupThrottled) {
                    newParent = target;
                }
                if (throttleMakeGroup && (newParent === null || !target.expanded)) {
                    this.makeGroupThrottleTarget = target;
                    this.makeGroupThrottleStart();
                }
            }
            newParent ?? (newParent = target?.parent ?? rootNode);
        }
        let inside = false;
        if (newParent !== null) {
            if (newParent === target && newParent !== rootNode) {
                inside = true; // Dragging as child
                const firstRow = newParent.expanded ? getPrevOrNext(clientSideRowModel, 1, target) : null;
                if (firstRow?.parent === newParent) {
                    target = firstRow; // Instead of showing "inside" style, we can show "above" by using first child as target
                    inside = false;
                    above = true;
                }
            }
            if (target && !inside) {
                // Set target to the first group that is not the root node or the new parent
                let current = target;
                while (current && current !== rootNode && current !== newParent) {
                    target = current;
                    current = current.parent;
                }
            }
            if (rowsHaveSameParent(rows, newParent)) {
                newParent = null; // No need to set parent if all rows have the same parent
            }
        }
        if (!newParent && targetInRows && (canSetParent || source === target)) {
            // No delta dragging of multiple rows with TreeData or no change, nothing to move
            return null;
        }
        const position = inside ? 'inside' : above ? 'above' : 'below';
        const result = {
            api: this.beans.gridApi,
            context: this.beans.gridOptions.context,
            draggingEvent,
            sameGrid,
            position,
            source,
            target,
            newParent,
            rows,
        };
        let customPosition = false;
        const isRowValidDropPosition = gos.get('isRowValidDropPosition');
        if (isRowValidDropPosition) {
            const canDropResult = isRowValidDropPosition(result);
            if (!canDropResult) {
                result.rows = array_1._EmptyArray; // Cannot drop, so no rows
            }
            else if (typeof canDropResult === 'object') {
                // Custom result, override the default values
                if (canDropResult.rows !== undefined) {
                    result.rows = canDropResult.rows ?? array_1._EmptyArray;
                }
                if (canDropResult.newParent !== undefined) {
                    result.newParent = canDropResult.newParent;
                }
                if (canDropResult.target !== undefined) {
                    result.target = canDropResult.target;
                }
                if (canDropResult.position) {
                    customPosition = true;
                    result.position = canDropResult.position;
                }
            }
        }
        if ((!result.newParent || !result.rows.length) && !customPosition) {
            result.position = above ? 'above' : 'below'; // Remove 'inside' if no new parent
        }
        return result;
    }
    makeGroupThrottleStart() {
        if (this.makeGroupThrottleTimer === null) {
            this.makeGroupThrottleTimer = window.setTimeout(this.makeGroupThrottleCallback, this.gos.get('rowDragInsertDelay'));
        }
    }
    makeGroupExpanded(target) {
        if (target && !target.expanded && target.childrenAfterSort?.length && target.isExpandable()) {
            target.setExpanded(true, this.lastDraggingEvent?.event, true);
        }
    }
    makeGroupThrottleClear() {
        this.makeGroupThrottled = false;
        this.makeGroupThrottleTarget = null;
        const timer = this.makeGroupThrottleTimer;
        if (timer !== null) {
            this.makeGroupThrottleTimer = null;
            clearTimeout(timer);
        }
    }
    targetShouldBeParent(target, yDelta, targetInRows, rows) {
        const targetRowIndex = target?.rowIndex;
        if (targetInRows || targetRowIndex === null) {
            return false;
        }
        const INSIDE_THRESHOLD = 0.25;
        if (yDelta < -0.5 + INSIDE_THRESHOLD) {
            return false; // Definitely above
        }
        if (yDelta < 0.5 - INSIDE_THRESHOLD) {
            return true; // Definitely inside
        }
        let nextRow;
        let nextRowIndex = targetRowIndex + 1;
        const clientSideRowModel = this.clientSideRowModel;
        do {
            nextRow = clientSideRowModel.getRow(nextRowIndex++);
        } while (nextRow && nextRow.footer);
        const childrenAfterGroup = target.childrenAfterGroup;
        if (nextRow && nextRow.parent === target && childrenAfterGroup?.length) {
            const rowsSet = new Set(rows);
            for (const child of childrenAfterGroup) {
                if (child.rowIndex !== null && !rowsSet.has(child)) {
                    return true; // The group has children, so we can move inside
                }
            }
        }
        return false;
    }
    addRowDropZone(params) {
        if (!params.getContainer()) {
            (0, logging_1._warn)(55);
            return;
        }
        const dragAndDrop = this.beans.dragAndDrop;
        if (dragAndDrop.findExternalZone(params)) {
            (0, logging_1._warn)(56);
            return;
        }
        let processedParams = {
            getContainer: params.getContainer,
        };
        if (params.fromGrid) {
            processedParams = params;
        }
        else {
            if (params.onDragEnter) {
                processedParams.onDragEnter = (e) => {
                    params.onDragEnter(this.draggingToRowDragEvent('rowDragEnter', e));
                };
            }
            if (params.onDragLeave) {
                processedParams.onDragLeave = (e) => {
                    params.onDragLeave(this.draggingToRowDragEvent('rowDragLeave', e));
                };
            }
            if (params.onDragging) {
                processedParams.onDragging = (e) => {
                    params.onDragging(this.draggingToRowDragEvent('rowDragMove', e));
                };
            }
            if (params.onDragStop) {
                processedParams.onDragStop = (e) => {
                    params.onDragStop(this.draggingToRowDragEvent('rowDragEnd', e));
                };
            }
            if (params.onDragCancel) {
                processedParams.onDragCancel = (e) => {
                    params.onDragCancel(this.draggingToRowDragEvent('rowDragCancel', e));
                };
            }
        }
        const dropTarget = {
            isInterestedIn: (type) => type === dragAndDropService_1.DragSourceType.RowDrag,
            getIconName: () => 'move',
            external: true,
            ...processedParams,
        };
        dragAndDrop.addDropTarget(dropTarget);
        this.addDestroyFunc(() => dragAndDrop.removeDropTarget(dropTarget));
    }
    getRowDropZone(events) {
        const getContainer = this.getContainer.bind(this);
        const onDragEnter = this.onDragEnter.bind(this);
        const onDragLeave = this.onDragLeave.bind(this);
        const onDragging = this.onDragging.bind(this);
        const onDragStop = this.onDragStop.bind(this);
        const onDragCancel = this.onDragCancel.bind(this);
        let params;
        if (!events) {
            params = {
                getContainer,
                onDragEnter,
                onDragLeave,
                onDragging,
                onDragStop,
                onDragCancel,
                /* @private */ fromGrid: true,
            };
        }
        else {
            params = {
                getContainer,
                onDragEnter: events.onDragEnter
                    ? (e) => {
                        onDragEnter(e);
                        events.onDragEnter(this.draggingToRowDragEvent('rowDragEnter', e));
                    }
                    : onDragEnter,
                onDragLeave: events.onDragLeave
                    ? (e) => {
                        onDragLeave(e);
                        events.onDragLeave(this.draggingToRowDragEvent('rowDragLeave', e));
                    }
                    : onDragLeave,
                onDragging: events.onDragging
                    ? (e) => {
                        onDragging(e);
                        events.onDragging(this.draggingToRowDragEvent('rowDragMove', e));
                    }
                    : onDragging,
                onDragStop: events.onDragStop
                    ? (e) => {
                        onDragStop(e);
                        events.onDragStop(this.draggingToRowDragEvent('rowDragEnd', e));
                    }
                    : onDragStop,
                onDragCancel: events.onDragCancel
                    ? (e) => {
                        onDragCancel(e);
                        events.onDragCancel(this.draggingToRowDragEvent('rowDragCancel', e));
                    }
                    : onDragCancel,
                fromGrid: true /* @private */,
            };
        }
        // Cast to RowDropZoneParams to hide the internal properties
        return params;
    }
    draggingToRowDragEvent(type, draggingEvent) {
        const beans = this.beans;
        const { pageBounds, rowModel, gos } = beans;
        const y = (0, mouseEventUtils_1._getNormalisedMousePosition)(this.beans, draggingEvent).y;
        const mouseIsPastLastRow = y > pageBounds.getCurrentPagePixelRange().pageLastPixel;
        let overIndex = -1;
        let overNode;
        if (!mouseIsPastLastRow) {
            overIndex = rowModel.getRowIndexAtPixel(y);
            overNode = rowModel.getRow(overIndex);
        }
        const event = (0, gridOptionsUtils_1._addGridCommonParams)(gos, {
            type: type,
            event: draggingEvent.event,
            node: draggingEvent.dragItem.rowNode,
            nodes: draggingEvent.dragItem.rowNodes,
            overIndex: overIndex,
            overNode: overNode,
            y,
            vDirection: draggingEvent.vDirection,
        });
        return event;
    }
    dispatchGridEvent(type, draggingEvent) {
        const event = this.draggingToRowDragEvent(type, draggingEvent);
        this.eventSvc.dispatchEvent(event);
    }
    onDragLeave(draggingEvent) {
        this.dispatchGridEvent('rowDragLeave', draggingEvent);
        this.stopDragging(draggingEvent);
        if (this.gos.get('rowDragManaged')) {
            this.beans.rowDropHighlightSvc.clear();
        }
        this.makeGroupThrottleClear();
    }
    onDragStop(draggingEvent) {
        this.dispatchGridEvent('rowDragEnd', draggingEvent);
        this.stopDragging(draggingEvent);
        const { dragAndDrop, gos } = this.beans;
        if (gos.get('rowDragManaged') &&
            (gos.get('suppressMoveWhenRowDragging') || !this.isFromThisGrid(draggingEvent)) &&
            dragAndDrop.isDropZoneWithinThisGrid(draggingEvent)) {
            const rowsDrop = this.managedRowsDrop(draggingEvent, false);
            if (rowsDrop) {
                this.dropRows(rowsDrop);
            }
            this.beans.rowDropHighlightSvc.clear();
        }
        this.makeGroupThrottleClear();
    }
    onDragCancel(draggingEvent) {
        this.dispatchGridEvent('rowDragCancel', draggingEvent);
        this.stopDragging(draggingEvent);
        const { dragAndDrop, gos } = this.beans;
        if (gos.get('rowDragManaged') &&
            (gos.get('suppressMoveWhenRowDragging') || !this.isFromThisGrid(draggingEvent)) &&
            dragAndDrop.isDropZoneWithinThisGrid(draggingEvent)) {
            this.beans.rowDropHighlightSvc.clear();
        }
        this.makeGroupThrottleClear();
    }
    stopDragging(draggingEvent) {
        this.autoScrollService?.ensureCleared();
        this.getRowNodes(draggingEvent).forEach((rowNode) => {
            this.setRowNodeDragging(rowNode, false);
        });
    }
    setRowNodeDragging(rowNode, dragging) {
        if (rowNode.dragging !== dragging) {
            rowNode.dragging = dragging;
            rowNode.dispatchRowEvent('draggingChanged');
        }
    }
    /** Drag and drop. Returns false if at least a row was moved, otherwise true */
    dropRows(rowsDrop) {
        return rowsDrop.sameGrid ? this.moveRows(rowsDrop) : this.addRows(rowsDrop);
    }
    addRows({ position, target, rows }) {
        const getRowIdFunc = (0, gridOptionsUtils_1._getRowIdCallback)(this.gos);
        const clientSideRowModel = this.clientSideRowModel;
        const add = rows
            .filter(({ data, rowPinned }) => !clientSideRowModel.getRowNode(getRowIdFunc?.({ data, level: 0, rowPinned }) ?? data.id))
            .map(({ data }) => data);
        if (add.length === 0) {
            return false; // Nothing to add
        }
        const addIndex = target ? getLeafSourceRowIndex(target) + (position === 'above' ? 0 : 1) : undefined;
        clientSideRowModel.updateRowData({ add, addIndex });
        return true;
    }
    refreshModelAfterDrop() {
        this.clientSideRowModel.refreshModel({
            step: 'group',
            keepRenderedRows: true,
            animate: !this.gos.get('suppressAnimationFrame'),
            changedPath: new changedPath_1.ChangedPath(false, this.clientSideRowModel.rootNode),
            rowNodesOrderChanged: true,
        });
    }
    moveRows({ position, target, rows, newParent }) {
        let changed = false;
        const clientSideRowModel = this.clientSideRowModel;
        const leafs = new Set();
        for (const row of rows) {
            if (row.footer || (row.rowTop === null && row !== clientSideRowModel.getRowNode(row.id))) {
                continue; // This row cannot be dragged, not in allLeafChildren and not a filler
            }
            if (newParent && row.parent !== newParent) {
                if (wouldFormCycle(row, newParent)) {
                    continue; // Invalid move.
                }
                row.treeParent = newParent;
                changed = true;
            }
            const leafRow = getLeafRow(row);
            if (leafRow) {
                leafs.add(leafRow);
            }
        }
        if (!changed && leafs.size === 0) {
            return false; // Nothing to move
        }
        // Get the focussed cell so we can ensure it remains focussed after the move
        const focusSvc = this.beans.focusSvc;
        const cellPosition = focusSvc.getFocusedCell();
        const cellCtrl = cellPosition && (0, positionUtils_1._getCellByPosition)(this.beans, cellPosition);
        if (leafs.size &&
            this.reorderLeafChildren(leafs, ...this.getMoveRowsBounds(leafs, target, position === 'above'))) {
            changed = true;
        }
        if (!changed) {
            return false;
        }
        this.refreshModelAfterDrop();
        // Get the focussed cell so we can ensure it remains focussed after the move
        if (cellCtrl) {
            cellCtrl.focusCell();
        }
        else {
            focusSvc.clearFocusedCell();
        }
        return true;
    }
    /** For reorderLeafChildren, returns min index of the rows to move, the target index and the max index of the rows to move. */
    getMoveRowsBounds(leafs, target, above) {
        const totalRows = this.clientSideRowModel.rootNode?.allLeafChildren.length ?? 0;
        let targetPositionIdx = getLeafSourceRowIndex(target);
        if (targetPositionIdx < 0 || targetPositionIdx >= totalRows) {
            targetPositionIdx = totalRows;
        }
        else if (!above) {
            ++targetPositionIdx;
        }
        let firstAffectedLeafIdx = targetPositionIdx;
        let lastAffectedLeafIndex = Math.min(targetPositionIdx, totalRows - 1);
        for (const row of leafs) {
            const sourceRowIndex = row.sourceRowIndex;
            if (sourceRowIndex < firstAffectedLeafIdx)
                firstAffectedLeafIdx = sourceRowIndex;
            if (sourceRowIndex > lastAffectedLeafIndex)
                lastAffectedLeafIndex = sourceRowIndex;
        }
        return [firstAffectedLeafIdx, targetPositionIdx, lastAffectedLeafIndex];
    }
    /** Reorders the children of the root node, so that the rows to move are in the correct order.
     * @param leafs The valid set of rows to move, as returned by getValidRowsToMove
     * @param firstAffectedLeafIdx The first index of the rows to move
     * @param targetPositionIdx The target index, where the rows will be moved
     * @param lastAffectedLeafIndex The last index of the rows to move
     * @returns True if the order of the rows changed, false otherwise
     */
    reorderLeafChildren(leafs, firstAffectedLeafIdx, targetPositionIdx, lastAffectedLeafIndex) {
        let orderChanged = false;
        const allLeafChildren = this.clientSideRowModel.rootNode?.allLeafChildren;
        if (!leafs.size || !allLeafChildren) {
            return false;
        }
        // First partition. Filter from left to right, so the middle can be overwritten
        let writeIdxLeft = firstAffectedLeafIdx;
        for (let readIdx = firstAffectedLeafIdx; readIdx < targetPositionIdx; ++readIdx) {
            const row = allLeafChildren[readIdx];
            if (!leafs.has(row)) {
                if (row.sourceRowIndex !== writeIdxLeft) {
                    row.sourceRowIndex = writeIdxLeft;
                    allLeafChildren[writeIdxLeft] = row;
                    orderChanged = true;
                }
                ++writeIdxLeft;
            }
        }
        // Third partition. Filter from right to left, so the middle can be overwritten
        let writeIdxRight = lastAffectedLeafIndex;
        for (let readIdx = lastAffectedLeafIndex; readIdx >= targetPositionIdx; --readIdx) {
            const row = allLeafChildren[readIdx];
            if (!leafs.has(row)) {
                if (row.sourceRowIndex !== writeIdxRight) {
                    row.sourceRowIndex = writeIdxRight;
                    allLeafChildren[writeIdxRight] = row;
                    orderChanged = true;
                }
                --writeIdxRight;
            }
        }
        // Second partition. Overwrites the middle between the other two filtered partitions
        for (const row of leafs) {
            if (row.sourceRowIndex !== writeIdxLeft) {
                row.sourceRowIndex = writeIdxLeft;
                allLeafChildren[writeIdxLeft] = row;
                orderChanged = true;
            }
            ++writeIdxLeft;
        }
        return orderChanged;
    }
}
exports.RowDragFeature = RowDragFeature;
const getRowsPrevOrNext = (clientSideRowModel, above, rows) => {
    return above ? getPrevOrNext(clientSideRowModel, -1, rows[0]) : getPrevOrNext(clientSideRowModel, 1, (0, array_1._last)(rows));
};
/** When dragging multiple rows, we want the user to be able to drag to the prev or next in the group if dragging on one of the selected rows. */
const getPrevOrNext = (clientSideRowModel, increment, initialRow) => {
    if (initialRow) {
        const rowCount = clientSideRowModel.getRowCount();
        let rowIndex = initialRow.rowIndex + increment;
        while (rowIndex >= 0 && rowIndex < rowCount) {
            const row = clientSideRowModel.getRow(rowIndex);
            if (!row || !row.footer) {
                return row;
            }
            rowIndex += increment;
        }
    }
    return undefined; // Out of bounds
};
const wouldFormCycle = (row, newParent) => {
    let parent = newParent;
    while (parent) {
        if (parent === row) {
            return true;
        }
        parent = parent.parent;
    }
    return false;
};
const rowsHaveSameParent = (rows, newParent) => {
    for (let i = 0, len = rows.length; i < len; ++i) {
        if (rows[i].parent !== newParent) {
            return false;
        }
    }
    return true;
};
const getLeafSourceRowIndex = (row) => {
    const leaf = getLeafRow(row);
    return leaf !== undefined ? leaf.sourceRowIndex : -1;
};
const getLeafRow = (row) => {
    while (row) {
        if (row.sourceRowIndex >= 0) {
            return row;
        }
        const childrenAfterGroup = row.childrenAfterGroup;
        if (!childrenAfterGroup?.length) {
            return undefined;
        }
        row = childrenAfterGroup[0];
    }
};


/***/ }),

/***/ 2895:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowDragService = void 0;
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
const rowDragComp_1 = __webpack_require__(1633);
const rowDragFeature_1 = __webpack_require__(2254);
class RowDragService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'rowDragSvc';
    }
    setupRowDrag(element, ctrl) {
        const rowDragFeature = ctrl.createManagedBean(new rowDragFeature_1.RowDragFeature(element));
        const dragAndDrop = this.beans.dragAndDrop;
        dragAndDrop.addDropTarget(rowDragFeature);
        ctrl.addDestroyFunc(() => dragAndDrop.removeDropTarget(rowDragFeature));
        this.rowDragFeature = rowDragFeature;
    }
    createRowDragComp(cellValueFn, rowNode, column, customGui, dragStartPixels, suppressVisibilityChange) {
        return new rowDragComp_1.RowDragComp(cellValueFn, rowNode, column, customGui, dragStartPixels, suppressVisibilityChange);
    }
    createRowDragCompForRow(rowNode, element) {
        if ((0, gridOptionsUtils_1._isCellSelectionEnabled)(this.gos)) {
            return undefined;
        }
        const translate = this.getLocaleTextFunc();
        return this.createRowDragComp(() => `1 ${translate('rowDragRow', 'row')}`, rowNode, undefined, element, undefined, true);
    }
    createRowDragCompForCell(rowNode, column, cellValueFn, element, dragStartPixels, suppressVisibilityChange) {
        const gos = this.gos;
        if (gos.get('rowDragManaged')) {
            // row dragging only available in default row model and when not using pagination
            if (!(0, gridOptionsUtils_1._isClientSideRowModel)(gos) || gos.get('pagination')) {
                return undefined;
            }
        }
        // otherwise (normal case) we are creating a RowDraggingComp for the first time
        const rowDragComp = this.createRowDragComp(cellValueFn, rowNode, column, element, dragStartPixels, suppressVisibilityChange);
        return rowDragComp;
    }
}
exports.RowDragService = RowDragService;


/***/ }),

/***/ 7406:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowDropHighlightService = void 0;
const beanStub_1 = __webpack_require__(8731);
class RowDropHighlightService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'rowDropHighlightSvc';
        this.uiLevel = 0;
        this.row = null;
        this.position = 'none';
    }
    postConstruct() {
        this.addManagedEventListeners({
            modelUpdated: this.onModelUpdated.bind(this),
        });
    }
    onModelUpdated() {
        const row = this.row;
        if (!row || row.rowIndex === null || this.position === 'none') {
            this.clear();
        }
        else {
            this.set(row, this.position);
        }
    }
    destroy() {
        this.clear();
        super.destroy();
    }
    clear() {
        const last = this.row;
        if (last) {
            this.uiLevel = 0;
            this.position = 'none';
            this.row = null;
            last.dispatchRowEvent('rowHighlightChanged');
        }
    }
    set(row, dropIndicatorPosition) {
        const nodeChanged = row !== this.row;
        const uiLevel = row.uiLevel;
        const highlightChanged = dropIndicatorPosition !== this.position;
        const uiLevelChanged = uiLevel !== this.uiLevel;
        if (nodeChanged || highlightChanged || uiLevelChanged) {
            if (nodeChanged) {
                this.clear();
            }
            this.uiLevel = uiLevel;
            this.position = dropIndicatorPosition;
            this.row = row;
            row.dispatchRowEvent('rowHighlightChanged');
        }
    }
}
exports.RowDropHighlightService = RowDropHighlightService;


/***/ }),

/***/ 6564:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.cellEditingCSS = void 0;
exports.cellEditingCSS = `.ag-cell-inline-editing{border:var(--ag-cell-editing-border)!important;border-radius:var(--ag-border-radius);box-shadow:var(--ag-cell-editing-shadow);padding:0;z-index:1;.ag-cell-edit-wrapper,.ag-cell-editor,.ag-cell-wrapper,:where(.ag-cell-editor) .ag-input-field-input,:where(.ag-cell-editor) .ag-wrapper{height:100%;line-height:normal;min-height:100%;width:100%}&.ag-cell-editing-error{border-color:var(--ag-invalid-color)!important}}:where(.ag-popup-editor) .ag-large-text{background-color:var(--ag-background-color);border-radius:var(--ag-border-radius);box-shadow:var(--ag-dropdown-shadow);padding:0}.ag-large-text-input{height:auto;padding:var(--ag-cell-horizontal-padding)}:where(.ag-rtl .ag-large-text-input) textarea{resize:none}:where(.ag-ltr) .ag-checkbox-edit{padding-left:var(--ag-cell-horizontal-padding)}:where(.ag-rtl) .ag-checkbox-edit{padding-right:var(--ag-cell-horizontal-padding)}:where(.ag-row.ag-row-editing-invalid .ag-cell-inline-editing){opacity:.8}`;


/***/ }),

/***/ 227:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CheckboxCellEditor = void 0;
const aria_1 = __webpack_require__(5230);
const agAbstractCellEditor_1 = __webpack_require__(4872);
const agCheckbox_1 = __webpack_require__(66);
const component_1 = __webpack_require__(8020);
const CheckboxCellEditorElement = {
    tag: 'div',
    cls: 'ag-cell-wrapper ag-cell-edit-wrapper ag-checkbox-edit',
    children: [
        {
            tag: 'ag-checkbox',
            ref: 'eEditor',
            role: 'presentation',
        },
    ],
};
class CheckboxCellEditor extends agAbstractCellEditor_1.AgAbstractCellEditor {
    constructor() {
        super(CheckboxCellEditorElement, [agCheckbox_1.AgCheckboxSelector]);
        this.eEditor = component_1.RefPlaceholder;
    }
    initialiseEditor(params) {
        const isSelected = params.value ?? undefined;
        const eEditor = this.eEditor;
        eEditor.setValue(isSelected);
        const inputEl = eEditor.getInputElement();
        inputEl.setAttribute('tabindex', '-1');
        this.setAriaLabel(isSelected);
        this.addManagedListeners(eEditor, {
            fieldValueChanged: (event) => this.setAriaLabel(event.selected),
        });
    }
    getValue() {
        return this.eEditor.getValue();
    }
    focusIn() {
        this.eEditor.getFocusableElement().focus();
    }
    afterGuiAttached() {
        if (this.params.cellStartedEdit) {
            this.focusIn();
        }
    }
    isPopup() {
        return false;
    }
    setAriaLabel(isSelected) {
        const translate = this.getLocaleTextFunc();
        const stateName = (0, aria_1._getAriaCheckboxStateName)(translate, isSelected);
        const ariaLabel = translate('ariaToggleCellValue', 'Press SPACE to toggle cell value');
        this.eEditor.setInputAriaLabel(`${ariaLabel} (${stateName})`);
    }
    getValidationElement() {
        return this.eEditor.getInputElement();
    }
    getValidationErrors() {
        const { params } = this;
        const { getValidationErrors } = params;
        const value = this.getValue();
        if (!getValidationErrors) {
            return null;
        }
        return getValidationErrors({
            value,
            internalErrors: null,
            cellEditorParams: params,
        });
    }
}
exports.CheckboxCellEditor = CheckboxCellEditor;


/***/ }),

/***/ 5314:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DateCellEditor = void 0;
const date_1 = __webpack_require__(9827);
const generic_1 = __webpack_require__(4422);
const agInputDateField_1 = __webpack_require__(3611);
const simpleCellEditor_1 = __webpack_require__(5336);
const DateCellElement = {
    tag: 'ag-input-date-field',
    ref: 'eEditor',
    cls: 'ag-cell-editor',
};
class DateCellEditorInput {
    constructor(getDataTypeService, getLocaleTextFunc) {
        this.getDataTypeService = getDataTypeService;
        this.getLocaleTextFunc = getLocaleTextFunc;
    }
    getTemplate() {
        return DateCellElement;
    }
    getAgComponents() {
        return [agInputDateField_1.AgInputDateFieldSelector];
    }
    init(eEditor, params) {
        this.eEditor = eEditor;
        this.params = params;
        const { min, max, step, colDef } = params;
        if (min != null) {
            eEditor.setMin(min);
        }
        if (max != null) {
            eEditor.setMax(max);
        }
        if (step != null) {
            eEditor.setStep(step);
        }
        this.includeTime =
            params.includeTime ?? this.getDataTypeService()?.getDateIncludesTimeFlag?.(colDef.cellDataType);
        if (this.includeTime != null) {
            eEditor.setIncludeTime(this.includeTime);
        }
    }
    getValidationErrors() {
        const eInput = this.eEditor.getInputElement();
        const value = eInput.valueAsDate;
        const { params } = this;
        const { min, max, getValidationErrors } = params;
        let internalErrors = [];
        const translate = this.getLocaleTextFunc();
        if (value instanceof Date && !isNaN(value.getTime())) {
            if (min) {
                const minValue = min instanceof Date ? min : new Date(min);
                if (value < minValue) {
                    const minDateString = minValue.toLocaleDateString();
                    internalErrors.push(translate('minDateValidation', `Date must be after ${minDateString}`, [minDateString]));
                }
            }
            if (max) {
                const maxValue = max instanceof Date ? max : new Date(max);
                if (value > maxValue) {
                    const maxDateString = maxValue.toLocaleDateString();
                    internalErrors.push(translate('maxDateValidation', `Date must be before ${maxDateString}`, [maxDateString]));
                }
            }
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({ value, cellEditorParams: params, internalErrors });
        }
        return internalErrors;
    }
    getValue() {
        const { eEditor, params } = this;
        const value = eEditor.getDate();
        if (!(0, generic_1._exists)(value) && !(0, generic_1._exists)(params.value)) {
            return params.value;
        }
        return value ?? null;
    }
    getStartValue() {
        const { value } = this.params;
        if (!(value instanceof Date)) {
            return undefined;
        }
        return (0, date_1._serialiseDate)(value, this.includeTime ?? false);
    }
}
class DateCellEditor extends simpleCellEditor_1.SimpleCellEditor {
    constructor() {
        super(new DateCellEditorInput(() => this.beans.dataTypeSvc, () => this.getLocaleTextFunc()));
    }
}
exports.DateCellEditor = DateCellEditor;


/***/ }),

/***/ 2059:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DateStringCellEditor = void 0;
const date_1 = __webpack_require__(9827);
const generic_1 = __webpack_require__(4422);
const agInputDateField_1 = __webpack_require__(3611);
const simpleCellEditor_1 = __webpack_require__(5336);
const DateStringCellElement = {
    tag: 'ag-input-date-field',
    ref: 'eEditor',
    cls: 'ag-cell-editor',
};
class DateStringCellEditorInput {
    constructor(getDataTypeService, getLocaleTextFunc) {
        this.getDataTypeService = getDataTypeService;
        this.getLocaleTextFunc = getLocaleTextFunc;
    }
    getTemplate() {
        return DateStringCellElement;
    }
    getAgComponents() {
        return [agInputDateField_1.AgInputDateFieldSelector];
    }
    init(eEditor, params) {
        this.eEditor = eEditor;
        this.params = params;
        const { min, max, step, colDef } = params;
        if (min != null) {
            eEditor.setMin(min);
        }
        if (max != null) {
            eEditor.setMax(max);
        }
        if (step != null) {
            eEditor.setStep(step);
        }
        this.includeTime =
            params.includeTime ?? this.getDataTypeService()?.getDateIncludesTimeFlag?.(colDef.cellDataType);
        if (this.includeTime != null) {
            eEditor.setIncludeTime(this.includeTime);
        }
    }
    getValidationErrors() {
        const { eEditor, params } = this;
        const raw = eEditor.getInputElement().value;
        const value = this.formatDate(this.parseDate(raw ?? undefined));
        const { min, max, getValidationErrors } = params;
        let internalErrors = [];
        if (value) {
            const date = new Date(value);
            const translate = this.getLocaleTextFunc();
            if (min) {
                const minDate = new Date(min);
                if (date < minDate) {
                    const minDateString = minDate.toLocaleDateString();
                    internalErrors.push(translate('minDateValidation', `Date must be after ${minDateString}`, [minDateString]));
                }
            }
            if (max) {
                const maxDate = new Date(max);
                if (date > maxDate) {
                    const maxDateString = maxDate.toLocaleDateString();
                    internalErrors.push(translate('maxDateValidation', `Date must be before ${maxDateString}`, [maxDateString]));
                }
            }
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({
                value: this.getValue(),
                cellEditorParams: params,
                internalErrors,
            });
        }
        return internalErrors;
    }
    getValue() {
        const { params, eEditor } = this;
        const value = this.formatDate(eEditor.getDate());
        if (!(0, generic_1._exists)(value) && !(0, generic_1._exists)(params.value)) {
            return params.value;
        }
        return params.parseValue(value ?? '');
    }
    getStartValue() {
        return (0, date_1._serialiseDate)(this.parseDate(this.params.value ?? undefined) ?? null, this.includeTime ?? false);
    }
    parseDate(value) {
        const dataTypeSvc = this.getDataTypeService();
        return dataTypeSvc
            ? dataTypeSvc.getDateParserFunction(this.params.column)(value)
            : (0, date_1._parseDateTimeFromString)(value) ?? undefined;
    }
    formatDate(value) {
        const dataTypeSvc = this.getDataTypeService();
        return dataTypeSvc
            ? dataTypeSvc.getDateFormatterFunction(this.params.column)(value)
            : (0, date_1._serialiseDate)(value ?? null, this.includeTime ?? false) ?? undefined;
    }
}
class DateStringCellEditor extends simpleCellEditor_1.SimpleCellEditor {
    constructor() {
        super(new DateStringCellEditorInput(() => this.beans.dataTypeSvc, () => this.getLocaleTextFunc()));
    }
}
exports.DateStringCellEditor = DateStringCellEditor;


/***/ }),

/***/ 4578:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LargeTextCellEditor = void 0;
const keyCode_1 = __webpack_require__(9853);
const generic_1 = __webpack_require__(4422);
const agAbstractCellEditor_1 = __webpack_require__(4872);
const agInputTextArea_1 = __webpack_require__(6209);
const component_1 = __webpack_require__(8020);
const LargeTextCellElement = {
    tag: 'div',
    cls: 'ag-large-text',
    children: [
        {
            tag: 'ag-input-text-area',
            ref: 'eEditor',
            cls: 'ag-large-text-input',
        },
    ],
};
class LargeTextCellEditor extends agAbstractCellEditor_1.AgAbstractCellEditor {
    constructor() {
        super(LargeTextCellElement, [agInputTextArea_1.AgInputTextAreaSelector]);
        this.eEditor = component_1.RefPlaceholder;
    }
    initialiseEditor(params) {
        const { eEditor } = this;
        const { cellStartedEdit, value, maxLength, cols, rows } = params;
        this.focusAfterAttached = cellStartedEdit;
        // disable initial tooltips added to the input field
        // let the validation handle tooltips.
        eEditor.getInputElement().setAttribute('title', '');
        eEditor
            .setMaxLength(maxLength || 200)
            .setCols(cols || 60)
            .setRows(rows || 10);
        if (value != null) {
            eEditor.setValue(value.toString(), true);
        }
        this.addGuiEventListener('keydown', this.onKeyDown.bind(this));
        this.activateTabIndex();
    }
    onKeyDown(event) {
        const key = event.key;
        if (key === keyCode_1.KeyCode.LEFT ||
            key === keyCode_1.KeyCode.UP ||
            key === keyCode_1.KeyCode.RIGHT ||
            key === keyCode_1.KeyCode.DOWN ||
            (event.shiftKey && key === keyCode_1.KeyCode.ENTER)) {
            // shift+enter allows for newlines
            event.stopPropagation();
        }
    }
    afterGuiAttached() {
        const translate = this.getLocaleTextFunc();
        this.eEditor.setInputAriaLabel(translate('ariaInputEditor', 'Input Editor'));
        if (this.focusAfterAttached) {
            this.eEditor.getFocusableElement().focus();
        }
    }
    getValue() {
        const { eEditor, params } = this;
        const { value } = params;
        const editorValue = eEditor.getValue();
        if (!(0, generic_1._exists)(editorValue) && !(0, generic_1._exists)(value)) {
            return value;
        }
        return params.parseValue(editorValue);
    }
    getValidationElement() {
        return this.eEditor.getInputElement();
    }
    getValidationErrors() {
        const { params } = this;
        const { maxLength, getValidationErrors } = params;
        const translate = this.getLocaleTextFunc();
        const value = this.getValue();
        let internalErrors = [];
        if (typeof value === 'string' && maxLength != null && value.length > maxLength) {
            internalErrors.push(translate('maxLengthValidation', `Must be ${maxLength} characters or fewer.`, [String(maxLength)]));
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({
                value,
                internalErrors,
                cellEditorParams: params,
            });
        }
        return internalErrors;
    }
}
exports.LargeTextCellEditor = LargeTextCellEditor;


/***/ }),

/***/ 4371:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NumberCellEditor = void 0;
const keyCode_1 = __webpack_require__(9853);
const browser_1 = __webpack_require__(8667);
const generic_1 = __webpack_require__(4422);
const agInputNumberField_1 = __webpack_require__(8792);
const simpleCellEditor_1 = __webpack_require__(5336);
const NumberCellElement = {
    tag: 'ag-input-number-field',
    ref: 'eEditor',
    cls: 'ag-cell-editor',
};
class NumberCellEditorInput {
    constructor(getLocaleTextFunc) {
        this.getLocaleTextFunc = getLocaleTextFunc;
    }
    getTemplate() {
        return NumberCellElement;
    }
    getAgComponents() {
        return [agInputNumberField_1.AgInputNumberFieldSelector];
    }
    init(eEditor, params) {
        this.eEditor = eEditor;
        this.params = params;
        const { max, min, precision, step } = params;
        if (max != null) {
            eEditor.setMax(max);
        }
        if (min != null) {
            eEditor.setMin(min);
        }
        if (precision != null) {
            eEditor.setPrecision(precision);
        }
        if (step != null) {
            eEditor.setStep(step);
        }
        const editorEl = eEditor.getInputElement();
        if (params.preventStepping) {
            eEditor.addManagedElementListeners(editorEl, { keydown: this.preventStepping });
        }
        else if (params.showStepperButtons) {
            editorEl.classList.add('ag-number-field-input-stepper');
        }
    }
    getValidationErrors() {
        const { params } = this;
        const { min, max, getValidationErrors } = params;
        const eInput = this.eEditor.getInputElement();
        const value = eInput.valueAsNumber;
        const translate = this.getLocaleTextFunc();
        let internalErrors = [];
        if (typeof value === 'number') {
            if (min != null && value < min) {
                internalErrors.push(translate('minValueValidation', `Must be greater than or equal to ${min}.`, [String(min)]));
            }
            if (max != null && value > max) {
                internalErrors.push(translate('maxValueValidation', `Must be less than or equal to ${max}.`, [String(max)]));
            }
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({
                value,
                cellEditorParams: params,
                internalErrors,
            });
        }
        return internalErrors;
    }
    preventStepping(e) {
        if (e.key === keyCode_1.KeyCode.UP || e.key === keyCode_1.KeyCode.DOWN) {
            e.preventDefault();
        }
    }
    getValue() {
        const { eEditor, params } = this;
        const value = eEditor.getValue();
        if (!(0, generic_1._exists)(value) && !(0, generic_1._exists)(params.value)) {
            return params.value;
        }
        let parsedValue = params.parseValue(value);
        if (parsedValue == null) {
            return parsedValue;
        }
        if (typeof parsedValue === 'string') {
            if (parsedValue === '') {
                return null;
            }
            parsedValue = Number(parsedValue);
        }
        return isNaN(parsedValue) ? null : parsedValue;
    }
    getStartValue() {
        return this.params.value;
    }
    setCaret() {
        if ((0, browser_1._isBrowserSafari)()) {
            // If not safari, input is already focused.
            // For safari we need to focus only for this use case to avoid AG-3238,
            // but still ensure the input has focus.
            this.eEditor.getInputElement().focus({ preventScroll: true });
        }
    }
}
class NumberCellEditor extends simpleCellEditor_1.SimpleCellEditor {
    constructor() {
        super(new NumberCellEditorInput(() => this.getLocaleTextFunc()));
    }
}
exports.NumberCellEditor = NumberCellEditor;


/***/ }),

/***/ 5609:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PopupEditorWrapper = void 0;
const gridOptionsUtils_1 = __webpack_require__(7274);
const keyboard_1 = __webpack_require__(6466);
const popupComponent_1 = __webpack_require__(3598);
const PopupEditorElement = { tag: 'div', cls: 'ag-popup-editor', attrs: { tabindex: '-1' } };
class PopupEditorWrapper extends popupComponent_1.PopupComponent {
    constructor(params) {
        super(PopupEditorElement);
        this.params = params;
    }
    postConstruct() {
        (0, gridOptionsUtils_1._setDomData)(this.gos, this.getGui(), 'popupEditorWrapper', true);
        this.addKeyDownListener();
    }
    addKeyDownListener() {
        const eGui = this.getGui();
        const params = this.params;
        const listener = (event) => {
            if (!(0, keyboard_1._isUserSuppressingKeyboardEvent)(this.gos, event, params.node, params.column, true)) {
                params.onKeyDown(event);
            }
        };
        this.addManagedElementListeners(eGui, { keydown: listener });
    }
}
exports.PopupEditorWrapper = PopupEditorWrapper;


/***/ }),

/***/ 8774:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectCellEditor = void 0;
const keyCode_1 = __webpack_require__(9853);
const generic_1 = __webpack_require__(4422);
const logging_1 = __webpack_require__(7764);
const agAbstractCellEditor_1 = __webpack_require__(4872);
const agSelect_1 = __webpack_require__(159);
const component_1 = __webpack_require__(8020);
const SelectCellElement = {
    tag: 'div',
    cls: 'ag-cell-edit-wrapper',
    children: [
        {
            tag: 'ag-select',
            ref: 'eEditor',
            cls: 'ag-cell-editor',
        },
    ],
};
class SelectCellEditor extends agAbstractCellEditor_1.AgAbstractCellEditor {
    wireBeans(beans) {
        this.valueSvc = beans.valueSvc;
    }
    constructor() {
        super(SelectCellElement, [agSelect_1.AgSelectSelector]);
        this.eEditor = component_1.RefPlaceholder;
        this.startedByEnter = false;
    }
    initialiseEditor(params) {
        this.focusAfterAttached = params.cellStartedEdit;
        const { eEditor, valueSvc, gos } = this;
        const { values, value, eventKey } = params;
        if ((0, generic_1._missing)(values)) {
            (0, logging_1._warn)(58);
            return;
        }
        this.startedByEnter = eventKey != null ? eventKey === keyCode_1.KeyCode.ENTER : false;
        let hasValue = false;
        values.forEach((currentValue) => {
            const option = { value: currentValue };
            const valueFormatted = valueSvc.formatValue(params.column, null, currentValue);
            const valueFormattedExits = valueFormatted !== null && valueFormatted !== undefined;
            option.text = valueFormattedExits ? valueFormatted : currentValue;
            eEditor.addOption(option);
            hasValue = hasValue || value === currentValue;
        });
        if (hasValue) {
            eEditor.setValue(params.value, true);
        }
        else if (params.values.length) {
            eEditor.setValue(params.values[0], true);
        }
        const { valueListGap, valueListMaxWidth, valueListMaxHeight } = params;
        if (valueListGap != null) {
            eEditor.setPickerGap(valueListGap);
        }
        if (valueListMaxHeight != null) {
            eEditor.setPickerMaxHeight(valueListMaxHeight);
        }
        if (valueListMaxWidth != null) {
            eEditor.setPickerMaxWidth(valueListMaxWidth);
        }
        // we don't want to add this if full row editing, otherwise selecting will stop the
        // full row editing.
        if (gos.get('editType') !== 'fullRow') {
            this.addManagedListeners(this.eEditor, { selectedItem: () => params.stopEditing() });
        }
    }
    afterGuiAttached() {
        if (this.focusAfterAttached) {
            this.eEditor.getFocusableElement().focus();
        }
        if (this.startedByEnter) {
            setTimeout(() => {
                if (this.isAlive()) {
                    this.eEditor.showPicker();
                }
            });
        }
    }
    focusIn() {
        this.eEditor.getFocusableElement().focus();
    }
    getValue() {
        return this.eEditor.getValue();
    }
    isPopup() {
        return false;
    }
    getValidationElement() {
        return this.eEditor.getAriaElement();
    }
    getValidationErrors() {
        const { params } = this;
        const { values, getValidationErrors } = params;
        const value = this.getValue();
        let internalErrors = [];
        if (values && !values.includes(value)) {
            const translate = this.getLocaleTextFunc();
            internalErrors.push(translate('invalidSelectionValidation', 'Invalid selection.'));
        }
        else {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({
                value,
                internalErrors,
                cellEditorParams: params,
            });
        }
        return internalErrors;
    }
}
exports.SelectCellEditor = SelectCellEditor;


/***/ }),

/***/ 5336:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleCellEditor = void 0;
const keyCode_1 = __webpack_require__(9853);
const browser_1 = __webpack_require__(8667);
const agAbstractCellEditor_1 = __webpack_require__(4872);
const component_1 = __webpack_require__(8020);
class SimpleCellEditor extends agAbstractCellEditor_1.AgAbstractCellEditor {
    constructor(cellEditorInput) {
        super();
        this.cellEditorInput = cellEditorInput;
        this.eEditor = component_1.RefPlaceholder;
    }
    initialiseEditor(params) {
        const { cellEditorInput } = this;
        this.setTemplate({ tag: 'div', cls: 'ag-cell-edit-wrapper', children: [cellEditorInput.getTemplate()] }, cellEditorInput.getAgComponents());
        const { eEditor } = this;
        const { cellStartedEdit, eventKey, suppressPreventDefault } = params;
        // disable initial tooltips added to the input field
        // let the validation handle tooltips.
        eEditor.getInputElement().setAttribute('title', '');
        cellEditorInput.init(eEditor, params);
        let startValue;
        let shouldSetStartValue = true;
        // cellStartedEdit is only false if we are doing fullRow editing
        if (cellStartedEdit) {
            this.focusAfterAttached = true;
            if (eventKey === keyCode_1.KeyCode.BACKSPACE || eventKey === keyCode_1.KeyCode.DELETE) {
                startValue = '';
            }
            else if (eventKey && eventKey.length === 1) {
                if (suppressPreventDefault) {
                    shouldSetStartValue = false;
                }
                else {
                    startValue = eventKey;
                }
            }
            else {
                startValue = cellEditorInput.getStartValue();
                if (eventKey !== keyCode_1.KeyCode.F2) {
                    this.highlightAllOnFocus = true;
                }
            }
        }
        else {
            this.focusAfterAttached = false;
            startValue = cellEditorInput.getStartValue();
        }
        if (shouldSetStartValue && startValue != null) {
            eEditor.setStartValue(startValue);
        }
        this.addGuiEventListener('keydown', (event) => {
            const { key } = event;
            if (key === keyCode_1.KeyCode.PAGE_UP || key === keyCode_1.KeyCode.PAGE_DOWN) {
                event.preventDefault();
            }
        });
    }
    afterGuiAttached() {
        const translate = this.getLocaleTextFunc();
        const eInput = this.eEditor;
        eInput.setInputAriaLabel(translate('ariaInputEditor', 'Input Editor'));
        if (!this.focusAfterAttached) {
            return;
        }
        // Added for AG-3238. We can't remove this explicit focus() because Chrome requires an input
        // to be focused before setSelectionRange will work. But it triggers a bug in Safari where
        // explicitly focusing then blurring an empty field will cause the parent container to scroll.
        if (!(0, browser_1._isBrowserSafari)()) {
            eInput.getFocusableElement().focus();
        }
        const inputEl = eInput.getInputElement();
        if (this.highlightAllOnFocus) {
            inputEl.select();
        }
        else {
            this.cellEditorInput.setCaret?.();
        }
    }
    // gets called when tabbing through cells and in full row edit mode
    focusIn() {
        const { eEditor } = this;
        const focusEl = eEditor.getFocusableElement();
        const inputEl = eEditor.getInputElement();
        focusEl.focus();
        inputEl.select();
    }
    getValue() {
        return this.cellEditorInput.getValue();
    }
    isPopup() {
        return false;
    }
    getValidationElement() {
        return this.eEditor.getInputElement();
    }
    getValidationErrors() {
        return this.cellEditorInput.getValidationErrors();
    }
}
exports.SimpleCellEditor = SimpleCellEditor;


/***/ }),

/***/ 5457:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextCellEditor = void 0;
const generic_1 = __webpack_require__(4422);
const agInputTextField_1 = __webpack_require__(5946);
const simpleCellEditor_1 = __webpack_require__(5336);
const TextCellEditorElement = {
    tag: 'ag-input-text-field',
    ref: 'eEditor',
    cls: 'ag-cell-editor',
};
class TextCellEditorInput {
    constructor(getLocaleTextFunc) {
        this.getLocaleTextFunc = getLocaleTextFunc;
    }
    getTemplate() {
        return TextCellEditorElement;
    }
    getAgComponents() {
        return [agInputTextField_1.AgInputTextFieldSelector];
    }
    init(eEditor, params) {
        this.eEditor = eEditor;
        this.params = params;
        const maxLength = params.maxLength;
        if (maxLength != null) {
            eEditor.setMaxLength(maxLength);
        }
    }
    getValidationErrors() {
        const { params } = this;
        const { maxLength, getValidationErrors } = params;
        const value = this.getValue();
        const translate = this.getLocaleTextFunc();
        let internalErrors = [];
        if (maxLength != null && typeof value === 'string' && value.length > maxLength) {
            internalErrors.push(translate('maxLengthValidation', `Must be ${maxLength} characters or fewer.`, [String(maxLength)]));
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({ value, cellEditorParams: params, internalErrors });
        }
        return internalErrors;
    }
    getValue() {
        const { eEditor, params } = this;
        const value = eEditor.getValue();
        if (!(0, generic_1._exists)(value) && !(0, generic_1._exists)(params.value)) {
            return params.value;
        }
        return params.parseValue(value);
    }
    getStartValue() {
        const params = this.params;
        const formatValue = params.useFormatter || params.column.getColDef().refData;
        return formatValue ? params.formatValue(params.value) : params.value;
    }
    setCaret() {
        // when we started editing, we want the caret at the end, not the start.
        // this comes into play in two scenarios:
        //   a) when user hits F2
        //   b) when user hits a printable character
        const eInput = this.eEditor;
        const value = eInput.getValue();
        const len = ((0, generic_1._exists)(value) && value.length) || 0;
        if (len) {
            eInput.getInputElement().setSelectionRange(len, len);
        }
    }
}
class TextCellEditor extends simpleCellEditor_1.SimpleCellEditor {
    constructor() {
        super(new TextCellEditorInput(() => this.getLocaleTextFunc()));
    }
}
exports.TextCellEditor = TextCellEditor;


/***/ }),

/***/ 89:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getCurrentRedoSize = exports.getCurrentUndoSize = exports.validateEdit = exports.cancelEdits = exports.startEditingCell = exports.isEditing = exports.stopEditing = exports.getEditingCells = exports.redoCellEditing = exports.undoCellEditing = void 0;
const scrollApi_1 = __webpack_require__(1765);
const positionUtils_1 = __webpack_require__(6257);
const logging_1 = __webpack_require__(7764);
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(8994);
function undoCellEditing(beans) {
    beans.undoRedo?.undo('api');
}
exports.undoCellEditing = undoCellEditing;
function redoCellEditing(beans) {
    beans.undoRedo?.redo('api');
}
exports.redoCellEditing = redoCellEditing;
function getEditingCells(beans) {
    const edits = beans.editModelSvc?.getEditMap();
    const positions = [];
    edits?.forEach((editRow, rowNode) => {
        const { rowIndex, rowPinned } = rowNode;
        editRow.forEach(({ newValue, oldValue, state }, column) => {
            const diff = (0, editors_1._valuesDiffer)({ newValue, oldValue });
            if (newValue === editors_1.UNEDITED) {
                newValue = undefined;
            }
            const edit = {
                newValue,
                oldValue,
                state,
                column,
                colId: column.getColId(),
                colKey: column.getColId(),
                rowIndex: rowIndex,
                rowPinned,
            };
            const changed = state === 'changed' && diff;
            const editing = state === 'editing';
            if (editing) {
                positions.push(edit);
            }
            else if (changed) {
                positions.push(edit);
            }
        });
    });
    return positions;
}
exports.getEditingCells = getEditingCells;
function stopEditing(beans, cancel = false) {
    const { editSvc } = beans;
    if (editSvc?.isBatchEditing()) {
        if (cancel) {
            beans.editModelSvc?.getEditPositions().forEach((cellPosition) => {
                if (cellPosition.state === 'editing') {
                    editSvc.revertSingleCellEdit(cellPosition);
                }
            });
        }
        else {
            (0, editors_1._syncFromEditors)(beans);
        }
        (0, editors_1._destroyEditors)(beans);
    }
    else {
        editSvc?.stopEditing(undefined, { cancel, source: 'api' });
    }
}
exports.stopEditing = stopEditing;
function isEditing(beans, cellPosition) {
    const cellCtrl = (0, controllers_1._getCellCtrl)(beans, cellPosition);
    return beans.editSvc?.isEditing(cellCtrl) ?? false;
}
exports.isEditing = isEditing;
function startEditingCell(beans, params) {
    const { key, colKey, rowIndex, rowPinned } = params;
    const { editSvc, colModel } = beans;
    const column = colModel.getCol(colKey);
    if (!column) {
        (0, logging_1._warn)(12, { colKey });
        return;
    }
    const cellPosition = {
        rowIndex,
        rowPinned: rowPinned || null,
        column,
    };
    const rowNode = (0, positionUtils_1._getRowNode)(beans, cellPosition);
    if (!rowNode) {
        (0, logging_1._warn)(290, { rowIndex, rowPinned });
        return;
    }
    if (!column.isCellEditable(rowNode)) {
        return;
    }
    const notPinned = rowPinned == null;
    if (notPinned) {
        (0, scrollApi_1.ensureIndexVisible)(beans, rowIndex);
    }
    (0, scrollApi_1.ensureColumnVisible)(beans, colKey);
    if (!(0, positionUtils_1._getCellByPosition)(beans, cellPosition)) {
        return;
    }
    editSvc?.setEditingCells([
        {
            ...cellPosition,
            colId: column.getColId(),
            newValue: key,
            state: 'editing',
        },
    ], { update: true });
}
exports.startEditingCell = startEditingCell;
function cancelEdits({ editSvc }) {
    editSvc?.stopEditing(undefined, { cancel: true, source: editSvc?.isBatchEditing() ? 'ui' : 'api' });
}
exports.cancelEdits = cancelEdits;
function validateEdit(beans) {
    return beans.editSvc?.validateEdit() || null;
}
exports.validateEdit = validateEdit;
function getCurrentUndoSize(beans) {
    return beans.undoRedo?.getCurrentUndoStackSize() ?? 0;
}
exports.getCurrentUndoSize = getCurrentUndoSize;
function getCurrentRedoSize(beans) {
    return beans.undoRedo?.getCurrentRedoStackSize() ?? 0;
}
exports.getCurrentRedoSize = getCurrentRedoSize;


/***/ }),

/***/ 8544:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditRowValidationModel = exports.EditCellValidationModel = exports.EditModelService = void 0;
const beanStub_1 = __webpack_require__(8731);
const editors_1 = __webpack_require__(8994);
class EditModelService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'editModelSvc';
        this.edits = new Map();
        this.cellValidations = new EditCellValidationModel();
        this.rowValidations = new EditRowValidationModel();
        // during some operations, we want to always return false from `hasEdits`
        this.suspendEdits = false;
    }
    suspend(suspend) {
        this.suspendEdits = suspend;
    }
    removeEdits({ rowNode, column }) {
        if (!this.hasEdits({ rowNode }) || !rowNode) {
            return;
        }
        const editRow = this.getEditRow(rowNode);
        if (column) {
            editRow.delete(column);
        }
        else {
            editRow.clear();
        }
        if (editRow.size === 0) {
            this.edits.delete(rowNode);
        }
    }
    getEditRow(rowNode, params = {}) {
        if (this.suspendEdits) {
            return undefined;
        }
        if (this.edits.size === 0) {
            return undefined;
        }
        const edits = rowNode && this.edits.get(rowNode);
        if (edits) {
            return edits;
        }
        if (params.checkSiblings) {
            const pinnedSibling = rowNode.pinnedSibling;
            if (pinnedSibling) {
                return this.getEditRow(pinnedSibling);
            }
        }
        return undefined;
    }
    getEditRowDataValue(rowNode, { checkSiblings } = {}) {
        if (this.edits.size === 0) {
            return rowNode.data;
        }
        const editRow = this.getEditRow(rowNode);
        const pinnedSibling = rowNode.pinnedSibling;
        const siblingRow = checkSiblings && pinnedSibling && this.getEditRow(pinnedSibling);
        if (!editRow && !siblingRow) {
            return rowNode.data;
        }
        const data = Object.assign({}, rowNode.data);
        const applyEdits = (edits, data) => edits.forEach(({ newValue }, column) => {
            if (newValue !== editors_1.UNEDITED) {
                data[column.getColId()] = newValue;
            }
        });
        if (editRow) {
            applyEdits(editRow, data);
        }
        if (siblingRow) {
            applyEdits(siblingRow, data);
        }
        return data;
    }
    getEdit(position) {
        return this._getEdit(position);
    }
    _getEdit(position) {
        if (this.suspendEdits) {
            return undefined;
        }
        if (this.edits.size === 0) {
            return undefined;
        }
        return position.rowNode && position.column && this.getEditRow(position.rowNode)?.get(position.column);
    }
    getEditMap(copy = true) {
        if (this.suspendEdits || this.edits.size === 0) {
            return new Map();
        }
        if (!copy) {
            return this.edits;
        }
        const map = new Map();
        this.edits.forEach((editRow, rowNode) => map.set(rowNode, new Map(editRow)));
        return map;
    }
    setEditMap(newEdits) {
        this.edits.clear();
        newEdits.forEach((editRow, rowNode) => {
            const newRow = new Map();
            editRow.forEach((cellData, column) => 
            // Ensure we copy the cell data to avoid reference issues
            newRow.set(column, { ...cellData }));
            this.edits.set(rowNode, newRow);
        });
    }
    setEdit(position, edit) {
        (this.edits.size === 0 || !this.edits.has(position.rowNode)) && this.edits.set(position.rowNode, new Map());
        const currentEdit = Object.assign({}, this._getEdit(position));
        Object.keys(edit).forEach((key) => {
            const value = edit[key];
            // don't copy unset keys
            if (value !== undefined) {
                currentEdit[key] = value;
            }
        });
        this.getEditRow(position.rowNode).set(position.column, currentEdit);
    }
    clearEditValue(position) {
        const { rowNode, column } = position;
        if (rowNode) {
            if (column) {
                const edit = this._getEdit(position);
                if (edit) {
                    edit.newValue = edit.oldValue;
                    edit.state = 'changed';
                }
            }
            else {
                this.getEditRow(rowNode)?.forEach((cellData) => {
                    cellData.newValue = cellData.oldValue;
                    cellData.state = 'changed';
                });
            }
        }
    }
    setState(position, state) {
        if (!position.rowNode || !position.column) {
            return;
        }
        const { rowNode, column } = position;
        let editRow = this.getEditRow(rowNode);
        const edit = editRow?.get(column);
        if (edit) {
            edit.state = state;
        }
        else {
            if (!editRow) {
                editRow = new Map();
                this.edits.set(rowNode, editRow);
            }
            editRow.set(column, { newValue: undefined, oldValue: undefined, state });
        }
    }
    getState(position) {
        if (this.suspendEdits) {
            return undefined;
        }
        return this.getEdit(position)?.state;
    }
    getEditPositions(editMap) {
        if (this.suspendEdits || (editMap ?? this.edits).size === 0) {
            return [];
        }
        const positions = [];
        (editMap ?? this.edits).forEach((editRow, rowNode) => {
            for (const column of editRow.keys()) {
                positions.push({
                    rowNode,
                    column,
                    ...editRow.get(column),
                });
            }
        });
        return positions;
    }
    hasRowEdits(rowNode, params) {
        if (this.suspendEdits) {
            return false;
        }
        if (this.edits.size === 0) {
            return false;
        }
        const rowEdits = this.getEditRow(rowNode, params);
        return !!rowEdits;
    }
    hasEdits(position = {}, params = {}) {
        if (this.suspendEdits) {
            return false;
        }
        if (this.edits.size === 0) {
            return false;
        }
        const { rowNode, column } = position;
        const { withOpenEditor } = params;
        if (rowNode) {
            const rowEdits = this.getEditRow(rowNode, params);
            if (!rowEdits) {
                return false;
            }
            if (column) {
                if (withOpenEditor) {
                    return this.getEdit(position)?.state === 'editing';
                }
                return rowEdits.has(column) ?? false;
            }
            if (rowEdits.size !== 0) {
                if (withOpenEditor) {
                    return Array.from(rowEdits.values()).some(({ state }) => state === 'editing');
                }
                return true;
            }
            return false;
        }
        if (withOpenEditor) {
            return this.getEditPositions().some(({ state }) => state === 'editing');
        }
        return this.edits.size > 0;
    }
    start(position) {
        const map = this.getEditRow(position.rowNode) ?? new Map();
        const { rowNode, column } = position;
        if (column && !map.has(column)) {
            map.set(column, {
                newValue: editors_1.UNEDITED,
                oldValue: this.beans.valueSvc.getValue(column, rowNode, true, 'api'),
                state: 'editing',
            });
        }
        this.edits.set(rowNode, map);
    }
    stop(position) {
        if (!this.hasEdits(position)) {
            return;
        }
        if (position) {
            this.removeEdits(position);
        }
        else {
            this.clear();
        }
        return;
    }
    clear() {
        for (const pendingRowEdits of this.edits.values()) {
            pendingRowEdits.clear();
        }
        this.edits.clear();
    }
    getCellValidationModel() {
        return this.cellValidations;
    }
    getRowValidationModel() {
        return this.rowValidations;
    }
    setCellValidationModel(model) {
        this.cellValidations = model;
    }
    setRowValidationModel(model) {
        this.rowValidations = model;
    }
    destroy() {
        super.destroy();
        this.clear();
    }
}
exports.EditModelService = EditModelService;
class EditCellValidationModel {
    constructor() {
        this.cellValidations = new Map();
    }
    getCellValidation(position) {
        const { rowNode, column } = position || {};
        return this.cellValidations?.get(rowNode)?.get(column);
    }
    hasCellValidation(position) {
        if (!position || !position.rowNode || !position.column) {
            return this.cellValidations.size > 0;
        }
        return !!this.getCellValidation(position);
    }
    setCellValidation(position, validation) {
        const { rowNode, column } = position;
        if (!this.cellValidations.has(rowNode)) {
            this.cellValidations.set(rowNode, new Map());
        }
        this.cellValidations.get(rowNode).set(column, validation);
    }
    clearCellValidation(position) {
        const { rowNode, column } = position;
        this.cellValidations.get(rowNode)?.delete(column);
    }
    setCellValidationMap(validationMap) {
        this.cellValidations = validationMap;
    }
    getCellValidationMap() {
        return this.cellValidations;
    }
    clearCellValidationMap() {
        this.cellValidations.clear();
    }
}
exports.EditCellValidationModel = EditCellValidationModel;
class EditRowValidationModel {
    constructor() {
        this.rowValidations = new Map();
    }
    getRowValidation(position) {
        const { rowNode } = position || {};
        return this.rowValidations.get(rowNode);
    }
    hasRowValidation(position) {
        if (!position || !position.rowNode) {
            return this.rowValidations.size > 0;
        }
        return !!this.getRowValidation(position);
    }
    setRowValidation({ rowNode }, rowValidation) {
        this.rowValidations.set(rowNode, rowValidation);
    }
    clearRowValidation({ rowNode }) {
        this.rowValidations.delete(rowNode);
    }
    setRowValidationMap(validationMap) {
        this.rowValidations = validationMap;
    }
    getRowValidationMap() {
        return this.rowValidations;
    }
    clearRowValidationMap() {
        this.rowValidations.clear();
    }
}
exports.EditRowValidationModel = EditRowValidationModel;


/***/ }),

/***/ 4652:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CustomEditorModule = exports.LargeTextEditorModule = exports.SelectEditorModule = exports.CheckboxEditorModule = exports.DateEditorModule = exports.NumberEditorModule = exports.TextEditorModule = exports.UndoRedoEditModule = exports.EditCoreModule = void 0;
const tooltipModule_1 = __webpack_require__(4658);
const undoRedoService_1 = __webpack_require__(7113);
const version_1 = __webpack_require__(7205);
const popupModule_1 = __webpack_require__(3137);
const cell_editing_css_GENERATED_1 = __webpack_require__(6564);
const checkboxCellEditor_1 = __webpack_require__(227);
const dateCellEditor_1 = __webpack_require__(5314);
const dateStringCellEditor_1 = __webpack_require__(2059);
const largeTextCellEditor_1 = __webpack_require__(4578);
const numberCellEditor_1 = __webpack_require__(4371);
const selectCellEditor_1 = __webpack_require__(8774);
const textCellEditor_1 = __webpack_require__(5457);
const editApi_1 = __webpack_require__(89);
const editModelService_1 = __webpack_require__(8544);
const editService_1 = __webpack_require__(1277);
const fullRowEditStrategy_1 = __webpack_require__(104);
const singleCellEditStrategy_1 = __webpack_require__(149);
const editors_1 = __webpack_require__(8994);
/**
 * @internal
 */
exports.EditCoreModule = {
    moduleName: 'EditCore',
    version: version_1.VERSION,
    beans: [editModelService_1.EditModelService, editService_1.EditService],
    apiFunctions: {
        getEditingCells: editApi_1.getEditingCells,
        getCellEditorInstances: editors_1.getCellEditorInstances,
        startEditingCell: editApi_1.startEditingCell,
        stopEditing: editApi_1.stopEditing,
        isEditing: editApi_1.isEditing,
        validateEdit: editApi_1.validateEdit,
    },
    dynamicBeans: {
        singleCell: singleCellEditStrategy_1.SingleCellEditStrategy,
        fullRow: fullRowEditStrategy_1.FullRowEditStrategy,
    },
    dependsOn: [popupModule_1.PopupModule, tooltipModule_1.TooltipModule],
    css: [cell_editing_css_GENERATED_1.cellEditingCSS],
};
/**
 * @feature Editing -> Undo / Redo Edits
 */
exports.UndoRedoEditModule = {
    moduleName: 'UndoRedoEdit',
    version: version_1.VERSION,
    beans: [undoRedoService_1.UndoRedoService],
    apiFunctions: {
        undoCellEditing: editApi_1.undoCellEditing,
        redoCellEditing: editApi_1.redoCellEditing,
        getCurrentUndoSize: editApi_1.getCurrentUndoSize,
        getCurrentRedoSize: editApi_1.getCurrentRedoSize,
    },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Text Editor
 */
exports.TextEditorModule = {
    moduleName: 'TextEditor',
    version: version_1.VERSION,
    userComponents: { agCellEditor: textCellEditor_1.TextCellEditor, agTextCellEditor: textCellEditor_1.TextCellEditor },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Number Editor
 */
exports.NumberEditorModule = {
    moduleName: 'NumberEditor',
    version: version_1.VERSION,
    userComponents: {
        agNumberCellEditor: {
            classImp: numberCellEditor_1.NumberCellEditor,
        },
    },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Date Editor
 */
exports.DateEditorModule = {
    moduleName: 'DateEditor',
    version: version_1.VERSION,
    userComponents: {
        agDateCellEditor: dateCellEditor_1.DateCellEditor,
        agDateStringCellEditor: dateStringCellEditor_1.DateStringCellEditor,
    },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Checkbox Editor
 */
exports.CheckboxEditorModule = {
    moduleName: 'CheckboxEditor',
    version: version_1.VERSION,
    userComponents: {
        agCheckboxCellEditor: checkboxCellEditor_1.CheckboxCellEditor,
    },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Select Editor
 */
exports.SelectEditorModule = {
    moduleName: 'SelectEditor',
    version: version_1.VERSION,
    userComponents: { agSelectCellEditor: selectCellEditor_1.SelectCellEditor },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Large Text Editor
 */
exports.LargeTextEditorModule = {
    moduleName: 'LargeTextEditor',
    version: version_1.VERSION,
    userComponents: { agLargeTextCellEditor: largeTextCellEditor_1.LargeTextCellEditor },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing
 */
exports.CustomEditorModule = {
    moduleName: 'CustomEditor',
    version: version_1.VERSION,
    dependsOn: [exports.EditCoreModule],
};


/***/ }),

/***/ 1277:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditService = void 0;
const keyCode_1 = __webpack_require__(9853);
const beanStub_1 = __webpack_require__(8731);
const positionUtils_1 = __webpack_require__(6257);
const gridOptionsUtils_1 = __webpack_require__(7274);
const cellCtrl_1 = __webpack_require__(814);
const popupEditorWrapper_1 = __webpack_require__(5609);
const cellEditStyleFeature_1 = __webpack_require__(6904);
const rowEditStyleFeature_1 = __webpack_require__(3536);
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(8994);
const refresh_1 = __webpack_require__(1539);
// these are event sources for setDataValue that will not cause the editors to close
const KEEP_EDITOR_SOURCES = new Set(['undo', 'redo']);
// stop editing sources that we treat as UI-originated so we follow standard processing.
const SOURCE_TRANSFORM = {
    paste: 'ui',
    rangeSvc: 'ui',
    fillHandle: 'api',
    cellClear: 'api',
};
const SOURCE_TRANSFORM_KEYS = new Set(Object.keys(SOURCE_TRANSFORM));
const CANCEL_PARAMS = { cancel: true, source: 'api' };
const COMMIT_PARAMS = { cancel: false, source: 'api' };
const CHECK_SIBLING = { checkSiblings: true };
const FORCE_REFRESH = { force: true, suppressFlash: true };
class EditService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'editSvc';
        this.batch = false;
    }
    postConstruct() {
        const { beans } = this;
        this.model = beans.editModelSvc;
        this.valueSvc = beans.valueSvc;
        this.rangeSvc = beans.rangeSvc;
        this.addManagedPropertyListener('editType', ({ currentValue }) => {
            this.stopEditing(undefined, CANCEL_PARAMS);
            // will re-create if different
            this.createStrategy(currentValue);
        });
        const handler = (0, refresh_1._refreshEditCells)(beans);
        const stopInvalidEdits = () => {
            const hasCellValidation = this.model.getCellValidationModel().getCellValidationMap().size > 0;
            const hasRowValidation = this.model.getRowValidationModel().getRowValidationMap().size > 0;
            if (hasCellValidation || hasRowValidation) {
                this.stopEditing(undefined, CANCEL_PARAMS);
            }
            else {
                if (this.isEditing()) {
                    if (this.isBatchEditing()) {
                        (0, editors_1._destroyEditors)(beans, this.model.getEditPositions());
                    }
                    else {
                        this.stopEditing(undefined, COMMIT_PARAMS);
                    }
                }
            }
            return false;
        };
        this.addManagedEventListeners({
            columnPinned: handler,
            columnVisible: handler,
            columnRowGroupChanged: handler,
            rowGroupOpened: handler,
            pinnedRowsChanged: handler,
            displayedRowsChanged: handler,
            sortChanged: stopInvalidEdits,
            filterChanged: stopInvalidEdits,
            cellFocused: this.onCellFocused.bind(this),
        });
    }
    isBatchEditing() {
        return this.batch;
    }
    setBatchEditing(enabled) {
        if (enabled) {
            this.batch = true;
            this.stopEditing(undefined, CANCEL_PARAMS);
        }
        else {
            this.stopEditing(undefined, CANCEL_PARAMS);
            this.batch = false;
        }
    }
    createStrategy(editType) {
        const { beans, gos, strategy } = this;
        const name = editType ?? gos.get('editType') ?? 'singleCell';
        if (strategy) {
            if (strategy.beanName === name) {
                return strategy;
            }
            this.destroyStrategy();
        }
        return (this.strategy = this.createOptionalManagedBean(beans.registry.createDynamicBean(name, true)));
    }
    destroyStrategy() {
        if (!this.strategy) {
            return;
        }
        this.strategy.destroy();
        this.strategy = this.destroyBean(this.strategy);
    }
    shouldStartEditing(position, event, cellStartedEdit, source = 'ui') {
        this.strategy ?? (this.strategy = this.createStrategy());
        return this.strategy?.shouldStart(position, event, cellStartedEdit, source) ?? null;
    }
    shouldStopEditing(position, event, source = 'ui') {
        return this.strategy?.shouldStop(position, event, source) ?? null;
    }
    shouldCancelEditing(position, event, source = 'ui') {
        return this.strategy?.shouldCancel(position, event, source) ?? null;
    }
    validateEdit() {
        return (0, editors_1._validateEdit)(this.beans);
    }
    isEditing(position, params) {
        return this.model.hasEdits(position, params ?? CHECK_SIBLING);
    }
    isRowEditing(rowNode, params) {
        return (rowNode && this.model.hasRowEdits(rowNode, params)) ?? false;
    }
    /** @returns whether to prevent default on event */
    startEditing(position, params) {
        const { startedEdit = true, event = null, source = 'ui', ignoreEventKey = false } = params;
        this.strategy ?? (this.strategy = this.createStrategy());
        if (!this.isCellEditable(position, 'api')) {
            return;
        }
        // because of async in React, the cellComp may not be set yet, if no cellComp then we are
        // yet to initialise the cell, so we re-schedule this operation for when celLComp is attached
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, position);
        if (cellCtrl && !cellCtrl.comp) {
            cellCtrl.onCompAttachedFuncs.push(() => this.startEditing(position, params));
            return;
        }
        const res = this.shouldStartEditing?.(position, event, startedEdit, source);
        if (res === false && source !== 'api') {
            this.isEditing(position) && this.stopEditing();
            return;
        }
        if (!this.batch && this.shouldStopEditing(position, undefined, source)) {
            this.stopEditing(undefined, { source });
        }
        if (res && this.isBatchEditing()) {
            this.dispatchBatchEvent('batchEditingStarted', new Map());
        }
        this.strategy.start(position, event, source, ignoreEventKey);
        return;
    }
    stopEditing(position, params) {
        const { event, cancel, source = 'ui', suppressNavigateAfterEdit } = params || {};
        const { beans, model } = this;
        if (SOURCE_TRANSFORM_KEYS.has(source)) {
            if (this.isBatchEditing()) {
                // if we are in batch editing, we do not stop editing on paste
                this.bulkRefresh(position);
                return false;
            }
            return this.stopEditing(position, { ...params, source: SOURCE_TRANSFORM[source] });
        }
        if (!this.isEditing() || !this.strategy) {
            return false;
        }
        const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
        if (cellCtrl) {
            cellCtrl.onEditorAttachedFuncs = [];
        }
        let edits = model.getEditMap(true);
        let res = false;
        const willStop = !cancel && !!this.shouldStopEditing(position, event, source);
        const willCancel = cancel && !!this.shouldCancelEditing(position, event, source);
        if (willStop || willCancel) {
            (0, editors_1._syncFromEditors)(beans, { event });
            const freshEdits = model.getEditMap();
            this.processEdits(freshEdits, cancel);
            this.strategy?.stop(cancel, event);
            this.bulkRefresh(undefined, edits);
            edits = freshEdits;
            res || (res = willStop);
        }
        else if (event instanceof KeyboardEvent &&
            this.batch &&
            this.strategy?.midBatchInputsAllowed(position) &&
            this.isEditing(position, { withOpenEditor: true })) {
            const key = event.key;
            const isEnter = key === keyCode_1.KeyCode.ENTER;
            const isEscape = key === keyCode_1.KeyCode.ESCAPE;
            if (isEnter || isEscape) {
                if (isEnter) {
                    (0, editors_1._syncFromEditors)(beans, { event });
                }
                else if (isEscape) {
                    // only if ESC is pressed while in the editor for this cell
                    this.revertSingleCellEdit(cellCtrl, false);
                }
                if (this.isBatchEditing()) {
                    this.strategy?.cleanupEditors();
                }
                else {
                    (0, editors_1._destroyEditors)(beans, model.getEditPositions(), { event });
                }
                event.preventDefault();
                this.bulkRefresh(position, edits, { suppressFlash: true });
                edits = model.getEditMap();
            }
        }
        else {
            (0, editors_1._syncFromEditors)(beans, { event });
            edits = model.getEditMap();
        }
        if (res && position) {
            this.model.removeEdits(position);
        }
        if (!suppressNavigateAfterEdit && cellCtrl) {
            this.navigateAfterEdit(event instanceof KeyboardEvent && event.shiftKey, cellCtrl.cellPosition);
        }
        (0, editors_1._purgeUnchangedEdits)(beans);
        if (!this.model.hasEdits()) {
            this.model.getCellValidationModel().clearCellValidationMap();
            this.model.getRowValidationModel().clearRowValidationMap();
        }
        this.bulkRefresh();
        if (willCancel) {
            // if we cancelled the edit, we need to refresh the rows to remove the pending value and editing styles
            this.beans.rowRenderer.refreshRows({ rowNodes: Array.from(edits.keys()) });
        }
        if (this.isBatchEditing()) {
            this.beans.rowRenderer.refreshRows({ suppressFlash: true, force: true });
            if (res && willStop) {
                this.dispatchBatchEvent('batchEditingStopped', edits);
            }
        }
        return res;
    }
    navigateAfterEdit(shiftKey, cellPosition) {
        const navAfterEdit = this.gos.get('enterNavigatesVerticallyAfterEdit');
        if (navAfterEdit) {
            const key = shiftKey ? keyCode_1.KeyCode.UP : keyCode_1.KeyCode.DOWN;
            this.beans.navigation?.navigateToNextCell(null, key, cellPosition, false);
        }
    }
    processEdits(edits, cancel = false) {
        const rowNodes = Array.from(edits.keys());
        const { beans } = this;
        const hasValidationErrors = this.model.getCellValidationModel().getCellValidationMap().size > 0 ||
            this.model.getRowValidationModel().getRowValidationMap().size > 0;
        const editsToDelete = [];
        for (const rowNode of rowNodes) {
            const editRow = edits.get(rowNode);
            for (const column of editRow.keys()) {
                const editValue = editRow.get(column);
                const position = { rowNode, column };
                const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
                const valueChanged = (0, editors_1._valuesDiffer)(editValue);
                const isCancelAfterEnd = cellCtrl?.comp?.getCellEditor()?.isCancelAfterEnd?.();
                if (!cancel && !isCancelAfterEnd && valueChanged && !hasValidationErrors) {
                    const success = this.setNodeDataValue(rowNode, column, editValue.newValue);
                    if (!success) {
                        editsToDelete.push(position);
                    }
                }
                cellCtrl?.refreshCell(FORCE_REFRESH);
            }
        }
        editsToDelete.forEach((position) => {
            this.model.clearEditValue(position);
        });
    }
    setNodeDataValue(rowNode, column, newValue, refreshCell) {
        const { beans } = this;
        const cellCtrl = (0, controllers_1._getCellCtrl)(beans, { rowNode, column });
        // we suppressRefreshCell because the call to rowNode.setDataValue() results in change detection
        // getting triggered, which results in all cells getting refreshed. we do not want this refresh
        // to happen on this call as we want to call it explicitly below. otherwise refresh gets called twice.
        // if we only did this refresh (and not the one below) then the cell would flash and not be forced.
        if (cellCtrl) {
            cellCtrl.suppressRefreshCell = true;
        }
        const success = rowNode.setDataValue(column, newValue, 'commit');
        if (cellCtrl) {
            cellCtrl.suppressRefreshCell = false;
        }
        if (refreshCell) {
            cellCtrl?.refreshCell(FORCE_REFRESH);
        }
        return success;
    }
    setEditMap(edits, params) {
        this.strategy ?? (this.strategy = this.createStrategy());
        this.strategy?.setEditMap(edits, params);
        this.bulkRefresh();
        // force refresh of all row cells as custom renderers may depend on multiple cell values
        this.beans.rowRenderer.refreshCells(FORCE_REFRESH);
    }
    dispatchEditValuesChanged({ rowNode, column }, edit = {}) {
        if (!rowNode || !column || !edit) {
            return;
        }
        const { newValue, oldValue } = edit;
        const { rowIndex, rowPinned, data } = rowNode;
        this.beans.eventSvc.dispatchEvent({
            type: 'cellEditValuesChanged',
            node: rowNode,
            rowIndex,
            rowPinned,
            column,
            source: 'api',
            data,
            newValue,
            oldValue,
            value: newValue,
            colDef: column.getColDef(),
        });
    }
    bulkRefresh(position = {}, editMap, params = {}) {
        const { beans, gos } = this;
        const { editModelSvc, rowModel } = beans;
        if ((0, gridOptionsUtils_1._isClientSideRowModel)(gos, rowModel)) {
            if (position.rowNode && position.column) {
                this.refCell(position, this.model.getEdit(position), params);
            }
            else if (editMap) {
                editModelSvc?.getEditMap(false)?.forEach((editRow, rowNode) => {
                    for (const column of editRow.keys()) {
                        this.refCell({ rowNode, column }, editRow.get(column), params);
                    }
                });
            }
        }
    }
    refCell({ rowNode, column }, edit, params = {}) {
        const { beans, gos } = this;
        const updatedNodes = new Set([rowNode]);
        const refreshNodes = new Set();
        const pinnedSibling = rowNode.pinnedSibling;
        if (pinnedSibling) {
            updatedNodes.add(pinnedSibling);
        }
        const sibling = rowNode.sibling;
        if (sibling) {
            refreshNodes.add(sibling);
        }
        let parent = rowNode.parent;
        while (parent) {
            if (parent.sibling?.footer && gos.get('groupTotalRow')) {
                refreshNodes.add(parent.sibling);
            }
            else if (!parent.parent && parent.sibling && gos.get('grandTotalRow')) {
                refreshNodes.add(parent.sibling);
            }
            else {
                refreshNodes.add(parent);
            }
            parent = parent.parent;
        }
        updatedNodes.forEach((node) => this.dispatchEditValuesChanged({ rowNode: node, column }, edit));
        updatedNodes.forEach((node) => (0, controllers_1._getCellCtrl)(beans, { rowNode: node, column })?.refreshCell(params));
        refreshNodes.forEach((node) => (0, controllers_1._getCellCtrl)(beans, { rowNode: node, column })?.refreshCell(params));
    }
    stopAllEditing(cancel = false, source = 'ui') {
        if (this.isEditing()) {
            this.stopEditing(undefined, { cancel, source });
        }
    }
    isCellEditable(position, source = 'ui') {
        const { rowNode } = position;
        if (rowNode.group) {
            // This is a group - it could be a tree group or a grouping group...
            if (this.gos.get('treeData')) {
                // tree - allow editing of groups with data by default.
                // Allow editing filler nodes (node without data) only if enableGroupEdit is true.
                if (!rowNode.data && !this.gos.get('enableGroupEdit')) {
                    return false;
                }
            }
            else {
                // grouping - allow editing of groups if the user has enableGroupEdit option enabled
                if (!this.gos.get('enableGroupEdit')) {
                    return false;
                }
            }
        }
        this.strategy ?? (this.strategy = this.createStrategy());
        return this.strategy?.isCellEditable(position, source) ?? false;
    }
    cellEditingInvalidCommitBlocks() {
        return this.gos.get('invalidEditValueMode') === 'block';
    }
    checkNavWithValidation(position, event) {
        if (this.hasValidationErrors(position)) {
            const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, position);
            if (this.cellEditingInvalidCommitBlocks()) {
                event?.preventDefault?.();
                !cellCtrl?.hasBrowserFocus() && cellCtrl?.focusCell();
                cellCtrl?.comp?.getCellEditor()?.focusIn?.();
                return 'block-stop';
            }
            cellCtrl && this.revertSingleCellEdit(cellCtrl);
            return 'revert-continue';
        }
        return 'continue';
    }
    revertSingleCellEdit(cellPosition, focus = false) {
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, cellPosition);
        if (!cellCtrl?.comp?.getCellEditor()) {
            // don't cancel/revert if there is no editor
            return;
        }
        this.model.clearEditValue(cellPosition);
        (0, editors_1._destroyEditors)(this.beans, [cellPosition], { silent: true });
        (0, editors_1._setupEditor)(this.beans, cellPosition, { silent: true });
        (0, editors_1._populateModelValidationErrors)(this.beans);
        cellCtrl?.refreshCell(FORCE_REFRESH);
        // refresh the styles directly rather than through refreshRow as that causes the group cell renderer to
        // be recreated and would discard future mouse click events
        cellCtrl.rowCtrl.rowEditStyleFeature?.applyRowStyles();
        if (!focus) {
            return;
        }
        cellCtrl?.focusCell();
        cellCtrl?.comp?.getCellEditor()?.focusIn?.();
    }
    hasValidationErrors(position) {
        (0, editors_1._populateModelValidationErrors)(this.beans);
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, position);
        if (cellCtrl) {
            cellCtrl.refreshCell(FORCE_REFRESH);
            // refresh the styles directly rather than through refreshRow as that causes the group cell renderer to
            // be recreated and would discard future mouse click events
            cellCtrl.rowCtrl.rowEditStyleFeature?.applyRowStyles();
        }
        let invalid = false;
        if (position?.rowNode) {
            invalid || (invalid = this.model.getRowValidationModel().hasRowValidation({ rowNode: position.rowNode }));
            if (position.column) {
                invalid || (invalid = this.model
                    .getCellValidationModel()
                    .hasCellValidation({ rowNode: position.rowNode, column: position.column }));
            }
        }
        else {
            invalid || (invalid = this.model.getCellValidationModel().getCellValidationMap().size > 0);
            invalid || (invalid = this.model.getRowValidationModel().getRowValidationMap().size > 0);
        }
        return invalid;
    }
    moveToNextCell(prev, backwards, event, source = 'ui') {
        let res;
        if (prev instanceof cellCtrl_1.CellCtrl && this.isEditing()) {
            // if we are editing, we know it's not a Full Width Row (RowComp)
            res = this.strategy?.moveToNextEditingCell(prev, backwards, event, source);
        }
        if (res === null) {
            return res;
        }
        // if a cell wasn't found, it's possible that focus was moved to the header
        res = res || !!this.beans.focusSvc.focusedHeader;
        if (res === false) {
            // not a header and not the table
            this.stopEditing();
        }
        return res;
    }
    getCellDataValue({ rowNode, column }) {
        if (!rowNode || !column) {
            return undefined;
        }
        let edit = this.model.getEdit({ rowNode, column });
        const pinnedSibling = rowNode.pinnedSibling;
        if (pinnedSibling) {
            const siblingEdit = this.model.getEdit({ rowNode: pinnedSibling, column });
            if (siblingEdit) {
                edit = siblingEdit;
            }
        }
        const newValue = edit?.newValue;
        return newValue === editors_1.UNEDITED || !edit
            ? this.valueSvc.getValue(column, rowNode, true, 'api')
            : newValue;
    }
    getRowDataValue(rowNode, params) {
        return this.model.getEditRowDataValue(rowNode, params);
    }
    addStopEditingWhenGridLosesFocus(viewports) {
        // TODO: find a better place for this
        (0, controllers_1._addStopEditingWhenGridLosesFocus)(this, this.beans, viewports);
    }
    createPopupEditorWrapper(params) {
        // TODO: find a better place for this
        return new popupEditorWrapper_1.PopupEditorWrapper(params);
    }
    setDataValue(position, newValue, eventSource) {
        if ((!this.isEditing() || eventSource === 'commit') &&
            eventSource !== 'paste' &&
            eventSource !== 'rangeSvc' &&
            eventSource !== 'renderer' &&
            eventSource !== 'cellClear') {
            return;
        }
        const { beans } = this;
        this.strategy ?? (this.strategy = this.createStrategy());
        const source = this.isBatchEditing() ? 'ui' : 'api';
        if (!eventSource || KEEP_EDITOR_SOURCES.has(eventSource)) {
            // editApi or undoRedoApi apply change without involving the editor
            (0, editors_1._syncFromEditor)(beans, position, newValue, eventSource);
            // a truthy return here indicates the operation succeeded, and if invoked from rowNode.setDataValue, will not result in a cell value change event
            return this.setNodeDataValue(position.rowNode, position.column, newValue, false);
        }
        const existing = this.model.getEdit(position);
        if (existing) {
            if (existing.newValue === newValue) {
                return false;
            }
            if (existing.oldValue !== newValue) {
                (0, editors_1._syncFromEditor)(beans, position, newValue, eventSource);
                this.stopEditing(position, { source });
                return true;
            }
            if (existing.oldValue === newValue) {
                beans.editModelSvc?.removeEdits(position);
                this.dispatchEditValuesChanged(position, {
                    newValue,
                    oldValue: existing.oldValue,
                });
                return true;
            }
        }
        (0, editors_1._syncFromEditor)(beans, position, newValue, eventSource);
        this.stopEditing(position, { source });
        return true;
    }
    handleColDefChanged(cellCtrl) {
        (0, editors_1._refreshEditorOnColDefChanged)(this.beans, cellCtrl);
    }
    destroy() {
        this.model.clear();
        this.destroyStrategy();
        super.destroy();
    }
    prepDetailsDuringBatch(position, params) {
        if (!this.batch) {
            return;
        }
        const hasEdits = this.model.hasRowEdits(position.rowNode, CHECK_SIBLING);
        if (!hasEdits) {
            return;
        }
        const { rowNode, column } = position;
        const { compDetails, valueToDisplay } = params;
        if (compDetails) {
            const { params } = compDetails;
            params.data = this.model.getEditRowDataValue(rowNode, CHECK_SIBLING);
            return { compDetails };
        }
        const editRow = this.model.getEditRow(position.rowNode, CHECK_SIBLING);
        if (valueToDisplay !== undefined && editRow?.has(column)) {
            return { valueToDisplay: this.valueSvc.getValue(column, rowNode) };
        }
    }
    cleanupEditors() {
        this.strategy?.cleanupEditors();
    }
    dispatchCellEvent(position, event, type, payload) {
        this.strategy?.dispatchCellEvent(position, event, type, payload);
    }
    dispatchRowEvent(position, type) {
        this.strategy?.dispatchRowEvent(position, type);
    }
    dispatchBatchEvent(type, edits) {
        this.eventSvc.dispatchEvent(this.createBatchEditEvent(type, edits));
    }
    createBatchEditEvent(type, edits) {
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            type,
            ...(type === 'batchEditingStopped'
                ? {
                    changes: this.model.getEditPositions(edits).map((edit) => {
                        return {
                            ...edit,
                            rowIndex: edit.rowNode.rowIndex,
                            rowPinned: edit.rowNode.rowPinned,
                            columnId: edit.column.getColId(),
                        };
                    }),
                }
                : {}),
        });
    }
    applyBulkEdit({ rowNode, column }, ranges) {
        if (!ranges || ranges.length === 0) {
            return;
        }
        const { beans, rangeSvc, valueSvc } = this;
        (0, editors_1._syncFromEditors)(beans);
        const edits = this.model.getEditMap(true);
        const editValue = edits.get(rowNode)?.get(column)?.newValue;
        ranges.forEach((range) => {
            rangeSvc?.forEachRowInRange(range, (position) => {
                const rowNode = (0, positionUtils_1._getRowNode)(beans, position);
                if (rowNode === undefined) {
                    return;
                }
                const editRow = edits.get(rowNode) ?? new Map();
                for (const column of range.columns) {
                    if (!column) {
                        continue;
                    }
                    if (this.isCellEditable({ rowNode, column }, 'api')) {
                        const oldValue = valueSvc.getValue(column, rowNode, true, 'api');
                        let newValue = valueSvc.parseValue(column, rowNode ?? null, editValue, oldValue);
                        if (Number.isNaN(newValue)) {
                            // non-number was bulk edited into a number column
                            newValue = null;
                        }
                        editRow.set(column, {
                            newValue,
                            oldValue,
                            state: 'changed',
                        });
                    }
                }
                if (editRow.size > 0) {
                    edits.set(rowNode, editRow);
                }
            });
            this.setEditMap(edits);
            if (this.batch) {
                this.cleanupEditors();
                (0, editors_1._purgeUnchangedEdits)(beans);
                // force refresh of all row cells as custom renderers may depend on multiple cell values
                this.bulkRefresh();
                return;
            }
            this.stopEditing(undefined, { source: 'api' });
        });
        this.bulkRefresh();
        // focus the first cell in the range
        const cellCtrl = (0, controllers_1._getCellCtrl)(beans, { rowNode, column });
        if (cellCtrl) {
            cellCtrl.focusCell(true);
        }
    }
    createCellStyleFeature(cellCtrl, beans) {
        return new cellEditStyleFeature_1.CellEditStyleFeature(cellCtrl, beans);
    }
    createRowStyleFeature(rowCtrl, beans) {
        return new rowEditStyleFeature_1.RowEditStyleFeature(rowCtrl, beans);
    }
    setEditingCells(cells, params) {
        const { beans } = this;
        const { colModel, valueSvc } = beans;
        const edits = new Map();
        cells.forEach(({ colId, column, colKey, rowIndex, rowPinned, newValue, state }) => {
            const col = colId ? colModel.getCol(colId) : colKey ? colModel.getCol(colKey) : column;
            if (!col) {
                return;
            }
            const rowNode = (0, positionUtils_1._getRowNode)(beans, { rowIndex, rowPinned });
            if (!rowNode) {
                return;
            }
            const oldValue = valueSvc.getValue(col, rowNode, true, 'api');
            if (!(0, editors_1._valuesDiffer)({ newValue, oldValue }) && state !== 'editing') {
                // If the new value is the same as the old value, we don't need to update
                return;
            }
            let editRow = edits.get(rowNode);
            if (!editRow) {
                editRow = new Map();
                edits.set(rowNode, editRow);
            }
            // translate undefined to unedited, don't translate null as that means cell was cleared
            if (newValue === undefined) {
                newValue = editors_1.UNEDITED;
            }
            editRow.set(col, { newValue, oldValue, state: state ?? 'changed' });
        });
        this.setEditMap(edits, params);
    }
    onCellFocused(event) {
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, event);
        if (!cellCtrl || !this.isEditing(cellCtrl, CHECK_SIBLING)) {
            return;
        }
        const edit = this.model.getEdit(cellCtrl);
        if (!edit || !(0, editors_1._valuesDiffer)(edit)) {
            return;
        }
        const translate = this.getLocaleTextFunc();
        const label = translate('ariaPendingChange', 'Pending Change');
        this.beans.ariaAnnounce?.announceValue(label, 'pendingChange');
    }
    allowedFocusTargetOnValidation(cellPosition) {
        return (0, controllers_1._getCellCtrl)(this.beans, cellPosition);
    }
}
exports.EditService = EditService;


/***/ }),

/***/ 3448:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseEditStrategy = void 0;
const keyCode_1 = __webpack_require__(9853);
const beanStub_1 = __webpack_require__(8731);
const positionUtils_1 = __webpack_require__(6257);
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(8994);
class BaseEditStrategy extends beanStub_1.BeanStub {
    postConstruct() {
        this.model = this.beans.editModelSvc;
        this.editSvc = this.beans.editSvc;
        this.addManagedEventListeners({
            cellFocused: this.onCellFocusChanged?.bind(this),
            cellFocusCleared: this.onCellFocusChanged?.bind(this),
        });
    }
    clearEdits(position) {
        this.model.clearEditValue(position);
    }
    onCellFocusChanged(event) {
        let cellCtrl;
        const previous = event['previousParams'];
        const { editSvc, beans } = this;
        const sourceEvent = event.type === 'cellFocused' ? event.sourceEvent : null;
        if (previous) {
            cellCtrl = (0, controllers_1._getCellCtrl)(beans, previous);
        }
        const { gos, editModelSvc } = beans;
        const isFocusCleared = event.type === 'cellFocusCleared';
        // check if any editors open
        if (editSvc.isEditing(undefined, { withOpenEditor: true })) {
            // if focus is clearing, we should stop editing
            // or cancel the editing if `block` and `hasErrors`
            const { column, rowIndex, rowPinned } = event;
            const cellPositionFromEvent = {
                column: column,
                rowNode: (0, positionUtils_1._getRowNode)(beans, { rowIndex: rowIndex, rowPinned }),
            };
            const isBlock = gos.get('invalidEditValueMode') === 'block';
            if (isBlock) {
                // if we are blocking on invalid edits, focus changes don't stop current editing
                return;
            }
            const shouldRevert = !isBlock;
            const hasError = !!editModelSvc?.getCellValidationModel().hasCellValidation(cellPositionFromEvent);
            const shouldCancel = shouldRevert && hasError;
            // if we don't have a previous cell, we don't need to force stopEditing
            const result = previous || isFocusCleared
                ? editSvc.stopEditing(undefined, {
                    cancel: shouldCancel,
                    source: isFocusCleared && shouldRevert ? 'api' : undefined,
                    event: sourceEvent,
                })
                : true;
            // editSvc didn't handle the stopEditing, we need to do more ourselves
            if (!result) {
                if (editSvc.isBatchEditing()) {
                    // close editors, but don't stop editing in batch mode
                    editSvc.cleanupEditors();
                }
                else {
                    // if not batch editing, then we stop editing the cell
                    editSvc.stopEditing(undefined, { source: 'api' });
                }
            }
        }
        cellCtrl?.refreshCell({ suppressFlash: true, force: true });
    }
    isCellEditable({ rowNode, column }, _source = 'ui') {
        return column.isColumnFunc(rowNode, column.getColDef().editable);
    }
    stop(cancel, event) {
        const editingCells = this.model.getEditPositions();
        const results = { all: [], pass: [], fail: [] };
        editingCells.forEach((cell) => {
            results.all.push(cell);
            const validation = this.model.getCellValidationModel().getCellValidation(cell);
            // check if the cell is valid
            if ((validation?.errorMessages?.length ?? 0) > 0) {
                results.fail.push(cell);
                return;
            }
            results.pass.push(cell);
        });
        if (cancel) {
            editingCells.forEach((cell) => {
                (0, editors_1._destroyEditor)(this.beans, cell);
                this.model.stop(cell);
            });
            return true;
        }
        const actions = this.processValidationResults(results);
        if (actions.destroy.length > 0) {
            actions.destroy.forEach((cell) => {
                (0, editors_1._destroyEditor)(this.beans, cell, { event });
                this.model.stop(cell);
            });
        }
        if (actions.keep.length > 0) {
            actions.keep.forEach((cell) => {
                const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, cell);
                if (!this.editSvc?.cellEditingInvalidCommitBlocks()) {
                    cellCtrl && this.editSvc.revertSingleCellEdit(cellCtrl);
                }
            });
        }
        return true;
    }
    cleanupEditors({ rowNode } = {}, includeEditing) {
        (0, editors_1._syncFromEditors)(this.beans);
        const positions = this.model.getEditPositions();
        const discard = [];
        if (rowNode) {
            positions.forEach((pos) => {
                // if the rowNode is provided, we only keep positions that match it
                if (!(!rowNode || pos.rowNode === rowNode)) {
                    discard.push(pos);
                }
            });
        }
        else {
            positions.forEach((pos) => {
                // if no rowNode is provided, we keep all positions
                discard.push(pos);
            });
        }
        // clean up any dangling editors
        (0, editors_1._destroyEditors)(this.beans, discard);
        (0, editors_1._purgeUnchangedEdits)(this.beans, includeEditing);
    }
    stopAllEditing() {
        (0, editors_1._syncFromEditors)(this.beans);
        this.stop();
    }
    setFocusOutOnEditor(cellCtrl) {
        cellCtrl.comp?.getCellEditor()?.focusOut?.();
    }
    setFocusInOnEditor(cellCtrl) {
        const comp = cellCtrl.comp;
        const editor = comp?.getCellEditor();
        if (editor?.focusIn) {
            // if the editor is present, then we just focus it
            editor.focusIn();
        }
        else {
            // if the editor is not present, it means async cell editor (e.g. React)
            // and we are trying to set focus before the cell editor is present, so we
            // focus the cell instead
            const isFullRow = this.beans.gos.get('editType') === 'fullRow';
            cellCtrl.focusCell(isFullRow);
            cellCtrl.onEditorAttachedFuncs.push(() => comp?.getCellEditor()?.focusIn?.());
        }
    }
    setupEditors(cells = this.model.getEditPositions(), position, cellStartedEdit, event, ignoreEventKey = false) {
        const key = (event instanceof KeyboardEvent && !ignoreEventKey && event.key) || undefined;
        (0, editors_1._setupEditors)(this.beans, cells, position, key, event, cellStartedEdit);
    }
    dispatchCellEvent(position, event, type, payload) {
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, position);
        if (cellCtrl) {
            this.eventSvc.dispatchEvent({ ...cellCtrl.createEvent(event ?? null, type), ...payload });
        }
    }
    dispatchRowEvent(position, type) {
        const rowCtrl = (0, controllers_1._getRowCtrl)(this.beans, position);
        if (rowCtrl) {
            this.eventSvc.dispatchEvent(rowCtrl.createRowEvent(type));
        }
    }
    shouldStart({ column }, event, cellStartedEdit, source = 'ui') {
        if (event instanceof KeyboardEvent &&
            (event.key === keyCode_1.KeyCode.TAB ||
                event.key === keyCode_1.KeyCode.ENTER ||
                event.key === keyCode_1.KeyCode.F2 ||
                (event.key === keyCode_1.KeyCode.BACKSPACE && cellStartedEdit))) {
            return true;
        }
        const extendingRange = event?.shiftKey && this.beans.rangeSvc?.getCellRanges().length != 0;
        if (extendingRange) {
            return false;
        }
        const colDef = column?.getColDef();
        const clickCount = this.deriveClickCount(colDef);
        const type = event?.type;
        if (type === 'click' && event?.detail === 1 && clickCount === 1) {
            return true;
        }
        if (type === 'dblclick' && event?.detail === 2 && clickCount === 2) {
            return true;
        }
        if (source === 'api') {
            return cellStartedEdit ?? false;
        }
        return false;
    }
    shouldStop(_position, event, source = 'ui') {
        const batch = this.editSvc.isBatchEditing();
        if (batch && source === 'api') {
            // we always defer to the API
            return true;
        }
        if (batch && source === 'ui') {
            // we always defer to the UI
            return false;
        }
        if (source === 'api') {
            return true;
        }
        if (event instanceof KeyboardEvent && !batch) {
            return event.key === keyCode_1.KeyCode.ENTER;
        }
        return null;
    }
    shouldCancel(_position, event, source = 'ui') {
        const batch = this.editSvc.isBatchEditing();
        if (event instanceof KeyboardEvent && !batch) {
            const result = event.key === keyCode_1.KeyCode.ESCAPE;
            if (result) {
                return true;
            }
        }
        if (batch && source === 'api') {
            // we always defer to the API
            return true;
        }
        if (source === 'api') {
            return true;
        }
        return false;
    }
    setEditMap(edits, params) {
        if (!params?.update) {
            this.editSvc.stopEditing(undefined, { cancel: true, source: 'api' });
        }
        // Identify incoming editing cells
        const cells = [];
        edits.forEach((editRow, rowNode) => {
            editRow.forEach((cellData, column) => {
                if (cellData.state === 'editing') {
                    cells.push({ ...cellData, rowNode, column });
                }
            });
        });
        if (params?.update) {
            edits = new Map([...this.model.getEditMap(), ...edits]);
        }
        this.model?.setEditMap(edits);
        if (cells.length > 0) {
            const cell = cells.at(-1);
            const key = cell.newValue === editors_1.UNEDITED ? undefined : cell.newValue;
            this.start(cell, new KeyboardEvent('keydown', { key }), 'api');
            const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, cell);
            if (cellCtrl) {
                this.setFocusInOnEditor(cellCtrl);
            }
        }
    }
    deriveClickCount(colDef) {
        const { gos } = this.beans;
        if (gos.get('suppressClickEdit') === true) {
            return 0;
        }
        if (gos.get('singleClickEdit') === true) {
            return 1;
        }
        if (colDef?.singleClickEdit) {
            return 1;
        }
        return 2;
    }
    destroy() {
        this.cleanupEditors();
        super.destroy();
    }
}
exports.BaseEditStrategy = BaseEditStrategy;


/***/ }),

/***/ 104:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FullRowEditStrategy = void 0;
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(8994);
const baseEditStrategy_1 = __webpack_require__(3448);
class FullRowEditStrategy extends baseEditStrategy_1.BaseEditStrategy {
    constructor() {
        super(...arguments);
        this.beanName = 'fullRow';
        this.startedRows = [];
    }
    isCellEditable(position, source = 'ui') {
        const editable = super.isCellEditable(position, source);
        if (editable === true || source === 'ui') {
            return editable;
        }
        // check if other cells in row are editable, so starting edit on uneditable cell will still work
        const columns = this.beans.colModel.getCols();
        return columns.some((col) => super.isCellEditable({ rowNode: position.rowNode, column: col }, source));
    }
    shouldStop(position, event, _source = 'ui') {
        const { rowNode } = position || {};
        const oldRowCtrl = (0, controllers_1._getRowCtrl)(this.beans, {
            rowNode: this.rowNode,
        });
        if (!oldRowCtrl) {
            return true;
        }
        const res = super.shouldStop({ rowNode: this.rowNode }, event, _source);
        if (res !== null) {
            return res;
        }
        if (!this.rowNode) {
            return false;
        }
        // stop editing if we've changed rows
        return rowNode !== this.rowNode;
    }
    midBatchInputsAllowed({ rowNode }) {
        if (!rowNode) {
            return false;
        }
        return this.model.hasEdits({ rowNode });
    }
    clearEdits(position) {
        this.model.clearEditValue(position);
    }
    start(position, event, _source = 'ui', ignoreEventKey) {
        const { rowNode } = position;
        if (this.rowNode !== rowNode) {
            super.cleanupEditors(position);
        }
        this.dispatchRowEvent({ rowNode }, 'rowEditingStarted');
        this.startedRows.push(rowNode);
        const columns = this.beans.visibleCols.allCols;
        const cells = [];
        columns.forEach((column) => {
            if (!column.isCellEditable(rowNode)) {
                return;
            }
            const position = {
                rowNode,
                column,
            };
            cells.push(position);
            if (!this.model.hasEdits(position)) {
                this.model.start(position);
            }
        });
        this.rowNode = rowNode;
        this.setupEditors(cells, position, true, event, ignoreEventKey);
    }
    processValidationResults(results) {
        const anyFailed = results.fail.length > 0;
        // if any of the cells failed, keep those editors
        if (anyFailed && this.editSvc.cellEditingInvalidCommitBlocks()) {
            return {
                destroy: [],
                keep: results.all,
            };
        }
        // if no cells failed, we destroy all editors
        return {
            destroy: results.all,
            keep: [],
        };
    }
    stop(cancel, event) {
        const { rowNode } = this;
        if (rowNode && !this.model.hasRowEdits(rowNode)) {
            return false;
        }
        const changedRows = [];
        if (!cancel) {
            this.model.getEditMap().forEach((rowEdits, rowNode) => {
                if (!rowEdits || rowEdits.size === 0) {
                    return;
                }
                for (const edit of rowEdits.values()) {
                    if ((0, editors_1._valuesDiffer)(edit)) {
                        changedRows.push(rowNode);
                        // early return, we only need to know if there are any edits
                        break;
                    }
                }
            });
        }
        // rerun validation, new values might have triggered row validations
        (0, editors_1._populateModelValidationErrors)(this.beans);
        if (!cancel && this.editSvc?.checkNavWithValidation({ rowNode }) === 'block-stop') {
            return false;
        }
        super.stop(cancel, event);
        changedRows.forEach((rowNode) => this.dispatchRowEvent({ rowNode }, 'rowValueChanged'));
        this.cleanupEditors({ rowNode }, true);
        this.rowNode = undefined;
        return true;
    }
    onCellFocusChanged(event) {
        const { rowIndex } = event;
        const prev = event['previousParams'];
        if (prev?.rowIndex === rowIndex || event.sourceEvent instanceof KeyboardEvent) {
            return;
        }
        const prevCell = (0, controllers_1._getCellCtrl)(this.beans, prev);
        const isBlock = this.gos.get('invalidEditValueMode') === 'block';
        if (isBlock &&
            prevCell &&
            (this.model.getCellValidationModel().getCellValidation(prevCell) ||
                this.model.getRowValidationModel().getRowValidation(prevCell))) {
            return;
        }
        super.onCellFocusChanged(event);
    }
    cleanupEditors(position = {}, includeEditing) {
        super.cleanupEditors(position, includeEditing);
        this.startedRows.forEach((rowNode) => this.dispatchRowEvent({ rowNode }, 'rowEditingStopped'));
        this.startedRows.length = 0;
    }
    // returns null if no navigation should be performed
    moveToNextEditingCell(prevCell, backwards, event, source = 'ui') {
        // check for all cell-level validation errors
        const preventNavigation = this.editSvc.checkNavWithValidation(undefined, event) === 'block-stop';
        const prevPos = prevCell.cellPosition;
        // find the next cell to start editing
        let nextCell;
        // fineNextCell in fullRow mode causes CellComps to initialise editors, this is
        // undesirable so we suspend the model while we find the next cell.
        this.model.suspend(true);
        try {
            nextCell = this.beans.navigation?.findNextCellToFocusOn(prevPos, {
                backwards,
                startEditing: true,
                // Default behaviour for fullRow is skip to the next cell,
                // editable or not. FullRow editing might have some editable
                // and some not editable cells in the row.
                // More complex logic needed to skip to the
                // next FullRow editable cell,
                skipToNextEditableCell: false,
            });
        }
        finally {
            this.model.suspend(false);
        }
        if (nextCell === false) {
            return null;
        }
        if (nextCell == null) {
            return false;
        }
        const nextPos = nextCell.cellPosition;
        const prevEditable = prevCell.isCellEditable();
        const nextEditable = nextCell.isCellEditable();
        const rowsMatch = nextPos && prevPos.rowIndex === nextPos.rowIndex && prevPos.rowPinned === nextPos.rowPinned;
        if (prevEditable) {
            this.setFocusOutOnEditor(prevCell);
        }
        if (nextEditable && !preventNavigation) {
            if (!nextCell.comp?.getCellEditor()) {
                // editor missing because it was outside the viewport during creating phase, attempt to create it now
                (0, editors_1._setupEditor)(this.beans, nextCell, { event, cellStartedEdit: true });
            }
            this.setFocusInOnEditor(nextCell);
            nextCell.focusCell(false, event);
        }
        else {
            nextCell.focusCell(true, event);
        }
        if (!rowsMatch && !preventNavigation) {
            this.cleanupEditors(nextCell, true);
            this.editSvc.startEditing(nextCell, { startedEdit: true, event, source, ignoreEventKey: true });
        }
        prevCell.rowCtrl?.refreshRow({ suppressFlash: true, force: true });
        return true;
    }
    destroy() {
        super.destroy();
        this.rowNode = undefined;
        this.startedRows.length = 0;
    }
}
exports.FullRowEditStrategy = FullRowEditStrategy;


/***/ }),

/***/ 149:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SingleCellEditStrategy = void 0;
const positionUtils_1 = __webpack_require__(6257);
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(8994);
const baseEditStrategy_1 = __webpack_require__(3448);
class SingleCellEditStrategy extends baseEditStrategy_1.BaseEditStrategy {
    constructor() {
        super(...arguments);
        this.beanName = 'singleCell';
    }
    shouldStop(position, event, source = 'ui') {
        const res = super.shouldStop(position, event, source);
        if (res !== null) {
            return res;
        }
        const { rowNode, column } = position || {};
        if ((!this.rowNode || !this.column) && rowNode && column) {
            return null;
        }
        return this.rowNode !== rowNode || this.column !== column;
    }
    midBatchInputsAllowed(position) {
        return this.model.hasEdits(position);
    }
    start(position, event, _source = 'ui', ignoreEventKey) {
        if (this.rowNode !== position.rowNode || this.column !== position.column) {
            super.cleanupEditors();
        }
        this.rowNode = position.rowNode;
        this.column = position.column;
        this.model.start(position);
        this.setupEditors([position], position, true, event, ignoreEventKey);
    }
    dispatchRowEvent(_position, _type) {
        // NOP - single cell edit strategy does not dispatch row events
    }
    stop(cancel, event) {
        super.stop(cancel, event);
        this.rowNode = undefined;
        this.column = undefined;
        return true;
    }
    onCellFocusChanged(event) {
        const { colModel, editSvc } = this.beans;
        const { rowIndex, column, rowPinned } = event;
        const rowNode = (0, positionUtils_1._getRowNode)(this.beans, { rowIndex: rowIndex, rowPinned });
        const curColId = (0, controllers_1._getColId)(column);
        const curCol = colModel.getCol(curColId);
        const previous = event['previousParams'];
        if (previous) {
            const prevColId = (0, controllers_1._getColId)(previous.column);
            if (previous?.rowIndex === rowIndex && prevColId === curColId && previous?.rowPinned === rowPinned) {
                return;
            }
        }
        if (editSvc?.isEditing({ rowNode, column: curCol }, { withOpenEditor: true }) &&
            event.type === 'cellFocused') {
            // editor is already active, so we don't need to do anything
            return;
        }
        super.onCellFocusChanged(event);
    }
    // returns null if no navigation should be performed
    moveToNextEditingCell(prevCell, backwards, event, source = 'ui') {
        // check for all cell-level validation errors
        const preventNavigation = this.editSvc.checkNavWithValidation(undefined, event) === 'block-stop';
        const prevPos = prevCell.cellPosition;
        // find the next cell to start editing
        let nextCell;
        const shouldSuspend = this.beans.gos.get('editType') === 'fullRow';
        if (shouldSuspend) {
            // fineNextCell in fullRow mode causes CellComps to initialise editors, this is
            // undesirable so we suspend the model while we find the next cell.
            this.model.suspend(true);
        }
        if (!preventNavigation) {
            // before we stop editing, we need to focus the cell element
            // so the grid doesn't detect that focus has left the grid
            prevCell.eGui.focus();
            // need to do this before getting next cell to edit, in case the next cell
            // has editable function (eg colDef.editable=func() ) and it depends on the
            // result of this cell, so need to save updates from the first edit, in case
            // the value is referenced in the function.
            prevCell.stopEditing();
        }
        try {
            nextCell = this.beans.navigation?.findNextCellToFocusOn(prevPos, {
                backwards,
                startEditing: true,
                // Default behaviour for fullRow is skip to the next cell,
                // editable or not. FullRow editing might have some editable
                // and some not editable cells in the row.
                // More complex logic needed to skip to the
                // next FullRow editable cell,
                // skipToNextEditableCell: false,
            });
        }
        finally {
            if (shouldSuspend) {
                this.model.suspend(false);
            }
        }
        if (nextCell === false) {
            return null;
        }
        if (nextCell == null) {
            return false;
        }
        const nextPos = nextCell.cellPosition;
        const prevEditable = prevCell.isCellEditable();
        const nextEditable = nextCell.isCellEditable();
        const rowsMatch = nextPos && prevPos.rowIndex === nextPos.rowIndex && prevPos.rowPinned === nextPos.rowPinned;
        if (!rowsMatch) {
            // run validation to gather row-level validation errors
            (0, editors_1._populateModelValidationErrors)(this.beans);
            if ((this.model.getRowValidationModel().getRowValidationMap().size ?? 0) === 0) {
                const rowPreventNavigation = this.editSvc.checkNavWithValidation(prevCell, event) === 'block-stop';
                if (rowPreventNavigation) {
                    return true;
                }
            }
        }
        if (prevEditable && !preventNavigation) {
            this.setFocusOutOnEditor(prevCell);
        }
        if (!rowsMatch && !preventNavigation) {
            super.cleanupEditors(nextCell, true);
            this.editSvc.startEditing(nextCell, { startedEdit: true, event, source, ignoreEventKey: true });
        }
        if (nextEditable && !preventNavigation) {
            // need to focus the cell before setting the editor, otherwise the focus handler won't cause previous editor cleanups
            nextCell.focusCell(false, event);
            if (!nextCell.comp?.getCellEditor()) {
                // editor missing because it was outside the viewport during creating phase, attempt to create it now
                (0, editors_1._setupEditor)(this.beans, nextCell, { event, cellStartedEdit: true });
            }
            this.setFocusInOnEditor(nextCell);
        }
        else {
            nextCell.focusCell(true, event);
        }
        prevCell.rowCtrl?.refreshRow({ suppressFlash: true, force: true });
        return true;
    }
    processValidationResults(results) {
        const anyFailed = results.fail.length > 0;
        // if any of the cells failed, we keep all editors
        if (anyFailed && this.editSvc.cellEditingInvalidCommitBlocks()) {
            return {
                destroy: [],
                keep: results.all,
            };
        }
        // if no cells failed, we destroy all editors
        return {
            destroy: results.all,
            keep: [],
        };
    }
    destroy() {
        super.destroy();
        this.rowNode = undefined;
        this.column = undefined;
    }
}
exports.SingleCellEditStrategy = SingleCellEditStrategy;


/***/ }),

/***/ 6904:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CellEditStyleFeature = void 0;
const beanStub_1 = __webpack_require__(8731);
const style_utils_1 = __webpack_require__(9320);
class CellEditStyleFeature extends beanStub_1.BeanStub {
    constructor(cellCtrl, beans) {
        super();
        this.cellCtrl = cellCtrl;
        this.beans = beans;
        this.editSvc = beans.editSvc;
        this.editModelSvc = beans.editModelSvc;
    }
    setComp(comp) {
        this.cellComp = comp;
        this.applyCellStyles();
    }
    applyCellStyles() {
        const { cellCtrl, editSvc, beans } = this;
        if (editSvc?.isBatchEditing() && editSvc.isEditing()) {
            const state = (0, style_utils_1._hasEdits)(beans, cellCtrl) || (0, style_utils_1._hasLeafEdits)(beans, cellCtrl) || (0, style_utils_1._hasPinnedEdits)(beans, cellCtrl);
            this.applyBatchingStyle(state);
        }
        else {
            this.applyBatchingStyle(false);
        }
        const hasErrors = !!this.editModelSvc?.getCellValidationModel().hasCellValidation(this.cellCtrl);
        this.cellComp.toggleCss('ag-cell-editing-error', hasErrors);
    }
    applyBatchingStyle(newState) {
        this.cellComp.toggleCss('ag-cell-editing', newState ?? false);
        this.cellComp.toggleCss('ag-cell-batch-edit', (newState && this.editSvc?.isBatchEditing()) ?? false);
    }
}
exports.CellEditStyleFeature = CellEditStyleFeature;


/***/ }),

/***/ 3536:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowEditStyleFeature = void 0;
const beanStub_1 = __webpack_require__(8731);
const style_utils_1 = __webpack_require__(9320);
class RowEditStyleFeature extends beanStub_1.BeanStub {
    constructor(rowCtrl, beans) {
        super();
        this.rowCtrl = rowCtrl;
        this.beans = beans;
        this.gos = beans.gos;
        this.editSvc = beans.editSvc;
        this.editModelSvc = beans.editModelSvc;
    }
    applyRowStyles() {
        const { rowCtrl, editModelSvc, beans } = this;
        let rowNode = rowCtrl.rowNode;
        let edits = editModelSvc?.getEditRow(rowNode);
        const hasErrors = this.editModelSvc?.getRowValidationModel().hasRowValidation({ rowNode });
        if (!edits && rowNode.pinnedSibling) {
            rowNode = rowNode.pinnedSibling;
            edits = editModelSvc?.getEditRow(rowNode);
        }
        if (edits) {
            const editing = Array.from(edits.keys()).some((column) => {
                const position = { rowNode, column };
                return ((0, style_utils_1._hasEdits)(beans, position, true) ||
                    (0, style_utils_1._hasLeafEdits)(beans, position) ||
                    (0, style_utils_1._hasPinnedEdits)(beans, position));
            });
            this.applyStyle(hasErrors, editing);
            return;
        }
        this.applyStyle(hasErrors);
    }
    applyStyle(hasErrors = false, editing = false) {
        const batchEdit = this.editSvc?.isBatchEditing() ?? false;
        const fullRow = this.gos.get('editType') === 'fullRow';
        this.rowCtrl?.forEachGui(undefined, ({ rowComp }) => {
            rowComp.toggleCss('ag-row-editing', fullRow && editing);
            rowComp.toggleCss('ag-row-batch-edit', fullRow && editing && batchEdit);
            // required for Material theme
            rowComp.toggleCss('ag-row-inline-editing', editing);
            rowComp.toggleCss('ag-row-not-inline-editing', !editing);
            rowComp.toggleCss('ag-row-editing-invalid', fullRow && editing && hasErrors);
        });
    }
}
exports.RowEditStyleFeature = RowEditStyleFeature;


/***/ }),

/***/ 9320:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._hasPinnedEdits = exports._hasLeafEdits = exports._hasEdits = void 0;
const editors_1 = __webpack_require__(8994);
const editHighlightFn = (edit, includeEditing = false) => {
    if (edit !== undefined) {
        return (0, editors_1._valuesDiffer)(edit) || (includeEditing && edit.state === 'editing');
    }
};
function _hasEdits(beans, position, includeEditing = false) {
    return editHighlightFn(beans.editModelSvc?.getEdit(position), includeEditing);
}
exports._hasEdits = _hasEdits;
function _hasLeafEdits(beans, position) {
    const { editModelSvc } = beans;
    const { column, rowNode } = position;
    // if we have group total rows, we should decorate them, rather than agg nodes
    if (beans.gos.get('groupTotalRow') && !rowNode?.footer) {
        return false;
    }
    for (const node of rowNode?.allLeafChildren ?? []) {
        const highlight = editHighlightFn(editModelSvc?.getEdit({ rowNode: node, column })) ||
            editHighlightFn(editModelSvc?.getEdit({ rowNode: node.pinnedSibling, column }));
        if (highlight) {
            return true;
        }
    }
}
exports._hasLeafEdits = _hasLeafEdits;
function _hasPinnedEdits(beans, { rowNode, column }) {
    rowNode = rowNode.pinnedSibling;
    if (!rowNode) {
        return;
    }
    return editHighlightFn(beans.editModelSvc?.getEdit({
        rowNode,
        column,
    }));
}
exports._hasPinnedEdits = _hasPinnedEdits;


/***/ }),

/***/ 1081:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getColId = exports._addStopEditingWhenGridLosesFocus = exports._getCtrls = exports._getCellCtrl = exports._getRowCtrl = void 0;
const positionUtils_1 = __webpack_require__(6257);
const mouseEventUtils_1 = __webpack_require__(8399);
const browser_1 = __webpack_require__(8667);
const editors_1 = __webpack_require__(8994);
function _getRowCtrl(beans, inputs = {}) {
    const { rowIndex, rowId, rowCtrl, rowPinned } = inputs;
    if (rowCtrl) {
        return rowCtrl;
    }
    const { rowModel, rowRenderer } = beans;
    let { rowNode } = inputs;
    if (!rowNode) {
        if (rowId) {
            rowNode = (0, positionUtils_1._getRowById)(beans, rowId, rowPinned);
        }
        else if (rowIndex != null) {
            rowNode = rowModel.getRow(rowIndex);
        }
    }
    return rowRenderer.getRowCtrls(rowNode ? [rowNode] : [])?.[0];
}
exports._getRowCtrl = _getRowCtrl;
function _getCellCtrl(beans, inputs = {}) {
    const { cellCtrl, colId, columnId, column } = inputs;
    if (cellCtrl) {
        return cellCtrl;
    }
    const actualColumn = beans.colModel.getCol(colId ?? columnId ?? _getColId(column));
    const rowCtrl = inputs.rowCtrl ?? _getRowCtrl(beans, inputs);
    const result = rowCtrl?.getCellCtrl(actualColumn) ?? undefined;
    if (result) {
        // if we found a cellCtrl, return it
        return result;
    }
    const rowNode = inputs.rowNode ?? rowCtrl?.rowNode;
    if (rowNode) {
        // can occur in spannedRow settings
        return beans.rowRenderer.getCellCtrls([rowNode], [actualColumn])?.[0];
    }
    return undefined;
}
exports._getCellCtrl = _getCellCtrl;
function _getCtrls(beans, inputs = {}) {
    const rowCtrl = _getRowCtrl(beans, inputs);
    const cellCtrl = _getCellCtrl(beans, inputs);
    return {
        rowCtrl,
        cellCtrl,
    };
}
exports._getCtrls = _getCtrls;
function _stopEditing(beans) {
    const { editSvc } = beans;
    if (editSvc?.isBatchEditing()) {
        (0, editors_1._destroyEditors)(beans);
    }
    else {
        editSvc?.stopEditing(undefined, { source: 'api' });
    }
}
function _addStopEditingWhenGridLosesFocus(bean, beans, viewports) {
    const { gos, popupSvc } = beans;
    if (!gos.get('stopEditingWhenCellsLoseFocus')) {
        return;
    }
    const focusOutListener = (event) => {
        // this is the element the focus is moving to
        const elementWithFocus = event.relatedTarget;
        if ((0, browser_1._getTabIndex)(elementWithFocus) === null) {
            _stopEditing(beans);
            return;
        }
        let clickInsideGrid = 
        // see if click came from inside the viewports
        viewports.some((viewport) => viewport.contains(elementWithFocus)) &&
            // and also that it's not from a detail grid
            (0, mouseEventUtils_1._isElementInThisGrid)(gos, elementWithFocus);
        if (!clickInsideGrid) {
            clickInsideGrid =
                !!popupSvc &&
                    (popupSvc.getActivePopups().some((popup) => popup.contains(elementWithFocus)) ||
                        popupSvc.isElementWithinCustomPopup(elementWithFocus));
        }
        if (!clickInsideGrid) {
            _stopEditing(beans);
        }
    };
    viewports.forEach((viewport) => bean.addManagedElementListeners(viewport, { focusout: focusOutListener }));
}
exports._addStopEditingWhenGridLosesFocus = _addStopEditingWhenGridLosesFocus;
function _getColId(column) {
    if (!column) {
        return undefined;
    }
    if (typeof column === 'string') {
        return column;
    }
    return column.getColId();
}
exports._getColId = _getColId;


/***/ }),

/***/ 8994:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._validateEdit = exports._generateRowValidationErrors = exports._populateModelValidationErrors = exports._destroyEditor = exports._destroyEditors = exports._syncFromEditor = exports._syncFromEditors = exports._refreshEditorOnColDefChanged = exports._purgeUnchangedEdits = exports._setupEditor = exports._valuesDiffer = exports._setupEditors = exports.getCellEditorInstances = exports.getCellEditorInstanceMap = exports.UNEDITED = void 0;
const unwrapUserComp_1 = __webpack_require__(4126);
const userCompUtils_1 = __webpack_require__(2036);
const gridOptionsUtils_1 = __webpack_require__(7274);
const localeUtils_1 = __webpack_require__(7230);
const aria_1 = __webpack_require__(5230);
const editModelService_1 = __webpack_require__(8544);
const controllers_1 = __webpack_require__(1081);
exports.UNEDITED = Symbol('unedited');
function getCellEditorInstanceMap(beans, params = {}) {
    const res = [];
    const ctrls = beans.rowRenderer.getCellCtrls(params.rowNodes, params.columns);
    for (const ctrl of ctrls) {
        const cellEditor = ctrl.comp?.getCellEditor();
        if (cellEditor) {
            res.push({
                ctrl,
                editor: (0, unwrapUserComp_1._unwrapUserComp)(cellEditor),
            });
        }
    }
    return res;
}
exports.getCellEditorInstanceMap = getCellEditorInstanceMap;
const getCellEditorInstances = (beans, params = {}) => getCellEditorInstanceMap(beans, params).map((res) => res.editor);
exports.getCellEditorInstances = getCellEditorInstances;
function _setupEditors(beans, editingCells, position, key, event, cellStartedEdit) {
    if (editingCells.length === 0 && position?.rowNode && position?.column) {
        _setupEditor(beans, position, { key, event, cellStartedEdit });
    }
    const { valueSvc, editSvc, editModelSvc } = beans;
    const { rowNode, column } = position ?? {};
    for (const cellPosition of editingCells) {
        const { rowNode: cellRowNode, column: cellColumn } = cellPosition;
        const curCellCtrl = (0, controllers_1._getCellCtrl)(beans, cellPosition);
        if (!curCellCtrl) {
            if (cellRowNode && cellColumn) {
                const oldValue = valueSvc.getValue(cellColumn, cellRowNode, undefined, 'api');
                const isNewValueCell = position?.rowNode === cellRowNode && position?.column === cellColumn;
                const cellStartValue = (isNewValueCell && key) || undefined;
                const newValue = cellStartValue ??
                    editSvc?.getCellDataValue(cellPosition) ??
                    valueSvc.getValueForDisplay(cellColumn, cellRowNode)?.value ??
                    oldValue ??
                    exports.UNEDITED;
                editModelSvc?.setEdit(cellPosition, { newValue, oldValue, state: 'editing' });
            }
            continue;
        }
        const shouldStartEditing = cellStartedEdit && rowNode === curCellCtrl.rowNode && curCellCtrl.column === column;
        _setupEditor(beans, { rowNode: rowNode, column: curCellCtrl.column }, {
            key: shouldStartEditing ? key : null,
            event: shouldStartEditing ? event : null,
            cellStartedEdit: shouldStartEditing,
        });
    }
    return;
}
exports._setupEditors = _setupEditors;
function _valuesDiffer({ newValue, oldValue }) {
    if (newValue === exports.UNEDITED) {
        newValue = oldValue;
    }
    return newValue !== oldValue;
}
exports._valuesDiffer = _valuesDiffer;
function _setupEditor(beans, position, params) {
    const { key, event, cellStartedEdit, silent } = params ?? {};
    const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
    const editorComp = cellCtrl?.comp?.getCellEditor();
    const editorParams = _createEditorParams(beans, position, key, cellStartedEdit);
    const previousEdit = beans.editModelSvc?.getEdit(position);
    // if key is a single character, then we treat it as user input
    let newValue = key?.length === 1 ? key : editorParams.value;
    if (newValue === undefined) {
        newValue = previousEdit?.oldValue;
    }
    beans.editModelSvc?.setEdit(position, { newValue: newValue ?? exports.UNEDITED, state: 'editing' });
    if (editorComp) {
        // don't reinitialise, just refresh if possible
        editorComp.refresh?.(editorParams);
        return;
    }
    const colDef = position.column.getColDef();
    const compDetails = (0, userCompUtils_1._getCellEditorDetails)(beans.userCompFactory, colDef, editorParams);
    // if cellEditorSelector was used, we give preference to popup and popupPosition from the selector
    const popup = compDetails?.popupFromSelector != null ? compDetails.popupFromSelector : !!colDef.cellEditorPopup;
    const popupLocation = compDetails?.popupPositionFromSelector != null
        ? compDetails.popupPositionFromSelector
        : colDef.cellEditorPopupPosition;
    checkAndPreventDefault(compDetails.params, event);
    if (cellCtrl) {
        cellCtrl.editCompDetails = compDetails;
        cellCtrl.comp?.setEditDetails(compDetails, popup, popupLocation, beans.gos.get('reactiveCustomComponents'));
        cellCtrl?.rowCtrl?.refreshRow({ suppressFlash: true });
        if (!silent) {
            beans.editSvc?.dispatchCellEvent(position, event, 'cellEditingStarted');
        }
    }
    return;
}
exports._setupEditor = _setupEditor;
function _valueFromEditor(cancel, cellComp) {
    const noValueResult = { newValueExists: false };
    if (cancel) {
        return noValueResult;
    }
    const cellEditor = cellComp?.getCellEditor();
    if (!cellEditor) {
        return noValueResult;
    }
    const validationErrors = cellEditor.getValidationErrors?.();
    if ((validationErrors?.length ?? 0) > 0) {
        return noValueResult;
    }
    const newValue = cellEditor.getValue();
    return {
        newValue,
        newValueExists: true,
    };
}
function _createEditorParams(beans, position, key, cellStartedEdit) {
    const { valueSvc, gos, editSvc } = beans;
    const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
    const rowIndex = position.rowNode?.rowIndex ?? undefined;
    const batchEdit = editSvc?.isBatchEditing();
    const agColumn = beans.colModel.getCol(position.column.getId());
    const { rowNode, column } = position;
    const initialNewValue = editSvc?.getCellDataValue(position) ?? _valueFromEditor(false, cellCtrl?.comp)?.newValue;
    const value = initialNewValue === exports.UNEDITED ? valueSvc.getValueForDisplay(agColumn, rowNode)?.value : initialNewValue;
    return (0, gridOptionsUtils_1._addGridCommonParams)(gos, {
        value,
        eventKey: key ?? null,
        column,
        colDef: column.getColDef(),
        rowIndex,
        node: rowNode,
        data: rowNode.data,
        cellStartedEdit: cellStartedEdit ?? false,
        onKeyDown: cellCtrl?.onKeyDown.bind(cellCtrl),
        stopEditing: (suppressNavigateAfterEdit) => {
            editSvc.stopEditing(position, { source: batchEdit ? 'ui' : 'api', suppressNavigateAfterEdit });
            _destroyEditor(beans, position);
        },
        eGridCell: cellCtrl?.eGui,
        parseValue: (newValue) => valueSvc.parseValue(agColumn, rowNode, newValue, cellCtrl?.value),
        formatValue: cellCtrl?.formatValue.bind(cellCtrl),
        validate: () => {
            editSvc?.validateEdit();
        },
    });
}
function _purgeUnchangedEdits(beans, includeEditing) {
    const { editModelSvc } = beans;
    editModelSvc?.getEditMap().forEach((editRow, rowNode) => {
        editRow.forEach((edit, column) => {
            if (!includeEditing && (edit.state === 'editing' || edit.newValue === exports.UNEDITED)) {
                return;
            }
            if (!_valuesDiffer(edit) && (edit.state !== 'editing' || includeEditing)) {
                // remove edits where the pending is equal to the old value
                editModelSvc?.removeEdits({ rowNode, column });
            }
        });
    });
}
exports._purgeUnchangedEdits = _purgeUnchangedEdits;
function _refreshEditorOnColDefChanged(beans, cellCtrl) {
    const editor = cellCtrl.comp?.getCellEditor();
    if (!editor?.refresh) {
        return;
    }
    const { eventKey, cellStartedEdit } = cellCtrl.editCompDetails.params;
    const { column } = cellCtrl;
    const editorParams = _createEditorParams(beans, cellCtrl, eventKey, cellStartedEdit);
    const colDef = column.getColDef();
    const compDetails = (0, userCompUtils_1._getCellEditorDetails)(beans.userCompFactory, colDef, editorParams);
    editor.refresh(checkAndPreventDefault(compDetails.params, eventKey));
}
exports._refreshEditorOnColDefChanged = _refreshEditorOnColDefChanged;
function checkAndPreventDefault(params, event) {
    if (event instanceof KeyboardEvent && params.column.getColDef().cellEditor === 'agNumberCellEditor') {
        // `-`, `+`, `.`, `e` need suppressPreventDefault to prevent the editor from ignoring the keypress
        params.suppressPreventDefault =
            ['-', '+', '.', 'e'].includes(event?.key ?? '') || params.suppressPreventDefault;
    }
    else {
        event?.preventDefault?.();
    }
    return params;
}
function _syncFromEditors(beans, params) {
    beans.editModelSvc?.getEditPositions().forEach((cellId) => {
        const cellCtrl = (0, controllers_1._getCellCtrl)(beans, cellId);
        if (!cellCtrl) {
            return;
        }
        const { newValue, newValueExists } = _valueFromEditor(false, cellCtrl.comp);
        if (!newValueExists) {
            return;
        }
        _syncFromEditor(beans, cellId, newValue, undefined, params);
    });
}
exports._syncFromEditors = _syncFromEditors;
function _syncFromEditor(beans, position, newValue, _source, params) {
    const { editModelSvc, valueSvc } = beans;
    if (!editModelSvc) {
        return;
    }
    const { rowNode, column } = position;
    if (!(rowNode && column)) {
        return;
    }
    const oldValue = editModelSvc.getEdit(position)?.oldValue ?? valueSvc.getValue(column, rowNode, undefined, 'api');
    const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
    const hasEditor = !!cellCtrl?.comp?.getCellEditor();
    // Only handle undefined, null is used to indicate a cleared cell value
    if (newValue === undefined) {
        newValue = exports.UNEDITED;
    }
    // Note: we don't clear the edit state here (even if new===old) as this is also called from the stop editing flow.
    editModelSvc.setEdit(position, { newValue, oldValue, state: hasEditor ? 'editing' : 'changed' });
    // re-read the value once it's been through all the formatting and parsing
    const { value } = valueSvc.getValueForDisplay(column, rowNode, true);
    newValue = value;
    // persist newly formatted value
    editModelSvc.setEdit(position, { newValue });
    if (newValue === oldValue || hasEditor) {
        // If the value hasn't changed or the editor is currently open, we don't need to dispatch an event
        return;
    }
    const edit = editModelSvc.getEdit(position);
    beans.editSvc?.dispatchCellEvent(position, params?.event, 'cellValueChanged', {
        valueChanged: edit && _valuesDiffer(edit),
        newValue: edit?.newValue,
        oldValue: edit?.oldValue,
    });
}
exports._syncFromEditor = _syncFromEditor;
function _destroyEditors(beans, edits, params) {
    if (!edits) {
        edits = beans.editModelSvc?.getEditPositions();
    }
    edits.forEach((cellPosition) => _destroyEditor(beans, cellPosition, params));
}
exports._destroyEditors = _destroyEditors;
function _destroyEditor(beans, position, params) {
    const { editSvc, editModelSvc } = beans;
    const { rowNode, column } = position;
    const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
    if (!cellCtrl) {
        if (editModelSvc?.hasEdits(position) && rowNode && column) {
            editModelSvc?.setState(position, 'changed');
        }
        return;
    }
    const { comp } = cellCtrl;
    if (comp && !comp.getCellEditor()) {
        // no editor, nothing to do
        return;
    }
    const errorMessages = comp?.getCellEditor()?.getValidationErrors?.();
    const cellValidationModel = editModelSvc?.getCellValidationModel();
    if (errorMessages?.length) {
        cellValidationModel?.setCellValidation(position, { errorMessages });
    }
    else {
        cellValidationModel?.clearCellValidation(position);
    }
    const wasEditing = editModelSvc?.getEdit(position)?.state === 'editing';
    if (editModelSvc?.hasEdits(position) && rowNode && column) {
        editModelSvc?.setState(position, 'changed');
    }
    comp?.setEditDetails(); // passing nothing stops editing
    comp?.refreshEditStyles(false, false);
    cellCtrl?.refreshCell({ force: true, suppressFlash: true });
    const edit = editModelSvc?.getEdit(position);
    if (wasEditing && edit?.state === 'changed' && !params?.silent) {
        editSvc?.dispatchCellEvent(position, params?.event, 'cellEditingStopped', {
            valueChanged: edit && _valuesDiffer(edit),
            newValue: edit?.newValue,
            oldValue: edit?.oldValue,
        });
    }
}
exports._destroyEditor = _destroyEditor;
function _populateModelValidationErrors(beans) {
    const mappedEditors = getCellEditorInstanceMap(beans);
    const cellValidationModel = new editModelService_1.EditCellValidationModel();
    const { ariaAnnounce, localeSvc, editModelSvc, gos } = beans;
    const includeRows = gos.get('editType') === 'fullRow';
    const translate = (0, localeUtils_1._getLocaleTextFunc)(localeSvc);
    const ariaValidationErrorPrefix = translate('ariaValidationErrorPrefix', 'Cell Editor Validation');
    for (const mappedEditor of mappedEditors) {
        const { ctrl, editor } = mappedEditor;
        const { rowNode, column } = ctrl;
        const errorMessages = editor.getValidationErrors?.() ?? [];
        const el = editor.getValidationElement?.();
        if (el) {
            const isInvalid = errorMessages != null && errorMessages.length > 0;
            const invalidMessage = isInvalid ? errorMessages.join('. ') : '';
            (0, aria_1._setAriaInvalid)(el, isInvalid);
            if (isInvalid) {
                ariaAnnounce.announceValue(`${ariaValidationErrorPrefix} ${errorMessages}`, 'editorValidation');
            }
            if (el instanceof HTMLInputElement) {
                el.setCustomValidity(invalidMessage);
            }
            else {
                el.classList.toggle('invalid', isInvalid);
            }
        }
        if (errorMessages?.length > 0) {
            cellValidationModel.setCellValidation({
                rowNode,
                column,
            }, {
                errorMessages,
            });
        }
    }
    _syncFromEditors(beans);
    // the cellValidationModel should probably be reused to avoid
    // the second loop over mappedEditor below
    editModelSvc?.setCellValidationModel(cellValidationModel);
    const rowCtrlSet = new Set();
    for (const { ctrl } of mappedEditors) {
        rowCtrlSet.add(ctrl.rowCtrl);
    }
    if (includeRows) {
        const rowValidations = (0, exports._generateRowValidationErrors)(beans);
        editModelSvc?.setRowValidationModel(rowValidations);
    }
    for (const rowCtrl of rowCtrlSet.values()) {
        rowCtrl.rowEditStyleFeature?.applyRowStyles();
        for (const cellCtrl of rowCtrl.getAllCellCtrls()) {
            cellCtrl.tooltipFeature?.refreshTooltip(true);
            cellCtrl.editorTooltipFeature?.refreshTooltip(true);
            cellCtrl.editStyleFeature?.applyCellStyles?.();
        }
    }
}
exports._populateModelValidationErrors = _populateModelValidationErrors;
const _generateRowValidationErrors = (beans) => {
    const rowValidationModel = new editModelService_1.EditRowValidationModel();
    const getFullRowEditValidationErrors = beans.gos.get('getFullRowEditValidationErrors');
    // populate row-level errors
    const editMap = beans.editModelSvc?.getEditMap();
    if (!editMap) {
        return rowValidationModel;
    }
    for (const rowNode of editMap.keys()) {
        const rowEditMap = editMap.get(rowNode);
        if (!rowEditMap) {
            continue;
        }
        const editorsState = [];
        const { rowIndex, rowPinned } = rowNode;
        for (const column of rowEditMap.keys()) {
            const editValue = rowEditMap.get(column);
            if (!editValue) {
                continue;
            }
            editorsState.push({
                column,
                colId: column.getColId(),
                rowIndex: rowIndex,
                rowPinned,
                ...editValue,
                // don't expose this implementation detail
                newValue: editValue.newValue === exports.UNEDITED ? undefined : editValue.newValue,
            });
        }
        const errorMessages = getFullRowEditValidationErrors?.({ editorsState }) ?? [];
        if (errorMessages.length > 0) {
            rowValidationModel.setRowValidation({
                rowNode,
            }, { errorMessages });
        }
    }
    return rowValidationModel;
};
exports._generateRowValidationErrors = _generateRowValidationErrors;
function _validateEdit(beans) {
    _populateModelValidationErrors(beans);
    const map = beans.editModelSvc?.getCellValidationModel().getCellValidationMap();
    if (!map) {
        return null;
    }
    const validations = [];
    map.forEach((rowValidations, rowNode) => {
        rowValidations.forEach(({ errorMessages }, column) => {
            validations.push({
                column,
                rowIndex: rowNode.rowIndex,
                rowPinned: rowNode.rowPinned,
                messages: errorMessages ?? null,
            });
        });
    });
    return validations;
}
exports._validateEdit = _validateEdit;


/***/ }),

/***/ 1539:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._refreshEditCells = void 0;
const purgeRows = ({ rowModel, pinnedRowModel, editModelSvc }, rowNodes) => {
    const found = new Set();
    rowModel.forEachNode((node) => rowNodes.has(node) && found.add(node));
    pinnedRowModel?.forEachPinnedRow('top', (node) => rowNodes.has(node) && found.add(node));
    pinnedRowModel?.forEachPinnedRow('bottom', (node) => rowNodes.has(node) && found.add(node));
    rowNodes.forEach((rowNode) => {
        if (!found.has(rowNode)) {
            editModelSvc.removeEdits({ rowNode });
        }
    });
    return found;
};
const purgeCells = ({ editModelSvc }, rowNodes, columns) => {
    rowNodes.forEach((rowNode) => editModelSvc
        ?.getEditRow(rowNode)
        ?.forEach((_, column) => !columns.has(column) && editModelSvc.removeEdits({ rowNode, column })));
};
const _refreshEditCells = (beans) => () => {
    const columns = new Set(beans.colModel.getCols());
    const updates = beans.editModelSvc.getEditMap(true);
    const rowNodes = new Set(updates.keys());
    purgeCells(beans, purgeRows(beans, rowNodes), columns);
};
exports._refreshEditCells = _refreshEditCells;


/***/ }),

/***/ 3355:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgColumn = exports.isColumn = exports.getNextColInstanceId = void 0;
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
const localEventService_1 = __webpack_require__(5889);
const generic_1 = __webpack_require__(4422);
const object_1 = __webpack_require__(6996);
const string_1 = __webpack_require__(7766);
const logging_1 = __webpack_require__(7764);
const COL_DEF_DEFAULTS = {
    resizable: true,
    sortable: true,
};
let instanceIdSequence = 0;
function getNextColInstanceId() {
    return instanceIdSequence++;
}
exports.getNextColInstanceId = getNextColInstanceId;
function isColumn(col) {
    return col instanceof AgColumn;
}
exports.isColumn = isColumn;
// Wrapper around a user provide column definition. The grid treats the column definition as ready only.
// This class contains all the runtime information about a column, plus some logic (the definition has no logic).
// This class implements both interfaces ColumnGroupChild and ProvidedColumnGroupChild as the class can
// appear as a child of either the original tree or the displayed tree. However the relevant group classes
// for each type only implements one, as each group can only appear in it's associated tree (eg ProvidedColumnGroup
// can only appear in OriginalColumn tree).
class AgColumn extends beanStub_1.BeanStub {
    constructor(colDef, 
    // We do NOT use this anywhere, we just keep a reference. this is to check object equivalence
    // when the user provides an updated list of columns - so we can check if we have a column already
    // existing for a col def. we cannot use the this.colDef as that is the result of a merge.
    // This is used in ColumnFactory
    userProvidedColDef, colId, primary) {
        super();
        this.colDef = colDef;
        this.userProvidedColDef = userProvidedColDef;
        this.colId = colId;
        this.primary = primary;
        this.isColumn = true;
        // used by React (and possibly other frameworks) as key for rendering. also used to
        // identify old vs new columns for destroying cols when no longer used.
        this.instanceId = getNextColInstanceId();
        // The measured height of this column's header when autoHeaderHeight is enabled
        this.autoHeaderHeight = null;
        this.moving = false;
        this.menuVisible = false;
        this.lastLeftPinned = false;
        this.firstRightPinned = false;
        this.filterActive = false;
        this.colEventSvc = new localEventService_1.LocalEventService();
        this.tooltipEnabled = false;
        this.rowGroupActive = false;
        this.pivotActive = false;
        this.aggregationActive = false;
        this.flex = null;
        this.colIdSanitised = (0, string_1._escapeString)(colId);
    }
    destroy() {
        super.destroy();
        this.beans.rowSpanSvc?.deregister(this);
    }
    getInstanceId() {
        return this.instanceId;
    }
    setState() {
        const { colDef, beans: { sortSvc, pinnedCols, colFlex }, } = this;
        sortSvc?.initCol(this);
        const hide = colDef.hide;
        if (hide !== undefined) {
            this.visible = !hide;
        }
        else {
            this.visible = !colDef.initialHide;
        }
        pinnedCols?.initCol(this);
        colFlex?.initCol(this);
    }
    // gets called when user provides an alternative colDef, eg
    setColDef(colDef, userProvidedColDef, source) {
        const colSpanChanged = colDef.spanRows !== this.colDef.spanRows;
        this.colDef = colDef;
        this.userProvidedColDef = userProvidedColDef;
        this.initMinAndMaxWidths();
        this.initDotNotation();
        this.initTooltip();
        if (colSpanChanged) {
            this.beans.rowSpanSvc?.deregister(this);
            this.initRowSpan();
        }
        this.dispatchColEvent('colDefChanged', source);
    }
    getUserProvidedColDef() {
        return this.userProvidedColDef;
    }
    getParent() {
        return this.parent;
    }
    getOriginalParent() {
        return this.originalParent;
    }
    // this is done after constructor as it uses gridOptionsService
    postConstruct() {
        this.setState();
        this.initMinAndMaxWidths();
        this.resetActualWidth('gridInitializing');
        this.initDotNotation();
        this.initTooltip();
        this.initRowSpan();
    }
    initDotNotation() {
        const { gos, colDef: { field, tooltipField }, } = this;
        const suppressDotNotation = gos.get('suppressFieldDotNotation');
        this.fieldContainsDots = (0, generic_1._exists)(field) && field.indexOf('.') >= 0 && !suppressDotNotation;
        this.tooltipFieldContainsDots = (0, generic_1._exists)(tooltipField) && tooltipField.indexOf('.') >= 0 && !suppressDotNotation;
    }
    initMinAndMaxWidths() {
        const colDef = this.colDef;
        this.minWidth = colDef.minWidth ?? this.beans.environment.getDefaultColumnMinWidth();
        this.maxWidth = colDef.maxWidth ?? Number.MAX_SAFE_INTEGER;
    }
    initTooltip() {
        this.beans.tooltipSvc?.initCol(this);
    }
    initRowSpan() {
        if (this.colDef.spanRows) {
            this.beans.rowSpanSvc?.register(this);
        }
    }
    resetActualWidth(source) {
        const initialWidth = this.calculateColInitialWidth(this.colDef);
        this.setActualWidth(initialWidth, source, true);
    }
    calculateColInitialWidth(colDef) {
        let width;
        const colDefWidth = colDef.width;
        const colDefInitialWidth = colDef.initialWidth;
        if (colDefWidth != null) {
            width = colDefWidth;
        }
        else if (colDefInitialWidth != null) {
            width = colDefInitialWidth;
        }
        else {
            width = 200;
        }
        return Math.max(Math.min(width, this.maxWidth), this.minWidth);
    }
    isEmptyGroup() {
        return false;
    }
    isRowGroupDisplayed(colId) {
        return this.beans.showRowGroupCols?.isRowGroupDisplayed(this, colId) ?? false;
    }
    isPrimary() {
        return this.primary;
    }
    isFilterAllowed() {
        // filter defined means it's a string, class or true.
        // if its false, null or undefined then it's false.
        const filterDefined = !!this.colDef.filter;
        return filterDefined;
    }
    isFieldContainsDots() {
        return this.fieldContainsDots;
    }
    isTooltipEnabled() {
        return this.tooltipEnabled;
    }
    isTooltipFieldContainsDots() {
        return this.tooltipFieldContainsDots;
    }
    getHighlighted() {
        return this.highlighted;
    }
    __addEventListener(eventType, listener) {
        this.colEventSvc.addEventListener(eventType, listener);
    }
    __removeEventListener(eventType, listener) {
        this.colEventSvc.removeEventListener(eventType, listener);
    }
    /**
     * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
     */
    addEventListener(eventType, userListener) {
        this.frameworkEventListenerService = this.beans.frameworkOverrides.createLocalEventListenerWrapper?.(this.frameworkEventListenerService, this.colEventSvc);
        const listener = this.frameworkEventListenerService?.wrap(eventType, userListener) ?? userListener;
        this.colEventSvc.addEventListener(eventType, listener);
    }
    /**
     * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
     */
    removeEventListener(eventType, userListener) {
        const listener = this.frameworkEventListenerService?.unwrap(eventType, userListener) ?? userListener;
        this.colEventSvc.removeEventListener(eventType, listener);
    }
    createColumnFunctionCallbackParams(rowNode) {
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            node: rowNode,
            data: rowNode.data,
            column: this,
            colDef: this.colDef,
        });
    }
    isSuppressNavigable(rowNode) {
        return this.beans.cellNavigation?.isSuppressNavigable(this, rowNode) ?? false;
    }
    isCellEditable(rowNode) {
        return this.beans.editSvc?.isCellEditable({ rowNode, column: this }) ?? false;
    }
    isSuppressFillHandle() {
        return !!this.colDef.suppressFillHandle;
    }
    isAutoHeight() {
        return !!this.colDef.autoHeight;
    }
    isAutoHeaderHeight() {
        return !!this.colDef.autoHeaderHeight;
    }
    isRowDrag(rowNode) {
        return this.isColumnFunc(rowNode, this.colDef.rowDrag);
    }
    isDndSource(rowNode) {
        return this.isColumnFunc(rowNode, this.colDef.dndSource);
    }
    isCellCheckboxSelection(rowNode) {
        return this.beans.selectionSvc?.isCellCheckboxSelection(this, rowNode) ?? false;
    }
    isSuppressPaste(rowNode) {
        return this.isColumnFunc(rowNode, this.colDef?.suppressPaste ?? null);
    }
    isResizable() {
        return !!this.getColDefValue('resizable');
    }
    /** Get value from ColDef or default if it exists. */
    getColDefValue(key) {
        return this.colDef[key] ?? COL_DEF_DEFAULTS[key];
    }
    isColumnFunc(rowNode, value) {
        // if boolean set, then just use it
        if (typeof value === 'boolean') {
            return value;
        }
        // if function, then call the function to find out
        if (typeof value === 'function') {
            const params = this.createColumnFunctionCallbackParams(rowNode);
            const editableFunc = value;
            return editableFunc(params);
        }
        return false;
    }
    createColumnEvent(type, source) {
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            type,
            column: this,
            columns: [this],
            source,
        });
    }
    isMoving() {
        return this.moving;
    }
    getSort() {
        return this.sort;
    }
    isSortable() {
        return !!this.getColDefValue('sortable');
    }
    /** @deprecated v32 use col.getSort() === 'asc */
    isSortAscending() {
        return this.sort === 'asc';
    }
    /** @deprecated v32 use col.getSort() === 'desc */
    isSortDescending() {
        return this.sort === 'desc';
    }
    /** @deprecated v32 use col.getSort() === undefined */
    isSortNone() {
        return (0, generic_1._missing)(this.sort);
    }
    /** @deprecated v32 use col.getSort() !== undefined */
    isSorting() {
        return (0, generic_1._exists)(this.sort);
    }
    getSortIndex() {
        return this.sortIndex;
    }
    isMenuVisible() {
        return this.menuVisible;
    }
    getAggFunc() {
        return this.aggFunc;
    }
    getLeft() {
        return this.left;
    }
    getOldLeft() {
        return this.oldLeft;
    }
    getRight() {
        return this.left + this.actualWidth;
    }
    setLeft(left, source) {
        this.oldLeft = this.left;
        if (this.left !== left) {
            this.left = left;
            this.dispatchColEvent('leftChanged', source);
        }
    }
    isFilterActive() {
        return this.filterActive;
    }
    /** @deprecated v33 Use `api.isColumnHovered(column)` instead. */
    isHovered() {
        (0, logging_1._warn)(261);
        return !!this.beans.colHover?.isHovered(this);
    }
    setFirstRightPinned(firstRightPinned, source) {
        if (this.firstRightPinned !== firstRightPinned) {
            this.firstRightPinned = firstRightPinned;
            this.dispatchColEvent('firstRightPinnedChanged', source);
        }
    }
    setLastLeftPinned(lastLeftPinned, source) {
        if (this.lastLeftPinned !== lastLeftPinned) {
            this.lastLeftPinned = lastLeftPinned;
            this.dispatchColEvent('lastLeftPinnedChanged', source);
        }
    }
    isFirstRightPinned() {
        return this.firstRightPinned;
    }
    isLastLeftPinned() {
        return this.lastLeftPinned;
    }
    isPinned() {
        return this.pinned === 'left' || this.pinned === 'right';
    }
    isPinnedLeft() {
        return this.pinned === 'left';
    }
    isPinnedRight() {
        return this.pinned === 'right';
    }
    getPinned() {
        return this.pinned;
    }
    setVisible(visible, source) {
        const newValue = visible === true;
        if (this.visible !== newValue) {
            this.visible = newValue;
            this.dispatchColEvent('visibleChanged', source);
        }
        this.dispatchStateUpdatedEvent('hide');
    }
    isVisible() {
        return this.visible;
    }
    isSpanHeaderHeight() {
        const colDef = this.getColDef();
        return !colDef.suppressSpanHeaderHeight;
    }
    getColumnGroupPaddingInfo() {
        let parent = this.getParent();
        if (!parent || !parent.isPadding()) {
            return { numberOfParents: 0, isSpanningTotal: false };
        }
        const numberOfParents = parent.getPaddingLevel() + 1;
        let isSpanningTotal = true;
        while (parent) {
            if (!parent.isPadding()) {
                isSpanningTotal = false;
                break;
            }
            parent = parent.getParent();
        }
        return { numberOfParents, isSpanningTotal };
    }
    getColDef() {
        return this.colDef;
    }
    getDefinition() {
        return this.colDef;
    }
    getColumnGroupShow() {
        return this.colDef.columnGroupShow;
    }
    getColId() {
        return this.colId;
    }
    getId() {
        return this.colId;
    }
    getUniqueId() {
        return this.colId;
    }
    getActualWidth() {
        return this.actualWidth;
    }
    getAutoHeaderHeight() {
        return this.autoHeaderHeight;
    }
    /** Returns true if the header height has changed */
    setAutoHeaderHeight(height) {
        const changed = height !== this.autoHeaderHeight;
        this.autoHeaderHeight = height;
        return changed;
    }
    createBaseColDefParams(rowNode) {
        const params = (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            node: rowNode,
            data: rowNode.data,
            colDef: this.colDef,
            column: this,
        });
        return params;
    }
    getColSpan(rowNode) {
        if ((0, generic_1._missing)(this.colDef.colSpan)) {
            return 1;
        }
        const params = this.createBaseColDefParams(rowNode);
        const colSpan = this.colDef.colSpan(params);
        // colSpan must be number equal to or greater than 1
        return Math.max(colSpan, 1);
    }
    getRowSpan(rowNode) {
        if ((0, generic_1._missing)(this.colDef.rowSpan)) {
            return 1;
        }
        const params = this.createBaseColDefParams(rowNode);
        const rowSpan = this.colDef.rowSpan(params);
        // rowSpan must be number equal to or greater than 1
        return Math.max(rowSpan, 1);
    }
    setActualWidth(actualWidth, source, silent = false) {
        actualWidth = Math.max(actualWidth, this.minWidth);
        actualWidth = Math.min(actualWidth, this.maxWidth);
        if (this.actualWidth !== actualWidth) {
            // disable flex for this column if it was manually resized.
            this.actualWidth = actualWidth;
            if (this.flex != null && source !== 'flex' && source !== 'gridInitializing') {
                this.flex = null;
            }
            if (!silent) {
                this.fireColumnWidthChangedEvent(source);
            }
        }
        this.dispatchStateUpdatedEvent('width');
    }
    fireColumnWidthChangedEvent(source) {
        this.dispatchColEvent('widthChanged', source);
    }
    isGreaterThanMax(width) {
        return width > this.maxWidth;
    }
    getMinWidth() {
        return this.minWidth;
    }
    getMaxWidth() {
        return this.maxWidth;
    }
    getFlex() {
        return this.flex;
    }
    isRowGroupActive() {
        return this.rowGroupActive;
    }
    isPivotActive() {
        return this.pivotActive;
    }
    isAnyFunctionActive() {
        return this.isPivotActive() || this.isRowGroupActive() || this.isValueActive();
    }
    isAnyFunctionAllowed() {
        return this.isAllowPivot() || this.isAllowRowGroup() || this.isAllowValue();
    }
    isValueActive() {
        return this.aggregationActive;
    }
    isAllowPivot() {
        return this.colDef.enablePivot === true;
    }
    isAllowValue() {
        return this.colDef.enableValue === true;
    }
    isAllowRowGroup() {
        return this.colDef.enableRowGroup === true;
    }
    dispatchColEvent(type, source, additionalEventAttributes) {
        const colEvent = this.createColumnEvent(type, source);
        if (additionalEventAttributes) {
            (0, object_1._mergeDeep)(colEvent, additionalEventAttributes);
        }
        this.colEventSvc.dispatchEvent(colEvent);
    }
    dispatchStateUpdatedEvent(key) {
        this.colEventSvc.dispatchEvent({
            type: 'columnStateUpdated',
            key,
        });
    }
}
exports.AgColumn = AgColumn;


/***/ }),

/***/ 6908:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgColumnGroup = exports.isColumnGroup = exports.createUniqueColumnGroupId = void 0;
const beanStub_1 = __webpack_require__(8731);
const array_1 = __webpack_require__(1502);
const agColumn_1 = __webpack_require__(3355);
function createUniqueColumnGroupId(groupId, instanceId) {
    return (groupId + '_' + instanceId);
}
exports.createUniqueColumnGroupId = createUniqueColumnGroupId;
function isColumnGroup(col) {
    return col instanceof AgColumnGroup;
}
exports.isColumnGroup = isColumnGroup;
class AgColumnGroup extends beanStub_1.BeanStub {
    constructor(providedColumnGroup, groupId, partId, pinned) {
        super();
        this.providedColumnGroup = providedColumnGroup;
        this.groupId = groupId;
        this.partId = partId;
        this.pinned = pinned;
        this.isColumn = false;
        // depends on the open/closed state of the group, only displaying columns are stored here
        this.displayedChildren = [];
        // The measured height of this column's header when autoHeaderHeight is enabled
        this.autoHeaderHeight = null;
        this.parent = null;
    }
    // as the user is adding and removing columns, the groups are recalculated.
    // this reset clears out all children, ready for children to be added again
    reset() {
        this.parent = null;
        this.children = null;
        this.displayedChildren = null;
    }
    getParent() {
        return this.parent;
    }
    getUniqueId() {
        return createUniqueColumnGroupId(this.groupId, this.partId);
    }
    isEmptyGroup() {
        return this.displayedChildren.length === 0;
    }
    isMoving() {
        const allLeafColumns = this.getProvidedColumnGroup().getLeafColumns();
        if (!allLeafColumns || allLeafColumns.length === 0) {
            return false;
        }
        return allLeafColumns.every((col) => col.isMoving());
    }
    checkLeft() {
        // first get all children to setLeft, as it impacts our decision below
        this.displayedChildren.forEach((child) => {
            if (isColumnGroup(child)) {
                child.checkLeft();
            }
        });
        // set our left based on first displayed column
        if (this.displayedChildren.length > 0) {
            if (this.gos.get('enableRtl')) {
                const lastChild = (0, array_1._last)(this.displayedChildren);
                const lastChildLeft = lastChild.getLeft();
                this.setLeft(lastChildLeft);
            }
            else {
                const firstChildLeft = this.displayedChildren[0].getLeft();
                this.setLeft(firstChildLeft);
            }
        }
        else {
            // this should never happen, as if we have no displayed columns, then
            // this groups should not even exist.
            this.setLeft(null);
        }
    }
    getLeft() {
        return this.left;
    }
    getOldLeft() {
        return this.oldLeft;
    }
    setLeft(left) {
        this.oldLeft = this.left;
        if (this.left !== left) {
            this.left = left;
            this.dispatchLocalEvent({ type: 'leftChanged' });
        }
    }
    getPinned() {
        return this.pinned;
    }
    getGroupId() {
        return this.groupId;
    }
    getPartId() {
        return this.partId;
    }
    getActualWidth() {
        let groupActualWidth = 0;
        this.displayedChildren?.forEach((child) => {
            groupActualWidth += child.getActualWidth();
        });
        return groupActualWidth;
    }
    isResizable() {
        if (!this.displayedChildren) {
            return false;
        }
        // if at least one child is resizable, then the group is resizable
        let result = false;
        this.displayedChildren.forEach((child) => {
            if (child.isResizable()) {
                result = true;
            }
        });
        return result;
    }
    getMinWidth() {
        let result = 0;
        this.displayedChildren.forEach((groupChild) => {
            result += groupChild.getMinWidth();
        });
        return result;
    }
    addChild(child) {
        if (!this.children) {
            this.children = [];
        }
        this.children.push(child);
    }
    getDisplayedChildren() {
        return this.displayedChildren;
    }
    getLeafColumns() {
        const result = [];
        this.addLeafColumns(result);
        return result;
    }
    getDisplayedLeafColumns() {
        const result = [];
        this.addDisplayedLeafColumns(result);
        return result;
    }
    getDefinition() {
        return this.providedColumnGroup.getColGroupDef();
    }
    getColGroupDef() {
        return this.providedColumnGroup.getColGroupDef();
    }
    isPadding() {
        return this.providedColumnGroup.isPadding();
    }
    isExpandable() {
        return this.providedColumnGroup.isExpandable();
    }
    isExpanded() {
        return this.providedColumnGroup.isExpanded();
    }
    setExpanded(expanded) {
        this.providedColumnGroup.setExpanded(expanded);
    }
    isAutoHeaderHeight() {
        return !!this.getColGroupDef()?.autoHeaderHeight;
    }
    getAutoHeaderHeight() {
        return this.autoHeaderHeight;
    }
    /** Returns true if the header height has changed */
    setAutoHeaderHeight(height) {
        const changed = height !== this.autoHeaderHeight;
        this.autoHeaderHeight = height;
        return changed;
    }
    addDisplayedLeafColumns(leafColumns) {
        this.displayedChildren.forEach((child) => {
            if ((0, agColumn_1.isColumn)(child)) {
                leafColumns.push(child);
            }
            else if (isColumnGroup(child)) {
                child.addDisplayedLeafColumns(leafColumns);
            }
        });
    }
    addLeafColumns(leafColumns) {
        this.children.forEach((child) => {
            if ((0, agColumn_1.isColumn)(child)) {
                leafColumns.push(child);
            }
            else if (isColumnGroup(child)) {
                child.addLeafColumns(leafColumns);
            }
        });
    }
    getChildren() {
        return this.children;
    }
    getColumnGroupShow() {
        return this.providedColumnGroup.getColumnGroupShow();
    }
    getProvidedColumnGroup() {
        return this.providedColumnGroup;
    }
    getPaddingLevel() {
        const parent = this.getParent();
        if (!this.isPadding() || !parent || !parent.isPadding()) {
            return 0;
        }
        return 1 + parent.getPaddingLevel();
    }
    calculateDisplayedColumns() {
        // clear out last time we calculated
        this.displayedChildren = [];
        // find the column group that is controlling expandable. this is relevant when we have padding (empty)
        // groups, where the expandable is actually the first parent that is not a padding group.
        let parentWithExpansion = this;
        while (parentWithExpansion != null && parentWithExpansion.isPadding()) {
            parentWithExpansion = parentWithExpansion.getParent();
        }
        const isExpandable = parentWithExpansion ? parentWithExpansion.getProvidedColumnGroup().isExpandable() : false;
        // it not expandable, everything is visible
        if (!isExpandable) {
            this.displayedChildren = this.children;
            this.dispatchLocalEvent({ type: 'displayedChildrenChanged' });
            return;
        }
        // Add cols based on columnGroupShow
        // Note - the below also adds padding groups, these are always added because they never have
        // colDef.columnGroupShow set.
        this.children.forEach((child) => {
            // never add empty groups
            const emptyGroup = isColumnGroup(child) && (!child.displayedChildren || !child.displayedChildren.length);
            if (emptyGroup) {
                return;
            }
            const headerGroupShow = child.getColumnGroupShow();
            switch (headerGroupShow) {
                case 'open':
                    // when set to open, only show col if group is open
                    if (parentWithExpansion.getProvidedColumnGroup().isExpanded()) {
                        this.displayedChildren.push(child);
                    }
                    break;
                case 'closed':
                    // when set to open, only show col if group is open
                    if (!parentWithExpansion.getProvidedColumnGroup().isExpanded()) {
                        this.displayedChildren.push(child);
                    }
                    break;
                default:
                    this.displayedChildren.push(child);
                    break;
            }
        });
        this.dispatchLocalEvent({ type: 'displayedChildrenChanged' });
    }
}
exports.AgColumnGroup = AgColumnGroup;


/***/ }),

/***/ 9409:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgProvidedColumnGroup = exports.isProvidedColumnGroup = void 0;
const beanStub_1 = __webpack_require__(8731);
const agColumn_1 = __webpack_require__(3355);
function isProvidedColumnGroup(col) {
    return col instanceof AgProvidedColumnGroup;
}
exports.isProvidedColumnGroup = isProvidedColumnGroup;
class AgProvidedColumnGroup extends beanStub_1.BeanStub {
    constructor(colGroupDef, groupId, padding, level) {
        super();
        this.colGroupDef = colGroupDef;
        this.groupId = groupId;
        this.padding = padding;
        this.level = level;
        this.isColumn = false;
        this.expandable = false;
        // used by React (and possibly other frameworks) as key for rendering. also used to
        // identify old vs new columns for destroying cols when no longer used.
        this.instanceId = (0, agColumn_1.getNextColInstanceId)();
        this.expandableListenerRemoveCallback = null;
        this.expanded = !!colGroupDef?.openByDefault;
    }
    destroy() {
        if (this.expandableListenerRemoveCallback) {
            this.reset(null, undefined);
        }
        super.destroy();
    }
    reset(colGroupDef, level) {
        this.colGroupDef = colGroupDef;
        this.level = level;
        this.originalParent = null;
        if (this.expandableListenerRemoveCallback) {
            this.expandableListenerRemoveCallback();
        }
        // we use ! below, as we want to set the object back to the
        // way it was when it was first created
        this.children = undefined;
        this.expandable = undefined;
    }
    getInstanceId() {
        return this.instanceId;
    }
    getOriginalParent() {
        return this.originalParent;
    }
    getLevel() {
        return this.level;
    }
    isVisible() {
        // return true if at least one child is visible
        if (this.children) {
            return this.children.some((child) => child.isVisible());
        }
        return false;
    }
    isPadding() {
        return this.padding;
    }
    setExpanded(expanded) {
        this.expanded = expanded === undefined ? false : expanded;
        this.dispatchLocalEvent({ type: 'expandedChanged' });
    }
    isExpandable() {
        return this.expandable;
    }
    isExpanded() {
        return this.expanded;
    }
    getGroupId() {
        return this.groupId;
    }
    getId() {
        return this.getGroupId();
    }
    setChildren(children) {
        this.children = children;
    }
    getChildren() {
        return this.children;
    }
    getColGroupDef() {
        return this.colGroupDef;
    }
    getLeafColumns() {
        const result = [];
        this.addLeafColumns(result);
        return result;
    }
    forEachLeafColumn(callback) {
        if (!this.children) {
            return;
        }
        for (const child of this.children) {
            if ((0, agColumn_1.isColumn)(child)) {
                callback(child);
            }
            else if (isProvidedColumnGroup(child)) {
                child.forEachLeafColumn(callback);
            }
        }
    }
    addLeafColumns(leafColumns) {
        if (!this.children) {
            return;
        }
        this.children.forEach((child) => {
            if ((0, agColumn_1.isColumn)(child)) {
                leafColumns.push(child);
            }
            else if (isProvidedColumnGroup(child)) {
                child.addLeafColumns(leafColumns);
            }
        });
    }
    getColumnGroupShow() {
        const colGroupDef = this.colGroupDef;
        if (!colGroupDef) {
            return;
        }
        return colGroupDef.columnGroupShow;
    }
    // need to check that this group has at least one col showing when both expanded and contracted.
    // if not, then we don't allow expanding and contracting on this group
    setupExpandable() {
        this.setExpandable();
        if (this.expandableListenerRemoveCallback) {
            this.expandableListenerRemoveCallback();
        }
        const listener = this.onColumnVisibilityChanged.bind(this);
        this.getLeafColumns().forEach((col) => col.__addEventListener('visibleChanged', listener));
        this.expandableListenerRemoveCallback = () => {
            this.getLeafColumns().forEach((col) => col.__removeEventListener('visibleChanged', listener));
            this.expandableListenerRemoveCallback = null;
        };
    }
    setExpandable() {
        if (this.isPadding()) {
            return;
        }
        // want to make sure the group doesn't disappear when it's open
        let atLeastOneShowingWhenOpen = false;
        // want to make sure the group doesn't disappear when it's closed
        let atLeastOneShowingWhenClosed = false;
        // want to make sure the group has something to show / hide
        let atLeastOneChangeable = false;
        const children = this.findChildrenRemovingPadding();
        for (let i = 0, j = children.length; i < j; i++) {
            const abstractColumn = children[i];
            if (!abstractColumn.isVisible()) {
                continue;
            }
            // if the abstractColumn is a grid generated group, there will be no colDef
            const headerGroupShow = abstractColumn.getColumnGroupShow();
            if (headerGroupShow === 'open') {
                atLeastOneShowingWhenOpen = true;
                atLeastOneChangeable = true;
            }
            else if (headerGroupShow === 'closed') {
                atLeastOneShowingWhenClosed = true;
                atLeastOneChangeable = true;
            }
            else {
                atLeastOneShowingWhenOpen = true;
                atLeastOneShowingWhenClosed = true;
            }
        }
        const expandable = atLeastOneShowingWhenOpen && atLeastOneShowingWhenClosed && atLeastOneChangeable;
        if (this.expandable !== expandable) {
            this.expandable = expandable;
            this.dispatchLocalEvent({ type: 'expandableChanged' });
        }
    }
    findChildrenRemovingPadding() {
        const res = [];
        const process = (items) => {
            items.forEach((item) => {
                // if padding, we add this children instead of the padding
                const skipBecausePadding = isProvidedColumnGroup(item) && item.isPadding();
                if (skipBecausePadding) {
                    process(item.children);
                }
                else {
                    res.push(item);
                }
            });
        };
        process(this.children);
        return res;
    }
    onColumnVisibilityChanged() {
        this.setExpandable();
    }
}
exports.AgProvidedColumnGroup = AgProvidedColumnGroup;


/***/ }),

/***/ 5449:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultColumnTypes = void 0;
exports.DefaultColumnTypes = {
    numericColumn: {
        headerClass: 'ag-right-aligned-header',
        cellClass: 'ag-right-aligned-cell',
    },
    rightAligned: {
        headerClass: 'ag-right-aligned-header',
        cellClass: 'ag-right-aligned-cell',
    },
};


/***/ }),

/***/ 6257:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getRowBelow = exports._getRowAbove = exports._getRowById = exports._getCellByPosition = exports._getRowNode = exports._getLastRow = exports._getFirstRow = exports._isSameRow = exports._isRowBefore = exports._areCellsEqual = exports._createCellId = void 0;
const gridOptionsUtils_1 = __webpack_require__(7274);
const generic_1 = __webpack_require__(4422);
function _createCellId(cellPosition) {
    const { rowIndex, rowPinned, column } = cellPosition;
    return `${rowIndex}.${rowPinned == null ? 'null' : rowPinned}.${column.getId()}`;
}
exports._createCellId = _createCellId;
function _areCellsEqual(cellA, cellB) {
    const colsMatch = cellA.column === cellB.column;
    const floatingMatch = cellA.rowPinned === cellB.rowPinned;
    const indexMatch = cellA.rowIndex === cellB.rowIndex;
    return colsMatch && floatingMatch && indexMatch;
}
exports._areCellsEqual = _areCellsEqual;
// tests if this row selection is before the other row selection
function _isRowBefore(rowA, rowB) {
    switch (rowA.rowPinned) {
        case 'top':
            // we we are floating top, and other isn't, then we are always before
            if (rowB.rowPinned !== 'top') {
                return true;
            }
            break;
        case 'bottom':
            // if we are floating bottom, and the other isn't, then we are never before
            if (rowB.rowPinned !== 'bottom') {
                return false;
            }
            break;
        default:
            // if we are not floating, but the other one is floating...
            if ((0, generic_1._exists)(rowB.rowPinned)) {
                return rowB.rowPinned !== 'top';
            }
            break;
    }
    return rowA.rowIndex < rowB.rowIndex;
}
exports._isRowBefore = _isRowBefore;
function _isSameRow(rowA, rowB) {
    // if both missing
    if (!rowA && !rowB) {
        return true;
    }
    // if only one missing
    if ((rowA && !rowB) || (!rowA && rowB)) {
        return false;
    }
    // otherwise compare (use == to compare rowPinned because it can be null or undefined)
    return rowA.rowIndex === rowB.rowIndex && rowA.rowPinned == rowB.rowPinned;
}
exports._isSameRow = _isSameRow;
function _getFirstRow(beans) {
    let rowIndex = 0;
    let rowPinned;
    const { pinnedRowModel, rowModel, pageBounds } = beans;
    if (pinnedRowModel?.getPinnedTopRowCount()) {
        rowPinned = 'top';
    }
    else if (rowModel.getRowCount()) {
        rowPinned = null;
        rowIndex = pageBounds.getFirstRow();
    }
    else if (pinnedRowModel?.getPinnedBottomRowCount()) {
        rowPinned = 'bottom';
    }
    return rowPinned === undefined ? null : { rowIndex, rowPinned };
}
exports._getFirstRow = _getFirstRow;
function _getLastRow(beans) {
    let rowIndex;
    let rowPinned = null;
    const { pinnedRowModel, pageBounds } = beans;
    const pinnedBottomCount = pinnedRowModel?.getPinnedBottomRowCount();
    const pinnedTopCount = pinnedRowModel?.getPinnedTopRowCount();
    if (pinnedBottomCount) {
        rowPinned = 'bottom';
        rowIndex = pinnedBottomCount - 1;
    }
    else if (beans.rowModel.getRowCount()) {
        rowPinned = null;
        rowIndex = pageBounds.getLastRow();
    }
    else if (pinnedTopCount) {
        rowPinned = 'top';
        rowIndex = pinnedTopCount - 1;
    }
    return rowIndex === undefined ? null : { rowIndex, rowPinned };
}
exports._getLastRow = _getLastRow;
function _getRowNode(beans, gridRow) {
    switch (gridRow.rowPinned) {
        case 'top':
            return beans.pinnedRowModel?.getPinnedTopRow(gridRow.rowIndex);
        case 'bottom':
            return beans.pinnedRowModel?.getPinnedBottomRow(gridRow.rowIndex);
        default:
            return beans.rowModel.getRow(gridRow.rowIndex);
    }
}
exports._getRowNode = _getRowNode;
function _getCellByPosition(beans, cellPosition) {
    // if spanned, return cell ctrl from spanned renderer
    const spannedCellCtrl = beans.spannedRowRenderer?.getCellByPosition(cellPosition);
    if (spannedCellCtrl) {
        return spannedCellCtrl;
    }
    const rowCtrl = beans.rowRenderer.getRowByPosition(cellPosition);
    if (!rowCtrl) {
        return null;
    }
    return rowCtrl.getCellCtrl(cellPosition.column);
}
exports._getCellByPosition = _getCellByPosition;
function _getRowById(beans, rowId, rowPinned) {
    const { rowModel: rm, pinnedRowModel: prm } = beans;
    let node;
    node ?? (node = rm?.getRowNode(rowId));
    if (rowPinned) {
        node ?? (node = prm?.getPinnedRowById(rowId, rowPinned));
    }
    else {
        node ?? (node = prm?.getPinnedRowById(rowId, 'top'));
        node ?? (node = prm?.getPinnedRowById(rowId, 'bottom'));
    }
    return node;
}
exports._getRowById = _getRowById;
function _getRowAbove(beans, rowPosition) {
    const { rowIndex: index, rowPinned: pinned } = rowPosition;
    const { pageBounds, pinnedRowModel, rowModel } = beans;
    if (index === 0) {
        if (pinned === 'top') {
            return null;
        }
        if (pinned === 'bottom' && rowModel.isRowsToRender()) {
            return { rowIndex: pageBounds.getLastRow(), rowPinned: null };
        }
        return pinnedRowModel?.isRowsToRender('top')
            ? { rowIndex: pinnedRowModel.getPinnedTopRowCount() - 1, rowPinned: 'top' }
            : null;
    }
    const rowNode = pinned ? undefined : rowModel.getRow(index);
    return getNextStickyPosition(beans, rowNode, true) ?? { rowIndex: index - 1, rowPinned: pinned };
}
exports._getRowAbove = _getRowAbove;
function _getRowBelow(beans, rowPosition) {
    const { rowIndex: index, rowPinned: pinned } = rowPosition;
    const { pageBounds, pinnedRowModel, rowModel } = beans;
    if (isLastRowInContainer(beans, rowPosition)) {
        if (pinned === 'bottom') {
            return null;
        }
        if (pinned === 'top' && rowModel.isRowsToRender()) {
            return { rowIndex: pageBounds.getFirstRow(), rowPinned: null };
        }
        return pinnedRowModel?.isRowsToRender('bottom') ? { rowIndex: 0, rowPinned: 'bottom' } : null;
    }
    const rowNode = pinned ? undefined : rowModel.getRow(index);
    return getNextStickyPosition(beans, rowNode) ?? { rowIndex: index + 1, rowPinned: pinned };
}
exports._getRowBelow = _getRowBelow;
function getNextStickyPosition(beans, rowNode, up) {
    const { gos, rowRenderer } = beans;
    if (!rowNode?.sticky || !(0, gridOptionsUtils_1._isGroupRowsSticky)(gos)) {
        return;
    }
    const stickyRowCtrls = up ? rowRenderer.getStickyTopRowCtrls() : rowRenderer.getStickyBottomRowCtrls();
    let nextCtrl;
    for (let i = 0; i < stickyRowCtrls.length; i++) {
        if (stickyRowCtrls[i].rowNode.rowIndex === rowNode.rowIndex) {
            nextCtrl = stickyRowCtrls[i + (up ? -1 : 1)];
            break;
        }
    }
    return nextCtrl ? { rowIndex: nextCtrl.rowNode.rowIndex, rowPinned: null } : undefined;
}
function isLastRowInContainer(beans, rowPosition) {
    const { rowPinned, rowIndex } = rowPosition;
    const { pinnedRowModel, pageBounds } = beans;
    if (rowPinned === 'top') {
        const lastTopIndex = (pinnedRowModel?.getPinnedTopRowCount() ?? 0) - 1;
        return lastTopIndex <= rowIndex;
    }
    if (rowPinned === 'bottom') {
        const lastBottomIndex = (pinnedRowModel?.getPinnedBottomRowCount() ?? 0) - 1;
        return lastBottomIndex <= rowIndex;
    }
    const lastBodyIndex = pageBounds.getLastRow();
    return lastBodyIndex <= rowIndex;
}


/***/ }),

/***/ 3373:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowNode = exports.ROW_ID_PREFIX_BOTTOM_PINNED = exports.ROW_ID_PREFIX_TOP_PINNED = exports.ROW_ID_PREFIX_ROW_GROUP = void 0;
const gridOptionsUtils_1 = __webpack_require__(7274);
const localEventService_1 = __webpack_require__(5889);
const logging_1 = __webpack_require__(7764);
exports.ROW_ID_PREFIX_ROW_GROUP = 'row-group-';
exports.ROW_ID_PREFIX_TOP_PINNED = 't-';
exports.ROW_ID_PREFIX_BOTTOM_PINNED = 'b-';
let OBJECT_ID_SEQUENCE = 0;
class RowNode {
    constructor(beans) {
        /** `true` if this row is a master row, part of master / detail (ie row can be expanded to show detail) */
        this.master = false;
        /** `true` if this row is a detail row, part of master / detail (ie child row of an expanded master row)*/
        this.detail = undefined;
        /** The current row index. If the row is filtered out or in a collapsed group, this value is set to `null`. */
        this.rowIndex = null;
        /** The key for the group eg Ireland, UK, USA */
        this.key = null;
        /**
         * The index of the row in the source rowData array including any updates via transactions.
         * It does not change when sorting, filtering, grouping, pivoting or any other UI related operations.
         * If this is a filler node (a visual row created by AG Grid in tree data or grouping) the value is set to `-1`.
         *
         * Generally readonly. It is modified only by:
         * - ClientSideNodeManager, cast to ClientSideNodeManagerRowNode
         * - ClientSideRowModel, cast to ClientSideRowModelRowNode
         */
        this.sourceRowIndex = -1;
        /** Children mapped by the pivot columns or group key */
        this.childrenMapped = null;
        /**
         * Parent RowNode for tree data.
         * When set, the parent node in the hierarchy is updated during Client-Side Row Model (CSRM) grouping.
         * Used by the ClientSideChildrenTreeNodeManager, TreeGroupStrategy, RowDragFeature
         */
        this.treeParent = null;
        /** The flags associated to this node. Used only internally within TreeGroupStrategy. */
        this.treeNodeFlags = 0;
        /**
         * This is `true` if the row has a rowIndex assigned, otherwise `false`.
         */
        this.displayed = false;
        /** The row top position in pixels. */
        this.rowTop = null;
        /** The top pixel for this row last time, makes sense if data set was ordered or filtered,
         * it is used so new rows can animate in from their old position. */
        this.oldRowTop = null;
        /** `true` by default - can be overridden via gridOptions.isRowSelectable(rowNode) */
        this.selectable = true;
        /**
         * Used by sorting service - to give deterministic sort to groups. Previously we
         * just id for this, however id is a string and had slower sorting compared to numbers.
         * If re-naming this property, you must also update `IGNORED_SIBLING_PROPERTIES`
         */
        this.__objectId = OBJECT_ID_SEQUENCE++;
        /** `true` when nodes with the same id are being removed and added as part of the same batch transaction */
        this.alreadyRendered = false;
        this.hovered = false;
        this.__selected = false;
        this.beans = beans;
    }
    /**
     * Replaces the data on the `rowNode`. When this method is called, the grid refreshes the entire rendered row if it is displayed.
     */
    setData(data) {
        this.setDataCommon(data, false);
    }
    // similar to setRowData, however it is expected that the data is the same data item. this
    // is intended to be used with Redux type stores, where the whole data can be changed. we are
    // guaranteed that the data is the same entity (so grid doesn't need to worry about the id of the
    // underlying data changing, hence doesn't need to worry about selection). the grid, upon receiving
    // dataChanged event, refreshes the cells rather than rip them all out (so user can show transitions).
    /**
     * Updates the data on the `rowNode`. When this method is called, the grid refreshes the entire rendered row if it is displayed.
     */
    updateData(data) {
        this.setDataCommon(data, true);
    }
    setDataCommon(data, update) {
        const { valueCache, eventSvc } = this.beans;
        const oldData = this.data;
        this.data = data;
        valueCache?.onDataChanged();
        this.updateDataOnDetailNode();
        this.resetQuickFilterAggregateText();
        const event = this.createDataChangedEvent(data, oldData, update);
        this.__localEventService?.dispatchEvent(event);
        if (this.sibling) {
            this.sibling.data = data;
            const event = this.sibling.createDataChangedEvent(data, oldData, update);
            this.sibling.__localEventService?.dispatchEvent(event);
        }
        eventSvc.dispatchEvent({ type: 'rowNodeDataChanged', node: this });
        const pinnedSibling = this.pinnedSibling;
        if (pinnedSibling) {
            pinnedSibling.data = data;
            pinnedSibling.__localEventService?.dispatchEvent(pinnedSibling.createDataChangedEvent(data, oldData, update));
            eventSvc.dispatchEvent({ type: 'rowNodeDataChanged', node: pinnedSibling });
        }
    }
    // when we are doing master / detail, the detail node is lazy created, but then kept around.
    // so if we show / hide the detail, the same detail rowNode is used. so we need to keep the data
    // in sync, otherwise expand/collapse of the detail would still show the old values.
    updateDataOnDetailNode() {
        if (this.detailNode) {
            this.detailNode.data = this.data;
        }
    }
    createDataChangedEvent(newData, oldData, update) {
        return {
            type: 'dataChanged',
            node: this,
            oldData: oldData,
            newData: newData,
            update: update,
        };
    }
    getRowIndexString() {
        if (this.rowIndex == null) {
            // Row has been removed so no index
            (0, logging_1._error)(13);
            return null;
        }
        if (this.rowPinned === 'top') {
            return exports.ROW_ID_PREFIX_TOP_PINNED + this.rowIndex;
        }
        if (this.rowPinned === 'bottom') {
            return exports.ROW_ID_PREFIX_BOTTOM_PINNED + this.rowIndex;
        }
        return this.rowIndex.toString();
    }
    setDataAndId(data, id) {
        const { selectionSvc } = this.beans;
        const oldNode = selectionSvc?.createDaemonNode?.(this);
        const oldData = this.data;
        this.data = data;
        this.updateDataOnDetailNode();
        this.setId(id);
        if (selectionSvc) {
            selectionSvc.updateRowSelectable(this);
            selectionSvc.syncInRowNode(this, oldNode);
        }
        const event = this.createDataChangedEvent(data, oldData, false);
        this.__localEventService?.dispatchEvent(event);
    }
    setId(id) {
        // see if user is providing the id's
        const getRowIdFunc = (0, gridOptionsUtils_1._getRowIdCallback)(this.beans.gos);
        if (getRowIdFunc) {
            // if user is providing the id's, then we set the id only after the data has been set.
            // this is important for virtual pagination and viewport, where empty rows exist.
            if (this.data) {
                // we pass 'true' as we skip this level when generating keys,
                // as we don't always have the key for this level (eg when updating
                // data via transaction on SSRM, we are getting key to look up the
                // RowNode, don't have the RowNode yet, thus no way to get the current key)
                const parentKeys = this.parent?.getRoute() ?? [];
                this.id = getRowIdFunc({
                    data: this.data,
                    parentKeys: parentKeys.length > 0 ? parentKeys : undefined,
                    level: this.level,
                    rowPinned: this.rowPinned,
                });
                // make sure id provided doesn't start with 'row-group-' as this is reserved.
                if (this.id.startsWith(exports.ROW_ID_PREFIX_ROW_GROUP)) {
                    (0, logging_1._error)(14, {
                        groupPrefix: exports.ROW_ID_PREFIX_ROW_GROUP,
                    });
                }
            }
            else {
                // this can happen if user has set blank into the rowNode after the row previously
                // having data. this happens in virtual page row model, when data is delete and
                // the page is refreshed.
                this.id = undefined;
            }
        }
        else {
            this.id = id;
        }
    }
    setRowTop(rowTop) {
        this.oldRowTop = this.rowTop;
        if (this.rowTop === rowTop) {
            return;
        }
        this.rowTop = rowTop;
        this.dispatchRowEvent('topChanged');
        this.setDisplayed(rowTop !== null);
    }
    clearRowTopAndRowIndex() {
        this.oldRowTop = null;
        this.setRowTop(null);
        this.setRowIndex(null);
    }
    setHovered(hovered) {
        this.hovered = hovered;
    }
    isHovered() {
        return this.hovered;
    }
    /**
     * Sets the row height.
     * Call if you want to change the height initially assigned to the row.
     * After calling, you must call `api.onRowHeightChanged()` so the grid knows it needs to work out the placement of the rows. */
    setRowHeight(rowHeight, estimated = false) {
        this.rowHeight = rowHeight;
        this.rowHeightEstimated = estimated;
        this.dispatchRowEvent('heightChanged');
    }
    setExpanded(expanded, e, forceSync) {
        this.beans.expansionSvc?.setExpanded(this, expanded, e, forceSync);
    }
    /**
     * Replaces the value on the `rowNode` for the specified column. When complete,
     * the grid refreshes the rendered cell on the required row only.
     * **Note**: This method only fires `onCellEditRequest` when the Grid is in **Read Only** mode.
     * **Note**: This method defers to EditModule if available and batches the edit when `fullRow` or `batchEdit` is enabled.
     *
     * @param colKey The column where the value should be updated
     * @param newValue The new value
     * @param eventSource The source of the event
     * @returns `true` if the value was changed, otherwise `false`.
     */
    setDataValue(colKey, newValue, eventSource) {
        const { colModel, valueSvc, gos, editSvc } = this.beans;
        // if in pivot mode, grid columns wont include primary columns
        const column = typeof colKey !== 'string' ? colKey : colModel.getCol(colKey) ?? colModel.getColDefCol(colKey);
        if (!column) {
            return false;
        }
        const oldValue = valueSvc.getValueForDisplay(column, this, undefined, undefined, 'api').value;
        if (gos.get('readOnlyEdit')) {
            const { beans: { eventSvc }, data, rowIndex, rowPinned, } = this;
            eventSvc.dispatchEvent({
                type: 'cellEditRequest',
                event: null,
                rowIndex,
                rowPinned,
                column,
                colDef: column.colDef,
                data,
                node: this,
                oldValue,
                newValue,
                value: newValue,
                source: eventSource,
            });
            return false;
        }
        if (editSvc) {
            const result = editSvc.setDataValue({ rowNode: this, column }, newValue, eventSource);
            if (result != null) {
                return result;
            }
        }
        const valueChanged = valueSvc.setValue(this, column, newValue, eventSource);
        this.dispatchCellChangedEvent(column, newValue, oldValue);
        const pinnedSibling = this.pinnedSibling;
        if (pinnedSibling) {
            // pinned sibling shares a reference to the same data object as the
            if (valueChanged) {
                pinnedSibling.dispatchCellChangedEvent(column, newValue, oldValue);
            }
        }
        return valueChanged;
    }
    updateHasChildren() {
        // in CSRM, the group property is set before the childrenAfterGroup property, check both to prevent flickering
        let newValue = (this.group && !this.footer) || (this.childrenAfterGroup && this.childrenAfterGroup.length > 0);
        const { rowChildrenSvc } = this.beans;
        if (rowChildrenSvc) {
            newValue = rowChildrenSvc.getHasChildrenValue(this);
        }
        if (newValue !== this.__hasChildren) {
            this.__hasChildren = !!newValue;
            this.dispatchRowEvent('hasChildrenChanged');
        }
    }
    hasChildren() {
        if (this.__hasChildren == null) {
            this.updateHasChildren();
        }
        return this.__hasChildren;
    }
    dispatchCellChangedEvent(column, newValue, oldValue) {
        const cellChangedEvent = {
            type: 'cellChanged',
            node: this,
            column: column,
            newValue: newValue,
            oldValue: oldValue,
        };
        this.__localEventService?.dispatchEvent(cellChangedEvent);
    }
    /**
     * The first time `quickFilter` runs, the grid creates a one-off string representation of the row.
     * This string is then used for the quick filter instead of hitting each column separately.
     * When you edit, using grid editing, this string gets cleared down.
     * However, if you edit without using grid editing, you need to clear this string down for the row to be updated with the new values.
     * Otherwise, new values would not work with the `quickFilter`. */
    resetQuickFilterAggregateText() {
        this.quickFilterAggregateText = null;
    }
    /** Returns:
     * - `true` if the node can be expanded, i.e it is a group or master row.
     * - `false` if the node cannot be expanded
     */
    isExpandable() {
        return this.beans.expansionSvc?.isExpandable(this) ?? false;
    }
    /** Returns:
     * - `true` if node is selected,
     * - `false` if the node isn't selected
     * - `undefined` if it's partially selected (group where not all children are selected). */
    isSelected() {
        // for footers, we just return what our sibling selected state is, as cannot select a footer
        if (this.footer) {
            return this.sibling.isSelected();
        }
        // similarly for manually pinned rows
        if (this.rowPinned && this.pinnedSibling) {
            return this.pinnedSibling.isSelected();
        }
        return this.__selected;
    }
    /** Perform a depth-first search of this node and its children. */
    depthFirstSearch(callback) {
        this.childrenAfterGroup?.forEach((child) => child.depthFirstSearch(callback));
        callback(this);
    }
    dispatchRowEvent(type) {
        this.__localEventService?.dispatchEvent({
            type: type,
            node: this,
        });
    }
    /**
     * Select (or deselect) the node.
     * @param newValue -`true` for selection, `false` for deselection.
     * @param clearSelection - If selecting, then passing `true` selects the node exclusively (i.e. NOT do multi select). If doing deselection, `clearSelection` has no impact.
     * @param source - Source property that appears in the `selectionChanged` event.
     */
    setSelected(newValue, clearSelection = false, source = 'api') {
        this.beans.selectionSvc?.setNodesSelected({
            nodes: [this],
            newValue,
            clearSelection,
            source,
        });
    }
    /**
     * Returns:
     * - `true` if node is either pinned to the `top` or `bottom`
     * - `false` if the node isn't pinned
     */
    isRowPinned() {
        return !!this.rowPinned;
    }
    __addEventListener(eventType, listener) {
        if (!this.__localEventService) {
            this.__localEventService = new localEventService_1.LocalEventService();
        }
        this.__localEventService.addEventListener(eventType, listener);
    }
    __removeEventListener(eventType, listener) {
        this.removeLocalListener(eventType, listener);
    }
    /**
     * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
     */
    addEventListener(eventType, userListener) {
        this.beans.validation?.checkRowEvents(eventType);
        if (!this.__localEventService) {
            this.__localEventService = new localEventService_1.LocalEventService();
        }
        this.frameworkEventListenerService = this.beans.frameworkOverrides.createLocalEventListenerWrapper?.(this.frameworkEventListenerService, this.__localEventService);
        const listener = this.frameworkEventListenerService?.wrap(eventType, userListener) ?? userListener;
        this.__localEventService.addEventListener(eventType, listener);
    }
    /**
     * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
     */
    removeEventListener(eventType, userListener) {
        const listener = this.frameworkEventListenerService?.unwrap(eventType, userListener) ?? userListener;
        this.removeLocalListener(eventType, listener);
    }
    removeLocalListener(eventType, listener) {
        this.__localEventService?.removeEventListener(eventType, listener);
        if (this.__localEventService?.noRegisteredListenersExist()) {
            this.__localEventService = null;
        }
    }
    /**
     * @deprecated v32.2.0 Check `node.detail` then user provided callback `isFullWidthRow` instead.
     *
     * Returns:
     * - `true` if the node is a full width cell
     * - `false` if the node is not a full width cell
     */
    isFullWidthCell() {
        // log deprecation
        (0, logging_1._warn)(61);
        if (this.detail) {
            return true;
        }
        const isFullWidthCellFunc = this.beans.gos.getCallback('isFullWidthRow');
        return isFullWidthCellFunc ? isFullWidthCellFunc({ rowNode: this }) : false;
    }
    /**
     * Returns the route of keys to the row node. Returns undefined if the node has no key.
     */
    getRoute() {
        // root node is still a valid route
        if (this.level === -1) {
            return [];
        }
        if (this.key == null) {
            return undefined;
        }
        const res = [];
        let pointer = this;
        while (pointer && pointer.key != null) {
            res.push(pointer.key);
            pointer = pointer.parent;
        }
        return res.reverse();
    }
    setFirstChild(firstChild) {
        if (this.firstChild !== firstChild) {
            this.firstChild = firstChild;
            this.dispatchRowEvent('firstChildChanged');
        }
    }
    setDisplayed(displayed) {
        if (this.displayed !== displayed) {
            this.displayed = displayed;
            this.dispatchRowEvent('displayedChanged');
        }
    }
    setRowIndex(rowIndex) {
        if (this.rowIndex !== rowIndex) {
            this.rowIndex = rowIndex;
            this.dispatchRowEvent('rowIndexChanged');
        }
    }
    setAllChildrenCount(allChildrenCount) {
        if (this.allChildrenCount !== allChildrenCount) {
            this.allChildrenCount = allChildrenCount;
            this.dispatchRowEvent('allChildrenCountChanged');
        }
    }
    setUiLevel(uiLevel) {
        if (this.uiLevel !== uiLevel) {
            this.uiLevel = uiLevel;
            this.dispatchRowEvent('uiLevelChanged');
        }
    }
    getFirstChild() {
        if (this.childStore) {
            return this.childStore.getFirstNode();
        }
        return this.childrenAfterSort?.[0] ?? null;
    }
}
exports.RowNode = RowNode;


/***/ }),

/***/ 9888:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._createRowNodeSibling = exports._createGlobalRowEvent = void 0;
const gridOptionsUtils_1 = __webpack_require__(7274);
const rowNode_1 = __webpack_require__(3373);
function _createGlobalRowEvent(rowNode, gos, type) {
    return (0, gridOptionsUtils_1._addGridCommonParams)(gos, {
        type,
        node: rowNode,
        data: rowNode.data,
        rowIndex: rowNode.rowIndex,
        rowPinned: rowNode.rowPinned,
    });
}
exports._createGlobalRowEvent = _createGlobalRowEvent;
/**
 * When creating sibling nodes (e.g. footers), we don't copy these properties as they
 * cause the sibling to have properties which should be unique to the row.
 *
 * Note that `keyof T` does not include private members of `T`, so these need to be
 * added explicitly to this list. Take care when adding or renaming private properties
 * of `RowNode`.
 */
const IGNORED_SIBLING_PROPERTIES = new Set(['__localEventService', '__objectId', 'sticky', '__autoHeights', '__checkAutoHeightsDebounced', 'childStore']);
function _createRowNodeSibling(rowNode, beans) {
    const sibling = new rowNode_1.RowNode(beans);
    Object.keys(rowNode).forEach((key) => {
        if (IGNORED_SIBLING_PROPERTIES.has(key)) {
            return;
        }
        sibling[key] = rowNode[key];
    });
    // manually set oldRowTop to null so we discard any
    // previous information about its position.
    sibling.oldRowTop = null;
    return sibling;
}
exports._createRowNodeSibling = _createRowNodeSibling;


/***/ }),

/***/ 9024:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Environment = void 0;
const beanStub_1 = __webpack_require__(8731);
const Theme_1 = __webpack_require__(9621);
const inject_1 = __webpack_require__(8951);
const themes_1 = __webpack_require__(2525);
const dom_1 = __webpack_require__(3507);
const logging_1 = __webpack_require__(7764);
const CELL_HORIZONTAL_PADDING = {
    cssName: '--ag-cell-horizontal-padding',
    changeKey: 'cellHorizontalPaddingChanged',
    defaultValue: 16,
};
const INDENTATION_LEVEL = {
    cssName: '--ag-indentation-level',
    changeKey: 'indentationLevelChanged',
    defaultValue: 0,
    noWarn: true,
    cacheDefault: true,
};
const ROW_GROUP_INDENT_SIZE = {
    cssName: '--ag-row-group-indent-size',
    changeKey: 'rowGroupIndentSizeChanged',
    defaultValue: 0,
};
const ROW_HEIGHT = {
    cssName: '--ag-row-height',
    changeKey: 'rowHeightChanged',
    defaultValue: 42,
};
const HEADER_HEIGHT = {
    cssName: '--ag-header-height',
    changeKey: 'headerHeightChanged',
    defaultValue: 48,
};
const LIST_ITEM_HEIGHT = {
    cssName: '--ag-list-item-height',
    changeKey: 'listItemHeightChanged',
    defaultValue: 24,
};
const ROW_BORDER_WIDTH = {
    cssName: '--ag-row-border',
    changeKey: 'rowBorderWidthChanged',
    defaultValue: 1,
    border: true,
};
const PINNED_BORDER_WIDTH = {
    cssName: '--ag-pinned-row-border',
    changeKey: 'pinnedRowBorderWidthChanged',
    defaultValue: 1,
    border: true,
};
let paramsId = 0;
class Environment extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'environment';
        this.sizeEls = new Map();
        this.lastKnownValues = new Map();
        this.sizesMeasured = false;
        this.paramsClass = `ag-theme-params-${++paramsId}`;
        this.globalCSS = [];
    }
    wireBeans(beans) {
        const { eGridDiv, gridOptions } = beans;
        this.eGridDiv = eGridDiv;
        // NOTE: need to use beans.gridOptions because beans.gos not yet initialised
        this.eStyleContainer =
            gridOptions.themeStyleContainer ?? (eGridDiv.getRootNode() === document ? document.head : eGridDiv);
        this.cssLayer = gridOptions.themeCssLayer;
        this.styleNonce = gridOptions.styleNonce;
    }
    postConstruct() {
        this.addManagedPropertyListener('theme', () => this.handleThemeGridOptionChange());
        this.handleThemeGridOptionChange();
        this.addManagedPropertyListener('rowHeight', () => this.refreshRowHeightVariable());
        this.getSizeEl(ROW_HEIGHT);
        this.getSizeEl(HEADER_HEIGHT);
        this.getSizeEl(LIST_ITEM_HEIGHT);
        this.getSizeEl(ROW_BORDER_WIDTH);
        this.getSizeEl(PINNED_BORDER_WIDTH);
        this.refreshRowBorderWidthVariable();
        this.addDestroyFunc(() => (0, inject_1._unregisterGridUsingThemingAPI)(this));
        this.mutationObserver = new MutationObserver(() => {
            this.fireGridStylesChangedEvent('themeChanged');
        });
        this.addDestroyFunc(() => this.mutationObserver.disconnect());
    }
    getPinnedRowBorderWidth() {
        return this.getCSSVariablePixelValue(PINNED_BORDER_WIDTH);
    }
    getRowBorderWidth() {
        return this.getCSSVariablePixelValue(ROW_BORDER_WIDTH);
    }
    getDefaultRowHeight() {
        return this.getCSSVariablePixelValue(ROW_HEIGHT);
    }
    getDefaultHeaderHeight() {
        return this.getCSSVariablePixelValue(HEADER_HEIGHT);
    }
    getDefaultCellHorizontalPadding() {
        return this.getCSSVariablePixelValue(CELL_HORIZONTAL_PADDING);
    }
    getCellPaddingLeft() {
        // calc(var(--ag-cell-horizontal-padding) - 1px + var(--ag-row-group-indent-size)*var(--ag-indentation-level))
        const cellHorizontalPadding = this.getDefaultCellHorizontalPadding();
        const indentationLevel = this.getCSSVariablePixelValue(INDENTATION_LEVEL);
        const rowGroupIndentSize = this.getCSSVariablePixelValue(ROW_GROUP_INDENT_SIZE);
        return cellHorizontalPadding - 1 + rowGroupIndentSize * indentationLevel;
    }
    getCellPadding() {
        const cellPaddingRight = this.getDefaultCellHorizontalPadding() - 1;
        return this.getCellPaddingLeft() + cellPaddingRight;
    }
    getDefaultColumnMinWidth() {
        // This replaces a table of hard-coded defaults for each theme, and is a
        // reasonable default that somewhat approximates the old table. This
        // value only needs to be a non-insane default - Applications are
        // expected to set column-specific defaults based on the icons and
        // header cell text they need to display
        return Math.min(36, this.getDefaultRowHeight());
    }
    getDefaultListItemHeight() {
        return this.getCSSVariablePixelValue(LIST_ITEM_HEIGHT);
    }
    applyThemeClasses(el) {
        const { gridTheme } = this;
        let themeClass = '';
        if (gridTheme) {
            // Theming API mode
            themeClass = `${this.paramsClass} ${gridTheme._getCssClass()}`;
        }
        else {
            // legacy mode
            this.mutationObserver.disconnect();
            let node = this.eGridDiv;
            while (node) {
                let isThemeEl = false;
                for (const className of Array.from(node.classList)) {
                    if (className.startsWith('ag-theme-')) {
                        isThemeEl = true;
                        themeClass = themeClass ? `${themeClass} ${className}` : className;
                    }
                }
                if (isThemeEl) {
                    this.mutationObserver.observe(node, {
                        attributes: true,
                        attributeFilter: ['class'],
                    });
                }
                node = node.parentElement;
            }
        }
        for (const className of Array.from(el.classList)) {
            if (className.startsWith('ag-theme-')) {
                el.classList.remove(className);
            }
        }
        if (themeClass) {
            const oldClass = el.className;
            el.className = oldClass + (oldClass ? ' ' : '') + themeClass;
        }
    }
    refreshRowHeightVariable() {
        const { eGridDiv } = this;
        const oldRowHeight = eGridDiv.style.getPropertyValue('--ag-line-height').trim();
        const height = this.gos.get('rowHeight');
        if (height == null || isNaN(height) || !isFinite(height)) {
            if (oldRowHeight !== null) {
                eGridDiv.style.setProperty('--ag-line-height', null);
            }
            return -1;
        }
        const newRowHeight = `${height}px`;
        if (oldRowHeight != newRowHeight) {
            eGridDiv.style.setProperty('--ag-line-height', newRowHeight);
            return height;
        }
        return oldRowHeight != '' ? parseFloat(oldRowHeight) : -1;
    }
    addGlobalCSS(css, debugId) {
        if (this.gridTheme) {
            (0, inject_1._injectGlobalCSS)(css, this.eStyleContainer, debugId, this.cssLayer, 0, this.styleNonce);
        }
        else {
            this.globalCSS.push([css, debugId]);
        }
    }
    getCSSVariablePixelValue(variable) {
        const cached = this.lastKnownValues.get(variable);
        if (cached != null) {
            return cached;
        }
        const measurement = this.measureSizeEl(variable);
        if (measurement === 'detached' || measurement === 'no-styles') {
            if (variable.cacheDefault) {
                this.lastKnownValues.set(variable, variable.defaultValue);
            }
            return variable.defaultValue;
        }
        this.lastKnownValues.set(variable, measurement);
        return measurement;
    }
    measureSizeEl(variable) {
        const sizeEl = this.getSizeEl(variable);
        if (sizeEl.offsetParent == null) {
            return 'detached';
        }
        const newSize = sizeEl.offsetWidth;
        if (newSize === NO_VALUE_SENTINEL)
            return 'no-styles';
        this.sizesMeasured = true;
        return newSize;
    }
    getMeasurementContainer() {
        let container = this.eMeasurementContainer;
        if (!container) {
            container = this.eMeasurementContainer = (0, dom_1._createElement)({ tag: 'div', cls: 'ag-measurement-container' });
            this.eGridDiv.appendChild(container);
        }
        return container;
    }
    getSizeEl(variable) {
        let sizeEl = this.sizeEls.get(variable);
        if (sizeEl) {
            return sizeEl;
        }
        const container = this.getMeasurementContainer();
        sizeEl = (0, dom_1._createElement)({ tag: 'div' });
        const { border, noWarn } = variable;
        if (border) {
            sizeEl.className = 'ag-measurement-element-border';
            sizeEl.style.setProperty('--ag-internal-measurement-border', `var(${variable.cssName}, solid ${NO_VALUE_SENTINEL}px)`);
        }
        else {
            sizeEl.style.width = `var(${variable.cssName}, ${NO_VALUE_SENTINEL}px)`;
        }
        container.appendChild(sizeEl);
        this.sizeEls.set(variable, sizeEl);
        let lastMeasurement = this.measureSizeEl(variable);
        if (lastMeasurement === 'no-styles' && !noWarn) {
            // No value for the variable
            (0, logging_1._warn)(9, { variable });
        }
        const unsubscribe = (0, dom_1._observeResize)(this.beans, sizeEl, () => {
            const newMeasurement = this.measureSizeEl(variable);
            if (newMeasurement === 'detached' || newMeasurement === 'no-styles') {
                return;
            }
            this.lastKnownValues.set(variable, newMeasurement);
            if (newMeasurement !== lastMeasurement) {
                lastMeasurement = newMeasurement;
                this.fireGridStylesChangedEvent(variable.changeKey);
            }
        });
        this.addDestroyFunc(() => unsubscribe());
        return sizeEl;
    }
    fireGridStylesChangedEvent(change) {
        if (change === 'rowBorderWidthChanged') {
            this.refreshRowBorderWidthVariable();
        }
        this.eventSvc.dispatchEvent({
            type: 'gridStylesChanged',
            [change]: true,
        });
    }
    refreshRowBorderWidthVariable() {
        const width = this.getCSSVariablePixelValue(ROW_BORDER_WIDTH);
        this.eGridDiv.style.setProperty('--ag-internal-row-border-width', `${width}px`);
    }
    handleThemeGridOptionChange() {
        const { gos, eGridDiv, globalCSS, gridTheme: oldGridTheme } = this;
        const themeGridOption = gos.get('theme');
        let newGridTheme;
        if (themeGridOption === 'legacy') {
            newGridTheme = undefined;
        }
        else {
            const themeOrDefault = themeGridOption ?? themes_1.themeQuartz;
            if (themeOrDefault instanceof Theme_1.ThemeImpl) {
                newGridTheme = themeOrDefault;
            }
            else {
                (0, logging_1._error)(240, { theme: themeOrDefault });
            }
        }
        if (newGridTheme !== oldGridTheme) {
            if (newGridTheme) {
                (0, inject_1._registerGridUsingThemingAPI)(this);
                (0, inject_1._injectCoreAndModuleCSS)(this.eStyleContainer, this.cssLayer, this.styleNonce);
                for (const [css, debugId] of globalCSS) {
                    (0, inject_1._injectGlobalCSS)(css, this.eStyleContainer, debugId, this.cssLayer, 0, this.styleNonce);
                }
                globalCSS.length = 0;
            }
            this.gridTheme = newGridTheme;
            newGridTheme?._startUse({
                loadThemeGoogleFonts: gos.get('loadThemeGoogleFonts'),
                styleContainer: this.eStyleContainer,
                cssLayer: this.cssLayer,
                nonce: this.styleNonce,
            });
            let eParamsStyle = this.eParamsStyle;
            if (!eParamsStyle) {
                eParamsStyle = this.eParamsStyle = (0, dom_1._createElement)({ tag: 'style' });
                const styleNonce = this.gos.get('styleNonce');
                if (styleNonce) {
                    eParamsStyle.setAttribute('nonce', styleNonce);
                }
                eGridDiv.appendChild(eParamsStyle);
            }
            if (!inject_1.IS_SSR) {
                eParamsStyle.textContent = newGridTheme?._getPerGridCss(this.paramsClass) || '';
            }
            this.applyThemeClasses(eGridDiv);
            this.fireGridStylesChangedEvent('themeChanged');
        }
        // --ag-legacy-styles-loaded is defined on .ag-measurement-container by the
        // legacy themes which shouldn't be used at the same time as Theming API
        if (newGridTheme &&
            getComputedStyle(this.getMeasurementContainer()).getPropertyValue('--ag-legacy-styles-loaded')) {
            if (themeGridOption) {
                (0, logging_1._error)(106);
            }
            else {
                (0, logging_1._error)(239);
            }
        }
    }
}
exports.Environment = Environment;
const NO_VALUE_SENTINEL = 15538;


/***/ }),

/***/ 8778:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventService = void 0;
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
const localEventService_1 = __webpack_require__(5889);
class EventService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'eventSvc';
        this.globalSvc = new localEventService_1.LocalEventService();
    }
    postConstruct() {
        const { globalListener, globalSyncListener } = this.beans;
        if (globalListener) {
            this.addGlobalListener(globalListener, true);
        }
        if (globalSyncListener) {
            this.addGlobalListener(globalSyncListener, false);
        }
    }
    addEventListener(eventType, listener, async) {
        this.globalSvc.addEventListener(eventType, listener, async);
    }
    removeEventListener(eventType, listener, async) {
        this.globalSvc.removeEventListener(eventType, listener, async);
    }
    addGlobalListener(listener, async = false) {
        this.globalSvc.addGlobalListener(listener, async);
    }
    removeGlobalListener(listener, async = false) {
        this.globalSvc.removeGlobalListener(listener, async);
    }
    /** @deprecated DO NOT FIRE LOCAL EVENTS OFF THE EVENT SERVICE */
    dispatchLocalEvent() {
        // only the destroy event from BeanStub should flow through here
    }
    dispatchEvent(event) {
        this.globalSvc.dispatchEvent((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, event));
    }
    dispatchEventOnce(event) {
        this.globalSvc.dispatchEventOnce((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, event));
    }
}
exports.EventService = EventService;


/***/ }),

/***/ 3080:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._GET_ALL_EVENTS = exports._INTERNAL_EVENTS = exports._PUBLIC_EVENTS = void 0;
// events that are available for use by users of AG Grid and so should be documented
/** EVENTS that should be exposed via code generation for the framework components.  */
exports._PUBLIC_EVENTS = [
    'columnEverythingChanged',
    'newColumnsLoaded',
    'columnPivotModeChanged',
    'pivotMaxColumnsExceeded',
    'columnRowGroupChanged',
    'expandOrCollapseAll',
    'columnPivotChanged',
    'gridColumnsChanged',
    'columnValueChanged',
    'columnMoved',
    'columnVisible',
    'columnPinned',
    'columnGroupOpened',
    'columnResized',
    'displayedColumnsChanged',
    'virtualColumnsChanged',
    'columnHeaderMouseOver',
    'columnHeaderMouseLeave',
    'columnHeaderClicked',
    'columnHeaderContextMenu',
    'asyncTransactionsFlushed',
    'rowGroupOpened',
    'rowDataUpdated',
    'pinnedRowDataChanged',
    'pinnedRowsChanged',
    'rangeSelectionChanged',
    'cellSelectionChanged',
    'chartCreated',
    'chartRangeSelectionChanged',
    'chartOptionsChanged',
    'chartDestroyed',
    'toolPanelVisibleChanged',
    'toolPanelSizeChanged',
    'modelUpdated',
    'cutStart',
    'cutEnd',
    'pasteStart',
    'pasteEnd',
    'fillStart',
    'fillEnd',
    'cellSelectionDeleteStart',
    'cellSelectionDeleteEnd',
    'rangeDeleteStart',
    'rangeDeleteEnd',
    'undoStarted',
    'undoEnded',
    'redoStarted',
    'redoEnded',
    'cellClicked',
    'cellDoubleClicked',
    'cellMouseDown',
    'cellContextMenu',
    'cellValueChanged',
    'cellEditRequest',
    'rowValueChanged',
    'headerFocused',
    'cellFocused',
    'rowSelected',
    'selectionChanged',
    'tooltipShow',
    'tooltipHide',
    'cellKeyDown',
    'cellMouseOver',
    'cellMouseOut',
    'filterChanged',
    'filterModified',
    'filterUiChanged',
    'filterOpened',
    'floatingFilterUiChanged',
    'advancedFilterBuilderVisibleChanged',
    'sortChanged',
    'virtualRowRemoved',
    'rowClicked',
    'rowDoubleClicked',
    'gridReady',
    'gridPreDestroyed',
    'gridSizeChanged',
    'viewportChanged',
    'firstDataRendered',
    'dragStarted',
    'dragStopped',
    'dragCancelled',
    'rowEditingStarted',
    'rowEditingStopped',
    'cellEditingStarted',
    'cellEditingStopped',
    'bodyScroll',
    'bodyScrollEnd',
    'paginationChanged',
    'componentStateChanged',
    'storeRefreshed',
    'stateUpdated',
    'columnMenuVisibleChanged',
    'contextMenuVisibleChanged',
    'rowDragEnter',
    'rowDragMove',
    'rowDragLeave',
    'rowDragEnd',
    'rowDragCancel',
    'findChanged',
    'rowResizeStarted',
    'rowResizeEnded',
    'columnsReset',
];
// events that are internal to AG Grid and should not be exposed to users via documentation or generated framework components
// These events are still available to users via the API if the eventName is cast to any to stop Typescript from complaining, but they are not intended for general use
/** Exclude the following internal events from code generation to prevent exposing these events via framework components */
exports._INTERNAL_EVENTS = [
    'scrollbarWidthChanged',
    'keyShortcutChangedCellStart',
    'keyShortcutChangedCellEnd',
    'pinnedHeightChanged',
    'cellFocusCleared',
    'fullWidthRowFocused',
    'checkboxChanged',
    'heightScaleChanged',
    'suppressMovableColumns',
    'suppressMenuHide',
    'suppressFieldDotNotation',
    'columnPanelItemDragStart',
    'columnPanelItemDragEnd',
    'bodyHeightChanged',
    'columnContainerWidthChanged',
    'displayedColumnsWidthChanged',
    'scrollVisibilityChanged',
    'scrollGapChanged',
    'columnHoverChanged',
    'flashCells',
    'paginationPixelOffsetChanged',
    'displayedRowsChanged',
    'leftPinnedWidthChanged',
    'rightPinnedWidthChanged',
    'rowContainerHeightChanged',
    'headerHeightChanged',
    'columnGroupHeaderHeightChanged',
    'columnHeaderHeightChanged',
    'gridStylesChanged',
    'storeUpdated',
    'filterDestroyed',
    'rowDataUpdateStarted',
    'rowCountReady',
    'advancedFilterEnabledChanged',
    'dataTypesInferred',
    'fieldValueChanged',
    'fieldPickerValueSelected',
    'richSelectListRowSelected',
    'sideBarUpdated',
    'alignedGridScroll',
    'alignedGridColumn',
    'gridOptionsChanged',
    'chartTitleEdit',
    'recalculateRowBounds',
    'stickyTopOffsetChanged',
    'overlayExclusiveChanged',
    'beforeRefreshModel',
    'rowNodeDataChanged',
    'cellEditValuesChanged',
    'filterSwitched',
    'batchEditingStarted',
    'batchEditingStopped',
    'filterClosed',
];
// We define as a callback to help with tree shaking (esbuild)
const _GET_ALL_EVENTS = () => [...exports._PUBLIC_EVENTS, ...exports._INTERNAL_EVENTS];
exports._GET_ALL_EVENTS = _GET_ALL_EVENTS;


/***/ }),

/***/ 7968:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ALWAYS_SYNC_GLOBAL_EVENTS = void 0;
exports.ALWAYS_SYNC_GLOBAL_EVENTS = new Set(['gridPreDestroyed', 'fillStart', 'pasteStart']);


/***/ }),

/***/ 7331:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseCreator = void 0;
const beanStub_1 = __webpack_require__(8731);
class BaseCreator extends beanStub_1.BeanStub {
    getFileName(fileName) {
        const extension = this.getDefaultFileExtension();
        if (fileName == null || !fileName.length) {
            fileName = this.getDefaultFileName();
        }
        return fileName.indexOf('.') === -1 ? `${fileName}.${extension}` : fileName;
    }
    getData(params) {
        const serializingSession = this.createSerializingSession(params);
        return this.beans.gridSerializer.serialize(serializingSession, params);
    }
    getDefaultFileName() {
        return `export.${this.getDefaultFileExtension()}`;
    }
}
exports.BaseCreator = BaseCreator;


/***/ }),

/***/ 8376:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseGridSerializingSession = void 0;
const gridOptionsUtils_1 = __webpack_require__(7274);
class BaseGridSerializingSession {
    constructor(config) {
        const { colModel, rowGroupColsSvc, colNames, valueSvc, gos, processCellCallback, processHeaderCallback, processGroupHeaderCallback, processRowGroupCallback, } = config;
        this.colModel = colModel;
        this.rowGroupColsSvc = rowGroupColsSvc;
        this.colNames = colNames;
        this.valueSvc = valueSvc;
        this.gos = gos;
        this.processCellCallback = processCellCallback;
        this.processHeaderCallback = processHeaderCallback;
        this.processGroupHeaderCallback = processGroupHeaderCallback;
        this.processRowGroupCallback = processRowGroupCallback;
    }
    prepare(_columnsToExport) { }
    extractHeaderValue(column) {
        const value = this.getHeaderName(this.processHeaderCallback, column);
        return value ?? '';
    }
    extractRowCellValue(column, currentColumnIndex, accumulatedRowIndex, type, node) {
        const isFullWidthGroup = currentColumnIndex === 0 && (0, gridOptionsUtils_1._isFullWidthGroupRow)(this.gos, node, this.colModel.isPivotMode());
        if (this.processRowGroupCallback &&
            (this.gos.get('treeData') || node.group) &&
            (column.isRowGroupDisplayed(node.rowGroupColumn?.getColId() ?? '') || isFullWidthGroup)) {
            return { value: this.processRowGroupCallback((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, { column, node })) ?? '' };
        }
        if (this.processCellCallback) {
            return {
                value: this.processCellCallback((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
                    accumulatedRowIndex,
                    column,
                    node,
                    value: this.valueSvc.getValueForDisplay(column, node, undefined, undefined).value,
                    type,
                    parseValue: (valueToParse) => this.valueSvc.parseValue(column, node, valueToParse, this.valueSvc.getValue(column, node, undefined)),
                    formatValue: (valueToFormat) => this.valueSvc.formatValue(column, node, valueToFormat) ?? valueToFormat,
                })) ?? '',
            };
        }
        const isTreeData = this.gos.get('treeData');
        const valueService = this.valueSvc;
        const isGrandTotalRow = node.level === -1 && node.footer;
        const isMultiAutoCol = column.colDef.showRowGroup === true && (node.group || isTreeData);
        // when using single auto group column or group row, create arrow separated string of group vals
        if (!isGrandTotalRow && (isFullWidthGroup || isMultiAutoCol)) {
            let concatenatedGroupValue = '';
            let pointer = node;
            while (pointer && pointer.level !== -1) {
                const { value, valueFormatted } = valueService.getValueForDisplay(isFullWidthGroup ? undefined : column, // full width group doesn't have a column
                pointer, true, true);
                concatenatedGroupValue = ` -> ${valueFormatted ?? value ?? ''}${concatenatedGroupValue}`;
                pointer = pointer.parent;
            }
            return {
                value: concatenatedGroupValue,
                valueFormatted: concatenatedGroupValue,
            };
        }
        const { value, valueFormatted } = valueService.getValueForDisplay(column, node, true, true);
        return {
            value: value ?? '',
            valueFormatted,
        };
    }
    getHeaderName(callback, column) {
        if (callback) {
            return callback((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, { column }));
        }
        return this.colNames.getDisplayNameForColumn(column, 'csv', true);
    }
}
exports.BaseGridSerializingSession = BaseGridSerializingSession;


/***/ }),

/***/ 3885:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._downloadFile = void 0;
const logging_1 = __webpack_require__(7764);
function _downloadFile(fileName, content) {
    const win = document.defaultView || window;
    if (!win) {
        (0, logging_1._warn)(52);
        return;
    }
    const element = document.createElement('a');
    const url = win.URL.createObjectURL(content);
    element.setAttribute('href', url);
    element.setAttribute('download', fileName);
    element.style.display = 'none';
    document.body.appendChild(element);
    element.dispatchEvent(new MouseEvent('click', {
        bubbles: false,
        cancelable: true,
        view: win,
    }));
    document.body.removeChild(element);
    win.setTimeout(() => {
        win.URL.revokeObjectURL(url);
    }, 0);
}
exports._downloadFile = _downloadFile;


/***/ }),

/***/ 2728:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SharedExportModule = void 0;
const version_1 = __webpack_require__(7205);
const gridSerializer_1 = __webpack_require__(826);
// Shared CSV and Excel logic
/**
 * @internal
 */
exports.SharedExportModule = {
    moduleName: 'SharedExport',
    version: version_1.VERSION,
    beans: [gridSerializer_1.GridSerializer],
};


/***/ }),

/***/ 826:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GridSerializer = void 0;
const columnUtils_1 = __webpack_require__(3146);
const groupInstanceIdCreator_1 = __webpack_require__(6034);
const beanStub_1 = __webpack_require__(8731);
const agColumnGroup_1 = __webpack_require__(6908);
const gridOptionsUtils_1 = __webpack_require__(7274);
const array_1 = __webpack_require__(1502);
class GridSerializer extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'gridSerializer';
    }
    wireBeans(beans) {
        this.visibleCols = beans.visibleCols;
        this.colModel = beans.colModel;
        this.rowModel = beans.rowModel;
        this.pinnedRowModel = beans.pinnedRowModel;
    }
    serialize(gridSerializingSession, params = {}) {
        const { allColumns, columnKeys, skipRowGroups, exportRowNumbers } = params;
        const columnsToExport = this.getColumnsToExport({
            allColumns,
            skipRowGroups,
            columnKeys: columnKeys,
            exportRowNumbers,
        });
        return [
            // first pass, put in the header names of the cols
            this.prepareSession(columnsToExport),
            this.prependContent(params),
            this.exportColumnGroups(params, columnsToExport),
            this.exportHeaders(params, columnsToExport),
            this.processPinnedTopRows(params, columnsToExport),
            this.processRows(params, columnsToExport),
            this.processPinnedBottomRows(params, columnsToExport),
            this.appendContent(params),
        ]
            .reduce((composed, f) => f(composed), gridSerializingSession)
            .parse();
    }
    processRow(gridSerializingSession, params, columnsToExport, node) {
        const rowSkipper = params.shouldRowBeSkipped || (() => false);
        // if onlySelected, we ignore groupHideOpenParents as the user has explicitly selected the rows they wish to export.
        // similarly, if specific rowNodes are provided we do the same. (the clipboard service uses rowNodes to define which rows to export)
        const isClipboardExport = params.rowPositions != null;
        const isExplicitExportSelection = isClipboardExport || !!params.onlySelected;
        const hideOpenParents = this.gos.get('groupHideOpenParents') && !isExplicitExportSelection;
        const isLeafNode = this.colModel.isPivotMode() ? node.leafGroup : !node.group;
        const isFooter = !!node.footer;
        const shouldSkipCurrentGroup = node.allChildrenCount === 1 &&
            node.childrenAfterGroup?.length === 1 &&
            (0, gridOptionsUtils_1._canSkipShowingRowGroup)(this.gos, node);
        if ((!isLeafNode && !isFooter && (params.skipRowGroups || shouldSkipCurrentGroup || hideOpenParents)) ||
            (params.onlySelected && !node.isSelected()) ||
            (params.skipPinnedTop && node.rowPinned === 'top') ||
            (params.skipPinnedBottom && node.rowPinned === 'bottom') ||
            node.stub // skip SSRM stub/loading rows
        ) {
            return;
        }
        // if we are in pivotMode, then the grid will show the root node only
        // if it's not a leaf group
        const nodeIsRootNode = node.level === -1;
        if (nodeIsRootNode && !isLeafNode && !isFooter) {
            return;
        }
        const shouldRowBeSkipped = rowSkipper((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, { node }));
        if (shouldRowBeSkipped) {
            return;
        }
        const rowAccumulator = gridSerializingSession.onNewBodyRow(node);
        columnsToExport.forEach((column, index) => {
            rowAccumulator.onColumn(column, index, node);
        });
        if (params.getCustomContentBelowRow) {
            const content = params.getCustomContentBelowRow((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, { node }));
            if (content) {
                gridSerializingSession.addCustomContent(content);
            }
        }
    }
    appendContent(params) {
        return (gridSerializingSession) => {
            const appendContent = params.appendContent;
            if (appendContent) {
                gridSerializingSession.addCustomContent(appendContent);
            }
            return gridSerializingSession;
        };
    }
    prependContent(params) {
        return (gridSerializingSession) => {
            const prependContent = params.prependContent;
            if (prependContent) {
                gridSerializingSession.addCustomContent(prependContent);
            }
            return gridSerializingSession;
        };
    }
    prepareSession(columnsToExport) {
        return (gridSerializingSession) => {
            gridSerializingSession.prepare(columnsToExport);
            return gridSerializingSession;
        };
    }
    exportColumnGroups(params, columnsToExport) {
        return (gridSerializingSession) => {
            if (!params.skipColumnGroupHeaders) {
                const idCreator = new groupInstanceIdCreator_1.GroupInstanceIdCreator();
                const { colGroupSvc } = this.beans;
                const displayedGroups = colGroupSvc
                    ? colGroupSvc.createColumnGroups({
                        columns: columnsToExport,
                        idCreator,
                        pinned: null,
                        isStandaloneStructure: true,
                    })
                    : columnsToExport;
                this.recursivelyAddHeaderGroups(displayedGroups, gridSerializingSession, params.processGroupHeaderCallback);
            }
            return gridSerializingSession;
        };
    }
    exportHeaders(params, columnsToExport) {
        return (gridSerializingSession) => {
            if (!params.skipColumnHeaders) {
                const gridRowIterator = gridSerializingSession.onNewHeaderRow();
                columnsToExport.forEach((column, index) => {
                    gridRowIterator.onColumn(column, index, undefined);
                });
            }
            return gridSerializingSession;
        };
    }
    processPinnedTopRows(params, columnsToExport) {
        return (gridSerializingSession) => {
            const processRow = this.processRow.bind(this, gridSerializingSession, params, columnsToExport);
            if (params.rowPositions) {
                params.rowPositions
                    // only pinnedTop rows, other models are processed by `processRows` and `processPinnedBottomsRows`
                    .filter((position) => position.rowPinned === 'top')
                    .sort((a, b) => a.rowIndex - b.rowIndex)
                    .map((position) => this.pinnedRowModel?.getPinnedTopRow(position.rowIndex))
                    .forEach(processRow);
            }
            else if (!this.pinnedRowModel?.isManual()) {
                // only process pinned rows if they are statically pinned
                this.pinnedRowModel?.forEachPinnedRow('top', processRow);
            }
            return gridSerializingSession;
        };
    }
    processRows(params, columnsToExport) {
        return (gridSerializingSession) => {
            // when in pivot mode, we always render cols on screen, never 'all columns'
            const rowModel = this.rowModel;
            const usingCsrm = (0, gridOptionsUtils_1._isClientSideRowModel)(this.gos, rowModel);
            const usingSsrm = (0, gridOptionsUtils_1._isServerSideRowModel)(this.gos, rowModel);
            const onlySelectedNonStandardModel = !usingCsrm && params.onlySelected;
            const processRow = this.processRow.bind(this, gridSerializingSession, params, columnsToExport);
            const { exportedRows = 'filteredAndSorted' } = params;
            if (params.rowPositions) {
                params.rowPositions
                    // pinnedRows are processed by `processPinnedTopRows` and `processPinnedBottomsRows`
                    .filter((position) => position.rowPinned == null)
                    .sort((a, b) => a.rowIndex - b.rowIndex)
                    .map((position) => rowModel.getRow(position.rowIndex))
                    .forEach(processRow);
                return gridSerializingSession;
            }
            if (this.colModel.isPivotMode()) {
                if (usingCsrm) {
                    rowModel.forEachPivotNode(processRow, true, exportedRows === 'filteredAndSorted');
                }
                else if (usingSsrm) {
                    rowModel.forEachNodeAfterFilterAndSort(processRow, true);
                }
                else {
                    // must be enterprise, so we can just loop through all the nodes
                    rowModel.forEachNode(processRow);
                }
                return gridSerializingSession;
            }
            // onlySelectedAllPages: user doing pagination and wants selected items from
            // other pages, so cannot use the standard row model as it won't have rows from
            // other pages.
            // onlySelectedNonStandardModel: if user wants selected in non standard row model
            // (eg viewport) then again RowModel cannot be used, so need to use selected instead.
            if (params.onlySelectedAllPages || onlySelectedNonStandardModel) {
                const selectedNodes = this.beans.selectionSvc?.getSelectedNodes() ?? [];
                this.replicateSortedOrder(selectedNodes);
                // serialize each node
                selectedNodes.forEach(processRow);
            }
            else {
                // here is everything else - including standard row model and selected. we don't use
                // the selection model even when just using selected, so that the result is the order
                // of the rows appearing on the screen.
                if (exportedRows === 'all') {
                    rowModel.forEachNode(processRow);
                }
                else if (usingCsrm || usingSsrm) {
                    rowModel.forEachNodeAfterFilterAndSort(processRow, true);
                }
                else {
                    rowModel.forEachNode(processRow);
                }
            }
            return gridSerializingSession;
        };
    }
    replicateSortedOrder(rows) {
        const { sortSvc, rowNodeSorter } = this.beans;
        if (!sortSvc || !rowNodeSorter) {
            return;
        }
        const sortOptions = sortSvc.getSortOptions();
        const compareNodes = (rowA, rowB) => {
            if (rowA.rowIndex != null && rowB.rowIndex != null) {
                // if the rows have rowIndexes, this is the easiest way to compare,
                // as they're already ordered
                return rowA.rowIndex - rowB.rowIndex;
            }
            // if the level is the same, compare these nodes, or their parents
            if (rowA.level === rowB.level) {
                if (rowA.parent?.id === rowB.parent?.id) {
                    return rowNodeSorter.compareRowNodes(sortOptions, {
                        rowNode: rowA,
                        currentPos: rowA.rowIndex ?? -1,
                    }, {
                        rowNode: rowB,
                        currentPos: rowB.rowIndex ?? -1,
                    });
                }
                // level is same, but parent isn't, compare parents
                return compareNodes(rowA.parent, rowB.parent);
            }
            // if level is different, match levels
            if (rowA.level > rowB.level) {
                return compareNodes(rowA.parent, rowB);
            }
            return compareNodes(rowA, rowB.parent);
        };
        // sort the nodes either by existing row index or compare them
        rows.sort(compareNodes);
    }
    processPinnedBottomRows(params, columnsToExport) {
        return (gridSerializingSession) => {
            const processRow = this.processRow.bind(this, gridSerializingSession, params, columnsToExport);
            if (params.rowPositions) {
                params.rowPositions
                    // only pinnedBottom rows, other models are processed by `processRows` and `processPinnedTopRows`
                    .filter((position) => position.rowPinned === 'bottom')
                    .sort((a, b) => a.rowIndex - b.rowIndex)
                    .map((position) => this.pinnedRowModel?.getPinnedBottomRow(position.rowIndex))
                    .forEach(processRow);
            }
            else if (!this.pinnedRowModel?.isManual()) {
                // only process pinned rows if they are statically pinned
                this.pinnedRowModel?.forEachPinnedRow('bottom', processRow);
            }
            return gridSerializingSession;
        };
    }
    getColumnsToExport(params) {
        const { allColumns = false, skipRowGroups = false, exportRowNumbers = false, columnKeys } = params;
        const { colModel, gos, visibleCols } = this;
        const isPivotMode = colModel.isPivotMode();
        const filterSpecialColumns = (col) => {
            if ((0, columnUtils_1.isColumnSelectionCol)(col)) {
                return false;
            }
            return !(0, columnUtils_1.isRowNumberCol)(col) || exportRowNumbers;
        };
        if (columnKeys && columnKeys.length) {
            return colModel.getColsForKeys(columnKeys).filter(filterSpecialColumns);
        }
        const isTreeData = gos.get('treeData');
        let columnsToExport = [];
        if (allColumns && !isPivotMode) {
            columnsToExport = colModel.getCols();
        }
        else {
            columnsToExport = visibleCols.allCols;
        }
        columnsToExport = columnsToExport.filter((column) => filterSpecialColumns(column) && (skipRowGroups && !isTreeData ? !(0, columnUtils_1.isColumnGroupAutoCol)(column) : true));
        return columnsToExport;
    }
    recursivelyAddHeaderGroups(displayedGroups, gridSerializingSession, processGroupHeaderCallback) {
        const directChildrenHeaderGroups = [];
        displayedGroups.forEach((columnGroupChild) => {
            const columnGroup = columnGroupChild;
            if (!columnGroup.getChildren) {
                return;
            }
            columnGroup.getChildren().forEach((it) => directChildrenHeaderGroups.push(it));
        });
        if (displayedGroups.length > 0 && (0, agColumnGroup_1.isColumnGroup)(displayedGroups[0])) {
            this.doAddHeaderHeader(gridSerializingSession, displayedGroups, processGroupHeaderCallback);
        }
        if (directChildrenHeaderGroups && directChildrenHeaderGroups.length > 0) {
            this.recursivelyAddHeaderGroups(directChildrenHeaderGroups, gridSerializingSession, processGroupHeaderCallback);
        }
    }
    doAddHeaderHeader(gridSerializingSession, displayedGroups, processGroupHeaderCallback) {
        const gridRowIterator = gridSerializingSession.onNewHeaderGroupingRow();
        let columnIndex = 0;
        displayedGroups.forEach((columnGroupChild) => {
            const columnGroup = columnGroupChild;
            let name;
            if (processGroupHeaderCallback) {
                name = processGroupHeaderCallback((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
                    columnGroup: columnGroup,
                }));
            }
            else {
                name = this.beans.colNames.getDisplayNameForColumnGroup(columnGroup, 'header');
            }
            const collapsibleGroupRanges = columnGroup
                .getLeafColumns()
                .reduce((collapsibleGroups, currentColumn, currentIdx, arr) => {
                let lastGroup = (0, array_1._last)(collapsibleGroups);
                const groupShow = currentColumn.getColumnGroupShow() === 'open';
                if (!groupShow) {
                    if (lastGroup && lastGroup[1] == null) {
                        lastGroup[1] = currentIdx - 1;
                    }
                }
                else if (!lastGroup || lastGroup[1] != null) {
                    lastGroup = [currentIdx];
                    collapsibleGroups.push(lastGroup);
                }
                if (currentIdx === arr.length - 1 && lastGroup && lastGroup[1] == null) {
                    lastGroup[1] = currentIdx;
                }
                return collapsibleGroups;
            }, []);
            gridRowIterator.onColumn(columnGroup, name || '', columnIndex++, columnGroup.getLeafColumns().length - 1, collapsibleGroupRanges);
        });
    }
}
exports.GridSerializer = GridSerializer;


/***/ }),

/***/ 6331:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.columnFiltersCSS = void 0;
exports.columnFiltersCSS = `.ag-set-filter{--ag-indentation-level:0}.ag-set-filter-item{align-items:center;display:flex;height:100%}:where(.ag-ltr) .ag-set-filter-item{padding-left:calc(var(--ag-widget-container-horizontal-padding) + var(--ag-indentation-level)*var(--ag-set-filter-indent-size))}:where(.ag-rtl) .ag-set-filter-item{padding-right:calc(var(--ag-widget-container-horizontal-padding) + var(--ag-indentation-level)*var(--ag-set-filter-indent-size))}.ag-set-filter-item-checkbox{display:flex;height:100%;width:100%}.ag-set-filter-group-icons{display:block;>*{cursor:pointer}}:where(.ag-ltr) .ag-set-filter-group-icons{margin-right:var(--ag-widget-container-horizontal-padding)}:where(.ag-rtl) .ag-set-filter-group-icons{margin-left:var(--ag-widget-container-horizontal-padding)}.ag-filter-body-wrapper{display:flex;flex-direction:column}:where(.ag-menu:not(.ag-tabs) .ag-filter) .ag-filter-body-wrapper,:where(.ag-menu:not(.ag-tabs) .ag-filter)>:not(.ag-filter-wrapper){min-width:180px}.ag-filter-filter{flex:1 1 0px}.ag-filter-condition{display:flex;justify-content:center}.ag-floating-filter-body{display:flex;flex:1 1 auto;height:100%;position:relative}.ag-floating-filter-full-body{align-items:center;display:flex;flex:1 1 auto;height:100%;overflow:hidden;width:100%}:where(.ag-floating-filter-full-body)>div{flex:1 1 auto}.ag-floating-filter-input{align-items:center;display:flex;width:100%;>*{flex:1 1 auto}:where(.ag-input-field-input[type=date]),:where(.ag-input-field-input[type=datetime-local]){width:1px}}.ag-floating-filter-button{display:flex;flex:none}.ag-date-floating-filter-wrapper{display:flex}.ag-set-floating-filter-input :where(input)[disabled]{pointer-events:none}.ag-floating-filter-button-button{-webkit-appearance:none;-moz-appearance:none;appearance:none;border:none;height:var(--ag-icon-size);width:var(--ag-icon-size)}.ag-filter-loading{align-items:unset;background-color:var(--ag-chrome-background-color);height:100%;padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);position:absolute;width:100%;z-index:1;:where(.ag-menu) &{background-color:var(--ag-menu-background-color)}}.ag-filter-separator{border-top:solid var(--ag-border-width) var(--menu-separator-color)}:where(.ag-filter-select) .ag-picker-field-wrapper{width:0}.ag-filter-condition-operator{height:17px}:where(.ag-ltr) .ag-filter-condition-operator-or{margin-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-filter-condition-operator-or{margin-right:calc(var(--ag-spacing)*2)}.ag-set-filter-select-all{padding-top:var(--ag-widget-container-vertical-padding)}.ag-filter-no-matches,.ag-set-filter-list{height:calc(var(--ag-list-item-height)*6)}.ag-filter-no-matches{padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding)}.ag-set-filter-tree-list{height:calc(var(--ag-list-item-height)*10)}.ag-set-filter-filter{margin-left:var(--ag-widget-container-horizontal-padding);margin-right:var(--ag-widget-container-horizontal-padding);margin-top:var(--ag-widget-container-vertical-padding)}.ag-filter-to{margin-top:var(--ag-widget-vertical-spacing)}.ag-mini-filter{margin:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding)}:where(.ag-ltr) .ag-set-filter-add-group-indent{margin-left:calc(var(--ag-icon-size) + var(--ag-widget-container-horizontal-padding))}:where(.ag-rtl) .ag-set-filter-add-group-indent{margin-right:calc(var(--ag-icon-size) + var(--ag-widget-container-horizontal-padding))}:where(.ag-filter-menu) .ag-set-filter-list{min-width:200px}.ag-filter-virtual-list-item:focus-visible{box-shadow:inset var(--ag-focus-shadow)}.ag-filter-apply-panel{display:flex;justify-content:flex-end;overflow:hidden;padding:var(--ag-widget-vertical-spacing) var(--ag-widget-container-horizontal-padding) var(--ag-widget-container-vertical-padding)}.ag-filter-apply-panel-button{line-height:1.5}:where(.ag-ltr) .ag-filter-apply-panel-button{margin-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-filter-apply-panel-button{margin-right:calc(var(--ag-spacing)*2)}.ag-simple-filter-body-wrapper{display:flex;flex-direction:column;min-height:calc(var(--ag-list-item-height) + var(--ag-widget-container-vertical-padding) + var(--ag-widget-vertical-spacing));overflow-y:auto;padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);padding-bottom:calc(var(--ag-widget-container-vertical-padding) - var(--ag-widget-vertical-spacing));&>*{margin-bottom:var(--ag-widget-vertical-spacing)}:where(.ag-resizer-wrapper){margin:0}}.ag-multi-filter-menu-item{margin:var(--ag-spacing) 0}.ag-multi-filter-group-title-bar{background-color:transparent;color:var(--ag-header-text-color);font-weight:500;padding:calc(var(--ag-spacing)*1.5) var(--ag-spacing)}.ag-group-filter-field-select-wrapper{display:flex;flex-direction:column;gap:var(--ag-widget-vertical-spacing);padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding)}`;


/***/ }),

/***/ 4527:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.doFilterAction = exports.getColumnFilterHandler = exports.showColumnFilter = exports.setColumnFilterModel = exports.getColumnFilterModel = exports.getFilterModel = exports.setFilterModel = exports.destroyFilter = exports.getColumnFilterInstance = exports.isColumnFilterPresent = void 0;
const logging_1 = __webpack_require__(7764);
function isColumnFilterPresent(beans) {
    const filterManager = beans.filterManager;
    return !!filterManager?.isColumnFilterPresent() || !!filterManager?.isAggregateFilterPresent();
}
exports.isColumnFilterPresent = isColumnFilterPresent;
function getColumnFilterInstance(beans, key) {
    return (beans.filterManager?.getColumnFilterInstance(key) ?? Promise.resolve(undefined));
}
exports.getColumnFilterInstance = getColumnFilterInstance;
function destroyFilter(beans, key) {
    const column = beans.colModel.getColDefCol(key);
    if (column) {
        return beans.colFilter?.destroyFilter(column, 'api');
    }
}
exports.destroyFilter = destroyFilter;
function setFilterModel(beans, model) {
    beans.frameworkOverrides.wrapIncoming(() => beans.filterManager?.setFilterModel(model));
}
exports.setFilterModel = setFilterModel;
function getFilterModel(beans) {
    return beans.filterManager?.getFilterModel() ?? {};
}
exports.getFilterModel = getFilterModel;
function getColumnFilterModel(beans, key, useUnapplied) {
    const { gos, colModel, colFilter } = beans;
    if (useUnapplied && !gos.get('enableFilterHandlers')) {
        (0, logging_1._warn)(288);
        useUnapplied = false;
    }
    const column = colModel.getColDefCol(key);
    return column ? colFilter?.getModelForColumn(column, useUnapplied) ?? null : null;
}
exports.getColumnFilterModel = getColumnFilterModel;
function setColumnFilterModel(beans, column, model) {
    return beans.filterManager?.setColumnFilterModel(column, model) ?? Promise.resolve();
}
exports.setColumnFilterModel = setColumnFilterModel;
function showColumnFilter(beans, colKey) {
    const column = beans.colModel.getCol(colKey);
    if (!column) {
        // Column not found, can't show filter
        (0, logging_1._error)(12, { colKey });
        return;
    }
    beans.menuSvc?.showFilterMenu({
        column,
        containerType: 'columnFilter',
        positionBy: 'auto',
    });
}
exports.showColumnFilter = showColumnFilter;
function getColumnFilterHandler(beans, colKey) {
    const column = beans.colModel.getCol(colKey);
    if (!column) {
        // Column not found, can't show filter
        (0, logging_1._error)(12, { colKey });
        return undefined;
    }
    return beans.colFilter?.getHandler(column, true);
}
exports.getColumnFilterHandler = getColumnFilterHandler;
function doFilterAction(beans, params) {
    const { colModel, colFilter, gos } = beans;
    if (!gos.get('enableFilterHandlers')) {
        (0, logging_1._warn)(287);
        return;
    }
    const { colId, action } = params;
    if (colId) {
        const column = colModel.getColById(colId);
        if (column) {
            colFilter?.updateModel(column, action);
        }
    }
    else {
        colFilter?.updateAllModels(action);
    }
}
exports.doFilterAction = doFilterAction;


/***/ }),

/***/ 219:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnFilterService = void 0;
const unwrapUserComp_1 = __webpack_require__(4126);
const userCompUtils_1 = __webpack_require__(2036);
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
const iFilter_1 = __webpack_require__(5679);
const generic_1 = __webpack_require__(4422);
const promise_1 = __webpack_require__(7990);
const logging_1 = __webpack_require__(7764);
const columnFilterUtils_1 = __webpack_require__(4985);
const filterDataTypeUtils_1 = __webpack_require__(6771);
const floatingFilterMapper_1 = __webpack_require__(9990);
/** Used for non-CSRM handlers */
const DUMMY_HANDLER = {
    filterHandler: () => ({
        doesFilterPass: () => true,
    }),
};
class ColumnFilterService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colFilter';
        this.allColumnFilters = new Map();
        this.allColumnListeners = new Map();
        this.activeAggregateFilters = [];
        this.activeColumnFilters = [];
        // this is true when the grid is processing the filter change. this is used by the cell comps, so that they
        // don't flash when data changes due to filter changes. there is no need to flash when filter changes as the
        // user is in control, so doesn't make sense to show flashing changes. for example, go to main demo where
        // this feature is turned off (hack code to always return false for isSuppressFlashingCellsBecauseFiltering(), put in)
        // 100,000 rows and group by country. then do some filtering. all the cells flash, which is silly.
        this.processingFilterChange = false;
        // when we're waiting for cell data types to be inferred, we need to defer filter model updates
        this.modelUpdates = [];
        this.columnModelUpdates = [];
        /** This contains the UI state for handler columns */
        this.state = new Map();
        this.handlerMap = {
            ...columnFilterUtils_1.FILTER_HANDLER_MAP,
        };
        this.isGlobalButtons = false;
        this.activeFilterComps = new Set();
    }
    postConstruct() {
        this.addManagedEventListeners({
            gridColumnsChanged: this.onColumnsChanged.bind(this),
            beforeRefreshModel: ({ params, groupsChanged }) => {
                // We listen to both row data updated and treeData changed as the SetFilter needs it
                if (groupsChanged || params.rowDataUpdated) {
                    this.onNewRowsLoaded('rowDataUpdated');
                }
            },
            dataTypesInferred: this.processFilterModelUpdateQueue.bind(this),
        });
        const gos = this.gos;
        const initialFilterModel = {
            ...(gos.get('initialState')?.filter?.filterModel ?? {}),
        };
        this.initialModel = initialFilterModel;
        this.model = {
            ...initialFilterModel,
        };
        if (!gos.get('enableFilterHandlers')) {
            delete this.handlerMap['agMultiColumnFilter'];
        }
    }
    setModel(model, source = 'api') {
        const { colModel, dataTypeSvc, filterManager } = this.beans;
        if (dataTypeSvc?.isPendingInference) {
            this.modelUpdates.push({ model, source });
            return;
        }
        const allPromises = [];
        const previousModel = this.getModel(true);
        if (model) {
            // mark the filters as we set them, so any active filters left over we stop
            const modelKeys = new Set(Object.keys(model));
            this.allColumnFilters.forEach((filterWrapper, colId) => {
                const newModel = model[colId];
                allPromises.push(this.setModelOnFilterWrapper(filterWrapper, newModel));
                modelKeys.delete(colId);
            });
            // at this point, processedFields contains data for which we don't have a filter working yet
            modelKeys.forEach((colId) => {
                const column = colModel.getColDefCol(colId) || colModel.getCol(colId);
                if (!column) {
                    (0, logging_1._warn)(62, { colId });
                    return;
                }
                if (!column.isFilterAllowed()) {
                    (0, logging_1._warn)(63, { colId });
                    return;
                }
                const filterWrapper = this.getOrCreateFilterWrapper(column, true);
                if (!filterWrapper) {
                    (0, logging_1._warn)(64, { colId });
                    return;
                }
                allPromises.push(this.setModelOnFilterWrapper(filterWrapper, model[colId], true));
            });
        }
        else {
            this.model = {};
            this.allColumnFilters.forEach((filterWrapper) => {
                allPromises.push(this.setModelOnFilterWrapper(filterWrapper, null));
            });
        }
        promise_1.AgPromise.all(allPromises).then(() => {
            const currentModel = this.getModel(true);
            const columns = [];
            this.allColumnFilters.forEach((filterWrapper, colId) => {
                const before = previousModel ? previousModel[colId] : null;
                const after = currentModel ? currentModel[colId] : null;
                if (!(0, generic_1._jsonEquals)(before, after)) {
                    columns.push(filterWrapper.column);
                }
            });
            if (columns.length > 0) {
                filterManager?.onFilterChanged({ columns, source });
            }
        });
    }
    getModel(excludeInitialState) {
        const result = {};
        const { allColumnFilters, initialModel, beans: { colModel }, } = this;
        allColumnFilters.forEach((filterWrapper, key) => {
            const model = this.getModelFromFilterWrapper(filterWrapper);
            if ((0, generic_1._exists)(model)) {
                result[key] = model;
            }
        });
        if (!excludeInitialState) {
            for (const colId of Object.keys(initialModel)) {
                const model = initialModel[colId];
                if ((0, generic_1._exists)(model) && !allColumnFilters.has(colId) && colModel.getCol(colId)?.isFilterAllowed()) {
                    result[colId] = model;
                }
            }
        }
        return result;
    }
    setState(model, state, source = 'api') {
        this.state.clear();
        if (state) {
            for (const colId of Object.keys(state)) {
                const newState = state[colId];
                this.state.set(colId, {
                    model: (0, columnFilterUtils_1._getFilterModel)(this.model, colId),
                    state: newState,
                });
            }
        }
        this.setModel(model, source);
    }
    getState() {
        const state = this.state;
        if (!state.size) {
            return undefined;
        }
        const newState = {};
        let hasNewState = false;
        state.forEach((colState, colId) => {
            const actualState = colState.state;
            if (actualState != null) {
                hasNewState = true;
                newState[colId] = actualState;
            }
        });
        return hasNewState ? newState : undefined;
    }
    getModelFromFilterWrapper(filterWrapper) {
        const column = filterWrapper.column;
        const colId = column.getColId();
        if (filterWrapper.isHandler) {
            return (0, columnFilterUtils_1._getFilterModel)(this.model, colId);
        }
        const filter = filterWrapper.filter;
        if (filter) {
            if (typeof filter.getModel !== 'function') {
                (0, logging_1._warn)(66);
                return null;
            }
            return filter.getModel();
        }
        // filter still being created. return initial state if it exists and hasn't been applied yet
        return (0, columnFilterUtils_1._getFilterModel)(this.initialModel, colId);
    }
    isFilterPresent() {
        return this.activeColumnFilters.length > 0;
    }
    isAggFilterPresent() {
        return !!this.activeAggregateFilters.length;
    }
    disableFilters() {
        this.initialModel = {};
        const { allColumnFilters } = this;
        if (allColumnFilters.size) {
            allColumnFilters.forEach((filterWrapper) => this.disposeFilterWrapper(filterWrapper, 'advancedFilterEnabled'));
            return true;
        }
        return false;
    }
    updateActiveFilters() {
        const isFilterActive = (filter) => {
            if (!filter) {
                return false;
            } // this never happens, including to avoid compile error
            if (!filter.isFilterActive) {
                (0, logging_1._warn)(67);
                return false;
            }
            return filter.isFilterActive();
        };
        const { colModel, gos } = this.beans;
        const groupFilterEnabled = !!(0, gridOptionsUtils_1._getGroupAggFiltering)(gos);
        const isAggFilter = (column) => {
            const isSecondary = !column.isPrimary();
            // the only filters that can appear on secondary columns are groupAgg filters
            if (isSecondary) {
                return true;
            }
            const isShowingPrimaryColumns = !colModel.isPivotActive();
            const isValueActive = column.isValueActive();
            // primary columns are only ever groupAgg filters if a) value is active and b) showing primary columns
            if (!isValueActive || !isShowingPrimaryColumns) {
                return false;
            }
            // from here on we know: isPrimary=true, isValueActive=true, isShowingPrimaryColumns=true
            if (colModel.isPivotMode()) {
                // primary column is pretending to be a pivot column, ie pivotMode=true, but we are
                // still showing primary columns
                return true;
            }
            // we are not pivoting, so we groupFilter when it's an agg column
            return groupFilterEnabled;
        };
        const activeAggregateFilters = [];
        const activeColumnFilters = [];
        const addFilter = (column, filterActive, doesFilterPassWrapper) => {
            if (filterActive) {
                if (isAggFilter(column)) {
                    activeAggregateFilters.push(doesFilterPassWrapper);
                }
                else {
                    activeColumnFilters.push(doesFilterPassWrapper);
                }
            }
        };
        const promises = [];
        this.allColumnFilters.forEach((filterWrapper) => {
            const column = filterWrapper.column;
            const colId = column.getColId();
            if (filterWrapper.isHandler) {
                promises.push(promise_1.AgPromise.resolve().then(() => {
                    addFilter(column, this.isHandlerActive(column), {
                        colId,
                        isHandler: true,
                        handler: filterWrapper.handler,
                        handlerParams: filterWrapper.handlerParams,
                    });
                }));
            }
            else {
                const promise = (0, columnFilterUtils_1.getFilterUiFromWrapper)(filterWrapper);
                if (promise) {
                    promises.push(promise.then((filter) => {
                        addFilter(column, isFilterActive(filter), {
                            colId,
                            isHandler: false,
                            comp: filter,
                        });
                    }));
                }
            }
        });
        return promise_1.AgPromise.all(promises).then(() => {
            this.activeAggregateFilters = activeAggregateFilters;
            this.activeColumnFilters = activeColumnFilters;
        });
    }
    updateFilterFlagInColumns(source, additionalEventAttributes) {
        const promises = [];
        this.allColumnFilters.forEach((filterWrapper) => {
            const column = filterWrapper.column;
            if (filterWrapper.isHandler) {
                promises.push(promise_1.AgPromise.resolve().then(() => {
                    this.setColFilterActive(column, this.isHandlerActive(column), source, additionalEventAttributes);
                }));
            }
            else {
                const promise = (0, columnFilterUtils_1.getFilterUiFromWrapper)(filterWrapper);
                if (promise) {
                    promises.push(promise.then((filter) => {
                        this.setColFilterActive(column, filter.isFilterActive(), source, additionalEventAttributes);
                    }));
                }
            }
        });
        this.beans.groupFilter?.updateFilterFlags(source, additionalEventAttributes);
        return promise_1.AgPromise.all(promises);
    }
    doFiltersPass(node, colIdToSkip, targetAggregates) {
        const { data, aggData } = node;
        const targetedFilters = targetAggregates ? this.activeAggregateFilters : this.activeColumnFilters;
        const targetedData = targetAggregates ? aggData : data;
        const model = this.model;
        for (let i = 0; i < targetedFilters.length; i++) {
            const filter = targetedFilters[i];
            const { colId, isHandler } = filter;
            if (colId === colIdToSkip) {
                continue;
            }
            if (isHandler) {
                const { handler, handlerParams } = filter;
                if (!handler.doesFilterPass({
                    node,
                    data: targetedData,
                    model: (0, columnFilterUtils_1._getFilterModel)(model, colId),
                    handlerParams,
                })) {
                    return false;
                }
            }
            else {
                const comp = filter.comp;
                if (typeof comp.doesFilterPass !== 'function') {
                    // because users can do custom filters, give nice error message
                    (0, logging_1._error)(91);
                    continue;
                }
                if (!comp.doesFilterPass({ node, data: targetedData })) {
                    return false;
                }
            }
        }
        return true;
    }
    getHandlerParams(column) {
        const wrapper = this.allColumnFilters.get(column.getColId());
        return wrapper?.isHandler ? wrapper.handlerParams : undefined;
    }
    // sometimes (especially in React) the filter can call onFilterChanged when we are in the middle
    // of a render cycle. this would be bad, so we wait for render cycle to complete when this happens.
    // this happens in react when we change React State in the grid (eg setting RowCtrl's in RowContainer)
    // which results in React State getting applied in the main application, triggering a useEffect() to
    // be kicked off adn then the application calling the grid's API. in AG-6554, the custom filter was
    // getting it's useEffect() triggered in this way.
    callOnFilterChangedOutsideRenderCycle(params) {
        const { rowRenderer, filterManager } = this.beans;
        const action = () => {
            if (this.isAlive()) {
                filterManager?.onFilterChanged(params);
            }
        };
        if (rowRenderer.isRefreshInProgress()) {
            setTimeout(action, 0);
        }
        else {
            action();
        }
    }
    updateBeforeFilterChanged(params = {}) {
        const { column, additionalEventAttributes } = params;
        const colId = column?.getColId();
        return this.updateActiveFilters().then(() => this.updateFilterFlagInColumns('filterChanged', additionalEventAttributes).then(() => {
            this.allColumnFilters.forEach((filterWrapper) => {
                const { column: filterColumn, isHandler } = filterWrapper;
                if (colId === filterColumn.getColId()) {
                    return;
                }
                if (isHandler) {
                    filterWrapper.handler.onAnyFilterChanged?.();
                }
                (0, columnFilterUtils_1.getFilterUiFromWrapper)(filterWrapper, isHandler)?.then((filter) => {
                    if (typeof filter?.onAnyFilterChanged === 'function') {
                        filter.onAnyFilterChanged();
                    }
                });
            });
            // because internal events are not async in ag-grid, when the dispatchEvent
            // method comes back, we know all listeners have finished executing.
            this.processingFilterChange = true;
        }));
    }
    updateAfterFilterChanged() {
        this.processingFilterChange = false;
    }
    isSuppressFlashingCellsBecauseFiltering() {
        // if user has elected to always flash cell changes, then always return false, otherwise we suppress flashing
        // changes when filtering
        const allowShowChangeAfterFilter = this.gos.get('allowShowChangeAfterFilter') ?? false;
        return !allowShowChangeAfterFilter && this.processingFilterChange;
    }
    onNewRowsLoaded(source) {
        const promises = [];
        this.allColumnFilters.forEach((filterWrapper) => {
            const isHandler = filterWrapper.isHandler;
            if (isHandler) {
                filterWrapper.handler.onNewRowsLoaded?.();
            }
            const promise = (0, columnFilterUtils_1.getFilterUiFromWrapper)(filterWrapper, isHandler);
            if (promise) {
                promises.push(promise.then((filter) => {
                    filter.onNewRowsLoaded?.();
                }));
            }
        });
        promise_1.AgPromise.all(promises)
            .then(() => this.updateFilterFlagInColumns(source, { afterDataChange: true }))
            .then(() => this.updateActiveFilters());
    }
    createGetValue(filterColumn, filterValueGetterOverride) {
        const { filterValueSvc, colModel } = this.beans;
        return (rowNode, column) => {
            const columnToUse = column ? colModel.getCol(column) : filterColumn;
            return columnToUse ? filterValueSvc.getValue(columnToUse, rowNode, filterValueGetterOverride) : undefined;
        };
    }
    isFilterActive(column) {
        const filterWrapper = this.cachedFilter(column);
        if (filterWrapper?.isHandler) {
            return this.isHandlerActive(column);
        }
        const filter = filterWrapper?.filter;
        if (filter) {
            return filter.isFilterActive();
        }
        // if not created, should only be active if there's a model
        return (0, columnFilterUtils_1._getFilterModel)(this.initialModel, column.getColId()) != null;
    }
    isHandlerActive(column) {
        // all the existing filter code uses `_exists` rather than not null,
        // so need to keep handling `''` until all the code is updated to do a simple null check
        const active = (0, generic_1._exists)((0, columnFilterUtils_1._getFilterModel)(this.model, column.getColId()));
        if (active) {
            return active;
        }
        const groupFilter = this.beans.groupFilter;
        return groupFilter?.isGroupFilter(column) ? groupFilter.isFilterActive(column) : false;
    }
    getOrCreateFilterUi(column) {
        const filterWrapper = this.getOrCreateFilterWrapper(column, true);
        return filterWrapper ? (0, columnFilterUtils_1.getFilterUiFromWrapper)(filterWrapper) : null;
    }
    getFilterUiForDisplay(column) {
        const filterWrapper = this.getOrCreateFilterWrapper(column, true);
        if (!filterWrapper) {
            return null;
        }
        const compPromise = (0, columnFilterUtils_1.getFilterUiFromWrapper)(filterWrapper);
        if (!compPromise) {
            return null;
        }
        return compPromise.then((comp) => ({
            comp: comp,
            params: filterWrapper.filterUi.filterParams,
            isHandler: filterWrapper.isHandler,
        }));
    }
    getHandler(column, createIfMissing) {
        const filterWrapper = this.getOrCreateFilterWrapper(column, createIfMissing);
        return filterWrapper?.isHandler ? filterWrapper.handler : undefined;
    }
    getOrCreateFilterWrapper(column, createIfMissing) {
        if (!column.isFilterAllowed()) {
            return undefined;
        }
        let filterWrapper = this.cachedFilter(column);
        if (!filterWrapper && createIfMissing) {
            filterWrapper = this.createFilterWrapper(column);
            this.setColumnFilterWrapper(column, filterWrapper);
        }
        return filterWrapper;
    }
    cachedFilter(column) {
        return this.allColumnFilters.get(column.getColId());
    }
    getDefaultFilter(column, isFloating = false) {
        return this.getDefaultFilterFromDataType(() => this.beans.dataTypeSvc?.getBaseDataType(column), isFloating);
    }
    getDefaultFilterFromDataType(getCellDataType, isFloating = false) {
        if ((0, gridOptionsUtils_1._isSetFilterByDefault)(this.gos)) {
            return isFloating ? 'agSetColumnFloatingFilter' : 'agSetColumnFilter';
        }
        return (0, filterDataTypeUtils_1._getDefaultSimpleFilter)(getCellDataType(), isFloating);
    }
    getDefaultFloatingFilter(column) {
        return this.getDefaultFilter(column, true);
    }
    createFilterComp(column, filterDef, defaultFilter, getFilterParams, isHandler, source) {
        const createFilterCompDetails = () => {
            const params = this.createFilterCompParams(column, isHandler, source);
            const updatedParams = getFilterParams(params, isHandler);
            return (0, userCompUtils_1._getFilterDetails)(this.beans.userCompFactory, filterDef, updatedParams, defaultFilter);
        };
        const compDetails = createFilterCompDetails();
        if (!compDetails) {
            return null;
        }
        const createFilterUi = (update) => {
            return (update ? createFilterCompDetails() : compDetails).newAgStackInstance();
        };
        return {
            compDetails,
            createFilterUi,
        };
    }
    createFilterInstance(column, filterDef, defaultFilter, getFilterParams) {
        const selectableFilter = this.beans.selectableFilter;
        if (selectableFilter?.isSelectable(filterDef)) {
            filterDef = selectableFilter.getFilterDef(column, filterDef);
        }
        const { handler, handlerParams, handlerGenerator } = this.createHandler(column, filterDef, defaultFilter) ?? {};
        const filterCompDetails = this.createFilterComp(column, filterDef, defaultFilter, getFilterParams, !!handler, 'init');
        if (!filterCompDetails) {
            return {
                compDetails: null,
                createFilterUi: null,
                handler,
                handlerGenerator,
                handlerParams,
            };
        }
        const { compDetails, createFilterUi } = filterCompDetails;
        if (this.isGlobalButtons) {
            const hasLocalButtons = !!compDetails.params?.buttons?.length;
            if (!hasLocalButtons) {
                (0, logging_1._warn)(281, { colId: column.getColId() });
            }
        }
        return {
            compDetails,
            handler,
            handlerGenerator,
            handlerParams,
            createFilterUi,
        };
    }
    createBaseFilterParams(column, forFloatingFilter) {
        const { filterManager, rowModel } = this.beans;
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            column,
            colDef: column.getColDef(),
            getValue: this.createGetValue(column),
            doesRowPassOtherFilter: forFloatingFilter
                ? () => true
                : (node) => filterManager?.doesRowPassOtherFilters(column.getColId(), node) ?? true,
            // to avoid breaking changes to `filterParams` defined as functions
            // we need to provide the below options even though they are not valid for handlers
            rowModel,
        });
    }
    createFilterCompParams(column, useHandler, source, forFloatingFilter) {
        const filterChangedCallback = this.filterChangedCallbackFactory(column);
        const params = this.createBaseFilterParams(column, forFloatingFilter);
        params.filterChangedCallback = filterChangedCallback;
        params.filterModifiedCallback = forFloatingFilter
            ? () => { }
            : (additionalEventAttributes) => this.filterModified(column, additionalEventAttributes);
        if (useHandler) {
            const displayParams = params;
            const colId = column.getColId();
            const model = (0, columnFilterUtils_1._getFilterModel)(this.model, colId);
            displayParams.model = model;
            displayParams.state = this.state.get(colId) ?? {
                model,
            };
            displayParams.onModelChange = (model, additionalEventAttributes) => {
                this.updateStoredModel(colId, model);
                this.refreshHandlerAndUi(column, model, 'ui').then(() => {
                    filterChangedCallback({ ...additionalEventAttributes, source: 'columnFilter' });
                });
            };
            displayParams.onStateChange = (state) => {
                this.updateState(column, state);
                this.updateOrRefreshFilterUi(column);
            };
            displayParams.onAction = (action, additionalEventAttributes, event) => {
                this.updateModel(column, action, additionalEventAttributes);
                this.dispatchLocalEvent({
                    type: 'filterAction',
                    column,
                    action,
                    event,
                });
            };
            displayParams.getHandler = () => this.getHandler(column, true);
            displayParams.onUiChange = (additionalEventAttributes) => this.filterUiChanged(column, additionalEventAttributes);
            displayParams.source = source;
        }
        return params;
    }
    createFilterUiForHandler(compDetails, createFilterUi) {
        return createFilterUi
            ? {
                created: false,
                create: createFilterUi,
                filterParams: compDetails.params,
                compDetails: compDetails,
            }
            : null;
    }
    createFilterUiLegacy(compDetails, createFilterUi, updateInstanceCallback) {
        const promise = createFilterUi();
        const filterUi = {
            created: true,
            create: createFilterUi,
            filterParams: compDetails.params,
            compDetails: compDetails,
            promise,
        };
        promise.then(updateInstanceCallback);
        return filterUi;
    }
    createFilterWrapper(column) {
        const { compDetails, handler, handlerGenerator, handlerParams, createFilterUi } = this.createFilterInstance(column, column.getColDef(), this.getDefaultFilter(column), (params) => params);
        const colId = column.getColId();
        if (handler) {
            delete this.initialModel[colId];
            handler.init?.({
                ...handlerParams,
                source: 'init',
                model: (0, columnFilterUtils_1._getFilterModel)(this.model, colId),
            });
            return {
                column,
                isHandler: true,
                handler,
                handlerGenerator: handlerGenerator,
                handlerParams: handlerParams,
                filterUi: this.createFilterUiForHandler(compDetails, createFilterUi),
            };
        }
        if (createFilterUi) {
            const filterWrapper = {
                column,
                filterUi: null,
                isHandler: false,
            };
            filterWrapper.filterUi = this.createFilterUiLegacy(compDetails, createFilterUi, (filterComp) => {
                filterWrapper.filter = filterComp ?? undefined;
            });
            return filterWrapper;
        }
        return {
            column,
            filterUi: null,
            isHandler: false,
        };
    }
    createHandlerFunc(filterDef, defaultFilter) {
        const { gos, frameworkOverrides, registry } = this.beans;
        // need to keep track of this so we can compare when col defs change
        let doesFilterPass;
        const getFilterHandlerFromDef = (filterDef) => {
            const filter = filterDef.filter;
            if ((0, iFilter_1.isColumnFilterComp)(filter)) {
                const handler = filter.handler;
                // handler takes priority
                if (handler) {
                    return handler;
                }
                doesFilterPass = filter.doesFilterPass;
                if (doesFilterPass) {
                    // wrap to create a handler
                    return () => ({
                        doesFilterPass: doesFilterPass,
                    });
                }
                return undefined;
            }
            return typeof filter === 'string' ? filter : undefined;
        };
        const providedFilterHandler = gos.get('enableFilterHandlers') ? getFilterHandlerFromDef(filterDef) : undefined;
        const resolveProvidedFilterHandler = (handlerName) => () => this.createBean(registry.createDynamicBean(handlerName, true));
        let filterHandler;
        let handlerName;
        if (typeof providedFilterHandler === 'string') {
            const userFilterHandler = gos.get('filterHandlers')?.[providedFilterHandler];
            if (userFilterHandler != null) {
                filterHandler = userFilterHandler;
            }
            else {
                if (columnFilterUtils_1.FILTER_HANDLERS.has(providedFilterHandler)) {
                    filterHandler = resolveProvidedFilterHandler(providedFilterHandler);
                    handlerName = providedFilterHandler;
                }
            }
        }
        else {
            filterHandler = providedFilterHandler;
        }
        if (!filterHandler) {
            let filterName;
            const { compName, jsComp, fwComp } = (0, userCompUtils_1._getFilterCompKeys)(frameworkOverrides, filterDef);
            if (compName) {
                filterName = compName;
            }
            else {
                const usingDefaultFilter = jsComp == null && fwComp == null && filterDef.filter === true;
                if (usingDefaultFilter) {
                    filterName = defaultFilter;
                }
            }
            handlerName = this.handlerMap[filterName];
            if (handlerName) {
                filterHandler = resolveProvidedFilterHandler(handlerName);
            }
        }
        if (!filterHandler) {
            return undefined;
        }
        return { filterHandler, handlerNameOrCallback: doesFilterPass ?? handlerName };
    }
    createHandler(column, filterDef, defaultFilter) {
        let handlerFunc = this.createHandlerFunc(filterDef, defaultFilter);
        if (!handlerFunc) {
            const gos = this.gos;
            if (!gos.get('enableFilterHandlers')) {
                return undefined;
            }
            if ((0, gridOptionsUtils_1._isClientSideRowModel)(gos)) {
                (0, logging_1._warn)(277, { colId: column.getColId() });
            }
            // create dummy handler for server side,
            // or to prevent blowing up for CSRM custom with missing props
            handlerFunc = DUMMY_HANDLER;
        }
        const filterParams = (0, userCompUtils_1._mergeFilterParamsWithApplicationProvidedParams)(this.beans.userCompFactory, filterDef, this.createFilterCompParams(column, true, 'init'));
        const { handlerNameOrCallback, filterHandler } = handlerFunc;
        const { handler, handlerParams } = this.createHandlerFromFunc(column, filterHandler, filterParams);
        return {
            handler,
            handlerParams,
            handlerGenerator: handlerNameOrCallback ?? filterHandler,
        };
    }
    createHandlerFromFunc(column, filterHandler, filterParams) {
        const colDef = column.getColDef();
        const handler = filterHandler((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, { column, colDef }));
        const handlerParams = this.createHandlerParams(column, filterParams);
        return { handler, handlerParams };
    }
    createHandlerParams(column, filterParams) {
        const colDef = column.getColDef();
        const colId = column.getColId();
        const filterChangedCallback = this.filterChangedCallbackFactory(column);
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            colDef,
            column,
            getValue: this.createGetValue(column),
            doesRowPassOtherFilter: (node) => this.beans.filterManager?.doesRowPassOtherFilters(colId, node) ?? true,
            onModelChange: (newModel, additionalEventAttributes) => {
                this.updateStoredModel(colId, newModel);
                this.refreshHandlerAndUi(column, newModel, 'handler').then(() => {
                    filterChangedCallback({ ...additionalEventAttributes, source: 'columnFilter' });
                });
            },
            filterParams,
        });
    }
    onColumnsChanged() {
        const columns = [];
        const { colModel, filterManager, groupFilter } = this.beans;
        this.allColumnFilters.forEach((wrapper, colId) => {
            let currentColumn;
            if (wrapper.column.isPrimary()) {
                currentColumn = colModel.getColDefCol(colId);
            }
            else {
                currentColumn = colModel.getCol(colId);
            }
            // group columns can be recreated with the same colId
            if (currentColumn && currentColumn === wrapper.column) {
                return;
            }
            columns.push(wrapper.column);
            this.disposeFilterWrapper(wrapper, 'columnChanged');
            this.disposeColumnListener(colId);
        });
        const allFiltersAreGroupFilters = groupFilter && columns.every((col) => groupFilter.isGroupFilter(col));
        // don't call `onFilterChanged` if only group column filter is present as it has no model
        if (columns.length > 0 && !allFiltersAreGroupFilters) {
            // When a filter changes as a side effect of a column changes,
            // we report 'api' as the source, so that the client can distinguish
            filterManager?.onFilterChanged({ columns, source: 'api' });
        }
    }
    isFilterAllowed(column) {
        const isFilterAllowed = column.isFilterAllowed();
        if (!isFilterAllowed) {
            return false;
        }
        // for group filters, can change dynamically whether they are allowed or not
        const groupFilter = this.beans.groupFilter;
        if (groupFilter?.isGroupFilter(column)) {
            return groupFilter.isFilterAllowed(column);
        }
        return true;
    }
    getFloatingFilterCompDetails(column, showParentFilter) {
        const { userCompFactory, frameworkOverrides, selectableFilter } = this.beans;
        const parentFilterInstance = (callback) => {
            const filterComponent = this.getOrCreateFilterUi(column);
            if (filterComponent == null) {
                return;
            }
            filterComponent.then((instance) => {
                callback((0, unwrapUserComp_1._unwrapUserComp)(instance));
            });
        };
        const colDef = column.getColDef();
        const filterDef = selectableFilter?.isSelectable(colDef)
            ? selectableFilter.getFilterDef(column, colDef)
            : colDef;
        const defaultFloatingFilterType = (0, floatingFilterMapper_1._getDefaultFloatingFilterType)(frameworkOverrides, filterDef, () => this.getDefaultFloatingFilter(column)) ??
            'agReadOnlyFloatingFilter';
        const isReactive = this.gos.get('enableFilterHandlers');
        const filterParams = (0, userCompUtils_1._mergeFilterParamsWithApplicationProvidedParams)(userCompFactory, filterDef, this.createFilterCompParams(column, isReactive, 'init', true));
        const params = (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            column,
            filterParams,
            currentParentModel: () => this.getCurrentFloatingFilterParentModel(column),
            parentFilterInstance,
            showParentFilter,
        });
        if (isReactive) {
            const displayParams = params;
            const colId = column.getColId();
            const filterChangedCallback = this.filterChangedCallbackFactory(column);
            displayParams.onUiChange = (additionalEventAttributes) => this.floatingFilterUiChanged(column, additionalEventAttributes);
            displayParams.model = (0, columnFilterUtils_1._getFilterModel)(this.model, colId);
            displayParams.onModelChange = (model, additionalEventAttributes) => {
                this.updateStoredModel(colId, model);
                this.refreshHandlerAndUi(column, model, 'floating', true).then(() => {
                    filterChangedCallback({ ...additionalEventAttributes, source: 'columnFilter' });
                });
            };
            displayParams.getHandler = () => this.getHandler(column, true);
            displayParams.source = 'init';
        }
        return (0, userCompUtils_1._getFloatingFilterCompDetails)(userCompFactory, colDef, params, defaultFloatingFilterType);
    }
    getCurrentFloatingFilterParentModel(column) {
        return this.getModelFromFilterWrapper(this.cachedFilter(column) ?? { column });
    }
    destroyFilterUi(filterWrapper, column, compDetails, createFilterUi) {
        if (filterWrapper.isHandler) {
            const colId = column.getColId();
            delete this.initialModel[colId];
            this.state.delete(colId);
            const filterUi = filterWrapper.filterUi;
            const newFilterUi = this.createFilterUiForHandler(compDetails, createFilterUi);
            filterWrapper.filterUi = newFilterUi;
            // destroy the old one after creating the new one
            // so that anything listening to the destroyed event will receive the new comp
            if (filterUi?.created) {
                filterUi.promise.then((filter) => {
                    this.destroyBean(filter);
                    this.eventSvc.dispatchEvent({
                        type: 'filterDestroyed',
                        source: 'paramsUpdated',
                        column: filterWrapper.column,
                    });
                });
            }
        }
        else {
            this.destroyFilter(column, 'paramsUpdated');
        }
    }
    // destroys the filter, so it no longer takes part
    destroyFilter(column, source = 'api') {
        const colId = column.getColId();
        const filterWrapper = this.allColumnFilters.get(colId);
        this.disposeColumnListener(colId);
        delete this.initialModel[colId];
        if (filterWrapper) {
            this.disposeFilterWrapper(filterWrapper, source).then((wasActive) => {
                if (wasActive && this.isAlive()) {
                    this.beans.filterManager?.onFilterChanged({
                        columns: [column],
                        source: 'api',
                    });
                }
            });
        }
    }
    disposeColumnListener(colId) {
        const columnListener = this.allColumnListeners.get(colId);
        if (columnListener) {
            this.allColumnListeners.delete(colId);
            columnListener();
        }
    }
    disposeFilterWrapper(filterWrapper, source) {
        let isActive = false;
        const { column, isHandler, filterUi } = filterWrapper;
        const colId = column.getColId();
        if (isHandler) {
            isActive = this.isHandlerActive(column);
            this.destroyBean(filterWrapper.handler);
            delete this.model[colId];
            this.state.delete(colId);
        }
        const removeFilter = () => {
            this.setColFilterActive(column, false, 'filterDestroyed');
            this.allColumnFilters.delete(colId);
            this.eventSvc.dispatchEvent({
                type: 'filterDestroyed',
                source,
                column,
            });
        };
        if (filterUi) {
            if (filterUi.created) {
                return filterUi.promise.then((filter) => {
                    isActive = isHandler ? isActive : !!filter?.isFilterActive();
                    this.destroyBean(filter);
                    removeFilter();
                    return isActive;
                });
            }
            else {
                removeFilter();
            }
        }
        return promise_1.AgPromise.resolve(isActive);
    }
    filterChangedCallbackFactory(column) {
        return (additionalEventAttributes) => {
            this.callOnFilterChangedOutsideRenderCycle({
                additionalEventAttributes,
                columns: [column],
                column,
                source: additionalEventAttributes?.source ?? 'columnFilter',
            });
        };
    }
    filterParamsChanged(colId, source = 'api') {
        const filterWrapper = this.allColumnFilters.get(colId);
        if (!filterWrapper) {
            return;
        }
        const beans = this.beans;
        const column = filterWrapper.column;
        const colDef = column.getColDef();
        const isFilterAllowed = column.isFilterAllowed();
        const defaultFilter = this.getDefaultFilter(column);
        const selectableFilter = beans.selectableFilter;
        const filterDef = selectableFilter?.isSelectable(colDef)
            ? selectableFilter.getFilterDef(column, colDef)
            : colDef;
        const handlerFunc = isFilterAllowed
            ? this.createHandlerFunc(filterDef, this.getDefaultFilter(column))
            : undefined;
        const isHandler = !!handlerFunc;
        const wasHandler = filterWrapper.isHandler;
        if (wasHandler != isHandler) {
            this.destroyFilter(column, 'paramsUpdated');
            return;
        }
        const { compDetails, createFilterUi } = (isFilterAllowed
            ? this.createFilterComp(column, filterDef, defaultFilter, (params) => params, isHandler, 'colDef')
            : null) ?? { compDetails: null, createFilterUi: null };
        const newFilterParams = compDetails?.params ??
            (0, userCompUtils_1._mergeFilterParamsWithApplicationProvidedParams)(beans.userCompFactory, filterDef, this.createFilterCompParams(column, isHandler, 'colDef'));
        if (wasHandler) {
            const handlerGenerator = handlerFunc?.handlerNameOrCallback ?? handlerFunc?.filterHandler;
            const existingModel = (0, columnFilterUtils_1._getFilterModel)(this.model, colId);
            if (filterWrapper.handlerGenerator != handlerGenerator) {
                // handler has changed
                const oldHandler = filterWrapper.handler;
                const { handler, handlerParams } = this.createHandlerFromFunc(column, handlerFunc.filterHandler, newFilterParams);
                filterWrapper.handler = handler;
                filterWrapper.handlerParams = handlerParams;
                filterWrapper.handlerGenerator = handlerGenerator;
                delete this.model[colId];
                handler.init?.({ ...handlerParams, source: 'init', model: null });
                // destroy the old handler after creating and assigning the new one in case anything
                // is listening to events on the handler and needs to resubscribe to the new one
                this.destroyBean(oldHandler);
                if (existingModel != null) {
                    this.beans.filterManager?.onFilterChanged({
                        columns: [column],
                        source,
                    });
                }
            }
            else {
                const handlerParams = this.createHandlerParams(column, compDetails?.params);
                // handler exists and is the same
                filterWrapper.handlerParams = handlerParams;
                filterWrapper.handler.refresh?.({
                    ...handlerParams,
                    source: 'colDef',
                    model: existingModel,
                });
            }
        }
        // Case when filter component changes
        // or when filter wrapper does not have promise to retrieve FilterComp, destroy
        if (this.areFilterCompsDifferent(filterWrapper.filterUi?.compDetails ?? null, compDetails) ||
            !filterWrapper.filterUi ||
            !compDetails) {
            this.destroyFilterUi(filterWrapper, column, compDetails, createFilterUi);
            return;
        }
        filterWrapper.filterUi.filterParams = newFilterParams;
        // Otherwise - Check for refresh method before destruction
        // If refresh() method is implemented - call it and destroy filter if it returns false
        // Otherwise - do nothing ( filter will not be destroyed - we assume new params are compatible with old ones )
        (0, columnFilterUtils_1.getFilterUiFromWrapper)(filterWrapper, wasHandler)?.then((filter) => {
            const shouldRefreshFilter = filter?.refresh ? filter.refresh(newFilterParams) : true;
            // framework wrapper always implements optional methods, but returns null if no underlying method
            if (shouldRefreshFilter === false) {
                this.destroyFilterUi(filterWrapper, column, compDetails, createFilterUi);
            }
            else {
                this.dispatchLocalEvent({
                    type: 'filterParamsChanged',
                    column,
                    params: newFilterParams,
                });
            }
        });
    }
    refreshHandlerAndUi(column, model, source, createIfMissing) {
        const filterWrapper = this.cachedFilter(column);
        if (!filterWrapper) {
            if (createIfMissing) {
                // create one. Don't need to refresh as it will be created with the latest details
                this.getOrCreateFilterWrapper(column, true);
            }
            return promise_1.AgPromise.resolve();
        }
        if (!filterWrapper.isHandler) {
            return promise_1.AgPromise.resolve();
        }
        const { filterUi, handler, handlerParams } = filterWrapper;
        return (0, columnFilterUtils_1._refreshHandlerAndUi)(() => {
            if (filterUi) {
                const { created, filterParams } = filterUi;
                if (created) {
                    return filterUi.promise.then((filter) => {
                        return filter ? { filter, filterParams } : undefined;
                    });
                }
                else {
                    filterUi.refreshed = true;
                }
            }
            return promise_1.AgPromise.resolve(undefined);
        }, handler, handlerParams, model, this.state.get(column.getColId()) ?? { model }, source);
    }
    setColumnFilterWrapper(column, filterWrapper) {
        const colId = column.getColId();
        this.allColumnFilters.set(colId, filterWrapper);
        this.allColumnListeners.set(colId, this.addManagedListeners(column, { colDefChanged: () => this.filterParamsChanged(colId) })[0]);
    }
    areFilterCompsDifferent(oldCompDetails, newCompDetails) {
        if (!newCompDetails || !oldCompDetails) {
            return true;
        }
        const { componentClass: oldComponentClass } = oldCompDetails;
        const { componentClass: newComponentClass } = newCompDetails;
        const isSameComponentClass = oldComponentClass === newComponentClass ||
            // react hooks returns new wrappers, so check nested render method
            (oldComponentClass?.render &&
                newComponentClass?.render &&
                oldComponentClass.render === newComponentClass.render);
        return !isSameComponentClass;
    }
    hasFloatingFilters() {
        const gridColumns = this.beans.colModel.getCols();
        return gridColumns.some((col) => col.getColDef().floatingFilter);
    }
    getFilterInstance(key) {
        const column = this.beans.colModel.getColDefCol(key);
        if (!column) {
            return Promise.resolve(undefined);
        }
        const filterPromise = this.getOrCreateFilterUi(column);
        if (!filterPromise) {
            return Promise.resolve(null);
        }
        return new Promise((resolve) => {
            filterPromise.then((filter) => {
                resolve((0, unwrapUserComp_1._unwrapUserComp)(filter));
            });
        });
    }
    processFilterModelUpdateQueue() {
        this.modelUpdates.forEach(({ model, source }) => this.setModel(model, source));
        this.modelUpdates = [];
        this.columnModelUpdates.forEach(({ key, model, resolve }) => {
            this.setModelForColumn(key, model).then(() => resolve());
        });
        this.columnModelUpdates = [];
    }
    getModelForColumn(column, useUnapplied) {
        if (useUnapplied) {
            const { state, model } = this;
            const colId = column.getColId();
            const colState = state.get(colId);
            if (colState) {
                return colState.model ?? null;
            }
            return (0, columnFilterUtils_1._getFilterModel)(model, colId);
        }
        const filterWrapper = this.cachedFilter(column);
        return filterWrapper ? this.getModelFromFilterWrapper(filterWrapper) : null;
    }
    setModelForColumn(key, model) {
        if (this.beans.dataTypeSvc?.isPendingInference) {
            let resolve = () => { };
            const promise = new Promise((res) => {
                resolve = res;
            });
            this.columnModelUpdates.push({ key, model, resolve });
            return promise;
        }
        return new Promise((resolve) => {
            this.setModelForColumnLegacy(key, model).then((result) => resolve(result));
        });
    }
    getStateForColumn(colId) {
        return (this.state.get(colId) ?? {
            model: (0, columnFilterUtils_1._getFilterModel)(this.model, colId),
        });
    }
    setModelForColumnLegacy(key, model) {
        const column = this.beans.colModel.getColDefCol(key);
        const filterWrapper = column ? this.getOrCreateFilterWrapper(column, true) : null;
        return filterWrapper ? this.setModelOnFilterWrapper(filterWrapper, model) : promise_1.AgPromise.resolve();
    }
    setColDefPropsForDataType(colDef, dataTypeDefinition, formatValue) {
        const providedFilter = colDef.filter;
        const filter = providedFilter === true
            ? this.getDefaultFilterFromDataType(() => dataTypeDefinition.baseDataType)
            : providedFilter;
        if (typeof filter !== 'string') {
            return;
        }
        let filterParams;
        let filterValueGetter;
        const beans = this.beans;
        const { filterParams: colDefFilterParams, filterValueGetter: colDefFilterValueGetter } = colDef;
        if (filter === 'agMultiColumnFilter') {
            ({ filterParams, filterValueGetter } =
                beans.multiFilter?.getParamsForDataType(colDefFilterParams, colDefFilterValueGetter, dataTypeDefinition, formatValue) ?? {});
        }
        else {
            ({ filterParams, filterValueGetter } = (0, filterDataTypeUtils_1._getFilterParamsForDataType)(filter, colDefFilterParams, colDefFilterValueGetter, dataTypeDefinition, formatValue, beans, this.getLocaleTextFunc()));
        }
        colDef.filterParams = filterParams;
        if (filterValueGetter) {
            colDef.filterValueGetter = filterValueGetter;
        }
    }
    // additionalEventAttributes is used by provided simple floating filter, so it can add 'floatingFilter=true' to the event
    setColFilterActive(column, active, source, additionalEventAttributes) {
        if (column.filterActive !== active) {
            column.filterActive = active;
            column.dispatchColEvent('filterActiveChanged', source);
        }
        column.dispatchColEvent('filterChanged', source, additionalEventAttributes);
    }
    setModelOnFilterWrapper(filterWrapper, newModel, justCreated) {
        return new promise_1.AgPromise((resolve) => {
            if (filterWrapper.isHandler) {
                const column = filterWrapper.column;
                const colId = column.getColId();
                const existingModel = this.model[colId];
                this.updateStoredModel(colId, newModel);
                if (justCreated && newModel === existingModel) {
                    // don't need to refresh as already has the new model
                    resolve();
                    return;
                }
                this.refreshHandlerAndUi(column, newModel, 'api').then(() => resolve());
                return;
            }
            const uiPromise = (0, columnFilterUtils_1.getFilterUiFromWrapper)(filterWrapper);
            if (uiPromise) {
                uiPromise.then((filter) => {
                    if (typeof filter?.setModel !== 'function') {
                        (0, logging_1._warn)(65);
                        resolve();
                        return;
                    }
                    (filter.setModel(newModel) || promise_1.AgPromise.resolve()).then(() => resolve());
                });
                return;
            }
            // no handler and no filter comp
            resolve();
        });
    }
    /** for handlers only */
    updateStoredModel(colId, model) {
        if ((0, generic_1._exists)(model)) {
            this.model[colId] = model;
        }
        else {
            delete this.model[colId];
        }
        const oldState = this.state.get(colId);
        const newState = {
            model,
            state: oldState?.state,
        };
        this.state.set(colId, newState);
    }
    filterModified(column, additionalEventAttributes) {
        this.getOrCreateFilterUi(column)?.then((filterInstance) => {
            this.eventSvc.dispatchEvent({
                type: 'filterModified',
                column,
                filterInstance,
                ...additionalEventAttributes,
            });
        });
    }
    filterUiChanged(column, additionalEventAttributes) {
        if (this.gos.get('enableFilterHandlers')) {
            this.eventSvc.dispatchEvent({
                type: 'filterUiChanged',
                column,
                ...additionalEventAttributes,
            });
        }
    }
    floatingFilterUiChanged(column, additionalEventAttributes) {
        if (this.gos.get('enableFilterHandlers')) {
            this.eventSvc.dispatchEvent({
                type: 'floatingFilterUiChanged',
                column,
                ...additionalEventAttributes,
            });
        }
    }
    updateModel(column, action, additionalEventAttributes) {
        const colId = column.getColId();
        const getFilterUi = () => this.cachedFilter(column)?.filterUi;
        (0, columnFilterUtils_1._updateFilterModel)(action, getFilterUi, () => (0, columnFilterUtils_1._getFilterModel)(this.model, colId), () => this.state.get(colId), (state) => this.updateState(column, state), (model) => getFilterUi()?.filterParams?.onModelChange(model, additionalEventAttributes));
    }
    updateAllModels(action, additionalEventAttributes) {
        const promises = [];
        this.allColumnFilters.forEach((filter, colId) => {
            const column = this.beans.colModel.getColDefCol(colId);
            if (column) {
                (0, columnFilterUtils_1._updateFilterModel)(action, () => filter.filterUi, () => (0, columnFilterUtils_1._getFilterModel)(this.model, colId), () => this.state.get(colId), (state) => this.updateState(column, state), (model) => {
                    this.updateStoredModel(colId, model);
                    this.dispatchLocalEvent({
                        type: 'filterAction',
                        column,
                        action,
                    });
                    promises.push(this.refreshHandlerAndUi(column, model, 'ui'));
                });
            }
        });
        if (promises.length) {
            promise_1.AgPromise.all(promises).then(() => {
                this.callOnFilterChangedOutsideRenderCycle({
                    source: 'columnFilter',
                    additionalEventAttributes,
                    columns: [],
                });
            });
        }
    }
    updateOrRefreshFilterUi(column) {
        const colId = column.getColId();
        (0, columnFilterUtils_1.getAndRefreshFilterUi)(() => this.cachedFilter(column)?.filterUi, () => (0, columnFilterUtils_1._getFilterModel)(this.model, colId), () => this.state.get(colId));
    }
    updateState(column, state) {
        this.state.set(column.getColId(), state);
        this.dispatchLocalEvent({
            type: 'filterStateChanged',
            column,
            state,
        });
    }
    // for tool panel only
    canApplyAll() {
        const { state, model, activeFilterComps } = this;
        for (const comp of activeFilterComps) {
            if (comp.source === 'COLUMN_MENU') {
                // if open in column menu, can't apply as unapplied state will be cleared when the filter closes
                return false;
            }
        }
        let hasChanges = false;
        for (const colId of state.keys()) {
            const colState = state.get(colId);
            // undefined is true
            if (colState.valid === false) {
                return false;
            }
            if ((colState.model ?? null) !== (0, columnFilterUtils_1._getFilterModel)(model, colId)) {
                hasChanges = true;
            }
        }
        return hasChanges;
    }
    hasUnappliedModel(colId) {
        const { model, state } = this;
        return (state.get(colId)?.model ?? null) !== (0, columnFilterUtils_1._getFilterModel)(model, colId);
    }
    setGlobalButtons(isGlobal) {
        this.isGlobalButtons = isGlobal;
        this.dispatchLocalEvent({
            type: 'filterGlobalButtons',
            isGlobal,
        });
    }
    shouldKeepStateOnDetach(column, lastContainerType) {
        if (lastContainerType === 'newFiltersToolPanel') {
            // don't reset for new filters tool panel
            return true;
        }
        const filterPanelSvc = this.beans.filterPanelSvc;
        if (filterPanelSvc?.isActive) {
            // if in tool panel, then keep
            return !!filterPanelSvc.getState(column.getColId());
        }
        return false;
    }
    destroy() {
        super.destroy();
        this.allColumnFilters.forEach((filterWrapper) => this.disposeFilterWrapper(filterWrapper, 'gridDestroyed'));
        // don't need to destroy the listeners as they are managed listeners
        this.allColumnListeners.clear();
        this.state.clear();
        this.activeFilterComps.clear();
    }
}
exports.ColumnFilterService = ColumnFilterService;


/***/ }),

/***/ 4985:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getFilterModel = exports._updateFilterModel = exports.getAndRefreshFilterUi = exports._refreshFilterUi = exports._refreshHandlerAndUi = exports.getFilterUiFromWrapper = exports.FILTER_HANDLERS = exports.FILTER_HANDLER_MAP = void 0;
exports.FILTER_HANDLER_MAP = {
    agSetColumnFilter: 'agSetColumnFilterHandler',
    agMultiColumnFilter: 'agMultiColumnFilterHandler',
    agGroupColumnFilter: 'agGroupColumnFilterHandler',
    agNumberColumnFilter: 'agNumberColumnFilterHandler',
    agDateColumnFilter: 'agDateColumnFilterHandler',
    agTextColumnFilter: 'agTextColumnFilterHandler',
};
exports.FILTER_HANDLERS = new Set(Object.values(exports.FILTER_HANDLER_MAP));
function getFilterUiFromWrapper(filterWrapper, skipCreate) {
    const filterUi = filterWrapper.filterUi;
    if (!filterUi) {
        return null;
    }
    if (filterUi.created) {
        return filterUi.promise;
    }
    if (skipCreate) {
        return null;
    }
    const promise = filterUi.create(filterUi.refreshed);
    const createdFilterUi = filterUi;
    createdFilterUi.created = true;
    createdFilterUi.promise = promise;
    return promise;
}
exports.getFilterUiFromWrapper = getFilterUiFromWrapper;
function _refreshHandlerAndUi(getFilterUi, handler, handlerParams, model, state, source) {
    handler.refresh?.({ ...handlerParams, model, source });
    return getFilterUi().then((filterUi) => {
        if (filterUi) {
            const { filter, filterParams } = filterUi;
            _refreshFilterUi(filter, filterParams, model, state, source);
        }
    });
}
exports._refreshHandlerAndUi = _refreshHandlerAndUi;
function _refreshFilterUi(filter, filterParams, model, state, source) {
    filter?.refresh?.({
        ...filterParams,
        model,
        state,
        source,
    });
}
exports._refreshFilterUi = _refreshFilterUi;
function getAndRefreshFilterUi(getFilterUi, getModel, getState) {
    const filterUi = getFilterUi();
    if (filterUi?.created) {
        filterUi.promise.then((filter) => {
            const model = getModel();
            _refreshFilterUi(filter, filterUi.filterParams, model, getState() ?? { model }, 'ui');
        });
    }
}
exports.getAndRefreshFilterUi = getAndRefreshFilterUi;
function _updateFilterModel(action, getFilterUi, getModel, getState, updateState, updateModel) {
    let state;
    let shouldUpdateModel = false;
    let model;
    switch (action) {
        case 'apply': {
            const oldState = getState();
            model = oldState?.model ?? null;
            state = {
                // keep the other UI state
                state: oldState?.state,
                model,
            };
            shouldUpdateModel = true;
            break;
        }
        case 'clear': {
            state = {
                // wipe other UI state
                model: null,
            };
            break;
        }
        case 'reset': {
            state = {
                // wipe other UI state
                model: null,
            };
            shouldUpdateModel = true;
            model = null;
            break;
        }
        case 'cancel': {
            state = {
                // wipe other UI state
                model: getModel(),
            };
            break;
        }
    }
    updateState(state);
    if (shouldUpdateModel) {
        updateModel(model);
    }
    else {
        getAndRefreshFilterUi(getFilterUi, getModel, getState);
    }
}
exports._updateFilterModel = _updateFilterModel;
function _getFilterModel(model, colId) {
    return model[colId] ?? null;
}
exports._getFilterModel = _getFilterModel;


/***/ }),

/***/ 9002:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.onFilterChanged = exports.isAnyFilterPresent = void 0;
function isAnyFilterPresent(beans) {
    return !!beans.filterManager?.isAnyFilterPresent();
}
exports.isAnyFilterPresent = isAnyFilterPresent;
function onFilterChanged(beans, source = 'api') {
    beans.filterManager?.onFilterChanged({ source });
}
exports.onFilterChanged = onFilterChanged;


/***/ }),

/***/ 1371:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterButtonComp = void 0;
const keyCode_1 = __webpack_require__(9853);
const dom_1 = __webpack_require__(3507);
const logging_1 = __webpack_require__(7764);
const component_1 = __webpack_require__(8020);
const filterLocaleText_1 = __webpack_require__(5741);
function getElement(className) {
    return {
        tag: 'div',
        cls: className,
    };
}
class FilterButtonComp extends component_1.Component {
    constructor(config) {
        const { className = 'ag-filter-apply-panel' } = config ?? {};
        super(getElement(className));
        this.listeners = [];
        this.className = className;
    }
    updateButtons(buttons, useForm) {
        const oldButtons = this.buttons;
        this.buttons = buttons;
        if (oldButtons === buttons) {
            return;
        }
        const eGui = this.getGui();
        (0, dom_1._clearElement)(eGui);
        let eApplyButton;
        this.destroyListeners();
        // Instead of appending each button to the DOM individually, we create a fragment and append that
        // to the DOM once. This is much faster than appending each button individually.
        const fragment = document.createDocumentFragment();
        const className = this.className;
        const addButton = (type) => {
            const localeKey = `${type}Filter`;
            const text = type ? (0, filterLocaleText_1.translateForFilter)(this, localeKey) : undefined;
            const clickListener = (event) => {
                this.dispatchLocalEvent({
                    type,
                    event,
                });
            };
            if (!['apply', 'clear', 'reset', 'cancel'].includes(type)) {
                (0, logging_1._warn)(75);
            }
            const isApply = type === 'apply';
            const buttonType = isApply && useForm ? 'submit' : 'button';
            const button = (0, dom_1._createElement)({
                tag: 'button',
                attrs: { type: buttonType },
                ref: `${type}FilterButton`,
                cls: `ag-button ag-standard-button ${className}-button${isApply ? ' ' + className + '-apply-button' : ''}`,
                children: text,
            });
            this.activateTabIndex([button]);
            if (isApply) {
                eApplyButton = button;
            }
            const keydownListener = (event) => {
                if (event.key === keyCode_1.KeyCode.ENTER) {
                    // this is needed to ensure a keyboard event is passed through, rather than a click event.
                    // otherwise focus won't be restored if a popup is closed
                    event.preventDefault();
                    clickListener(event);
                }
            };
            const listeners = this.listeners;
            button.addEventListener('click', clickListener);
            listeners.push(() => button.removeEventListener('click', clickListener));
            button.addEventListener('keydown', keydownListener);
            listeners.push(() => button.removeEventListener('keydown', keydownListener));
            fragment.append(button);
        };
        buttons.forEach((type) => addButton(type));
        this.eApply = eApplyButton;
        eGui.append(fragment);
    }
    updateValidity(valid) {
        const eApplyButton = this.eApply;
        if (!eApplyButton) {
            return;
        }
        (0, dom_1._setDisabled)(eApplyButton, valid === false);
    }
    destroyListeners() {
        this.listeners.forEach((destroyFunc) => destroyFunc());
        this.listeners = [];
    }
    destroy() {
        this.destroyListeners();
        super.destroy();
    }
}
exports.FilterButtonComp = FilterButtonComp;


/***/ }),

/***/ 2231:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterComp = void 0;
const dom_1 = __webpack_require__(3507);
const generic_1 = __webpack_require__(4422);
const promise_1 = __webpack_require__(7990);
const logging_1 = __webpack_require__(7764);
const component_1 = __webpack_require__(8020);
const filterWrapperComp_1 = __webpack_require__(1854);
const FilterElement = { tag: 'div', cls: 'ag-filter' };
/** Wraps column filters for use in menus, tool panel etc. */
class FilterComp extends component_1.Component {
    constructor(column, source, enableGlobalButtonCheck) {
        super(FilterElement);
        this.column = column;
        this.source = source;
        this.enableGlobalButtonCheck = enableGlobalButtonCheck;
        this.wrapper = null;
    }
    postConstruct() {
        this.beans.colFilter?.activeFilterComps.add(this);
        this.createFilter(true);
        this.addManagedEventListeners({ filterDestroyed: this.onFilterDestroyed.bind(this) });
    }
    hasFilter() {
        return this.wrapper != null;
    }
    getFilter() {
        return this.wrapper?.then((wrapper) => wrapper.comp) ?? null;
    }
    afterInit() {
        return this.wrapper?.then(() => { }) ?? promise_1.AgPromise.resolve();
    }
    afterGuiAttached(params) {
        this.afterGuiAttachedParams = params;
        this.wrapper?.then((wrapper) => {
            this.comp?.afterGuiAttached(params);
            wrapper?.comp?.afterGuiAttached?.(params);
        });
    }
    afterGuiDetached() {
        this.wrapper?.then((wrapper) => {
            wrapper?.comp?.afterGuiDetached?.();
        });
    }
    createFilter(init) {
        const { column, source, beans: { colFilter }, } = this;
        const filterPromise = colFilter.getFilterUiForDisplay(column) ?? null;
        this.wrapper = filterPromise;
        filterPromise?.then((wrapper) => {
            if (!wrapper) {
                return;
            }
            const { isHandler, comp } = wrapper;
            let filterGui;
            if (isHandler) {
                const enableGlobalButtonCheck = !!this.enableGlobalButtonCheck;
                const displayComp = this.createBean(new filterWrapperComp_1.FilterWrapperComp(column, wrapper, colFilter, colFilter.updateModel.bind(colFilter), enableGlobalButtonCheck && colFilter.isGlobalButtons, enableGlobalButtonCheck));
                this.comp = displayComp;
                filterGui = displayComp.getGui();
            }
            else {
                filterGui = comp.getGui();
                if (!(0, generic_1._exists)(filterGui)) {
                    (0, logging_1._warn)(69, { guiFromFilter: filterGui });
                }
            }
            this.appendChild(filterGui);
            if (init) {
                this.eventSvc.dispatchEvent({
                    type: 'filterOpened',
                    column,
                    source,
                    eGui: this.getGui(),
                });
            }
            else {
                // parent is already attached, and switching filter comps, so fire for the new comp
                comp.afterGuiAttached?.(this.afterGuiAttachedParams);
            }
        });
    }
    onFilterDestroyed(event) {
        const { source, column } = event;
        if ((source === 'api' || source === 'paramsUpdated') &&
            column.getId() === this.column.getId() &&
            this.beans.colModel.getColDefCol(this.column)) {
            // filter has been destroyed by the API or params changing. If the column still exists, need to recreate UI component
            (0, dom_1._clearElement)(this.getGui());
            this.comp = this.destroyBean(this.comp);
            this.createFilter();
        }
    }
    destroy() {
        this.beans.colFilter?.activeFilterComps.delete(this);
        this.eventSvc.dispatchEvent({
            type: 'filterClosed',
            column: this.column,
        });
        this.wrapper = null;
        this.comp = this.destroyBean(this.comp);
        this.afterGuiAttachedParams = undefined;
        super.destroy();
    }
}
exports.FilterComp = FilterComp;


/***/ }),

/***/ 6771:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getDefaultSimpleFilter = exports._getFilterParamsForDataType = void 0;
const date_1 = __webpack_require__(9827);
const generic_1 = __webpack_require__(4422);
const MONTH_LOCALE_TEXT = {
    january: 'January',
    february: 'February',
    march: 'March',
    april: 'April',
    may: 'May',
    june: 'June',
    july: 'July',
    august: 'August',
    september: 'September',
    october: 'October',
    november: 'November',
    december: 'December',
};
const MONTH_KEYS = [
    'january',
    'february',
    'march',
    'april',
    'may',
    'june',
    'july',
    'august',
    'september',
    'october',
    'november',
    'december',
];
function setFilterNumberComparator(a, b) {
    if (a == null) {
        return -1;
    }
    if (b == null) {
        return 1;
    }
    return parseFloat(a) - parseFloat(b);
}
function isValidDate(value) {
    return value instanceof Date && !isNaN(value.getTime());
}
// using an object here to enforce dev to not forget to implement new types as they are added
const filterParamsForEachDataType = {
    number: () => undefined,
    boolean: () => ({
        maxNumConditions: 1,
        debounceMs: 0,
        filterOptions: [
            'empty',
            {
                displayKey: 'true',
                displayName: 'True',
                predicate: (_filterValues, cellValue) => cellValue,
                numberOfInputs: 0,
            },
            {
                displayKey: 'false',
                displayName: 'False',
                predicate: (_filterValues, cellValue) => cellValue === false,
                numberOfInputs: 0,
            },
        ],
    }),
    date: () => ({ isValidDate }),
    dateString: ({ dataTypeDefinition }) => ({
        comparator: (filterDate, cellValue) => {
            const cellAsDate = dataTypeDefinition.dateParser(cellValue);
            if (cellValue == null || cellAsDate < filterDate) {
                return -1;
            }
            if (cellAsDate > filterDate) {
                return 1;
            }
            return 0;
        },
        isValidDate: (value) => typeof value === 'string' &&
            isValidDate(dataTypeDefinition.dateParser(value)),
    }),
    dateTime: (args) => filterParamsForEachDataType.date(args),
    dateTimeString: (args) => filterParamsForEachDataType.dateString(args),
    object: () => undefined,
    text: () => undefined,
};
// using an object here to enforce dev to not forget to implement new types as they are added
const setFilterParamsForEachDataType = {
    number: () => ({ comparator: setFilterNumberComparator }),
    boolean: ({ t }) => ({
        valueFormatter: (params) => (0, generic_1._exists)(params.value) ? t(String(params.value), params.value ? 'True' : 'False') : t('blanks', '(Blanks)'),
    }),
    date: ({ formatValue, t }) => ({
        valueFormatter: (params) => {
            const valueFormatted = formatValue(params);
            return (0, generic_1._exists)(valueFormatted) ? valueFormatted : t('blanks', '(Blanks)');
        },
        treeList: true,
        treeListFormatter: (pathKey, level) => {
            if (pathKey === 'NaN') {
                return t('invalidDate', 'Invalid Date');
            }
            if (level === 1 && pathKey != null) {
                const monthKey = MONTH_KEYS[Number(pathKey) - 1];
                return t(monthKey, MONTH_LOCALE_TEXT[monthKey]);
            }
            return pathKey ?? t('blanks', '(Blanks)');
        },
        treeListPathGetter: (date) => (0, date_1._getDateParts)(date, false),
    }),
    dateString: ({ formatValue, dataTypeDefinition, t }) => ({
        valueFormatter: (params) => {
            const valueFormatted = formatValue(params);
            return (0, generic_1._exists)(valueFormatted) ? valueFormatted : t('blanks', '(Blanks)');
        },
        treeList: true,
        treeListPathGetter: (value) => (0, date_1._getDateParts)(dataTypeDefinition.dateParser(value ?? undefined), false),
        treeListFormatter: (pathKey, level) => {
            if (level === 1 && pathKey != null) {
                const monthKey = MONTH_KEYS[Number(pathKey) - 1];
                return t(monthKey, MONTH_LOCALE_TEXT[monthKey]);
            }
            return pathKey ?? t('blanks', '(Blanks)');
        },
    }),
    dateTime: (args) => {
        const params = setFilterParamsForEachDataType.date(args);
        params.treeListPathGetter = date_1._getDateParts;
        return params;
    },
    dateTimeString(args) {
        const convertToDate = args.dataTypeDefinition.dateParser;
        const params = setFilterParamsForEachDataType.dateString(args);
        params.treeListPathGetter = (value) => (0, date_1._getDateParts)(convertToDate(value ?? undefined));
        return params;
    },
    object: ({ formatValue, t }) => ({
        valueFormatter: (params) => {
            const valueFormatted = formatValue(params);
            return (0, generic_1._exists)(valueFormatted) ? valueFormatted : t('blanks', '(Blanks)');
        },
    }),
    text: () => undefined,
};
function _getFilterParamsForDataType(filter, existingFilterParams, existingFilterValueGetter, dataTypeDefinition, formatValue, beans, translate) {
    let filterParams = existingFilterParams;
    let filterValueGetter = existingFilterValueGetter;
    const usingSetFilter = filter === 'agSetColumnFilter';
    if (!filterValueGetter && dataTypeDefinition.baseDataType === 'object' && !usingSetFilter) {
        filterValueGetter = ({ column, node }) => formatValue({ column, node, value: beans.valueSvc.getValue(column, node) });
    }
    const filterParamsMap = usingSetFilter ? setFilterParamsForEachDataType : filterParamsForEachDataType;
    const filterParamsGetter = filterParamsMap[dataTypeDefinition.baseDataType];
    const newFilterParams = filterParamsGetter({ dataTypeDefinition, formatValue, t: translate });
    filterParams =
        typeof existingFilterParams === 'object'
            ? {
                ...newFilterParams,
                ...existingFilterParams,
            }
            : newFilterParams;
    return { filterParams, filterValueGetter };
}
exports._getFilterParamsForDataType = _getFilterParamsForDataType;
const defaultFilters = {
    boolean: 'agTextColumnFilter',
    date: 'agDateColumnFilter',
    dateString: 'agDateColumnFilter',
    dateTime: 'agDateColumnFilter',
    dateTimeString: 'agDateColumnFilter',
    number: 'agNumberColumnFilter',
    object: 'agTextColumnFilter',
    text: 'agTextColumnFilter',
};
const defaultFloatingFilters = {
    boolean: 'agTextColumnFloatingFilter',
    date: 'agDateColumnFloatingFilter',
    dateString: 'agDateColumnFloatingFilter',
    dateTime: 'agDateColumnFloatingFilter',
    dateTimeString: 'agDateColumnFloatingFilter',
    number: 'agNumberColumnFloatingFilter',
    object: 'agTextColumnFloatingFilter',
    text: 'agTextColumnFloatingFilter',
};
function _getDefaultSimpleFilter(cellDataType, isFloating = false) {
    const filterSet = isFloating ? defaultFloatingFilters : defaultFilters;
    return filterSet[cellDataType ?? 'text'];
}
exports._getDefaultSimpleFilter = _getDefaultSimpleFilter;


/***/ }),

/***/ 5741:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.translateForFilter = void 0;
const localeUtils_1 = __webpack_require__(7230);
const FILTER_LOCALE_TEXT = {
    applyFilter: 'Apply',
    clearFilter: 'Clear',
    resetFilter: 'Reset',
    cancelFilter: 'Cancel',
    textFilter: 'Text Filter',
    numberFilter: 'Number Filter',
    dateFilter: 'Date Filter',
    setFilter: 'Set Filter',
    filterOoo: 'Filter...',
    empty: 'Choose one',
    equals: 'Equals',
    notEqual: 'Does not equal',
    lessThan: 'Less than',
    greaterThan: 'Greater than',
    inRange: 'Between',
    inRangeStart: 'From',
    inRangeEnd: 'To',
    lessThanOrEqual: 'Less than or equal to',
    greaterThanOrEqual: 'Greater than or equal to',
    contains: 'Contains',
    notContains: 'Does not contain',
    startsWith: 'Begins with',
    endsWith: 'Ends with',
    blank: 'Blank',
    notBlank: 'Not blank',
    before: 'Before',
    after: 'After',
    andCondition: 'AND',
    orCondition: 'OR',
    dateFormatOoo: 'yyyy-mm-dd',
    filterSummaryInactive: 'is (All)',
    filterSummaryContains: 'contains',
    filterSummaryNotContains: 'does not contain',
    filterSummaryTextEquals: 'equals',
    filterSummaryTextNotEqual: 'does not equal',
    filterSummaryStartsWith: 'begins with',
    filterSummaryEndsWith: 'ends with',
    filterSummaryBlank: 'is blank',
    filterSummaryNotBlank: 'is not blank',
    filterSummaryEquals: '=',
    filterSummaryNotEqual: '!=',
    filterSummaryGreaterThan: '>',
    filterSummaryGreaterThanOrEqual: '>=',
    filterSummaryLessThan: '<',
    filterSummaryLessThanOrEqual: '<=',
    filterSummaryInRange: 'between',
    filterSummaryInRangeValues: (variableValues) => `(${variableValues[0]}, ${variableValues[1]})`,
    filterSummaryTextQuote: (variableValues) => `"${variableValues[0]}"`,
};
function translateForFilter(bean, key, variableValues) {
    return (0, localeUtils_1._translate)(bean, FILTER_LOCALE_TEXT, key, variableValues);
}
exports.translateForFilter = translateForFilter;


/***/ }),

/***/ 8681:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterManager = void 0;
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
const object_1 = __webpack_require__(6996);
const promise_1 = __webpack_require__(7990);
const logging_1 = __webpack_require__(7764);
class FilterManager extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'filterManager';
        // when we're waiting for cell data types to be inferred, we need to defer filter model updates
        this.advFilterModelUpdateQueue = [];
    }
    wireBeans(beans) {
        this.quickFilter = beans.quickFilter;
        this.advancedFilter = beans.advancedFilter;
        this.colFilter = beans.colFilter;
    }
    postConstruct() {
        const refreshFiltersForAggregations = this.refreshFiltersForAggregations.bind(this);
        const updateAdvFilterColumns = this.updateAdvFilterColumns.bind(this);
        this.addManagedEventListeners({
            columnValueChanged: refreshFiltersForAggregations,
            columnPivotChanged: refreshFiltersForAggregations,
            columnPivotModeChanged: refreshFiltersForAggregations,
            newColumnsLoaded: updateAdvFilterColumns,
            columnVisible: updateAdvFilterColumns,
            advancedFilterEnabledChanged: ({ enabled }) => this.onAdvFilterEnabledChanged(enabled),
            dataTypesInferred: this.processFilterModelUpdateQueue.bind(this),
        });
        this.externalFilterPresent = this.isExternalFilterPresentCallback();
        this.addManagedPropertyListeners(['isExternalFilterPresent', 'doesExternalFilterPass'], () => {
            this.onFilterChanged({ source: 'api' });
        });
        this.updateAggFiltering();
        this.addManagedPropertyListener('groupAggFiltering', () => {
            this.updateAggFiltering();
            this.onFilterChanged();
        });
        if (this.quickFilter) {
            this.addManagedListeners(this.quickFilter, {
                quickFilterChanged: () => this.onFilterChanged({ source: 'quickFilter' }),
            });
        }
        const { gos } = this;
        this.alwaysPassFilter = gos.get('alwaysPassFilter');
        this.addManagedPropertyListener('alwaysPassFilter', () => {
            this.alwaysPassFilter = gos.get('alwaysPassFilter');
            this.onFilterChanged({ source: 'api' });
        });
    }
    isExternalFilterPresentCallback() {
        const isFilterPresent = this.gos.getCallback('isExternalFilterPresent');
        return typeof isFilterPresent === 'function' && isFilterPresent({});
    }
    doesExternalFilterPass(node) {
        const doesFilterPass = this.gos.get('doesExternalFilterPass');
        return typeof doesFilterPass === 'function' && doesFilterPass(node);
    }
    setFilterState(model, state, source = 'api') {
        if (this.isAdvFilterEnabled()) {
            return;
        }
        this.colFilter?.setState(model, state, source);
    }
    setFilterModel(model, source = 'api', skipWarning) {
        if (this.isAdvFilterEnabled()) {
            if (!skipWarning) {
                this.warnAdvFilters();
            }
            return;
        }
        this.colFilter?.setModel(model, source);
    }
    getFilterModel() {
        return this.colFilter?.getModel() ?? {};
    }
    getFilterState() {
        return this.colFilter?.getState();
    }
    isColumnFilterPresent() {
        return !!this.colFilter?.isFilterPresent();
    }
    isAggregateFilterPresent() {
        return !!this.colFilter?.isAggFilterPresent();
    }
    isChildFilterPresent() {
        return (this.isColumnFilterPresent() ||
            this.isQuickFilterPresent() ||
            this.externalFilterPresent ||
            this.isAdvFilterPresent());
    }
    isAnyFilterPresent() {
        return this.isChildFilterPresent() || this.isAggregateFilterPresent();
    }
    isAdvFilterPresent() {
        return this.isAdvFilterEnabled() && this.advancedFilter.isFilterPresent();
    }
    onAdvFilterEnabledChanged(enabled) {
        if (enabled) {
            if (this.colFilter?.disableFilters()) {
                this.onFilterChanged({ source: 'advancedFilter' });
            }
        }
        else {
            if (this.advancedFilter?.isFilterPresent()) {
                this.advancedFilter.setModel(null);
                this.onFilterChanged({ source: 'advancedFilter' });
            }
        }
    }
    isAdvFilterEnabled() {
        return !!this.advancedFilter?.isEnabled();
    }
    isAdvFilterHeaderActive() {
        return this.isAdvFilterEnabled() && this.advancedFilter.isHeaderActive();
    }
    refreshFiltersForAggregations() {
        const isAggFiltering = (0, gridOptionsUtils_1._getGroupAggFiltering)(this.gos);
        if (isAggFiltering) {
            this.onFilterChanged();
        }
    }
    onFilterChanged(params = {}) {
        const { source, additionalEventAttributes, columns = [] } = params;
        this.externalFilterPresent = this.isExternalFilterPresentCallback();
        (this.colFilter ? this.colFilter.updateBeforeFilterChanged(params) : promise_1.AgPromise.resolve()).then(() => {
            const filterChangedEvent = {
                source,
                type: 'filterChanged',
                columns,
            };
            if (additionalEventAttributes) {
                (0, object_1._mergeDeep)(filterChangedEvent, additionalEventAttributes);
            }
            this.eventSvc.dispatchEvent(filterChangedEvent);
            this.colFilter?.updateAfterFilterChanged();
        });
    }
    isSuppressFlashingCellsBecauseFiltering() {
        return !!this.colFilter?.isSuppressFlashingCellsBecauseFiltering();
    }
    isQuickFilterPresent() {
        return !!this.quickFilter?.isFilterPresent();
    }
    updateAggFiltering() {
        this.aggFiltering = !!(0, gridOptionsUtils_1._getGroupAggFiltering)(this.gos);
    }
    isAggregateQuickFilterPresent() {
        return this.isQuickFilterPresent() && this.shouldApplyQuickFilterAfterAgg();
    }
    isNonAggregateQuickFilterPresent() {
        return this.isQuickFilterPresent() && !this.shouldApplyQuickFilterAfterAgg();
    }
    shouldApplyQuickFilterAfterAgg() {
        return ((this.aggFiltering || this.beans.colModel.isPivotMode()) &&
            !this.gos.get('applyQuickFilterBeforePivotOrAgg'));
    }
    doesRowPassOtherFilters(colIdToSkip, rowNode) {
        return this.doesRowPassFilter({ rowNode, colIdToSkip });
    }
    doesRowPassAggregateFilters(params) {
        const { rowNode } = params;
        if (this.alwaysPassFilter?.(rowNode)) {
            return true;
        }
        // check quick filter
        if (this.isAggregateQuickFilterPresent() && !this.quickFilter.doesRowPass(rowNode)) {
            return false;
        }
        if (this.isAggregateFilterPresent() && !this.colFilter.doFiltersPass(rowNode, params.colIdToSkip, true)) {
            return false;
        }
        // got this far, all filters pass
        return true;
    }
    doesRowPassFilter(params) {
        const { rowNode } = params;
        if (this.alwaysPassFilter?.(rowNode)) {
            return true;
        }
        // the row must pass ALL of the filters, so if any of them fail,
        // we return true. that means if a row passes the quick filter,
        // but fails the column filter, it fails overall
        // first up, check quick filter
        if (this.isNonAggregateQuickFilterPresent() && !this.quickFilter.doesRowPass(rowNode)) {
            return false;
        }
        // secondly, give the client a chance to reject this row
        if (this.externalFilterPresent && !this.doesExternalFilterPass(rowNode)) {
            return false;
        }
        // lastly, check column filter
        if (this.isColumnFilterPresent() && !this.colFilter.doFiltersPass(rowNode, params.colIdToSkip)) {
            return false;
        }
        if (this.isAdvFilterPresent() && !this.advancedFilter.doesFilterPass(rowNode)) {
            return false;
        }
        // got this far, all filters pass
        return true;
    }
    // for group filters, can change dynamically whether they are allowed or not
    isFilterAllowed(column) {
        if (this.isAdvFilterEnabled()) {
            return false;
        }
        return !!this.colFilter?.isFilterAllowed(column);
    }
    getAdvFilterModel() {
        return this.isAdvFilterEnabled() ? this.advancedFilter.getModel() : null;
    }
    setAdvFilterModel(expression, source = 'api') {
        if (!this.isAdvFilterEnabled()) {
            return;
        }
        if (this.beans.dataTypeSvc?.isPendingInference) {
            this.advFilterModelUpdateQueue.push(expression);
            return;
        }
        this.advancedFilter.setModel(expression ?? null);
        this.onFilterChanged({ source });
    }
    toggleAdvFilterBuilder(show, source) {
        if (!this.isAdvFilterEnabled()) {
            return;
        }
        this.advancedFilter.getCtrl().toggleFilterBuilder({ source, force: show });
    }
    updateAdvFilterColumns() {
        if (!this.isAdvFilterEnabled()) {
            return;
        }
        if (this.advancedFilter.updateValidity()) {
            this.onFilterChanged({ source: 'advancedFilter' });
        }
    }
    hasFloatingFilters() {
        if (this.isAdvFilterEnabled()) {
            return false;
        }
        return !!this.colFilter?.hasFloatingFilters();
    }
    getColumnFilterInstance(key) {
        if (this.isAdvFilterEnabled()) {
            this.warnAdvFilters();
            return Promise.resolve(undefined);
        }
        return this.colFilter?.getFilterInstance(key) ?? Promise.resolve(undefined);
    }
    warnAdvFilters() {
        // Column Filter API methods have been disabled as Advanced Filters are enabled
        (0, logging_1._warn)(68);
    }
    setupAdvFilterHeaderComp(eCompToInsertBefore) {
        this.advancedFilter?.getCtrl().setupHeaderComp(eCompToInsertBefore);
    }
    getHeaderRowCount() {
        return this.isAdvFilterHeaderActive() ? 1 : 0;
    }
    getHeaderHeight() {
        return this.isAdvFilterHeaderActive() ? this.advancedFilter.getCtrl().getHeaderHeight() : 0;
    }
    processFilterModelUpdateQueue() {
        this.advFilterModelUpdateQueue.forEach((model) => this.setAdvFilterModel(model));
        this.advFilterModelUpdateQueue = [];
    }
    setColumnFilterModel(key, model) {
        if (this.isAdvFilterEnabled()) {
            this.warnAdvFilters();
            return Promise.resolve();
        }
        return this.colFilter?.setModelForColumn(key, model) ?? Promise.resolve();
    }
}
exports.FilterManager = FilterManager;


/***/ }),

/***/ 9665:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterMenuFactory = void 0;
const keyCode_1 = __webpack_require__(9853);
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
const menuService_1 = __webpack_require__(6613);
const dom_1 = __webpack_require__(3507);
const focus_1 = __webpack_require__(2331);
const logging_1 = __webpack_require__(7764);
const filterComp_1 = __webpack_require__(2231);
class FilterMenuFactory extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'filterMenuFactory';
    }
    wireBeans(beans) {
        this.popupSvc = beans.popupSvc;
    }
    hideActiveMenu() {
        this.hidePopup?.();
    }
    showMenuAfterMouseEvent(column, mouseEvent, containerType, onClosedCallback) {
        if (column && !column.isColumn) {
            // not supported
            return;
        }
        this.showPopup(column, (eMenu) => {
            this.popupSvc?.positionPopupUnderMouseEvent({
                column,
                type: containerType,
                mouseEvent,
                ePopup: eMenu,
            });
        }, containerType, mouseEvent.target, (0, gridOptionsUtils_1._isLegacyMenuEnabled)(this.gos), onClosedCallback);
    }
    showMenuAfterButtonClick(column, eventSource, containerType, onClosedCallback) {
        if (column && !column.isColumn) {
            // not supported
            return;
        }
        let multiplier = -1;
        let alignSide = 'left';
        const isLegacyMenuEnabled = (0, gridOptionsUtils_1._isLegacyMenuEnabled)(this.gos);
        if (!isLegacyMenuEnabled && this.gos.get('enableRtl')) {
            multiplier = 1;
            alignSide = 'right';
        }
        const nudgeX = isLegacyMenuEnabled ? undefined : 4 * multiplier;
        const nudgeY = isLegacyMenuEnabled ? undefined : 4;
        this.showPopup(column, (eMenu) => {
            this.popupSvc?.positionPopupByComponent({
                type: containerType,
                eventSource,
                ePopup: eMenu,
                nudgeX,
                nudgeY,
                alignSide,
                keepWithinBounds: true,
                position: 'under',
                column,
            });
        }, containerType, eventSource, isLegacyMenuEnabled, onClosedCallback);
    }
    showPopup(column, positionCallback, containerType, eventSource, isLegacyMenuEnabled, onClosedCallback) {
        const comp = column ? this.createBean(new filterComp_1.FilterComp(column, 'COLUMN_MENU')) : undefined;
        this.activeMenu = comp;
        if (!comp?.hasFilter() || !column) {
            (0, logging_1._error)(57);
            return;
        }
        const eMenu = (0, dom_1._createElement)({
            tag: 'div',
            cls: `ag-menu${!isLegacyMenuEnabled ? ' ag-filter-menu' : ''}`,
            role: 'presentation',
        });
        [this.tabListener] = this.addManagedElementListeners(eMenu, {
            keydown: (e) => this.trapFocusWithin(e, eMenu),
        });
        // eslint-disable-next-line @typescript-eslint/no-non-null-asserted-optional-chain
        eMenu.appendChild(comp?.getGui());
        let hidePopup;
        const afterGuiDetached = () => comp?.afterGuiDetached();
        const anchorToElement = (0, gridOptionsUtils_1._isColumnMenuAnchoringEnabled)(this.gos)
            ? eventSource ?? this.beans.ctrlsSvc.getGridBodyCtrl().eGridBody
            : undefined;
        const closedCallback = (e) => {
            (0, menuService_1._setColMenuVisible)(column, false, 'contextMenu');
            const isKeyboardEvent = e instanceof KeyboardEvent;
            if (this.tabListener) {
                this.tabListener = this.tabListener();
            }
            if (isKeyboardEvent && eventSource && (0, dom_1._isVisible)(eventSource)) {
                const focusableEl = (0, focus_1._findTabbableParent)(eventSource);
                focusableEl?.focus({ preventScroll: true });
            }
            afterGuiDetached();
            this.destroyBean(this.activeMenu);
            this.dispatchVisibleChangedEvent(false, containerType, column);
            onClosedCallback?.();
        };
        const translate = this.getLocaleTextFunc();
        const ariaLabel = isLegacyMenuEnabled && containerType !== 'columnFilter'
            ? translate('ariaLabelColumnMenu', 'Column Menu')
            : translate('ariaLabelColumnFilter', 'Column Filter');
        const addPopupRes = this.popupSvc?.addPopup({
            modal: true,
            eChild: eMenu,
            closeOnEsc: true,
            closedCallback,
            positionCallback: () => positionCallback(eMenu),
            anchorToElement,
            ariaLabel,
        });
        if (addPopupRes) {
            this.hidePopup = hidePopup = addPopupRes.hideFunc;
        }
        comp.afterInit().then(() => {
            // need to make sure the filter is present before positioning, as only
            // after filter it is visible can we find out what the width of it is
            positionCallback(eMenu);
            comp.afterGuiAttached({ container: containerType, hidePopup });
        });
        (0, menuService_1._setColMenuVisible)(column, true, 'contextMenu');
        this.dispatchVisibleChangedEvent(true, containerType, column);
    }
    trapFocusWithin(e, menu) {
        if (e.key !== keyCode_1.KeyCode.TAB ||
            e.defaultPrevented ||
            (0, focus_1._findNextFocusableElement)(this.beans, menu, false, e.shiftKey)) {
            return;
        }
        e.preventDefault();
        (0, focus_1._focusInto)(menu, e.shiftKey);
    }
    dispatchVisibleChangedEvent(visible, containerType, column) {
        this.eventSvc.dispatchEvent({
            type: 'columnMenuVisibleChanged',
            visible,
            switchingTab: false,
            key: containerType,
            column: column ?? null,
            columnGroup: null,
        });
    }
    isMenuEnabled(column) {
        // for standard, we show menu if filter is enabled, and the menu is not suppressed by passing an empty array
        return column.isFilterAllowed() && (column.getColDef().menuTabs ?? ['filterMenuTab']).includes('filterMenuTab');
    }
    showMenuAfterContextMenuEvent() {
        // not supported in standard menu
    }
    destroy() {
        this.destroyBean(this.activeMenu);
        super.destroy();
    }
}
exports.FilterMenuFactory = FilterMenuFactory;


/***/ }),

/***/ 5432:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExternalFilterModule = exports.QuickFilterModule = exports.DateFilterModule = exports.NumberFilterModule = exports.TextFilterModule = exports.CustomFilterModule = exports.ColumnFilterModule = exports.FilterValueModule = exports.FilterCoreModule = exports.ClientSideRowModelFilterModule = void 0;
const filterStage_1 = __webpack_require__(8287);
const headerFilterCellCtrl_1 = __webpack_require__(3868);
const sharedMenuModule_1 = __webpack_require__(3472);
const version_1 = __webpack_require__(7205);
const popupModule_1 = __webpack_require__(3137);
const column_filters_css_GENERATED_1 = __webpack_require__(6331);
const columnFilterApi_1 = __webpack_require__(4527);
const columnFilterService_1 = __webpack_require__(219);
const filterApi_1 = __webpack_require__(9002);
const filterManager_1 = __webpack_require__(8681);
const filterMenuFactory_1 = __webpack_require__(9665);
const filterValueService_1 = __webpack_require__(3508);
const readOnlyFloatingFilter_1 = __webpack_require__(6657);
const dateFilter_1 = __webpack_require__(3725);
const dateFilterHandler_1 = __webpack_require__(6977);
const dateFloatingFilter_1 = __webpack_require__(3091);
const defaultDateComponent_1 = __webpack_require__(5459);
const numberFilter_1 = __webpack_require__(8988);
const numberFilterHandler_1 = __webpack_require__(2927);
const numberFloatingFilter_1 = __webpack_require__(4789);
const textFilter_1 = __webpack_require__(2811);
const textFilterHandler_1 = __webpack_require__(4259);
const textFloatingFilter_1 = __webpack_require__(8305);
const quickFilterApi_1 = __webpack_require__(5381);
const quickFilterService_1 = __webpack_require__(1238);
/**
 * @internal
 */
exports.ClientSideRowModelFilterModule = {
    moduleName: 'ClientSideRowModelFilter',
    version: version_1.VERSION,
    rowModels: ['clientSide'],
    beans: [filterStage_1.FilterStage],
};
/**
 * @internal
 */
exports.FilterCoreModule = {
    moduleName: 'FilterCore',
    version: version_1.VERSION,
    beans: [filterManager_1.FilterManager],
    apiFunctions: {
        isAnyFilterPresent: filterApi_1.isAnyFilterPresent,
        onFilterChanged: filterApi_1.onFilterChanged,
    },
    css: [column_filters_css_GENERATED_1.columnFiltersCSS],
    dependsOn: [exports.ClientSideRowModelFilterModule],
};
/**
 * @internal
 */
exports.FilterValueModule = {
    moduleName: 'FilterValue',
    version: version_1.VERSION,
    beans: [filterValueService_1.FilterValueService],
};
/**
 * @internal
 */
exports.ColumnFilterModule = {
    moduleName: 'ColumnFilter',
    version: version_1.VERSION,
    beans: [columnFilterService_1.ColumnFilterService, filterMenuFactory_1.FilterMenuFactory],
    dynamicBeans: { headerFilterCellCtrl: headerFilterCellCtrl_1.HeaderFilterCellCtrl },
    icons: {
        // open filter button - header, floating filter, menu
        filter: 'filter',
        // filter is applied - header (legacy column menu), filter tool panel
        filterActive: 'filter',
    },
    apiFunctions: {
        isColumnFilterPresent: columnFilterApi_1.isColumnFilterPresent,
        getColumnFilterInstance: columnFilterApi_1.getColumnFilterInstance,
        destroyFilter: columnFilterApi_1.destroyFilter,
        setFilterModel: columnFilterApi_1.setFilterModel,
        getFilterModel: columnFilterApi_1.getFilterModel,
        getColumnFilterModel: columnFilterApi_1.getColumnFilterModel,
        setColumnFilterModel: columnFilterApi_1.setColumnFilterModel,
        showColumnFilter: columnFilterApi_1.showColumnFilter,
        getColumnFilterHandler: columnFilterApi_1.getColumnFilterHandler,
        doFilterAction: columnFilterApi_1.doFilterAction,
    },
    dependsOn: [exports.FilterCoreModule, popupModule_1.PopupModule, exports.FilterValueModule, sharedMenuModule_1.SharedMenuModule],
};
/**
 * @feature Filtering -> Custom Column Filters
 */
exports.CustomFilterModule = {
    moduleName: 'CustomFilter',
    version: version_1.VERSION,
    userComponents: { agReadOnlyFloatingFilter: readOnlyFloatingFilter_1.ReadOnlyFloatingFilter },
    dependsOn: [exports.ColumnFilterModule],
};
/**
 * @feature Filtering -> Text Filter
 */
exports.TextFilterModule = {
    moduleName: 'TextFilter',
    version: version_1.VERSION,
    dependsOn: [exports.ColumnFilterModule],
    userComponents: {
        agTextColumnFilter: {
            classImp: textFilter_1.TextFilter,
            params: {
                useForm: true,
            },
        },
        agTextColumnFloatingFilter: textFloatingFilter_1.TextFloatingFilter,
    },
    dynamicBeans: {
        agTextColumnFilterHandler: textFilterHandler_1.TextFilterHandler,
    },
};
/**
 * @feature Filtering -> Number Filter
 */
exports.NumberFilterModule = {
    moduleName: 'NumberFilter',
    version: version_1.VERSION,
    dependsOn: [exports.ColumnFilterModule],
    userComponents: {
        agNumberColumnFilter: {
            classImp: numberFilter_1.NumberFilter,
            params: {
                useForm: true,
            },
        },
        agNumberColumnFloatingFilter: numberFloatingFilter_1.NumberFloatingFilter,
    },
    dynamicBeans: {
        agNumberColumnFilterHandler: numberFilterHandler_1.NumberFilterHandler,
    },
};
/**
 * @feature Filtering -> Date Filter
 */
exports.DateFilterModule = {
    moduleName: 'DateFilter',
    version: version_1.VERSION,
    dependsOn: [exports.ColumnFilterModule],
    userComponents: {
        agDateColumnFilter: {
            classImp: dateFilter_1.DateFilter,
            params: {
                useForm: true,
            },
        },
        agDateInput: defaultDateComponent_1.DefaultDateComponent,
        agDateColumnFloatingFilter: dateFloatingFilter_1.DateFloatingFilter,
    },
    dynamicBeans: {
        agDateColumnFilterHandler: dateFilterHandler_1.DateFilterHandler,
    },
};
/**
 * @internal
 */
const QuickFilterCoreModule = {
    moduleName: 'QuickFilterCore',
    version: version_1.VERSION,
    rowModels: ['clientSide'],
    beans: [quickFilterService_1.QuickFilterService],
    dependsOn: [exports.FilterCoreModule, exports.FilterValueModule],
};
/**
 * @feature Filtering -> Quick Filter
 * @gridOption quickFilterText
 */
exports.QuickFilterModule = {
    moduleName: 'QuickFilter',
    version: version_1.VERSION,
    apiFunctions: {
        isQuickFilterPresent: quickFilterApi_1.isQuickFilterPresent,
        getQuickFilter: quickFilterApi_1.getQuickFilter,
        resetQuickFilter: quickFilterApi_1.resetQuickFilter,
    },
    dependsOn: [QuickFilterCoreModule],
};
/**
 * @feature Filtering -> External Filter
 * @gridOption doesExternalFilterPass
 */
exports.ExternalFilterModule = {
    moduleName: 'ExternalFilter',
    version: version_1.VERSION,
    dependsOn: [exports.FilterCoreModule],
};


/***/ }),

/***/ 3508:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterValueService = void 0;
const beanStub_1 = __webpack_require__(8731);
const gridOptionsUtils_1 = __webpack_require__(7274);
class FilterValueService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'filterValueSvc';
    }
    getValue(column, rowNode, filterValueGetterOverride) {
        if (!rowNode) {
            return;
        }
        const colDef = column.getColDef();
        const { selectableFilter, valueSvc } = this.beans;
        const filterValueGetter = filterValueGetterOverride ??
            selectableFilter?.getFilterValueGetter(column.getColId()) ??
            colDef.filterValueGetter;
        if (filterValueGetter) {
            return this.executeFilterValueGetter(filterValueGetter, rowNode.data, column, rowNode, colDef);
        }
        return valueSvc.getValue(column, rowNode);
    }
    executeFilterValueGetter(
    // eslint-disable-next-line @typescript-eslint/ban-types
    valueGetter, data, column, node, colDef) {
        const { expressionSvc, valueSvc } = this.beans;
        const params = (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            data,
            node,
            column,
            colDef,
            getValue: valueSvc.getValueCallback.bind(valueSvc, node),
        });
        if (typeof valueGetter === 'function') {
            return valueGetter(params);
        }
        return expressionSvc?.evaluate(valueGetter, params);
    }
}
exports.FilterValueService = FilterValueService;


/***/ }),

/***/ 1854:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterWrapperComp = void 0;
const keyCode_1 = __webpack_require__(9853);
const dom_1 = __webpack_require__(3507);
const generic_1 = __webpack_require__(4422);
const component_1 = __webpack_require__(8020);
const filterButtonComp_1 = __webpack_require__(1371);
const providedFilterUtils_1 = __webpack_require__(6808);
/** Used with filter handlers. This adds filter buttons. */
class FilterWrapperComp extends component_1.Component {
    constructor(column, wrapper, eventParent, updateModel, isGlobalButtons, enableGlobalButtonCheck) {
        super();
        this.column = column;
        this.wrapper = wrapper;
        this.eventParent = eventParent;
        this.updateModel = updateModel;
        this.isGlobalButtons = isGlobalButtons;
        this.enableGlobalButtonCheck = enableGlobalButtonCheck;
        this.hidePopup = null;
        this.applyActive = false;
    }
    postConstruct() {
        const { comp, params: originalParams } = this.wrapper;
        const params = originalParams;
        const useForm = params.useForm;
        const tag = useForm ? 'form' : 'div';
        this.setTemplate({
            tag,
            cls: 'ag-filter-wrapper',
        });
        if (useForm) {
            this.addManagedElementListeners(this.getGui(), {
                submit: (e) => {
                    e?.preventDefault();
                },
                keydown: this.handleKeyDown.bind(this),
            });
        }
        this.appendChild(comp.getGui());
        this.params = params;
        this.resetButtonsPanel(params);
        this.addManagedListeners(this.eventParent, {
            filterParamsChanged: ({ column, params: eventParams }) => {
                if (column === this.column) {
                    this.resetButtonsPanel(eventParams, this.params);
                }
            },
            filterStateChanged: ({ column, state }) => {
                if (column === this.column) {
                    this.eButtons?.updateValidity(state.valid);
                }
            },
            filterAction: ({ column, action, event: keyboardEvent }) => {
                if (column === this.column) {
                    this.afterAction(action, keyboardEvent);
                }
            },
            ...(this.enableGlobalButtonCheck
                ? {
                    filterGlobalButtons: ({ isGlobal }) => {
                        if (isGlobal !== this.isGlobalButtons) {
                            this.isGlobalButtons = isGlobal;
                            const currentParams = this.params;
                            this.resetButtonsPanel(currentParams, currentParams, true);
                        }
                    },
                }
                : undefined),
        });
    }
    afterGuiAttached(params) {
        if (params) {
            this.hidePopup = params.hidePopup;
        }
    }
    resetButtonsPanel(newParams, oldParams, forceUpdate) {
        const { buttons: oldButtons, readOnly: oldReadOnly } = oldParams ?? {};
        const { buttons, readOnly, useForm } = newParams;
        if (!forceUpdate && oldReadOnly === readOnly && (0, generic_1._jsonEquals)(oldButtons, buttons)) {
            return;
        }
        const hasButtons = buttons && buttons.length > 0 && !newParams.readOnly && !this.isGlobalButtons;
        let eButtonsPanel = this.eButtons;
        if (hasButtons) {
            this.applyActive = (0, providedFilterUtils_1._isUseApplyButton)(this.params);
            if (!eButtonsPanel) {
                eButtonsPanel = this.createBean(new filterButtonComp_1.FilterButtonComp());
                this.appendChild(eButtonsPanel.getGui());
                const column = this.column;
                const getListener = (action) => ({ event }) => {
                    this.updateModel(column, action);
                    this.afterAction(action, event);
                };
                eButtonsPanel?.addManagedListeners(eButtonsPanel, {
                    apply: getListener('apply'),
                    clear: getListener('clear'),
                    reset: getListener('reset'),
                    cancel: getListener('cancel'),
                });
                this.eButtons = eButtonsPanel;
            }
            eButtonsPanel.updateButtons(buttons, useForm);
        }
        else {
            this.applyActive = false;
            if (eButtonsPanel) {
                (0, dom_1._removeFromParent)(eButtonsPanel.getGui());
                this.eButtons = this.destroyBean(eButtonsPanel);
            }
        }
    }
    close(e) {
        const hidePopup = this.hidePopup;
        if (!hidePopup) {
            return;
        }
        const keyboardEvent = e;
        const key = keyboardEvent && keyboardEvent.key;
        let params;
        if (key === keyCode_1.KeyCode.ENTER || key === keyCode_1.KeyCode.SPACE) {
            params = { keyboardEvent };
        }
        hidePopup(params);
        this.hidePopup = null;
    }
    afterAction(action, event) {
        const { params, applyActive } = this;
        const closeOnApply = params?.closeOnApply;
        switch (action) {
            case 'apply': {
                // Prevent form submission
                event?.preventDefault();
                if (closeOnApply && applyActive) {
                    this.close(event);
                }
                break;
            }
            case 'reset': {
                if (closeOnApply && applyActive) {
                    this.close();
                }
                break;
            }
            case 'cancel': {
                if (closeOnApply) {
                    this.close(event);
                }
                break;
            }
        }
    }
    handleKeyDown(event) {
        if (!event.defaultPrevented && event.key === keyCode_1.KeyCode.ENTER && this.applyActive) {
            // trigger apply. Can't do this via form submit as it will use click event, which prevents restoring focus on close
            this.updateModel(this.column, 'apply');
            this.afterAction('apply', event);
        }
    }
    destroy() {
        this.hidePopup = null;
        this.eButtons = this.destroyBean(this.eButtons);
    }
}
exports.FilterWrapperComp = FilterWrapperComp;


/***/ }),

/***/ 9990:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getDefaultFloatingFilterType = void 0;
const userCompUtils_1 = __webpack_require__(2036);
function _getDefaultFloatingFilterType(frameworkOverrides, def, getFromDefault) {
    if (def == null) {
        return null;
    }
    let defaultFloatingFilterType = null;
    const { compName, jsComp, fwComp } = (0, userCompUtils_1._getFilterCompKeys)(frameworkOverrides, def);
    if (compName) {
        const floatingFilterTypeMap = {
            agSetColumnFilter: 'agSetColumnFloatingFilter',
            agMultiColumnFilter: 'agMultiColumnFloatingFilter',
            agGroupColumnFilter: 'agGroupColumnFloatingFilter',
            agNumberColumnFilter: 'agNumberColumnFloatingFilter',
            agDateColumnFilter: 'agDateColumnFloatingFilter',
            agTextColumnFilter: 'agTextColumnFloatingFilter',
        };
        // will be undefined if not in the map
        defaultFloatingFilterType = floatingFilterTypeMap[compName];
    }
    else {
        const usingDefaultFilter = jsComp == null && fwComp == null && def.filter === true;
        if (usingDefaultFilter) {
            defaultFloatingFilterType = getFromDefault();
        }
    }
    return defaultFloatingFilterType;
}
exports._getDefaultFloatingFilterType = _getDefaultFloatingFilterType;


/***/ }),

/***/ 7287:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FloatingFilterTextInputService = void 0;
const beanStub_1 = __webpack_require__(8731);
const agInputTextField_1 = __webpack_require__(5946);
const component_1 = __webpack_require__(8020);
class FloatingFilterTextInputService extends beanStub_1.BeanStub {
    constructor(params) {
        super();
        this.params = params;
        this.eInput = component_1.RefPlaceholder;
        this.onValueChanged = () => { };
    }
    setupGui(parentElement) {
        this.eInput = this.createManagedBean(new agInputTextField_1.AgInputTextField(this.params?.config));
        const eInput = this.eInput.getGui();
        parentElement.appendChild(eInput);
        const listener = (e) => this.onValueChanged(e);
        this.addManagedListeners(eInput, {
            input: listener,
            keydown: listener,
        });
    }
    setEditable(editable) {
        this.eInput.setDisabled(!editable);
    }
    getValue() {
        return this.eInput.getValue();
    }
    setValue(value, silent) {
        this.eInput.setValue(value, silent);
    }
    setValueChangedListener(listener) {
        this.onValueChanged = listener;
    }
    setParams({ ariaLabel, autoComplete }) {
        const { eInput } = this;
        eInput.setInputAriaLabel(ariaLabel);
        if (autoComplete !== undefined) {
            eInput.setAutoComplete(autoComplete);
        }
    }
}
exports.FloatingFilterTextInputService = FloatingFilterTextInputService;


/***/ }),

/***/ 6657:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReadOnlyFloatingFilter = void 0;
const agInputTextField_1 = __webpack_require__(5946);
const component_1 = __webpack_require__(8020);
const ReadOnlyFloatingFilterElement = {
    tag: 'div',
    cls: 'ag-floating-filter-input',
    role: 'presentation',
    children: [
        {
            tag: 'ag-input-text-field',
            ref: 'eFloatingFilterText',
        },
    ],
};
// optional floating filter for user provided filters - instead of providing a floating filter,
// they can provide a getModelAsString() method on the filter instead. this class just displays
// the string returned from getModelAsString()
class ReadOnlyFloatingFilter extends component_1.Component {
    constructor() {
        super(ReadOnlyFloatingFilterElement, [agInputTextField_1.AgInputTextFieldSelector]);
        this.eFloatingFilterText = component_1.RefPlaceholder;
    }
    init(params) {
        this.params = params;
        const displayName = this.beans.colNames.getDisplayNameForColumn(params.column, 'header', true);
        this.eFloatingFilterText
            .setDisabled(true)
            .setInputAriaLabel(`${displayName} ${this.getLocaleTextFunc()('ariaFilterInput', 'Filter Input')}`);
        if (this.gos.get('enableFilterHandlers')) {
            const reactiveParams = params;
            const handler = reactiveParams.getHandler();
            if (handler.getModelAsString) {
                const modelAsString = handler.getModelAsString(reactiveParams.model);
                this.eFloatingFilterText.setValue(modelAsString);
            }
        }
    }
    onParentModelChanged(parentModel) {
        if (parentModel == null) {
            this.eFloatingFilterText.setValue('');
            return;
        }
        this.params.parentFilterInstance((filterInstance) => {
            // it would be nice to check if getModelAsString was present before creating this component,
            // however that is not possible, as React Hooks and VueJS don't attached the methods to the Filter until
            // AFTER the filter is created, not allowing inspection before this (we create floating filters as columns
            // are drawn, but the parent filters are only created when needed).
            if (filterInstance.getModelAsString) {
                const modelAsString = filterInstance.getModelAsString(parentModel);
                this.eFloatingFilterText.setValue(modelAsString);
            }
        });
    }
    refresh(params) {
        this.init(params);
    }
}
exports.ReadOnlyFloatingFilter = ReadOnlyFloatingFilter;


/***/ }),

/***/ 3141:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleFloatingFilter = void 0;
const component_1 = __webpack_require__(8020);
const optionsFactory_1 = __webpack_require__(4824);
class SimpleFloatingFilter extends component_1.Component {
    constructor() {
        super(...arguments);
        this.defaultDebounceMs = 0;
    }
    setLastTypeFromModel(model) {
        // if no model provided by the parent filter use default
        if (!model) {
            this.lastType = this.optionsFactory.defaultOption;
            return;
        }
        const isCombined = model.operator;
        let condition;
        if (isCombined) {
            const combinedModel = model;
            condition = combinedModel.conditions[0];
        }
        else {
            condition = model;
        }
        this.lastType = condition.type;
    }
    canWeEditAfterModelFromParentFilter(model) {
        if (!model) {
            // if no model, then we can edit as long as the lastType is something we can edit, as this
            // is the type we will provide to the parent filter if the user decides to use the floating filter.
            return this.isTypeEditable(this.lastType);
        }
        // never allow editing if the filter is combined (ie has two parts)
        const isCombined = model.operator;
        if (isCombined) {
            return false;
        }
        const simpleModel = model;
        return this.isTypeEditable(simpleModel.type);
    }
    init(params) {
        this.params = params;
        const reactive = this.gos.get('enableFilterHandlers');
        this.reactive = reactive;
        this.setParams(params);
        if (reactive) {
            const reactiveParams = params;
            this.onModelUpdated(reactiveParams.model);
        }
    }
    setParams(params) {
        const optionsFactory = new optionsFactory_1.OptionsFactory();
        this.optionsFactory = optionsFactory;
        optionsFactory.init(params.filterParams, this.defaultOptions);
        this.filterModelFormatter = this.createManagedBean(new this.FilterModelFormatterClass(optionsFactory, params.filterParams));
        this.setSimpleParams(params, false);
    }
    setSimpleParams(params, update = true) {
        const defaultOption = this.optionsFactory.defaultOption;
        // Initial call
        if (!update) {
            this.lastType = defaultOption;
        }
        // readOnly is a property of IProvidedFilterParams - we need to find a better (type-safe)
        // way to support reading this in the future.
        this.readOnly = !!params.filterParams.readOnly;
        // we are editable if:
        // 1) there is a type (user has configured filter wrong if not type)
        //  AND
        // 2) the default type is not 'inRange'
        const editable = this.isTypeEditable(defaultOption);
        this.setEditable(editable);
    }
    refresh(params) {
        this.params = params;
        const reactiveParams = params;
        const reactive = this.reactive;
        if (!reactive || reactiveParams.source === 'colDef') {
            this.updateParams(params);
        }
        if (reactive) {
            const { source, model } = reactiveParams;
            if (source === 'dataChanged' || source === 'ui') {
                return;
            }
            this.onModelUpdated(model);
        }
    }
    updateParams(params) {
        const optionsFactory = this.optionsFactory;
        optionsFactory.refresh(params.filterParams, this.defaultOptions);
        this.setSimpleParams(params);
        this.filterModelFormatter.updateParams({
            optionsFactory,
            filterParams: params.filterParams,
        });
    }
    onParentModelChanged(model, event) {
        // We don't want to update the floating filter if the floating filter caused the change,
        // because the UI is already in sync. if we didn't do this, the UI would behave strangely
        // as it would be updating as the user is typing.
        // This is similar for data changes, which don't affect simple floating filters
        if (event?.afterFloatingFilter || event?.afterDataChange) {
            return;
        }
        this.onModelUpdated(model);
    }
    hasSingleInput(filterType) {
        const numberOfInputs = this.optionsFactory.getCustomOption(filterType)?.numberOfInputs;
        return numberOfInputs == null || numberOfInputs == 1;
    }
    isTypeEditable(type) {
        const uneditableTypes = ['inRange', 'empty', 'blank', 'notBlank'];
        return (!!type &&
            !this.readOnly &&
            this.hasSingleInput(type) &&
            uneditableTypes.indexOf(type) < 0);
    }
    getAriaLabel(params) {
        const displayName = this.beans.colNames.getDisplayNameForColumn(params.column, 'header', true);
        return `${displayName} ${this.getLocaleTextFunc()('ariaFilterInput', 'Filter Input')}`;
    }
}
exports.SimpleFloatingFilter = SimpleFloatingFilter;


/***/ }),

/***/ 8922:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextInputFloatingFilter = void 0;
const keyCode_1 = __webpack_require__(9853);
const dom_1 = __webpack_require__(3507);
const function_1 = __webpack_require__(2043);
const component_1 = __webpack_require__(8020);
const providedFilterUtils_1 = __webpack_require__(6808);
const textFilterUtils_1 = __webpack_require__(2470);
const simpleFloatingFilter_1 = __webpack_require__(3141);
const TextInputFloatingFilterElement = {
    tag: 'div',
    ref: 'eFloatingFilterInputContainer',
    cls: 'ag-floating-filter-input',
    role: 'presentation',
};
class TextInputFloatingFilter extends simpleFloatingFilter_1.SimpleFloatingFilter {
    constructor() {
        super(...arguments);
        this.eFloatingFilterInputContainer = component_1.RefPlaceholder;
        this.defaultDebounceMs = 500;
    }
    postConstruct() {
        this.setTemplate(TextInputFloatingFilterElement);
    }
    onModelUpdated(model) {
        this.setLastTypeFromModel(model);
        this.setEditable(this.canWeEditAfterModelFromParentFilter(model));
        this.inputSvc.setValue(this.filterModelFormatter.getModelAsString(model));
    }
    setParams(params) {
        this.setupFloatingFilterInputService(params);
        super.setParams(params);
        this.setTextInputParams(params);
    }
    setupFloatingFilterInputService(params) {
        this.inputSvc = this.createFloatingFilterInputService(params);
        this.inputSvc.setupGui(this.eFloatingFilterInputContainer);
    }
    setTextInputParams(params) {
        const autoComplete = params.browserAutoComplete ?? false;
        const { inputSvc, defaultDebounceMs, readOnly } = this;
        inputSvc.setParams({
            ariaLabel: this.getAriaLabel(params),
            autoComplete,
        });
        this.applyActive = (0, providedFilterUtils_1._isUseApplyButton)(params.filterParams);
        if (!readOnly) {
            const debounceMs = (0, providedFilterUtils_1.getDebounceMs)(params.filterParams, defaultDebounceMs);
            const toDebounce = (0, function_1._debounce)(this, this.syncUpWithParentFilter.bind(this), debounceMs);
            inputSvc.setValueChangedListener(toDebounce);
        }
    }
    updateParams(params) {
        super.updateParams(params);
        this.setTextInputParams(params);
    }
    recreateFloatingFilterInputService(params) {
        const { inputSvc } = this;
        const value = inputSvc.getValue();
        (0, dom_1._clearElement)(this.eFloatingFilterInputContainer);
        this.destroyBean(inputSvc);
        this.setupFloatingFilterInputService(params);
        inputSvc.setValue(value, true);
    }
    syncUpWithParentFilter(e) {
        const isEnterKey = e.key === keyCode_1.KeyCode.ENTER;
        const reactive = this.reactive;
        if (reactive) {
            const reactiveParams = this.params;
            reactiveParams.onUiChange();
        }
        if (this.applyActive && !isEnterKey) {
            return;
        }
        const { inputSvc, params, lastType } = this;
        let value = inputSvc.getValue();
        if (params.filterParams.trimInput) {
            value = (0, textFilterUtils_1.trimInputForFilter)(value);
            inputSvc.setValue(value, true); // ensure visible value is trimmed
        }
        if (reactive) {
            const reactiveParams = params;
            const model = reactiveParams.model;
            const parsedValue = this.convertValue(value);
            const newModel = parsedValue == null
                ? null
                : {
                    ...(model ?? {
                        filterType: this.filterType,
                        type: lastType ?? this.optionsFactory.defaultOption,
                    }),
                    filter: parsedValue,
                };
            reactiveParams.onModelChange(newModel, { afterFloatingFilter: true });
        }
        else {
            params.parentFilterInstance((filterInstance) => {
                // NumberFilter is typed as number, but actually receives string values
                filterInstance?.onFloatingFilterChanged(lastType || null, value || null);
            });
        }
    }
    convertValue(value) {
        return value || null; // '' to null
    }
    setEditable(editable) {
        this.inputSvc.setEditable(editable);
    }
}
exports.TextInputFloatingFilter = TextInputFloatingFilter;


/***/ }),

/***/ 8713:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DateCompWrapper = void 0;
const userCompUtils_1 = __webpack_require__(2036);
const dom_1 = __webpack_require__(3507);
/** Provides sync access to async component. Date component can be lazy created - this class encapsulates
 * this by keeping value locally until DateComp has loaded, then passing DateComp the value. */
class DateCompWrapper {
    constructor(context, userCompFactory, colDef, dateComponentParams, eParent, onReady) {
        this.alive = true;
        this.context = context;
        this.eParent = eParent;
        const compDetails = (0, userCompUtils_1._getDateCompDetails)(userCompFactory, colDef, dateComponentParams);
        if (!compDetails) {
            return;
        }
        compDetails.newAgStackInstance().then((dateComp) => {
            // because async, check the filter still exists after component comes back
            if (!this.alive) {
                context.destroyBean(dateComp);
                return;
            }
            this.dateComp = dateComp;
            if (!dateComp) {
                return;
            }
            eParent.appendChild(dateComp.getGui());
            dateComp?.afterGuiAttached?.();
            const { tempValue, disabled } = this;
            if (tempValue) {
                dateComp.setDate(tempValue);
            }
            if (disabled != null) {
                dateComp.setDisabled?.(disabled);
            }
            onReady?.(this);
        });
    }
    destroy() {
        this.alive = false;
        this.dateComp = this.context.destroyBean(this.dateComp);
    }
    getDate() {
        return this.dateComp ? this.dateComp.getDate() : this.tempValue;
    }
    setDate(value) {
        const dateComp = this.dateComp;
        if (dateComp) {
            dateComp.setDate(value);
        }
        else {
            this.tempValue = value;
        }
    }
    setDisabled(disabled) {
        const dateComp = this.dateComp;
        if (dateComp) {
            dateComp.setDisabled?.(disabled);
        }
        else {
            this.disabled = disabled;
        }
    }
    setDisplayed(displayed) {
        (0, dom_1._setDisplayed)(this.eParent, displayed);
    }
    setInputPlaceholder(placeholder) {
        this.dateComp?.setInputPlaceholder?.(placeholder);
    }
    setInputAriaLabel(label) {
        this.dateComp?.setInputAriaLabel?.(label);
    }
    afterGuiAttached(params) {
        this.dateComp?.afterGuiAttached?.(params);
    }
    updateParams(params) {
        this.dateComp?.refresh?.(params);
    }
}
exports.DateCompWrapper = DateCompWrapper;


/***/ }),

/***/ 3725:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DateFilter = void 0;
const gridOptionsUtils_1 = __webpack_require__(7274);
const date_1 = __webpack_require__(9827);
const dom_1 = __webpack_require__(3507);
const logging_1 = __webpack_require__(7764);
const simpleFilter_1 = __webpack_require__(5220);
const simpleFilterUtils_1 = __webpack_require__(7535);
const dateCompWrapper_1 = __webpack_require__(8713);
const dateFilterConstants_1 = __webpack_require__(4200);
const dateFilterUtils_1 = __webpack_require__(7392);
const DEFAULT_MIN_YEAR = 1000;
const DEFAULT_MAX_YEAR = Infinity;
class DateFilter extends simpleFilter_1.SimpleFilter {
    constructor() {
        super('dateFilter', dateFilterUtils_1.mapValuesFromDateFilterModel, dateFilterConstants_1.DEFAULT_DATE_FILTER_OPTIONS);
        this.eConditionPanelsFrom = [];
        this.eConditionPanelsTo = [];
        this.dateConditionFromComps = [];
        this.dateConditionToComps = [];
        this.minValidYear = DEFAULT_MIN_YEAR;
        this.maxValidYear = DEFAULT_MAX_YEAR;
        this.minValidDate = null;
        this.maxValidDate = null;
        this.filterType = 'date';
    }
    afterGuiAttached(params) {
        super.afterGuiAttached(params);
        this.dateConditionFromComps[0].afterGuiAttached(params);
    }
    commonUpdateSimpleParams(params) {
        super.commonUpdateSimpleParams(params);
        const yearParser = (param, fallback) => {
            const value = params[param];
            if (value != null) {
                if (!isNaN(value)) {
                    return value == null ? fallback : Number(value);
                }
                else {
                    (0, logging_1._warn)(82, { param });
                }
            }
            return fallback;
        };
        const minValidYear = yearParser('minValidYear', DEFAULT_MIN_YEAR);
        const maxValidYear = yearParser('maxValidYear', DEFAULT_MAX_YEAR);
        this.minValidYear = minValidYear;
        this.maxValidYear = maxValidYear;
        if (minValidYear > maxValidYear) {
            (0, logging_1._warn)(83);
        }
        const { minValidDate, maxValidDate } = params;
        const parsedMinValidDate = minValidDate instanceof Date ? minValidDate : (0, date_1._parseDateTimeFromString)(minValidDate);
        this.minValidDate = parsedMinValidDate;
        const parsedMaxValidDate = maxValidDate instanceof Date ? maxValidDate : (0, date_1._parseDateTimeFromString)(maxValidDate);
        this.maxValidDate = parsedMaxValidDate;
        if (parsedMinValidDate && parsedMaxValidDate && parsedMinValidDate > parsedMaxValidDate) {
            (0, logging_1._warn)(84);
        }
    }
    createDateCompWrapper(element) {
        const { beans: { userCompFactory, context, gos }, params, } = this;
        const dateCompWrapper = new dateCompWrapper_1.DateCompWrapper(context, userCompFactory, params.colDef, (0, gridOptionsUtils_1._addGridCommonParams)(gos, {
            onDateChanged: () => this.onUiChanged(),
            filterParams: params,
            location: 'filter',
        }), element);
        this.addDestroyFunc(() => dateCompWrapper.destroy());
        return dateCompWrapper;
    }
    setElementValue(element, value) {
        element.setDate(value);
    }
    setElementDisplayed(element, displayed) {
        element.setDisplayed(displayed);
    }
    setElementDisabled(element, disabled) {
        element.setDisabled(disabled);
    }
    createEValue() {
        const eCondition = (0, dom_1._createElement)({ tag: 'div', cls: 'ag-filter-body' });
        this.createFromToElement(eCondition, this.eConditionPanelsFrom, this.dateConditionFromComps, 'from');
        this.createFromToElement(eCondition, this.eConditionPanelsTo, this.dateConditionToComps, 'to');
        return eCondition;
    }
    createFromToElement(eCondition, eConditionPanels, dateConditionComps, fromTo) {
        const eConditionPanel = (0, dom_1._createElement)({ tag: 'div', cls: `ag-filter-${fromTo} ag-filter-date-${fromTo}` });
        eConditionPanels.push(eConditionPanel);
        eCondition.appendChild(eConditionPanel);
        dateConditionComps.push(this.createDateCompWrapper(eConditionPanel));
    }
    removeEValues(startPosition, deleteCount) {
        this.removeDateComps(this.dateConditionFromComps, startPosition, deleteCount);
        this.removeDateComps(this.dateConditionToComps, startPosition, deleteCount);
        (0, simpleFilterUtils_1.removeItems)(this.eConditionPanelsFrom, startPosition, deleteCount);
        (0, simpleFilterUtils_1.removeItems)(this.eConditionPanelsTo, startPosition, deleteCount);
    }
    removeDateComps(components, startPosition, deleteCount) {
        const removedComponents = (0, simpleFilterUtils_1.removeItems)(components, startPosition, deleteCount);
        removedComponents.forEach((comp) => comp.destroy());
    }
    isValidDateValue(value) {
        if (value === null) {
            return false;
        }
        const { minValidDate, maxValidDate, minValidYear, maxValidYear } = this;
        if (minValidDate) {
            if (value < minValidDate) {
                return false;
            }
        }
        else {
            if (value.getUTCFullYear() < minValidYear) {
                return false;
            }
        }
        if (maxValidDate) {
            if (value > maxValidDate) {
                return false;
            }
        }
        else {
            if (value.getUTCFullYear() > maxValidYear) {
                return false;
            }
        }
        return true;
    }
    isConditionUiComplete(position) {
        if (!super.isConditionUiComplete(position)) {
            return false;
        }
        let valid = true;
        this.forEachInput((element, index, elPosition, numberOfInputs) => {
            if (elPosition !== position || !valid || index >= numberOfInputs) {
                return;
            }
            valid = valid && this.isValidDateValue(element.getDate());
        });
        return valid;
    }
    areSimpleModelsEqual(aSimple, bSimple) {
        return (aSimple.dateFrom === bSimple.dateFrom && aSimple.dateTo === bSimple.dateTo && aSimple.type === bSimple.type);
    }
    createCondition(position) {
        const type = this.getConditionType(position);
        const model = {};
        const values = this.getValues(position);
        if (values.length > 0) {
            model.dateFrom = (0, date_1._serialiseDate)(values[0]);
        }
        if (values.length > 1) {
            model.dateTo = (0, date_1._serialiseDate)(values[1]);
        }
        return {
            dateFrom: null,
            dateTo: null,
            filterType: this.filterType,
            type,
            ...model,
        };
    }
    resetPlaceholder() {
        const globalTranslate = this.getLocaleTextFunc();
        const placeholder = this.translate('dateFormatOoo');
        const ariaLabel = globalTranslate('ariaFilterValue', 'Filter Value');
        this.forEachInput((element) => {
            element.setInputPlaceholder(placeholder);
            element.setInputAriaLabel(ariaLabel);
        });
    }
    getInputs(position) {
        const { dateConditionFromComps, dateConditionToComps } = this;
        if (position >= dateConditionFromComps.length) {
            return [null, null];
        }
        return [dateConditionFromComps[position], dateConditionToComps[position]];
    }
    getValues(position) {
        const result = [];
        this.forEachPositionInput(position, (element, index, _elPosition, numberOfInputs) => {
            if (index < numberOfInputs) {
                result.push(element.getDate());
            }
        });
        return result;
    }
    translate(key) {
        if (key === 'lessThan') {
            return super.translate('before');
        }
        if (key === 'greaterThan') {
            return super.translate('after');
        }
        return super.translate(key);
    }
}
exports.DateFilter = DateFilter;


/***/ }),

/***/ 4200:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DEFAULT_DATE_FILTER_OPTIONS = void 0;
exports.DEFAULT_DATE_FILTER_OPTIONS = [
    'equals',
    'notEqual',
    'lessThan',
    'greaterThan',
    'inRange',
    'blank',
    'notBlank',
];


/***/ }),

/***/ 6977:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DateFilterHandler = void 0;
const scalarFilterHandler_1 = __webpack_require__(3820);
const dateFilterConstants_1 = __webpack_require__(4200);
const dateFilterModelFormatter_1 = __webpack_require__(4392);
const dateFilterUtils_1 = __webpack_require__(7392);
function defaultDateComparator(filterDate, cellValue) {
    // The default comparator assumes that the cellValue is a date
    const cellAsDate = cellValue;
    if (cellAsDate < filterDate) {
        return -1;
    }
    if (cellAsDate > filterDate) {
        return 1;
    }
    return 0;
}
class DateFilterHandler extends scalarFilterHandler_1.ScalarFilterHandler {
    constructor() {
        super(dateFilterUtils_1.mapValuesFromDateFilterModel, dateFilterConstants_1.DEFAULT_DATE_FILTER_OPTIONS);
        this.filterType = 'date';
        this.FilterModelFormatterClass = dateFilterModelFormatter_1.DateFilterModelFormatter;
    }
    comparator() {
        return this.params.filterParams.comparator ?? defaultDateComparator;
    }
    isValid(value) {
        const isValidDate = this.params.filterParams.isValidDate;
        return !isValidDate || isValidDate(value);
    }
}
exports.DateFilterHandler = DateFilterHandler;


/***/ }),

/***/ 4392:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DateFilterModelFormatter = void 0;
const date_1 = __webpack_require__(9827);
const simpleFilterModelFormatter_1 = __webpack_require__(2786);
class DateFilterModelFormatter extends simpleFilterModelFormatter_1.SimpleFilterModelFormatter {
    constructor(optionsFactory, filterParams) {
        super(optionsFactory, filterParams, (value) => {
            const { dataTypeSvc, valueSvc } = this.beans;
            const column = filterParams.column;
            const dateFormatFn = dataTypeSvc?.getDateFormatterFunction(column);
            const dateStringStringValue = dateFormatFn?.(value ?? undefined);
            return valueSvc.formatValue(column, null, dateStringStringValue);
        });
        this.filterTypeKeys = simpleFilterModelFormatter_1.SCALAR_FILTER_TYPE_KEYS;
    }
    conditionToString(condition, forToolPanel, isRange, customDisplayKey, customDisplayName) {
        const { type } = condition;
        const dateFrom = (0, date_1._parseDateTimeFromString)(condition.dateFrom);
        const dateTo = (0, date_1._parseDateTimeFromString)(condition.dateTo);
        const format = this.filterParams.inRangeFloatingFilterDateFormat;
        const formatDate = forToolPanel
            ? this.formatValue.bind(this)
            : (value) => (0, date_1._dateToFormattedString)(value, format);
        const formattedFrom = () => (dateFrom !== null ? formatDate(dateFrom) : 'null');
        const formattedTo = () => (dateTo !== null ? formatDate(dateTo) : 'null');
        if (forToolPanel) {
            const valueForToolPanel = this.conditionForToolPanel(type, isRange, formattedFrom, formattedTo, customDisplayKey, customDisplayName);
            if (valueForToolPanel != null) {
                return valueForToolPanel;
            }
        }
        if (isRange) {
            return `${formattedFrom()}-${formattedTo()}`;
        }
        if (dateFrom != null) {
            return formatDate(dateFrom);
        }
        // cater for when the type doesn't need a value
        return `${type}`;
    }
}
exports.DateFilterModelFormatter = DateFilterModelFormatter;


/***/ }),

/***/ 7392:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.mapValuesFromDateFilterModel = void 0;
const date_1 = __webpack_require__(9827);
const simpleFilterUtils_1 = __webpack_require__(7535);
function mapValuesFromDateFilterModel(filterModel, optionsFactory) {
    // unlike the other filters, we do two things here:
    // 1) allow for different attribute names (same as done for other filters) (eg the 'from' and 'to'
    //    are in different locations in Date and Number filter models)
    // 2) convert the type (because Date filter uses Dates, however model is 'string')
    //
    // NOTE: The conversion of string to date also removes the timezone - i.e. when user picks
    //       a date from the UI, it will have timezone info in it. This is lost when creating
    //       the model. When we recreate the date again here, it's without a timezone.
    const { dateFrom, dateTo, type } = filterModel || {};
    return [
        (dateFrom && (0, date_1._parseDateTimeFromString)(dateFrom)) || null,
        (dateTo && (0, date_1._parseDateTimeFromString)(dateTo)) || null,
    ].slice(0, (0, simpleFilterUtils_1.getNumberOfInputs)(type, optionsFactory));
}
exports.mapValuesFromDateFilterModel = mapValuesFromDateFilterModel;


/***/ }),

/***/ 3091:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DateFloatingFilter = void 0;
const gridOptionsUtils_1 = __webpack_require__(7274);
const date_1 = __webpack_require__(9827);
const dom_1 = __webpack_require__(3507);
const function_1 = __webpack_require__(2043);
const agInputTextField_1 = __webpack_require__(5946);
const component_1 = __webpack_require__(8020);
const simpleFloatingFilter_1 = __webpack_require__(3141);
const providedFilterUtils_1 = __webpack_require__(6808);
const dateCompWrapper_1 = __webpack_require__(8713);
const dateFilterConstants_1 = __webpack_require__(4200);
const dateFilterModelFormatter_1 = __webpack_require__(4392);
const DateFloatingFilterElement = {
    tag: 'div',
    cls: 'ag-floating-filter-input',
    role: 'presentation',
    children: [
        {
            tag: 'ag-input-text-field',
            ref: 'eReadOnlyText',
        },
        { tag: 'div', ref: 'eDateWrapper', cls: 'ag-date-floating-filter-wrapper' },
    ],
};
class DateFloatingFilter extends simpleFloatingFilter_1.SimpleFloatingFilter {
    constructor() {
        super(DateFloatingFilterElement, [agInputTextField_1.AgInputTextFieldSelector]);
        this.eReadOnlyText = component_1.RefPlaceholder;
        this.eDateWrapper = component_1.RefPlaceholder;
        this.FilterModelFormatterClass = dateFilterModelFormatter_1.DateFilterModelFormatter;
        this.filterType = 'date';
        this.defaultOptions = dateFilterConstants_1.DEFAULT_DATE_FILTER_OPTIONS;
    }
    setParams(params) {
        super.setParams(params);
        this.createDateComponent();
        const translate = this.getLocaleTextFunc();
        this.eReadOnlyText.setDisabled(true).setInputAriaLabel(translate('ariaDateFilterInput', 'Date Filter Input'));
    }
    updateParams(params) {
        super.updateParams(params);
        this.dateComp.updateParams(this.getDateComponentParams());
        this.updateCompOnModelChange(params.currentParentModel());
    }
    updateCompOnModelChange(model) {
        // Update the read-only text field
        const allowEditing = !this.readOnly && this.canWeEditAfterModelFromParentFilter(model);
        this.setEditable(allowEditing);
        if (allowEditing) {
            const dateModel = model ? (0, date_1._parseDateTimeFromString)(model.dateFrom) : null;
            this.dateComp.setDate(dateModel);
            this.eReadOnlyText.setValue('');
        }
        else {
            this.eReadOnlyText.setValue(this.filterModelFormatter.getModelAsString(model));
            this.dateComp.setDate(null);
        }
    }
    setEditable(editable) {
        (0, dom_1._setDisplayed)(this.eDateWrapper, editable);
        (0, dom_1._setDisplayed)(this.eReadOnlyText.getGui(), !editable);
    }
    onModelUpdated(model) {
        super.setLastTypeFromModel(model);
        this.updateCompOnModelChange(model);
    }
    onDateChanged() {
        const filterValueDate = this.dateComp.getDate();
        if (this.reactive) {
            const reactiveParams = this.params;
            reactiveParams.onUiChange();
            const model = reactiveParams.model;
            const filterValueText = (0, date_1._serialiseDate)(filterValueDate);
            const newModel = filterValueText == null
                ? null
                : {
                    ...(model ?? {
                        filterType: this.filterType,
                        type: this.lastType ?? this.optionsFactory.defaultOption,
                    }),
                    dateFrom: filterValueText,
                };
            reactiveParams.onModelChange(newModel, { afterFloatingFilter: true });
        }
        else {
            this.params.parentFilterInstance((filterInstance) => {
                filterInstance?.onFloatingFilterChanged(this.lastType || null, filterValueDate);
            });
        }
    }
    getDateComponentParams() {
        const { filterParams } = this.params;
        const debounceMs = (0, providedFilterUtils_1.getDebounceMs)(filterParams, this.defaultDebounceMs);
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            onDateChanged: (0, function_1._debounce)(this, this.onDateChanged.bind(this), debounceMs),
            filterParams,
            location: 'floatingFilter',
        });
    }
    createDateComponent() {
        const { beans: { context, userCompFactory }, eDateWrapper, params, } = this;
        this.dateComp = new dateCompWrapper_1.DateCompWrapper(context, userCompFactory, params.column.getColDef(), this.getDateComponentParams(), eDateWrapper, (dateComp) => {
            dateComp.setInputAriaLabel(this.getAriaLabel(params));
        });
        this.addDestroyFunc(() => this.dateComp.destroy());
    }
}
exports.DateFloatingFilter = DateFloatingFilter;


/***/ }),

/***/ 5459:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultDateComponent = void 0;
const browser_1 = __webpack_require__(8667);
const date_1 = __webpack_require__(9827);
const logging_1 = __webpack_require__(7764);
const agInputTextField_1 = __webpack_require__(5946);
const component_1 = __webpack_require__(8020);
const DefaultDateElement = {
    tag: 'div',
    cls: 'ag-filter-filter',
    children: [
        {
            tag: 'ag-input-text-field',
            ref: 'eDateInput',
            cls: 'ag-date-filter',
        },
    ],
};
class DefaultDateComponent extends component_1.Component {
    constructor() {
        super(DefaultDateElement, [agInputTextField_1.AgInputTextFieldSelector]);
        this.eDateInput = component_1.RefPlaceholder;
        this.isApply = false;
        this.applyOnFocusOut = false;
    }
    init(params) {
        this.params = params;
        this.setParams(params);
        const inputElement = this.eDateInput.getInputElement();
        this.addManagedListeners(inputElement, {
            // ensures that the input element is focussed when a clear button is clicked,
            // unless using safari as there is no clear button and focus does not work properly
            mouseDown: () => {
                if (this.eDateInput.isDisabled() || this.usingSafariDatePicker) {
                    return;
                }
                inputElement.focus({ preventScroll: true });
            },
            input: this.handleInput.bind(this, false),
            change: this.handleInput.bind(this, true),
            focusout: this.handleFocusOut.bind(this),
        });
    }
    handleInput(isChange) {
        if (this.eDateInput.isDisabled()) {
            return;
        }
        if (this.isApply) {
            // If it's input event, queue up apply on focus out.
            // If it's change, clear and run.
            this.applyOnFocusOut = !isChange;
            if (isChange) {
                this.params.onDateChanged();
            }
            return;
        }
        if (!isChange) {
            // if not apply, execute on input
            this.params.onDateChanged();
        }
    }
    handleFocusOut() {
        if (this.applyOnFocusOut) {
            this.applyOnFocusOut = false;
            this.params.onDateChanged();
        }
    }
    setParams(params) {
        const inputElement = this.eDateInput.getInputElement();
        const shouldUseBrowserDatePicker = this.shouldUseBrowserDatePicker(params);
        this.usingSafariDatePicker = shouldUseBrowserDatePicker && (0, browser_1._isBrowserSafari)();
        const { minValidYear, maxValidYear, minValidDate, maxValidDate, buttons, includeTime, colDef } = params.filterParams || {};
        const dataTypeSvc = this.beans.dataTypeSvc;
        const shouldUseDateTimeLocal = includeTime ?? dataTypeSvc?.getDateIncludesTimeFlag?.(colDef.cellDataType) ?? false;
        if (shouldUseBrowserDatePicker) {
            if (shouldUseDateTimeLocal) {
                inputElement.type = 'datetime-local';
                inputElement.step = '1'; // enforce seconds part to show up by default
            }
            else {
                inputElement.type = 'date';
            }
        }
        else {
            inputElement.type = 'text';
        }
        if (minValidDate && minValidYear) {
            (0, logging_1._warn)(85);
        }
        if (maxValidDate && maxValidYear) {
            (0, logging_1._warn)(86);
        }
        if (minValidDate && maxValidDate) {
            const [parsedMinValidDate, parsedMaxValidDate] = [minValidDate, maxValidDate].map((v) => v instanceof Date ? v : (0, date_1._parseDateTimeFromString)(v));
            if (parsedMinValidDate &&
                parsedMaxValidDate &&
                parsedMinValidDate.getTime() > parsedMaxValidDate.getTime()) {
                (0, logging_1._warn)(87);
            }
        }
        if (minValidDate) {
            if (minValidDate instanceof Date) {
                inputElement.min = (0, date_1._dateToFormattedString)(minValidDate);
            }
            else {
                inputElement.min = minValidDate;
            }
        }
        else {
            if (minValidYear) {
                inputElement.min = `${minValidYear}-01-01`;
            }
        }
        if (maxValidDate) {
            if (maxValidDate instanceof Date) {
                inputElement.max = (0, date_1._dateToFormattedString)(maxValidDate);
            }
            else {
                inputElement.max = maxValidDate;
            }
        }
        else {
            if (maxValidYear) {
                inputElement.max = `${maxValidYear}-12-31`;
            }
        }
        this.isApply = params.location === 'floatingFilter' && !!buttons?.includes('apply');
    }
    refresh(params) {
        this.params = params;
        this.setParams(params);
    }
    getDate() {
        return (0, date_1._parseDateTimeFromString)(this.eDateInput.getValue());
    }
    setDate(date) {
        const colType = this.params.filterParams.colDef.cellDataType;
        const includeTime = this.beans.dataTypeSvc?.getDateIncludesTimeFlag(colType) ?? false;
        this.eDateInput.setValue((0, date_1._serialiseDate)(date, includeTime));
    }
    setInputPlaceholder(placeholder) {
        this.eDateInput.setInputPlaceholder(placeholder);
    }
    setInputAriaLabel(ariaLabel) {
        this.eDateInput.setAriaLabel(ariaLabel);
    }
    setDisabled(disabled) {
        this.eDateInput.setDisabled(disabled);
    }
    afterGuiAttached(params) {
        if (!params || !params.suppressFocus) {
            this.eDateInput.getInputElement().focus({ preventScroll: true });
        }
    }
    shouldUseBrowserDatePicker(params) {
        return params?.filterParams?.browserDatePicker ?? true;
    }
}
exports.DefaultDateComponent = DefaultDateComponent;


/***/ }),

/***/ 8845:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isCombinedFilterModel = void 0;
function isCombinedFilterModel(model) {
    return !!model.operator;
}
exports.isCombinedFilterModel = isCombinedFilterModel;


/***/ }),

/***/ 8988:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NumberFilter = void 0;
const dom_1 = __webpack_require__(3507);
const generic_1 = __webpack_require__(4422);
const agInputNumberField_1 = __webpack_require__(8792);
const agInputTextField_1 = __webpack_require__(5946);
const simpleFilter_1 = __webpack_require__(5220);
const numberFilterConstants_1 = __webpack_require__(846);
const numberFilterUtils_1 = __webpack_require__(730);
class NumberFilter extends simpleFilter_1.SimpleFilter {
    constructor() {
        super('numberFilter', numberFilterUtils_1.mapValuesFromNumberFilterModel, numberFilterConstants_1.DEFAULT_NUMBER_FILTER_OPTIONS);
        this.eValuesFrom = [];
        this.eValuesTo = [];
        this.filterType = 'number';
        this.defaultDebounceMs = 500;
    }
    setElementValue(element, value, fromFloatingFilter) {
        // values from floating filter are directly from the input, not from the model
        const { numberFormatter } = this.params;
        const valueToSet = !fromFloatingFilter && numberFormatter ? numberFormatter(value ?? null) : value;
        super.setElementValue(element, valueToSet);
    }
    createEValue() {
        const allowedCharPattern = (0, numberFilterUtils_1.getAllowedCharPattern)(this.params);
        const eCondition = (0, dom_1._createElement)({ tag: 'div', cls: 'ag-filter-body', role: 'presentation' });
        this.createFromToElement(eCondition, this.eValuesFrom, 'from', allowedCharPattern);
        this.createFromToElement(eCondition, this.eValuesTo, 'to', allowedCharPattern);
        return eCondition;
    }
    createFromToElement(eCondition, eValues, fromTo, allowedCharPattern) {
        const eValue = this.createManagedBean(allowedCharPattern ? new agInputTextField_1.AgInputTextField({ allowedCharPattern }) : new agInputNumberField_1.AgInputNumberField());
        eValue.addCss(`ag-filter-${fromTo}`);
        eValue.addCss('ag-filter-filter');
        eValues.push(eValue);
        eCondition.appendChild(eValue.getGui());
    }
    removeEValues(startPosition, deleteCount) {
        const removeComps = (eGui) => this.removeComponents(eGui, startPosition, deleteCount);
        removeComps(this.eValuesFrom);
        removeComps(this.eValuesTo);
    }
    getValues(position) {
        const result = [];
        this.forEachPositionInput(position, (element, index, _elPosition, numberOfInputs) => {
            if (index < numberOfInputs) {
                result.push((0, numberFilterUtils_1.processNumberFilterValue)(this.stringToFloat(element.getValue())));
            }
        });
        return result;
    }
    areSimpleModelsEqual(aSimple, bSimple) {
        return (aSimple.filter === bSimple.filter && aSimple.filterTo === bSimple.filterTo && aSimple.type === bSimple.type);
    }
    stringToFloat(value) {
        if (typeof value === 'number') {
            return value;
        }
        let filterText = (0, generic_1._makeNull)(value);
        if (filterText != null && filterText.trim() === '') {
            filterText = null;
        }
        const numberParser = this.params.numberParser;
        if (numberParser) {
            return numberParser(filterText);
        }
        return filterText == null || filterText.trim() === '-' ? null : parseFloat(filterText);
    }
    createCondition(position) {
        const type = this.getConditionType(position);
        const model = {
            filterType: this.filterType,
            type,
        };
        const values = this.getValues(position);
        if (values.length > 0) {
            model.filter = values[0];
        }
        if (values.length > 1) {
            model.filterTo = values[1];
        }
        return model;
    }
    getInputs(position) {
        const { eValuesFrom, eValuesTo } = this;
        if (position >= eValuesFrom.length) {
            return [null, null];
        }
        return [eValuesFrom[position], eValuesTo[position]];
    }
    hasInvalidInputs() {
        let invalidInputs = false;
        this.forEachInput((element) => {
            if (!element.getInputElement().validity.valid) {
                invalidInputs = true;
                return;
            }
        });
        return invalidInputs;
    }
}
exports.NumberFilter = NumberFilter;


/***/ }),

/***/ 846:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DEFAULT_NUMBER_FILTER_OPTIONS = void 0;
exports.DEFAULT_NUMBER_FILTER_OPTIONS = [
    'equals',
    'notEqual',
    'greaterThan',
    'greaterThanOrEqual',
    'lessThan',
    'lessThanOrEqual',
    'inRange',
    'blank',
    'notBlank',
];


/***/ }),

/***/ 2927:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NumberFilterHandler = void 0;
const scalarFilterHandler_1 = __webpack_require__(3820);
const numberFilterConstants_1 = __webpack_require__(846);
const numberFilterModelFormatter_1 = __webpack_require__(1862);
const numberFilterUtils_1 = __webpack_require__(730);
class NumberFilterHandler extends scalarFilterHandler_1.ScalarFilterHandler {
    constructor() {
        super(numberFilterUtils_1.mapValuesFromNumberFilterModel, numberFilterConstants_1.DEFAULT_NUMBER_FILTER_OPTIONS);
        this.filterType = 'number';
        this.FilterModelFormatterClass = numberFilterModelFormatter_1.NumberFilterModelFormatter;
    }
    comparator() {
        return (left, right) => {
            if (left === right) {
                return 0;
            }
            return left < right ? 1 : -1;
        };
    }
    isValid(value) {
        return !isNaN(value);
    }
}
exports.NumberFilterHandler = NumberFilterHandler;


/***/ }),

/***/ 1862:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NumberFilterModelFormatter = void 0;
const simpleFilterModelFormatter_1 = __webpack_require__(2786);
class NumberFilterModelFormatter extends simpleFilterModelFormatter_1.SimpleFilterModelFormatter {
    constructor(optionsFactory, filterParams) {
        super(optionsFactory, filterParams, filterParams.numberFormatter);
        this.filterTypeKeys = simpleFilterModelFormatter_1.SCALAR_FILTER_TYPE_KEYS;
    }
    conditionToString(condition, forToolPanel, isRange, customDisplayKey, customDisplayName) {
        const { filter, filterTo, type } = condition;
        const formatValue = this.formatValue.bind(this);
        if (forToolPanel) {
            const valueForToolPanel = this.conditionForToolPanel(type, isRange, () => formatValue(filter), () => formatValue(filterTo), customDisplayKey, customDisplayName);
            if (valueForToolPanel != null) {
                return valueForToolPanel;
            }
        }
        if (isRange) {
            return `${formatValue(filter)}-${formatValue(filterTo)}`;
        }
        // cater for when the type doesn't need a value
        if (filter != null) {
            return formatValue(filter);
        }
        return `${type}`;
    }
}
exports.NumberFilterModelFormatter = NumberFilterModelFormatter;


/***/ }),

/***/ 730:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.mapValuesFromNumberFilterModel = exports.processNumberFilterValue = exports.getAllowedCharPattern = void 0;
const simpleFilterUtils_1 = __webpack_require__(7535);
function getAllowedCharPattern(filterParams) {
    const { allowedCharPattern } = filterParams ?? {};
    return allowedCharPattern ?? null;
}
exports.getAllowedCharPattern = getAllowedCharPattern;
function processNumberFilterValue(value) {
    if (value == null) {
        return null;
    }
    return isNaN(value) ? null : value;
}
exports.processNumberFilterValue = processNumberFilterValue;
function mapValuesFromNumberFilterModel(filterModel, optionsFactory) {
    const { filter, filterTo, type } = filterModel || {};
    return [processNumberFilterValue(filter), processNumberFilterValue(filterTo)].slice(0, (0, simpleFilterUtils_1.getNumberOfInputs)(type, optionsFactory));
}
exports.mapValuesFromNumberFilterModel = mapValuesFromNumberFilterModel;


/***/ }),

/***/ 4789:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NumberFloatingFilter = void 0;
const beanStub_1 = __webpack_require__(8731);
const agInputNumberField_1 = __webpack_require__(8792);
const agInputTextField_1 = __webpack_require__(5946);
const floatingFilterTextInputService_1 = __webpack_require__(7287);
const textInputFloatingFilter_1 = __webpack_require__(8922);
const numberFilterConstants_1 = __webpack_require__(846);
const numberFilterModelFormatter_1 = __webpack_require__(1862);
const numberFilterUtils_1 = __webpack_require__(730);
class FloatingFilterNumberInputService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.onValueChanged = () => { };
        this.numberInputActive = true;
    }
    setupGui(parentElement) {
        this.eNumberInput = this.createManagedBean(new agInputNumberField_1.AgInputNumberField());
        this.eTextInput = this.createManagedBean(new agInputTextField_1.AgInputTextField());
        this.eTextInput.setDisabled(true);
        const eNumberInput = this.eNumberInput.getGui();
        const eTextInput = this.eTextInput.getGui();
        parentElement.appendChild(eNumberInput);
        parentElement.appendChild(eTextInput);
        this.setupListeners(eNumberInput, (e) => this.onValueChanged(e));
        this.setupListeners(eTextInput, (e) => this.onValueChanged(e));
    }
    setEditable(editable) {
        this.numberInputActive = editable;
        this.eNumberInput.setDisplayed(this.numberInputActive);
        this.eTextInput.setDisplayed(!this.numberInputActive);
    }
    setAutoComplete(autoComplete) {
        this.eNumberInput.setAutoComplete(autoComplete);
        this.eTextInput.setAutoComplete(autoComplete);
    }
    getValue() {
        return this.getActiveInputElement().getValue();
    }
    setValue(value, silent) {
        this.getActiveInputElement().setValue(value, silent);
    }
    getActiveInputElement() {
        return this.numberInputActive ? this.eNumberInput : this.eTextInput;
    }
    setValueChangedListener(listener) {
        this.onValueChanged = listener;
    }
    setupListeners(element, listener) {
        this.addManagedListeners(element, {
            input: listener,
            keydown: listener,
        });
    }
    setParams(params) {
        this.setAriaLabel(params.ariaLabel);
        if (params.autoComplete !== undefined) {
            this.setAutoComplete(params.autoComplete);
        }
    }
    setAriaLabel(ariaLabel) {
        this.eNumberInput.setInputAriaLabel(ariaLabel);
        this.eTextInput.setInputAriaLabel(ariaLabel);
    }
}
class NumberFloatingFilter extends textInputFloatingFilter_1.TextInputFloatingFilter {
    constructor() {
        super(...arguments);
        this.FilterModelFormatterClass = numberFilterModelFormatter_1.NumberFilterModelFormatter;
        this.filterType = 'number';
        this.defaultOptions = numberFilterConstants_1.DEFAULT_NUMBER_FILTER_OPTIONS;
    }
    updateParams(params) {
        const allowedCharPattern = (0, numberFilterUtils_1.getAllowedCharPattern)(params.filterParams);
        if (allowedCharPattern !== this.allowedCharPattern) {
            this.recreateFloatingFilterInputService(params);
        }
        super.updateParams(params);
    }
    createFloatingFilterInputService(params) {
        this.allowedCharPattern = (0, numberFilterUtils_1.getAllowedCharPattern)(params.filterParams);
        if (this.allowedCharPattern) {
            // need to use text input
            return this.createManagedBean(new floatingFilterTextInputService_1.FloatingFilterTextInputService({
                config: { allowedCharPattern: this.allowedCharPattern },
            }));
        }
        return this.createManagedBean(new FloatingFilterNumberInputService());
    }
    convertValue(value) {
        return value ? Number(value) : null;
    }
}
exports.NumberFloatingFilter = NumberFloatingFilter;


/***/ }),

/***/ 4824:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OptionsFactory = void 0;
const logging_1 = __webpack_require__(7764);
/* Common logic for options, used by both filters and floating filters. */
class OptionsFactory {
    constructor() {
        this.customFilterOptions = {};
    }
    init(params, defaultOptions) {
        this.filterOptions = params.filterOptions ?? defaultOptions;
        this.mapCustomOptions();
        this.defaultOption = this.getDefaultItem(params.defaultOption);
    }
    refresh(params, defaultOptions) {
        const filterOptions = params.filterOptions ?? defaultOptions;
        if (this.filterOptions !== filterOptions) {
            this.filterOptions = filterOptions;
            this.customFilterOptions = {};
            this.mapCustomOptions();
        }
        this.defaultOption = this.getDefaultItem(params.defaultOption);
    }
    mapCustomOptions() {
        const { filterOptions } = this;
        if (!filterOptions) {
            return;
        }
        filterOptions.forEach((filterOption) => {
            if (typeof filterOption === 'string') {
                return;
            }
            const requiredProperties = [['displayKey'], ['displayName'], ['predicate', 'test']];
            const propertyCheck = (keys) => {
                if (!keys.some((key) => filterOption[key] != null)) {
                    (0, logging_1._warn)(72, { keys });
                    return false;
                }
                return true;
            };
            if (!requiredProperties.every(propertyCheck)) {
                this.filterOptions = filterOptions.filter((v) => v === filterOption) || [];
                return;
            }
            this.customFilterOptions[filterOption.displayKey] = filterOption;
        });
    }
    getDefaultItem(defaultOption) {
        const { filterOptions } = this;
        if (defaultOption) {
            return defaultOption;
        }
        else if (filterOptions.length >= 1) {
            const firstFilterOption = filterOptions[0];
            if (typeof firstFilterOption === 'string') {
                return firstFilterOption;
            }
            else if (firstFilterOption.displayKey) {
                return firstFilterOption.displayKey;
            }
            else {
                // invalid FilterOptionDef supplied as it doesn't contain a 'displayKey
                (0, logging_1._warn)(73);
            }
        }
        else {
            //no filter options for filter
            (0, logging_1._warn)(74);
        }
        return undefined;
    }
    getCustomOption(name) {
        return this.customFilterOptions[name];
    }
}
exports.OptionsFactory = OptionsFactory;


/***/ }),

/***/ 2245:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProvidedFilter = void 0;
const positionableFeature_1 = __webpack_require__(2147);
const function_1 = __webpack_require__(2043);
const logging_1 = __webpack_require__(7764);
const component_1 = __webpack_require__(8020);
const managedFocusFeature_1 = __webpack_require__(1772);
const filterLocaleText_1 = __webpack_require__(5741);
const providedFilterUtils_1 = __webpack_require__(6808);
/**
 * Contains common logic to all provided filters (apply button, clear button, etc).
 * All the filters that come with AG Grid extend this class. User filters do not
 * extend this class.
 *
 * @param M type of filter-model managed by the concrete sub-class that extends this type
 * @param V type of value managed by the concrete sub-class that extends this type
 */
class ProvidedFilter extends component_1.Component {
    constructor(filterNameKey, cssIdentifier) {
        super();
        this.filterNameKey = filterNameKey;
        this.cssIdentifier = cssIdentifier;
        this.applyActive = false;
        this.debouncePending = false;
        // subclasses can override this to provide alternative debounce defaults
        this.defaultDebounceMs = 0;
    }
    postConstruct() {
        const element = {
            tag: 'div',
            cls: `ag-filter-body-wrapper ag-${this.cssIdentifier}-body-wrapper`,
            children: [this.createBodyTemplate()],
        };
        this.setTemplate(element, this.getAgComponents());
        this.createManagedBean(new managedFocusFeature_1.ManagedFocusFeature(this.getFocusableElement(), {
            handleKeyDown: this.handleKeyDown.bind(this),
        }));
        this.positionableFeature = this.createBean(new positionableFeature_1.PositionableFeature(this.getPositionableElement(), {
            forcePopupParentAsOffsetParent: true,
        }));
    }
    handleKeyDown(_e) { }
    init(legacyParams) {
        const params = legacyParams;
        this.setParams(params);
        this.setModelIntoUi(params.state.model, true).then(() => this.updateUiVisibility());
    }
    refresh(legacyNewParams) {
        const newParams = legacyNewParams;
        const oldParams = this.params;
        this.params = newParams;
        const source = newParams.source;
        if (source === 'colDef') {
            this.updateParams(newParams, oldParams);
        }
        const newState = newParams.state;
        const oldState = this.state;
        this.state = newState;
        if (newState.model !== oldState.model || newState.state !== oldState.state) {
            this.setModelIntoUi(newState.model);
        }
        return true;
    }
    /** Called on init only. Override in subclasses */
    setParams(params) {
        this.params = params;
        this.state = params.state;
        this.commonUpdateParams(params);
    }
    /** Called on refresh only. Override in subclasses */
    updateParams(newParams, oldParams) {
        this.commonUpdateParams(newParams, oldParams);
    }
    commonUpdatePara