var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod2) => __copyProps(__defProp({}, "__esModule", { value: true }), mod2);

// packages/ag-grid-community/src/main.ts
var main_exports = {};
__export(main_exports, {
  ALWAYS_SYNC_GLOBAL_EVENTS: () => ALWAYS_SYNC_GLOBAL_EVENTS,
  AbstractClientSideNodeManager: () => AbstractClientSideNodeManager,
  AgAbstractCellEditor: () => AgAbstractCellEditor,
  AgAbstractInputField: () => AgAbstractInputField,
  AgAbstractLabel: () => AgAbstractLabel,
  AgCheckbox: () => AgCheckbox,
  AgCheckboxSelector: () => AgCheckboxSelector,
  AgColumn: () => AgColumn,
  AgColumnGroup: () => AgColumnGroup,
  AgFilterButtonSelector: () => AgFilterButtonSelector,
  AgInputDateField: () => AgInputDateField,
  AgInputNumberField: () => AgInputNumberField,
  AgInputNumberFieldSelector: () => AgInputNumberFieldSelector,
  AgInputTextArea: () => AgInputTextArea,
  AgInputTextField: () => AgInputTextField,
  AgInputTextFieldSelector: () => AgInputTextFieldSelector,
  AgPickerField: () => AgPickerField,
  AgPromise: () => AgPromise,
  AgProvidedColumnGroup: () => AgProvidedColumnGroup,
  AgRadioButton: () => AgRadioButton,
  AgSelect: () => AgSelect,
  AgSelectSelector: () => AgSelectSelector,
  AgToggleButton: () => AgToggleButton,
  AgToggleButtonSelector: () => AgToggleButtonSelector,
  AlignedGridsModule: () => AlignedGridsModule,
  AllCommunityModule: () => AllCommunityModule,
  AutoScrollService: () => AutoScrollService,
  BaseColsService: () => BaseColsService,
  BaseComponentWrapper: () => BaseComponentWrapper,
  BaseCreator: () => BaseCreator,
  BaseGridSerializingSession: () => BaseGridSerializingSession,
  BaseSelectionService: () => BaseSelectionService,
  BeanStub: () => BeanStub,
  CellApiModule: () => CellApiModule,
  CellRangeType: () => CellRangeType,
  CellSpanModule: () => CellSpanModule,
  CellStyleModule: () => CellStyleModule,
  ChangedPath: () => ChangedPath,
  CheckboxEditorModule: () => CheckboxEditorModule,
  ClientSideRowModelApiModule: () => ClientSideRowModelApiModule,
  ClientSideRowModelModule: () => ClientSideRowModelModule,
  ColumnApiModule: () => ColumnApiModule,
  ColumnAutoSizeModule: () => ColumnAutoSizeModule,
  ColumnHoverModule: () => ColumnHoverModule,
  ColumnKeyCreator: () => ColumnKeyCreator,
  Component: () => Component,
  CssClassManager: () => CssClassManager,
  CsvExportModule: () => CsvExportModule,
  CustomEditorModule: () => CustomEditorModule,
  CustomFilterModule: () => CustomFilterModule,
  DateEditorModule: () => DateEditorModule,
  DateFilterModule: () => DateFilterModule,
  Direction: () => Direction,
  DragAndDropModule: () => DragAndDropModule,
  DragSourceType: () => DragSourceType,
  EventApiModule: () => EventApiModule,
  ExternalFilterModule: () => ExternalFilterModule,
  FakeHScrollComp: () => FakeHScrollComp,
  FakeVScrollComp: () => FakeVScrollComp,
  FilterButtonComp: () => FilterButtonComp,
  FilterComp: () => FilterComp,
  FilterWrapperComp: () => FilterWrapperComp,
  GROUP_AUTO_COLUMN_ID: () => GROUP_AUTO_COLUMN_ID,
  GridBodyCtrl: () => GridBodyCtrl,
  GridCoreCreator: () => GridCoreCreator,
  GridCtrl: () => GridCtrl,
  GridHeaderCtrl: () => GridHeaderCtrl,
  GridStateModule: () => GridStateModule,
  GroupInstanceIdCreator: () => GroupInstanceIdCreator,
  HeaderRowContainerCtrl: () => HeaderRowContainerCtrl,
  HighlightChangesModule: () => HighlightChangesModule,
  InfiniteRowModelModule: () => InfiniteRowModelModule,
  KeyCode: () => KeyCode,
  LargeTextEditorModule: () => LargeTextEditorModule,
  LocalEventService: () => LocalEventService,
  LocaleModule: () => LocaleModule,
  LocaleService: () => LocaleService,
  ManagedFocusFeature: () => ManagedFocusFeature,
  ModuleRegistry: () => ModuleRegistry,
  NumberEditorModule: () => NumberEditorModule,
  NumberFilterModule: () => NumberFilterModule,
  PaginationModule: () => PaginationModule,
  PinnedRowModel: () => PinnedRowModel,
  PinnedRowModule: () => PinnedRowModule,
  PopupComponent: () => PopupComponent,
  PositionableFeature: () => PositionableFeature,
  ProvidedFilter: () => ProvidedFilter,
  QuickFilterModule: () => QuickFilterModule,
  ROW_NUMBERS_COLUMN_ID: () => ROW_NUMBERS_COLUMN_ID,
  RefPlaceholder: () => RefPlaceholder,
  RenderApiModule: () => RenderApiModule,
  RowApiModule: () => RowApiModule,
  RowAutoHeightModule: () => RowAutoHeightModule,
  RowContainerCtrl: () => RowContainerCtrl,
  RowDragModule: () => RowDragModule,
  RowNode: () => RowNode,
  RowSelectionModule: () => RowSelectionModule,
  RowStyleModule: () => RowStyleModule,
  SELECTION_COLUMN_ID: () => SELECTION_COLUMN_ID,
  ScrollApiModule: () => ScrollApiModule,
  SelectEditorModule: () => SelectEditorModule,
  ServerSideTransactionResultStatus: () => ServerSideTransactionResultStatus,
  TabGuardClassNames: () => TabGuardClassNames,
  TabGuardComp: () => TabGuardComp,
  TabGuardCtrl: () => TabGuardCtrl,
  TabGuardFeature: () => TabGuardFeature,
  TextEditorModule: () => TextEditorModule,
  TextFilterModule: () => TextFilterModule,
  TooltipFeature: () => TooltipFeature,
  TooltipModule: () => TooltipModule,
  TouchListener: () => TouchListener,
  UndoRedoEditModule: () => UndoRedoEditModule,
  ValidationModule: () => ValidationModule,
  ValueCacheModule: () => ValueCacheModule,
  VanillaFrameworkOverrides: () => VanillaFrameworkOverrides,
  _BOOLEAN_MIXED_GRID_OPTIONS: () => _BOOLEAN_MIXED_GRID_OPTIONS,
  _ColumnFilterModule: () => ColumnFilterModule,
  _ColumnGroupModule: () => ColumnGroupModule,
  _ColumnMoveModule: () => ColumnMoveModule,
  _CsrmSsrmSharedApiModule: () => CsrmSsrmSharedApiModule,
  _DragModule: () => DragModule,
  _EditCoreModule: () => EditCoreModule,
  _EmptyArray: () => _EmptyArray,
  _EmptyBean: () => EmptyBean,
  _FOCUS_MANAGED_CLASS: () => FOCUS_MANAGED_CLASS,
  _FilterCoreModule: () => FilterCoreModule,
  _FilterValueModule: () => FilterValueModule,
  _GET_ALL_EVENTS: () => _GET_ALL_EVENTS,
  _GET_ALL_GRID_OPTIONS: () => _GET_ALL_GRID_OPTIONS,
  _HeaderComp: () => HeaderComp,
  _HorizontalResizeModule: () => HorizontalResizeModule,
  _KeyboardNavigationModule: () => KeyboardNavigationModule,
  _PUBLIC_EVENTS: () => _PUBLIC_EVENTS,
  _PUBLIC_EVENT_HANDLERS_MAP: () => _PUBLIC_EVENT_HANDLERS_MAP,
  _PopupModule: () => PopupModule,
  _ROW_ID_PREFIX_BOTTOM_PINNED: () => ROW_ID_PREFIX_BOTTOM_PINNED,
  _ROW_ID_PREFIX_ROW_GROUP: () => ROW_ID_PREFIX_ROW_GROUP,
  _ROW_ID_PREFIX_TOP_PINNED: () => ROW_ID_PREFIX_TOP_PINNED,
  _SharedDragAndDropModule: () => SharedDragAndDropModule,
  _SharedExportModule: () => SharedExportModule,
  _SharedMenuModule: () => SharedMenuModule,
  _SharedRowSelectionModule: () => SharedRowSelectionModule,
  _SortModule: () => SortModule,
  _SsrmInfiniteSharedApiModule: () => SsrmInfiniteSharedApiModule,
  _addColumnDefaultAndTypes: () => _addColumnDefaultAndTypes,
  _addFocusableContainerListener: () => _addFocusableContainerListener,
  _addGridCommonParams: () => _addGridCommonParams,
  _anchorElementToMouseMoveEvent: () => _anchorElementToMouseMoveEvent,
  _applyColumnState: () => _applyColumnState,
  _areCellsEqual: () => _areCellsEqual,
  _areColIdsEqual: () => _areColIdsEqual,
  _areEqual: () => _areEqual,
  _asThemeImpl: () => _asThemeImpl,
  _batchCall: () => _batchCall,
  _canSkipShowingRowGroup: () => _canSkipShowingRowGroup,
  _clearElement: () => _clearElement,
  _columnsMatch: () => _columnsMatch,
  _combineAttributesAndGridOptions: () => _combineAttributesAndGridOptions,
  _convertColumnEventSourceType: () => _convertColumnEventSourceType,
  _createCellId: () => _createCellId,
  _createColumnTree: () => _createColumnTree,
  _createColumnTreeWithIds: () => _createColumnTreeWithIds,
  _createElement: () => _createElement,
  _createGlobalRowEvent: () => _createGlobalRowEvent,
  _createIcon: () => _createIcon,
  _createIconNoSpan: () => _createIconNoSpan,
  _createRowNodeSibling: () => _createRowNodeSibling,
  _debounce: () => _debounce,
  _defaultComparator: () => _defaultComparator,
  _destroyColumnTree: () => _destroyColumnTree,
  _doOnce: () => _doOnce,
  _downloadFile: () => _downloadFile,
  _errMsg: () => _errMsg,
  _error: () => _error,
  _escapeString: () => _escapeString,
  _exists: () => _exists,
  _findFocusableElements: () => _findFocusableElements,
  _findNextFocusableElement: () => _findNextFocusableElement,
  _findTabbableParent: () => _findTabbableParent,
  _flatten: () => _flatten,
  _focusGridInnerElement: () => _focusGridInnerElement,
  _focusInto: () => _focusInto,
  _focusNextGridCoreContainer: () => _focusNextGridCoreContainer,
  _formatNumberCommas: () => _formatNumberCommas,
  _fuzzySuggestions: () => _fuzzySuggestions,
  _getAbsoluteHeight: () => _getAbsoluteHeight,
  _getAbsoluteWidth: () => _getAbsoluteWidth,
  _getActiveDomElement: () => _getActiveDomElement,
  _getAriaPosInSet: () => _getAriaPosInSet,
  _getCallbackForEvent: () => _getCallbackForEvent,
  _getCellByPosition: () => _getCellByPosition,
  _getCellCtrlForEventTarget: () => _getCellCtrlForEventTarget,
  _getCellPositionForEvent: () => _getCellPositionForEvent,
  _getCellRendererDetails: () => _getCellRendererDetails,
  _getCheckboxLocation: () => _getCheckboxLocation,
  _getCheckboxes: () => _getCheckboxes,
  _getClientSideRowModel: () => _getClientSideRowModel,
  _getColumnState: () => _getColumnState,
  _getColumnsFromTree: () => _getColumnsFromTree,
  _getDateParts: () => _getDateParts,
  _getDefaultFloatingFilterType: () => _getDefaultFloatingFilterType,
  _getDefaultSimpleFilter: () => _getDefaultSimpleFilter,
  _getDocument: () => _getDocument,
  _getEditorRendererDetails: () => _getEditorRendererDetails,
  _getFillHandle: () => _getFillHandle,
  _getFilterDetails: () => _getFilterDetails,
  _getFilterModel: () => _getFilterModel,
  _getFilterParamsForDataType: () => _getFilterParamsForDataType,
  _getFloatingFilterCompDetails: () => _getFloatingFilterCompDetails,
  _getFloatingFiltersHeight: () => getFloatingFiltersHeight,
  _getGlobalGridOption: () => _getGlobalGridOption,
  _getGrandTotalRow: () => _getGrandTotalRow,
  _getGridOption: () => _getGridOption,
  _getGridRegisteredModules: () => _getGridRegisteredModules,
  _getGroupAggFiltering: () => _getGroupAggFiltering,
  _getGroupSelection: () => _getGroupSelection,
  _getGroupSelectsDescendants: () => _getGroupSelectsDescendants,
  _getGroupTotalRowCallback: () => _getGroupTotalRowCallback,
  _getGroupingApproach: () => _getGroupingApproach,
  _getHeaderCheckbox: () => _getHeaderCheckbox,
  _getHeaderClassesFromColDef: () => _getHeaderClassesFromColDef,
  _getHeaderRowCount: () => getHeaderRowCount,
  _getInnerCellRendererDetails: () => _getInnerCellRendererDetails,
  _getInnerHeight: () => _getInnerHeight,
  _getInnerWidth: () => _getInnerWidth,
  _getIsRowSelectable: () => _getIsRowSelectable,
  _getLastRow: () => _getLastRow,
  _getLocaleTextFunc: () => _getLocaleTextFunc,
  _getMaxConcurrentDatasourceRequests: () => _getMaxConcurrentDatasourceRequests,
  _getNormalisedMousePosition: () => _getNormalisedMousePosition,
  _getPageBody: () => _getPageBody,
  _getRootNode: () => _getRootNode,
  _getRowAbove: () => _getRowAbove,
  _getRowBelow: () => _getRowBelow,
  _getRowContainerClass: () => _getRowContainerClass,
  _getRowContainerOptions: () => _getRowContainerOptions,
  _getRowHeightAsNumber: () => _getRowHeightAsNumber,
  _getRowHeightForNode: () => _getRowHeightForNode,
  _getRowIdCallback: () => _getRowIdCallback,
  _getRowNode: () => _getRowNode,
  _getRowSelectionMode: () => _getRowSelectionMode,
  _getRowSpanContainerClass: () => _getRowSpanContainerClass,
  _getRowViewportClass: () => _getRowViewportClass,
  _getServerSideRowModel: () => _getServerSideRowModel,
  _getShouldDisplayTooltip: () => _getShouldDisplayTooltip,
  _getSuppressMultiRanges: () => _getSuppressMultiRanges,
  _getToolPanelClassesFromColDef: () => _getToolPanelClassesFromColDef,
  _interpretAsRightClick: () => _interpretAsRightClick,
  _isAnimateRows: () => _isAnimateRows,
  _isCellSelectionEnabled: () => _isCellSelectionEnabled,
  _isClientSideRowModel: () => _isClientSideRowModel,
  _isColumnMenuAnchoringEnabled: () => _isColumnMenuAnchoringEnabled,
  _isColumnsSortingCoupledToGroup: () => _isColumnsSortingCoupledToGroup,
  _isDomLayout: () => _isDomLayout,
  _isElementInEventPath: () => _isElementInEventPath,
  _isElementOverflowingCallback: () => _isElementOverflowingCallback,
  _isEventFromPrintableCharacter: () => _isEventFromPrintableCharacter,
  _isFullWidthGroupRow: () => _isFullWidthGroupRow,
  _isGetRowHeightFunction: () => _isGetRowHeightFunction,
  _isGroupMultiAutoColumn: () => _isGroupMultiAutoColumn,
  _isGroupRowsSticky: () => _isGroupRowsSticky,
  _isGroupUseEntireRow: () => _isGroupUseEntireRow,
  _isIOSUserAgent: () => _isIOSUserAgent,
  _isKeyboardMode: () => _isKeyboardMode,
  _isLegacyMenuEnabled: () => _isLegacyMenuEnabled,
  _isMultiRowSelection: () => _isMultiRowSelection,
  _isNodeOrElement: () => _isNodeOrElement,
  _isNothingFocused: () => _isNothingFocused,
  _isPromise: () => _isPromise,
  _isRowBefore: () => _isRowBefore,
  _isRowSelection: () => _isRowSelection,
  _isSameRow: () => _isSameRow,
  _isServerSideRowModel: () => _isServerSideRowModel,
  _isSetFilterByDefault: () => _isSetFilterByDefault,
  _isShowTooltipWhenTruncated: () => _isShowTooltipWhenTruncated,
  _isStopPropagationForAgGrid: () => _isStopPropagationForAgGrid,
  _isUseApplyButton: () => _isUseApplyButton,
  _isUsingNewCellSelectionAPI: () => _isUsingNewCellSelectionAPI,
  _isUsingNewRowSelectionAPI: () => _isUsingNewRowSelectionAPI,
  _isVisible: () => _isVisible,
  _jsonEquals: () => _jsonEquals,
  _last: () => _last,
  _loadTemplate: () => _loadTemplate,
  _makeNull: () => _makeNull,
  _mergeDeep: () => _mergeDeep,
  _missing: () => _missing,
  _observeResize: () => _observeResize,
  _parseDateTimeFromString: () => _parseDateTimeFromString,
  _preInitErrMsg: () => _preInitErrMsg,
  _preserveRangesWhile: () => _preserveRangesWhile,
  _processOnChange: () => _processOnChange,
  _radioCssClass: () => _radioCssClass,
  _refreshFilterUi: () => _refreshFilterUi,
  _refreshHandlerAndUi: () => _refreshHandlerAndUi,
  _registerModule: () => _registerModule,
  _removeAriaExpanded: () => _removeAriaExpanded,
  _removeAriaSort: () => _removeAriaSort,
  _removeFromArray: () => _removeFromArray,
  _removeFromParent: () => _removeFromParent,
  _requestAnimationFrame: () => _requestAnimationFrame,
  _resetColumnState: () => _resetColumnState,
  _selectAllCells: () => _selectAllCells,
  _serialiseDate: () => _serialiseDate,
  _setAriaActiveDescendant: () => _setAriaActiveDescendant,
  _setAriaChecked: () => _setAriaChecked,
  _setAriaColCount: () => _setAriaColCount,
  _setAriaColIndex: () => _setAriaColIndex,
  _setAriaColSpan: () => _setAriaColSpan,
  _setAriaControls: () => _setAriaControls,
  _setAriaControlsAndLabel: () => _setAriaControlsAndLabel,
  _setAriaDescribedBy: () => _setAriaDescribedBy,
  _setAriaDisabled: () => _setAriaDisabled,
  _setAriaExpanded: () => _setAriaExpanded,
  _setAriaHasPopup: () => _setAriaHasPopup,
  _setAriaHidden: () => _setAriaHidden,
  _setAriaInvalid: () => _setAriaInvalid,
  _setAriaLabel: () => _setAriaLabel,
  _setAriaLabelledBy: () => _setAriaLabelledBy,
  _setAriaLevel: () => _setAriaLevel,
  _setAriaPosInSet: () => _setAriaPosInSet,
  _setAriaRole: () => _setAriaRole,
  _setAriaRowCount: () => _setAriaRowCount,
  _setAriaRowIndex: () => _setAriaRowIndex,
  _setAriaSelected: () => _setAriaSelected,
  _setAriaSetSize: () => _setAriaSetSize,
  _setAriaSort: () => _setAriaSort,
  _setColMenuVisible: () => _setColMenuVisible,
  _setDisabled: () => _setDisabled,
  _setDisplayed: () => _setDisplayed,
  _setFixedWidth: () => _setFixedWidth,
  _setUmd: () => _setUmd,
  _setVisible: () => _setVisible,
  _shouldUpdateColVisibilityAfterGroup: () => _shouldUpdateColVisibilityAfterGroup,
  _stopPropagationForAgGrid: () => _stopPropagationForAgGrid,
  _toString: () => _toString,
  _toStringOrNull: () => _toStringOrNull,
  _translate: () => _translate,
  _translateForFilter: () => translateForFilter,
  _unwrapUserComp: () => _unwrapUserComp,
  _updateColsMap: () => _updateColsMap,
  _updateColumnState: () => _updateColumnState,
  _updateFilterModel: () => _updateFilterModel,
  _waitUntil: () => _waitUntil,
  _warn: () => _warn,
  _warnOnce: () => _warnOnce,
  agTestIdFor: () => agTestIdFor,
  buttonStyleAlpine: () => buttonStyleAlpine,
  buttonStyleBalham: () => buttonStyleBalham,
  buttonStyleBase: () => buttonStyleBase,
  buttonStyleQuartz: () => buttonStyleQuartz,
  checkboxStyleDefault: () => checkboxStyleDefault,
  colorSchemeDark: () => colorSchemeDark,
  colorSchemeDarkBlue: () => colorSchemeDarkBlue,
  colorSchemeDarkWarm: () => colorSchemeDarkWarm,
  colorSchemeLight: () => colorSchemeLight,
  colorSchemeLightCold: () => colorSchemeLightCold,
  colorSchemeLightWarm: () => colorSchemeLightWarm,
  colorSchemeVariable: () => colorSchemeVariable,
  columnDropStyleBordered: () => columnDropStyleBordered,
  columnDropStylePlain: () => columnDropStylePlain,
  convertColumnGroupState: () => convertColumnGroupState,
  convertColumnState: () => convertColumnState,
  createGrid: () => createGrid,
  createPart: () => createPart,
  createTheme: () => createTheme,
  getGridApi: () => getGridApi,
  getGridElement: () => getGridElement,
  iconOverrides: () => iconOverrides,
  iconSetAlpine: () => iconSetAlpine,
  iconSetMaterial: () => iconSetMaterial,
  iconSetQuartz: () => iconSetQuartz,
  iconSetQuartzBold: () => iconSetQuartzBold,
  iconSetQuartzLight: () => iconSetQuartzLight,
  iconSetQuartzRegular: () => iconSetQuartzRegular,
  inputStyleBase: () => inputStyleBase,
  inputStyleBordered: () => inputStyleBordered,
  inputStyleUnderlined: () => inputStyleUnderlined,
  isColumn: () => isColumn,
  isColumnGroup: () => isColumnGroup,
  isColumnGroupAutoCol: () => isColumnGroupAutoCol,
  isColumnSelectionCol: () => isColumnSelectionCol,
  isCombinedFilterModel: () => isCombinedFilterModel,
  isProvidedColumnGroup: () => isProvidedColumnGroup,
  isRowNumberCol: () => isRowNumberCol,
  isSpecialCol: () => isSpecialCol,
  provideGlobalGridOptions: () => provideGlobalGridOptions,
  setupAgTestIds: () => setupAgTestIds,
  styleMaterial: () => styleMaterial,
  tabStyleAlpine: () => tabStyleAlpine,
  tabStyleBase: () => tabStyleBase,
  tabStyleMaterial: () => tabStyleMaterial,
  tabStyleQuartz: () => tabStyleQuartz,
  tabStyleRolodex: () => tabStyleRolodex,
  themeAlpine: () => themeAlpine,
  themeBalham: () => themeBalham,
  themeMaterial: () => themeMaterial,
  themeQuartz: () => themeQuartz,
  wrapAgTestIdFor: () => wrapAgTestIdFor
});
module.exports = __toCommonJS(main_exports);

// packages/ag-grid-community/src/localEventService.ts
var LocalEventService = class {
  constructor() {
    this.allSyncListeners = /* @__PURE__ */ new Map();
    this.allAsyncListeners = /* @__PURE__ */ new Map();
    this.globalSyncListeners = /* @__PURE__ */ new Set();
    this.globalAsyncListeners = /* @__PURE__ */ new Set();
    this.asyncFunctionsQueue = [];
    this.scheduled = false;
    // using an object performs better than a Set for the number of different events we have
    this.firedEvents = {};
  }
  setFrameworkOverrides(frameworkOverrides) {
    this.frameworkOverrides = frameworkOverrides;
  }
  getListeners(eventType, async, autoCreateListenerCollection) {
    const listenerMap = async ? this.allAsyncListeners : this.allSyncListeners;
    let listeners = listenerMap.get(eventType);
    if (!listeners && autoCreateListenerCollection) {
      listeners = /* @__PURE__ */ new Set();
      listenerMap.set(eventType, listeners);
    }
    return listeners;
  }
  noRegisteredListenersExist() {
    return this.allSyncListeners.size === 0 && this.allAsyncListeners.size === 0 && this.globalSyncListeners.size === 0 && this.globalAsyncListeners.size === 0;
  }
  addEventListener(eventType, listener, async = false) {
    this.getListeners(eventType, async, true).add(listener);
  }
  removeEventListener(eventType, listener, async = false) {
    const listeners = this.getListeners(eventType, async, false);
    if (!listeners) {
      return;
    }
    listeners.delete(listener);
    if (listeners.size === 0) {
      (async ? this.allAsyncListeners : this.allSyncListeners).delete(eventType);
    }
  }
  addGlobalListener(listener, async = false) {
    this.getGlobalListeners(async).add(listener);
  }
  removeGlobalListener(listener, async = false) {
    this.getGlobalListeners(async).delete(listener);
  }
  dispatchEvent(event) {
    this.dispatchToListeners(event, true);
    this.dispatchToListeners(event, false);
    this.firedEvents[event.type] = true;
  }
  dispatchEventOnce(event) {
    if (!this.firedEvents[event.type]) {
      this.dispatchEvent(event);
    }
  }
  dispatchToListeners(event, async) {
    const eventType = event.type;
    if (async && "event" in event) {
      const browserEvent = event.event;
      if (browserEvent instanceof Event) {
        event.eventPath = browserEvent.composedPath();
      }
    }
    const { frameworkOverrides } = this;
    const runCallback = (func) => {
      const callback = frameworkOverrides ? () => frameworkOverrides.wrapIncoming(func) : func;
      if (async) {
        this.dispatchAsync(callback);
      } else {
        callback();
      }
    };
    const originalListeners = this.getListeners(eventType, async, false);
    if ((originalListeners?.size ?? 0) > 0) {
      const listeners = new Set(originalListeners);
      for (const listener of listeners) {
        if (!originalListeners?.has(listener)) {
          continue;
        }
        runCallback(() => listener(event));
      }
    }
    const globalListenersSrc = this.getGlobalListeners(async);
    if (globalListenersSrc.size > 0) {
      const globalListeners = new Set(globalListenersSrc);
      for (const listener of globalListeners) {
        runCallback(() => listener(eventType, event));
      }
    }
  }
  getGlobalListeners(async) {
    return async ? this.globalAsyncListeners : this.globalSyncListeners;
  }
  // this gets called inside the grid's thread, for each event that it
  // wants to set async. the grid then batches the events into one setTimeout()
  // because setTimeout() is an expensive operation. ideally we would have
  // each event in it's own setTimeout(), but we batch for performance.
  dispatchAsync(func) {
    this.asyncFunctionsQueue.push(func);
    if (!this.scheduled) {
      const flush = () => {
        window.setTimeout(this.flushAsyncQueue.bind(this), 0);
      };
      this.frameworkOverrides ? this.frameworkOverrides.wrapIncoming(flush) : flush();
      this.scheduled = true;
    }
  }
  // this happens in the next VM turn only, and empties the queue of events
  flushAsyncQueue() {
    this.scheduled = false;
    const queueCopy = this.asyncFunctionsQueue.slice();
    this.asyncFunctionsQueue = [];
    queueCopy.forEach((func) => func());
  }
};

// packages/ag-grid-community/src/misc/locale/localeUtils.ts
function defaultLocaleTextFunc(_key, defaultValue) {
  return defaultValue;
}
function _getLocaleTextFunc(localeSvc) {
  return localeSvc?.getLocaleTextFunc() ?? defaultLocaleTextFunc;
}
function _translate(bean, localeValues, key, variableValues) {
  const defaultValue = localeValues[key];
  return bean.getLocaleTextFunc()(
    key,
    typeof defaultValue === "function" ? defaultValue(variableValues) : defaultValue,
    variableValues
  );
}

// packages/ag-grid-community/src/utils/generic.ts
function _makeNull(value) {
  if (value == null || value === "") {
    return null;
  }
  return value;
}
function _exists(value) {
  return value != null && value !== "";
}
function _missing(value) {
  return !_exists(value);
}
function _toStringOrNull(value) {
  return value != null && typeof value.toString === "function" ? value.toString() : null;
}
function _jsonEquals(val1, val2) {
  const val1Json = val1 ? JSON.stringify(val1) : null;
  const val2Json = val2 ? JSON.stringify(val2) : null;
  return val1Json === val2Json;
}
function _defaultComparator(valueA, valueB, accentedCompare = false) {
  const valueAMissing = valueA == null;
  const valueBMissing = valueB == null;
  if (valueA && valueA.toNumber) {
    valueA = valueA.toNumber();
  }
  if (valueB && valueB.toNumber) {
    valueB = valueB.toNumber();
  }
  if (valueAMissing && valueBMissing) {
    return 0;
  }
  if (valueAMissing) {
    return -1;
  }
  if (valueBMissing) {
    return 1;
  }
  function doQuickCompare(a, b) {
    return a > b ? 1 : a < b ? -1 : 0;
  }
  if (typeof valueA !== "string") {
    return doQuickCompare(valueA, valueB);
  }
  if (!accentedCompare) {
    return doQuickCompare(valueA, valueB);
  }
  try {
    return valueA.localeCompare(valueB);
  } catch (e) {
    return doQuickCompare(valueA, valueB);
  }
}

// packages/ag-grid-community/src/utils/object.ts
var SKIP_JS_BUILTINS = /* @__PURE__ */ new Set(["__proto__", "constructor", "prototype"]);
function _iterateObject(object, callback) {
  if (object == null) {
    return;
  }
  if (Array.isArray(object)) {
    for (let i = 0; i < object.length; i++) {
      callback(i.toString(), object[i]);
    }
    return;
  }
  for (const key of Object.keys(object).filter((key2) => !SKIP_JS_BUILTINS.has(key2))) {
    callback(key, object[key]);
  }
}
function _mergeDeep(dest, source, copyUndefined = true, makeCopyOfSimpleObjects = false) {
  if (!_exists(source)) {
    return;
  }
  _iterateObject(source, (key, sourceValue) => {
    let destValue = dest[key];
    if (destValue === sourceValue) {
      return;
    }
    if (makeCopyOfSimpleObjects) {
      const objectIsDueToBeCopied = destValue == null && sourceValue != null;
      if (objectIsDueToBeCopied) {
        const doNotCopyAsSourceIsSimpleObject = typeof sourceValue === "object" && sourceValue.constructor === Object;
        if (doNotCopyAsSourceIsSimpleObject) {
          destValue = {};
          dest[key] = destValue;
        }
      }
    }
    if (_isNonNullObject(sourceValue) && _isNonNullObject(destValue) && !Array.isArray(destValue)) {
      _mergeDeep(destValue, sourceValue, copyUndefined, makeCopyOfSimpleObjects);
    } else if (copyUndefined || sourceValue !== void 0) {
      dest[key] = sourceValue;
    }
  });
}
function _getValueUsingField(data, field, fieldContainsDots) {
  if (!field || !data) {
    return;
  }
  if (!fieldContainsDots) {
    return data[field];
  }
  const fields = field.split(".");
  let currentObject = data;
  for (let i = 0; i < fields.length; i++) {
    if (currentObject == null) {
      return void 0;
    }
    currentObject = currentObject[fields[i]];
  }
  return currentObject;
}
function _isNonNullObject(value) {
  return typeof value === "object" && value !== null;
}

// packages/ag-grid-community/src/globalGridOptions.ts
var _GlobalGridOptions = class _GlobalGridOptions {
  /**
   * @param providedOptions
   * @returns Shallow copy of the provided options with global options merged in.
   */
  static applyGlobalGridOptions(providedOptions) {
    if (!_GlobalGridOptions.gridOptions) {
      return { ...providedOptions };
    }
    let mergedGridOps = {};
    _mergeDeep(mergedGridOps, _GlobalGridOptions.gridOptions, true, true);
    if (_GlobalGridOptions.mergeStrategy === "deep") {
      _mergeDeep(mergedGridOps, providedOptions, true, true);
    } else {
      mergedGridOps = { ...mergedGridOps, ...providedOptions };
    }
    if (_GlobalGridOptions.gridOptions.context) {
      mergedGridOps.context = _GlobalGridOptions.gridOptions.context;
    }
    if (providedOptions.context) {
      if (_GlobalGridOptions.mergeStrategy === "deep" && mergedGridOps.context) {
        _mergeDeep(providedOptions.context, mergedGridOps.context, true, true);
      }
      mergedGridOps.context = providedOptions.context;
    }
    return mergedGridOps;
  }
};
_GlobalGridOptions.gridOptions = void 0;
_GlobalGridOptions.mergeStrategy = "shallow";
var GlobalGridOptions = _GlobalGridOptions;
function provideGlobalGridOptions(gridOptions, mergeStrategy = "shallow") {
  GlobalGridOptions.gridOptions = gridOptions;
  GlobalGridOptions.mergeStrategy = mergeStrategy;
}
function _getGlobalGridOption(gridOption) {
  return GlobalGridOptions.gridOptions?.[gridOption];
}

// packages/ag-grid-community/src/gridOptionsDefault.ts
var GRID_OPTION_DEFAULTS = {
  suppressContextMenu: false,
  preventDefaultOnContextMenu: false,
  allowContextMenuWithControlKey: false,
  suppressMenuHide: true,
  enableBrowserTooltips: false,
  tooltipTrigger: "hover",
  tooltipShowDelay: 2e3,
  tooltipHideDelay: 1e4,
  tooltipMouseTrack: false,
  tooltipShowMode: "standard",
  tooltipInteraction: false,
  copyHeadersToClipboard: false,
  copyGroupHeadersToClipboard: false,
  clipboardDelimiter: "	",
  suppressCopyRowsToClipboard: false,
  suppressCopySingleCellRanges: false,
  suppressLastEmptyLineOnPaste: false,
  suppressClipboardPaste: false,
  suppressClipboardApi: false,
  suppressCutToClipboard: false,
  maintainColumnOrder: false,
  enableStrictPivotColumnOrder: false,
  suppressFieldDotNotation: false,
  allowDragFromColumnsToolPanel: false,
  suppressMovableColumns: false,
  suppressColumnMoveAnimation: false,
  suppressMoveWhenColumnDragging: false,
  suppressDragLeaveHidesColumns: false,
  suppressRowGroupHidesColumns: false,
  suppressAutoSize: false,
  autoSizePadding: 20,
  skipHeaderOnAutoSize: false,
  singleClickEdit: false,
  suppressClickEdit: false,
  readOnlyEdit: false,
  stopEditingWhenCellsLoseFocus: false,
  enterNavigatesVertically: false,
  enterNavigatesVerticallyAfterEdit: false,
  enableCellEditingOnBackspace: false,
  undoRedoCellEditing: false,
  undoRedoCellEditingLimit: 10,
  suppressCsvExport: false,
  suppressExcelExport: false,
  cacheQuickFilter: false,
  includeHiddenColumnsInQuickFilter: false,
  excludeChildrenWhenTreeDataFiltering: false,
  enableAdvancedFilter: false,
  includeHiddenColumnsInAdvancedFilter: false,
  enableCharts: false,
  masterDetail: false,
  keepDetailRows: false,
  keepDetailRowsCount: 10,
  detailRowAutoHeight: false,
  tabIndex: 0,
  rowBuffer: 10,
  valueCache: false,
  valueCacheNeverExpires: false,
  enableCellExpressions: false,
  suppressTouch: false,
  suppressFocusAfterRefresh: false,
  suppressBrowserResizeObserver: false,
  suppressPropertyNamesCheck: false,
  suppressChangeDetection: false,
  debug: false,
  suppressLoadingOverlay: false,
  suppressNoRowsOverlay: false,
  pagination: false,
  paginationPageSize: 100,
  paginationPageSizeSelector: true,
  paginationAutoPageSize: false,
  paginateChildRows: false,
  suppressPaginationPanel: false,
  pivotMode: false,
  pivotPanelShow: "never",
  pivotDefaultExpanded: 0,
  pivotSuppressAutoColumn: false,
  suppressExpandablePivotGroups: false,
  functionsReadOnly: false,
  suppressAggFuncInHeader: false,
  alwaysAggregateAtRootLevel: false,
  aggregateOnlyChangedColumns: false,
  suppressAggFilteredOnly: false,
  removePivotHeaderRowWhenSingleValueColumn: false,
  animateRows: true,
  cellFlashDuration: 500,
  cellFadeDuration: 1e3,
  allowShowChangeAfterFilter: false,
  domLayout: "normal",
  ensureDomOrder: false,
  enableRtl: false,
  suppressColumnVirtualisation: false,
  suppressMaxRenderedRowRestriction: false,
  suppressRowVirtualisation: false,
  rowDragManaged: false,
  rowDragInsertDelay: 500,
  suppressRowDrag: false,
  suppressMoveWhenRowDragging: false,
  rowDragEntireRow: false,
  rowDragMultiRow: false,
  embedFullWidthRows: false,
  groupDisplayType: "singleColumn",
  groupDefaultExpanded: 0,
  groupMaintainOrder: false,
  groupSelectsChildren: false,
  groupSuppressBlankHeader: false,
  groupSelectsFiltered: false,
  showOpenedGroup: false,
  groupRemoveSingleChildren: false,
  groupRemoveLowestSingleChildren: false,
  groupHideOpenParents: false,
  groupAllowUnbalanced: false,
  rowGroupPanelShow: "never",
  suppressMakeColumnVisibleAfterUnGroup: false,
  treeData: false,
  rowGroupPanelSuppressSort: false,
  suppressGroupRowsSticky: false,
  rowModelType: "clientSide",
  asyncTransactionWaitMillis: 50,
  suppressModelUpdateAfterUpdateTransaction: false,
  cacheOverflowSize: 1,
  infiniteInitialRowCount: 1,
  serverSideInitialRowCount: 1,
  cacheBlockSize: 100,
  maxBlocksInCache: -1,
  maxConcurrentDatasourceRequests: 2,
  blockLoadDebounceMillis: 0,
  purgeClosedRowNodes: false,
  serverSideSortAllLevels: false,
  serverSideOnlyRefreshFilteredGroups: false,
  serverSidePivotResultFieldSeparator: "_",
  viewportRowModelPageSize: 5,
  viewportRowModelBufferSize: 5,
  alwaysShowHorizontalScroll: false,
  alwaysShowVerticalScroll: false,
  debounceVerticalScrollbar: false,
  suppressHorizontalScroll: false,
  suppressScrollOnNewData: false,
  suppressScrollWhenPopupsAreOpen: false,
  suppressAnimationFrame: false,
  suppressMiddleClickScrolls: false,
  suppressPreventDefaultOnMouseWheel: false,
  rowMultiSelectWithClick: false,
  suppressRowDeselection: false,
  suppressRowClickSelection: false,
  suppressCellFocus: false,
  suppressHeaderFocus: false,
  suppressMultiRangeSelection: false,
  enableCellTextSelection: false,
  enableRangeSelection: false,
  enableRangeHandle: false,
  enableFillHandle: false,
  fillHandleDirection: "xy",
  suppressClearOnFillReduction: false,
  accentedSort: false,
  unSortIcon: false,
  suppressMultiSort: false,
  alwaysMultiSort: false,
  suppressMaintainUnsortedOrder: false,
  suppressRowHoverHighlight: false,
  suppressRowTransform: false,
  columnHoverHighlight: false,
  deltaSort: false,
  enableGroupEdit: false,
  groupLockGroupColumns: 0,
  serverSideEnableClientSideSort: false,
  suppressServerSideFullWidthLoadingRow: false,
  pivotMaxGeneratedColumns: -1,
  columnMenu: "new",
  reactiveCustomComponents: true,
  suppressSetFilterByDefault: false,
  rowNumbers: false,
  enableFilterHandlers: false
};

// packages/ag-grid-community/src/utils/aria.ts
function _toggleAriaAttribute(element, attribute, value) {
  if (value == null || typeof value === "string" && value == "") {
    _removeAriaAttribute(element, attribute);
  } else {
    _setAriaAttribute(element, attribute, value);
  }
}
function _setAriaAttribute(element, attribute, value) {
  element.setAttribute(_ariaAttributeName(attribute), value.toString());
}
function _removeAriaAttribute(element, attribute) {
  element.removeAttribute(_ariaAttributeName(attribute));
}
function _ariaAttributeName(attribute) {
  return `aria-${attribute}`;
}
function _setAriaRole(element, role) {
  if (role) {
    element.setAttribute("role", role);
  } else {
    element.removeAttribute("role");
  }
}
function _getAriaSortState(sortDirection) {
  let sort;
  if (sortDirection === "asc") {
    sort = "ascending";
  } else if (sortDirection === "desc") {
    sort = "descending";
  } else if (sortDirection === "mixed") {
    sort = "other";
  } else {
    sort = "none";
  }
  return sort;
}
function _getAriaPosInSet(element) {
  return parseInt(element.getAttribute("aria-posinset"), 10);
}
function _getAriaLabel(element) {
  return element.getAttribute("aria-label");
}
function _setAriaLabel(element, label) {
  _toggleAriaAttribute(element, "label", label);
}
function _setAriaLabelledBy(element, labelledBy) {
  _toggleAriaAttribute(element, "labelledby", labelledBy);
}
function _setAriaDescribedBy(element, describedby) {
  _toggleAriaAttribute(element, "describedby", describedby);
}
function _setAriaLive(element, live) {
  _toggleAriaAttribute(element, "live", live);
}
function _setAriaAtomic(element, atomic) {
  _toggleAriaAttribute(element, "atomic", atomic);
}
function _setAriaRelevant(element, relevant) {
  _toggleAriaAttribute(element, "relevant", relevant);
}
function _setAriaInvalid(element, invalid) {
  _toggleAriaAttribute(element, "invalid", invalid);
}
function _setAriaLevel(element, level) {
  _toggleAriaAttribute(element, "level", level);
}
function _setAriaDisabled(element, disabled) {
  _toggleAriaAttribute(element, "disabled", disabled);
}
function _setAriaHidden(element, hidden) {
  _toggleAriaAttribute(element, "hidden", hidden);
}
function _setAriaActiveDescendant(element, descendantId) {
  _toggleAriaAttribute(element, "activedescendant", descendantId);
}
function _setAriaExpanded(element, expanded) {
  _setAriaAttribute(element, "expanded", expanded);
}
function _removeAriaExpanded(element) {
  _removeAriaAttribute(element, "expanded");
}
function _setAriaSetSize(element, setsize) {
  _setAriaAttribute(element, "setsize", setsize);
}
function _setAriaPosInSet(element, position) {
  _setAriaAttribute(element, "posinset", position);
}
function _setAriaMultiSelectable(element, multiSelectable) {
  _setAriaAttribute(element, "multiselectable", multiSelectable);
}
function _setAriaRowCount(element, rowCount) {
  _setAriaAttribute(element, "rowcount", rowCount);
}
function _setAriaRowIndex(element, rowIndex) {
  _setAriaAttribute(element, "rowindex", rowIndex);
}
function _setAriaRowSpan(element, spanCount) {
  _setAriaAttribute(element, "rowspan", spanCount);
}
function _setAriaColCount(element, colCount) {
  _setAriaAttribute(element, "colcount", colCount);
}
function _setAriaColIndex(element, colIndex) {
  _setAriaAttribute(element, "colindex", colIndex);
}
function _setAriaColSpan(element, colSpan) {
  _setAriaAttribute(element, "colspan", colSpan);
}
function _setAriaSort(element, sort) {
  _setAriaAttribute(element, "sort", sort);
}
function _removeAriaSort(element) {
  _removeAriaAttribute(element, "sort");
}
function _setAriaSelected(element, selected) {
  _toggleAriaAttribute(element, "selected", selected);
}
function _setAriaChecked(element, checked) {
  _setAriaAttribute(element, "checked", checked === void 0 ? "mixed" : checked);
}
function _setAriaControls(controllerElement, controlledId) {
  _toggleAriaAttribute(controllerElement, "controls", controlledId);
}
function _setAriaControlsAndLabel(controllerElement, controlledElement) {
  _setAriaControls(controllerElement, controlledElement.id);
  _setAriaLabelledBy(controlledElement, controllerElement.id);
}
function _setAriaOwns(ownerElement, ownedId) {
  _toggleAriaAttribute(ownerElement, "owns", ownedId);
}
function _setAriaHasPopup(element, hasPopup) {
  _toggleAriaAttribute(element, "haspopup", hasPopup === false ? null : hasPopup);
}
function _getAriaCheckboxStateName(translate, state) {
  return state === void 0 ? translate("ariaIndeterminate", "indeterminate") : state === true ? translate("ariaChecked", "checked") : translate("ariaUnchecked", "unchecked");
}

// packages/ag-grid-community/src/utils/browser.ts
var isSafari;
var isFirefox;
var isMacOs;
var isIOS;
var invisibleScrollbar;
var browserScrollbarWidth;
var maxDivHeight;
function _isBrowserSafari() {
  if (isSafari === void 0) {
    isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
  }
  return isSafari;
}
function _isBrowserFirefox() {
  if (isFirefox === void 0) {
    isFirefox = /(firefox)/i.test(navigator.userAgent);
  }
  return isFirefox;
}
function _isMacOsUserAgent() {
  if (isMacOs === void 0) {
    isMacOs = /(Mac|iPhone|iPod|iPad)/i.test(navigator.platform);
  }
  return isMacOs;
}
function _isIOSUserAgent() {
  if (isIOS === void 0) {
    isIOS = /iPad|iPhone|iPod/.test(navigator.platform) || navigator.platform === "MacIntel" && navigator.maxTouchPoints > 1;
  }
  return isIOS;
}
function _getTabIndex(el) {
  if (!el) {
    return null;
  }
  const numberTabIndex = el.tabIndex;
  const tabIndex = el.getAttribute("tabIndex");
  if (numberTabIndex === -1 && (tabIndex === null || tabIndex === "" && !_isBrowserFirefox())) {
    return null;
  }
  return numberTabIndex.toString();
}
function _getMaxDivHeight() {
  if (maxDivHeight !== void 0) {
    return maxDivHeight;
  }
  if (!document.body) {
    return -1;
  }
  let res = 1e6;
  const testUpTo = _isBrowserFirefox() ? 6e6 : 1e9;
  const div = document.createElement("div");
  document.body.appendChild(div);
  while (true) {
    const test = res * 2;
    div.style.height = test + "px";
    if (test > testUpTo || div.clientHeight !== test) {
      break;
    } else {
      res = test;
    }
  }
  document.body.removeChild(div);
  maxDivHeight = res;
  return res;
}
function _getScrollbarWidth() {
  if (browserScrollbarWidth == null) {
    initScrollbarWidthAndVisibility();
  }
  return browserScrollbarWidth;
}
function initScrollbarWidthAndVisibility() {
  const body = document.body;
  const div = document.createElement("div");
  div.style.width = div.style.height = "100px";
  div.style.opacity = "0";
  div.style.overflow = "scroll";
  div.style.msOverflowStyle = "scrollbar";
  div.style.position = "absolute";
  body.appendChild(div);
  let width = div.offsetWidth - div.clientWidth;
  if (width === 0 && div.clientWidth === 0) {
    width = null;
  }
  if (div.parentNode) {
    div.parentNode.removeChild(div);
  }
  if (width != null) {
    browserScrollbarWidth = width;
    invisibleScrollbar = width === 0;
  }
}
function _isInvisibleScrollbar() {
  if (invisibleScrollbar == null) {
    initScrollbarWidthAndVisibility();
  }
  return invisibleScrollbar;
}

// packages/ag-grid-community/src/utils/dom.ts
function _radioCssClass(element, elementClass, otherElementClass) {
  const parent = element.parentElement;
  let sibling = parent && parent.firstChild;
  while (sibling) {
    if (elementClass) {
      sibling.classList.toggle(elementClass, sibling === element);
    }
    if (otherElementClass) {
      sibling.classList.toggle(otherElementClass, sibling !== element);
    }
    sibling = sibling.nextSibling;
  }
}
var FOCUSABLE_SELECTOR = "[tabindex], input, select, button, textarea, [href]";
var FOCUSABLE_EXCLUDE = "[disabled], .ag-disabled:not(.ag-button), .ag-disabled *";
function _isFocusableFormField(element) {
  const matches = Element.prototype.matches || Element.prototype.msMatchesSelector;
  const inputSelector = "input, select, button, textarea";
  const isFocusable = matches.call(element, inputSelector);
  const isNotFocusable = matches.call(element, FOCUSABLE_EXCLUDE);
  const isElementVisible = _isVisible(element);
  const focusable = isFocusable && !isNotFocusable && isElementVisible;
  return focusable;
}
function _setDisplayed(element, displayed, options = {}) {
  const { skipAriaHidden } = options;
  element.classList.toggle("ag-hidden", !displayed);
  if (!skipAriaHidden) {
    _setAriaHidden(element, !displayed);
  }
}
function _setVisible(element, visible, options = {}) {
  const { skipAriaHidden } = options;
  element.classList.toggle("ag-invisible", !visible);
  if (!skipAriaHidden) {
    _setAriaHidden(element, !visible);
  }
}
function _setDisabled(element, disabled) {
  const attributeName = "disabled";
  const addOrRemoveDisabledAttribute = disabled ? (e) => e.setAttribute(attributeName, "") : (e) => e.removeAttribute(attributeName);
  addOrRemoveDisabledAttribute(element);
  const inputs = element.querySelectorAll("input") ?? [];
  for (const input of inputs) {
    addOrRemoveDisabledAttribute(input);
  }
}
function _isElementChildOfClass(element, cls, maxNest) {
  let counter = 0;
  while (element) {
    if (element.classList.contains(cls)) {
      return true;
    }
    element = element.parentElement;
    if (typeof maxNest == "number") {
      if (++counter > maxNest) {
        break;
      }
    } else if (element === maxNest) {
      break;
    }
  }
  return false;
}
function _getElementSize(el) {
  const {
    height,
    width,
    borderTopWidth,
    borderRightWidth,
    borderBottomWidth,
    borderLeftWidth,
    paddingTop,
    paddingRight,
    paddingBottom,
    paddingLeft,
    marginTop,
    marginRight,
    marginBottom,
    marginLeft,
    boxSizing
  } = window.getComputedStyle(el);
  return {
    height: parseFloat(height || "0"),
    width: parseFloat(width || "0"),
    borderTopWidth: parseFloat(borderTopWidth || "0"),
    borderRightWidth: parseFloat(borderRightWidth || "0"),
    borderBottomWidth: parseFloat(borderBottomWidth || "0"),
    borderLeftWidth: parseFloat(borderLeftWidth || "0"),
    paddingTop: parseFloat(paddingTop || "0"),
    paddingRight: parseFloat(paddingRight || "0"),
    paddingBottom: parseFloat(paddingBottom || "0"),
    paddingLeft: parseFloat(paddingLeft || "0"),
    marginTop: parseFloat(marginTop || "0"),
    marginRight: parseFloat(marginRight || "0"),
    marginBottom: parseFloat(marginBottom || "0"),
    marginLeft: parseFloat(marginLeft || "0"),
    boxSizing
  };
}
function _getInnerHeight(el) {
  const size = _getElementSize(el);
  if (size.boxSizing === "border-box") {
    return size.height - size.paddingTop - size.paddingBottom;
  }
  return size.height;
}
function _getInnerWidth(el) {
  const size = _getElementSize(el);
  if (size.boxSizing === "border-box") {
    return size.width - size.paddingLeft - size.paddingRight;
  }
  return size.width;
}
function _getAbsoluteHeight(el) {
  const { height, marginBottom, marginTop } = _getElementSize(el);
  return Math.floor(height + marginBottom + marginTop);
}
function _getAbsoluteWidth(el) {
  const { width, marginLeft, marginRight } = _getElementSize(el);
  return Math.floor(width + marginLeft + marginRight);
}
function _getElementRectWithOffset(el) {
  const offsetElementRect = el.getBoundingClientRect();
  const { borderTopWidth, borderLeftWidth, borderRightWidth, borderBottomWidth } = _getElementSize(el);
  return {
    top: offsetElementRect.top + (borderTopWidth || 0),
    left: offsetElementRect.left + (borderLeftWidth || 0),
    right: offsetElementRect.right + (borderRightWidth || 0),
    bottom: offsetElementRect.bottom + (borderBottomWidth || 0)
  };
}
function _getScrollLeft(element, rtl) {
  let scrollLeft = element.scrollLeft;
  if (rtl) {
    scrollLeft = Math.abs(scrollLeft);
  }
  return scrollLeft;
}
function _setScrollLeft(element, value, rtl) {
  if (rtl) {
    value *= -1;
  }
  element.scrollLeft = value;
}
function _clearElement(el) {
  while (el && el.firstChild) {
    el.removeChild(el.firstChild);
  }
}
function _removeFromParent(node) {
  if (node && node.parentNode) {
    node.parentNode.removeChild(node);
  }
}
function _isInDOM(element) {
  return !!element.offsetParent;
}
function _isVisible(element) {
  const el = element;
  if (el.checkVisibility) {
    return el.checkVisibility({ checkVisibilityCSS: true });
  }
  const isHidden = !_isInDOM(element) || window.getComputedStyle(element).visibility !== "visible";
  return !isHidden;
}
function _loadTemplate(template) {
  const tempDiv = document.createElement("div");
  tempDiv.innerHTML = (template || "").trim();
  return tempDiv.firstChild;
}
function _ensureDomOrder(eContainer, eChild, eChildBefore) {
  if (eChildBefore && eChildBefore.nextSibling === eChild) {
    return;
  }
  if (!eContainer.firstChild) {
    eContainer.appendChild(eChild);
  } else if (eChildBefore) {
    if (eChildBefore.nextSibling) {
      eContainer.insertBefore(eChild, eChildBefore.nextSibling);
    } else {
      eContainer.appendChild(eChild);
    }
  } else if (eContainer.firstChild && eContainer.firstChild !== eChild) {
    eContainer.insertAdjacentElement("afterbegin", eChild);
  }
}
function _setDomChildOrder(eContainer, orderedChildren) {
  for (let i = 0; i < orderedChildren.length; i++) {
    const correctCellAtIndex = orderedChildren[i];
    const actualCellAtIndex = eContainer.children[i];
    if (actualCellAtIndex !== correctCellAtIndex) {
      eContainer.insertBefore(correctCellAtIndex, actualCellAtIndex);
    }
  }
}
function _camelCaseToHyphenated(camelCase) {
  return camelCase.replace(/[A-Z]/g, (s) => `-${s.toLocaleLowerCase()}`);
}
function _addStylesToElement(eElement, styles) {
  if (!styles) {
    return;
  }
  for (const key of Object.keys(styles)) {
    const value = styles[key];
    if (!key || !key.length || value == null) {
      continue;
    }
    const parsedKey = _camelCaseToHyphenated(key);
    const valueAsString = value.toString();
    const parsedValue = valueAsString.replace(/\s*!important/g, "");
    const priority = parsedValue.length != valueAsString.length ? "important" : void 0;
    eElement.style.setProperty(parsedKey, parsedValue, priority);
  }
}
function _isElementOverflowingCallback(getElement2) {
  return () => {
    const element = getElement2();
    if (!element) {
      return true;
    }
    return _isHorizontalScrollShowing(element) || _isVerticalScrollShowing(element);
  };
}
function _isHorizontalScrollShowing(element) {
  return element.clientWidth < element.scrollWidth;
}
function _isVerticalScrollShowing(element) {
  return element.clientHeight < element.scrollHeight;
}
function _setElementWidth(element, width) {
  if (width === "flex") {
    element.style.removeProperty("width");
    element.style.removeProperty("minWidth");
    element.style.removeProperty("maxWidth");
    element.style.flex = "1 1 auto";
  } else {
    _setFixedWidth(element, width);
  }
}
function _setFixedWidth(element, width) {
  width = _formatSize(width);
  element.style.width = width;
  element.style.maxWidth = width;
  element.style.minWidth = width;
}
function _setFixedHeight(element, height) {
  height = _formatSize(height);
  element.style.height = height;
  element.style.maxHeight = height;
  element.style.minHeight = height;
}
function _formatSize(size) {
  return typeof size === "number" ? `${size}px` : size;
}
function _isNodeOrElement(o) {
  return o instanceof Node || o instanceof HTMLElement;
}
function _addOrRemoveAttribute(element, name, value) {
  if (value == null || value === "") {
    element.removeAttribute(name);
  } else {
    element.setAttribute(name, value.toString());
  }
}
function _observeResize(beans, element, callback) {
  const win = _getWindow(beans);
  const ResizeObserverImpl = win.ResizeObserver;
  const resizeObserver = ResizeObserverImpl ? new ResizeObserverImpl(callback) : null;
  resizeObserver?.observe(element);
  return () => resizeObserver?.disconnect();
}
function _getTextSelectionRanges(beans) {
  const rootNode = _getRootNode(beans);
  const selection = "getSelection" in rootNode ? rootNode.getSelection() : null;
  const ranges = [];
  for (let i = 0; i < (selection?.rangeCount ?? 0); i++) {
    const range = selection?.getRangeAt(i);
    if (range) {
      ranges.push(range);
    }
  }
  return { selection, ranges };
}
function _preserveRangesWhile(beans, fn) {
  const enableCellTextSelection = beans.gos.get("enableCellTextSelection");
  if (!enableCellTextSelection) {
    return fn();
  }
  if (!_isBrowserFirefox() && !_isBrowserSafari()) {
    return fn();
  }
  const { selection, ranges } = _getTextSelectionRanges(beans);
  fn();
  selection?.removeAllRanges();
  for (const range of ranges) {
    selection?.addRange(range);
  }
}
function _requestAnimationFrame(beans, callback) {
  const win = _getWindow(beans);
  if (win.requestAnimationFrame) {
    win.requestAnimationFrame(callback);
  } else if (win.webkitRequestAnimationFrame) {
    win.webkitRequestAnimationFrame(callback);
  } else {
    win.setTimeout(callback, 0);
  }
}
var DataRefAttribute = "data-ref";
var whitespaceNode;
function getWhitespaceNode() {
  whitespaceNode ?? (whitespaceNode = document.createTextNode(" "));
  return whitespaceNode.cloneNode();
}
function _createElement(params) {
  const { attrs, children, cls, ref, role, tag } = params;
  const element = document.createElement(tag);
  if (cls) {
    element.className = cls;
  }
  if (ref) {
    element.setAttribute(DataRefAttribute, ref);
  }
  if (role) {
    element.setAttribute("role", role);
  }
  if (attrs) {
    for (const key of Object.keys(attrs)) {
      element.setAttribute(key, attrs[key]);
    }
  }
  if (children) {
    if (typeof children === "string") {
      element.textContent = children;
    } else {
      let addFirstWhitespace = true;
      for (const child of children) {
        if (child) {
          if (typeof child === "string") {
            element.appendChild(document.createTextNode(child));
            addFirstWhitespace = false;
          } else if (typeof child === "function") {
            element.appendChild(child());
          } else {
            if (addFirstWhitespace) {
              element.appendChild(getWhitespaceNode());
              addFirstWhitespace = false;
            }
            element.append(_createElement(child));
            element.appendChild(getWhitespaceNode());
          }
        }
      }
    }
  }
  return element;
}

// packages/ag-grid-community/src/utils/function.ts
var doOnceFlags = {};
function _doOnce(func, key) {
  if (doOnceFlags[key]) {
    return;
  }
  func();
  doOnceFlags[key] = true;
}
function _logIfDebug(gos, message, ...args) {
  if (gos.get("debug")) {
    console.log("AG Grid: " + message, ...args);
  }
}
function _warnOnce(msg, ...args) {
  _doOnce(() => console.warn("AG Grid: " + msg, ...args), msg + args?.join(""));
}
function _errorOnce(msg, ...args) {
  _doOnce(() => console.error("AG Grid: " + msg, ...args), msg + args?.join(""));
}
var batchedCallsSetTimeout = {
  pending: false,
  funcs: []
};
var batchedCallsRaf = {
  pending: false,
  funcs: []
};
function _batchCall(func, mode = "setTimeout", beans) {
  const batch = mode === "raf" ? batchedCallsRaf : batchedCallsSetTimeout;
  batch.funcs.push(func);
  if (batch.pending) {
    return;
  }
  batch.pending = true;
  const runBatch = () => {
    const funcsCopy = batch.funcs.slice();
    batch.funcs.length = 0;
    batch.pending = false;
    funcsCopy.forEach((func2) => func2());
  };
  if (mode === "raf") {
    _requestAnimationFrame(beans, runBatch);
  } else {
    window.setTimeout(runBatch, 0);
  }
}
function _debounce(bean, func, delay) {
  let timeout;
  return function(...args) {
    const context = this;
    window.clearTimeout(timeout);
    timeout = window.setTimeout(function() {
      if (bean.isAlive()) {
        func.apply(context, args);
      }
    }, delay);
  };
}
function _throttle(func, wait) {
  let previousCall = 0;
  return function(...args) {
    const context = this;
    const currentCall = Date.now();
    if (currentCall - previousCall < wait) {
      return;
    }
    previousCall = currentCall;
    func.apply(context, args);
  };
}
function _waitUntil(condition, callback, timeout = 100, timeoutMessage) {
  const timeStamp = Date.now();
  let interval = null;
  let executed = false;
  const internalCallback = () => {
    const reachedTimeout = Date.now() - timeStamp > timeout;
    if (condition() || reachedTimeout) {
      callback();
      executed = true;
      if (interval != null) {
        window.clearInterval(interval);
        interval = null;
      }
      if (reachedTimeout && timeoutMessage) {
        _warnOnce(timeoutMessage);
      }
    }
  };
  internalCallback();
  if (!executed) {
    interval = window.setInterval(internalCallback, 10);
  }
}

// packages/ag-grid-community/src/baseUrl.ts
var BASE_URL = "https://www.ag-grid.com";

// packages/ag-grid-community/src/version.ts
var VERSION = "34.1.1";

// packages/ag-grid-community/src/validation/logging.ts
var MAX_URL_LENGTH = 2e3;
var MIN_PARAM_LENGTH = 100;
var VERSION_PARAM_NAME = "_version_";
var validation = null;
var baseDocLink = `${BASE_URL}/javascript-data-grid`;
function provideValidationServiceLogger(logger) {
  validation = logger;
}
function setValidationDocLink(docLink) {
  baseDocLink = docLink;
}
function getErrorParts(id, args, defaultMessage) {
  return validation?.getConsoleMessage(id, args) ?? [minifiedLog(id, args, defaultMessage)];
}
function getMsgOrDefault(logger, id, args, defaultMessage) {
  logger(`error #${id}`, ...getErrorParts(id, args, defaultMessage));
}
function stringifyObject(inputObj) {
  if (!inputObj)
    return String(inputObj);
  const object = {};
  for (const prop of Object.keys(inputObj)) {
    if (typeof inputObj[prop] !== "object" && typeof inputObj[prop] !== "function") {
      object[prop] = inputObj[prop];
    }
  }
  return JSON.stringify(object);
}
function stringifyValue(value) {
  let output = value;
  if (value instanceof Error) {
    output = value.toString();
  } else if (typeof value === "object") {
    output = stringifyObject(value);
  }
  return output;
}
function toStringWithNullUndefined(str) {
  return str === void 0 ? "undefined" : str === null ? "null" : str;
}
function getParamsUrl(baseUrl, params) {
  return `${baseUrl}?${params.toString()}`;
}
function truncateUrl(baseUrl, params, maxLength) {
  const sortedParams = Array.from(params.entries()).sort((a, b) => b[1].length - a[1].length);
  let url = getParamsUrl(baseUrl, params);
  for (const [key, value] of sortedParams) {
    if (key === VERSION_PARAM_NAME) {
      continue;
    }
    const excessLength = url.length - maxLength;
    if (excessLength <= 0) {
      break;
    }
    const ellipse = "...";
    const truncateAmount = excessLength + ellipse.length;
    const truncatedValue = value.length - truncateAmount > MIN_PARAM_LENGTH ? value.slice(0, value.length - truncateAmount) + ellipse : value.slice(0, MIN_PARAM_LENGTH) + ellipse;
    params.set(key, truncatedValue);
    url = getParamsUrl(baseUrl, params);
  }
  return url;
}
function getErrorLink(errorNum, args) {
  const params = new URLSearchParams();
  params.append(VERSION_PARAM_NAME, VERSION);
  if (args) {
    for (const key of Object.keys(args)) {
      params.append(key, stringifyValue(args[key]));
    }
  }
  const baseUrl = `${baseDocLink}/errors/${errorNum}`;
  const url = getParamsUrl(baseUrl, params);
  return url.length <= MAX_URL_LENGTH ? url : truncateUrl(baseUrl, params, MAX_URL_LENGTH);
}
var minifiedLog = (errorNum, args, defaultMessage) => {
  const errorLink = getErrorLink(errorNum, args);
  return `${defaultMessage ? defaultMessage + " \n" : ""}Visit ${errorLink}${defaultMessage ? "" : " \n  Alternatively register the ValidationModule to see the full message in the console."}`;
};
function _warn(...args) {
  getMsgOrDefault(_warnOnce, args[0], args[1]);
}
function _error(...args) {
  getMsgOrDefault(_errorOnce, args[0], args[1]);
}
function _logPreInitErr(id, args, defaultMessage) {
  getMsgOrDefault(_errorOnce, id, args, defaultMessage);
}
function getErrMsg(defaultMessage, args) {
  const id = args[0];
  return `error #${id} ` + getErrorParts(id, args[1], defaultMessage).join(" ");
}
function _errMsg(...args) {
  return getErrMsg(void 0, args);
}
function _preInitErrMsg(...args) {
  return getErrMsg("\n", args);
}

// packages/ag-grid-community/src/gridOptionsUtils.ts
function isRowModelType(gos, rowModelType) {
  return gos.get("rowModelType") === rowModelType;
}
function _isClientSideRowModel(gos, rowModel) {
  return isRowModelType(gos, "clientSide");
}
function _isServerSideRowModel(gos, rowModel) {
  return isRowModelType(gos, "serverSide");
}
function _isDomLayout(gos, domLayout) {
  return gos.get("domLayout") === domLayout;
}
function _isRowSelection(gos) {
  return _getRowSelectionMode(gos) !== void 0;
}
function _isGetRowHeightFunction(gos) {
  return typeof gos.get("getRowHeight") === "function";
}
function _shouldMaintainColumnOrder(gos, isPivotColumns) {
  if (isPivotColumns) {
    return !gos.get("enableStrictPivotColumnOrder");
  }
  return gos.get("maintainColumnOrder");
}
function _getRowHeightForNode(beans, rowNode, allowEstimate = false, defaultRowHeight) {
  const { gos, environment } = beans;
  if (defaultRowHeight == null) {
    defaultRowHeight = environment.getDefaultRowHeight();
  }
  if (_isGetRowHeightFunction(gos)) {
    if (allowEstimate) {
      return { height: defaultRowHeight, estimated: true };
    }
    const params = {
      node: rowNode,
      data: rowNode.data
    };
    const height = gos.getCallback("getRowHeight")(params);
    if (isNumeric(height)) {
      if (height === 0) {
        _warn(23);
      }
      return { height: Math.max(1, height), estimated: false };
    }
  }
  if (rowNode.detail && gos.get("masterDetail")) {
    return getMasterDetailRowHeight(gos);
  }
  const gridOptionsRowHeight = gos.get("rowHeight");
  const rowHeight = gridOptionsRowHeight && isNumeric(gridOptionsRowHeight) ? gridOptionsRowHeight : defaultRowHeight;
  return { height: rowHeight, estimated: false };
}
function getMasterDetailRowHeight(gos) {
  if (gos.get("detailRowAutoHeight")) {
    return { height: 1, estimated: false };
  }
  const defaultRowHeight = gos.get("detailRowHeight");
  if (isNumeric(defaultRowHeight)) {
    return { height: defaultRowHeight, estimated: false };
  }
  return { height: 300, estimated: false };
}
function _getRowHeightAsNumber(beans) {
  const { environment, gos } = beans;
  const gridOptionsRowHeight = gos.get("rowHeight");
  if (!gridOptionsRowHeight || _missing(gridOptionsRowHeight)) {
    return environment.getDefaultRowHeight();
  }
  const rowHeight = environment.refreshRowHeightVariable();
  if (rowHeight !== -1) {
    return rowHeight;
  }
  _warn(24);
  return environment.getDefaultRowHeight();
}
function isNumeric(value) {
  return !isNaN(value) && typeof value === "number" && isFinite(value);
}
function _getDomData(gos, element, key) {
  const domData = element[gos.getDomDataKey()];
  return domData ? domData[key] : void 0;
}
function _setDomData(gos, element, key, value) {
  const domDataKey = gos.getDomDataKey();
  let domData = element[domDataKey];
  if (_missing(domData)) {
    domData = {};
    element[domDataKey] = domData;
  }
  domData[key] = value;
}
function _getDocument(beans) {
  const { gos, eGridDiv } = beans;
  let result = null;
  const gridOptionsGetDocument = gos.get("getDocument");
  if (gridOptionsGetDocument && _exists(gridOptionsGetDocument)) {
    result = gridOptionsGetDocument();
  } else if (eGridDiv) {
    result = eGridDiv.ownerDocument;
  }
  if (result && _exists(result)) {
    return result;
  }
  return document;
}
function _getWindow(beans) {
  const eDocument = _getDocument(beans);
  return eDocument.defaultView || window;
}
function _getRootNode(beans) {
  return beans.eGridDiv.getRootNode();
}
function _getActiveDomElement(beans) {
  return _getRootNode(beans).activeElement;
}
function _getPageBody(beans) {
  let rootNode = null;
  let targetEl = null;
  try {
    rootNode = _getDocument(beans).fullscreenElement;
  } catch (e) {
  } finally {
    if (!rootNode) {
      rootNode = _getRootNode(beans);
    }
    const body = rootNode.querySelector("body");
    if (body) {
      targetEl = body;
    } else if (rootNode instanceof ShadowRoot) {
      targetEl = rootNode;
    } else if (rootNode instanceof Document) {
      targetEl = rootNode?.documentElement;
    } else {
      targetEl = rootNode;
    }
  }
  return targetEl;
}
function _getBodyWidth(beans) {
  const body = _getPageBody(beans);
  return body?.clientWidth ?? (window.innerWidth || -1);
}
function _getBodyHeight(beans) {
  const body = _getPageBody(beans);
  return body?.clientHeight ?? (window.innerHeight || -1);
}
function _anchorElementToMouseMoveEvent(element, mouseMoveEvent, beans) {
  const eRect = element.getBoundingClientRect();
  const height = eRect.height;
  const browserWidth = _getBodyWidth(beans) - 2;
  const browserHeight = _getBodyHeight(beans) - 2;
  const offsetParent = element.offsetParent;
  if (!offsetParent) {
    return;
  }
  const offsetParentSize = _getElementRectWithOffset(element.offsetParent);
  const { clientY, clientX } = mouseMoveEvent;
  let top = clientY - offsetParentSize.top - height / 2;
  let left = clientX - offsetParentSize.left - 10;
  const eDocument = _getDocument(beans);
  const win = eDocument.defaultView || window;
  const windowScrollY = win.pageYOffset || eDocument.documentElement.scrollTop;
  const windowScrollX = win.pageXOffset || eDocument.documentElement.scrollLeft;
  if (browserWidth > 0 && left + element.clientWidth > browserWidth + windowScrollX) {
    left = browserWidth + windowScrollX - element.clientWidth;
  }
  if (left < 0) {
    left = 0;
  }
  if (browserHeight > 0 && top + element.clientHeight > browserHeight + windowScrollY) {
    top = browserHeight + windowScrollY - element.clientHeight;
  }
  if (top < 0) {
    top = 0;
  }
  element.style.left = `${left}px`;
  element.style.top = `${top}px`;
}
function _isNothingFocused(beans) {
  const activeEl = _getActiveDomElement(beans);
  return activeEl === null || activeEl === _getDocument(beans).body;
}
function _isAnimateRows(gos) {
  if (gos.get("ensureDomOrder")) {
    return false;
  }
  return gos.get("animateRows");
}
function _isGroupRowsSticky(gos) {
  if (gos.get("paginateChildRows") || gos.get("groupHideOpenParents") || _isDomLayout(gos, "print")) {
    return false;
  }
  return true;
}
function _isColumnsSortingCoupledToGroup(gos) {
  const autoGroupColumnDef = gos.get("autoGroupColumnDef");
  return !autoGroupColumnDef?.comparator && !gos.get("treeData");
}
function _getGroupAggFiltering(gos) {
  const userValue = gos.get("groupAggFiltering");
  if (typeof userValue === "function") {
    return gos.getCallback("groupAggFiltering");
  }
  if (userValue === true) {
    return () => true;
  }
  return void 0;
}
function _getGrandTotalRow(gos) {
  return gos.get("grandTotalRow");
}
function _getGroupTotalRowCallback(gos) {
  const userValue = gos.get("groupTotalRow");
  if (typeof userValue === "function") {
    return gos.getCallback("groupTotalRow");
  }
  return () => userValue ?? void 0;
}
function _isGroupMultiAutoColumn(gos) {
  const isHideOpenParents = !!gos.get("groupHideOpenParents");
  if (isHideOpenParents) {
    return true;
  }
  return gos.get("groupDisplayType") === "multipleColumns";
}
function _isGroupUseEntireRow(gos, pivotMode) {
  if (pivotMode) {
    return false;
  }
  return gos.get("groupDisplayType") === "groupRows";
}
function _isFullWidthGroupRow(gos, node, pivotMode) {
  return !!node.group && !node.footer && _isGroupUseEntireRow(gos, pivotMode);
}
function _getRowIdCallback(gos) {
  const getRowId = gos.getCallback("getRowId");
  if (getRowId === void 0) {
    return getRowId;
  }
  return (params) => {
    let id = getRowId(params);
    if (typeof id !== "string") {
      _doOnce(() => _warn(25, { id }), "getRowIdString");
      id = String(id);
    }
    return id;
  };
}
function _canSkipShowingRowGroup(gos, node) {
  const isSkippingGroups = gos.get("groupHideParentOfSingleChild");
  if (isSkippingGroups === true) {
    return true;
  }
  if (isSkippingGroups === "leafGroupsOnly" && node.leafGroup) {
    return true;
  }
  if (gos.get("groupRemoveSingleChildren")) {
    return true;
  }
  if (gos.get("groupRemoveLowestSingleChildren") && node.leafGroup) {
    return true;
  }
  return false;
}
function _getMaxConcurrentDatasourceRequests(gos) {
  const res = gos.get("maxConcurrentDatasourceRequests");
  return res > 0 ? res : void 0;
}
function _shouldUpdateColVisibilityAfterGroup(gos, isGrouped) {
  const preventVisibilityChanges = gos.get("suppressGroupChangesColumnVisibility");
  if (preventVisibilityChanges === true) {
    return false;
  }
  if (isGrouped && preventVisibilityChanges === "suppressHideOnGroup") {
    return false;
  }
  if (!isGrouped && preventVisibilityChanges === "suppressShowOnUngroup") {
    return false;
  }
  const legacySuppressOnGroup = gos.get("suppressRowGroupHidesColumns");
  if (isGrouped && legacySuppressOnGroup === true) {
    return false;
  }
  const legacySuppressOnUngroup = gos.get("suppressMakeColumnVisibleAfterUnGroup");
  if (!isGrouped && legacySuppressOnUngroup === true) {
    return false;
  }
  return true;
}
function _getCheckboxes(selection) {
  return selection?.checkboxes ?? true;
}
function _getHeaderCheckbox(selection) {
  return selection?.mode === "multiRow" && (selection.headerCheckbox ?? true);
}
function _getCheckboxLocation(rowSelection) {
  if (typeof rowSelection !== "object") {
    return void 0;
  }
  return rowSelection.checkboxLocation ?? "selectionColumn";
}
function _getHideDisabledCheckboxes(selection) {
  return selection?.hideDisabledCheckboxes ?? false;
}
function _isUsingNewRowSelectionAPI(gos) {
  const rowSelection = gos.get("rowSelection");
  return typeof rowSelection !== "string";
}
function _isUsingNewCellSelectionAPI(gos) {
  return gos.get("cellSelection") !== void 0;
}
function _getSuppressMultiRanges(gos) {
  const selection = gos.get("cellSelection");
  const useNewAPI = selection !== void 0;
  if (!useNewAPI) {
    return gos.get("suppressMultiRangeSelection");
  }
  return typeof selection !== "boolean" ? selection?.suppressMultiRanges ?? false : false;
}
function _isCellSelectionEnabled(gos) {
  const selection = gos.get("cellSelection");
  const useNewAPI = selection !== void 0;
  return useNewAPI ? !!selection : gos.get("enableRangeSelection");
}
function _getFillHandle(gos) {
  const selection = gos.get("cellSelection");
  const useNewAPI = selection !== void 0;
  if (!useNewAPI) {
    return {
      mode: "fill",
      setFillValue: gos.get("fillOperation"),
      direction: gos.get("fillHandleDirection"),
      suppressClearOnFillReduction: gos.get("suppressClearOnFillReduction")
    };
  }
  return typeof selection !== "boolean" && selection.handle?.mode === "fill" ? selection.handle : void 0;
}
function _getEnableClickSelection(gos) {
  const selection = gos.get("rowSelection") ?? "single";
  if (typeof selection === "string") {
    const suppressRowClickSelection = gos.get("suppressRowClickSelection");
    const suppressRowDeselection = gos.get("suppressRowDeselection");
    if (suppressRowClickSelection && suppressRowDeselection) {
      return false;
    } else if (suppressRowClickSelection) {
      return "enableDeselection";
    } else if (suppressRowDeselection) {
      return "enableSelection";
    } else {
      return true;
    }
  }
  return selection.mode === "singleRow" || selection.mode === "multiRow" ? selection.enableClickSelection ?? false : false;
}
function _getEnableSelection(gos) {
  const enableClickSelection = _getEnableClickSelection(gos);
  return enableClickSelection === true || enableClickSelection === "enableSelection";
}
function _getEnableDeselection(gos) {
  const enableClickSelection = _getEnableClickSelection(gos);
  return enableClickSelection === true || enableClickSelection === "enableDeselection";
}
function _getIsRowSelectable(gos) {
  const selection = gos.get("rowSelection");
  if (typeof selection === "string") {
    return gos.get("isRowSelectable");
  }
  return selection?.isRowSelectable;
}
function _getRowSelectionMode(arg) {
  const selection = "beanName" in arg && arg.beanName === "gos" ? arg.get("rowSelection") : arg.rowSelection;
  if (typeof selection === "string") {
    switch (selection) {
      case "multiple":
        return "multiRow";
      case "single":
        return "singleRow";
      default:
        return;
    }
  }
  switch (selection?.mode) {
    case "multiRow":
    case "singleRow":
      return selection.mode;
    default:
      return;
  }
}
function _isMultiRowSelection(arg) {
  const mode = _getRowSelectionMode(arg);
  return mode === "multiRow";
}
function _getEnableSelectionWithoutKeys(gos) {
  const selection = gos.get("rowSelection");
  if (typeof selection === "string") {
    return gos.get("rowMultiSelectWithClick");
  }
  return selection?.enableSelectionWithoutKeys ?? false;
}
function _getGroupSelection(gos) {
  const selection = gos.get("rowSelection");
  if (typeof selection === "string") {
    const groupSelectsChildren = gos.get("groupSelectsChildren");
    const groupSelectsFiltered = gos.get("groupSelectsFiltered");
    if (groupSelectsChildren && groupSelectsFiltered) {
      return "filteredDescendants";
    } else if (groupSelectsChildren) {
      return "descendants";
    } else {
      return "self";
    }
  }
  return selection?.mode === "multiRow" ? selection.groupSelects : void 0;
}
function _getSelectAll(gos, defaultValue = true) {
  const rowSelection = gos.get("rowSelection");
  if (typeof rowSelection !== "object") {
    return defaultValue ? "all" : void 0;
  }
  return rowSelection.mode === "multiRow" ? rowSelection.selectAll : "all";
}
function _getGroupSelectsDescendants(gos) {
  const groupSelection = _getGroupSelection(gos);
  return groupSelection === "descendants" || groupSelection === "filteredDescendants";
}
function _getMasterSelects(gos) {
  const rowSelection = gos.get("rowSelection");
  return typeof rowSelection === "object" && rowSelection.masterSelects || "self";
}
function _isSetFilterByDefault(gos) {
  return gos.isModuleRegistered("SetFilter") && !gos.get("suppressSetFilterByDefault");
}
function _isLegacyMenuEnabled(gos) {
  return gos.get("columnMenu") === "legacy";
}
function _isColumnMenuAnchoringEnabled(gos) {
  return !_isLegacyMenuEnabled(gos);
}
function _getCallbackForEvent(eventName) {
  if (!eventName || eventName.length < 2) {
    return eventName;
  }
  return "on" + eventName[0].toUpperCase() + eventName.substring(1);
}
function _combineAttributesAndGridOptions(gridOptions, component, gridOptionsKeys) {
  if (typeof gridOptions !== "object") {
    gridOptions = {};
  }
  const mergedOptions = { ...gridOptions };
  gridOptionsKeys.forEach((key) => {
    const value = component[key];
    if (typeof value !== "undefined") {
      mergedOptions[key] = value;
    }
  });
  return mergedOptions;
}
function _processOnChange(changes, api) {
  if (!changes) {
    return;
  }
  const gridChanges = {};
  let hasChanges = false;
  Object.keys(changes).forEach((key) => {
    gridChanges[key] = changes[key];
    hasChanges = true;
  });
  if (!hasChanges) {
    return;
  }
  const internalUpdateEvent = {
    type: "gridOptionsChanged",
    options: gridChanges
  };
  api.dispatchEvent(internalUpdateEvent);
  const event = {
    type: "componentStateChanged",
    ...gridChanges
  };
  api.dispatchEvent(event);
}
function _addGridCommonParams(gos, params) {
  return gos.addGridCommonParams(params);
}
function _getGroupingApproach(gos) {
  if (gos.get("treeData")) {
    if (gos.get("treeDataParentIdField")) {
      return "treeSelfRef";
    }
    if (gos.get("treeDataChildrenField")) {
      return "treeNested";
    }
    return "treePath";
  }
  return "group";
}
function _getGridOption(providedGridOptions, gridOption) {
  return providedGridOptions[gridOption] ?? providedGridOptions[`gridOptions`]?.[gridOption] ?? _getGlobalGridOption(gridOption) ?? GRID_OPTION_DEFAULTS[gridOption];
}

// packages/ag-grid-community/src/utils/event.ts
var AG_GRID_STOP_PROPAGATION = "__ag_Grid_Stop_Propagation";
var PASSIVE_EVENTS = ["touchstart", "touchend", "touchmove", "touchcancel", "scroll"];
var NON_PASSIVE_EVENTS = ["wheel"];
var supports = {};
function _stopPropagationForAgGrid(event) {
  event[AG_GRID_STOP_PROPAGATION] = true;
}
function _isStopPropagationForAgGrid(event) {
  return event[AG_GRID_STOP_PROPAGATION] === true;
}
var _isEventSupported = /* @__PURE__ */ (() => {
  const tags = {
    select: "input",
    change: "input",
    submit: "form",
    reset: "form",
    error: "img",
    load: "img",
    abort: "img"
  };
  const eventChecker = (eventName) => {
    if (typeof supports[eventName] === "boolean") {
      return supports[eventName];
    }
    const el = document.createElement(tags[eventName] || "div");
    eventName = "on" + eventName;
    return supports[eventName] = eventName in el;
  };
  return eventChecker;
})();
function _getCtrlForEventTarget(gos, eventTarget, type) {
  let sourceElement = eventTarget;
  while (sourceElement) {
    const renderedComp = _getDomData(gos, sourceElement, type);
    if (renderedComp) {
      return renderedComp;
    }
    sourceElement = sourceElement.parentElement;
  }
  return null;
}
function _isElementInEventPath(element, event) {
  if (!event || !element) {
    return false;
  }
  return _getEventPath(event).indexOf(element) >= 0;
}
function _createEventPath(event) {
  const res = [];
  let pointer = event.target;
  while (pointer) {
    res.push(pointer);
    pointer = pointer.parentElement;
  }
  return res;
}
function _getEventPath(event) {
  const eventNoType = event;
  if (eventNoType.path) {
    return eventNoType.path;
  }
  if (eventNoType.composedPath) {
    return eventNoType.composedPath();
  }
  return _createEventPath(eventNoType);
}
function _addSafePassiveEventListener(frameworkOverrides, eElement, event, listener) {
  const passive = getPassiveStateForEvent(event);
  let options;
  if (passive != null) {
    options = { passive };
  }
  if (frameworkOverrides && frameworkOverrides.addEventListener) {
    frameworkOverrides.addEventListener(eElement, event, listener, options);
  }
}
var getPassiveStateForEvent = (event) => {
  const isPassive = PASSIVE_EVENTS.includes(event);
  const isNonPassive = NON_PASSIVE_EVENTS.includes(event);
  if (isPassive) {
    return true;
  }
  if (isNonPassive) {
    return false;
  }
};

// packages/ag-grid-community/src/context/beanStub.ts
var BeanStub = class {
  constructor() {
    // not named context to allow children to use 'context' as a variable name
    this.destroyFunctions = [];
    this.destroyed = false;
    // for vue 3 - prevents Vue from trying to make this (and obviously any sub classes) from being reactive
    // prevents vue from creating proxies for created objects and prevents identity related issues
    this.__v_skip = true;
    this.propertyListenerId = 0;
    // Enable multiple grid properties to be updated together by the user but only trigger shared logic once.
    // Closely related to logic in GridOptionsUtils.ts _processOnChange
    this.lastChangeSetIdLookup = {};
    this.isAlive = () => !this.destroyed;
  }
  preWireBeans(beans) {
    this.beans = beans;
    this.stubContext = beans.context;
    this.eventSvc = beans.eventSvc;
    this.gos = beans.gos;
  }
  // this was a test constructor niall built, when active, it prints after 5 seconds all beans/components that are
  // not destroyed. to use, create a new grid, then api.destroy() before 5 seconds. then anything that gets printed
  // points to a bean or component that was not properly disposed of.
  // constructor() {
  //     setTimeout(()=> {
  //         if (this.isAlive()) {
  //             let prototype: any = Object.getPrototypeOf(this);
  //             const constructor: any = prototype.constructor;
  //             const constructorString = constructor.toString();
  //             const beanName = constructorString.substring(9, constructorString.indexOf("("));
  //             console.log('is alive ' + beanName);
  //         }
  //     }, 5000);
  // }
  destroy() {
    const { destroyFunctions } = this;
    for (let i = 0; i < destroyFunctions.length; i++) {
      destroyFunctions[i]();
    }
    destroyFunctions.length = 0;
    this.destroyed = true;
    this.dispatchLocalEvent({ type: "destroyed" });
  }
  // The typing of AgEventListener<any, any, any> is not ideal, but it's the best we can do at the moment to enable
  // eventSvc to have the best typing at the expense of BeanStub local events
  /** Add a local event listener against this BeanStub */
  addEventListener(eventType, listener, async) {
    if (!this.localEventService) {
      this.localEventService = new LocalEventService();
    }
    this.localEventService.addEventListener(eventType, listener, async);
  }
  /** Remove a local event listener from this BeanStub */
  removeEventListener(eventType, listener, async) {
    this.localEventService?.removeEventListener(eventType, listener, async);
  }
  dispatchLocalEvent(event) {
    this.localEventService?.dispatchEvent(event);
  }
  addManagedElementListeners(object, handlers) {
    return this._setupListeners(object, handlers);
  }
  addManagedEventListeners(handlers) {
    return this._setupListeners(this.eventSvc, handlers);
  }
  addManagedListeners(object, handlers) {
    return this._setupListeners(object, handlers);
  }
  _setupListeners(object, handlers) {
    const destroyFuncs = [];
    for (const k of Object.keys(handlers)) {
      const handler = handlers[k];
      if (handler) {
        destroyFuncs.push(this._setupListener(object, k, handler));
      }
    }
    return destroyFuncs;
  }
  _setupListener(object, event, listener) {
    if (this.destroyed) {
      return () => null;
    }
    let destroyFunc;
    if (isAgEventEmitter(object)) {
      object.__addEventListener(event, listener);
      destroyFunc = () => {
        object.__removeEventListener(event, listener);
        return null;
      };
    } else {
      if (object instanceof HTMLElement) {
        _addSafePassiveEventListener(this.beans.frameworkOverrides, object, event, listener);
      } else {
        object.addEventListener(event, listener);
      }
      destroyFunc = () => {
        object.removeEventListener(event, listener);
        return null;
      };
    }
    this.destroyFunctions.push(destroyFunc);
    return () => {
      destroyFunc();
      this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
      return null;
    };
  }
  /**
   * Setup a managed property listener for the given GridOption property.
   * However, stores the destroy function in the beanStub so that if this bean
   * is a component the destroy function will be called when the component is destroyed
   * as opposed to being cleaned up only when the GridOptionsService is destroyed.
   */
  setupGridOptionListener(event, listener) {
    const { gos } = this;
    gos.addPropertyEventListener(event, listener);
    const destroyFunc = () => {
      gos.removePropertyEventListener(event, listener);
      return null;
    };
    this.destroyFunctions.push(destroyFunc);
    return () => {
      destroyFunc();
      this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
      return null;
    };
  }
  /**
   * Setup a managed property listener for the given GridOption property.
   * @param event GridOption property to listen to changes for.
   * @param listener Listener to run when property value changes
   */
  addManagedPropertyListener(event, listener) {
    if (this.destroyed) {
      return () => null;
    }
    return this.setupGridOptionListener(event, listener);
  }
  /**
   * Setup managed property listeners for the given set of GridOption properties.
   * The listener will be run if any of the property changes but will only run once if
   * multiple of the properties change within the same framework lifecycle event.
   * Works on the basis that GridOptionsService updates all properties *before* any property change events are fired.
   * @param events Array of GridOption properties to listen for changes too.
   * @param listener Shared listener to run if any of the properties change
   */
  addManagedPropertyListeners(events, listener) {
    if (this.destroyed) {
      return;
    }
    const eventsKey = events.join("-") + this.propertyListenerId++;
    const wrappedListener = (event) => {
      if (event.changeSet) {
        if (event.changeSet && event.changeSet.id === this.lastChangeSetIdLookup[eventsKey]) {
          return;
        }
        this.lastChangeSetIdLookup[eventsKey] = event.changeSet.id;
      }
      const propertiesChangeEvent = {
        type: "gridPropertyChanged",
        changeSet: event.changeSet,
        source: event.source
      };
      listener(propertiesChangeEvent);
    };
    events.forEach((event) => this.setupGridOptionListener(event, wrappedListener));
  }
  getLocaleTextFunc() {
    return _getLocaleTextFunc(this.beans.localeSvc);
  }
  addDestroyFunc(func) {
    if (this.isAlive()) {
      this.destroyFunctions.push(func);
    } else {
      func();
    }
  }
  /** doesn't throw an error if `bean` is undefined */
  createOptionalManagedBean(bean, context) {
    return bean ? this.createManagedBean(bean, context) : void 0;
  }
  createManagedBean(bean, context) {
    const res = this.createBean(bean, context);
    this.addDestroyFunc(this.destroyBean.bind(this, bean, context));
    return res;
  }
  createBean(bean, context, afterPreCreateCallback) {
    return (context || this.stubContext).createBean(bean, afterPreCreateCallback);
  }
  /**
   * Destroys a bean and returns undefined to support destruction and clean up in a single line.
   * this.dateComp = this.context.destroyBean(this.dateComp);
   */
  destroyBean(bean, context) {
    return (context || this.stubContext).destroyBean(bean);
  }
  /**
   * Destroys an array of beans and returns an empty array to support destruction and clean up in a single line.
   * this.dateComps = this.context.destroyBeans(this.dateComps);
   */
  destroyBeans(beans, context) {
    return (context || this.stubContext).destroyBeans(beans);
  }
};
function isAgEventEmitter(object) {
  return object.__addEventListener !== void 0;
}

// packages/ag-grid-community/src/utils/string.ts
var reUnescapedHtml = /[&<>"']/g;
var HTML_ESCAPES = {
  "&": "&amp;",
  "<": "&lt;",
  ">": "&gt;",
  '"': "&quot;",
  "'": "&#39;"
};
function _toString(toEscape) {
  return toEscape?.toString().toString() ?? null;
}
function _escapeString(toEscape) {
  return _toString(toEscape)?.replace(reUnescapedHtml, (chr) => HTML_ESCAPES[chr]) ?? null;
}

// packages/ag-grid-community/src/entities/agColumn.ts
var COL_DEF_DEFAULTS = {
  resizable: true,
  sortable: true
};
var instanceIdSequence = 0;
function getNextColInstanceId() {
  return instanceIdSequence++;
}
function isColumn(col) {
  return col instanceof AgColumn;
}
var AgColumn = class extends BeanStub {
  constructor(colDef, userProvidedColDef, colId, primary) {
    super();
    this.colDef = colDef;
    this.userProvidedColDef = userProvidedColDef;
    this.colId = colId;
    this.primary = primary;
    this.isColumn = true;
    // used by React (and possibly other frameworks) as key for rendering. also used to
    // identify old vs new columns for destroying cols when no longer used.
    this.instanceId = getNextColInstanceId();
    // The measured height of this column's header when autoHeaderHeight is enabled
    this.autoHeaderHeight = null;
    this.moving = false;
    this.resizing = false;
    this.menuVisible = false;
    this.lastLeftPinned = false;
    this.firstRightPinned = false;
    this.filterActive = false;
    this.colEventSvc = new LocalEventService();
    this.tooltipEnabled = false;
    this.rowGroupActive = false;
    this.pivotActive = false;
    this.aggregationActive = false;
    this.flex = null;
    this.colIdSanitised = _escapeString(colId);
  }
  destroy() {
    super.destroy();
    this.beans.rowSpanSvc?.deregister(this);
  }
  getInstanceId() {
    return this.instanceId;
  }
  setState() {
    const {
      colDef,
      beans: { sortSvc, pinnedCols, colFlex }
    } = this;
    sortSvc?.initCol(this);
    const hide = colDef.hide;
    if (hide !== void 0) {
      this.visible = !hide;
    } else {
      this.visible = !colDef.initialHide;
    }
    pinnedCols?.initCol(this);
    colFlex?.initCol(this);
  }
  // gets called when user provides an alternative colDef, eg
  setColDef(colDef, userProvidedColDef, source) {
    const colSpanChanged = colDef.spanRows !== this.colDef.spanRows;
    this.colDef = colDef;
    this.userProvidedColDef = userProvidedColDef;
    this.initMinAndMaxWidths();
    this.initDotNotation();
    this.initTooltip();
    if (colSpanChanged) {
      this.beans.rowSpanSvc?.deregister(this);
      this.initRowSpan();
    }
    this.dispatchColEvent("colDefChanged", source);
  }
  getUserProvidedColDef() {
    return this.userProvidedColDef;
  }
  getParent() {
    return this.parent;
  }
  getOriginalParent() {
    return this.originalParent;
  }
  // this is done after constructor as it uses gridOptionsService
  postConstruct() {
    this.setState();
    this.initMinAndMaxWidths();
    this.resetActualWidth("gridInitializing");
    this.initDotNotation();
    this.initTooltip();
    this.initRowSpan();
    this.addPivotListener();
  }
  initDotNotation() {
    const {
      gos,
      colDef: { field, tooltipField }
    } = this;
    const suppressDotNotation = gos.get("suppressFieldDotNotation");
    this.fieldContainsDots = _exists(field) && field.indexOf(".") >= 0 && !suppressDotNotation;
    this.tooltipFieldContainsDots = _exists(tooltipField) && tooltipField.indexOf(".") >= 0 && !suppressDotNotation;
  }
  initMinAndMaxWidths() {
    const colDef = this.colDef;
    this.minWidth = colDef.minWidth ?? this.beans.environment.getDefaultColumnMinWidth();
    this.maxWidth = colDef.maxWidth ?? Number.MAX_SAFE_INTEGER;
  }
  initTooltip() {
    this.beans.tooltipSvc?.initCol(this);
  }
  initRowSpan() {
    if (this.colDef.spanRows) {
      this.beans.rowSpanSvc?.register(this);
    }
  }
  addPivotListener() {
    const pivotColDefSvc = this.beans.pivotColDefSvc;
    const pivotValueColumn = this.colDef.pivotValueColumn;
    if (!pivotColDefSvc || !pivotValueColumn) {
      return;
    }
    this.addManagedListeners(pivotValueColumn, {
      colDefChanged: (evt) => {
        const colDef = pivotColDefSvc.recreateColDef(this.colDef);
        this.setColDef(colDef, colDef, evt.source);
      }
    });
  }
  resetActualWidth(source) {
    const initialWidth = this.calculateColInitialWidth(this.colDef);
    this.setActualWidth(initialWidth, source, true);
  }
  calculateColInitialWidth(colDef) {
    let width;
    const colDefWidth = colDef.width;
    const colDefInitialWidth = colDef.initialWidth;
    if (colDefWidth != null) {
      width = colDefWidth;
    } else if (colDefInitialWidth != null) {
      width = colDefInitialWidth;
    } else {
      width = 200;
    }
    return Math.max(Math.min(width, this.maxWidth), this.minWidth);
  }
  isEmptyGroup() {
    return false;
  }
  isRowGroupDisplayed(colId) {
    return this.beans.showRowGroupCols?.isRowGroupDisplayed(this, colId) ?? false;
  }
  isPrimary() {
    return this.primary;
  }
  isFilterAllowed() {
    const filterDefined = !!this.colDef.filter;
    return filterDefined;
  }
  isFieldContainsDots() {
    return this.fieldContainsDots;
  }
  isTooltipEnabled() {
    return this.tooltipEnabled;
  }
  isTooltipFieldContainsDots() {
    return this.tooltipFieldContainsDots;
  }
  getHighlighted() {
    return this.highlighted;
  }
  __addEventListener(eventType, listener) {
    this.colEventSvc.addEventListener(eventType, listener);
  }
  __removeEventListener(eventType, listener) {
    this.colEventSvc.removeEventListener(eventType, listener);
  }
  /**
   * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
   */
  addEventListener(eventType, userListener) {
    this.frameworkEventListenerService = this.beans.frameworkOverrides.createLocalEventListenerWrapper?.(
      this.frameworkEventListenerService,
      this.colEventSvc
    );
    const listener = this.frameworkEventListenerService?.wrap(eventType, userListener) ?? userListener;
    this.colEventSvc.addEventListener(eventType, listener);
  }
  /**
   * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
   */
  removeEventListener(eventType, userListener) {
    const listener = this.frameworkEventListenerService?.unwrap(eventType, userListener) ?? userListener;
    this.colEventSvc.removeEventListener(eventType, listener);
  }
  createColumnFunctionCallbackParams(rowNode) {
    return _addGridCommonParams(this.gos, {
      node: rowNode,
      data: rowNode.data,
      column: this,
      colDef: this.colDef
    });
  }
  isSuppressNavigable(rowNode) {
    return this.beans.cellNavigation?.isSuppressNavigable(this, rowNode) ?? false;
  }
  isCellEditable(rowNode) {
    return this.beans.editSvc?.isCellEditable({ rowNode, column: this }) ?? false;
  }
  isSuppressFillHandle() {
    return !!this.colDef.suppressFillHandle;
  }
  isAutoHeight() {
    return !!this.colDef.autoHeight;
  }
  isAutoHeaderHeight() {
    return !!this.colDef.autoHeaderHeight;
  }
  isRowDrag(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef.rowDrag);
  }
  isDndSource(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef.dndSource);
  }
  isCellCheckboxSelection(rowNode) {
    return this.beans.selectionSvc?.isCellCheckboxSelection(this, rowNode) ?? false;
  }
  isSuppressPaste(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef?.suppressPaste ?? null);
  }
  isResizable() {
    return !!this.getColDefValue("resizable");
  }
  /** Get value from ColDef or default if it exists. */
  getColDefValue(key) {
    return this.colDef[key] ?? COL_DEF_DEFAULTS[key];
  }
  isColumnFunc(rowNode, value) {
    if (typeof value === "boolean") {
      return value;
    }
    if (typeof value === "function") {
      const params = this.createColumnFunctionCallbackParams(rowNode);
      const editableFunc = value;
      return editableFunc(params);
    }
    return false;
  }
  createColumnEvent(type, source) {
    return _addGridCommonParams(this.gos, {
      type,
      column: this,
      columns: [this],
      source
    });
  }
  isMoving() {
    return this.moving;
  }
  getSort() {
    return this.sort;
  }
  isSortable() {
    return !!this.getColDefValue("sortable");
  }
  /** @deprecated v32 use col.getSort() === 'asc */
  isSortAscending() {
    return this.sort === "asc";
  }
  /** @deprecated v32 use col.getSort() === 'desc */
  isSortDescending() {
    return this.sort === "desc";
  }
  /** @deprecated v32 use col.getSort() === undefined */
  isSortNone() {
    return _missing(this.sort);
  }
  /** @deprecated v32 use col.getSort() !== undefined */
  isSorting() {
    return _exists(this.sort);
  }
  getSortIndex() {
    return this.sortIndex;
  }
  isMenuVisible() {
    return this.menuVisible;
  }
  getAggFunc() {
    return this.aggFunc;
  }
  getLeft() {
    return this.left;
  }
  getOldLeft() {
    return this.oldLeft;
  }
  getRight() {
    return this.left + this.actualWidth;
  }
  setLeft(left, source) {
    this.oldLeft = this.left;
    if (this.left !== left) {
      this.left = left;
      this.dispatchColEvent("leftChanged", source);
    }
  }
  isFilterActive() {
    return this.filterActive;
  }
  /** @deprecated v33 Use `api.isColumnHovered(column)` instead. */
  isHovered() {
    _warn(261);
    return !!this.beans.colHover?.isHovered(this);
  }
  setFirstRightPinned(firstRightPinned, source) {
    if (this.firstRightPinned !== firstRightPinned) {
      this.firstRightPinned = firstRightPinned;
      this.dispatchColEvent("firstRightPinnedChanged", source);
    }
  }
  setLastLeftPinned(lastLeftPinned, source) {
    if (this.lastLeftPinned !== lastLeftPinned) {
      this.lastLeftPinned = lastLeftPinned;
      this.dispatchColEvent("lastLeftPinnedChanged", source);
    }
  }
  isFirstRightPinned() {
    return this.firstRightPinned;
  }
  isLastLeftPinned() {
    return this.lastLeftPinned;
  }
  isPinned() {
    return this.pinned === "left" || this.pinned === "right";
  }
  isPinnedLeft() {
    return this.pinned === "left";
  }
  isPinnedRight() {
    return this.pinned === "right";
  }
  getPinned() {
    return this.pinned;
  }
  setVisible(visible, source) {
    const newValue = visible === true;
    if (this.visible !== newValue) {
      this.visible = newValue;
      this.dispatchColEvent("visibleChanged", source);
    }
    this.dispatchStateUpdatedEvent("hide");
  }
  isVisible() {
    return this.visible;
  }
  isSpanHeaderHeight() {
    const colDef = this.getColDef();
    return !colDef.suppressSpanHeaderHeight;
  }
  /**
   * Returns the first parent that is not a padding group.
   */
  getFirstRealParent() {
    let parent = this.getOriginalParent();
    while (parent && parent.isPadding()) {
      parent = parent.getOriginalParent();
    }
    return parent;
  }
  getColumnGroupPaddingInfo() {
    let parent = this.getParent();
    if (!parent || !parent.isPadding()) {
      return { numberOfParents: 0, isSpanningTotal: false };
    }
    const numberOfParents = parent.getPaddingLevel() + 1;
    let isSpanningTotal = true;
    while (parent) {
      if (!parent.isPadding()) {
        isSpanningTotal = false;
        break;
      }
      parent = parent.getParent();
    }
    return { numberOfParents, isSpanningTotal };
  }
  getColDef() {
    return this.colDef;
  }
  getDefinition() {
    return this.colDef;
  }
  getColumnGroupShow() {
    return this.colDef.columnGroupShow;
  }
  getColId() {
    return this.colId;
  }
  getId() {
    return this.colId;
  }
  getUniqueId() {
    return this.colId;
  }
  getActualWidth() {
    return this.actualWidth;
  }
  getAutoHeaderHeight() {
    return this.autoHeaderHeight;
  }
  /** Returns true if the header height has changed */
  setAutoHeaderHeight(height) {
    const changed = height !== this.autoHeaderHeight;
    this.autoHeaderHeight = height;
    return changed;
  }
  createBaseColDefParams(rowNode) {
    const params = _addGridCommonParams(this.gos, {
      node: rowNode,
      data: rowNode.data,
      colDef: this.colDef,
      column: this
    });
    return params;
  }
  getColSpan(rowNode) {
    if (_missing(this.colDef.colSpan)) {
      return 1;
    }
    const params = this.createBaseColDefParams(rowNode);
    const colSpan = this.colDef.colSpan(params);
    return Math.max(colSpan, 1);
  }
  getRowSpan(rowNode) {
    if (_missing(this.colDef.rowSpan)) {
      return 1;
    }
    const params = this.createBaseColDefParams(rowNode);
    const rowSpan = this.colDef.rowSpan(params);
    return Math.max(rowSpan, 1);
  }
  setActualWidth(actualWidth, source, silent = false) {
    actualWidth = Math.max(actualWidth, this.minWidth);
    actualWidth = Math.min(actualWidth, this.maxWidth);
    if (this.actualWidth !== actualWidth) {
      this.actualWidth = actualWidth;
      if (this.flex != null && source !== "flex" && source !== "gridInitializing") {
        this.flex = null;
      }
      if (!silent) {
        this.fireColumnWidthChangedEvent(source);
      }
    }
    this.dispatchStateUpdatedEvent("width");
  }
  fireColumnWidthChangedEvent(source) {
    this.dispatchColEvent("widthChanged", source);
  }
  isGreaterThanMax(width) {
    return width > this.maxWidth;
  }
  getMinWidth() {
    return this.minWidth;
  }
  getMaxWidth() {
    return this.maxWidth;
  }
  getFlex() {
    return this.flex;
  }
  isRowGroupActive() {
    return this.rowGroupActive;
  }
  isPivotActive() {
    return this.pivotActive;
  }
  isAnyFunctionActive() {
    return this.isPivotActive() || this.isRowGroupActive() || this.isValueActive();
  }
  isAnyFunctionAllowed() {
    return this.isAllowPivot() || this.isAllowRowGroup() || this.isAllowValue();
  }
  isValueActive() {
    return this.aggregationActive;
  }
  isAllowPivot() {
    return this.colDef.enablePivot === true;
  }
  isAllowValue() {
    return this.colDef.enableValue === true;
  }
  isAllowRowGroup() {
    return this.colDef.enableRowGroup === true;
  }
  dispatchColEvent(type, source, additionalEventAttributes) {
    const colEvent = this.createColumnEvent(type, source);
    if (additionalEventAttributes) {
      _mergeDeep(colEvent, additionalEventAttributes);
    }
    this.colEventSvc.dispatchEvent(colEvent);
  }
  dispatchStateUpdatedEvent(key) {
    this.colEventSvc.dispatchEvent({
      type: "columnStateUpdated",
      key
    });
  }
};

// packages/ag-grid-community/src/entities/agProvidedColumnGroup.ts
function isProvidedColumnGroup(col) {
  return col instanceof AgProvidedColumnGroup;
}
var AgProvidedColumnGroup = class extends BeanStub {
  constructor(colGroupDef, groupId, padding, level) {
    super();
    this.colGroupDef = colGroupDef;
    this.groupId = groupId;
    this.padding = padding;
    this.level = level;
    this.isColumn = false;
    this.expandable = false;
    // used by React (and possibly other frameworks) as key for rendering. also used to
    // identify old vs new columns for destroying cols when no longer used.
    this.instanceId = getNextColInstanceId();
    this.expandableListenerRemoveCallback = null;
    this.expanded = !!colGroupDef?.openByDefault;
  }
  destroy() {
    if (this.expandableListenerRemoveCallback) {
      this.reset(null, void 0);
    }
    super.destroy();
  }
  reset(colGroupDef, level) {
    this.colGroupDef = colGroupDef;
    this.level = level;
    this.originalParent = null;
    if (this.expandableListenerRemoveCallback) {
      this.expandableListenerRemoveCallback();
    }
    this.children = void 0;
    this.expandable = void 0;
  }
  getInstanceId() {
    return this.instanceId;
  }
  getOriginalParent() {
    return this.originalParent;
  }
  getLevel() {
    return this.level;
  }
  isVisible() {
    if (this.children) {
      return this.children.some((child) => child.isVisible());
    }
    return false;
  }
  isPadding() {
    return this.padding;
  }
  setExpanded(expanded) {
    this.expanded = expanded === void 0 ? false : expanded;
    this.dispatchLocalEvent({ type: "expandedChanged" });
  }
  isExpandable() {
    return this.expandable;
  }
  isExpanded() {
    return this.expanded;
  }
  getGroupId() {
    return this.groupId;
  }
  getId() {
    return this.getGroupId();
  }
  setChildren(children) {
    this.children = children;
  }
  getChildren() {
    return this.children;
  }
  getColGroupDef() {
    return this.colGroupDef;
  }
  getLeafColumns() {
    const result = [];
    this.addLeafColumns(result);
    return result;
  }
  forEachLeafColumn(callback) {
    if (!this.children) {
      return;
    }
    for (const child of this.children) {
      if (isColumn(child)) {
        callback(child);
      } else if (isProvidedColumnGroup(child)) {
        child.forEachLeafColumn(callback);
      }
    }
  }
  addLeafColumns(leafColumns) {
    if (!this.children) {
      return;
    }
    this.children.forEach((child) => {
      if (isColumn(child)) {
        leafColumns.push(child);
      } else if (isProvidedColumnGroup(child)) {
        child.addLeafColumns(leafColumns);
      }
    });
  }
  getColumnGroupShow() {
    const colGroupDef = this.colGroupDef;
    if (!colGroupDef) {
      return;
    }
    return colGroupDef.columnGroupShow;
  }
  // need to check that this group has at least one col showing when both expanded and contracted.
  // if not, then we don't allow expanding and contracting on this group
  setupExpandable() {
    this.setExpandable();
    if (this.expandableListenerRemoveCallback) {
      this.expandableListenerRemoveCallback();
    }
    const listener = this.onColumnVisibilityChanged.bind(this);
    this.getLeafColumns().forEach((col) => col.__addEventListener("visibleChanged", listener));
    this.expandableListenerRemoveCallback = () => {
      this.getLeafColumns().forEach((col) => col.__removeEventListener("visibleChanged", listener));
      this.expandableListenerRemoveCallback = null;
    };
  }
  setExpandable() {
    if (this.isPadding()) {
      return;
    }
    let atLeastOneShowingWhenOpen = false;
    let atLeastOneShowingWhenClosed = false;
    let atLeastOneChangeable = false;
    const children = this.findChildrenRemovingPadding();
    for (let i = 0, j = children.length; i < j; i++) {
      const abstractColumn = children[i];
      if (!abstractColumn.isVisible()) {
        continue;
      }
      const headerGroupShow = abstractColumn.getColumnGroupShow();
      if (headerGroupShow === "open") {
        atLeastOneShowingWhenOpen = true;
        atLeastOneChangeable = true;
      } else if (headerGroupShow === "closed") {
        atLeastOneShowingWhenClosed = true;
        atLeastOneChangeable = true;
      } else {
        atLeastOneShowingWhenOpen = true;
        atLeastOneShowingWhenClosed = true;
      }
    }
    const expandable = atLeastOneShowingWhenOpen && atLeastOneShowingWhenClosed && atLeastOneChangeable;
    if (this.expandable !== expandable) {
      this.expandable = expandable;
      this.dispatchLocalEvent({ type: "expandableChanged" });
    }
  }
  findChildrenRemovingPadding() {
    const res = [];
    const process = (items) => {
      items.forEach((item) => {
        const skipBecausePadding = isProvidedColumnGroup(item) && item.isPadding();
        if (skipBecausePadding) {
          process(item.children);
        } else {
          res.push(item);
        }
      });
    };
    process(this.children);
    return res;
  }
  onColumnVisibilityChanged() {
    this.setExpandable();
  }
};

// packages/ag-grid-community/src/entities/defaultColumnTypes.ts
var DefaultColumnTypes = {
  numericColumn: {
    headerClass: "ag-right-aligned-header",
    cellClass: "ag-right-aligned-cell"
  },
  rightAligned: {
    headerClass: "ag-right-aligned-header",
    cellClass: "ag-right-aligned-cell"
  }
};

// packages/ag-grid-community/src/columns/columnGroups/columnGroupUtils.ts
function createMergedColGroupDef(beans, colGroupDef, groupId) {
  const colGroupDefMerged = {};
  const gos = beans.gos;
  Object.assign(colGroupDefMerged, gos.get("defaultColGroupDef"));
  Object.assign(colGroupDefMerged, colGroupDef);
  gos.validateColDef(colGroupDefMerged, groupId);
  return colGroupDefMerged;
}

// packages/ag-grid-community/src/columns/columnKeyCreator.ts
var ColumnKeyCreator = class {
  constructor() {
    this.existingKeys = {};
  }
  addExistingKeys(keys) {
    for (let i = 0; i < keys.length; i++) {
      this.existingKeys[keys[i]] = true;
    }
  }
  getUniqueKey(colId, colField) {
    colId = _toStringOrNull(colId);
    let count = 0;
    while (true) {
      let idToTry = colId ?? colField;
      if (idToTry) {
        if (count !== 0) {
          idToTry += "_" + count;
        }
      } else {
        idToTry = count;
      }
      if (!this.existingKeys[idToTry]) {
        const usedId = String(idToTry);
        if (colId && count > 0) {
          _warn(273, { providedId: colId, usedId });
        }
        this.existingKeys[usedId] = true;
        return usedId;
      }
      count++;
    }
  }
};

// packages/ag-grid-community/src/utils/array.ts
var _EmptyArray = Object.freeze([]);
function _last(arr) {
  if (!arr?.length) {
    return;
  }
  return arr[arr.length - 1];
}
function _areEqual(a, b, comparator) {
  if (a == null && b == null) {
    return true;
  }
  return a != null && b != null && a.length === b.length && a.every((value, index) => comparator ? comparator(value, b[index]) : b[index] === value);
}
function _forAll(array, callback) {
  if (!array) {
    return;
  }
  for (const value of array) {
    callback(value);
  }
}
function _removeFromArray(array, object) {
  const index = array.indexOf(object);
  if (index >= 0) {
    array.splice(index, 1);
  }
}
function _moveInArray(array, objectsToMove, toIndex) {
  for (let i = 0; i < objectsToMove.length; i++) {
    _removeFromArray(array, objectsToMove[i]);
  }
  for (let i = objectsToMove.length - 1; i >= 0; i--) {
    array.splice(toIndex, 0, objectsToMove[i]);
  }
}
function _flatten(arrays) {
  return [].concat.apply([], arrays);
}

// packages/ag-grid-community/src/columns/columnUtils.ts
var GROUP_AUTO_COLUMN_ID = "ag-Grid-AutoColumn";
var SELECTION_COLUMN_ID = "ag-Grid-SelectionColumn";
var ROW_NUMBERS_COLUMN_ID = "ag-Grid-RowNumbersColumn";
function _getColumnsFromTree(rootColumns) {
  const result = [];
  const recursiveFindColumns = (childColumns) => {
    for (let i = 0; i < childColumns.length; i++) {
      const child = childColumns[i];
      if (isColumn(child)) {
        result.push(child);
      } else if (isProvidedColumnGroup(child)) {
        recursiveFindColumns(child.getChildren());
      }
    }
  };
  recursiveFindColumns(rootColumns);
  return result;
}
function getWidthOfColsInList(columnList) {
  return columnList.reduce((width, col) => width + col.getActualWidth(), 0);
}
function _destroyColumnTree(beans, oldTree, newTree) {
  const oldObjectsById = {};
  if (!oldTree) {
    return;
  }
  depthFirstOriginalTreeSearch(null, oldTree, (child) => {
    oldObjectsById[child.getInstanceId()] = child;
  });
  if (newTree) {
    depthFirstOriginalTreeSearch(null, newTree, (child) => {
      oldObjectsById[child.getInstanceId()] = null;
    });
  }
  const colsToDestroy = Object.values(oldObjectsById).filter((item) => item != null);
  beans.context.destroyBeans(colsToDestroy);
}
function isColumnGroupAutoCol(col) {
  const colId = col.getId();
  return colId.startsWith(GROUP_AUTO_COLUMN_ID);
}
function isColumnSelectionCol(col) {
  const id = typeof col === "string" ? col : "getColId" in col ? col.getColId() : col.colId;
  return id?.startsWith(SELECTION_COLUMN_ID) ?? false;
}
function isRowNumberCol(col) {
  const id = typeof col === "string" ? col : "getColId" in col ? col.getColId() : col.colId;
  return id?.startsWith(ROW_NUMBERS_COLUMN_ID) ?? false;
}
function isSpecialCol(col) {
  return isColumnSelectionCol(col) || isRowNumberCol(col);
}
function convertColumnTypes(type) {
  let typeKeys = [];
  if (type instanceof Array) {
    typeKeys = type;
  } else if (typeof type === "string") {
    typeKeys = type.split(",");
  }
  return typeKeys;
}
function _areColIdsEqual(colsA, colsB) {
  return _areEqual(colsA, colsB, (a, b) => a.getColId() === b.getColId());
}
function _updateColsMap(cols) {
  cols.map = {};
  cols.list.forEach((col) => cols.map[col.getId()] = col);
}
function _convertColumnEventSourceType(source) {
  return source === "gridOptionsUpdated" ? "gridOptionsChanged" : source;
}
function _columnsMatch(column, key) {
  const columnMatches = column === key;
  const colDefMatches = column.getColDef() === key;
  const idMatches = column.getColId() == key;
  return columnMatches || colDefMatches || idMatches;
}
var getValueFactory = (stateItem, defaultState) => (key1, key2) => {
  const obj = {
    value1: void 0,
    value2: void 0
  };
  let calculated = false;
  if (stateItem) {
    if (stateItem[key1] !== void 0) {
      obj.value1 = stateItem[key1];
      calculated = true;
    }
    if (_exists(key2) && stateItem[key2] !== void 0) {
      obj.value2 = stateItem[key2];
      calculated = true;
    }
  }
  if (!calculated && defaultState) {
    if (defaultState[key1] !== void 0) {
      obj.value1 = defaultState[key1];
    }
    if (_exists(key2) && defaultState[key2] !== void 0) {
      obj.value2 = defaultState[key2];
    }
  }
  return obj;
};

// packages/ag-grid-community/src/columns/columnFactoryUtils.ts
function _createColumnTreeWithIds(beans, defs = null, primaryColumns, existingTree, source) {
  const { existingCols, existingGroups } = extractExistingTreeData(existingTree);
  const colIdMap = new Map(existingCols.map((col) => [col.getId(), col]));
  const colGroupIdMap = new Map(existingGroups.map((group) => [group.getId(), group]));
  let maxDepth = 0;
  const recursivelyProcessColDef = (def, level) => {
    maxDepth = Math.max(maxDepth, level);
    if (isColumnGroupDef(def)) {
      if (!beans.colGroupSvc) {
        return null;
      }
      const groupId = def.groupId;
      const group = colGroupIdMap.get(groupId);
      const colGroupDef = createMergedColGroupDef(beans, def, groupId);
      const newGroup = new AgProvidedColumnGroup(colGroupDef, groupId, false, level);
      beans.context.createBean(newGroup);
      if (group) {
        newGroup.setExpanded(group.isExpanded());
      }
      newGroup.setChildren(def.children.map((child) => recursivelyProcessColDef(child, level + 1)));
      return newGroup;
    }
    const colId = def.colId;
    let column = colIdMap.get(colId);
    const colDefMerged = _addColumnDefaultAndTypes(beans, def, column?.getColId() ?? colId);
    if (!column) {
      column = new AgColumn(colDefMerged, def, colId, primaryColumns);
      beans.context.createBean(column);
    } else {
      column.setColDef(colDefMerged, def, source);
      _updateColumnState(beans, column, colDefMerged, source);
    }
    beans.dataTypeSvc?.addColumnListeners(column);
    return column;
  };
  const root = defs?.map((def) => recursivelyProcessColDef(def, 0)) ?? [];
  let counter = 0;
  const keyCreator = {
    getUniqueKey: (_colId, _field) => String(++counter)
  };
  const columnTree = beans.colGroupSvc ? beans.colGroupSvc.balanceColumnTree(root, 0, maxDepth, keyCreator) : root;
  const depthFirstCallback = (child, parent) => {
    if (isProvidedColumnGroup(child)) {
      child.setupExpandable();
    }
    child.originalParent = parent;
  };
  depthFirstOriginalTreeSearch(null, columnTree, depthFirstCallback);
  return {
    columnTree,
    treeDepth: maxDepth
  };
}
function _createColumnTree(beans, defs = null, primaryColumns, existingTree, source) {
  const columnKeyCreator = new ColumnKeyCreator();
  const { existingCols, existingGroups, existingColKeys } = extractExistingTreeData(existingTree);
  columnKeyCreator.addExistingKeys(existingColKeys);
  const unbalancedTree = _recursivelyCreateColumns(
    beans,
    defs,
    0,
    primaryColumns,
    existingCols,
    columnKeyCreator,
    existingGroups,
    source
  );
  const { colGroupSvc } = beans;
  const treeDepth = colGroupSvc?.findMaxDepth(unbalancedTree, 0) ?? 0;
  const columnTree = colGroupSvc ? colGroupSvc.balanceColumnTree(unbalancedTree, 0, treeDepth, columnKeyCreator) : unbalancedTree;
  const depthFirstCallback = (child, parent) => {
    if (isProvidedColumnGroup(child)) {
      child.setupExpandable();
    }
    child.originalParent = parent;
  };
  depthFirstOriginalTreeSearch(null, columnTree, depthFirstCallback);
  return {
    columnTree,
    treeDepth
  };
}
function extractExistingTreeData(existingTree) {
  const existingCols = [];
  const existingGroups = [];
  const existingColKeys = [];
  if (existingTree) {
    depthFirstOriginalTreeSearch(null, existingTree, (item) => {
      if (isProvidedColumnGroup(item)) {
        const group = item;
        existingGroups.push(group);
      } else {
        const col = item;
        existingColKeys.push(col.getId());
        existingCols.push(col);
      }
    });
  }
  return { existingCols, existingGroups, existingColKeys };
}
function _recursivelyCreateColumns(beans, defs, level, primaryColumns, existingColsCopy, columnKeyCreator, existingGroups, source) {
  if (!defs)
    return [];
  const { colGroupSvc } = beans;
  const result = new Array(defs.length);
  for (let i = 0; i < result.length; i++) {
    const def = defs[i];
    if (colGroupSvc && isColumnGroupDef(def)) {
      result[i] = colGroupSvc.createProvidedColumnGroup(
        primaryColumns,
        def,
        level,
        existingColsCopy,
        columnKeyCreator,
        existingGroups,
        source
      );
    } else {
      result[i] = createColumn(beans, primaryColumns, def, existingColsCopy, columnKeyCreator, source);
    }
  }
  return result;
}
function createColumn(beans, primaryColumns, colDef, existingColsCopy, columnKeyCreator, source) {
  const existingColAndIndex = findExistingColumn(colDef, existingColsCopy);
  if (existingColAndIndex) {
    existingColsCopy?.splice(existingColAndIndex.idx, 1);
  }
  let column = existingColAndIndex?.column;
  if (!column) {
    const colId = columnKeyCreator.getUniqueKey(colDef.colId, colDef.field);
    const colDefMerged = _addColumnDefaultAndTypes(beans, colDef, colId);
    column = new AgColumn(colDefMerged, colDef, colId, primaryColumns);
    beans.context.createBean(column);
  } else {
    const colDefMerged = _addColumnDefaultAndTypes(beans, colDef, column.getColId());
    column.setColDef(colDefMerged, colDef, source);
    _updateColumnState(beans, column, colDefMerged, source);
  }
  beans.dataTypeSvc?.addColumnListeners(column);
  return column;
}
function updateSomeColumnState(beans, column, hide, sort, sortIndex, pinned, flex, source) {
  const { sortSvc, pinnedCols, colFlex } = beans;
  if (hide !== void 0) {
    column.setVisible(!hide, source);
  }
  if (sortSvc) {
    sortSvc.updateColSort(column, sort, source);
    if (sortIndex !== void 0) {
      sortSvc.setColSortIndex(column, sortIndex);
    }
  }
  if (pinned !== void 0) {
    pinnedCols?.setColPinned(column, pinned);
  }
  if (flex !== void 0) {
    colFlex?.setColFlex(column, flex);
  }
}
function _updateColumnState(beans, column, colDef, source) {
  updateSomeColumnState(
    beans,
    column,
    colDef.hide,
    colDef.sort,
    colDef.sortIndex,
    colDef.pinned,
    colDef.flex,
    source
  );
  const colFlex = column.getFlex();
  if (colFlex != null && colFlex > 0) {
    return;
  }
  if (colDef.width != null) {
    column.setActualWidth(colDef.width, source);
  } else {
    const widthBeforeUpdate = column.getActualWidth();
    column.setActualWidth(widthBeforeUpdate, source);
  }
}
function findExistingColumn(newColDef, existingColsCopy) {
  if (!existingColsCopy)
    return void 0;
  for (let i = 0; i < existingColsCopy.length; i++) {
    const def = existingColsCopy[i].getUserProvidedColDef();
    if (!def)
      continue;
    const newHasId = newColDef.colId != null;
    if (newHasId) {
      if (existingColsCopy[i].getId() === newColDef.colId) {
        return { idx: i, column: existingColsCopy[i] };
      }
      continue;
    }
    const newHasField = newColDef.field != null;
    if (newHasField) {
      if (def.field === newColDef.field) {
        return { idx: i, column: existingColsCopy[i] };
      }
      continue;
    }
    if (def === newColDef) {
      return { idx: i, column: existingColsCopy[i] };
    }
  }
  return void 0;
}
function _addColumnDefaultAndTypes(beans, colDef, colId, isAutoCol) {
  const { gos, dataTypeSvc } = beans;
  const res = {};
  const defaultColDef = gos.get("defaultColDef");
  _mergeDeep(res, defaultColDef, false, true);
  const columnType = updateColDefAndGetColumnType(beans, res, colDef, colId);
  if (columnType) {
    assignColumnTypes(beans, columnType, res);
  }
  const cellDataType = res.cellDataType;
  _mergeDeep(res, colDef, false, true);
  if (cellDataType !== void 0) {
    res.cellDataType = cellDataType;
  }
  const autoGroupColDef = gos.get("autoGroupColumnDef");
  const isSortingCoupled = _isColumnsSortingCoupledToGroup(gos);
  if (colDef.rowGroup && autoGroupColDef && isSortingCoupled) {
    _mergeDeep(
      res,
      { sort: autoGroupColDef.sort, initialSort: autoGroupColDef.initialSort },
      false,
      true
    );
  }
  if (dataTypeSvc) {
    dataTypeSvc.postProcess(res);
    dataTypeSvc.validateColDef(res);
  }
  gos.validateColDef(res, colId, isAutoCol);
  return res;
}
function updateColDefAndGetColumnType(beans, colDef, userColDef, colId) {
  const dataTypeDefinitionColumnType = beans.dataTypeSvc?.updateColDefAndGetColumnType(colDef, userColDef, colId);
  const columnTypes = userColDef.type ?? dataTypeDefinitionColumnType ?? colDef.type;
  colDef.type = columnTypes;
  return columnTypes ? convertColumnTypes(columnTypes) : void 0;
}
function assignColumnTypes(beans, typeKeys, colDefMerged) {
  if (!typeKeys.length) {
    return;
  }
  const allColumnTypes = Object.assign({}, DefaultColumnTypes);
  const userTypes = beans.gos.get("columnTypes") || {};
  for (const key of Object.keys(userTypes)) {
    const value = userTypes[key];
    if (key in allColumnTypes) {
      _warn(34, { key });
    } else {
      const colType = value;
      if (colType.type) {
        _warn(35);
      }
      allColumnTypes[key] = value;
    }
  }
  typeKeys.forEach((t) => {
    const typeColDef = allColumnTypes[t.trim()];
    if (typeColDef) {
      _mergeDeep(colDefMerged, typeColDef, false, true);
    } else {
      _warn(36, { t });
    }
  });
}
function isColumnGroupDef(abstractColDef) {
  return abstractColDef.children !== void 0;
}
function depthFirstOriginalTreeSearch(parent, tree, callback) {
  if (!tree) {
    return;
  }
  for (let i = 0; i < tree.length; i++) {
    const child = tree[i];
    if (isProvidedColumnGroup(child)) {
      depthFirstOriginalTreeSearch(child, child.getChildren(), callback);
    }
    callback(child, parent);
  }
}

// packages/ag-grid-community/src/columnMove/columnMoveUtils.ts
function placeLockedColumns(cols, gos) {
  const left = [];
  const normal = [];
  const right = [];
  cols.forEach((col) => {
    const position = col.getColDef().lockPosition;
    if (position === "right") {
      right.push(col);
    } else if (position === "left" || position === true) {
      left.push(col);
    } else {
      normal.push(col);
    }
  });
  const isRtl = gos.get("enableRtl");
  if (isRtl) {
    return [...right, ...normal, ...left];
  }
  return [...left, ...normal, ...right];
}
function doesMovePassMarryChildren(allColumnsCopy, gridBalancedTree) {
  let rulePassed = true;
  depthFirstOriginalTreeSearch(null, gridBalancedTree, (child) => {
    if (!isProvidedColumnGroup(child)) {
      return;
    }
    const columnGroup = child;
    const colGroupDef = columnGroup.getColGroupDef();
    const marryChildren = colGroupDef && colGroupDef.marryChildren;
    if (!marryChildren) {
      return;
    }
    const newIndexes = [];
    columnGroup.getLeafColumns().forEach((col) => {
      const newColIndex = allColumnsCopy.indexOf(col);
      newIndexes.push(newColIndex);
    });
    const maxIndex = Math.max.apply(Math, newIndexes);
    const minIndex = Math.min.apply(Math, newIndexes);
    const spread = maxIndex - minIndex;
    const maxSpread = columnGroup.getLeafColumns().length - 1;
    if (spread > maxSpread) {
      rulePassed = false;
    }
  });
  return rulePassed;
}

// packages/ag-grid-community/src/columns/columnEventUtils.ts
function getCommonValue(cols, valueGetter) {
  if (!cols || cols.length == 0) {
    return void 0;
  }
  const firstValue = valueGetter(cols[0]);
  for (let i = 1; i < cols.length; i++) {
    if (firstValue !== valueGetter(cols[i])) {
      return void 0;
    }
  }
  return firstValue;
}
function dispatchColumnPinnedEvent(eventSvc, changedColumns, source) {
  if (!changedColumns.length) {
    return;
  }
  const column = changedColumns.length === 1 ? changedColumns[0] : null;
  const pinned = getCommonValue(changedColumns, (col) => col.getPinned());
  eventSvc.dispatchEvent({
    type: "columnPinned",
    // mistake in typing, 'undefined' should be allowed, as 'null' means 'not pinned'
    pinned: pinned != null ? pinned : null,
    columns: changedColumns,
    column,
    source
  });
}
function dispatchColumnVisibleEvent(eventSvc, changedColumns, source) {
  if (!changedColumns.length) {
    return;
  }
  const column = changedColumns.length === 1 ? changedColumns[0] : null;
  const visible = getCommonValue(changedColumns, (col) => col.isVisible());
  eventSvc.dispatchEvent({
    type: "columnVisible",
    visible,
    columns: changedColumns,
    column,
    source
  });
}
function dispatchColumnChangedEvent(eventSvc, type, columns, source) {
  eventSvc.dispatchEvent({
    type,
    columns,
    column: columns && columns.length == 1 ? columns[0] : null,
    source
  });
}
function dispatchColumnResizedEvent(eventSvc, columns, finished, source, flexColumns = null) {
  if (columns?.length) {
    eventSvc.dispatchEvent({
      type: "columnResized",
      columns,
      column: columns.length === 1 ? columns[0] : null,
      flexColumns,
      finished,
      source
    });
  }
}

// packages/ag-grid-community/src/columns/columnStateUtils.ts
function _applyColumnState(beans, params, source) {
  const {
    colModel,
    rowGroupColsSvc,
    pivotColsSvc,
    autoColSvc,
    selectionColSvc,
    colAnimation,
    visibleCols,
    pivotResultCols,
    environment,
    valueColsSvc,
    eventSvc,
    gos
  } = beans;
  const providedCols = colModel.getColDefCols() ?? [];
  const selectionCols = selectionColSvc?.getColumns();
  if (!providedCols?.length && !selectionCols?.length) {
    return false;
  }
  if (params?.state && !params.state.forEach) {
    _warn(32);
    return false;
  }
  const syncColumnWithStateItem = (column, stateItem, rowGroupIndexes, pivotIndexes, autoCol) => {
    if (!column) {
      return;
    }
    const getValue = getValueFactory(stateItem, params.defaultState);
    const flex = getValue("flex").value1;
    updateSomeColumnState(
      beans,
      column,
      getValue("hide").value1,
      getValue("sort").value1,
      getValue("sortIndex").value1,
      getValue("pinned").value1,
      flex,
      source
    );
    if (flex == null) {
      const width = getValue("width").value1;
      if (width != null) {
        const minColWidth = column.getColDef().minWidth ?? environment.getDefaultColumnMinWidth();
        if (minColWidth != null && width >= minColWidth) {
          column.setActualWidth(width, source);
        }
      }
    }
    if (autoCol || !column.isPrimary()) {
      return;
    }
    valueColsSvc?.syncColumnWithState(column, source, getValue);
    rowGroupColsSvc?.syncColumnWithState(column, source, getValue, rowGroupIndexes);
    pivotColsSvc?.syncColumnWithState(column, source, getValue, pivotIndexes);
  };
  const applyStates = (states, existingColumns, getById2) => {
    const dispatchEventsFunc = _compareColumnStatesAndDispatchEvents(beans, source);
    const columnsWithNoState = existingColumns.slice();
    const rowGroupIndexes = {};
    const pivotIndexes = {};
    const autoColStates = [];
    const selectionColStates = [];
    const unmatchedAndAutoStates2 = [];
    let unmatchedCount2 = 0;
    const previousRowGroupCols = rowGroupColsSvc?.columns.slice() ?? [];
    const previousPivotCols = pivotColsSvc?.columns.slice() ?? [];
    states.forEach((state) => {
      const colId = state.colId;
      const isAutoGroupColumn = colId.startsWith(GROUP_AUTO_COLUMN_ID);
      if (isAutoGroupColumn) {
        autoColStates.push(state);
        unmatchedAndAutoStates2.push(state);
        return;
      }
      if (isColumnSelectionCol(colId)) {
        selectionColStates.push(state);
        unmatchedAndAutoStates2.push(state);
        return;
      }
      const column = getById2(colId);
      if (!column) {
        unmatchedAndAutoStates2.push(state);
        unmatchedCount2 += 1;
      } else {
        syncColumnWithStateItem(column, state, rowGroupIndexes, pivotIndexes, false);
        _removeFromArray(columnsWithNoState, column);
      }
    });
    const applyDefaultsFunc = (col) => syncColumnWithStateItem(col, null, rowGroupIndexes, pivotIndexes, false);
    columnsWithNoState.forEach(applyDefaultsFunc);
    rowGroupColsSvc?.sortColumns(comparatorByIndex.bind(rowGroupColsSvc, rowGroupIndexes, previousRowGroupCols));
    pivotColsSvc?.sortColumns(comparatorByIndex.bind(pivotColsSvc, pivotIndexes, previousPivotCols));
    colModel.refreshCols(false);
    const syncColStates = (getCol, colStates, columns = []) => {
      colStates.forEach((stateItem) => {
        const col = getCol(stateItem.colId);
        _removeFromArray(columns, col);
        syncColumnWithStateItem(col, stateItem, null, null, true);
      });
      columns.forEach(applyDefaultsFunc);
    };
    syncColStates(
      (colId) => autoColSvc?.getColumn(colId) ?? null,
      autoColStates,
      autoColSvc?.getColumns()?.slice()
    );
    syncColStates(
      (colId) => selectionColSvc?.getColumn(colId) ?? null,
      selectionColStates,
      selectionColSvc?.getColumns()?.slice()
    );
    orderLiveColsLikeState(params, colModel, gos);
    visibleCols.refresh(source);
    eventSvc.dispatchEvent({
      type: "columnEverythingChanged",
      source
    });
    dispatchEventsFunc();
    return { unmatchedAndAutoStates: unmatchedAndAutoStates2, unmatchedCount: unmatchedCount2 };
  };
  colAnimation?.start();
  let { unmatchedAndAutoStates, unmatchedCount } = applyStates(
    params.state || [],
    providedCols,
    (id) => colModel.getColDefCol(id)
  );
  if (unmatchedAndAutoStates.length > 0 || _exists(params.defaultState)) {
    const pivotResultColsList = pivotResultCols?.getPivotResultCols()?.list ?? [];
    unmatchedCount = applyStates(
      unmatchedAndAutoStates,
      pivotResultColsList,
      (id) => pivotResultCols?.getPivotResultCol(id) ?? null
    ).unmatchedCount;
  }
  colAnimation?.finish();
  return unmatchedCount === 0;
}
function _resetColumnState(beans, source) {
  const { colModel, autoColSvc, selectionColSvc, eventSvc, gos } = beans;
  const primaryCols = colModel.getColDefCols();
  if (!primaryCols?.length) {
    return;
  }
  const primaryColumnTree = colModel.getColDefColTree();
  const primaryColumns = _getColumnsFromTree(primaryColumnTree);
  const columnStates = [];
  let letRowGroupIndex = 1e3;
  let letPivotIndex = 1e3;
  const addColState = (col) => {
    const stateItem = getColumnStateFromColDef(col);
    if (_missing(stateItem.rowGroupIndex) && stateItem.rowGroup) {
      stateItem.rowGroupIndex = letRowGroupIndex++;
    }
    if (_missing(stateItem.pivotIndex) && stateItem.pivot) {
      stateItem.pivotIndex = letPivotIndex++;
    }
    columnStates.push(stateItem);
  };
  autoColSvc?.getColumns()?.forEach(addColState);
  selectionColSvc?.getColumns()?.forEach(addColState);
  primaryColumns?.forEach(addColState);
  _applyColumnState(beans, { state: columnStates }, source);
  const autoCols = autoColSvc?.getColumns() ?? [];
  const selectionCols = selectionColSvc?.getColumns() ?? [];
  const orderedCols = [...selectionCols, ...autoCols, ...primaryCols];
  const orderedColState = orderedCols.map((col) => ({ colId: col.colId }));
  _applyColumnState(beans, { state: orderedColState, applyOrder: true }, source);
  eventSvc.dispatchEvent(_addGridCommonParams(gos, { type: "columnsReset", source }));
}
function _compareColumnStatesAndDispatchEvents(beans, source) {
  const { rowGroupColsSvc, pivotColsSvc, valueColsSvc, colModel, sortSvc, eventSvc } = beans;
  const startState = {
    rowGroupColumns: rowGroupColsSvc?.columns.slice() ?? [],
    pivotColumns: pivotColsSvc?.columns.slice() ?? [],
    valueColumns: valueColsSvc?.columns.slice() ?? []
  };
  const columnStateBefore = _getColumnState(beans);
  const columnStateBeforeMap = {};
  columnStateBefore.forEach((col) => {
    columnStateBeforeMap[col.colId] = col;
  });
  return () => {
    const dispatchWhenListsDifferent = (eventType, colsBefore, colsAfter, idMapper) => {
      const beforeList = colsBefore.map(idMapper);
      const afterList = colsAfter.map(idMapper);
      const unchanged = _areEqual(beforeList, afterList);
      if (unchanged) {
        return;
      }
      const changes = new Set(colsBefore);
      colsAfter.forEach((id) => {
        if (!changes.delete(id)) {
          changes.add(id);
        }
      });
      const changesArr = [...changes];
      eventSvc.dispatchEvent({
        type: eventType,
        columns: changesArr,
        column: changesArr.length === 1 ? changesArr[0] : null,
        source
      });
    };
    const getChangedColumns = (changedPredicate) => {
      const changedColumns2 = [];
      colModel.forAllCols((column) => {
        const colStateBefore = columnStateBeforeMap[column.getColId()];
        if (colStateBefore && changedPredicate(colStateBefore, column)) {
          changedColumns2.push(column);
        }
      });
      return changedColumns2;
    };
    const columnIdMapper = (c) => c.getColId();
    dispatchWhenListsDifferent(
      "columnRowGroupChanged",
      startState.rowGroupColumns,
      rowGroupColsSvc?.columns ?? [],
      columnIdMapper
    );
    dispatchWhenListsDifferent(
      "columnPivotChanged",
      startState.pivotColumns,
      pivotColsSvc?.columns ?? [],
      columnIdMapper
    );
    const valueChangePredicate = (cs, c) => {
      const oldActive = cs.aggFunc != null;
      const activeChanged = oldActive != c.isValueActive();
      const aggFuncChanged = oldActive && cs.aggFunc != c.getAggFunc();
      return activeChanged || aggFuncChanged;
    };
    const changedValues = getChangedColumns(valueChangePredicate);
    if (changedValues.length > 0) {
      dispatchColumnChangedEvent(eventSvc, "columnValueChanged", changedValues, source);
    }
    const resizeChangePredicate = (cs, c) => cs.width != c.getActualWidth();
    dispatchColumnResizedEvent(eventSvc, getChangedColumns(resizeChangePredicate), true, source);
    const pinnedChangePredicate = (cs, c) => cs.pinned != c.getPinned();
    dispatchColumnPinnedEvent(eventSvc, getChangedColumns(pinnedChangePredicate), source);
    const visibilityChangePredicate = (cs, c) => cs.hide == c.isVisible();
    dispatchColumnVisibleEvent(eventSvc, getChangedColumns(visibilityChangePredicate), source);
    const sortChangePredicate = (cs, c) => cs.sort != c.getSort() || cs.sortIndex != c.getSortIndex();
    const changedColumns = getChangedColumns(sortChangePredicate);
    if (changedColumns.length > 0) {
      sortSvc?.dispatchSortChangedEvents(source, changedColumns);
    }
    const colStateAfter = _getColumnState(beans);
    normaliseColumnMovedEventForColumnState(columnStateBefore, colStateAfter, source, colModel, eventSvc);
  };
}
function _getColumnState(beans) {
  const { colModel, rowGroupColsSvc, pivotColsSvc } = beans;
  const primaryCols = colModel.getColDefCols();
  if (_missing(primaryCols) || !colModel.isAlive()) {
    return [];
  }
  const rowGroupColumns = rowGroupColsSvc?.columns;
  const pivotColumns = pivotColsSvc?.columns;
  const res = [];
  const createStateItemFromColumn = (column) => {
    const rowGroupIndex = column.isRowGroupActive() && rowGroupColumns ? rowGroupColumns.indexOf(column) : null;
    const pivotIndex = column.isPivotActive() && pivotColumns ? pivotColumns.indexOf(column) : null;
    const aggFunc = column.isValueActive() ? column.getAggFunc() : null;
    const sort = column.getSort() != null ? column.getSort() : null;
    const sortIndex = column.getSortIndex() != null ? column.getSortIndex() : null;
    res.push({
      colId: column.getColId(),
      width: column.getActualWidth(),
      hide: !column.isVisible(),
      pinned: column.getPinned(),
      sort,
      sortIndex,
      aggFunc,
      rowGroup: column.isRowGroupActive(),
      rowGroupIndex,
      pivot: column.isPivotActive(),
      pivotIndex,
      flex: column.getFlex() ?? null
    });
  };
  colModel.forAllCols((col) => createStateItemFromColumn(col));
  const colIdToGridIndexMap = new Map(
    colModel.getCols().map((col, index) => [col.getColId(), index])
  );
  res.sort((itemA, itemB) => {
    const posA = colIdToGridIndexMap.has(itemA.colId) ? colIdToGridIndexMap.get(itemA.colId) : -1;
    const posB = colIdToGridIndexMap.has(itemB.colId) ? colIdToGridIndexMap.get(itemB.colId) : -1;
    return posA - posB;
  });
  return res;
}
function getColumnStateFromColDef(column) {
  const getValueOrNull = (a, b) => a != null ? a : b != null ? b : null;
  const colDef = column.getColDef();
  const sort = getValueOrNull(colDef.sort, colDef.initialSort);
  const sortIndex = getValueOrNull(colDef.sortIndex, colDef.initialSortIndex);
  const hide = getValueOrNull(colDef.hide, colDef.initialHide);
  const pinned = getValueOrNull(colDef.pinned, colDef.initialPinned);
  const width = getValueOrNull(colDef.width, colDef.initialWidth);
  const flex = getValueOrNull(colDef.flex, colDef.initialFlex);
  let rowGroupIndex = getValueOrNull(colDef.rowGroupIndex, colDef.initialRowGroupIndex);
  let rowGroup = getValueOrNull(colDef.rowGroup, colDef.initialRowGroup);
  if (rowGroupIndex == null && (rowGroup == null || rowGroup == false)) {
    rowGroupIndex = null;
    rowGroup = null;
  }
  let pivotIndex = getValueOrNull(colDef.pivotIndex, colDef.initialPivotIndex);
  let pivot = getValueOrNull(colDef.pivot, colDef.initialPivot);
  if (pivotIndex == null && (pivot == null || pivot == false)) {
    pivotIndex = null;
    pivot = null;
  }
  const aggFunc = getValueOrNull(colDef.aggFunc, colDef.initialAggFunc);
  return {
    colId: column.getColId(),
    sort,
    sortIndex,
    hide,
    pinned,
    width,
    flex,
    rowGroup,
    rowGroupIndex,
    pivot,
    pivotIndex,
    aggFunc
  };
}
function orderLiveColsLikeState(params, colModel, gos) {
  if (!params.applyOrder || !params.state) {
    return;
  }
  const colIds = [];
  params.state.forEach((item) => {
    if (item.colId != null) {
      colIds.push(item.colId);
    }
  });
  sortColsLikeKeys(colModel.cols, colIds, colModel, gos);
}
function sortColsLikeKeys(cols, colIds, colModel, gos) {
  if (cols == null) {
    return;
  }
  let newOrder = [];
  const processedColIds = {};
  colIds.forEach((colId) => {
    if (processedColIds[colId]) {
      return;
    }
    const col = cols.map[colId];
    if (col) {
      newOrder.push(col);
      processedColIds[colId] = true;
    }
  });
  let autoGroupInsertIndex = 0;
  cols.list.forEach((col) => {
    const colId = col.getColId();
    const alreadyProcessed = processedColIds[colId] != null;
    if (alreadyProcessed) {
      return;
    }
    const isAutoGroupCol = colId.startsWith(GROUP_AUTO_COLUMN_ID);
    if (isAutoGroupCol) {
      newOrder.splice(autoGroupInsertIndex++, 0, col);
    } else {
      newOrder.push(col);
    }
  });
  newOrder = placeLockedColumns(newOrder, gos);
  if (!doesMovePassMarryChildren(newOrder, colModel.getColTree())) {
    _warn(39);
    return;
  }
  cols.list = newOrder;
}
function normaliseColumnMovedEventForColumnState(colStateBefore, colStateAfter, source, colModel, eventSvc) {
  const colStateAfterMapped = {};
  colStateAfter.forEach((s) => colStateAfterMapped[s.colId] = s);
  const colsIntersectIds = {};
  colStateBefore.forEach((s) => {
    if (colStateAfterMapped[s.colId]) {
      colsIntersectIds[s.colId] = true;
    }
  });
  const beforeFiltered = colStateBefore.filter((c) => colsIntersectIds[c.colId]);
  const afterFiltered = colStateAfter.filter((c) => colsIntersectIds[c.colId]);
  const movedColumns = [];
  afterFiltered.forEach((csAfter, index) => {
    const csBefore = beforeFiltered && beforeFiltered[index];
    if (csBefore && csBefore.colId !== csAfter.colId) {
      const gridCol = colModel.getCol(csBefore.colId);
      if (gridCol) {
        movedColumns.push(gridCol);
      }
    }
  });
  if (!movedColumns.length) {
    return;
  }
  eventSvc.dispatchEvent({
    type: "columnMoved",
    columns: movedColumns,
    column: movedColumns.length === 1 ? movedColumns[0] : null,
    finished: true,
    source
  });
}
var comparatorByIndex = (indexes, oldList, colA, colB) => {
  const indexA = indexes[colA.getId()];
  const indexB = indexes[colB.getId()];
  const aHasIndex = indexA != null;
  const bHasIndex = indexB != null;
  if (aHasIndex && bHasIndex) {
    return indexA - indexB;
  }
  if (aHasIndex) {
    return -1;
  }
  if (bHasIndex) {
    return 1;
  }
  const oldIndexA = oldList.indexOf(colA);
  const oldIndexB = oldList.indexOf(colB);
  const aHasOldIndex = oldIndexA >= 0;
  const bHasOldIndex = oldIndexB >= 0;
  if (aHasOldIndex && bHasOldIndex) {
    return oldIndexA - oldIndexB;
  }
  if (aHasOldIndex) {
    return -1;
  }
  return 1;
};

// packages/ag-grid-community/src/columns/columnModel.ts
var ColumnModel = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colModel";
    // if pivotMode is on, however pivot results are NOT shown if no pivot columns are set
    this.pivotMode = false;
    this.ready = false;
    this.changeEventsDispatching = false;
  }
  postConstruct() {
    this.pivotMode = this.gos.get("pivotMode");
    this.addManagedPropertyListeners(
      [
        "groupDisplayType",
        "treeData",
        "treeDataDisplayType",
        "groupHideOpenParents",
        "rowNumbers",
        "hidePaddedHeaderRows"
      ],
      (event) => this.refreshAll(_convertColumnEventSourceType(event.source))
    );
    this.addManagedPropertyListeners(
      ["defaultColDef", "defaultColGroupDef", "columnTypes", "suppressFieldDotNotation"],
      this.recreateColumnDefs.bind(this)
    );
    this.addManagedPropertyListener(
      "pivotMode",
      (event) => this.setPivotMode(this.gos.get("pivotMode"), _convertColumnEventSourceType(event.source))
    );
  }
  // called from SyncService, when grid has finished initialising
  createColsFromColDefs(source) {
    const { beans } = this;
    const { valueCache, colAutosize, rowGroupColsSvc, pivotColsSvc, valueColsSvc, visibleCols, eventSvc } = beans;
    const dispatchEventsFunc = this.colDefs ? _compareColumnStatesAndDispatchEvents(beans, source) : void 0;
    valueCache?.expire();
    const oldCols = this.colDefCols?.list;
    const oldTree = this.colDefCols?.tree;
    const newTree = _createColumnTree(beans, this.colDefs, true, oldTree, source);
    _destroyColumnTree(beans, this.colDefCols?.tree, newTree.columnTree);
    const tree = newTree.columnTree;
    const treeDepth = newTree.treeDepth;
    const list = _getColumnsFromTree(tree);
    const map = {};
    list.forEach((col) => map[col.getId()] = col);
    this.colDefCols = { tree, treeDepth, list, map };
    rowGroupColsSvc?.extractCols(source, oldCols);
    pivotColsSvc?.extractCols(source, oldCols);
    valueColsSvc?.extractCols(source, oldCols);
    this.ready = true;
    this.refreshCols(true);
    visibleCols.refresh(source);
    eventSvc.dispatchEvent({
      type: "columnEverythingChanged",
      source
    });
    if (dispatchEventsFunc) {
      this.changeEventsDispatching = true;
      dispatchEventsFunc();
      this.changeEventsDispatching = false;
    }
    eventSvc.dispatchEvent({
      type: "newColumnsLoaded",
      source
    });
    if (source === "gridInitializing") {
      colAutosize?.applyAutosizeStrategy();
    }
  }
  // called from: buildAutoGroupColumns (events 'groupDisplayType', 'treeData', 'treeDataDisplayType', 'groupHideOpenParents')
  // createColsFromColDefs (recreateColumnDefs, setColumnsDefs),
  // setPivotMode, applyColumnState,
  // functionColsService.setPrimaryColList, functionColsService.updatePrimaryColList,
  // pivotResultCols.setPivotResultCols
  refreshCols(newColDefs) {
    if (!this.colDefCols) {
      return;
    }
    const prevColTree = this.cols?.tree;
    this.saveColOrder();
    const {
      autoColSvc,
      selectionColSvc,
      rowNumbersSvc,
      quickFilter,
      pivotResultCols,
      showRowGroupCols,
      rowAutoHeight,
      visibleCols,
      colViewport,
      eventSvc
    } = this.beans;
    const cols = this.selectCols(pivotResultCols, this.colDefCols);
    this.createColumnsForService([autoColSvc, selectionColSvc, rowNumbersSvc], cols);
    const shouldSortNewColDefs = _shouldMaintainColumnOrder(this.gos, this.showingPivotResult);
    if (!newColDefs || shouldSortNewColDefs) {
      this.restoreColOrder(cols);
    }
    this.positionLockedCols(cols);
    showRowGroupCols?.refresh();
    quickFilter?.refreshCols();
    this.setColSpanActive();
    rowAutoHeight?.setAutoHeightActive(cols);
    visibleCols.clear();
    colViewport.clear();
    const dispatchChangedEvent = !_areEqual(prevColTree, this.cols.tree);
    if (dispatchChangedEvent) {
      eventSvc.dispatchEvent({
        type: "gridColumnsChanged"
      });
    }
  }
  createColumnsForService(services, cols) {
    for (const service of services) {
      if (!service) {
        continue;
      }
      service.createColumns(cols, (updateOrder) => {
        this.lastOrder = updateOrder(this.lastOrder);
        this.lastPivotOrder = updateOrder(this.lastPivotOrder);
      });
      service.addColumns(cols);
    }
  }
  selectCols(pivotResultColsSvc, colDefCols) {
    const pivotResultCols = pivotResultColsSvc?.getPivotResultCols() ?? null;
    this.showingPivotResult = pivotResultCols != null;
    const { map, list, tree, treeDepth } = pivotResultCols ?? colDefCols;
    this.cols = {
      list: list.slice(),
      map: { ...map },
      tree: tree.slice(),
      treeDepth
    };
    if (pivotResultCols) {
      const hasSameColumns = pivotResultCols.list.some((col) => this.cols?.map[col.getColId()] !== void 0);
      if (!hasSameColumns) {
        this.lastPivotOrder = null;
      }
    }
    return this.cols;
  }
  getColsToShow() {
    if (!this.cols) {
      return [];
    }
    const { valueColsSvc, selectionColSvc, gos } = this.beans;
    const showAutoGroupAndValuesOnly = this.isPivotMode() && !this.showingPivotResult;
    const showSelectionColumn = selectionColSvc?.isSelectionColumnEnabled();
    const showRowNumbers = gos.get("rowNumbers");
    const valueColumns = valueColsSvc?.columns;
    const res = this.cols.list.filter((col) => {
      const isAutoGroupCol = isColumnGroupAutoCol(col);
      if (showAutoGroupAndValuesOnly) {
        const isValueCol = valueColumns?.includes(col);
        return isAutoGroupCol || isValueCol || showSelectionColumn && isColumnSelectionCol(col) || showRowNumbers && isRowNumberCol(col);
      } else {
        return isAutoGroupCol || col.isVisible();
      }
    });
    return res;
  }
  // on events 'groupDisplayType', 'treeData', 'treeDataDisplayType', 'groupHideOpenParents'
  refreshAll(source) {
    if (!this.ready) {
      return;
    }
    this.refreshCols(false);
    this.beans.visibleCols.refresh(source);
  }
  setColsVisible(keys, visible = false, source) {
    _applyColumnState(
      this.beans,
      {
        state: keys.map((key) => ({
          colId: typeof key === "string" ? key : key.getColId(),
          hide: !visible
        }))
      },
      source
    );
  }
  /**
   * Restores provided columns order to the previous order in this.lastPivotOrder / this.lastOrder
   * If columns are not in the last order:
   *  - Check column groups, and apply column after the last column in the lowest shared group
   *  - If no sibling is found, apply the column at the end of the cols
   */
  restoreColOrder(cols) {
    const lastOrder = this.showingPivotResult ? this.lastPivotOrder : this.lastOrder;
    if (!lastOrder) {
      return;
    }
    const preservedOrder = lastOrder.filter((col) => cols.map[col.getId()] != null);
    if (preservedOrder.length === 0) {
      return;
    }
    if (preservedOrder.length === cols.list.length) {
      cols.list = preservedOrder;
      return;
    }
    const hasSiblings = (col) => {
      const ancestor = col.getOriginalParent();
      if (!ancestor) {
        return false;
      }
      const children = ancestor.getChildren();
      if (children.length > 1) {
        return true;
      }
      return hasSiblings(ancestor);
    };
    if (!preservedOrder.some((col) => hasSiblings(col))) {
      const preservedOrderSet = new Set(preservedOrder);
      for (const col of cols.list) {
        if (!preservedOrderSet.has(col)) {
          preservedOrder.push(col);
        }
      }
      cols.list = preservedOrder;
      return;
    }
    const colPositionMap = /* @__PURE__ */ new Map();
    for (let i = 0; i < preservedOrder.length; i++) {
      const col = preservedOrder[i];
      colPositionMap.set(col, i);
    }
    const additionalCols = cols.list.filter((col) => !colPositionMap.has(col));
    if (additionalCols.length === 0) {
      cols.list = preservedOrder;
      return;
    }
    const getPreviousSibling = (col, group) => {
      const parent = group ? group.getOriginalParent() : col.getOriginalParent();
      if (!parent) {
        return null;
      }
      let highestIdx = null;
      let highestSibling = null;
      for (const child of parent.getChildren()) {
        if (child === group || child === col) {
          continue;
        }
        if (child instanceof AgColumn) {
          const colIdx = colPositionMap.get(child);
          if (colIdx == null) {
            continue;
          }
          if (highestIdx == null || highestIdx < colIdx) {
            highestIdx = colIdx;
            highestSibling = child;
          }
          continue;
        }
        child.forEachLeafColumn((leafCol) => {
          const colIdx = colPositionMap.get(leafCol);
          if (colIdx == null) {
            return;
          }
          if (highestIdx == null || highestIdx < colIdx) {
            highestIdx = colIdx;
            highestSibling = leafCol;
          }
        });
      }
      if (highestSibling == null) {
        return getPreviousSibling(col, parent);
      }
      return highestSibling;
    };
    const noSiblingsAvailable = [];
    const previousSiblingPosMap = /* @__PURE__ */ new Map();
    for (const col of additionalCols) {
      const prevSiblingIdx = getPreviousSibling(col, null);
      if (prevSiblingIdx == null) {
        noSiblingsAvailable.push(col);
        continue;
      }
      const prev = previousSiblingPosMap.get(prevSiblingIdx);
      if (prev === void 0) {
        previousSiblingPosMap.set(prevSiblingIdx, col);
      } else if (Array.isArray(prev)) {
        prev.push(col);
      } else {
        previousSiblingPosMap.set(prevSiblingIdx, [prev, col]);
      }
    }
    const result = new Array(cols.list.length);
    let resultPointer = result.length - 1;
    for (let i = noSiblingsAvailable.length - 1; i >= 0; i--) {
      result[resultPointer--] = noSiblingsAvailable[i];
    }
    for (let i = preservedOrder.length - 1; i >= 0; i--) {
      const nextCol = preservedOrder[i];
      const extraCols = previousSiblingPosMap.get(nextCol);
      if (extraCols) {
        if (Array.isArray(extraCols)) {
          for (let x = extraCols.length - 1; x >= 0; x--) {
            const col = extraCols[x];
            result[resultPointer--] = col;
          }
        } else {
          result[resultPointer--] = extraCols;
        }
      }
      result[resultPointer--] = nextCol;
    }
    cols.list = result;
  }
  positionLockedCols(cols) {
    cols.list = placeLockedColumns(cols.list, this.gos);
  }
  saveColOrder() {
    if (this.showingPivotResult) {
      this.lastPivotOrder = this.cols?.list ?? null;
    } else {
      this.lastOrder = this.cols?.list ?? null;
    }
  }
  getColumnDefs() {
    return this.colDefCols ? this.beans.colDefFactory?.getColumnDefs(
      this.colDefCols.list,
      this.showingPivotResult,
      this.lastOrder,
      this.cols?.list ?? []
    ) : void 0;
  }
  setColSpanActive() {
    this.colSpanActive = !!this.cols?.list.some((col) => col.getColDef().colSpan != null);
  }
  isPivotMode() {
    return this.pivotMode;
  }
  setPivotMode(pivotMode, source) {
    if (pivotMode === this.pivotMode) {
      return;
    }
    this.pivotMode = pivotMode;
    if (!this.ready) {
      return;
    }
    this.refreshCols(false);
    const { visibleCols, eventSvc } = this.beans;
    visibleCols.refresh(source);
    eventSvc.dispatchEvent({
      type: "columnPivotModeChanged"
    });
  }
  // + clientSideRowModel
  isPivotActive() {
    const pivotColumns = this.beans.pivotColsSvc?.columns;
    return this.pivotMode && !!pivotColumns?.length;
  }
  // called when dataTypes change
  recreateColumnDefs(e) {
    if (!this.cols) {
      return;
    }
    this.beans.autoColSvc?.updateColumns(e);
    const source = _convertColumnEventSourceType(e.source);
    this.createColsFromColDefs(source);
  }
  setColumnDefs(columnDefs, source) {
    this.colDefs = columnDefs;
    this.createColsFromColDefs(source);
  }
  destroy() {
    _destroyColumnTree(this.beans, this.colDefCols?.tree);
    super.destroy();
  }
  getColTree() {
    return this.cols?.tree ?? [];
  }
  // + columnSelectPanel
  getColDefColTree() {
    return this.colDefCols?.tree ?? [];
  }
  // + clientSideRowController -> sorting, building quick filter text
  // + headerRenderer -> sorting (clearing icon)
  getColDefCols() {
    return this.colDefCols?.list ?? null;
  }
  // + moveColumnController
  getCols() {
    return this.cols?.list ?? [];
  }
  forAllCols(callback) {
    const { pivotResultCols, autoColSvc, selectionColSvc } = this.beans;
    _forAll(this.colDefCols?.list, callback);
    _forAll(autoColSvc?.columns?.list, callback);
    _forAll(selectionColSvc?.columns?.list, callback);
    _forAll(pivotResultCols?.getPivotResultCols()?.list, callback);
  }
  getColsForKeys(keys) {
    if (!keys) {
      return [];
    }
    return keys.map((key) => this.getCol(key)).filter((col) => col != null);
  }
  getColDefCol(key) {
    if (!this.colDefCols?.list) {
      return null;
    }
    return this.getColFromCollection(key, this.colDefCols);
  }
  getCol(key) {
    if (key == null) {
      return null;
    }
    return this.getColFromCollection(key, this.cols);
  }
  /**
   * Get column exclusively by ID.
   *
   * Note getCol/getColFromCollection have poor performance when col has been removed.
   */
  getColById(key) {
    return this.cols?.map[key] ?? null;
  }
  getColFromCollection(key, cols) {
    if (cols == null) {
      return null;
    }
    const { map, list } = cols;
    if (typeof key == "string" && map[key]) {
      return map[key];
    }
    for (let i = 0; i < list.length; i++) {
      if (_columnsMatch(list[i], key)) {
        return list[i];
      }
    }
    return this.beans.autoColSvc?.getColumn(key) ?? this.beans.selectionColSvc?.getColumn(key) ?? null;
  }
};

// packages/ag-grid-community/src/columns/baseColsService.ts
var BaseColsService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.dispatchColumnChangedEvent = dispatchColumnChangedEvent;
    this.columns = [];
    this.columnIndexMap = {};
    this.updateIndexMap = () => {
      this.columnIndexMap = {};
      this.columns.forEach((col, index) => this.columnIndexMap[col.getId()] = index);
    };
  }
  wireBeans(beans) {
    this.colModel = beans.colModel;
    this.aggFuncSvc = beans.aggFuncSvc;
    this.visibleCols = beans.visibleCols;
  }
  sortColumns(compareFn) {
    this.columns.sort(compareFn);
    this.updateIndexMap();
  }
  setColumns(colKeys, source) {
    this.setColList(colKeys, this.columns, this.eventName, true, true, this.columnProcessors.set, source);
  }
  addColumns(colKeys, source) {
    this.updateColList(colKeys, this.columns, true, true, this.columnProcessors.add, this.eventName, source);
  }
  removeColumns(colKeys, source) {
    this.updateColList(colKeys, this.columns, false, true, this.columnProcessors.remove, this.eventName, source);
  }
  getColumnIndex(colId) {
    return this.columnIndexMap[colId];
  }
  setColList(colKeys = [], masterList, eventName, detectOrderChange, autoGroupsNeedBuilding, columnCallback, source) {
    const gridColumns = this.colModel.getCols();
    if (!gridColumns || gridColumns.length === 0) {
      return;
    }
    const changes = /* @__PURE__ */ new Map();
    masterList.forEach((col, idx) => changes.set(col, idx));
    masterList.length = 0;
    if (_exists(colKeys)) {
      colKeys.forEach((key) => {
        const column = this.colModel.getColDefCol(key);
        if (column) {
          masterList.push(column);
        }
      });
    }
    masterList.forEach((col, idx) => {
      const oldIndex = changes.get(col);
      if (oldIndex === void 0) {
        changes.set(col, 0);
        return;
      }
      if (detectOrderChange && oldIndex !== idx) {
        return;
      }
      changes.delete(col);
    });
    this.updateIndexMap();
    const primaryCols = this.colModel.getColDefCols();
    (primaryCols || []).forEach((column) => {
      const added = masterList.indexOf(column) >= 0;
      columnCallback(column, added, source);
    });
    autoGroupsNeedBuilding && this.colModel.refreshCols(false);
    this.visibleCols.refresh(source);
    this.dispatchColumnChangedEvent(this.eventSvc, eventName, [...changes.keys()], source);
  }
  updateColList(keys = [], masterList, actionIsAdd, autoGroupsNeedBuilding, columnCallback, eventType, source) {
    if (!keys || keys.length === 0) {
      return;
    }
    let atLeastOne = false;
    const updatedCols = /* @__PURE__ */ new Set();
    keys.forEach((key) => {
      if (!key) {
        return;
      }
      const columnToAdd = this.colModel.getColDefCol(key);
      if (!columnToAdd) {
        return;
      }
      updatedCols.add(columnToAdd);
      if (actionIsAdd) {
        if (masterList.indexOf(columnToAdd) >= 0) {
          return;
        }
        masterList.push(columnToAdd);
      } else {
        const currentIndex = masterList.indexOf(columnToAdd);
        if (currentIndex < 0) {
          return;
        }
        for (let i = currentIndex + 1; i < masterList.length; i++) {
          updatedCols.add(masterList[i]);
        }
        _removeFromArray(masterList, columnToAdd);
      }
      columnCallback(columnToAdd, actionIsAdd, source);
      atLeastOne = true;
    });
    if (!atLeastOne) {
      return;
    }
    this.updateIndexMap();
    if (autoGroupsNeedBuilding) {
      this.colModel.refreshCols(false);
    }
    this.visibleCols.refresh(source);
    const eventColumns = Array.from(updatedCols);
    this.eventSvc.dispatchEvent({
      type: eventType,
      columns: eventColumns,
      column: eventColumns.length === 1 ? eventColumns[0] : null,
      source
    });
  }
  extractCols(source, oldProvidedCols = []) {
    const previousCols = this.columns;
    const colsWithIndex = [];
    const colsWithValue = [];
    const { setFlagFunc, getIndexFunc, getInitialIndexFunc, getValueFunc, getInitialValueFunc } = this.columnExtractors;
    const primaryCols = this.colModel.getColDefCols() || [];
    primaryCols.forEach((col) => {
      const colIsNew = oldProvidedCols.indexOf(col) < 0;
      const colDef = col.getColDef();
      const value = getValueFunc(colDef);
      const initialValue = getInitialValueFunc(colDef);
      const index = getIndexFunc(colDef);
      const initialIndex = getInitialIndexFunc(colDef);
      let include;
      const valuePresent = value !== void 0;
      const indexPresent = index !== void 0;
      const initialValuePresent = initialValue !== void 0;
      const initialIndexPresent = initialIndex !== void 0;
      if (valuePresent) {
        include = value;
      } else if (indexPresent) {
        if (index === null) {
          include = false;
        } else {
          include = index >= 0;
        }
      } else {
        if (colIsNew) {
          if (initialValuePresent) {
            include = initialValue;
          } else if (initialIndexPresent) {
            include = initialIndex != null && initialIndex >= 0;
          } else {
            include = false;
          }
        } else {
          include = previousCols.indexOf(col) >= 0;
        }
      }
      if (include) {
        const useIndex = colIsNew ? index != null || initialIndex != null : index != null;
        useIndex ? colsWithIndex.push(col) : colsWithValue.push(col);
      }
    });
    const getIndexForCol = (col) => {
      const index = getIndexFunc(col.getColDef());
      const defaultIndex = getInitialIndexFunc(col.getColDef());
      return index != null ? index : defaultIndex;
    };
    colsWithIndex.sort((colA, colB) => {
      const indexA = getIndexForCol(colA);
      const indexB = getIndexForCol(colB);
      if (indexA === indexB) {
        return 0;
      }
      if (indexA < indexB) {
        return -1;
      }
      return 1;
    });
    const res = [].concat(colsWithIndex);
    previousCols.forEach((col) => {
      if (colsWithValue.indexOf(col) >= 0) {
        res.push(col);
      }
    });
    colsWithValue.forEach((col) => {
      if (res.indexOf(col) < 0) {
        res.push(col);
      }
    });
    previousCols.forEach((col) => {
      if (res.indexOf(col) < 0) {
        setFlagFunc(col, false, source);
      }
    });
    res.forEach((col) => {
      if (previousCols.indexOf(col) < 0) {
        setFlagFunc(col, true, source);
      }
    });
    this.columns = res;
    this.updateIndexMap();
    return this.columns;
  }
  restoreColumnOrder(columnStateAccumulator, incomingColumnState) {
    const colList = this.columns;
    const primaryCols = this.colModel.getColDefCols();
    if (!colList.length || !primaryCols) {
      return columnStateAccumulator;
    }
    const updatedColIdArray = Object.keys(incomingColumnState);
    const updatedColIds = new Set(updatedColIdArray);
    const newColIds = new Set(updatedColIdArray);
    const allColIds = new Set(
      colList.map((column) => {
        const colId = column.getColId();
        newColIds.delete(colId);
        return colId;
      }).concat(updatedColIdArray)
    );
    const colIdsInOriginalOrder = [];
    const originalOrderMap = {};
    let orderIndex = 0;
    for (let i = 0; i < primaryCols.length; i++) {
      const colId = primaryCols[i].getColId();
      if (allColIds.has(colId)) {
        colIdsInOriginalOrder.push(colId);
        originalOrderMap[colId] = orderIndex++;
      }
    }
    let index = 1e3;
    let hasAddedNewCols = false;
    let lastIndex = 0;
    const enableProp = this.columnOrdering.enableProp;
    const initialEnableProp = this.columnOrdering.initialEnableProp;
    const indexProp = this.columnOrdering.indexProp;
    const initialIndexProp = this.columnOrdering.initialIndexProp;
    const processPrecedingNewCols = (colId) => {
      const originalOrderIndex = originalOrderMap[colId];
      for (let i = lastIndex; i < originalOrderIndex; i++) {
        const newColId = colIdsInOriginalOrder[i];
        if (newColIds.has(newColId)) {
          incomingColumnState[newColId][indexProp] = index++;
          newColIds.delete(newColId);
        }
      }
      lastIndex = originalOrderIndex;
    };
    colList.forEach((column) => {
      const colId = column.getColId();
      if (updatedColIds.has(colId)) {
        processPrecedingNewCols(colId);
        incomingColumnState[colId][indexProp] = index++;
      } else {
        const colDef = column.getColDef();
        const missingIndex = colDef[indexProp] === null || colDef[indexProp] === void 0 && colDef[initialIndexProp] == null;
        if (missingIndex) {
          if (!hasAddedNewCols) {
            const propEnabled = colDef[enableProp] || colDef[enableProp] === void 0 && colDef[initialEnableProp];
            if (propEnabled) {
              processPrecedingNewCols(colId);
            } else {
              newColIds.forEach((newColId) => {
                incomingColumnState[newColId][indexProp] = index + originalOrderMap[newColId];
              });
              index += colIdsInOriginalOrder.length;
              hasAddedNewCols = true;
            }
          }
          if (!columnStateAccumulator[colId]) {
            columnStateAccumulator[colId] = { colId };
          }
          columnStateAccumulator[colId][indexProp] = index++;
        }
      }
    });
    return columnStateAccumulator;
  }
};

// packages/ag-grid-community/src/columns/groupInstanceIdCreator.ts
var GroupInstanceIdCreator = class {
  constructor() {
    // this map contains keys to numbers, so we remember what the last call was
    this.existingIds = {};
  }
  getInstanceIdForKey(key) {
    const lastResult = this.existingIds[key];
    let result;
    if (typeof lastResult !== "number") {
      result = 0;
    } else {
      result = lastResult + 1;
    }
    this.existingIds[key] = result;
    return result;
  }
};

// packages/ag-grid-community/src/components/emptyBean.ts
var EmptyBean = class extends BeanStub {
};
function setupCompBean(ctrl, ctx, compBean) {
  if (compBean) {
    ctrl.addDestroyFunc(() => ctx.destroyBean(compBean));
  }
  return compBean ?? ctrl;
}

// packages/ag-grid-community/src/rendering/cssClassManager.ts
var CssClassManager = class {
  constructor(getGui) {
    // to minimise DOM hits, we only apply CSS classes if they have changed. as adding a CSS class that is already
    // there, or removing one that wasn't present, all takes CPU.
    this.cssClassStates = {};
    this.getGui = getGui;
  }
  toggleCss(className, addOrRemove) {
    if (!className) {
      return;
    }
    if (className.indexOf(" ") >= 0) {
      const list = (className || "").split(" ");
      if (list.length > 1) {
        list.forEach((cls) => this.toggleCss(cls, addOrRemove));
        return;
      }
    }
    const updateNeeded = this.cssClassStates[className] !== addOrRemove;
    if (updateNeeded && className.length) {
      this.getGui()?.classList.toggle(className, addOrRemove);
      this.cssClassStates[className] = addOrRemove;
    }
  }
};

// packages/ag-grid-community/src/widgets/component.ts
var compIdSequence = 0;
var RefPlaceholder = null;
var Component = class extends BeanStub {
  constructor(templateOrParams, componentSelectors) {
    super();
    this.suppressDataRefValidation = false;
    // if false, then CSS class "ag-hidden" is applied, which sets "display: none"
    this.displayed = true;
    // if false, then CSS class "ag-invisible" is applied, which sets "visibility: hidden"
    this.visible = true;
    // unique id for this row component. this is used for getting a reference to the HTML dom.
    // we cannot use the RowNode id as this is not unique (due to animation, old rows can be lying
    // around as we create a new rowComp instance for the same row node).
    this.compId = compIdSequence++;
    this.cssManager = new CssClassManager(() => this.eGui);
    this.componentSelectors = new Map((componentSelectors ?? []).map((comp) => [comp.selector, comp]));
    if (templateOrParams) {
      this.setTemplate(templateOrParams);
    }
  }
  preConstruct() {
    this.wireTemplate(this.getGui());
    const debugId = "component-" + Object.getPrototypeOf(this)?.constructor?.name;
    this.css?.forEach((css) => this.beans.environment.addGlobalCSS(css, debugId));
  }
  wireTemplate(element, paramsMap) {
    if (element && this.gos) {
      this.applyElementsToComponent(element);
      this.createChildComponentsFromTags(element, paramsMap);
    }
  }
  getCompId() {
    return this.compId;
  }
  getDataRefAttribute(element) {
    if (element.getAttribute) {
      return element.getAttribute(DataRefAttribute);
    }
    return null;
  }
  applyElementsToComponent(element, elementRef, paramsMap, newComponent = null) {
    if (elementRef === void 0) {
      elementRef = this.getDataRefAttribute(element);
    }
    if (elementRef) {
      const current = this[elementRef];
      if (current === RefPlaceholder) {
        this[elementRef] = newComponent ?? element;
      } else {
        const usedAsParamRef = paramsMap && paramsMap[elementRef];
        if (!this.suppressDataRefValidation && !usedAsParamRef) {
          throw new Error(`data-ref: ${elementRef} on ${this.constructor.name} with ${current}`);
        }
      }
    }
  }
  // for registered components only, eg creates AgCheckbox instance from ag-checkbox HTML tag
  createChildComponentsFromTags(parentNode, paramsMap) {
    const childNodeList = [];
    for (const childNode of parentNode.childNodes ?? []) {
      childNodeList.push(childNode);
    }
    childNodeList.forEach((childNode) => {
      if (!(childNode instanceof HTMLElement)) {
        return;
      }
      const childComp = this.createComponentFromElement(
        childNode,
        (childComp2) => {
          const childGui = childComp2.getGui();
          if (childGui) {
            for (const attr of childNode.attributes ?? []) {
              childGui.setAttribute(attr.name, attr.value);
            }
          }
        },
        paramsMap
      );
      if (childComp) {
        if (childComp.addItems && childNode.children.length) {
          this.createChildComponentsFromTags(childNode, paramsMap);
          const items = Array.prototype.slice.call(childNode.children);
          childComp.addItems(items);
        }
        this.swapComponentForNode(childComp, parentNode, childNode);
      } else if (childNode.childNodes) {
        this.createChildComponentsFromTags(childNode, paramsMap);
      }
    });
  }
  createComponentFromElement(element, afterPreCreateCallback, paramsMap) {
    const key = element.nodeName;
    const elementRef = this.getDataRefAttribute(element);
    const isAgGridComponent = key.indexOf("AG-") === 0;
    const componentSelector = isAgGridComponent ? this.componentSelectors.get(key) : null;
    let newComponent = null;
    if (componentSelector) {
      const componentParams = paramsMap && elementRef ? paramsMap[elementRef] : void 0;
      newComponent = new componentSelector.component(componentParams);
      newComponent.setParentComponent(this);
      this.createBean(newComponent, null, afterPreCreateCallback);
    } else if (isAgGridComponent) {
      throw new Error(`selector: ${key}`);
    }
    this.applyElementsToComponent(element, elementRef, paramsMap, newComponent);
    return newComponent;
  }
  swapComponentForNode(newComponent, parentNode, childNode) {
    const eComponent = newComponent.getGui();
    parentNode.replaceChild(eComponent, childNode);
    parentNode.insertBefore(document.createComment(childNode.nodeName), eComponent);
    this.addDestroyFunc(this.destroyBean.bind(this, newComponent));
  }
  activateTabIndex(elements) {
    const tabIndex = this.gos.get("tabIndex");
    if (!elements) {
      elements = [];
    }
    if (!elements.length) {
      elements.push(this.getGui());
    }
    elements.forEach((el) => el.setAttribute("tabindex", tabIndex.toString()));
  }
  setTemplate(templateOrParams, componentSelectors, paramsMap) {
    let eGui;
    if (typeof templateOrParams === "string" || templateOrParams == null) {
      eGui = _loadTemplate(templateOrParams);
    } else {
      eGui = _createElement(templateOrParams);
    }
    this.setTemplateFromElement(eGui, componentSelectors, paramsMap);
  }
  setTemplateFromElement(element, components, paramsMap, suppressDataRefValidation = false) {
    this.eGui = element;
    this.suppressDataRefValidation = suppressDataRefValidation;
    if (components) {
      for (let i = 0; i < components.length; i++) {
        const component = components[i];
        this.componentSelectors.set(component.selector, component);
      }
    }
    this.wireTemplate(element, paramsMap);
  }
  getGui() {
    return this.eGui;
  }
  getFocusableElement() {
    return this.eGui;
  }
  getAriaElement() {
    return this.getFocusableElement();
  }
  setParentComponent(component) {
    this.parentComponent = component;
  }
  getParentComponent() {
    return this.parentComponent;
  }
  // this method is for older code, that wants to provide the gui element,
  // it is not intended for this to be in ag-Stack
  setGui(eGui) {
    this.eGui = eGui;
  }
  queryForHtmlElement(cssSelector) {
    return this.eGui.querySelector(cssSelector);
  }
  getContainerAndElement(newChild, container) {
    let parent = container;
    if (newChild == null) {
      return null;
    }
    if (!parent) {
      parent = this.eGui;
    }
    if (_isNodeOrElement(newChild)) {
      return {
        element: newChild,
        parent
      };
    }
    return {
      element: newChild.getGui(),
      parent
    };
  }
  prependChild(newChild, container) {
    const { element, parent } = this.getContainerAndElement(newChild, container) || {};
    if (!element || !parent) {
      return;
    }
    parent.insertAdjacentElement("afterbegin", element);
  }
  appendChild(newChild, container) {
    const { element, parent } = this.getContainerAndElement(newChild, container) || {};
    if (!element || !parent) {
      return;
    }
    parent.appendChild(element);
  }
  isDisplayed() {
    return this.displayed;
  }
  setVisible(visible, options = {}) {
    if (visible !== this.visible) {
      this.visible = visible;
      const { skipAriaHidden } = options;
      _setVisible(this.eGui, visible, { skipAriaHidden });
    }
  }
  setDisplayed(displayed, options = {}) {
    if (displayed !== this.displayed) {
      this.displayed = displayed;
      const { skipAriaHidden } = options;
      _setDisplayed(this.eGui, displayed, { skipAriaHidden });
      const event = {
        type: "displayChanged",
        visible: this.displayed
      };
      this.dispatchLocalEvent(event);
    }
  }
  destroy() {
    if (this.parentComponent) {
      this.parentComponent = void 0;
    }
    super.destroy();
  }
  addGuiEventListener(event, listener, options) {
    this.eGui.addEventListener(event, listener, options);
    this.addDestroyFunc(() => this.eGui.removeEventListener(event, listener));
  }
  addCss(className) {
    this.cssManager.toggleCss(className, true);
  }
  removeCss(className) {
    this.cssManager.toggleCss(className, false);
  }
  toggleCss(className, addOrRemove) {
    this.cssManager.toggleCss(className, addOrRemove);
  }
  registerCSS(css) {
    this.css || (this.css = []);
    this.css.push(css);
  }
};

// packages/ag-grid-community/src/interfaces/iFilter.ts
function isColumnFilterComp(filter) {
  return typeof filter === "object" && !!filter.component;
}

// packages/ag-grid-community/src/utils/promise.ts
function _isPromise(fn) {
  if (typeof fn.then === "function") {
    return true;
  }
  return false;
}
var AgPromise = class _AgPromise {
  constructor(callback) {
    this.status = 0 /* IN_PROGRESS */;
    this.resolution = null;
    this.waiters = [];
    callback(
      (value) => this.onDone(value),
      (params) => this.onReject(params)
    );
  }
  static all(promises) {
    return promises.length ? new _AgPromise((resolve) => {
      let remainingToResolve = promises.length;
      const combinedValues = new Array(remainingToResolve);
      promises.forEach((promise, index) => {
        promise.then((value) => {
          combinedValues[index] = value;
          remainingToResolve--;
          if (remainingToResolve === 0) {
            resolve(combinedValues);
          }
        });
      });
    }) : _AgPromise.resolve();
  }
  static resolve(value = null) {
    return new _AgPromise((resolve) => resolve(value));
  }
  then(func) {
    return new _AgPromise((resolve) => {
      if (this.status === 1 /* RESOLVED */) {
        resolve(func(this.resolution));
      } else {
        this.waiters.push((value) => resolve(func(value)));
      }
    });
  }
  onDone(value) {
    this.status = 1 /* RESOLVED */;
    this.resolution = value;
    this.waiters.forEach((waiter) => waiter(value));
  }
  onReject(_) {
  }
};

// packages/ag-grid-community/src/components/framework/userComponentFactory.ts
function doesImplementIComponent(candidate) {
  if (!candidate) {
    return false;
  }
  return candidate.prototype && "getGui" in candidate.prototype;
}
function _getUserCompKeys(frameworkOverrides, defObject, type, params) {
  const { name } = type;
  let compName;
  let jsComp;
  let fwComp;
  let paramsFromSelector;
  let popupFromSelector;
  let popupPositionFromSelector;
  if (defObject) {
    const defObjectAny = defObject;
    const selectorFunc = defObjectAny[name + "Selector"];
    const selectorRes = selectorFunc ? selectorFunc(params) : null;
    const assignComp = (providedJsComp) => {
      if (typeof providedJsComp === "string") {
        compName = providedJsComp;
      } else if (providedJsComp != null && providedJsComp !== true) {
        const isFwkComp = frameworkOverrides.isFrameworkComponent(providedJsComp);
        if (isFwkComp) {
          fwComp = providedJsComp;
        } else {
          jsComp = providedJsComp;
        }
      }
    };
    if (selectorRes) {
      assignComp(selectorRes.component);
      paramsFromSelector = selectorRes.params;
      popupFromSelector = selectorRes.popup;
      popupPositionFromSelector = selectorRes.popupPosition;
    } else {
      assignComp(defObjectAny[name]);
    }
  }
  return { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector };
}
var UserComponentFactory = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "userCompFactory";
  }
  wireBeans(beans) {
    this.agCompUtils = beans.agCompUtils;
    this.registry = beans.registry;
    this.frameworkCompWrapper = beans.frameworkCompWrapper;
    this.gridOptions = beans.gridOptions;
  }
  getCompDetailsFromGridOptions(type, defaultName, params, mandatory = false) {
    return this.getCompDetails(this.gridOptions, type, defaultName, params, mandatory);
  }
  getCompDetails(defObject, type, defaultName, params, mandatory = false) {
    const { name, cellRenderer } = type;
    let { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector } = _getUserCompKeys(this.beans.frameworkOverrides, defObject, type, params);
    let defaultCompParams;
    let defaultCompProcessParams;
    const lookupFromRegistry = (key) => {
      const item = this.registry.getUserComponent(name, key);
      if (item) {
        jsComp = !item.componentFromFramework ? item.component : void 0;
        fwComp = item.componentFromFramework ? item.component : void 0;
        defaultCompParams = item.params;
        defaultCompProcessParams = item.processParams;
      }
    };
    if (compName != null) {
      lookupFromRegistry(compName);
    }
    if (jsComp == null && fwComp == null && defaultName != null) {
      lookupFromRegistry(defaultName);
    }
    if (jsComp && cellRenderer && !doesImplementIComponent(jsComp)) {
      jsComp = this.agCompUtils?.adaptFunction(type, jsComp);
    }
    if (!jsComp && !fwComp) {
      const { validation: validation2 } = this.beans;
      if (mandatory && (compName !== defaultName || !defaultName)) {
        if (compName) {
          if (!validation2?.isProvidedUserComp(compName)) {
            _error(50, { compName });
          }
        } else {
          if (defaultName) {
            if (!validation2) {
              _error(260, {
                ...this.gos.getModuleErrorParams(),
                propName: name,
                compName: defaultName
              });
            }
          } else {
            _error(216, { name });
          }
        }
      } else if (defaultName && !validation2) {
        _error(146, { comp: defaultName });
      }
      return;
    }
    const paramsMerged = this.mergeParams(
      defObject,
      type,
      params,
      paramsFromSelector,
      defaultCompParams,
      defaultCompProcessParams
    );
    const componentFromFramework = jsComp == null;
    const componentClass = jsComp ?? fwComp;
    return {
      componentFromFramework,
      componentClass,
      params: paramsMerged,
      type,
      popupFromSelector,
      popupPositionFromSelector,
      newAgStackInstance: () => this.newAgStackInstance(componentClass, componentFromFramework, paramsMerged, type)
    };
  }
  newAgStackInstance(ComponentClass, componentFromFramework, params, type) {
    const jsComponent = !componentFromFramework;
    let instance;
    if (jsComponent) {
      instance = new ComponentClass();
    } else {
      instance = this.frameworkCompWrapper.wrap(
        ComponentClass,
        type.mandatoryMethods,
        type.optionalMethods,
        type
      );
    }
    this.createBean(instance);
    const deferredInit = instance.init?.(params);
    if (deferredInit == null) {
      return AgPromise.resolve(instance);
    }
    return deferredInit.then(() => instance);
  }
  /**
   * merges params with application provided params
   * used by Floating Filter
   */
  mergeParams(defObject, type, paramsFromGrid, paramsFromSelector = null, defaultCompParams, defaultCompProcessParams) {
    const params = { ...paramsFromGrid, ...defaultCompParams };
    const defObjectAny = defObject;
    const userParams = defObjectAny && defObjectAny[type.name + "Params"];
    if (typeof userParams === "function") {
      const userParamsFromFunc = userParams(paramsFromGrid);
      _mergeDeep(params, userParamsFromFunc);
    } else if (typeof userParams === "object") {
      _mergeDeep(params, userParams);
    }
    _mergeDeep(params, paramsFromSelector);
    return defaultCompProcessParams ? defaultCompProcessParams(params) : params;
  }
};

// packages/ag-grid-community/src/components/framework/userCompUtils.ts
var DateComponent = {
  name: "dateComponent",
  mandatoryMethods: ["getDate", "setDate"],
  optionalMethods: ["afterGuiAttached", "setInputPlaceholder", "setInputAriaLabel", "setDisabled", "refresh"]
};
var DragAndDropImageComponent = {
  name: "dragAndDropImageComponent",
  mandatoryMethods: ["setIcon", "setLabel"]
};
var HeaderComponent = { name: "headerComponent", optionalMethods: ["refresh"] };
var InnerHeaderComponent = { name: "innerHeaderComponent" };
var InnerHeaderGroupComponent = { name: "innerHeaderGroupComponent" };
var HeaderGroupComponent = { name: "headerGroupComponent" };
var InnerCellRendererComponent = {
  name: "innerRenderer",
  cellRenderer: true,
  optionalMethods: ["afterGuiAttached"]
};
var CellRendererComponent = {
  name: "cellRenderer",
  optionalMethods: ["refresh", "afterGuiAttached"],
  cellRenderer: true
};
var EditorRendererComponent = {
  name: "cellRenderer",
  optionalMethods: ["refresh", "afterGuiAttached"]
};
var LoadingCellRendererComponent = { name: "loadingCellRenderer", cellRenderer: true };
var CellEditorComponent = {
  name: "cellEditor",
  mandatoryMethods: ["getValue"],
  optionalMethods: [
    "isPopup",
    "isCancelBeforeStart",
    "isCancelAfterEnd",
    "getPopupPosition",
    "focusIn",
    "focusOut",
    "afterGuiAttached",
    "refresh"
  ]
};
var LoadingOverlayComponent = { name: "loadingOverlayComponent", optionalMethods: ["refresh"] };
var NoRowsOverlayComponent = { name: "noRowsOverlayComponent", optionalMethods: ["refresh"] };
var TooltipComponent = { name: "tooltipComponent" };
var FilterComponent = {
  name: "filter",
  mandatoryMethods: ["isFilterActive", "doesFilterPass", "getModel", "setModel"],
  optionalMethods: [
    "afterGuiAttached",
    "afterGuiDetached",
    "onNewRowsLoaded",
    "getModelAsString",
    "onFloatingFilterChanged",
    "onAnyFilterChanged",
    "refresh"
  ]
};
var FloatingFilterComponent = {
  name: "floatingFilterComponent",
  mandatoryMethods: ["onParentModelChanged"],
  optionalMethods: ["afterGuiAttached", "refresh"]
};
var FullWidth = {
  name: "fullWidthCellRenderer",
  optionalMethods: ["refresh", "afterGuiAttached"],
  cellRenderer: true
};
var FullWidthLoading = { name: "loadingCellRenderer", cellRenderer: true };
var FullWidthGroup = {
  name: "groupRowRenderer",
  optionalMethods: ["afterGuiAttached"],
  cellRenderer: true
};
var FullWidthDetail = { name: "detailCellRenderer", optionalMethods: ["refresh"], cellRenderer: true };
function _getDragAndDropImageCompDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(DragAndDropImageComponent, "agDragAndDropImage", params, true);
}
function _getInnerCellRendererDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, InnerCellRendererComponent, void 0, params);
}
function _getHeaderCompDetails(userCompFactory, colDef, params) {
  return userCompFactory.getCompDetails(colDef, HeaderComponent, "agColumnHeader", params);
}
function _getInnerHeaderCompDetails(userCompFactory, headerCompParams, params) {
  return userCompFactory.getCompDetails(headerCompParams, InnerHeaderComponent, void 0, params);
}
function _getHeaderGroupCompDetails(userCompFactory, params) {
  const colGroupDef = params.columnGroup.getColGroupDef();
  return userCompFactory.getCompDetails(colGroupDef, HeaderGroupComponent, "agColumnGroupHeader", params);
}
function _getInnerHeaderGroupCompDetails(userCompFactory, headerGroupCompParams, params) {
  return userCompFactory.getCompDetails(headerGroupCompParams, InnerHeaderGroupComponent, void 0, params);
}
function _getFullWidthCellRendererDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(FullWidth, void 0, params, true);
}
function _getFullWidthLoadingCellRendererDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(FullWidthLoading, "agLoadingCellRenderer", params, true);
}
function _getFullWidthGroupCellRendererDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(FullWidthGroup, "agGroupRowRenderer", params, true);
}
function _getFullWidthDetailCellRendererDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(FullWidthDetail, "agDetailCellRenderer", params, true);
}
function _getCellRendererDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, CellRendererComponent, void 0, params);
}
function _getEditorRendererDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(
    def,
    EditorRendererComponent,
    void 0,
    params
  );
}
function _getLoadingCellRendererDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, LoadingCellRendererComponent, "agSkeletonCellRenderer", params, true);
}
function _getCellEditorDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, CellEditorComponent, "agCellEditor", params, true);
}
function _getFilterDetails(userCompFactory, def, params, defaultFilter) {
  const filter = def.filter;
  if (isColumnFilterComp(filter)) {
    def = {
      filter: filter.component,
      filterParams: def.filterParams
    };
  }
  return userCompFactory.getCompDetails(def, FilterComponent, defaultFilter, params, true);
}
function _getDateCompDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, DateComponent, "agDateInput", params, true);
}
function _getLoadingOverlayCompDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(LoadingOverlayComponent, "agLoadingOverlay", params, true);
}
function _getNoRowsOverlayCompDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(NoRowsOverlayComponent, "agNoRowsOverlay", params, true);
}
function _getTooltipCompDetails(userCompFactory, params) {
  return userCompFactory.getCompDetails(params.colDef, TooltipComponent, "agTooltipComponent", params, true);
}
function _getFloatingFilterCompDetails(userCompFactory, def, params, defaultFloatingFilter) {
  return userCompFactory.getCompDetails(def, FloatingFilterComponent, defaultFloatingFilter, params);
}
function _getFilterCompKeys(frameworkOverrides, def) {
  return _getUserCompKeys(frameworkOverrides, def, FilterComponent);
}
function _mergeFilterParamsWithApplicationProvidedParams(userCompFactory, defObject, paramsFromGrid) {
  return userCompFactory.mergeParams(defObject, FilterComponent, paramsFromGrid);
}

// packages/ag-grid-community/src/components/framework/unwrapUserComp.ts
function _unwrapUserComp(comp) {
  const compAsAny = comp;
  const isProxy = compAsAny != null && compAsAny.getFrameworkComponentInstance != null;
  return isProxy ? compAsAny.getFrameworkComponentInstance() : comp;
}

// packages/ag-grid-community/src/modules/moduleRegistry.ts
var allRegisteredModules = /* @__PURE__ */ new Set();
var globalModulesMap = {};
var gridModulesMap = {};
var currentModuleVersion;
var userHasRegistered = false;
var areGridScopedModules = false;
var isUmd = false;
function isValidModuleVersion(module2) {
  const [moduleMajor, moduleMinor] = module2.version.split(".") || [];
  const [currentModuleMajor, currentModuleMinor] = currentModuleVersion.split(".") || [];
  return moduleMajor === currentModuleMajor && moduleMinor === currentModuleMinor;
}
function runVersionChecks(module2) {
  if (!currentModuleVersion) {
    currentModuleVersion = module2.version;
  }
  const errorMsg = (details) => `You are using incompatible versions of AG Grid modules. Major and minor versions should always match across modules. ${details} Please update all modules to the same version.`;
  if (!module2.version) {
    _errorOnce(errorMsg(`'${module2.moduleName}' is incompatible.`));
  } else if (!isValidModuleVersion(module2)) {
    _errorOnce(
      errorMsg(
        `'${module2.moduleName}' is version ${module2.version} but the other modules are version ${currentModuleVersion}.`
      )
    );
  }
  if (module2.validate) {
    const result = module2.validate();
    if (!result.isValid) {
      const errorResult = result;
      _errorOnce(`${errorResult.message}`);
    }
  }
}
function _registerModule(module2, gridId, isInternalRegistration = false) {
  if (!isInternalRegistration) {
    userHasRegistered = true;
  }
  runVersionChecks(module2);
  const rowModels = module2.rowModels ?? ["all"];
  allRegisteredModules.add(module2);
  let moduleStore;
  if (gridId !== void 0) {
    areGridScopedModules = true;
    if (gridModulesMap[gridId] === void 0) {
      gridModulesMap[gridId] = {};
    }
    moduleStore = gridModulesMap[gridId];
  } else {
    moduleStore = globalModulesMap;
  }
  rowModels.forEach((rowModel) => {
    if (moduleStore[rowModel] === void 0) {
      moduleStore[rowModel] = {};
    }
    moduleStore[rowModel][module2.moduleName] = module2;
  });
  if (module2.dependsOn) {
    module2.dependsOn.forEach((dependency) => _registerModule(dependency, gridId, isInternalRegistration));
  }
}
function _unRegisterGridModules(gridId) {
  delete gridModulesMap[gridId];
}
function _isModuleRegistered(moduleName, gridId, rowModel) {
  const isRegisteredForRowModel = (model) => !!globalModulesMap[model]?.[moduleName] || !!gridModulesMap[gridId]?.[model]?.[moduleName];
  return isRegisteredForRowModel(rowModel) || isRegisteredForRowModel("all");
}
function _areModulesGridScoped() {
  return areGridScopedModules;
}
function _getRegisteredModules(gridId, rowModel) {
  const gridModules = gridModulesMap[gridId] ?? {};
  return [
    ...Object.values(globalModulesMap["all"] ?? {}),
    ...Object.values(gridModules["all"] ?? {}),
    ...Object.values(globalModulesMap[rowModel] ?? {}),
    ...Object.values(gridModules[rowModel] ?? {})
  ];
}
function _getAllRegisteredModules() {
  return new Set(allRegisteredModules);
}
function _getGridRegisteredModules(gridId, rowModel) {
  const gridModules = gridModulesMap[gridId] ?? {};
  return [...Object.values(gridModules["all"] ?? {}), ...Object.values(gridModules[rowModel] ?? {})];
}
function _hasUserRegistered() {
  return userHasRegistered;
}
function _isUmd() {
  return isUmd;
}
function _setUmd() {
  isUmd = true;
}
var ModuleRegistry = class {
  /**
   * @deprecated v33 Use `registerModules([module])` instead.
   */
  static register(module2) {
    _registerModule(module2, void 0);
  }
  /**
   * Globally register the given modules for all grids.
   * @param modules - modules to register
   */
  static registerModules(modules) {
    modules.forEach((module2) => _registerModule(module2, void 0));
  }
};

// packages/ag-grid-community/src/context/genericContext.ts
var GenericContext = class {
  constructor(params) {
    this.beans = {};
    this.createdBeans = [];
    this.destroyed = false;
    if (!params || !params.beanClasses) {
      return;
    }
    this.beanDestroyComparator = params.beanDestroyComparator;
    this.init(params);
  }
  init(params) {
    for (const beanName of Object.keys(params.providedBeanInstances)) {
      this.beans[beanName] = params.providedBeanInstances[beanName];
    }
    params.beanClasses.forEach((BeanClass) => {
      const instance = new BeanClass();
      if (instance.beanName) {
        this.beans[instance.beanName] = instance;
      } else {
        console.error(`Bean ${BeanClass.name} is missing beanName`);
      }
      this.createdBeans.push(instance);
    });
    params.derivedBeans?.forEach((beanFunc) => {
      const { beanName, bean } = beanFunc(this);
      this.beans[beanName] = bean;
      this.createdBeans.push(bean);
    });
    if (params.beanInitComparator) {
      this.createdBeans.sort(params.beanInitComparator);
    }
    this.initBeans(this.createdBeans);
  }
  getBeanInstances() {
    return Object.values(this.beans);
  }
  createBean(bean, afterPreCreateCallback) {
    this.initBeans([bean], afterPreCreateCallback);
    return bean;
  }
  initBeans(beanInstances, afterPreCreateCallback) {
    beanInstances.forEach((instance) => {
      instance.preWireBeans?.(this.beans);
      instance.wireBeans?.(this.beans);
    });
    beanInstances.forEach((instance) => instance.preConstruct?.());
    if (afterPreCreateCallback) {
      beanInstances.forEach(afterPreCreateCallback);
    }
    beanInstances.forEach((instance) => instance.postConstruct?.());
  }
  getBeans() {
    return this.beans;
  }
  getBean(name) {
    return this.beans[name];
  }
  destroy() {
    if (this.destroyed) {
      return;
    }
    this.destroyed = true;
    const beanInstances = this.getBeanInstances();
    if (this.beanDestroyComparator) {
      beanInstances.sort(this.beanDestroyComparator);
    }
    this.destroyBeans(beanInstances);
    this.beans = {};
    this.createdBeans = [];
  }
  /**
   * Destroys a bean and returns undefined to support destruction and clean up in a single line.
   * this.dateComp = this.context.destroyBean(this.dateComp);
   */
  destroyBean(bean) {
    bean?.destroy?.();
  }
  /**
   * Destroys an array of beans and returns an empty array to support destruction and clean up in a single line.
   * this.dateComps = this.context.destroyBeans(this.dateComps);
   */
  destroyBeans(beans) {
    if (beans) {
      for (let i = 0; i < beans.length; i++) {
        this.destroyBean(beans[i]);
      }
    }
    return [];
  }
  isDestroyed() {
    return this.destroyed;
  }
};

// packages/ag-grid-community/src/context/context.ts
function isComponentMetaFunc(componentMeta) {
  return typeof componentMeta === "object" && !!componentMeta.getComp;
}
var Context = class extends GenericContext {
  init(params) {
    this.gridId = params.gridId;
    this.beans.context = this;
    this.destroyCallback = params.destroyCallback;
    super.init(params);
  }
  destroy() {
    super.destroy();
    _unRegisterGridModules(this.gridId);
    this.destroyCallback?.();
  }
  getGridId() {
    return this.gridId;
  }
};

// packages/ag-grid-community/src/edit/editModelService.ts
var EditModelService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "editModelSvc";
    this.edits = /* @__PURE__ */ new Map();
    this.cellValidations = new EditCellValidationModel();
    this.rowValidations = new EditRowValidationModel();
    // during some operations, we want to always return false from `hasEdits`
    this.suspendEdits = false;
  }
  suspend(suspend) {
    this.suspendEdits = suspend;
  }
  removeEdits({ rowNode, column }) {
    if (!this.hasEdits({ rowNode }) || !rowNode) {
      return;
    }
    const editRow = this.getEditRow(rowNode);
    if (column) {
      editRow.delete(column);
    } else {
      editRow.clear();
    }
    if (editRow.size === 0) {
      this.edits.delete(rowNode);
    }
  }
  getEditRow(rowNode, params = {}) {
    if (this.suspendEdits) {
      return void 0;
    }
    if (this.edits.size === 0) {
      return void 0;
    }
    const edits = rowNode && this.edits.get(rowNode);
    if (edits) {
      return edits;
    }
    if (params.checkSiblings) {
      const pinnedSibling = rowNode.pinnedSibling;
      if (pinnedSibling) {
        return this.getEditRow(pinnedSibling);
      }
    }
    return void 0;
  }
  getEditRowDataValue(rowNode, { checkSiblings } = {}) {
    if (this.edits.size === 0) {
      return rowNode.data;
    }
    const editRow = this.getEditRow(rowNode);
    const pinnedSibling = rowNode.pinnedSibling;
    const siblingRow = checkSiblings && pinnedSibling && this.getEditRow(pinnedSibling);
    if (!editRow && !siblingRow) {
      return rowNode.data;
    }
    const data = Object.assign({}, rowNode.data);
    const applyEdits = (edits, data2) => edits.forEach(({ pendingValue }, column) => {
      if (pendingValue !== UNEDITED) {
        data2[column.getColId()] = pendingValue;
      }
    });
    if (editRow) {
      applyEdits(editRow, data);
    }
    if (siblingRow) {
      applyEdits(siblingRow, data);
    }
    return data;
  }
  getEdit(position, copy) {
    const edit = this._getEdit(position);
    return copy && edit ? { ...edit } : edit;
  }
  _getEdit(position) {
    if (this.suspendEdits) {
      return void 0;
    }
    if (this.edits.size === 0) {
      return void 0;
    }
    return position.rowNode && position.column && this.getEditRow(position.rowNode)?.get(position.column);
  }
  getEditMap(copy = true) {
    if (this.suspendEdits || this.edits.size === 0) {
      return /* @__PURE__ */ new Map();
    }
    if (!copy) {
      return this.edits;
    }
    const map = /* @__PURE__ */ new Map();
    this.edits.forEach((editRow, rowNode) => map.set(rowNode, new Map(editRow)));
    return map;
  }
  setEditMap(newEdits) {
    this.edits.clear();
    newEdits.forEach((editRow, rowNode) => {
      const newRow = /* @__PURE__ */ new Map();
      editRow.forEach(
        (cellData, column) => (
          // Ensure we copy the cell data to avoid reference issues
          newRow.set(column, { ...cellData })
        )
      );
      this.edits.set(rowNode, newRow);
    });
  }
  setEdit(position, edit) {
    (this.edits.size === 0 || !this.edits.has(position.rowNode)) && this.edits.set(position.rowNode, /* @__PURE__ */ new Map());
    const currentEdit = { ...this._getEdit(position), ...edit };
    this.getEditRow(position.rowNode).set(position.column, currentEdit);
    return currentEdit;
  }
  clearEditValue(position) {
    const { rowNode, column } = position;
    if (rowNode) {
      if (column) {
        const edit = this._getEdit(position);
        if (edit) {
          edit.editorValue = void 0;
          edit.pendingValue = edit.sourceValue;
          edit.state = "changed";
        }
      } else {
        this.getEditRow(rowNode)?.forEach((cellData) => {
          cellData.editorValue = void 0;
          cellData.pendingValue = cellData.sourceValue;
          cellData.state = "changed";
        });
      }
    }
  }
  getState(position) {
    if (this.suspendEdits) {
      return void 0;
    }
    return this.getEdit(position)?.state;
  }
  getEditPositions(editMap) {
    if (this.suspendEdits || (editMap ?? this.edits).size === 0) {
      return [];
    }
    const positions = [];
    (editMap ?? this.edits).forEach((editRow, rowNode) => {
      for (const column of editRow.keys()) {
        positions.push({
          rowNode,
          column,
          ...editRow.get(column)
        });
      }
    });
    return positions;
  }
  hasRowEdits(rowNode, params) {
    if (this.suspendEdits) {
      return false;
    }
    if (this.edits.size === 0) {
      return false;
    }
    const rowEdits = this.getEditRow(rowNode, params);
    return !!rowEdits;
  }
  hasEdits(position = {}, params = {}) {
    if (this.suspendEdits) {
      return false;
    }
    if (this.edits.size === 0) {
      return false;
    }
    const { rowNode, column } = position;
    const { withOpenEditor } = params;
    if (rowNode) {
      const rowEdits = this.getEditRow(rowNode, params);
      if (!rowEdits) {
        return false;
      }
      if (column) {
        if (withOpenEditor) {
          return this.getEdit(position)?.state === "editing";
        }
        return rowEdits.has(column) ?? false;
      }
      if (rowEdits.size !== 0) {
        if (withOpenEditor) {
          return Array.from(rowEdits.values()).some(({ state }) => state === "editing");
        }
        return true;
      }
      return false;
    }
    if (withOpenEditor) {
      return this.getEditPositions().some(({ state }) => state === "editing");
    }
    return this.edits.size > 0;
  }
  start(position) {
    const map = this.getEditRow(position.rowNode) ?? /* @__PURE__ */ new Map();
    const { rowNode, column } = position;
    if (column && !map.has(column)) {
      map.set(column, {
        editorValue: void 0,
        pendingValue: UNEDITED,
        sourceValue: this.beans.valueSvc.getValue(column, rowNode, true, "api"),
        state: "editing"
      });
    }
    this.edits.set(rowNode, map);
  }
  stop(position) {
    if (!this.hasEdits(position)) {
      return;
    }
    if (position) {
      this.removeEdits(position);
    } else {
      this.clear();
    }
    return;
  }
  clear() {
    for (const pendingRowEdits of this.edits.values()) {
      pendingRowEdits.clear();
    }
    this.edits.clear();
  }
  getCellValidationModel() {
    return this.cellValidations;
  }
  getRowValidationModel() {
    return this.rowValidations;
  }
  setCellValidationModel(model) {
    this.cellValidations = model;
  }
  setRowValidationModel(model) {
    this.rowValidations = model;
  }
  destroy() {
    super.destroy();
    this.clear();
  }
};
var EditCellValidationModel = class {
  constructor() {
    this.cellValidations = /* @__PURE__ */ new Map();
  }
  getCellValidation(position) {
    const { rowNode, column } = position || {};
    return this.cellValidations?.get(rowNode)?.get(column);
  }
  hasCellValidation(position) {
    if (!position || !position.rowNode || !position.column) {
      return this.cellValidations.size > 0;
    }
    return !!this.getCellValidation(position);
  }
  setCellValidation(position, validation2) {
    const { rowNode, column } = position;
    if (!this.cellValidations.has(rowNode)) {
      this.cellValidations.set(rowNode, /* @__PURE__ */ new Map());
    }
    this.cellValidations.get(rowNode).set(column, validation2);
  }
  clearCellValidation(position) {
    const { rowNode, column } = position;
    this.cellValidations.get(rowNode)?.delete(column);
  }
  setCellValidationMap(validationMap) {
    this.cellValidations = validationMap;
  }
  getCellValidationMap() {
    return this.cellValidations;
  }
  clearCellValidationMap() {
    this.cellValidations.clear();
  }
};
var EditRowValidationModel = class {
  constructor() {
    this.rowValidations = /* @__PURE__ */ new Map();
  }
  getRowValidation(position) {
    const { rowNode } = position || {};
    return this.rowValidations.get(rowNode);
  }
  hasRowValidation(position) {
    if (!position || !position.rowNode) {
      return this.rowValidations.size > 0;
    }
    return !!this.getRowValidation(position);
  }
  setRowValidation({ rowNode }, rowValidation) {
    this.rowValidations.set(rowNode, rowValidation);
  }
  clearRowValidation({ rowNode }) {
    this.rowValidations.delete(rowNode);
  }
  setRowValidationMap(validationMap) {
    this.rowValidations = validationMap;
  }
  getRowValidationMap() {
    return this.rowValidations;
  }
  clearRowValidationMap() {
    this.rowValidations.clear();
  }
};

// packages/ag-grid-community/src/entities/positionUtils.ts
function _createCellId(cellPosition) {
  const { rowIndex, rowPinned, column } = cellPosition;
  return `${rowIndex}.${rowPinned == null ? "null" : rowPinned}.${column.getId()}`;
}
function _areCellsEqual(cellA, cellB) {
  const colsMatch = cellA.column === cellB.column;
  const floatingMatch = cellA.rowPinned === cellB.rowPinned;
  const indexMatch = cellA.rowIndex === cellB.rowIndex;
  return colsMatch && floatingMatch && indexMatch;
}
function _isRowBefore(rowA, rowB) {
  switch (rowA.rowPinned) {
    case "top":
      if (rowB.rowPinned !== "top") {
        return true;
      }
      break;
    case "bottom":
      if (rowB.rowPinned !== "bottom") {
        return false;
      }
      break;
    default:
      if (_exists(rowB.rowPinned)) {
        return rowB.rowPinned !== "top";
      }
      break;
  }
  return rowA.rowIndex < rowB.rowIndex;
}
function _isSameRow(rowA, rowB) {
  if (!rowA && !rowB) {
    return true;
  }
  if (rowA && !rowB || !rowA && rowB) {
    return false;
  }
  return rowA.rowIndex === rowB.rowIndex && rowA.rowPinned == rowB.rowPinned;
}
function _getFirstRow(beans) {
  let rowIndex = 0;
  let rowPinned;
  const { pinnedRowModel, rowModel, pageBounds } = beans;
  if (pinnedRowModel?.getPinnedTopRowCount()) {
    rowPinned = "top";
  } else if (rowModel.getRowCount()) {
    rowPinned = null;
    rowIndex = pageBounds.getFirstRow();
  } else if (pinnedRowModel?.getPinnedBottomRowCount()) {
    rowPinned = "bottom";
  }
  return rowPinned === void 0 ? null : { rowIndex, rowPinned };
}
function _getLastRow(beans) {
  let rowIndex;
  let rowPinned = null;
  const { pinnedRowModel, pageBounds } = beans;
  const pinnedBottomCount = pinnedRowModel?.getPinnedBottomRowCount();
  const pinnedTopCount = pinnedRowModel?.getPinnedTopRowCount();
  if (pinnedBottomCount) {
    rowPinned = "bottom";
    rowIndex = pinnedBottomCount - 1;
  } else if (beans.rowModel.getRowCount()) {
    rowPinned = null;
    rowIndex = pageBounds.getLastRow();
  } else if (pinnedTopCount) {
    rowPinned = "top";
    rowIndex = pinnedTopCount - 1;
  }
  return rowIndex === void 0 ? null : { rowIndex, rowPinned };
}
function _getRowNode(beans, gridRow) {
  switch (gridRow.rowPinned) {
    case "top":
      return beans.pinnedRowModel?.getPinnedTopRow(gridRow.rowIndex);
    case "bottom":
      return beans.pinnedRowModel?.getPinnedBottomRow(gridRow.rowIndex);
    default:
      return beans.rowModel.getRow(gridRow.rowIndex);
  }
}
function _getCellByPosition(beans, cellPosition) {
  const spannedCellCtrl = beans.spannedRowRenderer?.getCellByPosition(cellPosition);
  if (spannedCellCtrl) {
    return spannedCellCtrl;
  }
  const rowCtrl = beans.rowRenderer.getRowByPosition(cellPosition);
  if (!rowCtrl) {
    return null;
  }
  return rowCtrl.getCellCtrl(cellPosition.column);
}
function _getRowById(beans, rowId, rowPinned) {
  const { rowModel: rm, pinnedRowModel: prm } = beans;
  let node;
  node ?? (node = rm?.getRowNode(rowId));
  if (rowPinned) {
    node ?? (node = prm?.getPinnedRowById(rowId, rowPinned));
  } else {
    node ?? (node = prm?.getPinnedRowById(rowId, "top"));
    node ?? (node = prm?.getPinnedRowById(rowId, "bottom"));
  }
  return node;
}
function _getRowAbove(beans, rowPosition) {
  const { rowIndex: index, rowPinned: pinned } = rowPosition;
  const { pageBounds, pinnedRowModel, rowModel } = beans;
  if (index === 0) {
    if (pinned === "top") {
      return null;
    }
    if (pinned === "bottom" && rowModel.isRowsToRender()) {
      return { rowIndex: pageBounds.getLastRow(), rowPinned: null };
    }
    return pinnedRowModel?.isRowsToRender("top") ? { rowIndex: pinnedRowModel.getPinnedTopRowCount() - 1, rowPinned: "top" } : null;
  }
  const rowNode = pinned ? void 0 : rowModel.getRow(index);
  return getNextStickyPosition(beans, rowNode, true) ?? { rowIndex: index - 1, rowPinned: pinned };
}
function _getRowBelow(beans, rowPosition) {
  const { rowIndex: index, rowPinned: pinned } = rowPosition;
  const { pageBounds, pinnedRowModel, rowModel } = beans;
  if (isLastRowInContainer(beans, rowPosition)) {
    if (pinned === "bottom") {
      return null;
    }
    if (pinned === "top" && rowModel.isRowsToRender()) {
      return { rowIndex: pageBounds.getFirstRow(), rowPinned: null };
    }
    return pinnedRowModel?.isRowsToRender("bottom") ? { rowIndex: 0, rowPinned: "bottom" } : null;
  }
  const rowNode = pinned ? void 0 : rowModel.getRow(index);
  return getNextStickyPosition(beans, rowNode) ?? { rowIndex: index + 1, rowPinned: pinned };
}
function getNextStickyPosition(beans, rowNode, up = false) {
  const { gos, rowRenderer } = beans;
  if (!rowNode?.sticky || !_isGroupRowsSticky(gos)) {
    return;
  }
  const stickyTopCtrls = rowRenderer.getStickyTopRowCtrls();
  const stickyBottomCtrls = rowRenderer.getStickyBottomRowCtrls();
  const isStickyTop = !stickyBottomCtrls.some((ctrl) => ctrl.rowNode.rowIndex === rowNode.rowIndex);
  const stickyRowCtrls = isStickyTop ? stickyTopCtrls : stickyBottomCtrls;
  const increment = (up ? -1 : 1) * (isStickyTop ? -1 : 1);
  let nextCtrl;
  for (let i = 0; i < stickyRowCtrls.length; i++) {
    if (stickyRowCtrls[i].rowNode.rowIndex === rowNode.rowIndex) {
      nextCtrl = stickyRowCtrls[i + increment];
      break;
    }
  }
  return nextCtrl ? { rowIndex: nextCtrl.rowNode.rowIndex, rowPinned: null } : void 0;
}
function isLastRowInContainer(beans, rowPosition) {
  const { rowPinned, rowIndex } = rowPosition;
  const { pinnedRowModel, pageBounds } = beans;
  if (rowPinned === "top") {
    const lastTopIndex = (pinnedRowModel?.getPinnedTopRowCount() ?? 0) - 1;
    return lastTopIndex <= rowIndex;
  }
  if (rowPinned === "bottom") {
    const lastBottomIndex = (pinnedRowModel?.getPinnedBottomRowCount() ?? 0) - 1;
    return lastBottomIndex <= rowIndex;
  }
  const lastBodyIndex = pageBounds.getLastRow();
  return lastBodyIndex <= rowIndex;
}

// packages/ag-grid-community/src/edit/utils/controllers.ts
function _getRowCtrl(beans, inputs = {}) {
  const { rowIndex, rowId, rowCtrl, rowPinned } = inputs;
  if (rowCtrl) {
    return rowCtrl;
  }
  const { rowModel, rowRenderer } = beans;
  let { rowNode } = inputs;
  if (!rowNode) {
    if (rowId) {
      rowNode = _getRowById(beans, rowId, rowPinned);
    } else if (rowIndex != null) {
      rowNode = rowModel.getRow(rowIndex);
    }
  }
  return rowRenderer.getRowCtrls(rowNode ? [rowNode] : [])?.[0];
}
function _getCellCtrl(beans, inputs = {}) {
  const { cellCtrl, colId, columnId, column } = inputs;
  if (cellCtrl) {
    return cellCtrl;
  }
  const actualColumn = beans.colModel.getCol(colId ?? columnId ?? _getColId(column));
  const rowCtrl = inputs.rowCtrl ?? _getRowCtrl(beans, inputs);
  const result = rowCtrl?.getCellCtrl(actualColumn) ?? void 0;
  if (result) {
    return result;
  }
  const rowNode = inputs.rowNode ?? rowCtrl?.rowNode;
  if (rowNode) {
    return beans.rowRenderer.getCellCtrls([rowNode], [actualColumn])?.[0];
  }
  return void 0;
}
function _stopEditing(beans) {
  const { editSvc } = beans;
  if (editSvc?.isBatchEditing()) {
    _destroyEditors(beans);
  } else {
    editSvc?.stopEditing(void 0, { source: "api" });
  }
}
function _addStopEditingWhenGridLosesFocus(bean, beans, viewports) {
  const { gos, popupSvc } = beans;
  if (!gos.get("stopEditingWhenCellsLoseFocus")) {
    return;
  }
  const focusOutListener = (event) => {
    const elementWithFocus = event.relatedTarget;
    if (_getTabIndex(elementWithFocus) === null) {
      _stopEditing(beans);
      return;
    }
    let clickInsideGrid = (
      // see if click came from inside the viewports
      viewports.some((viewport) => viewport.contains(elementWithFocus)) && // and also that it's not from a detail grid
      _isElementInThisGrid(gos, elementWithFocus)
    );
    if (!clickInsideGrid) {
      clickInsideGrid = !!popupSvc && (popupSvc.getActivePopups().some((popup) => popup.contains(elementWithFocus)) || popupSvc.isElementWithinCustomPopup(elementWithFocus));
    }
    if (!clickInsideGrid) {
      _stopEditing(beans);
    }
  };
  viewports.forEach((viewport) => bean.addManagedElementListeners(viewport, { focusout: focusOutListener }));
}
function _getColId(column) {
  if (!column) {
    return void 0;
  }
  if (typeof column === "string") {
    return column;
  }
  return column.getColId();
}

// packages/ag-grid-community/src/edit/utils/editors.ts
var UNEDITED = Symbol("unedited");
function getCellEditorInstanceMap(beans, params = {}) {
  const res = [];
  const ctrls = beans.rowRenderer.getCellCtrls(params.rowNodes, params.columns);
  for (const ctrl of ctrls) {
    const cellEditor = ctrl.comp?.getCellEditor();
    if (cellEditor) {
      res.push({
        ctrl,
        editor: _unwrapUserComp(cellEditor)
      });
    }
  }
  return res;
}
var getCellEditorInstances = (beans, params = {}) => getCellEditorInstanceMap(beans, params).map((res) => res.editor);
function _setupEditors(beans, editingCells, position, key, event, cellStartedEdit) {
  if (editingCells.length === 0 && position?.rowNode && position?.column) {
    _setupEditor(beans, position, { key, event, cellStartedEdit });
  }
  const { valueSvc, editSvc, editModelSvc } = beans;
  const { rowNode, column } = position ?? {};
  for (const cellPosition of editingCells) {
    const { rowNode: cellRowNode, column: cellColumn } = cellPosition;
    const curCellCtrl = _getCellCtrl(beans, cellPosition);
    if (!curCellCtrl) {
      if (cellRowNode && cellColumn) {
        const oldValue = valueSvc.getValue(cellColumn, cellRowNode, void 0, "api");
        const isNewValueCell = position?.rowNode === cellRowNode && position?.column === cellColumn;
        const cellStartValue = isNewValueCell && key || void 0;
        const newValue = cellStartValue ?? editSvc?.getCellDataValue(cellPosition, false) ?? valueSvc.getValueForDisplay(cellColumn, cellRowNode)?.value ?? oldValue ?? UNEDITED;
        editModelSvc?.setEdit(cellPosition, {
          pendingValue: newValue,
          sourceValue: oldValue,
          state: "editing"
        });
      }
      continue;
    }
    const shouldStartEditing = cellStartedEdit && rowNode === curCellCtrl.rowNode && curCellCtrl.column === column;
    _setupEditor(
      beans,
      { rowNode, column: curCellCtrl.column },
      {
        key: shouldStartEditing ? key : null,
        event: shouldStartEditing ? event : null,
        cellStartedEdit: shouldStartEditing
      }
    );
  }
  return;
}
function _sourceAndPendingDiffer({
  pendingValue,
  sourceValue
}) {
  if (pendingValue === UNEDITED) {
    pendingValue = sourceValue;
  }
  return pendingValue !== sourceValue;
}
function _setupEditor(beans, position, params) {
  const { key, event, cellStartedEdit, silent } = params ?? {};
  const cellCtrl = _getCellCtrl(beans, position);
  const editorComp = cellCtrl?.comp?.getCellEditor();
  const editorParams = _createEditorParams(beans, position, key, cellStartedEdit);
  const previousEdit = beans.editModelSvc?.getEdit(position);
  let newValue = key?.length === 1 ? key : editorParams.value;
  if (newValue === void 0) {
    newValue = previousEdit?.sourceValue;
  }
  beans.editModelSvc?.setEdit(position, {
    editorValue: newValue,
    state: "editing"
  });
  if (editorComp) {
    editorComp.refresh?.(editorParams);
    return;
  }
  const colDef = position.column.getColDef();
  const compDetails = _getCellEditorDetails(beans.userCompFactory, colDef, editorParams);
  const popup = compDetails?.popupFromSelector != null ? compDetails.popupFromSelector : !!colDef.cellEditorPopup;
  const popupLocation = compDetails?.popupPositionFromSelector != null ? compDetails.popupPositionFromSelector : colDef.cellEditorPopupPosition;
  checkAndPreventDefault(compDetails.params, event);
  if (cellCtrl) {
    cellCtrl.editCompDetails = compDetails;
    cellCtrl.comp?.setEditDetails(compDetails, popup, popupLocation, beans.gos.get("reactiveCustomComponents"));
    cellCtrl?.rowCtrl?.refreshRow({ suppressFlash: true });
    if (!silent) {
      beans.editSvc?.dispatchCellEvent(position, event, "cellEditingStarted");
    }
  }
  return;
}
function _valueFromEditor(cellEditor) {
  const noValueResult = { editorValueExists: false };
  const validationErrors = cellEditor.getValidationErrors?.();
  if ((validationErrors?.length ?? 0) > 0) {
    return noValueResult;
  }
  const editorValue = cellEditor.getValue();
  return {
    editorValue,
    editorValueExists: true
  };
}
function _createEditorParams(beans, position, key, cellStartedEdit) {
  const { valueSvc, gos, editSvc } = beans;
  const cellCtrl = _getCellCtrl(beans, position);
  const rowIndex = position.rowNode?.rowIndex ?? void 0;
  const batchEdit = editSvc?.isBatchEditing();
  const agColumn = beans.colModel.getCol(position.column.getId());
  const { rowNode, column } = position;
  const editor = cellCtrl.comp?.getCellEditor();
  const initialNewValue = editSvc?.getCellDataValue(position, false) ?? (editor ? _valueFromEditor(editor)?.editorValue : void 0);
  const value = initialNewValue === UNEDITED ? valueSvc.getValueForDisplay(agColumn, rowNode)?.value : initialNewValue;
  return _addGridCommonParams(gos, {
    value,
    eventKey: key ?? null,
    column,
    colDef: column.getColDef(),
    rowIndex,
    node: rowNode,
    data: rowNode.data,
    cellStartedEdit: cellStartedEdit ?? false,
    onKeyDown: cellCtrl?.onKeyDown.bind(cellCtrl),
    stopEditing: (suppressNavigateAfterEdit) => {
      editSvc.stopEditing(position, { source: batchEdit ? "ui" : "api", suppressNavigateAfterEdit });
      _destroyEditor(beans, position);
    },
    eGridCell: cellCtrl?.eGui,
    parseValue: (newValue) => valueSvc.parseValue(agColumn, rowNode, newValue, cellCtrl?.value),
    formatValue: cellCtrl?.formatValue.bind(cellCtrl),
    validate: () => {
      editSvc?.validateEdit();
    }
  });
}
function _purgeUnchangedEdits(beans, includeEditing) {
  const { editModelSvc } = beans;
  editModelSvc?.getEditMap().forEach((editRow, rowNode) => {
    editRow.forEach((edit, column) => {
      if (!includeEditing && (edit.state === "editing" || edit.pendingValue === UNEDITED)) {
        return;
      }
      if (!_sourceAndPendingDiffer(edit) && (edit.state !== "editing" || includeEditing)) {
        editModelSvc?.removeEdits({ rowNode, column });
      }
    });
  });
}
function _refreshEditorOnColDefChanged(beans, cellCtrl) {
  const editor = cellCtrl.comp?.getCellEditor();
  if (!editor?.refresh) {
    return;
  }
  const { eventKey, cellStartedEdit } = cellCtrl.editCompDetails.params;
  const { column } = cellCtrl;
  const editorParams = _createEditorParams(beans, cellCtrl, eventKey, cellStartedEdit);
  const colDef = column.getColDef();
  const compDetails = _getCellEditorDetails(beans.userCompFactory, colDef, editorParams);
  editor.refresh(checkAndPreventDefault(compDetails.params, eventKey));
}
function checkAndPreventDefault(params, event) {
  if (event instanceof KeyboardEvent && params.column.getColDef().cellEditor === "agNumberCellEditor") {
    params.suppressPreventDefault = ["-", "+", ".", "e"].includes(event?.key ?? "") || params.suppressPreventDefault;
  } else {
    event?.preventDefault?.();
  }
  return params;
}
function _syncFromEditors(beans, persist) {
  beans.editModelSvc?.getEditPositions().forEach((cellId) => {
    const cellCtrl = _getCellCtrl(beans, cellId);
    if (!cellCtrl) {
      return;
    }
    const editor = cellCtrl.comp.getCellEditor();
    if (!editor) {
      return;
    }
    const { editorValue, editorValueExists } = _valueFromEditor(editor);
    _syncFromEditor(beans, cellId, persist, editorValue, void 0, !editorValueExists);
  });
}
function _syncFromEditor(beans, position, persist, editorValue, _source, valueSameAsSource) {
  const { editModelSvc, valueSvc } = beans;
  if (!editModelSvc) {
    return;
  }
  const { rowNode, column } = position;
  if (!(rowNode && column)) {
    return;
  }
  const cellCtrl = _getCellCtrl(beans, position);
  const hasEditor = !!cellCtrl?.comp?.getCellEditor();
  let edit = editModelSvc.getEdit(position, true);
  if (!edit?.sourceValue) {
    edit = editModelSvc.setEdit(position, {
      sourceValue: valueSvc.getValue(column, rowNode, void 0, "api"),
      pendingValue: UNEDITED,
      state: hasEditor ? "editing" : "changed"
    });
  }
  editModelSvc.setEdit(position, {
    editorValue: valueSameAsSource ? edit.sourceValue : editorValue,
    state: hasEditor ? "editing" : "changed"
  });
  if (persist) {
    _persistEditorValue(beans, position);
  }
}
function _persistEditorValue(beans, position) {
  const { editModelSvc } = beans;
  const edit = editModelSvc?.getEdit(position, true);
  editModelSvc?.setEdit(position, {
    pendingValue: edit?.editorValue
  });
}
function _destroyEditors(beans, edits, params) {
  if (!edits) {
    edits = beans.editModelSvc?.getEditPositions();
  }
  edits.forEach((cellPosition) => _destroyEditor(beans, cellPosition, params));
}
function _destroyEditor(beans, position, params) {
  const { editSvc, editModelSvc } = beans;
  const { rowNode, column } = position;
  const cellCtrl = _getCellCtrl(beans, position);
  if (!cellCtrl) {
    if (editModelSvc?.hasEdits(position) && rowNode && column) {
      editModelSvc?.setEdit(position, { state: "changed" });
    }
    return;
  }
  const { comp } = cellCtrl;
  if (comp && !comp.getCellEditor()) {
    return;
  }
  const errorMessages = comp?.getCellEditor()?.getValidationErrors?.();
  const cellValidationModel = editModelSvc?.getCellValidationModel();
  if (errorMessages?.length) {
    cellValidationModel?.setCellValidation(position, { errorMessages });
  } else {
    cellValidationModel?.clearCellValidation(position);
  }
  if (editModelSvc?.getEdit(position)) {
    editModelSvc?.setEdit(position, { state: "changed" });
  }
  comp?.setEditDetails();
  comp?.refreshEditStyles(false, false);
  cellCtrl?.refreshCell({ force: true, suppressFlash: true });
  const latest = editModelSvc?.getEdit(position);
  if (latest?.state === "changed" && !params?.silent) {
    editSvc?.dispatchCellEvent(position, params?.event, "cellEditingStopped", {
      valueChanged: _sourceAndPendingDiffer(latest),
      newValue: latest?.pendingValue,
      oldValue: latest?.sourceValue
    });
  }
}
function _populateModelValidationErrors(beans) {
  const mappedEditors = getCellEditorInstanceMap(beans);
  const cellValidationModel = new EditCellValidationModel();
  const { ariaAnnounce, localeSvc, editModelSvc, gos } = beans;
  const includeRows = gos.get("editType") === "fullRow";
  const translate = _getLocaleTextFunc(localeSvc);
  const ariaValidationErrorPrefix = translate("ariaValidationErrorPrefix", "Cell Editor Validation");
  for (const mappedEditor of mappedEditors) {
    const { ctrl, editor } = mappedEditor;
    const { rowNode, column } = ctrl;
    const errorMessages = editor.getValidationErrors?.() ?? [];
    const el = editor.getValidationElement?.(false) || !editor.isPopup?.() && ctrl.eGui;
    if (el) {
      const isInvalid = errorMessages != null && errorMessages.length > 0;
      const invalidMessage = isInvalid ? errorMessages.join(". ") : "";
      _setAriaInvalid(el, isInvalid);
      if (isInvalid) {
        ariaAnnounce.announceValue(`${ariaValidationErrorPrefix} ${errorMessages}`, "editorValidation");
      }
      if (el instanceof HTMLInputElement) {
        el.setCustomValidity(invalidMessage);
      } else {
        el.classList.toggle("invalid", isInvalid);
      }
    }
    if (errorMessages?.length > 0) {
      cellValidationModel.setCellValidation(
        {
          rowNode,
          column
        },
        {
          errorMessages
        }
      );
    }
  }
  _syncFromEditors(beans, false);
  editModelSvc?.setCellValidationModel(cellValidationModel);
  const rowCtrlSet = /* @__PURE__ */ new Set();
  for (const { ctrl } of mappedEditors) {
    rowCtrlSet.add(ctrl.rowCtrl);
  }
  if (includeRows) {
    const rowValidations = _generateRowValidationErrors(beans);
    editModelSvc?.setRowValidationModel(rowValidations);
  }
  for (const rowCtrl of rowCtrlSet.values()) {
    rowCtrl.rowEditStyleFeature?.applyRowStyles();
    for (const cellCtrl of rowCtrl.getAllCellCtrls()) {
      cellCtrl.tooltipFeature?.refreshTooltip(true);
      cellCtrl.editorTooltipFeature?.refreshTooltip(true);
      cellCtrl.editStyleFeature?.applyCellStyles?.();
    }
  }
}
var _generateRowValidationErrors = (beans) => {
  const rowValidationModel = new EditRowValidationModel();
  const getFullRowEditValidationErrors = beans.gos.get("getFullRowEditValidationErrors");
  const editMap = beans.editModelSvc?.getEditMap();
  if (!editMap) {
    return rowValidationModel;
  }
  for (const rowNode of editMap.keys()) {
    const rowEditMap = editMap.get(rowNode);
    if (!rowEditMap) {
      continue;
    }
    const editorsState = [];
    const { rowIndex, rowPinned } = rowNode;
    for (const column of rowEditMap.keys()) {
      const editValue = rowEditMap.get(column);
      if (!editValue) {
        continue;
      }
      const { editorValue, pendingValue, sourceValue } = editValue;
      const newValue = editorValue ?? (pendingValue === UNEDITED ? void 0 : pendingValue) ?? sourceValue;
      editorsState.push({
        column,
        colId: column.getColId(),
        rowIndex,
        rowPinned,
        oldValue: sourceValue,
        newValue
      });
    }
    const errorMessages = getFullRowEditValidationErrors?.({ editorsState }) ?? [];
    if (errorMessages.length > 0) {
      rowValidationModel.setRowValidation(
        {
          rowNode
        },
        { errorMessages }
      );
    }
  }
  return rowValidationModel;
};
function _validateEdit(beans) {
  _populateModelValidationErrors(beans);
  const map = beans.editModelSvc?.getCellValidationModel().getCellValidationMap();
  if (!map) {
    return null;
  }
  const validations = [];
  map.forEach((rowValidations, rowNode) => {
    rowValidations.forEach(({ errorMessages }, column) => {
      validations.push({
        column,
        rowIndex: rowNode.rowIndex,
        rowPinned: rowNode.rowPinned,
        messages: errorMessages ?? null
      });
    });
  });
  return validations;
}

// packages/ag-grid-community/src/headerRendering/cells/cssClassApplier.ts
var CSS_FIRST_COLUMN = "ag-column-first";
var CSS_LAST_COLUMN = "ag-column-last";
function _getHeaderClassesFromColDef(abstractColDef, gos, column, columnGroup) {
  if (_missing(abstractColDef)) {
    return [];
  }
  return getColumnClassesFromCollDef(abstractColDef.headerClass, abstractColDef, gos, column, columnGroup);
}
function _getToolPanelClassesFromColDef(abstractColDef, gos, column, columnGroup) {
  if (_missing(abstractColDef)) {
    return [];
  }
  return getColumnClassesFromCollDef(abstractColDef.toolPanelClass, abstractColDef, gos, column, columnGroup);
}
function refreshFirstAndLastStyles(comp, column, presentedColsService) {
  comp.toggleCss(CSS_FIRST_COLUMN, presentedColsService.isColAtEdge(column, "first"));
  comp.toggleCss(CSS_LAST_COLUMN, presentedColsService.isColAtEdge(column, "last"));
}
function getClassParams(abstractColDef, gos, column, columnGroup) {
  return _addGridCommonParams(gos, {
    // bad naming, as colDef here can be a group or a column,
    // however most people won't appreciate the difference,
    // so keeping it as colDef to avoid confusion.
    colDef: abstractColDef,
    column,
    columnGroup
  });
}
function getColumnClassesFromCollDef(classesOrFunc, abstractColDef, gos, column, columnGroup) {
  if (_missing(classesOrFunc)) {
    return [];
  }
  let classToUse;
  if (typeof classesOrFunc === "function") {
    const params = getClassParams(abstractColDef, gos, column, columnGroup);
    classToUse = classesOrFunc(params);
  } else {
    classToUse = classesOrFunc;
  }
  if (typeof classToUse === "string") {
    return [classToUse];
  }
  if (Array.isArray(classToUse)) {
    return [...classToUse];
  }
  return [];
}

// packages/ag-grid-community/src/pinnedRowModel/pinnedRowUtils.ts
function _isManualPinnedRow(rowNode) {
  return !!(rowNode.rowPinned && rowNode.pinnedSibling);
}
function _getNodesInRangeForSelection(rowModel, float, start, end) {
  const isTop = float === "top";
  if (!start) {
    return _getNodesInRangeForSelection(
      rowModel,
      float,
      isTop ? rowModel.getPinnedTopRow(0) : rowModel.getPinnedBottomRow(0),
      end
    );
  }
  if (!end) {
    const count = isTop ? rowModel.getPinnedTopRowCount() : rowModel.getPinnedBottomRowCount();
    return _getNodesInRangeForSelection(
      rowModel,
      float,
      start,
      isTop ? rowModel.getPinnedTopRow(count - 1) : rowModel.getPinnedBottomRow(count - 1)
    );
  }
  let started = false;
  let finished = false;
  const range = [];
  rowModel.forEachPinnedRow(float, (node) => {
    if (node === start && !started) {
      started = true;
      range.push(node);
      return;
    }
    if (started && node === end) {
      finished = true;
      range.push(node);
      return;
    }
    if (started && !finished) {
      range.push(node);
    }
  });
  return range;
}

// packages/ag-grid-community/src/constants/keyCode.ts
var KeyCode = {
  BACKSPACE: "Backspace",
  TAB: "Tab",
  ENTER: "Enter",
  ESCAPE: "Escape",
  SPACE: " ",
  LEFT: "ArrowLeft",
  UP: "ArrowUp",
  RIGHT: "ArrowRight",
  DOWN: "ArrowDown",
  DELETE: "Delete",
  F2: "F2",
  PAGE_UP: "PageUp",
  PAGE_DOWN: "PageDown",
  PAGE_HOME: "Home",
  PAGE_END: "End",
  // these should be used with `event.code` instead of `event.key`
  // as `event.key` changes when non-latin keyboards are used
  A: "KeyA",
  C: "KeyC",
  D: "KeyD",
  V: "KeyV",
  X: "KeyX",
  Y: "KeyY",
  Z: "KeyZ"
};

// packages/ag-grid-community/src/utils/focus.ts
var keyboardModeActive = false;
var instanceCount = 0;
function addKeyboardModeEvents(doc) {
  if (instanceCount > 0) {
    return;
  }
  doc.addEventListener("keydown", toggleKeyboardMode);
  doc.addEventListener("mousedown", toggleKeyboardMode);
}
function removeKeyboardModeEvents(doc) {
  if (instanceCount > 0)
    return;
  doc.removeEventListener("keydown", toggleKeyboardMode);
  doc.removeEventListener("mousedown", toggleKeyboardMode);
}
function toggleKeyboardMode(event) {
  const isKeyboardActive = keyboardModeActive;
  const isKeyboardEvent = event.type === "keydown";
  if (isKeyboardEvent) {
    if (event.ctrlKey || event.metaKey || event.altKey) {
      return;
    }
  }
  if (isKeyboardActive === isKeyboardEvent) {
    return;
  }
  keyboardModeActive = isKeyboardEvent;
}
function _registerKeyboardFocusEvents(beans) {
  const eDocument = _getDocument(beans);
  addKeyboardModeEvents(eDocument);
  instanceCount++;
  return () => {
    instanceCount--;
    removeKeyboardModeEvents(eDocument);
  };
}
function _isKeyboardMode() {
  return keyboardModeActive;
}
function _addFocusableContainerListener(beans, comp, eGui) {
  comp.addManagedElementListeners(eGui, {
    keydown: (e) => {
      if (!e.defaultPrevented && e.key === KeyCode.TAB) {
        const backwards = e.shiftKey;
        if (!_findNextFocusableElement(beans, eGui, false, backwards)) {
          if (_focusNextGridCoreContainer(beans, backwards)) {
            e.preventDefault();
          }
        }
      }
    }
  });
}
function _findFocusableElements(rootNode, exclude, onlyUnmanaged = false) {
  const focusableString = FOCUSABLE_SELECTOR;
  let excludeString = FOCUSABLE_EXCLUDE;
  if (exclude) {
    excludeString += ", " + exclude;
  }
  if (onlyUnmanaged) {
    excludeString += ', [tabindex="-1"]';
  }
  const nodes = Array.prototype.slice.apply(rootNode.querySelectorAll(focusableString)).filter((node) => {
    return _isVisible(node);
  });
  const excludeNodes = Array.prototype.slice.apply(rootNode.querySelectorAll(excludeString));
  if (!excludeNodes.length) {
    return nodes;
  }
  const diff = (a, b) => a.filter((element) => b.indexOf(element) === -1);
  return diff(nodes, excludeNodes);
}
function _focusInto(rootNode, up = false, onlyUnmanaged = false, excludeTabGuards = false) {
  const focusableElements = _findFocusableElements(
    rootNode,
    excludeTabGuards ? ".ag-tab-guard" : null,
    onlyUnmanaged
  );
  const toFocus = up ? _last(focusableElements) : focusableElements[0];
  if (toFocus) {
    toFocus.focus({ preventScroll: true });
    return true;
  }
  return false;
}
function _findNextFocusableElement(beans, rootNode, onlyManaged, backwards) {
  const focusable = _findFocusableElements(rootNode, onlyManaged ? ':not([tabindex="-1"])' : null);
  const activeEl = _getActiveDomElement(beans);
  let currentIndex;
  if (onlyManaged) {
    currentIndex = focusable.findIndex((el) => el.contains(activeEl));
  } else {
    currentIndex = focusable.indexOf(activeEl);
  }
  const nextIndex = currentIndex + (backwards ? -1 : 1);
  if (nextIndex < 0 || nextIndex >= focusable.length) {
    return null;
  }
  return focusable[nextIndex];
}
function _findTabbableParent(node, limit = 5) {
  let counter = 0;
  while (node && _getTabIndex(node) === null && ++counter <= limit) {
    node = node.parentElement;
  }
  if (_getTabIndex(node) === null) {
    return null;
  }
  return node;
}
function _focusGridInnerElement(beans, fromBottom) {
  return beans.ctrlsSvc.get("gridCtrl").focusInnerElement(fromBottom);
}
function _isHeaderFocusSuppressed(beans) {
  return beans.gos.get("suppressHeaderFocus") || !!beans.overlays?.isExclusive();
}
function _isCellFocusSuppressed(beans) {
  return beans.gos.get("suppressCellFocus") || !!beans.overlays?.isExclusive();
}
function _focusNextGridCoreContainer(beans, backwards, forceOut = false) {
  const gridCtrl = beans.ctrlsSvc.get("gridCtrl");
  if (!forceOut && gridCtrl.focusNextInnerContainer(backwards)) {
    return true;
  }
  if (forceOut || !backwards && !gridCtrl.isDetailGrid()) {
    gridCtrl.forceFocusOutOfContainer(backwards);
  }
  return false;
}

// packages/ag-grid-community/src/rendering/cell/cellEvent.ts
function _createCellEvent(beans, domEvent, eventType, { rowNode, column }, value) {
  const event = _addGridCommonParams(beans.gos, {
    type: eventType,
    node: rowNode,
    data: rowNode.data,
    value,
    column,
    colDef: column.getColDef(),
    rowPinned: rowNode.rowPinned,
    event: domEvent,
    rowIndex: rowNode.rowIndex
  });
  return event;
}

// packages/ag-grid-community/src/rendering/cell/cellKeyboardListenerFeature.ts
function _isDeleteKey(key, alwaysReturnFalseOnBackspace = false) {
  if (key === KeyCode.DELETE) {
    return true;
  }
  if (!alwaysReturnFalseOnBackspace && key === KeyCode.BACKSPACE) {
    return _isMacOsUserAgent();
  }
  return false;
}
var CellKeyboardListenerFeature = class extends BeanStub {
  constructor(cellCtrl, beans, rowNode, rowCtrl) {
    super();
    this.cellCtrl = cellCtrl;
    this.rowNode = rowNode;
    this.rowCtrl = rowCtrl;
    this.beans = beans;
  }
  init() {
    this.eGui = this.cellCtrl.eGui;
  }
  onKeyDown(event) {
    const key = event.key;
    switch (key) {
      case KeyCode.ENTER:
        this.onEnterKeyDown(event);
        break;
      case KeyCode.F2:
        this.onF2KeyDown(event);
        break;
      case KeyCode.ESCAPE:
        this.onEscapeKeyDown(event);
        break;
      case KeyCode.TAB:
        this.onTabKeyDown(event);
        break;
      case KeyCode.BACKSPACE:
      case KeyCode.DELETE:
        this.onBackspaceOrDeleteKeyDown(key, event);
        break;
      case KeyCode.DOWN:
      case KeyCode.UP:
      case KeyCode.RIGHT:
      case KeyCode.LEFT:
        this.onNavigationKeyDown(event, key);
        break;
    }
  }
  onNavigationKeyDown(event, key) {
    const { cellCtrl, beans } = this;
    if (beans.editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      return;
    }
    if (event.shiftKey && cellCtrl.isRangeSelectionEnabled()) {
      this.onShiftRangeSelect(event);
    } else {
      const currentCellPosition = cellCtrl.getFocusedCellPosition();
      beans.navigation?.navigateToNextCell(event, key, currentCellPosition, true);
    }
    event.preventDefault();
  }
  onShiftRangeSelect(event) {
    const { rangeSvc, navigation } = this.beans;
    if (!rangeSvc) {
      return;
    }
    const endCell = rangeSvc.extendLatestRangeInDirection(event);
    if (!endCell) {
      return;
    }
    if (event.key === KeyCode.LEFT || event.key === KeyCode.RIGHT) {
      navigation?.ensureColumnVisible(endCell.column);
    } else {
      navigation?.ensureRowVisible(endCell.rowIndex);
    }
  }
  onTabKeyDown(event) {
    this.beans.navigation?.onTabKeyDown(this.cellCtrl, event);
  }
  onBackspaceOrDeleteKeyDown(key, event) {
    const { cellCtrl, beans, rowNode } = this;
    const { gos, rangeSvc, eventSvc, editSvc } = beans;
    eventSvc.dispatchEvent({ type: "keyShortcutChangedCellStart" });
    if (_isDeleteKey(key, gos.get("enableCellEditingOnBackspace")) && !editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      if (rangeSvc && _isCellSelectionEnabled(gos)) {
        rangeSvc.clearCellRangeCellValues({ dispatchWrapperEvents: true, wrapperEventSource: "deleteKey" });
      } else if (cellCtrl.isCellEditable()) {
        const { column } = cellCtrl;
        const emptyValue = this.beans.valueSvc.getDeleteValue(column, rowNode);
        rowNode.setDataValue(column, emptyValue, "cellClear");
      }
    } else if (!editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      beans.editSvc?.startEditing(cellCtrl, { startedEdit: true, event });
    }
    eventSvc.dispatchEvent({ type: "keyShortcutChangedCellEnd" });
  }
  onEnterKeyDown(event) {
    const { cellCtrl, beans } = this;
    const { editSvc, navigation } = beans;
    const cellEditing = editSvc?.isEditing(cellCtrl);
    const rowNode = cellCtrl.rowNode;
    const rowEditing = editSvc?.isRowEditing(rowNode);
    const startEditingAction = (cellCtrl2) => {
      const started = editSvc?.startEditing(cellCtrl2, {
        startedEdit: true,
        event
      });
      if (started) {
        event.preventDefault();
      }
    };
    if (cellEditing || rowEditing) {
      if (this.isCtrlEnter(event)) {
        editSvc?.applyBulkEdit(cellCtrl, beans?.rangeSvc?.getCellRanges() || []);
        return;
      }
      _populateModelValidationErrors(beans);
      if (editSvc?.checkNavWithValidation(void 0, event) === "block-stop") {
        return;
      }
      if (editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
        editSvc?.stopEditing(cellCtrl, {
          event
        });
      } else if (rowEditing && !cellCtrl.isCellEditable()) {
        editSvc?.stopEditing({ rowNode }, { event });
      } else {
        startEditingAction(cellCtrl);
      }
    } else {
      if (beans.gos.get("enterNavigatesVertically")) {
        const key = event.shiftKey ? KeyCode.UP : KeyCode.DOWN;
        navigation?.navigateToNextCell(null, key, cellCtrl.cellPosition, false);
      } else {
        if (editSvc?.hasValidationErrors()) {
          return;
        }
        if (editSvc?.hasValidationErrors(cellCtrl)) {
          editSvc.revertSingleCellEdit(cellCtrl, true);
        }
        startEditingAction(cellCtrl);
      }
    }
  }
  isCtrlEnter(e) {
    return (e.ctrlKey || e.metaKey) && e.key === KeyCode.ENTER;
  }
  onF2KeyDown(event) {
    const {
      cellCtrl,
      beans: { editSvc }
    } = this;
    const editing = editSvc?.isEditing();
    if (editing) {
      _populateModelValidationErrors(this.beans);
      if (editSvc?.checkNavWithValidation(void 0, event) === "block-stop") {
        return;
      }
    }
    editSvc?.startEditing(cellCtrl, { startedEdit: true, event });
  }
  onEscapeKeyDown(event) {
    const {
      cellCtrl,
      beans: { editSvc }
    } = this;
    if (editSvc?.checkNavWithValidation(cellCtrl, event) === "block-stop") {
      editSvc.revertSingleCellEdit(cellCtrl);
    }
    editSvc?.stopEditing(cellCtrl, {
      event,
      cancel: true
    });
  }
  processCharacter(event) {
    const eventTarget = event.target;
    const eventOnChildComponent = eventTarget !== this.eGui;
    const {
      beans: { editSvc },
      cellCtrl
    } = this;
    if (eventOnChildComponent) {
      return;
    }
    if (editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      return;
    }
    const key = event.key;
    if (key === KeyCode.SPACE) {
      this.onSpaceKeyDown(event);
    } else if (editSvc?.isCellEditable(cellCtrl, "ui")) {
      if (editSvc?.hasValidationErrors() && !editSvc?.hasValidationErrors(cellCtrl)) {
        return;
      }
      editSvc?.startEditing(cellCtrl, { startedEdit: true, event, source: "api" });
      const compDetails = cellCtrl.editCompDetails;
      const shouldPreventDefault = !compDetails?.params?.suppressPreventDefault;
      if (shouldPreventDefault) {
        event.preventDefault();
      }
    }
  }
  onSpaceKeyDown(event) {
    const { gos, editSvc } = this.beans;
    const { rowNode } = this.cellCtrl;
    if (!editSvc?.isEditing(this.cellCtrl, { withOpenEditor: true }) && _isRowSelection(gos)) {
      this.beans.selectionSvc?.handleSelectionEvent(event, rowNode, "spaceKey");
    }
    event.preventDefault();
  }
};

// packages/ag-grid-community/src/utils/mouse.ts
function _areEventsNear(e1, e2, pixelCount) {
  if (pixelCount === 0) {
    return false;
  }
  const diffX = Math.abs(e1.clientX - e2.clientX);
  const diffY = Math.abs(e1.clientY - e2.clientY);
  return Math.max(diffX, diffY) <= pixelCount;
}
function _interpretAsRightClick({ gos }, event) {
  return event.button === 2 || event.ctrlKey && gos.get("allowContextMenuWithControlKey");
}

// packages/ag-grid-community/src/rendering/cell/cellMouseListenerFeature.ts
var CellMouseListenerFeature = class extends BeanStub {
  constructor(cellCtrl, beans, column) {
    super();
    this.cellCtrl = cellCtrl;
    this.column = column;
    this.beans = beans;
  }
  onMouseEvent(eventName, mouseEvent) {
    if (_isStopPropagationForAgGrid(mouseEvent)) {
      return;
    }
    switch (eventName) {
      case "click":
        this.onCellClicked(mouseEvent);
        break;
      case "mousedown":
      case "touchstart":
        this.onMouseDown(mouseEvent);
        break;
      case "dblclick":
        this.onCellDoubleClicked(mouseEvent);
        break;
      case "mouseout":
        this.onMouseOut(mouseEvent);
        break;
      case "mouseover":
        this.onMouseOver(mouseEvent);
        break;
    }
  }
  onCellClicked(event) {
    if (this.beans.touchSvc?.handleCellDoubleClick(this, event)) {
      return;
    }
    const { eventSvc, rangeSvc, editSvc, editModelSvc, frameworkOverrides } = this.beans;
    const isMultiKey = event.ctrlKey || event.metaKey;
    const { cellCtrl } = this;
    const { column, cellPosition } = cellCtrl;
    if (rangeSvc && isMultiKey) {
      if (rangeSvc.getCellRangeCount(cellPosition) > 1) {
        rangeSvc.intersectLastRange(true);
      }
    }
    const cellClickedEvent = cellCtrl.createEvent(event, "cellClicked");
    eventSvc.dispatchEvent(cellClickedEvent);
    const colDef = column.getColDef();
    if (colDef.onCellClicked) {
      window.setTimeout(() => {
        frameworkOverrides.wrapOutgoing(() => {
          colDef.onCellClicked(cellClickedEvent);
        });
      }, 0);
    }
    if (editModelSvc?.getState(cellCtrl) !== "editing") {
      const editing = editSvc?.isEditing();
      const cellValidations = editModelSvc?.getCellValidationModel().getCellValidationMap().size ?? 0;
      const rowValidations = editModelSvc?.getRowValidationModel().getRowValidationMap().size ?? 0;
      if (editing && (cellValidations > 0 || rowValidations > 0)) {
        return;
      }
      if (editSvc?.shouldStartEditing(cellCtrl, event)) {
        editSvc?.startEditing(cellCtrl, { event });
      } else if (editSvc?.shouldStopEditing(cellCtrl, event)) {
        editSvc?.stopEditing(cellCtrl);
      }
    }
  }
  onCellDoubleClicked(event) {
    const { column, beans, cellCtrl } = this;
    const { eventSvc, frameworkOverrides, editSvc, editModelSvc } = beans;
    const colDef = column.getColDef();
    const cellDoubleClickedEvent = cellCtrl.createEvent(event, "cellDoubleClicked");
    eventSvc.dispatchEvent(cellDoubleClickedEvent);
    if (typeof colDef.onCellDoubleClicked === "function") {
      window.setTimeout(() => {
        frameworkOverrides.wrapOutgoing(() => {
          colDef.onCellDoubleClicked(cellDoubleClickedEvent);
        });
      }, 0);
    }
    if (editSvc?.shouldStartEditing(this.cellCtrl, event) && this.beans.editModelSvc?.getState(this.cellCtrl) !== "editing") {
      const editing = editSvc?.isEditing();
      const cellValidations = editModelSvc?.getCellValidationModel().getCellValidationMap().size ?? 0;
      const rowValidations = editModelSvc?.getRowValidationModel().getRowValidationMap().size ?? 0;
      if (editing && (cellValidations > 0 || rowValidations > 0)) {
        return;
      }
      editSvc?.startEditing(cellCtrl, { event });
    }
  }
  onMouseDown(mouseEvent) {
    const { ctrlKey, metaKey, shiftKey } = mouseEvent;
    const target = mouseEvent.target;
    const { cellCtrl, beans } = this;
    const { eventSvc, rangeSvc, rowNumbersSvc, focusSvc, gos, editSvc } = beans;
    if (this.isRightClickInExistingRange(mouseEvent)) {
      return;
    }
    const hasRanges = rangeSvc && !rangeSvc.isEmpty();
    const containsWidget = this.containsWidget(target);
    const { cellPosition, column } = cellCtrl;
    const isRowNumberColumn = isRowNumberCol(column);
    if (rowNumbersSvc && isRowNumberColumn && !rowNumbersSvc.handleMouseDownOnCell(cellPosition, mouseEvent)) {
      if (rangeSvc) {
        mouseEvent.preventDefault();
      }
      mouseEvent.stopImmediatePropagation();
      return;
    }
    if (!shiftKey || !hasRanges) {
      const editing = editSvc?.isEditing(cellCtrl);
      const isEnableCellTextSelection = gos.get("enableCellTextSelection");
      const shouldFocus = isEnableCellTextSelection && mouseEvent.defaultPrevented;
      const forceBrowserFocus = (_isBrowserSafari() || shouldFocus) && !editing && !_isFocusableFormField(target) && !containsWidget;
      cellCtrl.focusCell(forceBrowserFocus, mouseEvent);
    }
    if (shiftKey && hasRanges && !focusSvc.isCellFocused(cellPosition)) {
      mouseEvent.preventDefault();
      const focusedCell = focusSvc.getFocusedCell();
      if (focusedCell) {
        const { column: column2, rowIndex, rowPinned } = focusedCell;
        if (editSvc?.isEditing(focusedCell)) {
          editSvc?.stopEditing(focusedCell);
        }
        focusSvc.setFocusedCell({
          column: column2,
          rowIndex,
          rowPinned,
          forceBrowserFocus: true,
          preventScrollOnBrowserFocus: true,
          sourceEvent: mouseEvent
        });
      }
    }
    if (containsWidget) {
      return;
    }
    if (rangeSvc) {
      if (isRowNumberColumn) {
        mouseEvent.preventDefault();
      }
      const hasRightClickedOnRowNumber = _interpretAsRightClick(this.beans, mouseEvent) && isRowNumberColumn;
      if (shiftKey) {
        rangeSvc.extendLatestRangeToCell(cellPosition);
      } else if (!hasRightClickedOnRowNumber) {
        const isMultiKey = ctrlKey || metaKey;
        rangeSvc.setRangeToCell(cellPosition, isMultiKey);
      }
    }
    eventSvc.dispatchEvent(this.cellCtrl.createEvent(mouseEvent, "cellMouseDown"));
  }
  isRightClickInExistingRange(mouseEvent) {
    const { rangeSvc } = this.beans;
    if (rangeSvc) {
      const cellInRange = rangeSvc.isCellInAnyRange(this.cellCtrl.cellPosition);
      const isRightClick = _interpretAsRightClick(this.beans, mouseEvent);
      if (cellInRange && isRightClick) {
        return true;
      }
    }
    return false;
  }
  containsWidget(target) {
    return _isElementChildOfClass(target, "ag-selection-checkbox", 3) || _isElementChildOfClass(target, "ag-drag-handle", 3);
  }
  onMouseOut(mouseEvent) {
    if (this.mouseStayingInsideCell(mouseEvent)) {
      return;
    }
    const { eventSvc, colHover } = this.beans;
    eventSvc.dispatchEvent(this.cellCtrl.createEvent(mouseEvent, "cellMouseOut"));
    colHover?.clearMouseOver();
  }
  onMouseOver(mouseEvent) {
    if (this.mouseStayingInsideCell(mouseEvent)) {
      return;
    }
    const { eventSvc, colHover } = this.beans;
    eventSvc.dispatchEvent(this.cellCtrl.createEvent(mouseEvent, "cellMouseOver"));
    colHover?.setMouseOver([this.column]);
  }
  mouseStayingInsideCell(e) {
    if (!e.target || !e.relatedTarget) {
      return false;
    }
    const eCell = this.cellCtrl.eGui;
    const cellContainsTarget = eCell.contains(e.target);
    const cellContainsRelatedTarget = eCell.contains(e.relatedTarget);
    return cellContainsTarget && cellContainsRelatedTarget;
  }
};

// packages/ag-grid-community/src/rendering/cell/cellPositionFeature.ts
var CellPositionFeature = class extends BeanStub {
  constructor(cellCtrl, beans) {
    super();
    this.cellCtrl = cellCtrl;
    this.beans = beans;
    this.column = cellCtrl.column;
    this.rowNode = cellCtrl.rowNode;
  }
  setupRowSpan() {
    this.rowSpan = this.column.getRowSpan(this.rowNode);
    this.addManagedListeners(this.beans.eventSvc, { newColumnsLoaded: () => this.onNewColumnsLoaded() });
  }
  init() {
    this.eSetLeft = this.cellCtrl.getRootElement();
    this.eContent = this.cellCtrl.eGui;
    const cellSpan = this.cellCtrl.getCellSpan();
    if (!cellSpan) {
      this.setupColSpan();
      this.setupRowSpan();
    }
    this.onLeftChanged();
    this.onWidthChanged();
    if (!cellSpan) {
      this._legacyApplyRowSpan();
    }
    if (cellSpan) {
      const refreshSpanHeight = this.refreshSpanHeight.bind(this, cellSpan);
      refreshSpanHeight();
      this.addManagedListeners(this.beans.eventSvc, {
        paginationChanged: refreshSpanHeight,
        recalculateRowBounds: refreshSpanHeight,
        pinnedHeightChanged: refreshSpanHeight
      });
    }
  }
  refreshSpanHeight(cellSpan) {
    const spanHeight = cellSpan.getCellHeight();
    if (spanHeight != null) {
      this.eContent.style.height = `${spanHeight}px`;
    }
  }
  onNewColumnsLoaded() {
    const rowSpan = this.column.getRowSpan(this.rowNode);
    if (this.rowSpan === rowSpan) {
      return;
    }
    this.rowSpan = rowSpan;
    this._legacyApplyRowSpan(true);
  }
  onDisplayColumnsChanged() {
    const colsSpanning = this.getColSpanningList();
    if (!_areEqual(this.colsSpanning, colsSpanning)) {
      this.colsSpanning = colsSpanning;
      this.onWidthChanged();
      this.onLeftChanged();
    }
  }
  setupColSpan() {
    if (this.column.getColDef().colSpan == null) {
      return;
    }
    this.colsSpanning = this.getColSpanningList();
    this.addManagedListeners(this.beans.eventSvc, {
      // because we are col spanning, a reorder of the cols can change what cols we are spanning over
      displayedColumnsChanged: this.onDisplayColumnsChanged.bind(this),
      // because we are spanning over multiple cols, we check for width any time any cols width changes.
      // this is expensive - really we should be explicitly checking only the cols we are spanning over
      // instead of every col, however it would be tricky code to track the cols we are spanning over, so
      // because hardly anyone will be using colSpan, am favouring this easier way for more maintainable code.
      displayedColumnsWidthChanged: this.onWidthChanged.bind(this)
    });
  }
  onWidthChanged() {
    if (!this.eContent) {
      return;
    }
    const width = this.getCellWidth();
    this.eContent.style.width = `${width}px`;
  }
  getCellWidth() {
    if (!this.colsSpanning) {
      return this.column.getActualWidth();
    }
    return this.colsSpanning.reduce((width, col) => width + col.getActualWidth(), 0);
  }
  getColSpanningList() {
    const { column, rowNode } = this;
    const colSpan = column.getColSpan(rowNode);
    const colsSpanning = [];
    if (colSpan === 1) {
      colsSpanning.push(column);
    } else {
      let pointer = column;
      const pinned = column.getPinned();
      for (let i = 0; pointer && i < colSpan; i++) {
        colsSpanning.push(pointer);
        pointer = this.beans.visibleCols.getColAfter(pointer);
        if (!pointer || _missing(pointer)) {
          break;
        }
        if (pinned !== pointer.getPinned()) {
          break;
        }
      }
    }
    return colsSpanning;
  }
  onLeftChanged() {
    if (!this.eSetLeft) {
      return;
    }
    const left = this.modifyLeftForPrintLayout(this.getCellLeft());
    this.eSetLeft.style.left = left + "px";
  }
  getCellLeft() {
    let mostLeftCol;
    if (this.beans.gos.get("enableRtl") && this.colsSpanning) {
      mostLeftCol = _last(this.colsSpanning);
    } else {
      mostLeftCol = this.column;
    }
    return mostLeftCol.getLeft();
  }
  modifyLeftForPrintLayout(leftPosition) {
    if (!this.cellCtrl.printLayout || this.column.getPinned() === "left") {
      return leftPosition;
    }
    const { visibleCols } = this.beans;
    const leftWidth = visibleCols.getColsLeftWidth();
    if (this.column.getPinned() === "right") {
      const bodyWidth = visibleCols.bodyWidth;
      return leftWidth + bodyWidth + (leftPosition || 0);
    }
    return leftWidth + (leftPosition || 0);
  }
  _legacyApplyRowSpan(force) {
    if (this.rowSpan === 1 && !force) {
      return;
    }
    const singleRowHeight = _getRowHeightAsNumber(this.beans);
    const totalRowHeight = singleRowHeight * this.rowSpan;
    this.eContent.style.height = `${totalRowHeight}px`;
    this.eContent.style.zIndex = "1";
  }
  // overriding to make public, as we don't dispose this bean via context
  destroy() {
    super.destroy();
  }
};

// packages/ag-grid-community/src/rendering/cell/cellCtrl.ts
var CSS_CELL = "ag-cell";
var CSS_AUTO_HEIGHT = "ag-cell-auto-height";
var CSS_NORMAL_HEIGHT = "ag-cell-normal-height";
var CSS_CELL_FOCUS = "ag-cell-focus";
var CSS_CELL_FIRST_RIGHT_PINNED = "ag-cell-first-right-pinned";
var CSS_CELL_LAST_LEFT_PINNED = "ag-cell-last-left-pinned";
var CSS_CELL_NOT_INLINE_EDITING = "ag-cell-not-inline-editing";
var CSS_CELL_WRAP_TEXT = "ag-cell-wrap-text";
var DOM_DATA_KEY_CELL_CTRL = "cellCtrl";
function _getCellCtrlForEventTarget(gos, eventTarget) {
  return _getCtrlForEventTarget(gos, eventTarget, DOM_DATA_KEY_CELL_CTRL);
}
var instanceIdSequence2 = 0;
var CellCtrl = class extends BeanStub {
  constructor(column, rowNode, beans, rowCtrl) {
    super();
    this.column = column;
    this.rowNode = rowNode;
    this.rowCtrl = rowCtrl;
    this.rangeFeature = void 0;
    this.rowResizeFeature = void 0;
    this.positionFeature = void 0;
    this.customStyleFeature = void 0;
    this.editStyleFeature = void 0;
    this.mouseListener = void 0;
    this.keyboardListener = void 0;
    this.suppressRefreshCell = false;
    this.onCompAttachedFuncs = [];
    this.onEditorAttachedFuncs = [];
    this.focusEventWhileNotReady = null;
    // if cell has been focused, check if it's focused when destroyed
    this.hasBeenFocused = false;
    this.hasEdit = false;
    this.tooltipFeature = void 0;
    this.editorTooltipFeature = void 0;
    this.beans = beans;
    this.gos = beans.gos;
    this.editSvc = beans.editSvc;
    this.hasEdit = !!beans.editSvc;
    const { colId } = column;
    this.instanceId = colId + "-" + instanceIdSequence2++;
    this.createCellPosition();
    this.updateAndFormatValue(false);
  }
  addFeatures() {
    const { beans } = this;
    this.positionFeature = new CellPositionFeature(this, beans);
    this.customStyleFeature = beans.cellStyles?.createCellCustomStyleFeature(this, beans);
    this.editStyleFeature = beans.editSvc?.createCellStyleFeature(this, beans);
    this.mouseListener = new CellMouseListenerFeature(this, beans, this.column);
    this.keyboardListener = new CellKeyboardListenerFeature(this, beans, this.rowNode, this.rowCtrl);
    this.enableTooltipFeature();
    const { rangeSvc } = beans;
    const cellSelectionEnabled = rangeSvc && _isCellSelectionEnabled(beans.gos);
    if (cellSelectionEnabled) {
      this.rangeFeature = rangeSvc.createCellRangeFeature(beans, this);
    }
    if (isRowNumberCol(this.column)) {
      this.rowResizeFeature = this.beans.rowNumbersSvc.createRowNumbersRowResizerFeature(beans, this);
    }
  }
  isCellSpanning() {
    return false;
  }
  getCellSpan() {
    return void 0;
  }
  removeFeatures() {
    const context = this.beans.context;
    this.positionFeature = context.destroyBean(this.positionFeature);
    this.editorTooltipFeature = context.destroyBean(this.editorTooltipFeature);
    this.customStyleFeature = context.destroyBean(this.customStyleFeature);
    this.editStyleFeature = context.destroyBean(this.editStyleFeature);
    this.mouseListener = context.destroyBean(this.mouseListener);
    this.keyboardListener = context.destroyBean(this.keyboardListener);
    this.rangeFeature = context.destroyBean(this.rangeFeature);
    this.rowResizeFeature = context.destroyBean(this.rowResizeFeature);
    this.disableTooltipFeature();
  }
  enableTooltipFeature(value, shouldDisplayTooltip) {
    this.tooltipFeature = this.beans.tooltipSvc?.enableCellTooltipFeature(this, value, shouldDisplayTooltip);
  }
  disableTooltipFeature() {
    this.tooltipFeature = this.beans.context.destroyBean(this.tooltipFeature);
  }
  enableEditorTooltipFeature(editor) {
    if (this.editorTooltipFeature) {
      this.disableEditorTooltipFeature();
    }
    this.editorTooltipFeature = this.beans.tooltipSvc?.setupCellEditorTooltip(this, editor);
    _populateModelValidationErrors(this.beans);
  }
  disableEditorTooltipFeature() {
    this.editorTooltipFeature = this.beans.context.destroyBean(this.editorTooltipFeature);
  }
  setComp(comp, eCell, _eWrapper, eCellWrapper, printLayout, startEditing, compBean) {
    this.comp = comp;
    this.eGui = eCell;
    this.printLayout = printLayout;
    compBean ?? (compBean = this);
    this.addDomData(compBean);
    this.addFeatures();
    compBean.addDestroyFunc(() => this.removeFeatures());
    this.onSuppressCellFocusChanged(this.beans.gos.get("suppressCellFocus"));
    this.setupFocus();
    this.applyStaticCssClasses();
    this.setWrapText();
    this.onFirstRightPinnedChanged();
    this.onLastLeftPinnedChanged();
    this.onColumnHover();
    this.setupControlComps();
    this.setupAutoHeight(eCellWrapper, compBean);
    this.refreshFirstAndLastStyles();
    this.refreshAriaColIndex();
    this.positionFeature?.init();
    this.customStyleFeature?.setComp(comp);
    this.editStyleFeature?.setComp(comp);
    this.tooltipFeature?.refreshTooltip();
    this.keyboardListener?.init();
    this.rangeFeature?.setComp(comp);
    this.rowResizeFeature?.refreshRowResizer();
    if (startEditing && this.isCellEditable()) {
      this.editSvc?.startEditing(this, { startedEdit: true, source: "api" });
    } else {
      this.showValue(false, true);
    }
    if (this.onCompAttachedFuncs.length) {
      this.onCompAttachedFuncs.forEach((func) => func());
      this.onCompAttachedFuncs = [];
    }
  }
  setupAutoHeight(eCellWrapper, compBean) {
    this.isAutoHeight = this.beans.rowAutoHeight?.setupCellAutoHeight(this, eCellWrapper, compBean) ?? false;
  }
  getCellAriaRole() {
    return this.column.getColDef().cellAriaRole ?? "gridcell";
  }
  isCellRenderer() {
    const colDef = this.column.getColDef();
    return colDef.cellRenderer != null || colDef.cellRendererSelector != null;
  }
  getValueToDisplay() {
    return this.valueFormatted ?? this.value;
  }
  getDeferLoadingCellRenderer() {
    const { beans, column } = this;
    const { userCompFactory, ctrlsSvc, eventSvc } = beans;
    const colDef = column.getColDef();
    const params = this.createCellRendererParams();
    params.deferRender = true;
    const loadingDetails = _getLoadingCellRendererDetails(userCompFactory, colDef, params);
    if (ctrlsSvc.getGridBodyCtrl()?.scrollFeature?.isScrolling()) {
      let resolver;
      const onReady = new AgPromise((resolve) => {
        resolver = resolve;
      });
      this.addManagedListeners(eventSvc, {
        bodyScrollEnd: () => resolver()
      });
      return { loadingComp: loadingDetails, onReady };
    }
    return { loadingComp: loadingDetails, onReady: AgPromise.resolve() };
  }
  showValue(forceNewCellRendererInstance, skipRangeHandleRefresh) {
    const { beans, column, rowNode, rangeFeature } = this;
    const { userCompFactory } = beans;
    let valueToDisplay = this.getValueToDisplay();
    let compDetails;
    const isSsrmLoading = rowNode.stub && rowNode.groupData?.[column.getId()] == null;
    const colDef = column.getColDef();
    if (isSsrmLoading || this.isCellRenderer()) {
      const params = this.createCellRendererParams();
      if (!isSsrmLoading || isRowNumberCol(column)) {
        compDetails = _getCellRendererDetails(userCompFactory, colDef, params);
      } else {
        compDetails = _getLoadingCellRendererDetails(userCompFactory, colDef, params);
      }
    }
    if (!compDetails && !isSsrmLoading && beans.findSvc?.isMatch(rowNode, column)) {
      const params = this.createCellRendererParams();
      compDetails = _getCellRendererDetails(
        userCompFactory,
        { ...column.getColDef(), cellRenderer: "agFindCellRenderer" },
        params
      );
    }
    if (this.hasEdit && this.editSvc.isBatchEditing() && this.editSvc.isRowEditing(rowNode, { checkSiblings: true })) {
      const result = this.editSvc.prepDetailsDuringBatch(this, { compDetails, valueToDisplay });
      if (result) {
        if (result.compDetails) {
          compDetails = result.compDetails;
        } else if (result.valueToDisplay) {
          valueToDisplay = result.valueToDisplay;
        }
      }
    }
    this.comp.setRenderDetails(compDetails, valueToDisplay, forceNewCellRendererInstance);
    if (!skipRangeHandleRefresh && rangeFeature) {
      _requestAnimationFrame(beans, () => rangeFeature?.refreshHandle());
    }
    this.rowResizeFeature?.refreshRowResizer();
  }
  setupControlComps() {
    const colDef = this.column.getColDef();
    this.includeSelection = this.isIncludeControl(this.isCheckboxSelection(colDef), true);
    this.includeRowDrag = this.isIncludeControl(colDef.rowDrag);
    this.includeDndSource = this.isIncludeControl(colDef.dndSource);
    this.comp.setIncludeSelection(this.includeSelection);
    this.comp.setIncludeDndSource(this.includeDndSource);
    this.comp.setIncludeRowDrag(this.includeRowDrag);
  }
  isForceWrapper() {
    return this.beans.gos.get("enableCellTextSelection") || this.column.isAutoHeight();
  }
  /**
   * Wrapper providing general conditions under which control elements (e.g. checkboxes and drag handles)
   * are rendered for a particular cell.
   * @param value Whether to render the control in the specific context of the caller
   * @param allowManuallyPinned Whether manually pinned rows are permitted this form of control element
   */
  // eslint-disable-next-line @typescript-eslint/ban-types
  isIncludeControl(value, allowManuallyPinned = false) {
    const rowUnpinned = this.rowNode.rowPinned == null;
    return (rowUnpinned || allowManuallyPinned && _isManualPinnedRow(this.rowNode)) && !!value;
  }
  isCheckboxSelection(colDef) {
    const { rowSelection, groupDisplayType } = this.beans.gridOptions;
    const checkboxLocation = _getCheckboxLocation(rowSelection);
    const isSelectionColumn = isColumnSelectionCol(this.column);
    if (groupDisplayType === "custom" && checkboxLocation !== "selectionColumn" && isSelectionColumn) {
      return false;
    }
    return colDef.checkboxSelection || isSelectionColumn && typeof rowSelection === "object" && _getCheckboxes(rowSelection);
  }
  refreshShouldDestroy() {
    const colDef = this.column.getColDef();
    const selectionChanged = this.includeSelection != this.isIncludeControl(this.isCheckboxSelection(colDef), true);
    const rowDragChanged = this.includeRowDrag != this.isIncludeControl(colDef.rowDrag);
    const dndSourceChanged = this.includeDndSource != this.isIncludeControl(colDef.dndSource);
    const autoHeightChanged = this.isAutoHeight != this.column.isAutoHeight();
    return selectionChanged || rowDragChanged || dndSourceChanged || autoHeightChanged;
  }
  onPopupEditorClosed() {
    const { editSvc } = this.beans;
    if (!editSvc?.isEditing(this, { withOpenEditor: true })) {
      return;
    }
    editSvc?.stopEditing(this, { source: editSvc?.isBatchEditing() ? "ui" : "api" });
  }
  /**
   * Ends the Cell Editing
   * @param cancel `True` if the edit process is being canceled.
   * @returns `True` if the value of the `GridCell` has been updated, otherwise `False`.
   */
  stopEditing(cancel = false) {
    const { editSvc } = this.beans;
    return editSvc?.stopEditing(this, { cancel, source: editSvc?.isBatchEditing() ? "ui" : "api" }) ?? false;
  }
  createCellRendererParams() {
    const {
      value,
      valueFormatted,
      column,
      rowNode,
      comp,
      eGui,
      beans: { valueSvc, gos, editSvc }
    } = this;
    const res = _addGridCommonParams(gos, {
      value,
      valueFormatted,
      getValue: () => valueSvc.getValueForDisplay(column, rowNode).value,
      setValue: (value2) => editSvc?.setDataValue({ rowNode, column }, value2) || valueSvc.setValue(rowNode, column, value2),
      formatValue: this.formatValue.bind(this),
      data: rowNode.data,
      node: rowNode,
      pinned: column.getPinned(),
      colDef: column.getColDef(),
      column,
      refreshCell: this.refreshCell.bind(this),
      eGridCell: eGui,
      eParentOfValue: comp.getParentOfValue(),
      registerRowDragger: (rowDraggerElement, dragStartPixels, value2, suppressVisibilityChange) => this.registerRowDragger(rowDraggerElement, dragStartPixels, suppressVisibilityChange),
      setTooltip: (value2, shouldDisplayTooltip) => {
        gos.assertModuleRegistered("Tooltip", 3);
        if (this.tooltipFeature) {
          this.disableTooltipFeature();
        }
        this.enableTooltipFeature(value2, shouldDisplayTooltip);
        this.tooltipFeature?.refreshTooltip();
      }
    });
    return res;
  }
  onCellChanged(event) {
    const eventImpactsThisCell = event.column === this.column;
    if (eventImpactsThisCell) {
      this.refreshCell({});
    }
  }
  refreshOrDestroyCell(params) {
    if (this.refreshShouldDestroy()) {
      this.rowCtrl?.recreateCell(this);
    } else {
      this.refreshCell(params);
    }
  }
  // + stop editing {force: true, suppressFlash: true}
  // + event cellChanged {}
  // + cellRenderer.params.refresh() {} -> method passes 'as is' to the cellRenderer, so params could be anything
  // + rowCtrl: event dataChanged {suppressFlash: !update, newData: !update}
  // + rowCtrl: api refreshCells() {animate: true/false}
  // + rowRenderer: api softRefreshView() {}
  refreshCell({ force, suppressFlash, newData } = {}) {
    if (this.suppressRefreshCell) {
      return;
    }
    const colDef = this.column.getColDef();
    const noValueProvided = colDef.field == null && colDef.valueGetter == null && colDef.showRowGroup == null;
    const forceRefresh = force || noValueProvided || newData;
    const isCellCompReady = !!this.comp;
    const valuesDifferent = this.updateAndFormatValue(isCellCompReady);
    const dataNeedsUpdating = forceRefresh || valuesDifferent;
    if (!isCellCompReady) {
      return;
    }
    if (dataNeedsUpdating) {
      this.showValue(!!newData, false);
      const processingFilterChange = this.beans.filterManager?.isSuppressFlashingCellsBecauseFiltering();
      const flashCell = !suppressFlash && !processingFilterChange && colDef.enableCellChangeFlash;
      if (flashCell) {
        this.beans.cellFlashSvc?.flashCell(this);
      }
      this.editStyleFeature?.applyCellStyles?.();
      this.customStyleFeature?.applyUserStyles();
      this.customStyleFeature?.applyClassesFromColDef();
    }
    this.tooltipFeature?.refreshTooltip();
    this.customStyleFeature?.applyCellClassRules();
  }
  isCellEditable() {
    return this.column.isCellEditable(this.rowNode);
  }
  formatValue(value) {
    return this.callValueFormatter(value) ?? value;
  }
  callValueFormatter(value) {
    return this.beans.valueSvc.formatValue(this.column, this.rowNode, value);
  }
  updateAndFormatValue(compareValues) {
    const oldValue = this.value;
    const oldValueFormatted = this.valueFormatted;
    const { value, valueFormatted } = this.beans.valueSvc.getValueForDisplay(this.column, this.rowNode, true);
    this.value = value;
    this.valueFormatted = valueFormatted;
    if (compareValues) {
      return !this.valuesAreEqual(oldValue, this.value) || this.valueFormatted != oldValueFormatted;
    }
    return true;
  }
  valuesAreEqual(val1, val2) {
    const colDef = this.column.getColDef();
    return colDef.equals ? colDef.equals(val1, val2) : val1 === val2;
  }
  addDomData(compBean) {
    const element = this.eGui;
    _setDomData(this.beans.gos, element, DOM_DATA_KEY_CELL_CTRL, this);
    compBean.addDestroyFunc(() => _setDomData(this.beans.gos, element, DOM_DATA_KEY_CELL_CTRL, null));
  }
  createEvent(domEvent, eventType) {
    const { rowNode, column, value, beans } = this;
    return _createCellEvent(beans, domEvent, eventType, { rowNode, column }, value);
  }
  processCharacter(event) {
    this.keyboardListener?.processCharacter(event);
  }
  onKeyDown(event) {
    this.keyboardListener?.onKeyDown(event);
  }
  onMouseEvent(eventName, mouseEvent) {
    this.mouseListener?.onMouseEvent(eventName, mouseEvent);
  }
  getColSpanningList() {
    return this.positionFeature?.getColSpanningList() ?? [];
  }
  onLeftChanged() {
    if (!this.comp) {
      return;
    }
    this.positionFeature?.onLeftChanged();
  }
  onDisplayedColumnsChanged() {
    if (!this.eGui) {
      return;
    }
    this.refreshAriaColIndex();
    this.refreshFirstAndLastStyles();
  }
  refreshFirstAndLastStyles() {
    const { comp, column, beans } = this;
    refreshFirstAndLastStyles(comp, column, beans.visibleCols);
  }
  refreshAriaColIndex() {
    const colIdx = this.beans.visibleCols.getAriaColIndex(this.column);
    _setAriaColIndex(this.eGui, colIdx);
  }
  onWidthChanged() {
    return this.positionFeature?.onWidthChanged();
  }
  getRowPosition() {
    const { rowIndex, rowPinned } = this.cellPosition;
    return {
      rowIndex,
      rowPinned
    };
  }
  updateRangeBordersIfRangeCount() {
    if (!this.comp) {
      return;
    }
    this.rangeFeature?.updateRangeBordersIfRangeCount();
  }
  onCellSelectionChanged() {
    if (!this.comp) {
      return;
    }
    this.rangeFeature?.onCellSelectionChanged();
  }
  isRangeSelectionEnabled() {
    return this.rangeFeature != null;
  }
  focusCell(forceBrowserFocus = false, sourceEvent) {
    const allowedTarget = this.editSvc?.allowedFocusTargetOnValidation(this);
    if (allowedTarget && allowedTarget !== this) {
      return;
    }
    this.beans.focusSvc.setFocusedCell({
      ...this.getFocusedCellPosition(),
      forceBrowserFocus,
      sourceEvent
    });
  }
  /**
   * Restores focus to the cell, if it should have it
   * @param waitForRender if the cell has just setComp, it may not be rendered yet, so we wait for the next render
   */
  restoreFocus(waitForRender = false) {
    const {
      beans: { editSvc, focusSvc },
      comp
    } = this;
    if (!comp || editSvc?.isEditing(this) || !this.isCellFocused() || !focusSvc.shouldTakeFocus()) {
      return;
    }
    const focus = () => {
      if (!this.isAlive()) {
        return;
      }
      const focusableElement = comp.getFocusableElement();
      if (this.isCellFocused()) {
        focusableElement.focus({ preventScroll: true });
      }
    };
    if (waitForRender) {
      setTimeout(focus, 0);
      return;
    }
    focus();
  }
  onRowIndexChanged() {
    this.createCellPosition();
    this.onCellFocused();
    this.restoreFocus();
    this.rangeFeature?.onCellSelectionChanged();
    this.rowResizeFeature?.refreshRowResizer();
  }
  onSuppressCellFocusChanged(suppressCellFocus) {
    const element = this.eGui;
    if (!element) {
      return;
    }
    if (isRowNumberCol(this.column)) {
      suppressCellFocus = true;
    }
    _addOrRemoveAttribute(element, "tabindex", suppressCellFocus ? void 0 : -1);
  }
  onFirstRightPinnedChanged() {
    if (!this.comp) {
      return;
    }
    const firstRightPinned = this.column.isFirstRightPinned();
    this.comp.toggleCss(CSS_CELL_FIRST_RIGHT_PINNED, firstRightPinned);
  }
  onLastLeftPinnedChanged() {
    if (!this.comp) {
      return;
    }
    const lastLeftPinned = this.column.isLastLeftPinned();
    this.comp.toggleCss(CSS_CELL_LAST_LEFT_PINNED, lastLeftPinned);
  }
  /**
   * Returns whether cell is focused by the focusSvc, overridden by spannedCellCtrl
   */
  checkCellFocused() {
    return this.beans.focusSvc.isCellFocused(this.cellPosition);
  }
  isCellFocused() {
    const isFocused = this.checkCellFocused();
    this.hasBeenFocused || (this.hasBeenFocused = isFocused);
    return isFocused;
  }
  setupFocus() {
    this.restoreFocus(true);
    this.onCellFocused(this.focusEventWhileNotReady ?? void 0);
  }
  onCellFocused(event) {
    const { beans } = this;
    if (_isCellFocusSuppressed(beans)) {
      return;
    }
    if (!this.comp) {
      if (event) {
        this.focusEventWhileNotReady = event;
      }
      return;
    }
    const cellFocused = this.isCellFocused();
    const editing = beans.editSvc?.isEditing(this) ?? false;
    this.comp.toggleCss(CSS_CELL_FOCUS, cellFocused);
    if (cellFocused && event && event.forceBrowserFocus) {
      let focusEl = this.comp.getFocusableElement();
      if (editing) {
        const focusableEls = _findFocusableElements(focusEl, null, true);
        if (focusableEls.length) {
          focusEl = focusableEls[0];
        }
      }
      focusEl.focus({ preventScroll: !!event.preventScrollOnBrowserFocus });
    }
    if (cellFocused) {
      this.rowCtrl.announceDescription();
    }
  }
  createCellPosition() {
    const { rowIndex, rowPinned } = this.rowNode;
    this.cellPosition = {
      rowIndex,
      rowPinned: _makeNull(rowPinned),
      column: this.column
    };
  }
  // CSS Classes that only get applied once, they never change
  applyStaticCssClasses() {
    const { comp } = this;
    comp.toggleCss(CSS_CELL, true);
    comp.toggleCss(CSS_CELL_NOT_INLINE_EDITING, true);
    const autoHeight = this.column.isAutoHeight() == true;
    comp.toggleCss(CSS_AUTO_HEIGHT, autoHeight);
    comp.toggleCss(CSS_NORMAL_HEIGHT, !autoHeight);
  }
  onColumnHover() {
    this.beans.colHover?.onCellColumnHover(this.column, this.comp);
  }
  onColDefChanged() {
    if (!this.comp) {
      return;
    }
    if (this.column.isTooltipEnabled()) {
      this.disableTooltipFeature();
      this.enableTooltipFeature();
    } else {
      this.disableTooltipFeature();
    }
    this.setWrapText();
    if (this.editSvc?.isEditing(this)) {
      this.editSvc?.handleColDefChanged(this);
    } else {
      this.refreshOrDestroyCell({ force: true, suppressFlash: true });
    }
  }
  setWrapText() {
    const value = this.column.getColDef().wrapText == true;
    this.comp.toggleCss(CSS_CELL_WRAP_TEXT, value);
  }
  dispatchCellContextMenuEvent(event) {
    const colDef = this.column.getColDef();
    const cellContextMenuEvent = this.createEvent(event, "cellContextMenu");
    const { beans } = this;
    beans.eventSvc.dispatchEvent(cellContextMenuEvent);
    if (colDef.onCellContextMenu) {
      window.setTimeout(() => {
        beans.frameworkOverrides.wrapOutgoing(() => {
          colDef.onCellContextMenu(cellContextMenuEvent);
        });
      }, 0);
    }
  }
  getCellRenderer() {
    return this.comp?.getCellRenderer() ?? null;
  }
  destroy() {
    this.onCompAttachedFuncs = [];
    this.onEditorAttachedFuncs = [];
    if (this.isCellFocused() && this.hasBrowserFocus()) {
      this.beans.focusSvc.attemptToRecoverFocus();
    }
    super.destroy();
  }
  hasBrowserFocus() {
    return this.eGui?.contains(_getActiveDomElement(this.beans)) ?? false;
  }
  createSelectionCheckbox() {
    const cbSelectionComponent = this.beans.selectionSvc?.createCheckboxSelectionComponent();
    if (!cbSelectionComponent) {
      return void 0;
    }
    this.beans.context.createBean(cbSelectionComponent);
    cbSelectionComponent.init({ rowNode: this.rowNode, column: this.column });
    return cbSelectionComponent;
  }
  createDndSource() {
    const dndSourceComp = this.beans.registry.createDynamicBean(
      "dndSourceComp",
      false,
      this.rowNode,
      this.column,
      this.eGui
    );
    if (dndSourceComp) {
      this.beans.context.createBean(dndSourceComp);
    }
    return dndSourceComp;
  }
  registerRowDragger(customElement, dragStartPixels, suppressVisibilityChange) {
    if (this.customRowDragComp) {
      this.customRowDragComp.setDragElement(customElement, dragStartPixels);
      return;
    }
    const newComp = this.createRowDragComp(customElement, dragStartPixels, suppressVisibilityChange);
    if (newComp) {
      this.customRowDragComp = newComp;
      this.addDestroyFunc(() => {
        this.beans.context.destroyBean(newComp);
        this.customRowDragComp = null;
      });
    }
  }
  createRowDragComp(customElement, dragStartPixels, suppressVisibilityChange) {
    const rowDragComp = this.beans.rowDragSvc?.createRowDragCompForCell(
      this.rowNode,
      this.column,
      () => this.value,
      customElement,
      dragStartPixels,
      suppressVisibilityChange
    );
    if (!rowDragComp) {
      return void 0;
    }
    this.beans.context.createBean(rowDragComp);
    return rowDragComp;
  }
  cellEditorAttached() {
    this.onEditorAttachedFuncs.forEach((func) => func());
    this.onEditorAttachedFuncs = [];
  }
  setFocusedCellPosition(_cellPosition) {
  }
  getFocusedCellPosition() {
    return this.cellPosition;
  }
  // used by spannedCellCtrl
  refreshAriaRowIndex() {
  }
  /**
   * Returns the root element of the cell, could be a span container rather than the cell element.
   * @returns The root element of the cell.
   */
  getRootElement() {
    return this.eGui;
  }
};

// packages/ag-grid-community/src/gridBodyComp/mouseEventUtils.ts
var GRID_DOM_KEY = "__ag_grid_instance";
function _stampTopLevelGridCompWithGridInstance(gos, eGridDiv) {
  eGridDiv[GRID_DOM_KEY] = gos.gridInstanceId;
}
function _isEventFromThisGrid(gos, event) {
  const res = _isElementInThisGrid(gos, event.target);
  return res;
}
function _isElementInThisGrid(gos, element) {
  let pointer = element;
  while (pointer) {
    const instanceId = pointer[GRID_DOM_KEY];
    if (_exists(instanceId)) {
      const eventFromThisGrid = instanceId === gos.gridInstanceId;
      return eventFromThisGrid;
    }
    pointer = pointer.parentElement;
  }
  return false;
}
function _getCellPositionForEvent(gos, event) {
  return _getCellCtrlForEventTarget(gos, event.target)?.getFocusedCellPosition() ?? null;
}
function _getNormalisedMousePosition(beans, event) {
  const gridPanelHasScrolls = _isDomLayout(beans.gos, "normal");
  const e = event;
  let x;
  let y;
  if (e.clientX != null || e.clientY != null) {
    x = e.clientX;
    y = e.clientY;
  } else {
    x = e.x;
    y = e.y;
  }
  const { pageFirstPixel } = beans.pageBounds.getCurrentPagePixelRange();
  y += pageFirstPixel;
  if (gridPanelHasScrolls) {
    const scrollFeature = beans.ctrlsSvc.getScrollFeature();
    const vRange = scrollFeature.getVScrollPosition();
    const hRange = scrollFeature.getHScrollPosition();
    x += hRange.left;
    y += vRange.top;
  }
  return { x, y };
}

// packages/ag-grid-community/src/dragAndDrop/dragAndDropService.ts
var DragSourceType = /* @__PURE__ */ ((DragSourceType2) => {
  DragSourceType2[DragSourceType2["ToolPanel"] = 0] = "ToolPanel";
  DragSourceType2[DragSourceType2["HeaderCell"] = 1] = "HeaderCell";
  DragSourceType2[DragSourceType2["RowDrag"] = 2] = "RowDrag";
  DragSourceType2[DragSourceType2["ChartPanel"] = 3] = "ChartPanel";
  DragSourceType2[DragSourceType2["AdvancedFilterBuilder"] = 4] = "AdvancedFilterBuilder";
  return DragSourceType2;
})(DragSourceType || {});
var DragAndDropService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "dragAndDrop";
    this.dragSourceAndParamsList = [];
    this.dropTargets = [];
  }
  wireBeans(beans) {
    this.ctrlsSvc = beans.ctrlsSvc;
    this.dragSvc = beans.dragSvc;
    this.environment = beans.environment;
    this.userCompFactory = beans.userCompFactory;
  }
  addDragSource(dragSource, allowTouch = false) {
    const params = {
      eElement: dragSource.eElement,
      dragStartPixels: dragSource.dragStartPixels,
      onDragStart: this.onDragStart.bind(this, dragSource),
      onDragStop: this.onDragStop.bind(this),
      onDragging: this.onDragging.bind(this),
      onDragCancel: this.onDragCancel.bind(this),
      includeTouch: allowTouch
    };
    this.dragSourceAndParamsList.push({ params, dragSource });
    this.dragSvc.addDragSource(params);
  }
  getDragAndDropImageComponent() {
    const { dragAndDropImageComp } = this;
    if (!dragAndDropImageComp || !dragAndDropImageComp.comp) {
      return null;
    }
    return dragAndDropImageComp.comp;
  }
  removeDragSource(dragSource) {
    const { dragSourceAndParamsList, dragSvc } = this;
    const sourceAndParams = dragSourceAndParamsList.find((item) => item.dragSource === dragSource);
    if (sourceAndParams) {
      dragSvc.removeDragSource(sourceAndParams.params);
      _removeFromArray(dragSourceAndParamsList, sourceAndParams);
    }
  }
  destroy() {
    const { dragSourceAndParamsList, dragSvc, dropTargets } = this;
    dragSourceAndParamsList.forEach((sourceAndParams) => dragSvc.removeDragSource(sourceAndParams.params));
    dragSourceAndParamsList.length = 0;
    dropTargets.length = 0;
    this.clearDragAndDropProperties();
    super.destroy();
  }
  nudge() {
    if (this.dragging) {
      this.onDragging(this.eventLastTime, true);
    }
  }
  onDragStart(dragSource, mouseEvent) {
    this.dragging = true;
    this.dragSource = dragSource;
    this.eventLastTime = mouseEvent;
    this.dragItem = dragSource.getDragItem();
    dragSource.onDragStarted?.();
    this.createDragAndDropImageComponent();
  }
  onDragStop(mouseEvent) {
    this.dragSource?.onDragStopped?.();
    const { lastDropTarget } = this;
    if (lastDropTarget?.onDragStop) {
      const draggingEvent = this.createDropTargetEvent(lastDropTarget, mouseEvent, null, null, false);
      lastDropTarget.onDragStop(draggingEvent);
    }
    this.clearDragAndDropProperties();
  }
  onDragCancel() {
    const { dragSource, lastDropTarget } = this;
    dragSource?.onDragCancelled?.();
    if (lastDropTarget?.onDragCancel) {
      lastDropTarget.onDragCancel(
        this.createDropTargetEvent(lastDropTarget, this.eventLastTime, null, null, false)
      );
    }
    this.clearDragAndDropProperties();
  }
  clearDragAndDropProperties() {
    this.eventLastTime = null;
    this.dragging = false;
    this.lastDropTarget = void 0;
    this.dragItem = null;
    this.dragSource = null;
    this.removeDragAndDropImageComponent();
  }
  onDragging(mouseEvent, fromNudge = false) {
    const hDirection = this.getHorizontalDirection(mouseEvent);
    const vDirection = this.getVerticalDirection(mouseEvent);
    this.eventLastTime = mouseEvent;
    this.positionDragAndDropImageComp(mouseEvent);
    const validDropTargets = this.dropTargets.filter((target) => this.isMouseOnDropTarget(mouseEvent, target));
    const dropTarget = this.findCurrentDropTarget(mouseEvent, validDropTargets);
    const { lastDropTarget, dragSource, dragAndDropImageComp, dragItem } = this;
    if (dropTarget !== lastDropTarget) {
      this.leaveLastTargetIfExists(mouseEvent, hDirection, vDirection, fromNudge);
      if (lastDropTarget !== null && dropTarget === null) {
        dragSource?.onGridExit?.(dragItem);
      }
      if (lastDropTarget === null && dropTarget !== null) {
        dragSource?.onGridEnter?.(dragItem);
      }
      this.enterDragTargetIfExists(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
      if (dropTarget && dragAndDropImageComp) {
        const { comp, promise } = dragAndDropImageComp;
        if (comp) {
          comp.setIcon(dropTarget.getIconName ? dropTarget.getIconName() : null, false);
        } else {
          promise.then((resolvedComponent) => {
            if (resolvedComponent) {
              resolvedComponent.setIcon(dropTarget.getIconName ? dropTarget.getIconName() : null, false);
            }
          });
        }
      }
      this.lastDropTarget = dropTarget;
    } else if (dropTarget && dropTarget.onDragging) {
      const draggingEvent = this.createDropTargetEvent(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
      dropTarget.onDragging(draggingEvent);
    }
  }
  getAllContainersFromDropTarget(dropTarget) {
    const secondaryContainers = dropTarget.getSecondaryContainers ? dropTarget.getSecondaryContainers() : null;
    const containers = [[dropTarget.getContainer()]];
    return secondaryContainers ? containers.concat(secondaryContainers) : containers;
  }
  // checks if the mouse is on the drop target. it checks eContainer and eSecondaryContainers
  isMouseOnDropTarget(mouseEvent, dropTarget) {
    const allContainersFromDropTarget = this.getAllContainersFromDropTarget(dropTarget);
    let mouseOverTarget = false;
    const allContainersIntersect = (mouseEvent2, containers) => {
      for (const container of containers) {
        const { width, height, left, right, top, bottom } = container.getBoundingClientRect();
        if (width === 0 || height === 0) {
          return false;
        }
        const horizontalFit = mouseEvent2.clientX >= left && mouseEvent2.clientX < right;
        const verticalFit = mouseEvent2.clientY >= top && mouseEvent2.clientY < bottom;
        if (!horizontalFit || !verticalFit) {
          return false;
        }
      }
      return true;
    };
    for (const currentContainers of allContainersFromDropTarget) {
      if (allContainersIntersect(mouseEvent, currentContainers)) {
        mouseOverTarget = true;
        break;
      }
    }
    const { eElement, type } = this.dragSource;
    if (dropTarget.targetContainsSource && !dropTarget.getContainer().contains(eElement)) {
      return false;
    }
    return mouseOverTarget && dropTarget.isInterestedIn(type, eElement);
  }
  findCurrentDropTarget(mouseEvent, validDropTargets) {
    const len = validDropTargets.length;
    if (len === 0) {
      return null;
    }
    if (len === 1) {
      return validDropTargets[0];
    }
    const rootNode = _getRootNode(this.beans);
    const elementStack = rootNode.elementsFromPoint(mouseEvent.clientX, mouseEvent.clientY);
    for (const el of elementStack) {
      for (const dropTarget of validDropTargets) {
        const containers = this.getAllContainersFromDropTarget(dropTarget).flatMap((a) => a);
        if (containers.indexOf(el) !== -1) {
          return dropTarget;
        }
      }
    }
    return null;
  }
  enterDragTargetIfExists(dropTarget, mouseEvent, hDirection, vDirection, fromNudge) {
    if (!dropTarget) {
      return;
    }
    if (dropTarget.onDragEnter) {
      const dragEnterEvent = this.createDropTargetEvent(
        dropTarget,
        mouseEvent,
        hDirection,
        vDirection,
        fromNudge
      );
      dropTarget.onDragEnter(dragEnterEvent);
    }
  }
  leaveLastTargetIfExists(mouseEvent, hDirection, vDirection, fromNudge) {
    const { lastDropTarget } = this;
    if (!lastDropTarget) {
      return;
    }
    if (lastDropTarget.onDragLeave) {
      const dragLeaveEvent = this.createDropTargetEvent(
        lastDropTarget,
        mouseEvent,
        hDirection,
        vDirection,
        fromNudge
      );
      lastDropTarget.onDragLeave(dragLeaveEvent);
    }
    const dragAndDropImageComponent = this.getDragAndDropImageComponent();
    if (dragAndDropImageComponent) {
      dragAndDropImageComponent.setIcon(null, false);
    }
  }
  addDropTarget(dropTarget) {
    this.dropTargets.push(dropTarget);
  }
  removeDropTarget(dropTarget) {
    this.dropTargets = this.dropTargets.filter((target) => target.getContainer() !== dropTarget.getContainer());
  }
  hasExternalDropZones() {
    return this.dropTargets.some((zones) => zones.external);
  }
  findExternalZone(params) {
    const externalTargets = this.dropTargets.filter((target) => target.external);
    return externalTargets.find((zone) => zone.getContainer() === params.getContainer()) || null;
  }
  isDropZoneWithinThisGrid(draggingEvent) {
    const gridBodyCon = this.ctrlsSvc.getGridBodyCtrl();
    const gridGui = gridBodyCon.eGridBody;
    const { dropZoneTarget } = draggingEvent;
    return gridGui.contains(dropZoneTarget);
  }
  getHorizontalDirection(event) {
    const clientX = this.eventLastTime?.clientX;
    const eClientX = event.clientX;
    if (clientX === eClientX) {
      return null;
    }
    return clientX > eClientX ? "left" : "right";
  }
  getVerticalDirection(event) {
    const clientY = this.eventLastTime?.clientY;
    const eClientY = event.clientY;
    if (clientY === eClientY) {
      return null;
    }
    return clientY > eClientY ? "up" : "down";
  }
  createDropTargetEvent(dropTarget, event, hDirection, vDirection, fromNudge) {
    const dropZoneTarget = dropTarget.getContainer();
    const rect = dropZoneTarget.getBoundingClientRect();
    const { dragItem, dragSource, gos } = this;
    const x = event.clientX - rect.left;
    const y = event.clientY - rect.top;
    return _addGridCommonParams(gos, {
      event,
      x,
      y,
      vDirection,
      hDirection,
      dragSource,
      fromNudge,
      dragItem,
      dropZoneTarget
    });
  }
  positionDragAndDropImageComp(event) {
    const dragAndDropImageComponent = this.getDragAndDropImageComponent();
    if (!dragAndDropImageComponent) {
      return;
    }
    _anchorElementToMouseMoveEvent(dragAndDropImageComponent.getGui(), event, this.beans);
  }
  removeDragAndDropImageComponent() {
    const { dragAndDropImageComp } = this;
    if (dragAndDropImageComp) {
      const { comp } = dragAndDropImageComp;
      if (comp) {
        const eGui = comp.getGui();
        this.dragAndDropImageParent?.removeChild(eGui);
        this.destroyBean(comp);
      }
    }
    this.dragAndDropImageComp = null;
  }
  createDragAndDropImageComponent() {
    const { dragSource, gos, userCompFactory } = this;
    if (!dragSource) {
      return;
    }
    const userCompDetails = _getDragAndDropImageCompDetails(
      userCompFactory,
      _addGridCommonParams(gos, {
        dragSource
      })
    );
    if (!userCompDetails) {
      return;
    }
    const promise = userCompDetails.newAgStackInstance();
    this.dragAndDropImageComp = {
      promise
    };
    promise.then((comp) => {
      if (!comp || !this.isAlive()) {
        return;
      }
      this.processDragAndDropImageComponent(comp);
      this.dragAndDropImageComp.comp = comp;
    });
  }
  processDragAndDropImageComponent(dragAndDropImageComponent) {
    const { dragSource, environment } = this;
    if (!dragSource) {
      return;
    }
    const eGui = dragAndDropImageComponent.getGui();
    eGui.style.setProperty("position", "absolute");
    eGui.style.setProperty("z-index", "9999");
    _stampTopLevelGridCompWithGridInstance(this.gos, eGui);
    environment.applyThemeClasses(eGui);
    dragAndDropImageComponent.setIcon(null, false);
    let { dragItemName } = dragSource;
    if (typeof dragItemName === "function") {
      dragItemName = dragItemName();
    }
    dragAndDropImageComponent.setLabel(dragItemName || "");
    eGui.style.top = "20px";
    eGui.style.left = "20px";
    const targetEl = _getPageBody(this.beans);
    this.dragAndDropImageParent = targetEl;
    if (!targetEl) {
      _warn(54);
    } else {
      targetEl.appendChild(eGui);
    }
  }
  registerGridDropTarget(elementFn, ctrl) {
    const dropTarget = {
      getContainer: elementFn,
      isInterestedIn: (type) => type === 1 /* HeaderCell */ || type === 0 /* ToolPanel */,
      getIconName: () => "notAllowed"
    };
    this.addDropTarget(dropTarget);
    ctrl.addDestroyFunc(() => this.removeDropTarget(dropTarget));
  }
};

// packages/ag-grid-community/src/dragAndDrop/dragService.ts
var DragService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "dragSvc";
    this.dragEndFunctions = [];
    this.dragSources = [];
  }
  destroy() {
    const { dragSources } = this;
    dragSources.forEach(this.removeListener.bind(this));
    dragSources.length = 0;
    super.destroy();
  }
  removeListener(dragSourceAndListener) {
    const element = dragSourceAndListener.dragSource.eElement;
    const mouseDownListener = dragSourceAndListener.mouseDownListener;
    element.removeEventListener("mousedown", mouseDownListener);
    if (dragSourceAndListener.touchEnabled) {
      const touchStartListener = dragSourceAndListener.touchStartListener;
      element.removeEventListener("touchstart", touchStartListener, { passive: true });
    }
  }
  removeDragSource(params) {
    const { dragSources } = this;
    const dragSourceAndListener = dragSources.find((item) => item.dragSource === params);
    if (!dragSourceAndListener) {
      return;
    }
    this.removeListener(dragSourceAndListener);
    _removeFromArray(dragSources, dragSourceAndListener);
  }
  addDragSource(params) {
    const mouseListener = this.onMouseDown.bind(this, params);
    const { eElement, includeTouch, stopPropagationForTouch } = params;
    eElement.addEventListener("mousedown", mouseListener);
    let touchListener = null;
    const suppressTouch = this.gos.get("suppressTouch");
    if (includeTouch && !suppressTouch) {
      touchListener = (touchEvent) => {
        if (_isFocusableFormField(touchEvent.target)) {
          return;
        }
        if (stopPropagationForTouch) {
          touchEvent.stopPropagation();
        }
        this.onTouchStart(params, touchEvent);
      };
      eElement.addEventListener("touchstart", touchListener, { passive: false });
    }
    this.dragSources.push({
      dragSource: params,
      mouseDownListener: mouseListener,
      touchStartListener: touchListener,
      touchEnabled: !!includeTouch
    });
  }
  // gets called whenever mouse down on any drag source
  onTouchStart(params, touchEvent) {
    this.currentDragParams = params;
    this.dragging = false;
    const touch = touchEvent.touches[0];
    this.touchLastTime = touch;
    this.touchStart = touch;
    const touchMoveEvent = (e) => this.onTouchMove(e, params.eElement);
    const touchEndEvent = (e) => this.onTouchUp(e, params.eElement);
    const documentTouchMove = (e) => {
      if (e.cancelable) {
        e.preventDefault();
      }
    };
    const target = touchEvent.target;
    const events = [
      // Prevents the page document from moving while we are dragging items around.
      // preventDefault needs to be called in the touchmove listener and never inside the
      // touchstart, because using touchstart causes the click event to be cancelled on touch devices.
      {
        target: _getRootNode(this.beans),
        type: "touchmove",
        listener: documentTouchMove,
        options: { passive: false }
      },
      { target, type: "touchmove", listener: touchMoveEvent, options: { passive: true } },
      { target, type: "touchend", listener: touchEndEvent, options: { passive: true } },
      { target, type: "touchcancel", listener: touchEndEvent, options: { passive: true } }
    ];
    this.addTemporaryEvents(events);
    if (params.dragStartPixels === 0) {
      this.onCommonMove(touch, this.touchStart, params.eElement);
    }
  }
  // gets called whenever mouse down on any drag source
  onMouseDown(params, mouseEvent) {
    const e = mouseEvent;
    if (params.skipMouseEvent && params.skipMouseEvent(mouseEvent)) {
      return;
    }
    if (e._alreadyProcessedByDragService) {
      return;
    }
    e._alreadyProcessedByDragService = true;
    if (mouseEvent.button !== 0) {
      return;
    }
    if (this.shouldPreventMouseEvent(mouseEvent)) {
      mouseEvent.preventDefault();
    }
    this.currentDragParams = params;
    this.dragging = false;
    this.mouseStartEvent = mouseEvent;
    this.startTarget = mouseEvent.target;
    const mouseMoveEvent = (event) => this.onMouseMove(event, params.eElement);
    const mouseUpEvent = (event) => this.onMouseUp(event, params.eElement);
    const contextEvent = (event) => event.preventDefault();
    const keydownEvent = (event) => {
      if (event.key === KeyCode.ESCAPE) {
        this.cancelDrag(params.eElement);
      }
    };
    const target = _getRootNode(this.beans);
    const events = [
      { target, type: "mousemove", listener: mouseMoveEvent },
      { target, type: "mouseup", listener: mouseUpEvent },
      { target, type: "contextmenu", listener: contextEvent },
      { target, type: "keydown", listener: keydownEvent }
    ];
    this.addTemporaryEvents(events);
    if (params.dragStartPixels === 0) {
      this.onMouseMove(mouseEvent, params.eElement);
    }
  }
  addTemporaryEvents(events) {
    events.forEach((currentEvent) => {
      const { target, type, listener, options } = currentEvent;
      target.addEventListener(type, listener, options);
    });
    this.dragEndFunctions.push(() => {
      events.forEach((currentEvent) => {
        const { target, type, listener, options } = currentEvent;
        target.removeEventListener(type, listener, options);
      });
    });
  }
  // returns true if the event is close to the original event by X pixels either vertically or horizontally.
  // we only start dragging after X pixels so this allows us to know if we should start dragging yet.
  isEventNearStartEvent(currentEvent, startEvent) {
    const { dragStartPixels } = this.currentDragParams;
    const requiredPixelDiff = _exists(dragStartPixels) ? dragStartPixels : 4;
    return _areEventsNear(currentEvent, startEvent, requiredPixelDiff);
  }
  getFirstActiveTouch(touchList) {
    for (let i = 0; i < touchList.length; i++) {
      if (touchList[i].identifier === this.touchStart.identifier) {
        return touchList[i];
      }
    }
    return null;
  }
  onCommonMove(currentEvent, startEvent, el) {
    if (!this.dragging) {
      if (this.isEventNearStartEvent(currentEvent, startEvent)) {
        return;
      }
      this.dragging = true;
      this.eventSvc.dispatchEvent({
        type: "dragStarted",
        target: el
      });
      this.currentDragParams.onDragStart(startEvent);
      if (!this.currentDragParams) {
        this.dragging = false;
        return;
      }
      this.currentDragParams.onDragging(startEvent);
    }
    this.currentDragParams?.onDragging(currentEvent);
  }
  onTouchMove(touchEvent, el) {
    const touch = this.getFirstActiveTouch(touchEvent.touches);
    if (!touch) {
      return;
    }
    this.onCommonMove(touch, this.touchStart, el);
  }
  // only gets called after a mouse down - as this is only added after mouseDown
  // and is removed when mouseUp happens
  onMouseMove(mouseEvent, el) {
    if (_isBrowserSafari()) {
      const eDocument = _getDocument(this.beans);
      eDocument.getSelection()?.removeAllRanges();
    }
    if (this.shouldPreventMouseEvent(mouseEvent)) {
      mouseEvent.preventDefault();
    }
    this.onCommonMove(mouseEvent, this.mouseStartEvent, el);
  }
  shouldPreventMouseEvent(mouseEvent) {
    const { gos } = this;
    const isEnableCellTextSelect = gos.get("enableCellTextSelection");
    const isMouseMove = mouseEvent.type === "mousemove";
    const isOverFormFieldElement = (mouseEvent2) => {
      const el = mouseEvent2.target;
      const tagName = el?.tagName.toLocaleLowerCase();
      return !!tagName?.match("^a$|textarea|input|select|button");
    };
    return (
      // when `isEnableCellTextSelect` is `true`, we need to preventDefault on mouseMove
      // to avoid the grid text being selected while dragging components.
      isEnableCellTextSelect && isMouseMove && mouseEvent.cancelable && _isEventFromThisGrid(gos, mouseEvent) && !isOverFormFieldElement(mouseEvent)
    );
  }
  onTouchUp(touchEvent, el) {
    let touch = this.getFirstActiveTouch(touchEvent.changedTouches);
    if (!touch) {
      touch = this.touchLastTime;
    }
    this.onUpCommon(touch, el);
  }
  onMouseUp(mouseEvent, el) {
    this.onUpCommon(mouseEvent, el);
  }
  onUpCommon(eventOrTouch, el) {
    if (this.dragging) {
      this.dragging = false;
      this.currentDragParams.onDragStop(eventOrTouch);
      this.eventSvc.dispatchEvent({
        type: "dragStopped",
        target: el
      });
    }
    this.resetDragProperties();
  }
  cancelDrag(el) {
    this.eventSvc.dispatchEvent({
      type: "dragCancelled",
      target: el
    });
    this.currentDragParams?.onDragCancel?.();
    this.resetDragProperties();
  }
  resetDragProperties() {
    this.mouseStartEvent = null;
    this.startTarget = null;
    this.touchStart = null;
    this.touchLastTime = null;
    this.currentDragParams = null;
    const { dragEndFunctions } = this;
    dragEndFunctions.forEach((func) => func());
    dragEndFunctions.length = 0;
  }
};

// packages/ag-grid-community/src/entities/agColumnGroup.ts
function createUniqueColumnGroupId(groupId, instanceId) {
  return groupId + "_" + instanceId;
}
function isColumnGroup(col) {
  return col instanceof AgColumnGroup;
}
var AgColumnGroup = class extends BeanStub {
  constructor(providedColumnGroup, groupId, partId, pinned) {
    super();
    this.providedColumnGroup = providedColumnGroup;
    this.groupId = groupId;
    this.partId = partId;
    this.pinned = pinned;
    this.isColumn = false;
    // depends on the open/closed state of the group, only displaying columns are stored here
    this.displayedChildren = [];
    // The measured height of this column's header when autoHeaderHeight is enabled
    this.autoHeaderHeight = null;
    this.parent = null;
  }
  // as the user is adding and removing columns, the groups are recalculated.
  // this reset clears out all children, ready for children to be added again
  reset() {
    this.parent = null;
    this.children = null;
    this.displayedChildren = null;
  }
  getParent() {
    return this.parent;
  }
  getUniqueId() {
    return createUniqueColumnGroupId(this.groupId, this.partId);
  }
  isEmptyGroup() {
    return this.displayedChildren.length === 0;
  }
  isMoving() {
    const allLeafColumns = this.getProvidedColumnGroup().getLeafColumns();
    if (!allLeafColumns || allLeafColumns.length === 0) {
      return false;
    }
    return allLeafColumns.every((col) => col.isMoving());
  }
  checkLeft() {
    this.displayedChildren.forEach((child) => {
      if (isColumnGroup(child)) {
        child.checkLeft();
      }
    });
    if (this.displayedChildren.length > 0) {
      if (this.gos.get("enableRtl")) {
        const lastChild = _last(this.displayedChildren);
        const lastChildLeft = lastChild.getLeft();
        this.setLeft(lastChildLeft);
      } else {
        const firstChildLeft = this.displayedChildren[0].getLeft();
        this.setLeft(firstChildLeft);
      }
    } else {
      this.setLeft(null);
    }
  }
  getLeft() {
    return this.left;
  }
  getOldLeft() {
    return this.oldLeft;
  }
  setLeft(left) {
    this.oldLeft = this.left;
    if (this.left !== left) {
      this.left = left;
      this.dispatchLocalEvent({ type: "leftChanged" });
    }
  }
  getPinned() {
    return this.pinned;
  }
  getGroupId() {
    return this.groupId;
  }
  getPartId() {
    return this.partId;
  }
  getActualWidth() {
    let groupActualWidth = 0;
    this.displayedChildren?.forEach((child) => {
      groupActualWidth += child.getActualWidth();
    });
    return groupActualWidth;
  }
  isResizable() {
    if (!this.displayedChildren) {
      return false;
    }
    let result = false;
    this.displayedChildren.forEach((child) => {
      if (child.isResizable()) {
        result = true;
      }
    });
    return result;
  }
  getMinWidth() {
    let result = 0;
    this.displayedChildren.forEach((groupChild) => {
      result += groupChild.getMinWidth();
    });
    return result;
  }
  addChild(child) {
    if (!this.children) {
      this.children = [];
    }
    this.children.push(child);
  }
  getDisplayedChildren() {
    return this.displayedChildren;
  }
  getLeafColumns() {
    const result = [];
    this.addLeafColumns(result);
    return result;
  }
  getDisplayedLeafColumns() {
    const result = [];
    this.addDisplayedLeafColumns(result);
    return result;
  }
  getDefinition() {
    return this.providedColumnGroup.getColGroupDef();
  }
  getColGroupDef() {
    return this.providedColumnGroup.getColGroupDef();
  }
  isPadding() {
    return this.providedColumnGroup.isPadding();
  }
  isExpandable() {
    return this.providedColumnGroup.isExpandable();
  }
  isExpanded() {
    return this.providedColumnGroup.isExpanded();
  }
  setExpanded(expanded) {
    this.providedColumnGroup.setExpanded(expanded);
  }
  isAutoHeaderHeight() {
    return !!this.getColGroupDef()?.autoHeaderHeight;
  }
  getAutoHeaderHeight() {
    return this.autoHeaderHeight;
  }
  /** Returns true if the header height has changed */
  setAutoHeaderHeight(height) {
    const changed = height !== this.autoHeaderHeight;
    this.autoHeaderHeight = height;
    return changed;
  }
  addDisplayedLeafColumns(leafColumns) {
    this.displayedChildren.forEach((child) => {
      if (isColumn(child)) {
        leafColumns.push(child);
      } else if (isColumnGroup(child)) {
        child.addDisplayedLeafColumns(leafColumns);
      }
    });
  }
  addLeafColumns(leafColumns) {
    this.children.forEach((child) => {
      if (isColumn(child)) {
        leafColumns.push(child);
      } else if (isColumnGroup(child)) {
        child.addLeafColumns(leafColumns);
      }
    });
  }
  getChildren() {
    return this.children;
  }
  getColumnGroupShow() {
    return this.providedColumnGroup.getColumnGroupShow();
  }
  getProvidedColumnGroup() {
    return this.providedColumnGroup;
  }
  getPaddingLevel() {
    const parent = this.getParent();
    if (!this.isPadding() || !parent || !parent.isPadding()) {
      return 0;
    }
    return 1 + parent.getPaddingLevel();
  }
  calculateDisplayedColumns() {
    this.displayedChildren = [];
    let parentWithExpansion = this;
    while (parentWithExpansion != null && parentWithExpansion.isPadding()) {
      parentWithExpansion = parentWithExpansion.getParent();
    }
    const isExpandable = parentWithExpansion ? parentWithExpansion.getProvidedColumnGroup().isExpandable() : false;
    if (!isExpandable) {
      this.displayedChildren = this.children;
      this.dispatchLocalEvent({ type: "displayedChildrenChanged" });
      return;
    }
    this.children.forEach((child) => {
      const emptyGroup = isColumnGroup(child) && !child.displayedChildren?.length;
      if (emptyGroup) {
        return;
      }
      const headerGroupShow = child.getColumnGroupShow();
      switch (headerGroupShow) {
        case "open":
          if (parentWithExpansion.getProvidedColumnGroup().isExpanded()) {
            this.displayedChildren.push(child);
          }
          break;
        case "closed":
          if (!parentWithExpansion.getProvidedColumnGroup().isExpanded()) {
            this.displayedChildren.push(child);
          }
          break;
        default:
          this.displayedChildren.push(child);
          break;
      }
    });
    this.dispatchLocalEvent({ type: "displayedChildrenChanged" });
  }
};

// packages/ag-grid-community/src/entities/rowNode.ts
var ROW_ID_PREFIX_ROW_GROUP = "row-group-";
var ROW_ID_PREFIX_TOP_PINNED = "t-";
var ROW_ID_PREFIX_BOTTOM_PINNED = "b-";
var OBJECT_ID_SEQUENCE = 0;
var RowNode = class {
  constructor(beans) {
    /** `true` if this row is a master row, part of master / detail (ie row can be expanded to show detail) */
    this.master = false;
    /** `true` if this row is a detail row, part of master / detail (ie child row of an expanded master row)*/
    this.detail = void 0;
    /** The current row index. If the row is filtered out or in a collapsed group, this value is set to `null`. */
    this.rowIndex = null;
    /** The key for the group eg Ireland, UK, USA */
    this.key = null;
    /**
     * The index of the row in the source rowData array including any updates via transactions.
     * It does not change when sorting, filtering, grouping, pivoting or any other UI related operations.
     * If this is a filler node (a visual row created by AG Grid in tree data or grouping) the value is set to `-1`.
     *
     * Generally readonly. It is modified only by:
     * - ClientSideNodeManager, cast to ClientSideNodeManagerRowNode
     * - ClientSideRowModel, cast to ClientSideRowModelRowNode
     */
    this.sourceRowIndex = -1;
    /** Children mapped by the pivot columns or group key */
    this.childrenMapped = null;
    /**
     * Parent RowNode for tree data.
     * When set, the parent node in the hierarchy is updated during Client-Side Row Model (CSRM) grouping.
     * Used by the ClientSideChildrenTreeNodeManager, TreeGroupStrategy, RowDragFeature
     */
    this.treeParent = null;
    /** The flags associated to this node. Used only internally within TreeGroupStrategy. */
    this.treeNodeFlags = 0;
    /**
     * This is `true` if the row has a rowIndex assigned, otherwise `false`.
     */
    this.displayed = false;
    /** The row top position in pixels. */
    this.rowTop = null;
    /** The top pixel for this row last time, makes sense if data set was ordered or filtered,
     * it is used so new rows can animate in from their old position. */
    this.oldRowTop = null;
    /** `true` by default - can be overridden via gridOptions.isRowSelectable(rowNode) */
    this.selectable = true;
    /**
     * Used by sorting service - to give deterministic sort to groups. Previously we
     * just id for this, however id is a string and had slower sorting compared to numbers.
     * If re-naming this property, you must also update `IGNORED_SIBLING_PROPERTIES`
     */
    this.__objectId = OBJECT_ID_SEQUENCE++;
    /** `true` when nodes with the same id are being removed and added as part of the same batch transaction */
    this.alreadyRendered = false;
    this.hovered = false;
    this.__selected = false;
    this.beans = beans;
  }
  /**
   * Replaces the data on the `rowNode`. When this method is called, the grid refreshes the entire rendered row if it is displayed.
   */
  setData(data) {
    this.setDataCommon(data, false);
  }
  // similar to setRowData, however it is expected that the data is the same data item. this
  // is intended to be used with Redux type stores, where the whole data can be changed. we are
  // guaranteed that the data is the same entity (so grid doesn't need to worry about the id of the
  // underlying data changing, hence doesn't need to worry about selection). the grid, upon receiving
  // dataChanged event, refreshes the cells rather than rip them all out (so user can show transitions).
  /**
   * Updates the data on the `rowNode`. When this method is called, the grid refreshes the entire rendered row if it is displayed.
   */
  updateData(data) {
    this.setDataCommon(data, true);
  }
  setDataCommon(data, update) {
    const { valueCache, eventSvc } = this.beans;
    const oldData = this.data;
    this.data = data;
    valueCache?.onDataChanged();
    this.updateDataOnDetailNode();
    this.resetQuickFilterAggregateText();
    const event = this.createDataChangedEvent(data, oldData, update);
    this.__localEventService?.dispatchEvent(event);
    if (this.sibling) {
      this.sibling.data = data;
      const event2 = this.sibling.createDataChangedEvent(data, oldData, update);
      this.sibling.__localEventService?.dispatchEvent(event2);
    }
    eventSvc.dispatchEvent({ type: "rowNodeDataChanged", node: this });
    const pinnedSibling = this.pinnedSibling;
    if (pinnedSibling) {
      pinnedSibling.data = data;
      pinnedSibling.__localEventService?.dispatchEvent(
        pinnedSibling.createDataChangedEvent(data, oldData, update)
      );
      eventSvc.dispatchEvent({ type: "rowNodeDataChanged", node: pinnedSibling });
    }
  }
  // when we are doing master / detail, the detail node is lazy created, but then kept around.
  // so if we show / hide the detail, the same detail rowNode is used. so we need to keep the data
  // in sync, otherwise expand/collapse of the detail would still show the old values.
  updateDataOnDetailNode() {
    if (this.detailNode) {
      this.detailNode.data = this.data;
    }
  }
  createDataChangedEvent(newData, oldData, update) {
    return {
      type: "dataChanged",
      node: this,
      oldData,
      newData,
      update
    };
  }
  getRowIndexString() {
    if (this.rowIndex == null) {
      _error(13);
      return null;
    }
    if (this.rowPinned === "top") {
      return ROW_ID_PREFIX_TOP_PINNED + this.rowIndex;
    }
    if (this.rowPinned === "bottom") {
      return ROW_ID_PREFIX_BOTTOM_PINNED + this.rowIndex;
    }
    return this.rowIndex.toString();
  }
  setDataAndId(data, id) {
    const { selectionSvc } = this.beans;
    const oldNode = selectionSvc?.createDaemonNode?.(this);
    const oldData = this.data;
    this.data = data;
    this.updateDataOnDetailNode();
    this.setId(id);
    if (selectionSvc) {
      selectionSvc.updateRowSelectable(this);
      selectionSvc.syncInRowNode(this, oldNode);
    }
    const event = this.createDataChangedEvent(data, oldData, false);
    this.__localEventService?.dispatchEvent(event);
  }
  setId(id) {
    const getRowIdFunc = _getRowIdCallback(this.beans.gos);
    if (getRowIdFunc) {
      if (this.data) {
        const parentKeys = this.parent?.getRoute() ?? [];
        this.id = getRowIdFunc({
          data: this.data,
          parentKeys: parentKeys.length > 0 ? parentKeys : void 0,
          level: this.level,
          rowPinned: this.rowPinned
        });
        if (this.id.startsWith(ROW_ID_PREFIX_ROW_GROUP)) {
          _error(14, {
            groupPrefix: ROW_ID_PREFIX_ROW_GROUP
          });
        }
      } else {
        this.id = void 0;
      }
    } else {
      this.id = id;
    }
  }
  setRowTop(rowTop) {
    this.oldRowTop = this.rowTop;
    if (this.rowTop === rowTop) {
      return;
    }
    this.rowTop = rowTop;
    this.dispatchRowEvent("topChanged");
    this.setDisplayed(rowTop !== null);
  }
  clearRowTopAndRowIndex() {
    this.oldRowTop = null;
    this.setRowTop(null);
    this.setRowIndex(null);
  }
  setHovered(hovered) {
    this.hovered = hovered;
  }
  isHovered() {
    return this.hovered;
  }
  /**
   * Sets the row height.
   * Call if you want to change the height initially assigned to the row.
   * After calling, you must call `api.onRowHeightChanged()` so the grid knows it needs to work out the placement of the rows. */
  setRowHeight(rowHeight, estimated = false) {
    this.rowHeight = rowHeight;
    this.rowHeightEstimated = estimated;
    this.dispatchRowEvent("heightChanged");
  }
  setExpanded(expanded, e, forceSync) {
    this.beans.expansionSvc?.setExpanded(this, expanded, e, forceSync);
  }
  /**
   * Replaces the value on the `rowNode` for the specified column. When complete,
   * the grid refreshes the rendered cell on the required row only.
   * **Note**: This method only fires `onCellEditRequest` when the Grid is in **Read Only** mode.
   * **Note**: This method defers to EditModule if available and batches the edit when `fullRow` or `batchEdit` is enabled.
   *
   * @param colKey The column where the value should be updated
   * @param newValue The new value
   * @param eventSource The source of the event
   * @returns `true` if the value was changed, otherwise `false`.
   */
  setDataValue(colKey, newValue, eventSource) {
    const { colModel, valueSvc, gos, editSvc } = this.beans;
    const column = typeof colKey !== "string" ? colKey : colModel.getCol(colKey) ?? colModel.getColDefCol(colKey);
    if (!column) {
      return false;
    }
    const oldValue = valueSvc.getValueForDisplay(column, this, void 0, void 0, "api").value;
    if (gos.get("readOnlyEdit")) {
      const {
        beans: { eventSvc },
        data,
        rowIndex,
        rowPinned
      } = this;
      eventSvc.dispatchEvent({
        type: "cellEditRequest",
        event: null,
        rowIndex,
        rowPinned,
        column,
        colDef: column.colDef,
        data,
        node: this,
        oldValue,
        newValue,
        value: newValue,
        source: eventSource
      });
      return false;
    }
    if (editSvc) {
      const result = editSvc.setDataValue({ rowNode: this, column }, newValue, eventSource);
      if (result != null) {
        return result;
      }
    }
    const valueChanged = valueSvc.setValue(this, column, newValue, eventSource);
    this.dispatchCellChangedEvent(column, newValue, oldValue);
    const pinnedSibling = this.pinnedSibling;
    if (pinnedSibling) {
      if (valueChanged) {
        pinnedSibling.dispatchCellChangedEvent(column, newValue, oldValue);
      }
    }
    return valueChanged;
  }
  updateHasChildren() {
    let newValue = this.group && !this.footer || this.childrenAfterGroup && this.childrenAfterGroup.length > 0;
    const { rowChildrenSvc } = this.beans;
    if (rowChildrenSvc) {
      newValue = rowChildrenSvc.getHasChildrenValue(this);
    }
    if (newValue !== this.__hasChildren) {
      this.__hasChildren = !!newValue;
      this.dispatchRowEvent("hasChildrenChanged");
    }
  }
  hasChildren() {
    if (this.__hasChildren == null) {
      this.updateHasChildren();
    }
    return this.__hasChildren;
  }
  dispatchCellChangedEvent(column, newValue, oldValue) {
    const cellChangedEvent = {
      type: "cellChanged",
      node: this,
      column,
      newValue,
      oldValue
    };
    this.__localEventService?.dispatchEvent(cellChangedEvent);
  }
  /**
   * The first time `quickFilter` runs, the grid creates a one-off string representation of the row.
   * This string is then used for the quick filter instead of hitting each column separately.
   * When you edit, using grid editing, this string gets cleared down.
   * However, if you edit without using grid editing, you need to clear this string down for the row to be updated with the new values.
   * Otherwise, new values would not work with the `quickFilter`. */
  resetQuickFilterAggregateText() {
    this.quickFilterAggregateText = null;
  }
  /** Returns:
   * - `true` if the node can be expanded, i.e it is a group or master row.
   * - `false` if the node cannot be expanded
   */
  isExpandable() {
    return this.beans.expansionSvc?.isExpandable(this) ?? false;
  }
  /** Returns:
   * - `true` if node is selected,
   * - `false` if the node isn't selected
   * - `undefined` if it's partially selected (group where not all children are selected). */
  isSelected() {
    if (this.footer) {
      return this.sibling.isSelected();
    }
    if (this.rowPinned && this.pinnedSibling) {
      return this.pinnedSibling.isSelected();
    }
    return this.__selected;
  }
  /** Perform a depth-first search of this node and its children. */
  depthFirstSearch(callback) {
    this.childrenAfterGroup?.forEach((child) => child.depthFirstSearch(callback));
    callback(this);
  }
  dispatchRowEvent(type) {
    this.__localEventService?.dispatchEvent({
      type,
      node: this
    });
  }
  /**
   * Select (or deselect) the node.
   * @param newValue -`true` for selection, `false` for deselection.
   * @param clearSelection - If selecting, then passing `true` selects the node exclusively (i.e. NOT do multi select). If doing deselection, `clearSelection` has no impact.
   * @param source - Source property that appears in the `selectionChanged` event.
   */
  setSelected(newValue, clearSelection = false, source = "api") {
    this.beans.selectionSvc?.setNodesSelected({
      nodes: [this],
      newValue,
      clearSelection,
      source
    });
  }
  /**
   * Returns:
   * - `true` if node is either pinned to the `top` or `bottom`
   * - `false` if the node isn't pinned
   */
  isRowPinned() {
    return !!this.rowPinned;
  }
  __addEventListener(eventType, listener) {
    if (!this.__localEventService) {
      this.__localEventService = new LocalEventService();
    }
    this.__localEventService.addEventListener(eventType, listener);
  }
  __removeEventListener(eventType, listener) {
    this.removeLocalListener(eventType, listener);
  }
  /**
   * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
   */
  addEventListener(eventType, userListener) {
    this.beans.validation?.checkRowEvents(eventType);
    if (!this.__localEventService) {
      this.__localEventService = new LocalEventService();
    }
    this.frameworkEventListenerService = this.beans.frameworkOverrides.createLocalEventListenerWrapper?.(
      this.frameworkEventListenerService,
      this.__localEventService
    );
    const listener = this.frameworkEventListenerService?.wrap(eventType, userListener) ?? userListener;
    this.__localEventService.addEventListener(eventType, listener);
  }
  /**
   * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
   */
  removeEventListener(eventType, userListener) {
    const listener = this.frameworkEventListenerService?.unwrap(eventType, userListener) ?? userListener;
    this.removeLocalListener(eventType, listener);
  }
  removeLocalListener(eventType, listener) {
    this.__localEventService?.removeEventListener(eventType, listener);
    if (this.__localEventService?.noRegisteredListenersExist()) {
      this.__localEventService = null;
    }
  }
  /**
   * @deprecated v32.2.0 Check `node.detail` then user provided callback `isFullWidthRow` instead.
   *
   * Returns:
   * - `true` if the node is a full width cell
   * - `false` if the node is not a full width cell
   */
  isFullWidthCell() {
    _warn(61);
    if (this.detail) {
      return true;
    }
    const isFullWidthCellFunc = this.beans.gos.getCallback("isFullWidthRow");
    return isFullWidthCellFunc ? isFullWidthCellFunc({ rowNode: this }) : false;
  }
  /**
   * Returns the route of keys to the row node. Returns undefined if the node has no key.
   */
  getRoute() {
    if (this.level === -1) {
      return [];
    }
    if (this.key == null) {
      return void 0;
    }
    const res = [];
    let pointer = this;
    while (pointer && pointer.key != null) {
      res.push(pointer.key);
      pointer = pointer.parent;
    }
    return res.reverse();
  }
  setFirstChild(firstChild) {
    if (this.firstChild !== firstChild) {
      this.firstChild = firstChild;
      this.dispatchRowEvent("firstChildChanged");
    }
  }
  setDisplayed(displayed) {
    if (this.displayed !== displayed) {
      this.displayed = displayed;
      this.dispatchRowEvent("displayedChanged");
    }
  }
  setRowIndex(rowIndex) {
    if (this.rowIndex !== rowIndex) {
      this.rowIndex = rowIndex;
      this.dispatchRowEvent("rowIndexChanged");
    }
  }
  setAllChildrenCount(allChildrenCount) {
    if (this.allChildrenCount !== allChildrenCount) {
      this.allChildrenCount = allChildrenCount;
      this.dispatchRowEvent("allChildrenCountChanged");
    }
  }
  setUiLevel(uiLevel) {
    if (this.uiLevel !== uiLevel) {
      this.uiLevel = uiLevel;
      this.dispatchRowEvent("uiLevelChanged");
    }
  }
  getFirstChild() {
    if (this.childStore) {
      return this.childStore.getFirstNode();
    }
    return this.childrenAfterSort?.[0] ?? null;
  }
};

// packages/ag-grid-community/src/entities/rowNodeUtils.ts
function _createGlobalRowEvent(rowNode, gos, type) {
  return _addGridCommonParams(gos, {
    type,
    node: rowNode,
    data: rowNode.data,
    rowIndex: rowNode.rowIndex,
    rowPinned: rowNode.rowPinned
  });
}
var IGNORED_SIBLING_PROPERTIES = /* @__PURE__ */ new Set(["__localEventService", "__objectId", "sticky", "__autoHeights", "__checkAutoHeightsDebounced", "childStore"]);
function _createRowNodeSibling(rowNode, beans) {
  const sibling = new RowNode(beans);
  Object.keys(rowNode).forEach((key) => {
    if (IGNORED_SIBLING_PROPERTIES.has(key)) {
      return;
    }
    sibling[key] = rowNode[key];
  });
  sibling.oldRowTop = null;
  return sibling;
}

// packages/ag-grid-community/src/filter/columnFilterUtils.ts
var FILTER_HANDLER_MAP = {
  agSetColumnFilter: "agSetColumnFilterHandler",
  agMultiColumnFilter: "agMultiColumnFilterHandler",
  agGroupColumnFilter: "agGroupColumnFilterHandler",
  agNumberColumnFilter: "agNumberColumnFilterHandler",
  agDateColumnFilter: "agDateColumnFilterHandler",
  agTextColumnFilter: "agTextColumnFilterHandler"
};
var FILTER_HANDLERS = new Set(Object.values(FILTER_HANDLER_MAP));
function getFilterUiFromWrapper(filterWrapper, skipCreate) {
  const filterUi = filterWrapper.filterUi;
  if (!filterUi) {
    return null;
  }
  if (filterUi.created) {
    return filterUi.promise;
  }
  if (skipCreate) {
    return null;
  }
  const promise = filterUi.create(filterUi.refreshed);
  const createdFilterUi = filterUi;
  createdFilterUi.created = true;
  createdFilterUi.promise = promise;
  return promise;
}
function _refreshHandlerAndUi(getFilterUi, handler, handlerParams, model, state, source) {
  handler.refresh?.({ ...handlerParams, model, source });
  return getFilterUi().then((filterUi) => {
    if (filterUi) {
      const { filter, filterParams } = filterUi;
      _refreshFilterUi(filter, filterParams, model, state, source);
    }
  });
}
function _refreshFilterUi(filter, filterParams, model, state, source) {
  filter?.refresh?.({
    ...filterParams,
    model,
    state,
    source
  });
}
function getAndRefreshFilterUi(getFilterUi, getModel, getState2) {
  const filterUi = getFilterUi();
  if (filterUi?.created) {
    filterUi.promise.then((filter) => {
      const model = getModel();
      _refreshFilterUi(filter, filterUi.filterParams, model, getState2() ?? { model }, "ui");
    });
  }
}
function _updateFilterModel(action, getFilterUi, getModel, getState2, updateState, updateModel) {
  let state;
  let shouldUpdateModel = false;
  let model;
  switch (action) {
    case "apply": {
      const oldState = getState2();
      model = oldState?.model ?? null;
      state = {
        // keep the other UI state
        state: oldState?.state,
        model
      };
      shouldUpdateModel = true;
      break;
    }
    case "clear": {
      state = {
        // wipe other UI state
        model: null
      };
      break;
    }
    case "reset": {
      state = {
        // wipe other UI state
        model: null
      };
      shouldUpdateModel = true;
      model = null;
      break;
    }
    case "cancel": {
      state = {
        // wipe other UI state
        model: getModel()
      };
      break;
    }
  }
  updateState(state);
  if (shouldUpdateModel) {
    updateModel(model);
  } else {
    getAndRefreshFilterUi(getFilterUi, getModel, getState2);
  }
}
function _getFilterModel(model, colId) {
  return model[colId] ?? null;
}

// packages/ag-grid-community/src/filter/filterButtonComp.ts
function getElement(className) {
  return {
    tag: "div",
    cls: className
  };
}
var FilterButtonComp = class extends Component {
  constructor(config) {
    const { className = "ag-filter-apply-panel" } = config ?? {};
    super(getElement(className));
    this.listeners = [];
    this.validationMessage = null;
    this.className = className;
  }
  updateButtons(buttons, useForm) {
    const oldButtons = this.buttons;
    this.buttons = buttons;
    if (oldButtons === buttons) {
      return;
    }
    const eGui = this.getGui();
    _clearElement(eGui);
    let eApplyButton;
    this.destroyListeners();
    const fragment = document.createDocumentFragment();
    const className = this.className;
    const addButton = ({ type, label }) => {
      const clickListener = (event) => {
        this.dispatchLocalEvent({
          type,
          event
        });
      };
      if (!["apply", "clear", "reset", "cancel"].includes(type)) {
        _warn(75);
      }
      const isApply = type === "apply";
      const buttonType = isApply && useForm ? "submit" : "button";
      const button = _createElement({
        tag: "button",
        attrs: { type: buttonType },
        ref: `${type}FilterButton`,
        cls: `ag-button ag-standard-button ${className}-button${isApply ? " " + className + "-apply-button" : ""}`,
        children: label
      });
      this.activateTabIndex([button]);
      if (isApply) {
        eApplyButton = button;
      }
      const keydownListener = (event) => {
        if (event.key === KeyCode.ENTER) {
          event.preventDefault();
          clickListener(event);
        }
      };
      const listeners = this.listeners;
      button.addEventListener("click", clickListener);
      listeners.push(() => button.removeEventListener("click", clickListener));
      button.addEventListener("keydown", keydownListener);
      listeners.push(() => button.removeEventListener("keydown", keydownListener));
      fragment.append(button);
    };
    buttons.forEach((button) => addButton(button));
    this.eApply = eApplyButton;
    const tooltip = this.validationTooltipFeature;
    if (eApplyButton && !tooltip) {
      this.validationTooltipFeature = this.createOptionalManagedBean(
        this.beans.registry.createDynamicBean("tooltipFeature", false, {
          getGui: () => this.eApply,
          getLocation: () => "advancedFilter",
          getTooltipShowDelayOverride: () => 1e3
        })
      );
    } else if (!eApplyButton && tooltip) {
      this.validationTooltipFeature = this.destroyBean(tooltip);
    }
    eGui.append(fragment);
  }
  getApplyButton() {
    return this.eApply;
  }
  updateValidity(valid, message = null) {
    const eApplyButton = this.eApply;
    if (!eApplyButton) {
      return;
    }
    _setDisabled(eApplyButton, valid === false);
    this.validationMessage = message ?? null;
    this.validationTooltipFeature?.setTooltipAndRefresh(this.validationMessage);
  }
  destroyListeners() {
    this.listeners.forEach((destroyFunc) => destroyFunc());
    this.listeners = [];
  }
  destroy() {
    this.destroyListeners();
    super.destroy();
  }
};
var AgFilterButtonSelector = {
  selector: "AG-FILTER-BUTTON",
  component: FilterButtonComp
};

// packages/ag-grid-community/src/filter/filterLocaleText.ts
var FILTER_LOCALE_TEXT = {
  applyFilter: "Apply",
  clearFilter: "Clear",
  resetFilter: "Reset",
  cancelFilter: "Cancel",
  textFilter: "Text Filter",
  numberFilter: "Number Filter",
  dateFilter: "Date Filter",
  setFilter: "Set Filter",
  filterOoo: "Filter...",
  empty: "Choose one",
  equals: "Equals",
  notEqual: "Does not equal",
  lessThan: "Less than",
  greaterThan: "Greater than",
  inRange: "Between",
  inRangeStart: "From",
  inRangeEnd: "To",
  lessThanOrEqual: "Less than or equal to",
  greaterThanOrEqual: "Greater than or equal to",
  contains: "Contains",
  notContains: "Does not contain",
  startsWith: "Begins with",
  endsWith: "Ends with",
  blank: "Blank",
  notBlank: "Not blank",
  before: "Before",
  after: "After",
  andCondition: "AND",
  orCondition: "OR",
  dateFormatOoo: "yyyy-mm-dd",
  filterSummaryInactive: "is (All)",
  filterSummaryContains: "contains",
  filterSummaryNotContains: "does not contain",
  filterSummaryTextEquals: "equals",
  filterSummaryTextNotEqual: "does not equal",
  filterSummaryStartsWith: "begins with",
  filterSummaryEndsWith: "ends with",
  filterSummaryBlank: "is blank",
  filterSummaryNotBlank: "is not blank",
  filterSummaryEquals: "=",
  filterSummaryNotEqual: "!=",
  filterSummaryGreaterThan: ">",
  filterSummaryGreaterThanOrEqual: ">=",
  filterSummaryLessThan: "<",
  filterSummaryLessThanOrEqual: "<=",
  filterSummaryInRange: "between",
  filterSummaryInRangeValues: (variableValues) => `(${variableValues[0]}, ${variableValues[1]})`,
  filterSummaryTextQuote: (variableValues) => `"${variableValues[0]}"`
};
function translateForFilter(bean, key, variableValues) {
  return _translate(bean, FILTER_LOCALE_TEXT, key, variableValues);
}

// packages/ag-grid-community/src/filter/provided/providedFilterUtils.ts
function getDebounceMs(params, debounceDefault) {
  const { debounceMs } = params;
  if (_isUseApplyButton(params)) {
    if (debounceMs != null) {
      _warn(71);
    }
    return 0;
  }
  return debounceMs ?? debounceDefault;
}
function _isUseApplyButton(params) {
  return (params.buttons?.indexOf("apply") ?? -1) >= 0;
}

// packages/ag-grid-community/src/filter/filterWrapperComp.ts
var FilterWrapperComp = class extends Component {
  constructor(column, wrapper, eventParent, updateModel, isGlobalButtons, enableGlobalButtonCheck) {
    super();
    this.column = column;
    this.wrapper = wrapper;
    this.eventParent = eventParent;
    this.updateModel = updateModel;
    this.isGlobalButtons = isGlobalButtons;
    this.enableGlobalButtonCheck = enableGlobalButtonCheck;
    this.hidePopup = null;
    this.applyActive = false;
  }
  postConstruct() {
    const { comp, params: originalParams } = this.wrapper;
    const params = originalParams;
    const useForm = params.useForm;
    const tag = useForm ? "form" : "div";
    this.setTemplate({
      tag,
      cls: "ag-filter-wrapper"
    });
    if (useForm) {
      this.addManagedElementListeners(this.getGui(), {
        submit: (e) => {
          e?.preventDefault();
        },
        keydown: this.handleKeyDown.bind(this)
      });
    }
    this.appendChild(comp.getGui());
    this.params = params;
    this.resetButtonsPanel(params);
    this.addManagedListeners(this.eventParent, {
      filterParamsChanged: ({ column, params: eventParams }) => {
        if (column === this.column) {
          this.resetButtonsPanel(eventParams, this.params);
        }
      },
      filterStateChanged: ({ column, state }) => {
        if (column === this.column) {
          this.eButtons?.updateValidity(state.valid !== false);
        }
      },
      filterAction: ({ column, action, event: keyboardEvent }) => {
        if (column === this.column) {
          this.afterAction(action, keyboardEvent);
        }
      },
      ...this.enableGlobalButtonCheck ? {
        filterGlobalButtons: ({ isGlobal }) => {
          if (isGlobal !== this.isGlobalButtons) {
            this.isGlobalButtons = isGlobal;
            const currentParams = this.params;
            this.resetButtonsPanel(currentParams, currentParams, true);
          }
        }
      } : void 0
    });
  }
  afterGuiAttached(params) {
    if (params) {
      this.hidePopup = params.hidePopup;
    }
  }
  resetButtonsPanel(newParams, oldParams, forceUpdate) {
    const { buttons: oldButtons, readOnly: oldReadOnly } = oldParams ?? {};
    const { buttons: newButtons, readOnly, useForm } = newParams;
    if (!forceUpdate && oldReadOnly === readOnly && _jsonEquals(oldButtons, newButtons)) {
      return;
    }
    const hasButtons = newButtons && newButtons.length > 0 && !newParams.readOnly && !this.isGlobalButtons;
    let eButtonsPanel = this.eButtons;
    if (hasButtons) {
      const buttons = newButtons.map((type) => {
        const localeKey = `${type}Filter`;
        return { type, label: translateForFilter(this, localeKey) };
      });
      this.applyActive = _isUseApplyButton(this.params);
      if (!eButtonsPanel) {
        eButtonsPanel = this.createBean(new FilterButtonComp());
        this.appendChild(eButtonsPanel.getGui());
        const column = this.column;
        const getListener = (action) => ({ event }) => {
          this.updateModel(column, action);
          this.afterAction(action, event);
        };
        eButtonsPanel?.addManagedListeners(eButtonsPanel, {
          apply: getListener("apply"),
          clear: getListener("clear"),
          reset: getListener("reset"),
          cancel: getListener("cancel")
        });
        this.eButtons = eButtonsPanel;
      }
      eButtonsPanel.updateButtons(buttons, useForm);
    } else {
      this.applyActive = false;
      if (eButtonsPanel) {
        _removeFromParent(eButtonsPanel.getGui());
        this.eButtons = this.destroyBean(eButtonsPanel);
      }
    }
  }
  close(e) {
    const hidePopup = this.hidePopup;
    if (!hidePopup) {
      return;
    }
    const keyboardEvent = e;
    const key = keyboardEvent && keyboardEvent.key;
    let params;
    if (key === KeyCode.ENTER || key === KeyCode.SPACE) {
      params = { keyboardEvent };
    }
    hidePopup(params);
    this.hidePopup = null;
  }
  afterAction(action, event) {
    const { params, applyActive } = this;
    const closeOnApply = params?.closeOnApply;
    switch (action) {
      case "apply": {
        event?.preventDefault();
        if (closeOnApply && applyActive) {
          this.close(event);
        }
        break;
      }
      case "reset": {
        if (closeOnApply && applyActive) {
          this.close();
        }
        break;
      }
      case "cancel": {
        if (closeOnApply) {
          this.close(event);
        }
        break;
      }
    }
  }
  handleKeyDown(event) {
    if (!event.defaultPrevented && event.key === KeyCode.ENTER && this.applyActive) {
      this.updateModel(this.column, "apply");
      this.afterAction("apply", event);
    }
  }
  destroy() {
    this.hidePopup = null;
    this.eButtons = this.destroyBean(this.eButtons);
  }
};

// packages/ag-grid-community/src/filter/filterComp.ts
var FilterElement = { tag: "div", cls: "ag-filter" };
var FilterComp = class extends Component {
  constructor(column, source, enableGlobalButtonCheck) {
    super(FilterElement);
    this.column = column;
    this.source = source;
    this.enableGlobalButtonCheck = enableGlobalButtonCheck;
    this.wrapper = null;
  }
  postConstruct() {
    this.beans.colFilter?.activeFilterComps.add(this);
    this.createFilter(true);
    this.addManagedEventListeners({ filterDestroyed: this.onFilterDestroyed.bind(this) });
  }
  hasFilter() {
    return this.wrapper != null;
  }
  getFilter() {
    return this.wrapper?.then((wrapper) => wrapper.comp) ?? null;
  }
  afterInit() {
    return this.wrapper?.then(() => {
    }) ?? AgPromise.resolve();
  }
  afterGuiAttached(params) {
    this.afterGuiAttachedParams = params;
    this.wrapper?.then((wrapper) => {
      this.comp?.afterGuiAttached(params);
      wrapper?.comp?.afterGuiAttached?.(params);
    });
  }
  afterGuiDetached() {
    this.wrapper?.then((wrapper) => {
      wrapper?.comp?.afterGuiDetached?.();
    });
  }
  createFilter(init) {
    const {
      column,
      source,
      beans: { colFilter }
    } = this;
    const filterPromise = colFilter.getFilterUiForDisplay(column) ?? null;
    this.wrapper = filterPromise;
    filterPromise?.then((wrapper) => {
      if (!wrapper) {
        return;
      }
      const { isHandler, comp } = wrapper;
      let filterGui;
      if (isHandler) {
        const enableGlobalButtonCheck = !!this.enableGlobalButtonCheck;
        const displayComp = this.createBean(
          new FilterWrapperComp(
            column,
            wrapper,
            colFilter,
            colFilter.updateModel.bind(colFilter),
            enableGlobalButtonCheck && colFilter.isGlobalButtons,
            enableGlobalButtonCheck
          )
        );
        this.comp = displayComp;
        filterGui = displayComp.getGui();
      } else {
        filterGui = comp.getGui();
        if (!_exists(filterGui)) {
          _warn(69, { guiFromFilter: filterGui });
        }
      }
      this.appendChild(filterGui);
      if (init) {
        this.eventSvc.dispatchEvent({
          type: "filterOpened",
          column,
          source,
          eGui: this.getGui()
        });
      } else {
        comp.afterGuiAttached?.(this.afterGuiAttachedParams);
      }
    });
  }
  onFilterDestroyed(event) {
    const { source, column } = event;
    if ((source === "api" || source === "paramsUpdated") && column.getId() === this.column.getId() && this.beans.colModel.getColDefCol(this.column)) {
      _clearElement(this.getGui());
      this.comp = this.destroyBean(this.comp);
      this.createFilter();
    }
  }
  destroy() {
    this.beans.colFilter?.activeFilterComps.delete(this);
    this.eventSvc.dispatchEvent({
      type: "filterClosed",
      column: this.column
    });
    this.wrapper = null;
    this.comp = this.destroyBean(this.comp);
    this.afterGuiAttachedParams = void 0;
    super.destroy();
  }
};

// packages/ag-grid-community/src/utils/date.ts
var DATE_TIME_SEPARATOR = "T";
var DATE_TIME_REGEXP = new RegExp(`^\\d{4}-\\d{2}-\\d{2}(${DATE_TIME_SEPARATOR}\\d{2}:\\d{2}:\\d{2}\\D?)?`);
function _padStartWidthZeros(value, totalStringSize) {
  return value.toString().padStart(totalStringSize, "0");
}
function _serialiseDate(date, includeTime = true, separator = "-") {
  if (!date) {
    return null;
  }
  let serialised = [date.getFullYear(), date.getMonth() + 1, date.getDate()].map((part) => _padStartWidthZeros(part, 2)).join(separator);
  if (includeTime) {
    serialised += DATE_TIME_SEPARATOR + [date.getHours(), date.getMinutes(), date.getSeconds()].map((part) => _padStartWidthZeros(part, 2)).join(":");
  }
  return serialised;
}
function _getDateParts(d, includeTime = true) {
  if (!d) {
    return null;
  }
  if (includeTime) {
    return [
      String(d.getFullYear()),
      String(d.getMonth() + 1),
      _padStartWidthZeros(d.getDate(), 2),
      _padStartWidthZeros(d.getHours(), 2),
      `:${_padStartWidthZeros(d.getMinutes(), 2)}`,
      `:${_padStartWidthZeros(d.getSeconds(), 2)}`
    ];
  }
  return [d.getFullYear(), d.getMonth() + 1, _padStartWidthZeros(d.getDate(), 2)].map(String);
}
var calculateOrdinal = (value) => {
  if (value > 3 && value < 21) {
    return "th";
  }
  const remainder = value % 10;
  switch (remainder) {
    case 1:
      return "st";
    case 2:
      return "nd";
    case 3:
      return "rd";
  }
  return "th";
};
function _dateToFormattedString(date, format) {
  if (format == null) {
    return _serialiseDate(date, false);
  }
  const fullYear = _padStartWidthZeros(date.getFullYear(), 4);
  const months = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December"
  ];
  const days = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
  const replace = {
    YYYY: () => fullYear.slice(fullYear.length - 4, fullYear.length),
    YY: () => fullYear.slice(fullYear.length - 2, fullYear.length),
    Y: () => `${date.getFullYear()}`,
    MMMM: () => months[date.getMonth()],
    MMM: () => months[date.getMonth()].slice(0, 3),
    MM: () => _padStartWidthZeros(date.getMonth() + 1, 2),
    Mo: () => `${date.getMonth() + 1}${calculateOrdinal(date.getMonth() + 1)}`,
    M: () => `${date.getMonth() + 1}`,
    Do: () => `${date.getDate()}${calculateOrdinal(date.getDate())}`,
    DD: () => _padStartWidthZeros(date.getDate(), 2),
    D: () => `${date.getDate()}`,
    dddd: () => days[date.getDay()],
    ddd: () => days[date.getDay()].slice(0, 3),
    dd: () => days[date.getDay()].slice(0, 2),
    do: () => `${date.getDay()}${calculateOrdinal(date.getDay())}`,
    d: () => `${date.getDay()}`
  };
  const regexp = new RegExp(Object.keys(replace).join("|"), "g");
  return format.replace(regexp, (match) => {
    if (match in replace) {
      return replace[match]();
    }
    return match;
  });
}
function _isValidDate(value, bailIfInvalidTime = false) {
  return !!_parseDateTimeFromString(value, bailIfInvalidTime);
}
function _isValidDateTime(value) {
  return _isValidDate(value, true);
}
function _parseDateTimeFromString(value, bailIfInvalidTime = false) {
  if (!value) {
    return null;
  }
  if (!DATE_TIME_REGEXP.test(value)) {
    return null;
  }
  const [dateStr, timeStr] = value.split(DATE_TIME_SEPARATOR);
  if (!dateStr) {
    return null;
  }
  const fields = dateStr.split("-").map((f) => parseInt(f, 10));
  if (fields.filter((f) => !isNaN(f)).length !== 3) {
    return null;
  }
  const [year, month, day] = fields;
  const date = new Date(year, month - 1, day);
  if (date.getFullYear() !== year || date.getMonth() !== month - 1 || date.getDate() !== day) {
    return null;
  }
  if (!timeStr && bailIfInvalidTime) {
    return null;
  }
  if (!timeStr || timeStr === "00:00:00") {
    return date;
  }
  const [hours, minutes, seconds] = timeStr.split(":").map((part) => parseInt(part, 10));
  if (hours >= 0 && hours < 24) {
    date.setHours(hours);
  } else if (bailIfInvalidTime) {
    return null;
  }
  if (minutes >= 0 && minutes < 60) {
    date.setMinutes(minutes);
  } else if (bailIfInvalidTime) {
    return null;
  }
  if (seconds >= 0 && seconds < 60) {
    date.setSeconds(seconds);
  } else if (bailIfInvalidTime) {
    return null;
  }
  return date;
}

// packages/ag-grid-community/src/filter/filterDataTypeUtils.ts
var MONTH_LOCALE_TEXT = {
  january: "January",
  february: "February",
  march: "March",
  april: "April",
  may: "May",
  june: "June",
  july: "July",
  august: "August",
  september: "September",
  october: "October",
  november: "November",
  december: "December"
};
var MONTH_KEYS = [
  "january",
  "february",
  "march",
  "april",
  "may",
  "june",
  "july",
  "august",
  "september",
  "october",
  "november",
  "december"
];
function setFilterNumberComparator(a, b) {
  if (a == null) {
    return -1;
  }
  if (b == null) {
    return 1;
  }
  return parseFloat(a) - parseFloat(b);
}
function isValidDate(value) {
  return value instanceof Date && !isNaN(value.getTime());
}
var filterParamsForEachDataType = {
  number: () => void 0,
  boolean: () => ({
    maxNumConditions: 1,
    debounceMs: 0,
    filterOptions: [
      "empty",
      {
        displayKey: "true",
        displayName: "True",
        predicate: (_filterValues, cellValue) => cellValue,
        numberOfInputs: 0
      },
      {
        displayKey: "false",
        displayName: "False",
        predicate: (_filterValues, cellValue) => cellValue === false,
        numberOfInputs: 0
      }
    ]
  }),
  date: () => ({ isValidDate }),
  dateString: ({ dataTypeDefinition }) => ({
    comparator: (filterDate, cellValue) => {
      const cellAsDate = dataTypeDefinition.dateParser(cellValue);
      if (cellValue == null || cellAsDate < filterDate) {
        return -1;
      }
      if (cellAsDate > filterDate) {
        return 1;
      }
      return 0;
    },
    isValidDate: (value) => typeof value === "string" && isValidDate(dataTypeDefinition.dateParser(value))
  }),
  dateTime: (args) => filterParamsForEachDataType.date(args),
  dateTimeString: (args) => filterParamsForEachDataType.dateString(args),
  object: () => void 0,
  text: () => void 0
};
var setFilterParamsForEachDataType = {
  number: () => ({ comparator: setFilterNumberComparator }),
  boolean: ({ t }) => ({
    valueFormatter: (params) => _exists(params.value) ? t(String(params.value), params.value ? "True" : "False") : t("blanks", "(Blanks)")
  }),
  date: ({ formatValue, t }) => ({
    valueFormatter: (params) => {
      const valueFormatted = formatValue(params);
      return _exists(valueFormatted) ? valueFormatted : t("blanks", "(Blanks)");
    },
    treeList: true,
    treeListFormatter: (pathKey, level) => {
      if (pathKey === "NaN") {
        return t("invalidDate", "Invalid Date");
      }
      if (level === 1 && pathKey != null) {
        const monthKey = MONTH_KEYS[Number(pathKey) - 1];
        return t(monthKey, MONTH_LOCALE_TEXT[monthKey]);
      }
      return pathKey ?? t("blanks", "(Blanks)");
    },
    treeListPathGetter: (date) => _getDateParts(date, false)
  }),
  dateString: ({ formatValue, dataTypeDefinition, t }) => ({
    valueFormatter: (params) => {
      const valueFormatted = formatValue(params);
      return _exists(valueFormatted) ? valueFormatted : t("blanks", "(Blanks)");
    },
    treeList: true,
    treeListPathGetter: (value) => _getDateParts(dataTypeDefinition.dateParser(value ?? void 0), false),
    treeListFormatter: (pathKey, level) => {
      if (level === 1 && pathKey != null) {
        const monthKey = MONTH_KEYS[Number(pathKey) - 1];
        return t(monthKey, MONTH_LOCALE_TEXT[monthKey]);
      }
      return pathKey ?? t("blanks", "(Blanks)");
    }
  }),
  dateTime: (args) => {
    const params = setFilterParamsForEachDataType.date(args);
    params.treeListPathGetter = _getDateParts;
    return params;
  },
  dateTimeString(args) {
    const convertToDate = args.dataTypeDefinition.dateParser;
    const params = setFilterParamsForEachDataType.dateString(args);
    params.treeListPathGetter = (value) => _getDateParts(convertToDate(value ?? void 0));
    return params;
  },
  object: ({ formatValue, t }) => ({
    valueFormatter: (params) => {
      const valueFormatted = formatValue(params);
      return _exists(valueFormatted) ? valueFormatted : t("blanks", "(Blanks)");
    }
  }),
  text: () => void 0
};
function _getFilterParamsForDataType(filter, existingFilterParams, existingFilterValueGetter, dataTypeDefinition, formatValue, beans, translate) {
  let filterParams = existingFilterParams;
  let filterValueGetter = existingFilterValueGetter;
  const usingSetFilter = filter === "agSetColumnFilter";
  if (!filterValueGetter && dataTypeDefinition.baseDataType === "object" && !usingSetFilter) {
    filterValueGetter = ({ column, node }) => formatValue({ column, node, value: beans.valueSvc.getValue(column, node) });
  }
  const filterParamsMap = usingSetFilter ? setFilterParamsForEachDataType : filterParamsForEachDataType;
  const filterParamsGetter = filterParamsMap[dataTypeDefinition.baseDataType];
  const newFilterParams = filterParamsGetter({ dataTypeDefinition, formatValue, t: translate });
  filterParams = typeof existingFilterParams === "object" ? {
    ...newFilterParams,
    ...existingFilterParams
  } : newFilterParams;
  return { filterParams, filterValueGetter };
}
var defaultFilters = {
  boolean: "agTextColumnFilter",
  date: "agDateColumnFilter",
  dateString: "agDateColumnFilter",
  dateTime: "agDateColumnFilter",
  dateTimeString: "agDateColumnFilter",
  number: "agNumberColumnFilter",
  object: "agTextColumnFilter",
  text: "agTextColumnFilter"
};
var defaultFloatingFilters = {
  boolean: "agTextColumnFloatingFilter",
  date: "agDateColumnFloatingFilter",
  dateString: "agDateColumnFloatingFilter",
  dateTime: "agDateColumnFloatingFilter",
  dateTimeString: "agDateColumnFloatingFilter",
  number: "agNumberColumnFloatingFilter",
  object: "agTextColumnFloatingFilter",
  text: "agTextColumnFloatingFilter"
};
function _getDefaultSimpleFilter(cellDataType, isFloating = false) {
  const filterSet = isFloating ? defaultFloatingFilters : defaultFilters;
  return filterSet[cellDataType ?? "text"];
}

// packages/ag-grid-community/src/rendering/features/positionableFeature.ts
var RESIZE_CONTAINER_STYLE = "ag-resizer-wrapper";
var makeDiv = (dataRefPrefix, classSuffix) => ({
  tag: "div",
  ref: `${dataRefPrefix}Resizer`,
  cls: `ag-resizer ag-resizer-${classSuffix}`
});
var RESIZE_TEMPLATE = {
  tag: "div",
  cls: RESIZE_CONTAINER_STYLE,
  children: [
    makeDiv("eTopLeft", "topLeft"),
    makeDiv("eTop", "top"),
    makeDiv("eTopRight", "topRight"),
    makeDiv("eRight", "right"),
    makeDiv("eBottomRight", "bottomRight"),
    makeDiv("eBottom", "bottom"),
    makeDiv("eBottomLeft", "bottomLeft"),
    makeDiv("eLeft", "left")
  ]
};
var PositionableFeature = class extends BeanStub {
  constructor(element, config) {
    super();
    this.element = element;
    this.dragStartPosition = {
      x: 0,
      y: 0
    };
    this.position = {
      x: 0,
      y: 0
    };
    this.lastSize = {
      width: -1,
      height: -1
    };
    this.positioned = false;
    this.resizersAdded = false;
    this.resizeListeners = [];
    this.boundaryEl = null;
    this.isResizing = false;
    this.isMoving = false;
    this.resizable = {};
    this.movable = false;
    this.currentResizer = null;
    this.config = Object.assign({}, { popup: false }, config);
  }
  wireBeans(beans) {
    this.popupSvc = beans.popupSvc;
    this.dragSvc = beans.dragSvc;
  }
  center(postProcessCallback) {
    const { clientHeight, clientWidth } = this.offsetParent;
    const x = clientWidth / 2 - this.getWidth() / 2;
    const y = clientHeight / 2 - this.getHeight() / 2;
    this.offsetElement(x, y, postProcessCallback);
  }
  initialisePosition(postProcessCallback) {
    if (this.positioned) {
      return;
    }
    const { centered, forcePopupParentAsOffsetParent, minWidth, width, minHeight, height, x, y } = this.config;
    if (!this.offsetParent) {
      this.setOffsetParent();
    }
    let computedMinHeight = 0;
    let computedMinWidth = 0;
    const isElementVisible = _isVisible(this.element);
    if (isElementVisible) {
      const boundaryEl = this.findBoundaryElement();
      const offsetParentComputedStyles = window.getComputedStyle(boundaryEl);
      if (offsetParentComputedStyles.minWidth != null) {
        const paddingWidth = boundaryEl.offsetWidth - this.element.offsetWidth;
        computedMinWidth = parseInt(offsetParentComputedStyles.minWidth, 10) - paddingWidth;
      }
      if (offsetParentComputedStyles.minHeight != null) {
        const paddingHeight = boundaryEl.offsetHeight - this.element.offsetHeight;
        computedMinHeight = parseInt(offsetParentComputedStyles.minHeight, 10) - paddingHeight;
      }
    }
    this.minHeight = minHeight || computedMinHeight;
    this.minWidth = minWidth || computedMinWidth;
    if (width) {
      this.setWidth(width);
    }
    if (height) {
      this.setHeight(height);
    }
    if (!width || !height) {
      this.refreshSize();
    }
    if (centered) {
      this.center(postProcessCallback);
    } else if (x || y) {
      this.offsetElement(x, y, postProcessCallback);
    } else if (isElementVisible && forcePopupParentAsOffsetParent) {
      let boundaryEl = this.boundaryEl;
      let initialisedDuringPositioning = true;
      if (!boundaryEl) {
        boundaryEl = this.findBoundaryElement();
        initialisedDuringPositioning = false;
      }
      if (boundaryEl) {
        const top = parseFloat(boundaryEl.style.top);
        const left = parseFloat(boundaryEl.style.left);
        if (initialisedDuringPositioning) {
          this.offsetElement(isNaN(left) ? 0 : left, isNaN(top) ? 0 : top, postProcessCallback);
        } else {
          this.setPosition(left, top);
        }
      }
    }
    this.positioned = !!this.offsetParent;
  }
  isPositioned() {
    return this.positioned;
  }
  getPosition() {
    return this.position;
  }
  setMovable(movable, moveElement) {
    if (!this.config.popup || movable === this.movable) {
      return;
    }
    this.movable = movable;
    const params = this.moveElementDragListener || {
      eElement: moveElement,
      onDragStart: this.onMoveStart.bind(this),
      onDragging: this.onMove.bind(this),
      onDragStop: this.onMoveEnd.bind(this)
    };
    if (movable) {
      this.dragSvc?.addDragSource(params);
      this.moveElementDragListener = params;
    } else {
      this.dragSvc?.removeDragSource(params);
      this.moveElementDragListener = void 0;
    }
  }
  setResizable(resizable) {
    this.clearResizeListeners();
    if (resizable) {
      this.addResizers();
    } else {
      this.removeResizers();
    }
    if (typeof resizable === "boolean") {
      if (resizable === false) {
        return;
      }
      resizable = {
        topLeft: resizable,
        top: resizable,
        topRight: resizable,
        right: resizable,
        bottomRight: resizable,
        bottom: resizable,
        bottomLeft: resizable,
        left: resizable
      };
    }
    Object.keys(resizable).forEach((side) => {
      const resizableStructure = resizable;
      const isSideResizable = !!resizableStructure[side];
      const resizerEl = this.getResizerElement(side);
      const params = {
        dragStartPixels: 0,
        eElement: resizerEl,
        onDragStart: (e) => this.onResizeStart(e, side),
        onDragging: this.onResize.bind(this),
        onDragStop: (e) => this.onResizeEnd(e, side)
      };
      if (isSideResizable || !this.isAlive() && !isSideResizable) {
        if (isSideResizable) {
          this.dragSvc?.addDragSource(params);
          this.resizeListeners.push(params);
          resizerEl.style.pointerEvents = "all";
        } else {
          resizerEl.style.pointerEvents = "none";
        }
        this.resizable[side] = isSideResizable;
      }
    });
  }
  removeSizeFromEl() {
    this.element.style.removeProperty("height");
    this.element.style.removeProperty("width");
    this.element.style.removeProperty("flex");
  }
  restoreLastSize() {
    this.element.style.flex = "0 0 auto";
    const { height, width } = this.lastSize;
    if (width !== -1) {
      this.element.style.width = `${width}px`;
    }
    if (height !== -1) {
      this.element.style.height = `${height}px`;
    }
  }
  getHeight() {
    return this.element.offsetHeight;
  }
  setHeight(height) {
    const { popup } = this.config;
    const eGui = this.element;
    let isPercent = false;
    if (typeof height === "string" && height.indexOf("%") !== -1) {
      _setFixedHeight(eGui, height);
      height = _getAbsoluteHeight(eGui);
      isPercent = true;
    } else {
      height = Math.max(this.minHeight, height);
      if (this.positioned) {
        const availableHeight = this.getAvailableHeight();
        if (availableHeight && height > availableHeight) {
          height = availableHeight;
        }
      }
    }
    if (this.getHeight() === height) {
      return;
    }
    if (!isPercent) {
      if (popup) {
        _setFixedHeight(eGui, height);
      } else {
        eGui.style.height = `${height}px`;
        eGui.style.flex = "0 0 auto";
        this.lastSize.height = typeof height === "number" ? height : parseFloat(height);
      }
    } else {
      eGui.style.maxHeight = "unset";
      eGui.style.minHeight = "unset";
    }
  }
  getAvailableHeight() {
    const { popup, forcePopupParentAsOffsetParent } = this.config;
    if (!this.positioned) {
      this.initialisePosition();
    }
    const { clientHeight } = this.offsetParent;
    if (!clientHeight) {
      return null;
    }
    const elRect = this.element.getBoundingClientRect();
    const offsetParentRect = this.offsetParent.getBoundingClientRect();
    const yPosition = popup ? this.position.y : elRect.top;
    const parentTop = popup ? 0 : offsetParentRect.top;
    let additionalHeight = 0;
    if (forcePopupParentAsOffsetParent) {
      const parentEl = this.element.parentElement;
      if (parentEl) {
        const { bottom } = parentEl.getBoundingClientRect();
        additionalHeight = bottom - elRect.bottom;
      }
    }
    const availableHeight = clientHeight + parentTop - yPosition - additionalHeight;
    return availableHeight;
  }
  getWidth() {
    return this.element.offsetWidth;
  }
  setWidth(width) {
    const eGui = this.element;
    const { popup } = this.config;
    let isPercent = false;
    if (typeof width === "string" && width.indexOf("%") !== -1) {
      _setFixedWidth(eGui, width);
      width = _getAbsoluteWidth(eGui);
      isPercent = true;
    } else if (this.positioned) {
      width = Math.max(this.minWidth, width);
      const { clientWidth } = this.offsetParent;
      const xPosition = popup ? this.position.x : this.element.getBoundingClientRect().left;
      if (clientWidth && width + xPosition > clientWidth) {
        width = clientWidth - xPosition;
      }
    }
    if (this.getWidth() === width) {
      return;
    }
    if (!isPercent) {
      if (this.config.popup) {
        _setFixedWidth(eGui, width);
      } else {
        eGui.style.width = `${width}px`;
        eGui.style.flex = " unset";
        this.lastSize.width = typeof width === "number" ? width : parseFloat(width);
      }
    } else {
      eGui.style.maxWidth = "unset";
      eGui.style.minWidth = "unset";
    }
  }
  offsetElement(x = 0, y = 0, postProcessCallback) {
    const { forcePopupParentAsOffsetParent } = this.config;
    const ePopup = forcePopupParentAsOffsetParent ? this.boundaryEl : this.element;
    if (!ePopup) {
      return;
    }
    this.popupSvc?.positionPopup({
      ePopup,
      keepWithinBounds: true,
      skipObserver: this.movable || this.isResizable(),
      updatePosition: () => ({ x, y }),
      postProcessCallback
    });
    this.setPosition(parseFloat(ePopup.style.left), parseFloat(ePopup.style.top));
  }
  constrainSizeToAvailableHeight(constrain) {
    if (!this.config.forcePopupParentAsOffsetParent) {
      return;
    }
    const applyMaxHeightToElement = () => {
      const availableHeight = this.getAvailableHeight();
      this.element.style.setProperty("max-height", `${availableHeight}px`);
    };
    if (constrain && this.popupSvc) {
      this.resizeObserverSubscriber?.();
      this.resizeObserverSubscriber = _observeResize(
        this.beans,
        this.popupSvc?.getPopupParent(),
        applyMaxHeightToElement
      );
    } else {
      this.element.style.removeProperty("max-height");
      if (this.resizeObserverSubscriber) {
        this.resizeObserverSubscriber();
        this.resizeObserverSubscriber = void 0;
      }
    }
  }
  setPosition(x, y) {
    this.position.x = x;
    this.position.y = y;
  }
  updateDragStartPosition(x, y) {
    this.dragStartPosition = { x, y };
  }
  calculateMouseMovement(params) {
    const { e, isLeft, isTop, anywhereWithin, topBuffer } = params;
    const xDiff = e.clientX - this.dragStartPosition.x;
    const yDiff = e.clientY - this.dragStartPosition.y;
    const movementX = this.shouldSkipX(e, !!isLeft, !!anywhereWithin, xDiff) ? 0 : xDiff;
    const movementY = this.shouldSkipY(e, !!isTop, topBuffer, yDiff) ? 0 : yDiff;
    return { movementX, movementY };
  }
  shouldSkipX(e, isLeft, anywhereWithin, diff) {
    const elRect = this.element.getBoundingClientRect();
    const parentRect = this.offsetParent.getBoundingClientRect();
    const boundaryElRect = this.boundaryEl.getBoundingClientRect();
    const xPosition = this.config.popup ? this.position.x : elRect.left;
    let skipX = xPosition <= 0 && parentRect.left >= e.clientX || parentRect.right <= e.clientX && parentRect.right <= boundaryElRect.right;
    if (skipX) {
      return true;
    }
    if (isLeft) {
      skipX = // skip if we are moving to the left and the cursor
      // is positioned to the right of the left side anchor
      diff < 0 && e.clientX > xPosition + parentRect.left || // skip if we are moving to the right and the cursor
      // is positioned to the left of the dialog
      diff > 0 && e.clientX < xPosition + parentRect.left;
    } else {
      if (anywhereWithin) {
        skipX = diff < 0 && e.clientX > boundaryElRect.right || diff > 0 && e.clientX < xPosition + parentRect.left;
      } else {
        skipX = // if the movement is bound to the right side of the dialog
        // we skip if we are moving to the left and the cursor
        // is to the right of the dialog
        diff < 0 && e.clientX > boundaryElRect.right || // or skip if we are moving to the right and the cursor
        // is to the left of the right side anchor
        diff > 0 && e.clientX < boundaryElRect.right;
      }
    }
    return skipX;
  }
  shouldSkipY(e, isTop, topBuffer = 0, diff) {
    const elRect = this.element.getBoundingClientRect();
    const parentRect = this.offsetParent.getBoundingClientRect();
    const boundaryElRect = this.boundaryEl.getBoundingClientRect();
    const yPosition = this.config.popup ? this.position.y : elRect.top;
    let skipY = yPosition <= 0 && parentRect.top >= e.clientY || parentRect.bottom <= e.clientY && parentRect.bottom <= boundaryElRect.bottom;
    if (skipY) {
      return true;
    }
    if (isTop) {
      skipY = // skip if we are moving to towards top and the cursor is
      // below the top anchor + topBuffer
      // note: topBuffer is used when moving the dialog using the title bar
      diff < 0 && e.clientY > yPosition + parentRect.top + topBuffer || // skip if we are moving to the bottom and the cursor is
      // above the top anchor
      diff > 0 && e.clientY < yPosition + parentRect.top;
    } else {
      skipY = // skip if we are moving towards the top and the cursor
      // is below the bottom anchor
      diff < 0 && e.clientY > boundaryElRect.bottom || // skip if we are moving towards the bottom and the cursor
      // is above the bottom anchor
      diff > 0 && e.clientY < boundaryElRect.bottom;
    }
    return skipY;
  }
  createResizeMap() {
    const getElement2 = (ref) => ({
      element: this.element.querySelector(`[data-ref=${ref}Resizer]`)
    });
    this.resizerMap = {
      topLeft: getElement2("eTopLeft"),
      top: getElement2("eTop"),
      topRight: getElement2("eTopRight"),
      right: getElement2("eRight"),
      bottomRight: getElement2("eBottomRight"),
      bottom: getElement2("eBottom"),
      bottomLeft: getElement2("eBottomLeft"),
      left: getElement2("eLeft")
    };
  }
  addResizers() {
    if (this.resizersAdded) {
      return;
    }
    const eGui = this.element;
    if (!eGui) {
      return;
    }
    eGui.appendChild(_createElement(RESIZE_TEMPLATE));
    this.createResizeMap();
    this.resizersAdded = true;
  }
  removeResizers() {
    this.resizerMap = void 0;
    const resizerEl = this.element.querySelector(`.${RESIZE_CONTAINER_STYLE}`);
    if (resizerEl) {
      this.element.removeChild(resizerEl);
    }
    this.resizersAdded = false;
  }
  getResizerElement(side) {
    return this.resizerMap[side].element;
  }
  onResizeStart(e, side) {
    this.boundaryEl = this.findBoundaryElement();
    if (!this.positioned) {
      this.initialisePosition();
    }
    this.currentResizer = {
      isTop: !!side.match(/top/i),
      isRight: !!side.match(/right/i),
      isBottom: !!side.match(/bottom/i),
      isLeft: !!side.match(/left/i)
    };
    this.element.classList.add("ag-resizing");
    this.resizerMap[side].element.classList.add("ag-active");
    const { popup, forcePopupParentAsOffsetParent } = this.config;
    if (!popup && !forcePopupParentAsOffsetParent) {
      this.applySizeToSiblings(this.currentResizer.isBottom || this.currentResizer.isTop);
    }
    this.isResizing = true;
    this.updateDragStartPosition(e.clientX, e.clientY);
  }
  getSiblings() {
    const element = this.element;
    const parent = element.parentElement;
    if (!parent) {
      return null;
    }
    return Array.prototype.slice.call(parent.children).filter((el) => !el.classList.contains("ag-hidden"));
  }
  getMinSizeOfSiblings() {
    const siblings = this.getSiblings() || [];
    let height = 0;
    let width = 0;
    for (let i = 0; i < siblings.length; i++) {
      const currentEl = siblings[i];
      const isFlex = !!currentEl.style.flex && currentEl.style.flex !== "0 0 auto";
      if (currentEl === this.element) {
        continue;
      }
      let nextHeight = this.minHeight || 0;
      let nextWidth = this.minWidth || 0;
      if (isFlex) {
        const computedStyle = window.getComputedStyle(currentEl);
        if (computedStyle.minHeight) {
          nextHeight = parseInt(computedStyle.minHeight, 10);
        }
        if (computedStyle.minWidth) {
          nextWidth = parseInt(computedStyle.minWidth, 10);
        }
      } else {
        nextHeight = currentEl.offsetHeight;
        nextWidth = currentEl.offsetWidth;
      }
      height += nextHeight;
      width += nextWidth;
    }
    return { height, width };
  }
  applySizeToSiblings(vertical) {
    let containerToFlex = null;
    const siblings = this.getSiblings();
    if (!siblings) {
      return;
    }
    for (let i = 0; i < siblings.length; i++) {
      const el = siblings[i];
      if (el === containerToFlex) {
        continue;
      }
      if (vertical) {
        el.style.height = `${el.offsetHeight}px`;
      } else {
        el.style.width = `${el.offsetWidth}px`;
      }
      el.style.flex = "0 0 auto";
      if (el === this.element) {
        containerToFlex = siblings[i + 1];
      }
    }
    if (containerToFlex) {
      containerToFlex.style.removeProperty("height");
      containerToFlex.style.removeProperty("min-height");
      containerToFlex.style.removeProperty("max-height");
      containerToFlex.style.flex = "1 1 auto";
    }
  }
  isResizable() {
    return Object.values(this.resizable).some((value) => value);
  }
  onResize(e) {
    if (!this.isResizing || !this.currentResizer) {
      return;
    }
    const { popup, forcePopupParentAsOffsetParent } = this.config;
    const { isTop, isRight, isBottom, isLeft } = this.currentResizer;
    const isHorizontal = isRight || isLeft;
    const isVertical = isBottom || isTop;
    const { movementX, movementY } = this.calculateMouseMovement({ e, isLeft, isTop });
    const xPosition = this.position.x;
    const yPosition = this.position.y;
    let offsetLeft = 0;
    let offsetTop = 0;
    if (isHorizontal && movementX) {
      const direction = isLeft ? -1 : 1;
      const oldWidth = this.getWidth();
      const newWidth = oldWidth + movementX * direction;
      let skipWidth = false;
      if (isLeft) {
        offsetLeft = oldWidth - newWidth;
        if (xPosition + offsetLeft <= 0 || newWidth <= this.minWidth) {
          skipWidth = true;
          offsetLeft = 0;
        }
      }
      if (!skipWidth) {
        this.setWidth(newWidth);
      }
    }
    if (isVertical && movementY) {
      const direction = isTop ? -1 : 1;
      const oldHeight = this.getHeight();
      const newHeight = oldHeight + movementY * direction;
      let skipHeight = false;
      if (isTop) {
        offsetTop = oldHeight - newHeight;
        if (yPosition + offsetTop <= 0 || newHeight <= this.minHeight) {
          skipHeight = true;
          offsetTop = 0;
        }
      } else {
        if (!this.config.popup && !this.config.forcePopupParentAsOffsetParent && oldHeight < newHeight && this.getMinSizeOfSiblings().height + newHeight > this.element.parentElement.offsetHeight) {
          skipHeight = true;
        }
      }
      if (!skipHeight) {
        this.setHeight(newHeight);
      }
    }
    this.updateDragStartPosition(e.clientX, e.clientY);
    if ((popup || forcePopupParentAsOffsetParent) && offsetLeft || offsetTop) {
      this.offsetElement(xPosition + offsetLeft, yPosition + offsetTop);
    }
  }
  onResizeEnd(e, side) {
    this.isResizing = false;
    this.currentResizer = null;
    this.boundaryEl = null;
    this.element.classList.remove("ag-resizing");
    this.resizerMap[side].element.classList.remove("ag-active");
    this.dispatchLocalEvent({ type: "resize" });
  }
  refreshSize() {
    const eGui = this.element;
    if (this.config.popup) {
      if (!this.config.width) {
        this.setWidth(eGui.offsetWidth);
      }
      if (!this.config.height) {
        this.setHeight(eGui.offsetHeight);
      }
    }
  }
  onMoveStart(e) {
    this.boundaryEl = this.findBoundaryElement();
    if (!this.positioned) {
      this.initialisePosition();
    }
    this.isMoving = true;
    this.element.classList.add("ag-moving");
    this.updateDragStartPosition(e.clientX, e.clientY);
  }
  onMove(e) {
    if (!this.isMoving) {
      return;
    }
    const { x, y } = this.position;
    let topBuffer;
    if (this.config.calculateTopBuffer) {
      topBuffer = this.config.calculateTopBuffer();
    }
    const { movementX, movementY } = this.calculateMouseMovement({
      e,
      isTop: true,
      anywhereWithin: true,
      topBuffer
    });
    this.offsetElement(x + movementX, y + movementY);
    this.updateDragStartPosition(e.clientX, e.clientY);
  }
  onMoveEnd() {
    this.isMoving = false;
    this.boundaryEl = null;
    this.element.classList.remove("ag-moving");
  }
  setOffsetParent() {
    if (this.config.forcePopupParentAsOffsetParent && this.popupSvc) {
      this.offsetParent = this.popupSvc.getPopupParent();
    } else {
      this.offsetParent = this.element.offsetParent;
    }
  }
  findBoundaryElement() {
    let el = this.element;
    while (el) {
      if (window.getComputedStyle(el).position !== "static") {
        return el;
      }
      el = el.parentElement;
    }
    return this.element;
  }
  clearResizeListeners() {
    while (this.resizeListeners.length) {
      const params = this.resizeListeners.pop();
      this.dragSvc?.removeDragSource(params);
    }
  }
  destroy() {
    super.destroy();
    if (this.moveElementDragListener) {
      this.dragSvc?.removeDragSource(this.moveElementDragListener);
    }
    this.constrainSizeToAvailableHeight(false);
    this.clearResizeListeners();
    this.removeResizers();
  }
};

// packages/ag-grid-community/src/widgets/managedFocusFeature.ts
var FOCUS_MANAGED_CLASS = "ag-focus-managed";
var ManagedFocusFeature = class extends BeanStub {
  constructor(eFocusable, callbacks = {}) {
    super();
    this.eFocusable = eFocusable;
    this.callbacks = callbacks;
    this.callbacks = {
      shouldStopEventPropagation: () => false,
      onTabKeyDown: (e) => {
        if (e.defaultPrevented) {
          return;
        }
        const nextRoot = _findNextFocusableElement(this.beans, this.eFocusable, false, e.shiftKey);
        if (!nextRoot) {
          return;
        }
        nextRoot.focus();
        e.preventDefault();
      },
      ...callbacks
    };
  }
  postConstruct() {
    const {
      eFocusable,
      callbacks: { onFocusIn, onFocusOut }
    } = this;
    eFocusable.classList.add(FOCUS_MANAGED_CLASS);
    this.addKeyDownListeners(eFocusable);
    if (onFocusIn) {
      this.addManagedElementListeners(eFocusable, { focusin: onFocusIn });
    }
    if (onFocusOut) {
      this.addManagedElementListeners(eFocusable, { focusout: onFocusOut });
    }
  }
  addKeyDownListeners(eGui) {
    this.addManagedElementListeners(eGui, {
      keydown: (e) => {
        if (e.defaultPrevented || _isStopPropagationForAgGrid(e)) {
          return;
        }
        const { callbacks } = this;
        if (callbacks.shouldStopEventPropagation(e)) {
          _stopPropagationForAgGrid(e);
          return;
        }
        if (e.key === KeyCode.TAB) {
          callbacks.onTabKeyDown(e);
        } else if (callbacks.handleKeyDown) {
          callbacks.handleKeyDown(e);
        }
      }
    });
  }
};

// packages/ag-grid-community/src/filter/provided/providedFilter.ts
var ProvidedFilter = class extends Component {
  constructor(filterNameKey, cssIdentifier) {
    super();
    this.filterNameKey = filterNameKey;
    this.cssIdentifier = cssIdentifier;
    this.applyActive = false;
    this.debouncePending = false;
    // subclasses can override this to provide alternative debounce defaults
    this.defaultDebounceMs = 0;
  }
  postConstruct() {
    const element = {
      tag: "div",
      cls: `ag-filter-body-wrapper ag-${this.cssIdentifier}-body-wrapper`,
      children: [this.createBodyTemplate()]
    };
    this.setTemplate(element, this.getAgComponents());
    this.createManagedBean(
      new ManagedFocusFeature(this.getFocusableElement(), {
        handleKeyDown: this.handleKeyDown.bind(this)
      })
    );
    this.positionableFeature = this.createBean(
      new PositionableFeature(this.getPositionableElement(), {
        forcePopupParentAsOffsetParent: true
      })
    );
  }
  handleKeyDown(_e) {
  }
  init(legacyParams) {
    const params = legacyParams;
    this.setParams(params);
    this.setModelIntoUi(params.state.model, true).then(() => this.updateUiVisibility());
  }
  refresh(legacyNewParams) {
    const newParams = legacyNewParams;
    const oldParams = this.params;
    this.params = newParams;
    const source = newParams.source;
    if (source === "colDef") {
      this.updateParams(newParams, oldParams);
    }
    const newState = newParams.state;
    const oldState = this.state;
    this.state = newState;
    if (newState.model !== oldState.model || newState.state !== oldState.state) {
      this.setModelIntoUi(newState.model);
    }
    return true;
  }
  /** Called on init only. Override in subclasses */
  setParams(params) {
    this.params = params;
    this.state = params.state;
    this.commonUpdateParams(params);
  }
  /** Called on refresh only. Override in subclasses */
  updateParams(newParams, oldParams) {
    this.commonUpdateParams(newParams, oldParams);
  }
  commonUpdateParams(newParams, _oldParams) {
    this.applyActive = _isUseApplyButton(newParams);
    this.setupApplyDebounced();
  }
  /**
   * @deprecated v34 Use the same method on the filter handler (`api.getColumnFilterHandler()`) instead.
   */
  doesFilterPass(params) {
    _warn(283);
    const { getHandler, model, column } = this.params;
    return getHandler().doesFilterPass({
      ...params,
      model,
      handlerParams: this.beans.colFilter.getHandlerParams(column)
    });
  }
  getFilterTitle() {
    return this.translate(this.filterNameKey);
  }
  /**
   * @deprecated v34 Filters are active when they have a model. Use `api.getColumnFilterModel()` instead.
   */
  isFilterActive() {
    _warn(284);
    return this.params.model != null;
  }
  setupApplyDebounced() {
    const debounceMs = getDebounceMs(this.params, this.defaultDebounceMs);
    const debounceFunc = _debounce(this, this.checkApplyDebounce.bind(this), debounceMs);
    this.applyDebounced = () => {
      this.debouncePending = true;
      debounceFunc();
    };
  }
  checkApplyDebounce() {
    if (this.debouncePending) {
      this.debouncePending = false;
      this.doApplyModel();
    }
  }
  /**
   * @deprecated v34 Use (`api.getColumnFilterModel()`) instead.
   */
  getModel() {
    _warn(285);
    return this.params.model;
  }
  /**
   * @deprecated v34 Use (`api.setColumnFilterModel()`) instead.
   */
  setModel(model) {
    _warn(286);
    const { beans, params } = this;
    return beans.colFilter.setModelForColumnLegacy(params.column, model);
  }
  /**
   * Applies changes made in the UI to the filter, and returns true if the model has changed.
   */
  applyModel(_source = "api") {
    return this.doApplyModel();
  }
  canApply(_model) {
    return true;
  }
  doApplyModel(additionalEventAttributes) {
    const { params, state } = this;
    const changed = !this.areModelsEqual(params.model, state.model);
    if (changed) {
      params.onAction("apply", additionalEventAttributes);
    }
    return changed;
  }
  /**
   * @deprecated v34 Internal method - should only be called by the grid.
   */
  onNewRowsLoaded() {
  }
  /**
   * By default, if the change came from a floating filter it will be applied immediately, otherwise if there is no
   * apply button it will be applied after a debounce, otherwise it will not be applied at all. This behaviour can
   * be adjusted by using the apply parameter.
   */
  onUiChanged(apply, afterFloatingFilter = false) {
    this.updateUiVisibility();
    const model = this.getModelFromUi();
    const state = {
      model,
      state: this.getState(),
      valid: this.canApply(model)
    };
    this.state = state;
    const params = this.params;
    params.onStateChange(state);
    params.onUiChange(this.getUiChangeEventParams());
    if (!this.gos.get("enableFilterHandlers")) {
      this.eventSvc.dispatchEvent({
        type: "filterModified",
        column: params.column,
        filterInstance: this
      });
    }
    apply ?? (apply = this.applyActive ? void 0 : "debounce");
    if (apply === "immediately") {
      this.doApplyModel({ afterFloatingFilter, afterDataChange: false });
    } else if (apply === "debounce") {
      this.applyDebounced();
    }
  }
  getState() {
    return void 0;
  }
  getUiChangeEventParams() {
    return void 0;
  }
  afterGuiAttached(params) {
    this.lastContainerType = params?.container;
    this.refreshFilterResizer(params?.container);
  }
  refreshFilterResizer(containerType) {
    const { positionableFeature, gos } = this;
    if (!positionableFeature) {
      return;
    }
    const isResizable = containerType === "floatingFilter" || containerType === "columnFilter";
    if (isResizable) {
      positionableFeature.restoreLastSize();
      positionableFeature.setResizable(
        gos.get("enableRtl") ? { bottom: true, bottomLeft: true, left: true } : { bottom: true, bottomRight: true, right: true }
      );
    } else {
      positionableFeature.removeSizeFromEl();
      positionableFeature.setResizable(false);
    }
    positionableFeature.constrainSizeToAvailableHeight(isResizable);
  }
  afterGuiDetached() {
    this.checkApplyDebounce();
    this.positionableFeature?.constrainSizeToAvailableHeight(false);
  }
  destroy() {
    this.positionableFeature = this.destroyBean(this.positionableFeature);
    super.destroy();
  }
  translate(key) {
    return translateForFilter(this, key);
  }
  // override to control positionable feature
  getPositionableElement() {
    return this.getGui();
  }
  areModelsEqual(a, b) {
    if (a === b || a == null && b == null) {
      return true;
    }
    if (a == null || b == null) {
      return false;
    }
    return this.areNonNullModelsEqual(a, b);
  }
};

// packages/ag-grid-community/src/filter/provided/iSimpleFilter.ts
function isCombinedFilterModel(model) {
  return !!model.operator;
}

// packages/ag-grid-community/src/filter/floating/floatingFilterMapper.ts
function _getDefaultFloatingFilterType(frameworkOverrides, def, getFromDefault) {
  if (def == null) {
    return null;
  }
  let defaultFloatingFilterType = null;
  const { compName, jsComp, fwComp } = _getFilterCompKeys(frameworkOverrides, def);
  if (compName) {
    const floatingFilterTypeMap = {
      agSetColumnFilter: "agSetColumnFloatingFilter",
      agMultiColumnFilter: "agMultiColumnFloatingFilter",
      agGroupColumnFilter: "agGroupColumnFloatingFilter",
      agNumberColumnFilter: "agNumberColumnFloatingFilter",
      agDateColumnFilter: "agDateColumnFloatingFilter",
      agTextColumnFilter: "agTextColumnFloatingFilter"
    };
    defaultFloatingFilterType = floatingFilterTypeMap[compName];
  } else {
    const usingDefaultFilter = jsComp == null && fwComp == null && def.filter === true;
    if (usingDefaultFilter) {
      defaultFloatingFilterType = getFromDefault();
    }
  }
  return defaultFloatingFilterType;
}

// packages/ag-grid-community/src/styling/layoutFeature.ts
var LayoutCssClasses = {
  AUTO_HEIGHT: "ag-layout-auto-height",
  NORMAL: "ag-layout-normal",
  PRINT: "ag-layout-print"
};
var LayoutFeature = class extends BeanStub {
  constructor(view) {
    super();
    this.view = view;
  }
  postConstruct() {
    this.addManagedPropertyListener("domLayout", this.updateLayoutClasses.bind(this));
    this.updateLayoutClasses();
  }
  updateLayoutClasses() {
    const domLayout = this.gos.get("domLayout");
    const params = {
      autoHeight: domLayout === "autoHeight",
      normal: domLayout === "normal",
      print: domLayout === "print"
    };
    const cssClass = params.autoHeight ? LayoutCssClasses.AUTO_HEIGHT : params.print ? LayoutCssClasses.PRINT : LayoutCssClasses.NORMAL;
    this.view.updateLayoutClasses(cssClass, params);
  }
};

// packages/ag-grid-community/src/constants/direction.ts
var Direction = /* @__PURE__ */ ((Direction2) => {
  Direction2[Direction2["Vertical"] = 0] = "Vertical";
  Direction2[Direction2["Horizontal"] = 1] = "Horizontal";
  return Direction2;
})(Direction || {});

// packages/ag-grid-community/src/gridBodyComp/gridBodyScrollFeature.ts
var VIEWPORT = "Viewport";
var FAKE_V_SCROLLBAR = "fakeVScrollComp";
var HORIZONTAL_SOURCES = [
  "fakeHScrollComp",
  "centerHeader",
  "topCenter",
  "bottomCenter",
  "stickyTopCenter",
  "stickyBottomCenter"
];
var SCROLL_DEBOUNCE_TIMEOUT = 100;
var SCROLL_END_TIMEOUT = 150;
var GridBodyScrollFeature = class extends BeanStub {
  constructor(eBodyViewport) {
    super();
    // listeners for when ensureIndexVisible is waiting for SSRM data to load
    this.clearRetryListenerFncs = [];
    this.lastScrollSource = [null, null];
    this.scrollLeft = -1;
    this.nextScrollTop = -1;
    this.scrollTop = -1;
    // Used to provide approximate values of scrollTop and offsetHeight
    // without forcing the browser to recalculate styles.
    this.lastOffsetHeight = -1;
    this.lastScrollTop = -1;
    this.lastIsHorizontalScrollShowing = false;
    this.scrollTimer = 0;
    this.isScrollActive = false;
    this.isVerticalPositionInvalidated = true;
    this.isHorizontalPositionInvalidated = true;
    this.eBodyViewport = eBodyViewport;
    this.resetLastHScrollDebounced = _debounce(
      this,
      () => this.lastScrollSource[1 /* Horizontal */] = null,
      SCROLL_END_TIMEOUT
    );
    this.resetLastVScrollDebounced = _debounce(
      this,
      () => this.lastScrollSource[0 /* Vertical */] = null,
      SCROLL_END_TIMEOUT
    );
  }
  wireBeans(beans) {
    this.ctrlsSvc = beans.ctrlsSvc;
    this.animationFrameSvc = beans.animationFrameSvc;
    this.visibleCols = beans.visibleCols;
  }
  destroy() {
    super.destroy();
    this.clearRetryListenerFncs = [];
    window.clearTimeout(this.scrollTimer);
  }
  postConstruct() {
    this.enableRtl = this.gos.get("enableRtl");
    const invalidateVerticalScroll = this.invalidateVerticalScroll.bind(this);
    const invalidateHorizontalScroll = this.invalidateHorizontalScroll.bind(this);
    this.addManagedEventListeners({
      displayedColumnsWidthChanged: this.onDisplayedColumnsWidthChanged.bind(this),
      gridSizeChanged: invalidateVerticalScroll,
      // We only invalidate horizontal scrolling when the viewport switches
      // between scrollable and non-scrollable, avoiding unnecessary
      // invalidation on every gridSizeChanged event. If more properties
      // require invalidation, read/write DOM cycles may be needed.
      scrollGapChanged: invalidateHorizontalScroll
    });
    this.addManagedElementListeners(this.eBodyViewport, {
      scroll: invalidateVerticalScroll
    });
    this.ctrlsSvc.whenReady(this, (p) => {
      this.centerRowsCtrl = p.center;
      this.onDisplayedColumnsWidthChanged();
      this.addScrollListener();
    });
  }
  invalidateHorizontalScroll() {
    this.isHorizontalPositionInvalidated = true;
  }
  invalidateVerticalScroll() {
    this.isVerticalPositionInvalidated = true;
  }
  addScrollListener() {
    this.addHorizontalScrollListeners();
    this.addVerticalScrollListeners();
  }
  addHorizontalScrollListeners() {
    this.addManagedElementListeners(this.centerRowsCtrl.eViewport, {
      scroll: this.onHScroll.bind(this, VIEWPORT)
    });
    for (const source of HORIZONTAL_SOURCES) {
      const scrollPartner = this.ctrlsSvc.get(source);
      this.registerScrollPartner(scrollPartner, this.onHScroll.bind(this, source));
    }
  }
  addVerticalScrollListeners() {
    const fakeVScrollComp = this.ctrlsSvc.get("fakeVScrollComp");
    const isDebounce = this.gos.get("debounceVerticalScrollbar");
    const onVScroll = isDebounce ? _debounce(this, this.onVScroll.bind(this, VIEWPORT), SCROLL_DEBOUNCE_TIMEOUT) : this.onVScroll.bind(this, VIEWPORT);
    const onFakeVScroll = isDebounce ? _debounce(this, this.onVScroll.bind(this, FAKE_V_SCROLLBAR), SCROLL_DEBOUNCE_TIMEOUT) : this.onVScroll.bind(this, FAKE_V_SCROLLBAR);
    this.addManagedElementListeners(this.eBodyViewport, { scroll: onVScroll });
    this.registerScrollPartner(fakeVScrollComp, onFakeVScroll);
  }
  registerScrollPartner(comp, callback) {
    comp.onScrollCallback(callback);
  }
  onDisplayedColumnsWidthChanged() {
    if (this.enableRtl) {
      this.horizontallyScrollHeaderCenterAndFloatingCenter();
    }
  }
  horizontallyScrollHeaderCenterAndFloatingCenter(scrollLeft) {
    const notYetInitialised = this.centerRowsCtrl == null;
    if (notYetInitialised) {
      return;
    }
    if (scrollLeft === void 0) {
      scrollLeft = this.centerRowsCtrl.getCenterViewportScrollLeft();
    }
    this.setScrollLeftForAllContainersExceptCurrent(Math.abs(scrollLeft));
  }
  setScrollLeftForAllContainersExceptCurrent(scrollLeft) {
    for (const container of [...HORIZONTAL_SOURCES, VIEWPORT]) {
      if (this.lastScrollSource[1 /* Horizontal */] === container) {
        continue;
      }
      const viewport = this.getViewportForSource(container);
      _setScrollLeft(viewport, scrollLeft, this.enableRtl);
    }
  }
  getViewportForSource(source) {
    if (source === VIEWPORT) {
      return this.centerRowsCtrl.eViewport;
    }
    return this.ctrlsSvc.get(source).eViewport;
  }
  isControllingScroll(source, direction) {
    if (this.lastScrollSource[direction] == null) {
      if (direction === 0 /* Vertical */) {
        this.lastScrollSource[0] = source;
      } else {
        this.lastScrollSource[1] = source;
      }
      return true;
    }
    return this.lastScrollSource[direction] === source;
  }
  onHScroll(source) {
    if (!this.isControllingScroll(source, 1 /* Horizontal */)) {
      return;
    }
    const centerContainerViewport = this.centerRowsCtrl.eViewport;
    const { scrollLeft } = centerContainerViewport;
    if (this.shouldBlockScrollUpdate(1 /* Horizontal */, scrollLeft, true)) {
      return;
    }
    const newScrollLeft = _getScrollLeft(this.getViewportForSource(source), this.enableRtl);
    this.doHorizontalScroll(newScrollLeft);
    this.resetLastHScrollDebounced();
  }
  onVScroll(source) {
    if (!this.isControllingScroll(source, 0 /* Vertical */)) {
      return;
    }
    let scrollTop;
    if (source === VIEWPORT) {
      scrollTop = this.eBodyViewport.scrollTop;
    } else {
      scrollTop = this.ctrlsSvc.get("fakeVScrollComp").getScrollPosition();
    }
    if (this.shouldBlockScrollUpdate(0 /* Vertical */, scrollTop, true)) {
      return;
    }
    const { animationFrameSvc } = this;
    animationFrameSvc?.setScrollTop(scrollTop);
    this.nextScrollTop = scrollTop;
    if (source === VIEWPORT) {
      this.ctrlsSvc.get("fakeVScrollComp").setScrollPosition(scrollTop);
    } else {
      this.eBodyViewport.scrollTop = scrollTop;
    }
    if (animationFrameSvc?.active) {
      animationFrameSvc.schedule();
    } else {
      this.scrollGridIfNeeded(true);
    }
    this.resetLastVScrollDebounced();
  }
  doHorizontalScroll(scrollLeft) {
    const fakeScrollLeft = this.ctrlsSvc.get("fakeHScrollComp").getScrollPosition();
    if (this.scrollLeft === scrollLeft && scrollLeft === fakeScrollLeft) {
      return;
    }
    this.scrollLeft = scrollLeft;
    this.fireScrollEvent(1 /* Horizontal */);
    this.horizontallyScrollHeaderCenterAndFloatingCenter(scrollLeft);
    this.centerRowsCtrl.onHorizontalViewportChanged(true);
  }
  isScrolling() {
    return this.isScrollActive;
  }
  fireScrollEvent(direction) {
    const bodyScrollEvent = {
      type: "bodyScroll",
      direction: direction === 1 /* Horizontal */ ? "horizontal" : "vertical",
      left: this.scrollLeft,
      top: this.scrollTop
    };
    this.isScrollActive = true;
    this.eventSvc.dispatchEvent(bodyScrollEvent);
    window.clearTimeout(this.scrollTimer);
    this.scrollTimer = window.setTimeout(() => {
      this.scrollTimer = 0;
      this.isScrollActive = false;
      this.eventSvc.dispatchEvent({
        ...bodyScrollEvent,
        type: "bodyScrollEnd"
      });
    }, SCROLL_END_TIMEOUT);
  }
  shouldBlockScrollUpdate(direction, scrollTo, touchOnly = false) {
    if (touchOnly && !_isIOSUserAgent()) {
      return false;
    }
    if (direction === 0 /* Vertical */) {
      return this.shouldBlockVerticalScroll(scrollTo);
    }
    return this.shouldBlockHorizontalScroll(scrollTo);
  }
  shouldBlockVerticalScroll(scrollTo) {
    const clientHeight = _getInnerHeight(this.eBodyViewport);
    const { scrollHeight } = this.eBodyViewport;
    if (scrollTo < 0 || scrollTo + clientHeight > scrollHeight) {
      return true;
    }
    return false;
  }
  shouldBlockHorizontalScroll(scrollTo) {
    const clientWidth = this.centerRowsCtrl.getCenterWidth();
    const { scrollWidth } = this.centerRowsCtrl.eViewport;
    if (this.enableRtl) {
      if (scrollTo > 0) {
        return true;
      }
    } else if (scrollTo < 0) {
      return true;
    }
    if (Math.abs(scrollTo) + clientWidth > scrollWidth) {
      return true;
    }
    return false;
  }
  redrawRowsAfterScroll() {
    this.fireScrollEvent(0 /* Vertical */);
  }
  // this is to cater for AG-3274, where grid is removed from the dom and then inserted back in again.
  // (which happens with some implementations of tabbing). this can result in horizontal scroll getting
  // reset back to the left, however no scroll event is fired. so we need to get header to also scroll
  // back to the left to be kept in sync.
  // adding and removing the grid from the DOM both resets the scroll position and
  // triggers a resize event, so notify listeners if the scroll position has changed
  checkScrollLeft() {
    const scrollLeft = this.scrollLeft;
    let hasHorizontalScrollersOutOfSync = false;
    for (const source of HORIZONTAL_SOURCES) {
      const viewport = this.getViewportForSource(source);
      if (viewport.scrollLeft !== scrollLeft) {
        hasHorizontalScrollersOutOfSync = true;
        break;
      }
    }
    if (hasHorizontalScrollersOutOfSync) {
      this.onHScroll(VIEWPORT);
    }
  }
  scrollGridIfNeeded(suppressedAnimationFrame = false) {
    const frameNeeded = this.scrollTop != this.nextScrollTop;
    if (frameNeeded) {
      this.scrollTop = this.nextScrollTop;
      if (suppressedAnimationFrame) {
        this.invalidateVerticalScroll();
      }
      this.redrawRowsAfterScroll();
    }
    return frameNeeded;
  }
  // called by scrollHorizontally method and alignedGridsService
  setHorizontalScrollPosition(hScrollPosition, fromAlignedGridsService = false) {
    const minScrollLeft = 0;
    const maxScrollLeft = this.centerRowsCtrl.eViewport.scrollWidth - this.centerRowsCtrl.getCenterWidth();
    if (!fromAlignedGridsService && this.shouldBlockScrollUpdate(1 /* Horizontal */, hScrollPosition)) {
      if (this.enableRtl) {
        hScrollPosition = hScrollPosition > 0 ? 0 : maxScrollLeft;
      } else {
        hScrollPosition = Math.min(Math.max(hScrollPosition, minScrollLeft), maxScrollLeft);
      }
    }
    _setScrollLeft(this.centerRowsCtrl.eViewport, Math.abs(hScrollPosition), this.enableRtl);
    this.doHorizontalScroll(hScrollPosition);
  }
  setVerticalScrollPosition(vScrollPosition) {
    this.invalidateVerticalScroll();
    this.eBodyViewport.scrollTop = vScrollPosition;
  }
  getVScrollPosition() {
    if (!this.isVerticalPositionInvalidated) {
      const { lastOffsetHeight, lastScrollTop } = this;
      return {
        top: lastScrollTop,
        bottom: lastScrollTop + lastOffsetHeight
      };
    }
    this.isVerticalPositionInvalidated = false;
    const { scrollTop, offsetHeight } = this.eBodyViewport;
    this.lastScrollTop = scrollTop;
    this.lastOffsetHeight = offsetHeight;
    return {
      top: scrollTop,
      bottom: scrollTop + offsetHeight
    };
  }
  /** Get an approximate scroll position that returns the last real value read.
   * This is useful for avoiding repeated DOM reads that force the browser to recalculate styles.
   * This can have big performance improvements but may not be 100% accurate so only use if this is acceptable.
   */
  getApproximateVScollPosition() {
    if (this.lastScrollTop >= 0 && this.lastOffsetHeight >= 0) {
      return {
        top: this.scrollTop,
        bottom: this.scrollTop + this.lastOffsetHeight
      };
    }
    return this.getVScrollPosition();
  }
  getHScrollPosition() {
    return this.centerRowsCtrl.getHScrollPosition();
  }
  isHorizontalScrollShowing() {
    if (this.isHorizontalPositionInvalidated) {
      this.lastIsHorizontalScrollShowing = this.centerRowsCtrl.isHorizontalScrollShowing();
      this.isHorizontalPositionInvalidated = false;
    }
    return this.lastIsHorizontalScrollShowing;
  }
  // called by the headerRootComp and moveColumnController
  scrollHorizontally(pixels) {
    const oldScrollPosition = this.centerRowsCtrl.eViewport.scrollLeft;
    this.setHorizontalScrollPosition(oldScrollPosition + pixels);
    return this.centerRowsCtrl.eViewport.scrollLeft - oldScrollPosition;
  }
  // gets called by rowRenderer when new data loaded, as it will want to scroll to the top
  scrollToTop() {
    this.eBodyViewport.scrollTop = 0;
  }
  // Valid values for position are bottom, middle and top
  ensureNodeVisible(comparator, position = null) {
    const { rowModel } = this.beans;
    const rowCount = rowModel.getRowCount();
    let indexToSelect = -1;
    for (let i = 0; i < rowCount; i++) {
      const node = rowModel.getRow(i);
      if (typeof comparator === "function") {
        const predicate = comparator;
        if (node && predicate(node)) {
          indexToSelect = i;
          break;
        }
      } else {
        if (comparator === node || comparator === node.data) {
          indexToSelect = i;
          break;
        }
      }
    }
    if (indexToSelect >= 0) {
      this.ensureIndexVisible(indexToSelect, position);
    }
  }
  // Valid values for position are bottom, middle and top
  // position should be {'top','middle','bottom', or undefined/null}.
  // if undefined/null, then the grid will to the minimal amount of scrolling,
  // eg if grid needs to scroll up, it scrolls until row is on top,
  //    if grid needs to scroll down, it scrolls until row is on bottom,
  //    if row is already in view, grid does not scroll
  ensureIndexVisible(index, position, retry = 0) {
    if (_isDomLayout(this.gos, "print")) {
      return;
    }
    const { rowModel } = this.beans;
    const rowCount = rowModel.getRowCount();
    if (typeof index !== "number" || index < 0 || index >= rowCount) {
      _warn(88, { index });
      return;
    }
    this.clearRetryListeners();
    const { frameworkOverrides, pageBounds, rowContainerHeight: heightScaler, rowRenderer } = this.beans;
    frameworkOverrides.wrapIncoming(() => {
      const gridBodyCtrl = this.ctrlsSvc.getGridBodyCtrl();
      const rowNode = rowModel.getRow(index);
      let rowGotShiftedDuringOperation;
      let stickyHeightsChanged;
      let attempt = 0;
      this.invalidateVerticalScroll();
      do {
        const { stickyTopHeight, stickyBottomHeight } = gridBodyCtrl;
        const startingRowTop = rowNode.rowTop;
        const startingRowHeight = rowNode.rowHeight;
        const paginationOffset = pageBounds.getPixelOffset();
        const rowTopPixel = rowNode.rowTop - paginationOffset;
        const rowBottomPixel = rowTopPixel + rowNode.rowHeight;
        const scrollPosition = this.getVScrollPosition();
        const heightOffset = heightScaler.divStretchOffset;
        const vScrollTop = scrollPosition.top + heightOffset;
        const vScrollBottom = scrollPosition.bottom + heightOffset;
        const viewportHeight = vScrollBottom - vScrollTop;
        const pxTop = heightScaler.getScrollPositionForPixel(rowTopPixel);
        const pxBottom = heightScaler.getScrollPositionForPixel(rowBottomPixel - viewportHeight);
        const pxMiddle = Math.min((pxTop + pxBottom) / 2, rowTopPixel);
        const rowAboveViewport = vScrollTop + stickyTopHeight > rowTopPixel;
        const rowBelowViewport = vScrollBottom - stickyBottomHeight < rowBottomPixel;
        let newScrollPosition = null;
        if (position === "top") {
          newScrollPosition = pxTop - stickyTopHeight;
        } else if (position === "bottom") {
          newScrollPosition = pxBottom + stickyBottomHeight;
        } else if (position === "middle") {
          newScrollPosition = pxMiddle;
        } else if (rowAboveViewport) {
          newScrollPosition = pxTop - stickyTopHeight;
        } else if (rowBelowViewport) {
          if (pxBottom - pxTop > viewportHeight) {
            newScrollPosition = pxTop - stickyTopHeight;
          } else {
            newScrollPosition = pxBottom + stickyBottomHeight;
          }
        }
        if (newScrollPosition !== null) {
          this.setVerticalScrollPosition(newScrollPosition);
          rowRenderer.redraw({ afterScroll: true });
        }
        rowGotShiftedDuringOperation = startingRowTop !== rowNode.rowTop || startingRowHeight !== rowNode.rowHeight;
        stickyHeightsChanged = stickyTopHeight !== gridBodyCtrl.stickyTopHeight || stickyBottomHeight !== gridBodyCtrl.stickyBottomHeight;
        attempt++;
      } while ((rowGotShiftedDuringOperation || stickyHeightsChanged) && attempt < 10);
      this.animationFrameSvc?.flushAllFrames();
      if (retry < 10 && (rowNode?.stub || !this.beans.rowAutoHeight?.areRowsMeasured())) {
        const scrollTop = this.getVScrollPosition().top;
        this.clearRetryListenerFncs = this.addManagedEventListeners({
          bodyScroll: () => {
            const newScrollTop = this.getVScrollPosition().top;
            if (scrollTop === newScrollTop) {
              return;
            }
            this.clearRetryListeners();
          },
          modelUpdated: () => {
            this.clearRetryListeners();
            if (index >= rowModel.getRowCount()) {
              return;
            }
            this.ensureIndexVisible(index, position, retry + 1);
          }
        });
      }
    });
  }
  clearRetryListeners() {
    this.clearRetryListenerFncs.forEach((callback) => callback());
    this.clearRetryListenerFncs = [];
  }
  ensureColumnVisible(key, position = "auto") {
    const { colModel, frameworkOverrides } = this.beans;
    const column = colModel.getCol(key);
    if (!column) {
      return;
    }
    if (column.isPinned()) {
      return;
    }
    if (!this.visibleCols.isColDisplayed(column)) {
      return;
    }
    const newHorizontalScroll = this.getPositionedHorizontalScroll(column, position);
    frameworkOverrides.wrapIncoming(() => {
      if (newHorizontalScroll !== null) {
        this.centerRowsCtrl.setCenterViewportScrollLeft(newHorizontalScroll);
      }
      this.centerRowsCtrl.onHorizontalViewportChanged();
      this.animationFrameSvc?.flushAllFrames();
    });
  }
  getPositionedHorizontalScroll(column, position) {
    const { columnBeforeStart, columnAfterEnd } = this.isColumnOutsideViewport(column);
    const viewportTooSmallForColumn = this.centerRowsCtrl.getCenterWidth() < column.getActualWidth();
    const viewportWidth = this.centerRowsCtrl.getCenterWidth();
    const isRtl = this.enableRtl;
    let alignColToStart = (isRtl ? columnBeforeStart : columnAfterEnd) || viewportTooSmallForColumn;
    let alignColToEnd = isRtl ? columnAfterEnd : columnBeforeStart;
    if (position !== "auto") {
      alignColToStart = position === "start";
      alignColToEnd = position === "end";
    }
    const isMiddle = position === "middle";
    if (alignColToStart || alignColToEnd || isMiddle) {
      const { colLeft, colMiddle, colRight } = this.getColumnBounds(column);
      if (isMiddle) {
        return colMiddle - viewportWidth / 2;
      }
      if (alignColToStart) {
        return isRtl ? colRight : colLeft;
      }
      return isRtl ? colLeft - viewportWidth : colRight - viewportWidth;
    }
    return null;
  }
  isColumnOutsideViewport(column) {
    const { start: viewportStart, end: viewportEnd } = this.getViewportBounds();
    const { colLeft, colRight } = this.getColumnBounds(column);
    const isRtl = this.enableRtl;
    const columnBeforeStart = isRtl ? viewportStart > colRight : viewportEnd < colRight;
    const columnAfterEnd = isRtl ? viewportEnd < colLeft : viewportStart > colLeft;
    return { columnBeforeStart, columnAfterEnd };
  }
  getColumnBounds(column) {
    const isRtl = this.enableRtl;
    const bodyWidth = this.visibleCols.bodyWidth;
    const colWidth = column.getActualWidth();
    const colLeft = column.getLeft();
    const multiplier = isRtl ? -1 : 1;
    const colLeftPixel = isRtl ? bodyWidth - colLeft : colLeft;
    const colRightPixel = colLeftPixel + colWidth * multiplier;
    const colMidPixel = colLeftPixel + colWidth / 2 * multiplier;
    return { colLeft: colLeftPixel, colMiddle: colMidPixel, colRight: colRightPixel };
  }
  getViewportBounds() {
    const viewportWidth = this.centerRowsCtrl.getCenterWidth();
    const scrollPosition = this.centerRowsCtrl.getCenterViewportScrollLeft();
    const viewportStartPixel = scrollPosition;
    const viewportEndPixel = viewportWidth + scrollPosition;
    return { start: viewportStartPixel, end: viewportEndPixel, width: viewportWidth };
  }
};

// packages/ag-grid-community/src/gridBodyComp/centerWidthFeature.ts
var CenterWidthFeature = class extends BeanStub {
  constructor(callback, addSpacer = false) {
    super();
    this.callback = callback;
    this.addSpacer = addSpacer;
  }
  postConstruct() {
    const listener = this.setWidth.bind(this);
    this.addManagedPropertyListener("domLayout", listener);
    this.addManagedEventListeners({
      columnContainerWidthChanged: listener,
      displayedColumnsChanged: listener,
      leftPinnedWidthChanged: listener
    });
    if (this.addSpacer) {
      this.addManagedEventListeners({
        rightPinnedWidthChanged: listener,
        scrollVisibilityChanged: listener,
        scrollbarWidthChanged: listener
      });
    }
    this.setWidth();
  }
  setWidth() {
    const printLayout = _isDomLayout(this.gos, "print");
    const { visibleCols, scrollVisibleSvc } = this.beans;
    const centerWidth = visibleCols.bodyWidth;
    const leftWidth = visibleCols.getColsLeftWidth();
    const rightWidth = visibleCols.getDisplayedColumnsRightWidth();
    let totalWidth;
    if (printLayout) {
      totalWidth = centerWidth + leftWidth + rightWidth;
    } else {
      totalWidth = centerWidth;
      if (this.addSpacer) {
        const relevantWidth = this.gos.get("enableRtl") ? leftWidth : rightWidth;
        if (relevantWidth === 0 && scrollVisibleSvc.verticalScrollShowing) {
          totalWidth += scrollVisibleSvc.getScrollbarWidth();
        }
      }
    }
    this.callback(totalWidth);
  }
};

// packages/ag-grid-community/src/gridBodyComp/viewportSizeFeature.ts
var ViewportSizeFeature = class extends BeanStub {
  constructor(centerContainerCtrl) {
    super();
    this.centerContainerCtrl = centerContainerCtrl;
  }
  wireBeans(beans) {
    this.scrollVisibleSvc = beans.scrollVisibleSvc;
  }
  postConstruct() {
    this.beans.ctrlsSvc.whenReady(this, (p) => {
      this.gridBodyCtrl = p.gridBodyCtrl;
      this.listenForResize();
    });
    this.addManagedEventListeners({ scrollbarWidthChanged: this.onScrollbarWidthChanged.bind(this) });
    this.addManagedPropertyListeners(["alwaysShowHorizontalScroll", "alwaysShowVerticalScroll"], () => {
      this.checkViewportAndScrolls();
    });
  }
  listenForResize() {
    const { beans, centerContainerCtrl, gridBodyCtrl } = this;
    const listener = () => {
      _requestAnimationFrame(beans, () => {
        this.onCenterViewportResized();
      });
    };
    centerContainerCtrl.registerViewportResizeListener(listener);
    gridBodyCtrl.registerBodyViewportResizeListener(listener);
  }
  onScrollbarWidthChanged() {
    this.checkViewportAndScrolls();
  }
  onCenterViewportResized() {
    this.scrollVisibleSvc.updateScrollGap();
    if (this.centerContainerCtrl.isViewportInTheDOMTree()) {
      const { pinnedCols, colFlex } = this.beans;
      pinnedCols?.keepPinnedColumnsNarrowerThanViewport();
      this.checkViewportAndScrolls();
      const newWidth = this.centerContainerCtrl.getCenterWidth();
      if (newWidth !== this.centerWidth) {
        this.centerWidth = newWidth;
        colFlex?.refreshFlexedColumns({
          viewportWidth: this.centerWidth,
          updateBodyWidths: true,
          fireResizedEvent: true
        });
      }
    } else {
      this.bodyHeight = 0;
    }
  }
  // gets called every time the viewport size changes. we use this to check visibility of scrollbars
  // in the grid panel, and also to check size and position of viewport for row and column virtualisation.
  checkViewportAndScrolls() {
    this.updateScrollVisibleService();
    this.checkBodyHeight();
    this.onHorizontalViewportChanged();
    this.gridBodyCtrl.scrollFeature.checkScrollLeft();
  }
  getBodyHeight() {
    return this.bodyHeight;
  }
  checkBodyHeight() {
    const eBodyViewport = this.gridBodyCtrl.eBodyViewport;
    const bodyHeight = _getInnerHeight(eBodyViewport);
    if (this.bodyHeight !== bodyHeight) {
      this.bodyHeight = bodyHeight;
      this.eventSvc.dispatchEvent({
        type: "bodyHeightChanged"
      });
    }
  }
  updateScrollVisibleService() {
    this.updateScrollVisibleServiceImpl();
    setTimeout(this.updateScrollVisibleServiceImpl.bind(this), 500);
  }
  updateScrollVisibleServiceImpl() {
    const params = {
      horizontalScrollShowing: this.centerContainerCtrl.isHorizontalScrollShowing(),
      verticalScrollShowing: this.gridBodyCtrl.isVerticalScrollShowing()
    };
    this.scrollVisibleSvc.setScrollsVisible(params);
  }
  // this gets called whenever a change in the viewport, so we can inform column controller it has to work
  // out the virtual columns again. gets called from following locations:
  // + ensureColVisible, scroll, init, layoutChanged, displayedColumnsChanged
  onHorizontalViewportChanged() {
    const scrollWidth = this.centerContainerCtrl.getCenterWidth();
    const scrollPosition = this.centerContainerCtrl.getViewportScrollLeft();
    this.beans.colViewport.setScrollPosition(scrollWidth, scrollPosition);
  }
};

// packages/ag-grid-community/src/styling/stylingUtils.ts
function processClassRules(expressionSvc, previousClassRules, classRules, params, onApplicableClass, onNotApplicableClass) {
  if (classRules == null && previousClassRules == null) {
    return;
  }
  const classesToApply = {};
  const classesToRemove = {};
  const forEachSingleClass = (className, callback) => {
    className.split(" ").forEach((singleClass) => {
      if (singleClass.trim() == "")
        return;
      callback(singleClass);
    });
  };
  if (classRules) {
    const classNames = Object.keys(classRules);
    for (let i = 0; i < classNames.length; i++) {
      const className = classNames[i];
      const rule = classRules[className];
      let resultOfRule;
      if (typeof rule === "string") {
        resultOfRule = expressionSvc ? expressionSvc.evaluate(rule, params) : true;
      } else if (typeof rule === "function") {
        resultOfRule = rule(params);
      }
      forEachSingleClass(className, (singleClass) => {
        resultOfRule ? classesToApply[singleClass] = true : classesToRemove[singleClass] = true;
      });
    }
  }
  if (previousClassRules && onNotApplicableClass) {
    Object.keys(previousClassRules).forEach(
      (className) => forEachSingleClass(className, (singleClass) => {
        if (!classesToApply[singleClass]) {
          classesToRemove[singleClass] = true;
        }
      })
    );
  }
  if (onNotApplicableClass) {
    Object.keys(classesToRemove).forEach(onNotApplicableClass);
  }
  Object.keys(classesToApply).forEach(onApplicableClass);
}

// packages/ag-grid-community/src/styling/rowStyleService.ts
function calculateRowLevel(rowNode) {
  if (rowNode.group) {
    return rowNode.level;
  }
  const parent = rowNode.parent;
  return parent ? parent.level + 1 : 0;
}
var RowStyleService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "rowStyleSvc";
  }
  processClassesFromGridOptions(classes, rowNode) {
    const gos = this.gos;
    const process = (rowCls) => {
      if (typeof rowCls === "string") {
        classes.push(rowCls);
      } else if (Array.isArray(rowCls)) {
        rowCls.forEach((e) => classes.push(e));
      }
    };
    const rowClass = gos.get("rowClass");
    if (rowClass) {
      process(rowClass);
    }
    const rowClassFunc = gos.getCallback("getRowClass");
    if (rowClassFunc) {
      const params = {
        data: rowNode.data,
        node: rowNode,
        rowIndex: rowNode.rowIndex
      };
      const rowClassFuncResult = rowClassFunc(params);
      process(rowClassFuncResult);
    }
  }
  preProcessRowClassRules(classes, rowNode) {
    this.processRowClassRules(
      rowNode,
      (className) => {
        classes.push(className);
      },
      () => {
      }
    );
  }
  processRowClassRules(rowNode, onApplicableClass, onNotApplicableClass) {
    const { gos, expressionSvc } = this.beans;
    const rowClassParams = _addGridCommonParams(gos, {
      data: rowNode.data,
      node: rowNode,
      rowIndex: rowNode.rowIndex
    });
    processClassRules(
      expressionSvc,
      void 0,
      gos.get("rowClassRules"),
      rowClassParams,
      onApplicableClass,
      onNotApplicableClass
    );
  }
  processStylesFromGridOptions(rowNode) {
    const gos = this.gos;
    const rowStyle = gos.get("rowStyle");
    const rowStyleFunc = gos.getCallback("getRowStyle");
    let rowStyleFuncResult;
    if (rowStyleFunc) {
      const params = {
        data: rowNode.data,
        node: rowNode,
        rowIndex: rowNode.rowIndex
      };
      rowStyleFuncResult = rowStyleFunc(params);
    }
    if (rowStyleFuncResult || rowStyle) {
      return Object.assign({}, rowStyle, rowStyleFuncResult);
    }
    return void 0;
  }
};

// packages/ag-grid-community/src/rendering/row/rowCtrl.ts
var instanceIdSequence3 = 0;
var DOM_DATA_KEY_ROW_CTRL = "renderedRow";
var RowCtrl = class extends BeanStub {
  constructor(rowNode, beans, animateIn, useAnimationFrameForCreate, printLayout) {
    super();
    this.rowNode = rowNode;
    this.useAnimationFrameForCreate = useAnimationFrameForCreate;
    this.printLayout = printLayout;
    this.allRowGuis = [];
    this.active = true;
    this.centerCellCtrls = { list: [], map: {} };
    this.leftCellCtrls = { list: [], map: {} };
    this.rightCellCtrls = { list: [], map: {} };
    this.slideInAnimation = {
      left: false,
      center: false,
      right: false,
      fullWidth: false
    };
    this.fadeInAnimation = {
      left: false,
      center: false,
      right: false,
      fullWidth: false
    };
    this.rowDragComps = [];
    this.lastMouseDownOnDragger = false;
    this.emptyStyle = {};
    this.updateColumnListsPending = false;
    this.rowId = null;
    /** sanitised */
    this.businessKey = null;
    this.beans = beans;
    this.gos = beans.gos;
    this.paginationPage = beans.pagination?.getCurrentPage() ?? 0;
    this.suppressRowTransform = this.gos.get("suppressRowTransform");
    this.instanceId = rowNode.id + "-" + instanceIdSequence3++;
    this.rowId = _escapeString(rowNode.id);
    this.initRowBusinessKey();
    this.rowFocused = beans.focusSvc.isRowFocused(this.rowNode.rowIndex, this.rowNode.rowPinned);
    this.rowLevel = calculateRowLevel(this.rowNode);
    this.setRowType();
    this.setAnimateFlags(animateIn);
    this.rowStyles = this.processStylesFromGridOptions();
    this.rowEditStyleFeature = beans.editSvc?.createRowStyleFeature(this, beans);
    this.addListeners();
  }
  initRowBusinessKey() {
    this.businessKeyForNodeFunc = this.gos.get("getBusinessKeyForNode");
    this.updateRowBusinessKey();
  }
  updateRowBusinessKey() {
    if (typeof this.businessKeyForNodeFunc !== "function") {
      return;
    }
    const businessKey = this.businessKeyForNodeFunc(this.rowNode);
    this.businessKey = _escapeString(businessKey);
  }
  updateGui(containerType, gui) {
    if (containerType === "left") {
      this.leftGui = gui;
    } else if (containerType === "right") {
      this.rightGui = gui;
    } else if (containerType === "fullWidth") {
      this.fullWidthGui = gui;
    } else {
      this.centerGui = gui;
    }
  }
  setComp(rowComp, element, containerType, compBean) {
    const { context, focusSvc } = this.beans;
    compBean = setupCompBean(this, context, compBean);
    const gui = { rowComp, element, containerType, compBean };
    this.allRowGuis.push(gui);
    this.updateGui(containerType, gui);
    this.initialiseRowComp(gui);
    const rowNode = this.rowNode;
    const isSsrmLoadingRow = this.rowType === "FullWidthLoading" || rowNode.stub;
    const isIrmLoadingRow = !rowNode.data && this.beans.rowModel.getType() === "infinite";
    if (!isSsrmLoadingRow && !isIrmLoadingRow && !rowNode.rowPinned) {
      this.beans.rowRenderer.dispatchFirstDataRenderedEvent();
    }
    const focusableElement = this.fullWidthGui?.element;
    if (focusableElement) {
      const editing = this.beans.editSvc?.isEditing(this);
      if (!editing && focusSvc.isRowFocused(rowNode.rowIndex, rowNode.rowPinned) && focusSvc.shouldTakeFocus()) {
        setTimeout(() => focusableElement.focus({ preventScroll: true }), 0);
      }
    }
  }
  unsetComp(containerType) {
    this.allRowGuis = this.allRowGuis.filter((rowGui) => rowGui.containerType !== containerType);
    this.updateGui(containerType, void 0);
  }
  isCacheable() {
    return this.rowType === "FullWidthDetail" && this.gos.get("keepDetailRows");
  }
  setCached(cached) {
    const displayValue = cached ? "none" : "";
    this.allRowGuis.forEach((rg) => rg.element.style.display = displayValue);
  }
  initialiseRowComp(gui) {
    const gos = this.gos;
    this.onSuppressCellFocusChanged(this.beans.gos.get("suppressCellFocus"));
    this.listenOnDomOrder(gui);
    this.onRowHeightChanged(gui);
    this.updateRowIndexes(gui);
    this.setFocusedClasses(gui);
    this.setStylesFromGridOptions(false, gui);
    if (_isRowSelection(gos) && this.rowNode.selectable) {
      this.onRowSelected(gui);
    }
    this.updateColumnLists(!this.useAnimationFrameForCreate);
    const comp = gui.rowComp;
    const initialRowClasses = this.getInitialRowClasses(gui.containerType);
    initialRowClasses.forEach((name) => comp.toggleCss(name, true));
    this.executeSlideAndFadeAnimations(gui);
    if (this.rowNode.group) {
      _setAriaExpanded(gui.element, this.rowNode.expanded == true);
    }
    this.setRowCompRowId(comp);
    this.setRowCompRowBusinessKey(comp);
    _setDomData(gos, gui.element, DOM_DATA_KEY_ROW_CTRL, this);
    gui.compBean.addDestroyFunc(() => _setDomData(gos, gui.element, DOM_DATA_KEY_ROW_CTRL, null));
    if (this.useAnimationFrameForCreate) {
      this.beans.animationFrameSvc.createTask(
        this.addHoverFunctionality.bind(this, gui),
        this.rowNode.rowIndex,
        "p2",
        false
      );
    } else {
      this.addHoverFunctionality(gui);
    }
    if (this.isFullWidth()) {
      this.setupFullWidth(gui);
    }
    if (gos.get("rowDragEntireRow")) {
      this.addRowDraggerToRow(gui);
    }
    if (this.useAnimationFrameForCreate) {
      this.beans.animationFrameSvc.addDestroyTask(() => {
        if (!this.isAlive()) {
          return;
        }
        gui.rowComp.toggleCss("ag-after-created", true);
      });
    }
    this.executeProcessRowPostCreateFunc();
  }
  setRowCompRowBusinessKey(comp) {
    if (this.businessKey == null) {
      return;
    }
    comp.setRowBusinessKey(this.businessKey);
  }
  setRowCompRowId(comp) {
    const rowId = _escapeString(this.rowNode.id);
    this.rowId = rowId;
    if (rowId == null) {
      return;
    }
    comp.setRowId(rowId);
  }
  executeSlideAndFadeAnimations(gui) {
    const { containerType } = gui;
    const shouldSlide = this.slideInAnimation[containerType];
    if (shouldSlide) {
      _batchCall(() => {
        this.onTopChanged();
      });
      this.slideInAnimation[containerType] = false;
    }
    const shouldFade = this.fadeInAnimation[containerType];
    if (shouldFade) {
      _batchCall(() => {
        gui.rowComp.toggleCss("ag-opacity-zero", false);
      });
      this.fadeInAnimation[containerType] = false;
    }
  }
  addRowDraggerToRow(gui) {
    const rowDragComp = this.beans.rowDragSvc?.createRowDragCompForRow(this.rowNode, gui.element);
    if (!rowDragComp) {
      return;
    }
    const rowDragBean = this.createBean(rowDragComp, this.beans.context);
    this.rowDragComps.push(rowDragBean);
    gui.compBean.addDestroyFunc(() => {
      this.rowDragComps = this.rowDragComps.filter((r) => r !== rowDragBean);
      this.rowEditStyleFeature = this.destroyBean(this.rowEditStyleFeature, this.beans.context);
      this.destroyBean(rowDragBean, this.beans.context);
    });
  }
  setupFullWidth(gui) {
    const pinned = this.getPinnedForContainer(gui.containerType);
    const compDetails = this.createFullWidthCompDetails(gui.element, pinned);
    gui.rowComp.showFullWidth(compDetails);
  }
  getFullWidthCellRenderers() {
    if (this.gos.get("embedFullWidthRows")) {
      return this.allRowGuis.map((gui) => gui?.rowComp?.getFullWidthCellRenderer());
    }
    return [this.fullWidthGui?.rowComp?.getFullWidthCellRenderer()];
  }
  executeProcessRowPostCreateFunc() {
    const func = this.gos.getCallback("processRowPostCreate");
    if (!func || !this.areAllContainersReady()) {
      return;
    }
    const params = {
      // areAllContainersReady asserts that centerGui is not null
      eRow: this.centerGui.element,
      ePinnedLeftRow: this.leftGui ? this.leftGui.element : void 0,
      ePinnedRightRow: this.rightGui ? this.rightGui.element : void 0,
      node: this.rowNode,
      rowIndex: this.rowNode.rowIndex,
      addRenderedRowListener: this.addEventListener.bind(this)
    };
    func(params);
  }
  areAllContainersReady() {
    const {
      leftGui,
      centerGui,
      rightGui,
      beans: { visibleCols }
    } = this;
    const isLeftReady = !!leftGui || !visibleCols.isPinningLeft();
    const isCenterReady = !!centerGui;
    const isRightReady = !!rightGui || !visibleCols.isPinningRight();
    return isLeftReady && isCenterReady && isRightReady;
  }
  isNodeFullWidthCell() {
    if (this.rowNode.detail) {
      return true;
    }
    const isFullWidthCellFunc = this.beans.gos.getCallback("isFullWidthRow");
    return isFullWidthCellFunc ? isFullWidthCellFunc({ rowNode: this.rowNode }) : false;
  }
  setRowType() {
    const isStub = this.rowNode.stub && !this.gos.get("suppressServerSideFullWidthLoadingRow") && !this.gos.get("groupHideOpenParents");
    const isFullWidthCell = this.isNodeFullWidthCell();
    const isDetailCell = this.gos.get("masterDetail") && this.rowNode.detail;
    const pivotMode = this.beans.colModel.isPivotMode();
    const isFullWidthGroup = _isFullWidthGroupRow(this.gos, this.rowNode, pivotMode);
    if (isStub) {
      this.rowType = "FullWidthLoading";
    } else if (isDetailCell) {
      this.rowType = "FullWidthDetail";
    } else if (isFullWidthCell) {
      this.rowType = "FullWidth";
    } else if (isFullWidthGroup) {
      this.rowType = "FullWidthGroup";
    } else {
      this.rowType = "Normal";
    }
  }
  updateColumnLists(suppressAnimationFrame = false, useFlushSync = false) {
    if (this.isFullWidth()) {
      return;
    }
    const { animationFrameSvc } = this.beans;
    const noAnimation = !animationFrameSvc?.active || suppressAnimationFrame || this.printLayout;
    if (noAnimation) {
      this.updateColumnListsImpl(useFlushSync);
      return;
    }
    if (this.updateColumnListsPending) {
      return;
    }
    animationFrameSvc.createTask(
      () => {
        if (!this.active) {
          return;
        }
        this.updateColumnListsImpl(true);
      },
      this.rowNode.rowIndex,
      "p1",
      false
    );
    this.updateColumnListsPending = true;
  }
  /**
   * Overridden by SpannedRowCtrl
   */
  getNewCellCtrl(col) {
    const isCellSpan = this.beans.rowSpanSvc?.isCellSpanning(col, this.rowNode);
    if (isCellSpan) {
      return void 0;
    }
    return new CellCtrl(col, this.rowNode, this.beans, this);
  }
  /**
   * Overridden by SpannedRowCtrl, if span context changes cell needs rebuilt
   */
  isCorrectCtrlForSpan(cell) {
    return !this.beans.rowSpanSvc?.isCellSpanning(cell.column, this.rowNode);
  }
  createCellCtrls(prev, cols, pinned = null) {
    const res = {
      list: [],
      map: {}
    };
    const addCell = (colInstanceId, cellCtrl, index) => {
      if (index != null) {
        res.list.splice(index, 0, cellCtrl);
      } else {
        res.list.push(cellCtrl);
      }
      res.map[colInstanceId] = cellCtrl;
    };
    const colsFromPrev = [];
    for (const col of cols) {
      const colInstanceId = col.getInstanceId();
      let cellCtrl = prev.map[colInstanceId];
      if (cellCtrl && !this.isCorrectCtrlForSpan(cellCtrl)) {
        cellCtrl.destroy();
        cellCtrl = void 0;
      }
      if (!cellCtrl) {
        cellCtrl = this.getNewCellCtrl(col);
      }
      if (!cellCtrl) {
        continue;
      }
      addCell(colInstanceId, cellCtrl);
    }
    for (const prevCellCtrl of prev.list) {
      const colInstanceId = prevCellCtrl.column.getInstanceId();
      const cellInResult = res.map[colInstanceId] != null;
      if (cellInResult) {
        continue;
      }
      const keepCell = !this.isCellEligibleToBeRemoved(prevCellCtrl, pinned);
      if (keepCell) {
        colsFromPrev.push([colInstanceId, prevCellCtrl]);
      } else {
        prevCellCtrl.destroy();
      }
    }
    if (colsFromPrev.length) {
      for (const [colInstanceId, cellCtrl] of colsFromPrev) {
        const index = res.list.findIndex((ctrl) => ctrl.column.getLeft() > cellCtrl.column.getLeft());
        const normalisedIndex = index === -1 ? void 0 : Math.max(index - 1, 0);
        addCell(colInstanceId, cellCtrl, normalisedIndex);
      }
    }
    const { focusSvc, visibleCols } = this.beans;
    const focusedCell = focusSvc.getFocusedCell();
    if (focusedCell && focusedCell.column.getPinned() == pinned) {
      const focusedColInstanceId = focusedCell.column.getInstanceId();
      const focusedCellCtrl = res.map[focusedColInstanceId];
      if (!focusedCellCtrl && visibleCols.allCols.includes(focusedCell.column)) {
        const cellCtrl = this.createFocusedCellCtrl();
        if (cellCtrl) {
          const index = res.list.findIndex((ctrl) => ctrl.column.getLeft() > cellCtrl.column.getLeft());
          const normalisedIndex = index === -1 ? void 0 : Math.max(index - 1, 0);
          addCell(focusedColInstanceId, cellCtrl, normalisedIndex);
        }
      }
    }
    return res;
  }
  /**
   * Creates a new cell ctrl for the focused cell, if this is the correct row ctrl.
   * @returns a CellCtrl for the focused cell, if required.
   */
  createFocusedCellCtrl() {
    const { focusSvc, rowSpanSvc } = this.beans;
    const focusedCell = focusSvc.getFocusedCell();
    if (!focusedCell) {
      return void 0;
    }
    const focusedSpan = rowSpanSvc?.getCellSpan(focusedCell.column, this.rowNode);
    if (focusedSpan) {
      if (focusedSpan.firstNode !== this.rowNode || !focusedSpan.doesSpanContain(focusedCell)) {
        return void 0;
      }
    } else {
      if (!focusSvc.isRowFocused(this.rowNode.rowIndex, this.rowNode.rowPinned)) {
        return void 0;
      }
    }
    return this.getNewCellCtrl(focusedCell.column);
  }
  updateColumnListsImpl(useFlushSync) {
    this.updateColumnListsPending = false;
    this.createAllCellCtrls();
    this.setCellCtrls(useFlushSync);
  }
  setCellCtrls(useFlushSync) {
    this.allRowGuis.forEach((item) => {
      const cellControls = this.getCellCtrlsForContainer(item.containerType);
      item.rowComp.setCellCtrls(cellControls, useFlushSync);
    });
  }
  getCellCtrlsForContainer(containerType) {
    switch (containerType) {
      case "left":
        return this.leftCellCtrls.list;
      case "right":
        return this.rightCellCtrls.list;
      case "fullWidth":
        return [];
      case "center":
        return this.centerCellCtrls.list;
    }
  }
  createAllCellCtrls() {
    const colViewport = this.beans.colViewport;
    const presentedColsService = this.beans.visibleCols;
    if (this.printLayout) {
      this.centerCellCtrls = this.createCellCtrls(this.centerCellCtrls, presentedColsService.allCols);
      this.leftCellCtrls = { list: [], map: {} };
      this.rightCellCtrls = { list: [], map: {} };
    } else {
      const centerCols = colViewport.getColsWithinViewport(this.rowNode);
      this.centerCellCtrls = this.createCellCtrls(this.centerCellCtrls, centerCols);
      const leftCols = presentedColsService.getLeftColsForRow(this.rowNode);
      this.leftCellCtrls = this.createCellCtrls(this.leftCellCtrls, leftCols, "left");
      const rightCols = presentedColsService.getRightColsForRow(this.rowNode);
      this.rightCellCtrls = this.createCellCtrls(this.rightCellCtrls, rightCols, "right");
    }
  }
  isCellEligibleToBeRemoved(cellCtrl, nextContainerPinned) {
    const REMOVE_CELL = true;
    const KEEP_CELL = false;
    const { column } = cellCtrl;
    if (column.getPinned() != nextContainerPinned) {
      return REMOVE_CELL;
    }
    if (!this.isCorrectCtrlForSpan(cellCtrl)) {
      return REMOVE_CELL;
    }
    const { visibleCols, editSvc } = this.beans;
    const editing = editSvc?.isEditing(cellCtrl);
    const focused = cellCtrl.isCellFocused();
    const mightWantToKeepCell = editing || focused;
    if (mightWantToKeepCell) {
      const displayedColumns = visibleCols.allCols;
      const cellStillDisplayed = displayedColumns.indexOf(column) >= 0;
      return cellStillDisplayed ? KEEP_CELL : REMOVE_CELL;
    }
    return REMOVE_CELL;
  }
  getDomOrder() {
    const isEnsureDomOrder = this.gos.get("ensureDomOrder");
    return isEnsureDomOrder || _isDomLayout(this.gos, "print");
  }
  listenOnDomOrder(gui) {
    const listener = () => {
      gui.rowComp.setDomOrder(this.getDomOrder());
    };
    gui.compBean.addManagedPropertyListeners(["domLayout", "ensureDomOrder"], listener);
  }
  setAnimateFlags(animateIn) {
    if (this.rowNode.sticky || !animateIn) {
      return;
    }
    const oldRowTopExists = _exists(this.rowNode.oldRowTop);
    const { visibleCols } = this.beans;
    const pinningLeft = visibleCols.isPinningLeft();
    const pinningRight = visibleCols.isPinningRight();
    if (oldRowTopExists) {
      const { slideInAnimation } = this;
      if (this.isFullWidth() && !this.gos.get("embedFullWidthRows")) {
        slideInAnimation.fullWidth = true;
        return;
      }
      slideInAnimation.center = true;
      slideInAnimation.left = pinningLeft;
      slideInAnimation.right = pinningRight;
    } else {
      const { fadeInAnimation } = this;
      if (this.isFullWidth() && !this.gos.get("embedFullWidthRows")) {
        fadeInAnimation.fullWidth = true;
        return;
      }
      fadeInAnimation.center = true;
      fadeInAnimation.left = pinningLeft;
      fadeInAnimation.right = pinningRight;
    }
  }
  isFullWidth() {
    return this.rowType !== "Normal";
  }
  refreshFullWidth() {
    const tryRefresh = (gui, pinned) => {
      if (!gui) {
        return true;
      }
      return gui.rowComp.refreshFullWidth(() => {
        const compDetails = this.createFullWidthCompDetails(gui.element, pinned);
        return compDetails.params;
      });
    };
    const fullWidthSuccess = tryRefresh(this.fullWidthGui, null);
    const centerSuccess = tryRefresh(this.centerGui, null);
    const leftSuccess = tryRefresh(this.leftGui, "left");
    const rightSuccess = tryRefresh(this.rightGui, "right");
    const allFullWidthRowsRefreshed = fullWidthSuccess && centerSuccess && leftSuccess && rightSuccess;
    return allFullWidthRowsRefreshed;
  }
  addListeners() {
    const { beans, gos, rowNode } = this;
    const { expansionSvc, eventSvc, context, rowSpanSvc } = beans;
    this.addManagedListeners(this.rowNode, {
      heightChanged: () => this.onRowHeightChanged(),
      rowSelected: () => this.onRowSelected(),
      rowIndexChanged: this.onRowIndexChanged.bind(this),
      topChanged: this.onTopChanged.bind(this),
      ...expansionSvc?.getRowExpandedListeners(this) ?? {}
    });
    if (rowNode.detail) {
      this.addManagedListeners(rowNode.parent, { dataChanged: this.onRowNodeDataChanged.bind(this) });
    }
    this.addManagedListeners(rowNode, {
      dataChanged: this.onRowNodeDataChanged.bind(this),
      cellChanged: this.postProcessCss.bind(this),
      rowHighlightChanged: this.onRowNodeHighlightChanged.bind(this),
      draggingChanged: this.postProcessRowDragging.bind(this),
      uiLevelChanged: this.onUiLevelChanged.bind(this),
      rowPinned: this.onRowPinned.bind(this)
    });
    this.addManagedListeners(eventSvc, {
      paginationPixelOffsetChanged: this.onPaginationPixelOffsetChanged.bind(this),
      heightScaleChanged: this.onTopChanged.bind(this),
      displayedColumnsChanged: this.onDisplayedColumnsChanged.bind(this),
      virtualColumnsChanged: this.onVirtualColumnsChanged.bind(this),
      cellFocused: this.onCellFocusChanged.bind(this),
      cellFocusCleared: this.onCellFocusChanged.bind(this),
      paginationChanged: this.onPaginationChanged.bind(this),
      modelUpdated: this.refreshFirstAndLastRowStyles.bind(this),
      columnMoved: () => this.updateColumnLists()
    });
    if (rowSpanSvc) {
      this.addManagedListeners(rowSpanSvc, {
        spannedCellsUpdated: ({ pinned }) => {
          if (pinned && !rowNode.rowPinned) {
            return;
          }
          this.updateColumnLists();
        }
      });
    }
    this.addDestroyFunc(() => {
      this.rowDragComps = this.destroyBeans(this.rowDragComps, context);
      this.tooltipFeature = this.destroyBean(this.tooltipFeature, context);
      this.rowEditStyleFeature = this.destroyBean(this.rowEditStyleFeature, context);
    });
    this.addManagedPropertyListeners(
      ["rowStyle", "getRowStyle", "rowClass", "getRowClass", "rowClassRules"],
      this.postProcessCss.bind(this)
    );
    this.addManagedPropertyListener("rowDragEntireRow", () => {
      const useRowDragEntireRow = gos.get("rowDragEntireRow");
      if (useRowDragEntireRow) {
        this.allRowGuis.forEach((gui) => {
          this.addRowDraggerToRow(gui);
        });
        return;
      }
      this.rowDragComps = this.destroyBeans(this.rowDragComps, context);
    });
    this.addListenersForCellComps();
  }
  addListenersForCellComps() {
    this.addManagedListeners(this.rowNode, {
      rowIndexChanged: () => this.getAllCellCtrls().forEach((cellCtrl) => cellCtrl.onRowIndexChanged()),
      cellChanged: (event) => this.getAllCellCtrls().forEach((cellCtrl) => cellCtrl.onCellChanged(event))
    });
  }
  /** Should only ever be triggered on source rows (i.e. not on pinned siblings) */
  onRowPinned() {
    for (const gui of this.allRowGuis) {
      gui.rowComp.toggleCss("ag-row-pinned-source", !!this.rowNode.pinnedSibling);
    }
  }
  onRowNodeDataChanged(event) {
    this.refreshRow({
      suppressFlash: !event.update,
      newData: !event.update
    });
  }
  refreshRow(params) {
    const fullWidthChanged = this.isFullWidth() !== !!this.isNodeFullWidthCell();
    if (fullWidthChanged) {
      this.beans.rowRenderer.redrawRow(this.rowNode);
      return;
    }
    if (this.isFullWidth()) {
      const refresh = this.refreshFullWidth();
      if (!refresh) {
        this.beans.rowRenderer.redrawRow(this.rowNode);
      }
      return;
    }
    this.getAllCellCtrls().forEach((cellCtrl) => cellCtrl.refreshCell(params));
    this.allRowGuis.forEach((gui) => {
      this.setRowCompRowId(gui.rowComp);
      this.updateRowBusinessKey();
      this.setRowCompRowBusinessKey(gui.rowComp);
    });
    this.onRowSelected();
    this.postProcessCss();
  }
  postProcessCss() {
    this.setStylesFromGridOptions(true);
    this.postProcessClassesFromGridOptions();
    this.postProcessRowClassRules();
    this.rowEditStyleFeature?.applyRowStyles();
    this.postProcessRowDragging();
  }
  onRowNodeHighlightChanged() {
    const rowDropHighlightSvc = this.beans.rowDropHighlightSvc;
    const highlighted = rowDropHighlightSvc?.row === this.rowNode ? rowDropHighlightSvc.position : "none";
    const aboveOn = highlighted === "above";
    const insideOn = highlighted === "inside";
    const belowOn = highlighted === "below";
    const treeData = this.gos.get("treeData");
    const indented = treeData && (belowOn || aboveOn);
    const uiLevel = this.rowNode.uiLevel.toString();
    this.allRowGuis.forEach((gui) => {
      const rowComp = gui.rowComp;
      rowComp.toggleCss("ag-row-highlight-above", aboveOn);
      rowComp.toggleCss("ag-row-highlight-inside", insideOn);
      rowComp.toggleCss("ag-row-highlight-below", belowOn);
      rowComp.toggleCss("ag-row-highlight-indent", indented);
      if (indented) {
        gui.element.style.setProperty("--ag-row-highlight-level", uiLevel);
      } else {
        gui.element.style.removeProperty("--ag-row-highlight-level");
      }
    });
  }
  postProcessRowDragging() {
    const dragging = this.rowNode.dragging;
    this.allRowGuis.forEach((gui) => gui.rowComp.toggleCss("ag-row-dragging", dragging));
  }
  onDisplayedColumnsChanged() {
    this.updateColumnLists(true);
    this.beans.rowAutoHeight?.requestCheckAutoHeight();
  }
  onVirtualColumnsChanged() {
    this.updateColumnLists(false, true);
  }
  getRowPosition() {
    return {
      rowPinned: _makeNull(this.rowNode.rowPinned),
      rowIndex: this.rowNode.rowIndex
    };
  }
  onKeyboardNavigate(keyboardEvent) {
    const groupInfo = this.findFullWidthInfoForEvent(keyboardEvent);
    if (!groupInfo) {
      return;
    }
    const { rowGui, column } = groupInfo;
    const currentFullWidthContainer = rowGui.element;
    const isFullWidthContainerFocused = currentFullWidthContainer === keyboardEvent.target;
    if (!isFullWidthContainerFocused) {
      return;
    }
    const node = this.rowNode;
    const { focusSvc, navigation } = this.beans;
    const lastFocusedCell = focusSvc.getFocusedCell();
    const cellPosition = {
      rowIndex: node.rowIndex,
      rowPinned: node.rowPinned,
      column: lastFocusedCell?.column ?? column
    };
    navigation?.navigateToNextCell(keyboardEvent, keyboardEvent.key, cellPosition, true);
    keyboardEvent.preventDefault();
  }
  onTabKeyDown(keyboardEvent) {
    if (keyboardEvent.defaultPrevented || _isStopPropagationForAgGrid(keyboardEvent)) {
      return;
    }
    const currentFullWidthComp = this.allRowGuis.find(
      (c) => c.element.contains(keyboardEvent.target)
    );
    const currentFullWidthContainer = currentFullWidthComp ? currentFullWidthComp.element : null;
    const isFullWidthContainerFocused = currentFullWidthContainer === keyboardEvent.target;
    const activeEl = _getActiveDomElement(this.beans);
    let isDetailGridCellFocused = false;
    if (currentFullWidthContainer && activeEl) {
      isDetailGridCellFocused = currentFullWidthContainer.contains(activeEl) && activeEl.classList.contains("ag-cell");
    }
    let nextEl = null;
    if (!isFullWidthContainerFocused && !isDetailGridCellFocused) {
      nextEl = _findNextFocusableElement(this.beans, currentFullWidthContainer, false, keyboardEvent.shiftKey);
    }
    if (this.isFullWidth() && isFullWidthContainerFocused || !nextEl) {
      this.beans.navigation?.onTabKeyDown(this, keyboardEvent);
    }
  }
  getFullWidthElement() {
    if (this.fullWidthGui) {
      return this.fullWidthGui.element;
    }
    return null;
  }
  getRowYPosition() {
    const displayedEl = this.allRowGuis.find((el) => _isVisible(el.element))?.element;
    if (displayedEl) {
      return displayedEl.getBoundingClientRect().top;
    }
    return 0;
  }
  onSuppressCellFocusChanged(suppressCellFocus) {
    const tabIndex = this.isFullWidth() && suppressCellFocus ? void 0 : -1;
    this.allRowGuis.forEach((gui) => {
      _addOrRemoveAttribute(gui.element, "tabindex", tabIndex);
    });
  }
  onFullWidthRowFocused(event) {
    const node = this.rowNode;
    const isFocused = !event ? false : this.isFullWidth() && event.rowIndex === node.rowIndex && event.rowPinned == node.rowPinned;
    let element;
    if (this.fullWidthGui) {
      element = this.fullWidthGui.element;
    } else {
      const column = this.beans.colModel.getCol(event?.column);
      const pinned = column?.pinned;
      if (pinned) {
        element = pinned === "right" ? this.rightGui?.element : this.leftGui?.element;
      } else {
        element = this.centerGui?.element;
      }
    }
    if (!element) {
      return;
    }
    element.classList.toggle("ag-full-width-focus", isFocused);
    if (isFocused && event?.forceBrowserFocus) {
      element.focus({ preventScroll: true });
    }
  }
  recreateCell(cellCtrl) {
    this.centerCellCtrls = this.removeCellCtrl(this.centerCellCtrls, cellCtrl);
    this.leftCellCtrls = this.removeCellCtrl(this.leftCellCtrls, cellCtrl);
    this.rightCellCtrls = this.removeCellCtrl(this.rightCellCtrls, cellCtrl);
    cellCtrl.destroy();
    this.updateColumnLists();
  }
  removeCellCtrl(prev, cellCtrlToRemove) {
    const res = {
      list: [],
      map: {}
    };
    prev.list.forEach((cellCtrl) => {
      if (cellCtrl === cellCtrlToRemove) {
        return;
      }
      res.list.push(cellCtrl);
      res.map[cellCtrl.column.getInstanceId()] = cellCtrl;
    });
    return res;
  }
  onMouseEvent(eventName, mouseEvent) {
    switch (eventName) {
      case "dblclick":
        this.onRowDblClick(mouseEvent);
        break;
      case "click":
        this.onRowClick(mouseEvent);
        break;
      case "touchstart":
      case "mousedown":
        this.onRowMouseDown(mouseEvent);
        break;
    }
  }
  createRowEvent(type, domEvent) {
    const { rowNode } = this;
    return _addGridCommonParams(this.gos, {
      type,
      node: rowNode,
      data: rowNode.data,
      rowIndex: rowNode.rowIndex,
      rowPinned: rowNode.rowPinned,
      event: domEvent
    });
  }
  createRowEventWithSource(type, domEvent) {
    const event = this.createRowEvent(type, domEvent);
    event.source = this;
    return event;
  }
  onRowDblClick(mouseEvent) {
    if (_isStopPropagationForAgGrid(mouseEvent)) {
      return;
    }
    this.beans.eventSvc.dispatchEvent(this.createRowEventWithSource("rowDoubleClicked", mouseEvent));
  }
  findFullWidthInfoForEvent(event) {
    if (!event) {
      return;
    }
    const rowGui = this.findFullWidthRowGui(event.target);
    const column = this.getColumnForFullWidth(rowGui);
    if (!rowGui || !column) {
      return;
    }
    return { rowGui, column };
  }
  findFullWidthRowGui(target) {
    return this.allRowGuis.find((c) => c.element.contains(target));
  }
  getColumnForFullWidth(fullWidthRowGui) {
    const { visibleCols } = this.beans;
    switch (fullWidthRowGui?.containerType) {
      case "center":
        return visibleCols.centerCols[0];
      case "left":
        return visibleCols.leftCols[0];
      case "right":
        return visibleCols.rightCols[0];
      default:
        return visibleCols.allCols[0];
    }
  }
  onRowMouseDown(mouseEvent) {
    this.lastMouseDownOnDragger = _isElementChildOfClass(mouseEvent.target, "ag-row-drag", 3);
    if (!this.isFullWidth()) {
      return;
    }
    const node = this.rowNode;
    const { rangeSvc, focusSvc } = this.beans;
    rangeSvc?.removeAllCellRanges();
    const groupInfo = this.findFullWidthInfoForEvent(mouseEvent);
    if (!groupInfo) {
      return;
    }
    const { rowGui, column } = groupInfo;
    const element = rowGui.element;
    const target = mouseEvent.target;
    let forceBrowserFocus = mouseEvent.defaultPrevented || _isBrowserSafari();
    if (element && element.contains(target) && _isFocusableFormField(target)) {
      forceBrowserFocus = false;
    }
    focusSvc.setFocusedCell({
      rowIndex: node.rowIndex,
      column,
      rowPinned: node.rowPinned,
      forceBrowserFocus
    });
  }
  onRowClick(mouseEvent) {
    const stop = _isStopPropagationForAgGrid(mouseEvent) || this.lastMouseDownOnDragger;
    if (stop) {
      return;
    }
    const { eventSvc, selectionSvc } = this.beans;
    eventSvc.dispatchEvent(this.createRowEventWithSource("rowClicked", mouseEvent));
    selectionSvc?.handleSelectionEvent(mouseEvent, this.rowNode, "rowClicked");
  }
  setupDetailRowAutoHeight(eDetailGui) {
    if (this.rowType !== "FullWidthDetail") {
      return;
    }
    this.beans.masterDetailSvc?.setupDetailRowAutoHeight(this, eDetailGui);
  }
  createFullWidthCompDetails(eRow, pinned) {
    const { gos, rowNode } = this;
    const params = _addGridCommonParams(gos, {
      fullWidth: true,
      data: rowNode.data,
      node: rowNode,
      value: rowNode.key,
      valueFormatted: rowNode.key,
      // these need to be taken out, as part of 'afterAttached' now
      eGridCell: eRow,
      eParentOfValue: eRow,
      pinned,
      addRenderedRowListener: this.addEventListener.bind(this),
      // This is not on the type of ICellRendererParams
      registerRowDragger: (rowDraggerElement, dragStartPixels, value, suppressVisibilityChange) => this.addFullWidthRowDragging(rowDraggerElement, dragStartPixels, value, suppressVisibilityChange),
      setTooltip: (value, shouldDisplayTooltip) => {
        gos.assertModuleRegistered("Tooltip", 3);
        this.setupFullWidthRowTooltip(value, shouldDisplayTooltip);
      }
    });
    const compFactory = this.beans.userCompFactory;
    switch (this.rowType) {
      case "FullWidthDetail":
        return _getFullWidthDetailCellRendererDetails(compFactory, params);
      case "FullWidthGroup": {
        const { value, valueFormatted } = this.beans.valueSvc.getValueForDisplay(void 0, this.rowNode, true);
        params.value = value;
        params.valueFormatted = valueFormatted;
        return _getFullWidthGroupCellRendererDetails(compFactory, params);
      }
      case "FullWidthLoading":
        return _getFullWidthLoadingCellRendererDetails(compFactory, params);
      default:
        return _getFullWidthCellRendererDetails(compFactory, params);
    }
  }
  setupFullWidthRowTooltip(value, shouldDisplayTooltip) {
    if (!this.fullWidthGui) {
      return;
    }
    this.tooltipFeature = this.beans.tooltipSvc?.setupFullWidthRowTooltip(
      this.tooltipFeature,
      this,
      value,
      shouldDisplayTooltip
    );
  }
  addFullWidthRowDragging(rowDraggerElement, dragStartPixels, value = "", suppressVisibilityChange) {
    const { rowDragSvc, context } = this.beans;
    if (!rowDragSvc || !this.isFullWidth()) {
      return;
    }
    const rowDragComp = rowDragSvc.createRowDragComp(
      () => value,
      this.rowNode,
      void 0,
      rowDraggerElement,
      dragStartPixels,
      suppressVisibilityChange
    );
    this.createBean(rowDragComp, context);
    this.addDestroyFunc(() => {
      this.destroyBean(rowDragComp, context);
    });
  }
  onUiLevelChanged() {
    const newLevel = calculateRowLevel(this.rowNode);
    if (this.rowLevel != newLevel) {
      const classToAdd = "ag-row-level-" + newLevel;
      const classToRemove = "ag-row-level-" + this.rowLevel;
      this.allRowGuis.forEach((gui) => {
        gui.rowComp.toggleCss(classToAdd, true);
        gui.rowComp.toggleCss(classToRemove, false);
      });
    }
    this.rowLevel = newLevel;
  }
  isFirstRowOnPage() {
    return this.rowNode.rowIndex === this.beans.pageBounds.getFirstRow();
  }
  isLastRowOnPage() {
    return this.rowNode.rowIndex === this.beans.pageBounds.getLastRow();
  }
  refreshFirstAndLastRowStyles() {
    const newFirst = this.isFirstRowOnPage();
    const newLast = this.isLastRowOnPage();
    if (this.firstRowOnPage !== newFirst) {
      this.firstRowOnPage = newFirst;
      this.allRowGuis.forEach((gui) => gui.rowComp.toggleCss("ag-row-first", newFirst));
    }
    if (this.lastRowOnPage !== newLast) {
      this.lastRowOnPage = newLast;
      this.allRowGuis.forEach((gui) => gui.rowComp.toggleCss("ag-row-last", newLast));
    }
  }
  getAllCellCtrls() {
    if (this.leftCellCtrls.list.length === 0 && this.rightCellCtrls.list.length === 0) {
      return this.centerCellCtrls.list;
    }
    const res = [...this.centerCellCtrls.list, ...this.leftCellCtrls.list, ...this.rightCellCtrls.list];
    return res;
  }
  postProcessClassesFromGridOptions() {
    const cssClasses = [];
    this.beans.rowStyleSvc?.processClassesFromGridOptions(cssClasses, this.rowNode);
    if (!cssClasses.length) {
      return;
    }
    cssClasses.forEach((classStr) => {
      this.allRowGuis.forEach((c) => c.rowComp.toggleCss(classStr, true));
    });
  }
  postProcessRowClassRules() {
    this.beans.rowStyleSvc?.processRowClassRules(
      this.rowNode,
      (className) => {
        this.allRowGuis.forEach((gui) => gui.rowComp.toggleCss(className, true));
      },
      (className) => {
        this.allRowGuis.forEach((gui) => gui.rowComp.toggleCss(className, false));
      }
    );
  }
  setStylesFromGridOptions(updateStyles, gui) {
    if (updateStyles) {
      this.rowStyles = this.processStylesFromGridOptions();
    }
    this.forEachGui(gui, (gui2) => gui2.rowComp.setUserStyles(this.rowStyles));
  }
  getPinnedForContainer(rowContainerType) {
    if (rowContainerType === "left" || rowContainerType === "right") {
      return rowContainerType;
    }
    return null;
  }
  getInitialRowClasses(rowContainerType) {
    const pinned = this.getPinnedForContainer(rowContainerType);
    const fullWidthRow = this.isFullWidth();
    const { rowNode, beans } = this;
    const classes = [];
    classes.push("ag-row");
    classes.push(this.rowFocused ? "ag-row-focus" : "ag-row-no-focus");
    if (this.fadeInAnimation[rowContainerType]) {
      classes.push("ag-opacity-zero");
    }
    classes.push(rowNode.rowIndex % 2 === 0 ? "ag-row-even" : "ag-row-odd");
    if (rowNode.isRowPinned()) {
      classes.push("ag-row-pinned");
      if (beans.pinnedRowModel?.isManual()) {
        classes.push("ag-row-pinned-manual");
      }
    }
    if (!rowNode.isRowPinned() && rowNode.pinnedSibling) {
      classes.push("ag-row-pinned-source");
    }
    if (rowNode.isSelected()) {
      classes.push("ag-row-selected");
    }
    if (rowNode.footer) {
      classes.push("ag-row-footer");
    }
    classes.push("ag-row-level-" + this.rowLevel);
    if (rowNode.stub) {
      classes.push("ag-row-loading");
    }
    if (fullWidthRow) {
      classes.push("ag-full-width-row");
    }
    beans.expansionSvc?.addExpandedCss(classes, rowNode);
    if (rowNode.dragging) {
      classes.push("ag-row-dragging");
    }
    const { rowStyleSvc } = beans;
    if (rowStyleSvc) {
      rowStyleSvc.processClassesFromGridOptions(classes, rowNode);
      rowStyleSvc.preProcessRowClassRules(classes, rowNode);
    }
    classes.push(this.printLayout ? "ag-row-position-relative" : "ag-row-position-absolute");
    if (this.isFirstRowOnPage()) {
      classes.push("ag-row-first");
    }
    if (this.isLastRowOnPage()) {
      classes.push("ag-row-last");
    }
    if (fullWidthRow) {
      if (pinned === "left") {
        classes.push("ag-cell-last-left-pinned");
      }
      if (pinned === "right") {
        classes.push("ag-cell-first-right-pinned");
      }
    }
    return classes;
  }
  processStylesFromGridOptions() {
    return this.beans.rowStyleSvc?.processStylesFromGridOptions(this.rowNode) ?? this.emptyStyle;
  }
  onRowSelected(gui) {
    this.beans.selectionSvc?.onRowCtrlSelected(
      this,
      (gui2) => {
        if (gui2 === this.centerGui || gui2 === this.fullWidthGui) {
          this.announceDescription();
        }
      },
      gui
    );
  }
  announceDescription() {
    this.beans.selectionSvc?.announceAriaRowSelection(this.rowNode);
  }
  addHoverFunctionality(eGui) {
    if (!this.active) {
      return;
    }
    const { element, compBean } = eGui;
    const { rowNode, beans, gos } = this;
    compBean.addManagedListeners(element, {
      // We use pointer events here instead of mouse events, as pointer events
      // are more reliable for hover detection, especially with touch devices
      // or hybrid touch + mouse devices.
      pointerenter: (e) => {
        if (e.pointerType === "mouse") {
          rowNode.dispatchRowEvent("mouseEnter");
        }
      },
      pointerleave: (e) => {
        if (e.pointerType === "mouse") {
          rowNode.dispatchRowEvent("mouseLeave");
        }
      }
    });
    compBean.addManagedListeners(rowNode, {
      mouseEnter: () => {
        if (!beans.dragSvc?.dragging && !gos.get("suppressRowHoverHighlight")) {
          element.classList.add("ag-row-hover");
          rowNode.setHovered(true);
        }
      },
      mouseLeave: () => {
        this.resetHoveredStatus(element);
      }
    });
  }
  resetHoveredStatus(el) {
    const elements = el ? [el] : this.allRowGuis.map((gui) => gui.element);
    for (const element of elements) {
      element.classList.remove("ag-row-hover");
    }
    this.rowNode.setHovered(false);
  }
  // for animation, we don't want to animate entry or exit to a very far away pixel,
  // otherwise the row would move so fast, it would appear to disappear. so this method
  // moves the row closer to the viewport if it is far away, so the row slide in / out
  // at a speed the user can see.
  roundRowTopToBounds(rowTop) {
    const range = this.beans.ctrlsSvc.getScrollFeature().getApproximateVScollPosition();
    const minPixel = this.applyPaginationOffset(range.top, true) - 100;
    const maxPixel = this.applyPaginationOffset(range.bottom, true) + 100;
    return Math.min(Math.max(minPixel, rowTop), maxPixel);
  }
  forEachGui(gui, callback) {
    if (gui) {
      callback(gui);
    } else {
      this.allRowGuis.forEach(callback);
    }
  }
  isRowRendered() {
    return this.allRowGuis.length > 0;
  }
  onRowHeightChanged(gui) {
    if (this.rowNode.rowHeight == null) {
      return;
    }
    const rowHeight = this.rowNode.rowHeight;
    const defaultRowHeight = this.beans.environment.getDefaultRowHeight();
    const isHeightFromFunc = _isGetRowHeightFunction(this.gos);
    const heightFromFunc = isHeightFromFunc ? _getRowHeightForNode(this.beans, this.rowNode).height : void 0;
    const lineHeight = heightFromFunc ? `${Math.min(defaultRowHeight, heightFromFunc) - 2}px` : void 0;
    this.forEachGui(gui, (gui2) => {
      gui2.element.style.height = `${rowHeight}px`;
      if (lineHeight) {
        gui2.element.style.setProperty("--ag-line-height", lineHeight);
      }
    });
  }
  // note - this is NOT called by context, as we don't wire / unwire the CellComp for performance reasons.
  destroyFirstPass(suppressAnimation = false) {
    this.active = false;
    const { rowNode } = this;
    if (!suppressAnimation && _isAnimateRows(this.gos) && !rowNode.sticky) {
      const rowStillVisibleJustNotInViewport = rowNode.rowTop != null;
      if (rowStillVisibleJustNotInViewport) {
        const rowTop = this.roundRowTopToBounds(rowNode.rowTop);
        this.setRowTop(rowTop);
      } else {
        this.allRowGuis.forEach((gui) => gui.rowComp.toggleCss("ag-opacity-zero", true));
      }
    }
    if (this.fullWidthGui?.element.contains(_getActiveDomElement(this.beans))) {
      this.beans.focusSvc.attemptToRecoverFocus();
    }
    rowNode.setHovered(false);
    const event = this.createRowEvent("virtualRowRemoved");
    this.dispatchLocalEvent(event);
    this.beans.eventSvc.dispatchEvent(event);
    super.destroy();
  }
  destroySecondPass() {
    this.allRowGuis.length = 0;
    const destroyCellCtrls = (ctrls) => {
      ctrls.list.forEach((c) => c.destroy());
      return { list: [], map: {} };
    };
    this.centerCellCtrls = destroyCellCtrls(this.centerCellCtrls);
    this.leftCellCtrls = destroyCellCtrls(this.leftCellCtrls);
    this.rightCellCtrls = destroyCellCtrls(this.rightCellCtrls);
  }
  setFocusedClasses(gui) {
    this.forEachGui(gui, (gui2) => {
      gui2.rowComp.toggleCss("ag-row-focus", this.rowFocused);
      gui2.rowComp.toggleCss("ag-row-no-focus", !this.rowFocused);
    });
  }
  onCellFocusChanged() {
    const { focusSvc } = this.beans;
    const rowFocused = focusSvc.isRowFocused(this.rowNode.rowIndex, this.rowNode.rowPinned);
    if (rowFocused !== this.rowFocused) {
      this.rowFocused = rowFocused;
      this.setFocusedClasses();
    }
  }
  onPaginationChanged() {
    const currentPage = this.beans.pagination?.getCurrentPage() ?? 0;
    if (this.paginationPage !== currentPage) {
      this.paginationPage = currentPage;
      this.onTopChanged();
    }
    this.refreshFirstAndLastRowStyles();
  }
  onTopChanged() {
    this.setRowTop(this.rowNode.rowTop);
  }
  onPaginationPixelOffsetChanged() {
    this.onTopChanged();
  }
  // applies pagination offset, eg if on second page, and page height is 500px, then removes
  // 500px from the top position, so a row with rowTop 600px is displayed at location 100px.
  // reverse will take the offset away rather than add.
  applyPaginationOffset(topPx, reverse = false) {
    if (this.rowNode.isRowPinned() || this.rowNode.sticky) {
      return topPx;
    }
    const pixelOffset = this.beans.pageBounds.getPixelOffset();
    const multiplier = reverse ? 1 : -1;
    return topPx + pixelOffset * multiplier;
  }
  setRowTop(pixels) {
    if (this.printLayout) {
      return;
    }
    if (_exists(pixels)) {
      const afterPaginationPixels = this.applyPaginationOffset(pixels);
      const skipScaling = this.rowNode.isRowPinned() || this.rowNode.sticky;
      const afterScalingPixels = skipScaling ? afterPaginationPixels : this.beans.rowContainerHeight.getRealPixelPosition(afterPaginationPixels);
      const topPx = `${afterScalingPixels}px`;
      this.setRowTopStyle(topPx);
    }
  }
  // the top needs to be set into the DOM element when the element is created, not updated afterwards.
  // otherwise the transition would not work, as it would be transitioning from zero (the unset value).
  // for example, suppose a row that is outside the viewport, then user does a filter to remove other rows
  // and this row now appears in the viewport, and the row moves up (ie it was under the viewport and not rendered,
  // but now is in the viewport) then a new RowComp is created, however it should have it's position initialised
  // to below the viewport, so the row will appear to animate up. if we didn't set the initial position at creation
  // time, the row would animate down (ie from position zero).
  getInitialRowTop(rowContainerType) {
    return this.suppressRowTransform ? this.getInitialRowTopShared(rowContainerType) : void 0;
  }
  getInitialTransform(rowContainerType) {
    return this.suppressRowTransform ? void 0 : `translateY(${this.getInitialRowTopShared(rowContainerType)})`;
  }
  getInitialRowTopShared(rowContainerType) {
    if (this.printLayout) {
      return "";
    }
    const rowNode = this.rowNode;
    let rowTop;
    if (rowNode.sticky) {
      rowTop = rowNode.stickyRowTop;
    } else {
      const pixels = this.slideInAnimation[rowContainerType] ? this.roundRowTopToBounds(rowNode.oldRowTop) : rowNode.rowTop;
      const afterPaginationPixels = this.applyPaginationOffset(pixels);
      rowTop = rowNode.isRowPinned() ? afterPaginationPixels : this.beans.rowContainerHeight.getRealPixelPosition(afterPaginationPixels);
    }
    return rowTop + "px";
  }
  setRowTopStyle(topPx) {
    this.allRowGuis.forEach(
      (gui) => this.suppressRowTransform ? gui.rowComp.setTop(topPx) : gui.rowComp.setTransform(`translateY(${topPx})`)
    );
  }
  getCellCtrl(column, skipColSpanSearch = false) {
    let res = null;
    this.getAllCellCtrls().forEach((cellCtrl) => {
      if (cellCtrl.column == column) {
        res = cellCtrl;
      }
    });
    if (res != null || skipColSpanSearch) {
      return res;
    }
    this.getAllCellCtrls().forEach((cellCtrl) => {
      if (cellCtrl?.getColSpanningList().indexOf(column) >= 0) {
        res = cellCtrl;
      }
    });
    return res;
  }
  onRowIndexChanged() {
    if (this.rowNode.rowIndex != null) {
      this.onCellFocusChanged();
      this.updateRowIndexes();
      this.postProcessCss();
    }
  }
  updateRowIndexes(gui) {
    const rowIndexStr = this.rowNode.getRowIndexString();
    if (rowIndexStr === null) {
      return;
    }
    const headerRowCount = (this.beans.ctrlsSvc.getHeaderRowContainerCtrl()?.getRowCount() ?? 0) + (this.beans.filterManager?.getHeaderRowCount() ?? 0);
    const rowIsEven = this.rowNode.rowIndex % 2 === 0;
    const ariaRowIndex = headerRowCount + this.rowNode.rowIndex + 1;
    this.forEachGui(gui, (c) => {
      c.rowComp.setRowIndex(rowIndexStr);
      c.rowComp.toggleCss("ag-row-even", rowIsEven);
      c.rowComp.toggleCss("ag-row-odd", !rowIsEven);
      _setAriaRowIndex(c.element, ariaRowIndex);
    });
  }
};

// packages/ag-grid-community/src/utils/keyboard.ts
function _isEventFromPrintableCharacter(event) {
  if (event.altKey || event.ctrlKey || event.metaKey) {
    return false;
  }
  const printableCharacter = event.key?.length === 1;
  return printableCharacter;
}
function _isUserSuppressingKeyboardEvent(gos, keyboardEvent, rowNode, column, editing) {
  const colDefFunc = column ? column.getColDef().suppressKeyboardEvent : void 0;
  if (!colDefFunc) {
    return false;
  }
  const params = _addGridCommonParams(gos, {
    event: keyboardEvent,
    editing,
    column,
    node: rowNode,
    data: rowNode.data,
    colDef: column.getColDef()
  });
  if (colDefFunc) {
    const colDefFuncResult = colDefFunc(params);
    if (colDefFuncResult) {
      return true;
    }
  }
  return false;
}

// packages/ag-grid-community/src/utils/selection.ts
function _selectAllCells(beans) {
  const { pinnedRowModel, rowModel } = beans;
  const [isEmptyPinnedTop, isEmptyPinnedBottom] = [
    pinnedRowModel?.isEmpty("top") ?? true,
    pinnedRowModel?.isEmpty("bottom") ?? true
  ];
  const floatingStart = isEmptyPinnedTop ? null : "top";
  let floatingEnd;
  let rowEnd;
  if (isEmptyPinnedBottom) {
    floatingEnd = null;
    rowEnd = rowModel.getRowCount() - 1;
  } else {
    floatingEnd = "bottom";
    rowEnd = pinnedRowModel?.getPinnedBottomRowCount() ?? 0 - 1;
  }
  const { visibleCols, rangeSvc } = beans;
  const allDisplayedColumns = visibleCols.allCols;
  if (!rangeSvc || !allDisplayedColumns?.length) {
    return;
  }
  rangeSvc.setCellRange({
    rowStartIndex: 0,
    rowStartPinned: floatingStart,
    rowEndIndex: rowEnd,
    rowEndPinned: floatingEnd
  });
}

// packages/ag-grid-community/src/gridBodyComp/rowContainer/rowContainerEventsFeature.ts
var A_KEYCODE = 65;
var C_KEYCODE = 67;
var V_KEYCODE = 86;
var D_KEYCODE = 68;
var Z_KEYCODE = 90;
var Y_KEYCODE = 89;
function _normaliseQwertyAzerty(keyboardEvent) {
  const { keyCode } = keyboardEvent;
  let code;
  switch (keyCode) {
    case A_KEYCODE:
      code = KeyCode.A;
      break;
    case C_KEYCODE:
      code = KeyCode.C;
      break;
    case V_KEYCODE:
      code = KeyCode.V;
      break;
    case D_KEYCODE:
      code = KeyCode.D;
      break;
    case Z_KEYCODE:
      code = KeyCode.Z;
      break;
    case Y_KEYCODE:
      code = KeyCode.Y;
      break;
    default:
      code = keyboardEvent.code;
  }
  return code;
}
var RowContainerEventsFeature = class extends BeanStub {
  constructor(element) {
    super();
    this.element = element;
  }
  postConstruct() {
    this.addKeyboardListeners();
    this.addMouseListeners();
    this.beans.touchSvc?.mockRowContextMenu(this);
    this.editSvc = this.beans.editSvc;
  }
  addKeyboardListeners() {
    const eventName = "keydown";
    const listener = this.processKeyboardEvent.bind(this, eventName);
    this.addManagedElementListeners(this.element, { [eventName]: listener });
  }
  addMouseListeners() {
    const mouseDownEvent = _isEventSupported("touchstart") ? "touchstart" : "mousedown";
    const eventNames = ["dblclick", "contextmenu", "mouseover", "mouseout", "click", mouseDownEvent];
    eventNames.forEach((eventName) => {
      const listener = this.processMouseEvent.bind(this, eventName);
      this.addManagedElementListeners(this.element, { [eventName]: listener });
    });
  }
  processMouseEvent(eventName, mouseEvent) {
    if (!_isEventFromThisGrid(this.gos, mouseEvent) || _isStopPropagationForAgGrid(mouseEvent)) {
      return;
    }
    const { cellCtrl, rowCtrl } = this.getControlsForEventTarget(mouseEvent.target);
    if (eventName === "contextmenu") {
      if (cellCtrl?.column) {
        cellCtrl.dispatchCellContextMenuEvent(mouseEvent);
      }
      this.beans.contextMenuSvc?.handleContextMenuMouseEvent(mouseEvent, void 0, rowCtrl, cellCtrl);
    } else {
      if (cellCtrl) {
        cellCtrl.onMouseEvent(eventName, mouseEvent);
      }
      if (rowCtrl) {
        rowCtrl.onMouseEvent(eventName, mouseEvent);
      }
    }
  }
  getControlsForEventTarget(target) {
    const { gos } = this;
    return {
      cellCtrl: _getCellCtrlForEventTarget(gos, target),
      rowCtrl: _getCtrlForEventTarget(gos, target, DOM_DATA_KEY_ROW_CTRL)
    };
  }
  processKeyboardEvent(eventName, keyboardEvent) {
    const { cellCtrl, rowCtrl } = this.getControlsForEventTarget(keyboardEvent.target);
    if (keyboardEvent.defaultPrevented) {
      return;
    }
    if (cellCtrl) {
      this.processCellKeyboardEvent(cellCtrl, eventName, keyboardEvent);
    } else if (rowCtrl?.isFullWidth()) {
      this.processFullWidthRowKeyboardEvent(rowCtrl, eventName, keyboardEvent);
    }
  }
  processCellKeyboardEvent(cellCtrl, eventName, keyboardEvent) {
    const editing = this.editSvc?.isEditing(cellCtrl, { withOpenEditor: true }) ?? false;
    const gridProcessingAllowed = !_isUserSuppressingKeyboardEvent(
      this.gos,
      keyboardEvent,
      cellCtrl.rowNode,
      cellCtrl.column,
      editing
    );
    if (gridProcessingAllowed) {
      if (eventName === "keydown") {
        const wasScrollKey = !editing && this.beans.navigation?.handlePageScrollingKey(keyboardEvent);
        if (!wasScrollKey) {
          cellCtrl.onKeyDown(keyboardEvent);
        }
        this.doGridOperations(keyboardEvent, editing);
        if (_isEventFromPrintableCharacter(keyboardEvent)) {
          cellCtrl.processCharacter(keyboardEvent);
        }
      }
    }
    if (eventName === "keydown") {
      this.eventSvc.dispatchEvent(cellCtrl.createEvent(keyboardEvent, "cellKeyDown"));
    }
  }
  processFullWidthRowKeyboardEvent(rowCtrl, eventName, keyboardEvent) {
    const { rowNode } = rowCtrl;
    const { focusSvc, navigation } = this.beans;
    const focusedCell = focusSvc.getFocusedCell();
    const column = focusedCell?.column;
    const gridProcessingAllowed = !_isUserSuppressingKeyboardEvent(this.gos, keyboardEvent, rowNode, column, false);
    if (gridProcessingAllowed) {
      const key = keyboardEvent.key;
      if (eventName === "keydown") {
        switch (key) {
          case KeyCode.PAGE_HOME:
          case KeyCode.PAGE_END:
          case KeyCode.PAGE_UP:
          case KeyCode.PAGE_DOWN:
            navigation?.handlePageScrollingKey(keyboardEvent, true);
            break;
          case KeyCode.LEFT:
          case KeyCode.RIGHT:
            if (!this.gos.get("embedFullWidthRows")) {
              break;
            }
          case KeyCode.UP:
          case KeyCode.DOWN:
            rowCtrl.onKeyboardNavigate(keyboardEvent);
            break;
          case KeyCode.TAB:
            rowCtrl.onTabKeyDown(keyboardEvent);
            break;
          default:
        }
      }
    }
    if (eventName === "keydown") {
      this.eventSvc.dispatchEvent(rowCtrl.createRowEvent("cellKeyDown", keyboardEvent));
    }
  }
  doGridOperations(keyboardEvent, editing) {
    if (!keyboardEvent.ctrlKey && !keyboardEvent.metaKey) {
      return;
    }
    if (editing) {
      return;
    }
    if (!_isEventFromThisGrid(this.gos, keyboardEvent)) {
      return;
    }
    const keyCode = _normaliseQwertyAzerty(keyboardEvent);
    const { clipboardSvc, undoRedo } = this.beans;
    if (keyCode === KeyCode.A) {
      return this.onCtrlAndA(keyboardEvent);
    }
    if (keyCode === KeyCode.C) {
      return this.onCtrlAndC(clipboardSvc, keyboardEvent);
    }
    if (keyCode === KeyCode.D) {
      return this.onCtrlAndD(clipboardSvc, keyboardEvent);
    }
    if (keyCode === KeyCode.V) {
      return this.onCtrlAndV(clipboardSvc, keyboardEvent);
    }
    if (keyCode === KeyCode.X) {
      return this.onCtrlAndX(clipboardSvc, keyboardEvent);
    }
    if (keyCode === KeyCode.Y) {
      return this.onCtrlAndY(undoRedo);
    }
    if (keyCode === KeyCode.Z) {
      return this.onCtrlAndZ(undoRedo, keyboardEvent);
    }
  }
  onCtrlAndA(event) {
    const {
      beans: { rowModel, rangeSvc, selectionSvc },
      gos
    } = this;
    if (rangeSvc && _isCellSelectionEnabled(gos) && rowModel.isRowsToRender()) {
      _selectAllCells(this.beans);
    } else if (selectionSvc) {
      selectionSvc?.selectAllRowNodes({ source: "keyboardSelectAll", selectAll: _getSelectAll(gos) });
    }
    event.preventDefault();
  }
  onCtrlAndC(clipboardSvc, event) {
    if (!clipboardSvc || this.gos.get("enableCellTextSelection")) {
      return;
    }
    const { cellCtrl } = this.getControlsForEventTarget(event.target);
    if (this.editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      return;
    }
    event.preventDefault();
    clipboardSvc.copyToClipboard();
  }
  onCtrlAndX(clipboardSvc, event) {
    if (!clipboardSvc || this.gos.get("enableCellTextSelection") || this.gos.get("suppressCutToClipboard")) {
      return;
    }
    const { cellCtrl } = this.getControlsForEventTarget(event.target);
    if (this.editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      return;
    }
    event.preventDefault();
    clipboardSvc.cutToClipboard(void 0, "ui");
  }
  onCtrlAndV(clipboardSvc, event) {
    const { cellCtrl } = this.getControlsForEventTarget(event.target);
    if (this.editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      return;
    }
    if (clipboardSvc && !this.gos.get("suppressClipboardPaste")) {
      clipboardSvc.pasteFromClipboard();
    }
  }
  onCtrlAndD(clipboardSvc, event) {
    if (clipboardSvc && !this.gos.get("suppressClipboardPaste")) {
      clipboardSvc.copyRangeDown();
    }
    event.preventDefault();
  }
  onCtrlAndZ(undoRedo, event) {
    if (!this.gos.get("undoRedoCellEditing") || !undoRedo) {
      return;
    }
    event.preventDefault();
    if (event.shiftKey) {
      undoRedo.redo("ui");
    } else {
      undoRedo.undo("ui");
    }
  }
  onCtrlAndY(undoRedo) {
    undoRedo?.redo("ui");
  }
};

// packages/ag-grid-community/src/gridBodyComp/rowContainer/setHeightFeature.ts
var SetHeightFeature = class extends BeanStub {
  constructor(eContainer, eViewport) {
    super();
    this.eContainer = eContainer;
    this.eViewport = eViewport;
  }
  postConstruct() {
    this.addManagedEventListeners({
      rowContainerHeightChanged: this.onHeightChanged.bind(this, this.beans.rowContainerHeight)
    });
  }
  onHeightChanged(maxDivHeightScaler) {
    const height = maxDivHeightScaler.uiContainerHeight;
    const heightString = height != null ? `${height}px` : ``;
    this.eContainer.style.height = heightString;
    if (this.eViewport) {
      this.eViewport.style.height = heightString;
    }
  }
};

// packages/ag-grid-community/src/gridBodyComp/rowContainer/rowContainerCtrl.ts
var getTopRowCtrls = (r) => r.topRowCtrls;
var getStickyTopRowCtrls = (r) => r.getStickyTopRowCtrls();
var getStickyBottomRowCtrls = (r) => r.getStickyBottomRowCtrls();
var getBottomRowCtrls = (r) => r.bottomRowCtrls;
var getCentreRowCtrls = (r) => r.allRowCtrls;
var getSpannedTopRowCtrls = (r) => r.getCtrls("top");
var getSpannedCenterRowCtrls = (r) => r.getCtrls("center");
var getSpannedBottomRowCtrls = (r) => r.getCtrls("bottom");
var ContainerCssClasses = {
  center: {
    type: "center",
    name: "center-cols",
    getRowCtrls: getCentreRowCtrls,
    getSpannedRowCtrls: getSpannedCenterRowCtrls
  },
  left: {
    type: "left",
    name: "pinned-left-cols",
    pinnedType: "left",
    getRowCtrls: getCentreRowCtrls,
    getSpannedRowCtrls: getSpannedCenterRowCtrls
  },
  right: {
    type: "right",
    name: "pinned-right-cols",
    pinnedType: "right",
    getRowCtrls: getCentreRowCtrls,
    getSpannedRowCtrls: getSpannedCenterRowCtrls
  },
  fullWidth: {
    type: "fullWidth",
    name: "full-width",
    fullWidth: true,
    getRowCtrls: getCentreRowCtrls
  },
  topCenter: {
    type: "center",
    name: "floating-top",
    getRowCtrls: getTopRowCtrls,
    getSpannedRowCtrls: getSpannedTopRowCtrls
  },
  topLeft: {
    type: "left",
    name: "pinned-left-floating",
    container: "ag-pinned-left-floating-top",
    pinnedType: "left",
    getRowCtrls: getTopRowCtrls,
    getSpannedRowCtrls: getSpannedTopRowCtrls
  },
  topRight: {
    type: "right",
    name: "pinned-right-floating",
    container: "ag-pinned-right-floating-top",
    pinnedType: "right",
    getRowCtrls: getTopRowCtrls,
    getSpannedRowCtrls: getSpannedTopRowCtrls
  },
  topFullWidth: {
    type: "fullWidth",
    name: "floating-top-full-width",
    fullWidth: true,
    getRowCtrls: getTopRowCtrls
  },
  stickyTopCenter: {
    type: "center",
    name: "sticky-top",
    getRowCtrls: getStickyTopRowCtrls
  },
  stickyTopLeft: {
    type: "left",
    name: "pinned-left-sticky-top",
    container: "ag-pinned-left-sticky-top",
    pinnedType: "left",
    getRowCtrls: getStickyTopRowCtrls
  },
  stickyTopRight: {
    type: "right",
    name: "pinned-right-sticky-top",
    container: "ag-pinned-right-sticky-top",
    pinnedType: "right",
    getRowCtrls: getStickyTopRowCtrls
  },
  stickyTopFullWidth: {
    type: "fullWidth",
    name: "sticky-top-full-width",
    fullWidth: true,
    getRowCtrls: getStickyTopRowCtrls
  },
  stickyBottomCenter: {
    type: "center",
    name: "sticky-bottom",
    getRowCtrls: getStickyBottomRowCtrls
  },
  stickyBottomLeft: {
    type: "left",
    name: "pinned-left-sticky-bottom",
    container: "ag-pinned-left-sticky-bottom",
    pinnedType: "left",
    getRowCtrls: getStickyBottomRowCtrls
  },
  stickyBottomRight: {
    type: "right",
    name: "pinned-right-sticky-bottom",
    container: "ag-pinned-right-sticky-bottom",
    pinnedType: "right",
    getRowCtrls: getStickyBottomRowCtrls
  },
  stickyBottomFullWidth: {
    type: "fullWidth",
    name: "sticky-bottom-full-width",
    fullWidth: true,
    getRowCtrls: getStickyBottomRowCtrls
  },
  bottomCenter: {
    type: "center",
    name: "floating-bottom",
    getRowCtrls: getBottomRowCtrls,
    getSpannedRowCtrls: getSpannedBottomRowCtrls
  },
  bottomLeft: {
    type: "left",
    name: "pinned-left-floating-bottom",
    container: "ag-pinned-left-floating-bottom",
    pinnedType: "left",
    getRowCtrls: getBottomRowCtrls,
    getSpannedRowCtrls: getSpannedBottomRowCtrls
  },
  bottomRight: {
    type: "right",
    name: "pinned-right-floating-bottom",
    container: "ag-pinned-right-floating-bottom",
    pinnedType: "right",
    getRowCtrls: getBottomRowCtrls,
    getSpannedRowCtrls: getSpannedBottomRowCtrls
  },
  bottomFullWidth: {
    type: "fullWidth",
    name: "floating-bottom-full-width",
    fullWidth: true,
    getRowCtrls: getBottomRowCtrls
  }
};
function _getRowViewportClass(name) {
  const options = _getRowContainerOptions(name);
  return `ag-${options.name}-viewport`;
}
function _getRowContainerClass(name) {
  const options = _getRowContainerOptions(name);
  return options.container ?? `ag-${options.name}-container`;
}
function _getRowSpanContainerClass(name) {
  const options = _getRowContainerOptions(name);
  return `ag-${options.name}-spanned-cells-container`;
}
function _getRowContainerOptions(name) {
  return ContainerCssClasses[name];
}
var allTopNoFW = ["topCenter", "topLeft", "topRight"];
var allBottomNoFW = ["bottomCenter", "bottomLeft", "bottomRight"];
var allMiddleNoFW = ["center", "left", "right"];
var allMiddle = ["center", "left", "right", "fullWidth"];
var allCenter = ["stickyTopCenter", "stickyBottomCenter", "center", "topCenter", "bottomCenter"];
var allLeft = ["left", "bottomLeft", "topLeft", "stickyTopLeft", "stickyBottomLeft"];
var allRight = ["right", "bottomRight", "topRight", "stickyTopRight", "stickyBottomRight"];
var allStickyTopNoFW = ["stickyTopCenter", "stickyTopLeft", "stickyTopRight"];
var allStickyBottomNoFW = ["stickyBottomCenter", "stickyBottomLeft", "stickyBottomRight"];
var allStickyContainers = [
  ...allStickyTopNoFW,
  "stickyTopFullWidth",
  ...allStickyBottomNoFW,
  "stickyBottomFullWidth"
];
var allNoFW = [
  ...allTopNoFW,
  ...allBottomNoFW,
  ...allMiddleNoFW,
  ...allStickyTopNoFW,
  ...allStickyBottomNoFW
];
var RowContainerCtrl = class extends BeanStub {
  constructor(name) {
    super();
    this.name = name;
    this.visible = true;
    // Maintaining a constant reference enables optimization in React.
    this.EMPTY_CTRLS = [];
    this.options = _getRowContainerOptions(name);
  }
  postConstruct() {
    this.enableRtl = this.gos.get("enableRtl");
    this.forContainers(["center"], () => {
      this.viewportSizeFeature = this.createManagedBean(new ViewportSizeFeature(this));
      this.addManagedEventListeners({
        stickyTopOffsetChanged: this.onStickyTopOffsetChanged.bind(this)
      });
    });
  }
  onStickyTopOffsetChanged(event) {
    this.comp.setOffsetTop(`${event.offset}px`);
  }
  registerWithCtrlsService() {
    if (this.options.fullWidth)
      return;
    this.beans.ctrlsSvc.register(this.name, this);
  }
  forContainers(names, callback) {
    if (names.indexOf(this.name) >= 0) {
      callback();
    }
  }
  setComp(view, eContainer, eSpannedContainer, eViewport) {
    this.comp = view;
    this.eContainer = eContainer;
    this.eSpannedContainer = eSpannedContainer;
    this.eViewport = eViewport;
    this.createManagedBean(new RowContainerEventsFeature(this.eViewport ?? this.eContainer));
    this.addPreventScrollWhileDragging();
    this.listenOnDomOrder();
    const { pinnedCols, rangeSvc } = this.beans;
    const pinnedWidthChanged = () => this.onPinnedWidthChanged();
    this.forContainers(allLeft, () => {
      this.pinnedWidthFeature = this.createOptionalManagedBean(
        pinnedCols?.createPinnedWidthFeature(true, this.eContainer, this.eSpannedContainer)
      );
      this.addManagedEventListeners({ leftPinnedWidthChanged: pinnedWidthChanged });
    });
    this.forContainers(allRight, () => {
      this.pinnedWidthFeature = this.createOptionalManagedBean(
        pinnedCols?.createPinnedWidthFeature(false, this.eContainer, this.eSpannedContainer)
      );
      this.addManagedEventListeners({ rightPinnedWidthChanged: pinnedWidthChanged });
    });
    this.forContainers(
      allMiddle,
      () => this.createManagedBean(
        new SetHeightFeature(this.eContainer, this.name === "center" ? eViewport : void 0)
      )
    );
    if (rangeSvc) {
      this.forContainers(
        allNoFW,
        () => this.createManagedBean(rangeSvc.createDragListenerFeature(this.eContainer))
      );
    }
    this.forContainers(
      allCenter,
      () => this.createManagedBean(new CenterWidthFeature((width) => this.comp.setContainerWidth(`${width}px`)))
    );
    this.visible = this.isContainerVisible();
    this.addListeners();
    this.registerWithCtrlsService();
  }
  onScrollCallback(fn) {
    this.addManagedElementListeners(this.eViewport, { scroll: fn });
  }
  addListeners() {
    const { spannedRowRenderer, gos } = this.beans;
    const onDisplayedColumnsChanged = this.onDisplayedColumnsChanged.bind(this);
    this.addManagedEventListeners({
      displayedColumnsChanged: onDisplayedColumnsChanged,
      displayedColumnsWidthChanged: onDisplayedColumnsChanged,
      displayedRowsChanged: (params) => this.onDisplayedRowsChanged(params.afterScroll)
    });
    onDisplayedColumnsChanged();
    this.onDisplayedRowsChanged();
    if (spannedRowRenderer && this.options.getSpannedRowCtrls && gos.get("enableCellSpan")) {
      this.addManagedListeners(spannedRowRenderer, {
        spannedRowsUpdated: () => {
          const spannedCtrls = this.options.getSpannedRowCtrls(spannedRowRenderer);
          if (!spannedCtrls) {
            return;
          }
          this.comp.setSpannedRowCtrls(spannedCtrls, false);
        }
      });
    }
  }
  listenOnDomOrder() {
    const isStickContainer = allStickyContainers.indexOf(this.name) >= 0;
    if (isStickContainer) {
      this.comp.setDomOrder(true);
      return;
    }
    const listener = () => {
      const isEnsureDomOrder = this.gos.get("ensureDomOrder");
      const isPrintLayout = _isDomLayout(this.gos, "print");
      this.comp.setDomOrder(isEnsureDomOrder || isPrintLayout);
    };
    this.addManagedPropertyListener("domLayout", listener);
    listener();
  }
  onDisplayedColumnsChanged() {
    this.forContainers(["center"], () => this.onHorizontalViewportChanged());
  }
  // this methods prevents the grid views from being scrolled while the dragService is being used
  // eg. the view should not scroll up and down while dragging rows using the rowDragComp.
  addPreventScrollWhileDragging() {
    const { dragSvc } = this.beans;
    if (!dragSvc) {
      return;
    }
    const preventScroll = (e) => {
      if (dragSvc.dragging) {
        if (e.cancelable) {
          e.preventDefault();
        }
      }
    };
    this.eContainer.addEventListener("touchmove", preventScroll, { passive: false });
    this.addDestroyFunc(() => this.eContainer.removeEventListener("touchmove", preventScroll));
  }
  // this gets called whenever a change in the viewport, so we can inform column controller it has to work
  // out the virtual columns again. gets called from following locations:
  // + ensureColVisible, scroll, init, layoutChanged, displayedColumnsChanged
  onHorizontalViewportChanged(afterScroll = false) {
    const scrollWidth = this.getCenterWidth();
    const scrollPosition = this.getCenterViewportScrollLeft();
    this.beans.colViewport.setScrollPosition(scrollWidth, scrollPosition, afterScroll);
  }
  hasHorizontalScrollGap() {
    return this.eContainer.clientWidth - this.eViewport.clientWidth < 0;
  }
  hasVerticalScrollGap() {
    return this.eContainer.clientHeight - this.eViewport.clientHeight < 0;
  }
  getCenterWidth() {
    return _getInnerWidth(this.eViewport);
  }
  getCenterViewportScrollLeft() {
    return _getScrollLeft(this.eViewport, this.enableRtl);
  }
  registerViewportResizeListener(listener) {
    const unsubscribeFromResize = _observeResize(this.beans, this.eViewport, listener);
    this.addDestroyFunc(() => unsubscribeFromResize());
  }
  isViewportInTheDOMTree() {
    return _isInDOM(this.eViewport);
  }
  getViewportScrollLeft() {
    return _getScrollLeft(this.eViewport, this.enableRtl);
  }
  isHorizontalScrollShowing() {
    const isAlwaysShowHorizontalScroll = this.gos.get("alwaysShowHorizontalScroll");
    return isAlwaysShowHorizontalScroll || _isHorizontalScrollShowing(this.eViewport);
  }
  setHorizontalScroll(offset) {
    this.comp.setHorizontalScroll(offset);
  }
  getHScrollPosition() {
    const res = {
      left: this.eViewport.scrollLeft,
      right: this.eViewport.scrollLeft + this.eViewport.offsetWidth
    };
    return res;
  }
  setCenterViewportScrollLeft(value) {
    _setScrollLeft(this.eViewport, value, this.enableRtl);
  }
  isContainerVisible() {
    const pinned = this.options.pinnedType != null;
    return !pinned || !!this.pinnedWidthFeature && this.pinnedWidthFeature.getWidth() > 0;
  }
  onPinnedWidthChanged() {
    const visible = this.isContainerVisible();
    if (this.visible != visible) {
      this.visible = visible;
      this.onDisplayedRowsChanged();
    }
  }
  onDisplayedRowsChanged(afterScroll = false) {
    const rows = this.options.getRowCtrls(this.beans.rowRenderer);
    if (!this.visible || rows.length === 0) {
      this.comp.setRowCtrls({ rowCtrls: this.EMPTY_CTRLS });
      return;
    }
    const printLayout = _isDomLayout(this.gos, "print");
    const embedFullWidthRows = this.gos.get("embedFullWidthRows");
    const embedFW = embedFullWidthRows || printLayout;
    const rowsThisContainer = rows.filter((rowCtrl) => {
      const fullWidthRow = rowCtrl.isFullWidth();
      const match = this.options.fullWidth ? !embedFW && fullWidthRow : embedFW || !fullWidthRow;
      return match;
    });
    this.comp.setRowCtrls({ rowCtrls: rowsThisContainer, useFlushSync: afterScroll });
  }
};

// packages/ag-grid-community/src/gridBodyComp/gridBodyCtrl.ts
var CSS_CLASS_FORCE_VERTICAL_SCROLL = "ag-force-vertical-scroll";
var CSS_CLASS_CELL_SELECTABLE = "ag-selectable";
var CSS_CLASS_COLUMN_MOVING = "ag-column-moving";
var GridBodyCtrl = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.stickyTopHeight = 0;
    this.stickyBottomHeight = 0;
  }
  wireBeans(beans) {
    this.ctrlsSvc = beans.ctrlsSvc;
    this.colModel = beans.colModel;
    this.scrollVisibleSvc = beans.scrollVisibleSvc;
    this.pinnedRowModel = beans.pinnedRowModel;
    this.filterManager = beans.filterManager;
    this.rowGroupColsSvc = beans.rowGroupColsSvc;
  }
  setComp(comp, eGridBody, eBodyViewport, eTop, eBottom, eStickyTop, eStickyBottom) {
    this.comp = comp;
    this.eGridBody = eGridBody;
    this.eBodyViewport = eBodyViewport;
    this.eTop = eTop;
    this.eBottom = eBottom;
    this.eStickyTop = eStickyTop;
    this.eStickyBottom = eStickyBottom;
    this.eCenterColsViewport = eBodyViewport.querySelector(`.${_getRowViewportClass("center")}`);
    this.eFullWidthContainer = eBodyViewport.querySelector(`.${_getRowContainerClass("fullWidth")}`);
    this.eStickyTopFullWidthContainer = eStickyTop.querySelector(
      `.${_getRowContainerClass("stickyTopFullWidth")}`
    );
    this.eStickyBottomFullWidthContainer = eStickyBottom.querySelector(
      `.${_getRowContainerClass("stickyBottomFullWidth")}`
    );
    this.setCellTextSelection(this.gos.get("enableCellTextSelection"));
    this.addManagedPropertyListener(
      "enableCellTextSelection",
      (props) => this.setCellTextSelection(props.currentValue)
    );
    this.createManagedBean(new LayoutFeature(this.comp));
    this.scrollFeature = this.createManagedBean(new GridBodyScrollFeature(eBodyViewport));
    this.beans.rowDragSvc?.setupRowDrag(eBodyViewport, this);
    this.setupRowAnimationCssClass();
    this.addEventListeners();
    this.addFocusListeners([eTop, eBodyViewport, eBottom, eStickyTop, eStickyBottom]);
    this.setGridRootRole();
    this.onGridColumnsChanged();
    this.addBodyViewportListener();
    this.setFloatingHeights();
    this.disableBrowserDragging();
    this.addStopEditingWhenGridLosesFocus();
    this.updateScrollingClasses();
    this.filterManager?.setupAdvFilterHeaderComp(eTop);
    this.ctrlsSvc.register("gridBodyCtrl", this);
  }
  addEventListeners() {
    const setFloatingHeights = this.setFloatingHeights.bind(this);
    const setGridRootRole = this.setGridRootRole.bind(this);
    const toggleRowResizeStyle = this.toggleRowResizeStyles.bind(this);
    this.addManagedEventListeners({
      gridColumnsChanged: this.onGridColumnsChanged.bind(this),
      scrollVisibilityChanged: this.onScrollVisibilityChanged.bind(this),
      scrollGapChanged: this.updateScrollingClasses.bind(this),
      pinnedRowDataChanged: setFloatingHeights,
      pinnedHeightChanged: setFloatingHeights,
      pinnedRowsChanged: setFloatingHeights,
      headerHeightChanged: this.setStickyTopOffsetTop.bind(this),
      columnRowGroupChanged: setGridRootRole,
      columnPivotChanged: setGridRootRole,
      rowResizeStarted: toggleRowResizeStyle,
      rowResizeEnded: toggleRowResizeStyle
    });
    this.addManagedPropertyListener("treeData", setGridRootRole);
  }
  toggleRowResizeStyles(params) {
    const isResizingRow = params.type === "rowResizeStarted";
    this.eBodyViewport.classList.toggle("ag-prevent-animation", isResizingRow);
  }
  onGridColumnsChanged() {
    const columns = this.beans.colModel.getCols();
    this.comp.setColumnCount(columns.length);
  }
  onScrollVisibilityChanged() {
    const { scrollVisibleSvc } = this;
    const visible = scrollVisibleSvc.verticalScrollShowing;
    this.setVerticalScrollPaddingVisible(visible);
    this.setStickyWidth(visible);
    this.setStickyBottomOffsetBottom();
    const scrollbarWidth = visible ? scrollVisibleSvc.getScrollbarWidth() || 0 : 0;
    const pad = _isInvisibleScrollbar() ? 16 : 0;
    const width = `calc(100% + ${scrollbarWidth + pad}px)`;
    _requestAnimationFrame(this.beans, () => this.comp.setBodyViewportWidth(width));
    this.updateScrollingClasses();
  }
  setGridRootRole() {
    const { rowGroupColsSvc, colModel } = this;
    let isTreeGrid = this.gos.get("treeData");
    if (!isTreeGrid) {
      const isPivotActive = colModel.isPivotMode();
      const rowGroupColumnLen = !rowGroupColsSvc ? 0 : rowGroupColsSvc.columns.length;
      const columnsNeededForGrouping = isPivotActive ? 2 : 1;
      isTreeGrid = rowGroupColumnLen >= columnsNeededForGrouping;
    }
    this.comp.setGridRootRole(isTreeGrid ? "treegrid" : "grid");
  }
  addFocusListeners(elements) {
    elements.forEach((element) => {
      this.addManagedElementListeners(element, {
        focusin: (e) => {
          const { target } = e;
          const isFocusedElementNested = _isElementChildOfClass(target, "ag-root", element);
          element.classList.toggle("ag-has-focus", !isFocusedElementNested);
        },
        focusout: (e) => {
          const { target, relatedTarget } = e;
          const gridContainRelatedTarget = element.contains(relatedTarget);
          const isNestedRelatedTarget = _isElementChildOfClass(
            relatedTarget,
            "ag-root",
            element
          );
          const isNestedTarget = _isElementChildOfClass(target, "ag-root", element);
          if (isNestedTarget) {
            return;
          }
          if (!gridContainRelatedTarget || isNestedRelatedTarget) {
            element.classList.remove("ag-has-focus");
          }
        }
      });
    });
  }
  // used by ColumnAnimationService
  setColumnMovingCss(moving) {
    this.comp.setColumnMovingCss(CSS_CLASS_COLUMN_MOVING, moving);
  }
  setCellTextSelection(selectable = false) {
    this.comp.setCellSelectableCss(CSS_CLASS_CELL_SELECTABLE, selectable);
  }
  updateScrollingClasses() {
    const {
      eGridBody: { classList },
      scrollVisibleSvc
    } = this;
    classList.toggle("ag-body-vertical-content-no-gap", !scrollVisibleSvc.verticalScrollGap);
    classList.toggle("ag-body-horizontal-content-no-gap", !scrollVisibleSvc.horizontalScrollGap);
  }
  // if we do not do this, then the user can select a pic in the grid (eg an image in a custom cell renderer)
  // and then that will start the browser native drag n' drop, which messes up with our own drag and drop.
  disableBrowserDragging() {
    this.addManagedElementListeners(this.eGridBody, {
      dragstart: (event) => {
        if (event.target instanceof HTMLImageElement) {
          event.preventDefault();
          return false;
        }
      }
    });
  }
  addStopEditingWhenGridLosesFocus() {
    this.beans.editSvc?.addStopEditingWhenGridLosesFocus([
      this.eBodyViewport,
      this.eBottom,
      this.eTop,
      this.eStickyTop,
      this.eStickyBottom
    ]);
  }
  updateRowCount() {
    const headerCount = (this.ctrlsSvc.getHeaderRowContainerCtrl()?.getRowCount() ?? 0) + (this.filterManager?.getHeaderRowCount() ?? 0);
    const { rowModel } = this.beans;
    const rowCount = rowModel.isLastRowIndexKnown() ? rowModel.getRowCount() : -1;
    const total = rowCount === -1 ? -1 : headerCount + rowCount;
    this.comp.setRowCount(total);
  }
  registerBodyViewportResizeListener(listener) {
    this.comp.registerBodyViewportResizeListener(listener);
  }
  setVerticalScrollPaddingVisible(visible) {
    const overflowY = visible ? "scroll" : "hidden";
    this.comp.setPinnedTopBottomOverflowY(overflowY);
  }
  isVerticalScrollShowing() {
    const show = this.gos.get("alwaysShowVerticalScroll");
    const cssClass = show ? CSS_CLASS_FORCE_VERTICAL_SCROLL : null;
    const allowVerticalScroll = _isDomLayout(this.gos, "normal");
    this.comp.setAlwaysVerticalScrollClass(cssClass, show);
    return show || allowVerticalScroll && _isVerticalScrollShowing(this.eBodyViewport);
  }
  setupRowAnimationCssClass() {
    const { rowContainerHeight, environment } = this.beans;
    let initialSizeMeasurementComplete = environment.sizesMeasured;
    const updateAnimationClass = () => {
      const animateRows = initialSizeMeasurementComplete && _isAnimateRows(this.gos) && !rowContainerHeight.stretching;
      const animateRowsCssClass = animateRows ? "ag-row-animation" : "ag-row-no-animation";
      this.comp.setRowAnimationCssOnBodyViewport(animateRowsCssClass, animateRows);
    };
    updateAnimationClass();
    this.addManagedEventListeners({ heightScaleChanged: updateAnimationClass });
    this.addManagedPropertyListener("animateRows", updateAnimationClass);
    this.addManagedEventListeners({
      gridStylesChanged: () => {
        if (!initialSizeMeasurementComplete && environment.sizesMeasured) {
          initialSizeMeasurementComplete = true;
          updateAnimationClass();
        }
      }
    });
  }
  addBodyViewportListener() {
    const {
      eBodyViewport,
      eStickyTop,
      eStickyBottom,
      eTop,
      eBottom,
      beans: { popupSvc, touchSvc }
    } = this;
    const listener = this.onBodyViewportContextMenu.bind(this);
    this.addManagedElementListeners(eBodyViewport, { contextmenu: listener });
    touchSvc?.mockBodyContextMenu(this, listener);
    this.addManagedElementListeners(eBodyViewport, {
      wheel: this.onBodyViewportWheel.bind(this, popupSvc)
    });
    const onStickyWheel = this.onStickyWheel.bind(this);
    for (const container of [eStickyTop, eStickyBottom, eTop, eBottom]) {
      this.addManagedElementListeners(container, { wheel: onStickyWheel });
    }
    const onHorizontalWheel = this.onHorizontalWheel.bind(this);
    for (const container of ["left", "right", "topLeft", "topRight", "bottomLeft", "bottomRight"]) {
      this.addManagedElementListeners(this.ctrlsSvc.get(container).eContainer, {
        wheel: onHorizontalWheel
      });
    }
    this.addFullWidthContainerWheelListener();
  }
  addFullWidthContainerWheelListener() {
    this.addManagedElementListeners(this.eFullWidthContainer, {
      wheel: (e) => this.onFullWidthContainerWheel(e)
    });
  }
  onFullWidthContainerWheel(e) {
    const { deltaX, deltaY, shiftKey } = e;
    const isHorizontalScroll = shiftKey || Math.abs(deltaX) > Math.abs(deltaY);
    if (isHorizontalScroll && _isEventFromThisGrid(this.gos, e)) {
      this.scrollGridBodyToMatchEvent(e);
    }
  }
  onStickyWheel(e) {
    const { deltaY } = e;
    const scrolled = this.scrollVertically(deltaY);
    if (scrolled > 0) {
      e.preventDefault();
    }
  }
  onHorizontalWheel(e) {
    const { deltaX, deltaY, shiftKey } = e;
    const isHorizontalScroll = shiftKey || Math.abs(deltaX) > Math.abs(deltaY);
    if (!isHorizontalScroll) {
      return;
    }
    this.scrollGridBodyToMatchEvent(e);
  }
  scrollGridBodyToMatchEvent(e) {
    const { deltaX, deltaY } = e;
    e.preventDefault();
    this.eCenterColsViewport.scrollBy({ left: deltaX || deltaY });
  }
  onBodyViewportContextMenu(mouseEvent, touch, touchEvent) {
    if (!mouseEvent && !touchEvent) {
      return;
    }
    if (this.gos.get("preventDefaultOnContextMenu")) {
      const event = mouseEvent || touchEvent;
      event.preventDefault();
    }
    const { target } = mouseEvent || touch;
    if (target === this.eBodyViewport || target === this.ctrlsSvc.get("center").eViewport) {
      this.beans.contextMenuSvc?.showContextMenu({
        mouseEvent,
        touchEvent,
        value: null,
        anchorToElement: this.eGridBody,
        source: "ui"
      });
    }
  }
  onBodyViewportWheel(popupSvc, e) {
    if (!this.gos.get("suppressScrollWhenPopupsAreOpen")) {
      return;
    }
    if (popupSvc?.hasAnchoredPopup()) {
      e.preventDefault();
    }
  }
  // called by rowDragFeature
  scrollVertically(pixels) {
    const oldScrollPosition = this.eBodyViewport.scrollTop;
    this.scrollFeature.setVerticalScrollPosition(oldScrollPosition + pixels);
    return this.eBodyViewport.scrollTop - oldScrollPosition;
  }
  setFloatingHeights() {
    const {
      pinnedRowModel,
      beans: { environment }
    } = this;
    const floatingTopHeight = pinnedRowModel?.getPinnedTopTotalHeight();
    const floatingBottomHeight = pinnedRowModel?.getPinnedBottomTotalHeight();
    const pinnedBorderWidth = environment.getPinnedRowBorderWidth();
    const rowBorderWidth = environment.getRowBorderWidth();
    const additionalHeight = pinnedBorderWidth - rowBorderWidth;
    const normalisedFloatingTopHeight = !floatingTopHeight ? 0 : additionalHeight + floatingTopHeight;
    const normalisedFloatingBottomHeight = !floatingBottomHeight ? 0 : additionalHeight + floatingBottomHeight;
    this.comp.setTopHeight(normalisedFloatingTopHeight);
    this.comp.setBottomHeight(normalisedFloatingBottomHeight);
    this.comp.setTopInvisible(normalisedFloatingTopHeight <= 0);
    this.comp.setBottomInvisible(normalisedFloatingBottomHeight <= 0);
    this.setStickyTopOffsetTop();
    this.setStickyBottomOffsetBottom();
  }
  setStickyTopHeight(height = 0) {
    this.comp.setStickyTopHeight(`${height}px`);
    this.stickyTopHeight = height;
  }
  setStickyBottomHeight(height = 0) {
    this.comp.setStickyBottomHeight(`${height}px`);
    this.stickyBottomHeight = height;
  }
  setStickyWidth(vScrollVisible) {
    if (!vScrollVisible) {
      this.comp.setStickyTopWidth("100%");
      this.comp.setStickyBottomWidth("100%");
    } else {
      const scrollbarWidth = this.scrollVisibleSvc.getScrollbarWidth();
      this.comp.setStickyTopWidth(`calc(100% - ${scrollbarWidth}px)`);
      this.comp.setStickyBottomWidth(`calc(100% - ${scrollbarWidth}px)`);
    }
  }
  setStickyTopOffsetTop() {
    const headerCtrl = this.ctrlsSvc.get("gridHeaderCtrl");
    const headerHeight = headerCtrl.headerHeight + (this.filterManager?.getHeaderHeight() ?? 0);
    const pinnedTopHeight = this.pinnedRowModel?.getPinnedTopTotalHeight() ?? 0;
    let height = 0;
    if (headerHeight > 0) {
      height += headerHeight;
    }
    if (pinnedTopHeight > 0) {
      height += pinnedTopHeight;
    }
    if (height > 0) {
      height += 1;
    }
    this.comp.setStickyTopTop(`${height}px`);
  }
  setStickyBottomOffsetBottom() {
    const { pinnedRowModel, scrollVisibleSvc, comp } = this;
    const pinnedBottomHeight = pinnedRowModel?.getPinnedBottomTotalHeight() ?? 0;
    const hScrollShowing = scrollVisibleSvc.horizontalScrollShowing;
    const scrollbarWidth = hScrollShowing ? scrollVisibleSvc.getScrollbarWidth() || 0 : 0;
    const height = pinnedBottomHeight + scrollbarWidth;
    comp.setStickyBottomBottom(`${height}px`);
  }
};

// packages/ag-grid-community/src/gridBodyComp/abstractFakeScrollComp.ts
var AbstractFakeScrollComp = class extends Component {
  constructor(template, direction) {
    super();
    this.direction = direction;
    this.eViewport = RefPlaceholder;
    this.eContainer = RefPlaceholder;
    this.hideTimeout = 0;
    this.setTemplate(template);
  }
  postConstruct() {
    this.addManagedEventListeners({
      scrollVisibilityChanged: this.onScrollVisibilityChanged.bind(this)
    });
    this.onScrollVisibilityChanged();
    this.toggleCss("ag-apple-scrollbar", _isMacOsUserAgent() || _isIOSUserAgent());
  }
  destroy() {
    super.destroy();
    window.clearTimeout(this.hideTimeout);
  }
  initialiseInvisibleScrollbar() {
    if (this.invisibleScrollbar !== void 0) {
      return;
    }
    this.invisibleScrollbar = _isInvisibleScrollbar();
    if (this.invisibleScrollbar) {
      this.hideAndShowInvisibleScrollAsNeeded();
      this.addActiveListenerToggles();
    }
  }
  addActiveListenerToggles() {
    const eGui = this.getGui();
    const onActivate = () => this.toggleCss("ag-scrollbar-active", true);
    const onDeactivate = () => this.toggleCss("ag-scrollbar-active", false);
    this.addManagedListeners(eGui, {
      mouseenter: onActivate,
      mousedown: onActivate,
      touchstart: onActivate,
      mouseleave: onDeactivate,
      touchend: onDeactivate
    });
  }
  onScrollVisibilityChanged() {
    if (this.invisibleScrollbar === void 0) {
      this.initialiseInvisibleScrollbar();
    }
    _requestAnimationFrame(this.beans, () => this.setScrollVisible());
  }
  hideAndShowInvisibleScrollAsNeeded() {
    this.addManagedEventListeners({
      bodyScroll: (params) => {
        if (params.direction === this.direction) {
          if (this.hideTimeout) {
            window.clearTimeout(this.hideTimeout);
            this.hideTimeout = 0;
          }
          this.toggleCss("ag-scrollbar-scrolling", true);
        }
      },
      bodyScrollEnd: () => {
        this.hideTimeout = window.setTimeout(() => {
          this.toggleCss("ag-scrollbar-scrolling", false);
          this.hideTimeout = 0;
        }, 400);
      }
    });
  }
  attemptSettingScrollPosition(value) {
    const viewport = this.eViewport;
    _waitUntil(
      () => _isVisible(viewport),
      () => this.setScrollPosition(value),
      100
    );
  }
  onScrollCallback(fn) {
    this.addManagedElementListeners(this.eViewport, { scroll: fn });
  }
};

// packages/ag-grid-community/src/gridBodyComp/fakeHScrollComp.ts
var FakeHScrollElement = {
  tag: "div",
  cls: "ag-body-horizontal-scroll",
  attrs: { "aria-hidden": "true" },
  children: [
    { tag: "div", ref: "eLeftSpacer", cls: "ag-horizontal-left-spacer" },
    {
      tag: "div",
      ref: "eViewport",
      cls: "ag-body-horizontal-scroll-viewport",
      children: [{ tag: "div", ref: "eContainer", cls: "ag-body-horizontal-scroll-container" }]
    },
    { tag: "div", ref: "eRightSpacer", cls: "ag-horizontal-right-spacer" }
  ]
};
var FakeHScrollComp = class extends AbstractFakeScrollComp {
  constructor() {
    super(FakeHScrollElement, "horizontal");
    this.eLeftSpacer = RefPlaceholder;
    this.eRightSpacer = RefPlaceholder;
    this.setScrollVisibleDebounce = 0;
  }
  wireBeans(beans) {
    this.visibleCols = beans.visibleCols;
    this.scrollVisibleSvc = beans.scrollVisibleSvc;
  }
  postConstruct() {
    super.postConstruct();
    const spacerWidthsListener = this.setFakeHScrollSpacerWidths.bind(this);
    this.addManagedEventListeners({
      displayedColumnsChanged: spacerWidthsListener,
      displayedColumnsWidthChanged: spacerWidthsListener,
      pinnedRowDataChanged: this.refreshCompBottom.bind(this)
    });
    this.addManagedPropertyListener("domLayout", spacerWidthsListener);
    this.beans.ctrlsSvc.register("fakeHScrollComp", this);
    this.createManagedBean(new CenterWidthFeature((width) => this.eContainer.style.width = `${width}px`));
    this.addManagedPropertyListeners(["suppressHorizontalScroll"], this.onScrollVisibilityChanged.bind(this));
  }
  destroy() {
    window.clearTimeout(this.setScrollVisibleDebounce);
    super.destroy();
  }
  initialiseInvisibleScrollbar() {
    if (this.invisibleScrollbar !== void 0) {
      return;
    }
    this.enableRtl = this.gos.get("enableRtl");
    super.initialiseInvisibleScrollbar();
    if (this.invisibleScrollbar) {
      this.refreshCompBottom();
    }
  }
  refreshCompBottom() {
    if (!this.invisibleScrollbar) {
      return;
    }
    const bottomPinnedHeight = this.beans.pinnedRowModel?.getPinnedBottomTotalHeight() ?? 0;
    this.getGui().style.bottom = `${bottomPinnedHeight}px`;
  }
  onScrollVisibilityChanged() {
    super.onScrollVisibilityChanged();
    this.setFakeHScrollSpacerWidths();
  }
  setFakeHScrollSpacerWidths() {
    const vScrollShowing = this.scrollVisibleSvc.verticalScrollShowing;
    let rightSpacing = this.visibleCols.getDisplayedColumnsRightWidth();
    const scrollOnRight = !this.enableRtl && vScrollShowing;
    const scrollbarWidth = this.scrollVisibleSvc.getScrollbarWidth();
    if (scrollOnRight) {
      rightSpacing += scrollbarWidth;
    }
    _setFixedWidth(this.eRightSpacer, rightSpacing);
    this.eRightSpacer.classList.toggle("ag-scroller-corner", rightSpacing <= scrollbarWidth);
    let leftSpacing = this.visibleCols.getColsLeftWidth();
    const scrollOnLeft = this.enableRtl && vScrollShowing;
    if (scrollOnLeft) {
      leftSpacing += scrollbarWidth;
    }
    _setFixedWidth(this.eLeftSpacer, leftSpacing);
    this.eLeftSpacer.classList.toggle("ag-scroller-corner", leftSpacing <= scrollbarWidth);
  }
  setScrollVisible() {
    const hScrollShowing = this.scrollVisibleSvc.horizontalScrollShowing;
    const invisibleScrollbar2 = this.invisibleScrollbar;
    const isSuppressHorizontalScroll = this.gos.get("suppressHorizontalScroll");
    const scrollbarWidth = hScrollShowing ? this.scrollVisibleSvc.getScrollbarWidth() || 0 : 0;
    const adjustedScrollbarWidth = scrollbarWidth === 0 && invisibleScrollbar2 ? 16 : scrollbarWidth;
    const scrollContainerSize = !isSuppressHorizontalScroll ? adjustedScrollbarWidth : 0;
    const apply = () => {
      this.setScrollVisibleDebounce = 0;
      this.toggleCss("ag-scrollbar-invisible", invisibleScrollbar2);
      _setFixedHeight(this.getGui(), scrollContainerSize);
      _setFixedHeight(this.eViewport, scrollContainerSize);
      _setFixedHeight(this.eContainer, scrollContainerSize);
      if (!scrollContainerSize) {
        this.eContainer.style.setProperty("min-height", "1px");
      }
      this.setVisible(hScrollShowing, { skipAriaHidden: true });
    };
    window.clearTimeout(this.setScrollVisibleDebounce);
    if (!hScrollShowing) {
      apply();
    } else {
      this.setScrollVisibleDebounce = window.setTimeout(apply, 100);
    }
  }
  getScrollPosition() {
    return _getScrollLeft(this.eViewport, this.enableRtl);
  }
  setScrollPosition(value) {
    if (!_isVisible(this.eViewport)) {
      this.attemptSettingScrollPosition(value);
    }
    _setScrollLeft(this.eViewport, value, this.enableRtl);
  }
};
var FakeHScrollSelector = {
  selector: "AG-FAKE-HORIZONTAL-SCROLL",
  component: FakeHScrollComp
};

// packages/ag-grid-community/src/gridBodyComp/fakeVScrollComp.ts
var FakeVScrollElement = {
  tag: "div",
  cls: "ag-body-vertical-scroll",
  attrs: { "aria-hidden": "true" },
  children: [
    {
      tag: "div",
      ref: "eViewport",
      cls: "ag-body-vertical-scroll-viewport",
      children: [{ tag: "div", ref: "eContainer", cls: "ag-body-vertical-scroll-container" }]
    }
  ]
};
var FakeVScrollComp = class extends AbstractFakeScrollComp {
  constructor() {
    super(FakeVScrollElement, "vertical");
  }
  postConstruct() {
    super.postConstruct();
    this.createManagedBean(new SetHeightFeature(this.eContainer));
    const { ctrlsSvc } = this.beans;
    ctrlsSvc.register("fakeVScrollComp", this);
    this.addManagedEventListeners({
      rowContainerHeightChanged: this.onRowContainerHeightChanged.bind(this, ctrlsSvc)
    });
  }
  setScrollVisible() {
    const { scrollVisibleSvc } = this.beans;
    const vScrollShowing = scrollVisibleSvc.verticalScrollShowing;
    const invisibleScrollbar2 = this.invisibleScrollbar;
    const scrollbarWidth = vScrollShowing ? scrollVisibleSvc.getScrollbarWidth() || 0 : 0;
    const adjustedScrollbarWidth = scrollbarWidth === 0 && invisibleScrollbar2 ? 16 : scrollbarWidth;
    this.toggleCss("ag-scrollbar-invisible", invisibleScrollbar2);
    _setFixedWidth(this.getGui(), adjustedScrollbarWidth);
    _setFixedWidth(this.eViewport, adjustedScrollbarWidth);
    _setFixedWidth(this.eContainer, adjustedScrollbarWidth);
    this.setDisplayed(vScrollShowing, { skipAriaHidden: true });
  }
  onRowContainerHeightChanged(ctrlsSvc) {
    const gridBodyCtrl = ctrlsSvc.getGridBodyCtrl();
    const gridBodyViewportEl = gridBodyCtrl.eBodyViewport;
    const eViewportScrollTop = this.getScrollPosition();
    const gridBodyViewportScrollTop = gridBodyViewportEl.scrollTop;
    if (eViewportScrollTop != gridBodyViewportScrollTop) {
      this.setScrollPosition(gridBodyViewportScrollTop, true);
    }
  }
  getScrollPosition() {
    return this.eViewport.scrollTop;
  }
  setScrollPosition(value, force) {
    if (!force && !_isVisible(this.eViewport)) {
      this.attemptSettingScrollPosition(value);
    }
    this.eViewport.scrollTop = value;
  }
};
var FakeVScrollSelector = {
  selector: "AG-FAKE-VERTICAL-SCROLL",
  component: FakeVScrollComp
};

// packages/ag-grid-community/src/headerRendering/headerUtils.ts
function getHeaderRowCount(colModel) {
  if (!colModel.cols) {
    return -1;
  }
  return colModel.cols.treeDepth + 1;
}
function getFocusHeaderRowCount(beans) {
  return beans.ctrlsSvc.getHeaderRowContainerCtrl()?.getRowCount() ?? 0;
}
function getGroupRowsHeight(beans) {
  const heights = [];
  const headerRowContainerCtrls = beans.ctrlsSvc.getHeaderRowContainerCtrls();
  for (const headerRowContainerCtrl of headerRowContainerCtrls) {
    if (!headerRowContainerCtrl) {
      continue;
    }
    const groupRowCount = headerRowContainerCtrl.getGroupRowCount() || 0;
    for (let i = 0; i < groupRowCount; i++) {
      const headerRowCtrl = headerRowContainerCtrl.getGroupRowCtrlAtIndex(i);
      const currentHeightAtPos = heights[i];
      if (headerRowCtrl) {
        const newHeight = getColumnGroupHeaderRowHeight(beans, headerRowCtrl);
        if (currentHeightAtPos == null || newHeight > currentHeightAtPos) {
          heights[i] = newHeight;
        }
      }
    }
  }
  return heights;
}
function getColumnGroupHeaderRowHeight(beans, headerRowCtrl) {
  const defaultHeight = beans.colModel.isPivotMode() ? getPivotGroupHeaderHeight(beans) : getGroupHeaderHeight(beans);
  let maxDisplayedHeight = defaultHeight;
  const headerRowCellCtrls = headerRowCtrl.getHeaderCellCtrls();
  for (const headerCellCtrl of headerRowCellCtrls) {
    const { column } = headerCellCtrl;
    const height = column.getAutoHeaderHeight();
    if (height != null && height > maxDisplayedHeight && column.isAutoHeaderHeight()) {
      maxDisplayedHeight = height;
    }
  }
  return maxDisplayedHeight;
}
function getColumnHeaderRowHeight(beans) {
  const defaultHeight = beans.colModel.isPivotMode() ? getPivotHeaderHeight(beans) : getHeaderHeight(beans);
  let maxDisplayedHeight = defaultHeight;
  beans.colModel.forAllCols((col) => {
    const height = col.getAutoHeaderHeight();
    if (height != null && height > maxDisplayedHeight && col.isAutoHeaderHeight()) {
      maxDisplayedHeight = height;
    }
  });
  return maxDisplayedHeight;
}
function getHeaderHeight(beans) {
  return beans.gos.get("headerHeight") ?? beans.environment.getDefaultHeaderHeight();
}
function getFloatingFiltersHeight(beans) {
  return beans.gos.get("floatingFiltersHeight") ?? getHeaderHeight(beans);
}
function getGroupHeaderHeight(beans) {
  return beans.gos.get("groupHeaderHeight") ?? getHeaderHeight(beans);
}
function getPivotHeaderHeight(beans) {
  return beans.gos.get("pivotHeaderHeight") ?? getHeaderHeight(beans);
}
function getPivotGroupHeaderHeight(beans) {
  return beans.gos.get("pivotGroupHeaderHeight") ?? getGroupHeaderHeight(beans);
}

// packages/ag-grid-community/src/headerRendering/gridHeaderCtrl.ts
var GridHeaderCtrl = class extends BeanStub {
  setComp(comp, eGui, eFocusableElement) {
    this.comp = comp;
    this.eGui = eGui;
    const { beans } = this;
    const { headerNavigation, touchSvc, ctrlsSvc } = beans;
    if (headerNavigation) {
      this.createManagedBean(
        new ManagedFocusFeature(eFocusableElement, {
          onTabKeyDown: this.onTabKeyDown.bind(this),
          handleKeyDown: this.handleKeyDown.bind(this),
          onFocusOut: this.onFocusOut.bind(this)
        })
      );
    }
    this.addManagedEventListeners({
      columnPivotModeChanged: this.onPivotModeChanged.bind(this, beans),
      displayedColumnsChanged: this.onDisplayedColumnsChanged.bind(this, beans)
    });
    this.onPivotModeChanged(beans);
    this.setupHeaderHeight();
    const listener = this.onHeaderContextMenu.bind(this);
    this.addManagedElementListeners(this.eGui, { contextmenu: listener });
    touchSvc?.mockHeaderContextMenu(this, listener);
    ctrlsSvc.register("gridHeaderCtrl", this);
  }
  setupHeaderHeight() {
    const listener = this.setHeaderHeight.bind(this);
    listener();
    this.addManagedPropertyListeners(
      [
        "headerHeight",
        "pivotHeaderHeight",
        "groupHeaderHeight",
        "pivotGroupHeaderHeight",
        "floatingFiltersHeight"
      ],
      listener
    );
    this.addManagedEventListeners({
      headerRowsChanged: listener,
      columnHeaderHeightChanged: listener,
      // add this to the animation frame to avoid a feedback loop
      columnGroupHeaderHeightChanged: () => _requestAnimationFrame(this.beans, () => listener()),
      gridStylesChanged: listener,
      advancedFilterEnabledChanged: listener
    });
  }
  setHeaderHeight() {
    const { beans } = this;
    let totalHeaderHeight = 0;
    const groupHeight = getGroupRowsHeight(beans).reduce((prev, curr) => prev + curr, 0);
    const headerHeight = getColumnHeaderRowHeight(beans);
    if (beans.filterManager?.hasFloatingFilters()) {
      totalHeaderHeight += getFloatingFiltersHeight(beans);
    }
    totalHeaderHeight += groupHeight;
    totalHeaderHeight += headerHeight;
    if (this.headerHeight === totalHeaderHeight) {
      return;
    }
    this.headerHeight = totalHeaderHeight;
    const px = `${totalHeaderHeight + 1}px`;
    this.comp.setHeightAndMinHeight(px);
    this.eventSvc.dispatchEvent({
      type: "headerHeightChanged"
    });
  }
  onPivotModeChanged(beans) {
    const pivotMode = beans.colModel.isPivotMode();
    this.comp.toggleCss("ag-pivot-on", pivotMode);
    this.comp.toggleCss("ag-pivot-off", !pivotMode);
  }
  onDisplayedColumnsChanged(beans) {
    const columns = beans.visibleCols.allCols;
    const shouldAllowOverflow = columns.some((col) => col.isSpanHeaderHeight());
    this.comp.toggleCss("ag-header-allow-overflow", shouldAllowOverflow);
  }
  onTabKeyDown(e) {
    const isRtl = this.gos.get("enableRtl");
    const backwards = e.shiftKey;
    const direction = backwards !== isRtl ? "LEFT" : "RIGHT";
    const { beans } = this;
    const { headerNavigation, focusSvc } = beans;
    if (headerNavigation.navigateHorizontally(direction, true, e) || !backwards && focusSvc.focusOverlay(false) || _focusNextGridCoreContainer(beans, backwards, true)) {
      e.preventDefault();
    }
  }
  handleKeyDown(e) {
    let direction = null;
    const { headerNavigation } = this.beans;
    switch (e.key) {
      case KeyCode.LEFT:
        direction = "LEFT";
      case KeyCode.RIGHT: {
        if (!_exists(direction)) {
          direction = "RIGHT";
        }
        if (headerNavigation.navigateHorizontally(direction, false, e)) {
          e.preventDefault();
        }
        break;
      }
      case KeyCode.UP:
        direction = "UP";
      case KeyCode.DOWN: {
        if (!_exists(direction)) {
          direction = "DOWN";
        }
        if (headerNavigation.navigateVertically(direction, e)) {
          e.preventDefault();
        }
        break;
      }
      default:
        return;
    }
  }
  onFocusOut(e) {
    const { relatedTarget } = e;
    const { eGui, beans } = this;
    if (!relatedTarget && eGui.contains(_getActiveDomElement(beans))) {
      return;
    }
    if (!eGui.contains(relatedTarget)) {
      beans.focusSvc.focusedHeader = null;
    }
  }
  onHeaderContextMenu(mouseEvent, touch, touchEvent) {
    const { menuSvc, ctrlsSvc } = this.beans;
    if (!mouseEvent && !touchEvent || !menuSvc?.isHeaderContextMenuEnabled()) {
      return;
    }
    const { target } = mouseEvent ?? touch;
    if (target === this.eGui || target === ctrlsSvc.getHeaderRowContainerCtrl()?.eViewport) {
      menuSvc.showHeaderContextMenu(void 0, mouseEvent, touchEvent);
    }
  }
};

// packages/ag-grid-community/src/headerRendering/cells/abstractCell/abstractHeaderCellComp.ts
var AbstractHeaderCellComp = class extends Component {
  constructor(template, ctrl) {
    super(template);
    this.ctrl = ctrl;
  }
  getCtrl() {
    return this.ctrl;
  }
};

// packages/ag-grid-community/src/headerRendering/cells/column/headerCellComp.ts
var HeaderCellElement = {
  tag: "div",
  cls: "ag-header-cell",
  role: "columnheader",
  children: [
    { tag: "div", ref: "eResize", cls: "ag-header-cell-resize", role: "presentation" },
    { tag: "div", ref: "eHeaderCompWrapper", cls: "ag-header-cell-comp-wrapper", role: "presentation" }
  ]
};
var HeaderCellComp = class extends AbstractHeaderCellComp {
  constructor(ctrl) {
    super(HeaderCellElement, ctrl);
    this.eResize = RefPlaceholder;
    this.eHeaderCompWrapper = RefPlaceholder;
    this.headerCompVersion = 0;
  }
  postConstruct() {
    const eGui = this.getGui();
    const setAttribute = (name, value) => {
      if (value != null && value != "") {
        eGui.setAttribute(name, value);
      } else {
        eGui.removeAttribute(name);
      }
    };
    const refreshSelectAllGui = () => {
      const selectAllGui = this.ctrl.getSelectAllGui();
      if (selectAllGui) {
        this.eResize.insertAdjacentElement("afterend", selectAllGui);
        this.addDestroyFunc(() => selectAllGui.remove());
      }
    };
    setAttribute("col-id", this.ctrl.column.getColId());
    const compProxy = {
      setWidth: (width) => eGui.style.width = width,
      toggleCss: (cssClassName, on) => this.toggleCss(cssClassName, on),
      setUserStyles: (styles) => _addStylesToElement(eGui, styles),
      setAriaSort: (sort) => sort ? _setAriaSort(eGui, sort) : _removeAriaSort(eGui),
      setUserCompDetails: (compDetails) => this.setUserCompDetails(compDetails),
      getUserCompInstance: () => this.headerComp,
      refreshSelectAllGui,
      removeSelectAllGui: () => this.ctrl.getSelectAllGui()?.remove()
    };
    this.ctrl.setComp(compProxy, this.getGui(), this.eResize, this.eHeaderCompWrapper, void 0);
    refreshSelectAllGui();
  }
  destroy() {
    this.destroyHeaderComp();
    super.destroy();
  }
  destroyHeaderComp() {
    if (this.headerComp) {
      this.eHeaderCompWrapper.removeChild(this.headerCompGui);
      this.headerComp = this.destroyBean(this.headerComp);
      this.headerCompGui = void 0;
    }
  }
  setUserCompDetails(compDetails) {
    this.headerCompVersion++;
    const versionCopy = this.headerCompVersion;
    compDetails.newAgStackInstance().then((comp) => this.afterCompCreated(versionCopy, comp));
  }
  afterCompCreated(version, headerComp) {
    if (version != this.headerCompVersion || !this.isAlive()) {
      this.destroyBean(headerComp);
      return;
    }
    this.destroyHeaderComp();
    this.headerComp = headerComp;
    this.headerCompGui = headerComp.getGui();
    this.eHeaderCompWrapper.appendChild(this.headerCompGui);
    this.ctrl.setDragSource(this.getGui());
  }
};

// packages/ag-grid-community/src/headerRendering/cells/columnGroup/headerGroupCellComp.ts
var HeaderGroupCellCompElement = {
  tag: "div",
  cls: "ag-header-group-cell",
  role: "columnheader",
  children: [
    { tag: "div", ref: "eHeaderCompWrapper", cls: "ag-header-cell-comp-wrapper", role: "presentation" },
    { tag: "div", ref: "eResize", cls: "ag-header-cell-resize", role: "presentation" }
  ]
};
var HeaderGroupCellComp = class extends AbstractHeaderCellComp {
  constructor(ctrl) {
    super(HeaderGroupCellCompElement, ctrl);
    this.eResize = RefPlaceholder;
    this.eHeaderCompWrapper = RefPlaceholder;
  }
  postConstruct() {
    const eGui = this.getGui();
    const setAttribute = (key, value) => value != void 0 ? eGui.setAttribute(key, value) : eGui.removeAttribute(key);
    eGui.setAttribute("col-id", this.ctrl.column.getUniqueId());
    const compProxy = {
      toggleCss: (cssClassName, on) => this.toggleCss(cssClassName, on),
      setUserStyles: (styles) => _addStylesToElement(eGui, styles),
      setHeaderWrapperHidden: (hidden) => {
        if (hidden) {
          this.eHeaderCompWrapper.style.setProperty("display", "none");
        } else {
          this.eHeaderCompWrapper.style.removeProperty("display");
        }
      },
      setHeaderWrapperMaxHeight: (value) => {
        if (value != null) {
          this.eHeaderCompWrapper.style.setProperty("max-height", `${value}px`);
        } else {
          this.eHeaderCompWrapper.style.removeProperty("max-height");
        }
        this.eHeaderCompWrapper.classList.toggle("ag-header-cell-comp-wrapper-limited-height", value != null);
      },
      setResizableDisplayed: (displayed) => _setDisplayed(this.eResize, displayed),
      setWidth: (width) => eGui.style.width = width,
      setAriaExpanded: (expanded) => setAttribute("aria-expanded", expanded),
      setUserCompDetails: (details) => this.setUserCompDetails(details),
      getUserCompInstance: () => this.headerGroupComp
    };
    this.ctrl.setComp(compProxy, eGui, this.eResize, this.eHeaderCompWrapper, void 0);
  }
  setUserCompDetails(details) {
    details.newAgStackInstance().then((comp) => this.afterHeaderCompCreated(comp));
  }
  afterHeaderCompCreated(headerGroupComp) {
    const destroyFunc = () => this.destroyBean(headerGroupComp);
    if (!this.isAlive()) {
      destroyFunc();
      return;
    }
    const eGui = this.getGui();
    const eHeaderGroupGui = headerGroupComp.getGui();
    this.eHeaderCompWrapper.appendChild(eHeaderGroupGui);
    this.addDestroyFunc(destroyFunc);
    this.headerGroupComp = headerGroupComp;
    this.ctrl.setDragSource(eGui);
  }
};

// packages/ag-grid-community/src/headerRendering/cells/floatingFilter/headerFilterCellComp.ts
var HeaderFilterCellCompElement = {
  tag: "div",
  cls: "ag-header-cell ag-floating-filter",
  role: "gridcell",
  children: [
    { tag: "div", ref: "eFloatingFilterBody", role: "presentation" },
    {
      tag: "div",
      ref: "eButtonWrapper",
      cls: "ag-floating-filter-button ag-hidden",
      role: "presentation",
      children: [
        {
          tag: "button",
          ref: "eButtonShowMainFilter",
          cls: "ag-button ag-floating-filter-button-button",
          attrs: { type: "button", tabindex: "-1" }
        }
      ]
    }
  ]
};
var HeaderFilterCellComp = class extends AbstractHeaderCellComp {
  constructor(ctrl) {
    super(HeaderFilterCellCompElement, ctrl);
    this.eFloatingFilterBody = RefPlaceholder;
    this.eButtonWrapper = RefPlaceholder;
    this.eButtonShowMainFilter = RefPlaceholder;
  }
  postConstruct() {
    const eGui = this.getGui();
    const compProxy = {
      toggleCss: (cssClassName, on) => this.toggleCss(cssClassName, on),
      setUserStyles: (styles) => _addStylesToElement(eGui, styles),
      addOrRemoveBodyCssClass: (cssClassName, on) => this.eFloatingFilterBody.classList.toggle(cssClassName, on),
      setButtonWrapperDisplayed: (displayed) => _setDisplayed(this.eButtonWrapper, displayed),
      setCompDetails: (compDetails) => this.setCompDetails(compDetails),
      getFloatingFilterComp: () => this.compPromise,
      setWidth: (width) => eGui.style.width = width,
      setMenuIcon: (eIcon) => this.eButtonShowMainFilter.appendChild(eIcon)
    };
    this.ctrl.setComp(compProxy, eGui, this.eButtonShowMainFilter, this.eFloatingFilterBody, void 0);
  }
  setCompDetails(compDetails) {
    if (!compDetails) {
      this.destroyFloatingFilterComp();
      this.compPromise = null;
      return;
    }
    this.compPromise = compDetails.newAgStackInstance();
    this.compPromise.then((comp) => this.afterCompCreated(comp));
  }
  destroy() {
    this.destroyFloatingFilterComp();
    super.destroy();
  }
  destroyFloatingFilterComp() {
    if (this.floatingFilterComp) {
      this.eFloatingFilterBody.removeChild(this.floatingFilterComp.getGui());
      this.floatingFilterComp = this.destroyBean(this.floatingFilterComp);
    }
  }
  afterCompCreated(comp) {
    if (!comp) {
      return;
    }
    if (!this.isAlive()) {
      this.destroyBean(comp);
      return;
    }
    this.destroyFloatingFilterComp();
    this.floatingFilterComp = comp;
    this.eFloatingFilterBody.appendChild(comp.getGui());
    if (comp.afterGuiAttached) {
      comp.afterGuiAttached();
    }
  }
};

// packages/ag-grid-community/src/headerRendering/row/headerRowComp.ts
var HeaderRowComp = class extends Component {
  constructor(ctrl) {
    super({ tag: "div", cls: ctrl.headerRowClass, role: "row" });
    this.ctrl = ctrl;
    this.headerComps = {};
  }
  postConstruct() {
    _setAriaRowIndex(this.getGui(), this.ctrl.getAriaRowIndex());
    const compProxy = {
      setHeight: (height) => this.getGui().style.height = height,
      setTop: (top) => this.getGui().style.top = top,
      setHeaderCtrls: (ctrls, forceOrder) => this.setHeaderCtrls(ctrls, forceOrder),
      setWidth: (width) => this.getGui().style.width = width,
      setRowIndex: (rowIndex) => _setAriaRowIndex(this.getGui(), rowIndex)
    };
    this.ctrl.setComp(compProxy, void 0);
  }
  destroy() {
    this.setHeaderCtrls([], false);
    super.destroy();
  }
  setHeaderCtrls(ctrls, forceOrder) {
    if (!this.isAlive()) {
      return;
    }
    const oldComps = this.headerComps;
    this.headerComps = {};
    ctrls.forEach((ctrl) => {
      const id = ctrl.instanceId;
      let comp = oldComps[id];
      delete oldComps[id];
      if (comp == null) {
        comp = this.createHeaderComp(ctrl);
        this.getGui().appendChild(comp.getGui());
      }
      this.headerComps[id] = comp;
    });
    Object.values(oldComps).forEach((comp) => {
      this.getGui().removeChild(comp.getGui());
      this.destroyBean(comp);
    });
    if (forceOrder) {
      const comps = Object.values(this.headerComps);
      comps.sort(
        (a, b) => {
          const leftA = a.getCtrl().column.getLeft();
          const leftB = b.getCtrl().column.getLeft();
          return leftA - leftB;
        }
      );
      const elementsInOrder = comps.map((c) => c.getGui());
      _setDomChildOrder(this.getGui(), elementsInOrder);
    }
  }
  createHeaderComp(headerCtrl) {
    let result;
    switch (this.ctrl.type) {
      case "group":
        result = new HeaderGroupCellComp(headerCtrl);
        break;
      case "filter":
        result = new HeaderFilterCellComp(headerCtrl);
        break;
      default:
        result = new HeaderCellComp(headerCtrl);
        break;
    }
    this.createBean(result);
    result.setParentComponent(this);
    return result;
  }
};

// packages/ag-grid-community/src/rendering/features/setLeftFeature.ts
var SetLeftFeature = class extends BeanStub {
  constructor(columnOrGroup, eCell, beans, colsSpanning) {
    super();
    this.columnOrGroup = columnOrGroup;
    this.eCell = eCell;
    this.colsSpanning = colsSpanning;
    this.columnOrGroup = columnOrGroup;
    this.ariaEl = eCell.querySelector("[role=columnheader]") || eCell;
    this.beans = beans;
  }
  setColsSpanning(colsSpanning) {
    this.colsSpanning = colsSpanning;
    this.onLeftChanged();
  }
  getColumnOrGroup() {
    const { beans, colsSpanning } = this;
    if (beans.gos.get("enableRtl") && colsSpanning) {
      return _last(colsSpanning);
    }
    return this.columnOrGroup;
  }
  postConstruct() {
    const onLeftChanged = this.onLeftChanged.bind(this);
    this.addManagedListeners(this.columnOrGroup, { leftChanged: onLeftChanged });
    this.setLeftFirstTime();
    this.addManagedEventListeners({ displayedColumnsWidthChanged: onLeftChanged });
    this.addManagedPropertyListener("domLayout", onLeftChanged);
  }
  setLeftFirstTime() {
    const { gos, colAnimation } = this.beans;
    const suppressMoveAnimation = gos.get("suppressColumnMoveAnimation");
    const oldLeftExists = _exists(this.columnOrGroup.getOldLeft());
    const animateColumnMove = colAnimation?.isActive() && oldLeftExists && !suppressMoveAnimation;
    if (animateColumnMove) {
      this.animateInLeft();
    } else {
      this.onLeftChanged();
    }
  }
  animateInLeft() {
    const colOrGroup = this.getColumnOrGroup();
    const oldActualLeft = this.modifyLeftForPrintLayout(colOrGroup, colOrGroup.getOldLeft());
    const actualLeft = this.modifyLeftForPrintLayout(colOrGroup, colOrGroup.getLeft());
    this.setLeft(oldActualLeft);
    this.actualLeft = actualLeft;
    this.beans.colAnimation.executeNextVMTurn(() => {
      if (this.actualLeft === actualLeft) {
        this.setLeft(actualLeft);
      }
    });
  }
  onLeftChanged() {
    const colOrGroup = this.getColumnOrGroup();
    const left = colOrGroup.getLeft();
    this.actualLeft = this.modifyLeftForPrintLayout(colOrGroup, left);
    this.setLeft(this.actualLeft);
  }
  modifyLeftForPrintLayout(colOrGroup, leftPosition) {
    const { gos, visibleCols } = this.beans;
    const printLayout = _isDomLayout(gos, "print");
    if (!printLayout) {
      return leftPosition;
    }
    if (colOrGroup.getPinned() === "left") {
      return leftPosition;
    }
    const leftWidth = visibleCols.getColsLeftWidth();
    if (colOrGroup.getPinned() === "right") {
      const bodyWidth = visibleCols.bodyWidth;
      return leftWidth + bodyWidth + leftPosition;
    }
    return leftWidth + leftPosition;
  }
  setLeft(value) {
    if (_exists(value)) {
      this.eCell.style.left = `${value}px`;
    }
    if (isColumnGroup(this.columnOrGroup)) {
      const children = this.columnOrGroup.getLeafColumns();
      if (!children.length) {
        return;
      }
      if (children.length > 1) {
        _setAriaColSpan(this.ariaEl, children.length);
      }
    }
  }
};

// packages/ag-grid-community/src/headerRendering/cells/abstractCell/abstractHeaderCellCtrl.ts
var instanceIdSequence4 = 0;
var DOM_DATA_KEY_HEADER_CTRL = "headerCtrl";
var AbstractHeaderCellCtrl = class extends BeanStub {
  constructor(column, rowCtrl) {
    super();
    this.column = column;
    this.rowCtrl = rowCtrl;
    this.resizeToggleTimeout = 0;
    this.resizeMultiplier = 1;
    this.resizeFeature = null;
    this.lastFocusEvent = null;
    this.dragSource = null;
    this.instanceId = column.getUniqueId() + "-" + instanceIdSequence4++;
  }
  postConstruct() {
    const refreshTabIndex = this.refreshTabIndex.bind(this);
    this.addManagedPropertyListeners(["suppressHeaderFocus"], refreshTabIndex);
    this.addManagedEventListeners({
      overlayExclusiveChanged: refreshTabIndex
    });
  }
  shouldStopEventPropagation(event) {
    const { headerRowIndex, column } = this.beans.focusSvc.focusedHeader;
    const colDef = column.getDefinition();
    const colDefFunc = colDef && colDef.suppressHeaderKeyboardEvent;
    if (!_exists(colDefFunc)) {
      return false;
    }
    const params = _addGridCommonParams(this.gos, {
      colDef,
      column,
      headerRowIndex,
      event
    });
    return !!colDefFunc(params);
  }
  getWrapperHasFocus() {
    const activeEl = _getActiveDomElement(this.beans);
    return activeEl === this.eGui;
  }
  setGui(eGui, compBean) {
    this.eGui = eGui;
    this.addDomData(compBean);
    compBean.addManagedListeners(this.beans.eventSvc, {
      displayedColumnsChanged: this.onDisplayedColumnsChanged.bind(this)
    });
    compBean.addManagedElementListeners(this.eGui, {
      focus: this.onGuiFocus.bind(this)
    });
    this.onDisplayedColumnsChanged();
    this.refreshTabIndex();
  }
  refreshHeaderStyles() {
    const colDef = this.column.getDefinition();
    if (!colDef) {
      return;
    }
    const { headerStyle } = colDef;
    let styles;
    if (typeof headerStyle === "function") {
      const cellStyleParams = this.getHeaderClassParams();
      styles = headerStyle(cellStyleParams);
    } else {
      styles = headerStyle;
    }
    if (styles) {
      this.comp.setUserStyles(styles);
    }
  }
  onGuiFocus() {
    this.eventSvc.dispatchEvent({
      type: "headerFocused",
      column: this.column
    });
  }
  setupAutoHeight(params) {
    const { wrapperElement, checkMeasuringCallback, compBean } = params;
    const { beans } = this;
    const measureHeight = (timesCalled) => {
      if (!this.isAlive() || !compBean.isAlive()) {
        return;
      }
      const { paddingTop, paddingBottom, borderBottomWidth, borderTopWidth } = _getElementSize(this.eGui);
      const extraHeight = paddingTop + paddingBottom + borderBottomWidth + borderTopWidth;
      const wrapperHeight = wrapperElement.offsetHeight;
      const autoHeight = wrapperHeight + extraHeight;
      if (timesCalled < 5) {
        const doc = _getDocument(beans);
        const notYetInDom = !doc || !doc.contains(wrapperElement);
        const possiblyNoContentYet = autoHeight == 0;
        if (notYetInDom || possiblyNoContentYet) {
          _batchCall(() => measureHeight(timesCalled + 1), "raf", beans);
          return;
        }
      }
      this.setColHeaderHeight(this.column, autoHeight);
    };
    let isMeasuring = false;
    let stopResizeObserver;
    const checkMeasuring = () => {
      const newValue = this.column.isAutoHeaderHeight();
      if (newValue && !isMeasuring) {
        startMeasuring();
      }
      if (!newValue && isMeasuring) {
        stopMeasuring();
      }
    };
    const startMeasuring = () => {
      isMeasuring = true;
      measureHeight(0);
      this.comp.toggleCss("ag-header-cell-auto-height", true);
      stopResizeObserver = _observeResize(this.beans, wrapperElement, () => measureHeight(0));
    };
    const stopMeasuring = () => {
      isMeasuring = false;
      if (stopResizeObserver) {
        stopResizeObserver();
      }
      this.comp.toggleCss("ag-header-cell-auto-height", false);
      stopResizeObserver = void 0;
    };
    checkMeasuring();
    compBean.addDestroyFunc(() => stopMeasuring());
    compBean.addManagedListeners(this.column, { widthChanged: () => isMeasuring && measureHeight(0) });
    compBean.addManagedEventListeners({
      sortChanged: () => {
        if (isMeasuring) {
          window.setTimeout(() => measureHeight(0));
        }
      }
    });
    if (checkMeasuringCallback) {
      checkMeasuringCallback(checkMeasuring);
    }
  }
  onDisplayedColumnsChanged() {
    const { comp, column, beans, eGui } = this;
    if (!comp || !column || !eGui) {
      return;
    }
    refreshFirstAndLastStyles(comp, column, beans.visibleCols);
    _setAriaColIndex(eGui, beans.visibleCols.getAriaColIndex(column));
  }
  addResizeAndMoveKeyboardListeners(compBean) {
    compBean.addManagedListeners(this.eGui, {
      keydown: this.onGuiKeyDown.bind(this),
      keyup: this.onGuiKeyUp.bind(this)
    });
  }
  refreshTabIndex() {
    const suppressHeaderFocus = _isHeaderFocusSuppressed(this.beans);
    if (this.eGui) {
      _addOrRemoveAttribute(this.eGui, "tabindex", suppressHeaderFocus ? null : "-1");
    }
  }
  onGuiKeyDown(e) {
    const activeEl = _getActiveDomElement(this.beans);
    const isLeftOrRight = e.key === KeyCode.LEFT || e.key === KeyCode.RIGHT;
    if (this.isResizing) {
      e.preventDefault();
      e.stopImmediatePropagation();
    }
    if (
      // if elements within the header are focused, we don't process the event
      activeEl !== this.eGui || // if shiftKey and altKey are not pressed, it's cell navigation so we don't process the event
      !e.shiftKey && !e.altKey
    ) {
      return;
    }
    if (this.isResizing || isLeftOrRight) {
      e.preventDefault();
      e.stopImmediatePropagation();
    }
    if (!isLeftOrRight) {
      return;
    }
    const isLeft = e.key === KeyCode.LEFT !== this.gos.get("enableRtl");
    const direction = isLeft ? "left" : "right";
    if (e.altKey) {
      this.isResizing = true;
      this.resizeMultiplier += 1;
      const diff = this.getViewportAdjustedResizeDiff(e);
      this.resizeHeader(diff, e.shiftKey);
      this.resizeFeature?.toggleColumnResizing(true);
    } else {
      this.moveHeader(direction);
    }
  }
  moveHeader(hDirection) {
    this.beans.colMoves?.moveHeader(hDirection, this.eGui, this.column, this.rowCtrl.pinned, this);
  }
  getViewportAdjustedResizeDiff(e) {
    const diff = this.getResizeDiff(e);
    const { pinnedCols } = this.beans;
    return pinnedCols ? pinnedCols.getHeaderResizeDiff(diff, this.column) : diff;
  }
  getResizeDiff(e) {
    const { gos, column } = this;
    let isLeft = e.key === KeyCode.LEFT !== gos.get("enableRtl");
    const pinned = column.getPinned();
    const isRtl = gos.get("enableRtl");
    if (pinned) {
      if (isRtl !== (pinned === "right")) {
        isLeft = !isLeft;
      }
    }
    return (isLeft ? -1 : 1) * this.resizeMultiplier;
  }
  onGuiKeyUp() {
    if (!this.isResizing) {
      return;
    }
    if (this.resizeToggleTimeout) {
      window.clearTimeout(this.resizeToggleTimeout);
      this.resizeToggleTimeout = 0;
    }
    this.isResizing = false;
    this.resizeMultiplier = 1;
    this.resizeToggleTimeout = window.setTimeout(() => {
      this.resizeFeature?.toggleColumnResizing(false);
    }, 150);
  }
  handleKeyDown(e) {
    const wrapperHasFocus = this.getWrapperHasFocus();
    switch (e.key) {
      case KeyCode.PAGE_DOWN:
      case KeyCode.PAGE_UP:
      case KeyCode.PAGE_HOME:
      case KeyCode.PAGE_END:
        if (wrapperHasFocus) {
          e.preventDefault();
        }
    }
  }
  addDomData(compBean) {
    const key = DOM_DATA_KEY_HEADER_CTRL;
    const { eGui, gos } = this;
    _setDomData(gos, eGui, key, this);
    compBean.addDestroyFunc(() => _setDomData(gos, eGui, key, null));
  }
  focus(event) {
    const { eGui } = this;
    if (!eGui) {
      return false;
    }
    this.lastFocusEvent = event || null;
    eGui.focus();
    return true;
  }
  focusThis() {
    this.beans.focusSvc.focusedHeader = { headerRowIndex: this.rowCtrl.rowIndex, column: this.column };
  }
  removeDragSource() {
    if (this.dragSource) {
      this.beans.dragAndDrop?.removeDragSource(this.dragSource);
      this.dragSource = null;
    }
  }
  handleContextMenuMouseEvent(mouseEvent, touchEvent, column) {
    const event = mouseEvent ?? touchEvent;
    const { menuSvc, gos } = this.beans;
    if (gos.get("preventDefaultOnContextMenu")) {
      event.preventDefault();
    }
    if (menuSvc?.isHeaderContextMenuEnabled(column)) {
      menuSvc.showHeaderContextMenu(column, mouseEvent, touchEvent);
    }
    this.dispatchColumnMouseEvent("columnHeaderContextMenu", column);
  }
  dispatchColumnMouseEvent(eventType, column) {
    this.eventSvc.dispatchEvent({
      type: eventType,
      column
    });
  }
  setColHeaderHeight(col, height) {
    if (!col.setAutoHeaderHeight(height)) {
      return;
    }
    const { eventSvc } = this;
    if (col.isColumn) {
      eventSvc.dispatchEvent({
        type: "columnHeaderHeightChanged",
        column: col,
        columns: [col],
        source: "autosizeColumnHeaderHeight"
      });
    } else {
      eventSvc.dispatchEvent({
        type: "columnGroupHeaderHeightChanged",
        columnGroup: col,
        source: "autosizeColumnGroupHeaderHeight"
      });
    }
  }
  clearComponent() {
    this.removeDragSource();
    this.resizeFeature = null;
    this.comp = null;
    this.eGui = null;
  }
  destroy() {
    super.destroy();
    this.column = null;
    this.lastFocusEvent = null;
    this.rowCtrl = null;
  }
};

// packages/ag-grid-community/src/headerRendering/cells/column/headerCellCtrl.ts
var HeaderCellCtrl = class extends AbstractHeaderCellCtrl {
  constructor() {
    super(...arguments);
    this.refreshFunctions = {};
    this.userHeaderClasses = /* @__PURE__ */ new Set();
    this.ariaDescriptionProperties = /* @__PURE__ */ new Map();
  }
  setComp(comp, eGui, eResize, eHeaderCompWrapper, compBeanInput) {
    this.comp = comp;
    const { rowCtrl, column, beans } = this;
    const { colResize, context, colHover, rangeSvc } = beans;
    const compBean = setupCompBean(this, context, compBeanInput);
    this.setGui(eGui, compBean);
    this.updateState();
    this.setupWidth(compBean);
    this.setupMovingCss(compBean);
    this.setupMenuClass(compBean);
    this.setupSortableClass(compBean);
    this.setupWrapTextClass();
    this.refreshSpanHeaderHeight();
    this.setupAutoHeight({
      wrapperElement: eHeaderCompWrapper,
      checkMeasuringCallback: (checkMeasuring) => this.setRefreshFunction("measuring", checkMeasuring),
      compBean
    });
    this.addColumnHoverListener(compBean);
    this.setupFilterClass(compBean);
    this.setupStylesFromColDef();
    this.setupClassesFromColDef();
    this.setupTooltip();
    this.addActiveHeaderMouseListeners(compBean);
    this.setupSelectAll(compBean);
    this.setupUserComp();
    this.refreshAria();
    if (colResize) {
      this.resizeFeature = compBean.createManagedBean(
        colResize.createResizeFeature(rowCtrl.pinned, column, eResize, comp, this)
      );
    } else {
      _setDisplayed(eResize, false);
    }
    colHover?.createHoverFeature(compBean, [column], eGui);
    rangeSvc?.createRangeHighlightFeature(compBean, column, comp);
    compBean.createManagedBean(new SetLeftFeature(column, eGui, beans));
    compBean.createManagedBean(
      new ManagedFocusFeature(eGui, {
        shouldStopEventPropagation: (e) => this.shouldStopEventPropagation(e),
        onTabKeyDown: () => null,
        handleKeyDown: this.handleKeyDown.bind(this),
        onFocusIn: this.onFocusIn.bind(this),
        onFocusOut: this.onFocusOut.bind(this)
      })
    );
    this.addResizeAndMoveKeyboardListeners(compBean);
    compBean.addManagedPropertyListeners(
      ["suppressMovableColumns", "suppressMenuHide", "suppressAggFuncInHeader", "enableAdvancedFilter"],
      () => this.refresh()
    );
    compBean.addManagedListeners(column, { colDefChanged: () => this.refresh() });
    compBean.addManagedListeners(column, { headerHighlightChanged: this.onHeaderHighlightChanged.bind(this) });
    const listener = () => this.checkDisplayName();
    compBean.addManagedEventListeners({
      columnValueChanged: listener,
      columnRowGroupChanged: listener,
      columnPivotChanged: listener,
      headerHeightChanged: this.onHeaderHeightChanged.bind(this)
    });
    compBean.addDestroyFunc(() => {
      this.refreshFunctions = {};
      this.selectAllFeature = null;
      this.dragSourceElement = void 0;
      this.userCompDetails = null;
      this.userHeaderClasses.clear();
      this.ariaDescriptionProperties.clear();
      this.clearComponent();
    });
  }
  resizeHeader(delta, shiftKey) {
    this.beans.colResize?.resizeHeader(this.column, delta, shiftKey);
  }
  getHeaderClassParams() {
    const { column, beans } = this;
    const colDef = column.colDef;
    return _addGridCommonParams(beans.gos, {
      colDef,
      column,
      floatingFilter: false
    });
  }
  setupUserComp() {
    const compDetails = this.lookupUserCompDetails();
    if (compDetails) {
      this.setCompDetails(compDetails);
    }
  }
  setCompDetails(compDetails) {
    this.userCompDetails = compDetails;
    this.comp.setUserCompDetails(compDetails);
  }
  lookupUserCompDetails() {
    const params = this.createParams();
    const colDef = this.column.getColDef();
    return _getHeaderCompDetails(this.beans.userCompFactory, colDef, params);
  }
  createParams() {
    const { menuSvc, sortSvc, colFilter, gos } = this.beans;
    const params = _addGridCommonParams(gos, {
      column: this.column,
      displayName: this.displayName,
      enableSorting: this.column.isSortable(),
      enableMenu: this.menuEnabled,
      enableFilterButton: this.openFilterEnabled && !!menuSvc?.isHeaderFilterButtonEnabled(this.column),
      enableFilterIcon: !!colFilter && (!this.openFilterEnabled || _isLegacyMenuEnabled(this.gos)),
      showColumnMenu: (buttonElement, onClosedCallback) => {
        menuSvc?.showColumnMenu({
          column: this.column,
          buttonElement,
          positionBy: "button",
          onClosedCallback
        });
      },
      showColumnMenuAfterMouseClick: (mouseEvent, onClosedCallback) => {
        menuSvc?.showColumnMenu({
          column: this.column,
          mouseEvent,
          positionBy: "mouse",
          onClosedCallback
        });
      },
      showFilter: (buttonElement) => {
        menuSvc?.showFilterMenu({
          column: this.column,
          buttonElement,
          containerType: "columnFilter",
          positionBy: "button"
        });
      },
      progressSort: (multiSort) => {
        sortSvc?.progressSort(this.column, !!multiSort, "uiColumnSorted");
      },
      setSort: (sort, multiSort) => {
        sortSvc?.setSortForColumn(this.column, sort, !!multiSort, "uiColumnSorted");
      },
      eGridHeader: this.eGui,
      setTooltip: (value, shouldDisplayTooltip) => {
        gos.assertModuleRegistered("Tooltip", 3);
        this.setupTooltip(value, shouldDisplayTooltip);
      }
    });
    return params;
  }
  setupSelectAll(compBean) {
    const { selectionSvc } = this.beans;
    if (!selectionSvc) {
      return;
    }
    this.selectAllFeature = compBean.createOptionalManagedBean(selectionSvc.createSelectAllFeature(this.column));
    this.selectAllFeature?.setComp(this);
    compBean.addManagedPropertyListener("rowSelection", () => {
      const selectAllFeature = selectionSvc.createSelectAllFeature(this.column);
      if (selectAllFeature && !this.selectAllFeature) {
        this.selectAllFeature = compBean.createManagedBean(selectAllFeature);
        this.selectAllFeature?.setComp(this);
        this.comp.refreshSelectAllGui();
      } else if (this.selectAllFeature && !selectAllFeature) {
        this.comp.removeSelectAllGui();
        this.selectAllFeature = this.destroyBean(this.selectAllFeature);
      }
    });
  }
  getSelectAllGui() {
    return this.selectAllFeature?.getCheckboxGui();
  }
  handleKeyDown(e) {
    super.handleKeyDown(e);
    if (e.key === KeyCode.SPACE) {
      this.selectAllFeature?.onSpaceKeyDown(e);
    }
    if (e.key === KeyCode.ENTER) {
      this.onEnterKeyDown(e);
    }
    if (e.key === KeyCode.DOWN && e.altKey) {
      this.showMenuOnKeyPress(e, false);
    }
  }
  onEnterKeyDown(e) {
    if (e.ctrlKey || e.metaKey) {
      this.showMenuOnKeyPress(e, true);
    } else if (this.sortable) {
      this.beans.sortSvc?.progressSort(this.column, e.shiftKey, "uiColumnSorted");
    }
  }
  showMenuOnKeyPress(e, isFilterShortcut) {
    const headerComp = this.comp.getUserCompInstance();
    if (!isHeaderComp(headerComp)) {
      return;
    }
    if (headerComp.onMenuKeyboardShortcut(isFilterShortcut)) {
      e.preventDefault();
    }
  }
  onFocusIn(e) {
    if (!this.eGui.contains(e.relatedTarget)) {
      this.focusThis();
      this.announceAriaDescription();
    }
    if (_isKeyboardMode()) {
      this.setActiveHeader(true);
    }
  }
  onFocusOut(e) {
    if (this.eGui.contains(e.relatedTarget)) {
      return;
    }
    this.setActiveHeader(false);
  }
  setupTooltip(value, shouldDisplayTooltip) {
    this.tooltipFeature = this.beans.tooltipSvc?.setupHeaderTooltip(
      this.tooltipFeature,
      this,
      value,
      shouldDisplayTooltip
    );
  }
  setupStylesFromColDef() {
    this.setRefreshFunction("headerStyles", this.refreshHeaderStyles.bind(this));
    this.refreshHeaderStyles();
  }
  setupClassesFromColDef() {
    const refreshHeaderClasses = () => {
      const colDef = this.column.getColDef();
      const classes = _getHeaderClassesFromColDef(colDef, this.gos, this.column, null);
      const oldClasses = this.userHeaderClasses;
      this.userHeaderClasses = new Set(classes);
      classes.forEach((c) => {
        if (oldClasses.has(c)) {
          oldClasses.delete(c);
        } else {
          this.comp.toggleCss(c, true);
        }
      });
      oldClasses.forEach((c) => this.comp.toggleCss(c, false));
    };
    this.setRefreshFunction("headerClasses", refreshHeaderClasses);
    refreshHeaderClasses();
  }
  setDragSource(eSource) {
    this.dragSourceElement = eSource;
    this.removeDragSource();
    if (!eSource || !this.draggable) {
      return;
    }
    this.dragSource = this.beans.colMoves?.setDragSourceForHeader(eSource, this.column, this.displayName) ?? null;
  }
  updateState() {
    const { menuSvc } = this.beans;
    this.menuEnabled = !!menuSvc?.isColumnMenuInHeaderEnabled(this.column);
    this.openFilterEnabled = !!menuSvc?.isFilterMenuInHeaderEnabled(this.column);
    this.sortable = this.column.isSortable();
    this.displayName = this.calculateDisplayName();
    this.draggable = this.workOutDraggable();
  }
  setRefreshFunction(name, func) {
    this.refreshFunctions[name] = func;
  }
  refresh() {
    this.updateState();
    this.refreshHeaderComp();
    this.refreshAria();
    Object.values(this.refreshFunctions).forEach((f) => f());
  }
  refreshHeaderComp() {
    const newCompDetails = this.lookupUserCompDetails();
    if (!newCompDetails) {
      return;
    }
    const compInstance = this.comp.getUserCompInstance();
    const attemptRefresh = compInstance != null && this.userCompDetails.componentClass == newCompDetails.componentClass;
    const headerCompRefreshed = attemptRefresh ? this.attemptHeaderCompRefresh(newCompDetails.params) : false;
    if (headerCompRefreshed) {
      this.setDragSource(this.dragSourceElement);
    } else {
      this.setCompDetails(newCompDetails);
    }
  }
  attemptHeaderCompRefresh(params) {
    const headerComp = this.comp.getUserCompInstance();
    if (!headerComp) {
      return false;
    }
    if (!headerComp.refresh) {
      return false;
    }
    const res = headerComp.refresh(params);
    return res;
  }
  calculateDisplayName() {
    return this.beans.colNames.getDisplayNameForColumn(this.column, "header", true);
  }
  checkDisplayName() {
    if (this.displayName !== this.calculateDisplayName()) {
      this.refresh();
    }
  }
  workOutDraggable() {
    const colDef = this.column.getColDef();
    const isSuppressMovableColumns = this.gos.get("suppressMovableColumns");
    const colCanMove = !isSuppressMovableColumns && !colDef.suppressMovable && !colDef.lockPosition;
    return !!colCanMove || !!colDef.enableRowGroup || !!colDef.enablePivot;
  }
  setupWidth(compBean) {
    const listener = () => {
      const columnWidth = this.column.getActualWidth();
      this.comp.setWidth(`${columnWidth}px`);
    };
    compBean.addManagedListeners(this.column, { widthChanged: listener });
    listener();
  }
  setupMovingCss(compBean) {
    const listener = () => {
      this.comp.toggleCss("ag-header-cell-moving", this.column.isMoving());
    };
    compBean.addManagedListeners(this.column, { movingChanged: listener });
    listener();
  }
  setupMenuClass(compBean) {
    const listener = () => {
      this.comp?.toggleCss("ag-column-menu-visible", this.column.isMenuVisible());
    };
    compBean.addManagedListeners(this.column, { menuVisibleChanged: listener });
    listener();
  }
  setupSortableClass(compBean) {
    const updateSortableCssClass = () => {
      this.comp.toggleCss("ag-header-cell-sortable", !!this.sortable);
    };
    updateSortableCssClass();
    this.setRefreshFunction("updateSortable", updateSortableCssClass);
    compBean.addManagedEventListeners({ sortChanged: this.refreshAriaSort.bind(this) });
  }
  setupFilterClass(compBean) {
    const listener = () => {
      const isFilterActive = this.column.isFilterActive();
      this.comp.toggleCss("ag-header-cell-filtered", isFilterActive);
      this.refreshAria();
    };
    compBean.addManagedListeners(this.column, { filterActiveChanged: listener });
    listener();
  }
  setupWrapTextClass() {
    const listener = () => {
      const wrapText = !!this.column.getColDef().wrapHeaderText;
      this.comp.toggleCss("ag-header-cell-wrap-text", wrapText);
    };
    listener();
    this.setRefreshFunction("wrapText", listener);
  }
  onHeaderHighlightChanged() {
    const highlighted = this.column.getHighlighted();
    const beforeOn = highlighted === 0 /* Before */;
    const afterOn = highlighted === 1 /* After */;
    this.comp.toggleCss("ag-header-highlight-before", beforeOn);
    this.comp.toggleCss("ag-header-highlight-after", afterOn);
  }
  onDisplayedColumnsChanged() {
    super.onDisplayedColumnsChanged();
    if (!this.isAlive()) {
      return;
    }
    this.onHeaderHeightChanged();
  }
  onHeaderHeightChanged() {
    this.refreshSpanHeaderHeight();
  }
  refreshSpanHeaderHeight() {
    const { eGui, column, comp, beans } = this;
    const groupHeaderHeight = getGroupRowsHeight(this.beans);
    const isZeroGroupHeight = groupHeaderHeight.reduce((total, next) => total += next, 0) === 0;
    comp.toggleCss("ag-header-parent-hidden", isZeroGroupHeight);
    if (!column.isSpanHeaderHeight()) {
      eGui.style.removeProperty("top");
      eGui.style.removeProperty("height");
      comp.toggleCss("ag-header-span-height", false);
      comp.toggleCss("ag-header-span-total", false);
      return;
    }
    const { numberOfParents, isSpanningTotal } = this.column.getColumnGroupPaddingInfo();
    comp.toggleCss("ag-header-span-height", numberOfParents > 0);
    const headerHeight = getColumnHeaderRowHeight(beans);
    if (numberOfParents === 0) {
      comp.toggleCss("ag-header-span-total", false);
      eGui.style.setProperty("top", `0px`);
      eGui.style.setProperty("height", `${headerHeight}px`);
      return;
    }
    comp.toggleCss("ag-header-span-total", isSpanningTotal);
    const indexToStartSpanning = (this.column.getFirstRealParent()?.getLevel() ?? -1) + 1;
    const rowsToSpan = groupHeaderHeight.length - indexToStartSpanning;
    let extraHeight = 0;
    for (let i = 0; i < rowsToSpan; i++) {
      extraHeight += groupHeaderHeight[groupHeaderHeight.length - 1 - i];
    }
    eGui.style.setProperty("top", `${-extraHeight}px`);
    eGui.style.setProperty("height", `${headerHeight + extraHeight}px`);
  }
  refreshAriaSort() {
    if (this.sortable) {
      const translate = this.getLocaleTextFunc();
      const sort = this.beans.sortSvc?.getDisplaySortForColumn(this.column) || null;
      this.comp.setAriaSort(_getAriaSortState(sort));
      this.setAriaDescriptionProperty("sort", translate("ariaSortableColumn", "Press ENTER to sort"));
    } else {
      this.comp.setAriaSort();
      this.setAriaDescriptionProperty("sort", null);
    }
  }
  refreshAriaMenu() {
    if (this.menuEnabled) {
      const translate = this.getLocaleTextFunc();
      this.setAriaDescriptionProperty("menu", translate("ariaMenuColumn", "Press ALT DOWN to open column menu"));
    } else {
      this.setAriaDescriptionProperty("menu", null);
    }
  }
  refreshAriaFilterButton() {
    if (this.openFilterEnabled && !_isLegacyMenuEnabled(this.gos)) {
      const translate = this.getLocaleTextFunc();
      this.setAriaDescriptionProperty(
        "filterButton",
        translate("ariaFilterColumn", "Press CTRL ENTER to open filter")
      );
    } else {
      this.setAriaDescriptionProperty("filterButton", null);
    }
  }
  refreshAriaFiltered() {
    const translate = this.getLocaleTextFunc();
    const isFilterActive = this.column.isFilterActive();
    if (isFilterActive) {
      this.setAriaDescriptionProperty("filter", translate("ariaColumnFiltered", "Column Filtered"));
    } else {
      this.setAriaDescriptionProperty("filter", null);
    }
  }
  setAriaDescriptionProperty(property, value) {
    if (value != null) {
      this.ariaDescriptionProperties.set(property, value);
    } else {
      this.ariaDescriptionProperties.delete(property);
    }
  }
  announceAriaDescription() {
    if (!this.eGui.contains(_getActiveDomElement(this.beans))) {
      return;
    }
    const ariaDescription = Array.from(this.ariaDescriptionProperties.keys()).sort((a, b) => a === "filter" ? -1 : b.charCodeAt(0) - a.charCodeAt(0)).map((key) => this.ariaDescriptionProperties.get(key)).join(". ");
    this.beans.ariaAnnounce?.announceValue(ariaDescription, "columnHeader");
  }
  refreshAria() {
    this.refreshAriaSort();
    this.refreshAriaMenu();
    this.refreshAriaFilterButton();
    this.refreshAriaFiltered();
  }
  addColumnHoverListener(compBean) {
    this.beans.colHover?.addHeaderColumnHoverListener(compBean, this.comp, this.column);
  }
  addActiveHeaderMouseListeners(compBean) {
    const listener = (e) => this.handleMouseOverChange(e.type === "mouseenter");
    const clickListener = () => {
      this.setActiveHeader(true);
      this.dispatchColumnMouseEvent("columnHeaderClicked", this.column);
    };
    const contextMenuListener = (event) => this.handleContextMenuMouseEvent(event, void 0, this.column);
    compBean.addManagedListeners(this.eGui, {
      mouseenter: listener,
      mouseleave: listener,
      click: clickListener,
      contextmenu: contextMenuListener
    });
  }
  handleMouseOverChange(isMouseOver) {
    this.setActiveHeader(isMouseOver);
    this.eventSvc.dispatchEvent({
      type: isMouseOver ? "columnHeaderMouseOver" : "columnHeaderMouseLeave",
      column: this.column
    });
  }
  setActiveHeader(active) {
    this.comp.toggleCss("ag-header-active", active);
  }
  getAnchorElementForMenu(isFilter) {
    const headerComp = this.comp.getUserCompInstance();
    if (isHeaderComp(headerComp)) {
      return headerComp.getAnchorElementForMenu(isFilter);
    }
    return this.eGui;
  }
  destroy() {
    this.tooltipFeature = this.destroyBean(this.tooltipFeature);
    super.destroy();
  }
};
function isHeaderComp(headerComp) {
  return typeof headerComp?.getAnchorElementForMenu === "function" && typeof headerComp.onMenuKeyboardShortcut === "function";
}

// packages/ag-grid-community/src/headerRendering/row/headerRowCtrl.ts
var instanceIdSequence5 = 0;
var HeaderRowCtrl = class extends BeanStub {
  constructor(rowIndex, pinned, type) {
    super();
    this.rowIndex = rowIndex;
    this.pinned = pinned;
    this.type = type;
    this.instanceId = instanceIdSequence5++;
    this.comp = null;
    this.allCtrls = [];
    let typeClass = "ag-header-row-column";
    if (type === "group") {
      typeClass = "ag-header-row-group";
    } else if (type === "filter") {
      typeClass = "ag-header-row-filter";
    }
    this.headerRowClass = `ag-header-row ${typeClass}`;
  }
  setRowIndex(rowIndex) {
    this.rowIndex = rowIndex;
    this.comp?.setRowIndex(this.getAriaRowIndex());
    this.onRowHeightChanged();
  }
  postConstruct() {
    this.isPrintLayout = _isDomLayout(this.gos, "print");
    this.isEnsureDomOrder = this.gos.get("ensureDomOrder");
  }
  /** Checks that every header cell that is currently visible has been rendered.
   * Can only be false under some circumstances when using React
   */
  areCellsRendered() {
    if (!this.comp) {
      return false;
    }
    return this.allCtrls.every((ctrl) => ctrl.eGui != null);
  }
  /**
   *
   * @param comp Proxy to the actual component
   * @param initCompState Should the component be initialised with the current state of the controller. Default: true
   */
  setComp(comp, compBean, initCompState = true) {
    this.comp = comp;
    compBean = setupCompBean(this, this.beans.context, compBean);
    if (initCompState) {
      this.setRowIndex(this.rowIndex);
      this.onVirtualColumnsChanged();
    }
    this.setWidth();
    this.addEventListeners(compBean);
  }
  getAriaRowIndex() {
    return this.rowIndex + 1;
  }
  addEventListeners(compBean) {
    const onHeightChanged = this.onRowHeightChanged.bind(this);
    const onDisplayedColumnsChanged = this.onDisplayedColumnsChanged.bind(this);
    compBean.addManagedEventListeners({
      columnResized: this.setWidth.bind(this),
      displayedColumnsChanged: onDisplayedColumnsChanged,
      virtualColumnsChanged: (params) => this.onVirtualColumnsChanged(params.afterScroll),
      columnGroupHeaderHeightChanged: onHeightChanged,
      columnHeaderHeightChanged: onHeightChanged,
      gridStylesChanged: onHeightChanged,
      advancedFilterEnabledChanged: onHeightChanged
    });
    compBean.addManagedPropertyListener("domLayout", onDisplayedColumnsChanged);
    compBean.addManagedPropertyListener("ensureDomOrder", (e) => this.isEnsureDomOrder = e.currentValue);
    compBean.addManagedPropertyListeners(
      [
        "headerHeight",
        "pivotHeaderHeight",
        "groupHeaderHeight",
        "pivotGroupHeaderHeight",
        "floatingFiltersHeight"
      ],
      onHeightChanged
    );
  }
  onDisplayedColumnsChanged() {
    this.isPrintLayout = _isDomLayout(this.gos, "print");
    this.onVirtualColumnsChanged();
    this.setWidth();
    this.onRowHeightChanged();
  }
  setWidth() {
    if (!this.comp) {
      return;
    }
    const width = this.getWidthForRow();
    this.comp.setWidth(`${width}px`);
  }
  getWidthForRow() {
    const { visibleCols } = this.beans;
    if (this.isPrintLayout) {
      const pinned = this.pinned != null;
      if (pinned) {
        return 0;
      }
      return visibleCols.getContainerWidth("right") + visibleCols.getContainerWidth("left") + visibleCols.getContainerWidth(null);
    }
    return visibleCols.getContainerWidth(this.pinned);
  }
  onRowHeightChanged() {
    if (!this.comp) {
      return;
    }
    const { topOffset, rowHeight } = this.getTopAndHeight();
    this.comp.setTop(topOffset + "px");
    this.comp.setHeight(rowHeight + "px");
  }
  getTopAndHeight() {
    let topOffset = 0;
    const groupHeadersHeight = getGroupRowsHeight(this.beans);
    for (let i = 0; i < groupHeadersHeight.length; i++) {
      if (i === this.rowIndex && this.type === "group") {
        return { topOffset, rowHeight: groupHeadersHeight[i] };
      }
      topOffset += groupHeadersHeight[i];
    }
    const headerHeight = getColumnHeaderRowHeight(this.beans);
    if (this.type === "column") {
      return { topOffset, rowHeight: headerHeight };
    }
    topOffset += headerHeight;
    const filterHeight = getFloatingFiltersHeight(this.beans);
    return { topOffset, rowHeight: filterHeight };
  }
  onVirtualColumnsChanged(afterScroll = false) {
    if (!this.comp) {
      return;
    }
    const ctrlsToDisplay = this.getUpdatedHeaderCtrls();
    const forceOrder = this.isEnsureDomOrder || this.isPrintLayout;
    this.comp.setHeaderCtrls(ctrlsToDisplay, forceOrder, afterScroll);
  }
  /**
   * Recycles the header cell ctrls and creates new ones for the columns in the viewport
   * @returns The updated header cell ctrls
   */
  getUpdatedHeaderCtrls() {
    const oldCtrls = this.ctrlsById;
    this.ctrlsById = /* @__PURE__ */ new Map();
    const columns = this.getColumnsInViewport();
    for (const child of columns) {
      this.recycleAndCreateHeaderCtrls(child, this.ctrlsById, oldCtrls);
    }
    const isFocusedAndDisplayed = (ctrl) => {
      const { focusSvc, visibleCols } = this.beans;
      const isFocused = focusSvc.isHeaderWrapperFocused(ctrl);
      if (!isFocused) {
        return false;
      }
      const isDisplayed = visibleCols.isVisible(ctrl.column);
      return isDisplayed;
    };
    if (oldCtrls) {
      for (const [id, oldCtrl] of oldCtrls) {
        const keepCtrl = isFocusedAndDisplayed(oldCtrl);
        if (keepCtrl) {
          this.ctrlsById.set(id, oldCtrl);
        } else {
          this.destroyBean(oldCtrl);
        }
      }
    }
    this.allCtrls = Array.from(this.ctrlsById.values());
    return this.allCtrls;
  }
  /** Get the current header cell ctrls */
  getHeaderCellCtrls() {
    return this.allCtrls;
  }
  recycleAndCreateHeaderCtrls(headerColumn, currCtrls, oldCtrls) {
    if (headerColumn.isEmptyGroup()) {
      return;
    }
    const idOfChild = headerColumn.getUniqueId();
    let headerCtrl;
    if (oldCtrls) {
      headerCtrl = oldCtrls.get(idOfChild);
      oldCtrls.delete(idOfChild);
    }
    const forOldColumn = headerCtrl && headerCtrl.column != headerColumn;
    if (forOldColumn) {
      this.destroyBean(headerCtrl);
      headerCtrl = void 0;
    }
    if (headerCtrl == null) {
      switch (this.type) {
        case "filter": {
          headerCtrl = this.createBean(
            this.beans.registry.createDynamicBean(
              "headerFilterCellCtrl",
              true,
              headerColumn,
              this
            )
          );
          break;
        }
        case "group":
          headerCtrl = this.createBean(
            this.beans.registry.createDynamicBean(
              "headerGroupCellCtrl",
              true,
              headerColumn,
              this
            )
          );
          break;
        default:
          headerCtrl = this.createBean(new HeaderCellCtrl(headerColumn, this));
          break;
      }
    }
    currCtrls.set(idOfChild, headerCtrl);
  }
  getColumnsInViewport() {
    if (!this.isPrintLayout) {
      return this.getComponentsToRender();
    }
    if (this.pinned) {
      return [];
    }
    const viewportColumns = [];
    ["left", null, "right"].forEach((pinned) => {
      viewportColumns.push(...this.getComponentsToRender(pinned));
    });
    return viewportColumns;
  }
  getComponentsToRender(pinned = this.pinned) {
    if (this.type === "group") {
      return this.beans.colViewport.getHeadersToRender(pinned, this.rowIndex);
    }
    return this.beans.colViewport.getColumnHeadersToRender(pinned);
  }
  focusHeader(column, event) {
    const ctrl = this.allCtrls.find((ctrl2) => ctrl2.column == column);
    if (!ctrl) {
      return false;
    }
    const focused = ctrl.focus(event);
    return focused;
  }
  destroy() {
    this.allCtrls = this.destroyBeans(this.allCtrls);
    this.ctrlsById = void 0;
    this.comp = null;
    super.destroy();
  }
};

// packages/ag-grid-community/src/headerRendering/rowContainer/headerRowContainerCtrl.ts
var HeaderRowContainerCtrl = class extends BeanStub {
  constructor(pinned) {
    super();
    this.pinned = pinned;
    this.hidden = false;
    this.includeFloatingFilter = false;
    this.groupsRowCtrls = [];
  }
  setComp(comp, eGui) {
    this.comp = comp;
    this.eViewport = eGui;
    const { pinnedCols, ctrlsSvc, colModel, colMoves } = this.beans;
    this.setupCenterWidth();
    pinnedCols?.setupHeaderPinnedWidth(this);
    this.setupDragAndDrop(colMoves, this.eViewport);
    const onDisplayedColsChanged = this.refresh.bind(this, true);
    this.addManagedEventListeners({
      displayedColumnsChanged: onDisplayedColsChanged,
      advancedFilterEnabledChanged: onDisplayedColsChanged
    });
    const headerType = `${typeof this.pinned === "string" ? this.pinned : "center"}Header`;
    ctrlsSvc.register(headerType, this);
    if (colModel.ready) {
      this.refresh();
    }
  }
  getAllCtrls() {
    const res = [...this.groupsRowCtrls];
    if (this.columnsRowCtrl) {
      res.push(this.columnsRowCtrl);
    }
    if (this.filtersRowCtrl) {
      res.push(this.filtersRowCtrl);
    }
    return res;
  }
  refresh(keepColumns = false) {
    const { focusSvc, filterManager, visibleCols } = this.beans;
    let sequence = 0;
    const focusedHeaderPosition = focusSvc.getFocusHeaderToUseAfterRefresh();
    const refreshColumnGroups = () => {
      const groupRowCount = visibleCols.headerGroupRowCount;
      sequence = groupRowCount;
      const currentGroupCount = this.groupsRowCtrls.length;
      if (currentGroupCount === groupRowCount) {
        return;
      }
      if (currentGroupCount > groupRowCount) {
        for (let i = groupRowCount; i < currentGroupCount; i++) {
          this.destroyBean(this.groupsRowCtrls[i]);
        }
        this.groupsRowCtrls.length = groupRowCount;
        return;
      }
      for (let i = currentGroupCount; i < groupRowCount; i++) {
        const ctrl = this.createBean(new HeaderRowCtrl(i, this.pinned, "group"));
        this.groupsRowCtrls.push(ctrl);
      }
    };
    const refreshColumns = () => {
      const rowIndex = sequence++;
      if (this.hidden) {
        this.columnsRowCtrl = this.destroyBean(this.columnsRowCtrl);
        return;
      }
      if (this.columnsRowCtrl == null || !keepColumns) {
        this.columnsRowCtrl = this.destroyBean(this.columnsRowCtrl);
        this.columnsRowCtrl = this.createBean(new HeaderRowCtrl(rowIndex, this.pinned, "column"));
      } else if (this.columnsRowCtrl.rowIndex !== rowIndex) {
        this.columnsRowCtrl.setRowIndex(rowIndex);
      }
    };
    const refreshFilters = () => {
      this.includeFloatingFilter = !!filterManager?.hasFloatingFilters() && !this.hidden;
      const destroyPreviousComp = () => {
        this.filtersRowCtrl = this.destroyBean(this.filtersRowCtrl);
      };
      if (!this.includeFloatingFilter) {
        destroyPreviousComp();
        return;
      }
      if (!keepColumns) {
        destroyPreviousComp();
      }
      const rowIndex = sequence++;
      if (this.filtersRowCtrl) {
        const rowIndexMismatch = this.filtersRowCtrl.rowIndex !== rowIndex;
        if (rowIndexMismatch) {
          this.filtersRowCtrl.setRowIndex(rowIndex);
        }
      } else {
        this.filtersRowCtrl = this.createBean(new HeaderRowCtrl(rowIndex, this.pinned, "filter"));
      }
    };
    const oldCtrls = this.getAllCtrls();
    refreshColumnGroups();
    refreshColumns();
    refreshFilters();
    const allCtrls = this.getAllCtrls();
    this.comp.setCtrls(allCtrls);
    this.restoreFocusOnHeader(focusSvc, focusedHeaderPosition);
    if (oldCtrls.length !== allCtrls.length) {
      this.beans.eventSvc.dispatchEvent({
        type: "headerRowsChanged"
      });
    }
  }
  getHeaderCtrlForColumn(column) {
    const findCtrl = (ctrl) => ctrl?.getHeaderCellCtrls().find((ctrl2) => ctrl2.column === column);
    if (isColumn(column)) {
      return findCtrl(this.columnsRowCtrl);
    }
    if (this.groupsRowCtrls.length === 0) {
      return;
    }
    for (let i = 0; i < this.groupsRowCtrls.length; i++) {
      const ctrl = findCtrl(this.groupsRowCtrls[i]);
      if (ctrl) {
        return ctrl;
      }
    }
  }
  getHtmlElementForColumnHeader(column) {
    return this.getHeaderCtrlForColumn(column)?.eGui ?? null;
  }
  getRowType(rowIndex) {
    return this.getAllCtrls()[rowIndex]?.type;
  }
  focusHeader(rowIndex, column, event) {
    const allCtrls = this.getAllCtrls();
    const ctrl = allCtrls[rowIndex];
    if (!ctrl) {
      return false;
    }
    return ctrl.focusHeader(column, event);
  }
  getGroupRowCount() {
    return this.groupsRowCtrls.length;
  }
  getGroupRowCtrlAtIndex(index) {
    return this.groupsRowCtrls[index];
  }
  getRowCount() {
    return this.groupsRowCtrls.length + (this.columnsRowCtrl ? 1 : 0) + (this.filtersRowCtrl ? 1 : 0);
  }
  setHorizontalScroll(offset) {
    this.comp.setViewportScrollLeft(offset);
  }
  onScrollCallback(fn) {
    this.addManagedElementListeners(this.eViewport, { scroll: fn });
  }
  destroy() {
    this.filtersRowCtrl = this.destroyBean(this.filtersRowCtrl);
    this.columnsRowCtrl = this.destroyBean(this.columnsRowCtrl);
    this.groupsRowCtrls = this.destroyBeans(this.groupsRowCtrls);
    super.destroy();
  }
  setupDragAndDrop(colMoves, dropContainer) {
    const bodyDropTarget = colMoves?.createBodyDropTarget(this.pinned, dropContainer);
    if (bodyDropTarget) {
      this.createManagedBean(bodyDropTarget);
    }
  }
  restoreFocusOnHeader(focusSvc, position) {
    if (!position) {
      return;
    }
    const { column } = position;
    if (column.getPinned() != this.pinned) {
      return;
    }
    focusSvc.focusHeaderPosition({ headerPosition: position });
  }
  setupCenterWidth() {
    if (this.pinned != null) {
      return;
    }
    this.createManagedBean(new CenterWidthFeature((width) => this.comp.setCenterWidth(`${width}px`), true));
  }
};

// packages/ag-grid-community/src/misc/menu/menuService.ts
var MenuService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "menuSvc";
  }
  postConstruct() {
    const { enterpriseMenuFactory, filterMenuFactory } = this.beans;
    this.activeMenuFactory = enterpriseMenuFactory ?? filterMenuFactory;
  }
  showColumnMenu(params) {
    this.showColumnMenuCommon(this.activeMenuFactory, params, "columnMenu");
  }
  showFilterMenu(params) {
    this.showColumnMenuCommon(getFilterMenuFactory(this.beans), params, params.containerType, true);
  }
  showHeaderContextMenu(column, mouseEvent, touchEvent) {
    this.activeMenuFactory?.showMenuAfterContextMenuEvent(column, mouseEvent, touchEvent);
  }
  hidePopupMenu() {
    this.beans.contextMenuSvc?.hideActiveMenu();
    this.activeMenuFactory?.hideActiveMenu();
  }
  hideFilterMenu() {
    getFilterMenuFactory(this.beans)?.hideActiveMenu();
  }
  isColumnMenuInHeaderEnabled(column) {
    const { suppressHeaderMenuButton } = column.getColDef();
    return !suppressHeaderMenuButton && !!this.activeMenuFactory?.isMenuEnabled(column) && (_isLegacyMenuEnabled(this.gos) || !!this.beans.enterpriseMenuFactory);
  }
  isFilterMenuInHeaderEnabled(column) {
    return !column.getColDef().suppressHeaderFilterButton && !!this.beans.filterManager?.isFilterAllowed(column);
  }
  isHeaderContextMenuEnabled(column) {
    const colDef = column && isColumn(column) ? column.getColDef() : column?.getColGroupDef();
    return !colDef?.suppressHeaderContextMenu && this.gos.get("columnMenu") === "new";
  }
  isHeaderMenuButtonAlwaysShowEnabled() {
    return this.isSuppressMenuHide();
  }
  isHeaderMenuButtonEnabled() {
    const menuHides = !this.isSuppressMenuHide();
    const onIpadAndMenuHides = _isIOSUserAgent() && menuHides;
    return !onIpadAndMenuHides;
  }
  isHeaderFilterButtonEnabled(column) {
    return this.isFilterMenuInHeaderEnabled(column) && !_isLegacyMenuEnabled(this.gos) && !this.isFloatingFilterButtonDisplayed(column);
  }
  isFilterMenuItemEnabled(column) {
    return !!this.beans.filterManager?.isFilterAllowed(column) && !_isLegacyMenuEnabled(this.gos) && !this.isFilterMenuInHeaderEnabled(column) && !this.isFloatingFilterButtonDisplayed(column);
  }
  isFloatingFilterButtonEnabled(column) {
    return !column.getColDef().suppressFloatingFilterButton;
  }
  isFloatingFilterButtonDisplayed(column) {
    return !!column.getColDef().floatingFilter && this.isFloatingFilterButtonEnabled(column);
  }
  isSuppressMenuHide() {
    const gos = this.gos;
    const suppressMenuHide = gos.get("suppressMenuHide");
    if (_isLegacyMenuEnabled(gos)) {
      return gos.exists("suppressMenuHide") ? suppressMenuHide : false;
    }
    return suppressMenuHide;
  }
  showColumnMenuCommon(menuFactory, params, containerType, filtersOnly) {
    const { positionBy, onClosedCallback } = params;
    const column = params.column;
    if (positionBy === "button") {
      const { buttonElement } = params;
      menuFactory?.showMenuAfterButtonClick(column, buttonElement, containerType, onClosedCallback, filtersOnly);
    } else if (positionBy === "mouse") {
      const { mouseEvent } = params;
      menuFactory?.showMenuAfterMouseEvent(column, mouseEvent, containerType, onClosedCallback, filtersOnly);
    } else if (column) {
      const beans = this.beans;
      const ctrlsSvc = beans.ctrlsSvc;
      ctrlsSvc.getScrollFeature().ensureColumnVisible(column, "auto");
      _requestAnimationFrame(beans, () => {
        const headerCellCtrl = ctrlsSvc.getHeaderRowContainerCtrl(column.getPinned())?.getHeaderCtrlForColumn(column);
        if (headerCellCtrl) {
          menuFactory?.showMenuAfterButtonClick(
            column,
            headerCellCtrl.getAnchorElementForMenu(filtersOnly),
            containerType,
            onClosedCallback,
            filtersOnly
          );
        }
      });
    }
  }
};
function _setColMenuVisible(column, visible, source) {
  if (column.menuVisible !== visible) {
    column.menuVisible = visible;
    column.dispatchColEvent("menuVisibleChanged", source);
  }
}
function getFilterMenuFactory(beans) {
  const { enterpriseMenuFactory, filterMenuFactory, gos } = beans;
  return enterpriseMenuFactory && _isLegacyMenuEnabled(gos) ? enterpriseMenuFactory : filterMenuFactory;
}

// packages/ag-grid-community/src/widgets/popupComponent.ts
var PopupComponent = class extends Component {
  isPopup() {
    return true;
  }
  setParentComponent(container) {
    container.addCss("ag-has-popup");
    super.setParentComponent(container);
  }
  destroy() {
    const parentComp = this.parentComponent;
    const hasParent = parentComp && parentComp.isAlive();
    if (hasParent) {
      parentComp.getGui().classList.remove("ag-has-popup");
    }
    super.destroy();
  }
};

// packages/ag-grid-community/src/widgets/agAbstractCellEditor.ts
var AgAbstractCellEditor = class extends PopupComponent {
  constructor() {
    super(...arguments);
    this.errorMessages = null;
  }
  init(params) {
    this.params = params;
    this.initialiseEditor(params);
    this.eEditor.onValueChange(() => params.validate());
  }
  destroy() {
    this.errorMessages = null;
  }
};

// packages/ag-grid-community/src/rendering/overlays/overlayComponent.ts
var OverlayComponent = class extends Component {
  constructor() {
    super();
  }
};

// packages/ag-grid-community/src/rendering/overlays/loadingOverlayComponent.ts
var LoadingOverlayElement = {
  tag: "span",
  cls: "ag-overlay-loading-center",
  attrs: { "aria-live": "polite", "aria-atomic": "true" }
};
var LoadingOverlayComponent2 = class extends OverlayComponent {
  init() {
    const customTemplate = _makeNull(this.gos.get("overlayLoadingTemplate")?.trim());
    this.setTemplate(customTemplate ?? LoadingOverlayElement);
    if (!customTemplate) {
      const localeTextFunc = this.getLocaleTextFunc();
      setTimeout(() => {
        this.getGui().textContent = localeTextFunc("loadingOoo", "Loading...");
      });
    }
  }
};

// packages/ag-grid-community/src/rendering/overlays/noRowsOverlayComponent.ts
var NoRowsOverlayElement = { tag: "span", cls: "ag-overlay-no-rows-center" };
var NoRowsOverlayComponent2 = class extends OverlayComponent {
  init() {
    const customTemplate = _makeNull(this.gos.get("overlayNoRowsTemplate")?.trim());
    this.setTemplate(customTemplate ?? NoRowsOverlayElement);
    if (!customTemplate) {
      const localeTextFunc = this.getLocaleTextFunc();
      setTimeout(() => {
        this.getGui().textContent = localeTextFunc("noRowsToShow", "No Rows To Show");
      });
    }
  }
};

// packages/ag-grid-community/src/utils/icon.ts
function _createIcon(iconName, beans, column) {
  const iconContents = _createIconNoSpan(iconName, beans, column);
  if (iconContents) {
    const { className } = iconContents;
    if (typeof className === "string" && className.indexOf("ag-icon") > -1 || typeof className === "object" && className["ag-icon"]) {
      return iconContents;
    }
  }
  const eResult = _createElement({ tag: "span" });
  eResult.appendChild(iconContents);
  return eResult;
}
function _createIconNoSpan(iconName, beans, column) {
  let userProvidedIcon = null;
  if (iconName === "smallDown") {
    _warn(262);
  } else if (iconName === "smallLeft") {
    _warn(263);
  } else if (iconName === "smallRight") {
    _warn(264);
  }
  const icons = column && column.getColDef().icons;
  if (icons) {
    userProvidedIcon = icons[iconName];
  }
  if (beans.gos && !userProvidedIcon) {
    const optionsIcons = beans.gos.get("icons");
    if (optionsIcons) {
      userProvidedIcon = optionsIcons[iconName];
    }
  }
  if (userProvidedIcon) {
    let rendererResult;
    if (typeof userProvidedIcon === "function") {
      rendererResult = userProvidedIcon();
    } else if (typeof userProvidedIcon === "string") {
      rendererResult = userProvidedIcon;
    } else {
      _warn(38, { iconName });
      return void 0;
    }
    if (typeof rendererResult === "string") {
      return _loadTemplate(rendererResult);
    }
    if (_isNodeOrElement(rendererResult)) {
      return rendererResult;
    }
    _warn(133, { iconName });
    return void 0;
  } else {
    const iconValue = beans.registry.getIcon(iconName);
    if (!iconValue) {
      beans.validation?.validateIcon(iconName);
    }
    return _createElement({
      tag: "span",
      cls: `ag-icon ag-icon-${iconValue ?? iconName}`,
      role: "presentation",
      attrs: { unselectable: "on" }
    });
  }
}

// packages/ag-grid-community/src/dragAndDrop/dragAndDropImageComponent.css-GENERATED.ts
var dragAndDropImageComponentCSS = (
  /*css*/
  `.ag-dnd-ghost{align-items:center;background-color:var(--ag-drag-and-drop-image-background-color);border:var(--ag-drag-and-drop-image-border);border-radius:var(--ag-border-radius);box-shadow:var(--ag-drag-and-drop-image-shadow);color:var(--ag-text-color);cursor:move;display:flex;font-weight:500;gap:var(--ag-cell-widget-spacing);height:var(--ag-header-height);overflow:hidden;padding-left:var(--ag-cell-horizontal-padding);padding-right:var(--ag-cell-horizontal-padding);text-overflow:ellipsis;transform:translateY(calc(var(--ag-spacing)*2));white-space:nowrap}`
);

// packages/ag-grid-community/src/dragAndDrop/dragAndDropImageComponent.ts
var DragAndDropElement = {
  tag: "div",
  children: [
    {
      tag: "div",
      ref: "eGhost",
      cls: "ag-dnd-ghost ag-unselectable",
      children: [
        { tag: "span", ref: "eIcon", cls: "ag-dnd-ghost-icon ag-shake-left-to-right" },
        { tag: "div", ref: "eLabel", cls: "ag-dnd-ghost-label" }
      ]
    }
  ]
};
var DragAndDropImageComponent2 = class extends Component {
  constructor() {
    super();
    this.dragSource = null;
    this.eIcon = RefPlaceholder;
    this.eLabel = RefPlaceholder;
    this.eGhost = RefPlaceholder;
    this.registerCSS(dragAndDropImageComponentCSS);
  }
  postConstruct() {
    const create = (iconName) => _createIcon(iconName, this.beans, null);
    this.dropIconMap = {
      pinned: create("columnMovePin"),
      hide: create("columnMoveHide"),
      move: create("columnMoveMove"),
      left: create("columnMoveLeft"),
      right: create("columnMoveRight"),
      group: create("columnMoveGroup"),
      aggregate: create("columnMoveValue"),
      pivot: create("columnMovePivot"),
      notAllowed: create("dropNotAllowed")
    };
  }
  init(params) {
    this.dragSource = params.dragSource;
    this.setTemplate(DragAndDropElement);
    this.beans.environment.applyThemeClasses(this.eGhost);
  }
  destroy() {
    this.dragSource = null;
    super.destroy();
  }
  setIcon(iconName, shake) {
    const { eIcon, dragSource, dropIconMap, gos } = this;
    _clearElement(eIcon);
    let eIconChild = null;
    if (!iconName) {
      iconName = dragSource?.getDefaultIconName ? dragSource.getDefaultIconName() : "notAllowed";
    }
    eIconChild = dropIconMap[iconName];
    eIcon.classList.toggle("ag-shake-left-to-right", shake);
    if (eIconChild === dropIconMap["hide"] && gos.get("suppressDragLeaveHidesColumns")) {
      return;
    }
    if (eIconChild) {
      eIcon.appendChild(eIconChild);
    }
  }
  setLabel(label) {
    this.eLabel.textContent = label;
  }
};

// packages/ag-grid-community/src/widgets/agAbstractLabel.css-GENERATED.ts
var agAbstractLabelCSS = (
  /*css*/
  `.ag-label{white-space:nowrap}:where(.ag-ltr) .ag-label{margin-right:var(--ag-spacing)}:where(.ag-rtl) .ag-label{margin-left:var(--ag-spacing)}:where(.ag-label-align-right) .ag-label{order:1}:where(.ag-ltr) :where(.ag-label-align-right) .ag-label{margin-left:var(--ag-spacing)}:where(.ag-rtl) :where(.ag-label-align-right) .ag-label{margin-right:var(--ag-spacing)}.ag-label-align-right>*{flex:none}.ag-label-align-top{align-items:flex-start;flex-direction:column;>*{align-self:stretch}}.ag-label-ellipsis{flex:1;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}:where(.ag-label-align-top) .ag-label{margin-bottom:calc(var(--ag-spacing)*.5)}`
);

// packages/ag-grid-community/src/widgets/agAbstractLabel.ts
var AgAbstractLabel = class extends Component {
  constructor(config, template, components) {
    super(template, components);
    this.labelSeparator = "";
    this.labelAlignment = "left";
    this.disabled = false;
    this.label = "";
    this.config = config || {};
    this.registerCSS(agAbstractLabelCSS);
  }
  postConstruct() {
    this.addCss("ag-labeled");
    this.eLabel.classList.add("ag-label");
    const { labelSeparator, label, labelWidth, labelAlignment, disabled } = this.config;
    if (disabled != null) {
      this.setDisabled(disabled);
    }
    if (labelSeparator != null) {
      this.setLabelSeparator(labelSeparator);
    }
    if (label != null) {
      this.setLabel(label);
    }
    if (labelWidth != null) {
      this.setLabelWidth(labelWidth);
    }
    this.setLabelAlignment(labelAlignment || this.labelAlignment);
    this.refreshLabel();
  }
  refreshLabel() {
    const { label, eLabel } = this;
    _clearElement(eLabel);
    if (typeof label === "string") {
      eLabel.innerText = label + this.labelSeparator;
    } else if (label) {
      eLabel.appendChild(label);
    }
    if (label === "") {
      _setDisplayed(eLabel, false);
      _setAriaRole(eLabel, "presentation");
    } else {
      _setDisplayed(eLabel, true);
      _setAriaRole(eLabel, null);
    }
  }
  setLabelSeparator(labelSeparator) {
    if (this.labelSeparator === labelSeparator) {
      return this;
    }
    this.labelSeparator = labelSeparator;
    if (this.label != null) {
      this.refreshLabel();
    }
    return this;
  }
  getLabelId() {
    const eLabel = this.eLabel;
    eLabel.id = eLabel.id || `ag-${this.getCompId()}-label`;
    return eLabel.id;
  }
  getLabel() {
    return this.label;
  }
  setLabel(label) {
    if (this.label === label) {
      return this;
    }
    this.label = label;
    this.refreshLabel();
    return this;
  }
  setLabelAlignment(alignment) {
    const eGui = this.getGui();
    const eGuiClassList = eGui.classList;
    eGuiClassList.toggle("ag-label-align-left", alignment === "left");
    eGuiClassList.toggle("ag-label-align-right", alignment === "right");
    eGuiClassList.toggle("ag-label-align-top", alignment === "top");
    return this;
  }
  setLabelEllipsis(hasEllipsis) {
    this.eLabel.classList.toggle("ag-label-ellipsis", hasEllipsis);
    return this;
  }
  setLabelWidth(width) {
    if (this.label == null) {
      return this;
    }
    _setElementWidth(this.eLabel, width);
    return this;
  }
  setDisabled(disabled) {
    disabled = !!disabled;
    const element = this.getGui();
    _setDisabled(element, disabled);
    element.classList.toggle("ag-disabled", disabled);
    this.disabled = disabled;
    return this;
  }
  isDisabled() {
    return !!this.disabled;
  }
};

// packages/ag-grid-community/src/widgets/agAbstractField.ts
var AgAbstractField = class extends AgAbstractLabel {
  constructor(config, template, components, className) {
    super(config, template, components);
    this.className = className;
  }
  postConstruct() {
    super.postConstruct();
    const { width, value, onValueChange } = this.config;
    if (width != null) {
      this.setWidth(width);
    }
    if (value != null) {
      this.setValue(value);
    }
    if (onValueChange != null) {
      this.onValueChange(onValueChange);
    }
    if (this.className) {
      this.addCss(this.className);
    }
    this.refreshAriaLabelledBy();
  }
  setLabel(label) {
    super.setLabel(label);
    this.refreshAriaLabelledBy();
    return this;
  }
  refreshAriaLabelledBy() {
    const ariaEl = this.getAriaElement();
    const labelId = this.getLabelId();
    const label = this.getLabel();
    if (label == null || label == "" || _getAriaLabel(ariaEl) !== null) {
      _setAriaLabelledBy(ariaEl, "");
    } else {
      _setAriaLabelledBy(ariaEl, labelId ?? "");
    }
  }
  setAriaLabel(label) {
    _setAriaLabel(this.getAriaElement(), label);
    this.refreshAriaLabelledBy();
    return this;
  }
  onValueChange(callbackFn) {
    this.addManagedListeners(this, { fieldValueChanged: () => callbackFn(this.getValue()) });
    return this;
  }
  getWidth() {
    return this.getGui().clientWidth;
  }
  setWidth(width) {
    _setFixedWidth(this.getGui(), width);
    return this;
  }
  getPreviousValue() {
    return this.previousValue;
  }
  getValue() {
    return this.value;
  }
  setValue(value, silent) {
    if (this.value === value) {
      return this;
    }
    this.previousValue = this.value;
    this.value = value;
    if (!silent) {
      this.dispatchLocalEvent({ type: "fieldValueChanged" });
    }
    return this;
  }
};

// packages/ag-grid-community/src/widgets/agAbstractInputField.ts
function buildTemplate(displayFieldTag) {
  return {
    tag: "div",
    role: "presentation",
    children: [
      { tag: "div", ref: "eLabel", cls: "ag-input-field-label" },
      {
        tag: "div",
        ref: "eWrapper",
        cls: "ag-wrapper ag-input-wrapper",
        role: "presentation",
        children: [{ tag: displayFieldTag, ref: "eInput", cls: "ag-input-field-input" }]
      }
    ]
  };
}
var AgAbstractInputField = class extends AgAbstractField {
  constructor(config, className, inputType = "text", displayFieldTag = "input") {
    super(config, config?.template ?? buildTemplate(displayFieldTag), [], className);
    this.inputType = inputType;
    this.displayFieldTag = displayFieldTag;
    this.eLabel = RefPlaceholder;
    this.eWrapper = RefPlaceholder;
    this.eInput = RefPlaceholder;
  }
  postConstruct() {
    super.postConstruct();
    this.setInputType(this.inputType);
    const { eLabel, eWrapper, eInput, className } = this;
    eLabel.classList.add(`${className}-label`);
    eWrapper.classList.add(`${className}-input-wrapper`);
    eInput.classList.add(`${className}-input`);
    this.addCss("ag-input-field");
    eInput.id = eInput.id || `ag-${this.getCompId()}-input`;
    const { inputName, inputWidth } = this.config;
    if (inputName != null) {
      this.setInputName(inputName);
    }
    if (inputWidth != null) {
      this.setInputWidth(inputWidth);
    }
    this.addInputListeners();
    this.activateTabIndex([eInput]);
  }
  addInputListeners() {
    this.addManagedElementListeners(this.eInput, {
      input: (e) => this.setValue(e.target.value)
    });
  }
  setInputType(inputType) {
    if (this.displayFieldTag === "input") {
      this.inputType = inputType;
      _addOrRemoveAttribute(this.eInput, "type", inputType);
    }
  }
  getInputElement() {
    return this.eInput;
  }
  setInputWidth(width) {
    _setElementWidth(this.eWrapper, width);
    return this;
  }
  setInputName(name) {
    this.getInputElement().setAttribute("name", name);
    return this;
  }
  getFocusableElement() {
    return this.eInput;
  }
  setMaxLength(length) {
    const eInput = this.eInput;
    eInput.maxLength = length;
    return this;
  }
  setInputPlaceholder(placeholder) {
    _addOrRemoveAttribute(this.eInput, "placeholder", placeholder);
    return this;
  }
  setInputAriaLabel(label) {
    _setAriaLabel(this.eInput, label);
    this.refreshAriaLabelledBy();
    return this;
  }
  setDisabled(disabled) {
    _setDisabled(this.eInput, disabled);
    return super.setDisabled(disabled);
  }
  setAutoComplete(value) {
    if (value === true) {
      _addOrRemoveAttribute(this.eInput, "autocomplete", null);
    } else {
      const autoCompleteValue = typeof value === "string" ? value : "off";
      _addOrRemoveAttribute(this.eInput, "autocomplete", autoCompleteValue);
    }
    return this;
  }
};

// packages/ag-grid-community/src/widgets/agCheckbox.ts
var AgCheckbox = class extends AgAbstractInputField {
  constructor(config, className = "ag-checkbox", inputType = "checkbox") {
    super(config, className, inputType);
    this.labelAlignment = "right";
    this.selected = false;
    this.readOnly = false;
    this.passive = false;
  }
  postConstruct() {
    super.postConstruct();
    const { readOnly, passive } = this.config;
    if (typeof readOnly === "boolean")
      this.setReadOnly(readOnly);
    if (typeof passive === "boolean")
      this.setPassive(passive);
  }
  addInputListeners() {
    this.addManagedElementListeners(this.eInput, { click: this.onCheckboxClick.bind(this) });
    this.addManagedElementListeners(this.eLabel, { click: this.toggle.bind(this) });
  }
  getNextValue() {
    return this.selected === void 0 ? true : !this.selected;
  }
  setPassive(passive) {
    this.passive = passive;
  }
  isReadOnly() {
    return this.readOnly;
  }
  setReadOnly(readOnly) {
    this.eWrapper.classList.toggle("ag-disabled", readOnly);
    this.eInput.disabled = readOnly;
    this.readOnly = readOnly;
  }
  setDisabled(disabled) {
    this.eWrapper.classList.toggle("ag-disabled", disabled);
    return super.setDisabled(disabled);
  }
  toggle() {
    if (this.eInput.disabled) {
      return;
    }
    const previousValue = this.isSelected();
    const nextValue = this.getNextValue();
    if (this.passive) {
      this.dispatchChange(nextValue, previousValue);
    } else {
      this.setValue(nextValue);
    }
  }
  getValue() {
    return this.isSelected();
  }
  setValue(value, silent) {
    this.refreshSelectedClass(value);
    this.setSelected(value, silent);
    return this;
  }
  setName(name) {
    const input = this.getInputElement();
    input.name = name;
    return this;
  }
  isSelected() {
    return this.selected;
  }
  setSelected(selected, silent) {
    if (this.isSelected() === selected) {
      return;
    }
    this.previousValue = this.isSelected();
    selected = this.selected = typeof selected === "boolean" ? selected : void 0;
    const eInput = this.eInput;
    eInput.checked = selected;
    eInput.indeterminate = selected === void 0;
    if (!silent) {
      this.dispatchChange(this.selected, this.previousValue);
    }
  }
  dispatchChange(selected, previousValue, event) {
    this.dispatchLocalEvent({ type: "fieldValueChanged", selected, previousValue, event });
    const input = this.getInputElement();
    this.eventSvc.dispatchEvent({
      type: "checkboxChanged",
      id: input.id,
      name: input.name,
      selected,
      previousValue
    });
  }
  onCheckboxClick(e) {
    if (this.passive || this.eInput.disabled) {
      return;
    }
    const previousValue = this.isSelected();
    const selected = this.selected = e.target.checked;
    this.refreshSelectedClass(selected);
    this.dispatchChange(selected, previousValue, e);
  }
  refreshSelectedClass(value) {
    const classList = this.eWrapper.classList;
    classList.toggle("ag-checked", value === true);
    classList.toggle("ag-indeterminate", value == null);
  }
};
var AgCheckboxSelector = {
  selector: "AG-CHECKBOX",
  component: AgCheckbox
};

// packages/ag-grid-community/src/rendering/cellRenderers/checkboxCellRenderer.css-GENERATED.ts
var checkboxCellRendererCSS = (
  /*css*/
  `.ag-checkbox-cell{height:100%}`
);

// packages/ag-grid-community/src/rendering/cellRenderers/checkboxCellRenderer.ts
var CheckboxCellRendererElement = {
  tag: "div",
  cls: "ag-cell-wrapper ag-checkbox-cell",
  role: "presentation",
  children: [
    {
      tag: "ag-checkbox",
      ref: "eCheckbox",
      role: "presentation"
    }
  ]
};
var CheckboxCellRenderer = class extends Component {
  constructor() {
    super(CheckboxCellRendererElement, [AgCheckboxSelector]);
    this.eCheckbox = RefPlaceholder;
    this.registerCSS(checkboxCellRendererCSS);
  }
  init(params) {
    this.refresh(params);
    const { eCheckbox, beans } = this;
    const inputEl = eCheckbox.getInputElement();
    inputEl.setAttribute("tabindex", "-1");
    _setAriaLive(inputEl, "polite");
    this.addManagedListeners(inputEl, {
      click: (event) => {
        _stopPropagationForAgGrid(event);
        if (eCheckbox.isDisabled()) {
          return;
        }
        const isSelected = eCheckbox.getValue();
        this.onCheckboxChanged(isSelected);
      },
      dblclick: (event) => {
        _stopPropagationForAgGrid(event);
      }
    });
    this.addManagedElementListeners(params.eGridCell, {
      keydown: (event) => {
        if (event.key === KeyCode.SPACE && !eCheckbox.isDisabled()) {
          if (params.eGridCell === _getActiveDomElement(beans)) {
            eCheckbox.toggle();
          }
          const isSelected = eCheckbox.getValue();
          this.onCheckboxChanged(isSelected);
          event.preventDefault();
        }
      }
    });
  }
  refresh(params) {
    this.params = params;
    this.updateCheckbox(params);
    return true;
  }
  updateCheckbox(params) {
    let isSelected;
    let displayed = true;
    const { value, column, node } = params;
    if (node.group && column) {
      if (typeof value === "boolean") {
        isSelected = value;
      } else {
        const colId = column.getColId();
        if (colId.startsWith(GROUP_AUTO_COLUMN_ID)) {
          isSelected = value == null || value === "" ? void 0 : value === "true";
        } else if (node.aggData && node.aggData[colId] !== void 0) {
          isSelected = value ?? void 0;
        } else {
          displayed = false;
        }
      }
    } else {
      isSelected = value ?? void 0;
    }
    const { eCheckbox } = this;
    if (!displayed) {
      eCheckbox.setDisplayed(false);
      return;
    }
    eCheckbox.setValue(isSelected);
    const disabled = params.disabled ?? !column?.isCellEditable(node);
    eCheckbox.setDisabled(disabled);
    const translate = this.getLocaleTextFunc();
    const stateName = _getAriaCheckboxStateName(translate, isSelected);
    const ariaLabel = disabled ? stateName : `${translate("ariaToggleCellValue", "Press SPACE to toggle cell value")} (${stateName})`;
    eCheckbox.setInputAriaLabel(ariaLabel);
  }
  onCheckboxChanged(isSelected) {
    const { params } = this;
    const { column, node, value } = params;
    this.beans?.editSvc?.setEditingCells(
      [
        {
          column,
          colId: column.getColId(),
          rowIndex: node.rowIndex,
          rowPinned: node.rowPinned,
          state: "changed",
          oldValue: value,
          newValue: value
        }
      ],
      { update: true }
    );
    const valueChanged = node.setDataValue(column, isSelected, "renderer");
    this.beans.editSvc?.stopEditing(
      {
        rowNode: node,
        column
      },
      { source: this.beans.editSvc?.isBatchEditing() ? "ui" : "api" }
    );
    if (!valueChanged) {
      this.updateCheckbox(params);
    }
  }
};

// packages/ag-grid-community/src/pinnedRowModel/manualPinnedRowUtils.ts
var PinnedRows = class {
  constructor(beans, floating) {
    this.beans = beans;
    this.floating = floating;
    /** Canonical set of pinned nodes */
    this.all = /* @__PURE__ */ new Set();
    /**
     * Set of nodes that should currently be visible given the context of the grid.
     * This is currently used for hiding leaf nodes in pivot mode and filtered nodes.
     */
    this.visible = /* @__PURE__ */ new Set();
    /** Ordering of nodes in the pinned area */
    this.order = [];
    /** IDs of nodes that need to be pinned once they are available from the row model (SSRM) */
    this.queued = /* @__PURE__ */ new Set();
  }
  size() {
    return this.visible.size;
  }
  add(node) {
    const { all, visible, order } = this;
    if (all.has(node))
      return;
    all.add(node);
    visible.add(node);
    order.push(node);
    this.sort();
  }
  delete(item) {
    this.all.delete(item);
    this.visible.delete(item);
    this.queued.delete(item.id);
    _removeFromArray(this.order, item);
  }
  has(item) {
    return this.visible.has(item);
  }
  forEach(fn) {
    this.order.forEach(fn);
  }
  getByIndex(i) {
    return this.order[i];
  }
  getById(id) {
    for (const node of this.visible) {
      if (node.id == id)
        return node;
    }
  }
  clear() {
    const { all, visible, order, queued } = this;
    all.clear();
    queued.clear();
    visible.clear();
    order.length = 0;
  }
  sort() {
    const { sortSvc, rowNodeSorter, gos } = this.beans;
    const sortOptions = sortSvc?.getSortOptions() ?? [];
    const grandTotalNode = _removeGrandTotalRow(this.order);
    this.order.sort((a, b) => (a.pinnedSibling?.rowIndex ?? 0) - (b.pinnedSibling?.rowIndex ?? 0));
    this.order = rowNodeSorter?.doFullSort(this.order, sortOptions) ?? this.order;
    if (!grandTotalNode)
      return;
    const grandTotalRow = _getGrandTotalRow(gos);
    if (grandTotalRow === "bottom" || grandTotalRow === "pinnedBottom") {
      this.order.push(grandTotalNode);
    } else {
      this.order.unshift(grandTotalNode);
    }
  }
  hide(shouldHide) {
    const { all, visible } = this;
    all.forEach((node) => shouldHide(node) ? visible.delete(node) : visible.add(node));
    this.order = Array.from(visible);
    this.sort();
  }
  queue(id) {
    this.queued.add(id);
  }
  unqueue(id) {
    this.queued.delete(id);
  }
  forEachQueued(fn) {
    this.queued.forEach(fn);
  }
};
function _isDisplayedAfterFilterCSRM(node) {
  if (node.level === -1)
    return true;
  const parent = node.parent;
  if (parent?.childrenAfterSort?.some((child) => child == node)) {
    return _isDisplayedAfterFilterCSRM(parent);
  }
  return false;
}
function _shouldHidePinnedRows(beans, node) {
  const { gos, rowModel, filterManager } = beans;
  if (_isServerSideRowModel(gos, rowModel)) {
    return !rowModel.getRowNode(node.id);
  }
  if (filterManager?.isAnyFilterPresent()) {
    return !_isDisplayedAfterFilterCSRM(node);
  }
  if (gos.get("pivotMode")) {
    return !node.group;
  }
  return false;
}
function _isNodeGrandTotal(node) {
  return !!node.footer && node.level === -1;
}
function _isPinnedNodeGrandTotal(node) {
  return !!node.pinnedSibling && _isNodeGrandTotal(node.pinnedSibling);
}
function _removeGrandTotalRow(order) {
  const index = order.findIndex(_isPinnedNodeGrandTotal);
  if (index > -1) {
    return order.splice(index, 1)?.[0];
  }
}

// packages/ag-grid-community/src/pinnedRowModel/manualPinnedRowModel.ts
var ManualPinnedRowModel = class extends BeanStub {
  postConstruct() {
    const { gos, beans } = this;
    this.top = new PinnedRows(beans, "top");
    this.bottom = new PinnedRows(beans, "bottom");
    const shouldHide = (node) => _shouldHidePinnedRows(beans, node.pinnedSibling);
    const runIsRowPinned = () => {
      const isRowPinned = gos.get("isRowPinned");
      if (isRowPinned && gos.get("enableRowPinning")) {
        beans.rowModel.forEachNode((node) => this.pinRow(node, isRowPinned(node)), true);
      }
      this.refreshRowPositions();
      this.dispatchRowPinnedEvents();
    };
    this.addManagedEventListeners({
      gridStylesChanged: this.onGridStylesChanges.bind(this),
      modelUpdated: ({ keepRenderedRows }) => {
        this.tryToEmptyQueues();
        this.pinGrandTotalRow();
        this.forContainers((container) => container.hide(shouldHide));
        this.refreshRowPositions();
        if (!keepRenderedRows) {
          this.dispatchRowPinnedEvents();
        }
      },
      columnRowGroupChanged: () => {
        this.forContainers(removeGroupRows);
        this.refreshRowPositions();
      },
      rowNodeDataChanged: ({ node }) => {
        const isRowPinnable = gos.get("isRowPinnable");
        const pinnable = isRowPinnable?.(node) ?? true;
        if (!pinnable) {
          this.pinRow(node, null);
        }
      },
      firstDataRendered: runIsRowPinned
    });
    this.addManagedPropertyListener("pivotMode", () => {
      this.forContainers((container) => container.hide(shouldHide));
      this.dispatchRowPinnedEvents();
    });
    this.addManagedPropertyListener("grandTotalRow", ({ currentValue }) => {
      this._grandTotalPinned = currentValue === "pinnedBottom" ? "bottom" : currentValue === "pinnedTop" ? "top" : null;
    });
    this.addManagedPropertyListener("isRowPinned", runIsRowPinned);
  }
  destroy() {
    this.reset(false);
    super.destroy();
  }
  reset(dispatch = true) {
    this.forContainers((container) => {
      const nodesToUnpin = [];
      container.forEach((n) => nodesToUnpin.push(n));
      nodesToUnpin.forEach((n) => this.pinRow(n, null));
      container.clear();
    });
    if (dispatch) {
      this.dispatchRowPinnedEvents();
    }
  }
  pinRow(rowNode, float, column) {
    if (rowNode.footer && rowNode.level > -1)
      return;
    if (rowNode.footer && rowNode.level === -1) {
      this._grandTotalPinned = float;
      refreshCSRM(this.beans);
      return;
    }
    const currentFloat = rowNode.rowPinned ?? rowNode.pinnedSibling?.rowPinned;
    const switching = currentFloat != null && float != null && float != currentFloat;
    if (switching) {
      const pinned = rowNode.rowPinned ? rowNode : rowNode.pinnedSibling;
      const source = rowNode.rowPinned ? rowNode.pinnedSibling : rowNode;
      this.pinRow(pinned, null, column);
      this.pinRow(source, float, column);
      return;
    }
    const spannedRows = column && getSpannedRows(this.beans, rowNode, column);
    if (spannedRows) {
      spannedRows.forEach((node) => this.pinRow(node, float));
      return;
    }
    if (float == null) {
      const node = rowNode.rowPinned ? rowNode : rowNode.pinnedSibling;
      const found = this.findPinnedRowNode(node);
      if (!found)
        return;
      found.delete(node);
      const source = node.pinnedSibling;
      _destroyRowNodeSibling(node);
      this.refreshRowPositions(float);
      this.dispatchRowPinnedEvents(source);
    } else {
      const sibling = _createPinnedSibling(this.beans, rowNode, float);
      const container = this.getContainer(float);
      container.add(sibling);
      if (_shouldHidePinnedRows(this.beans, rowNode)) {
        container.hide((node) => _shouldHidePinnedRows(this.beans, node.pinnedSibling));
      }
      this.refreshRowPositions(float);
      this.dispatchRowPinnedEvents(rowNode);
    }
  }
  isManual() {
    return true;
  }
  isEmpty(floating) {
    return this.getContainer(floating).size() === 0;
  }
  isRowsToRender(floating) {
    return !this.isEmpty(floating);
  }
  ensureRowHeightsValid() {
    let anyChange = false;
    let rowTop = 0;
    const updateRowHeight = (rowNode) => {
      if (rowNode.rowHeightEstimated) {
        const rowHeight = _getRowHeightForNode(this.beans, rowNode);
        rowNode.setRowTop(rowTop);
        rowNode.setRowHeight(rowHeight.height);
        rowTop += rowHeight.height;
        anyChange = true;
      }
    };
    this.bottom.forEach(updateRowHeight);
    rowTop = 0;
    this.top.forEach(updateRowHeight);
    this.eventSvc.dispatchEvent({
      type: "pinnedHeightChanged"
    });
    return anyChange;
  }
  getPinnedTopTotalHeight() {
    return getTotalHeight(this.top);
  }
  getPinnedBottomTotalHeight() {
    return getTotalHeight(this.bottom);
  }
  getPinnedTopRowCount() {
    return this.top.size();
  }
  getPinnedBottomRowCount() {
    return this.bottom.size();
  }
  getPinnedTopRow(index) {
    return this.top.getByIndex(index);
  }
  getPinnedBottomRow(index) {
    return this.bottom.getByIndex(index);
  }
  getPinnedRowById(id, floating) {
    return this.getContainer(floating).getById(id);
  }
  forEachPinnedRow(floating, callback) {
    this.getContainer(floating).forEach(callback);
  }
  getPinnedState() {
    const buildState = (floating) => {
      const list = [];
      this.forEachPinnedRow(floating, (node) => list.push(node.pinnedSibling.id));
      return list;
    };
    return {
      top: buildState("top"),
      bottom: buildState("bottom")
    };
  }
  setPinnedState(state) {
    this.forContainers((pinned, floating) => {
      for (const id of state[floating]) {
        const node = this.beans.rowModel.getRowNode(id);
        if (node) {
          this.pinRow(node, floating);
        } else {
          pinned.queue(id);
        }
      }
    });
  }
  getGrandTotalPinned() {
    return this._grandTotalPinned;
  }
  setGrandTotalPinned(value) {
    this._grandTotalPinned = value;
  }
  tryToEmptyQueues() {
    this.forContainers((pinned, container) => {
      const nodesToPin = /* @__PURE__ */ new Set();
      pinned.forEachQueued((id) => {
        const node = this.beans.rowModel.getRowNode(id);
        if (node) {
          nodesToPin.add(node);
        }
      });
      for (const node of nodesToPin) {
        pinned.unqueue(node.id);
        this.pinRow(node, container);
      }
    });
  }
  pinGrandTotalRow() {
    const { gos, beans, _grandTotalPinned: float } = this;
    const rowModel = beans.rowModel;
    if (!_isClientSideRowModel(gos, rowModel))
      return;
    const sibling = rowModel.rootNode?.sibling;
    if (!sibling)
      return;
    const pinnedSibling = sibling.pinnedSibling;
    const container = pinnedSibling && this.findPinnedRowNode(pinnedSibling);
    if (!float) {
      if (!container)
        return;
      container.delete(pinnedSibling);
      _destroyRowNodeSibling(pinnedSibling);
    } else {
      if (container && container.floating !== float) {
        container.delete(pinnedSibling);
        _destroyRowNodeSibling(pinnedSibling);
      }
      if (!container || container.floating !== float) {
        const newPinnedSibling = _createPinnedSibling(beans, sibling, float);
        this.getContainer(float).add(newPinnedSibling);
      }
    }
  }
  onGridStylesChanges(e) {
    if (e.rowHeightChanged) {
      this.forContainers(
        (container) => container.forEach((rowNode) => rowNode.setRowHeight(rowNode.rowHeight, true))
      );
    }
  }
  getContainer(floating) {
    return floating === "top" ? this.top : this.bottom;
  }
  findPinnedRowNode(node) {
    if (this.top.has(node))
      return this.top;
    if (this.bottom.has(node))
      return this.bottom;
  }
  refreshRowPositions(floating) {
    const refreshAll = (pinned) => refreshRowPositions(this.beans, pinned);
    return floating == null ? this.forContainers(refreshAll) : refreshAll(this.getContainer(floating));
  }
  forContainers(fn) {
    fn(this.top, "top");
    fn(this.bottom, "bottom");
  }
  dispatchRowPinnedEvents(node) {
    this.eventSvc.dispatchEvent({ type: "pinnedRowsChanged" });
    node?.dispatchRowEvent("rowPinned");
  }
};
function refreshRowPositions(beans, container) {
  let rowTop = 0;
  container.forEach((node, index) => {
    node.setRowTop(rowTop);
    if (node.rowHeightEstimated || node.rowHeight == null) {
      node.setRowHeight(_getRowHeightForNode(beans, node).height);
    }
    node.setRowIndex(index);
    rowTop += node.rowHeight;
  });
}
function _createPinnedSibling(beans, rowNode, floating) {
  if (rowNode.pinnedSibling) {
    return rowNode.pinnedSibling;
  }
  const sibling = _createRowNodeSibling(rowNode, beans);
  sibling.setRowTop(null);
  sibling.setRowIndex(null);
  sibling.rowPinned = floating;
  const prefix = floating === "top" ? ROW_ID_PREFIX_TOP_PINNED : ROW_ID_PREFIX_BOTTOM_PINNED;
  sibling.id = `${prefix}${floating}-${rowNode.id}`;
  sibling.pinnedSibling = rowNode;
  rowNode.pinnedSibling = sibling;
  return sibling;
}
function _destroyRowNodeSibling(rowNode) {
  if (!rowNode.pinnedSibling) {
    return;
  }
  rowNode.rowPinned = null;
  rowNode.setRowTop(null);
  rowNode.setRowIndex(null);
  const mainNode = rowNode.pinnedSibling;
  rowNode.pinnedSibling = void 0;
  if (mainNode) {
    mainNode.pinnedSibling = void 0;
    mainNode.rowPinned = null;
  }
}
function removeGroupRows(set) {
  const rowsToRemove = /* @__PURE__ */ new Set();
  set.forEach((node) => {
    if (node.group) {
      rowsToRemove.add(node);
    }
  });
  rowsToRemove.forEach((node) => set.delete(node));
}
function getSpannedRows(beans, rowNode, column) {
  const { rowSpanSvc } = beans;
  const isCellSpanning = (column && rowSpanSvc?.isCellSpanning(column, rowNode)) ?? false;
  if (column && isCellSpanning) {
    return rowSpanSvc?.getCellSpan(column, rowNode)?.spannedNodes;
  }
}
function getTotalHeight(container) {
  const size = container.size();
  if (size === 0)
    return 0;
  const node = container.getByIndex(size - 1);
  if (node === void 0)
    return 0;
  return node.rowTop + node.rowHeight;
}
function refreshCSRM({ gos, rowModel }) {
  if (_isClientSideRowModel(gos, rowModel)) {
    rowModel.refreshModel({ step: "map" });
  }
}

// packages/ag-grid-community/src/pinnedRowModel/staticPinnedRowModel.ts
var StaticPinnedRowModel = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.nextId = 0;
    this.pinnedTopRows = { cache: {}, order: [] };
    this.pinnedBottomRows = { cache: {}, order: [] };
  }
  postConstruct() {
    const gos = this.gos;
    this.setPinnedRowData(gos.get("pinnedTopRowData"), "top");
    this.setPinnedRowData(gos.get("pinnedBottomRowData"), "bottom");
    this.addManagedPropertyListener("pinnedTopRowData", (e) => this.setPinnedRowData(e.currentValue, "top"));
    this.addManagedPropertyListener("pinnedBottomRowData", (e) => this.setPinnedRowData(e.currentValue, "bottom"));
    this.addManagedEventListeners({ gridStylesChanged: this.onGridStylesChanges.bind(this) });
  }
  reset() {
  }
  isEmpty(floating) {
    return this.getCache(floating).order.length === 0;
  }
  isRowsToRender(floating) {
    return !this.isEmpty(floating);
  }
  isManual() {
    return false;
  }
  pinRow(_node, _container) {
  }
  onGridStylesChanges(e) {
    if (e.rowHeightChanged) {
      const estimateRowHeight = (rowNode) => {
        rowNode.setRowHeight(rowNode.rowHeight, true);
      };
      forEach(this.pinnedBottomRows, estimateRowHeight);
      forEach(this.pinnedTopRows, estimateRowHeight);
    }
  }
  ensureRowHeightsValid() {
    let anyChange = false;
    let rowTop = 0;
    const updateRowHeight = (rowNode) => {
      if (rowNode.rowHeightEstimated) {
        const rowHeight = _getRowHeightForNode(this.beans, rowNode);
        rowNode.setRowTop(rowTop);
        rowNode.setRowHeight(rowHeight.height);
        rowTop += rowHeight.height;
        anyChange = true;
      }
    };
    forEach(this.pinnedBottomRows, updateRowHeight);
    rowTop = 0;
    forEach(this.pinnedTopRows, updateRowHeight);
    this.eventSvc.dispatchEvent({
      type: "pinnedHeightChanged"
    });
    return anyChange;
  }
  setPinnedRowData(rowData, floating) {
    this.updateNodesFromRowData(rowData, floating);
    this.eventSvc.dispatchEvent({
      type: "pinnedRowDataChanged"
    });
  }
  /**
   * Updates existing RowNode instances and creates new ones if necessary
   *
   * Setting data as `undefined` will clear row nodes
   */
  updateNodesFromRowData(allData, floating) {
    const nodes = this.getCache(floating);
    if (allData === void 0) {
      nodes.order.length = 0;
      nodes.cache = {};
      return;
    }
    const getRowId = _getRowIdCallback(this.gos);
    const idPrefix = floating === "top" ? ROW_ID_PREFIX_TOP_PINNED : ROW_ID_PREFIX_BOTTOM_PINNED;
    const nodesToRemove = new Set(nodes.order);
    const newOrder = [];
    const dataIds = /* @__PURE__ */ new Set();
    let nextRowTop = 0;
    let i = -1;
    for (const data of allData) {
      const id = getRowId?.({ data, level: 0, rowPinned: floating }) ?? idPrefix + this.nextId++;
      if (dataIds.has(id)) {
        _warn(96, { id, data });
        continue;
      }
      i++;
      dataIds.add(id);
      newOrder.push(id);
      const existingNode = getById(nodes, id);
      if (existingNode !== void 0) {
        if (existingNode.data !== data) {
          existingNode.updateData(data);
        }
        nextRowTop += this.setRowTopAndRowIndex(existingNode, nextRowTop, i);
        nodesToRemove.delete(id);
      } else {
        const rowNode = new RowNode(this.beans);
        rowNode.id = id;
        rowNode.data = data;
        rowNode.rowPinned = floating;
        nextRowTop += this.setRowTopAndRowIndex(rowNode, nextRowTop, i);
        nodes.cache[id] = rowNode;
        nodes.order.push(id);
      }
    }
    nodesToRemove.forEach((id) => {
      getById(nodes, id)?.clearRowTopAndRowIndex();
      delete nodes.cache[id];
    });
    nodes.order = newOrder;
  }
  setRowTopAndRowIndex(rowNode, rowTop, rowIndex) {
    rowNode.setRowTop(rowTop);
    rowNode.setRowHeight(_getRowHeightForNode(this.beans, rowNode).height);
    rowNode.setRowIndex(rowIndex);
    return rowNode.rowHeight;
  }
  getPinnedTopTotalHeight() {
    return getTotalHeight2(this.pinnedTopRows);
  }
  getPinnedBottomTotalHeight() {
    return getTotalHeight2(this.pinnedBottomRows);
  }
  getPinnedTopRowCount() {
    return getSize(this.pinnedTopRows);
  }
  getPinnedBottomRowCount() {
    return getSize(this.pinnedBottomRows);
  }
  getPinnedTopRow(index) {
    return getByIndex(this.pinnedTopRows, index);
  }
  getPinnedBottomRow(index) {
    return getByIndex(this.pinnedBottomRows, index);
  }
  getPinnedRowById(id, floating) {
    return getById(this.getCache(floating), id);
  }
  forEachPinnedRow(floating, callback) {
    return forEach(this.getCache(floating), callback);
  }
  getCache(floating) {
    return floating === "top" ? this.pinnedTopRows : this.pinnedBottomRows;
  }
  getPinnedState() {
    return { top: [], bottom: [] };
  }
  setPinnedState() {
  }
  getGrandTotalPinned() {
    return;
  }
  setGrandTotalPinned() {
  }
};
function getTotalHeight2(rowNodes) {
  const size = getSize(rowNodes);
  if (size === 0) {
    return 0;
  }
  const node = getByIndex(rowNodes, size - 1);
  if (node === void 0) {
    return 0;
  }
  return node.rowTop + node.rowHeight;
}
function getById(cache, id) {
  return cache.cache[id];
}
function getByIndex(cache, i) {
  return getById(cache, cache.order[i]);
}
function forEach(cache, callback) {
  cache.order.forEach((id, index) => {
    const node = getById(cache, id);
    node && callback(node, index);
  });
}
function getSize(cache) {
  return cache.order.length;
}

// packages/ag-grid-community/src/pinnedRowModel/pinnedRowModel.ts
var PinnedRowModel = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "pinnedRowModel";
  }
  postConstruct() {
    const { gos } = this;
    const initialiseRowModel = () => {
      const enableRowPinning = gos.get("enableRowPinning");
      const grandTotalRow = _getGrandTotalRow(gos);
      const isGrandTotalRowPinned = grandTotalRow === "pinnedBottom" || grandTotalRow === "pinnedTop";
      const useManualPinnedRowModel = !!enableRowPinning || isGrandTotalRowPinned;
      const shouldDestroy = useManualPinnedRowModel ? this.inner instanceof StaticPinnedRowModel : this.inner instanceof ManualPinnedRowModel;
      if (this.inner && shouldDestroy) {
        this.destroyBean(this.inner);
      }
      if (shouldDestroy || !this.inner) {
        this.inner = this.createManagedBean(
          useManualPinnedRowModel ? new ManualPinnedRowModel() : new StaticPinnedRowModel()
        );
      }
    };
    this.addManagedPropertyListeners(["enableRowPinning", "grandTotalRow"], initialiseRowModel);
    initialiseRowModel();
  }
  reset() {
    return this.inner.reset();
  }
  isEmpty(container) {
    return this.inner.isEmpty(container);
  }
  isManual() {
    return this.inner.isManual();
  }
  isRowsToRender(container) {
    return this.inner.isRowsToRender(container);
  }
  pinRow(node, container, column) {
    return this.inner.pinRow(node, container, column);
  }
  ensureRowHeightsValid() {
    return this.inner.ensureRowHeightsValid();
  }
  getPinnedRowById(id, container) {
    return this.inner.getPinnedRowById(id, container);
  }
  getPinnedTopTotalHeight() {
    return this.inner.getPinnedTopTotalHeight();
  }
  getPinnedBottomTotalHeight() {
    return this.inner.getPinnedBottomTotalHeight();
  }
  getPinnedTopRowCount() {
    return this.inner.getPinnedTopRowCount();
  }
  getPinnedBottomRowCount() {
    return this.inner.getPinnedBottomRowCount();
  }
  getPinnedTopRow(index) {
    return this.inner.getPinnedTopRow(index);
  }
  getPinnedBottomRow(index) {
    return this.inner.getPinnedBottomRow(index);
  }
  forEachPinnedRow(container, callback) {
    return this.inner.forEachPinnedRow(container, callback);
  }
  getPinnedState() {
    return this.inner.getPinnedState();
  }
  setPinnedState(state) {
    return this.inner.setPinnedState(state);
  }
  setGrandTotalPinned(value) {
    return this.inner.setGrandTotalPinned(value);
  }
  getGrandTotalPinned() {
    return this.inner.getGrandTotalPinned();
  }
};

// packages/ag-grid-community/src/clientSideRowModel/abstractClientSideNodeManager.ts
var ROOT_NODE_ID = "ROOT_NODE_ID";
var AbstractClientSideNodeManager = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.nextId = 0;
    this.allNodesMap = {};
    this.rootNode = null;
  }
  getRowNode(id) {
    return this.allNodesMap[id];
  }
  extractRowData() {
    return this.rootNode?.allLeafChildren?.map((node) => node.data);
  }
  activate(rootNode) {
    this.rootNode = rootNode;
    rootNode.group = true;
    rootNode.level = -1;
    rootNode.id = ROOT_NODE_ID;
    rootNode.allLeafChildren = [];
    rootNode.childrenAfterGroup = [];
    rootNode.childrenAfterSort = [];
    rootNode.childrenAfterAggFilter = [];
    rootNode.childrenAfterFilter = [];
    this.updateRootSiblingArrays(rootNode);
  }
  deactivate() {
    if (this.rootNode) {
      this.allNodesMap = {};
      this.rootNode = null;
    }
  }
  destroy() {
    super.destroy();
    this.allNodesMap = {};
    this.rootNode = null;
  }
  setNewRowData(rowData) {
    const rootNode = this.rootNode;
    if (!rootNode) {
      return;
    }
    this.dispatchRowDataUpdateStartedEvent(rowData);
    rootNode.childrenAfterFilter = null;
    rootNode.childrenAfterGroup = null;
    rootNode.childrenAfterAggFilter = null;
    rootNode.childrenAfterSort = null;
    rootNode.childrenMapped = null;
    rootNode.updateHasChildren();
    this.allNodesMap = {};
    this.nextId = 0;
    this.loadNewRowData(rowData);
    this.updateRootSiblingArrays(rootNode);
  }
  updateRootSiblingArrays(rootNode) {
    const sibling = rootNode.sibling;
    if (sibling) {
      sibling.childrenAfterFilter = rootNode.childrenAfterFilter;
      sibling.childrenAfterGroup = rootNode.childrenAfterGroup;
      sibling.childrenAfterAggFilter = rootNode.childrenAfterAggFilter;
      sibling.childrenAfterSort = rootNode.childrenAfterSort;
      sibling.childrenMapped = rootNode.childrenMapped;
      sibling.allLeafChildren = rootNode.allLeafChildren;
    }
  }
  loadNewRowData(rowData) {
    this.rootNode.allLeafChildren = rowData?.map((dataItem, index) => this.createRowNode(dataItem, index)) ?? [];
  }
  setImmutableRowData(params, rowData) {
    const getRowIdFunc = _getRowIdCallback(this.gos);
    const reorder = !this.gos.get("suppressMaintainUnsortedOrder");
    const changedRowNodes = params.changedRowNodes;
    const processedNodes = /* @__PURE__ */ new Set();
    const rootNode = this.rootNode;
    const oldAllLeafChildren = rootNode.allLeafChildren;
    const oldAllLeafChildrenLen = oldAllLeafChildren.length;
    let nodesAdded = false;
    let nodesRemoved = false;
    let nodesUpdated = false;
    let orderChanged = false;
    for (let i = 0, prevSourceRowIndex = -1, len = rowData.length; i < len; i++) {
      const data = rowData[i];
      let node = this.getRowNode(
        getRowIdFunc({ data, level: 0 })
      );
      if (!node) {
        nodesAdded = true;
        node = this.createRowNode(data, -1);
        changedRowNodes.add(node);
      } else {
        if (reorder) {
          const sourceRowIndex = node.sourceRowIndex;
          orderChanged || (orderChanged = sourceRowIndex <= prevSourceRowIndex || // A node was moved up, so order changed
          nodesAdded);
          prevSourceRowIndex = sourceRowIndex;
        }
        if (node.data !== data) {
          nodesUpdated = true;
          node.updateData(data);
          changedRowNodes.update(node);
        }
      }
      processedNodes.add(node);
    }
    const nodesToUnselect = [];
    for (let i = 0; i < oldAllLeafChildrenLen; i++) {
      const node = oldAllLeafChildren[i];
      if (!processedNodes.has(node)) {
        nodesRemoved = true;
        if (node.isSelected()) {
          nodesToUnselect.push(node);
        }
        if (node.pinnedSibling) {
          this.beans.pinnedRowModel?.pinRow(node.pinnedSibling, null);
        }
        this.rowNodeDeleted(node);
        changedRowNodes.remove(node);
      }
    }
    if (nodesAdded || nodesRemoved || orderChanged) {
      const newAllLeafChildren = new Array(processedNodes.size);
      let writeIdx = 0;
      if (!reorder) {
        for (let i = 0; i < oldAllLeafChildrenLen; ++i) {
          const node = oldAllLeafChildren[i];
          if (processedNodes.delete(node)) {
            node.sourceRowIndex = writeIdx;
            newAllLeafChildren[writeIdx++] = node;
          }
        }
      }
      for (const node of processedNodes) {
        node.sourceRowIndex = writeIdx;
        newAllLeafChildren[writeIdx++] = node;
      }
      rootNode.allLeafChildren = newAllLeafChildren;
      const sibling = rootNode.sibling;
      if (sibling) {
        sibling.allLeafChildren = newAllLeafChildren;
      }
      params.rowNodesOrderChanged || (params.rowNodesOrderChanged = orderChanged);
    }
    if (nodesAdded || nodesRemoved || orderChanged || nodesUpdated) {
      this.deselectNodes(nodesToUnselect);
      params.rowDataUpdated = true;
    }
  }
  /** Called when a node needs to be deleted */
  rowNodeDeleted(node) {
    node.clearRowTopAndRowIndex();
    const id = node.id;
    const allNodesMap = this.allNodesMap;
    if (allNodesMap[id] === node) {
      delete allNodesMap[id];
    }
  }
  updateRowData(rowDataTran, changedRowNodes) {
    this.dispatchRowDataUpdateStartedEvent(rowDataTran.add);
    const updateRowDataResult = {
      changedRowNodes,
      rowNodeTransaction: { remove: [], update: [], add: [] },
      rowsInserted: false
    };
    const nodesToUnselect = [];
    const getRowIdFunc = _getRowIdCallback(this.gos);
    this.executeRemove(getRowIdFunc, rowDataTran, updateRowDataResult, nodesToUnselect);
    this.executeUpdate(getRowIdFunc, rowDataTran, updateRowDataResult, nodesToUnselect);
    this.executeAdd(rowDataTran, updateRowDataResult);
    this.deselectNodes(nodesToUnselect);
    return updateRowDataResult;
  }
  executeAdd(rowDataTran, result) {
    const add = rowDataTran.add;
    if (!add?.length) {
      return;
    }
    let allLeafChildren = this.rootNode.allLeafChildren;
    let addIndex = allLeafChildren.length;
    if (typeof rowDataTran.addIndex === "number") {
      addIndex = this.sanitizeAddIndex(rowDataTran.addIndex);
      if (addIndex > 0) {
        const getDataPath = this.gos.get("treeData") && this.gos.get("getDataPath");
        if (getDataPath) {
          for (let i = 0; i < allLeafChildren.length; i++) {
            const node = allLeafChildren[i];
            if (node?.rowIndex == addIndex - 1) {
              addIndex = i + 1;
              break;
            }
          }
        }
      }
    }
    const addLength = add.length;
    const changedRowNodes = result.changedRowNodes;
    const newNodes = new Array(addLength);
    for (let i = 0; i < addLength; i++) {
      const newNode = this.createRowNode(add[i], addIndex + i);
      changedRowNodes.add(newNode);
      newNodes[i] = newNode;
    }
    const rootNode = this.rootNode;
    if (addIndex < allLeafChildren.length) {
      const nodesBeforeIndex = allLeafChildren.slice(0, addIndex);
      const nodesAfterIndex = allLeafChildren.slice(addIndex, allLeafChildren.length);
      const nodesAfterIndexFirstIndex = nodesBeforeIndex.length + newNodes.length;
      for (let index = 0, length = nodesAfterIndex.length; index < length; ++index) {
        nodesAfterIndex[index].sourceRowIndex = nodesAfterIndexFirstIndex + index;
      }
      allLeafChildren = [...nodesBeforeIndex, ...newNodes, ...nodesAfterIndex];
      result.rowsInserted = true;
    } else {
      allLeafChildren = allLeafChildren.concat(newNodes);
    }
    rootNode.allLeafChildren = allLeafChildren;
    const sibling = rootNode.sibling;
    if (sibling) {
      sibling.allLeafChildren = allLeafChildren;
    }
    result.rowNodeTransaction.add = newNodes;
  }
  executeRemove(getRowIdFunc, rowDataTran, { changedRowNodes, rowNodeTransaction }, nodesToUnselect) {
    const { remove } = rowDataTran;
    if (!remove?.length) {
      return;
    }
    const rowIdsRemoved = {};
    remove.forEach((item) => {
      const rowNode = this.lookupRowNode(getRowIdFunc, item);
      if (!rowNode) {
        return;
      }
      if (rowNode.isSelected()) {
        nodesToUnselect.push(rowNode);
      }
      if (rowNode.pinnedSibling) {
        this.beans.pinnedRowModel?.pinRow(rowNode.pinnedSibling, null);
      }
      rowNode.clearRowTopAndRowIndex();
      rowIdsRemoved[rowNode.id] = true;
      delete this.allNodesMap[rowNode.id];
      rowNodeTransaction.remove.push(rowNode);
      changedRowNodes.remove(rowNode);
    });
    const rootNode = this.rootNode;
    rootNode.allLeafChildren = rootNode.allLeafChildren?.filter((rowNode) => !rowIdsRemoved[rowNode.id]) ?? null;
    rootNode.allLeafChildren?.forEach((node, idx) => {
      node.sourceRowIndex = idx;
    });
    const sibling = rootNode.sibling;
    if (sibling) {
      sibling.allLeafChildren = rootNode.allLeafChildren;
    }
  }
  executeUpdate(getRowIdFunc, rowDataTran, { changedRowNodes, rowNodeTransaction }, nodesToUnselect) {
    const { update } = rowDataTran;
    if (!update?.length) {
      return;
    }
    update.forEach((item) => {
      const rowNode = this.lookupRowNode(getRowIdFunc, item);
      if (!rowNode) {
        return;
      }
      rowNode.updateData(item);
      if (!rowNode.selectable && rowNode.isSelected()) {
        nodesToUnselect.push(rowNode);
      }
      rowNodeTransaction.update.push(rowNode);
      changedRowNodes.update(rowNode);
    });
  }
  dispatchRowDataUpdateStartedEvent(rowData) {
    this.eventSvc.dispatchEvent({
      type: "rowDataUpdateStarted",
      firstRowData: rowData?.length ? rowData[0] : null
    });
  }
  deselectNodes(nodesToUnselect) {
    const source = "rowDataChanged";
    const selectionSvc = this.beans.selectionSvc;
    const selectionChanged = nodesToUnselect.length > 0;
    if (selectionChanged) {
      selectionSvc?.setNodesSelected({
        newValue: false,
        nodes: nodesToUnselect,
        suppressFinishActions: true,
        source
      });
    }
    selectionSvc?.updateGroupsFromChildrenSelections?.(source);
    if (selectionChanged) {
      this.eventSvc.dispatchEvent({
        type: "selectionChanged",
        source,
        selectedNodes: selectionSvc?.getSelectedNodes() ?? null,
        serverSideState: null
      });
    }
  }
  sanitizeAddIndex(addIndex) {
    const allChildrenCount = this.rootNode.allLeafChildren?.length ?? 0;
    if (addIndex < 0 || addIndex >= allChildrenCount || Number.isNaN(addIndex)) {
      return allChildrenCount;
    }
    return Math.ceil(addIndex);
  }
  createRowNode(data, sourceRowIndex) {
    const node = new RowNode(this.beans);
    node.parent = this.rootNode;
    node.level = 0;
    node.group = false;
    node.expanded = false;
    node.sourceRowIndex = sourceRowIndex;
    node.setDataAndId(data, String(this.nextId));
    if (this.allNodesMap[node.id]) {
      _warn(2, { nodeId: node.id });
    }
    this.allNodesMap[node.id] = node;
    this.nextId++;
    return node;
  }
  lookupRowNode(getRowIdFunc, data) {
    let rowNode;
    if (getRowIdFunc) {
      const id = getRowIdFunc({ data, level: 0 });
      rowNode = this.allNodesMap[id];
      if (!rowNode) {
        _error(4, { id });
        return null;
      }
    } else {
      rowNode = this.rootNode?.allLeafChildren?.find((node) => node.data === data);
      if (!rowNode) {
        _error(5, { data });
        return null;
      }
    }
    return rowNode || null;
  }
};

// packages/ag-grid-community/src/interfaces/serverSideTransaction.ts
var ServerSideTransactionResultStatus = /* @__PURE__ */ ((ServerSideTransactionResultStatus2) => {
  ServerSideTransactionResultStatus2["Applied"] = "Applied";
  ServerSideTransactionResultStatus2["StoreNotFound"] = "StoreNotFound";
  ServerSideTransactionResultStatus2["StoreLoading"] = "StoreLoading";
  ServerSideTransactionResultStatus2["StoreWaitingToLoad"] = "StoreWaitingToLoad";
  ServerSideTransactionResultStatus2["StoreLoadingFailed"] = "StoreLoadingFailed";
  ServerSideTransactionResultStatus2["StoreWrongType"] = "StoreWrongType";
  ServerSideTransactionResultStatus2["Cancelled"] = "Cancelled";
  ServerSideTransactionResultStatus2["StoreNotStarted"] = "StoreNotStarted";
  return ServerSideTransactionResultStatus2;
})(ServerSideTransactionResultStatus || {});

// packages/ag-grid-community/src/selection/checkboxSelectionComponent.ts
var CheckboxSelectionComponentElement = {
  tag: "div",
  cls: "ag-selection-checkbox",
  role: "presentation",
  children: [
    {
      tag: "ag-checkbox",
      ref: "eCheckbox",
      role: "presentation"
    }
  ]
};
var CheckboxSelectionComponent = class extends Component {
  constructor() {
    super(CheckboxSelectionComponentElement, [AgCheckboxSelector]);
    this.eCheckbox = RefPlaceholder;
  }
  postConstruct() {
    this.eCheckbox.setPassive(true);
  }
  onDataChanged() {
    this.onSelectionChanged();
  }
  onSelectableChanged() {
    this.showOrHideSelect();
  }
  onSelectionChanged() {
    const translate = this.getLocaleTextFunc();
    const { rowNode, eCheckbox } = this;
    const state = rowNode.isSelected();
    const stateName = _getAriaCheckboxStateName(translate, state);
    const [ariaKey, ariaLabel] = rowNode.selectable ? ["ariaRowToggleSelection", "Press Space to toggle row selection"] : ["ariaRowSelectionDisabled", "Row Selection is disabled for this row"];
    const translatedLabel = translate(ariaKey, ariaLabel);
    eCheckbox.setValue(state, true);
    eCheckbox.setInputAriaLabel(`${translatedLabel} (${stateName})`);
  }
  init(params) {
    this.rowNode = params.rowNode;
    this.column = params.column;
    this.overrides = params.overrides;
    this.onSelectionChanged();
    this.addManagedListeners(this.eCheckbox.getInputElement(), {
      // we don't want double click on this icon to open a group
      dblclick: _stopPropagationForAgGrid,
      click: (event) => {
        _stopPropagationForAgGrid(event);
        this.beans.selectionSvc?.handleSelectionEvent(event, this.rowNode, "checkboxSelected");
      }
    });
    this.addManagedListeners(this.rowNode, {
      rowSelected: this.onSelectionChanged.bind(this),
      dataChanged: this.onDataChanged.bind(this),
      selectableChanged: this.onSelectableChanged.bind(this)
    });
    this.addManagedPropertyListener("rowSelection", ({ currentValue, previousValue }) => {
      const curr = typeof currentValue === "object" ? _getHideDisabledCheckboxes(currentValue) : void 0;
      const prev = typeof previousValue === "object" ? _getHideDisabledCheckboxes(previousValue) : void 0;
      if (curr !== prev) {
        this.onSelectableChanged();
      }
    });
    const isRowSelectableFunc = _getIsRowSelectable(this.gos);
    const checkboxVisibleIsDynamic = isRowSelectableFunc || typeof this.getIsVisible() === "function";
    if (checkboxVisibleIsDynamic) {
      const showOrHideSelectListener = this.showOrHideSelect.bind(this);
      this.addManagedEventListeners({ displayedColumnsChanged: showOrHideSelectListener });
      this.addManagedListeners(this.rowNode, {
        dataChanged: showOrHideSelectListener,
        cellChanged: showOrHideSelectListener
      });
      this.showOrHideSelect();
    }
    this.eCheckbox.getInputElement().setAttribute("tabindex", "-1");
  }
  showOrHideSelect() {
    const { column, rowNode, overrides, gos } = this;
    const selectable = rowNode.selectable;
    const isVisible = this.getIsVisible();
    let checkboxes = void 0;
    if (typeof isVisible === "function") {
      const extraParams = overrides?.callbackParams;
      if (!column) {
        checkboxes = isVisible({ ...extraParams, node: rowNode, data: rowNode.data });
      } else {
        const params = column.createColumnFunctionCallbackParams(rowNode);
        checkboxes = isVisible({ ...extraParams, ...params });
      }
    } else {
      checkboxes = isVisible ?? false;
    }
    const disabled = selectable && !checkboxes || !selectable && checkboxes;
    const visible = selectable || checkboxes;
    const so = gos.get("rowSelection");
    const showDisabledCheckboxes = so && typeof so !== "string" ? !_getHideDisabledCheckboxes(so) : !!column?.getColDef().showDisabledCheckboxes;
    this.setVisible(visible && (disabled ? showDisabledCheckboxes : true));
    this.setDisplayed(visible && (disabled ? showDisabledCheckboxes : true));
    if (visible) {
      this.eCheckbox.setDisabled(disabled);
    }
    if (overrides?.removeHidden) {
      this.setDisplayed(visible);
      return;
    }
  }
  getIsVisible() {
    const overrides = this.overrides;
    if (overrides) {
      return overrides.isVisible;
    }
    const so = this.gos.get("rowSelection");
    if (so && typeof so !== "string") {
      return _getCheckboxes(so);
    }
    return this.column?.getColDef()?.checkboxSelection;
  }
};

// packages/ag-grid-community/src/selection/rowRangeSelectionContext.ts
var RowRangeSelectionContext = class {
  constructor(rowModel, pinnedRowModel) {
    this.rowModel = rowModel;
    this.pinnedRowModel = pinnedRowModel;
    /** Whether the user is currently selecting all nodes either via the header checkbox or API */
    this.selectAll = false;
    this.rootId = null;
    /**
     * Note that the "end" `RowNode` may come before or after the "root" `RowNode` in the
     * actual grid.
     */
    this.endId = null;
    this.cachedRange = [];
  }
  reset() {
    this.rootId = null;
    this.endId = null;
    this.cachedRange.length = 0;
  }
  setRoot(node) {
    this.rootId = node.id;
    this.endId = null;
    this.cachedRange.length = 0;
  }
  setEndRange(end) {
    this.endId = end.id;
    this.cachedRange.length = 0;
  }
  getRange() {
    if (this.cachedRange.length === 0) {
      const root = this.getRoot();
      const end = this.getEnd();
      if (root == null || end == null) {
        return this.cachedRange;
      }
      this.cachedRange = this.getNodesInRange(root, end) ?? [];
    }
    return this.cachedRange;
  }
  isInRange(node) {
    if (this.rootId === null) {
      return false;
    }
    return this.getRange().some((nodeInRange) => nodeInRange.id === node.id);
  }
  getRoot(fallback) {
    if (this.rootId) {
      return this.getRowNode(this.rootId);
    }
    if (fallback) {
      this.setRoot(fallback);
      return fallback;
    }
  }
  getEnd() {
    if (this.endId) {
      return this.getRowNode(this.endId);
    }
  }
  getRowNode(id) {
    let node;
    const { rowModel, pinnedRowModel } = this;
    node ?? (node = rowModel.getRowNode(id));
    if (pinnedRowModel?.isManual()) {
      node ?? (node = pinnedRowModel.getPinnedRowById(id, "top"));
      node ?? (node = pinnedRowModel.getPinnedRowById(id, "bottom"));
    }
    return node;
  }
  /**
   * Truncates the range to the given node (assumed to be within the current range).
   * Returns nodes that remain in the current range and those that should be removed
   *
   * @param node - Node at which to truncate the range
   * @returns Object of nodes to either keep or discard (i.e. deselect) from the range
   */
  truncate(node) {
    const range = this.getRange();
    if (range.length === 0) {
      return { keep: [], discard: [] };
    }
    const discardAfter = range[0].id === this.rootId;
    const idx = range.findIndex((rowNode) => rowNode.id === node.id);
    if (idx > -1) {
      const above = range.slice(0, idx);
      const below = range.slice(idx + 1);
      this.setEndRange(node);
      return discardAfter ? { keep: above, discard: below } : { keep: below, discard: above };
    } else {
      return { keep: range, discard: [] };
    }
  }
  /**
   * Extends the range to the given node. Returns nodes that remain in the current range
   * and those that should be removed.
   *
   * @param node - Node marking the new end of the range
   * @returns Object of nodes to either keep or discard (i.e. deselect) from the range
   */
  extend(node, groupSelectsChildren = false) {
    const root = this.getRoot();
    if (root == null) {
      const keep = this.getRange().slice();
      if (groupSelectsChildren) {
        node.depthFirstSearch((node2) => !node2.group && keep.push(node2));
      }
      keep.push(node);
      this.setRoot(node);
      return { keep, discard: [] };
    }
    const newRange = this.getNodesInRange(root, node);
    if (!newRange) {
      this.setRoot(node);
      return { keep: [node], discard: [] };
    }
    if (newRange.find((newRangeNode) => newRangeNode.id === this.endId)) {
      this.setEndRange(node);
      return { keep: this.getRange(), discard: [] };
    } else {
      const discard = this.getRange().slice();
      this.setEndRange(node);
      return { keep: this.getRange(), discard };
    }
  }
  getNodesInRange(start, end) {
    const { pinnedRowModel, rowModel } = this;
    if (!pinnedRowModel?.isManual()) {
      return rowModel.getNodesInRangeForSelection(start, end);
    }
    if (start.rowPinned === "top" && !end.rowPinned) {
      const pinnedRange = _getNodesInRangeForSelection(pinnedRowModel, "top", start, void 0);
      return pinnedRange.concat(rowModel.getNodesInRangeForSelection(rowModel.getRow(0), end) ?? []);
    }
    if (start.rowPinned === "bottom" && !end.rowPinned) {
      const pinnedRange = _getNodesInRangeForSelection(pinnedRowModel, "bottom", void 0, start);
      const count = rowModel.getRowCount();
      const lastMain = rowModel.getRow(count - 1);
      return (rowModel.getNodesInRangeForSelection(end, lastMain) ?? []).concat(pinnedRange);
    }
    if (!start.rowPinned && !end.rowPinned) {
      return rowModel.getNodesInRangeForSelection(start, end);
    }
    if (start.rowPinned === "top" && end.rowPinned === "top") {
      return _getNodesInRangeForSelection(pinnedRowModel, "top", start, end);
    }
    if (start.rowPinned === "bottom" && end.rowPinned === "top") {
      const top = _getNodesInRangeForSelection(pinnedRowModel, "top", end, void 0);
      const bottom = _getNodesInRangeForSelection(pinnedRowModel, "bottom", void 0, start);
      const first = rowModel.getRow(0);
      const last = rowModel.getRow(rowModel.getRowCount() - 1);
      return top.concat(rowModel.getNodesInRangeForSelection(first, last) ?? []).concat(bottom);
    }
    if (!start.rowPinned && end.rowPinned === "top") {
      const pinned = _getNodesInRangeForSelection(pinnedRowModel, "top", end, void 0);
      return pinned.concat(rowModel.getNodesInRangeForSelection(rowModel.getRow(0), start) ?? []);
    }
    if (start.rowPinned === "top" && end.rowPinned === "bottom") {
      const top = _getNodesInRangeForSelection(pinnedRowModel, "top", start, void 0);
      const bottom = _getNodesInRangeForSelection(pinnedRowModel, "bottom", void 0, end);
      const first = rowModel.getRow(0);
      const last = rowModel.getRow(rowModel.getRowCount() - 1);
      return top.concat(rowModel.getNodesInRangeForSelection(first, last) ?? []).concat(bottom);
    }
    if (start.rowPinned === "bottom" && end.rowPinned === "bottom") {
      return _getNodesInRangeForSelection(pinnedRowModel, "bottom", start, end);
    }
    if (!start.rowPinned && end.rowPinned === "bottom") {
      const pinned = _getNodesInRangeForSelection(pinnedRowModel, "bottom", void 0, end);
      const last = rowModel.getRow(rowModel.getRowCount());
      return (rowModel.getNodesInRangeForSelection(start, last) ?? []).concat(pinned);
    }
    return null;
  }
};

// packages/ag-grid-community/src/selection/selectAllFeature.ts
var SelectAllFeature = class extends BeanStub {
  constructor(column) {
    super();
    this.column = column;
    this.cbSelectAllVisible = false;
    this.processingEventFromCheckbox = false;
  }
  onSpaceKeyDown(e) {
    const checkbox = this.cbSelectAll;
    if (checkbox.isDisplayed() && !checkbox.getGui().contains(_getActiveDomElement(this.beans))) {
      e.preventDefault();
      checkbox.setValue(!checkbox.getValue());
    }
  }
  getCheckboxGui() {
    return this.cbSelectAll.getGui();
  }
  setComp(ctrl) {
    this.headerCellCtrl = ctrl;
    const cbSelectAll = this.createManagedBean(new AgCheckbox());
    this.cbSelectAll = cbSelectAll;
    cbSelectAll.addCss("ag-header-select-all");
    _setAriaRole(cbSelectAll.getGui(), "presentation");
    this.showOrHideSelectAll();
    const updateStateOfCheckbox = this.updateStateOfCheckbox.bind(this);
    this.addManagedEventListeners({
      newColumnsLoaded: () => this.showOrHideSelectAll(),
      displayedColumnsChanged: this.onDisplayedColumnsChanged.bind(this),
      selectionChanged: updateStateOfCheckbox,
      paginationChanged: updateStateOfCheckbox,
      modelUpdated: updateStateOfCheckbox
    });
    this.addManagedPropertyListener("rowSelection", ({ currentValue, previousValue }) => {
      const getSelectAll = (rowSelection) => typeof rowSelection === "string" || !rowSelection || rowSelection.mode === "singleRow" ? void 0 : rowSelection.selectAll;
      if (getSelectAll(currentValue) !== getSelectAll(previousValue)) {
        this.showOrHideSelectAll();
      }
      this.updateStateOfCheckbox();
    });
    this.addManagedListeners(cbSelectAll, { fieldValueChanged: this.onCbSelectAll.bind(this) });
    cbSelectAll.getInputElement().setAttribute("tabindex", "-1");
    this.refreshSelectAllLabel();
  }
  onDisplayedColumnsChanged(e) {
    if (!this.isAlive()) {
      return;
    }
    this.showOrHideSelectAll(e.source === "uiColumnMoved");
  }
  showOrHideSelectAll(fromColumnMoved = false) {
    const cbSelectAllVisible = this.isCheckboxSelection();
    this.cbSelectAllVisible = cbSelectAllVisible;
    this.cbSelectAll.setDisplayed(cbSelectAllVisible);
    if (cbSelectAllVisible) {
      this.checkRightRowModelType("selectAllCheckbox");
      this.checkSelectionType("selectAllCheckbox");
      this.updateStateOfCheckbox();
    }
    this.refreshSelectAllLabel(fromColumnMoved);
  }
  updateStateOfCheckbox() {
    if (!this.cbSelectAllVisible || this.processingEventFromCheckbox) {
      return;
    }
    this.processingEventFromCheckbox = true;
    const selectAllMode = this.getSelectAllMode();
    const selectionSvc = this.beans.selectionSvc;
    const cbSelectAll = this.cbSelectAll;
    const allSelected = selectionSvc.getSelectAllState(selectAllMode);
    cbSelectAll.setValue(allSelected);
    const hasNodesToSelect = selectionSvc.hasNodesToSelect(selectAllMode);
    cbSelectAll.setDisabled(!hasNodesToSelect);
    this.refreshSelectAllLabel();
    this.processingEventFromCheckbox = false;
  }
  refreshSelectAllLabel(fromColumnMoved = false) {
    const translate = this.getLocaleTextFunc();
    const { headerCellCtrl, cbSelectAll, cbSelectAllVisible } = this;
    const checked = cbSelectAll.getValue();
    const ariaStatus = _getAriaCheckboxStateName(translate, checked);
    const ariaLabel = translate("ariaRowSelectAll", "Press Space to toggle all rows selection");
    headerCellCtrl.setAriaDescriptionProperty(
      "selectAll",
      cbSelectAllVisible ? `${ariaLabel} (${ariaStatus})` : null
    );
    cbSelectAll.setInputAriaLabel(translate("ariaHeaderSelection", "Column with Header Selection"));
    if (!fromColumnMoved) {
      headerCellCtrl.announceAriaDescription();
    }
  }
  checkSelectionType(feature) {
    const isMultiSelect = _isMultiRowSelection(this.gos);
    if (!isMultiSelect) {
      _warn(128, { feature });
      return false;
    }
    return true;
  }
  checkRightRowModelType(feature) {
    const { gos, rowModel } = this.beans;
    const rowModelMatches = _isClientSideRowModel(gos) || _isServerSideRowModel(gos);
    if (!rowModelMatches) {
      _warn(129, { feature, rowModel: rowModel.getType() });
      return false;
    }
    return true;
  }
  onCbSelectAll() {
    if (this.processingEventFromCheckbox) {
      return;
    }
    if (!this.cbSelectAllVisible) {
      return;
    }
    const value = this.cbSelectAll.getValue();
    const selectAll2 = this.getSelectAllMode();
    let source = "uiSelectAll";
    if (selectAll2 === "currentPage") {
      source = "uiSelectAllCurrentPage";
    } else if (selectAll2 === "filtered") {
      source = "uiSelectAllFiltered";
    }
    const params = { source, selectAll: selectAll2 };
    const selectionSvc = this.beans.selectionSvc;
    if (value) {
      selectionSvc.selectAllRowNodes(params);
    } else {
      selectionSvc.deselectAllRowNodes(params);
    }
  }
  /**
   * Checkbox is enabled when either the `headerCheckbox` option is enabled in the new selection API
   * or `headerCheckboxSelection` is enabled in the legacy API.
   */
  isCheckboxSelection() {
    const { column, gos, beans } = this;
    const rowSelection = gos.get("rowSelection");
    const newHeaderCheckbox = typeof rowSelection === "object";
    const featureName = newHeaderCheckbox ? "headerCheckbox" : "headerCheckboxSelection";
    return isCheckboxSelection(beans, column) && this.checkRightRowModelType(featureName) && this.checkSelectionType(featureName);
  }
  getSelectAllMode() {
    const selectAll2 = _getSelectAll(this.gos, false);
    if (selectAll2) {
      return selectAll2;
    }
    const { headerCheckboxSelectionCurrentPageOnly, headerCheckboxSelectionFilteredOnly } = this.column.getColDef();
    if (headerCheckboxSelectionCurrentPageOnly) {
      return "currentPage";
    }
    if (headerCheckboxSelectionFilteredOnly) {
      return "filtered";
    }
    return "all";
  }
  destroy() {
    super.destroy();
    this.cbSelectAll = void 0;
    this.headerCellCtrl = void 0;
  }
};
function isCheckboxSelection({ gos, selectionColSvc }, column) {
  const rowSelection = gos.get("rowSelection");
  const colDef = column.getColDef();
  const { headerCheckboxSelection } = colDef;
  let result = false;
  const newHeaderCheckbox = typeof rowSelection === "object";
  if (newHeaderCheckbox) {
    const isSelectionCol = isColumnSelectionCol(column);
    const isAutoCol = isColumnGroupAutoCol(column);
    const location = _getCheckboxLocation(rowSelection);
    if (location === "autoGroupColumn" && isAutoCol || isSelectionCol && selectionColSvc?.isSelectionColumnEnabled()) {
      result = _getHeaderCheckbox(rowSelection);
    }
  } else {
    if (typeof headerCheckboxSelection === "function") {
      result = headerCheckboxSelection(_addGridCommonParams(gos, { column, colDef }));
    } else {
      result = !!headerCheckboxSelection;
    }
  }
  return result;
}

// packages/ag-grid-community/src/selection/baseSelectionService.ts
var BaseSelectionService = class extends BeanStub {
  postConstruct() {
    const { gos, beans } = this;
    this.selectionCtx = new RowRangeSelectionContext(beans.rowModel, beans.pinnedRowModel);
    this.addManagedPropertyListeners(["isRowSelectable", "rowSelection"], () => {
      const callback = _getIsRowSelectable(gos);
      if (callback !== this.isRowSelectable) {
        this.isRowSelectable = callback;
        this.updateSelectable();
      }
    });
    this.isRowSelectable = _getIsRowSelectable(gos);
    this.addManagedEventListeners({
      cellValueChanged: (e) => this.updateRowSelectable(e.node),
      rowNodeDataChanged: (e) => this.updateRowSelectable(e.node)
    });
  }
  destroy() {
    super.destroy();
    this.selectionCtx.reset();
  }
  createCheckboxSelectionComponent() {
    return new CheckboxSelectionComponent();
  }
  createSelectAllFeature(column) {
    if (isCheckboxSelection(this.beans, column)) {
      return new SelectAllFeature(column);
    }
  }
  isMultiSelect() {
    return _isMultiRowSelection(this.gos);
  }
  onRowCtrlSelected(rowCtrl, hasFocusFunc, gui) {
    const selected = !!rowCtrl.rowNode.isSelected();
    rowCtrl.forEachGui(gui, (gui2) => {
      gui2.rowComp.toggleCss("ag-row-selected", selected);
      const element = gui2.element;
      _setAriaSelected(element, selected);
      const hasFocus = element.contains(_getActiveDomElement(this.beans));
      if (hasFocus) {
        hasFocusFunc(gui2);
      }
    });
  }
  announceAriaRowSelection(rowNode) {
    if (this.isRowSelectionBlocked(rowNode)) {
      return;
    }
    const selected = rowNode.isSelected();
    if (!rowNode.selectable) {
      return;
    }
    const translate = this.getLocaleTextFunc();
    const label = translate(
      selected ? "ariaRowDeselect" : "ariaRowSelect",
      `Press SPACE to ${selected ? "deselect" : "select"} this row`
    );
    this.beans.ariaAnnounce?.announceValue(label, "rowSelection");
  }
  isRowSelectionBlocked(rowNode) {
    return !rowNode.selectable || rowNode.rowPinned && !_isManualPinnedRow(rowNode) || !_isRowSelection(this.gos);
  }
  updateRowSelectable(rowNode, suppressSelectionUpdate) {
    const selectable = rowNode.rowPinned && rowNode.pinnedSibling ? (
      // If row node is pinned sibling, copy selectable status over from sibling row node
      rowNode.pinnedSibling.selectable
    ) : (
      // otherwise calculate selectable state directly
      this.isRowSelectable?.(rowNode) ?? true
    );
    this.setRowSelectable(rowNode, selectable, suppressSelectionUpdate);
    return selectable;
  }
  setRowSelectable(rowNode, newVal, suppressSelectionUpdate) {
    if (rowNode.selectable !== newVal) {
      rowNode.selectable = newVal;
      rowNode.dispatchRowEvent("selectableChanged");
      if (suppressSelectionUpdate) {
        return;
      }
      const isGroupSelectsChildren = _getGroupSelectsDescendants(this.gos);
      if (isGroupSelectsChildren) {
        const selected = this.calculateSelectedFromChildren(rowNode);
        this.setNodesSelected({ nodes: [rowNode], newValue: selected ?? false, source: "selectableChanged" });
        return;
      }
      if (rowNode.isSelected() && !rowNode.selectable) {
        this.setNodesSelected({ nodes: [rowNode], newValue: false, source: "selectableChanged" });
      }
    }
  }
  calculateSelectedFromChildren(rowNode) {
    let atLeastOneSelected = false;
    let atLeastOneDeSelected = false;
    if (!rowNode.childrenAfterGroup?.length) {
      return rowNode.selectable ? rowNode.__selected : null;
    }
    for (let i = 0; i < rowNode.childrenAfterGroup.length; i++) {
      const child = rowNode.childrenAfterGroup[i];
      let childState = child.isSelected();
      if (!child.selectable) {
        const selectable = this.calculateSelectedFromChildren(child);
        if (selectable === null) {
          continue;
        }
        childState = selectable;
      }
      switch (childState) {
        case true:
          atLeastOneSelected = true;
          break;
        case false:
          atLeastOneDeSelected = true;
          break;
        default:
          return void 0;
      }
    }
    if (atLeastOneSelected && atLeastOneDeSelected) {
      return void 0;
    }
    if (atLeastOneSelected) {
      return true;
    }
    if (atLeastOneDeSelected) {
      return false;
    }
    if (!rowNode.selectable) {
      return null;
    }
    return rowNode.__selected;
  }
  selectRowNode(rowNode, newValue, e, source = "api") {
    const selectionNotAllowed = !rowNode.selectable && newValue;
    const selectionNotChanged = rowNode.__selected === newValue;
    if (selectionNotAllowed || selectionNotChanged) {
      return false;
    }
    rowNode.__selected = newValue;
    rowNode.dispatchRowEvent("rowSelected");
    const sibling = rowNode.sibling;
    if (sibling && sibling.footer && sibling.__localEventService) {
      sibling.dispatchRowEvent("rowSelected");
    }
    const pinnedSibling = rowNode.pinnedSibling;
    if (pinnedSibling && pinnedSibling.rowPinned && pinnedSibling.__localEventService) {
      pinnedSibling.dispatchRowEvent("rowSelected");
    }
    this.eventSvc.dispatchEvent({
      ..._createGlobalRowEvent(rowNode, this.gos, "rowSelected"),
      event: e || null,
      source
    });
    return true;
  }
  isCellCheckboxSelection(column, rowNode) {
    const so = this.gos.get("rowSelection");
    if (so && typeof so !== "string") {
      const checkbox = isColumnSelectionCol(column) && _getCheckboxes(so);
      return column.isColumnFunc(rowNode, checkbox);
    } else {
      return column.isColumnFunc(rowNode, column.colDef.checkboxSelection);
    }
  }
  inferNodeSelections(node, shiftKey, metaKey, source) {
    const { gos, selectionCtx } = this;
    const currentSelection = node.isSelected();
    const groupSelectsDescendants = _getGroupSelectsDescendants(gos);
    const enableClickSelection = _getEnableSelection(gos);
    const enableDeselection = _getEnableDeselection(gos);
    const isMultiSelect = this.isMultiSelect();
    const isRowClicked = source === "rowClicked";
    if (isRowClicked && !(enableClickSelection || enableDeselection))
      return null;
    if (shiftKey && metaKey && isMultiSelect) {
      const root = selectionCtx.getRoot();
      if (!root) {
        return null;
      } else if (!root.isSelected()) {
        const partition = selectionCtx.extend(node, groupSelectsDescendants);
        return {
          select: [],
          deselect: partition.keep,
          reset: false
        };
      } else {
        const partition = selectionCtx.isInRange(node) ? selectionCtx.truncate(node) : selectionCtx.extend(node, groupSelectsDescendants);
        return {
          deselect: partition.discard,
          select: partition.keep,
          reset: false
        };
      }
    } else if (shiftKey && isMultiSelect) {
      const fallback = selectionCtx.selectAll ? this.beans.rowModel.getRow(0) : void 0;
      const root = selectionCtx.getRoot(fallback);
      const partition = selectionCtx.isInRange(node) ? selectionCtx.truncate(node) : selectionCtx.extend(node, groupSelectsDescendants);
      return {
        select: partition.keep,
        deselect: partition.discard,
        reset: selectionCtx.selectAll || !!(root && !root.isSelected())
      };
    } else if (metaKey) {
      if (isRowClicked) {
        const newValue = !currentSelection;
        const selectingWhenDisabled = newValue && !enableClickSelection;
        const deselectingWhenDisabled = !newValue && !enableDeselection;
        if (selectingWhenDisabled || deselectingWhenDisabled)
          return null;
        selectionCtx.setRoot(node);
        return {
          node,
          newValue,
          clearSelection: false
        };
      }
      selectionCtx.setRoot(node);
      return {
        node,
        newValue: !currentSelection,
        clearSelection: !isMultiSelect
      };
    } else {
      selectionCtx.setRoot(node);
      const enableSelectionWithoutKeys = _getEnableSelectionWithoutKeys(gos);
      const groupSelectsFiltered = _getGroupSelection(gos) === "filteredDescendants";
      const shouldClear = isRowClicked && (!enableSelectionWithoutKeys || !enableClickSelection);
      if (groupSelectsFiltered && currentSelection === void 0 && _isClientSideRowModel(gos)) {
        return {
          node,
          newValue: false,
          clearSelection: !isMultiSelect || shouldClear
        };
      }
      if (isRowClicked) {
        const newValue = currentSelection ? !enableSelectionWithoutKeys : enableClickSelection;
        const selectingWhenDisabled = newValue && !enableClickSelection;
        const deselectingWhenDisabled = !newValue && !enableDeselection;
        const wouldStateBeUnchanged = newValue === currentSelection && !shouldClear;
        if (wouldStateBeUnchanged || selectingWhenDisabled || deselectingWhenDisabled)
          return null;
        return {
          node,
          newValue,
          clearSelection: !isMultiSelect || shouldClear,
          keepDescendants: node.group && groupSelectsDescendants
        };
      }
      return {
        node,
        newValue: !currentSelection,
        clearSelection: !isMultiSelect || shouldClear
      };
    }
  }
};

// packages/ag-grid-community/src/widgets/agRadioButton.ts
var AgRadioButton = class extends AgCheckbox {
  constructor(config) {
    super(config, "ag-radio-button", "radio");
  }
  isSelected() {
    return this.eInput.checked;
  }
  toggle() {
    if (this.eInput.disabled) {
      return;
    }
    if (!this.isSelected()) {
      this.setValue(true);
    }
  }
  addInputListeners() {
    super.addInputListeners();
    this.addManagedEventListeners({ checkboxChanged: this.onChange.bind(this) });
  }
  /**
   * This ensures that if another radio button in the same named group is selected, we deselect this radio button.
   * By default the browser does this for you, but we are managing classes ourselves in order to ensure input
   * elements are styled correctly in IE11, and the DOM 'changed' event is only fired when a button is selected,
   * not deselected, so we need to use our own event.
   */
  onChange(event) {
    const eInput = this.eInput;
    if (event.selected && event.name && eInput.name && eInput.name === event.name && event.id && eInput.id !== event.id) {
      this.setValue(false, true);
    }
  }
};

// packages/ag-grid-community/src/widgets/agToggleButton.css-GENERATED.ts
var agToggleButtonCSS = (
  /*css*/
  `.ag-toggle-button{flex:none;min-width:unset;width:unset}.ag-toggle-button-input-wrapper{background-color:var(--ag-toggle-button-off-background-color);border-radius:calc(var(--ag-toggle-button-height)*.5);flex:none;height:var(--ag-toggle-button-height);max-width:var(--ag-toggle-button-width);min-width:var(--ag-toggle-button-width);position:relative;transition:background-color .1s;:where(.ag-toggle-button-input){-webkit-appearance:none;-moz-appearance:none;appearance:none;cursor:pointer;display:block;height:var(--ag-toggle-button-height);margin:0;max-width:var(--ag-toggle-button-width);min-width:var(--ag-toggle-button-width);opacity:0}&:before{background-color:var(--ag-toggle-button-switch-background-color);border-radius:100%;content:"";display:block;height:calc(var(--ag-toggle-button-height) - var(--ag-toggle-button-switch-inset)*2);left:var(--ag-toggle-button-switch-inset);pointer-events:none;position:absolute;top:var(--ag-toggle-button-switch-inset);transition:left .1s;width:calc(var(--ag-toggle-button-height) - var(--ag-toggle-button-switch-inset)*2)}&.ag-checked{background-color:var(--ag-toggle-button-on-background-color);&:before{left:calc(100% - var(--ag-toggle-button-height) + var(--ag-toggle-button-switch-inset))}}&:focus-within{box-shadow:var(--ag-focus-shadow)}&.ag-disabled{opacity:.5}}`
);

// packages/ag-grid-community/src/widgets/agToggleButton.ts
var AgToggleButton = class extends AgCheckbox {
  constructor(config) {
    super(config, "ag-toggle-button");
    this.registerCSS(agToggleButtonCSS);
  }
  setValue(value, silent) {
    super.setValue(value, silent);
    this.toggleCss("ag-selected", this.getValue());
    return this;
  }
};
var AgToggleButtonSelector = {
  selector: "AG-TOGGLE-BUTTON",
  component: AgToggleButton
};

// packages/ag-grid-community/src/widgets/agInputTextField.ts
var AgInputTextField = class extends AgAbstractInputField {
  constructor(config, className = "ag-text-field", inputType = "text") {
    super(config, className, inputType);
  }
  postConstruct() {
    super.postConstruct();
    if (this.config.allowedCharPattern) {
      this.preventDisallowedCharacters();
    }
  }
  setValue(value, silent) {
    const eInput = this.eInput;
    if (eInput.value !== value) {
      eInput.value = _exists(value) ? value : "";
    }
    return super.setValue(value, silent);
  }
  /** Used to set an initial value into the input without necessarily setting `this.value` or triggering events (e.g. to set an invalid value) */
  setStartValue(value) {
    this.setValue(value, true);
  }
  preventDisallowedCharacters() {
    const pattern = new RegExp(`[${this.config.allowedCharPattern}]`);
    const preventCharacters = (event) => {
      if (!_isEventFromPrintableCharacter(event)) {
        return;
      }
      if (event.key && !pattern.test(event.key)) {
        event.preventDefault();
      }
    };
    this.addManagedListeners(this.eInput, {
      keydown: preventCharacters,
      paste: (e) => {
        const text = e.clipboardData?.getData("text");
        if (text && text.split("").some((c) => !pattern.test(c))) {
          e.preventDefault();
        }
      }
    });
  }
};
var AgInputTextFieldSelector = {
  selector: "AG-INPUT-TEXT-FIELD",
  component: AgInputTextField
};

// packages/ag-grid-community/src/widgets/agInputTextArea.ts
var AgInputTextArea = class extends AgAbstractInputField {
  constructor(config) {
    super(config, "ag-text-area", null, "textarea");
  }
  setValue(value, silent) {
    const ret = super.setValue(value, silent);
    this.eInput.value = value;
    return ret;
  }
  setCols(cols) {
    this.eInput.cols = cols;
    return this;
  }
  setRows(rows) {
    this.eInput.rows = rows;
    return this;
  }
};
var AgInputTextAreaSelector = {
  selector: "AG-INPUT-TEXT-AREA",
  component: AgInputTextArea
};

// packages/ag-grid-community/src/widgets/agInputNumberField.ts
var AgInputNumberField = class extends AgInputTextField {
  constructor(config) {
    super(config, "ag-number-field", "number");
  }
  postConstruct() {
    super.postConstruct();
    const eInput = this.eInput;
    this.addManagedListeners(eInput, {
      blur: () => {
        const floatedValue = parseFloat(eInput.value);
        const value = isNaN(floatedValue) ? "" : this.normalizeValue(floatedValue.toString());
        if (this.value !== value) {
          this.setValue(value);
        }
      },
      wheel: this.onWheel.bind(this)
    });
    eInput.step = "any";
    const { precision, min, max, step } = this.config;
    if (typeof precision === "number")
      this.setPrecision(precision);
    if (typeof min === "number")
      this.setMin(min);
    if (typeof max === "number")
      this.setMax(max);
    if (typeof step === "number")
      this.setStep(step);
  }
  onWheel(e) {
    if (_getActiveDomElement(this.beans) === this.eInput) {
      e.preventDefault();
    }
  }
  normalizeValue(value) {
    if (value === "") {
      return "";
    }
    if (this.precision != null) {
      value = this.adjustPrecision(value);
    }
    return value;
  }
  adjustPrecision(value, isScientificNotation) {
    const precision = this.precision;
    if (precision == null) {
      return value;
    }
    if (isScientificNotation) {
      const floatString = parseFloat(value).toFixed(precision);
      return parseFloat(floatString).toString();
    }
    const parts = String(value).split(".");
    if (parts.length > 1) {
      if (parts[1].length <= precision) {
        return value;
      } else if (precision > 0) {
        return `${parts[0]}.${parts[1].slice(0, precision)}`;
      }
    }
    return parts[0];
  }
  setMin(min) {
    if (this.min === min) {
      return this;
    }
    this.min = min;
    _addOrRemoveAttribute(this.eInput, "min", min);
    return this;
  }
  setMax(max) {
    if (this.max === max) {
      return this;
    }
    this.max = max;
    _addOrRemoveAttribute(this.eInput, "max", max);
    return this;
  }
  setPrecision(precision) {
    this.precision = precision;
    return this;
  }
  setStep(step) {
    if (this.step === step) {
      return this;
    }
    this.step = step;
    _addOrRemoveAttribute(this.eInput, "step", step);
    return this;
  }
  setValue(value, silent) {
    return this.setValueOrInputValue(
      (v) => super.setValue(v, silent),
      () => this,
      value
    );
  }
  setStartValue(value) {
    return this.setValueOrInputValue(
      (v) => super.setValue(v, true),
      (v) => {
        this.eInput.value = v;
      },
      value
    );
  }
  setValueOrInputValue(setValueFunc, setInputValueOnlyFunc, value) {
    if (_exists(value)) {
      let setInputValueOnly = this.isScientificNotation(value);
      if (setInputValueOnly && this.eInput.validity.valid) {
        return setValueFunc(value);
      }
      if (!setInputValueOnly) {
        value = this.adjustPrecision(value);
        const normalizedValue = this.normalizeValue(value);
        setInputValueOnly = value != normalizedValue;
      }
      if (setInputValueOnly) {
        return setInputValueOnlyFunc(value);
      }
    }
    return setValueFunc(value);
  }
  getValue() {
    const eInput = this.eInput;
    if (!eInput.validity.valid) {
      return void 0;
    }
    const inputValue = eInput.value;
    if (this.isScientificNotation(inputValue)) {
      return this.adjustPrecision(inputValue, true);
    }
    return super.getValue();
  }
  isScientificNotation(value) {
    return typeof value === "string" && value.includes("e");
  }
};
var AgInputNumberFieldSelector = {
  selector: "AG-INPUT-NUMBER-FIELD",
  component: AgInputNumberField
};

// packages/ag-grid-community/src/widgets/agInputDateField.ts
var AgInputDateField = class extends AgInputTextField {
  constructor(config) {
    super(config, "ag-date-field", "date");
  }
  postConstruct() {
    super.postConstruct();
    const usingSafari = _isBrowserSafari();
    this.addManagedListeners(this.eInput, {
      wheel: this.onWheel.bind(this),
      mousedown: () => {
        if (this.isDisabled() || usingSafari) {
          return;
        }
        this.eInput.focus();
      }
    });
    this.eInput.step = "any";
  }
  onWheel(e) {
    if (_getActiveDomElement(this.beans) === this.eInput) {
      e.preventDefault();
    }
  }
  setMin(minDate) {
    const min = minDate instanceof Date ? _serialiseDate(minDate ?? null, !!this.includeTime) ?? void 0 : minDate;
    if (this.min === min) {
      return this;
    }
    this.min = min;
    _addOrRemoveAttribute(this.eInput, "min", min);
    return this;
  }
  setMax(maxDate) {
    const max = maxDate instanceof Date ? _serialiseDate(maxDate ?? null, !!this.includeTime) ?? void 0 : maxDate;
    if (this.max === max) {
      return this;
    }
    this.max = max;
    _addOrRemoveAttribute(this.eInput, "max", max);
    return this;
  }
  setStep(step) {
    if (this.step === step) {
      return this;
    }
    this.step = step;
    _addOrRemoveAttribute(this.eInput, "step", step);
    return this;
  }
  setIncludeTime(includeTime) {
    if (this.includeTime === includeTime) {
      return this;
    }
    this.includeTime = includeTime;
    super.setInputType(includeTime ? "datetime-local" : "date");
    if (includeTime)
      this.setStep(1);
    return this;
  }
  getDate() {
    if (!this.eInput.validity.valid) {
      return void 0;
    }
    return _parseDateTimeFromString(this.getValue()) ?? void 0;
  }
  setDate(date, silent) {
    this.setValue(_serialiseDate(date ?? null, this.includeTime), silent);
  }
};
var AgInputDateFieldSelector = {
  selector: "AG-INPUT-DATE-FIELD",
  component: AgInputDateField
};

// packages/ag-grid-community/src/widgets/agList.ts
var AgList = class extends Component {
  constructor(cssIdentifier = "default", unFocusable = false) {
    super({ tag: "div", cls: `ag-list ag-${cssIdentifier}-list` });
    this.cssIdentifier = cssIdentifier;
    this.unFocusable = unFocusable;
    this.activeClass = "ag-active-item";
    this.options = [];
    this.itemEls = [];
  }
  postConstruct() {
    const eGui = this.getGui();
    this.addManagedElementListeners(eGui, { mouseleave: () => this.clearHighlighted() });
    if (this.unFocusable) {
      return;
    }
    this.addManagedElementListeners(eGui, { keydown: this.handleKeyDown.bind(this) });
  }
  handleKeyDown(e) {
    const key = e.key;
    switch (key) {
      case KeyCode.ENTER:
        if (!this.highlightedEl) {
          this.setValue(this.getValue());
        } else {
          const pos = this.itemEls.indexOf(this.highlightedEl);
          this.setValueByIndex(pos);
        }
        break;
      case KeyCode.DOWN:
      case KeyCode.UP:
        e.preventDefault();
        this.navigate(key);
        break;
      case KeyCode.PAGE_DOWN:
      case KeyCode.PAGE_UP:
      case KeyCode.PAGE_HOME:
      case KeyCode.PAGE_END:
        e.preventDefault();
        this.navigateToPage(key);
        break;
    }
  }
  navigate(key) {
    const isDown = key === KeyCode.DOWN;
    let itemToHighlight;
    const { itemEls, highlightedEl } = this;
    if (!highlightedEl) {
      itemToHighlight = itemEls[isDown ? 0 : itemEls.length - 1];
    } else {
      const currentIdx = itemEls.indexOf(highlightedEl);
      let nextPos = currentIdx + (isDown ? 1 : -1);
      nextPos = Math.min(Math.max(nextPos, 0), itemEls.length - 1);
      itemToHighlight = itemEls[nextPos];
    }
    this.highlightItem(itemToHighlight);
  }
  navigateToPage(key) {
    const { itemEls, highlightedEl } = this;
    if (!highlightedEl || itemEls.length === 0) {
      return;
    }
    const currentIdx = itemEls.indexOf(highlightedEl);
    const rowCount = this.options.length - 1;
    const itemHeight = itemEls[0].clientHeight;
    const pageSize = Math.floor(this.getGui().clientHeight / itemHeight);
    let newIndex = -1;
    if (key === KeyCode.PAGE_HOME) {
      newIndex = 0;
    } else if (key === KeyCode.PAGE_END) {
      newIndex = rowCount;
    } else if (key === KeyCode.PAGE_DOWN) {
      newIndex = Math.min(currentIdx + pageSize, rowCount);
    } else if (key === KeyCode.PAGE_UP) {
      newIndex = Math.max(currentIdx - pageSize, 0);
    }
    if (newIndex === -1) {
      return;
    }
    this.highlightItem(itemEls[newIndex]);
  }
  addOptions(listOptions) {
    listOptions.forEach((listOption) => this.addOption(listOption));
    return this;
  }
  addOption(listOption) {
    const { value, text } = listOption;
    const valueToRender = text ?? value;
    this.options.push({ value, text: valueToRender });
    this.renderOption(value, valueToRender);
    this.updateIndices();
    return this;
  }
  clearOptions() {
    this.options = [];
    this.reset(true);
    this.itemEls.forEach((itemEl) => {
      _removeFromParent(itemEl);
    });
    this.itemEls = [];
    this.refreshAriaRole();
  }
  refreshAriaRole() {
    const eGui = this.getGui();
    _setAriaRole(eGui, this.options.length === 0 ? "presentation" : "listbox");
  }
  updateIndices() {
    const options = this.getGui().querySelectorAll(".ag-list-item");
    this.refreshAriaRole();
    options.forEach((option, idx) => {
      _setAriaPosInSet(option, idx + 1);
      _setAriaSetSize(option, options.length);
    });
  }
  renderOption(value, text) {
    const itemEl = _createElement({
      tag: "div",
      cls: `ag-list-item ag-${this.cssIdentifier}-list-item`,
      attrs: { role: "option" }
    });
    const span = _createElement({
      tag: "span",
      children: text
    });
    itemEl.appendChild(span);
    if (!this.unFocusable) {
      itemEl.tabIndex = -1;
    }
    this.itemEls.push(itemEl);
    this.addManagedListeners(itemEl, {
      mouseover: () => this.highlightItem(itemEl),
      mousedown: (e) => {
        e.preventDefault();
        e.stopPropagation();
        this.setValue(value);
      }
    });
    this.createOptionalManagedBean(
      this.beans.registry.createDynamicBean("tooltipFeature", false, {
        getTooltipValue: () => text,
        getGui: () => itemEl,
        getLocation: () => "UNKNOWN",
        // only show tooltips for items where the text cannot be fully displayed
        shouldDisplayTooltip: () => span.scrollWidth > span.clientWidth
      })
    );
    this.getGui().appendChild(itemEl);
  }
  setValue(value, silent) {
    if (this.value === value) {
      this.fireItemSelected();
      return this;
    }
    if (value == null) {
      this.reset(silent);
      return this;
    }
    const idx = this.options.findIndex((option) => option.value === value);
    if (idx !== -1) {
      const option = this.options[idx];
      this.value = option.value;
      this.displayValue = option.text;
      this.highlightItem(this.itemEls[idx]);
      if (!silent) {
        this.fireChangeEvent();
      }
    }
    return this;
  }
  setValueByIndex(idx) {
    return this.setValue(this.options[idx].value);
  }
  getValue() {
    return this.value;
  }
  getDisplayValue() {
    return this.displayValue;
  }
  refreshHighlighted() {
    this.clearHighlighted();
    const idx = this.options.findIndex((option) => option.value === this.value);
    if (idx !== -1) {
      this.highlightItem(this.itemEls[idx]);
    }
  }
  reset(silent) {
    this.value = null;
    this.displayValue = null;
    this.clearHighlighted();
    if (!silent) {
      this.fireChangeEvent();
    }
  }
  highlightItem(el) {
    if (!_isVisible(el)) {
      return;
    }
    this.clearHighlighted();
    this.highlightedEl = el;
    el.classList.add(this.activeClass);
    _setAriaSelected(el, true);
    const eGui = this.getGui();
    const { scrollTop, clientHeight } = eGui;
    const { offsetTop, offsetHeight } = el;
    if (offsetTop + offsetHeight > scrollTop + clientHeight || offsetTop < scrollTop) {
      el.scrollIntoView({ block: "nearest" });
    }
    if (!this.unFocusable) {
      el.focus();
    }
  }
  clearHighlighted() {
    const highlightedEl = this.highlightedEl;
    if (!highlightedEl || !_isVisible(highlightedEl)) {
      return;
    }
    highlightedEl.classList.remove(this.activeClass);
    _setAriaSelected(highlightedEl, false);
    this.highlightedEl = null;
  }
  fireChangeEvent() {
    this.dispatchLocalEvent({ type: "fieldValueChanged" });
    this.fireItemSelected();
  }
  fireItemSelected() {
    this.dispatchLocalEvent({ type: "selectedItem" });
  }
};

// packages/ag-grid-community/src/widgets/agPickerField.css-GENERATED.ts
var agPickerFieldCSS = (
  /*css*/
  `.ag-picker-field-display{flex:1 1 auto}.ag-picker-field{align-items:center;display:flex}.ag-picker-field-icon{border:0;cursor:pointer;display:flex;margin:0;padding:0}.ag-picker-field-wrapper{background-color:var(--ag-picker-button-background-color);border:var(--ag-picker-button-border);border-radius:5px;min-height:max(var(--ag-list-item-height),calc(var(--ag-spacing)*4));overflow:hidden;&:where(.ag-picker-has-focus),&:where(:focus-within){background-color:var(--ag-picker-button-focus-background-color);border:var(--ag-picker-button-focus-border);box-shadow:var(--ag-focus-shadow);&:where(.invalid){box-shadow:var(--ag-focus-error-shadow)}}&:where(.invalid){background-color:var(--ag-input-invalid-background-color);border:var(--ag-input-invalid-border);color:var(--ag-input-invalid-text-color)}&:disabled{opacity:.5}}`
);

// packages/ag-grid-community/src/widgets/agPickerField.ts
var AgPickerFieldElement = {
  tag: "div",
  cls: "ag-picker-field",
  role: "presentation",
  children: [
    { tag: "div", ref: "eLabel" },
    {
      tag: "div",
      ref: "eWrapper",
      cls: "ag-wrapper ag-picker-field-wrapper ag-picker-collapsed",
      children: [
        { tag: "div", ref: "eDisplayField", cls: "ag-picker-field-display" },
        { tag: "div", ref: "eIcon", cls: "ag-picker-field-icon", attrs: { "aria-hidden": "true" } }
      ]
    }
  ]
};
var AgPickerField = class extends AgAbstractField {
  constructor(config) {
    super(config, config?.template || AgPickerFieldElement, config?.agComponents || [], config?.className);
    this.isPickerDisplayed = false;
    this.skipClick = false;
    this.pickerGap = 4;
    this.hideCurrentPicker = null;
    this.eLabel = RefPlaceholder;
    this.eWrapper = RefPlaceholder;
    this.eDisplayField = RefPlaceholder;
    this.eIcon = RefPlaceholder;
    this.registerCSS(agPickerFieldCSS);
    this.ariaRole = config?.ariaRole;
    this.onPickerFocusIn = this.onPickerFocusIn.bind(this);
    this.onPickerFocusOut = this.onPickerFocusOut.bind(this);
    if (!config) {
      return;
    }
    const { pickerGap, maxPickerHeight, variableWidth, minPickerWidth, maxPickerWidth } = config;
    if (pickerGap != null) {
      this.pickerGap = pickerGap;
    }
    this.variableWidth = !!variableWidth;
    if (maxPickerHeight != null) {
      this.setPickerMaxHeight(maxPickerHeight);
    }
    if (minPickerWidth != null) {
      this.setPickerMinWidth(minPickerWidth);
    }
    if (maxPickerWidth != null) {
      this.setPickerMaxWidth(maxPickerWidth);
    }
  }
  postConstruct() {
    super.postConstruct();
    this.setupAria();
    const displayId = `ag-${this.getCompId()}-display`;
    this.eDisplayField.setAttribute("id", displayId);
    const ariaEl = this.getAriaElement();
    this.addManagedElementListeners(ariaEl, { keydown: this.onKeyDown.bind(this) });
    this.addManagedElementListeners(this.eLabel, { mousedown: this.onLabelOrWrapperMouseDown.bind(this) });
    this.addManagedElementListeners(this.eWrapper, { mousedown: this.onLabelOrWrapperMouseDown.bind(this) });
    const { pickerIcon, inputWidth } = this.config;
    if (pickerIcon) {
      const icon = _createIconNoSpan(pickerIcon, this.beans);
      if (icon) {
        this.eIcon.appendChild(icon);
      }
    }
    if (inputWidth != null) {
      this.setInputWidth(inputWidth);
    }
  }
  setupAria() {
    const ariaEl = this.getAriaElement();
    ariaEl.setAttribute("tabindex", this.gos.get("tabIndex").toString());
    _setAriaExpanded(ariaEl, false);
    if (this.ariaRole) {
      _setAriaRole(ariaEl, this.ariaRole);
    }
  }
  onLabelOrWrapperMouseDown(e) {
    if (e) {
      const focusableEl = this.getFocusableElement();
      if (focusableEl !== this.eWrapper && e?.target === focusableEl) {
        return;
      }
      e.preventDefault();
      this.getFocusableElement().focus();
    }
    if (this.skipClick) {
      this.skipClick = false;
      return;
    }
    if (this.isDisabled()) {
      return;
    }
    if (this.isPickerDisplayed) {
      this.hidePicker();
    } else {
      this.showPicker();
    }
  }
  onKeyDown(e) {
    switch (e.key) {
      case KeyCode.UP:
      case KeyCode.DOWN:
      case KeyCode.ENTER:
      case KeyCode.SPACE:
        e.preventDefault();
        this.onLabelOrWrapperMouseDown();
        break;
      case KeyCode.ESCAPE:
        if (this.isPickerDisplayed) {
          e.preventDefault();
          e.stopPropagation();
          if (this.hideCurrentPicker) {
            this.hideCurrentPicker();
          }
        }
        break;
    }
  }
  showPicker() {
    this.isPickerDisplayed = true;
    if (!this.pickerComponent) {
      this.pickerComponent = this.createPickerComponent();
    }
    const pickerGui = this.pickerComponent.getGui();
    pickerGui.addEventListener("focusin", this.onPickerFocusIn);
    pickerGui.addEventListener("focusout", this.onPickerFocusOut);
    this.hideCurrentPicker = this.renderAndPositionPicker();
    this.toggleExpandedStyles(true);
  }
  renderAndPositionPicker() {
    const ePicker = this.pickerComponent.getGui();
    if (!this.gos.get("suppressScrollWhenPopupsAreOpen")) {
      [this.destroyMouseWheelFunc] = this.addManagedEventListeners({
        bodyScroll: () => {
          this.hidePicker();
        }
      });
    }
    const translate = this.getLocaleTextFunc();
    const {
      config: { pickerAriaLabelKey, pickerAriaLabelValue, modalPicker = true },
      maxPickerHeight,
      minPickerWidth,
      maxPickerWidth,
      variableWidth,
      beans,
      eWrapper
    } = this;
    const popupParams = {
      modal: modalPicker,
      eChild: ePicker,
      closeOnEsc: true,
      closedCallback: () => {
        const shouldRestoreFocus = _isNothingFocused(beans);
        this.beforeHidePicker();
        if (shouldRestoreFocus && this.isAlive()) {
          this.getFocusableElement().focus();
        }
      },
      ariaLabel: translate(pickerAriaLabelKey, pickerAriaLabelValue),
      anchorToElement: eWrapper
    };
    ePicker.style.position = "absolute";
    const popupSvc = beans.popupSvc;
    const addPopupRes = popupSvc.addPopup(popupParams);
    if (variableWidth) {
      if (minPickerWidth) {
        ePicker.style.minWidth = minPickerWidth;
      }
      ePicker.style.width = _formatSize(_getAbsoluteWidth(eWrapper));
      if (maxPickerWidth) {
        ePicker.style.maxWidth = maxPickerWidth;
      }
    } else {
      _setElementWidth(ePicker, maxPickerWidth ?? _getAbsoluteWidth(eWrapper));
    }
    const maxHeight = maxPickerHeight ?? `${_getInnerHeight(popupSvc.getPopupParent())}px`;
    ePicker.style.setProperty("max-height", maxHeight);
    this.alignPickerToComponent();
    return addPopupRes.hideFunc;
  }
  alignPickerToComponent() {
    if (!this.pickerComponent) {
      return;
    }
    const {
      pickerGap,
      config: { pickerType },
      beans: { popupSvc, gos },
      eWrapper,
      pickerComponent
    } = this;
    const alignSide = gos.get("enableRtl") ? "right" : "left";
    popupSvc.positionPopupByComponent({
      type: pickerType,
      eventSource: eWrapper,
      ePopup: pickerComponent.getGui(),
      position: "under",
      alignSide,
      keepWithinBounds: true,
      nudgeY: pickerGap
    });
  }
  beforeHidePicker() {
    if (this.destroyMouseWheelFunc) {
      this.destroyMouseWheelFunc();
      this.destroyMouseWheelFunc = void 0;
    }
    this.toggleExpandedStyles(false);
    const pickerGui = this.pickerComponent.getGui();
    pickerGui.removeEventListener("focusin", this.onPickerFocusIn);
    pickerGui.removeEventListener("focusout", this.onPickerFocusOut);
    this.isPickerDisplayed = false;
    this.pickerComponent = void 0;
    this.hideCurrentPicker = null;
  }
  toggleExpandedStyles(expanded) {
    if (!this.isAlive()) {
      return;
    }
    const ariaEl = this.getAriaElement();
    _setAriaExpanded(ariaEl, expanded);
    const classList = this.eWrapper.classList;
    classList.toggle("ag-picker-expanded", expanded);
    classList.toggle("ag-picker-collapsed", !expanded);
  }
  onPickerFocusIn() {
    this.togglePickerHasFocus(true);
  }
  onPickerFocusOut(e) {
    if (!this.pickerComponent?.getGui().contains(e.relatedTarget)) {
      this.togglePickerHasFocus(false);
    }
  }
  togglePickerHasFocus(focused) {
    if (!this.pickerComponent) {
      return;
    }
    this.eWrapper.classList.toggle("ag-picker-has-focus", focused);
  }
  hidePicker() {
    if (this.hideCurrentPicker) {
      this.hideCurrentPicker();
      this.dispatchLocalEvent({
        type: "pickerHidden"
      });
    }
  }
  setInputWidth(width) {
    _setElementWidth(this.eWrapper, width);
    return this;
  }
  getFocusableElement() {
    return this.eWrapper;
  }
  setPickerGap(gap) {
    this.pickerGap = gap;
    return this;
  }
  setPickerMinWidth(width) {
    if (typeof width === "number") {
      width = `${width}px`;
    }
    this.minPickerWidth = width == null ? void 0 : width;
    return this;
  }
  setPickerMaxWidth(width) {
    if (typeof width === "number") {
      width = `${width}px`;
    }
    this.maxPickerWidth = width == null ? void 0 : width;
    return this;
  }
  setPickerMaxHeight(height) {
    if (typeof height === "number") {
      height = `${height}px`;
    }
    this.maxPickerHeight = height == null ? void 0 : height;
    return this;
  }
  destroy() {
    this.hidePicker();
    super.destroy();
  }
};

// packages/ag-grid-community/src/widgets/agSelect.css-GENERATED.ts
var agSelectCSS = (
  /*css*/
  `.ag-select{align-items:center;display:flex;&.ag-disabled{opacity:.5}}:where(.ag-select){.ag-picker-field-wrapper{cursor:default}&.ag-disabled .ag-picker-field-wrapper:focus{box-shadow:none}&:not(.ag-cell-editor,.ag-label-align-top){min-height:var(--ag-list-item-height)}.ag-picker-field-display{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ag-picker-field-icon{align-items:center;display:flex}}:where(.ag-ltr) :where(.ag-select){.ag-picker-field-wrapper{padding-left:calc(var(--ag-cell-horizontal-padding)/2);padding-right:var(--ag-spacing)}}:where(.ag-rtl) :where(.ag-select){.ag-picker-field-wrapper{padding-left:var(--ag-spacing);padding-right:calc(var(--ag-cell-horizontal-padding)/2)}}`
);

// packages/ag-grid-community/src/widgets/agSelect.ts
var AgSelect = class extends AgPickerField {
  constructor(config) {
    super({
      pickerAriaLabelKey: "ariaLabelSelectField",
      pickerAriaLabelValue: "Select Field",
      pickerType: "ag-list",
      className: "ag-select",
      pickerIcon: "selectOpen",
      ariaRole: "combobox",
      ...config
    });
    this.registerCSS(agSelectCSS);
  }
  postConstruct() {
    this.tooltipFeature = this.createOptionalManagedBean(
      this.beans.registry.createDynamicBean("tooltipFeature", false, {
        shouldDisplayTooltip: _isElementOverflowingCallback(() => this.eDisplayField),
        getGui: () => this.getGui()
      })
    );
    super.postConstruct();
    this.createListComponent();
    this.eWrapper.tabIndex = this.gos.get("tabIndex");
    const { options, value, placeholder } = this.config;
    if (options != null) {
      this.addOptions(options);
    }
    if (value != null) {
      this.setValue(value, true);
    }
    if (placeholder && value == null) {
      this.eDisplayField.textContent = placeholder;
    }
    this.addManagedElementListeners(this.eWrapper, { focusout: this.onWrapperFocusOut.bind(this) });
  }
  onWrapperFocusOut(e) {
    if (!this.eWrapper.contains(e.relatedTarget)) {
      this.hidePicker();
    }
  }
  createListComponent() {
    const listComponent = this.createBean(new AgList("select", true));
    this.listComponent = listComponent;
    listComponent.setParentComponent(this);
    const eListAriaEl = listComponent.getAriaElement();
    const listId = `ag-select-list-${listComponent.getCompId()}`;
    eListAriaEl.setAttribute("id", listId);
    _setAriaControlsAndLabel(this.getAriaElement(), eListAriaEl);
    listComponent.addManagedElementListeners(listComponent.getGui(), {
      mousedown: (e) => {
        e?.preventDefault();
      }
    });
    listComponent.addManagedListeners(listComponent, {
      selectedItem: () => {
        this.hidePicker();
        this.dispatchLocalEvent({ type: "selectedItem" });
      },
      fieldValueChanged: () => {
        if (!this.listComponent) {
          return;
        }
        this.setValue(this.listComponent.getValue(), false, true);
        this.hidePicker();
      }
    });
  }
  createPickerComponent() {
    return this.listComponent;
  }
  onKeyDown(e) {
    const { key } = e;
    if (key === KeyCode.TAB) {
      this.hidePicker();
    }
    switch (key) {
      case KeyCode.ENTER:
      case KeyCode.UP:
      case KeyCode.DOWN:
      case KeyCode.PAGE_UP:
      case KeyCode.PAGE_DOWN:
      case KeyCode.PAGE_HOME:
      case KeyCode.PAGE_END:
        e.preventDefault();
        if (this.isPickerDisplayed) {
          this.listComponent?.handleKeyDown(e);
        } else {
          super.onKeyDown(e);
        }
        break;
      case KeyCode.ESCAPE:
        super.onKeyDown(e);
        break;
      case KeyCode.SPACE:
        if (this.isPickerDisplayed) {
          e.preventDefault();
        } else {
          super.onKeyDown(e);
        }
        break;
    }
  }
  showPicker() {
    const listComponent = this.listComponent;
    if (!listComponent) {
      return;
    }
    super.showPicker();
    listComponent.refreshHighlighted();
  }
  addOptions(options) {
    options.forEach((option) => this.addOption(option));
    return this;
  }
  addOption(option) {
    this.listComponent.addOption(option);
    return this;
  }
  clearOptions() {
    this.listComponent?.clearOptions();
    this.setValue(void 0, true);
    return this;
  }
  setValue(value, silent, fromPicker) {
    const {
      listComponent,
      config: { placeholder },
      eDisplayField,
      tooltipFeature
    } = this;
    if (this.value === value || !listComponent) {
      return this;
    }
    if (!fromPicker) {
      listComponent.setValue(value, true);
    }
    const newValue = listComponent.getValue();
    if (newValue === this.getValue()) {
      return this;
    }
    let displayValue = listComponent.getDisplayValue();
    if (displayValue == null && placeholder) {
      displayValue = placeholder;
    }
    eDisplayField.textContent = displayValue;
    tooltipFeature?.setTooltipAndRefresh(displayValue ?? null);
    return super.setValue(value, silent);
  }
  destroy() {
    this.listComponent = this.destroyBean(this.listComponent);
    super.destroy();
  }
};
var AgSelectSelector = {
  selector: "AG-SELECT",
  component: AgSelect
};

// packages/ag-grid-community/src/widgets/tabGuardCtrl.ts
var TabGuardClassNames = {
  TAB_GUARD: "ag-tab-guard",
  TAB_GUARD_TOP: "ag-tab-guard-top",
  TAB_GUARD_BOTTOM: "ag-tab-guard-bottom"
};
var TabGuardCtrl = class extends BeanStub {
  constructor(params) {
    super();
    this.skipTabGuardFocus = false;
    this.forcingFocusOut = false;
    // Used when `isFocusableContainer` enabled
    this.allowFocus = false;
    const {
      comp,
      eTopGuard,
      eBottomGuard,
      focusTrapActive,
      forceFocusOutWhenTabGuardsAreEmpty,
      isFocusableContainer,
      focusInnerElement,
      onFocusIn,
      onFocusOut,
      shouldStopEventPropagation,
      onTabKeyDown,
      handleKeyDown,
      isEmpty,
      eFocusableElement
    } = params;
    this.comp = comp;
    this.eTopGuard = eTopGuard;
    this.eBottomGuard = eBottomGuard;
    this.providedFocusInnerElement = focusInnerElement;
    this.eFocusableElement = eFocusableElement;
    this.focusTrapActive = !!focusTrapActive;
    this.forceFocusOutWhenTabGuardsAreEmpty = !!forceFocusOutWhenTabGuardsAreEmpty;
    this.isFocusableContainer = !!isFocusableContainer;
    this.providedFocusIn = onFocusIn;
    this.providedFocusOut = onFocusOut;
    this.providedShouldStopEventPropagation = shouldStopEventPropagation;
    this.providedOnTabKeyDown = onTabKeyDown;
    this.providedHandleKeyDown = handleKeyDown;
    this.providedIsEmpty = isEmpty;
  }
  postConstruct() {
    this.createManagedBean(
      new ManagedFocusFeature(this.eFocusableElement, {
        shouldStopEventPropagation: () => this.shouldStopEventPropagation(),
        onTabKeyDown: (e) => this.onTabKeyDown(e),
        handleKeyDown: (e) => this.handleKeyDown(e),
        onFocusIn: (e) => this.onFocusIn(e),
        onFocusOut: (e) => this.onFocusOut(e)
      })
    );
    this.activateTabGuards();
    [this.eTopGuard, this.eBottomGuard].forEach(
      (guard) => this.addManagedElementListeners(guard, { focus: this.onFocus.bind(this) })
    );
  }
  handleKeyDown(e) {
    if (this.providedHandleKeyDown) {
      this.providedHandleKeyDown(e);
    }
  }
  tabGuardsAreActive() {
    return !!this.eTopGuard && this.eTopGuard.hasAttribute("tabIndex");
  }
  shouldStopEventPropagation() {
    if (this.providedShouldStopEventPropagation) {
      return this.providedShouldStopEventPropagation();
    }
    return false;
  }
  activateTabGuards() {
    if (this.forcingFocusOut) {
      return;
    }
    const tabIndex = this.gos.get("tabIndex");
    this.comp.setTabIndex(tabIndex.toString());
  }
  deactivateTabGuards() {
    this.comp.setTabIndex();
  }
  onFocus(e) {
    if (this.isFocusableContainer && !this.eFocusableElement.contains(e.relatedTarget)) {
      if (!this.allowFocus) {
        this.findNextElementOutsideAndFocus(e.target === this.eBottomGuard);
        return;
      }
    }
    if (this.skipTabGuardFocus) {
      this.skipTabGuardFocus = false;
      return;
    }
    if (this.forceFocusOutWhenTabGuardsAreEmpty) {
      const isEmpty = this.providedIsEmpty ? this.providedIsEmpty() : _findFocusableElements(this.eFocusableElement, ".ag-tab-guard").length === 0;
      if (isEmpty) {
        this.findNextElementOutsideAndFocus(e.target === this.eBottomGuard);
        return;
      }
    }
    if (this.isFocusableContainer && this.eFocusableElement.contains(e.relatedTarget)) {
      return;
    }
    const fromBottom = e.target === this.eBottomGuard;
    const hasFocusedInnerElement = this.providedFocusInnerElement ? this.providedFocusInnerElement(fromBottom) : this.focusInnerElement(fromBottom);
    if (!hasFocusedInnerElement && this.forceFocusOutWhenTabGuardsAreEmpty) {
      this.findNextElementOutsideAndFocus(e.target === this.eBottomGuard);
    }
  }
  findNextElementOutsideAndFocus(up) {
    const eDocument = _getDocument(this.beans);
    const focusableEls = _findFocusableElements(eDocument.body, null, true);
    const index = focusableEls.indexOf(up ? this.eTopGuard : this.eBottomGuard);
    if (index === -1) {
      return;
    }
    let start;
    let end;
    if (up) {
      start = 0;
      end = index;
    } else {
      start = index + 1;
      end = focusableEls.length;
    }
    const focusableRange = focusableEls.slice(start, end);
    const targetTabIndex = this.gos.get("tabIndex");
    focusableRange.sort((a, b) => {
      const indexA = parseInt(a.getAttribute("tabindex") || "0");
      const indexB = parseInt(b.getAttribute("tabindex") || "0");
      if (indexB === targetTabIndex) {
        return 1;
      }
      if (indexA === targetTabIndex) {
        return -1;
      }
      if (indexA === 0) {
        return 1;
      }
      if (indexB === 0) {
        return -1;
      }
      return indexA - indexB;
    });
    focusableRange[up ? focusableRange.length - 1 : 0]?.focus();
  }
  onFocusIn(e) {
    if (this.focusTrapActive || this.forcingFocusOut) {
      return;
    }
    if (this.providedFocusIn) {
      this.providedFocusIn(e);
    }
    if (!this.isFocusableContainer) {
      this.deactivateTabGuards();
    }
  }
  onFocusOut(e) {
    if (this.focusTrapActive) {
      return;
    }
    if (this.providedFocusOut) {
      this.providedFocusOut(e);
    }
    if (!this.eFocusableElement.contains(e.relatedTarget)) {
      this.activateTabGuards();
    }
  }
  onTabKeyDown(e) {
    if (this.providedOnTabKeyDown) {
      this.providedOnTabKeyDown(e);
      return;
    }
    if (this.focusTrapActive) {
      return;
    }
    if (e.defaultPrevented) {
      return;
    }
    const tabGuardsAreActive = this.tabGuardsAreActive();
    if (tabGuardsAreActive) {
      this.deactivateTabGuards();
    }
    const nextRoot = this.getNextFocusableElement(e.shiftKey);
    if (tabGuardsAreActive) {
      setTimeout(() => this.activateTabGuards(), 0);
    }
    if (!nextRoot) {
      return;
    }
    nextRoot.focus();
    e.preventDefault();
  }
  focusInnerElement(fromBottom = false) {
    const focusable = _findFocusableElements(this.eFocusableElement);
    if (this.tabGuardsAreActive()) {
      focusable.splice(0, 1);
      focusable.splice(focusable.length - 1, 1);
    }
    if (!focusable.length) {
      return false;
    }
    focusable[fromBottom ? focusable.length - 1 : 0].focus({ preventScroll: true });
    return true;
  }
  getNextFocusableElement(backwards) {
    return _findNextFocusableElement(this.beans, this.eFocusableElement, false, backwards);
  }
  forceFocusOutOfContainer(up = false) {
    if (this.forcingFocusOut) {
      return;
    }
    const tabGuardToFocus = up ? this.eTopGuard : this.eBottomGuard;
    this.activateTabGuards();
    this.skipTabGuardFocus = true;
    this.forcingFocusOut = true;
    tabGuardToFocus.focus();
    window.setTimeout(() => {
      this.forcingFocusOut = false;
      this.activateTabGuards();
    });
  }
  isTabGuard(element, bottom) {
    return element === this.eTopGuard && !bottom || element === this.eBottomGuard && (bottom ?? true);
  }
  setAllowFocus(allowFocus) {
    this.allowFocus = allowFocus;
  }
};

// packages/ag-grid-community/src/widgets/tabGuardFeature.ts
var TabGuardFeature = class extends BeanStub {
  constructor(comp) {
    super();
    this.comp = comp;
  }
  initialiseTabGuard(params) {
    this.eTopGuard = this.createTabGuard("top");
    this.eBottomGuard = this.createTabGuard("bottom");
    this.eFocusableElement = this.comp.getFocusableElement();
    const { eTopGuard, eBottomGuard, eFocusableElement } = this;
    const tabGuards = [eTopGuard, eBottomGuard];
    const compProxy = {
      setTabIndex: (tabIndex) => {
        tabGuards.forEach(
          (tabGuard) => tabIndex != null ? tabGuard.setAttribute("tabindex", tabIndex) : tabGuard.removeAttribute("tabindex")
        );
      }
    };
    this.addTabGuards(eTopGuard, eBottomGuard);
    const {
      focusTrapActive = false,
      onFocusIn,
      onFocusOut,
      focusInnerElement,
      handleKeyDown,
      onTabKeyDown,
      shouldStopEventPropagation,
      isEmpty,
      forceFocusOutWhenTabGuardsAreEmpty,
      isFocusableContainer
    } = params;
    this.tabGuardCtrl = this.createManagedBean(
      new TabGuardCtrl({
        comp: compProxy,
        focusTrapActive,
        eTopGuard,
        eBottomGuard,
        eFocusableElement,
        onFocusIn,
        onFocusOut,
        focusInnerElement,
        handleKeyDown,
        onTabKeyDown,
        shouldStopEventPropagation,
        isEmpty,
        forceFocusOutWhenTabGuardsAreEmpty,
        isFocusableContainer
      })
    );
  }
  getTabGuardCtrl() {
    return this.tabGuardCtrl;
  }
  createTabGuard(side) {
    const tabGuard = _getDocument(this.beans).createElement("div");
    const cls = side === "top" ? TabGuardClassNames.TAB_GUARD_TOP : TabGuardClassNames.TAB_GUARD_BOTTOM;
    tabGuard.classList.add(TabGuardClassNames.TAB_GUARD, cls);
    _setAriaRole(tabGuard, "presentation");
    return tabGuard;
  }
  addTabGuards(topTabGuard, bottomTabGuard) {
    const eFocusableElement = this.eFocusableElement;
    eFocusableElement.insertAdjacentElement("afterbegin", topTabGuard);
    eFocusableElement.insertAdjacentElement("beforeend", bottomTabGuard);
  }
  removeAllChildrenExceptTabGuards() {
    const tabGuards = [this.eTopGuard, this.eBottomGuard];
    _clearElement(this.comp.getFocusableElement());
    this.addTabGuards(...tabGuards);
  }
  forceFocusOutOfContainer(up = false) {
    this.tabGuardCtrl.forceFocusOutOfContainer(up);
  }
  appendChild(appendChild, newChild, container) {
    if (!_isNodeOrElement(newChild)) {
      newChild = newChild.getGui();
    }
    const { eBottomGuard: bottomTabGuard } = this;
    if (bottomTabGuard) {
      bottomTabGuard.insertAdjacentElement("beforebegin", newChild);
    } else {
      appendChild(newChild, container);
    }
  }
  destroy() {
    const { eTopGuard, eBottomGuard } = this;
    _removeFromParent(eTopGuard);
    _removeFromParent(eBottomGuard);
    super.destroy();
  }
};

// packages/ag-grid-community/src/widgets/tabGuardComp.ts
var TabGuardComp = class extends Component {
  initialiseTabGuard(params) {
    this.tabGuardFeature = this.createManagedBean(new TabGuardFeature(this));
    this.tabGuardFeature.initialiseTabGuard(params);
  }
  forceFocusOutOfContainer(up = false) {
    this.tabGuardFeature.forceFocusOutOfContainer(up);
  }
  appendChild(newChild, container) {
    this.tabGuardFeature.appendChild(super.appendChild.bind(this), newChild, container);
  }
};

// packages/ag-grid-community/src/widgets/touchListener.ts
var TouchListener = class {
  constructor(eElement, preventMouseClick = false) {
    this.DOUBLE_TAP_MILLIS = 500;
    this.destroyFuncs = [];
    this.touching = false;
    this.localEventService = new LocalEventService();
    this.preventMouseClick = preventMouseClick;
    const startListener = this.onTouchStart.bind(this);
    const moveListener = this.onTouchMove.bind(this);
    const endListener = this.onTouchEnd.bind(this);
    eElement.addEventListener("touchstart", startListener, { passive: true });
    eElement.addEventListener("touchmove", moveListener, { passive: true });
    eElement.addEventListener("touchend", endListener, { passive: false });
    this.destroyFuncs.push(() => {
      eElement.removeEventListener("touchstart", startListener, { passive: true });
      eElement.removeEventListener("touchmove", moveListener, { passive: true });
      eElement.removeEventListener("touchend", endListener, { passive: false });
    });
  }
  getActiveTouch(touchList) {
    for (let i = 0; i < touchList.length; i++) {
      const matches = touchList[i].identifier === this.touchStart.identifier;
      if (matches) {
        return touchList[i];
      }
    }
    return null;
  }
  addEventListener(eventType, listener) {
    this.localEventService.addEventListener(eventType, listener);
  }
  removeEventListener(eventType, listener) {
    this.localEventService.removeEventListener(eventType, listener);
  }
  onTouchStart(touchEvent) {
    if (this.touching) {
      return;
    }
    this.touchStart = touchEvent.touches[0];
    this.touching = true;
    this.moved = false;
    const touchStartCopy = this.touchStart;
    window.setTimeout(() => {
      const touchesMatch = this.touchStart === touchStartCopy;
      if (this.touching && touchesMatch && !this.moved) {
        this.moved = true;
        const event = {
          type: "longTap",
          touchStart: this.touchStart,
          touchEvent
        };
        this.localEventService.dispatchEvent(event);
      }
    }, 500);
  }
  onTouchMove(touchEvent) {
    if (!this.touching) {
      return;
    }
    const touch = this.getActiveTouch(touchEvent.touches);
    if (!touch) {
      return;
    }
    const eventIsFarAway = !_areEventsNear(touch, this.touchStart, 4);
    if (eventIsFarAway) {
      this.moved = true;
    }
  }
  onTouchEnd(touchEvent) {
    if (!this.touching) {
      return;
    }
    if (!this.moved) {
      const event = {
        type: "tap",
        touchStart: this.touchStart
      };
      this.localEventService.dispatchEvent(event);
      this.checkForDoubleTap();
    }
    if (this.preventMouseClick && touchEvent.cancelable) {
      touchEvent.preventDefault();
    }
    this.touching = false;
  }
  checkForDoubleTap() {
    const now = Date.now();
    if (this.lastTapTime && this.lastTapTime > 0) {
      const interval = now - this.lastTapTime;
      if (interval > this.DOUBLE_TAP_MILLIS) {
        const event = {
          type: "doubleTap",
          touchStart: this.touchStart
        };
        this.localEventService.dispatchEvent(event);
        this.lastTapTime = null;
      } else {
        this.lastTapTime = now;
      }
    } else {
      this.lastTapTime = now;
    }
  }
  destroy() {
    this.destroyFuncs.forEach((func) => func());
  }
};

// packages/ag-grid-community/src/interfaces/IRangeService.ts
var CellRangeType = /* @__PURE__ */ ((CellRangeType2) => {
  CellRangeType2[CellRangeType2["VALUE"] = 0] = "VALUE";
  CellRangeType2[CellRangeType2["DIMENSION"] = 1] = "DIMENSION";
  return CellRangeType2;
})(CellRangeType || {});

// packages/ag-grid-community/src/autoScrollService.ts
var AutoScrollService = class {
  constructor(params) {
    this.tickingInterval = null;
    this.onScrollCallback = null;
    this.scrollContainer = params.scrollContainer;
    this.scrollHorizontally = params.scrollAxis.indexOf("x") !== -1;
    this.scrollVertically = params.scrollAxis.indexOf("y") !== -1;
    this.scrollByTick = params.scrollByTick != null ? params.scrollByTick : 20;
    if (params.onScrollCallback) {
      this.onScrollCallback = params.onScrollCallback;
    }
    if (this.scrollVertically) {
      this.getVerticalPosition = params.getVerticalPosition;
      this.setVerticalPosition = params.setVerticalPosition;
    }
    if (this.scrollHorizontally) {
      this.getHorizontalPosition = params.getHorizontalPosition;
      this.setHorizontalPosition = params.setHorizontalPosition;
    }
    this.shouldSkipVerticalScroll = params.shouldSkipVerticalScroll || (() => false);
    this.shouldSkipHorizontalScroll = params.shouldSkipHorizontalScroll || (() => false);
  }
  check(mouseEvent, forceSkipVerticalScroll = false) {
    const skipVerticalScroll = forceSkipVerticalScroll || this.shouldSkipVerticalScroll();
    if (skipVerticalScroll && this.shouldSkipHorizontalScroll()) {
      return;
    }
    const rect = this.scrollContainer.getBoundingClientRect();
    const scrollTick = this.scrollByTick;
    this.tickLeft = mouseEvent.clientX < rect.left + scrollTick;
    this.tickRight = mouseEvent.clientX > rect.right - scrollTick;
    this.tickUp = mouseEvent.clientY < rect.top + scrollTick && !skipVerticalScroll;
    this.tickDown = mouseEvent.clientY > rect.bottom - scrollTick && !skipVerticalScroll;
    if (this.tickLeft || this.tickRight || this.tickUp || this.tickDown) {
      this.ensureTickingStarted();
    } else {
      this.ensureCleared();
    }
  }
  ensureTickingStarted() {
    if (this.tickingInterval === null) {
      this.tickingInterval = window.setInterval(this.doTick.bind(this), 100);
      this.tickCount = 0;
    }
  }
  doTick() {
    this.tickCount++;
    const tickAmount = this.tickCount > 20 ? 200 : this.tickCount > 10 ? 80 : 40;
    if (this.scrollVertically) {
      const vScrollPosition = this.getVerticalPosition();
      if (this.tickUp) {
        this.setVerticalPosition(vScrollPosition - tickAmount);
      }
      if (this.tickDown) {
        this.setVerticalPosition(vScrollPosition + tickAmount);
      }
    }
    if (this.scrollHorizontally) {
      const hScrollPosition = this.getHorizontalPosition();
      if (this.tickLeft) {
        this.setHorizontalPosition(hScrollPosition - tickAmount);
      }
      if (this.tickRight) {
        this.setHorizontalPosition(hScrollPosition + tickAmount);
      }
    }
    if (this.onScrollCallback) {
      this.onScrollCallback();
    }
  }
  ensureCleared() {
    if (this.tickingInterval) {
      window.clearInterval(this.tickingInterval);
      this.tickingInterval = null;
    }
  }
};

// packages/ag-grid-community/src/vanillaFrameworkOverrides.ts
var VanillaFrameworkOverrides = class {
  constructor(frameworkName = "javascript") {
    this.frameworkName = frameworkName;
    this.renderingEngine = "vanilla";
    this.batchFrameworkComps = false;
    this.wrapIncoming = (callback) => callback();
    this.wrapOutgoing = (callback) => callback();
    this.baseDocLink = `${BASE_URL}/${this.frameworkName}-data-grid`;
    setValidationDocLink(this.baseDocLink);
  }
  setInterval(action, timeout) {
    return new AgPromise((resolve) => {
      resolve(window.setInterval(action, timeout));
    });
  }
  // for Vanilla JS, we just add the event to the element
  addEventListener(element, type, listener, options) {
    let eventListenerOptions = {};
    if (typeof options === "object") {
      eventListenerOptions = options;
    } else if (typeof options === "boolean") {
      eventListenerOptions = { capture: options };
    }
    if (eventListenerOptions.passive == null) {
      const passive = getPassiveStateForEvent(type);
      if (passive != null) {
        eventListenerOptions.passive = passive;
      }
    }
    element.addEventListener(type, listener, eventListenerOptions);
  }
  frameworkComponent(_) {
    return null;
  }
  isFrameworkComponent(_) {
    return false;
  }
  getDocLink(path) {
    return `${this.baseDocLink}${path ? `/${path}` : ""}`;
  }
};

// packages/ag-grid-community/src/api/apiUtils.ts
function createGridApi(context) {
  return {
    beanName: "gridApi",
    bean: context.getBean("apiFunctionSvc").api
  };
}

// packages/ag-grid-community/src/context/gridBeanComparator.ts
var orderedCoreBeans = [
  // Validate license first
  "licenseManager",
  // core beans only
  "environment",
  "eventSvc",
  "gos",
  "paginationAutoPageSizeSvc",
  "apiFunctionSvc",
  "gridApi",
  "registry",
  "agCompUtils",
  "userCompFactory",
  "rowContainerHeight",
  "horizontalResizeSvc",
  "localeSvc",
  "pinnedRowModel",
  "dragSvc",
  "colGroupSvc",
  "visibleCols",
  "popupSvc",
  "selectionSvc",
  "colFilter",
  "quickFilter",
  "filterManager",
  "colModel",
  "headerNavigation",
  "pageBounds",
  "pagination",
  "pageBoundsListener",
  "rowSpanSvc",
  "stickyRowSvc",
  "rowRenderer",
  "expressionSvc",
  "alignedGridsSvc",
  "navigation",
  "valueCache",
  "valueSvc",
  "autoWidthCalc",
  "filterMenuFactory",
  "dragAndDrop",
  "focusSvc",
  "cellNavigation",
  "cellStyles",
  "scrollVisibleSvc",
  "sortSvc",
  "colHover",
  "colAnimation",
  "autoColSvc",
  "selectionColSvc",
  "changeDetectionSvc",
  "animationFrameSvc",
  "undoRedo",
  "colDefFactory",
  "rowStyleSvc",
  "rowNodeBlockLoader",
  "rowNodeSorter",
  "ctrlsSvc",
  "pinnedCols",
  "dataTypeSvc",
  "syncSvc",
  "overlays",
  "stateSvc",
  "expansionSvc",
  "apiEventSvc",
  "ariaAnnounce",
  "menuSvc",
  "colMoves",
  "colAutosize",
  "colFlex",
  "colResize",
  "pivotColsSvc",
  "valueColsSvc",
  "rowGroupColsSvc",
  "funcColsSvc",
  "colNames",
  "colViewport",
  "pivotResultCols",
  "showRowGroupCols",
  "validation"
  // Have validations run last
];
var beanNamePosition = Object.fromEntries(
  orderedCoreBeans.map((beanName, index) => [beanName, index])
);
function gridBeanInitComparator(bean1, bean2) {
  const index1 = (bean1.beanName ? beanNamePosition[bean1.beanName] : void 0) ?? Number.MAX_SAFE_INTEGER;
  const index2 = (bean2.beanName ? beanNamePosition[bean2.beanName] : void 0) ?? Number.MAX_SAFE_INTEGER;
  return index1 - index2;
}
function gridBeanDestroyComparator(bean1, bean2) {
  if (bean1?.beanName === "gridDestroySvc") {
    return -1;
  }
  if (bean2?.beanName === "gridDestroySvc") {
    return 1;
  }
  return 0;
}

// packages/ag-grid-community/src/headerRendering/rowContainer/headerRowContainerComp.ts
var PinnedLeftElement = { tag: "div", cls: "ag-pinned-left-header", role: "rowgroup" };
var PinnedRightElement = { tag: "div", cls: "ag-pinned-right-header", role: "rowgroup" };
var CenterElement = {
  tag: "div",
  cls: "ag-header-viewport",
  role: "presentation",
  attrs: { tabindex: "-1" },
  children: [{ tag: "div", ref: "eCenterContainer", cls: "ag-header-container", role: "rowgroup" }]
};
var HeaderRowContainerComp = class extends Component {
  constructor(pinned) {
    super();
    this.eCenterContainer = RefPlaceholder;
    this.headerRowComps = {};
    this.rowCompsList = [];
    this.pinned = pinned;
  }
  postConstruct() {
    this.selectAndSetTemplate();
    const compProxy = {
      setDisplayed: (displayed) => this.setDisplayed(displayed),
      setCtrls: (ctrls) => this.setCtrls(ctrls),
      // only gets called for center section
      setCenterWidth: (width) => this.eCenterContainer.style.width = width,
      setViewportScrollLeft: (left) => this.getGui().scrollLeft = left,
      // only gets called for pinned sections
      setPinnedContainerWidth: (width) => {
        const eGui = this.getGui();
        eGui.style.width = width;
        eGui.style.maxWidth = width;
        eGui.style.minWidth = width;
      }
    };
    const ctrl = this.createManagedBean(new HeaderRowContainerCtrl(this.pinned));
    ctrl.setComp(compProxy, this.getGui());
  }
  selectAndSetTemplate() {
    const pinnedLeft = this.pinned == "left";
    const pinnedRight = this.pinned == "right";
    const template = pinnedLeft ? PinnedLeftElement : pinnedRight ? PinnedRightElement : CenterElement;
    this.setTemplate(template);
    this.eRowContainer = this.eCenterContainer !== RefPlaceholder ? this.eCenterContainer : this.getGui();
  }
  destroy() {
    this.setCtrls([]);
    super.destroy();
  }
  destroyRowComp(rowComp) {
    this.destroyBean(rowComp);
    this.eRowContainer.removeChild(rowComp.getGui());
  }
  setCtrls(ctrls) {
    const oldRowComps = this.headerRowComps;
    this.headerRowComps = {};
    this.rowCompsList = [];
    let prevGui;
    const appendEnsuringDomOrder = (rowComp) => {
      const eGui = rowComp.getGui();
      const notAlreadyIn = eGui.parentElement != this.eRowContainer;
      if (notAlreadyIn) {
        this.eRowContainer.appendChild(eGui);
      }
      if (prevGui) {
        _ensureDomOrder(this.eRowContainer, eGui, prevGui);
      }
      prevGui = eGui;
    };
    ctrls.forEach((ctrl) => {
      const ctrlId = ctrl.instanceId;
      const existingComp = oldRowComps[ctrlId];
      delete oldRowComps[ctrlId];
      const rowComp = existingComp ? existingComp : this.createBean(new HeaderRowComp(ctrl));
      this.headerRowComps[ctrlId] = rowComp;
      this.rowCompsList.push(rowComp);
      appendEnsuringDomOrder(rowComp);
    });
    Object.values(oldRowComps).forEach((c) => this.destroyRowComp(c));
  }
};

// packages/ag-grid-community/src/headerRendering/gridHeaderComp.ts
var GridHeaderElement = { tag: "div", cls: "ag-header", role: "presentation" };
var GridHeaderComp = class extends Component {
  constructor() {
    super(GridHeaderElement);
  }
  postConstruct() {
    const compProxy = {
      toggleCss: (cssClassName, on) => this.toggleCss(cssClassName, on),
      setHeightAndMinHeight: (height) => {
        this.getGui().style.height = height;
        this.getGui().style.minHeight = height;
      }
    };
    const ctrl = this.createManagedBean(new GridHeaderCtrl());
    ctrl.setComp(compProxy, this.getGui(), this.getFocusableElement());
    const addContainer = (container) => {
      this.createManagedBean(container);
      this.appendChild(container);
    };
    addContainer(new HeaderRowContainerComp("left"));
    addContainer(new HeaderRowContainerComp(null));
    addContainer(new HeaderRowContainerComp("right"));
  }
};
var GridHeaderSelector = {
  selector: "AG-HEADER-ROOT",
  component: GridHeaderComp
};

// packages/ag-grid-community/src/rendering/cell/cellComp.ts
var CellComp = class extends Component {
  constructor(beans, cellCtrl, printLayout, eRow, editingCell) {
    super();
    this.cellCtrl = cellCtrl;
    // every time we go into edit mode, or back again, this gets incremented.
    // it's the components way of dealing with the async nature of framework components,
    // so if a framework component takes a while to be created, we know if the object
    // is still relevant when creating is finished. eg we could click edit / un-edit 20
    // times before the first React edit component comes back - we should discard
    // the first 19.
    this.rendererVersion = 0;
    this.editorVersion = 0;
    this.beans = beans;
    this.gos = beans.gos;
    this.column = cellCtrl.column;
    this.rowNode = cellCtrl.rowNode;
    this.eRow = eRow;
    const cellDiv = _createElement({
      tag: "div",
      role: cellCtrl.getCellAriaRole(),
      attrs: {
        "comp-id": `${this.getCompId()}`,
        "col-id": cellCtrl.column.colIdSanitised
      }
    });
    this.eCell = cellDiv;
    let wrapperDiv;
    if (cellCtrl.isCellSpanning()) {
      wrapperDiv = _createElement({
        tag: "div",
        cls: "ag-spanned-cell-wrapper",
        role: "presentation"
      });
      wrapperDiv.appendChild(cellDiv);
      this.setTemplateFromElement(wrapperDiv);
    } else {
      this.setTemplateFromElement(cellDiv);
    }
    this.cellCssManager = new CssClassManager(() => cellDiv);
    this.forceWrapper = cellCtrl.isForceWrapper();
    this.refreshWrapper(false);
    const compProxy = {
      toggleCss: (cssClassName, on) => this.cellCssManager.toggleCss(cssClassName, on),
      setUserStyles: (styles) => _addStylesToElement(cellDiv, styles),
      getFocusableElement: () => cellDiv,
      setIncludeSelection: (include) => this.includeSelection = include,
      setIncludeRowDrag: (include) => this.includeRowDrag = include,
      setIncludeDndSource: (include) => this.includeDndSource = include,
      setRenderDetails: (compDetails, valueToDisplay, force) => this.setRenderDetails(compDetails, valueToDisplay, force),
      setEditDetails: (compDetails, popup, position) => this.setEditDetails(compDetails, popup, position),
      getCellEditor: () => this.cellEditor || null,
      getCellRenderer: () => this.cellRenderer || null,
      getParentOfValue: () => this.getParentOfValue(),
      refreshEditStyles: (editing, isPopup) => this.refreshEditStyles(editing, isPopup)
    };
    cellCtrl.setComp(compProxy, cellDiv, wrapperDiv, this.eCellWrapper, printLayout, editingCell, void 0);
  }
  getParentOfValue() {
    return this.eCellValue ?? this.eCellWrapper ?? this.eCell;
  }
  setRenderDetails(compDetails, valueToDisplay, forceNewCellRendererInstance) {
    const isInlineEditing = this.cellEditor && !this.cellEditorPopupWrapper;
    if (isInlineEditing) {
      return;
    }
    this.firstRender = this.firstRender == null;
    const controlWrapperChanged = this.refreshWrapper(false);
    this.refreshEditStyles(false);
    if (compDetails) {
      const neverRefresh = forceNewCellRendererInstance || controlWrapperChanged;
      const cellRendererRefreshSuccessful = neverRefresh ? false : this.refreshCellRenderer(compDetails);
      if (!cellRendererRefreshSuccessful) {
        this.destroyRenderer();
        this.createCellRendererInstance(compDetails);
      }
    } else {
      this.destroyRenderer();
      this.insertValueWithoutCellRenderer(valueToDisplay);
    }
  }
  setEditDetails(compDetails, popup, position) {
    if (compDetails) {
      this.createCellEditorInstance(compDetails, popup, position);
    } else {
      this.destroyEditor();
    }
  }
  removeControls() {
    const context = this.beans.context;
    this.checkboxSelectionComp = context.destroyBean(this.checkboxSelectionComp);
    this.dndSourceComp = context.destroyBean(this.dndSourceComp);
    this.rowDraggingComp = context.destroyBean(this.rowDraggingComp);
  }
  // returns true if wrapper was changed
  refreshWrapper(editing) {
    const providingControls = this.includeRowDrag || this.includeDndSource || this.includeSelection;
    const usingWrapper = providingControls || this.forceWrapper;
    const putWrapperIn = usingWrapper && this.eCellWrapper == null;
    if (putWrapperIn) {
      this.eCellWrapper = _createElement({ tag: "div", cls: "ag-cell-wrapper", role: "presentation" });
      this.eCell.appendChild(this.eCellWrapper);
    }
    const takeWrapperOut = !usingWrapper && this.eCellWrapper != null;
    if (takeWrapperOut) {
      _removeFromParent(this.eCellWrapper);
      this.eCellWrapper = void 0;
    }
    this.cellCssManager.toggleCss("ag-cell-value", !usingWrapper);
    const usingCellValue = !editing && usingWrapper;
    const putCellValueIn = usingCellValue && this.eCellValue == null;
    if (putCellValueIn) {
      this.eCellValue = _createElement({ tag: "span", cls: "ag-cell-value", role: "presentation" });
      this.eCellWrapper.appendChild(this.eCellValue);
    }
    const takeCellValueOut = !usingCellValue && this.eCellValue != null;
    if (takeCellValueOut) {
      _removeFromParent(this.eCellValue);
      this.eCellValue = void 0;
    }
    const templateChanged = putWrapperIn || takeWrapperOut || putCellValueIn || takeCellValueOut;
    if (templateChanged) {
      this.removeControls();
    }
    if (!editing && providingControls) {
      this.addControls();
    }
    return templateChanged;
  }
  addControls() {
    const { cellCtrl, eCellWrapper, eCellValue, includeRowDrag, includeDndSource, includeSelection } = this;
    const insertBefore = (comp) => {
      if (comp) {
        eCellWrapper.insertBefore(comp.getGui(), eCellValue);
      }
    };
    if (includeRowDrag && this.rowDraggingComp == null) {
      this.rowDraggingComp = cellCtrl.createRowDragComp();
      insertBefore(this.rowDraggingComp);
    }
    if (includeDndSource && this.dndSourceComp == null) {
      this.dndSourceComp = cellCtrl.createDndSource();
      insertBefore(this.dndSourceComp);
    }
    if (includeSelection && this.checkboxSelectionComp == null) {
      this.checkboxSelectionComp = cellCtrl.createSelectionCheckbox();
      insertBefore(this.checkboxSelectionComp);
    }
  }
  createCellEditorInstance(compDetails, popup, position) {
    const versionCopy = this.editorVersion;
    const cellEditorPromise = compDetails.newAgStackInstance();
    const { params } = compDetails;
    cellEditorPromise.then((c) => this.afterCellEditorCreated(versionCopy, c, params, popup, position));
    const cellEditorAsync = _missing(this.cellEditor);
    if (cellEditorAsync && params.cellStartedEdit) {
      this.cellCtrl.focusCell(true);
    }
  }
  insertValueWithoutCellRenderer(valueToDisplay) {
    const eParent = this.getParentOfValue();
    _clearElement(eParent);
    const escapedValue = _toString(valueToDisplay);
    if (escapedValue != null) {
      eParent.textContent = escapedValue;
    }
  }
  destroyRenderer() {
    const { context } = this.beans;
    this.cellRenderer = context.destroyBean(this.cellRenderer);
    _removeFromParent(this.cellRendererGui);
    this.cellRendererGui = null;
    this.rendererVersion++;
  }
  destroyEditor() {
    const { context } = this.beans;
    const recoverFocus = this.cellEditorPopupWrapper?.getGui().contains(_getActiveDomElement(this.beans)) || this.cellCtrl.hasBrowserFocus();
    if (recoverFocus) {
      this.eCell.focus({ preventScroll: true });
    }
    this.hideEditorPopup?.();
    this.hideEditorPopup = void 0;
    this.cellEditor = context.destroyBean(this.cellEditor);
    this.cellEditorPopupWrapper = context.destroyBean(this.cellEditorPopupWrapper);
    _removeFromParent(this.cellEditorGui);
    this.cellCtrl.disableEditorTooltipFeature();
    this.cellEditorGui = null;
    this.editorVersion++;
  }
  refreshCellRenderer(compClassAndParams) {
    if (this.cellRenderer?.refresh == null) {
      return false;
    }
    if (this.cellRendererClass !== compClassAndParams.componentClass) {
      return false;
    }
    const result = this.cellRenderer.refresh(compClassAndParams.params);
    return result === true || result === void 0;
  }
  createCellRendererInstance(compDetails) {
    const displayComponentVersionCopy = this.rendererVersion;
    const createCellRendererFunc = (details) => (_) => {
      const staleTask = this.rendererVersion !== displayComponentVersionCopy || !this.isAlive();
      if (staleTask) {
        return;
      }
      const componentPromise = details.newAgStackInstance();
      const callback = this.afterCellRendererCreated.bind(
        this,
        displayComponentVersionCopy,
        details.componentClass
      );
      componentPromise?.then(callback);
    };
    const { animationFrameSvc } = this.beans;
    let createTask;
    if (animationFrameSvc?.active && this.firstRender) {
      createTask = (details, isDeferred = false) => {
        animationFrameSvc.createTask(
          createCellRendererFunc(details),
          this.rowNode.rowIndex,
          "p2",
          details.componentFromFramework,
          isDeferred
        );
      };
    } else {
      createTask = (details) => createCellRendererFunc(details)();
    }
    if (compDetails.params?.deferRender && !this.cellCtrl.rowNode.group) {
      const { loadingComp, onReady } = this.cellCtrl.getDeferLoadingCellRenderer();
      if (loadingComp) {
        createTask(loadingComp);
        onReady.then(() => createTask(compDetails, true));
      }
    } else {
      createTask(compDetails);
    }
  }
  afterCellRendererCreated(cellRendererVersion, cellRendererClass, cellRenderer) {
    const staleTask = !this.isAlive() || cellRendererVersion !== this.rendererVersion;
    if (staleTask) {
      this.beans.context.destroyBean(cellRenderer);
      return;
    }
    this.cellRenderer = cellRenderer;
    this.cellRendererClass = cellRendererClass;
    const cellGui = cellRenderer.getGui();
    this.cellRendererGui = cellGui;
    if (cellGui != null) {
      const eParent = this.getParentOfValue();
      _clearElement(eParent);
      eParent.appendChild(cellGui);
    }
  }
  afterCellEditorCreated(requestVersion, cellEditor, params, popup, position) {
    const staleComp = requestVersion !== this.editorVersion;
    const { context } = this.beans;
    if (staleComp) {
      context.destroyBean(cellEditor);
      return;
    }
    const editingCancelledByUserComp = cellEditor.isCancelBeforeStart && cellEditor.isCancelBeforeStart();
    if (editingCancelledByUserComp) {
      context.destroyBean(cellEditor);
      this.cellCtrl.stopEditing(true);
      return;
    }
    if (!cellEditor.getGui) {
      _warn(97, { colId: this.column.getId() });
      context.destroyBean(cellEditor);
      return;
    }
    this.cellEditor = cellEditor;
    this.cellEditorGui = cellEditor.getGui();
    const cellEditorInPopup = popup || cellEditor.isPopup !== void 0 && cellEditor.isPopup();
    if (cellEditorInPopup) {
      this.addPopupCellEditor(params, position);
    } else {
      this.addInCellEditor();
    }
    this.refreshEditStyles(true, cellEditorInPopup);
    cellEditor.afterGuiAttached?.();
    this.cellCtrl.enableEditorTooltipFeature(cellEditor);
    this.cellCtrl.cellEditorAttached();
  }
  refreshEditStyles(editing, isPopup) {
    const { cellCssManager } = this;
    cellCssManager.toggleCss("ag-cell-inline-editing", editing && !isPopup);
    cellCssManager.toggleCss("ag-cell-popup-editing", editing && !!isPopup);
    cellCssManager.toggleCss("ag-cell-not-inline-editing", !editing || !!isPopup);
  }
  addInCellEditor() {
    const { eCell } = this;
    if (eCell.contains(_getActiveDomElement(this.beans))) {
      eCell.focus();
    }
    this.destroyRenderer();
    this.refreshWrapper(true);
    _clearElement(this.getParentOfValue());
    if (this.cellEditorGui) {
      const eParent = this.getParentOfValue();
      eParent.appendChild(this.cellEditorGui);
    }
  }
  addPopupCellEditor(params, position) {
    const { gos, context, popupSvc, editSvc } = this.beans;
    if (gos.get("editType") === "fullRow") {
      _warn(98);
    }
    const cellEditorPopupWrapper = this.cellEditorPopupWrapper = context.createBean(
      editSvc.createPopupEditorWrapper(params)
    );
    const { cellEditor, cellEditorGui, eCell, rowNode, column, cellCtrl } = this;
    const ePopupGui = cellEditorPopupWrapper.getGui();
    if (cellEditorGui) {
      ePopupGui.appendChild(cellEditorGui);
    }
    const useModelPopup = gos.get("stopEditingWhenCellsLoseFocus");
    const positionToUse = position != null ? position : cellEditor.getPopupPosition?.() ?? "over";
    const isRtl = gos.get("enableRtl");
    const positionParams = {
      ePopup: ePopupGui,
      column,
      rowNode,
      type: "popupCellEditor",
      eventSource: eCell,
      position: positionToUse,
      alignSide: isRtl ? "right" : "left",
      keepWithinBounds: true
    };
    const positionCallback = popupSvc.positionPopupByComponent.bind(popupSvc, positionParams);
    const addPopupRes = popupSvc.addPopup({
      modal: useModelPopup,
      eChild: ePopupGui,
      closeOnEsc: true,
      closedCallback: () => {
        cellCtrl.onPopupEditorClosed();
      },
      anchorToElement: eCell,
      positionCallback,
      ariaOwns: eCell
    });
    if (addPopupRes) {
      this.hideEditorPopup = addPopupRes.hideFunc;
    }
  }
  detach() {
    this.eRow.removeChild(this.getGui());
  }
  // if the row is also getting destroyed, then we don't need to remove from dom,
  // as the row will also get removed, so no need to take out the cells from the row
  // if the row is going (removing is an expensive operation, so only need to remove
  // the top part)
  //
  // note - this is NOT called by context, as we don't wire / unwire the CellComp for performance reasons.
  destroy() {
    this.destroyRenderer();
    this.destroyEditor();
    this.removeControls();
    super.destroy();
  }
};

// packages/ag-grid-community/src/rendering/row/rowComp.ts
var RowComp = class extends Component {
  constructor(ctrl, beans, containerType) {
    super();
    this.cellComps = /* @__PURE__ */ new Map();
    this.beans = beans;
    this.rowCtrl = ctrl;
    const rowDiv = _createElement({ tag: "div", role: "row", attrs: { "comp-id": `${this.getCompId()}` } });
    this.setInitialStyle(rowDiv, containerType);
    this.setTemplateFromElement(rowDiv);
    const style = rowDiv.style;
    this.domOrder = this.rowCtrl.getDomOrder();
    const compProxy = {
      setDomOrder: (domOrder) => this.domOrder = domOrder,
      setCellCtrls: (cellCtrls) => this.setCellCtrls(cellCtrls),
      showFullWidth: (compDetails) => this.showFullWidth(compDetails),
      getFullWidthCellRenderer: () => this.fullWidthCellRenderer,
      toggleCss: (name, on) => this.toggleCss(name, on),
      setUserStyles: (styles) => _addStylesToElement(rowDiv, styles),
      setTop: (top) => style.top = top,
      setTransform: (transform) => style.transform = transform,
      setRowIndex: (rowIndex) => rowDiv.setAttribute("row-index", rowIndex),
      setRowId: (rowId) => rowDiv.setAttribute("row-id", rowId),
      setRowBusinessKey: (businessKey) => rowDiv.setAttribute("row-business-key", businessKey),
      refreshFullWidth: (getUpdatedParams) => this.fullWidthCellRenderer?.refresh?.(getUpdatedParams()) ?? false
    };
    ctrl.setComp(compProxy, this.getGui(), containerType, void 0);
    this.addDestroyFunc(() => {
      ctrl.unsetComp(containerType);
    });
  }
  setInitialStyle(container, containerType) {
    const transform = this.rowCtrl.getInitialTransform(containerType);
    if (transform) {
      container.style.setProperty("transform", transform);
    } else {
      const top = this.rowCtrl.getInitialRowTop(containerType);
      if (top) {
        container.style.setProperty("top", top);
      }
    }
  }
  showFullWidth(compDetails) {
    const callback = (cellRenderer) => {
      if (this.isAlive()) {
        const eGui = cellRenderer.getGui();
        this.getGui().appendChild(eGui);
        this.rowCtrl.setupDetailRowAutoHeight(eGui);
        this.setFullWidthRowComp(cellRenderer);
      } else {
        this.beans.context.destroyBean(cellRenderer);
      }
    };
    const res = compDetails.newAgStackInstance();
    res.then(callback);
  }
  setCellCtrls(cellCtrls) {
    const cellsToRemove = new Map(this.cellComps);
    for (const cellCtrl of cellCtrls) {
      const key = cellCtrl.instanceId;
      if (!this.cellComps.has(key)) {
        this.newCellComp(cellCtrl);
      } else {
        cellsToRemove.delete(key);
      }
    }
    this.destroyCells(cellsToRemove);
    this.ensureDomOrder(cellCtrls);
  }
  ensureDomOrder(cellCtrls) {
    if (!this.domOrder) {
      return;
    }
    const elementsInOrder = [];
    for (const cellCtrl of cellCtrls) {
      const cellComp = this.cellComps.get(cellCtrl.instanceId);
      if (cellComp) {
        elementsInOrder.push(cellComp.getGui());
      }
    }
    _setDomChildOrder(this.getGui(), elementsInOrder);
  }
  newCellComp(cellCtrl) {
    const editing = this.beans.editSvc?.isEditing(cellCtrl, { withOpenEditor: true }) ?? false;
    const cellComp = new CellComp(this.beans, cellCtrl, this.rowCtrl.printLayout, this.getGui(), editing);
    this.cellComps.set(cellCtrl.instanceId, cellComp);
    this.getGui().appendChild(cellComp.getGui());
  }
  destroy() {
    super.destroy();
    this.destroyCells(this.cellComps);
  }
  setFullWidthRowComp(fullWidthRowComponent) {
    this.fullWidthCellRenderer = fullWidthRowComponent;
    this.addDestroyFunc(() => {
      this.fullWidthCellRenderer = this.beans.context.destroyBean(this.fullWidthCellRenderer);
    });
  }
  destroyCells(cellComps) {
    for (const cellComp of cellComps.values()) {
      if (!cellComp) {
        return;
      }
      const instanceId = cellComp.cellCtrl.instanceId;
      if (this.cellComps.get(instanceId) !== cellComp) {
        return;
      }
      cellComp.detach();
      cellComp.destroy();
      this.cellComps.delete(instanceId);
    }
  }
};

// packages/ag-grid-community/src/gridBodyComp/rowContainer/rowContainerComp.ts
function getElementParams(name, options, beans) {
  const isCellSpanning = !!beans.gos.get("enableCellSpan") && !!options.getSpannedRowCtrls;
  const eContainerElement = {
    tag: "div",
    ref: "eContainer",
    cls: _getRowContainerClass(name),
    role: "rowgroup"
  };
  if (options.type === "center" || isCellSpanning) {
    const eSpannedContainerElement = {
      tag: "div",
      ref: "eSpannedContainer",
      cls: `ag-spanning-container ${_getRowSpanContainerClass(name)}`,
      role: "rowgroup"
    };
    return {
      tag: "div",
      ref: "eViewport",
      cls: `ag-viewport ${_getRowViewportClass(name)}`,
      role: "presentation",
      children: [eContainerElement, isCellSpanning ? eSpannedContainerElement : null]
    };
  }
  return eContainerElement;
}
var RowContainerComp = class extends Component {
  constructor(params) {
    super();
    this.eViewport = RefPlaceholder;
    this.eContainer = RefPlaceholder;
    this.eSpannedContainer = RefPlaceholder;
    this.rowCompsNoSpan = {};
    this.rowCompsWithSpan = {};
    this.name = params?.name;
    this.options = _getRowContainerOptions(this.name);
  }
  postConstruct() {
    this.setTemplate(getElementParams(this.name, this.options, this.beans));
    const compProxy = {
      setHorizontalScroll: (offset) => this.eViewport.scrollLeft = offset,
      setViewportHeight: (height) => this.eViewport.style.height = height,
      setRowCtrls: ({ rowCtrls }) => this.setRowCtrls(rowCtrls),
      setSpannedRowCtrls: (rowCtrls) => this.setRowCtrls(rowCtrls, true),
      setDomOrder: (domOrder) => {
        this.domOrder = domOrder;
      },
      setContainerWidth: (width) => {
        this.eContainer.style.width = width;
        if (this.eSpannedContainer) {
          this.eSpannedContainer.style.width = width;
        }
      },
      setOffsetTop: (offset) => {
        const top = `translateY(${offset})`;
        this.eContainer.style.transform = top;
        if (this.eSpannedContainer) {
          this.eSpannedContainer.style.transform = top;
        }
      }
    };
    const ctrl = this.createManagedBean(new RowContainerCtrl(this.name));
    ctrl.setComp(compProxy, this.eContainer, this.eSpannedContainer, this.eViewport);
  }
  destroy() {
    this.setRowCtrls([]);
    this.setRowCtrls([], true);
    super.destroy();
    this.lastPlacedElement = null;
  }
  setRowCtrls(rowCtrls, spanContainer) {
    const { beans, options } = this;
    const container = spanContainer ? this.eSpannedContainer : this.eContainer;
    const oldRows = spanContainer ? { ...this.rowCompsWithSpan } : { ...this.rowCompsNoSpan };
    const newComps = {};
    if (spanContainer) {
      this.rowCompsWithSpan = newComps;
    } else {
      this.rowCompsNoSpan = newComps;
    }
    this.lastPlacedElement = null;
    const orderedRows = [];
    for (const rowCtrl of rowCtrls) {
      const instanceId = rowCtrl.instanceId;
      const existingRowComp = oldRows[instanceId];
      let rowComp;
      if (existingRowComp) {
        rowComp = existingRowComp;
        delete oldRows[instanceId];
      } else {
        if (!rowCtrl.rowNode.displayed) {
          continue;
        }
        rowComp = new RowComp(rowCtrl, beans, options.type);
      }
      newComps[instanceId] = rowComp;
      orderedRows.push([rowComp, !existingRowComp]);
    }
    this.removeOldRows(Object.values(oldRows), container);
    this.addRowNodes(orderedRows, container);
  }
  addRowNodes(rows, container) {
    const { domOrder } = this;
    for (const [rowComp, isNew] of rows) {
      const eGui = rowComp.getGui();
      if (!domOrder) {
        if (isNew) {
          container.appendChild(eGui);
        }
      } else {
        this.ensureDomOrder(eGui, container);
      }
    }
  }
  removeOldRows(rowComps, container) {
    for (const oldRowComp of rowComps) {
      container.removeChild(oldRowComp.getGui());
      oldRowComp.destroy();
    }
  }
  ensureDomOrder(eRow, container) {
    _ensureDomOrder(container, eRow, this.lastPlacedElement);
    this.lastPlacedElement = eRow;
  }
};
var RowContainerSelector = {
  selector: "AG-ROW-CONTAINER",
  component: RowContainerComp
};

// packages/ag-grid-community/src/gridBodyComp/gridBodyComp.ts
function makeRowContainers(paramsMap, names) {
  return names.map((name) => {
    const refName = `e${name[0].toUpperCase() + name.substring(1)}RowContainer`;
    paramsMap[refName] = { name };
    return {
      tag: "ag-row-container",
      ref: refName,
      attrs: { name }
    };
  });
}
function getGridBodyTemplate(includeOverlay) {
  const paramsMap = {};
  const elementParams = {
    tag: "div",
    ref: "eGridRoot",
    cls: "ag-root ag-unselectable",
    children: [
      { tag: "ag-header-root" },
      {
        tag: "div",
        ref: "eTop",
        cls: "ag-floating-top",
        role: "presentation",
        children: makeRowContainers(paramsMap, ["topLeft", "topCenter", "topRight", "topFullWidth"])
      },
      {
        tag: "div",
        ref: "eBody",
        cls: "ag-body",
        role: "presentation",
        children: [
          {
            tag: "div",
            ref: "eBodyViewport",
            cls: "ag-body-viewport",
            role: "presentation",
            children: makeRowContainers(paramsMap, ["left", "center", "right", "fullWidth"])
          },
          { tag: "ag-fake-vertical-scroll" }
        ]
      },
      {
        tag: "div",
        ref: "eStickyTop",
        cls: "ag-sticky-top",
        role: "presentation",
        children: makeRowContainers(paramsMap, [
          "stickyTopLeft",
          "stickyTopCenter",
          "stickyTopRight",
          "stickyTopFullWidth"
        ])
      },
      {
        tag: "div",
        ref: "eStickyBottom",
        cls: "ag-sticky-bottom",
        role: "presentation",
        children: makeRowContainers(paramsMap, [
          "stickyBottomLeft",
          "stickyBottomCenter",
          "stickyBottomRight",
          "stickyBottomFullWidth"
        ])
      },
      {
        tag: "div",
        ref: "eBottom",
        cls: "ag-floating-bottom",
        role: "presentation",
        children: makeRowContainers(paramsMap, [
          "bottomLeft",
          "bottomCenter",
          "bottomRight",
          "bottomFullWidth"
        ])
      },
      { tag: "ag-fake-horizontal-scroll" },
      includeOverlay ? { tag: "ag-overlay-wrapper" } : null
    ]
  };
  return { paramsMap, elementParams };
}
var GridBodyComp = class extends Component {
  constructor() {
    super(...arguments);
    this.eGridRoot = RefPlaceholder;
    this.eBodyViewport = RefPlaceholder;
    this.eStickyTop = RefPlaceholder;
    this.eStickyBottom = RefPlaceholder;
    this.eTop = RefPlaceholder;
    this.eBottom = RefPlaceholder;
    this.eBody = RefPlaceholder;
  }
  postConstruct() {
    const { overlays, rangeSvc } = this.beans;
    const overlaySelector = overlays?.getOverlayWrapperSelector();
    const { paramsMap, elementParams } = getGridBodyTemplate(!!overlaySelector);
    this.setTemplate(
      elementParams,
      [
        ...overlaySelector ? [overlaySelector] : [],
        FakeHScrollSelector,
        FakeVScrollSelector,
        GridHeaderSelector,
        RowContainerSelector
      ],
      paramsMap
    );
    const setHeight = (height, element) => {
      const heightString = `${height}px`;
      element.style.minHeight = heightString;
      element.style.height = heightString;
    };
    const compProxy = {
      setRowAnimationCssOnBodyViewport: (cssClass, animate) => this.setRowAnimationCssOnBodyViewport(cssClass, animate),
      setColumnCount: (count) => _setAriaColCount(this.getGui(), count),
      setRowCount: (count) => _setAriaRowCount(this.getGui(), count),
      setTopHeight: (height) => setHeight(height, this.eTop),
      setBottomHeight: (height) => setHeight(height, this.eBottom),
      setTopInvisible: (invisible) => this.eTop.classList.toggle("ag-invisible", invisible),
      setBottomInvisible: (invisible) => this.eBottom.classList.toggle("ag-invisible", invisible),
      setStickyTopHeight: (height) => this.eStickyTop.style.height = height,
      setStickyTopTop: (top) => this.eStickyTop.style.top = top,
      setStickyTopWidth: (width) => this.eStickyTop.style.width = width,
      setStickyBottomHeight: (height) => {
        this.eStickyBottom.style.height = height;
        this.eStickyBottom.classList.toggle("ag-invisible", height === "0px");
      },
      setStickyBottomBottom: (bottom) => this.eStickyBottom.style.bottom = bottom,
      setStickyBottomWidth: (width) => this.eStickyBottom.style.width = width,
      setColumnMovingCss: (cssClass, flag) => this.toggleCss(cssClass, flag),
      updateLayoutClasses: (cssClass, params) => {
        const classLists = [this.eBodyViewport.classList, this.eBody.classList];
        for (const classList of classLists) {
          classList.toggle(LayoutCssClasses.AUTO_HEIGHT, params.autoHeight);
          classList.toggle(LayoutCssClasses.NORMAL, params.normal);
          classList.toggle(LayoutCssClasses.PRINT, params.print);
        }
        this.toggleCss(LayoutCssClasses.AUTO_HEIGHT, params.autoHeight);
        this.toggleCss(LayoutCssClasses.NORMAL, params.normal);
        this.toggleCss(LayoutCssClasses.PRINT, params.print);
      },
      setAlwaysVerticalScrollClass: (cssClass, on) => this.eBodyViewport.classList.toggle(CSS_CLASS_FORCE_VERTICAL_SCROLL, on),
      registerBodyViewportResizeListener: (listener) => {
        const unsubscribeFromResize = _observeResize(this.beans, this.eBodyViewport, listener);
        this.addDestroyFunc(() => unsubscribeFromResize());
      },
      setPinnedTopBottomOverflowY: (overflow) => this.eTop.style.overflowY = this.eBottom.style.overflowY = overflow,
      setCellSelectableCss: (cssClass, selectable) => {
        [this.eTop, this.eBodyViewport, this.eBottom].forEach(
          (ct) => ct.classList.toggle(cssClass, selectable)
        );
      },
      setBodyViewportWidth: (width) => this.eBodyViewport.style.width = width,
      setGridRootRole: (role) => _setAriaRole(this.eGridRoot, role)
    };
    this.ctrl = this.createManagedBean(new GridBodyCtrl());
    this.ctrl.setComp(
      compProxy,
      this.getGui(),
      this.eBodyViewport,
      this.eTop,
      this.eBottom,
      this.eStickyTop,
      this.eStickyBottom
    );
    if (rangeSvc && _isCellSelectionEnabled(this.gos) || _isMultiRowSelection(this.gos)) {
      _setAriaMultiSelectable(this.getGui(), true);
    }
  }
  setRowAnimationCssOnBodyViewport(cssClass, animateRows) {
    const bodyViewportClassList = this.eBodyViewport.classList;
    bodyViewportClassList.toggle("ag-row-animation", animateRows);
    bodyViewportClassList.toggle("ag-row-no-animation", !animateRows);
  }
};
var GridBodySelector = {
  selector: "AG-GRID-BODY",
  component: GridBodyComp
};

// packages/ag-grid-community/src/gridComp/gridCtrl.ts
var GridCtrl = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.additionalFocusableContainers = /* @__PURE__ */ new Set();
  }
  setComp(view, eGridDiv, eGui) {
    this.view = view;
    this.eGridHostDiv = eGridDiv;
    this.eGui = eGui;
    this.eGui.setAttribute("grid-id", this.beans.context.getGridId());
    const { dragAndDrop, ctrlsSvc } = this.beans;
    dragAndDrop?.registerGridDropTarget(() => this.eGui, this);
    _stampTopLevelGridCompWithGridInstance(this.gos, eGridDiv);
    this.createManagedBean(new LayoutFeature(this.view));
    this.view.setRtlClass(this.gos.get("enableRtl") ? "ag-rtl" : "ag-ltr");
    const unsubscribeFromResize = _observeResize(this.beans, this.eGridHostDiv, this.onGridSizeChanged.bind(this));
    this.addDestroyFunc(() => unsubscribeFromResize());
    ctrlsSvc.register("gridCtrl", this);
  }
  isDetailGrid() {
    const el = _findTabbableParent(this.getGui());
    return el?.getAttribute("row-id")?.startsWith("detail") || false;
  }
  getOptionalSelectors() {
    const beans = this.beans;
    return {
      paginationSelector: beans.pagination?.getPaginationSelector(),
      gridHeaderDropZonesSelector: beans.registry?.getSelector("AG-GRID-HEADER-DROP-ZONES"),
      sideBarSelector: beans.sideBar?.getSelector(),
      statusBarSelector: beans.registry?.getSelector("AG-STATUS-BAR"),
      watermarkSelector: beans.licenseManager?.getWatermarkSelector()
    };
  }
  onGridSizeChanged() {
    this.eventSvc.dispatchEvent({
      type: "gridSizeChanged",
      clientWidth: this.eGridHostDiv.clientWidth,
      clientHeight: this.eGridHostDiv.clientHeight
    });
  }
  destroyGridUi() {
    this.view.destroyGridUi();
  }
  getGui() {
    return this.eGui;
  }
  setResizeCursor(direction) {
    const { view } = this;
    if (direction === false) {
      view.setCursor(null);
    } else {
      const cursor = direction === 1 /* Horizontal */ ? "ew-resize" : "ns-resize";
      view.setCursor(cursor);
    }
  }
  disableUserSelect(on) {
    this.view.setUserSelect(on ? "none" : null);
  }
  focusNextInnerContainer(backwards) {
    const focusableContainers = this.getFocusableContainers();
    const { indexWithFocus, nextIndex } = this.getNextFocusableIndex(focusableContainers, backwards);
    if (nextIndex < 0 || nextIndex >= focusableContainers.length) {
      return false;
    }
    if (nextIndex === 0) {
      if (indexWithFocus > 0) {
        const { visibleCols, focusSvc } = this.beans;
        const allColumns = visibleCols.allCols;
        const lastColumn = _last(allColumns);
        if (focusSvc.focusGridView({ column: lastColumn, backwards: true })) {
          return true;
        }
      }
      return false;
    }
    return this.focusContainer(focusableContainers[nextIndex], backwards);
  }
  focusInnerElement(fromBottom) {
    const userCallbackFunction = this.gos.getCallback("focusGridInnerElement");
    if (userCallbackFunction && userCallbackFunction({ fromBottom: !!fromBottom })) {
      return true;
    }
    const focusableContainers = this.getFocusableContainers();
    const { focusSvc, visibleCols } = this.beans;
    const allColumns = visibleCols.allCols;
    if (fromBottom) {
      if (focusableContainers.length > 1) {
        return this.focusContainer(_last(focusableContainers), fromBottom);
      }
      const lastColumn = _last(allColumns);
      if (focusSvc.focusGridView({ column: lastColumn, backwards: fromBottom })) {
        return true;
      }
    }
    if (this.gos.get("headerHeight") === 0 || _isHeaderFocusSuppressed(this.beans)) {
      if (focusSvc.focusGridView({ column: allColumns[0], backwards: fromBottom })) {
        return true;
      }
      for (let i = 1; i < focusableContainers.length; i++) {
        if (_focusInto(focusableContainers[i].getGui(), fromBottom)) {
          return true;
        }
      }
      return false;
    }
    return focusSvc.focusFirstHeader();
  }
  forceFocusOutOfContainer(up = false) {
    this.view.forceFocusOutOfContainer(up);
  }
  addFocusableContainer(container) {
    this.additionalFocusableContainers.add(container);
  }
  removeFocusableContainer(container) {
    this.additionalFocusableContainers.delete(container);
  }
  allowFocusForNextCoreContainer(up) {
    const coreContainers = this.view.getFocusableContainers();
    const { nextIndex, indexWithFocus } = this.getNextFocusableIndex(coreContainers, up);
    if (indexWithFocus === -1 || nextIndex < 0 || nextIndex >= coreContainers.length) {
      return;
    }
    const comp = coreContainers[nextIndex];
    comp.setAllowFocus?.(true);
    setTimeout(() => {
      comp.setAllowFocus?.(false);
    });
  }
  isFocusable() {
    const beans = this.beans;
    return !_isCellFocusSuppressed(beans) || !_isHeaderFocusSuppressed(beans) || !!beans.sideBar?.comp?.isDisplayed();
  }
  getNextFocusableIndex(focusableContainers, backwards) {
    const activeEl = _getActiveDomElement(this.beans);
    const indexWithFocus = focusableContainers.findIndex((container) => container.getGui().contains(activeEl));
    const nextIndex = indexWithFocus + (backwards ? -1 : 1);
    return {
      indexWithFocus,
      nextIndex
    };
  }
  focusContainer(comp, up) {
    comp.setAllowFocus?.(true);
    const result = _focusInto(comp.getGui(), up, false, true);
    comp.setAllowFocus?.(false);
    return result;
  }
  getFocusableContainers() {
    return [...this.view.getFocusableContainers(), ...this.additionalFocusableContainers];
  }
  destroy() {
    this.additionalFocusableContainers.clear();
    super.destroy();
  }
};

// packages/ag-grid-community/src/gridComp/gridComp.ts
var GridComp = class extends TabGuardComp {
  constructor(eGridDiv) {
    super();
    this.gridBody = RefPlaceholder;
    this.sideBar = RefPlaceholder;
    this.pagination = RefPlaceholder;
    this.rootWrapperBody = RefPlaceholder;
    this.eGridDiv = eGridDiv;
  }
  postConstruct() {
    const compProxy = {
      destroyGridUi: () => this.destroyBean(this),
      setRtlClass: (cssClass) => this.addCss(cssClass),
      forceFocusOutOfContainer: this.forceFocusOutOfContainer.bind(this),
      updateLayoutClasses: this.updateLayoutClasses.bind(this),
      getFocusableContainers: this.getFocusableContainers.bind(this),
      setUserSelect: (value) => {
        this.getGui().style.userSelect = value != null ? value : "";
        this.getGui().style.webkitUserSelect = value != null ? value : "";
      },
      setCursor: (value) => {
        this.getGui().style.cursor = value != null ? value : "";
      }
    };
    const ctrl = this.createManagedBean(new GridCtrl());
    const comps = ctrl.getOptionalSelectors();
    const template = this.createTemplate(comps);
    const requiredComps = [GridBodySelector, ...Object.values(comps).filter((c) => !!c)];
    this.setTemplate(template, requiredComps);
    ctrl.setComp(compProxy, this.eGridDiv, this.getGui());
    this.insertGridIntoDom();
    this.initialiseTabGuard({
      // we want to override the default behaviour to do nothing for onTabKeyDown
      onTabKeyDown: () => void 0,
      focusInnerElement: (fromBottom) => ctrl.focusInnerElement(fromBottom),
      forceFocusOutWhenTabGuardsAreEmpty: true,
      isEmpty: () => !ctrl.isFocusable()
    });
  }
  insertGridIntoDom() {
    const eGui = this.getGui();
    this.eGridDiv.appendChild(eGui);
    this.addDestroyFunc(() => {
      this.eGridDiv.removeChild(eGui);
      _logIfDebug(this.gos, "Grid removed from DOM");
    });
  }
  updateLayoutClasses(cssClass, params) {
    const eRootWrapperBodyClassList = this.rootWrapperBody.classList;
    const { AUTO_HEIGHT, NORMAL, PRINT } = LayoutCssClasses;
    const { autoHeight, normal, print } = params;
    eRootWrapperBodyClassList.toggle(AUTO_HEIGHT, autoHeight);
    eRootWrapperBodyClassList.toggle(NORMAL, normal);
    eRootWrapperBodyClassList.toggle(PRINT, print);
    this.toggleCss(AUTO_HEIGHT, autoHeight);
    this.toggleCss(NORMAL, normal);
    this.toggleCss(PRINT, print);
  }
  createTemplate(params) {
    const dropZones = params.gridHeaderDropZonesSelector ? { tag: "ag-grid-header-drop-zones" } : null;
    const sideBar = params.sideBarSelector ? {
      tag: "ag-side-bar",
      ref: "sideBar"
    } : null;
    const statusBar = params.statusBarSelector ? { tag: "ag-status-bar" } : null;
    const watermark = params.watermarkSelector ? { tag: "ag-watermark" } : null;
    const pagination = params.paginationSelector ? { tag: "ag-pagination", ref: "pagination" } : null;
    return {
      tag: "div",
      cls: "ag-root-wrapper",
      role: "presentation",
      children: [
        dropZones,
        {
          tag: "div",
          ref: "rootWrapperBody",
          cls: "ag-root-wrapper-body",
          role: "presentation",
          children: [{ tag: "ag-grid-body", ref: "gridBody" }, sideBar]
        },
        statusBar,
        pagination,
        watermark
      ]
    };
  }
  getFocusableElement() {
    return this.rootWrapperBody;
  }
  forceFocusOutOfContainer(up = false) {
    if (!up && this.pagination?.isDisplayed()) {
      this.pagination.forceFocusOutOfContainer(up);
      return;
    }
    super.forceFocusOutOfContainer(up);
  }
  getFocusableContainers() {
    const focusableContainers = [this.gridBody];
    [this.sideBar, this.pagination].forEach((comp) => {
      if (comp) {
        focusableContainers.push(comp);
      }
    });
    return focusableContainers.filter((el) => _isVisible(el.getGui()));
  }
};

// packages/ag-grid-community/src/api/gridApiFunctions.ts
var mod = (moduleName, input) => {
  for (const key of Object.keys(input)) {
    input[key] = moduleName;
  }
  return input;
};
var gridApiFunctionsMap = {
  dispatchEvent: "CommunityCore",
  // this is always registered
  ...mod("CommunityCore", {
    destroy: 0,
    getGridId: 0,
    getGridOption: 0,
    isDestroyed: 0,
    setGridOption: 0,
    updateGridOptions: 0,
    isModuleRegistered: 0
  }),
  ...mod("GridState", {
    getState: 0,
    setState: 0
  }),
  ...mod("SharedRowSelection", {
    setNodesSelected: 0,
    selectAll: 0,
    deselectAll: 0,
    selectAllFiltered: 0,
    deselectAllFiltered: 0,
    selectAllOnCurrentPage: 0,
    deselectAllOnCurrentPage: 0,
    getSelectedNodes: 0,
    getSelectedRows: 0
  }),
  ...mod("RowApi", {
    redrawRows: 0,
    setRowNodeExpanded: 0,
    getRowNode: 0,
    addRenderedRowListener: 0,
    getRenderedNodes: 0,
    forEachNode: 0,
    getFirstDisplayedRowIndex: 0,
    getLastDisplayedRowIndex: 0,
    getDisplayedRowAtIndex: 0,
    getDisplayedRowCount: 0
  }),
  ...mod("ScrollApi", {
    getVerticalPixelRange: 0,
    getHorizontalPixelRange: 0,
    ensureColumnVisible: 0,
    ensureIndexVisible: 0,
    ensureNodeVisible: 0
  }),
  ...mod("KeyboardNavigation", {
    getFocusedCell: 0,
    clearFocusedCell: 0,
    setFocusedCell: 0,
    tabToNextCell: 0,
    tabToPreviousCell: 0,
    setFocusedHeader: 0
  }),
  ...mod("EventApi", {
    addEventListener: 0,
    addGlobalListener: 0,
    removeEventListener: 0,
    removeGlobalListener: 0
  }),
  ...mod("ValueCache", {
    expireValueCache: 0
  }),
  ...mod("CellApi", {
    getCellValue: 0
  }),
  ...mod("SharedMenu", {
    showColumnMenu: 0,
    hidePopupMenu: 0
  }),
  ...mod("Sort", {
    onSortChanged: 0
  }),
  ...mod("PinnedRow", {
    getPinnedTopRowCount: 0,
    getPinnedBottomRowCount: 0,
    getPinnedTopRow: 0,
    getPinnedBottomRow: 0,
    forEachPinnedRow: 0
  }),
  ...mod("Overlay", {
    showLoadingOverlay: 0,
    showNoRowsOverlay: 0,
    hideOverlay: 0
  }),
  ...mod("RenderApi", {
    setGridAriaProperty: 0,
    refreshCells: 0,
    refreshHeader: 0,
    isAnimationFrameQueueEmpty: 0,
    flushAllAnimationFrames: 0,
    getSizesForCurrentTheme: 0,
    getCellRendererInstances: 0
  }),
  ...mod("HighlightChanges", {
    flashCells: 0
  }),
  ...mod("RowDrag", {
    addRowDropZone: 0,
    removeRowDropZone: 0,
    getRowDropZoneParams: 0,
    getRowDropPositionIndicator: 0,
    setRowDropPositionIndicator: 0
  }),
  ...mod("ColumnApi", {
    getColumnDefs: 0,
    getColumnDef: 0,
    getDisplayNameForColumn: 0,
    getColumn: 0,
    getColumns: 0,
    applyColumnState: 0,
    getColumnState: 0,
    resetColumnState: 0,
    isPinning: 0,
    isPinningLeft: 0,
    isPinningRight: 0,
    getDisplayedColAfter: 0,
    getDisplayedColBefore: 0,
    setColumnsVisible: 0,
    setColumnsPinned: 0,
    getAllGridColumns: 0,
    getDisplayedLeftColumns: 0,
    getDisplayedCenterColumns: 0,
    getDisplayedRightColumns: 0,
    getAllDisplayedColumns: 0,
    getAllDisplayedVirtualColumns: 0
  }),
  ...mod("ColumnAutoSize", {
    sizeColumnsToFit: 0,
    autoSizeColumns: 0,
    autoSizeAllColumns: 0
  }),
  ...mod("ColumnGroup", {
    setColumnGroupOpened: 0,
    getColumnGroup: 0,
    getProvidedColumnGroup: 0,
    getDisplayNameForColumnGroup: 0,
    getColumnGroupState: 0,
    setColumnGroupState: 0,
    resetColumnGroupState: 0,
    getLeftDisplayedColumnGroups: 0,
    getCenterDisplayedColumnGroups: 0,
    getRightDisplayedColumnGroups: 0,
    getAllDisplayedColumnGroups: 0
  }),
  ...mod("ColumnMove", {
    moveColumnByIndex: 0,
    moveColumns: 0
  }),
  ...mod("ColumnResize", {
    setColumnWidths: 0
  }),
  ...mod("ColumnHover", {
    isColumnHovered: 0
  }),
  ...mod("EditCore", {
    getCellEditorInstances: 0,
    getEditingCells: 0,
    stopEditing: 0,
    startEditingCell: 0,
    isEditing: 0,
    validateEdit: 0
  }),
  ...mod("BatchEdit", {
    startBatchEdit: 0,
    cancelBatchEdit: 0,
    commitBatchEdit: 0,
    isBatchEditing: 0
  }),
  ...mod("UndoRedoEdit", {
    undoCellEditing: 0,
    redoCellEditing: 0,
    getCurrentUndoSize: 0,
    getCurrentRedoSize: 0
  }),
  ...mod("FilterCore", {
    isAnyFilterPresent: 0,
    onFilterChanged: 0
  }),
  ...mod("ColumnFilter", {
    isColumnFilterPresent: 0,
    getColumnFilterInstance: 0,
    destroyFilter: 0,
    setFilterModel: 0,
    getFilterModel: 0,
    getColumnFilterModel: 0,
    setColumnFilterModel: 0,
    showColumnFilter: 0,
    hideColumnFilter: 0,
    getColumnFilterHandler: 0,
    doFilterAction: 0
  }),
  ...mod("QuickFilter", {
    isQuickFilterPresent: 0,
    getQuickFilter: 0,
    resetQuickFilter: 0
  }),
  ...mod("Find", {
    findGetActiveMatch: 0,
    findGetTotalMatches: 0,
    findGoTo: 0,
    findNext: 0,
    findPrevious: 0,
    findGetNumMatches: 0,
    findGetParts: 0,
    findClearActive: 0,
    findRefresh: 0
  }),
  ...mod("Pagination", {
    paginationIsLastPageFound: 0,
    paginationGetPageSize: 0,
    paginationGetCurrentPage: 0,
    paginationGetTotalPages: 0,
    paginationGetRowCount: 0,
    paginationGoToNextPage: 0,
    paginationGoToPreviousPage: 0,
    paginationGoToFirstPage: 0,
    paginationGoToLastPage: 0,
    paginationGoToPage: 0
  }),
  ...mod("CsrmSsrmSharedApi", {
    expandAll: 0,
    collapseAll: 0,
    onRowHeightChanged: 0
  }),
  ...mod("SsrmInfiniteSharedApi", {
    setRowCount: 0,
    getCacheBlockState: 0,
    isLastRowIndexKnown: 0
  }),
  ...mod("ClientSideRowModelApi", {
    onGroupExpandedOrCollapsed: 0,
    refreshClientSideRowModel: 0,
    isRowDataEmpty: 0,
    forEachLeafNode: 0,
    forEachNodeAfterFilter: 0,
    forEachNodeAfterFilterAndSort: 0,
    resetRowHeights: 0,
    applyTransaction: 0,
    applyTransactionAsync: 0,
    flushAsyncTransactions: 0,
    getBestCostNodeSelection: 0
  }),
  ...mod("CsvExport", {
    getDataAsCsv: 0,
    exportDataAsCsv: 0
  }),
  ...mod("InfiniteRowModel", {
    refreshInfiniteCache: 0,
    purgeInfiniteCache: 0,
    getInfiniteRowCount: 0
  }),
  ...mod("AdvancedFilter", {
    getAdvancedFilterModel: 0,
    setAdvancedFilterModel: 0,
    showAdvancedFilterBuilder: 0,
    hideAdvancedFilterBuilder: 0
  }),
  ...mod("IntegratedCharts", {
    getChartModels: 0,
    getChartRef: 0,
    getChartImageDataURL: 0,
    downloadChart: 0,
    openChartToolPanel: 0,
    closeChartToolPanel: 0,
    createRangeChart: 0,
    createPivotChart: 0,
    createCrossFilterChart: 0,
    updateChart: 0,
    restoreChart: 0
  }),
  ...mod("Clipboard", {
    copyToClipboard: 0,
    cutToClipboard: 0,
    copySelectedRowsToClipboard: 0,
    copySelectedRangeToClipboard: 0,
    copySelectedRangeDown: 0,
    pasteFromClipboard: 0
  }),
  ...mod("ExcelExport", {
    getDataAsExcel: 0,
    exportDataAsExcel: 0,
    getSheetDataForExcel: 0,
    getMultipleSheetsAsExcel: 0,
    exportMultipleSheetsAsExcel: 0
  }),
  ...mod("SharedMasterDetail", {
    addDetailGridInfo: 0,
    removeDetailGridInfo: 0,
    getDetailGridInfo: 0,
    forEachDetailGridInfo: 0
  }),
  ...mod("ContextMenu", {
    showContextMenu: 0
  }),
  ...mod("ColumnMenu", {
    showColumnChooser: 0,
    hideColumnChooser: 0
  }),
  ...mod("CellSelection", {
    getCellRanges: 0,
    addCellRange: 0,
    clearRangeSelection: 0,
    clearCellSelection: 0
  }),
  ...mod("SharedRowGrouping", {
    setRowGroupColumns: 0,
    removeRowGroupColumns: 0,
    addRowGroupColumns: 0,
    getRowGroupColumns: 0,
    moveRowGroupColumn: 0
  }),
  ...mod("SharedAggregation", {
    addAggFuncs: 0,
    clearAggFuncs: 0,
    setColumnAggFunc: 0
  }),
  ...mod("SharedPivot", {
    isPivotMode: 0,
    getPivotResultColumn: 0,
    setValueColumns: 0,
    getValueColumns: 0,
    removeValueColumns: 0,
    addValueColumns: 0,
    setPivotColumns: 0,
    removePivotColumns: 0,
    addPivotColumns: 0,
    getPivotColumns: 0,
    setPivotResultColumns: 0,
    getPivotResultColumns: 0
  }),
  ...mod("ServerSideRowModelApi", {
    getServerSideSelectionState: 0,
    setServerSideSelectionState: 0,
    applyServerSideTransaction: 0,
    applyServerSideTransactionAsync: 0,
    applyServerSideRowData: 0,
    retryServerSideLoads: 0,
    flushServerSideAsyncTransactions: 0,
    refreshServerSide: 0,
    getServerSideGroupLevelState: 0
  }),
  ...mod("SideBar", {
    isSideBarVisible: 0,
    setSideBarVisible: 0,
    setSideBarPosition: 0,
    openToolPanel: 0,
    closeToolPanel: 0,
    getOpenedToolPanel: 0,
    refreshToolPanel: 0,
    isToolPanelShowing: 0,
    getToolPanelInstance: 0,
    getSideBar: 0
  }),
  ...mod("StatusBar", {
    getStatusPanel: 0
  })
};

// packages/ag-grid-community/src/api/apiFunctionService.ts
var defaultFns = {
  isDestroyed: () => true,
  destroy() {
  },
  preConstruct() {
  },
  postConstruct() {
  },
  preWireBeans() {
  },
  wireBeans() {
  }
};
var dispatchEvent = (beans, event) => beans.eventSvc.dispatchEvent(event);
var GridApiClass = class {
};
Reflect.defineProperty(GridApiClass, "name", { value: "GridApi" });
var ApiFunctionService = class extends BeanStub {
  constructor() {
    super();
    this.beanName = "apiFunctionSvc";
    this.api = new GridApiClass();
    this.fns = {
      ...defaultFns,
      // dispatchEvent is used by frameworks, also used by aligned grids to identify a grid api instance
      dispatchEvent
    };
    this.preDestroyLink = "";
    const { api } = this;
    for (const key of Object.keys(gridApiFunctionsMap)) {
      api[key] = this.makeApi(key)[key];
    }
  }
  postConstruct() {
    this.preDestroyLink = this.beans.frameworkOverrides.getDocLink("grid-lifecycle/#grid-pre-destroyed");
  }
  addFunction(functionName, func) {
    const { fns, beans } = this;
    if (fns !== defaultFns) {
      fns[functionName] = beans?.validation?.validateApiFunction(functionName, func) ?? func;
    }
  }
  makeApi(apiName) {
    return {
      [apiName]: (...args) => {
        const {
          beans,
          fns: { [apiName]: fn }
        } = this;
        return fn ? fn(beans, ...args) : this.apiNotFound(apiName);
      }
    };
  }
  apiNotFound(fnName) {
    const { beans, gos, preDestroyLink } = this;
    if (!beans) {
      _warn(26, { fnName, preDestroyLink });
    } else {
      const module2 = gridApiFunctionsMap[fnName];
      if (gos.assertModuleRegistered(module2, `api.${fnName}`)) {
        _warn(27, { fnName, module: module2 });
      }
    }
  }
  destroy() {
    super.destroy();
    this.fns = defaultFns;
    this.beans = null;
  }
};

// packages/ag-grid-community/src/api/coreApi.ts
function getGridId(beans) {
  return beans.context.getGridId();
}
function destroy(beans) {
  beans.gridDestroySvc.destroy();
}
function isDestroyed(beans) {
  return beans.gridDestroySvc.destroyCalled;
}
function getGridOption(beans, key) {
  return beans.gos.get(key);
}
function setGridOption(beans, key, value) {
  updateGridOptions(beans, { [key]: value });
}
function updateGridOptions(beans, options) {
  beans.gos.updateGridOptions({ options });
}
function isModuleRegistered(beans, moduleName) {
  const withoutSuffix = moduleName.replace(/Module$/, "");
  return beans.gos.isModuleRegistered(withoutSuffix);
}

// packages/ag-grid-community/src/rendering/dndSourceComp.ts
var DndSourceElement = { tag: "div", cls: "ag-drag-handle ag-row-drag", attrs: { draggable: "true" } };
var DndSourceComp = class extends Component {
  constructor(rowNode, column, eCell) {
    super(DndSourceElement);
    this.rowNode = rowNode;
    this.column = column;
    this.eCell = eCell;
  }
  postConstruct() {
    const eGui = this.getGui();
    eGui.appendChild(_createIconNoSpan("rowDrag", this.beans, null));
    this.addGuiEventListener("mousedown", (e) => {
      e.stopPropagation();
    });
    this.addDragSource();
    this.checkVisibility();
  }
  addDragSource() {
    this.addGuiEventListener("dragstart", this.onDragStart.bind(this));
  }
  onDragStart(dragEvent) {
    const { rowNode, column, eCell, gos } = this;
    const providedOnRowDrag = column.getColDef().dndSourceOnRowDrag;
    const dataTransfer = dragEvent.dataTransfer;
    dataTransfer.setDragImage(eCell, 0, 0);
    if (providedOnRowDrag) {
      const params = _addGridCommonParams(gos, {
        rowNode,
        dragEvent
      });
      providedOnRowDrag(params);
    } else {
      try {
        const jsonData = JSON.stringify(rowNode.data);
        dataTransfer.setData("application/json", jsonData);
        dataTransfer.setData("text/plain", jsonData);
      } catch (e) {
      }
    }
  }
  checkVisibility() {
    const visible = this.column.isDndSource(this.rowNode);
    this.setDisplayed(visible);
  }
};

// packages/ag-grid-community/src/dragAndDrop/dragApi.ts
function addRowDropZone(beans, params) {
  beans.rowDragSvc?.rowDragFeature?.addRowDropZone(params);
}
function removeRowDropZone(beans, params) {
  const activeDropTarget = beans.dragAndDrop?.findExternalZone(params);
  if (activeDropTarget) {
    beans.dragAndDrop?.removeDropTarget(activeDropTarget);
  }
}
function getRowDropZoneParams(beans, events) {
  return beans.rowDragSvc?.rowDragFeature?.getRowDropZone(events);
}
function getRowDropPositionIndicator(beans) {
  const rowDropHighlightSvc = beans.rowDropHighlightSvc;
  return rowDropHighlightSvc ? { row: rowDropHighlightSvc.row, dropIndicatorPosition: rowDropHighlightSvc.position } : { row: null, dropIndicatorPosition: "none" };
}
function setRowDropPositionIndicator(beans, params) {
  const rowDropHighlightSvc = beans.rowDropHighlightSvc;
  if (!rowDropHighlightSvc) {
    return;
  }
  const rowNode = params?.row;
  let position = params?.dropIndicatorPosition;
  if (position !== "above" && position !== "below" && position !== "inside") {
    position = "none";
  }
  const rowIndex = rowNode?.rowIndex;
  if (rowIndex === null || rowIndex === void 0 || position === "none") {
    rowDropHighlightSvc.clear();
  } else {
    rowDropHighlightSvc.set(rowNode, position);
  }
}

// packages/ag-grid-community/src/dragAndDrop/horizontalResizeService.ts
var HorizontalResizeService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "horizontalResizeSvc";
  }
  addResizeBar(params) {
    const dragSource = {
      dragStartPixels: params.dragStartPixels || 0,
      eElement: params.eResizeBar,
      onDragStart: this.onDragStart.bind(this, params),
      onDragStop: this.onDragStop.bind(this, params),
      onDragging: this.onDragging.bind(this, params),
      onDragCancel: this.onDragStop.bind(this, params),
      includeTouch: true,
      stopPropagationForTouch: true
    };
    const { dragSvc } = this.beans;
    dragSvc.addDragSource(dragSource);
    const finishedWithResizeFunc = () => dragSvc.removeDragSource(dragSource);
    return finishedWithResizeFunc;
  }
  onDragStart(params, mouseEvent) {
    this.dragStartX = mouseEvent.clientX;
    this.setResizeIcons();
    const shiftKey = mouseEvent instanceof MouseEvent && mouseEvent.shiftKey === true;
    params.onResizeStart(shiftKey);
  }
  setResizeIcons() {
    const ctrl = this.beans.ctrlsSvc.get("gridCtrl");
    ctrl.setResizeCursor(1 /* Horizontal */);
    ctrl.disableUserSelect(true);
  }
  onDragStop(params) {
    params.onResizeEnd(this.resizeAmount);
    this.resetIcons();
  }
  resetIcons() {
    const ctrl = this.beans.ctrlsSvc.get("gridCtrl");
    ctrl.setResizeCursor(false);
    ctrl.disableUserSelect(false);
  }
  onDragging(params, mouseEvent) {
    this.resizeAmount = mouseEvent.clientX - this.dragStartX;
    params.onResizing(this.resizeAmount);
  }
};

// packages/ag-grid-community/src/dragAndDrop/rowDragComp.ts
var RowDragElement = {
  tag: "div",
  cls: "ag-drag-handle ag-row-drag",
  attrs: { "aria-hidden": "true" }
};
var RowDragComp = class extends Component {
  constructor(cellValueFn, rowNode, column, customGui, dragStartPixels, suppressVisibilityChange) {
    super();
    this.cellValueFn = cellValueFn;
    this.rowNode = rowNode;
    this.column = column;
    this.customGui = customGui;
    this.dragStartPixels = dragStartPixels;
    this.suppressVisibilityChange = suppressVisibilityChange;
    this.dragSource = null;
  }
  isCustomGui() {
    return this.customGui != null;
  }
  postConstruct() {
    const { beans, rowNode, column, gos } = this;
    if (!this.customGui) {
      this.setTemplate(RowDragElement);
      this.getGui().appendChild(_createIconNoSpan("rowDrag", beans, null));
      this.addDragSource();
    } else {
      this.setDragElement(this.customGui, this.dragStartPixels);
    }
    if (!this.suppressVisibilityChange) {
      const strategy = gos.get("rowDragManaged") ? new ManagedVisibilityStrategy(this, rowNode, column) : new NonManagedVisibilityStrategy(this, rowNode, column);
      this.createManagedBean(strategy, this.beans.context);
    }
  }
  setDragElement(dragElement, dragStartPixels) {
    this.setTemplateFromElement(dragElement, void 0, void 0, true);
    this.addDragSource(dragStartPixels);
  }
  getSelectedNodes() {
    const rowNode = this.rowNode;
    const isRowDragMultiRow = this.gos.get("rowDragMultiRow");
    if (!isRowDragMultiRow) {
      return [rowNode];
    }
    const selection = this.beans.selectionSvc?.getSelectedNodes() ?? [];
    return selection.indexOf(rowNode) !== -1 ? selection : [rowNode];
  }
  getDragItem() {
    const { column, rowNode } = this;
    return {
      rowNode,
      rowNodes: this.getSelectedNodes(),
      columns: column ? [column] : void 0,
      defaultTextValue: this.cellValueFn()
    };
  }
  getRowDragText(column) {
    if (column) {
      const colDef = column.getColDef();
      if (colDef.rowDragText) {
        return colDef.rowDragText;
      }
    }
    return this.gos.get("rowDragText");
  }
  addDragSource(dragStartPixels = 4) {
    if (this.dragSource) {
      this.removeDragSource();
    }
    if (this.gos.get("rowDragManaged") && this.rowNode.footer) {
      return;
    }
    const eGui = this.getGui();
    if (this.gos.get("enableCellTextSelection")) {
      this.removeMouseDownListener();
      this.mouseDownListener = this.addManagedElementListeners(eGui, {
        mousedown: (e) => {
          e?.preventDefault();
        }
      })[0];
    }
    const translate = this.getLocaleTextFunc();
    this.dragSource = {
      type: 2 /* RowDrag */,
      eElement: eGui,
      dragItemName: () => {
        const dragItem = this.getDragItem();
        const dragItemCount = dragItem.rowNodes?.length || 1;
        const rowDragText = this.getRowDragText(this.column);
        if (rowDragText) {
          return rowDragText(dragItem, dragItemCount);
        }
        return dragItemCount === 1 ? this.cellValueFn() : `${dragItemCount} ${translate("rowDragRows", "rows")}`;
      },
      getDragItem: () => this.getDragItem(),
      dragStartPixels,
      dragSourceDomDataKey: this.gos.getDomDataKey()
    };
    this.beans.dragAndDrop.addDragSource(this.dragSource, true);
  }
  destroy() {
    this.removeDragSource();
    this.removeMouseDownListener();
    super.destroy();
  }
  removeDragSource() {
    if (!this.dragSource) {
      return;
    }
    this.beans.dragAndDrop.removeDragSource(this.dragSource);
    this.dragSource = null;
  }
  removeMouseDownListener() {
    if (!this.mouseDownListener) {
      return;
    }
    this.mouseDownListener();
    this.mouseDownListener = void 0;
  }
};
var VisibilityStrategy = class extends BeanStub {
  constructor(parent, rowNode, column) {
    super();
    this.parent = parent;
    this.rowNode = rowNode;
    this.column = column;
  }
  setDisplayedOrVisible(neverDisplayed, alwaysHidden = false) {
    const displayedOptions = { skipAriaHidden: true };
    if (neverDisplayed) {
      this.parent.setDisplayed(false, displayedOptions);
    } else {
      let shown = !alwaysHidden;
      let isShownSometimes = false;
      const { column, rowNode, parent } = this;
      if (column) {
        const rowDrag = column.getColDef().rowDrag;
        isShownSometimes = typeof rowDrag === "function";
        shown = (alwaysHidden ? !!rowDrag : column.isRowDrag(rowNode)) || parent.isCustomGui();
      }
      if (isShownSometimes) {
        parent.setDisplayed(true, displayedOptions);
        parent.setVisible(shown && !alwaysHidden, displayedOptions);
      } else {
        parent.setDisplayed(shown, displayedOptions);
        parent.setVisible(!alwaysHidden, displayedOptions);
      }
    }
  }
};
var NonManagedVisibilityStrategy = class extends VisibilityStrategy {
  postConstruct() {
    this.addManagedPropertyListener("suppressRowDrag", this.onSuppressRowDrag.bind(this));
    const listener = this.workOutVisibility.bind(this);
    this.addManagedListeners(this.rowNode, {
      dataChanged: listener,
      cellChanged: listener
    });
    this.addManagedListeners(this.beans.eventSvc, { newColumnsLoaded: listener });
    this.workOutVisibility();
  }
  onSuppressRowDrag() {
    this.workOutVisibility();
  }
  workOutVisibility() {
    const neverDisplayed = this.gos.get("suppressRowDrag");
    this.setDisplayedOrVisible(neverDisplayed);
  }
};
var ManagedVisibilityStrategy = class extends VisibilityStrategy {
  postConstruct() {
    const listener = this.workOutVisibility.bind(this);
    this.addManagedListeners(this.beans.eventSvc, {
      sortChanged: listener,
      filterChanged: listener,
      columnRowGroupChanged: listener,
      newColumnsLoaded: listener
    });
    this.addManagedListeners(this.rowNode, {
      dataChanged: listener,
      cellChanged: listener
    });
    this.addManagedPropertyListener("suppressRowDrag", this.onSuppressRowDrag.bind(this));
    this.workOutVisibility();
  }
  onSuppressRowDrag() {
    this.workOutVisibility();
  }
  workOutVisibility() {
    const { rowDragSvc, dragAndDrop, gos } = this.beans;
    const rowDragFeature = rowDragSvc.rowDragFeature;
    const shouldPreventRowMove = rowDragFeature && rowDragFeature.shouldPreventRowMove();
    const suppressRowDrag = gos.get("suppressRowDrag");
    const hasExternalDropZones = dragAndDrop.hasExternalDropZones();
    const neverDisplayed = shouldPreventRowMove && !hasExternalDropZones || suppressRowDrag;
    this.setDisplayedOrVisible(neverDisplayed, this.rowNode.footer);
  }
};

// packages/ag-grid-community/src/utils/changedPath.ts
var ChangedPath = class {
  constructor(keepingColumns, rootNode) {
    // whether changed path is active of not. it is active when a) doing
    // a transaction update or b) doing change detection. if we are doing
    // a CSRM refresh for other reasons (after sort or filter, or user calling
    // setRowData() without delta mode) then we are not active. we are also
    // marked as not active if secondary columns change in pivot (as this impacts
    // aggregations).
    // can be set inactive by:
    // a) ClientSideRowModel, if no transactions or
    // b) PivotService, if secondary columns changed
    this.active = true;
    // for each node in the change path, we also store which columns need
    // to be re-aggregated.
    this.nodeIdsToColumns = {};
    // for quick lookup, all items in the change path are mapped by nodeId
    this.mapToItems = {};
    this.keepingColumns = keepingColumns;
    this.pathRoot = {
      rowNode: rootNode,
      children: null
    };
    this.mapToItems[rootNode.id] = this.pathRoot;
  }
  depthFirstSearchChangedPath(pathItem, callback) {
    const { rowNode, children } = pathItem;
    if (children) {
      for (let i = 0; i < children.length; ++i) {
        this.depthFirstSearchChangedPath(children[i], callback);
      }
    }
    callback(rowNode);
  }
  depthFirstSearchEverything(rowNode, callback, traverseEverything) {
    const childrenAfterGroup = rowNode.childrenAfterGroup;
    if (childrenAfterGroup) {
      for (let i = 0, len = childrenAfterGroup.length; i < len; ++i) {
        const childNode = childrenAfterGroup[i];
        if (childNode.childrenAfterGroup) {
          this.depthFirstSearchEverything(childNode, callback, traverseEverything);
        } else if (traverseEverything) {
          callback(childNode);
        }
      }
    }
    callback(rowNode);
  }
  // traverseLeafNodes -> used when NOT doing changed path, ie traversing everything. the callback
  // will be called for child nodes in addition to parent nodes.
  forEachChangedNodeDepthFirst(callback, traverseLeafNodes = false, includeUnchangedNodes = false) {
    if (this.active && !includeUnchangedNodes) {
      this.depthFirstSearchChangedPath(this.pathRoot, callback);
    } else {
      this.depthFirstSearchEverything(this.pathRoot.rowNode, callback, traverseLeafNodes);
    }
  }
  executeFromRootNode(callback) {
    callback(this.pathRoot.rowNode);
  }
  createPathItems(rowNode) {
    let pointer = rowNode;
    let newEntryCount = 0;
    while (!this.mapToItems[pointer.id]) {
      const newEntry = {
        rowNode: pointer,
        children: null
      };
      this.mapToItems[pointer.id] = newEntry;
      newEntryCount++;
      pointer = pointer.parent;
    }
    return newEntryCount;
  }
  populateColumnsMap(rowNode, columns) {
    if (!this.keepingColumns || !columns) {
      return;
    }
    let pointer = rowNode;
    while (pointer) {
      if (!this.nodeIdsToColumns[pointer.id]) {
        this.nodeIdsToColumns[pointer.id] = {};
      }
      columns.forEach((col) => this.nodeIdsToColumns[pointer.id][col.getId()] = true);
      pointer = pointer.parent;
    }
  }
  linkPathItems(rowNode, newEntryCount) {
    let pointer = rowNode;
    for (let i = 0; i < newEntryCount; i++) {
      const thisItem = this.mapToItems[pointer.id];
      const parentItem = this.mapToItems[pointer.parent.id];
      if (!parentItem.children) {
        parentItem.children = [];
      }
      parentItem.children.push(thisItem);
      pointer = pointer.parent;
    }
  }
  // called by
  // 1) change detection (provides cols) and
  // 2) groupStage if doing transaction update (doesn't provide cols)
  addParentNode(rowNode, columns) {
    if (!rowNode || rowNode.isRowPinned()) {
      return;
    }
    const newEntryCount = this.createPathItems(rowNode);
    this.linkPathItems(rowNode, newEntryCount);
    this.populateColumnsMap(rowNode, columns);
  }
  canSkip(rowNode) {
    return this.active && !this.mapToItems[rowNode.id];
  }
  getValueColumnsForNode(rowNode, valueColumns) {
    if (!this.keepingColumns) {
      return valueColumns;
    }
    const colsForThisNode = this.nodeIdsToColumns[rowNode.id];
    const result = valueColumns.filter((col) => colsForThisNode[col.getId()]);
    return result;
  }
  getNotValueColumnsForNode(rowNode, valueColumns) {
    if (!this.keepingColumns) {
      return null;
    }
    const colsForThisNode = this.nodeIdsToColumns[rowNode.id];
    const result = valueColumns.filter((col) => !colsForThisNode[col.getId()]);
    return result;
  }
};

// packages/ag-grid-community/src/dragAndDrop/rowDragFeature.ts
var RowDragFeature = class extends BeanStub {
  constructor(eContainer) {
    super();
    this.eContainer = null;
    this.lastDraggingEvent = null;
    this.autoScrollService = null;
    this.makeGroupThrottleTimer = null;
    this.makeGroupThrottleTarget = null;
    this.makeGroupThrottled = false;
    this.makeGroupThrottleCallback = () => {
      this.makeGroupThrottleTimer = null;
      const event = this.lastDraggingEvent;
      if (event) {
        this.makeGroupThrottled = true;
        this.doManagedDrag(event, false);
        this.makeGroupExpanded(this.makeGroupThrottleTarget);
      }
    };
    this.eContainer = eContainer;
  }
  postConstruct() {
    const { rowModel, gos, ctrlsSvc } = this.beans;
    if (_isClientSideRowModel(gos, rowModel)) {
      this.clientSideRowModel = rowModel;
    }
    ctrlsSvc.whenReady(this, (p) => {
      const gridBodyCon = p.gridBodyCtrl;
      let oldVScroll = 0;
      const getVScroll2 = () => gridBodyCon.scrollFeature.getVScrollPosition().top;
      this.autoScrollService = new AutoScrollService({
        scrollContainer: gridBodyCon.eBodyViewport,
        scrollAxis: "y",
        getVerticalPosition: getVScroll2,
        setVerticalPosition: (position) => gridBodyCon.scrollFeature.setVerticalScrollPosition(position),
        onScrollCallback: () => {
          const newVScroll = getVScroll2();
          if (oldVScroll !== newVScroll) {
            oldVScroll = newVScroll;
            const lastDraggingEvent = this.lastDraggingEvent;
            if (lastDraggingEvent) {
              this.onDragging(lastDraggingEvent);
            }
          }
        }
      });
    });
  }
  destroy() {
    super.destroy();
    this.eContainer = null;
    this.lastDraggingEvent = null;
    this.makeGroupThrottleClear();
    const autoScrollService = this.autoScrollService;
    if (autoScrollService) {
      this.autoScrollService = null;
      autoScrollService?.ensureCleared();
    }
  }
  getContainer() {
    return this.eContainer;
  }
  isInterestedIn(type) {
    return type === 2 /* RowDrag */;
  }
  getIconName() {
    const managedDrag = this.gos.get("rowDragManaged");
    if (managedDrag && this.shouldPreventRowMove()) {
      return "notAllowed";
    }
    return "move";
  }
  shouldPreventRowMove() {
    const { rowGroupColsSvc, filterManager, sortSvc } = this.beans;
    const rowGroupCols = rowGroupColsSvc?.columns ?? [];
    if (rowGroupCols.length) {
      return true;
    }
    const isFilterPresent = filterManager?.isAnyFilterPresent();
    if (isFilterPresent) {
      return true;
    }
    const isSortActive = sortSvc?.isSortActive();
    if (isSortActive) {
      return true;
    }
    return false;
  }
  getRowNodes(draggingEvent) {
    if (!this.isFromThisGrid(draggingEvent)) {
      return draggingEvent.dragItem.rowNodes || [];
    }
    const currentNode = draggingEvent.dragItem.rowNode;
    const isRowDragMultiRow = this.gos.get("rowDragMultiRow");
    if (isRowDragMultiRow) {
      const selectedNodes = [...this.beans.selectionSvc?.getSelectedNodes() ?? []].sort((a, b) => {
        if (a.rowIndex == null || b.rowIndex == null) {
          return 0;
        }
        return this.getRowIndexNumber(a) - this.getRowIndexNumber(b);
      });
      if (selectedNodes.indexOf(currentNode) !== -1) {
        return selectedNodes;
      }
    }
    return [currentNode];
  }
  onDragEnter(draggingEvent) {
    draggingEvent.dragItem.rowNodes = this.getRowNodes(draggingEvent);
    this.dispatchGridEvent("rowDragEnter", draggingEvent);
    this.getRowNodes(draggingEvent).forEach((rowNode) => {
      this.setRowNodeDragging(rowNode, true);
    });
    this.onEnterOrDragging(draggingEvent);
  }
  onDragging(draggingEvent) {
    this.onEnterOrDragging(draggingEvent);
  }
  isFromThisGrid(draggingEvent) {
    const { dragSourceDomDataKey } = draggingEvent.dragSource;
    return dragSourceDomDataKey === this.gos.getDomDataKey();
  }
  onEnterOrDragging(draggingEvent) {
    if (!this.autoScrollService) {
      return;
    }
    this.dispatchGridEvent("rowDragMove", draggingEvent);
    this.lastDraggingEvent = draggingEvent;
    if (this.gos.get("rowDragManaged")) {
      this.doManagedDrag(draggingEvent, true);
    }
    this.autoScrollService.check(draggingEvent.event);
  }
  doManagedDrag(draggingEvent, throttleMakeGroup) {
    const { dragAndDrop, gos } = this.beans;
    const isFromThisGrid = this.isFromThisGrid(draggingEvent);
    const managedDrag = gos.get("rowDragManaged");
    if (managedDrag && this.shouldPreventRowMove()) {
      return;
    }
    if (gos.get("suppressMoveWhenRowDragging") || !isFromThisGrid) {
      if (dragAndDrop.isDropZoneWithinThisGrid(draggingEvent)) {
        const rowsDrop = this.managedRowsDrop(draggingEvent, throttleMakeGroup);
        const target = rowsDrop?.target;
        const rowDropHighlightSvc = this.beans.rowDropHighlightSvc;
        if (target && rowsDrop.rows.length) {
          rowDropHighlightSvc.set(target, rowsDrop.position);
        } else {
          rowDropHighlightSvc.clear();
        }
      }
    } else {
      const rowsDrop = this.managedRowsDrop(draggingEvent, throttleMakeGroup);
      if (rowsDrop) {
        this.dropRows(rowsDrop);
      }
    }
  }
  getRowIndexNumber(rowNode) {
    const rowIndexStr = rowNode.getRowIndexString();
    return parseInt(_last(rowIndexStr.split("-")), 10);
  }
  managedRowsDrop(draggingEvent, throttleMakeGroup) {
    const { rowNode, rowNodes: rows } = draggingEvent.dragItem;
    const rowsLen = rows?.length;
    const source = rowsLen && (rowNode ?? rows[0]);
    if (!source) {
      this.makeGroupThrottleClear();
      return null;
    }
    const { beans, gos, clientSideRowModel } = this;
    const rootNode = clientSideRowModel.rootNode;
    const y = _getNormalisedMousePosition(beans, draggingEvent).y;
    let targetRowIndex = clientSideRowModel.getRowIndexAtPixel(y);
    let target = clientSideRowModel.getRow(targetRowIndex) ?? null;
    const moved = source !== target;
    let yDelta = target ? (y - target.rowTop - target.rowHeight / 2) / target.rowHeight || 0 : 1;
    const sameGrid = this.isFromThisGrid(draggingEvent);
    const groupingApproach = _getGroupingApproach(gos);
    const canSetParent = (
      // We don't yet support drag and drop with grouping
      groupingApproach !== "group" && // We don't yet support moving tree rows from a different grid in a structured way
      sameGrid
    );
    let newParent = null;
    if (canSetParent && target?.footer) {
      newParent = target.sibling ?? rootNode;
      const found = getPrevOrNext(clientSideRowModel, -1, target) ?? getPrevOrNext(clientSideRowModel, 1, target);
      yDelta = found && found.rowIndex > target.rowIndex ? -0.5 : 0.5;
      target = found ?? null;
    }
    let above = yDelta < 0;
    let targetInRows = false;
    if (sameGrid && target) {
      if (!moved) {
        if (Math.abs(yDelta) <= 0.5) {
          this.makeGroupThrottleClear();
          return null;
        }
        targetInRows = true;
      } else {
        targetInRows = rows.indexOf(target) >= 0;
        if (targetInRows) {
          const newTarget = getRowsPrevOrNext(clientSideRowModel, targetRowIndex < source.rowIndex, rows);
          if (newTarget?.parent === target.parent) {
            target = newTarget;
            targetRowIndex = target.rowIndex;
          }
        }
      }
      if (targetInRows || !canSetParent && Math.abs(targetRowIndex - source.rowIndex) === 1) {
        above = targetRowIndex < source.rowIndex;
      }
    }
    const makeGroupThrottleTarget = this.makeGroupThrottleTarget;
    if (makeGroupThrottleTarget !== null && makeGroupThrottleTarget !== target) {
      this.makeGroupThrottleClear();
    }
    if (target?.expanded && target.childrenAfterSort?.length) {
      this.makeGroupThrottled = true;
      this.makeGroupThrottleTarget = target;
    }
    if (newParent === null && canSetParent) {
      if (!target || yDelta >= 0.5 && target.rowIndex === beans.pageBounds.getLastRow()) {
        newParent = rootNode;
      } else if (this.targetShouldBeParent(target, yDelta, targetInRows, rows)) {
        if (this.makeGroupThrottled) {
          newParent = target;
        }
        if (throttleMakeGroup && (newParent === null || !target.expanded)) {
          this.makeGroupThrottleTarget = target;
          this.makeGroupThrottleStart();
        }
      }
      newParent ?? (newParent = target?.parent ?? rootNode);
    }
    let inside = false;
    if (newParent !== null) {
      if (newParent === target && newParent !== rootNode) {
        inside = true;
        const firstRow = newParent.expanded ? getPrevOrNext(clientSideRowModel, 1, target) : null;
        if (firstRow?.parent === newParent) {
          target = firstRow;
          inside = false;
          above = true;
        }
      }
      if (target && !inside) {
        let current = target;
        while (current && current !== rootNode && current !== newParent) {
          target = current;
          current = current.parent;
        }
      }
      if (rowsHaveSameParent(rows, newParent)) {
        newParent = null;
      }
    }
    if (!newParent && targetInRows && (canSetParent || source === target)) {
      return null;
    }
    const position = inside ? "inside" : above ? "above" : "below";
    const result = {
      api: this.beans.gridApi,
      context: this.beans.gridOptions.context,
      draggingEvent,
      sameGrid,
      position,
      source,
      target,
      newParent,
      rows
    };
    let customPosition = false;
    const isRowValidDropPosition = gos.get("isRowValidDropPosition");
    if (isRowValidDropPosition) {
      const canDropResult = isRowValidDropPosition(result);
      if (!canDropResult) {
        result.rows = _EmptyArray;
      } else if (typeof canDropResult === "object") {
        if (canDropResult.rows !== void 0) {
          result.rows = canDropResult.rows ?? _EmptyArray;
        }
        if (canDropResult.newParent !== void 0) {
          result.newParent = canDropResult.newParent;
        }
        if (canDropResult.target !== void 0) {
          result.target = canDropResult.target;
        }
        if (canDropResult.position) {
          customPosition = true;
          result.position = canDropResult.position;
        }
      }
    }
    if ((!result.newParent || !result.rows.length) && !customPosition) {
      result.position = above ? "above" : "below";
    }
    return result;
  }
  makeGroupThrottleStart() {
    if (this.makeGroupThrottleTimer === null) {
      this.makeGroupThrottleTimer = window.setTimeout(
        this.makeGroupThrottleCallback,
        this.gos.get("rowDragInsertDelay")
      );
    }
  }
  makeGroupExpanded(target) {
    if (target && !target.expanded && target.childrenAfterSort?.length && target.isExpandable()) {
      target.setExpanded(true, this.lastDraggingEvent?.event, true);
    }
  }
  makeGroupThrottleClear() {
    this.makeGroupThrottled = false;
    this.makeGroupThrottleTarget = null;
    const timer = this.makeGroupThrottleTimer;
    if (timer !== null) {
      this.makeGroupThrottleTimer = null;
      clearTimeout(timer);
    }
  }
  targetShouldBeParent(target, yDelta, targetInRows, rows) {
    const targetRowIndex = target?.rowIndex;
    if (targetInRows || targetRowIndex === null) {
      return false;
    }
    const INSIDE_THRESHOLD = 0.25;
    if (yDelta < -0.5 + INSIDE_THRESHOLD) {
      return false;
    }
    if (yDelta < 0.5 - INSIDE_THRESHOLD) {
      return true;
    }
    let nextRow;
    let nextRowIndex = targetRowIndex + 1;
    const clientSideRowModel = this.clientSideRowModel;
    do {
      nextRow = clientSideRowModel.getRow(nextRowIndex++);
    } while (nextRow && nextRow.footer);
    const childrenAfterGroup = target.childrenAfterGroup;
    if (nextRow && nextRow.parent === target && childrenAfterGroup?.length) {
      const rowsSet = new Set(rows);
      for (const child of childrenAfterGroup) {
        if (child.rowIndex !== null && !rowsSet.has(child)) {
          return true;
        }
      }
    }
    return false;
  }
  addRowDropZone(params) {
    if (!params.getContainer()) {
      _warn(55);
      return;
    }
    const dragAndDrop = this.beans.dragAndDrop;
    if (dragAndDrop.findExternalZone(params)) {
      _warn(56);
      return;
    }
    let processedParams = {
      getContainer: params.getContainer
    };
    if (params.fromGrid) {
      processedParams = params;
    } else {
      if (params.onDragEnter) {
        processedParams.onDragEnter = (e) => {
          params.onDragEnter(this.draggingToRowDragEvent("rowDragEnter", e));
        };
      }
      if (params.onDragLeave) {
        processedParams.onDragLeave = (e) => {
          params.onDragLeave(this.draggingToRowDragEvent("rowDragLeave", e));
        };
      }
      if (params.onDragging) {
        processedParams.onDragging = (e) => {
          params.onDragging(this.draggingToRowDragEvent("rowDragMove", e));
        };
      }
      if (params.onDragStop) {
        processedParams.onDragStop = (e) => {
          params.onDragStop(this.draggingToRowDragEvent("rowDragEnd", e));
        };
      }
      if (params.onDragCancel) {
        processedParams.onDragCancel = (e) => {
          params.onDragCancel(this.draggingToRowDragEvent("rowDragCancel", e));
        };
      }
    }
    const dropTarget = {
      isInterestedIn: (type) => type === 2 /* RowDrag */,
      getIconName: () => "move",
      external: true,
      ...processedParams
    };
    dragAndDrop.addDropTarget(dropTarget);
    this.addDestroyFunc(() => dragAndDrop.removeDropTarget(dropTarget));
  }
  getRowDropZone(events) {
    const getContainer = this.getContainer.bind(this);
    const onDragEnter = this.onDragEnter.bind(this);
    const onDragLeave = this.onDragLeave.bind(this);
    const onDragging = this.onDragging.bind(this);
    const onDragStop = this.onDragStop.bind(this);
    const onDragCancel = this.onDragCancel.bind(this);
    let params;
    if (!events) {
      params = {
        getContainer,
        onDragEnter,
        onDragLeave,
        onDragging,
        onDragStop,
        onDragCancel,
        /* @private */
        fromGrid: true
      };
    } else {
      params = {
        getContainer,
        onDragEnter: events.onDragEnter ? (e) => {
          onDragEnter(e);
          events.onDragEnter(this.draggingToRowDragEvent("rowDragEnter", e));
        } : onDragEnter,
        onDragLeave: events.onDragLeave ? (e) => {
          onDragLeave(e);
          events.onDragLeave(this.draggingToRowDragEvent("rowDragLeave", e));
        } : onDragLeave,
        onDragging: events.onDragging ? (e) => {
          onDragging(e);
          events.onDragging(this.draggingToRowDragEvent("rowDragMove", e));
        } : onDragging,
        onDragStop: events.onDragStop ? (e) => {
          onDragStop(e);
          events.onDragStop(this.draggingToRowDragEvent("rowDragEnd", e));
        } : onDragStop,
        onDragCancel: events.onDragCancel ? (e) => {
          onDragCancel(e);
          events.onDragCancel(this.draggingToRowDragEvent("rowDragCancel", e));
        } : onDragCancel,
        fromGrid: true
      };
    }
    return params;
  }
  draggingToRowDragEvent(type, draggingEvent) {
    const beans = this.beans;
    const { pageBounds, rowModel, gos } = beans;
    const y = _getNormalisedMousePosition(this.beans, draggingEvent).y;
    const mouseIsPastLastRow = y > pageBounds.getCurrentPagePixelRange().pageLastPixel;
    let overIndex = -1;
    let overNode;
    if (!mouseIsPastLastRow) {
      overIndex = rowModel.getRowIndexAtPixel(y);
      overNode = rowModel.getRow(overIndex);
    }
    const event = _addGridCommonParams(gos, {
      type,
      event: draggingEvent.event,
      node: draggingEvent.dragItem.rowNode,
      nodes: draggingEvent.dragItem.rowNodes,
      overIndex,
      overNode,
      y,
      vDirection: draggingEvent.vDirection
    });
    return event;
  }
  dispatchGridEvent(type, draggingEvent) {
    const event = this.draggingToRowDragEvent(type, draggingEvent);
    this.eventSvc.dispatchEvent(event);
  }
  onDragLeave(draggingEvent) {
    this.dispatchGridEvent("rowDragLeave", draggingEvent);
    this.stopDragging(draggingEvent);
    if (this.gos.get("rowDragManaged")) {
      this.beans.rowDropHighlightSvc.clear();
    }
    this.makeGroupThrottleClear();
  }
  onDragStop(draggingEvent) {
    this.dispatchGridEvent("rowDragEnd", draggingEvent);
    this.stopDragging(draggingEvent);
    const { dragAndDrop, gos } = this.beans;
    if (gos.get("rowDragManaged") && (gos.get("suppressMoveWhenRowDragging") || !this.isFromThisGrid(draggingEvent)) && dragAndDrop.isDropZoneWithinThisGrid(draggingEvent)) {
      const rowsDrop = this.managedRowsDrop(draggingEvent, false);
      if (rowsDrop) {
        this.dropRows(rowsDrop);
      }
      this.beans.rowDropHighlightSvc.clear();
    }
    this.makeGroupThrottleClear();
  }
  onDragCancel(draggingEvent) {
    this.dispatchGridEvent("rowDragCancel", draggingEvent);
    this.stopDragging(draggingEvent);
    const { dragAndDrop, gos } = this.beans;
    if (gos.get("rowDragManaged") && (gos.get("suppressMoveWhenRowDragging") || !this.isFromThisGrid(draggingEvent)) && dragAndDrop.isDropZoneWithinThisGrid(draggingEvent)) {
      this.beans.rowDropHighlightSvc.clear();
    }
    this.makeGroupThrottleClear();
  }
  stopDragging(draggingEvent) {
    this.autoScrollService?.ensureCleared();
    this.getRowNodes(draggingEvent).forEach((rowNode) => {
      this.setRowNodeDragging(rowNode, false);
    });
  }
  setRowNodeDragging(rowNode, dragging) {
    if (rowNode.dragging !== dragging) {
      rowNode.dragging = dragging;
      rowNode.dispatchRowEvent("draggingChanged");
    }
  }
  /** Drag and drop. Returns false if at least a row was moved, otherwise true */
  dropRows(rowsDrop) {
    return rowsDrop.sameGrid ? this.moveRows(rowsDrop) : this.addRows(rowsDrop);
  }
  addRows({ position, target, rows }) {
    const getRowIdFunc = _getRowIdCallback(this.gos);
    const clientSideRowModel = this.clientSideRowModel;
    const add = rows.filter(
      ({ data, rowPinned }) => !clientSideRowModel.getRowNode(getRowIdFunc?.({ data, level: 0, rowPinned }) ?? data.id)
    ).map(({ data }) => data);
    if (add.length === 0) {
      return false;
    }
    const addIndex = target ? getLeafSourceRowIndex(target) + (position === "above" ? 0 : 1) : void 0;
    clientSideRowModel.updateRowData({ add, addIndex });
    return true;
  }
  refreshModelAfterDrop() {
    this.clientSideRowModel.refreshModel({
      step: "group",
      keepRenderedRows: true,
      animate: !this.gos.get("suppressAnimationFrame"),
      changedPath: new ChangedPath(false, this.clientSideRowModel.rootNode),
      rowNodesOrderChanged: true
    });
  }
  moveRows({ position, target, rows, newParent }) {
    let changed = false;
    const clientSideRowModel = this.clientSideRowModel;
    const leafs = /* @__PURE__ */ new Set();
    for (const row of rows) {
      if (row.footer || row.rowTop === null && row !== clientSideRowModel.getRowNode(row.id)) {
        continue;
      }
      if (newParent && row.parent !== newParent) {
        if (wouldFormCycle(row, newParent)) {
          continue;
        }
        row.treeParent = newParent;
        changed = true;
      }
      const leafRow = getLeafRow(row);
      if (leafRow) {
        leafs.add(leafRow);
      }
    }
    if (!changed && leafs.size === 0) {
      return false;
    }
    const focusSvc = this.beans.focusSvc;
    const cellPosition = focusSvc.getFocusedCell();
    const cellCtrl = cellPosition && _getCellByPosition(this.beans, cellPosition);
    if (leafs.size && this.reorderLeafChildren(leafs, ...this.getMoveRowsBounds(leafs, target, position === "above"))) {
      changed = true;
    }
    if (!changed) {
      return false;
    }
    this.refreshModelAfterDrop();
    if (cellCtrl) {
      cellCtrl.focusCell();
    } else {
      focusSvc.clearFocusedCell();
    }
    return true;
  }
  /** For reorderLeafChildren, returns min index of the rows to move, the target index and the max index of the rows to move. */
  getMoveRowsBounds(leafs, target, above) {
    const totalRows = this.clientSideRowModel.rootNode?.allLeafChildren.length ?? 0;
    let targetPositionIdx = getLeafSourceRowIndex(target);
    if (targetPositionIdx < 0 || targetPositionIdx >= totalRows) {
      targetPositionIdx = totalRows;
    } else if (!above) {
      ++targetPositionIdx;
    }
    let firstAffectedLeafIdx = targetPositionIdx;
    let lastAffectedLeafIndex = Math.min(targetPositionIdx, totalRows - 1);
    for (const row of leafs) {
      const sourceRowIndex = row.sourceRowIndex;
      if (sourceRowIndex < firstAffectedLeafIdx)
        firstAffectedLeafIdx = sourceRowIndex;
      if (sourceRowIndex > lastAffectedLeafIndex)
        lastAffectedLeafIndex = sourceRowIndex;
    }
    return [firstAffectedLeafIdx, targetPositionIdx, lastAffectedLeafIndex];
  }
  /** Reorders the children of the root node, so that the rows to move are in the correct order.
   * @param leafs The valid set of rows to move, as returned by getValidRowsToMove
   * @param firstAffectedLeafIdx The first index of the rows to move
   * @param targetPositionIdx The target index, where the rows will be moved
   * @param lastAffectedLeafIndex The last index of the rows to move
   * @returns True if the order of the rows changed, false otherwise
   */
  reorderLeafChildren(leafs, firstAffectedLeafIdx, targetPositionIdx, lastAffectedLeafIndex) {
    let orderChanged = false;
    const allLeafChildren = this.clientSideRowModel.rootNode?.allLeafChildren;
    if (!leafs.size || !allLeafChildren) {
      return false;
    }
    let writeIdxLeft = firstAffectedLeafIdx;
    for (let readIdx = firstAffectedLeafIdx; readIdx < targetPositionIdx; ++readIdx) {
      const row = allLeafChildren[readIdx];
      if (!leafs.has(row)) {
        if (row.sourceRowIndex !== writeIdxLeft) {
          row.sourceRowIndex = writeIdxLeft;
          allLeafChildren[writeIdxLeft] = row;
          orderChanged = true;
        }
        ++writeIdxLeft;
      }
    }
    let writeIdxRight = lastAffectedLeafIndex;
    for (let readIdx = lastAffectedLeafIndex; readIdx >= targetPositionIdx; --readIdx) {
      const row = allLeafChildren[readIdx];
      if (!leafs.has(row)) {
        if (row.sourceRowIndex !== writeIdxRight) {
          row.sourceRowIndex = writeIdxRight;
          allLeafChildren[writeIdxRight] = row;
          orderChanged = true;
        }
        --writeIdxRight;
      }
    }
    for (const row of leafs) {
      if (row.sourceRowIndex !== writeIdxLeft) {
        row.sourceRowIndex = writeIdxLeft;
        allLeafChildren[writeIdxLeft] = row;
        orderChanged = true;
      }
      ++writeIdxLeft;
    }
    return orderChanged;
  }
};
var getRowsPrevOrNext = (clientSideRowModel, above, rows) => {
  return above ? getPrevOrNext(clientSideRowModel, -1, rows[0]) : getPrevOrNext(clientSideRowModel, 1, _last(rows));
};
var getPrevOrNext = (clientSideRowModel, increment, initialRow) => {
  if (initialRow) {
    const rowCount = clientSideRowModel.getRowCount();
    let rowIndex = initialRow.rowIndex + increment;
    while (rowIndex >= 0 && rowIndex < rowCount) {
      const row = clientSideRowModel.getRow(rowIndex);
      if (!row || !row.footer) {
        return row;
      }
      rowIndex += increment;
    }
  }
  return void 0;
};
var wouldFormCycle = (row, newParent) => {
  let parent = newParent;
  while (parent) {
    if (parent === row) {
      return true;
    }
    parent = parent.parent;
  }
  return false;
};
var rowsHaveSameParent = (rows, newParent) => {
  for (let i = 0, len = rows.length; i < len; ++i) {
    if (rows[i].parent !== newParent) {
      return false;
    }
  }
  return true;
};
var getLeafSourceRowIndex = (row) => {
  const leaf = getLeafRow(row);
  return leaf !== void 0 ? leaf.sourceRowIndex : -1;
};
var getLeafRow = (row) => {
  while (row) {
    if (row.sourceRowIndex >= 0) {
      return row;
    }
    const childrenAfterGroup = row.childrenAfterGroup;
    if (!childrenAfterGroup?.length) {
      return void 0;
    }
    row = childrenAfterGroup[0];
  }
};

// packages/ag-grid-community/src/dragAndDrop/rowDragService.ts
var RowDragService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "rowDragSvc";
  }
  setupRowDrag(element, ctrl) {
    const rowDragFeature = ctrl.createManagedBean(new RowDragFeature(element));
    const dragAndDrop = this.beans.dragAndDrop;
    dragAndDrop.addDropTarget(rowDragFeature);
    ctrl.addDestroyFunc(() => dragAndDrop.removeDropTarget(rowDragFeature));
    this.rowDragFeature = rowDragFeature;
  }
  createRowDragComp(cellValueFn, rowNode, column, customGui, dragStartPixels, suppressVisibilityChange) {
    return new RowDragComp(cellValueFn, rowNode, column, customGui, dragStartPixels, suppressVisibilityChange);
  }
  createRowDragCompForRow(rowNode, element) {
    if (_isCellSelectionEnabled(this.gos)) {
      return void 0;
    }
    const translate = this.getLocaleTextFunc();
    return this.createRowDragComp(
      () => `1 ${translate("rowDragRow", "row")}`,
      rowNode,
      void 0,
      element,
      void 0,
      true
    );
  }
  createRowDragCompForCell(rowNode, column, cellValueFn, element, dragStartPixels, suppressVisibilityChange) {
    const gos = this.gos;
    if (gos.get("rowDragManaged")) {
      if (!_isClientSideRowModel(gos) || gos.get("pagination")) {
        return void 0;
      }
    }
    const rowDragComp = this.createRowDragComp(
      cellValueFn,
      rowNode,
      column,
      element,
      dragStartPixels,
      suppressVisibilityChange
    );
    return rowDragComp;
  }
};

// packages/ag-grid-community/src/dragAndDrop/rowDropHighlightService.ts
var RowDropHighlightService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "rowDropHighlightSvc";
    this.uiLevel = 0;
    this.row = null;
    this.position = "none";
  }
  postConstruct() {
    this.addManagedEventListeners({
      modelUpdated: this.onModelUpdated.bind(this)
    });
  }
  onModelUpdated() {
    const row = this.row;
    if (!row || row.rowIndex === null || this.position === "none") {
      this.clear();
    } else {
      this.set(row, this.position);
    }
  }
  destroy() {
    this.clear();
    super.destroy();
  }
  clear() {
    const last = this.row;
    if (last) {
      this.uiLevel = 0;
      this.position = "none";
      this.row = null;
      last.dispatchRowEvent("rowHighlightChanged");
    }
  }
  set(row, dropIndicatorPosition) {
    const nodeChanged = row !== this.row;
    const uiLevel = row.uiLevel;
    const highlightChanged = dropIndicatorPosition !== this.position;
    const uiLevelChanged = uiLevel !== this.uiLevel;
    if (nodeChanged || highlightChanged || uiLevelChanged) {
      if (nodeChanged) {
        this.clear();
      }
      this.uiLevel = uiLevel;
      this.position = dropIndicatorPosition;
      this.row = row;
      row.dispatchRowEvent("rowHighlightChanged");
    }
  }
};

// packages/ag-grid-community/src/dragAndDrop/dragModule.ts
var DragModule = {
  moduleName: "Drag",
  version: VERSION,
  beans: [DragService]
};
var DragAndDropModule = {
  moduleName: "DragAndDrop",
  version: VERSION,
  dynamicBeans: {
    dndSourceComp: DndSourceComp
  },
  icons: {
    // drag handle used to pick up draggable rows
    rowDrag: "grip"
  }
};
var SharedDragAndDropModule = {
  moduleName: "SharedDragAndDrop",
  version: VERSION,
  beans: [DragAndDropService],
  dependsOn: [DragModule],
  userComponents: {
    agDragAndDropImage: DragAndDropImageComponent2
  },
  icons: {
    // shown on drag and drop image component icon while dragging column to the side of the grid to pin
    columnMovePin: "pin",
    // shown on drag and drop image component icon while dragging over part of the page that is not a drop zone
    columnMoveHide: "eye-slash",
    // shown on drag and drop image component icon while dragging columns to reorder
    columnMoveMove: "arrows",
    // animating icon shown when dragging a column to the right of the grid causes horizontal scrolling
    columnMoveLeft: "left",
    // animating icon shown when dragging a column to the left of the grid causes horizontal scrolling
    columnMoveRight: "right",
    // shown on drag and drop image component icon while dragging over Row Groups drop zone
    columnMoveGroup: "group",
    // shown on drag and drop image component icon while dragging over Values drop zone
    columnMoveValue: "aggregation",
    // shown on drag and drop image component icon while dragging over pivot drop zone
    columnMovePivot: "pivot",
    // shown on drag and drop image component icon while dragging over drop zone that doesn't support it, e.g.
    // string column over aggregation drop zone
    dropNotAllowed: "not-allowed",
    // drag handle used to pick up draggable rows
    rowDrag: "grip"
  }
};
var RowDragModule = {
  moduleName: "RowDrag",
  version: VERSION,
  beans: [RowDropHighlightService, RowDragService],
  apiFunctions: {
    addRowDropZone,
    removeRowDropZone,
    getRowDropZoneParams,
    getRowDropPositionIndicator,
    setRowDropPositionIndicator
  },
  dependsOn: [SharedDragAndDropModule]
};
var HorizontalResizeModule = {
  moduleName: "HorizontalResize",
  version: VERSION,
  beans: [HorizontalResizeService],
  dependsOn: [DragModule]
};

// packages/ag-grid-community/src/columnMove/column-moving.css-GENERATED.ts
var columnMovingCSS = (
  /*css*/
  `:where(.ag-ltr) :where(.ag-column-moving){.ag-cell,.ag-header-cell,.ag-spanned-cell-wrapper{transition:left .2s}.ag-header-group-cell{transition:left .2s,width .2s}}:where(.ag-rtl) :where(.ag-column-moving){.ag-cell,.ag-header-cell,.ag-spanned-cell-wrapper{transition:right .2s}.ag-header-group-cell{transition:right .2s,width .2s}}`
);

// packages/ag-grid-community/src/columnMove/columnAnimationService.ts
var ColumnAnimationService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colAnimation";
    this.executeNextFuncs = [];
    this.executeLaterFuncs = [];
    this.active = false;
    // activeNext starts with active but it is reset earlier after the nextFuncs are cleared
    // to prevent calls made to executeNextVMTurn from queuing functions after executeNextFuncs has already been flushed,
    this.activeNext = false;
    this.suppressAnimation = false;
    this.animationThreadCount = 0;
  }
  postConstruct() {
    this.beans.ctrlsSvc.whenReady(this, (p) => this.gridBodyCtrl = p.gridBodyCtrl);
  }
  isActive() {
    return this.active && !this.suppressAnimation;
  }
  setSuppressAnimation(suppress) {
    this.suppressAnimation = suppress;
  }
  start() {
    if (this.active) {
      return;
    }
    const { gos } = this;
    if (gos.get("suppressColumnMoveAnimation")) {
      return;
    }
    if (gos.get("enableRtl")) {
      return;
    }
    this.ensureAnimationCssClassPresent();
    this.active = true;
    this.activeNext = true;
  }
  finish() {
    if (!this.active) {
      return;
    }
    this.flush(
      () => this.activeNext = false,
      () => this.active = false
    );
  }
  executeNextVMTurn(func) {
    if (this.activeNext) {
      this.executeNextFuncs.push(func);
    } else {
      func();
    }
  }
  executeLaterVMTurn(func) {
    if (this.active) {
      this.executeLaterFuncs.push(func);
    } else {
      func();
    }
  }
  ensureAnimationCssClassPresent() {
    this.animationThreadCount++;
    const animationThreadCountCopy = this.animationThreadCount;
    const { gridBodyCtrl } = this;
    gridBodyCtrl.setColumnMovingCss(true);
    this.executeLaterFuncs.push(() => {
      if (this.animationThreadCount === animationThreadCountCopy) {
        gridBodyCtrl.setColumnMovingCss(false);
      }
    });
  }
  flush(callbackNext, callbackLater) {
    const { executeNextFuncs, executeLaterFuncs } = this;
    if (executeNextFuncs.length === 0 && executeLaterFuncs.length === 0) {
      callbackNext();
      callbackLater();
      return;
    }
    const runFuncs = (queue) => {
      while (queue.length) {
        const func = queue.pop();
        if (func) {
          func();
        }
      }
    };
    this.beans.frameworkOverrides.wrapIncoming(() => {
      window.setTimeout(() => {
        callbackNext();
        runFuncs(executeNextFuncs);
      }, 0);
      window.setTimeout(() => {
        callbackLater();
        runFuncs(executeLaterFuncs);
      }, 200);
    });
  }
};

// packages/ag-grid-community/src/columnMove/columnMoveApi.ts
function moveColumnByIndex(beans, fromIndex, toIndex) {
  beans.colMoves?.moveColumnByIndex(fromIndex, toIndex, "api");
}
function moveColumns(beans, columnsToMoveKeys, toIndex) {
  beans.colMoves?.moveColumns(columnsToMoveKeys, toIndex, "api");
}

// packages/ag-grid-community/src/columnMove/columnDrag/bodyDropPivotTarget.ts
var BodyDropPivotTarget = class extends BeanStub {
  constructor(pinned) {
    super();
    this.pinned = pinned;
    this.columnsToAggregate = [];
    this.columnsToGroup = [];
    this.columnsToPivot = [];
  }
  /** Callback for when drag enters */
  onDragEnter(draggingEvent) {
    this.clearColumnsList();
    if (this.gos.get("functionsReadOnly")) {
      return;
    }
    const dragColumns = draggingEvent.dragItem.columns;
    if (!dragColumns) {
      return;
    }
    dragColumns.forEach((column) => {
      if (!column.isPrimary()) {
        return;
      }
      if (column.isAnyFunctionActive()) {
        return;
      }
      if (column.isAllowValue()) {
        this.columnsToAggregate.push(column);
      } else if (column.isAllowRowGroup()) {
        this.columnsToGroup.push(column);
      } else if (column.isAllowPivot()) {
        this.columnsToPivot.push(column);
      }
    });
  }
  getIconName() {
    const totalColumns = this.columnsToAggregate.length + this.columnsToGroup.length + this.columnsToPivot.length;
    if (totalColumns > 0) {
      return this.pinned ? "pinned" : "move";
    }
    return null;
  }
  /** Callback for when drag leaves */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  onDragLeave(draggingEvent) {
    this.clearColumnsList();
  }
  clearColumnsList() {
    this.columnsToAggregate.length = 0;
    this.columnsToGroup.length = 0;
    this.columnsToPivot.length = 0;
  }
  /** Callback for when dragging */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  onDragging(draggingEvent) {
  }
  /** Callback for when drag stops */
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  onDragStop(draggingEvent) {
    const { valueColsSvc, rowGroupColsSvc, pivotColsSvc } = this.beans;
    if (this.columnsToAggregate.length > 0) {
      valueColsSvc?.addColumns(this.columnsToAggregate, "toolPanelDragAndDrop");
    }
    if (this.columnsToGroup.length > 0) {
      rowGroupColsSvc?.addColumns(this.columnsToGroup, "toolPanelDragAndDrop");
    }
    if (this.columnsToPivot.length > 0) {
      pivotColsSvc?.addColumns(this.columnsToPivot, "toolPanelDragAndDrop");
    }
  }
  onDragCancel() {
    this.clearColumnsList();
  }
};

// packages/ag-grid-community/src/columnMove/internalColumnMoveUtils.ts
function sortColsLikeCols(colsList, cols) {
  if (!cols || cols.length <= 1) {
    return;
  }
  const notAllColsPresent = cols.filter((c) => colsList.indexOf(c) < 0).length > 0;
  if (notAllColsPresent) {
    return;
  }
  cols.sort((a, b) => {
    const indexA = colsList.indexOf(a);
    const indexB = colsList.indexOf(b);
    return indexA - indexB;
  });
}
function getColsToMove(allMovingColumns) {
  const newCols = [...allMovingColumns];
  allMovingColumns.forEach((col) => {
    let movingGroup = null;
    let parent = col.getParent();
    while (parent != null && parent.getDisplayedLeafColumns().length === 1) {
      movingGroup = parent;
      parent = parent.getParent();
    }
    if (movingGroup != null) {
      const isMarryChildren = !!movingGroup.getColGroupDef()?.marryChildren;
      const columnsToMove = isMarryChildren ? (
        // when marry children is true, we also have to move hidden
        // columns within the group, so grab them from the `providedColumnGroup`
        movingGroup.getProvidedColumnGroup().getLeafColumns()
      ) : movingGroup.getLeafColumns();
      columnsToMove.forEach((newCol) => {
        if (!newCols.includes(newCol)) {
          newCols.push(newCol);
        }
      });
    }
  });
  return newCols;
}
function getLowestFragMove(validMoves, allMovingColumnsOrdered, colMoves, visibleCols) {
  const displayedCols = visibleCols.allCols;
  let lowestFragMove = null;
  let targetOrder = null;
  for (let i = 0; i < validMoves.length; i++) {
    const move = validMoves[i];
    const order = colMoves.getProposedColumnOrder(allMovingColumnsOrdered, move);
    if (!colMoves.doesOrderPassRules(order)) {
      continue;
    }
    const displayedOrder = order.filter((col) => displayedCols.includes(col));
    if (targetOrder === null) {
      targetOrder = displayedOrder;
    } else if (!_areEqual(displayedOrder, targetOrder)) {
      break;
    }
    const fragCount = groupFragCount(order);
    if (lowestFragMove === null || fragCount < lowestFragMove.fragCount) {
      lowestFragMove = { move, fragCount };
    }
  }
  return lowestFragMove;
}
function getBestColumnMoveIndexFromXPosition(params) {
  const { isFromHeader, fromLeft, xPosition, fromEnter, fakeEvent, pinned, gos, colModel, colMoves, visibleCols } = params;
  let { allMovingColumns } = params;
  if (isFromHeader) {
    allMovingColumns = getColsToMove(allMovingColumns);
  }
  const allMovingColumnsOrdered = allMovingColumns.slice();
  sortColsLikeCols(colModel.getCols(), allMovingColumnsOrdered);
  const validMoves = calculateValidMoves({
    movingCols: allMovingColumnsOrdered,
    draggingRight: fromLeft,
    xPosition,
    pinned,
    gos,
    colModel,
    visibleCols
  });
  const oldIndex = calculateOldIndex(allMovingColumnsOrdered, colModel);
  if (validMoves.length === 0) {
    return;
  }
  const firstValidMove = validMoves[0];
  const constrainDirection = oldIndex !== null && (isFromHeader || !fromEnter);
  if (constrainDirection && !fakeEvent) {
    if (!fromLeft && firstValidMove >= oldIndex) {
      return;
    }
    if (fromLeft && firstValidMove <= oldIndex) {
      return;
    }
  }
  const lowestFragMove = getLowestFragMove(validMoves, allMovingColumnsOrdered, colMoves, visibleCols);
  if (!lowestFragMove) {
    return;
  }
  const toIndex = lowestFragMove.move;
  if (toIndex > colModel.getCols().length - allMovingColumnsOrdered.length) {
    return;
  }
  return { columns: allMovingColumnsOrdered, toIndex };
}
function attemptMoveColumns(params) {
  const { columns, toIndex } = getBestColumnMoveIndexFromXPosition(params) || {};
  const { finished, colMoves } = params;
  if (!columns || toIndex == null) {
    return null;
  }
  colMoves.moveColumns(columns, toIndex, "uiColumnMoved", finished);
  return finished ? null : { columns, toIndex };
}
function calculateOldIndex(movingCols, colModel) {
  const gridCols = colModel.getCols();
  const indexes = movingCols.map((col) => gridCols.indexOf(col)).sort((a, b) => a - b);
  const firstIndex = indexes[0];
  const lastIndex = _last(indexes);
  const spread = lastIndex - firstIndex;
  const gapsExist = spread !== indexes.length - 1;
  return gapsExist ? null : firstIndex;
}
function groupFragCount(columns) {
  function parents(col) {
    const result = [];
    let parent = col.getOriginalParent();
    while (parent != null) {
      result.push(parent);
      parent = parent.getOriginalParent();
    }
    return result;
  }
  let count = 0;
  for (let i = 0; i < columns.length - 1; i++) {
    let a = parents(columns[i]);
    let b = parents(columns[i + 1]);
    [a, b] = a.length > b.length ? [a, b] : [b, a];
    a.forEach((parent) => {
      if (b.indexOf(parent) === -1) {
        count++;
      }
    });
  }
  return count;
}
function getDisplayedColumns(visibleCols, type) {
  switch (type) {
    case "left":
      return visibleCols.leftCols;
    case "right":
      return visibleCols.rightCols;
    default:
      return visibleCols.centerCols;
  }
}
function calculateValidMoves(params) {
  const { movingCols, draggingRight, xPosition, pinned, gos, colModel, visibleCols } = params;
  const isMoveBlocked = gos.get("suppressMovableColumns") || movingCols.some((col) => col.getColDef().suppressMovable);
  if (isMoveBlocked) {
    return [];
  }
  const allDisplayedCols = getDisplayedColumns(visibleCols, pinned);
  const allGridCols = colModel.getCols();
  const movingDisplayedCols = allDisplayedCols.filter((col) => movingCols.includes(col));
  const otherDisplayedCols = allDisplayedCols.filter((col) => !movingCols.includes(col));
  const otherGridCols = allGridCols.filter((col) => !movingCols.includes(col));
  let displayIndex = 0;
  let availableWidth = xPosition;
  if (draggingRight) {
    let widthOfMovingDisplayedCols = 0;
    movingDisplayedCols.forEach((col) => widthOfMovingDisplayedCols += col.getActualWidth());
    availableWidth -= widthOfMovingDisplayedCols;
  }
  if (availableWidth > 0) {
    for (let i = 0; i < otherDisplayedCols.length; i++) {
      const col = otherDisplayedCols[i];
      availableWidth -= col.getActualWidth();
      if (availableWidth < 0) {
        break;
      }
      displayIndex++;
    }
    if (draggingRight) {
      displayIndex++;
    }
  }
  let firstValidMove;
  if (displayIndex > 0) {
    const leftColumn = otherDisplayedCols[displayIndex - 1];
    firstValidMove = otherGridCols.indexOf(leftColumn) + 1;
  } else {
    firstValidMove = otherGridCols.indexOf(otherDisplayedCols[0]);
    if (firstValidMove === -1) {
      firstValidMove = 0;
    }
  }
  const validMoves = [firstValidMove];
  const numberComparator = (a, b) => a - b;
  if (draggingRight) {
    let pointer = firstValidMove + 1;
    const lastIndex = allGridCols.length - 1;
    while (pointer <= lastIndex) {
      validMoves.push(pointer);
      pointer++;
    }
    validMoves.sort(numberComparator);
  } else {
    let pointer = firstValidMove;
    const lastIndex = allGridCols.length - 1;
    let displacedCol = allGridCols[pointer];
    while (pointer <= lastIndex && allDisplayedCols.indexOf(displacedCol) < 0) {
      pointer++;
      validMoves.push(pointer);
      displacedCol = allGridCols[pointer];
    }
    pointer = firstValidMove - 1;
    const firstDisplayIndex = 0;
    while (pointer >= firstDisplayIndex) {
      validMoves.push(pointer);
      pointer--;
    }
    validMoves.sort(numberComparator).reverse();
  }
  return validMoves;
}
function normaliseX(params) {
  const { pinned, fromKeyboard, gos, ctrlsSvc, useHeaderRow, skipScrollPadding } = params;
  let eViewport = ctrlsSvc.getHeaderRowContainerCtrl(pinned)?.eViewport;
  let { x } = params;
  if (!eViewport) {
    return 0;
  }
  if (fromKeyboard) {
    x -= eViewport.getBoundingClientRect().left;
  }
  if (gos.get("enableRtl")) {
    if (useHeaderRow) {
      eViewport = eViewport.querySelector(".ag-header-row");
    }
    x = eViewport.clientWidth - x;
  }
  if (pinned == null && !skipScrollPadding) {
    x += ctrlsSvc.get("center").getCenterViewportScrollLeft();
  }
  return x;
}
function setColumnsMoving(columns, isMoving) {
  for (const column of columns) {
    column.moving = isMoving;
    column.dispatchColEvent("movingChanged", "uiColumnMoved");
  }
}

// packages/ag-grid-community/src/columnMove/columnDrag/moveColumnFeature.ts
var MOVE_FAIL_THRESHOLD = 7;
var SCROLL_MOVE_WIDTH = 100;
var SCROLL_GAP_NEEDED_BEFORE_MOVE = SCROLL_MOVE_WIDTH / 2;
var SCROLL_ACCELERATION_RATE = 5;
var SCROLL_TIME_INTERVAL = 100;
var MoveColumnFeature = class extends BeanStub {
  constructor(pinned) {
    super();
    this.pinned = pinned;
    this.needToMoveLeft = false;
    this.needToMoveRight = false;
    this.lastMovedInfo = null;
    this.isCenterContainer = !_exists(pinned);
  }
  postConstruct() {
    this.beans.ctrlsSvc.whenReady(this, (p) => {
      this.gridBodyCon = p.gridBodyCtrl;
    });
  }
  getIconName() {
    const { pinned, lastDraggingEvent } = this;
    const { dragItem } = lastDraggingEvent || {};
    const columns = dragItem?.columns ?? [];
    for (const col of columns) {
      const colPinned = col.getPinned();
      if (col.getColDef().lockPinned) {
        if (colPinned == pinned) {
          return "move";
        }
        continue;
      }
      const initialPinnedState = dragItem?.containerType;
      if (initialPinnedState === pinned || !pinned) {
        return "move";
      }
      if (pinned && (!colPinned || initialPinnedState !== pinned)) {
        return "pinned";
      }
    }
    return "notAllowed";
  }
  onDragEnter(draggingEvent) {
    const dragItem = draggingEvent.dragItem;
    const columns = dragItem.columns;
    const dragCameFromToolPanel = draggingEvent.dragSource.type === 0 /* ToolPanel */;
    if (dragCameFromToolPanel) {
      this.setColumnsVisible(columns, true, "uiColumnDragged");
    } else {
      const visibleState = dragItem.visibleState;
      const visibleColumns = (columns || []).filter(
        (column) => visibleState[column.getId()] && !column.isVisible()
      );
      this.setColumnsVisible(visibleColumns, true, "uiColumnDragged");
    }
    if (!this.gos.get("suppressMoveWhenColumnDragging")) {
      this.attemptToPinColumns(columns, this.pinned);
    }
    this.onDragging(draggingEvent, true, true);
  }
  onDragging(draggingEvent = this.lastDraggingEvent, fromEnter = false, fakeEvent = false, finished = false) {
    const { gos, ctrlsSvc } = this.beans;
    const isSuppressMoveWhenDragging = gos.get("suppressMoveWhenColumnDragging");
    if (finished && !isSuppressMoveWhenDragging) {
      this.finishColumnMoving();
      return;
    }
    this.lastDraggingEvent = draggingEvent;
    if (!draggingEvent || !finished && _missing(draggingEvent.hDirection)) {
      return;
    }
    const mouseX = normaliseX({
      x: draggingEvent.x,
      pinned: this.pinned,
      gos,
      ctrlsSvc
    });
    if (!fromEnter) {
      this.checkCenterForScrolling(mouseX);
    }
    if (isSuppressMoveWhenDragging) {
      this.handleColumnDragWhileSuppressingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished);
    } else {
      this.handleColumnDragWhileAllowingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished);
    }
  }
  onDragLeave() {
    this.ensureIntervalCleared();
    this.clearHighlighted();
    this.updateDragItemContainerType();
    this.lastMovedInfo = null;
  }
  onDragStop() {
    this.onDragging(this.lastDraggingEvent, false, true, true);
    this.ensureIntervalCleared();
    this.lastMovedInfo = null;
  }
  onDragCancel() {
    this.clearHighlighted();
    this.ensureIntervalCleared();
    this.lastMovedInfo = null;
  }
  setColumnsVisible(columns, visible, source) {
    if (!columns?.length) {
      return;
    }
    const allowedCols = columns.filter((c) => !c.getColDef().lockVisible);
    if (!allowedCols.length) {
      return;
    }
    this.beans.colModel.setColsVisible(allowedCols, visible, source);
  }
  finishColumnMoving() {
    this.clearHighlighted();
    const lastMovedInfo = this.lastMovedInfo;
    if (!lastMovedInfo) {
      return;
    }
    const { columns, toIndex } = lastMovedInfo;
    this.beans.colMoves.moveColumns(columns, toIndex, "uiColumnMoved", true);
  }
  updateDragItemContainerType() {
    const { lastDraggingEvent } = this;
    if (this.gos.get("suppressMoveWhenColumnDragging") || !lastDraggingEvent) {
      return;
    }
    const dragItem = lastDraggingEvent.dragItem;
    if (!dragItem) {
      return;
    }
    dragItem.containerType = this.pinned;
  }
  handleColumnDragWhileSuppressingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished) {
    const allMovingColumns = this.getAllMovingColumns(draggingEvent, true);
    if (finished) {
      const isAttemptingToPin = this.isAttemptingToPin(allMovingColumns);
      if (isAttemptingToPin) {
        this.attemptToPinColumns(allMovingColumns, void 0, true);
      }
      const { fromLeft, xPosition } = this.getNormalisedXPositionInfo(allMovingColumns, isAttemptingToPin) || {};
      if (fromLeft == null || xPosition == null) {
        this.finishColumnMoving();
        return;
      }
      this.moveColumnsAfterHighlight({
        allMovingColumns,
        xPosition,
        fromEnter,
        fakeEvent,
        fromLeft
      });
    } else {
      if (!this.beans.dragAndDrop.isDropZoneWithinThisGrid(draggingEvent)) {
        return;
      }
      this.highlightHoveredColumn(allMovingColumns, mouseX);
    }
  }
  handleColumnDragWhileAllowingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished) {
    const allMovingColumns = this.getAllMovingColumns(draggingEvent);
    const fromLeft = this.normaliseDirection(draggingEvent.hDirection) === "right";
    const isFromHeader = draggingEvent.dragSource.type === 1 /* HeaderCell */;
    const params = this.getMoveColumnParams({
      allMovingColumns,
      isFromHeader,
      xPosition: mouseX,
      fromLeft,
      fromEnter,
      fakeEvent
    });
    const lastMovedInfo = attemptMoveColumns({ ...params, finished });
    if (lastMovedInfo) {
      this.lastMovedInfo = lastMovedInfo;
    }
  }
  getAllMovingColumns(draggingEvent, useSplit = false) {
    const dragItem = draggingEvent.dragSource.getDragItem();
    let columns = null;
    if (useSplit) {
      columns = dragItem.columnsInSplit;
      if (!columns) {
        columns = dragItem.columns;
      }
    } else {
      columns = dragItem.columns;
    }
    const conditionCallback = (col) => col.getColDef().lockPinned ? col.getPinned() == this.pinned : true;
    if (!columns) {
      return [];
    }
    return columns.filter(conditionCallback);
  }
  getMoveColumnParams(params) {
    const { allMovingColumns, isFromHeader, xPosition, fromLeft, fromEnter, fakeEvent } = params;
    const { gos, colModel, colMoves, visibleCols } = this.beans;
    return {
      allMovingColumns,
      isFromHeader,
      fromLeft,
      xPosition,
      pinned: this.pinned,
      fromEnter,
      fakeEvent,
      gos,
      colModel,
      colMoves,
      visibleCols
    };
  }
  highlightHoveredColumn(movingColumns, mouseX) {
    const { gos, colModel } = this.beans;
    const isRtl = gos.get("enableRtl");
    const consideredColumns = colModel.getCols().filter((col) => col.isVisible() && col.getPinned() === this.pinned);
    let start = null;
    let width = null;
    let targetColumn = null;
    for (const col of consideredColumns) {
      width = col.getActualWidth();
      start = this.getNormalisedColumnLeft(col, 0, isRtl);
      if (start != null) {
        const end = start + width;
        if (start <= mouseX && end >= mouseX) {
          targetColumn = col;
          break;
        }
      }
      start = null;
      width = null;
    }
    if (!targetColumn) {
      for (let i = consideredColumns.length - 1; i >= 0; i--) {
        const currentColumn = consideredColumns[i];
        const parent = consideredColumns[i].getParent();
        if (!parent) {
          targetColumn = currentColumn;
          break;
        }
        const leafDisplayedCols = parent?.getDisplayedLeafColumns();
        if (leafDisplayedCols.length) {
          targetColumn = _last(leafDisplayedCols);
          break;
        }
      }
      if (!targetColumn) {
        return;
      }
      start = this.getNormalisedColumnLeft(targetColumn, 0, isRtl);
      width = targetColumn.getActualWidth();
    } else if (movingColumns.indexOf(targetColumn) !== -1) {
      targetColumn = null;
    }
    if (this.lastHighlightedColumn?.column !== targetColumn) {
      this.clearHighlighted();
    }
    if (targetColumn == null || start == null || width == null) {
      return;
    }
    let position;
    if (mouseX - start < width / 2 !== isRtl) {
      position = 0 /* Before */;
    } else {
      position = 1 /* After */;
    }
    setColumnHighlighted(targetColumn, position);
    this.lastHighlightedColumn = { column: targetColumn, position };
  }
  getNormalisedXPositionInfo(allMovingColumns, isAttemptingToPin) {
    const { gos, visibleCols } = this.beans;
    const isRtl = gos.get("enableRtl");
    const { firstMovingCol, column, position } = this.getColumnMoveAndTargetInfo(
      allMovingColumns,
      isAttemptingToPin,
      isRtl
    );
    if (!firstMovingCol || !column || position == null) {
      return;
    }
    const visibleColumns = visibleCols.allCols;
    const movingColIndex = visibleColumns.indexOf(firstMovingCol);
    const targetIndex = visibleColumns.indexOf(column);
    const isBefore = position === 0 /* Before */ !== isRtl;
    const fromLeft = movingColIndex < targetIndex || movingColIndex === targetIndex && !isBefore;
    let diff = 0;
    if (isBefore) {
      if (fromLeft) {
        diff -= 1;
      }
    } else {
      if (!fromLeft) {
        diff += 1;
      }
    }
    if (targetIndex + diff === movingColIndex) {
      return;
    }
    const targetColumn = visibleColumns[targetIndex + diff];
    if (!targetColumn) {
      return;
    }
    const xPosition = this.getNormalisedColumnLeft(targetColumn, 20, isRtl);
    return { fromLeft, xPosition };
  }
  getColumnMoveAndTargetInfo(allMovingColumns, isAttemptingToPin, isRtl) {
    const lastHighlightedColumn = this.lastHighlightedColumn || {};
    const { firstMovingCol, lastMovingCol } = findFirstAndLastMovingColumns(allMovingColumns);
    if (!firstMovingCol || !lastMovingCol || lastHighlightedColumn.column || !isAttemptingToPin) {
      return {
        firstMovingCol,
        ...lastHighlightedColumn
      };
    }
    const pinned = this.getPinDirection();
    const isLeft = pinned === "left";
    return {
      firstMovingCol,
      position: isLeft ? 1 /* After */ : 0 /* Before */,
      column: isLeft !== isRtl ? firstMovingCol : lastMovingCol
    };
  }
  normaliseDirection(hDirection) {
    if (this.gos.get("enableRtl")) {
      switch (hDirection) {
        case "left":
          return "right";
        case "right":
          return "left";
      }
    }
    return hDirection;
  }
  getNormalisedColumnLeft(col, padding, isRtl) {
    const { gos, ctrlsSvc } = this.beans;
    const left = col.getLeft();
    if (left == null) {
      return null;
    }
    const width = col.getActualWidth();
    return normaliseX({
      x: isRtl ? left + width - padding : left + padding,
      pinned: col.getPinned(),
      useHeaderRow: isRtl,
      skipScrollPadding: true,
      gos,
      ctrlsSvc
    });
  }
  isAttemptingToPin(columns) {
    const isMovingHorizontally = this.needToMoveLeft || this.needToMoveRight;
    const isFailedMoreThanThreshold = this.failedMoveAttempts > MOVE_FAIL_THRESHOLD;
    return isMovingHorizontally && isFailedMoreThanThreshold || columns.some((col) => col.getPinned() !== this.pinned);
  }
  moveColumnsAfterHighlight(params) {
    const { allMovingColumns, xPosition, fromEnter, fakeEvent, fromLeft } = params;
    const columnMoveParams = this.getMoveColumnParams({
      allMovingColumns,
      isFromHeader: true,
      xPosition,
      fromLeft,
      fromEnter,
      fakeEvent
    });
    const { columns, toIndex } = getBestColumnMoveIndexFromXPosition(columnMoveParams) || {};
    if (columns && toIndex != null) {
      this.lastMovedInfo = {
        columns,
        toIndex
      };
    }
    this.finishColumnMoving();
  }
  clearHighlighted() {
    const { lastHighlightedColumn } = this;
    if (!lastHighlightedColumn) {
      return;
    }
    setColumnHighlighted(lastHighlightedColumn.column, null);
    this.lastHighlightedColumn = null;
  }
  checkCenterForScrolling(xAdjustedForScroll) {
    if (!this.isCenterContainer) {
      return;
    }
    const centerCtrl = this.beans.ctrlsSvc.get("center");
    const firstVisiblePixel = centerCtrl.getCenterViewportScrollLeft();
    const lastVisiblePixel = firstVisiblePixel + centerCtrl.getCenterWidth();
    let needToMoveRight;
    let needToMoveLeft;
    if (this.gos.get("enableRtl")) {
      needToMoveRight = xAdjustedForScroll < firstVisiblePixel + SCROLL_GAP_NEEDED_BEFORE_MOVE;
      needToMoveLeft = xAdjustedForScroll > lastVisiblePixel - SCROLL_GAP_NEEDED_BEFORE_MOVE;
    } else {
      needToMoveLeft = xAdjustedForScroll < firstVisiblePixel + SCROLL_GAP_NEEDED_BEFORE_MOVE;
      needToMoveRight = xAdjustedForScroll > lastVisiblePixel - SCROLL_GAP_NEEDED_BEFORE_MOVE;
    }
    this.needToMoveRight = needToMoveRight;
    this.needToMoveLeft = needToMoveLeft;
    if (needToMoveLeft || needToMoveRight) {
      this.ensureIntervalStarted();
    } else {
      this.ensureIntervalCleared();
    }
  }
  ensureIntervalStarted() {
    if (this.movingIntervalId) {
      return;
    }
    this.intervalCount = 0;
    this.failedMoveAttempts = 0;
    this.movingIntervalId = window.setInterval(this.moveInterval.bind(this), SCROLL_TIME_INTERVAL);
    this.beans.dragAndDrop.getDragAndDropImageComponent()?.setIcon(this.needToMoveLeft ? "left" : "right", true);
  }
  ensureIntervalCleared() {
    if (!this.movingIntervalId) {
      return;
    }
    window.clearInterval(this.movingIntervalId);
    this.movingIntervalId = null;
    this.failedMoveAttempts = 0;
    this.beans.dragAndDrop.getDragAndDropImageComponent()?.setIcon(this.getIconName(), false);
  }
  moveInterval() {
    let pixelsToMove;
    this.intervalCount++;
    pixelsToMove = 10 + this.intervalCount * SCROLL_ACCELERATION_RATE;
    if (pixelsToMove > SCROLL_MOVE_WIDTH) {
      pixelsToMove = SCROLL_MOVE_WIDTH;
    }
    let pixelsMoved = null;
    const scrollFeature = this.gridBodyCon.scrollFeature;
    if (this.needToMoveLeft) {
      pixelsMoved = scrollFeature.scrollHorizontally(-pixelsToMove);
    } else if (this.needToMoveRight) {
      pixelsMoved = scrollFeature.scrollHorizontally(pixelsToMove);
    }
    if (pixelsMoved !== 0) {
      this.onDragging(this.lastDraggingEvent);
      this.failedMoveAttempts = 0;
    } else {
      this.failedMoveAttempts++;
      const { pinnedCols, dragAndDrop, gos } = this.beans;
      if (this.failedMoveAttempts <= MOVE_FAIL_THRESHOLD + 1 || !pinnedCols) {
        return;
      }
      dragAndDrop.getDragAndDropImageComponent()?.setIcon("pinned", false);
      if (!gos.get("suppressMoveWhenColumnDragging")) {
        const columns = this.lastDraggingEvent?.dragItem.columns;
        this.attemptToPinColumns(columns, void 0, true);
      }
    }
  }
  getPinDirection() {
    if (this.needToMoveLeft || this.pinned === "left") {
      return "left";
    }
    if (this.needToMoveRight || this.pinned === "right") {
      return "right";
    }
  }
  attemptToPinColumns(columns, pinned, fromMoving = false) {
    const allowedCols = (columns || []).filter((c) => !c.getColDef().lockPinned);
    if (!allowedCols.length) {
      return 0;
    }
    if (fromMoving) {
      pinned = this.getPinDirection();
    }
    const { pinnedCols, dragAndDrop } = this.beans;
    pinnedCols?.setColsPinned(allowedCols, pinned, "uiColumnDragged");
    if (fromMoving) {
      dragAndDrop.nudge();
    }
    return allowedCols.length;
  }
  destroy() {
    super.destroy();
    this.lastDraggingEvent = null;
    this.clearHighlighted();
    this.lastMovedInfo = null;
  }
};
function setColumnHighlighted(column, highlighted) {
  if (column.highlighted === highlighted) {
    return;
  }
  column.highlighted = highlighted;
  column.dispatchColEvent("headerHighlightChanged", "uiColumnMoved");
}
function findFirstAndLastMovingColumns(allMovingColumns) {
  const moveLen = allMovingColumns.length;
  let firstMovingCol;
  let lastMovingCol;
  for (let i = 0; i < moveLen; i++) {
    if (!firstMovingCol) {
      const leftCol = allMovingColumns[i];
      if (leftCol.getLeft() != null) {
        firstMovingCol = leftCol;
      }
    }
    if (!lastMovingCol) {
      const rightCol = allMovingColumns[moveLen - 1 - i];
      if (rightCol.getLeft() != null) {
        lastMovingCol = rightCol;
      }
    }
    if (firstMovingCol && lastMovingCol) {
      break;
    }
  }
  return { firstMovingCol, lastMovingCol };
}

// packages/ag-grid-community/src/columnMove/columnDrag/bodyDropTarget.ts
var BodyDropTarget = class extends BeanStub {
  constructor(pinned, eContainer) {
    super();
    this.pinned = pinned;
    this.eContainer = eContainer;
  }
  postConstruct() {
    const { ctrlsSvc, dragAndDrop } = this.beans;
    const pinned = this.pinned;
    ctrlsSvc.whenReady(this, (p) => {
      let eSecondaryContainers;
      const eBodyViewport = p.gridBodyCtrl.eBodyViewport;
      switch (pinned) {
        case "left":
          eSecondaryContainers = [
            [eBodyViewport, p.left.eContainer],
            [p.bottomLeft.eContainer],
            [p.topLeft.eContainer]
          ];
          break;
        case "right":
          eSecondaryContainers = [
            [eBodyViewport, p.right.eContainer],
            [p.bottomRight.eContainer],
            [p.topRight.eContainer]
          ];
          break;
        default:
          eSecondaryContainers = [
            [eBodyViewport, p.center.eViewport],
            [p.bottomCenter.eViewport],
            [p.topCenter.eViewport]
          ];
          break;
      }
      this.eSecondaryContainers = eSecondaryContainers;
    });
    this.moveColumnFeature = this.createManagedBean(new MoveColumnFeature(pinned));
    this.bodyDropPivotTarget = this.createManagedBean(new BodyDropPivotTarget(pinned));
    dragAndDrop.addDropTarget(this);
    this.addDestroyFunc(() => dragAndDrop.removeDropTarget(this));
  }
  isInterestedIn(type) {
    return type === 1 /* HeaderCell */ || type === 0 /* ToolPanel */ && this.gos.get("allowDragFromColumnsToolPanel");
  }
  getSecondaryContainers() {
    return this.eSecondaryContainers;
  }
  getContainer() {
    return this.eContainer;
  }
  getIconName() {
    return this.currentDropListener.getIconName();
  }
  // we want to use the bodyPivotTarget if the user is dragging columns in from the toolPanel
  // and we are in pivot mode, as it has to logic to set pivot/value/group on the columns when
  // dropped into the grid's body.
  isDropColumnInPivotMode(draggingEvent) {
    return this.beans.colModel.isPivotMode() && draggingEvent.dragSource.type === 0 /* ToolPanel */;
  }
  onDragEnter(draggingEvent) {
    this.currentDropListener = this.isDropColumnInPivotMode(draggingEvent) ? this.bodyDropPivotTarget : this.moveColumnFeature;
    this.currentDropListener.onDragEnter(draggingEvent);
  }
  onDragLeave(params) {
    this.currentDropListener.onDragLeave(params);
  }
  onDragging(params) {
    this.currentDropListener.onDragging(params);
  }
  onDragStop(params) {
    this.currentDropListener.onDragStop(params);
  }
  onDragCancel() {
    this.currentDropListener.onDragCancel();
  }
};

// packages/ag-grid-community/src/columnMove/columnMoveService.ts
var ColumnMoveService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colMoves";
  }
  moveColumnByIndex(fromIndex, toIndex, source) {
    const gridColumns = this.beans.colModel.getCols();
    if (!gridColumns) {
      return;
    }
    const column = gridColumns[fromIndex];
    this.moveColumns([column], toIndex, source);
  }
  moveColumns(columnsToMoveKeys, toIndex, source, finished = true) {
    const { colModel, colAnimation, visibleCols, eventSvc } = this.beans;
    const gridColumns = colModel.getCols();
    if (!gridColumns) {
      return;
    }
    if (toIndex > gridColumns.length - columnsToMoveKeys.length) {
      _warn(30, { toIndex });
      return;
    }
    colAnimation?.start();
    const movedColumns = colModel.getColsForKeys(columnsToMoveKeys);
    if (this.doesMovePassRules(movedColumns, toIndex)) {
      _moveInArray(colModel.getCols(), movedColumns, toIndex);
      visibleCols.refresh(source);
      eventSvc.dispatchEvent({
        type: "columnMoved",
        columns: movedColumns,
        column: movedColumns.length === 1 ? movedColumns[0] : null,
        toIndex,
        finished,
        source
      });
    }
    colAnimation?.finish();
  }
  doesMovePassRules(columnsToMove, toIndex) {
    const proposedColumnOrder = this.getProposedColumnOrder(columnsToMove, toIndex);
    return this.doesOrderPassRules(proposedColumnOrder);
  }
  doesOrderPassRules(gridOrder) {
    const { colModel, gos } = this.beans;
    if (!doesMovePassMarryChildren(gridOrder, colModel.getColTree())) {
      return false;
    }
    const doesMovePassLockedPositions = (proposedColumnOrder) => {
      const lockPositionToPlacement = (position) => {
        if (!position) {
          return 0 /* NONE */;
        }
        return position === "left" || position === true ? -1 /* LEFT */ : 1 /* RIGHT */;
      };
      const isRtl = gos.get("enableRtl");
      let lastPlacement = isRtl ? 1 /* RIGHT */ : -1 /* LEFT */;
      let rulePassed = true;
      proposedColumnOrder.forEach((col) => {
        const placement = lockPositionToPlacement(col.getColDef().lockPosition);
        if (isRtl) {
          if (placement > lastPlacement) {
            rulePassed = false;
          }
        } else {
          if (placement < lastPlacement) {
            rulePassed = false;
          }
        }
        lastPlacement = placement;
      });
      return rulePassed;
    };
    if (!doesMovePassLockedPositions(gridOrder)) {
      return false;
    }
    return true;
  }
  getProposedColumnOrder(columnsToMove, toIndex) {
    const gridColumns = this.beans.colModel.getCols();
    const proposedColumnOrder = gridColumns.slice();
    _moveInArray(proposedColumnOrder, columnsToMove, toIndex);
    return proposedColumnOrder;
  }
  createBodyDropTarget(pinned, dropContainer) {
    return new BodyDropTarget(pinned, dropContainer);
  }
  moveHeader(hDirection, eGui, column, pinned, bean) {
    const { ctrlsSvc, gos, colModel, visibleCols, focusSvc } = this.beans;
    const rect = eGui.getBoundingClientRect();
    const left = rect.left;
    const isGroup = isColumnGroup(column);
    const width = isGroup ? rect.width : column.getActualWidth();
    const isLeft = hDirection === "left" !== gos.get("enableRtl");
    const xPosition = normaliseX({
      x: isLeft ? left - 20 : left + width + 20,
      pinned,
      fromKeyboard: true,
      gos,
      ctrlsSvc
    });
    const headerPosition = focusSvc.focusedHeader;
    attemptMoveColumns({
      allMovingColumns: isGroup ? column.getLeafColumns() : [column],
      isFromHeader: true,
      fromLeft: hDirection === "right",
      xPosition,
      pinned,
      fromEnter: false,
      fakeEvent: false,
      gos,
      colModel,
      colMoves: this,
      visibleCols,
      finished: true
    });
    let targetColumn;
    if (isGroup) {
      const displayedLeafColumns = column.getDisplayedLeafColumns();
      targetColumn = isLeft ? displayedLeafColumns[0] : _last(displayedLeafColumns);
    } else {
      targetColumn = column;
    }
    ctrlsSvc.getScrollFeature().ensureColumnVisible(targetColumn, "auto");
    if ((!bean.isAlive() || gos.get("ensureDomOrder")) && headerPosition) {
      let restoreFocusColumn;
      if (isGroup) {
        const groupId = column.getGroupId();
        const leafCols = column.getLeafColumns();
        if (!leafCols.length) {
          return;
        }
        const parent = leafCols[0].getParent();
        if (!parent) {
          return;
        }
        restoreFocusColumn = findGroupWidthId(parent, groupId);
      } else {
        restoreFocusColumn = column;
      }
      if (restoreFocusColumn) {
        focusSvc.focusHeaderPosition({
          headerPosition: {
            ...headerPosition,
            column: restoreFocusColumn
          }
        });
      }
    }
  }
  setDragSourceForHeader(eSource, column, displayName) {
    const { gos, colModel, dragAndDrop, visibleCols } = this.beans;
    let hideColumnOnExit = !gos.get("suppressDragLeaveHidesColumns");
    const isGroup = isColumnGroup(column);
    const columns = isGroup ? column.getProvidedColumnGroup().getLeafColumns() : [column];
    const getDragItem = isGroup ? () => createDragItemForGroup(column, visibleCols.allCols) : () => createDragItem(column);
    const dragSource = {
      type: 1 /* HeaderCell */,
      eElement: eSource,
      getDefaultIconName: () => hideColumnOnExit ? "hide" : "notAllowed",
      getDragItem,
      dragItemName: displayName,
      onDragStarted: () => {
        hideColumnOnExit = !gos.get("suppressDragLeaveHidesColumns");
        setColumnsMoving(columns, true);
      },
      onDragStopped: () => setColumnsMoving(columns, false),
      onDragCancelled: () => setColumnsMoving(columns, false),
      onGridEnter: (dragItem) => {
        if (hideColumnOnExit) {
          const { columns: columns2 = [], visibleState } = dragItem ?? {};
          const hasVisibleState = isGroup ? (col) => !visibleState || visibleState[col.getColId()] : () => true;
          const unlockedColumns = columns2.filter(
            (col) => !col.getColDef().lockVisible && hasVisibleState(col)
          );
          colModel.setColsVisible(unlockedColumns, true, "uiColumnMoved");
        }
      },
      onGridExit: (dragItem) => {
        if (hideColumnOnExit) {
          const unlockedColumns = dragItem?.columns?.filter((col) => !col.getColDef().lockVisible) || [];
          colModel.setColsVisible(unlockedColumns, false, "uiColumnMoved");
        }
      }
    };
    dragAndDrop.addDragSource(dragSource, true);
    return dragSource;
  }
};
function findGroupWidthId(columnGroup, id) {
  while (columnGroup) {
    if (columnGroup.getGroupId() === id) {
      return columnGroup;
    }
    columnGroup = columnGroup.getParent();
  }
  return void 0;
}
function createDragItem(column) {
  const visibleState = {};
  visibleState[column.getId()] = column.isVisible();
  return {
    columns: [column],
    visibleState,
    containerType: column.pinned
  };
}
function createDragItemForGroup(columnGroup, allCols) {
  const allColumnsOriginalOrder = columnGroup.getProvidedColumnGroup().getLeafColumns();
  const visibleState = {};
  allColumnsOriginalOrder.forEach((column) => visibleState[column.getId()] = column.isVisible());
  const allColumnsCurrentOrder = [];
  allCols.forEach((column) => {
    if (allColumnsOriginalOrder.indexOf(column) >= 0) {
      allColumnsCurrentOrder.push(column);
      _removeFromArray(allColumnsOriginalOrder, column);
    }
  });
  allColumnsOriginalOrder.forEach((column) => allColumnsCurrentOrder.push(column));
  const columnsInSplit = [];
  const columnGroupColumns = columnGroup.getLeafColumns();
  for (const col of allColumnsCurrentOrder) {
    if (columnGroupColumns.indexOf(col) !== -1) {
      columnsInSplit.push(col);
    }
  }
  return {
    columns: allColumnsCurrentOrder,
    columnsInSplit,
    visibleState,
    containerType: columnsInSplit[0]?.pinned
  };
}

// packages/ag-grid-community/src/columnMove/columnMoveModule.ts
var ColumnMoveModule = {
  moduleName: "ColumnMove",
  version: VERSION,
  beans: [ColumnMoveService, ColumnAnimationService],
  apiFunctions: {
    moveColumnByIndex,
    moveColumns
  },
  dependsOn: [SharedDragAndDropModule],
  css: [columnMovingCSS]
};

// packages/ag-grid-community/src/rendering/autoWidthCalculator.ts
var AutoWidthCalculator = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "autoWidthCalc";
  }
  postConstruct() {
    this.beans.ctrlsSvc.whenReady(this, (p) => {
      this.centerRowContainerCtrl = p.center;
    });
  }
  // this is the trick: we create a dummy container and clone all the cells
  // into the dummy, then check the dummy's width. then destroy the dummy
  // as we don't need it any more.
  // drawback: only the cells visible on the screen are considered
  getPreferredWidthForColumn(column, skipHeader) {
    const eHeaderCell = this.getHeaderCellForColumn(column);
    if (!eHeaderCell) {
      return -1;
    }
    const elements = this.beans.rowRenderer.getAllCellsNotSpanningForColumn(column);
    if (!skipHeader) {
      elements.push(eHeaderCell);
    }
    return this.getPreferredWidthForElements(elements);
  }
  getPreferredWidthForColumnGroup(columnGroup) {
    const eHeaderCell = this.getHeaderCellForColumn(columnGroup);
    if (!eHeaderCell) {
      return -1;
    }
    return this.getPreferredWidthForElements([eHeaderCell]);
  }
  getPreferredWidthForElements(elements, extraPadding) {
    const eDummyContainer = document.createElement("form");
    eDummyContainer.style.position = "fixed";
    const eBodyContainer = this.centerRowContainerCtrl.eContainer;
    elements.forEach((el) => this.cloneItemIntoDummy(el, eDummyContainer));
    eBodyContainer.appendChild(eDummyContainer);
    const dummyContainerWidth = eDummyContainer.offsetWidth;
    eBodyContainer.removeChild(eDummyContainer);
    extraPadding = extraPadding ?? this.gos.get("autoSizePadding");
    return dummyContainerWidth + extraPadding;
  }
  getHeaderCellForColumn(column) {
    let element = null;
    this.beans.ctrlsSvc.getHeaderRowContainerCtrls().forEach((container) => {
      const res = container.getHtmlElementForColumnHeader(column);
      if (res != null) {
        element = res;
      }
    });
    return element;
  }
  cloneItemIntoDummy(eCell, eDummyContainer) {
    const eCellClone = eCell.cloneNode(true);
    eCellClone.style.width = "";
    eCellClone.style.position = "static";
    eCellClone.style.left = "";
    const eCloneParent = document.createElement("div");
    const eCloneParentClassList = eCloneParent.classList;
    const isHeader = ["ag-header-cell", "ag-header-group-cell"].some((cls) => eCellClone.classList.contains(cls));
    if (isHeader) {
      eCloneParentClassList.add("ag-header", "ag-header-row");
      eCloneParent.style.position = "static";
    } else {
      eCloneParentClassList.add("ag-row");
    }
    let pointer = eCell.parentElement;
    while (pointer) {
      const isRow = ["ag-header-row", "ag-row"].some((cls) => pointer.classList.contains(cls));
      if (isRow) {
        for (let i = 0; i < pointer.classList.length; i++) {
          const item = pointer.classList[i];
          if (item != "ag-row-position-absolute") {
            eCloneParentClassList.add(item);
          }
        }
        break;
      }
      pointer = pointer.parentElement;
    }
    eCloneParent.appendChild(eCellClone);
    eDummyContainer.appendChild(eCloneParent);
  }
};

// packages/ag-grid-community/src/rendering/autoWidthModule.ts
var AutoWidthModule = {
  moduleName: "AutoWidth",
  version: VERSION,
  beans: [AutoWidthCalculator]
};

// packages/ag-grid-community/src/columnResize/columnResizeApi.ts
function setColumnWidths(beans, columnWidths, finished = true, source = "api") {
  beans.colResize?.setColumnWidths(columnWidths, false, finished, source);
}

// packages/ag-grid-community/src/columnResize/groupResizeFeature.ts
var GroupResizeFeature = class extends BeanStub {
  constructor(comp, eResize, pinned, columnGroup) {
    super();
    this.comp = comp;
    this.eResize = eResize;
    this.pinned = pinned;
    this.columnGroup = columnGroup;
  }
  postConstruct() {
    if (!this.columnGroup.isResizable()) {
      this.comp.setResizableDisplayed(false);
      return;
    }
    const { horizontalResizeSvc, gos, colAutosize } = this.beans;
    const finishedWithResizeFunc = horizontalResizeSvc.addResizeBar({
      eResizeBar: this.eResize,
      onResizeStart: this.onResizeStart.bind(this),
      onResizing: this.onResizing.bind(this, false),
      onResizeEnd: this.onResizing.bind(this, true)
    });
    this.addDestroyFunc(finishedWithResizeFunc);
    if (!gos.get("suppressAutoSize") && colAutosize) {
      this.addDestroyFunc(
        colAutosize.addColumnGroupResize(
          this.eResize,
          this.columnGroup,
          () => this.resizeLeafColumnsToFit("uiColumnResized")
        )
      );
    }
  }
  onResizeStart(shiftKey) {
    const {
      columnsToResize,
      resizeStartWidth,
      resizeRatios,
      groupAfterColumns,
      groupAfterStartWidth,
      groupAfterRatios
    } = this.getInitialValues(shiftKey);
    this.resizeCols = columnsToResize;
    this.resizeStartWidth = resizeStartWidth;
    this.resizeRatios = resizeRatios;
    this.resizeTakeFromCols = groupAfterColumns;
    this.resizeTakeFromStartWidth = groupAfterStartWidth;
    this.resizeTakeFromRatios = groupAfterRatios;
    this.toggleColumnResizing(true);
  }
  onResizing(finished, resizeAmount, source = "uiColumnResized") {
    const resizeAmountNormalised = this.normaliseDragChange(resizeAmount);
    const width = this.resizeStartWidth + resizeAmountNormalised;
    this.resizeColumnsFromLocalValues(width, source, finished);
  }
  getInitialValues(shiftKey) {
    const getInitialSizeOfColumns = (columns) => columns.reduce((totalWidth, column) => totalWidth + column.getActualWidth(), 0);
    const getSizeRatiosOfColumns = (columns, initialSizeOfColumns) => columns.map((column) => column.getActualWidth() / initialSizeOfColumns);
    const columnsToResize = this.getColumnsToResize();
    const resizeStartWidth = getInitialSizeOfColumns(columnsToResize);
    const resizeRatios = getSizeRatiosOfColumns(columnsToResize, resizeStartWidth);
    const columnSizeAndRatios = {
      columnsToResize,
      resizeStartWidth,
      resizeRatios
    };
    let groupAfter = null;
    if (shiftKey) {
      groupAfter = this.beans.colGroupSvc?.getGroupAtDirection(this.columnGroup, "After") ?? null;
    }
    if (groupAfter) {
      const takeFromLeafCols = groupAfter.getDisplayedLeafColumns();
      const groupAfterColumns = columnSizeAndRatios.groupAfterColumns = takeFromLeafCols.filter(
        (col) => col.isResizable()
      );
      const groupAfterStartWidth = columnSizeAndRatios.groupAfterStartWidth = getInitialSizeOfColumns(groupAfterColumns);
      columnSizeAndRatios.groupAfterRatios = getSizeRatiosOfColumns(groupAfterColumns, groupAfterStartWidth);
    } else {
      columnSizeAndRatios.groupAfterColumns = void 0;
      columnSizeAndRatios.groupAfterStartWidth = void 0;
      columnSizeAndRatios.groupAfterRatios = void 0;
    }
    return columnSizeAndRatios;
  }
  resizeLeafColumnsToFit(source) {
    const preferredSize = this.beans.autoWidthCalc.getPreferredWidthForColumnGroup(this.columnGroup);
    const initialValues = this.getInitialValues();
    if (preferredSize > initialValues.resizeStartWidth) {
      this.resizeColumns(initialValues, preferredSize, source, true);
    }
  }
  resizeColumnsFromLocalValues(totalWidth, source, finished = true) {
    if (!this.resizeCols || !this.resizeRatios) {
      return;
    }
    const initialValues = {
      columnsToResize: this.resizeCols,
      resizeStartWidth: this.resizeStartWidth,
      resizeRatios: this.resizeRatios,
      groupAfterColumns: this.resizeTakeFromCols,
      groupAfterStartWidth: this.resizeTakeFromStartWidth,
      groupAfterRatios: this.resizeTakeFromRatios
    };
    this.resizeColumns(initialValues, totalWidth, source, finished);
  }
  resizeColumns(initialValues, totalWidth, source, finished = true) {
    const {
      columnsToResize,
      resizeStartWidth,
      resizeRatios,
      groupAfterColumns,
      groupAfterStartWidth,
      groupAfterRatios
    } = initialValues;
    const resizeSets = [];
    resizeSets.push({
      columns: columnsToResize,
      ratios: resizeRatios,
      width: totalWidth
    });
    if (groupAfterColumns) {
      const diff = totalWidth - resizeStartWidth;
      resizeSets.push({
        columns: groupAfterColumns,
        ratios: groupAfterRatios,
        width: groupAfterStartWidth - diff
      });
    }
    this.beans.colResize?.resizeColumnSets({
      resizeSets,
      finished,
      source
    });
    if (finished) {
      this.toggleColumnResizing(false);
    }
  }
  toggleColumnResizing(resizing) {
    this.comp.toggleCss("ag-column-resizing", resizing);
  }
  getColumnsToResize() {
    const leafCols = this.columnGroup.getDisplayedLeafColumns();
    return leafCols.filter((col) => col.isResizable());
  }
  // optionally inverts the drag, depending on pinned and RTL
  // note - this method is duplicated in RenderedHeaderCell - should refactor out?
  normaliseDragChange(dragChange) {
    let result = dragChange;
    if (this.gos.get("enableRtl")) {
      if (this.pinned !== "left") {
        result *= -1;
      }
    } else if (this.pinned === "right") {
      result *= -1;
    }
    return result;
  }
  destroy() {
    super.destroy();
    this.resizeCols = void 0;
    this.resizeRatios = void 0;
    this.resizeTakeFromCols = void 0;
    this.resizeTakeFromRatios = void 0;
  }
};

// packages/ag-grid-community/src/columnResize/resizeFeature.ts
var ResizeFeature = class extends BeanStub {
  constructor(pinned, column, eResize, comp, ctrl) {
    super();
    this.pinned = pinned;
    this.column = column;
    this.eResize = eResize;
    this.comp = comp;
    this.ctrl = ctrl;
  }
  postConstruct() {
    const destroyResizeFuncs = [];
    let canResize;
    let canAutosize;
    const addResize = () => {
      _setDisplayed(this.eResize, canResize);
      if (!canResize) {
        return;
      }
      const { horizontalResizeSvc, colAutosize } = this.beans;
      const finishedWithResizeFunc = horizontalResizeSvc.addResizeBar({
        eResizeBar: this.eResize,
        onResizeStart: this.onResizeStart.bind(this),
        onResizing: this.onResizing.bind(this, false),
        onResizeEnd: this.onResizing.bind(this, true)
      });
      destroyResizeFuncs.push(finishedWithResizeFunc);
      if (canAutosize && colAutosize) {
        destroyResizeFuncs.push(colAutosize.addColumnAutosize(this.eResize, this.column));
      }
    };
    const removeResize = () => {
      destroyResizeFuncs.forEach((f) => f());
      destroyResizeFuncs.length = 0;
    };
    const refresh = () => {
      const resize = this.column.isResizable();
      const autoSize = !this.gos.get("suppressAutoSize") && !this.column.getColDef().suppressAutoSize;
      const propertyChange = resize !== canResize || autoSize !== canAutosize;
      if (propertyChange) {
        canResize = resize;
        canAutosize = autoSize;
        removeResize();
        addResize();
      }
    };
    refresh();
    this.addDestroyFunc(removeResize);
    this.ctrl.setRefreshFunction("resize", refresh);
  }
  onResizing(finished, resizeAmount) {
    const { column: key, lastResizeAmount, resizeStartWidth, beans } = this;
    const resizeAmountNormalised = this.normaliseResizeAmount(resizeAmount);
    const newWidth = resizeStartWidth + resizeAmountNormalised;
    const columnWidths = [{ key, newWidth }];
    const { pinnedCols, ctrlsSvc, colResize } = beans;
    if (this.column.getPinned()) {
      const leftWidth = pinnedCols?.leftWidth ?? 0;
      const rightWidth = pinnedCols?.rightWidth ?? 0;
      const bodyWidth = _getInnerWidth(ctrlsSvc.getGridBodyCtrl().eBodyViewport) - 50;
      if (leftWidth + rightWidth + (resizeAmountNormalised - lastResizeAmount) > bodyWidth) {
        return;
      }
    }
    this.lastResizeAmount = resizeAmountNormalised;
    colResize?.setColumnWidths(columnWidths, this.resizeWithShiftKey, finished, "uiColumnResized");
    if (finished) {
      this.toggleColumnResizing(false);
    }
  }
  onResizeStart(shiftKey) {
    this.resizeStartWidth = this.column.getActualWidth();
    this.lastResizeAmount = 0;
    this.resizeWithShiftKey = shiftKey;
    this.toggleColumnResizing(true);
  }
  toggleColumnResizing(resizing) {
    this.column.resizing = resizing;
    this.comp.toggleCss("ag-column-resizing", resizing);
  }
  // optionally inverts the drag, depending on pinned and RTL
  // note - this method is duplicated in RenderedHeaderGroupCell - should refactor out?
  normaliseResizeAmount(dragChange) {
    let result = dragChange;
    const notPinningLeft = this.pinned !== "left";
    const pinningRight = this.pinned === "right";
    if (this.gos.get("enableRtl")) {
      if (notPinningLeft) {
        result *= -1;
      }
    } else {
      if (pinningRight) {
        result *= -1;
      }
    }
    return result;
  }
};

// packages/ag-grid-community/src/columnResize/columnResizeService.ts
var ColumnResizeService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colResize";
  }
  setColumnWidths(columnWidths, shiftKey, finished, source) {
    const sets = [];
    const { colModel, gos, visibleCols } = this.beans;
    columnWidths.forEach((columnWidth) => {
      const col = colModel.getColDefCol(columnWidth.key) || colModel.getCol(columnWidth.key);
      if (!col) {
        return;
      }
      sets.push({
        width: columnWidth.newWidth,
        ratios: [1],
        columns: [col]
      });
      const defaultIsShift = gos.get("colResizeDefault") === "shift";
      if (defaultIsShift) {
        shiftKey = !shiftKey;
      }
      if (shiftKey) {
        const otherCol = visibleCols.getColAfter(col);
        if (!otherCol) {
          return;
        }
        const widthDiff = col.getActualWidth() - columnWidth.newWidth;
        const otherColWidth = otherCol.getActualWidth() + widthDiff;
        sets.push({
          width: otherColWidth,
          ratios: [1],
          columns: [otherCol]
        });
      }
    });
    if (sets.length === 0) {
      return;
    }
    this.resizeColumnSets({
      resizeSets: sets,
      finished,
      source
    });
  }
  // method takes sets of columns and resizes them. either all sets will be resized, or nothing
  // be resized. this is used for example when user tries to resize a group and holds shift key,
  // then both the current group (grows), and the adjacent group (shrinks), will get resized,
  // so that's two sets for this method.
  resizeColumnSets(params) {
    const { resizeSets, finished, source } = params;
    const passMinMaxCheck = !resizeSets || resizeSets.every((columnResizeSet) => checkMinAndMaxWidthsForSet(columnResizeSet));
    if (!passMinMaxCheck) {
      if (finished) {
        const columns = resizeSets && resizeSets.length > 0 ? resizeSets[0].columns : null;
        dispatchColumnResizedEvent(this.eventSvc, columns, finished, source);
      }
      return;
    }
    const changedCols = [];
    const allResizedCols = [];
    resizeSets.forEach((set) => {
      const { width, columns, ratios } = set;
      const newWidths = {};
      const finishedCols = {};
      columns.forEach((col) => allResizedCols.push(col));
      let finishedColsGrew = true;
      let loopCount = 0;
      while (finishedColsGrew) {
        loopCount++;
        if (loopCount > 1e3) {
          _error(31);
          break;
        }
        finishedColsGrew = false;
        const subsetCols = [];
        let subsetRatioTotal = 0;
        let pixelsToDistribute = width;
        columns.forEach((col, index) => {
          const thisColFinished = finishedCols[col.getId()];
          if (thisColFinished) {
            pixelsToDistribute -= newWidths[col.getId()];
          } else {
            subsetCols.push(col);
            const ratioThisCol = ratios[index];
            subsetRatioTotal += ratioThisCol;
          }
        });
        const ratioScale = 1 / subsetRatioTotal;
        subsetCols.forEach((col, index) => {
          const lastCol = index === subsetCols.length - 1;
          let colNewWidth;
          if (lastCol) {
            colNewWidth = pixelsToDistribute;
          } else {
            colNewWidth = Math.round(ratios[index] * width * ratioScale);
            pixelsToDistribute -= colNewWidth;
          }
          const minWidth = col.getMinWidth();
          const maxWidth = col.getMaxWidth();
          if (colNewWidth < minWidth) {
            colNewWidth = minWidth;
            finishedCols[col.getId()] = true;
            finishedColsGrew = true;
          } else if (maxWidth > 0 && colNewWidth > maxWidth) {
            colNewWidth = maxWidth;
            finishedCols[col.getId()] = true;
            finishedColsGrew = true;
          }
          newWidths[col.getId()] = colNewWidth;
        });
      }
      columns.forEach((col) => {
        const newWidth = newWidths[col.getId()];
        const actualWidth = col.getActualWidth();
        if (actualWidth !== newWidth) {
          col.setActualWidth(newWidth, source);
          changedCols.push(col);
        }
      });
    });
    const atLeastOneColChanged = changedCols.length > 0;
    let flexedCols = [];
    if (atLeastOneColChanged) {
      const { colFlex, visibleCols, colViewport } = this.beans;
      flexedCols = colFlex?.refreshFlexedColumns({
        resizingCols: allResizedCols,
        skipSetLeft: true
      }) ?? [];
      visibleCols.setLeftValues(source);
      visibleCols.updateBodyWidths();
      colViewport.checkViewportColumns();
    }
    const colsForEvent = allResizedCols.concat(flexedCols);
    if (atLeastOneColChanged || finished) {
      dispatchColumnResizedEvent(this.eventSvc, colsForEvent, finished, source, flexedCols);
    }
  }
  resizeHeader(column, delta, shiftKey) {
    if (!column.isResizable()) {
      return;
    }
    const actualWidth = column.getActualWidth();
    const minWidth = column.getMinWidth();
    const maxWidth = column.getMaxWidth();
    const newWidth = Math.min(Math.max(actualWidth + delta, minWidth), maxWidth);
    this.setColumnWidths([{ key: column, newWidth }], shiftKey, true, "uiColumnResized");
  }
  createResizeFeature(pinned, column, eResize, comp, ctrl) {
    return new ResizeFeature(pinned, column, eResize, comp, ctrl);
  }
  createGroupResizeFeature(comp, eResize, pinned, columnGroup) {
    return new GroupResizeFeature(comp, eResize, pinned, columnGroup);
  }
};
function checkMinAndMaxWidthsForSet(columnResizeSet) {
  const { columns, width } = columnResizeSet;
  let minWidthAccumulated = 0;
  let maxWidthAccumulated = 0;
  let maxWidthActive = true;
  columns.forEach((col) => {
    const minWidth = col.getMinWidth();
    minWidthAccumulated += minWidth || 0;
    const maxWidth = col.getMaxWidth();
    if (maxWidth > 0) {
      maxWidthAccumulated += maxWidth;
    } else {
      maxWidthActive = false;
    }
  });
  const minWidthPasses = width >= minWidthAccumulated;
  const maxWidthPasses = !maxWidthActive || width <= maxWidthAccumulated;
  return minWidthPasses && maxWidthPasses;
}

// packages/ag-grid-community/src/columnResize/columnResizeModule.ts
var ColumnResizeModule = {
  moduleName: "ColumnResize",
  version: VERSION,
  beans: [ColumnResizeService],
  apiFunctions: {
    setColumnWidths
  },
  dependsOn: [HorizontalResizeModule, AutoWidthModule]
};

// packages/ag-grid-community/src/headerRendering/cells/columnGroup/groupWidthFeature.ts
var GroupWidthFeature = class extends BeanStub {
  constructor(comp, columnGroup) {
    super();
    // the children can change, we keep destroy functions related to listening to the children here
    this.removeChildListenersFuncs = [];
    this.columnGroup = columnGroup;
    this.comp = comp;
  }
  postConstruct() {
    this.addListenersToChildrenColumns();
    this.addManagedListeners(this.columnGroup, {
      displayedChildrenChanged: this.onDisplayedChildrenChanged.bind(this)
    });
    this.onWidthChanged();
    this.addDestroyFunc(this.removeListenersOnChildrenColumns.bind(this));
  }
  addListenersToChildrenColumns() {
    this.removeListenersOnChildrenColumns();
    const widthChangedListener = this.onWidthChanged.bind(this);
    this.columnGroup.getLeafColumns().forEach((column) => {
      column.__addEventListener("widthChanged", widthChangedListener);
      column.__addEventListener("visibleChanged", widthChangedListener);
      this.removeChildListenersFuncs.push(() => {
        column.__removeEventListener("widthChanged", widthChangedListener);
        column.__removeEventListener("visibleChanged", widthChangedListener);
      });
    });
  }
  removeListenersOnChildrenColumns() {
    this.removeChildListenersFuncs.forEach((func) => func());
    this.removeChildListenersFuncs = [];
  }
  onDisplayedChildrenChanged() {
    this.addListenersToChildrenColumns();
    this.onWidthChanged();
  }
  onWidthChanged() {
    const columnWidth = this.columnGroup.getActualWidth();
    this.comp.setWidth(`${columnWidth}px`);
    this.comp.toggleCss("ag-hidden", columnWidth === 0);
  }
};

// packages/ag-grid-community/src/headerRendering/cells/columnGroup/headerGroupCellCtrl.ts
var HeaderGroupCellCtrl = class extends AbstractHeaderCellCtrl {
  constructor() {
    super(...arguments);
    this.onSuppressColMoveChange = () => {
      if (!this.isAlive() || this.isSuppressMoving()) {
        this.removeDragSource();
      } else {
        if (!this.dragSource) {
          this.setDragSource(this.eGui);
        }
      }
    };
  }
  setComp(comp, eGui, eResize, eHeaderCompWrapper, compBean) {
    const { column, beans } = this;
    const { context, colNames, colHover, rangeSvc, colResize } = beans;
    this.comp = comp;
    compBean = setupCompBean(this, context, compBean);
    this.setGui(eGui, compBean);
    this.displayName = colNames.getDisplayNameForColumnGroup(column, "header");
    this.refreshHeaderStyles();
    this.addClasses();
    this.setupMovingCss(compBean);
    this.setupExpandable(compBean);
    this.setupTooltip();
    this.setupAutoHeight({
      wrapperElement: eHeaderCompWrapper,
      compBean
    });
    this.setupUserComp();
    this.addHeaderMouseListeners(compBean);
    this.addManagedPropertyListener("groupHeaderHeight", this.refreshMaxHeaderHeight.bind(this));
    this.refreshMaxHeaderHeight();
    const pinned = this.rowCtrl.pinned;
    const leafCols = column.getProvidedColumnGroup().getLeafColumns();
    colHover?.createHoverFeature(compBean, leafCols, eGui);
    rangeSvc?.createRangeHighlightFeature(compBean, column, comp);
    compBean.createManagedBean(new SetLeftFeature(column, eGui, beans));
    compBean.createManagedBean(new GroupWidthFeature(comp, column));
    if (colResize) {
      this.resizeFeature = compBean.createManagedBean(
        colResize.createGroupResizeFeature(comp, eResize, pinned, column)
      );
    } else {
      comp.setResizableDisplayed(false);
    }
    compBean.createManagedBean(
      new ManagedFocusFeature(eGui, {
        shouldStopEventPropagation: this.shouldStopEventPropagation.bind(this),
        onTabKeyDown: () => void 0,
        handleKeyDown: this.handleKeyDown.bind(this),
        onFocusIn: this.onFocusIn.bind(this)
      })
    );
    this.addHighlightListeners(compBean, leafCols);
    compBean.addManagedPropertyListener("suppressMovableColumns", this.onSuppressColMoveChange);
    this.addResizeAndMoveKeyboardListeners(compBean);
    compBean.addDestroyFunc(() => this.clearComponent());
  }
  getHeaderClassParams() {
    const { column, beans } = this;
    const colDef = column.getDefinition();
    return _addGridCommonParams(beans.gos, {
      colDef,
      columnGroup: column,
      floatingFilter: false
    });
  }
  refreshMaxHeaderHeight() {
    const { gos, comp } = this;
    const groupHeaderHeight = gos.get("groupHeaderHeight");
    if (groupHeaderHeight != null) {
      if (groupHeaderHeight === 0) {
        comp.setHeaderWrapperHidden(true);
      } else {
        comp.setHeaderWrapperMaxHeight(groupHeaderHeight);
      }
    } else {
      comp.setHeaderWrapperHidden(false);
      comp.setHeaderWrapperMaxHeight(null);
    }
  }
  addHighlightListeners(compBean, columns) {
    if (!this.beans.gos.get("suppressMoveWhenColumnDragging")) {
      return;
    }
    for (const column of columns) {
      compBean.addManagedListeners(column, {
        headerHighlightChanged: this.onLeafColumnHighlightChanged.bind(this, column)
      });
    }
  }
  onLeafColumnHighlightChanged(column) {
    const displayedColumns = this.column.getDisplayedLeafColumns();
    const isFirst = displayedColumns[0] === column;
    const isLast = _last(displayedColumns) === column;
    if (!isFirst && !isLast) {
      return;
    }
    const highlighted = column.getHighlighted();
    const isColumnMoveAtThisLevel = !!this.rowCtrl.getHeaderCellCtrls().find((ctrl) => {
      return ctrl.column.isMoving();
    });
    let beforeOn = false;
    let afterOn = false;
    if (isColumnMoveAtThisLevel) {
      const isRtl = this.beans.gos.get("enableRtl");
      const isHighlightAfter = highlighted === 1 /* After */;
      const isHighlightBefore = highlighted === 0 /* Before */;
      if (isFirst) {
        if (isRtl) {
          afterOn = isHighlightAfter;
        } else {
          beforeOn = isHighlightBefore;
        }
      }
      if (isLast) {
        if (isRtl) {
          beforeOn = isHighlightBefore;
        } else {
          afterOn = isHighlightAfter;
        }
      }
    }
    this.comp.toggleCss("ag-header-highlight-before", beforeOn);
    this.comp.toggleCss("ag-header-highlight-after", afterOn);
  }
  resizeHeader(delta, shiftKey) {
    const { resizeFeature } = this;
    if (!resizeFeature) {
      return;
    }
    const initialValues = resizeFeature.getInitialValues(shiftKey);
    resizeFeature.resizeColumns(initialValues, initialValues.resizeStartWidth + delta, "uiColumnResized", true);
  }
  resizeLeafColumnsToFit(source) {
    this.resizeFeature?.resizeLeafColumnsToFit(source);
  }
  setupUserComp() {
    const { colGroupSvc, userCompFactory, gos, enterpriseMenuFactory } = this.beans;
    const columnGroup = this.column;
    const providedColumnGroup = columnGroup.getProvidedColumnGroup();
    const params = _addGridCommonParams(gos, {
      displayName: this.displayName,
      columnGroup,
      setExpanded: (expanded) => {
        colGroupSvc.setColumnGroupOpened(providedColumnGroup, expanded, "gridInitializing");
      },
      setTooltip: (value, shouldDisplayTooltip) => {
        gos.assertModuleRegistered("Tooltip", 3);
        this.setupTooltip(value, shouldDisplayTooltip);
      },
      showColumnMenu: (buttonElement, onClosedCallback) => enterpriseMenuFactory?.showMenuAfterButtonClick(
        providedColumnGroup,
        buttonElement,
        "columnMenu",
        onClosedCallback
      ),
      showColumnMenuAfterMouseClick: (mouseEvent, onClosedCallback) => enterpriseMenuFactory?.showMenuAfterMouseEvent(
        providedColumnGroup,
        mouseEvent,
        "columnMenu",
        onClosedCallback
      ),
      eGridHeader: this.eGui
    });
    const compDetails = _getHeaderGroupCompDetails(userCompFactory, params);
    if (compDetails) {
      this.comp.setUserCompDetails(compDetails);
    }
  }
  addHeaderMouseListeners(compBean) {
    const listener = (e) => this.handleMouseOverChange(e.type === "mouseenter");
    const clickListener = () => this.dispatchColumnMouseEvent("columnHeaderClicked", this.column.getProvidedColumnGroup());
    const contextMenuListener = (event) => this.handleContextMenuMouseEvent(event, void 0, this.column.getProvidedColumnGroup());
    compBean.addManagedListeners(this.eGui, {
      mouseenter: listener,
      mouseleave: listener,
      click: clickListener,
      contextmenu: contextMenuListener
    });
  }
  handleMouseOverChange(isMouseOver) {
    this.eventSvc.dispatchEvent({
      type: isMouseOver ? "columnHeaderMouseOver" : "columnHeaderMouseLeave",
      column: this.column.getProvidedColumnGroup()
    });
  }
  setupTooltip(value, shouldDisplayTooltip) {
    this.tooltipFeature = this.beans.tooltipSvc?.setupHeaderGroupTooltip(
      this.tooltipFeature,
      this,
      value,
      shouldDisplayTooltip
    );
  }
  setupExpandable(compBean) {
    const providedColGroup = this.column.getProvidedColumnGroup();
    this.refreshExpanded();
    const listener = this.refreshExpanded.bind(this);
    compBean.addManagedListeners(providedColGroup, {
      expandedChanged: listener,
      expandableChanged: listener
    });
  }
  refreshExpanded() {
    const { column } = this;
    this.expandable = column.isExpandable();
    const expanded = column.isExpanded();
    if (this.expandable) {
      this.comp.setAriaExpanded(expanded ? "true" : "false");
    } else {
      this.comp.setAriaExpanded(void 0);
    }
    this.refreshHeaderStyles();
  }
  addClasses() {
    const { column } = this;
    const colGroupDef = column.getColGroupDef();
    const classes = _getHeaderClassesFromColDef(colGroupDef, this.gos, null, column);
    if (column.isPadding()) {
      classes.push("ag-header-group-cell-no-group");
      const leafCols = column.getLeafColumns();
      if (leafCols.every((col) => col.isSpanHeaderHeight())) {
        classes.push("ag-header-span-height");
      }
    } else {
      classes.push("ag-header-group-cell-with-group");
      if (colGroupDef?.wrapHeaderText) {
        classes.push("ag-header-cell-wrap-text");
      }
    }
    classes.forEach((c) => this.comp.toggleCss(c, true));
  }
  setupMovingCss(compBean) {
    const { column } = this;
    const providedColumnGroup = column.getProvidedColumnGroup();
    const leafColumns = providedColumnGroup.getLeafColumns();
    const listener = () => this.comp.toggleCss("ag-header-cell-moving", column.isMoving());
    leafColumns.forEach((col) => {
      compBean.addManagedListeners(col, { movingChanged: listener });
    });
    listener();
  }
  onFocusIn(e) {
    if (!this.eGui.contains(e.relatedTarget)) {
      this.focusThis();
    }
  }
  handleKeyDown(e) {
    super.handleKeyDown(e);
    const wrapperHasFocus = this.getWrapperHasFocus();
    if (!this.expandable || !wrapperHasFocus) {
      return;
    }
    if (e.key === KeyCode.ENTER) {
      const column = this.column;
      const newExpandedValue = !column.isExpanded();
      this.beans.colGroupSvc.setColumnGroupOpened(
        column.getProvidedColumnGroup(),
        newExpandedValue,
        "uiColumnExpanded"
      );
    }
  }
  // unlike columns, this will only get called once, as we don't react on props on column groups
  // (we will always destroy and recreate this comp if something changes)
  setDragSource(eHeaderGroup) {
    if (!this.isAlive() || this.isSuppressMoving()) {
      return;
    }
    this.removeDragSource();
    if (!eHeaderGroup) {
      return;
    }
    this.dragSource = this.beans.colMoves?.setDragSourceForHeader(eHeaderGroup, this.column, this.displayName) ?? null;
  }
  isSuppressMoving() {
    return this.gos.get("suppressMovableColumns") || this.column.getLeafColumns().some((column) => column.getColDef().suppressMovable || column.getColDef().lockPosition);
  }
  destroy() {
    this.tooltipFeature = this.destroyBean(this.tooltipFeature);
    super.destroy();
  }
};

// packages/ag-grid-community/src/columns/columnGroups/columnGroupApi.ts
function setColumnGroupOpened(beans, group, newValue) {
  beans.colGroupSvc?.setColumnGroupOpened(group, newValue, "api");
}
function getColumnGroup(beans, name, instanceId) {
  return beans.colGroupSvc?.getColumnGroup(name, instanceId) ?? null;
}
function getProvidedColumnGroup(beans, name) {
  return beans.colGroupSvc?.getProvidedColGroup(name) ?? null;
}
function getDisplayNameForColumnGroup(beans, columnGroup, location) {
  return beans.colNames.getDisplayNameForColumnGroup(columnGroup, location) || "";
}
function getColumnGroupState(beans) {
  return beans.colGroupSvc?.getColumnGroupState() ?? [];
}
function setColumnGroupState(beans, stateItems) {
  beans.colGroupSvc?.setColumnGroupState(stateItems, "api");
}
function resetColumnGroupState(beans) {
  beans.colGroupSvc?.resetColumnGroupState("api");
}
function getLeftDisplayedColumnGroups(beans) {
  return beans.visibleCols.treeLeft;
}
function getCenterDisplayedColumnGroups(beans) {
  return beans.visibleCols.treeCenter;
}
function getRightDisplayedColumnGroups(beans) {
  return beans.visibleCols.treeRight;
}
function getAllDisplayedColumnGroups(beans) {
  return beans.visibleCols.getAllTrees();
}

// packages/ag-grid-community/src/columns/visibleColsService.ts
function _removeAllFromUnorderedArray(array, toRemove) {
  for (let i = 0; i < toRemove.length; i++) {
    const index = array.indexOf(toRemove[i]);
    if (index >= 0) {
      array[index] = array[array.length - 1];
      array.pop();
    }
  }
}
var VisibleColsService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "visibleCols";
    // for fast lookup, to see if a column or group is still visible
    this.colsAndGroupsMap = {};
    // leave level columns of the displayed trees
    this.leftCols = [];
    this.rightCols = [];
    this.centerCols = [];
    // all three lists above combined
    this.allCols = [];
    this.headerGroupRowCount = 0;
    // used by:
    // + angularGrid -> for setting body width
    // + rowController -> setting main row widths (when inserting and resizing)
    // need to cache this
    this.bodyWidth = 0;
    this.leftWidth = 0;
    this.rightWidth = 0;
    this.isBodyWidthDirty = true;
  }
  refresh(source, skipTreeBuild = false) {
    const { colFlex, colModel, colGroupSvc, colViewport, selectionColSvc } = this.beans;
    if (!skipTreeBuild) {
      this.buildTrees(colModel, colGroupSvc);
    }
    colGroupSvc?.updateOpenClosedVisibility();
    this.leftCols = pickDisplayedCols(this.treeLeft);
    this.centerCols = pickDisplayedCols(this.treeCenter);
    this.rightCols = pickDisplayedCols(this.treeRight);
    selectionColSvc?.refreshVisibility(this.leftCols, this.centerCols, this.rightCols);
    this.joinColsAriaOrder(colModel);
    this.joinCols();
    this.headerGroupRowCount = this.getHeaderRowCount();
    this.setLeftValues(source);
    this.autoHeightCols = this.allCols.filter((col) => col.isAutoHeight());
    colFlex?.refreshFlexedColumns();
    this.updateBodyWidths();
    this.setFirstRightAndLastLeftPinned(colModel, this.leftCols, this.rightCols, source);
    colViewport.checkViewportColumns(false);
    this.eventSvc.dispatchEvent({
      type: "displayedColumnsChanged",
      source
    });
  }
  getHeaderRowCount() {
    if (!this.gos.get("hidePaddedHeaderRows")) {
      return this.beans.colModel.cols.treeDepth;
    }
    let headerGroupRowCount = 0;
    for (const col of this.allCols) {
      let parent = col.getParent();
      while (parent) {
        if (!parent.isPadding()) {
          const level = parent.getProvidedColumnGroup().getLevel() + 1;
          if (level > headerGroupRowCount) {
            headerGroupRowCount = level;
          }
          break;
        }
        parent = parent.getParent();
      }
    }
    return headerGroupRowCount;
  }
  // after setColumnWidth or updateGroupsAndPresentedCols
  updateBodyWidths() {
    const newBodyWidth = getWidthOfColsInList(this.centerCols);
    const newLeftWidth = getWidthOfColsInList(this.leftCols);
    const newRightWidth = getWidthOfColsInList(this.rightCols);
    this.isBodyWidthDirty = this.bodyWidth !== newBodyWidth;
    const atLeastOneChanged = this.bodyWidth !== newBodyWidth || this.leftWidth !== newLeftWidth || this.rightWidth !== newRightWidth;
    if (atLeastOneChanged) {
      this.bodyWidth = newBodyWidth;
      this.leftWidth = newLeftWidth;
      this.rightWidth = newRightWidth;
      this.eventSvc.dispatchEvent({
        type: "columnContainerWidthChanged"
      });
      this.eventSvc.dispatchEvent({
        type: "displayedColumnsWidthChanged"
      });
    }
  }
  // sets the left pixel position of each column
  setLeftValues(source) {
    this.setLeftValuesOfCols(source);
    this.setLeftValuesOfGroups();
  }
  setFirstRightAndLastLeftPinned(colModel, leftCols, rightCols, source) {
    let lastLeft;
    let firstRight;
    if (this.gos.get("enableRtl")) {
      lastLeft = leftCols ? leftCols[0] : null;
      firstRight = rightCols ? _last(rightCols) : null;
    } else {
      lastLeft = leftCols ? _last(leftCols) : null;
      firstRight = rightCols ? rightCols[0] : null;
    }
    colModel.getCols().forEach((col) => {
      col.setLastLeftPinned(col === lastLeft, source);
      col.setFirstRightPinned(col === firstRight, source);
    });
  }
  buildTrees(colModel, columnGroupSvc) {
    const cols = colModel.getColsToShow();
    const leftCols = cols.filter((col) => col.getPinned() == "left");
    const rightCols = cols.filter((col) => col.getPinned() == "right");
    const centerCols = cols.filter((col) => col.getPinned() != "left" && col.getPinned() != "right");
    const idCreator = new GroupInstanceIdCreator();
    const createGroups = (params) => {
      return columnGroupSvc ? columnGroupSvc.createColumnGroups(params) : params.columns;
    };
    this.treeLeft = createGroups({
      columns: leftCols,
      idCreator,
      pinned: "left",
      oldDisplayedGroups: this.treeLeft
    });
    this.treeRight = createGroups({
      columns: rightCols,
      idCreator,
      pinned: "right",
      oldDisplayedGroups: this.treeRight
    });
    this.treeCenter = createGroups({
      columns: centerCols,
      idCreator,
      pinned: null,
      oldDisplayedGroups: this.treeCenter
    });
    this.updateColsAndGroupsMap();
  }
  clear() {
    this.leftCols = [];
    this.rightCols = [];
    this.centerCols = [];
    this.allCols = [];
    this.ariaOrderColumns = [];
  }
  joinColsAriaOrder(colModel) {
    const allColumns = colModel.getCols();
    const pinnedLeft = [];
    const center = [];
    const pinnedRight = [];
    for (const col of allColumns) {
      const pinned = col.getPinned();
      if (!pinned) {
        center.push(col);
      } else if (pinned === true || pinned === "left") {
        pinnedLeft.push(col);
      } else {
        pinnedRight.push(col);
      }
    }
    this.ariaOrderColumns = pinnedLeft.concat(center).concat(pinnedRight);
  }
  getAriaColIndex(colOrGroup) {
    let col;
    if (isColumnGroup(colOrGroup)) {
      col = colOrGroup.getLeafColumns()[0];
    } else {
      col = colOrGroup;
    }
    return this.ariaOrderColumns.indexOf(col) + 1;
  }
  setLeftValuesOfGroups() {
    [this.treeLeft, this.treeRight, this.treeCenter].forEach((columns) => {
      columns.forEach((column) => {
        if (isColumnGroup(column)) {
          const columnGroup = column;
          columnGroup.checkLeft();
        }
      });
    });
  }
  setLeftValuesOfCols(source) {
    const { colModel } = this.beans;
    const primaryCols = colModel.getColDefCols();
    if (!primaryCols) {
      return;
    }
    const allColumns = colModel.getCols().slice(0);
    const doingRtl = this.gos.get("enableRtl");
    [this.leftCols, this.rightCols, this.centerCols].forEach((columns) => {
      if (doingRtl) {
        let left = getWidthOfColsInList(columns);
        columns.forEach((column) => {
          left -= column.getActualWidth();
          column.setLeft(left, source);
        });
      } else {
        let left = 0;
        columns.forEach((column) => {
          column.setLeft(left, source);
          left += column.getActualWidth();
        });
      }
      _removeAllFromUnorderedArray(allColumns, columns);
    });
    allColumns.forEach((column) => {
      column.setLeft(null, source);
    });
  }
  joinCols() {
    if (this.gos.get("enableRtl")) {
      this.allCols = this.rightCols.concat(this.centerCols).concat(this.leftCols);
    } else {
      this.allCols = this.leftCols.concat(this.centerCols).concat(this.rightCols);
    }
  }
  getAllTrees() {
    if (this.treeLeft && this.treeRight && this.treeCenter) {
      return this.treeLeft.concat(this.treeCenter).concat(this.treeRight);
    }
    return null;
  }
  // gridPanel -> ensureColumnVisible
  isColDisplayed(column) {
    return this.allCols.indexOf(column) >= 0;
  }
  getLeftColsForRow(rowNode) {
    const {
      leftCols,
      beans: { colModel }
    } = this;
    const colSpanActive = colModel.colSpanActive;
    if (!colSpanActive) {
      return leftCols;
    }
    return this.getColsForRow(rowNode, leftCols);
  }
  getRightColsForRow(rowNode) {
    const {
      rightCols,
      beans: { colModel }
    } = this;
    const colSpanActive = colModel.colSpanActive;
    if (!colSpanActive) {
      return rightCols;
    }
    return this.getColsForRow(rowNode, rightCols);
  }
  getColsForRow(rowNode, displayedColumns, filterCallback, emptySpaceBeforeColumn) {
    const result = [];
    let lastConsideredCol = null;
    for (let i = 0; i < displayedColumns.length; i++) {
      const col = displayedColumns[i];
      const maxAllowedColSpan = displayedColumns.length - i;
      const colSpan = Math.min(col.getColSpan(rowNode), maxAllowedColSpan);
      const columnsToCheckFilter = [col];
      if (colSpan > 1) {
        const colsToRemove = colSpan - 1;
        for (let j = 1; j <= colsToRemove; j++) {
          columnsToCheckFilter.push(displayedColumns[i + j]);
        }
        i += colsToRemove;
      }
      let filterPasses;
      if (filterCallback) {
        filterPasses = false;
        columnsToCheckFilter.forEach((colForFilter) => {
          if (filterCallback(colForFilter)) {
            filterPasses = true;
          }
        });
      } else {
        filterPasses = true;
      }
      if (filterPasses) {
        if (result.length === 0 && lastConsideredCol) {
          const gapBeforeColumn = emptySpaceBeforeColumn ? emptySpaceBeforeColumn(col) : false;
          if (gapBeforeColumn) {
            result.push(lastConsideredCol);
          }
        }
        result.push(col);
      }
      lastConsideredCol = col;
    }
    return result;
  }
  getContainerWidth(pinned) {
    switch (pinned) {
      case "left":
        return this.leftWidth;
      case "right":
        return this.rightWidth;
      default:
        return this.bodyWidth;
    }
  }
  getColBefore(col) {
    const allDisplayedColumns = this.allCols;
    const oldIndex = allDisplayedColumns.indexOf(col);
    if (oldIndex > 0) {
      return allDisplayedColumns[oldIndex - 1];
    }
    return null;
  }
  isPinningLeft() {
    return this.leftCols.length > 0;
  }
  isPinningRight() {
    return this.rightCols.length > 0;
  }
  updateColsAndGroupsMap() {
    this.colsAndGroupsMap = {};
    const func = (child) => {
      this.colsAndGroupsMap[child.getUniqueId()] = child;
    };
    depthFirstAllColumnTreeSearch(this.treeCenter, false, func);
    depthFirstAllColumnTreeSearch(this.treeLeft, false, func);
    depthFirstAllColumnTreeSearch(this.treeRight, false, func);
  }
  isVisible(item) {
    const fromMap = this.colsAndGroupsMap[item.getUniqueId()];
    return fromMap === item;
  }
  getFirstColumn() {
    const isRtl = this.gos.get("enableRtl");
    const queryOrder = ["leftCols", "centerCols", "rightCols"];
    if (isRtl) {
      queryOrder.reverse();
    }
    for (let i = 0; i < queryOrder.length; i++) {
      const container = this[queryOrder[i]];
      if (container.length) {
        return isRtl ? _last(container) : container[0];
      }
    }
    return null;
  }
  // used by:
  // + rowRenderer -> for navigation
  getColAfter(col) {
    const allDisplayedColumns = this.allCols;
    const oldIndex = allDisplayedColumns.indexOf(col);
    if (oldIndex < allDisplayedColumns.length - 1) {
      return allDisplayedColumns[oldIndex + 1];
    }
    return null;
  }
  // used by:
  // + angularGrid -> setting pinned body width
  // note: this should be cached
  getColsLeftWidth() {
    return getWidthOfColsInList(this.leftCols);
  }
  // note: this should be cached
  getDisplayedColumnsRightWidth() {
    return getWidthOfColsInList(this.rightCols);
  }
  isColAtEdge(col, edge) {
    const allColumns = this.allCols;
    if (!allColumns.length) {
      return false;
    }
    const isFirst = edge === "first";
    let columnToCompare;
    if (isColumnGroup(col)) {
      const leafColumns = col.getDisplayedLeafColumns();
      if (!leafColumns.length) {
        return false;
      }
      columnToCompare = isFirst ? leafColumns[0] : _last(leafColumns);
    } else {
      columnToCompare = col;
    }
    return (isFirst ? allColumns[0] : _last(allColumns)) === columnToCompare;
  }
};
function depthFirstAllColumnTreeSearch(tree, useDisplayedChildren, callback) {
  if (!tree) {
    return;
  }
  for (let i = 0; i < tree.length; i++) {
    const child = tree[i];
    if (isColumnGroup(child)) {
      const childTree = useDisplayedChildren ? child.getDisplayedChildren() : child.getChildren();
      depthFirstAllColumnTreeSearch(childTree, useDisplayedChildren, callback);
    }
    callback(child);
  }
}
function pickDisplayedCols(tree) {
  const res = [];
  depthFirstAllColumnTreeSearch(tree, true, (child) => {
    if (isColumn(child)) {
      res.push(child);
    }
  });
  return res;
}

// packages/ag-grid-community/src/columns/columnGroups/columnGroupService.ts
var ColumnGroupService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colGroupSvc";
  }
  getColumnGroupState() {
    const columnGroupState = [];
    const gridBalancedTree = this.beans.colModel.getColTree();
    depthFirstOriginalTreeSearch(null, gridBalancedTree, (node) => {
      if (isProvidedColumnGroup(node)) {
        columnGroupState.push({
          groupId: node.getGroupId(),
          open: node.isExpanded()
        });
      }
    });
    return columnGroupState;
  }
  resetColumnGroupState(source) {
    const primaryColumnTree = this.beans.colModel.getColDefColTree();
    if (!primaryColumnTree) {
      return;
    }
    const stateItems = [];
    depthFirstOriginalTreeSearch(null, primaryColumnTree, (child) => {
      if (isProvidedColumnGroup(child)) {
        const colGroupDef = child.getColGroupDef();
        const groupState = {
          groupId: child.getGroupId(),
          open: !colGroupDef ? void 0 : colGroupDef.openByDefault
        };
        stateItems.push(groupState);
      }
    });
    this.setColumnGroupState(stateItems, source);
  }
  setColumnGroupState(stateItems, source) {
    const { colModel, colAnimation, visibleCols, eventSvc } = this.beans;
    const gridBalancedTree = colModel.getColTree();
    if (!gridBalancedTree.length) {
      return;
    }
    colAnimation?.start();
    const impactedGroups = [];
    stateItems.forEach((stateItem) => {
      const groupKey = stateItem.groupId;
      const newValue = stateItem.open;
      const providedColumnGroup = this.getProvidedColGroup(groupKey);
      if (!providedColumnGroup) {
        return;
      }
      if (providedColumnGroup.isExpanded() === newValue) {
        return;
      }
      providedColumnGroup.setExpanded(newValue);
      impactedGroups.push(providedColumnGroup);
    });
    visibleCols.refresh(source, true);
    if (impactedGroups.length) {
      eventSvc.dispatchEvent({
        type: "columnGroupOpened",
        columnGroup: impactedGroups.length === 1 ? impactedGroups[0] : void 0,
        columnGroups: impactedGroups
      });
    }
    colAnimation?.finish();
  }
  // called by headerRenderer - when a header is opened or closed
  setColumnGroupOpened(key, newValue, source) {
    let keyAsString;
    if (isProvidedColumnGroup(key)) {
      keyAsString = key.getId();
    } else {
      keyAsString = key || "";
    }
    this.setColumnGroupState([{ groupId: keyAsString, open: newValue }], source);
  }
  getProvidedColGroup(key) {
    let res = null;
    depthFirstOriginalTreeSearch(null, this.beans.colModel.getColTree(), (node) => {
      if (isProvidedColumnGroup(node)) {
        if (node.getId() === key) {
          res = node;
        }
      }
    });
    return res;
  }
  getGroupAtDirection(columnGroup, direction) {
    const requiredLevel = columnGroup.getProvidedColumnGroup().getLevel() + columnGroup.getPaddingLevel();
    const colGroupLeafColumns = columnGroup.getDisplayedLeafColumns();
    const col = direction === "After" ? _last(colGroupLeafColumns) : colGroupLeafColumns[0];
    const getDisplayColMethod = `getCol${direction}`;
    while (true) {
      const column = this.beans.visibleCols[getDisplayColMethod](col);
      if (!column) {
        return null;
      }
      const groupPointer = this.getColGroupAtLevel(column, requiredLevel);
      if (groupPointer !== columnGroup) {
        return groupPointer;
      }
    }
  }
  getColGroupAtLevel(column, level) {
    let groupPointer = column.getParent();
    let originalGroupLevel;
    let groupPointerLevel;
    while (true) {
      const groupPointerProvidedColumnGroup = groupPointer.getProvidedColumnGroup();
      originalGroupLevel = groupPointerProvidedColumnGroup.getLevel();
      groupPointerLevel = groupPointer.getPaddingLevel();
      if (originalGroupLevel + groupPointerLevel <= level) {
        break;
      }
      groupPointer = groupPointer.getParent();
    }
    return groupPointer;
  }
  updateOpenClosedVisibility() {
    const allColumnGroups = this.beans.visibleCols.getAllTrees();
    depthFirstAllColumnTreeSearch(allColumnGroups, false, (child) => {
      if (isColumnGroup(child)) {
        child.calculateDisplayedColumns();
      }
    });
  }
  // returns the group with matching colId and instanceId. If instanceId is missing,
  // matches only on the colId.
  getColumnGroup(colId, partId) {
    if (!colId) {
      return null;
    }
    if (isColumnGroup(colId)) {
      return colId;
    }
    const allColumnGroups = this.beans.visibleCols.getAllTrees();
    const checkPartId = typeof partId === "number";
    let result = null;
    depthFirstAllColumnTreeSearch(allColumnGroups, false, (child) => {
      if (isColumnGroup(child)) {
        const columnGroup = child;
        let matched;
        if (checkPartId) {
          matched = colId === columnGroup.getGroupId() && partId === columnGroup.getPartId();
        } else {
          matched = colId === columnGroup.getGroupId();
        }
        if (matched) {
          result = columnGroup;
        }
      }
    });
    return result;
  }
  createColumnGroups(params) {
    const { columns, idCreator, pinned, oldDisplayedGroups, isStandaloneStructure } = params;
    const oldColumnsMapped = this.mapOldGroupsById(oldDisplayedGroups);
    const topLevelResultCols = [];
    let groupsOrColsAtCurrentLevel = columns;
    while (groupsOrColsAtCurrentLevel.length) {
      const currentlyIterating = groupsOrColsAtCurrentLevel;
      groupsOrColsAtCurrentLevel = [];
      let lastGroupedColIdx = 0;
      const createGroupToIndex = (to) => {
        const from = lastGroupedColIdx;
        lastGroupedColIdx = to;
        const previousNode = currentlyIterating[from];
        const previousNodeProvided = isColumnGroup(previousNode) ? previousNode.getProvidedColumnGroup() : previousNode;
        const previousNodeParent = previousNodeProvided.getOriginalParent();
        if (previousNodeParent == null) {
          for (let i = from; i < to; i++) {
            topLevelResultCols.push(currentlyIterating[i]);
          }
          return;
        }
        const newGroup = this.createColumnGroup(
          previousNodeParent,
          idCreator,
          oldColumnsMapped,
          pinned,
          isStandaloneStructure
        );
        for (let i = from; i < to; i++) {
          newGroup.addChild(currentlyIterating[i]);
        }
        groupsOrColsAtCurrentLevel.push(newGroup);
      };
      for (let i = 1; i < currentlyIterating.length; i++) {
        const thisNode = currentlyIterating[i];
        const thisNodeProvided = isColumnGroup(thisNode) ? thisNode.getProvidedColumnGroup() : thisNode;
        const thisNodeParent = thisNodeProvided.getOriginalParent();
        const previousNode = currentlyIterating[lastGroupedColIdx];
        const previousNodeProvided = isColumnGroup(previousNode) ? previousNode.getProvidedColumnGroup() : previousNode;
        const previousNodeParent = previousNodeProvided.getOriginalParent();
        if (thisNodeParent !== previousNodeParent) {
          createGroupToIndex(i);
        }
      }
      if (lastGroupedColIdx < currentlyIterating.length) {
        createGroupToIndex(currentlyIterating.length);
      }
    }
    if (!isStandaloneStructure) {
      this.setupParentsIntoCols(topLevelResultCols, null);
    }
    return topLevelResultCols;
  }
  createProvidedColumnGroup(primaryColumns, colGroupDef, level, existingColumns, columnKeyCreator, existingGroups, source) {
    const groupId = columnKeyCreator.getUniqueKey(colGroupDef.groupId || null, null);
    const colGroupDefMerged = createMergedColGroupDef(this.beans, colGroupDef, groupId);
    const providedGroup = new AgProvidedColumnGroup(colGroupDefMerged, groupId, false, level);
    this.createBean(providedGroup);
    const existingGroupAndIndex = this.findExistingGroup(colGroupDef, existingGroups);
    if (existingGroupAndIndex) {
      existingGroups.splice(existingGroupAndIndex.idx, 1);
    }
    const existingGroup = existingGroupAndIndex?.group;
    if (existingGroup) {
      providedGroup.setExpanded(existingGroup.isExpanded());
    }
    const children = _recursivelyCreateColumns(
      this.beans,
      colGroupDefMerged.children,
      level + 1,
      primaryColumns,
      existingColumns,
      columnKeyCreator,
      existingGroups,
      source
    );
    providedGroup.setChildren(children);
    return providedGroup;
  }
  balanceColumnTree(unbalancedTree, currentDepth, columnDepth, columnKeyCreator) {
    const result = [];
    for (let i = 0; i < unbalancedTree.length; i++) {
      const child = unbalancedTree[i];
      if (isProvidedColumnGroup(child)) {
        const originalGroup = child;
        const newChildren = this.balanceColumnTree(
          originalGroup.getChildren(),
          currentDepth + 1,
          columnDepth,
          columnKeyCreator
        );
        originalGroup.setChildren(newChildren);
        result.push(originalGroup);
      } else {
        let firstPaddedGroup;
        let currentPaddedGroup;
        for (let j = currentDepth; j < columnDepth; j++) {
          const newColId = columnKeyCreator.getUniqueKey(null, null);
          const colGroupDefMerged = createMergedColGroupDef(this.beans, null, newColId);
          const paddedGroup = new AgProvidedColumnGroup(colGroupDefMerged, newColId, true, j);
          this.createBean(paddedGroup);
          if (currentPaddedGroup) {
            currentPaddedGroup.setChildren([paddedGroup]);
          }
          currentPaddedGroup = paddedGroup;
          if (!firstPaddedGroup) {
            firstPaddedGroup = currentPaddedGroup;
          }
        }
        if (firstPaddedGroup && currentPaddedGroup) {
          result.push(firstPaddedGroup);
          const hasGroups = unbalancedTree.some((leaf) => isProvidedColumnGroup(leaf));
          if (hasGroups) {
            currentPaddedGroup.setChildren([child]);
            continue;
          } else {
            currentPaddedGroup.setChildren(unbalancedTree);
            break;
          }
        }
        result.push(child);
      }
    }
    return result;
  }
  findDepth(balancedColumnTree) {
    let depth = 0;
    let pointer = balancedColumnTree;
    while (pointer && pointer[0] && isProvidedColumnGroup(pointer[0])) {
      depth++;
      pointer = pointer[0].getChildren();
    }
    return depth;
  }
  findMaxDepth(treeChildren, depth) {
    let maxDepthThisLevel = depth;
    for (let i = 0; i < treeChildren.length; i++) {
      const abstractColumn = treeChildren[i];
      if (isProvidedColumnGroup(abstractColumn)) {
        const originalGroup = abstractColumn;
        const newDepth = this.findMaxDepth(originalGroup.getChildren(), depth + 1);
        if (maxDepthThisLevel < newDepth) {
          maxDepthThisLevel = newDepth;
        }
      }
    }
    return maxDepthThisLevel;
  }
  /**
   * Inserts dummy group columns in the hierarchy above auto-generated columns
   * in order to ensure auto-generated columns are leaf nodes (and therefore are
   * displayed correctly)
   */
  balanceTreeForAutoCols(autoCols, depth) {
    const tree = [];
    autoCols.forEach((col) => {
      let nextChild = col;
      for (let i = depth - 1; i >= 0; i--) {
        const autoGroup = new AgProvidedColumnGroup(null, `FAKE_PATH_${col.getId()}}_${i}`, true, i);
        this.createBean(autoGroup);
        autoGroup.setChildren([nextChild]);
        nextChild.originalParent = autoGroup;
        nextChild = autoGroup;
      }
      if (depth === 0) {
        col.originalParent = null;
      }
      tree.push(nextChild);
    });
    return tree;
  }
  findExistingGroup(newGroupDef, existingGroups) {
    const newHasId = newGroupDef.groupId != null;
    if (!newHasId) {
      return void 0;
    }
    for (let i = 0; i < existingGroups.length; i++) {
      const existingGroup = existingGroups[i];
      const existingDef = existingGroup.getColGroupDef();
      if (!existingDef) {
        continue;
      }
      if (existingGroup.getId() === newGroupDef.groupId) {
        return { idx: i, group: existingGroup };
      }
    }
    return void 0;
  }
  createColumnGroup(providedGroup, groupInstanceIdCreator, oldColumnsMapped, pinned, isStandaloneStructure) {
    const groupId = providedGroup.getGroupId();
    const instanceId = groupInstanceIdCreator.getInstanceIdForKey(groupId);
    const uniqueId = createUniqueColumnGroupId(groupId, instanceId);
    let columnGroup = oldColumnsMapped[uniqueId];
    if (columnGroup && columnGroup.getProvidedColumnGroup() !== providedGroup) {
      columnGroup = null;
    }
    if (_exists(columnGroup)) {
      columnGroup.reset();
    } else {
      columnGroup = new AgColumnGroup(providedGroup, groupId, instanceId, pinned);
      if (!isStandaloneStructure) {
        this.createBean(columnGroup);
      }
    }
    return columnGroup;
  }
  // returns back a 2d map of ColumnGroup as follows: groupId -> instanceId -> ColumnGroup
  mapOldGroupsById(displayedGroups) {
    const result = {};
    const recursive = (columnsOrGroups) => {
      columnsOrGroups.forEach((columnOrGroup) => {
        if (isColumnGroup(columnOrGroup)) {
          const columnGroup = columnOrGroup;
          result[columnOrGroup.getUniqueId()] = columnGroup;
          recursive(columnGroup.getChildren());
        }
      });
    };
    if (displayedGroups) {
      recursive(displayedGroups);
    }
    return result;
  }
  setupParentsIntoCols(columnsOrGroups, parent) {
    columnsOrGroups.forEach((columnsOrGroup) => {
      if (columnsOrGroup.parent !== parent) {
        this.beans.colViewport.colsWithinViewportHash = "";
      }
      columnsOrGroup.parent = parent;
      if (isColumnGroup(columnsOrGroup)) {
        const columnGroup = columnsOrGroup;
        this.setupParentsIntoCols(columnGroup.getChildren(), columnGroup);
      }
    });
  }
};

// packages/ag-grid-community/src/columns/columnGroups/columnGroupModule.ts
var ColumnGroupModule = {
  moduleName: "ColumnGroup",
  version: VERSION,
  dynamicBeans: { headerGroupCellCtrl: HeaderGroupCellCtrl },
  beans: [ColumnGroupService],
  apiFunctions: {
    getAllDisplayedColumnGroups,
    getCenterDisplayedColumnGroups,
    getColumnGroup,
    getColumnGroupState,
    getDisplayNameForColumnGroup,
    getLeftDisplayedColumnGroups,
    getProvidedColumnGroup,
    getRightDisplayedColumnGroups,
    resetColumnGroupState,
    setColumnGroupOpened,
    setColumnGroupState
  }
};

// packages/ag-grid-community/src/rendering/cellRenderers/skeletonCellRenderer.ts
var SkeletonCellRendererElement = { tag: "div", cls: "ag-skeleton-container" };
var SkeletonCellRenderer = class extends Component {
  constructor() {
    super(SkeletonCellRendererElement);
  }
  init(params) {
    const id = `ag-cell-skeleton-renderer-${this.getCompId()}`;
    this.getGui().setAttribute("id", id);
    this.addDestroyFunc(() => _setAriaLabelledBy(params.eParentOfValue));
    _setAriaLabelledBy(params.eParentOfValue, id);
    if (params.deferRender) {
      this.setupLoading(params);
    } else {
      params.node.failedLoad ? this.setupFailed() : this.setupLoading(params);
    }
  }
  setupFailed() {
    const localeTextFunc = this.getLocaleTextFunc();
    this.getGui().textContent = localeTextFunc("loadingError", "ERR");
    const ariaFailed = localeTextFunc("ariaSkeletonCellLoadingFailed", "Row failed to load");
    _setAriaLabel(this.getGui(), ariaFailed);
  }
  setupLoading(params) {
    const skeletonEffect = _createElement({
      tag: "div",
      cls: "ag-skeleton-effect"
    });
    const rowIndex = params.node.rowIndex;
    if (rowIndex != null) {
      const width = 75 + 25 * (rowIndex % 2 === 0 ? Math.sin(rowIndex) : Math.cos(rowIndex));
      skeletonEffect.style.width = `${width}%`;
    }
    this.getGui().appendChild(skeletonEffect);
    const localeTextFunc = this.getLocaleTextFunc();
    const ariaLoading = params.deferRender ? localeTextFunc("ariaDeferSkeletonCellLoading", "Cell is loading") : localeTextFunc("ariaSkeletonCellLoading", "Row data is loading");
    _setAriaLabel(this.getGui(), ariaLoading);
  }
  refresh(_params) {
    return false;
  }
};

// packages/ag-grid-community/src/rendering/cellRenderers/cellRendererModule.ts
var CheckboxCellRendererModule = {
  moduleName: "CheckboxCellRenderer",
  version: VERSION,
  userComponents: {
    agCheckboxCellRenderer: CheckboxCellRenderer
  }
};
var SkeletonCellRendererModule = {
  moduleName: "SkeletonCellRenderer",
  version: VERSION,
  userComponents: {
    agSkeletonCellRenderer: SkeletonCellRenderer
  }
};

// packages/ag-grid-community/src/columns/columnApi.ts
function getColumnDef(beans, key) {
  const column = beans.colModel.getColDefCol(key);
  if (column) {
    return column.getColDef();
  }
  return null;
}
function getColumnDefs(beans) {
  return beans.colModel.getColumnDefs();
}
function getDisplayNameForColumn(beans, column, location) {
  return beans.colNames.getDisplayNameForColumn(column, location) || "";
}
function getColumn(beans, key) {
  return beans.colModel.getColDefCol(key);
}
function getColumns(beans) {
  return beans.colModel.getColDefCols();
}
function applyColumnState(beans, params) {
  return _applyColumnState(beans, params, "api");
}
function getColumnState(beans) {
  return _getColumnState(beans);
}
function resetColumnState(beans) {
  _resetColumnState(beans, "api");
}
function isPinning(beans) {
  return beans.visibleCols.isPinningLeft() || beans.visibleCols.isPinningRight();
}
function isPinningLeft(beans) {
  return beans.visibleCols.isPinningLeft();
}
function isPinningRight(beans) {
  return beans.visibleCols.isPinningRight();
}
function getDisplayedColAfter(beans, col) {
  return beans.visibleCols.getColAfter(col);
}
function getDisplayedColBefore(beans, col) {
  return beans.visibleCols.getColBefore(col);
}
function setColumnsVisible(beans, keys, visible) {
  beans.colModel.setColsVisible(keys, visible, "api");
}
function setColumnsPinned(beans, keys, pinned) {
  beans.pinnedCols?.setColsPinned(keys, pinned, "api");
}
function getAllGridColumns(beans) {
  return beans.colModel.getCols();
}
function getDisplayedLeftColumns(beans) {
  return beans.visibleCols.leftCols;
}
function getDisplayedCenterColumns(beans) {
  return beans.visibleCols.centerCols;
}
function getDisplayedRightColumns(beans) {
  return beans.visibleCols.rightCols;
}
function getAllDisplayedColumns(beans) {
  return beans.visibleCols.allCols;
}
function getAllDisplayedVirtualColumns(beans) {
  return beans.colViewport.getViewportColumns();
}

// packages/ag-grid-community/src/columns/columnDefFactory.ts
function _deepCloneDefinition(object, keysToSkip) {
  if (!object) {
    return;
  }
  const obj = object;
  const res = {};
  Object.keys(obj).forEach((key) => {
    if (keysToSkip && keysToSkip.indexOf(key) >= 0 || SKIP_JS_BUILTINS.has(key)) {
      return;
    }
    const value = obj[key];
    const sourceIsSimpleObject = typeof value === "object" && value !== null && value.constructor === Object;
    if (sourceIsSimpleObject) {
      res[key] = _deepCloneDefinition(value);
    } else {
      res[key] = value;
    }
  });
  return res;
}
var ColumnDefFactory = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colDefFactory";
  }
  wireBeans(beans) {
    this.rowGroupColsSvc = beans.rowGroupColsSvc;
    this.pivotColsSvc = beans.pivotColsSvc;
  }
  getColumnDefs(colDefColsList, showingPivotResult, lastOrder, colsList) {
    const cols = colDefColsList.slice();
    if (showingPivotResult) {
      cols.sort((a, b) => lastOrder.indexOf(a) - lastOrder.indexOf(b));
    } else if (lastOrder) {
      cols.sort((a, b) => colsList.indexOf(a) - colsList.indexOf(b));
    }
    const rowGroupColumns = this.rowGroupColsSvc?.columns;
    const pivotColumns = this.pivotColsSvc?.columns;
    return this.buildColumnDefs(cols, rowGroupColumns, pivotColumns);
  }
  buildColumnDefs(cols, rowGroupColumns = [], pivotColumns = []) {
    const res = [];
    const colGroupDefs = {};
    cols.forEach((col) => {
      const colDef = this.createDefFromColumn(col, rowGroupColumns, pivotColumns);
      let addToResult = true;
      let childDef = colDef;
      let pointer = col.getOriginalParent();
      let lastPointer = null;
      while (pointer) {
        let parentDef = null;
        if (pointer.isPadding()) {
          pointer = pointer.getOriginalParent();
          continue;
        }
        const existingParentDef = colGroupDefs[pointer.getGroupId()];
        if (existingParentDef) {
          existingParentDef.children.push(childDef);
          addToResult = false;
          break;
        }
        parentDef = this.createDefFromGroup(pointer);
        if (parentDef) {
          parentDef.children = [childDef];
          colGroupDefs[parentDef.groupId] = parentDef;
          childDef = parentDef;
          pointer = pointer.getOriginalParent();
        }
        if (pointer != null && lastPointer === pointer) {
          addToResult = false;
          break;
        }
        lastPointer = pointer;
      }
      if (addToResult) {
        res.push(childDef);
      }
    });
    return res;
  }
  createDefFromGroup(group) {
    const defCloned = _deepCloneDefinition(group.getColGroupDef(), ["children"]);
    if (defCloned) {
      defCloned.groupId = group.getGroupId();
    }
    return defCloned;
  }
  createDefFromColumn(col, rowGroupColumns, pivotColumns) {
    const colDefCloned = _deepCloneDefinition(col.getColDef());
    colDefCloned.colId = col.getColId();
    colDefCloned.width = col.getActualWidth();
    colDefCloned.rowGroup = col.isRowGroupActive();
    colDefCloned.rowGroupIndex = col.isRowGroupActive() ? rowGroupColumns.indexOf(col) : null;
    colDefCloned.pivot = col.isPivotActive();
    colDefCloned.pivotIndex = col.isPivotActive() ? pivotColumns.indexOf(col) : null;
    colDefCloned.aggFunc = col.isValueActive() ? col.getAggFunc() : null;
    colDefCloned.hide = col.isVisible() ? void 0 : true;
    colDefCloned.pinned = col.isPinned() ? col.getPinned() : null;
    colDefCloned.sort = col.getSort() ? col.getSort() : null;
    colDefCloned.sortIndex = col.getSortIndex() != null ? col.getSortIndex() : null;
    return colDefCloned;
  }
};

// packages/ag-grid-community/src/columns/columnFlexService.ts
var ColumnFlexService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colFlex";
  }
  refreshFlexedColumns(params = {}) {
    const source = params.source ?? "flex";
    if (params.viewportWidth != null) {
      this.flexViewportWidth = params.viewportWidth;
    }
    const totalSpace = this.flexViewportWidth;
    if (!totalSpace) {
      return [];
    }
    const { visibleCols } = this.beans;
    const visibleCenterCols = visibleCols.centerCols;
    let flexAfterDisplayIndex = -1;
    if (params.resizingCols) {
      const allResizingCols = new Set(params.resizingCols);
      for (let i = visibleCenterCols.length - 1; i >= 0; i--) {
        if (allResizingCols.has(visibleCenterCols[i])) {
          flexAfterDisplayIndex = i;
          break;
        }
      }
    }
    let hasFlexItems = false;
    const items = visibleCenterCols.map((col, i) => {
      const flex = col.getFlex();
      const isFlex = flex != null && flex > 0 && i > flexAfterDisplayIndex;
      hasFlexItems || (hasFlexItems = isFlex);
      return {
        col,
        isFlex,
        flex: Math.max(0, flex ?? 0),
        initialSize: col.getActualWidth(),
        min: col.getMinWidth(),
        max: col.getMaxWidth(),
        targetSize: 0
      };
    });
    if (!hasFlexItems) {
      return [];
    }
    let unfrozenItemCount = items.length;
    let unfrozenFlex = items.reduce((acc, item) => acc + item.flex, 0);
    let unfrozenSpace = totalSpace;
    const freeze = (item, width) => {
      item.frozenSize = width;
      item.col.setActualWidth(width, source);
      unfrozenSpace -= width;
      unfrozenFlex -= item.flex;
      unfrozenItemCount -= 1;
    };
    const isFrozen = (item) => item.frozenSize != null;
    for (const item of items) {
      if (!item.isFlex) {
        freeze(item, item.initialSize);
      }
    }
    while (unfrozenItemCount > 0) {
      const spaceToFill = Math.round(unfrozenFlex < 1 ? unfrozenSpace * unfrozenFlex : unfrozenSpace);
      let lastUnfrozenItem;
      let actualLeft = 0;
      let idealRight = 0;
      for (const item of items) {
        if (isFrozen(item)) {
          continue;
        }
        lastUnfrozenItem = item;
        idealRight += spaceToFill * (item.flex / unfrozenFlex);
        const idealSize = idealRight - actualLeft;
        const roundedSize = Math.round(idealSize);
        item.targetSize = roundedSize;
        actualLeft += roundedSize;
      }
      if (lastUnfrozenItem) {
        lastUnfrozenItem.targetSize += spaceToFill - actualLeft;
      }
      let totalViolation = 0;
      for (const item of items) {
        if (isFrozen(item)) {
          continue;
        }
        const unclampedSize = item.targetSize;
        const clampedSize = Math.min(Math.max(unclampedSize, item.min), item.max);
        totalViolation += clampedSize - unclampedSize;
        item.violationType = clampedSize === unclampedSize ? void 0 : clampedSize < unclampedSize ? "max" : "min";
        item.targetSize = clampedSize;
      }
      const freezeType = totalViolation === 0 ? "all" : totalViolation > 0 ? "min" : "max";
      for (const item of items) {
        if (isFrozen(item)) {
          continue;
        }
        if (freezeType === "all" || item.violationType === freezeType) {
          freeze(item, item.targetSize);
        }
      }
    }
    if (!params.skipSetLeft) {
      visibleCols.setLeftValues(source);
    }
    if (params.updateBodyWidths) {
      visibleCols.updateBodyWidths();
    }
    const unconstrainedFlexColumns = items.filter((item) => item.isFlex && !item.violationType).map((item) => item.col);
    if (params.fireResizedEvent) {
      const changedColumns = items.filter((item) => item.initialSize !== item.frozenSize).map((item) => item.col);
      const flexingColumns = items.filter((item) => item.flex).map((item) => item.col);
      dispatchColumnResizedEvent(this.eventSvc, changedColumns, true, source, flexingColumns);
    }
    return unconstrainedFlexColumns;
  }
  initCol(column) {
    const { flex, initialFlex } = column.colDef;
    if (flex !== void 0) {
      column.flex = flex;
    } else if (initialFlex !== void 0) {
      column.flex = initialFlex;
    }
  }
  // this method should only be used by the colModel to
  // change flex when required by the applyColumnState method.
  setColFlex(column, flex) {
    column.flex = flex ?? null;
    column.dispatchStateUpdatedEvent("flex");
  }
};

// packages/ag-grid-community/src/columns/dataTypeService.ts
var SORTED_CELL_DATA_TYPES_FOR_MATCHING = [
  "dateTimeString",
  "dateString",
  "text",
  "number",
  "boolean",
  "date"
];
var DataTypeService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "dataTypeSvc";
    this.dataTypeDefinitions = {};
    this.isPendingInference = false;
    this.isColumnTypeOverrideInDataTypeDefinitions = false;
    // keep track of any column state updates whilst waiting for data types to be inferred
    this.columnStateUpdatesPendingInference = {};
    this.columnStateUpdateListenerDestroyFuncs = [];
    // using an object here to enforce dev to not forget to implement new types as they are added
    this.columnDefinitionPropsPerDataType = {
      number() {
        return { cellEditor: "agNumberCellEditor" };
      },
      boolean() {
        return {
          cellEditor: "agCheckboxCellEditor",
          cellRenderer: "agCheckboxCellRenderer",
          getFindText: () => null,
          suppressKeyboardEvent: (params) => !!params.colDef.editable && params.event.key === KeyCode.SPACE
        };
      },
      date({ formatValue }) {
        return { cellEditor: "agDateCellEditor", keyCreator: formatValue };
      },
      dateString({ formatValue }) {
        return { cellEditor: "agDateStringCellEditor", keyCreator: formatValue };
      },
      dateTime(args) {
        return this.date(args);
      },
      dateTimeString(args) {
        return this.dateString(args);
      },
      object({ formatValue, colModel, colId }) {
        return {
          cellEditorParams: {
            useFormatter: true
          },
          comparator: (a, b) => {
            const column = colModel.getColDefCol(colId);
            const colDef = column?.getColDef();
            if (!column || !colDef) {
              return 0;
            }
            const valA = a == null ? "" : formatValue({ column, node: null, value: a });
            const valB = b == null ? "" : formatValue({ column, node: null, value: b });
            if (valA === valB)
              return 0;
            return valA > valB ? 1 : -1;
          },
          keyCreator: formatValue
        };
      },
      text() {
        return {};
      }
    };
  }
  wireBeans(beans) {
    this.colModel = beans.colModel;
  }
  postConstruct() {
    this.processDataTypeDefinitions();
    this.addManagedPropertyListener("dataTypeDefinitions", (event) => {
      this.processDataTypeDefinitions();
      this.colModel.recreateColumnDefs(event);
    });
  }
  processDataTypeDefinitions() {
    const defaultDataTypes = this.getDefaultDataTypes();
    const newDataTypeDefinitions = {};
    const newFormatValueFuncs = {};
    const generateFormatValueFunc = (dataTypeDefinition) => {
      return (params) => {
        const { column, node, value } = params;
        let valueFormatter = column.getColDef().valueFormatter;
        if (valueFormatter === dataTypeDefinition.groupSafeValueFormatter) {
          valueFormatter = dataTypeDefinition.valueFormatter;
        }
        return this.beans.valueSvc.formatValue(column, node, value, valueFormatter);
      };
    };
    for (const cellDataType of Object.keys(defaultDataTypes)) {
      const defaultDataTypeDef = defaultDataTypes[cellDataType];
      const mergedDataTypeDefinition = {
        ...defaultDataTypeDef,
        groupSafeValueFormatter: createGroupSafeValueFormatter(defaultDataTypeDef, this.gos)
      };
      newDataTypeDefinitions[cellDataType] = mergedDataTypeDefinition;
      newFormatValueFuncs[cellDataType] = generateFormatValueFunc(mergedDataTypeDefinition);
    }
    const userDataTypeDefs = this.gos.get("dataTypeDefinitions") ?? {};
    const newDataTypeMatchers = {};
    for (const cellDataType of Object.keys(userDataTypeDefs)) {
      const userDataTypeDef = userDataTypeDefs[cellDataType];
      const mergedDataTypeDefinition = this.processDataTypeDefinition(
        userDataTypeDef,
        userDataTypeDefs,
        [cellDataType],
        defaultDataTypes
      );
      if (mergedDataTypeDefinition) {
        newDataTypeDefinitions[cellDataType] = mergedDataTypeDefinition;
        if (userDataTypeDef.dataTypeMatcher) {
          newDataTypeMatchers[cellDataType] = userDataTypeDef.dataTypeMatcher;
        }
        newFormatValueFuncs[cellDataType] = generateFormatValueFunc(mergedDataTypeDefinition);
      }
    }
    const { valueParser: defaultValueParser, valueFormatter: defaultValueFormatter } = defaultDataTypes.object;
    const { valueParser: userValueParser, valueFormatter: userValueFormatter } = newDataTypeDefinitions.object;
    this.hasObjectValueParser = userValueParser !== defaultValueParser;
    this.hasObjectValueFormatter = userValueFormatter !== defaultValueFormatter;
    this.formatValueFuncs = newFormatValueFuncs;
    this.dataTypeDefinitions = newDataTypeDefinitions;
    this.dataTypeMatchers = this.sortKeysInMatchers(newDataTypeMatchers, defaultDataTypes);
  }
  /**
   * Sorts the keys in the matchers object.
   * Does not mutate the original object, creates a copy of it with sorted keys instead.
   */
  sortKeysInMatchers(matchers, dataTypes) {
    const sortedMatchers = { ...matchers };
    for (const cellDataType of SORTED_CELL_DATA_TYPES_FOR_MATCHING) {
      delete sortedMatchers[cellDataType];
      sortedMatchers[cellDataType] = matchers[cellDataType] ?? dataTypes[cellDataType].dataTypeMatcher;
    }
    return sortedMatchers;
  }
  processDataTypeDefinition(userDataTypeDef, userDataTypeDefs, alreadyProcessedDataTypes, defaultDataTypes) {
    let mergedDataTypeDefinition;
    const extendsCellDataType = userDataTypeDef.extendsDataType;
    if (userDataTypeDef.columnTypes) {
      this.isColumnTypeOverrideInDataTypeDefinitions = true;
    }
    if (userDataTypeDef.extendsDataType === userDataTypeDef.baseDataType) {
      let baseDataTypeDefinition = defaultDataTypes[extendsCellDataType];
      const overriddenBaseDataTypeDefinition = userDataTypeDefs[extendsCellDataType];
      if (baseDataTypeDefinition && overriddenBaseDataTypeDefinition) {
        baseDataTypeDefinition = overriddenBaseDataTypeDefinition;
      }
      if (!validateDataTypeDefinition(userDataTypeDef, baseDataTypeDefinition, extendsCellDataType)) {
        return void 0;
      }
      mergedDataTypeDefinition = mergeDataTypeDefinitions(baseDataTypeDefinition, userDataTypeDef);
    } else {
      if (alreadyProcessedDataTypes.includes(extendsCellDataType)) {
        _warn(44);
        return void 0;
      }
      const extendedDataTypeDefinition = userDataTypeDefs[extendsCellDataType];
      if (!validateDataTypeDefinition(userDataTypeDef, extendedDataTypeDefinition, extendsCellDataType)) {
        return void 0;
      }
      const mergedExtendedDataTypeDefinition = this.processDataTypeDefinition(
        extendedDataTypeDefinition,
        userDataTypeDefs,
        [...alreadyProcessedDataTypes, extendsCellDataType],
        defaultDataTypes
      );
      if (!mergedExtendedDataTypeDefinition) {
        return void 0;
      }
      mergedDataTypeDefinition = mergeDataTypeDefinitions(mergedExtendedDataTypeDefinition, userDataTypeDef);
    }
    return {
      ...mergedDataTypeDefinition,
      groupSafeValueFormatter: createGroupSafeValueFormatter(mergedDataTypeDefinition, this.gos)
    };
  }
  updateColDefAndGetColumnType(colDef, userColDef, colId) {
    let { cellDataType } = userColDef;
    const { field } = userColDef;
    if (cellDataType === void 0) {
      cellDataType = colDef.cellDataType;
    }
    if (cellDataType == null || cellDataType === true) {
      cellDataType = this.canInferCellDataType(colDef, userColDef) ? this.inferCellDataType(field, colId) : false;
    }
    if (!cellDataType) {
      colDef.cellDataType = false;
      return void 0;
    }
    const dataTypeDefinition = this.dataTypeDefinitions[cellDataType];
    if (!dataTypeDefinition) {
      _warn(47, { cellDataType });
      return void 0;
    }
    colDef.cellDataType = cellDataType;
    if (dataTypeDefinition.groupSafeValueFormatter) {
      colDef.valueFormatter = dataTypeDefinition.groupSafeValueFormatter;
    }
    if (dataTypeDefinition.valueParser) {
      colDef.valueParser = dataTypeDefinition.valueParser;
    }
    if (!dataTypeDefinition.suppressDefaultProperties) {
      this.setColDefPropertiesForBaseDataType(colDef, cellDataType, dataTypeDefinition, colId);
    }
    return dataTypeDefinition.columnTypes;
  }
  addColumnListeners(column) {
    if (!this.isPendingInference) {
      return;
    }
    const columnStateUpdates = this.columnStateUpdatesPendingInference[column.getColId()];
    if (!columnStateUpdates) {
      return;
    }
    const columnListener = (event) => {
      columnStateUpdates.add(event.key);
    };
    column.__addEventListener("columnStateUpdated", columnListener);
    this.columnStateUpdateListenerDestroyFuncs.push(
      () => column.__removeEventListener("columnStateUpdated", columnListener)
    );
  }
  canInferCellDataType(colDef, userColDef) {
    const { gos } = this;
    if (!_isClientSideRowModel(gos)) {
      return false;
    }
    const propsToCheckForInference = { cellRenderer: true, valueGetter: true, valueParser: true, refData: true };
    if (doColDefPropsPreventInference(userColDef, propsToCheckForInference)) {
      return false;
    }
    const columnTypes = userColDef.type === null ? colDef.type : userColDef.type;
    if (columnTypes) {
      const columnTypeDefs = gos.get("columnTypes") ?? {};
      const hasPropsPreventingInference = convertColumnTypes(columnTypes).some((columnType) => {
        const columnTypeDef = columnTypeDefs[columnType.trim()];
        return columnTypeDef && doColDefPropsPreventInference(columnTypeDef, propsToCheckForInference);
      });
      if (hasPropsPreventingInference) {
        return false;
      }
    }
    return !doColDefPropsPreventInference(colDef, propsToCheckForInference);
  }
  inferCellDataType(field, colId) {
    if (!field) {
      return void 0;
    }
    let value;
    const initialData = this.getInitialData();
    if (initialData) {
      const fieldContainsDots = field.indexOf(".") >= 0 && !this.gos.get("suppressFieldDotNotation");
      value = _getValueUsingField(initialData, field, fieldContainsDots);
    } else {
      this.initWaitForRowData(colId);
    }
    if (value == null) {
      return void 0;
    }
    const matchedType = Object.keys(this.dataTypeMatchers).find(
      (_cellDataType) => this.dataTypeMatchers[_cellDataType](value)
    );
    return matchedType ?? "object";
  }
  getInitialData() {
    const rowData = this.gos.get("rowData");
    if (rowData?.length) {
      return rowData[0];
    } else if (this.initialData) {
      return this.initialData;
    } else {
      const rowNodes = this.beans.rowModel.rootNode?.allLeafChildren;
      if (rowNodes?.length) {
        return rowNodes[0].data;
      }
    }
    return null;
  }
  initWaitForRowData(colId) {
    this.columnStateUpdatesPendingInference[colId] = /* @__PURE__ */ new Set();
    if (this.isPendingInference) {
      return;
    }
    this.isPendingInference = true;
    const columnTypeOverridesExist = this.isColumnTypeOverrideInDataTypeDefinitions;
    const { colAutosize, eventSvc } = this.beans;
    if (columnTypeOverridesExist && colAutosize) {
      colAutosize.shouldQueueResizeOperations = true;
    }
    const [destroyFunc] = this.addManagedEventListeners({
      rowDataUpdateStarted: (event) => {
        const { firstRowData } = event;
        if (!firstRowData) {
          return;
        }
        destroyFunc?.();
        this.isPendingInference = false;
        this.processColumnsPendingInference(firstRowData, columnTypeOverridesExist);
        this.columnStateUpdatesPendingInference = {};
        if (columnTypeOverridesExist) {
          colAutosize?.processResizeOperations();
        }
        eventSvc.dispatchEvent({
          type: "dataTypesInferred"
        });
      }
    });
  }
  processColumnsPendingInference(firstRowData, columnTypeOverridesExist) {
    this.initialData = firstRowData;
    const state = [];
    this.destroyColumnStateUpdateListeners();
    const newRowGroupColumnStateWithoutIndex = {};
    const newPivotColumnStateWithoutIndex = {};
    for (const colId of Object.keys(this.columnStateUpdatesPendingInference)) {
      const columnStateUpdates = this.columnStateUpdatesPendingInference[colId];
      const column = this.colModel.getCol(colId);
      if (!column) {
        return;
      }
      const oldColDef = column.getColDef();
      if (!this.resetColDefIntoCol(column, "cellDataTypeInferred")) {
        return;
      }
      const newColDef = column.getColDef();
      if (columnTypeOverridesExist && newColDef.type && newColDef.type !== oldColDef.type) {
        const updatedColumnState = getUpdatedColumnState(column, columnStateUpdates);
        if (updatedColumnState.rowGroup && updatedColumnState.rowGroupIndex == null) {
          newRowGroupColumnStateWithoutIndex[colId] = updatedColumnState;
        }
        if (updatedColumnState.pivot && updatedColumnState.pivotIndex == null) {
          newPivotColumnStateWithoutIndex[colId] = updatedColumnState;
        }
        state.push(updatedColumnState);
      }
    }
    if (columnTypeOverridesExist) {
      state.push(
        ...this.generateColumnStateForRowGroupAndPivotIndexes(
          newRowGroupColumnStateWithoutIndex,
          newPivotColumnStateWithoutIndex
        )
      );
    }
    if (state.length) {
      _applyColumnState(this.beans, { state }, "cellDataTypeInferred");
    }
    this.initialData = null;
  }
  generateColumnStateForRowGroupAndPivotIndexes(updatedRowGroupColumnState, updatedPivotColumnState) {
    const existingColumnStateUpdates = {};
    const { rowGroupColsSvc, pivotColsSvc } = this.beans;
    rowGroupColsSvc?.restoreColumnOrder(existingColumnStateUpdates, updatedRowGroupColumnState);
    pivotColsSvc?.restoreColumnOrder(existingColumnStateUpdates, updatedPivotColumnState);
    return Object.values(existingColumnStateUpdates);
  }
  resetColDefIntoCol(column, source) {
    const userColDef = column.getUserProvidedColDef();
    if (!userColDef) {
      return false;
    }
    const newColDef = _addColumnDefaultAndTypes(this.beans, userColDef, column.getColId());
    column.setColDef(newColDef, userColDef, source);
    return true;
  }
  getDateStringTypeDefinition(column) {
    const { dateString } = this.dataTypeDefinitions;
    if (!column) {
      return dateString;
    }
    return this.getDataTypeDefinition(column) ?? dateString;
  }
  getDateParserFunction(column) {
    return this.getDateStringTypeDefinition(column).dateParser;
  }
  getDateFormatterFunction(column) {
    return this.getDateStringTypeDefinition(column).dateFormatter;
  }
  getDateIncludesTimeFlag(cellDataType) {
    return cellDataType === "dateTime" || cellDataType === "dateTimeString";
  }
  getDataTypeDefinition(column) {
    const colDef = column.getColDef();
    if (!colDef.cellDataType) {
      return void 0;
    }
    return this.dataTypeDefinitions[colDef.cellDataType];
  }
  getBaseDataType(column) {
    return this.getDataTypeDefinition(column)?.baseDataType;
  }
  checkType(column, value) {
    if (value == null) {
      return true;
    }
    const dataTypeMatcher = this.getDataTypeDefinition(column)?.dataTypeMatcher;
    if (!dataTypeMatcher) {
      return true;
    }
    return dataTypeMatcher(value);
  }
  validateColDef(colDef) {
    const warning = (property) => _warn(48, { property });
    if (colDef.cellDataType === "object") {
      const { object } = this.dataTypeDefinitions;
      if (colDef.valueFormatter === object.groupSafeValueFormatter && !this.hasObjectValueFormatter) {
        warning("Formatter");
      }
      if (colDef.editable && colDef.valueParser === object.valueParser && !this.hasObjectValueParser) {
        warning("Parser");
      }
    }
  }
  postProcess(colDef) {
    const cellDataType = colDef.cellDataType;
    if (!cellDataType || typeof cellDataType !== "string") {
      return;
    }
    const { dataTypeDefinitions, beans, formatValueFuncs } = this;
    const dataTypeDefinition = dataTypeDefinitions[cellDataType];
    beans.colFilter?.setColDefPropsForDataType(colDef, dataTypeDefinition, formatValueFuncs[cellDataType]);
  }
  // noinspection JSUnusedGlobalSymbols
  getFormatValue(cellDataType) {
    return this.formatValueFuncs[cellDataType];
  }
  isColPendingInference(colId) {
    return this.isPendingInference && !!this.columnStateUpdatesPendingInference[colId];
  }
  setColDefPropertiesForBaseDataType(colDef, cellDataType, dataTypeDefinition, colId) {
    const formatValue = this.formatValueFuncs[cellDataType];
    const partialColDef = this.columnDefinitionPropsPerDataType[dataTypeDefinition.baseDataType]({
      colDef,
      cellDataType,
      colModel: this.colModel,
      dataTypeDefinition,
      colId,
      formatValue
    });
    Object.assign(colDef, partialColDef);
  }
  getDateObjectTypeDef(baseDataType) {
    const translate = this.getLocaleTextFunc();
    const includeTime = this.getDateIncludesTimeFlag(baseDataType);
    return {
      baseDataType,
      valueParser: (params) => _parseDateTimeFromString(params.newValue && String(params.newValue)),
      valueFormatter: (params) => {
        if (params.value == null) {
          return "";
        }
        if (!(params.value instanceof Date) || isNaN(params.value.getTime())) {
          return translate("invalidDate", "Invalid Date");
        }
        return _serialiseDate(params.value, includeTime) ?? "";
      },
      dataTypeMatcher: (value) => value instanceof Date
    };
  }
  getDateStringTypeDef(baseDataType) {
    const includeTime = this.getDateIncludesTimeFlag(baseDataType);
    return {
      baseDataType,
      dateParser: (value) => _parseDateTimeFromString(value) ?? void 0,
      dateFormatter: (value) => _serialiseDate(value ?? null, includeTime) ?? void 0,
      valueParser: (params) => _isValidDate(String(params.newValue)) ? params.newValue : null,
      valueFormatter: (params) => _isValidDate(String(params.value)) ? String(params.value) : "",
      dataTypeMatcher: (value) => typeof value === "string" && _isValidDate(value)
    };
  }
  getDefaultDataTypes() {
    const translate = this.getLocaleTextFunc();
    return {
      number: {
        baseDataType: "number",
        // can be empty space with legacy copy
        valueParser: (params) => params.newValue?.trim?.() === "" ? null : Number(params.newValue),
        valueFormatter: (params) => {
          if (params.value == null) {
            return "";
          }
          if (typeof params.value !== "number" || isNaN(params.value)) {
            return translate("invalidNumber", "Invalid Number");
          }
          return String(params.value);
        },
        dataTypeMatcher: (value) => typeof value === "number"
      },
      text: {
        baseDataType: "text",
        valueParser: (params) => params.newValue === "" ? null : _toStringOrNull(params.newValue),
        dataTypeMatcher: (value) => typeof value === "string"
      },
      boolean: {
        baseDataType: "boolean",
        valueParser: (params) => {
          if (params.newValue == null) {
            return params.newValue;
          }
          return params.newValue?.trim?.() === "" ? null : String(params.newValue).toLowerCase() === "true";
        },
        valueFormatter: (params) => params.value == null ? "" : String(params.value),
        dataTypeMatcher: (value) => typeof value === "boolean"
      },
      date: this.getDateObjectTypeDef("date"),
      dateString: this.getDateStringTypeDef("dateString"),
      dateTime: this.getDateObjectTypeDef("dateTime"),
      dateTimeString: {
        ...this.getDateStringTypeDef("dateTimeString"),
        dataTypeMatcher: (value) => typeof value === "string" && _isValidDateTime(value)
      },
      object: {
        baseDataType: "object",
        valueParser: () => null,
        valueFormatter: (params) => _toStringOrNull(params.value) ?? ""
      }
    };
  }
  destroyColumnStateUpdateListeners() {
    this.columnStateUpdateListenerDestroyFuncs.forEach((destroyFunc) => destroyFunc());
    this.columnStateUpdateListenerDestroyFuncs = [];
  }
  destroy() {
    this.dataTypeDefinitions = {};
    this.dataTypeMatchers = {};
    this.formatValueFuncs = {};
    this.columnStateUpdatesPendingInference = {};
    this.destroyColumnStateUpdateListeners();
    super.destroy();
  }
};
function mergeDataTypeDefinitions(parentDataTypeDefinition, childDataTypeDefinition) {
  const mergedDataTypeDefinition = {
    ...parentDataTypeDefinition,
    ...childDataTypeDefinition
  };
  if (parentDataTypeDefinition.columnTypes && childDataTypeDefinition.columnTypes && childDataTypeDefinition.appendColumnTypes) {
    mergedDataTypeDefinition.columnTypes = [
      ...convertColumnTypes(parentDataTypeDefinition.columnTypes),
      ...convertColumnTypes(childDataTypeDefinition.columnTypes)
    ];
  }
  return mergedDataTypeDefinition;
}
function validateDataTypeDefinition(dataTypeDefinition, parentDataTypeDefinition, parentCellDataType) {
  if (!parentDataTypeDefinition) {
    _warn(45, { parentCellDataType });
    return false;
  }
  if (parentDataTypeDefinition.baseDataType !== dataTypeDefinition.baseDataType) {
    _warn(46);
    return false;
  }
  return true;
}
function createGroupSafeValueFormatter(dataTypeDefinition, gos) {
  if (!dataTypeDefinition.valueFormatter) {
    return void 0;
  }
  return (params) => {
    if (params.node?.group) {
      const aggFunc = (params.colDef.pivotValueColumn ?? params.column).getAggFunc();
      if (aggFunc) {
        if (aggFunc === "first" || aggFunc === "last") {
          return dataTypeDefinition.valueFormatter(params);
        }
        if (dataTypeDefinition.baseDataType === "number" && aggFunc !== "count") {
          if (typeof params.value === "number") {
            return dataTypeDefinition.valueFormatter(params);
          }
          if (typeof params.value === "object") {
            if (!params.value) {
              return void 0;
            }
            if ("toNumber" in params.value) {
              return dataTypeDefinition.valueFormatter({
                ...params,
                value: params.value.toNumber()
              });
            }
            if ("value" in params.value) {
              return dataTypeDefinition.valueFormatter({
                ...params,
                value: params.value.value
              });
            }
          }
        }
        return void 0;
      }
    } else if (gos.get("groupHideOpenParents") && params.column.isRowGroupActive()) {
      if (typeof params.value === "string" && !dataTypeDefinition.dataTypeMatcher?.(params.value)) {
        return void 0;
      }
    }
    return dataTypeDefinition.valueFormatter(params);
  };
}
function doesColDefPropPreventInference(colDef, checkProps, prop, comparisonValue) {
  if (!checkProps[prop]) {
    return false;
  }
  const value = colDef[prop];
  if (value === null) {
    checkProps[prop] = false;
    return false;
  } else {
    return comparisonValue === void 0 ? !!value : value === comparisonValue;
  }
}
function doColDefPropsPreventInference(colDef, propsToCheckForInference) {
  return [
    ["cellRenderer", "agSparklineCellRenderer"],
    ["valueGetter", void 0],
    ["valueParser", void 0],
    ["refData", void 0]
  ].some(
    ([prop, comparisonValue]) => doesColDefPropPreventInference(colDef, propsToCheckForInference, prop, comparisonValue)
  );
}
function getUpdatedColumnState(column, columnStateUpdates) {
  const columnState = getColumnStateFromColDef(column);
  columnStateUpdates.forEach((key) => {
    delete columnState[key];
    if (key === "rowGroup") {
      delete columnState.rowGroupIndex;
    } else if (key === "pivot") {
      delete columnState.pivotIndex;
    }
  });
  return columnState;
}

// packages/ag-grid-community/src/columns/columnModule.ts
var DataTypeModule = {
  moduleName: "DataType",
  version: VERSION,
  beans: [DataTypeService],
  dependsOn: [CheckboxCellRendererModule]
};
var ColumnFlexModule = {
  moduleName: "ColumnFlex",
  version: VERSION,
  beans: [ColumnFlexService]
};
var ColumnApiModule = {
  moduleName: "ColumnApi",
  version: VERSION,
  beans: [ColumnDefFactory],
  apiFunctions: {
    getColumnDef,
    getDisplayNameForColumn,
    getColumn,
    getColumns,
    applyColumnState,
    getColumnState,
    resetColumnState,
    isPinning,
    isPinningLeft,
    isPinningRight,
    getDisplayedColAfter,
    getDisplayedColBefore,
    setColumnsVisible,
    setColumnsPinned,
    getAllGridColumns,
    getDisplayedLeftColumns,
    getDisplayedCenterColumns,
    getDisplayedRightColumns,
    getAllDisplayedColumns,
    getAllDisplayedVirtualColumns,
    getColumnDefs
  }
};

// packages/ag-grid-community/src/columns/columnNameService.ts
function _camelCaseToHumanText(camelCase) {
  if (!camelCase || camelCase == null) {
    return null;
  }
  const rex = /([a-z])([A-Z])/g;
  const rexCaps = /([A-Z]+)([A-Z])([a-z])/g;
  const words = camelCase.replace(rex, "$1 $2").replace(rexCaps, "$1 $2$3").replace(/\./g, " ").split(" ");
  return words.map((word) => word.substring(0, 1).toUpperCase() + (word.length > 1 ? word.substring(1, word.length) : "")).join(" ");
}
var ColumnNameService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colNames";
  }
  getDisplayNameForColumn(column, location, includeAggFunc = false) {
    if (!column) {
      return null;
    }
    const headerName = this.getHeaderName(column.getColDef(), column, null, null, location);
    const { aggColNameSvc } = this.beans;
    if (includeAggFunc && aggColNameSvc) {
      return aggColNameSvc.getHeaderName(column, headerName);
    }
    return headerName;
  }
  getDisplayNameForProvidedColumnGroup(columnGroup, providedColumnGroup, location) {
    const colGroupDef = providedColumnGroup?.getColGroupDef();
    if (colGroupDef) {
      return this.getHeaderName(colGroupDef, null, columnGroup, providedColumnGroup, location);
    }
    return null;
  }
  getDisplayNameForColumnGroup(columnGroup, location) {
    return this.getDisplayNameForProvidedColumnGroup(columnGroup, columnGroup.getProvidedColumnGroup(), location);
  }
  // location is where the column is going to appear, ie who is calling us
  getHeaderName(colDef, column, columnGroup, providedColumnGroup, location) {
    const headerValueGetter = colDef.headerValueGetter;
    if (headerValueGetter) {
      const params = _addGridCommonParams(this.gos, {
        colDef,
        column,
        columnGroup,
        providedColumnGroup,
        location
      });
      if (typeof headerValueGetter === "function") {
        return headerValueGetter(params);
      } else if (typeof headerValueGetter === "string") {
        return this.beans.expressionSvc?.evaluate(headerValueGetter, params) ?? null;
      }
      return "";
    } else if (colDef.headerName != null) {
      return colDef.headerName;
    } else if (colDef.field) {
      return _camelCaseToHumanText(colDef.field);
    }
    return "";
  }
};

// packages/ag-grid-community/src/columns/columnViewportService.ts
var ColumnViewportService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colViewport";
    // cols in center that are in the viewport
    this.colsWithinViewport = [];
    // same as colsWithinViewport, except we always include columns with headerAutoHeight
    this.headerColsWithinViewport = [];
    // A hash key to keep track of changes in viewport columns
    this.colsWithinViewportHash = "";
    // all columns & groups to be rendered, index by row.
    // used by header rows to get all items to render for that row.
    this.rowsOfHeadersToRenderLeft = {};
    this.rowsOfHeadersToRenderRight = {};
    this.rowsOfHeadersToRenderCenter = {};
    this.columnsToRenderLeft = [];
    this.columnsToRenderRight = [];
    this.columnsToRenderCenter = [];
  }
  wireBeans(beans) {
    this.visibleCols = beans.visibleCols;
    this.colModel = beans.colModel;
  }
  postConstruct() {
    this.suppressColumnVirtualisation = this.gos.get("suppressColumnVirtualisation");
  }
  setScrollPosition(scrollWidth, scrollPosition, afterScroll = false) {
    const { visibleCols } = this;
    const bodyWidthDirty = visibleCols.isBodyWidthDirty;
    const noChange = scrollWidth === this.scrollWidth && scrollPosition === this.scrollPosition && !bodyWidthDirty;
    if (noChange) {
      return;
    }
    this.scrollWidth = scrollWidth;
    this.scrollPosition = scrollPosition;
    visibleCols.isBodyWidthDirty = true;
    if (this.gos.get("enableRtl")) {
      const bodyWidth = visibleCols.bodyWidth;
      this.viewportLeft = bodyWidth - scrollPosition - scrollWidth;
      this.viewportRight = bodyWidth - scrollPosition;
    } else {
      this.viewportLeft = scrollPosition;
      this.viewportRight = scrollWidth + scrollPosition;
    }
    if (this.colModel.ready) {
      this.checkViewportColumns(afterScroll);
    }
  }
  /**
   * Returns the columns that are currently rendered in the viewport.
   */
  getColumnHeadersToRender(type) {
    switch (type) {
      case "left":
        return this.columnsToRenderLeft;
      case "right":
        return this.columnsToRenderRight;
      default:
        return this.columnsToRenderCenter;
    }
  }
  /**
   * Returns the column groups that are currently rendered in the viewport at a specific header row index.
   */
  getHeadersToRender(type, depth) {
    let result;
    switch (type) {
      case "left":
        result = this.rowsOfHeadersToRenderLeft[depth];
        break;
      case "right":
        result = this.rowsOfHeadersToRenderRight[depth];
        break;
      default:
        result = this.rowsOfHeadersToRenderCenter[depth];
        break;
    }
    return result ?? [];
  }
  extractViewportColumns() {
    const displayedColumnsCenter = this.visibleCols.centerCols;
    if (this.isColumnVirtualisationSuppressed()) {
      this.colsWithinViewport = displayedColumnsCenter;
      this.headerColsWithinViewport = displayedColumnsCenter;
    } else {
      this.colsWithinViewport = displayedColumnsCenter.filter(this.isColumnInRowViewport.bind(this));
      this.headerColsWithinViewport = displayedColumnsCenter.filter(this.isColumnInHeaderViewport.bind(this));
    }
  }
  isColumnVirtualisationSuppressed() {
    return this.suppressColumnVirtualisation || this.viewportRight === 0;
  }
  clear() {
    this.rowsOfHeadersToRenderLeft = {};
    this.rowsOfHeadersToRenderRight = {};
    this.rowsOfHeadersToRenderCenter = {};
    this.colsWithinViewportHash = "";
  }
  isColumnInHeaderViewport(col) {
    if (col.isAutoHeaderHeight() || isAnyParentAutoHeaderHeight(col)) {
      return true;
    }
    return this.isColumnInRowViewport(col);
  }
  isColumnInRowViewport(col) {
    if (col.isAutoHeight()) {
      return true;
    }
    const columnLeft = col.getLeft() || 0;
    const columnRight = columnLeft + col.getActualWidth();
    const leftBounds = this.viewportLeft - 200;
    const rightBounds = this.viewportRight + 200;
    const columnToMuchLeft = columnLeft < leftBounds && columnRight < leftBounds;
    const columnToMuchRight = columnLeft > rightBounds && columnRight > rightBounds;
    return !columnToMuchLeft && !columnToMuchRight;
  }
  // used by Grid API only
  getViewportColumns() {
    const { leftCols, rightCols } = this.visibleCols;
    const res = this.colsWithinViewport.concat(leftCols).concat(rightCols);
    return res;
  }
  // + rowRenderer
  // if we are not column spanning, this just returns back the virtual centre columns,
  // however if we are column spanning, then different rows can have different virtual
  // columns, so we have to work out the list for each individual row.
  getColsWithinViewport(rowNode) {
    if (!this.colModel.colSpanActive) {
      return this.colsWithinViewport;
    }
    const emptySpaceBeforeColumn = (col) => {
      const left = col.getLeft();
      return _exists(left) && left > this.viewportLeft;
    };
    const inViewportCallback = this.isColumnVirtualisationSuppressed() ? void 0 : this.isColumnInRowViewport.bind(this);
    const { visibleCols } = this;
    const displayedColumnsCenter = visibleCols.centerCols;
    return visibleCols.getColsForRow(rowNode, displayedColumnsCenter, inViewportCallback, emptySpaceBeforeColumn);
  }
  // checks what columns are currently displayed due to column virtualisation. dispatches an event
  // if the list of columns has changed.
  // + setColumnWidth(), setViewportPosition(), setColumnDefs(), sizeColumnsToFit()
  checkViewportColumns(afterScroll = false) {
    const viewportColumnsChanged = this.extractViewport();
    if (viewportColumnsChanged) {
      this.eventSvc.dispatchEvent({
        type: "virtualColumnsChanged",
        afterScroll
      });
    }
  }
  calculateHeaderRows() {
    const { leftCols, rightCols } = this.visibleCols;
    this.columnsToRenderLeft = leftCols;
    this.columnsToRenderRight = rightCols;
    this.columnsToRenderCenter = this.colsWithinViewport;
    const workOutGroupsToRender = (cols) => {
      const groupsToRenderSet = /* @__PURE__ */ new Set();
      const groupsToRender = {};
      for (const col of cols) {
        let group = col.getParent();
        const skipFillers = col.isSpanHeaderHeight();
        while (group) {
          if (groupsToRenderSet.has(group)) {
            break;
          }
          const skipFillerGroup = skipFillers && group.isPadding();
          if (skipFillerGroup) {
            group = group.getParent();
            continue;
          }
          const level = group.getProvidedColumnGroup().getLevel();
          groupsToRender[level] ?? (groupsToRender[level] = []);
          groupsToRender[level].push(group);
          groupsToRenderSet.add(group);
          group = group.getParent();
        }
      }
      return groupsToRender;
    };
    this.rowsOfHeadersToRenderLeft = workOutGroupsToRender(leftCols);
    this.rowsOfHeadersToRenderRight = workOutGroupsToRender(rightCols);
    this.rowsOfHeadersToRenderCenter = workOutGroupsToRender(this.headerColsWithinViewport);
  }
  extractViewport() {
    const hashColumn = (c) => `${c.getId()}-${c.getPinned() || "normal"}`;
    this.extractViewportColumns();
    const newHash = this.getViewportColumns().map(hashColumn).join("#");
    const changed = this.colsWithinViewportHash !== newHash;
    if (changed) {
      this.colsWithinViewportHash = newHash;
      this.calculateHeaderRows();
    }
    return changed;
  }
};
function isAnyParentAutoHeaderHeight(col) {
  while (col) {
    if (col.isAutoHeaderHeight()) {
      return true;
    }
    col = col.getParent();
  }
  return false;
}

// packages/ag-grid-community/src/components/framework/agComponentUtils.ts
var AgComponentUtils = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "agCompUtils";
  }
  adaptFunction(type, jsCompFunc) {
    if (!type.cellRenderer) {
      return null;
    }
    class Adapter {
      refresh() {
        return false;
      }
      getGui() {
        return this.eGui;
      }
      init(params) {
        const callbackResult = jsCompFunc(params);
        const type2 = typeof callbackResult;
        if (type2 === "string" || type2 === "number" || type2 === "boolean") {
          this.eGui = _loadTemplate("<span>" + callbackResult + "</span>");
          return;
        }
        if (callbackResult == null) {
          this.eGui = _createElement({ tag: "span" });
          return;
        }
        this.eGui = callbackResult;
      }
    }
    return Adapter;
  }
};

// packages/ag-grid-community/src/components/framework/cellRendererFunctionModule.ts
var CellRendererFunctionModule = {
  moduleName: "CellRendererFunction",
  version: VERSION,
  beans: [AgComponentUtils]
};

// packages/ag-grid-community/src/components/framework/registry.ts
var Registry = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "registry";
    this.agGridDefaults = {};
    this.agGridDefaultOverrides = {};
    this.jsComps = {};
    this.selectors = {};
    this.icons = {};
  }
  postConstruct() {
    const comps = this.gos.get("components");
    if (comps != null) {
      for (const key of Object.keys(comps)) {
        this.jsComps[key] = comps[key];
      }
    }
  }
  registerModule(module2) {
    const { icons, userComponents, dynamicBeans, selectors } = module2;
    if (userComponents) {
      const registerUserComponent = (name, component, params, processParams) => {
        this.agGridDefaults[name] = component;
        if (params || processParams) {
          this.agGridDefaultOverrides[name] = { params, processParams };
        }
      };
      for (const name of Object.keys(userComponents)) {
        let comp = userComponents[name];
        if (isComponentMetaFunc(comp)) {
          comp = comp.getComp(this.beans);
        }
        if (typeof comp === "object") {
          const { classImp, params, processParams } = comp;
          registerUserComponent(name, classImp, params, processParams);
        } else {
          registerUserComponent(name, comp);
        }
      }
    }
    if (dynamicBeans) {
      this.dynamicBeans ?? (this.dynamicBeans = {});
      for (const name of Object.keys(dynamicBeans)) {
        this.dynamicBeans[name] = dynamicBeans[name];
      }
    }
    selectors?.forEach((selector) => {
      this.selectors[selector.selector] = selector;
    });
    if (icons) {
      for (const name of Object.keys(icons)) {
        this.icons[name] = icons[name];
      }
    }
  }
  getUserComponent(propertyName, name) {
    const createResult = (component, componentFromFramework, params, processParams) => ({
      componentFromFramework,
      component,
      params,
      processParams
    });
    const { frameworkOverrides } = this.beans;
    const registeredViaFrameworkComp = frameworkOverrides.frameworkComponent(name, this.gos.get("components"));
    if (registeredViaFrameworkComp != null) {
      return createResult(registeredViaFrameworkComp, true);
    }
    const jsComponent = this.jsComps[name];
    if (jsComponent) {
      const isFwkComp = frameworkOverrides.isFrameworkComponent(jsComponent);
      return createResult(jsComponent, isFwkComp);
    }
    const defaultComponent = this.agGridDefaults[name];
    if (defaultComponent) {
      const overrides = this.agGridDefaultOverrides[name];
      return createResult(defaultComponent, false, overrides?.params, overrides?.processParams);
    }
    this.beans.validation?.missingUserComponent(propertyName, name, this.agGridDefaults, this.jsComps);
    return null;
  }
  createDynamicBean(name, mandatory, ...args) {
    if (!this.dynamicBeans) {
      throw new Error(_errMsg(279, { name }));
    }
    const BeanClass = this.dynamicBeans[name];
    if (BeanClass == null) {
      if (mandatory) {
        throw new Error(this.beans.validation?.missingDynamicBean(name) ?? _errMsg(256));
      }
      return void 0;
    }
    return new BeanClass(...args);
  }
  getSelector(name) {
    return this.selectors[name];
  }
  getIcon(name) {
    return this.icons[name];
  }
};

// packages/ag-grid-community/src/ctrlsService.ts
var NUM_CTRLS = 23;
var CtrlsService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "ctrlsSvc";
    this.params = {};
    this.ready = false;
    this.readyCallbacks = [];
  }
  postConstruct() {
    this.addEventListener(
      "ready",
      () => {
        this.updateReady();
        if (this.ready) {
          this.readyCallbacks.forEach((c) => c(this.params));
          this.readyCallbacks.length = 0;
        }
      },
      this.beans.frameworkOverrides.runWhenReadyAsync?.() ?? false
    );
  }
  updateReady() {
    const values = Object.values(this.params);
    this.ready = values.length === NUM_CTRLS && values.every((ctrl) => {
      return ctrl?.isAlive() ?? false;
    });
  }
  whenReady(caller, callback) {
    if (this.ready) {
      callback(this.params);
    } else {
      this.readyCallbacks.push(callback);
    }
    caller.addDestroyFunc(() => {
      const index = this.readyCallbacks.indexOf(callback);
      if (index >= 0) {
        this.readyCallbacks.splice(index, 1);
      }
    });
  }
  register(ctrlType, ctrl) {
    this.params[ctrlType] = ctrl;
    this.updateReady();
    if (this.ready) {
      this.dispatchLocalEvent({ type: "ready" });
    }
    ctrl.addDestroyFunc(() => {
      this.updateReady();
    });
  }
  get(ctrlType) {
    return this.params[ctrlType];
  }
  getGridBodyCtrl() {
    return this.params.gridBodyCtrl;
  }
  getHeaderRowContainerCtrls() {
    const { leftHeader, centerHeader, rightHeader } = this.params;
    return [leftHeader, rightHeader, centerHeader];
  }
  getHeaderRowContainerCtrl(pinned) {
    const params = this.params;
    switch (pinned) {
      case "left":
        return params.leftHeader;
      case "right":
        return params.rightHeader;
      default:
        return params.centerHeader;
    }
  }
  getScrollFeature() {
    return this.getGridBodyCtrl().scrollFeature;
  }
};

// packages/ag-grid-community/src/theming/core/core.css-GENERATED.ts
var coreCSS = (
  /*css*/
  `:where(.ag-root-wrapper,.ag-popup,.ag-dnd-ghost,.ag-chart),:where(.ag-root-wrapper,.ag-popup,.ag-dnd-ghost,.ag-chart) :where([class^=ag-]){box-sizing:border-box;&:after,&:before{box-sizing:border-box}&:where(div,span,label):focus-visible{box-shadow:inset var(--ag-focus-shadow);outline:none;&:where(.invalid){box-shadow:inset var(--ag-focus-error-shadow)}}&:where(button){color:inherit}}:where(.ag-root-wrapper,.ag-popup,.ag-dnd-ghost,.ag-chart) :where([class^=ag-]) ::-ms-clear{display:none}.ag-aria-description-container{border:0;z-index:9999;clip:rect(1px,1px,1px,1px);height:1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}.ag-hidden{display:none!important}.ag-invisible{visibility:hidden!important}.ag-unselectable{-webkit-user-select:none;-moz-user-select:none;user-select:none}.ag-selectable{-webkit-user-select:text;-moz-user-select:text;user-select:text}.ag-tab-guard{display:block;height:0;position:absolute;width:0}:where(.ag-virtual-list-viewport) .ag-tab-guard{position:sticky}.ag-tab-guard-top{top:1px}.ag-tab-guard-bottom{bottom:1px}.ag-shake-left-to-right{animation-direction:alternate;animation-duration:.2s;animation-iteration-count:infinite;animation-name:ag-shake-left-to-right}@keyframes ag-shake-left-to-right{0%{padding-left:6px;padding-right:2px}to{padding-left:2px;padding-right:6px}}.ag-body-horizontal-scroll-viewport,.ag-body-vertical-scroll-viewport,.ag-body-viewport,.ag-center-cols-viewport,.ag-floating-bottom-viewport,.ag-floating-top-viewport,.ag-header-viewport,.ag-sticky-bottom-viewport,.ag-sticky-top-viewport,.ag-virtual-list-viewport{flex:1 1 auto;height:100%;min-width:0;overflow:hidden;position:relative}.ag-viewport{position:relative}.ag-spanning-container{position:absolute;top:0;z-index:1}.ag-body-viewport,.ag-center-cols-viewport,.ag-floating-bottom-viewport,.ag-floating-top-viewport,.ag-header-viewport,.ag-sticky-bottom-viewport,.ag-sticky-top-viewport{overflow-x:auto;-ms-overflow-style:none!important;scrollbar-width:none!important;&::-webkit-scrollbar{display:none!important}}.ag-body-viewport{display:flex;overflow-x:hidden;&:where(.ag-layout-normal){overflow-y:auto;-webkit-overflow-scrolling:touch}}.ag-floating-bottom-container,.ag-floating-top-container,.ag-sticky-bottom-container,.ag-sticky-top-container{min-height:1px}.ag-center-cols-viewport{min-height:100%;width:100%}.ag-body-horizontal-scroll-viewport{overflow-x:scroll}.ag-body-vertical-scroll-viewport{overflow-y:scroll}.ag-virtual-list-viewport{overflow:auto;width:100%}.ag-body-container,.ag-body-horizontal-scroll-container,.ag-body-vertical-scroll-container,.ag-center-cols-container,.ag-floating-bottom-container,.ag-floating-bottom-full-width-container,.ag-floating-top-container,.ag-full-width-container,.ag-header-container,.ag-pinned-left-cols-container,.ag-pinned-right-cols-container,.ag-sticky-bottom-container,.ag-sticky-top-container,.ag-virtual-list-container{position:relative}.ag-floating-bottom-container,.ag-floating-top-container,.ag-header-container,.ag-pinned-left-floating-bottom,.ag-pinned-left-floating-top,.ag-pinned-right-floating-bottom,.ag-pinned-right-floating-top,.ag-sticky-bottom-container,.ag-sticky-top-container{height:100%;white-space:nowrap}.ag-center-cols-container,.ag-pinned-right-cols-container{display:block}.ag-body-horizontal-scroll-container{height:100%}.ag-body-vertical-scroll-container{width:100%}.ag-floating-bottom-full-width-container,.ag-floating-top-full-width-container,.ag-full-width-container,.ag-sticky-bottom-full-width-container,.ag-sticky-top-full-width-container{pointer-events:none;position:absolute;top:0}:where(.ag-ltr) .ag-floating-bottom-full-width-container,:where(.ag-ltr) .ag-floating-top-full-width-container,:where(.ag-ltr) .ag-full-width-container,:where(.ag-ltr) .ag-sticky-bottom-full-width-container,:where(.ag-ltr) .ag-sticky-top-full-width-container{left:0}:where(.ag-rtl) .ag-floating-bottom-full-width-container,:where(.ag-rtl) .ag-floating-top-full-width-container,:where(.ag-rtl) .ag-full-width-container,:where(.ag-rtl) .ag-sticky-bottom-full-width-container,:where(.ag-rtl) .ag-sticky-top-full-width-container{right:0}.ag-full-width-container{width:100%}.ag-floating-bottom-full-width-container,.ag-floating-top-full-width-container{display:inline-block;height:100%;overflow:hidden;width:100%}.ag-virtual-list-container{overflow:hidden}.ag-body{display:flex;flex:1 1 auto;flex-direction:row!important;min-height:0;position:relative}.ag-body-horizontal-scroll,.ag-body-vertical-scroll{display:flex;min-height:0;min-width:0;position:relative;&:where(.ag-scrollbar-invisible){bottom:0;position:absolute;&:where(.ag-apple-scrollbar){opacity:0;transition:opacity .4s;visibility:hidden;&:where(.ag-scrollbar-scrolling,.ag-scrollbar-active){opacity:1;visibility:visible}}}}.ag-body-horizontal-scroll{width:100%;&:where(.ag-scrollbar-invisible){left:0;right:0}}.ag-body-vertical-scroll{height:100%;&:where(.ag-scrollbar-invisible){top:0;z-index:10}}:where(.ag-ltr) .ag-body-vertical-scroll{&:where(.ag-scrollbar-invisible){right:0}}:where(.ag-rtl) .ag-body-vertical-scroll{&:where(.ag-scrollbar-invisible){left:0}}.ag-force-vertical-scroll{overflow-y:scroll!important}.ag-horizontal-left-spacer,.ag-horizontal-right-spacer{height:100%;min-width:0;overflow-x:scroll;&:where(.ag-scroller-corner){overflow-x:hidden}}:where(.ag-row-animation) .ag-row{transition:transform .4s,top .4s,opacity .2s;&:where(.ag-after-created){transition:transform .4s,top .4s,height .4s,opacity .2s}}:where(.ag-row-animation.ag-prevent-animation) .ag-row{transition:none!important;&:where(.ag-row.ag-after-created){transition:none!important}}:where(.ag-row-no-animation) .ag-row{transition:none}.ag-row-loading{align-items:center;display:flex}.ag-row-position-absolute{position:absolute}.ag-row-position-relative{position:relative}.ag-full-width-row{overflow:hidden;pointer-events:all}.ag-row-inline-editing{z-index:1}.ag-row-dragging{z-index:2}.ag-stub-cell{align-items:center;display:flex}.ag-cell{display:inline-block;height:100%;position:absolute;white-space:nowrap;&:focus-visible{box-shadow:none}}.ag-cell-value{flex:1 1 auto}.ag-cell-value,.ag-group-value{overflow:hidden;text-overflow:ellipsis}.ag-cell-wrap-text{white-space:normal;word-break:break-word}:where(.ag-cell) .ag-icon{display:inline-block;vertical-align:middle}.ag-floating-top{display:flex;overflow:hidden;position:relative;white-space:nowrap;width:100%}:where(.ag-floating-top:not(.ag-invisible)){border-bottom:var(--ag-pinned-row-border)}.ag-floating-bottom{display:flex;overflow:hidden;position:relative;white-space:nowrap;width:100%}:where(.ag-floating-bottom:not(.ag-invisible)){border-top:var(--ag-pinned-row-border)}.ag-sticky-bottom,.ag-sticky-top{background-color:var(--ag-background-color);display:flex;height:0;overflow:hidden;position:absolute;width:100%;z-index:1}.ag-opacity-zero{opacity:0!important}.ag-cell-label-container{align-items:center;display:flex;flex-direction:row-reverse;height:100%;justify-content:space-between;width:100%}:where(.ag-right-aligned-header){.ag-cell-label-container{flex-direction:row}.ag-header-cell-text{text-align:end}}.ag-column-group-icons{display:block;>*{cursor:pointer}}:where(.ag-ltr){direction:ltr;.ag-body,.ag-body-horizontal-scroll,.ag-body-viewport,.ag-floating-bottom,.ag-floating-top,.ag-header,.ag-sticky-bottom,.ag-sticky-top{flex-direction:row}}:where(.ag-rtl){direction:rtl;text-align:right;.ag-body,.ag-body-horizontal-scroll,.ag-body-viewport,.ag-floating-bottom,.ag-floating-top,.ag-header,.ag-sticky-bottom,.ag-sticky-top{flex-direction:row-reverse}.ag-icon-contracted,.ag-icon-expanded,.ag-icon-tree-closed{display:block}}:where(.ag-rtl){.ag-icon-contracted,.ag-icon-expanded,.ag-icon-tree-closed{transform:rotate(180deg)}}:where(.ag-rtl){.ag-icon-contracted,.ag-icon-expanded,.ag-icon-tree-closed{transform:rotate(-180deg)}}.ag-measurement-container{height:0;overflow:hidden;visibility:hidden;width:0}.ag-measurement-element-border{display:inline-block;&:before{border-left:var(--ag-internal-measurement-border);content:"";display:block}}.ag-group{position:relative;width:100%}.ag-group-title-bar{align-items:center;display:flex;padding:var(--ag-spacing)}.ag-group-title{display:inline;min-width:0;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}:where(.ag-group-title-bar) .ag-group-title{cursor:default}.ag-group-toolbar{align-items:center;display:flex;padding:var(--ag-spacing)}.ag-group-container{display:flex}.ag-disabled .ag-group-container{pointer-events:none}.ag-disabled-group-container,.ag-disabled-group-title-bar{opacity:.5}.ag-group-container-horizontal{flex-flow:row wrap}.ag-group-container-vertical{flex-direction:column}.ag-group-title-bar-icon{cursor:pointer;flex:none}:where(.ag-ltr) .ag-group-title-bar-icon{margin-right:var(--ag-spacing)}:where(.ag-rtl) .ag-group-title-bar-icon{margin-left:var(--ag-spacing)}:where(.ag-group-item-alignment-stretch) .ag-group-item{align-items:stretch}:where(.ag-group-item-alignment-start) .ag-group-item{align-items:flex-start}:where(.ag-group-item-alignment-end) .ag-group-item{align-items:flex-end}.ag-popup-child{top:0;z-index:5;&:where(:not(.ag-tooltip-custom)){box-shadow:var(--ag-popup-shadow)}}.ag-popup-editor{position:absolute;-webkit-user-select:none;-moz-user-select:none;user-select:none}.ag-large-text-input{display:block}:where(.ag-ltr) .ag-row:not(.ag-row-level-0) .ag-pivot-leaf-group{margin-left:var(--ag-row-group-indent-size)}:where(.ag-rtl) .ag-row:not(.ag-row-level-0) .ag-pivot-leaf-group{margin-right:var(--ag-row-group-indent-size)}:where(.ag-ltr) .ag-row-group-leaf-indent{margin-left:calc(var(--ag-cell-widget-spacing) + var(--ag-icon-size))}:where(.ag-rtl) .ag-row-group-leaf-indent{margin-right:calc(var(--ag-cell-widget-spacing) + var(--ag-icon-size))}.ag-value-change-delta{padding:0 2px}.ag-value-change-delta-up{color:var(--ag-value-change-delta-up-color)}.ag-value-change-delta-down{color:var(--ag-value-change-delta-down-color)}.ag-value-change-value{background-color:transparent;border-radius:1px;padding-left:1px;padding-right:1px;transition:background-color 1s}.ag-value-change-value-highlight{background-color:var(--ag-value-change-value-highlight-background-color);transition:background-color .1s}.ag-cell-data-changed{background-color:var(--ag-value-change-value-highlight-background-color)!important}.ag-cell-data-changed-animation{background-color:transparent}.ag-cell-highlight{background-color:var(--ag-range-selection-highlight-color)!important}.ag-row,.ag-spanned-row{color:var(--ag-cell-text-color);font-family:var(--ag-cell-font-family);font-size:var(--ag-data-font-size);white-space:nowrap;--ag-internal-content-line-height:calc(min(var(--ag-row-height), var(--ag-line-height, 1000px)) - var(--ag-internal-row-border-width, 1px) - 2px)}.ag-row{background-color:var(--ag-background-color);border-bottom:var(--ag-row-border);height:var(--ag-row-height);width:100%;&.ag-row-editing-invalid{background-color:var(--ag-full-row-edit-invalid-background-color)}}:where(.ag-body-vertical-content-no-gap>div>div>div,.ag-body-vertical-content-no-gap>div>div>div>div)>.ag-row-last{border-bottom-color:transparent}.ag-sticky-bottom{border-top:var(--ag-row-border);box-sizing:content-box!important}.ag-group-contracted,.ag-group-expanded{cursor:pointer}.ag-cell,.ag-full-width-row .ag-cell-wrapper.ag-row-group{border:1px solid transparent;line-height:var(--ag-internal-content-line-height);-webkit-font-smoothing:subpixel-antialiased}:where(.ag-ltr) .ag-cell{border-right:var(--ag-column-border)}:where(.ag-rtl) .ag-cell{border-left:var(--ag-column-border)}.ag-spanned-cell-wrapper{background-color:var(--ag-background-color);position:absolute}.ag-spanned-cell-wrapper>.ag-spanned-cell{display:block;position:relative}:where(.ag-ltr) :where(.ag-body-horizontal-content-no-gap) .ag-column-last{border-right-color:transparent}:where(.ag-rtl) :where(.ag-body-horizontal-content-no-gap) .ag-column-last{border-left-color:transparent}.ag-cell-wrapper{align-items:center;display:flex;>:where(:not(.ag-cell-value,.ag-group-value)){align-items:center;display:flex;height:var(--ag-internal-content-line-height)}&:where(.ag-row-group){align-items:flex-start}:where(.ag-full-width-row) &:where(.ag-row-group){align-items:center;height:100%}}:where(.ag-ltr) .ag-cell-wrapper{padding-left:calc(var(--ag-indentation-level)*var(--ag-row-group-indent-size))}:where(.ag-rtl) .ag-cell-wrapper{padding-right:calc(var(--ag-indentation-level)*var(--ag-row-group-indent-size))}:where(.ag-cell-wrap-text:not(.ag-cell-auto-height)) .ag-cell-wrapper{align-items:normal;height:100%;:where(.ag-cell-value){height:100%}}:where(.ag-ltr) .ag-row>.ag-cell-wrapper.ag-row-group{padding-left:calc(var(--ag-cell-horizontal-padding) + var(--ag-row-group-indent-size)*var(--ag-indentation-level))}:where(.ag-rtl) .ag-row>.ag-cell-wrapper.ag-row-group{padding-right:calc(var(--ag-cell-horizontal-padding) + var(--ag-row-group-indent-size)*var(--ag-indentation-level))}.ag-cell-focus:not(.ag-cell-range-selected):focus-within,.ag-cell-range-single-cell,.ag-cell-range-single-cell.ag-cell-range-handle,.ag-context-menu-open .ag-cell-focus:not(.ag-cell-range-selected),.ag-context-menu-open .ag-full-width-row.ag-row-focus .ag-cell-wrapper.ag-row-group,.ag-full-width-row.ag-row-focus:focus .ag-cell-wrapper.ag-row-group{border:1px solid;border-color:var(--ag-range-selection-border-color);border-style:var(--ag-range-selection-border-style);outline:initial}.ag-full-width-row.ag-row-focus:focus{box-shadow:none}:where(.ag-ltr) .ag-group-contracted,:where(.ag-ltr) .ag-group-expanded,:where(.ag-ltr) .ag-row-drag,:where(.ag-ltr) .ag-selection-checkbox{margin-right:var(--ag-cell-widget-spacing)}:where(.ag-rtl) .ag-group-contracted,:where(.ag-rtl) .ag-group-expanded,:where(.ag-rtl) .ag-row-drag,:where(.ag-rtl) .ag-selection-checkbox{margin-left:var(--ag-cell-widget-spacing)}:where(.ag-ltr) .ag-group-child-count{margin-left:3px}:where(.ag-rtl) .ag-group-child-count{margin-right:3px}.ag-row-highlight-above:after,.ag-row-highlight-below:after,.ag-row-highlight-inside:after{background-color:var(--ag-range-selection-border-color);content:"";height:1px;pointer-events:none;position:absolute;width:calc(100% - 1px)}:where(.ag-ltr) .ag-row-highlight-above:after,:where(.ag-ltr) .ag-row-highlight-below:after,:where(.ag-ltr) .ag-row-highlight-inside:after{left:1px}:where(.ag-rtl) .ag-row-highlight-above:after,:where(.ag-rtl) .ag-row-highlight-below:after,:where(.ag-rtl) .ag-row-highlight-inside:after{right:1px}.ag-row-highlight-above:after{top:0}.ag-row-highlight-below:after{bottom:0}.ag-row-highlight-indent:after{display:block;width:auto}:where(.ag-ltr) .ag-row-highlight-indent:after{left:calc((var(--ag-cell-widget-spacing) + var(--ag-icon-size))*2 + var(--ag-cell-horizontal-padding) + var(--ag-row-highlight-level)*var(--ag-row-group-indent-size));right:1px}:where(.ag-rtl) .ag-row-highlight-indent:after{left:1px;right:calc((var(--ag-cell-widget-spacing) + var(--ag-icon-size))*2 + var(--ag-cell-horizontal-padding) + var(--ag-row-highlight-level)*var(--ag-row-group-indent-size))}.ag-row-highlight-inside:after{background-color:var(--ag-selected-row-background-color);border:1px solid var(--ag-range-selection-border-color);display:block;height:auto;inset:0;width:auto}.ag-row-odd{background-color:var(--ag-odd-row-background-color)}.ag-row-selected:before{background-color:var(--ag-selected-row-background-color);content:"";display:block;inset:0;pointer-events:none;position:absolute}.ag-row-hover.ag-full-width-row.ag-row-group:before,.ag-row-hover:not(.ag-full-width-row):before{background-color:var(--ag-row-hover-color);content:"";display:block;inset:0;pointer-events:none;position:absolute}.ag-row-hover.ag-row-selected:before{background-color:var(--ag-row-hover-color);background-image:linear-gradient(var(--ag-selected-row-background-color),var(--ag-selected-row-background-color))}.ag-row.ag-full-width-row.ag-row-group>*{position:relative}.ag-column-hover{background-color:var(--ag-column-hover-color)}.ag-header-range-highlight{background-color:var(--ag-range-header-highlight-color)}.ag-right-aligned-cell{font-variant-numeric:tabular-nums}:where(.ag-ltr) .ag-right-aligned-cell{text-align:right}:where(.ag-rtl) .ag-right-aligned-cell{text-align:left}.ag-right-aligned-cell .ag-cell-value,.ag-right-aligned-cell .ag-group-value{margin-left:auto}:where(.ag-ltr) .ag-cell:not(.ag-cell-inline-editing),:where(.ag-ltr) .ag-full-width-row .ag-cell-wrapper.ag-row-group{padding-left:calc(var(--ag-cell-horizontal-padding) - 1px + var(--ag-row-group-indent-size)*var(--ag-indentation-level));padding-right:calc(var(--ag-cell-horizontal-padding) - 1px)}:where(.ag-rtl) .ag-cell:not(.ag-cell-inline-editing),:where(.ag-rtl) .ag-full-width-row .ag-cell-wrapper.ag-row-group{padding-left:calc(var(--ag-cell-horizontal-padding) - 1px);padding-right:calc(var(--ag-cell-horizontal-padding) - 1px + var(--ag-row-group-indent-size)*var(--ag-indentation-level))}.ag-row>.ag-cell-wrapper{padding-left:calc(var(--ag-cell-horizontal-padding) - 1px);padding-right:calc(var(--ag-cell-horizontal-padding) - 1px)}.ag-row-dragging{cursor:move;opacity:.5}.ag-details-row{background-color:var(--ag-background-color);padding:calc(var(--ag-spacing)*3.75)}.ag-layout-auto-height,.ag-layout-print{.ag-center-cols-container,.ag-center-cols-viewport{min-height:150px}}.ag-overlay-loading-wrapper{background-color:var(--ag-modal-overlay-background-color)}.ag-skeleton-container{align-content:center;height:100%;width:100%}.ag-skeleton-effect{animation:ag-skeleton-loading 1.5s ease-in-out .5s infinite;background-color:var(--ag-row-loading-skeleton-effect-color);border-radius:.25rem;height:1em;width:100%}:where(.ag-ltr) .ag-right-aligned-cell .ag-skeleton-effect{margin-left:auto}:where(.ag-rtl) .ag-right-aligned-cell .ag-skeleton-effect{margin-right:auto}@keyframes ag-skeleton-loading{0%{background-color:var(--ag-row-loading-skeleton-effect-color)}50%{background-color:color-mix(in srgb,transparent,var(--ag-row-loading-skeleton-effect-color) 40%)}to{background-color:var(--ag-row-loading-skeleton-effect-color)}}.ag-loading{align-items:center;display:flex;height:100%}:where(.ag-ltr) .ag-loading{padding-left:var(--ag-cell-horizontal-padding)}:where(.ag-rtl) .ag-loading{padding-right:var(--ag-cell-horizontal-padding)}:where(.ag-ltr) .ag-loading-icon{padding-right:var(--ag-cell-widget-spacing)}:where(.ag-rtl) .ag-loading-icon{padding-left:var(--ag-cell-widget-spacing)}.ag-icon-loading{animation-duration:1s;animation-iteration-count:infinite;animation-name:spin;animation-timing-function:linear}@keyframes spin{0%{transform:rotate(0deg)}to{transform:rotate(1turn)}}.ag-input-wrapper,.ag-picker-field-wrapper{align-items:center;display:flex;flex:1 1 auto;line-height:normal;position:relative}.ag-input-field{align-items:center;display:flex;flex-direction:row}.ag-input-field-input:where(:not([type=checkbox],[type=radio])){flex:1 1 auto;min-width:0;width:100%}.ag-header{background-color:var(--ag-header-background-color);border-bottom:var(--ag-header-row-border);color:var(--ag-header-text-color);display:flex;font-family:var(--ag-header-font-family);font-size:var(--ag-header-font-size);font-weight:var(--ag-header-font-weight);overflow:hidden;white-space:nowrap;width:100%}.ag-header-row{height:var(--ag-header-height);position:absolute}.ag-floating-filter-button-button,.ag-header-cell-filter-button,.ag-header-cell-menu-button,.ag-header-expand-icon,.ag-panel-title-bar-button,:where(.ag-header-cell-sortable) .ag-header-cell-label{cursor:pointer}:where(.ag-ltr) .ag-header-expand-icon{margin-left:4px}:where(.ag-rtl) .ag-header-expand-icon{margin-right:4px}.ag-header-row:where(:not(:first-child)){:where(.ag-header-cell:not(.ag-header-span-height.ag-header-span-total,.ag-header-parent-hidden),.ag-header-group-cell.ag-header-group-cell-with-group){border-top:var(--ag-header-row-border)}}.ag-header-row:where(:not(.ag-header-row-column-group)){overflow:hidden}:where(.ag-header.ag-header-allow-overflow) .ag-header-row{overflow:visible}.ag-header-cell{display:inline-flex;overflow:hidden}.ag-header-group-cell{contain:paint;display:flex}.ag-header-cell,.ag-header-group-cell{align-items:center;gap:var(--ag-cell-widget-spacing);height:100%;padding:0 var(--ag-cell-horizontal-padding);position:absolute}@property --ag-internal-moving-color{syntax:"<color>";inherits:false;initial-value:transparent}@property --ag-internal-hover-color{syntax:"<color>";inherits:false;initial-value:transparent}.ag-header-cell:where(:not(.ag-floating-filter)),.ag-header-group-cell{&:before{background-image:linear-gradient(var(--ag-internal-hover-color),var(--ag-internal-hover-color)),linear-gradient(var(--ag-internal-moving-color),var(--ag-internal-moving-color));content:"";inset:0;position:absolute;--ag-internal-moving-color:transparent;--ag-internal-hover-color:transparent;transition:--ag-internal-moving-color var(--ag-header-cell-background-transition-duration),--ag-internal-hover-color var(--ag-header-cell-background-transition-duration)}&:where(:hover):before{--ag-internal-hover-color:var(--ag-header-cell-hover-background-color)}&:where(.ag-header-cell-moving):before{--ag-internal-moving-color:var(--ag-header-cell-moving-background-color);--ag-internal-hover-color:var(--ag-header-cell-hover-background-color)}}:where(.ag-header-cell:not(.ag-floating-filter) *,.ag-header-group-cell *){position:relative;z-index:1}.ag-header-cell-menu-button:where(:not(.ag-header-menu-always-show)){opacity:0;transition:opacity .2s}.ag-header-cell-filter-button,:where(.ag-header-cell.ag-header-active) .ag-header-cell-menu-button{opacity:1}.ag-header-cell-label,.ag-header-group-cell-label{align-items:center;align-self:stretch;display:flex;flex:1 1 auto;overflow:hidden;padding:5px 0}:where(.ag-ltr) .ag-sort-indicator-icon{padding-left:var(--ag-spacing)}:where(.ag-rtl) .ag-sort-indicator-icon{padding-right:var(--ag-spacing)}.ag-header-cell-label{text-overflow:ellipsis}.ag-header-group-cell-label.ag-sticky-label{flex:none;max-width:100%;overflow:visible;position:sticky}:where(.ag-ltr) .ag-header-group-cell-label.ag-sticky-label{left:var(--ag-cell-horizontal-padding)}:where(.ag-rtl) .ag-header-group-cell-label.ag-sticky-label{right:var(--ag-cell-horizontal-padding)}.ag-header-cell-text,.ag-header-group-text{overflow:hidden;text-overflow:ellipsis}.ag-header-cell-text{word-break:break-word}.ag-header-cell-comp-wrapper{width:100%}:where(.ag-header-group-cell) .ag-header-cell-comp-wrapper{display:flex}:where(.ag-header-cell:not(.ag-header-cell-auto-height)) .ag-header-cell-comp-wrapper{align-items:center;display:flex;height:100%}.ag-header-cell-wrap-text .ag-header-cell-comp-wrapper{white-space:normal}.ag-header-cell-comp-wrapper-limited-height>*{overflow:hidden}:where(.ag-right-aligned-header) .ag-header-cell-label{flex-direction:row-reverse}:where(.ag-ltr) :where(.ag-header-cell:not(.ag-right-aligned-header)){.ag-header-label-icon,.ag-header-menu-icon{margin-left:var(--ag-spacing)}}:where(.ag-rtl) :where(.ag-header-cell:not(.ag-right-aligned-header)){.ag-header-label-icon,.ag-header-menu-icon{margin-right:var(--ag-spacing)}}:where(.ag-ltr) :where(.ag-header-cell.ag-right-aligned-header){.ag-header-label-icon,.ag-header-menu-icon{margin-right:var(--ag-spacing)}}:where(.ag-rtl) :where(.ag-header-cell.ag-right-aligned-header){.ag-header-label-icon,.ag-header-menu-icon{margin-left:var(--ag-spacing)}}.ag-header-cell:after,.ag-header-group-cell:where(:not(.ag-header-span-height.ag-header-group-cell-no-group)):after{content:"";height:var(--ag-header-column-border-height);position:absolute;top:calc(50% - var(--ag-header-column-border-height)*.5);z-index:1}:where(.ag-ltr) .ag-header-cell:after,:where(.ag-ltr) .ag-header-group-cell:where(:not(.ag-header-span-height.ag-header-group-cell-no-group)):after{border-right:var(--ag-header-column-border);right:0}:where(.ag-rtl) .ag-header-cell:after,:where(.ag-rtl) .ag-header-group-cell:where(:not(.ag-header-span-height.ag-header-group-cell-no-group)):after{border-left:var(--ag-header-column-border);left:0}.ag-header-highlight-after:after,.ag-header-highlight-before:after{background-color:var(--ag-accent-color);content:"";height:100%;position:absolute;width:1px}:where(.ag-ltr) .ag-header-highlight-before:after{left:0}:where(.ag-rtl) .ag-header-highlight-before:after{right:0}:where(.ag-ltr) .ag-header-highlight-after:after{right:0;:where(.ag-pinned-left-header) &{right:1px}}:where(.ag-rtl) .ag-header-highlight-after:after{left:0;:where(.ag-pinned-left-header) &{left:1px}}.ag-header-cell-resize{align-items:center;cursor:ew-resize;display:flex;height:100%;position:absolute;top:0;width:8px;z-index:2;&:after{background-color:var(--ag-header-column-resize-handle-color);content:"";height:var(--ag-header-column-resize-handle-height);position:absolute;top:calc(50% - var(--ag-header-column-resize-handle-height)*.5);width:var(--ag-header-column-resize-handle-width);z-index:1}}:where(.ag-ltr) .ag-header-cell-resize{right:-3px;&:after{left:calc(50% - var(--ag-header-column-resize-handle-width))}}:where(.ag-rtl) .ag-header-cell-resize{left:-3px;&:after{right:calc(50% - var(--ag-header-column-resize-handle-width))}}:where(.ag-header-cell.ag-header-span-height) .ag-header-cell-resize:after{height:calc(100% - var(--ag-spacing)*4);top:calc(var(--ag-spacing)*2)}.ag-header-group-cell-no-group:where(.ag-header-span-height){display:none}.ag-sort-indicator-container{display:flex;gap:var(--ag-spacing)}.ag-layout-print{&.ag-body{display:block;height:unset}&.ag-root-wrapper{display:inline-block}.ag-body-horizontal-scroll,.ag-body-vertical-scroll{display:none}&.ag-force-vertical-scroll{overflow-y:visible!important}}@media print{.ag-root-wrapper.ag-layout-print{display:table;.ag-body-horizontal-scroll-viewport,.ag-body-viewport,.ag-center-cols-container,.ag-center-cols-viewport,.ag-root,.ag-root-wrapper-body,.ag-virtual-list-viewport{display:block!important;height:auto!important;overflow:hidden!important}.ag-cell,.ag-row{-moz-column-break-inside:avoid;break-inside:avoid}}}ag-grid,ag-grid-angular{display:block}.ag-chart,.ag-dnd-ghost,.ag-popup,.ag-root-wrapper{cursor:default;line-height:normal;white-space:normal;-webkit-font-smoothing:antialiased;background-color:var(--ag-background-color);color:var(--ag-text-color);color-scheme:var(--ag-browser-color-scheme);font-family:var(--ag-font-family);font-size:var(--ag-font-size);--ag-indentation-level:0}.ag-root-wrapper{border:var(--ag-wrapper-border);border-radius:var(--ag-wrapper-border-radius);display:flex;flex-direction:column;overflow:hidden;position:relative;&.ag-layout-normal{height:100%}}.ag-root-wrapper-body{display:flex;flex-direction:row;&.ag-layout-normal{flex:1 1 auto;height:0;min-height:0}}.ag-root{display:flex;flex-direction:column;position:relative;&.ag-layout-auto-height,&.ag-layout-normal{flex:1 1 auto;overflow:hidden;width:0}&.ag-layout-normal{height:100%}}.ag-list-item,.ag-virtual-list-item{height:var(--ag-list-item-height)}.ag-virtual-list-item{position:absolute;width:100%}.ag-select-list{background-color:var(--ag-picker-list-background-color);border:var(--ag-picker-list-border);border-radius:var(--ag-border-radius);box-shadow:var(--ag-dropdown-shadow);overflow:hidden auto}.ag-list-item{align-items:center;display:flex;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;&.ag-active-item{background-color:var(--ag-row-hover-color)}}.ag-select-list-item{cursor:default;-webkit-user-select:none;-moz-user-select:none;user-select:none;:where(span){overflow:hidden;text-overflow:ellipsis;white-space:nowrap}}:where(.ag-ltr) .ag-select-list-item{padding-left:calc(var(--ag-cell-horizontal-padding)/2)}:where(.ag-rtl) .ag-select-list-item{padding-right:calc(var(--ag-cell-horizontal-padding)/2)}.ag-list-item-hovered:after{background-color:var(--ag-accent-color);content:"";height:1px;left:0;position:absolute;right:0}.ag-item-highlight-top:after{top:0}.ag-item-highlight-bottom:after{bottom:0}:where(.ag-icon):before{align-items:center;background-color:currentcolor;color:inherit;content:"";display:flex;font-family:inherit;font-size:var(--ag-icon-size);font-style:normal;font-variant:normal;height:var(--ag-icon-size);justify-content:center;line-height:var(--ag-icon-size);-webkit-mask-size:contain;mask-size:contain;text-transform:none;width:var(--ag-icon-size)}.ag-icon{background-position:50%;background-repeat:no-repeat;background-size:contain;color:var(--ag-icon-color);display:block;height:var(--ag-icon-size);position:relative;-webkit-user-select:none;-moz-user-select:none;user-select:none;width:var(--ag-icon-size)}.ag-column-select-column-group-readonly,.ag-column-select-column-readonly,.ag-disabled,[disabled]{.ag-icon{opacity:.5}&.ag-icon-grip{opacity:.35}}.ag-column-select-column-readonly{&.ag-icon-grip,.ag-icon-grip{opacity:.35}}.ag-drag-handle{color:var(--ag-drag-handle-color);cursor:grab;:where(.ag-icon){color:var(--ag-drag-handle-color)}}.ag-chart-menu-icon,.ag-chart-settings-next,.ag-chart-settings-prev,.ag-column-group-icons,.ag-column-select-header-icon,.ag-filter-toolpanel-expand,.ag-floating-filter-button-button,.ag-group-title-bar-icon,.ag-header-cell-filter-button,.ag-header-cell-menu-button,.ag-header-expand-icon,.ag-panel-title-bar-button,.ag-panel-title-bar-button-icon,.ag-set-filter-group-icons,:where(.ag-group-contracted) .ag-icon,:where(.ag-group-expanded) .ag-icon{background-color:var(--ag-icon-button-background-color);border-radius:var(--ag-icon-button-border-radius);box-shadow:0 0 0 var(--ag-icon-button-background-spread) var(--ag-icon-button-background-color);color:var(--ag-icon-button-color);&:hover{background-color:var(--ag-icon-button-hover-background-color);box-shadow:0 0 0 var(--ag-icon-button-background-spread) var(--ag-icon-button-hover-background-color);color:var(--ag-icon-button-hover-color)}}.ag-filter-active{background-image:linear-gradient(var(--ag-icon-button-active-background-color),var(--ag-icon-button-active-background-color));border-radius:1px;outline:solid var(--ag-icon-button-background-spread) var(--ag-icon-button-active-background-color);position:relative;&:after{background-color:var(--ag-icon-button-active-indicator-color);border-radius:50%;content:"";height:6px;position:absolute;top:-1px;width:6px}:where(.ag-icon-filter){clip-path:path("M8,0C8,4.415 11.585,8 16,8L16,16L0,16L0,0L8,0Z");color:var(--ag-icon-button-active-color)}}:where(.ag-ltr) .ag-filter-active{&:after{right:-1px}}:where(.ag-rtl) .ag-filter-active{&:after{left:-1px}}.ag-menu{background-color:var(--ag-menu-background-color);border:var(--ag-menu-border);border-radius:var(--ag-border-radius);box-shadow:var(--ag-menu-shadow);color:var(--ag-menu-text-color);max-height:100%;overflow-y:auto}.ag-menu,.ag-resizer{position:absolute;-webkit-user-select:none;-moz-user-select:none;user-select:none}.ag-resizer{pointer-events:none;z-index:1}:where(.ag-resizer){&.ag-resizer-topLeft{cursor:nwse-resize;height:5px;left:0;top:0;width:5px}&.ag-resizer-top{cursor:ns-resize;height:5px;left:5px;right:5px;top:0}&.ag-resizer-topRight{cursor:nesw-resize;height:5px;right:0;top:0;width:5px}&.ag-resizer-right{bottom:5px;cursor:ew-resize;right:0;top:5px;width:5px}&.ag-resizer-bottomRight{bottom:0;cursor:nwse-resize;height:5px;right:0;width:5px}&.ag-resizer-bottom{bottom:0;cursor:ns-resize;height:5px;left:5px;right:5px}&.ag-resizer-bottomLeft{bottom:0;cursor:nesw-resize;height:5px;left:0;width:5px}&.ag-resizer-left{bottom:5px;cursor:ew-resize;left:0;top:5px;width:5px}}`
);

// packages/ag-grid-community/src/theming/inject.ts
var IS_SSR = typeof window !== "object" || !window?.document?.fonts?.forEach;
var _injectGlobalCSS = (css, styleContainer, debugId, layer, priority, nonce) => {
  if (IS_SSR)
    return;
  if (FORCE_LEGACY_THEMES)
    return;
  if (layer) {
    css = `@layer ${CSS.escape(layer)} { ${css} }`;
  }
  let injections = injectionState.map.get(styleContainer);
  if (!injections) {
    injections = [];
    injectionState.map.set(styleContainer, injections);
  }
  if (injections.find((i) => i.css === css))
    return;
  const el = document.createElement("style");
  if (nonce) {
    el.setAttribute("nonce", nonce);
  }
  el.dataset.agGlobalCss = debugId;
  el.textContent = css;
  const newInjection = { css, el, priority };
  let insertAfter;
  for (const injection of injections) {
    if (injection.priority > priority)
      break;
    insertAfter = injection;
  }
  if (insertAfter) {
    insertAfter.el.insertAdjacentElement("afterend", el);
    const index = injections.indexOf(insertAfter);
    injections.splice(index + 1, 0, newInjection);
  } else {
    styleContainer.insertBefore(el, styleContainer.querySelector(":not(title, meta)"));
    injections.push(newInjection);
  }
};
var _injectCoreAndModuleCSS = (styleContainer, layer, nonce) => {
  _injectGlobalCSS(coreCSS, styleContainer, "core", layer, 0, nonce);
  Array.from(_getAllRegisteredModules()).sort((a, b) => a.moduleName.localeCompare(b.moduleName)).forEach(
    (module2) => module2.css?.forEach(
      (css) => _injectGlobalCSS(css, styleContainer, `module-${module2.moduleName}`, layer, 0, nonce)
    )
  );
};
var _registerGridUsingThemingAPI = (environment) => {
  injectionState.grids.add(environment);
};
var _unregisterGridUsingThe