(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["agGrid"] = factory();
	else
		root["agGrid"] = factory();
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 72213:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Direction = void 0;
var Direction;
(function (Direction) {
    Direction[Direction["Vertical"] = 0] = "Vertical";
    Direction[Direction["Horizontal"] = 1] = "Horizontal";
})(Direction || (exports.Direction = Direction = {}));


/***/ }),

/***/ 59926:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KeyCode = void 0;
exports.KeyCode = {
    BACKSPACE: 'Backspace',
    TAB: 'Tab',
    ENTER: 'Enter',
    ESCAPE: 'Escape',
    SPACE: ' ',
    LEFT: 'ArrowLeft',
    UP: 'ArrowUp',
    RIGHT: 'ArrowRight',
    DOWN: 'ArrowDown',
    DELETE: 'Delete',
    F2: 'F2',
    PAGE_UP: 'PageUp',
    PAGE_DOWN: 'PageDown',
    PAGE_HOME: 'Home',
    PAGE_END: 'End',
    // these should be used with `event.code` instead of `event.key`
    // as `event.key` changes when non-latin keyboards are used
    A: 'KeyA',
    C: 'KeyC',
    D: 'KeyD',
    V: 'KeyV',
    X: 'KeyX',
    Y: 'KeyY',
    Z: 'KeyZ',
};


/***/ }),

/***/ 74856:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgBeanStub = void 0;
const localEventService_1 = __webpack_require__(19378);
const event_1 = __webpack_require__(7356);
const locale_1 = __webpack_require__(66352);
class AgBeanStub {
    constructor() {
        this.destroyFunctions = [];
        this.destroyed = false;
        // for vue 3 - prevents Vue from trying to make this (and obviously any sub classes) from being reactive
        // prevents vue from creating proxies for created objects and prevents identity related issues
        this.__v_skip = true;
        this.propertyListenerId = 0;
        // Enable multiple grid properties to be updated together by the user but only trigger shared logic once.
        // Closely related to logic in GridOptionsUtils.ts _processOnChange
        this.lastChangeSetIdLookup = {};
        this.isAlive = () => !this.destroyed;
    }
    preWireBeans(beans) {
        this.beans = beans;
        this.stubContext = beans.context;
        this.eventSvc = beans.eventSvc;
        this.gos = beans.gos;
    }
    // this was a test constructor niall built, when active, it prints after 5 seconds all beans/components that are
    // not destroyed. to use, create a new grid, then api.destroy() before 5 seconds. then anything that gets printed
    // points to a bean or component that was not properly disposed of.
    // constructor() {
    //     setTimeout(()=> {
    //         if (this.isAlive()) {
    //             let prototype: any = Object.getPrototypeOf(this);
    //             const constructor: any = prototype.constructor;
    //             const constructorString = constructor.toString();
    //             const beanName = constructorString.substring(9, constructorString.indexOf("("));
    //             console.log('is alive ' + beanName);
    //         }
    //     }, 5000);
    // }
    destroy() {
        const { destroyFunctions } = this;
        for (let i = 0; i < destroyFunctions.length; i++) {
            destroyFunctions[i]();
        }
        destroyFunctions.length = 0;
        this.destroyed = true;
        // cast destroy type as we do not want to expose destroy event type to the dispatchLocalEvent method
        // as no one else should be firing destroyed at the bean stub.
        this.dispatchLocalEvent({ type: 'destroyed' });
    }
    /** Add a local event listener against this BeanStub */
    addEventListener(eventType, listener, async) {
        if (!this.localEventService) {
            this.localEventService = new localEventService_1.LocalEventService();
        }
        this.localEventService.addEventListener(eventType, listener, async);
    }
    /** Remove a local event listener from this BeanStub */
    removeEventListener(eventType, listener, async) {
        this.localEventService?.removeEventListener(eventType, listener, async);
    }
    dispatchLocalEvent(event) {
        this.localEventService?.dispatchEvent(event);
    }
    addManagedElementListeners(object, handlers) {
        return this._setupListeners(object, handlers);
    }
    addManagedEventListeners(handlers) {
        return this._setupListeners(this.eventSvc, handlers);
    }
    addManagedListeners(object, handlers) {
        return this._setupListeners(object, handlers);
    }
    _setupListeners(object, handlers) {
        const destroyFuncs = [];
        for (const k of Object.keys(handlers)) {
            const handler = handlers[k];
            if (handler) {
                destroyFuncs.push(this._setupListener(object, k, handler));
            }
        }
        return destroyFuncs;
    }
    _setupListener(object, event, listener) {
        if (this.destroyed) {
            return () => null;
        }
        let destroyFunc;
        if (isAgEventEmitter(object)) {
            object.__addEventListener(event, listener);
            destroyFunc = () => {
                object.__removeEventListener(event, listener);
                return null;
            };
        }
        else {
            const objIsEventService = isEventService(object);
            if (object instanceof HTMLElement) {
                (0, event_1._addSafePassiveEventListener)(object, event, listener);
            }
            else if (objIsEventService) {
                object.addListener(event, listener);
            }
            else {
                object.addEventListener(event, listener);
            }
            destroyFunc = objIsEventService
                ? () => {
                    object.removeListener(event, listener);
                    return null;
                }
                : () => {
                    object.removeEventListener(event, listener);
                    return null;
                };
        }
        this.destroyFunctions.push(destroyFunc);
        return () => {
            destroyFunc();
            // Only remove if manually called before bean is destroyed
            this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
            return null;
        };
    }
    /**
     * Setup a managed property listener for the given property.
     * However, stores the destroy function in the beanStub so that if this bean
     * is a component the destroy function will be called when the component is destroyed
     * as opposed to being cleaned up only when the properties service is destroyed.
     */
    setupPropertyListener(event, listener) {
        const { gos } = this;
        gos.addPropertyEventListener(event, listener);
        const destroyFunc = () => {
            gos.removePropertyEventListener(event, listener);
            return null;
        };
        this.destroyFunctions.push(destroyFunc);
        return () => {
            destroyFunc();
            // Only remove if manually called before bean is destroyed
            this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
            return null;
        };
    }
    /**
     * Setup a managed property listener for the given GridOption property.
     * @param event GridOption property to listen to changes for.
     * @param listener Listener to run when property value changes
     */
    addManagedPropertyListener(event, listener) {
        if (this.destroyed) {
            return () => null;
        }
        return this.setupPropertyListener(event, listener);
    }
    /**
     * Setup managed property listeners for the given set of GridOption properties.
     * The listener will be run if any of the property changes but will only run once if
     * multiple of the properties change within the same framework lifecycle event.
     * Works on the basis that GridOptionsService updates all properties *before* any property change events are fired.
     * @param events Array of GridOption properties to listen for changes too.
     * @param listener Shared listener to run if any of the properties change
     */
    addManagedPropertyListeners(events, listener) {
        if (this.destroyed) {
            return;
        }
        // Ensure each set of events can run for the same changeSetId
        const eventsKey = events.join('-') + this.propertyListenerId++;
        const wrappedListener = (event) => {
            if (event.changeSet) {
                // ChangeSet is only set when the property change is part of a group of changes from ComponentUtils
                // Direct api calls should always be run as
                if (event.changeSet && event.changeSet.id === this.lastChangeSetIdLookup[eventsKey]) {
                    // Already run the listener for this set of prop changes so don't run again
                    return;
                }
                this.lastChangeSetIdLookup[eventsKey] = event.changeSet.id;
            }
            // Don't expose the underlying event value changes to the group listener.
            const propertiesChangeEvent = {
                type: 'propertyChanged',
                changeSet: event.changeSet,
                source: event.source,
            };
            listener(propertiesChangeEvent);
        };
        events.forEach((event) => this.setupPropertyListener(event, wrappedListener));
    }
    getLocaleTextFunc() {
        return (0, locale_1._getLocaleTextFunc)(this.beans.localeSvc);
    }
    addDestroyFunc(func) {
        // if we are already destroyed, we execute the func now
        if (this.isAlive()) {
            this.destroyFunctions.push(func);
        }
        else {
            func();
        }
    }
    /** doesn't throw an error if `bean` is undefined */
    createOptionalManagedBean(bean, context) {
        return bean ? this.createManagedBean(bean, context) : undefined;
    }
    createManagedBean(bean, context) {
        const res = this.createBean(bean, context);
        this.addDestroyFunc(this.destroyBean.bind(this, bean, context));
        return res;
    }
    createBean(bean, context, afterPreCreateCallback) {
        return (context || this.stubContext).createBean(bean, afterPreCreateCallback);
    }
    /**
     * Destroys a bean and returns undefined to support destruction and clean up in a single line.
     * this.dateComp = this.context.destroyBean(this.dateComp);
     */
    destroyBean(bean, context) {
        return (context || this.stubContext).destroyBean(bean);
    }
    /**
     * Destroys an array of beans and returns an empty array to support destruction and clean up in a single line.
     * this.dateComps = this.context.destroyBeans(this.dateComps);
     */
    destroyBeans(beans, context) {
        return (context || this.stubContext).destroyBeans(beans);
    }
}
exports.AgBeanStub = AgBeanStub;
// type guard for IAgEventEmitter
function isAgEventEmitter(object) {
    return object.__addEventListener !== undefined;
}
function isEventService(object) {
    return object.eventServiceType === 'global';
}


/***/ }),

/***/ 7047:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgComponentStub = void 0;
const agComponent_1 = __webpack_require__(91668);
const dom_1 = __webpack_require__(1956);
const agBeanStub_1 = __webpack_require__(74856);
const cssClassManager_1 = __webpack_require__(72872);
let compIdSequence = 0;
class AgComponentStub extends agBeanStub_1.AgBeanStub {
    constructor(templateOrParams, componentSelectors) {
        super();
        this.suppressDataRefValidation = false;
        // if false, then CSS class "ag-hidden" is applied, which sets "display: none"
        this.displayed = true;
        // if false, then CSS class "ag-invisible" is applied, which sets "visibility: hidden"
        this.visible = true;
        // unique id for this row component. this is used for getting a reference to the HTML dom.
        // we cannot use the RowNode id as this is not unique (due to animation, old rows can be lying
        // around as we create a new rowComp instance for the same row node).
        this.compId = compIdSequence++;
        this.cssManager = new cssClassManager_1.CssClassManager(() => this.eGui);
        this.componentSelectors = new Map((componentSelectors ?? []).map((comp) => [comp.selector, comp]));
        if (templateOrParams) {
            this.setTemplate(templateOrParams);
        }
    }
    preConstruct() {
        this.wireTemplate(this.getGui());
        const debugId = 'component-' + Object.getPrototypeOf(this)?.constructor?.name;
        this.css?.forEach((css) => this.beans.environment.addGlobalCSS(css, debugId));
    }
    wireTemplate(element, paramsMap) {
        // ui exists if user sets template in constructor. when this happens,
        // We have to wait for the context to be autoWired first before we can create child components.
        if (element && this.gos) {
            this.applyElementsToComponent(element);
            this.createChildComponentsFromTags(element, paramsMap);
        }
    }
    getCompId() {
        return this.compId;
    }
    getDataRefAttribute(element) {
        if (element.getAttribute) {
            return element.getAttribute(dom_1.DataRefAttribute);
        }
        // Plain text nodes don't have attributes or getAttribute method
        return null;
    }
    applyElementsToComponent(element, elementRef, paramsMap, newComponent = null) {
        if (elementRef === undefined) {
            elementRef = this.getDataRefAttribute(element);
        }
        if (elementRef) {
            // We store the reference to the element in the parent component under that same name
            // if there is a placeholder property with the same name.
            const current = this[elementRef];
            if (current === agComponent_1.RefPlaceholder) {
                this[elementRef] = newComponent ?? element;
            }
            else {
                // Don't warn if the data-ref is used for passing parameters to the component
                const usedAsParamRef = paramsMap && paramsMap[elementRef];
                if (!this.suppressDataRefValidation && !usedAsParamRef) {
                    // This can happen because of:
                    // 1. The data-ref has a typo and doesn't match the property in the component
                    // 2. The  property is not initialised with the RefPlaceholder and should be.
                    // 3. The property is on a child component and not available on the parent during construction.
                    //    In which case you may need to pass the template via setTemplate() instead of in the super constructor.
                    // 4. The data-ref is not used by the component and should be removed from the template.
                    throw new Error(`data-ref: ${elementRef} on ${this.constructor.name} with ${current}`);
                }
            }
        }
    }
    // for registered components only, eg creates AgCheckbox instance from ag-checkbox HTML tag
    createChildComponentsFromTags(parentNode, paramsMap) {
        // we MUST take a copy of the list first, as the 'swapComponentForNode' adds comments into the DOM
        // which messes up the traversal order of the children.
        const childNodeList = [];
        for (const childNode of parentNode.childNodes ?? []) {
            childNodeList.push(childNode);
        }
        childNodeList.forEach((childNode) => {
            if (!(childNode instanceof HTMLElement)) {
                return;
            }
            const childComp = this.createComponentFromElement(childNode, (childComp) => {
                // copy over all attributes, including css classes, so any attributes user put on the tag
                // wll be carried across
                const childGui = childComp.getGui();
                if (childGui) {
                    for (const attr of childNode.attributes ?? []) {
                        childGui.setAttribute(attr.name, attr.value);
                    }
                }
            }, paramsMap);
            if (childComp) {
                if (childComp.addItems && childNode.children.length) {
                    this.createChildComponentsFromTags(childNode, paramsMap);
                    // converting from HTMLCollection to Array
                    const items = Array.prototype.slice.call(childNode.children);
                    childComp.addItems(items);
                }
                // replace the tag (eg ag-checkbox) with the proper HTMLElement (eg 'div') in the dom
                this.swapComponentForNode(childComp, parentNode, childNode);
            }
            else if (childNode.childNodes) {
                this.createChildComponentsFromTags(childNode, paramsMap);
            }
        });
    }
    createComponentFromElement(element, afterPreCreateCallback, paramsMap) {
        const key = element.nodeName;
        const elementRef = this.getDataRefAttribute(element);
        const isAgGridComponent = key.indexOf('AG-') === 0;
        const componentSelector = isAgGridComponent ? this.componentSelectors.get(key) : null;
        let newComponent = null;
        if (componentSelector) {
            const componentParams = paramsMap && elementRef ? paramsMap[elementRef] : undefined;
            newComponent = new componentSelector.component(componentParams);
            newComponent.setParentComponent(this);
            this.createBean(newComponent, null, afterPreCreateCallback);
        }
        else if (isAgGridComponent) {
            throw new Error(`selector: ${key}`);
        }
        this.applyElementsToComponent(element, elementRef, paramsMap, newComponent);
        return newComponent;
    }
    swapComponentForNode(newComponent, parentNode, childNode) {
        const eComponent = newComponent.getGui();
        parentNode.replaceChild(eComponent, childNode);
        parentNode.insertBefore(document.createComment(childNode.nodeName), eComponent);
        this.addDestroyFunc(this.destroyBean.bind(this, newComponent));
    }
    activateTabIndex(elements) {
        const tabIndex = this.gos.get('tabIndex');
        if (!elements) {
            elements = [];
        }
        if (!elements.length) {
            elements.push(this.getGui());
        }
        elements.forEach((el) => el.setAttribute('tabindex', tabIndex.toString()));
    }
    setTemplate(templateOrParams, componentSelectors, paramsMap) {
        let eGui;
        if (typeof templateOrParams === 'string' || templateOrParams == null) {
            eGui = (0, dom_1._loadTemplate)(templateOrParams);
        }
        else {
            eGui = (0, dom_1._createAgElement)(templateOrParams);
        }
        this.setTemplateFromElement(eGui, componentSelectors, paramsMap);
    }
    setTemplateFromElement(element, components, paramsMap, suppressDataRefValidation = false) {
        this.eGui = element;
        this.suppressDataRefValidation = suppressDataRefValidation;
        if (components) {
            for (let i = 0; i < components.length; i++) {
                const component = components[i];
                this.componentSelectors.set(component.selector, component);
            }
        }
        this.wireTemplate(element, paramsMap);
    }
    getGui() {
        return this.eGui;
    }
    getFocusableElement() {
        return this.eGui;
    }
    getAriaElement() {
        return this.getFocusableElement();
    }
    setParentComponent(component) {
        this.parentComponent = component;
    }
    getParentComponent() {
        return this.parentComponent;
    }
    // this method is for older code, that wants to provide the gui element,
    // it is not intended for this to be in ag-Stack
    setGui(eGui) {
        this.eGui = eGui;
    }
    queryForHtmlElement(cssSelector) {
        return this.eGui.querySelector(cssSelector);
    }
    getContainerAndElement(newChild, container) {
        let parent = container;
        if (newChild == null) {
            return null;
        }
        if (!parent) {
            parent = this.eGui;
        }
        if ((0, dom_1._isNodeOrElement)(newChild)) {
            return {
                element: newChild,
                parent,
            };
        }
        return {
            element: newChild.getGui(),
            parent,
        };
    }
    prependChild(newChild, container) {
        const { element, parent } = this.getContainerAndElement(newChild, container) || {};
        if (!element || !parent) {
            return;
        }
        parent.insertAdjacentElement('afterbegin', element);
    }
    appendChild(newChild, container) {
        const { element, parent } = this.getContainerAndElement(newChild, container) || {};
        if (!element || !parent) {
            return;
        }
        parent.appendChild(element);
    }
    isDisplayed() {
        return this.displayed;
    }
    setVisible(visible, options = {}) {
        if (visible !== this.visible) {
            this.visible = visible;
            const { skipAriaHidden } = options;
            (0, dom_1._setVisible)(this.eGui, visible, { skipAriaHidden });
        }
    }
    setDisplayed(displayed, options = {}) {
        if (displayed !== this.displayed) {
            this.displayed = displayed;
            const { skipAriaHidden } = options;
            (0, dom_1._setDisplayed)(this.eGui, displayed, { skipAriaHidden });
            const event = {
                type: 'displayChanged',
                visible: this.displayed,
            };
            this.dispatchLocalEvent(event);
        }
    }
    destroy() {
        if (this.parentComponent) {
            this.parentComponent = undefined;
        }
        super.destroy();
    }
    addGuiEventListener(event, listener, options) {
        this.eGui.addEventListener(event, listener, options);
        this.addDestroyFunc(() => this.eGui.removeEventListener(event, listener));
    }
    addCss(className) {
        this.cssManager.toggleCss(className, true);
    }
    removeCss(className) {
        this.cssManager.toggleCss(className, false);
    }
    toggleCss(className, addOrRemove) {
        this.cssManager.toggleCss(className, addOrRemove);
    }
    registerCSS(css) {
        this.css || (this.css = []);
        this.css.push(css);
    }
}
exports.AgComponentStub = AgComponentStub;


/***/ }),

/***/ 61215:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgContext = void 0;
/** Instance Id used by React to reset the state of a component tree when the context changes. */
let contextId = 1;
class AgContext {
    constructor(params) {
        this.beans = {};
        this.createdBeans = [];
        this.destroyed = false;
        this.instanceId = contextId++;
        if (!params || !params.beanClasses) {
            return;
        }
        this.beanDestroyComparator = params.beanDestroyComparator;
        this.init(params);
    }
    init(params) {
        this.id = params.id;
        this.beans.context = this;
        this.destroyCallback = params.destroyCallback;
        for (const beanName of Object.keys(params.providedBeanInstances)) {
            this.beans[beanName] = params.providedBeanInstances[beanName];
        }
        params.beanClasses.forEach((BeanClass) => {
            const instance = new BeanClass();
            if (instance.beanName) {
                this.beans[instance.beanName] = instance;
            }
            else {
                // eslint-disable-next-line no-console
                console.error(`Bean ${BeanClass.name} is missing beanName`);
            }
            this.createdBeans.push(instance);
        });
        params.derivedBeans?.forEach((beanFunc) => {
            const { beanName, bean } = beanFunc(this);
            this.beans[beanName] = bean;
            this.createdBeans.push(bean);
        });
        if (params.beanInitComparator) {
            // sort the beans so that they are in a consistent order
            this.createdBeans.sort(params.beanInitComparator);
        }
        this.initBeans(this.createdBeans);
    }
    getBeanInstances() {
        return Object.values(this.beans);
    }
    createBean(bean, afterPreCreateCallback) {
        this.initBeans([bean], afterPreCreateCallback);
        return bean;
    }
    initBeans(beanInstances, afterPreCreateCallback) {
        const beans = this.beans;
        beanInstances.forEach((instance) => {
            // used to avoid the need for calling super.wireBeans() in every subclasses
            instance.preWireBeans?.(beans);
            instance.wireBeans?.(beans);
        });
        // used by the component class
        beanInstances.forEach((instance) => instance.preConstruct?.());
        if (afterPreCreateCallback) {
            beanInstances.forEach(afterPreCreateCallback);
        }
        beanInstances.forEach((instance) => instance.postConstruct?.());
    }
    getBeans() {
        return this.beans;
    }
    getBean(name) {
        return this.beans[name];
    }
    getId() {
        return this.id;
    }
    destroy() {
        if (this.destroyed) {
            return;
        }
        // Set before doing the destroy, so if context.destroy() gets called via another bean
        // we are marked as destroyed already to prevent running destroy() twice
        this.destroyed = true;
        const beanInstances = this.getBeanInstances();
        if (this.beanDestroyComparator) {
            beanInstances.sort(this.beanDestroyComparator);
        }
        this.destroyBeans(beanInstances);
        this.beans = {};
        this.createdBeans = [];
        this.destroyCallback?.();
    }
    /**
     * Destroys a bean and returns undefined to support destruction and clean up in a single line.
     * this.dateComp = this.context.destroyBean(this.dateComp);
     */
    destroyBean(bean) {
        bean?.destroy?.();
    }
    /**
     * Destroys an array of beans and returns an empty array to support destruction and clean up in a single line.
     * this.dateComps = this.context.destroyBeans(this.dateComps);
     */
    destroyBeans(beans) {
        if (beans) {
            for (let i = 0; i < beans.length; i++) {
                this.destroyBean(beans[i]);
            }
        }
        return [];
    }
    isDestroyed() {
        return this.destroyed;
    }
}
exports.AgContext = AgContext;


/***/ }),

/***/ 54646:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseDragAndDropService = void 0;
const array_1 = __webpack_require__(79909);
const document_1 = __webpack_require__(80011);
const event_1 = __webpack_require__(7356);
const agBeanStub_1 = __webpack_require__(74856);
class BaseDragAndDropService extends agBeanStub_1.AgBeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'dragAndDrop';
        this.dragSourceAndParamsList = [];
        this.dragItem = null;
        this.lastMouseEvent = null;
        this.lastDraggingEvent = null;
        this.dragSource = null;
        this.dragImageParent = null;
        this.dragImageCompPromise = null;
        this.dragImageComp = null;
        this.dragImageLastIcon = undefined;
        this.dragImageLastLabel = undefined;
        this.dropTargets = [];
        this.lastDropTarget = null;
    }
    addDragSource(dragSource, allowTouch = false) {
        const entry = {
            dragSource,
            eElement: dragSource.eElement,
            dragStartPixels: dragSource.dragStartPixels,
            onDragStart: (mouseEvent) => this.onDragStart(dragSource, mouseEvent),
            onDragStop: this.onDragStop.bind(this),
            onDragging: this.onDragging.bind(this),
            onDragCancel: this.onDragCancel.bind(this),
            includeTouch: allowTouch,
        };
        this.dragSourceAndParamsList.push(entry);
        this.beans.dragSvc.addDragSource(entry);
    }
    setDragImageCompIcon(iconName, shake = false) {
        const component = this.dragImageComp;
        if (component && (shake || this.dragImageLastIcon !== iconName)) {
            this.dragImageLastIcon = iconName;
            component.setIcon(iconName, shake);
        }
    }
    removeDragSource(dragSource) {
        const { dragSourceAndParamsList, beans } = this;
        const sourceAndParams = dragSourceAndParamsList.find((item) => item.dragSource === dragSource);
        if (sourceAndParams) {
            beans.dragSvc?.removeDragSource(sourceAndParams);
            (0, array_1._removeFromArray)(dragSourceAndParamsList, sourceAndParams);
        }
    }
    destroy() {
        const { dragSourceAndParamsList, dropTargets, beans } = this;
        const dragSvc = beans.dragSvc;
        for (const sourceAndParams of dragSourceAndParamsList) {
            dragSvc?.removeDragSource(sourceAndParams);
        }
        dragSourceAndParamsList.length = 0;
        dropTargets.length = 0;
        this.clearDragAndDropProperties();
        super.destroy();
    }
    nudge() {
        const lastMouseEvent = this.lastMouseEvent;
        if (lastMouseEvent) {
            this.onDragging(lastMouseEvent, true);
        }
    }
    onDragStart(dragSource, mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.dragSource = dragSource;
        this.dragItem = dragSource.getDragItem();
        dragSource.onDragStarted?.();
        this.createAndUpdateDragImageComp(dragSource);
    }
    onDragStop(mouseEvent) {
        const { dragSource, lastDropTarget } = this;
        dragSource?.onDragStopped?.();
        if (lastDropTarget) {
            const dragEndEvent = this.dropTargetEvent(lastDropTarget, mouseEvent, false);
            lastDropTarget.onDragStop?.(dragEndEvent);
        }
        this.clearDragAndDropProperties();
    }
    onDragCancel() {
        const { dragSource, lastDropTarget, lastMouseEvent } = this;
        dragSource?.onDragCancelled?.();
        if (lastDropTarget && lastMouseEvent) {
            const dragCancelEvent = this.dropTargetEvent(lastDropTarget, lastMouseEvent, false);
            lastDropTarget.onDragCancel?.(dragCancelEvent);
        }
        this.clearDragAndDropProperties();
    }
    onDragging(mouseEvent, fromNudge = false) {
        this.positionDragImageComp(mouseEvent);
        // check if mouseEvent intersects with any of the drop targets
        const dropTarget = this.findCurrentDropTarget(mouseEvent);
        const { lastDropTarget, dragSource, dragItem } = this;
        let needUpdate = false;
        if (dropTarget !== lastDropTarget) {
            needUpdate = true;
            if (lastDropTarget) {
                const dragLeaveEvent = this.dropTargetEvent(lastDropTarget, mouseEvent, fromNudge);
                lastDropTarget.onDragLeave?.(dragLeaveEvent);
            }
            if (lastDropTarget !== null && !dropTarget) {
                this.handleExit(dragSource, dragItem);
            }
            else if (lastDropTarget === null && dropTarget) {
                this.handleEnter(dragSource, dragItem);
            }
            if (dropTarget) {
                const dragEnterEvent = this.dropTargetEvent(dropTarget, mouseEvent, fromNudge);
                dropTarget.onDragEnter?.(dragEnterEvent);
            }
            this.lastDropTarget = dropTarget;
        }
        else if (dropTarget) {
            const dragMoveEvent = this.dropTargetEvent(dropTarget, mouseEvent, fromNudge);
            dropTarget.onDragging?.(dragMoveEvent);
            if (dragMoveEvent?.changed) {
                needUpdate = true;
            }
        }
        this.lastMouseEvent = mouseEvent;
        if (needUpdate) {
            this.updateDragImageComp();
        }
    }
    clearDragAndDropProperties() {
        this.removeDragImageComp(this.dragImageComp);
        this.dragImageCompPromise = null;
        this.dragImageParent = null;
        this.dragImageLastIcon = undefined;
        this.dragImageLastLabel = undefined;
        this.lastMouseEvent = null;
        this.lastDraggingEvent = null;
        this.lastDropTarget = null;
        this.dragItem = null;
        this.dragSource = null;
    }
    getAllContainersFromDropTarget(dropTarget) {
        const secondaryContainers = dropTarget.getSecondaryContainers ? dropTarget.getSecondaryContainers() : null;
        const containers = [[dropTarget.getContainer()]];
        return secondaryContainers ? containers.concat(secondaryContainers) : containers;
    }
    // checks if the mouse is on the drop target. it checks eContainer and eSecondaryContainers
    isMouseOnDropTarget(mouseEvent, dropTarget) {
        const allContainersFromDropTarget = this.getAllContainersFromDropTarget(dropTarget);
        let mouseOverTarget = false;
        const allContainersIntersect = (mouseEvent, containers) => {
            for (const container of containers) {
                const { width, height, left, right, top, bottom } = container.getBoundingClientRect();
                // if element is not visible, then width and height are zero
                if (width === 0 || height === 0) {
                    return false;
                }
                const horizontalFit = mouseEvent.clientX >= left && mouseEvent.clientX < right;
                const verticalFit = mouseEvent.clientY >= top && mouseEvent.clientY < bottom;
                if (!horizontalFit || !verticalFit) {
                    return false;
                }
            }
            return true;
        };
        for (const currentContainers of allContainersFromDropTarget) {
            if (allContainersIntersect(mouseEvent, currentContainers)) {
                mouseOverTarget = true;
                break;
            }
        }
        const { eElement, type } = this.dragSource;
        if (dropTarget.targetContainsSource && !dropTarget.getContainer().contains(eElement)) {
            return false;
        }
        return mouseOverTarget && dropTarget.isInterestedIn(type, eElement);
    }
    findCurrentDropTarget(mouseEvent) {
        const validDropTargets = this.dropTargets.filter((target) => this.isMouseOnDropTarget(mouseEvent, target));
        const len = validDropTargets.length;
        if (len === 0) {
            return null;
        }
        if (len === 1) {
            return validDropTargets[0];
        }
        const rootNode = (0, document_1._getRootNode)(this.beans);
        // elementsFromPoint return a list of elements under
        // the mouseEvent sorted from topMost to bottomMost
        const elementStack = rootNode.elementsFromPoint(mouseEvent.clientX, mouseEvent.clientY);
        // loop over the sorted elementStack to find which dropTarget comes first
        for (const el of elementStack) {
            for (const dropTarget of validDropTargets) {
                const containers = this.getAllContainersFromDropTarget(dropTarget).flatMap((a) => a);
                if (containers.indexOf(el) !== -1) {
                    return dropTarget;
                }
            }
        }
        // we should never hit this point of the code because only
        // valid dropTargets should be provided to this method.
        return null;
    }
    addDropTarget(dropTarget) {
        this.dropTargets.push(dropTarget);
    }
    removeDropTarget(dropTarget) {
        this.dropTargets = this.dropTargets.filter((target) => target.getContainer() !== dropTarget.getContainer());
    }
    hasExternalDropZones() {
        return this.dropTargets.some((zones) => zones.external);
    }
    findExternalZone(container) {
        return this.dropTargets.find((zone) => zone.external && zone.getContainer() === container) || null;
    }
    dropTargetEvent(dropTarget, mouseEvent, fromNudge) {
        const { dragSource, dragItem, lastDraggingEvent, lastMouseEvent } = this;
        const dropZoneTarget = dropTarget.getContainer();
        const rect = dropZoneTarget.getBoundingClientRect();
        const { clientX, clientY } = mouseEvent;
        const xDir = clientX - (lastMouseEvent?.clientX || 0);
        const yDir = clientY - (lastMouseEvent?.clientY || 0);
        const draggingEvent = this.createEvent({
            event: mouseEvent,
            x: clientX - rect.left,
            y: clientY - rect.top,
            vDirection: yDir > 0 ? 'down' : yDir < 0 ? 'up' : null,
            hDirection: xDir < 0 ? 'left' : xDir > 0 ? 'right' : null,
            dragSource: dragSource,
            fromNudge,
            dragItem: dragItem,
            dropZoneTarget,
            dropTarget: lastDraggingEvent?.dropTarget ?? null,
            changed: !!lastDraggingEvent?.changed,
        });
        this.lastDraggingEvent = draggingEvent;
        return draggingEvent;
    }
    positionDragImageComp(event) {
        const gui = this.dragImageComp?.getGui();
        if (gui) {
            (0, event_1._anchorElementToMouseMoveEvent)(gui, event, this.beans);
        }
    }
    removeDragImageComp(comp) {
        if (this.dragImageComp === comp) {
            this.dragImageComp = null;
        }
        if (comp) {
            const eGui = comp.getGui();
            this.dragImageParent?.removeChild(eGui);
            this.destroyBean(comp);
        }
    }
    createAndUpdateDragImageComp(dragSource) {
        const promise = this.createDragImageComp(dragSource) ?? null;
        this.dragImageCompPromise = promise;
        promise?.then((dragImageComp) => {
            if (promise !== this.dragImageCompPromise || !this.lastMouseEvent || !this.isAlive()) {
                this.destroyBean(dragImageComp);
                return; // New promise was started, ignore this old one.
            }
            this.dragImageCompPromise = null;
            this.dragImageLastIcon = undefined;
            this.dragImageLastLabel = undefined;
            const oldDragImageComp = this.dragImageComp;
            if (oldDragImageComp !== dragImageComp) {
                this.dragImageComp = dragImageComp;
                this.removeDragImageComp(oldDragImageComp);
            }
            if (dragImageComp) {
                this.appendDragImageComp(dragImageComp);
                this.updateDragImageComp();
            }
        });
    }
    appendDragImageComp(component) {
        const eGui = component.getGui();
        const style = eGui.style;
        style.setProperty('position', 'absolute');
        style.setProperty('z-index', '9999');
        this.gos.setInstanceDomData(eGui);
        this.beans.environment.applyThemeClasses(eGui);
        style.top = '20px';
        style.left = '20px';
        const targetEl = (0, document_1._getPageBody)(this.beans);
        this.dragImageParent = targetEl;
        if (!targetEl) {
            this.warnNoBody();
        }
        else {
            targetEl.appendChild(eGui);
        }
    }
    updateDragImageComp() {
        const { dragImageComp, dragSource, lastDropTarget, lastDraggingEvent, dragImageLastLabel } = this;
        if (!dragImageComp) {
            return;
        }
        this.setDragImageCompIcon(lastDropTarget?.getIconName?.(lastDraggingEvent) ?? null);
        let label = dragSource?.dragItemName;
        if (typeof label === 'function') {
            label = label(lastDraggingEvent);
        }
        label || (label = '');
        if (dragImageLastLabel !== label) {
            this.dragImageLastLabel = label;
            dragImageComp.setLabel(label);
        }
    }
}
exports.BaseDragAndDropService = BaseDragAndDropService;


/***/ }),

/***/ 21726:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseDragService = void 0;
const keyCode_1 = __webpack_require__(59926);
const array_1 = __webpack_require__(79909);
const browser_1 = __webpack_require__(36916);
const document_1 = __webpack_require__(80011);
const dom_1 = __webpack_require__(1956);
const event_1 = __webpack_require__(7356);
const generic_1 = __webpack_require__(89097);
const agBeanStub_1 = __webpack_require__(74856);
class BaseDragService extends agBeanStub_1.AgBeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'dragSvc';
        this.dragEndFunctions = [];
        this.dragSources = [];
    }
    destroy() {
        const { dragSources } = this;
        dragSources.forEach(this.removeListener.bind(this));
        dragSources.length = 0;
        super.destroy();
    }
    removeListener(dragSourceAndListener) {
        const element = dragSourceAndListener.dragSource.eElement;
        const mouseDownListener = dragSourceAndListener.mouseDownListener;
        element.removeEventListener('mousedown', mouseDownListener);
        // remove touch listener only if it exists
        if (dragSourceAndListener.touchEnabled) {
            const touchStartListener = dragSourceAndListener.touchStartListener;
            element.removeEventListener('touchstart', touchStartListener, { passive: true });
        }
    }
    removeDragSource(params) {
        const { dragSources } = this;
        const dragSourceAndListener = dragSources.find((item) => item.dragSource === params);
        if (!dragSourceAndListener) {
            return;
        }
        this.removeListener(dragSourceAndListener);
        (0, array_1._removeFromArray)(dragSources, dragSourceAndListener);
    }
    addDragSource(params) {
        const mouseListener = this.onMouseDown.bind(this, params);
        const { eElement, includeTouch, stopPropagationForTouch } = params;
        eElement.addEventListener('mousedown', mouseListener);
        let touchListener = null;
        const suppressTouch = this.gos.get('suppressTouch');
        if (includeTouch && !suppressTouch) {
            touchListener = (touchEvent) => {
                if ((0, dom_1._isFocusableFormField)(touchEvent.target)) {
                    return;
                }
                if (stopPropagationForTouch) {
                    touchEvent.stopPropagation();
                }
                this.onTouchStart(params, touchEvent);
            };
            // we set passive=false, as we want to prevent default on this event
            eElement.addEventListener('touchstart', touchListener, { passive: false });
        }
        this.dragSources.push({
            dragSource: params,
            mouseDownListener: mouseListener,
            touchStartListener: touchListener,
            touchEnabled: !!includeTouch,
        });
    }
    // gets called whenever mouse down on any drag source
    onTouchStart(params, touchEvent) {
        this.currentDragParams = params;
        this.dragging = false;
        const touch = touchEvent.touches[0];
        this.touchLastTime = touch;
        this.touchStart = touch;
        const touchMoveEvent = (e) => this.onTouchMove(e, params.eElement);
        const touchEndEvent = (e) => this.onTouchUp(e, params.eElement);
        const documentTouchMove = (e) => {
            if (e.cancelable) {
                e.preventDefault();
            }
        };
        const target = touchEvent.target;
        const events = [
            // Prevents the page document from moving while we are dragging items around.
            // preventDefault needs to be called in the touchmove listener and never inside the
            // touchstart, because using touchstart causes the click event to be cancelled on touch devices.
            {
                target: (0, document_1._getRootNode)(this.beans),
                type: 'touchmove',
                listener: documentTouchMove,
                options: { passive: false },
            },
            { target, type: 'touchmove', listener: touchMoveEvent, options: { passive: true } },
            { target, type: 'touchend', listener: touchEndEvent, options: { passive: true } },
            { target, type: 'touchcancel', listener: touchEndEvent, options: { passive: true } },
        ];
        // temporally add these listeners, for the duration of the drag
        this.addTemporaryEvents(events);
        // see if we want to start dragging straight away
        if (params.dragStartPixels === 0) {
            this.onCommonMove(touch, this.touchStart, params.eElement);
        }
    }
    // gets called whenever mouse down on any drag source
    onMouseDown(params, mouseEvent) {
        const e = mouseEvent;
        if (params.skipMouseEvent && params.skipMouseEvent(mouseEvent)) {
            return;
        }
        // if there are two elements with parent / child relationship, and both are draggable,
        // when we drag the child, we should NOT drag the parent. an example of this is row moving
        // and range selection - row moving should get preference when use drags the rowDrag component.
        if (e._alreadyProcessedByDragService) {
            return;
        }
        e._alreadyProcessedByDragService = true;
        // only interested in left button clicks
        if (mouseEvent.button !== 0) {
            return;
        }
        if (this.shouldPreventMouseEvent(mouseEvent)) {
            mouseEvent.preventDefault();
        }
        this.currentDragParams = params;
        this.dragging = false;
        this.mouseStartEvent = mouseEvent;
        this.startTarget = mouseEvent.target;
        const mouseMoveEvent = (event) => this.onMouseMove(event, params.eElement);
        const mouseUpEvent = (event) => this.onMouseUp(event, params.eElement);
        const contextEvent = (event) => event.preventDefault();
        const keydownEvent = (event) => {
            if (event.key === keyCode_1.KeyCode.ESCAPE) {
                this.cancelDrag(params.eElement);
            }
        };
        const target = (0, document_1._getRootNode)(this.beans);
        const events = [
            { target, type: 'mousemove', listener: mouseMoveEvent },
            { target, type: 'mouseup', listener: mouseUpEvent },
            { target, type: 'contextmenu', listener: contextEvent },
            { target, type: 'keydown', listener: keydownEvent },
        ];
        // temporally add these listeners, for the duration of the drag
        this.addTemporaryEvents(events);
        //see if we want to start dragging straight away
        if (params.dragStartPixels === 0) {
            this.onMouseMove(mouseEvent, params.eElement);
        }
    }
    addTemporaryEvents(events) {
        events.forEach((currentEvent) => {
            const { target, type, listener, options } = currentEvent;
            target.addEventListener(type, listener, options);
        });
        this.dragEndFunctions.push(() => {
            events.forEach((currentEvent) => {
                const { target, type, listener, options } = currentEvent;
                target.removeEventListener(type, listener, options);
            });
        });
    }
    // returns true if the event is close to the original event by X pixels either vertically or horizontally.
    // we only start dragging after X pixels so this allows us to know if we should start dragging yet.
    isEventNearStartEvent(currentEvent, startEvent) {
        // by default, we wait 4 pixels before starting the drag
        const { dragStartPixels } = this.currentDragParams;
        const requiredPixelDiff = (0, generic_1._exists)(dragStartPixels) ? dragStartPixels : 4;
        return (0, event_1._areEventsNear)(currentEvent, startEvent, requiredPixelDiff);
    }
    getFirstActiveTouch(touchList) {
        for (let i = 0; i < touchList.length; i++) {
            if (touchList[i].identifier === this.touchStart.identifier) {
                return touchList[i];
            }
        }
        return null;
    }
    onCommonMove(currentEvent, startEvent, el) {
        if (!this.dragging) {
            // if mouse hasn't travelled from the start position enough, do nothing
            if (this.isEventNearStartEvent(currentEvent, startEvent)) {
                return;
            }
            this.dragging = true;
            this.eventSvc.dispatchEvent({
                type: 'dragStarted',
                target: el,
            });
            this.currentDragParams.onDragStart(startEvent);
            // we need ONE drag action at the startEvent, so that we are guaranteed the drop target
            // at the start gets notified. this is because the drag can start outside of the element
            // that started it, as the mouse is allowed drag away from the mouse down before it's
            // considered a drag (the isEventNearStartEvent() above). if we didn't do this, then
            // it would be possible to click a column by the edge, then drag outside of the drop zone
            // in less than 4 pixels and the drag officially starts outside of the header but the header
            // wouldn't be notified of the dragging.
            // if currentDragParams is null here, it means that drag has been cancelled.
            if (!this.currentDragParams) {
                this.dragging = false;
                return;
            }
            this.currentDragParams.onDragging(startEvent);
        }
        this.currentDragParams?.onDragging(currentEvent);
    }
    onTouchMove(touchEvent, el) {
        const touch = this.getFirstActiveTouch(touchEvent.touches);
        if (!touch) {
            return;
        }
        // this.___statusPanel.setInfoText(Math.random() + ' onTouchMove preventDefault stopPropagation');
        this.onCommonMove(touch, this.touchStart, el);
    }
    // only gets called after a mouse down - as this is only added after mouseDown
    // and is removed when mouseUp happens
    onMouseMove(mouseEvent, el) {
        if ((0, browser_1._isBrowserSafari)()) {
            const eDocument = (0, document_1._getDocument)(this.beans);
            eDocument.getSelection()?.removeAllRanges();
        }
        if (this.shouldPreventMouseEvent(mouseEvent)) {
            mouseEvent.preventDefault();
        }
        this.onCommonMove(mouseEvent, this.mouseStartEvent, el);
    }
    shouldPreventMouseEvent(mouseEvent) {
        const isMouseMove = mouseEvent.type === 'mousemove';
        const isOverFormFieldElement = (mouseEvent) => {
            const el = mouseEvent.target;
            const tagName = el?.tagName.toLocaleLowerCase();
            return !!tagName?.match('^a$|textarea|input|select|button');
        };
        return (isMouseMove &&
            mouseEvent.cancelable &&
            (0, event_1._isEventFromThisInstance)(this.beans, mouseEvent) &&
            !isOverFormFieldElement(mouseEvent));
    }
    onTouchUp(touchEvent, el) {
        let touch = this.getFirstActiveTouch(touchEvent.changedTouches);
        // i haven't worked this out yet, but there is no matching touch
        // when we get the touch up event. to get around this, we swap in
        // the last touch. this is a hack to 'get it working' while we
        // figure out what's going on, why we are not getting a touch in
        // current event.
        if (!touch) {
            touch = this.touchLastTime;
        }
        // if mouse was left up before we started to move, then this is a tap.
        // we check this before onUpCommon as onUpCommon resets the dragging
        // let tap = !this.dragging;
        // let tapTarget = this.currentDragParams.eElement;
        this.onUpCommon(touch, el);
        // if tap, tell user
        // console.log(`${Math.random()} tap = ${tap}`);
        // if (tap) {
        //     tapTarget.click();
        // }
    }
    onMouseUp(mouseEvent, el) {
        this.onUpCommon(mouseEvent, el);
    }
    onUpCommon(eventOrTouch, el) {
        if (this.dragging) {
            this.dragging = false;
            this.currentDragParams.onDragStop(eventOrTouch);
            this.eventSvc.dispatchEvent({
                type: 'dragStopped',
                target: el,
            });
        }
        this.resetDragProperties();
    }
    cancelDrag(el) {
        this.eventSvc.dispatchEvent({
            type: 'dragCancelled',
            target: el,
        });
        this.currentDragParams?.onDragCancel?.();
        this.resetDragProperties();
    }
    resetDragProperties() {
        this.mouseStartEvent = null;
        this.startTarget = null;
        this.touchStart = null;
        this.touchLastTime = null;
        this.currentDragParams = null;
        const { dragEndFunctions } = this;
        dragEndFunctions.forEach((func) => func());
        dragEndFunctions.length = 0;
    }
}
exports.BaseDragService = BaseDragService;


/***/ }),

/***/ 29758:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseEnvironment = void 0;
const inject_1 = __webpack_require__(10654);
const themeImpl_1 = __webpack_require__(71756);
const dom_1 = __webpack_require__(1956);
const agBeanStub_1 = __webpack_require__(74856);
let paramsId = 0;
class BaseEnvironment extends agBeanStub_1.AgBeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'environment';
        this.paramsClass = `ag-theme-params-${++paramsId}`;
        this.globalCSS = [];
    }
    wireBeans(beans) {
        this.eRootDiv = beans.eRootDiv;
    }
    postConstruct() {
        const { gos, eRootDiv } = this;
        gos.setInstanceDomData(eRootDiv);
        this.eStyleContainer =
            gos.get('themeStyleContainer') ?? (eRootDiv.getRootNode() === document ? document.head : eRootDiv);
        this.cssLayer = gos.get('themeCssLayer');
        this.styleNonce = gos.get('styleNonce');
        this.addManagedPropertyListener('theme', () => this.handleThemeChange());
        this.handleThemeChange();
        this.initVariables();
        this.addDestroyFunc(() => (0, inject_1._unregisterInstanceUsingThemingAPI)(this));
        this.mutationObserver = new MutationObserver(() => {
            this.fireStylesChangedEvent('themeChanged');
        });
        this.addDestroyFunc(() => this.mutationObserver.disconnect());
    }
    applyThemeClasses(el, extraClasses = []) {
        const { theme } = this;
        let themeClass;
        if (theme) {
            // Theming API mode
            themeClass = `${this.paramsClass} ${theme._getCssClass()}`;
        }
        else {
            themeClass = this.applyLegacyThemeClasses();
        }
        for (const className of Array.from(el.classList)) {
            if (className.startsWith('ag-theme-')) {
                el.classList.remove(className);
            }
        }
        if (themeClass) {
            const oldClass = el.className;
            el.className = `${oldClass}${oldClass ? ' ' : ''}${themeClass}${extraClasses?.length ? ` ${extraClasses.join(' ')}` : ''}`;
        }
    }
    applyLegacyThemeClasses() {
        let themeClass = '';
        this.mutationObserver.disconnect();
        let node = this.eRootDiv;
        while (node) {
            let isThemeEl = false;
            for (const className of Array.from(node.classList)) {
                if (className.startsWith('ag-theme-')) {
                    isThemeEl = true;
                    themeClass = themeClass ? `${themeClass} ${className}` : className;
                }
            }
            if (isThemeEl) {
                this.mutationObserver.observe(node, {
                    attributes: true,
                    attributeFilter: ['class'],
                });
            }
            node = node.parentElement;
        }
        return themeClass;
    }
    addGlobalCSS(css, debugId) {
        if (this.theme) {
            (0, inject_1._injectGlobalCSS)(css, this.eStyleContainer, debugId, this.cssLayer, 0, this.styleNonce);
        }
        else {
            this.globalCSS.push([css, debugId]);
        }
    }
    handleThemeChange() {
        const { gos, theme: oldTheme } = this;
        const themeProperty = gos.get('theme');
        let newTheme;
        if (themeProperty === 'legacy') {
            newTheme = undefined;
        }
        else {
            const themeOrDefault = themeProperty ?? this.getDefaultTheme();
            if (themeOrDefault instanceof themeImpl_1.ThemeImpl) {
                newTheme = themeOrDefault;
            }
            else {
                this.themeError(themeOrDefault);
            }
        }
        if (newTheme !== oldTheme) {
            this.handleNewTheme(newTheme);
        }
        this.postProcessThemeChange(newTheme, themeProperty);
    }
    handleNewTheme(newTheme) {
        const { gos, eRootDiv, globalCSS } = this;
        const additionalCss = this.getAdditionalCss();
        if (newTheme) {
            (0, inject_1._registerInstanceUsingThemingAPI)(this);
            (0, inject_1._injectCoreAndModuleCSS)(this.eStyleContainer, this.cssLayer, this.styleNonce, additionalCss);
            for (const [css, debugId] of globalCSS) {
                (0, inject_1._injectGlobalCSS)(css, this.eStyleContainer, debugId, this.cssLayer, 0, this.styleNonce);
            }
            globalCSS.length = 0;
        }
        this.theme = newTheme;
        newTheme?._startUse({
            loadThemeGoogleFonts: gos.get('loadThemeGoogleFonts'),
            styleContainer: this.eStyleContainer,
            cssLayer: this.cssLayer,
            nonce: this.styleNonce,
            moduleCss: additionalCss,
        });
        let eParamsStyle = this.eParamsStyle;
        if (!eParamsStyle) {
            eParamsStyle = this.eParamsStyle = (0, dom_1._createAgElement)({ tag: 'style' });
            const styleNonce = gos.get('styleNonce');
            if (styleNonce) {
                eParamsStyle.setAttribute('nonce', styleNonce);
            }
            eRootDiv.appendChild(eParamsStyle);
        }
        if (!inject_1.IS_SSR) {
            eParamsStyle.textContent = newTheme?._getPerInstanceCss(this.paramsClass) || '';
        }
        this.applyThemeClasses(eRootDiv);
        this.fireStylesChangedEvent('themeChanged');
    }
}
exports.BaseEnvironment = BaseEnvironment;


/***/ }),

/***/ 34232:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseRegistry = void 0;
const agBeanStub_1 = __webpack_require__(74856);
class BaseRegistry extends agBeanStub_1.AgBeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'registry';
    }
    registerDynamicBeans(dynamicBeans) {
        if (dynamicBeans) {
            // initialise the dynamic beans registry on first use
            this.dynamicBeans ?? (this.dynamicBeans = {});
            for (const name of Object.keys(dynamicBeans)) {
                this.dynamicBeans[name] = dynamicBeans[name];
            }
        }
    }
    createDynamicBean(name, mandatory, ...args) {
        if (!this.dynamicBeans) {
            // this happens when a module tries to init a dynamic bean during module initialization lifecycle
            throw new Error(this.getDynamicError(name, true));
        }
        const BeanClass = this.dynamicBeans[name];
        if (BeanClass == null) {
            if (mandatory) {
                throw new Error(this.getDynamicError(name, false));
            }
            return undefined;
        }
        return new BeanClass(...args);
    }
}
exports.BaseRegistry = BaseRegistry;


/***/ }),

/***/ 72872:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CssClassManager = void 0;
class CssClassManager {
    constructor(getGui) {
        // to minimise DOM hits, we only apply CSS classes if they have changed. as adding a CSS class that is already
        // there, or removing one that wasn't present, all takes CPU.
        this.cssClassStates = {};
        this.getGui = getGui;
    }
    toggleCss(className, addOrRemove) {
        if (!className) {
            return;
        }
        // we check for spaces before doing the split, as doing the split
        // created a performance problem (on windows only, see AG-6765)
        if (className.indexOf(' ') >= 0) {
            const list = (className || '').split(' ');
            if (list.length > 1) {
                list.forEach((cls) => this.toggleCss(cls, addOrRemove));
                return;
            }
        }
        const updateNeeded = this.cssClassStates[className] !== addOrRemove;
        if (updateNeeded && className.length) {
            this.getGui()?.classList.toggle(className, addOrRemove);
            this.cssClassStates[className] = addOrRemove;
        }
    }
}
exports.CssClassManager = CssClassManager;


/***/ }),

/***/ 91874:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseEventService = void 0;
const agBeanStub_1 = __webpack_require__(74856);
const localEventService_1 = __webpack_require__(19378);
class BaseEventService extends agBeanStub_1.AgBeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'eventSvc';
        this.eventServiceType = 'global';
        this.globalSvc = new localEventService_1.LocalEventService();
    }
    addListener(eventType, listener, async) {
        this.globalSvc.addEventListener(eventType, listener, async);
    }
    removeListener(eventType, listener, async) {
        this.globalSvc.removeEventListener(eventType, listener, async);
    }
    addGlobalListener(listener, async = false) {
        this.globalSvc.addGlobalListener(listener, async);
    }
    removeGlobalListener(listener, async = false) {
        this.globalSvc.removeGlobalListener(listener, async);
    }
    dispatchEvent(event) {
        this.globalSvc.dispatchEvent(this.gos.addCommon(event));
    }
    dispatchEventOnce(event) {
        this.globalSvc.dispatchEventOnce(this.gos.addCommon(event));
    }
}
exports.BaseEventService = BaseEventService;


/***/ }),

/***/ 19378:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LocalEventService = void 0;
class LocalEventService {
    constructor() {
        this.allSyncListeners = new Map();
        this.allAsyncListeners = new Map();
        this.globalSyncListeners = new Set();
        this.globalAsyncListeners = new Set();
        this.asyncFunctionsQueue = [];
        this.scheduled = false;
        // using an object performs better than a Set for the number of different events we have
        this.firedEvents = {};
    }
    setFrameworkOverrides(frameworkOverrides) {
        this.frameworkOverrides = frameworkOverrides;
    }
    getListeners(eventType, async, autoCreateListenerCollection) {
        const listenerMap = async ? this.allAsyncListeners : this.allSyncListeners;
        let listeners = listenerMap.get(eventType);
        // Note: 'autoCreateListenerCollection' should only be 'true' if a listener is about to be added. For instance
        // getListeners() is also called during event dispatch even though no listeners are added. This measure protects
        // against 'memory bloat' as empty collections will prevent the RowNode's event service from being removed after
        // the RowComp is destroyed, see noRegisteredListenersExist() below.
        if (!listeners && autoCreateListenerCollection) {
            listeners = new Set();
            listenerMap.set(eventType, listeners);
        }
        return listeners;
    }
    noRegisteredListenersExist() {
        return (this.allSyncListeners.size === 0 &&
            this.allAsyncListeners.size === 0 &&
            this.globalSyncListeners.size === 0 &&
            this.globalAsyncListeners.size === 0);
    }
    addEventListener(eventType, listener, async = false) {
        this.getListeners(eventType, async, true).add(listener);
    }
    removeEventListener(eventType, listener, async = false) {
        const listeners = this.getListeners(eventType, async, false);
        if (!listeners) {
            return;
        }
        listeners.delete(listener);
        if (listeners.size === 0) {
            (async ? this.allAsyncListeners : this.allSyncListeners).delete(eventType);
        }
    }
    addGlobalListener(listener, async = false) {
        this.getGlobalListeners(async).add(listener);
    }
    removeGlobalListener(listener, async = false) {
        this.getGlobalListeners(async).delete(listener);
    }
    dispatchEvent(event) {
        this.dispatchToListeners(event, true);
        this.dispatchToListeners(event, false);
        this.firedEvents[event.type] = true;
    }
    dispatchEventOnce(event) {
        if (!this.firedEvents[event.type]) {
            this.dispatchEvent(event);
        }
    }
    dispatchToListeners(event, async) {
        const eventType = event.type;
        if (async && 'event' in event) {
            const browserEvent = event.event;
            if (browserEvent instanceof Event) {
                // AG-7893 - Persist composedPath() so that its result can still be accessed by the user asynchronously.
                // Within an async event handler if they call composedPath() on the event it will always return an empty [].
                event.eventPath = browserEvent.composedPath();
            }
        }
        const { frameworkOverrides } = this;
        const runCallback = (func) => {
            const callback = frameworkOverrides ? () => frameworkOverrides.wrapIncoming(func) : func;
            if (async) {
                this.dispatchAsync(callback);
            }
            else {
                callback();
            }
        };
        const originalListeners = this.getListeners(eventType, async, false);
        if ((originalListeners?.size ?? 0) > 0) {
            // create a shallow copy to prevent listeners cyclically adding more listeners to capture this event
            const listeners = new Set(originalListeners);
            for (const listener of listeners) {
                if (!originalListeners?.has(listener)) {
                    // A listener could have been removed by a previously processed listener. In this case we don't want to call
                    continue;
                }
                runCallback(() => listener(event));
            }
        }
        const globalListenersSrc = this.getGlobalListeners(async);
        if (globalListenersSrc.size > 0) {
            const globalListeners = new Set(globalListenersSrc);
            for (const listener of globalListeners) {
                runCallback(() => listener(eventType, event));
            }
        }
    }
    getGlobalListeners(async) {
        return async ? this.globalAsyncListeners : this.globalSyncListeners;
    }
    // this gets called inside the grid's thread, for each event that it
    // wants to set async. the grid then batches the events into one setTimeout()
    // because setTimeout() is an expensive operation. ideally we would have
    // each event in it's own setTimeout(), but we batch for performance.
    dispatchAsync(func) {
        // add to the queue for executing later in the next VM turn
        this.asyncFunctionsQueue.push(func);
        // check if timeout is already scheduled. the first time the grid calls
        // this within it's thread turn, this should be false, so it will schedule
        // the 'flush queue' method the first time it comes here. then the flag is
        // set to 'true' so it will know it's already scheduled for subsequent calls.
        if (!this.scheduled) {
            // if not scheduled, schedule one
            const flush = () => {
                window.setTimeout(this.flushAsyncQueue.bind(this), 0);
            };
            this.frameworkOverrides ? this.frameworkOverrides.wrapIncoming(flush) : flush();
            // mark that it is scheduled
            this.scheduled = true;
        }
    }
    // this happens in the next VM turn only, and empties the queue of events
    flushAsyncQueue() {
        this.scheduled = false;
        // we take a copy, because the event listener could be using
        // the grid, which would cause more events, which would be potentially
        // added to the queue, so safe to take a copy, the new events will
        // get executed in a later VM turn rather than risk updating the
        // queue as we are flushing it.
        const queueCopy = this.asyncFunctionsQueue.slice();
        this.asyncFunctionsQueue = [];
        // execute the queue
        queueCopy.forEach((func) => func());
    }
}
exports.LocalEventService = LocalEventService;


/***/ }),

/***/ 91668:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._isComponent = exports.RefPlaceholder = void 0;
/** The RefPlaceholder is used to control when data-ref attribute should be applied to the component
 * There are hanging data-refs in the DOM that are not being used internally by the component which we don't want to apply to the component.
 * There is also the case where data-refs are solely used for passing parameters to the component and should not be applied to the component.
 * It also enables validation to catch typo errors in the data-ref attribute vs component name.
 * The value is `null` so that it can be identified in the component and distinguished from just missing with undefined.
 * The `null` value also allows for existing falsy checks to work as expected when code can be run before the template is setup.
 */
exports.RefPlaceholder = null;
function _isComponent(item) {
    return typeof item?.getGui === 'function';
}
exports._isComponent = _isComponent;


/***/ }),

/***/ 75298:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgPopupComponent = void 0;
const agComponentStub_1 = __webpack_require__(7047);
class AgPopupComponent extends agComponentStub_1.AgComponentStub {
    isPopup() {
        return true;
    }
    setParentComponent(container) {
        container.addCss('ag-has-popup');
        super.setParentComponent(container);
    }
    destroy() {
        const parentComp = this.parentComponent;
        const hasParent = parentComp && parentComp.isAlive();
        if (hasParent) {
            parentComp.getGui().classList.remove('ag-has-popup');
        }
        super.destroy();
    }
}
exports.AgPopupComponent = AgPopupComponent;


/***/ }),

/***/ 97531:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BasePopupService = void 0;
const direction_1 = __webpack_require__(72213);
const keyCode_1 = __webpack_require__(59926);
const agBeanStub_1 = __webpack_require__(74856);
const aria_1 = __webpack_require__(91623);
const document_1 = __webpack_require__(80011);
const dom_1 = __webpack_require__(1956);
const event_1 = __webpack_require__(7356);
const generic_1 = __webpack_require__(89097);
const promise_1 = __webpack_require__(35269);
let instanceIdSeq = 0;
const WAIT_FOR_POPUP_CONTENT_RESIZE = 200;
class BasePopupService extends agBeanStub_1.AgBeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'popupSvc';
        this.popupList = [];
    }
    getPopupParent() {
        const ePopupParent = this.gos.get('popupParent');
        if (ePopupParent) {
            return ePopupParent;
        }
        return this.getDefaultPopupParent();
    }
    positionPopupUnderMouseEvent(params) {
        const { ePopup, nudgeX, nudgeY, skipObserver } = params;
        this.positionPopup({
            ePopup: ePopup,
            nudgeX,
            nudgeY,
            keepWithinBounds: true,
            skipObserver,
            updatePosition: () => this.calculatePointerAlign(params.mouseEvent),
            postProcessCallback: () => this.callPostProcessPopup(params, params.type, params.ePopup, null, params.mouseEvent),
        });
    }
    calculatePointerAlign(e) {
        const parentRect = this.getParentRect();
        return {
            x: e.clientX - parentRect.left,
            y: e.clientY - parentRect.top,
        };
    }
    positionPopupByComponent(params) {
        const { ePopup, nudgeX, nudgeY, keepWithinBounds, eventSource, alignSide = 'left', position = 'over', type, } = params;
        const sourceRect = eventSource.getBoundingClientRect();
        const parentRect = this.getParentRect();
        this.setAlignedTo(eventSource, ePopup);
        const updatePosition = () => {
            let x = sourceRect.left - parentRect.left;
            if (alignSide === 'right') {
                x -= ePopup.offsetWidth - sourceRect.width;
            }
            let y;
            if (position === 'over') {
                y = sourceRect.top - parentRect.top;
                this.setAlignedStyles(ePopup, 'over');
            }
            else {
                this.setAlignedStyles(ePopup, 'under');
                const alignSide = this.shouldRenderUnderOrAbove(ePopup, sourceRect, parentRect, params.nudgeY || 0);
                if (alignSide === 'under') {
                    y = sourceRect.top - parentRect.top + sourceRect.height;
                }
                else {
                    y = sourceRect.top - ePopup.offsetHeight - (nudgeY || 0) * 2 - parentRect.top;
                }
            }
            return { x, y };
        };
        this.positionPopup({
            ePopup,
            nudgeX,
            nudgeY,
            keepWithinBounds,
            updatePosition,
            postProcessCallback: () => this.callPostProcessPopup(params, type, ePopup, eventSource, null),
        });
    }
    shouldRenderUnderOrAbove(ePopup, targetCompRect, parentRect, nudgeY) {
        const spaceAvailableUnder = parentRect.bottom - targetCompRect.bottom;
        const spaceAvailableAbove = targetCompRect.top - parentRect.top;
        const spaceRequired = ePopup.offsetHeight + nudgeY;
        if (spaceAvailableUnder > spaceRequired) {
            return 'under';
        }
        if (spaceAvailableAbove > spaceRequired || spaceAvailableAbove > spaceAvailableUnder) {
            return 'above';
        }
        return 'under';
    }
    setAlignedStyles(ePopup, positioned) {
        const popupIdx = this.getPopupIndex(ePopup);
        if (popupIdx === -1) {
            return;
        }
        const popup = this.popupList[popupIdx];
        const { alignedToElement } = popup;
        if (!alignedToElement) {
            return;
        }
        const positions = ['right', 'left', 'over', 'above', 'under'];
        positions.forEach((position) => {
            alignedToElement.classList.remove(`ag-has-popup-positioned-${position}`);
            ePopup.classList.remove(`ag-popup-positioned-${position}`);
        });
        if (!positioned) {
            return;
        }
        alignedToElement.classList.add(`ag-has-popup-positioned-${positioned}`);
        ePopup.classList.add(`ag-popup-positioned-${positioned}`);
    }
    setAlignedTo(eventSource, ePopup) {
        const popupIdx = this.getPopupIndex(ePopup);
        if (popupIdx !== -1) {
            const popup = this.popupList[popupIdx];
            popup.alignedToElement = eventSource;
        }
    }
    positionPopup(params) {
        const { ePopup, keepWithinBounds, nudgeX, nudgeY, skipObserver, updatePosition } = params;
        const lastSize = { width: 0, height: 0 };
        const updatePopupPosition = (fromResizeObserver = false) => {
            let { x, y } = updatePosition();
            if (fromResizeObserver &&
                ePopup.clientWidth === lastSize.width &&
                ePopup.clientHeight === lastSize.height) {
                return;
            }
            lastSize.width = ePopup.clientWidth;
            lastSize.height = ePopup.clientHeight;
            if (nudgeX) {
                x += nudgeX;
            }
            if (nudgeY) {
                y += nudgeY;
            }
            // if popup is overflowing to the bottom, move it up
            if (keepWithinBounds) {
                x = this.keepXYWithinBounds(ePopup, x, direction_1.Direction.Horizontal);
                y = this.keepXYWithinBounds(ePopup, y, direction_1.Direction.Vertical);
            }
            ePopup.style.left = `${x}px`;
            ePopup.style.top = `${y}px`;
            if (params.postProcessCallback) {
                params.postProcessCallback();
            }
        };
        updatePopupPosition();
        // Mouse tracking will recalculate positioning when moving, so won't need to recalculate here
        if (!skipObserver) {
            // Since rendering popup contents can be asynchronous, use a resize observer to
            // reposition the popup after initial updates to the size of the contents
            const resizeObserverDestroyFunc = (0, dom_1._observeResize)(this.beans, ePopup, () => updatePopupPosition(true));
            // Only need to reposition when first open, so can clean up after a bit of time
            setTimeout(() => resizeObserverDestroyFunc(), WAIT_FOR_POPUP_CONTENT_RESIZE);
        }
    }
    getParentRect() {
        // subtract the popup parent borders, because popupParent.getBoundingClientRect
        // returns the rect outside the borders, but the 0,0 coordinate for absolute
        // positioning is inside the border, leading the popup to be off by the width
        // of the border
        const eDocument = (0, document_1._getDocument)(this.beans);
        let popupParent = this.getPopupParent();
        if (popupParent === eDocument.body) {
            popupParent = eDocument.documentElement;
        }
        else if (getComputedStyle(popupParent).position === 'static') {
            popupParent = popupParent.offsetParent;
        }
        return (0, dom_1._getElementRectWithOffset)(popupParent);
    }
    keepXYWithinBounds(ePopup, position, direction) {
        const isVertical = direction === direction_1.Direction.Vertical;
        const sizeProperty = isVertical ? 'clientHeight' : 'clientWidth';
        const anchorProperty = isVertical ? 'top' : 'left';
        const offsetProperty = isVertical ? 'height' : 'width';
        const scrollPositionProperty = isVertical ? 'scrollTop' : 'scrollLeft';
        const eDocument = (0, document_1._getDocument)(this.beans);
        const docElement = eDocument.documentElement;
        const popupParent = this.getPopupParent();
        const popupRect = ePopup.getBoundingClientRect();
        const parentRect = popupParent.getBoundingClientRect();
        const documentRect = eDocument.documentElement.getBoundingClientRect();
        const isBody = popupParent === eDocument.body;
        const offsetSize = Math.ceil(popupRect[offsetProperty]);
        const getSize = isVertical ? dom_1._getAbsoluteHeight : dom_1._getAbsoluteWidth;
        let sizeOfParent = isBody
            ? getSize(docElement) + docElement[scrollPositionProperty]
            : popupParent[sizeProperty];
        if (isBody) {
            sizeOfParent -= Math.abs(documentRect[anchorProperty] - parentRect[anchorProperty]);
        }
        const max = sizeOfParent - offsetSize;
        return Math.min(Math.max(position, 0), Math.abs(max));
    }
    addPopup(params) {
        const { eChild, ariaLabel, ariaOwns, alwaysOnTop, positionCallback, anchorToElement } = params;
        const pos = this.getPopupIndex(eChild);
        if (pos !== -1) {
            const popup = this.popupList[pos];
            return { hideFunc: popup.hideFunc };
        }
        this.initialisePopupPosition(eChild);
        const wrapperEl = this.createPopupWrapper(eChild, !!alwaysOnTop, ariaLabel, ariaOwns);
        const removeListeners = this.addEventListenersToPopup({ ...params, wrapperEl });
        if (positionCallback) {
            positionCallback();
        }
        this.addPopupToPopupList(eChild, wrapperEl, removeListeners, anchorToElement);
        return {
            hideFunc: removeListeners,
        };
    }
    initialisePopupPosition(element) {
        const ePopupParent = this.getPopupParent();
        const ePopupParentRect = ePopupParent.getBoundingClientRect();
        if (!(0, generic_1._exists)(element.style.top)) {
            element.style.top = `${ePopupParentRect.top * -1}px`;
        }
        if (!(0, generic_1._exists)(element.style.left)) {
            element.style.left = `${ePopupParentRect.left * -1}px`;
        }
    }
    createPopupWrapper(element, alwaysOnTop, ariaLabel, ariaOwns) {
        const ePopupParent = this.getPopupParent();
        // add env CSS class to child, in case user provided a popup parent, which means
        // theme class may be missing
        const { environment, gos } = this.beans;
        const eWrapper = (0, dom_1._createAgElement)({ tag: 'div' });
        environment.applyThemeClasses(eWrapper);
        eWrapper.classList.add('ag-popup');
        element.classList.add(gos.get('enableRtl') ? 'ag-rtl' : 'ag-ltr', 'ag-popup-child');
        if (!element.hasAttribute('role')) {
            (0, aria_1._setAriaRole)(element, 'dialog');
        }
        if (ariaLabel) {
            (0, aria_1._setAriaLabel)(element, ariaLabel);
        }
        else if (ariaOwns) {
            element.id || (element.id = `popup-component-${instanceIdSeq}`);
            (0, aria_1._setAriaOwns)(ariaOwns, element.id);
        }
        eWrapper.appendChild(element);
        ePopupParent.appendChild(eWrapper);
        if (alwaysOnTop) {
            this.setAlwaysOnTop(element, true);
        }
        else {
            this.bringPopupToFront(element);
        }
        return eWrapper;
    }
    addEventListenersToPopup(params) {
        const beans = this.beans;
        const eDocument = (0, document_1._getDocument)(beans);
        const ePopupParent = this.getPopupParent();
        const { wrapperEl, eChild: popupEl, closedCallback, afterGuiAttached, closeOnEsc, modal, ariaOwns } = params;
        let popupHidden = false;
        const hidePopupOnKeyboardEvent = (event) => {
            if (!wrapperEl.contains((0, document_1._getActiveDomElement)(beans))) {
                return;
            }
            const key = event.key;
            if (key === keyCode_1.KeyCode.ESCAPE && !this.isStopPropagation(event)) {
                removeListeners({ keyboardEvent: event });
            }
        };
        const hidePopupOnMouseEvent = (event) => removeListeners({ mouseEvent: event });
        const hidePopupOnTouchEvent = (event) => removeListeners({ touchEvent: event });
        const removeListeners = (popupParams = {}) => {
            const { mouseEvent, touchEvent, keyboardEvent, forceHide } = popupParams;
            if (!forceHide &&
                // we don't hide popup if the event was on the child, or any
                // children of this child
                (this.isEventFromCurrentPopup({ mouseEvent, touchEvent }, popupEl) ||
                    // this method should only be called once. the client can have different
                    // paths, each one wanting to close, so this method may be called multiple times.
                    popupHidden)) {
                return;
            }
            popupHidden = true;
            ePopupParent.removeChild(wrapperEl);
            eDocument.removeEventListener('keydown', hidePopupOnKeyboardEvent);
            eDocument.removeEventListener('mousedown', hidePopupOnMouseEvent);
            eDocument.removeEventListener('touchstart', hidePopupOnTouchEvent);
            eDocument.removeEventListener('contextmenu', hidePopupOnMouseEvent);
            this.eventSvc.removeListener('dragStarted', hidePopupOnMouseEvent);
            if (closedCallback) {
                closedCallback(mouseEvent || touchEvent || keyboardEvent);
            }
            this.removePopupFromPopupList(popupEl, ariaOwns);
        };
        if (afterGuiAttached) {
            afterGuiAttached({ hidePopup: removeListeners });
        }
        // if we add these listeners now, then the current mouse
        // click will be included, which we don't want
        window.setTimeout(() => {
            if (closeOnEsc) {
                eDocument.addEventListener('keydown', hidePopupOnKeyboardEvent);
            }
            if (modal) {
                eDocument.addEventListener('mousedown', hidePopupOnMouseEvent);
                this.eventSvc.addListener('dragStarted', hidePopupOnMouseEvent);
                eDocument.addEventListener('touchstart', hidePopupOnTouchEvent);
                eDocument.addEventListener('contextmenu', hidePopupOnMouseEvent);
            }
        }, 0);
        return removeListeners;
    }
    addPopupToPopupList(element, wrapperEl, removeListeners, anchorToElement) {
        this.popupList.push({
            element: element,
            wrapper: wrapperEl,
            hideFunc: removeListeners,
            instanceId: instanceIdSeq,
            isAnchored: !!anchorToElement,
        });
        if (anchorToElement) {
            this.setPopupPositionRelatedToElement(element, anchorToElement);
        }
        instanceIdSeq = instanceIdSeq + 1;
    }
    getPopupIndex(el) {
        return this.popupList.findIndex((p) => p.element === el);
    }
    setPopupPositionRelatedToElement(popupEl, relativeElement) {
        const popupIndex = this.getPopupIndex(popupEl);
        if (popupIndex === -1) {
            return;
        }
        const popup = this.popupList[popupIndex];
        if (popup.stopAnchoringPromise) {
            popup.stopAnchoringPromise.then((destroyFunc) => destroyFunc && destroyFunc());
        }
        popup.stopAnchoringPromise = undefined;
        popup.isAnchored = false;
        if (!relativeElement) {
            return;
        }
        // keeps popup positioned under created, eg if context menu, if user scrolls
        // using touchpad and the cell moves, it moves the popup to keep it with the cell.
        const destroyPositionTracker = this.keepPopupPositionedRelativeTo({
            element: relativeElement,
            ePopup: popupEl,
            hidePopup: popup.hideFunc,
        });
        popup.stopAnchoringPromise = destroyPositionTracker;
        popup.isAnchored = true;
        return destroyPositionTracker;
    }
    removePopupFromPopupList(element, ariaOwns) {
        this.setAlignedStyles(element, null);
        this.setPopupPositionRelatedToElement(element, null);
        if (ariaOwns) {
            (0, aria_1._setAriaOwns)(ariaOwns, null);
        }
        this.popupList = this.popupList.filter((p) => p.element !== element);
    }
    keepPopupPositionedRelativeTo(params) {
        const eParent = this.getPopupParent();
        const parentRect = eParent.getBoundingClientRect();
        const { element, ePopup } = params;
        const sourceRect = element.getBoundingClientRect();
        const extractFromPixelValue = (pxSize) => parseInt(pxSize.substring(0, pxSize.length - 1), 10);
        const createPosition = (prop, direction) => {
            const initialDiff = parentRect[prop] - sourceRect[prop];
            const initial = extractFromPixelValue(ePopup.style[prop]);
            return {
                initialDiff,
                lastDiff: initialDiff,
                initial,
                last: initial,
                direction,
            };
        };
        const topPosition = createPosition('top', direction_1.Direction.Vertical);
        const leftPosition = createPosition('left', direction_1.Direction.Horizontal);
        const fwOverrides = this.beans.frameworkOverrides;
        return new promise_1.AgPromise((resolve) => {
            fwOverrides.wrapIncoming(() => {
                (0, promise_1._wrapInterval)(() => {
                    const pRect = eParent.getBoundingClientRect();
                    const sRect = element.getBoundingClientRect();
                    const elementNotInDom = sRect.top == 0 && sRect.left == 0 && sRect.height == 0 && sRect.width == 0;
                    if (elementNotInDom) {
                        params.hidePopup();
                        return;
                    }
                    const calculateNewPosition = (position, prop) => {
                        const current = extractFromPixelValue(ePopup.style[prop]);
                        if (position.last !== current) {
                            // some other process has moved the popup
                            position.initial = current;
                            position.last = current;
                        }
                        const currentDiff = pRect[prop] - sRect[prop];
                        if (currentDiff != position.lastDiff) {
                            const newValue = this.keepXYWithinBounds(ePopup, position.initial + position.initialDiff - currentDiff, position.direction);
                            ePopup.style[prop] = `${newValue}px`;
                            position.last = newValue;
                        }
                        position.lastDiff = currentDiff;
                    };
                    calculateNewPosition(topPosition, 'top');
                    calculateNewPosition(leftPosition, 'left');
                }, 200).then((intervalId) => {
                    const result = () => {
                        if (intervalId != null) {
                            window.clearInterval(intervalId);
                        }
                    };
                    resolve(result);
                });
            }, 'popupPositioning');
        });
    }
    isEventFromCurrentPopup(params, target) {
        const { mouseEvent, touchEvent } = params;
        const event = mouseEvent ? mouseEvent : touchEvent;
        if (!event) {
            return false;
        }
        const indexOfThisChild = this.getPopupIndex(target);
        if (indexOfThisChild === -1) {
            return false;
        }
        for (let i = indexOfThisChild; i < this.popupList.length; i++) {
            const popup = this.popupList[i];
            if ((0, event_1._isElementInEventPath)(popup.element, event)) {
                return true;
            }
        }
        // if the user did not write their own Custom Element to be rendered as popup
        // and this component has an additional popup element, they should have the
        // `ag-custom-component-popup` class to be detected as part of the Custom Component
        return this.isElementWithinCustomPopup(event.target);
    }
    isElementWithinCustomPopup(el) {
        const eDocument = (0, document_1._getDocument)(this.beans);
        while (el && el !== eDocument.body) {
            if (el.classList.contains('ag-custom-component-popup') || el.parentElement === null) {
                return true;
            }
            el = el.parentElement;
        }
        return false;
    }
    getWrapper(ePopup) {
        while (!ePopup.classList.contains('ag-popup') && ePopup.parentElement) {
            ePopup = ePopup.parentElement;
        }
        return ePopup.classList.contains('ag-popup') ? ePopup : null;
    }
    setAlwaysOnTop(ePopup, alwaysOnTop) {
        const eWrapper = this.getWrapper(ePopup);
        if (!eWrapper) {
            return;
        }
        eWrapper.classList.toggle('ag-always-on-top', !!alwaysOnTop);
        if (alwaysOnTop) {
            this.bringPopupToFront(eWrapper);
        }
    }
    /** @returns true if moved */
    bringPopupToFront(ePopup) {
        const parent = this.getPopupParent();
        const popupList = Array.prototype.slice.call(parent.querySelectorAll('.ag-popup'));
        const popupLen = popupList.length;
        const eWrapper = this.getWrapper(ePopup);
        if (!eWrapper || popupLen <= 1 || !parent.contains(ePopup)) {
            return;
        }
        const standardPopupList = [];
        const alwaysOnTopList = [];
        for (const popup of popupList) {
            if (popup === eWrapper) {
                continue;
            }
            if (popup.classList.contains('ag-always-on-top')) {
                alwaysOnTopList.push(popup);
            }
            else {
                standardPopupList.push(popup);
            }
        }
        const innerElsScrollMap = [];
        const onTopLength = alwaysOnTopList.length;
        const isPopupAlwaysOnTop = eWrapper.classList.contains('ag-always-on-top');
        const shouldBeLast = isPopupAlwaysOnTop || !onTopLength;
        const targetList = shouldBeLast
            ? [...standardPopupList, ...alwaysOnTopList, eWrapper]
            : [...standardPopupList, eWrapper, ...alwaysOnTopList];
        for (let i = 0; i <= popupLen; i++) {
            const currentPopup = targetList[i];
            if (popupList[i] === targetList[i] || currentPopup === eWrapper) {
                continue;
            }
            const innerEls = currentPopup.querySelectorAll('div');
            innerEls.forEach((el) => {
                if (el.scrollTop !== 0) {
                    innerElsScrollMap.push([el, el.scrollTop]);
                }
            });
            if (i === 0) {
                parent.insertAdjacentElement('afterbegin', currentPopup);
            }
            else {
                targetList[i - 1].insertAdjacentElement('afterend', currentPopup);
            }
        }
        while (innerElsScrollMap.length) {
            const currentEl = innerElsScrollMap.pop();
            currentEl[0].scrollTop = currentEl[1];
        }
    }
}
exports.BasePopupService = BasePopupService;


/***/ }),

/***/ 10654:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._unregisterInstanceUsingThemingAPI = exports._registerInstanceUsingThemingAPI = exports._injectCoreAndModuleCSS = exports._injectGlobalCSS = exports.FORCE_LEGACY_THEMES = exports.IS_SSR = void 0;
const shared_css_GENERATED_1 = __webpack_require__(7825);
exports.IS_SSR = typeof window !== 'object' || !window?.document?.fonts?.forEach;
/** For testing, if true, only Vanilla examples will work and they will use legacy themes. */
exports.FORCE_LEGACY_THEMES = false;
const _injectGlobalCSS = (css, styleContainer, debugId, layer, priority, nonce) => {
    if (exports.IS_SSR)
        return;
    if (exports.FORCE_LEGACY_THEMES)
        return;
    if (layer) {
        css = `@layer ${CSS.escape(layer)} { ${css} }`;
    }
    let injections = injectionState.map.get(styleContainer);
    if (!injections) {
        injections = [];
        injectionState.map.set(styleContainer, injections);
    }
    if (injections.find((i) => i.css === css))
        return;
    const el = document.createElement('style');
    if (nonce) {
        el.setAttribute('nonce', nonce);
    }
    el.dataset.agGlobalCss = debugId;
    el.textContent = css;
    const newInjection = { css, el, priority };
    let insertAfter;
    for (const injection of injections) {
        if (injection.priority > priority)
            break;
        insertAfter = injection;
    }
    if (insertAfter) {
        insertAfter.el.insertAdjacentElement('afterend', el);
        const index = injections.indexOf(insertAfter);
        injections.splice(index + 1, 0, newInjection);
    }
    else {
        styleContainer.insertBefore(el, styleContainer.querySelector(':not(title, meta)'));
        injections.push(newInjection);
    }
};
exports._injectGlobalCSS = _injectGlobalCSS;
const _injectCoreAndModuleCSS = (styleContainer, layer, nonce, moduleCss) => {
    (0, exports._injectGlobalCSS)(shared_css_GENERATED_1.sharedCSS, styleContainer, 'shared', layer, 0, nonce);
    moduleCss?.forEach((css, debugId) => css.forEach((singleCss) => (0, exports._injectGlobalCSS)(singleCss, styleContainer, debugId, layer, 0, nonce)));
};
exports._injectCoreAndModuleCSS = _injectCoreAndModuleCSS;
const _registerInstanceUsingThemingAPI = (environment) => {
    injectionState.grids.add(environment);
};
exports._registerInstanceUsingThemingAPI = _registerInstanceUsingThemingAPI;
const _unregisterInstanceUsingThemingAPI = (environment) => {
    injectionState.grids.delete(environment);
    if (injectionState.grids.size === 0) {
        injectionState.map = new WeakMap();
        for (const style of document.head.querySelectorAll('style[data-ag-global-css]')) {
            style.remove();
        }
    }
};
exports._unregisterInstanceUsingThemingAPI = _unregisterInstanceUsingThemingAPI;
// AG-14716 - for customers using module federation, there may be many
// instances of this module, but we want to ensure that there is only
// one instance of the container to injection map per window otherwise
// unmounting any grid instance will clear all styles from the page
// resulting in unstyled grids
const injectionState = ((_a = (typeof window === 'object'
    ? window
    : {})).agStyleInjectionState ?? (_a.agStyleInjectionState = {
    map: new WeakMap(),
    grids: new Set(),
}));


/***/ }),

/***/ 83036:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PartImpl = exports.defaultModeName = exports.createPart = void 0;
const inject_1 = __webpack_require__(10654);
/**
 * Create a new empty part.
 *
 * @param feature an The part feature, e.g. 'iconSet'. Adding a part to a theme will remove any existing part with the same feature.
 * @param variant an optional identifier for debugging, if omitted one will be generated
 */
const createPart = (args) => {
    /*#__PURE__*/
    return new PartImpl(args);
};
exports.createPart = createPart;
exports.defaultModeName = '$default';
let partCounter = 0;
class PartImpl {
    constructor({ feature, params, modeParams = {}, css, cssImports }) {
        this.feature = feature;
        this.css = css;
        this.cssImports = cssImports;
        this.modeParams = {
            // NOTE: it's important that default is defined first, putting it
            // first in iteration order, because when merging params the default
            // params override any prior modal params, so modal params in this
            // part need to come after default params to prevent them from being
            // immediately overridden.
            [exports.defaultModeName]: {
                ...(modeParams[exports.defaultModeName] ?? {}),
                ...(params ?? {}),
            },
            ...modeParams,
        };
    }
    use(styleContainer, layer, nonce) {
        let inject = this._inject;
        if (inject == null) {
            let { css } = this;
            if (css) {
                const className = `ag-theme-${this.feature ?? 'part'}-${++partCounter}`;
                if (typeof css === 'function')
                    css = css();
                css = `:where(.${className}) {\n${css}\n}\n`;
                for (const cssImport of this.cssImports ?? []) {
                    css = `@import url(${JSON.stringify(cssImport)});\n${css}`;
                }
                inject = { css, class: className };
            }
            else {
                inject = false;
            }
            this._inject = inject;
        }
        if (inject && styleContainer) {
            (0, inject_1._injectGlobalCSS)(inject.css, styleContainer, inject.class, layer, 1, nonce);
        }
        return inject ? inject.class : false;
    }
}
exports.PartImpl = PartImpl;


/***/ }),

/***/ 34422:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.sharedDefaults = exports.defaultLightColorSchemeParams = void 0;
const themeUtils_1 = __webpack_require__(19981);
exports.defaultLightColorSchemeParams = {
    backgroundColor: '#fff',
    foregroundColor: '#181d1f',
    borderColor: (0, themeUtils_1.foregroundMix)(0.15),
    chromeBackgroundColor: (0, themeUtils_1.foregroundBackgroundMix)(0.02),
    browserColorScheme: 'light',
};
exports.sharedDefaults = {
    ...exports.defaultLightColorSchemeParams,
    textColor: themeUtils_1.foregroundColor,
    accentColor: '#2196f3',
    invalidColor: '#e02525',
    fontFamily: [
        '-apple-system',
        'BlinkMacSystemFont',
        'Segoe UI',
        'Roboto',
        'Oxygen-Sans',
        'Ubuntu',
        'Cantarell',
        'Helvetica Neue',
        'sans-serif',
    ],
    subtleTextColor: {
        ref: 'textColor',
        mix: 0.5,
    },
    borderWidth: 1,
    borderRadius: 4,
    spacing: 8,
    fontSize: 14,
    focusShadow: {
        spread: 3,
        color: (0, themeUtils_1.accentMix)(0.5),
    },
    focusErrorShadow: {
        spread: 3,
        color: {
            ref: 'invalidColor',
            onto: 'backgroundColor',
            mix: 0.5,
        },
    },
    popupShadow: '0 0 16px #00000026',
    cardShadow: '0 1px 4px 1px #00000018',
    dropdownShadow: { ref: 'cardShadow' },
    listItemHeight: {
        calc: 'max(iconSize, dataFontSize) + widgetVerticalSpacing',
    },
    dragAndDropImageBackgroundColor: themeUtils_1.backgroundColor,
    dragAndDropImageBorder: true,
    dragAndDropImageNotAllowedBorder: {
        color: {
            ref: 'invalidColor',
            onto: 'dragAndDropImageBackgroundColor',
            mix: 0.5,
        },
    },
    dragAndDropImageShadow: {
        ref: 'popupShadow',
    },
    iconSize: 16,
    iconColor: 'inherit',
    toggleButtonWidth: 28,
    toggleButtonHeight: 18,
    toggleButtonOnBackgroundColor: themeUtils_1.accentColor,
    toggleButtonOffBackgroundColor: (0, themeUtils_1.foregroundBackgroundMix)(0.3),
    toggleButtonSwitchBackgroundColor: themeUtils_1.backgroundColor,
    toggleButtonSwitchInset: 2,
    tooltipBackgroundColor: {
        ref: 'chromeBackgroundColor',
    },
    tooltipErrorBackgroundColor: {
        ref: 'invalidColor',
        onto: 'backgroundColor',
        mix: 0.1,
    },
    tooltipTextColor: {
        ref: 'textColor',
    },
    tooltipErrorTextColor: {
        ref: 'invalidColor',
    },
    tooltipBorder: true,
    tooltipErrorBorder: {
        color: {
            ref: 'invalidColor',
            onto: 'backgroundColor',
            mix: 0.25,
        },
    },
};


/***/ }),

/***/ 7825:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.sharedCSS = void 0;
exports.sharedCSS = `:where(.ag-root-wrapper,.ag-external,.ag-popup,.ag-dnd-ghost,.ag-chart),:where(.ag-root-wrapper,.ag-external,.ag-popup,.ag-dnd-ghost,.ag-chart) :where([class^=ag-]){box-sizing:border-box;&:after,&:before{box-sizing:border-box}&:where(div,span,label):focus-visible{box-shadow:inset var(--ag-focus-shadow);outline:none;&:where(.invalid){box-shadow:inset var(--ag-focus-error-shadow)}}&:where(button){color:inherit}}:where(.ag-root-wrapper,ag-external,.ag-popup,.ag-dnd-ghost,.ag-chart) :where([class^=ag-]) ::-ms-clear{display:none}.ag-hidden{display:none!important}.ag-invisible{visibility:hidden!important}.ag-popup-child{top:0;z-index:5;&:where(:not(.ag-tooltip-custom)){box-shadow:var(--ag-popup-shadow)}}.ag-input-wrapper,.ag-picker-field-wrapper{align-items:center;display:flex;flex:1 1 auto;line-height:normal;position:relative}.ag-input-field{align-items:center;display:flex;flex-direction:row}.ag-input-field-input:where(:not([type=checkbox],[type=radio])){flex:1 1 auto;min-width:0;width:100%}.ag-chart,.ag-dnd-ghost,.ag-external,.ag-popup,.ag-root-wrapper{cursor:default;line-height:normal;white-space:normal;-webkit-font-smoothing:antialiased;background-color:var(--ag-background-color);color:var(--ag-text-color);color-scheme:var(--ag-browser-color-scheme);font-family:var(--ag-font-family);font-size:var(--ag-font-size);--ag-indentation-level:0}:where(.ag-icon):before{align-items:center;background-color:currentcolor;color:inherit;content:"";display:flex;font-family:inherit;font-size:var(--ag-icon-size);font-style:normal;font-variant:normal;height:var(--ag-icon-size);justify-content:center;line-height:var(--ag-icon-size);-webkit-mask-size:contain;mask-size:contain;text-transform:none;width:var(--ag-icon-size)}.ag-icon{background-position:50%;background-repeat:no-repeat;background-size:contain;color:var(--ag-icon-color);display:block;height:var(--ag-icon-size);position:relative;-webkit-user-select:none;-moz-user-select:none;user-select:none;width:var(--ag-icon-size)}.ag-disabled,[disabled]{.ag-icon{opacity:.5}&.ag-icon-grip{opacity:.35}}.ag-resizer{pointer-events:none;position:absolute;-webkit-user-select:none;-moz-user-select:none;user-select:none;z-index:1}:where(.ag-resizer){&.ag-resizer-topLeft{cursor:nwse-resize;height:5px;left:0;top:0;width:5px}&.ag-resizer-top{cursor:ns-resize;height:5px;left:5px;right:5px;top:0}&.ag-resizer-topRight{cursor:nesw-resize;height:5px;right:0;top:0;width:5px}&.ag-resizer-right{bottom:5px;cursor:ew-resize;right:0;top:5px;width:5px}&.ag-resizer-bottomRight{bottom:0;cursor:nwse-resize;height:5px;right:0;width:5px}&.ag-resizer-bottom{bottom:0;cursor:ns-resize;height:5px;left:5px;right:5px}&.ag-resizer-bottomLeft{bottom:0;cursor:nesw-resize;height:5px;left:0;width:5px}&.ag-resizer-left{bottom:5px;cursor:ew-resize;left:0;top:5px;width:5px}}`;


/***/ }),

/***/ 71756:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ThemeImpl = exports.createSharedTheme = exports._asThemeImpl = void 0;
const inject_1 = __webpack_require__(10654);
const partImpl_1 = __webpack_require__(83036);
const shared_css_1 = __webpack_require__(34422);
const themeTypeUtils_1 = __webpack_require__(14949);
const themeUtils_1 = __webpack_require__(19981);
const _asThemeImpl = (theme) => {
    if (!(theme instanceof ThemeImpl)) {
        throw new Error('theme is not an object created by createTheme');
    }
    return theme;
};
exports._asThemeImpl = _asThemeImpl;
const createSharedTheme = (themeLogger) => new ThemeImpl(themeLogger);
exports.createSharedTheme = createSharedTheme;
class ThemeImpl {
    constructor(themeLogger, parts = []) {
        this.themeLogger = themeLogger;
        this.parts = parts;
    }
    withPart(part) {
        if (typeof part === 'function')
            part = part();
        if (!(part instanceof partImpl_1.PartImpl)) {
            // Can't use validation service as this is API is designed to be used before modules are registered
            this.themeLogger.preInitErr(259, 'Invalid part', { part });
            return this;
        }
        return new ThemeImpl(this.themeLogger, [...this.parts, part]);
    }
    withoutPart(feature) {
        return this.withPart((0, partImpl_1.createPart)({ feature }));
    }
    withParams(params, mode = partImpl_1.defaultModeName) {
        return this.withPart((0, partImpl_1.createPart)({
            modeParams: { [mode]: params },
        }));
    }
    /**
     * Called by a grid instance when it starts using the theme. This installs
     * the theme's parts into document head, or the shadow DOM if the provided
     * container is within a shadow root.
     */
    _startUse({ styleContainer, cssLayer, nonce, loadThemeGoogleFonts, moduleCss }) {
        if (inject_1.IS_SSR)
            return;
        if (inject_1.FORCE_LEGACY_THEMES)
            return;
        uninstallLegacyCSS();
        (0, inject_1._injectCoreAndModuleCSS)(styleContainer, cssLayer, nonce, moduleCss);
        const googleFontsUsed = getGoogleFontsUsed(this);
        if (googleFontsUsed.length > 0) {
            for (const googleFont of googleFontsUsed) {
                if (loadThemeGoogleFonts) {
                    loadGoogleFont(googleFont, nonce);
                }
            }
        }
        for (const part of this.parts) {
            part.use(styleContainer, cssLayer, nonce);
        }
    }
    /**
     * Return CSS that that applies the params of this theme to elements with
     * the provided class name
     */
    _getCssClass() {
        if (inject_1.FORCE_LEGACY_THEMES)
            return 'ag-theme-quartz';
        return (this._cssClassCache ?? (this._cssClassCache = deduplicatePartsByFeature(this.parts)
            .map((part) => part.use(undefined, undefined, undefined))
            .filter(Boolean)
            .join(' ')));
    }
    _getModeParams() {
        let paramsCache = this._paramsCache;
        if (!paramsCache) {
            const mergedModeParams = {
                // NOTE: defining the default mode here is important, it ensures
                // that the default mode is first in iteration order, which puts
                // it first in outputted CSS, allowing other modes to override it
                [partImpl_1.defaultModeName]: { ...shared_css_1.sharedDefaults },
            };
            for (const part of deduplicatePartsByFeature(this.parts)) {
                for (const partMode of Object.keys(part.modeParams)) {
                    const partParams = part.modeParams[partMode];
                    if (partParams) {
                        const mergedParams = (mergedModeParams[partMode] ?? (mergedModeParams[partMode] = {}));
                        const partParamNames = new Set();
                        for (const partParamName of Object.keys(partParams)) {
                            const partParamValue = partParams[partParamName];
                            if (partParamValue !== undefined) {
                                mergedParams[partParamName] = partParamValue;
                                partParamNames.add(partParamName);
                            }
                        }
                        // If a later part has added default mode params, remove any non-default mode
                        // values for the same param. We need to do this because the last value set
                        // for a param should always take precedence. Consider this:
                        // const redInDarkMode = themeQuartz.withParams({accentColor: 'red'}, 'dark');
                        // const alwaysBlue = redInDarkMode.withParams({accentColor: 'blue'});
                        // Setting theme.withParams({accentColor: 'blue'}) is expected to produce a theme
                        // whose accent color is always blue, end of story. So we remove the accentColor
                        // value from the `dark` mode params otherwise it would override the default
                        // accent color.
                        if (partMode === partImpl_1.defaultModeName) {
                            for (const mergedMode of Object.keys(mergedModeParams)) {
                                const mergedParams = mergedModeParams[mergedMode];
                                if (mergedMode !== partImpl_1.defaultModeName) {
                                    for (const partParamName of partParamNames) {
                                        delete mergedParams[partParamName];
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this._paramsCache = paramsCache = mergedModeParams;
        }
        return paramsCache;
    }
    /**
     * Return the CSS chunk that is inserted into the grid DOM, and will
     * therefore be removed automatically when the grid is destroyed or it
     * starts to use a new theme.
     *
     * @param className a unique class name on the grid wrapper used to scope the returned CSS to the grid instance
     */
    _getPerInstanceCss(className) {
        const selectorPlaceholder = '##SELECTOR##';
        let innerParamsCss = this._paramsCssCache;
        if (!innerParamsCss) {
            // Ensure that every variable has a value set on root elements ("root"
            // elements are those containing grid UI, e.g. ag-root-wrapper and
            // ag-popup)
            //
            // Simply setting .ag-root-wrapper { --ag-foo: default-value } is not
            // appropriate because it will override any values set on parent
            // elements. An application should be able to set `--ag-spacing: 4px`
            // on the document body and have it picked up by all grids on the page.
            //
            // To allow this we capture the application-provided value of --ag-foo
            // into --ag-inherited-foo on the *parent* element of the root, and then
            // use --ag-inherited-foo as the value for --ag-foo on the root element,
            // applying our own default if it is unset.
            let variablesCss = '';
            let inheritanceCss = '';
            const modeParams = this._getModeParams();
            for (const mode of Object.keys(modeParams)) {
                const params = modeParams[mode];
                if (mode !== partImpl_1.defaultModeName) {
                    const escapedMode = typeof CSS === 'object' ? CSS.escape(mode) : mode; // check for CSS global in case we're running in tests
                    const wrapPrefix = `:where([data-ag-theme-mode="${escapedMode}"]) & {\n`;
                    variablesCss += wrapPrefix;
                    inheritanceCss += wrapPrefix;
                }
                // NOSONAR - these are not localised
                for (const key of Object.keys(params).sort()) {
                    const value = params[key];
                    const cssValue = (0, themeTypeUtils_1.paramValueToCss)(key, value, this.themeLogger);
                    if (cssValue === false) {
                        this.themeLogger.error(107, { key, value });
                    }
                    else {
                        const cssName = (0, themeUtils_1.paramToVariableName)(key);
                        const inheritedName = cssName.replace('--ag-', '--ag-inherited-');
                        variablesCss += `\t${cssName}: var(${inheritedName}, ${cssValue});\n`;
                        inheritanceCss += `\t${inheritedName}: var(${cssName});\n`;
                    }
                }
                if (mode !== partImpl_1.defaultModeName) {
                    variablesCss += '}\n';
                    inheritanceCss += '}\n';
                }
            }
            let css = `${selectorPlaceholder} {\n${variablesCss}}\n`;
            // Create --ag-inherited-foo variable values on the parent element, unless
            // the parent is itself a root (which can happen if popupParent is
            // ag-root-wrapper)
            css += `:has(> ${selectorPlaceholder}):not(${selectorPlaceholder}) {\n${inheritanceCss}}\n`;
            this._paramsCssCache = innerParamsCss = css;
        }
        return innerParamsCss.replaceAll(selectorPlaceholder, `:where(.${className})`);
    }
}
exports.ThemeImpl = ThemeImpl;
// Remove parts with the same feature, keeping only the last one
const deduplicatePartsByFeature = (parts) => {
    const lastPartByFeature = new Map();
    for (const part of parts) {
        lastPartByFeature.set(part.feature, part);
    }
    const result = [];
    for (const part of parts) {
        if (!part.feature || lastPartByFeature.get(part.feature) === part) {
            result.push(part);
        }
    }
    return result;
};
const getGoogleFontsUsed = (theme) => {
    const googleFontsUsed = new Set();
    const visitParamValue = (paramValue) => {
        // font value can be a font object or array of font objects
        if (Array.isArray(paramValue)) {
            paramValue.forEach(visitParamValue);
        }
        else {
            const googleFont = paramValue?.googleFont;
            if (typeof googleFont === 'string') {
                googleFontsUsed.add(googleFont);
            }
        }
    };
    const allModeValues = Object.values(theme._getModeParams());
    const allValues = allModeValues.flatMap((mv) => Object.values(mv));
    allValues.forEach(visitParamValue);
    // NOSONAR - these are not localised
    return Array.from(googleFontsUsed).sort();
};
let uninstalledLegacyCSS = false;
// Remove the CSS from @ag-grid-community/styles that is automatically injected
// by the UMD bundle
const uninstallLegacyCSS = () => {
    if (uninstalledLegacyCSS)
        return;
    uninstalledLegacyCSS = true;
    for (const style of Array.from(document.head.querySelectorAll('style[data-ag-scope="legacy"]'))) {
        style.remove();
    }
};
const googleFontsLoaded = new Set();
const loadGoogleFont = async (font, nonce) => {
    googleFontsLoaded.add(font);
    const css = `@import url('https://${googleFontsDomain}/css2?family=${encodeURIComponent(font)}:wght@100;200;300;400;500;600;700;800;900&display=swap');\n`;
    // fonts are always installed in the document head, they are inherited in
    // shadow DOM without the need for separate installation
    (0, inject_1._injectGlobalCSS)(css, document.head, `googleFont:${font}`, undefined, 0, nonce);
};
const googleFontsDomain = 'fonts.googleapis.com';


/***/ }),

/***/ 14949:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.paramValueToCss = exports.durationValueToCss = exports.imageValueToCss = exports.fontWeightValueToCss = exports.fontFamilyValueToCss = exports.borderStyleValueToCss = exports.shadowValueToCss = exports.borderValueToCss = exports.scaleValueToCss = exports.lengthValueToCss = exports.colorSchemeValueToCss = exports.colorValueToCss = exports.getParamType = exports.paramTypes = void 0;
const themeUtils_1 = __webpack_require__(19981);
exports.paramTypes = [
    'colorScheme',
    'color',
    'length',
    'scale',
    'borderStyle',
    'border',
    'shadow',
    'image',
    'fontFamily',
    'fontWeight',
    'duration',
];
/**
 * Return the ParamType for a given param name,
 */
exports.getParamType = (0, themeUtils_1.memoize)((param) => {
    param = param.toLowerCase();
    return exports.paramTypes.find((type) => param.endsWith(type.toLowerCase())) ?? 'length';
});
const literalToCSS = (value) => {
    if (typeof value === 'object' && value?.ref)
        return (0, themeUtils_1.paramToVariableExpression)(value.ref);
    if (typeof value === 'string')
        return value;
    if (typeof value === 'number')
        return String(value);
    return false;
};
const colorValueToCss = (value) => {
    if (typeof value === 'string')
        return value;
    if (value && 'ref' in value) {
        const colorExpr = (0, themeUtils_1.paramToVariableExpression)(value.ref);
        if (value.mix == null) {
            return colorExpr;
        }
        const backgroundExpr = value.onto ? (0, themeUtils_1.paramToVariableExpression)(value.onto) : 'transparent';
        return `color-mix(in srgb, ${backgroundExpr}, ${colorExpr} ${(0, themeUtils_1.clamp)(value.mix * 100, 0, 100)}%)`;
    }
    return false;
};
exports.colorValueToCss = colorValueToCss;
exports.colorSchemeValueToCss = literalToCSS;
const lengthValueToCss = (value) => {
    if (typeof value === 'string')
        return value;
    if (typeof value === 'number')
        return `${value}px`;
    if (value && 'calc' in value) {
        // ensure a space around operators other than `-` (which can be part of an identifier)
        const valueWithSpaces = value.calc.replace(/ ?[*/+] ?/g, ' $& ');
        // convert param names to variable expressions, e.g. "fooBar" -> "var(--ag-foo-bar)",
        // ignoring words that are part of function names "fooBar()" or variables "--fooBar"
        return `calc(${valueWithSpaces.replace(/-?\b[a-z][a-z0-9]*\b(?![-(])/gi, (p) => (p[0] === '-' ? p : ` ${(0, themeUtils_1.paramToVariableExpression)(p)} `))})`;
    }
    if (value && 'ref' in value)
        return (0, themeUtils_1.paramToVariableExpression)(value.ref);
    return false;
};
exports.lengthValueToCss = lengthValueToCss;
exports.scaleValueToCss = literalToCSS;
const borderValueToCss = (value, param) => {
    if (typeof value === 'string')
        return value;
    if (value === true)
        return (0, exports.borderValueToCss)({}, param);
    if (value === false)
        return param === 'columnBorder' ? (0, exports.borderValueToCss)({ color: 'transparent' }, param) : 'none';
    if (value && 'ref' in value)
        return (0, themeUtils_1.paramToVariableExpression)(value.ref);
    return ((0, exports.borderStyleValueToCss)(value.style ?? 'solid') +
        ' ' +
        (0, exports.lengthValueToCss)(value.width ?? { ref: 'borderWidth' }) +
        ' ' +
        (0, exports.colorValueToCss)(value.color ?? { ref: 'borderColor' }));
};
exports.borderValueToCss = borderValueToCss;
const shadowValueToCss = (value) => {
    if (typeof value === 'string')
        return value;
    if (value === false)
        return 'none';
    if (value && 'ref' in value)
        return (0, themeUtils_1.paramToVariableExpression)(value.ref);
    return [
        (0, exports.lengthValueToCss)(value.offsetX ?? 0),
        (0, exports.lengthValueToCss)(value.offsetY ?? 0),
        (0, exports.lengthValueToCss)(value.radius ?? 0),
        (0, exports.lengthValueToCss)(value.spread ?? 0),
        (0, exports.colorValueToCss)(value.color ?? { ref: 'foregroundColor' }),
    ].join(' ');
};
exports.shadowValueToCss = shadowValueToCss;
exports.borderStyleValueToCss = literalToCSS;
const fontFamilyValueToCss = (value) => {
    // normally string values are passed through as CSS without modification,
    // but for fonts this means you need to add internal quotes around font
    // names like `fontFamily: '"Times New Roman"'` which is a bit awkward. So
    // we add the quotes, unless a comma is present in which case we assume that
    // it's a list of correctly quoted font names
    if (typeof value === 'string')
        return value.includes(',') ? value : quoteUnsafeChars(value);
    if (value && 'googleFont' in value)
        return (0, exports.fontFamilyValueToCss)(value.googleFont);
    if (value && 'ref' in value)
        return (0, themeUtils_1.paramToVariableExpression)(value.ref);
    if (Array.isArray(value)) {
        return value
            .map((font) => {
            if (typeof font === 'object' && 'googleFont' in font) {
                font = font.googleFont;
            }
            return quoteUnsafeChars(font);
        })
            .join(', ');
    }
    return false;
};
exports.fontFamilyValueToCss = fontFamilyValueToCss;
const quoteUnsafeChars = (font) => 
// don't quote var() expressions or quote safe identifier names, so that
// people can specify fonts like sans-serif which are keywords not strings,
// or var(--my-var)
/^[\w-]+$|\w\(/.test(font) ? font : JSON.stringify(font);
exports.fontWeightValueToCss = literalToCSS;
const imageValueToCss = (value) => {
    if (typeof value === 'string')
        return value;
    if (value && 'url' in value)
        return `url(${JSON.stringify(value.url)})`;
    if (value && 'svg' in value)
        return (0, exports.imageValueToCss)({ url: `data:image/svg+xml,${encodeURIComponent(value.svg)}` });
    if (value && 'ref' in value)
        return (0, themeUtils_1.paramToVariableExpression)(value.ref);
    return false;
};
exports.imageValueToCss = imageValueToCss;
const durationValueToCss = (value, param, themeLogger) => {
    if (typeof value === 'string')
        return value;
    if (typeof value === 'number') {
        if (value >= 10) {
            themeLogger.warn(104, { value, param });
        }
        return `${value}s`;
    }
    if (value && 'ref' in value)
        return (0, themeUtils_1.paramToVariableExpression)(value.ref);
    return false;
};
exports.durationValueToCss = durationValueToCss;
const paramValidators = {
    color: exports.colorValueToCss,
    colorScheme: exports.colorSchemeValueToCss,
    length: exports.lengthValueToCss,
    scale: exports.scaleValueToCss,
    border: exports.borderValueToCss,
    borderStyle: exports.borderStyleValueToCss,
    shadow: exports.shadowValueToCss,
    image: exports.imageValueToCss,
    fontFamily: exports.fontFamilyValueToCss,
    fontWeight: exports.fontWeightValueToCss,
    duration: exports.durationValueToCss,
};
const paramValueToCss = (param, value, themeLogger) => {
    const type = (0, exports.getParamType)(param);
    return paramValidators[type](value, param, themeLogger);
};
exports.paramValueToCss = paramValueToCss;


/***/ }),

/***/ 19981:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.accentColor = exports.foregroundColor = exports.backgroundColor = exports.foregroundHeaderBackgroundMix = exports.foregroundBackgroundMix = exports.foregroundMix = exports.accentMix = exports.memoize = exports.clamp = exports.paramToVariableExpression = exports.paramToVariableName = void 0;
const kebabCase = (str) => str.replace(/[A-Z]/g, (m) => `-${m}`).toLowerCase();
const paramToVariableName = (paramName) => `--ag-${kebabCase(paramName)}`;
exports.paramToVariableName = paramToVariableName;
const paramToVariableExpression = (paramName) => `var(${(0, exports.paramToVariableName)(paramName)})`;
exports.paramToVariableExpression = paramToVariableExpression;
const clamp = (value, min, max) => Math.max(min, Math.min(max, value));
exports.clamp = clamp;
const memoize = (fn) => {
    const values = new Map();
    return (a) => {
        const key = a;
        if (!values.has(key)) {
            values.set(key, fn(a));
        }
        return values.get(key);
    };
};
exports.memoize = memoize;
const accentMix = (mix) => ({ ref: 'accentColor', mix });
exports.accentMix = accentMix;
const foregroundMix = (mix) => ({ ref: 'foregroundColor', mix });
exports.foregroundMix = foregroundMix;
const foregroundBackgroundMix = (mix) => ({
    ref: 'foregroundColor',
    mix,
    onto: 'backgroundColor',
});
exports.foregroundBackgroundMix = foregroundBackgroundMix;
const foregroundHeaderBackgroundMix = (mix) => ({
    ref: 'foregroundColor',
    mix,
    onto: 'headerBackgroundColor',
});
exports.foregroundHeaderBackgroundMix = foregroundHeaderBackgroundMix;
exports.backgroundColor = { ref: 'backgroundColor' };
exports.foregroundColor = { ref: 'foregroundColor' };
exports.accentColor = { ref: 'accentColor' };


/***/ }),

/***/ 56153:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgHighlightTooltipFeature = void 0;
const agTooltipFeature_1 = __webpack_require__(42663);
const baseTooltipStateManager_1 = __webpack_require__(94750);
class AgHighlightTooltipFeature extends agTooltipFeature_1.AgTooltipFeature {
    constructor(ctrl, highlightTracker, beans) {
        super(ctrl, beans);
        this.highlightTracker = highlightTracker;
        this.onHighlight = this.onHighlight.bind(this);
    }
    postConstruct() {
        super.postConstruct();
        this.wireHighlightListeners();
    }
    wireHighlightListeners() {
        this.addManagedPropertyListener('tooltipTrigger', ({ currentValue }) => {
            this.setTooltipMode(currentValue);
        });
        this.setTooltipMode(this.gos.get('tooltipTrigger'));
        this.highlightTracker.addEventListener('itemHighlighted', this.onHighlight);
    }
    onHighlight(event) {
        if (this.tooltipMode !== baseTooltipStateManager_1.TooltipTrigger.FOCUS) {
            return;
        }
        if (event.highlighted) {
            this.attemptToShowTooltip();
        }
        else {
            this.attemptToHideTooltip();
        }
    }
    setTooltipMode(tooltipTriggerMode = 'focus') {
        this.tooltipMode = tooltipTriggerMode === 'focus' ? baseTooltipStateManager_1.TooltipTrigger.FOCUS : baseTooltipStateManager_1.TooltipTrigger.HOVER;
    }
    destroy() {
        this.highlightTracker.removeEventListener('itemHighlighted', this.onHighlight);
        super.destroy();
    }
}
exports.AgHighlightTooltipFeature = AgHighlightTooltipFeature;


/***/ }),

/***/ 35654:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgTooltipComponent = void 0;
const agPopupComponent_1 = __webpack_require__(75298);
const string_1 = __webpack_require__(31931);
class AgTooltipComponent extends agPopupComponent_1.AgPopupComponent {
    constructor() {
        super({ tag: 'div', cls: 'ag-tooltip' });
    }
    // will need to type params
    init(params) {
        const { value } = params;
        const eGui = this.getGui();
        eGui.textContent = (0, string_1._toString)(value);
        const locationKebabCase = params.location.replace(/([a-z])([A-Z0-9])/g, '$1-$2').toLowerCase();
        eGui.classList.add(`ag-${locationKebabCase}-tooltip`);
    }
}
exports.AgTooltipComponent = AgTooltipComponent;


/***/ }),

/***/ 42663:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgTooltipFeature = void 0;
const agBeanStub_1 = __webpack_require__(74856);
class AgTooltipFeature extends agBeanStub_1.AgBeanStub {
    constructor(ctrl, beans) {
        super();
        this.ctrl = ctrl;
        if (beans) {
            this.beans = beans;
        }
    }
    postConstruct() {
        this.refreshTooltip();
    }
    /**
     *
     * @param tooltip The tooltip value
     * @param allowEmptyString Set it to true to allow the title to be set to `''`. This is necessary
     * when the browser adds a default tooltip the element and the tooltip service will be displayed
     * next to a browser tooltip causing confusion.
     */
    setBrowserTooltip(tooltip, allowEmptyString) {
        const name = 'title';
        const eGui = this.ctrl.getGui();
        if (!eGui) {
            return;
        }
        if (tooltip != null && (tooltip != '' || allowEmptyString)) {
            eGui.setAttribute(name, tooltip);
        }
        else {
            eGui.removeAttribute(name);
        }
    }
    updateTooltipText() {
        const { getTooltipValue } = this.ctrl;
        if (getTooltipValue) {
            this.tooltip = getTooltipValue();
        }
    }
    createTooltipFeatureIfNeeded() {
        if (this.tooltipManager == null) {
            const tooltipManager = this.beans.registry.createDynamicBean('tooltipStateManager', true, this.ctrl, () => this.tooltip);
            if (tooltipManager) {
                this.tooltipManager = this.createBean(tooltipManager, this.beans.context);
            }
        }
    }
    attemptToShowTooltip() {
        this.tooltipManager?.prepareToShowTooltip();
    }
    attemptToHideTooltip() {
        this.tooltipManager?.hideTooltip();
    }
    setTooltipAndRefresh(tooltip) {
        this.tooltip = tooltip;
        this.refreshTooltip();
    }
    refreshTooltip(clearWithEmptyString) {
        this.browserTooltips = this.beans.gos.get('enableBrowserTooltips');
        this.updateTooltipText();
        if (this.browserTooltips) {
            this.setBrowserTooltip(this.tooltip);
            this.tooltipManager = this.destroyBean(this.tooltipManager, this.beans.context);
        }
        else {
            this.setBrowserTooltip(clearWithEmptyString ? '' : null, clearWithEmptyString);
            this.createTooltipFeatureIfNeeded();
        }
    }
    destroy() {
        this.tooltipManager = this.destroyBean(this.tooltipManager, this.beans.context);
        super.destroy();
    }
}
exports.AgTooltipFeature = AgTooltipFeature;


/***/ }),

/***/ 94750:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseTooltipStateManager = exports.TooltipTrigger = void 0;
const agBeanStub_1 = __webpack_require__(74856);
const browser_1 = __webpack_require__(36916);
const document_1 = __webpack_require__(80011);
const generic_1 = __webpack_require__(89097);
var TooltipStates;
(function (TooltipStates) {
    TooltipStates[TooltipStates["NOTHING"] = 0] = "NOTHING";
    TooltipStates[TooltipStates["WAITING_TO_SHOW"] = 1] = "WAITING_TO_SHOW";
    TooltipStates[TooltipStates["SHOWING"] = 2] = "SHOWING";
})(TooltipStates || (TooltipStates = {}));
var TooltipTrigger;
(function (TooltipTrigger) {
    TooltipTrigger[TooltipTrigger["HOVER"] = 0] = "HOVER";
    TooltipTrigger[TooltipTrigger["FOCUS"] = 1] = "FOCUS";
})(TooltipTrigger || (exports.TooltipTrigger = TooltipTrigger = {}));
const SHOW_QUICK_TOOLTIP_DIFF = 1000;
const FADE_OUT_TOOLTIP_TIMEOUT = 1000;
const INTERACTIVE_HIDE_DELAY = 100;
// different instances of tooltipFeature use this to see when the
// last tooltip was hidden.
let lastTooltipHideTime;
let isLocked = false;
class BaseTooltipStateManager extends agBeanStub_1.AgBeanStub {
    wireBeans(beans) {
        this.popupSvc = beans.popupSvc;
    }
    constructor(tooltipCtrl, getTooltipValue) {
        super();
        this.tooltipCtrl = tooltipCtrl;
        this.getTooltipValue = getTooltipValue;
        this.interactionEnabled = false;
        this.isInteractingWithTooltip = false;
        this.state = TooltipStates.NOTHING;
        // when showing the tooltip, we need to make sure it's the most recent instance we request, as due to
        // async we could request two tooltips before the first instance returns, in which case we should
        // disregard the second instance.
        this.tooltipInstanceCount = 0;
        this.tooltipMouseTrack = false;
    }
    postConstruct() {
        if (this.gos.get('tooltipInteraction')) {
            this.interactionEnabled = true;
        }
        this.tooltipTrigger = this.getTooltipTrigger();
        this.tooltipMouseTrack = this.gos.get('tooltipMouseTrack');
        const el = this.tooltipCtrl.getGui();
        if (this.tooltipTrigger === TooltipTrigger.HOVER) {
            this.addManagedListeners(el, {
                mouseenter: this.onMouseEnter.bind(this),
                mouseleave: this.onMouseLeave.bind(this),
            });
        }
        if (this.tooltipTrigger === TooltipTrigger.FOCUS) {
            this.addManagedListeners(el, {
                focusin: this.onFocusIn.bind(this),
                focusout: this.onFocusOut.bind(this),
            });
        }
        this.addManagedListeners(el, { mousemove: this.onMouseMove.bind(this) });
        if (!this.interactionEnabled) {
            this.addManagedListeners(el, {
                mousedown: this.onMouseDown.bind(this),
                keydown: this.onKeyDown.bind(this),
            });
        }
    }
    getGridOptionsTooltipDelay(delayOption) {
        const delay = this.gos.get(delayOption);
        return Math.max(200, delay);
    }
    getTooltipDelay(type) {
        if (type === 'show') {
            return (this.tooltipCtrl.getTooltipShowDelayOverride?.() ?? this.getGridOptionsTooltipDelay('tooltipShowDelay'));
        }
        return this.tooltipCtrl.getTooltipHideDelayOverride?.() ?? this.getGridOptionsTooltipDelay('tooltipHideDelay');
    }
    destroy() {
        // if this component gets destroyed while tooltip is showing, need to make sure
        // we don't end with no mouseLeave event resulting in zombie tooltip
        this.setToDoNothing();
        super.destroy();
    }
    getTooltipTrigger() {
        const trigger = this.gos.get('tooltipTrigger');
        if (!trigger || trigger === 'hover') {
            return TooltipTrigger.HOVER;
        }
        return TooltipTrigger.FOCUS;
    }
    onMouseEnter(e) {
        // if `interactiveTooltipTimeoutId` is set, it means that this cell has a tooltip
        // and we are in the process of moving the cursor from the tooltip back to the cell
        // so we need to unlock this service here.
        if (this.interactionEnabled && this.interactiveTooltipTimeoutId) {
            this.unlockService();
            this.startHideTimeout();
        }
        if ((0, browser_1._isIOSUserAgent)()) {
            return;
        }
        if (isLocked) {
            this.showTooltipTimeoutId = window.setTimeout(() => {
                this.prepareToShowTooltip(e);
            }, INTERACTIVE_HIDE_DELAY);
        }
        else {
            this.prepareToShowTooltip(e);
        }
    }
    onMouseMove(e) {
        // there is a delay from the time we mouseOver a component and the time the
        // tooltip is displayed, so we need to track mousemove to be able to correctly
        // position the tooltip when showTooltip is called.
        if (this.lastMouseEvent) {
            this.lastMouseEvent = e;
        }
        if (this.tooltipMouseTrack && this.state === TooltipStates.SHOWING && this.tooltipComp) {
            this.positionTooltip();
        }
    }
    onMouseDown() {
        this.setToDoNothing();
    }
    onMouseLeave() {
        // if interaction is enabled, we need to verify if the user is moving
        // the cursor from the cell onto the tooltip, so we lock the service
        // for 100ms to prevent other tooltips from being created while this is happening.
        if (this.interactionEnabled) {
            this.lockService();
        }
        else {
            this.setToDoNothing();
        }
    }
    onFocusIn() {
        this.prepareToShowTooltip();
    }
    onFocusOut(e) {
        const relatedTarget = e.relatedTarget;
        const parentCompGui = this.tooltipCtrl.getGui();
        const tooltipGui = this.tooltipComp?.getGui();
        if (this.isInteractingWithTooltip ||
            parentCompGui.contains(relatedTarget) ||
            (this.interactionEnabled && tooltipGui?.contains(relatedTarget))) {
            return;
        }
        this.setToDoNothing();
    }
    onKeyDown() {
        // if the keydown happens outside of the tooltip, we cancel
        // the tooltip interaction and hide the tooltip.
        if (this.isInteractingWithTooltip) {
            this.isInteractingWithTooltip = false;
        }
        this.setToDoNothing();
    }
    prepareToShowTooltip(mouseEvent) {
        // every mouseenter should be following by a mouseleave, however for some unknown, it's possible for
        // mouseenter to be called twice in a row, which can happen if editing the cell. this was reported
        // in https://ag-grid.atlassian.net/browse/AG-4422. to get around this, we check the state, and if
        // state is != nothing, then we know mouseenter was already received.
        if (this.state != TooltipStates.NOTHING || isLocked) {
            return;
        }
        // if we are showing the tooltip because of focus, no delay at all
        // if another tooltip was hidden very recently, we only wait 200ms to show, not the normal waiting time
        let delay = 0;
        if (mouseEvent) {
            delay = this.isLastTooltipHiddenRecently() ? 200 : this.getTooltipDelay('show');
        }
        this.lastMouseEvent = mouseEvent || null;
        this.showTooltipTimeoutId = window.setTimeout(this.showTooltip.bind(this), delay);
        this.state = TooltipStates.WAITING_TO_SHOW;
    }
    isLastTooltipHiddenRecently() {
        // return true if <1000ms since last time we hid a tooltip
        const now = Date.now();
        const then = lastTooltipHideTime;
        return now - then < SHOW_QUICK_TOOLTIP_DIFF;
    }
    setToDoNothing(fromHideTooltip) {
        if (!fromHideTooltip && this.state === TooltipStates.SHOWING) {
            this.hideTooltip();
        }
        if (this.onBodyScrollEventCallback) {
            this.onBodyScrollEventCallback();
            this.onBodyScrollEventCallback = undefined;
        }
        this.clearEventHandlers();
        if (this.onDocumentKeyDownCallback) {
            this.onDocumentKeyDownCallback();
            this.onDocumentKeyDownCallback = undefined;
        }
        this.clearTimeouts();
        this.state = TooltipStates.NOTHING;
        this.lastMouseEvent = null;
    }
    showTooltip() {
        const value = this.getTooltipValue();
        const ctrl = this.tooltipCtrl;
        if (!(0, generic_1._exists)(value) || (ctrl.shouldDisplayTooltip && !ctrl.shouldDisplayTooltip())) {
            this.setToDoNothing();
            return;
        }
        const params = this.gos.addCommon({
            location: ctrl.getLocation?.() ?? 'UNKNOWN',
            value,
            hideTooltipCallback: () => this.hideTooltip(true),
            ...ctrl.getAdditionalParams?.(),
        });
        this.state = TooltipStates.SHOWING;
        this.tooltipInstanceCount++;
        // we pass in tooltipInstanceCount so the callback knows what the count was when
        // we requested the tooltip, so if another tooltip was requested in the mean time
        // we disregard it
        const callback = this.newTooltipComponentCallback.bind(this, this.tooltipInstanceCount);
        this.createTooltipComp(params, callback);
    }
    hideTooltip(forceHide) {
        if (!forceHide && this.isInteractingWithTooltip) {
            return;
        }
        // check if comp exists - due to async, although we asked for
        // one, the instance may not be back yet
        if (this.tooltipComp) {
            this.destroyTooltipComp();
            lastTooltipHideTime = Date.now();
        }
        this.eventSvc.dispatchEvent({
            type: 'tooltipHide',
            parentGui: this.tooltipCtrl.getGui(),
        });
        if (forceHide) {
            this.isInteractingWithTooltip = false;
        }
        this.setToDoNothing(true);
    }
    newTooltipComponentCallback(tooltipInstanceCopy, tooltipComp) {
        const compNoLongerNeeded = this.state !== TooltipStates.SHOWING || this.tooltipInstanceCount !== tooltipInstanceCopy;
        if (compNoLongerNeeded) {
            this.destroyBean(tooltipComp);
            return;
        }
        const eGui = tooltipComp.getGui();
        this.tooltipComp = tooltipComp;
        if (!eGui.classList.contains('ag-tooltip')) {
            eGui.classList.add('ag-tooltip-custom');
        }
        if (this.tooltipTrigger === TooltipTrigger.HOVER) {
            eGui.classList.add('ag-tooltip-animate');
        }
        if (this.interactionEnabled) {
            eGui.classList.add('ag-tooltip-interactive');
        }
        const translate = this.getLocaleTextFunc();
        const addPopupRes = this.popupSvc?.addPopup({
            eChild: eGui,
            ariaLabel: translate('ariaLabelTooltip', 'Tooltip'),
        });
        if (addPopupRes) {
            this.tooltipPopupDestroyFunc = addPopupRes.hideFunc;
        }
        this.positionTooltip();
        if (this.tooltipTrigger === TooltipTrigger.FOCUS) {
            const listener = () => this.setToDoNothing();
            [this.onBodyScrollEventCallback] = this.addManagedEventListeners({
                bodyScroll: listener,
            });
            this.setEventHandlers(listener);
        }
        if (this.interactionEnabled) {
            [this.tooltipMouseEnterListener, this.tooltipMouseLeaveListener] = this.addManagedElementListeners(eGui, {
                mouseenter: this.onTooltipMouseEnter.bind(this),
                mouseleave: this.onTooltipMouseLeave.bind(this),
            });
            [this.onDocumentKeyDownCallback] = this.addManagedElementListeners((0, document_1._getDocument)(this.beans), {
                keydown: (e) => {
                    if (!eGui.contains(e?.target)) {
                        this.onKeyDown();
                    }
                },
            });
            if (this.tooltipTrigger === TooltipTrigger.FOCUS) {
                [this.tooltipFocusInListener, this.tooltipFocusOutListener] = this.addManagedElementListeners(eGui, {
                    focusin: this.onTooltipFocusIn.bind(this),
                    focusout: this.onTooltipFocusOut.bind(this),
                });
            }
        }
        this.eventSvc.dispatchEvent({
            type: 'tooltipShow',
            tooltipGui: eGui,
            parentGui: this.tooltipCtrl.getGui(),
        });
        this.startHideTimeout();
    }
    onTooltipMouseEnter() {
        this.isInteractingWithTooltip = true;
        this.unlockService();
    }
    onTooltipMouseLeave() {
        if (this.isTooltipFocused()) {
            return;
        }
        this.isInteractingWithTooltip = false;
        this.lockService();
    }
    onTooltipFocusIn() {
        this.isInteractingWithTooltip = true;
    }
    isTooltipFocused() {
        const tooltipGui = this.tooltipComp?.getGui();
        const activeEl = (0, document_1._getActiveDomElement)(this.beans);
        return !!tooltipGui && tooltipGui.contains(activeEl);
    }
    onTooltipFocusOut(e) {
        const parentGui = this.tooltipCtrl.getGui();
        // focusout is dispatched when inner elements lose focus
        // so we need to verify if focus is contained within the tooltip
        if (this.isTooltipFocused()) {
            return;
        }
        this.isInteractingWithTooltip = false;
        // if we move the focus from the tooltip back to the original cell
        // the tooltip should remain open, but we need to restart the hide timeout counter
        if (parentGui.contains(e.relatedTarget)) {
            this.startHideTimeout();
        }
        // if the parent cell doesn't contain the focus, simply hide the tooltip
        else {
            this.hideTooltip();
        }
    }
    positionTooltip() {
        const params = {
            type: 'tooltip',
            ePopup: this.tooltipComp.getGui(),
            nudgeY: 18,
            skipObserver: this.tooltipMouseTrack,
        };
        if (this.lastMouseEvent) {
            this.popupSvc?.positionPopupUnderMouseEvent({
                ...params,
                mouseEvent: this.lastMouseEvent,
            });
        }
        else {
            this.popupSvc?.positionPopupByComponent({
                ...params,
                eventSource: this.tooltipCtrl.getGui(),
                position: 'under',
                keepWithinBounds: true,
                nudgeY: 5,
            });
        }
    }
    destroyTooltipComp() {
        // add class to fade out the tooltip
        this.tooltipComp.getGui().classList.add('ag-tooltip-hiding');
        // make local copies of these variables, as we use them in the async function below,
        // and we clear then to 'undefined' later, so need to take a copy before they are undefined.
        const tooltipPopupDestroyFunc = this.tooltipPopupDestroyFunc;
        const tooltipComp = this.tooltipComp;
        const delay = this.tooltipTrigger === TooltipTrigger.HOVER ? FADE_OUT_TOOLTIP_TIMEOUT : 0;
        window.setTimeout(() => {
            tooltipPopupDestroyFunc();
            this.destroyBean(tooltipComp);
        }, delay);
        this.clearTooltipListeners();
        this.tooltipPopupDestroyFunc = undefined;
        this.tooltipComp = undefined;
    }
    clearTooltipListeners() {
        [
            this.tooltipMouseEnterListener,
            this.tooltipMouseLeaveListener,
            this.tooltipFocusInListener,
            this.tooltipFocusOutListener,
        ].forEach((listener) => {
            if (listener) {
                listener();
            }
        });
        this.tooltipMouseEnterListener =
            this.tooltipMouseLeaveListener =
                this.tooltipFocusInListener =
                    this.tooltipFocusOutListener =
                        null;
    }
    lockService() {
        isLocked = true;
        this.interactiveTooltipTimeoutId = window.setTimeout(() => {
            this.unlockService();
            this.setToDoNothing();
        }, INTERACTIVE_HIDE_DELAY);
    }
    unlockService() {
        isLocked = false;
        this.clearInteractiveTimeout();
    }
    startHideTimeout() {
        this.clearHideTimeout();
        this.hideTooltipTimeoutId = window.setTimeout(this.hideTooltip.bind(this), this.getTooltipDelay('hide'));
    }
    clearShowTimeout() {
        if (!this.showTooltipTimeoutId) {
            return;
        }
        window.clearTimeout(this.showTooltipTimeoutId);
        this.showTooltipTimeoutId = undefined;
    }
    clearHideTimeout() {
        if (!this.hideTooltipTimeoutId) {
            return;
        }
        window.clearTimeout(this.hideTooltipTimeoutId);
        this.hideTooltipTimeoutId = undefined;
    }
    clearInteractiveTimeout() {
        if (!this.interactiveTooltipTimeoutId) {
            return;
        }
        window.clearTimeout(this.interactiveTooltipTimeoutId);
        this.interactiveTooltipTimeoutId = undefined;
    }
    clearTimeouts() {
        this.clearShowTimeout();
        this.clearHideTimeout();
        this.clearInteractiveTimeout();
    }
}
exports.BaseTooltipStateManager = BaseTooltipStateManager;


/***/ }),

/***/ 14336:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.tooltipCSS = void 0;
exports.tooltipCSS = `.ag-tooltip{background-color:var(--ag-tooltip-background-color);border:var(--ag-tooltip-border);border-radius:var(--ag-border-radius);color:var(--ag-tooltip-text-color);padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);position:absolute;white-space:normal;z-index:99999;&:where(.ag-cell-editor-tooltip){background-color:var(--ag-tooltip-error-background-color);border:var(--ag-tooltip-error-border);color:var(--ag-tooltip-error-text-color);font-weight:500}}.ag-tooltip-custom{position:absolute;z-index:99999}.ag-tooltip-custom:where(:not(.ag-tooltip-interactive)),.ag-tooltip:where(:not(.ag-tooltip-interactive)){pointer-events:none}.ag-tooltip-animate{transition:opacity 1s;&:where(.ag-tooltip-hiding){opacity:0}}`;


/***/ }),

/***/ 91623:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getAriaCheckboxStateName = exports._setAriaHasPopup = exports._setAriaOwns = exports._setAriaControlsAndLabel = exports._setAriaControls = exports._setAriaChecked = exports._setAriaSelected = exports._removeAriaSort = exports._setAriaSort = exports._setAriaColSpan = exports._setAriaColIndex = exports._setAriaColCount = exports._setAriaRowSpan = exports._setAriaRowIndex = exports._setAriaRowCount = exports._setAriaMultiSelectable = exports._setAriaPosInSet = exports._setAriaSetSize = exports._removeAriaExpanded = exports._setAriaExpanded = exports._setAriaActiveDescendant = exports._setAriaHidden = exports._setAriaDisabled = exports._setAriaLevel = exports._setAriaInvalid = exports._setAriaRelevant = exports._setAriaAtomic = exports._setAriaLive = exports._setAriaDescribedBy = exports._setAriaLabelledBy = exports._setAriaLabel = exports._getAriaLabel = exports._getAriaPosInSet = exports._getAriaSortState = exports._setAriaRole = void 0;
// ARIA HELPER FUNCTIONS
function _toggleAriaAttribute(element, attribute, value) {
    if (value == null || (typeof value === 'string' && value == '')) {
        _removeAriaAttribute(element, attribute);
    }
    else {
        _setAriaAttribute(element, attribute, value);
    }
}
function _setAriaAttribute(element, attribute, value) {
    element.setAttribute(_ariaAttributeName(attribute), value.toString());
}
function _removeAriaAttribute(element, attribute) {
    element.removeAttribute(_ariaAttributeName(attribute));
}
function _ariaAttributeName(attribute) {
    return `aria-${attribute}`;
}
function _setAriaRole(element, role) {
    if (role) {
        element.setAttribute('role', role);
    }
    else {
        element.removeAttribute('role');
    }
}
exports._setAriaRole = _setAriaRole;
function _getAriaSortState(sortDirection) {
    let sort;
    if (sortDirection === 'asc') {
        sort = 'ascending';
    }
    else if (sortDirection === 'desc') {
        sort = 'descending';
    }
    else if (sortDirection === 'mixed') {
        sort = 'other';
    }
    else {
        sort = 'none';
    }
    return sort;
}
exports._getAriaSortState = _getAriaSortState;
// ARIA ATTRIBUTE GETTERS
function _getAriaPosInSet(element) {
    return parseInt(element.getAttribute('aria-posinset'), 10);
}
exports._getAriaPosInSet = _getAriaPosInSet;
function _getAriaLabel(element) {
    return element.getAttribute('aria-label');
}
exports._getAriaLabel = _getAriaLabel;
// ARIA ATTRIBUTE SETTERS
function _setAriaLabel(element, label) {
    _toggleAriaAttribute(element, 'label', label);
}
exports._setAriaLabel = _setAriaLabel;
function _setAriaLabelledBy(element, labelledBy) {
    _toggleAriaAttribute(element, 'labelledby', labelledBy);
}
exports._setAriaLabelledBy = _setAriaLabelledBy;
function _setAriaDescribedBy(element, describedby) {
    _toggleAriaAttribute(element, 'describedby', describedby);
}
exports._setAriaDescribedBy = _setAriaDescribedBy;
function _setAriaLive(element, live) {
    _toggleAriaAttribute(element, 'live', live);
}
exports._setAriaLive = _setAriaLive;
function _setAriaAtomic(element, atomic) {
    _toggleAriaAttribute(element, 'atomic', atomic);
}
exports._setAriaAtomic = _setAriaAtomic;
function _setAriaRelevant(element, relevant) {
    _toggleAriaAttribute(element, 'relevant', relevant);
}
exports._setAriaRelevant = _setAriaRelevant;
function _setAriaInvalid(element, invalid) {
    _toggleAriaAttribute(element, 'invalid', invalid);
}
exports._setAriaInvalid = _setAriaInvalid;
function _setAriaLevel(element, level) {
    _toggleAriaAttribute(element, 'level', level);
}
exports._setAriaLevel = _setAriaLevel;
function _setAriaDisabled(element, disabled) {
    _toggleAriaAttribute(element, 'disabled', disabled);
}
exports._setAriaDisabled = _setAriaDisabled;
function _setAriaHidden(element, hidden) {
    _toggleAriaAttribute(element, 'hidden', hidden);
}
exports._setAriaHidden = _setAriaHidden;
function _setAriaActiveDescendant(element, descendantId) {
    _toggleAriaAttribute(element, 'activedescendant', descendantId);
}
exports._setAriaActiveDescendant = _setAriaActiveDescendant;
function _setAriaExpanded(element, expanded) {
    _setAriaAttribute(element, 'expanded', expanded);
}
exports._setAriaExpanded = _setAriaExpanded;
function _removeAriaExpanded(element) {
    _removeAriaAttribute(element, 'expanded');
}
exports._removeAriaExpanded = _removeAriaExpanded;
function _setAriaSetSize(element, setsize) {
    _setAriaAttribute(element, 'setsize', setsize);
}
exports._setAriaSetSize = _setAriaSetSize;
function _setAriaPosInSet(element, position) {
    _setAriaAttribute(element, 'posinset', position);
}
exports._setAriaPosInSet = _setAriaPosInSet;
function _setAriaMultiSelectable(element, multiSelectable) {
    _setAriaAttribute(element, 'multiselectable', multiSelectable);
}
exports._setAriaMultiSelectable = _setAriaMultiSelectable;
function _setAriaRowCount(element, rowCount) {
    _setAriaAttribute(element, 'rowcount', rowCount);
}
exports._setAriaRowCount = _setAriaRowCount;
function _setAriaRowIndex(element, rowIndex) {
    _setAriaAttribute(element, 'rowindex', rowIndex);
}
exports._setAriaRowIndex = _setAriaRowIndex;
function _setAriaRowSpan(element, spanCount) {
    _setAriaAttribute(element, 'rowspan', spanCount);
}
exports._setAriaRowSpan = _setAriaRowSpan;
function _setAriaColCount(element, colCount) {
    _setAriaAttribute(element, 'colcount', colCount);
}
exports._setAriaColCount = _setAriaColCount;
function _setAriaColIndex(element, colIndex) {
    _setAriaAttribute(element, 'colindex', colIndex);
}
exports._setAriaColIndex = _setAriaColIndex;
function _setAriaColSpan(element, colSpan) {
    _setAriaAttribute(element, 'colspan', colSpan);
}
exports._setAriaColSpan = _setAriaColSpan;
function _setAriaSort(element, sort) {
    _setAriaAttribute(element, 'sort', sort);
}
exports._setAriaSort = _setAriaSort;
function _removeAriaSort(element) {
    _removeAriaAttribute(element, 'sort');
}
exports._removeAriaSort = _removeAriaSort;
function _setAriaSelected(element, selected) {
    _toggleAriaAttribute(element, 'selected', selected);
}
exports._setAriaSelected = _setAriaSelected;
function _setAriaChecked(element, checked) {
    _setAriaAttribute(element, 'checked', checked === undefined ? 'mixed' : checked);
}
exports._setAriaChecked = _setAriaChecked;
function _setAriaControls(controllerElement, controlledId) {
    _toggleAriaAttribute(controllerElement, 'controls', controlledId);
}
exports._setAriaControls = _setAriaControls;
function _setAriaControlsAndLabel(controllerElement, controlledElement) {
    _setAriaControls(controllerElement, controlledElement.id);
    _setAriaLabelledBy(controlledElement, controllerElement.id);
}
exports._setAriaControlsAndLabel = _setAriaControlsAndLabel;
function _setAriaOwns(ownerElement, ownedId) {
    _toggleAriaAttribute(ownerElement, 'owns', ownedId);
}
exports._setAriaOwns = _setAriaOwns;
function _setAriaHasPopup(element, hasPopup) {
    _toggleAriaAttribute(element, 'haspopup', hasPopup === false ? null : hasPopup);
}
exports._setAriaHasPopup = _setAriaHasPopup;
function _getAriaCheckboxStateName(translate, state) {
    return state === undefined
        ? translate('ariaIndeterminate', 'indeterminate')
        : state === true
            ? translate('ariaChecked', 'checked')
            : translate('ariaUnchecked', 'unchecked');
}
exports._getAriaCheckboxStateName = _getAriaCheckboxStateName;


/***/ }),

/***/ 79909:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._flatten = exports._moveInArray = exports._removeFromArray = exports._forAll = exports._areEqual = exports._last = exports._EmptyArray = void 0;
/** An array that is always empty and that cannot be modified */
exports._EmptyArray = Object.freeze([]);
function _last(arr) {
    if (!arr?.length) {
        return;
    }
    return arr[arr.length - 1];
}
exports._last = _last;
function _areEqual(a, b, comparator) {
    if (a === b) {
        return true; // Same instance, no need to compare
    }
    if (!a || !b) {
        return a == null && b == null; // True if both are null or undefined, false otherwise
    }
    const len = a.length;
    if (len !== b.length) {
        return false; // Different lengths, cannot be equal
    }
    for (let i = 0; i < len; i++) {
        // We don't need to invoke the comparator if the values are the same instance
        if (a[i] !== b[i] && !comparator?.(a[i], b[i])) {
            return false; // Instances are different and not equal according to the comparator
        }
    }
    return true; // Arrays are equal
}
exports._areEqual = _areEqual;
/**
 * Utility that uses the fastest looping approach to apply a callback to each element of the array
 * https://jsperf.app/for-for-of-for-in-foreach-comparison
 */
function _forAll(array, callback) {
    if (!array) {
        return;
    }
    for (const value of array) {
        callback(value);
    }
}
exports._forAll = _forAll;
function _removeFromArray(array, object) {
    const index = array.indexOf(object);
    if (index >= 0) {
        array.splice(index, 1);
    }
}
exports._removeFromArray = _removeFromArray;
// should consider refactoring the callers to create a new array rather than mutating the original, which is expensive
function _moveInArray(array, objectsToMove, toIndex) {
    // first take out items from the array
    for (let i = 0; i < objectsToMove.length; i++) {
        _removeFromArray(array, objectsToMove[i]);
    }
    // now add the objects, in same order as provided to us, that means we start at the end
    // as the objects will be pushed to the right as they are inserted
    for (let i = objectsToMove.length - 1; i >= 0; i--) {
        array.splice(toIndex, 0, objectsToMove[i]);
    }
}
exports._moveInArray = _moveInArray;
function _flatten(arrays) {
    // Currently the fastest way to flatten an array according to https://jsbench.me/adlib26t2y/2
    return [].concat.apply([], arrays);
}
exports._flatten = _flatten;


/***/ }),

/***/ 36916:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._isInvisibleScrollbar = exports._getScrollbarWidth = exports._getMaxDivHeight = exports._getTabIndex = exports._isIOSUserAgent = exports._isMacOsUserAgent = exports._isBrowserFirefox = exports._isBrowserSafari = void 0;
/**
 * These variables are lazy loaded, as otherwise they try and get initialised when we are loading
 * unit tests and we don't have references to window or document in the unit tests
 */
let isSafari;
// let isChrome: boolean;
let isFirefox;
let isMacOs;
let isIOS;
let invisibleScrollbar;
let browserScrollbarWidth;
let maxDivHeight;
function _isBrowserSafari() {
    if (isSafari === undefined) {
        isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
    }
    return isSafari;
}
exports._isBrowserSafari = _isBrowserSafari;
/**
 * Returns true for Chrome and also for Edge (Chromium)
 */
// export function _isBrowserChrome(): boolean {
//     if (isChrome === undefined) {
//         const win = window as any;
//         isChrome =
//             (!!win.chrome && (!!win.chrome.webstore || !!win.chrome.runtime)) ||
//             (/Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor));
//     }
//     return isChrome;
// }
function _isBrowserFirefox() {
    if (isFirefox === undefined) {
        isFirefox = /(firefox)/i.test(navigator.userAgent);
    }
    return isFirefox;
}
exports._isBrowserFirefox = _isBrowserFirefox;
function _isMacOsUserAgent() {
    if (isMacOs === undefined) {
        isMacOs = /(Mac|iPhone|iPod|iPad)/i.test(navigator.platform);
    }
    return isMacOs;
}
exports._isMacOsUserAgent = _isMacOsUserAgent;
function _isIOSUserAgent() {
    if (isIOS === undefined) {
        isIOS =
            /iPad|iPhone|iPod/.test(navigator.platform) ||
                (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1);
    }
    return isIOS;
}
exports._isIOSUserAgent = _isIOSUserAgent;
function _getTabIndex(el) {
    if (!el) {
        return null;
    }
    const numberTabIndex = el.tabIndex;
    const tabIndex = el.getAttribute('tabIndex');
    if (numberTabIndex === -1 && (tabIndex === null || (tabIndex === '' && !_isBrowserFirefox()))) {
        return null;
    }
    return numberTabIndex.toString();
}
exports._getTabIndex = _getTabIndex;
function _getMaxDivHeight() {
    if (maxDivHeight !== undefined) {
        return maxDivHeight;
    }
    if (!document.body) {
        return -1;
    }
    let res = 1000000;
    // FF reports the height back but still renders blank after ~6M px
    const testUpTo = _isBrowserFirefox() ? 6000000 : 1000000000;
    const div = document.createElement('div');
    document.body.appendChild(div);
    while (true) {
        const test = res * 2;
        div.style.height = test + 'px';
        if (test > testUpTo || div.clientHeight !== test) {
            break;
        }
        else {
            res = test;
        }
    }
    document.body.removeChild(div);
    maxDivHeight = res;
    return res;
}
exports._getMaxDivHeight = _getMaxDivHeight;
function _getScrollbarWidth() {
    if (browserScrollbarWidth == null) {
        initScrollbarWidthAndVisibility();
    }
    return browserScrollbarWidth;
}
exports._getScrollbarWidth = _getScrollbarWidth;
function initScrollbarWidthAndVisibility() {
    const body = document.body;
    const div = document.createElement('div');
    div.style.width = div.style.height = '100px';
    div.style.opacity = '0';
    div.style.overflow = 'scroll';
    div.style.msOverflowStyle = 'scrollbar'; // needed for WinJS apps
    div.style.position = 'absolute';
    body.appendChild(div);
    let width = div.offsetWidth - div.clientWidth;
    // if width is 0 and client width is 0, means the DOM isn't ready
    if (width === 0 && div.clientWidth === 0) {
        width = null;
    }
    // remove div
    if (div.parentNode) {
        div.parentNode.removeChild(div);
    }
    if (width != null) {
        browserScrollbarWidth = width;
        invisibleScrollbar = width === 0;
    }
}
function _isInvisibleScrollbar() {
    if (invisibleScrollbar == null) {
        initScrollbarWidthAndVisibility();
    }
    return invisibleScrollbar;
}
exports._isInvisibleScrollbar = _isInvisibleScrollbar;


/***/ }),

/***/ 97066:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._parseDateTimeFromString = exports._isValidDateTime = exports._isValidDate = exports._dateToFormattedString = exports.MONTHS = exports._getDateParts = exports._serialiseDate = void 0;
const DATE_TIME_SEPARATOR = 'T';
/** Spaces are allowed for legacy reasons to support date filter models */
const DATE_TIME_SEPARATOR_REGEXP = new RegExp(`[${DATE_TIME_SEPARATOR} ]`);
/**
 * Executing this against date produces the following:
 * ["2008-08-24T21:00:08"," 21:00:08"]
 */
const DATE_TIME_REGEXP = new RegExp(`^\\d{4}-\\d{2}-\\d{2}(${DATE_TIME_SEPARATOR}\\d{2}:\\d{2}:\\d{2}\\D?)?`);
function _padStartWidthZeros(value, totalStringSize) {
    return value.toString().padStart(totalStringSize, '0');
}
/**
 * Serialises a Date to a string of format `yyyy-MM-ddTHH:mm:ss`.
 * An alternative separator can be provided to be used instead of hyphens.
 * @param date The date to serialise
 * @param includeTime Whether to include the time in the serialised string
 * @param separator The separator to use between date and time parts (default 'T')
 */
function _serialiseDate(date, includeTime = true, separator = DATE_TIME_SEPARATOR) {
    if (!date) {
        return null;
    }
    let serialised = [date.getFullYear(), date.getMonth() + 1, date.getDate()]
        .map((part) => _padStartWidthZeros(part, 2))
        .join('-');
    if (includeTime) {
        serialised +=
            separator +
                [date.getHours(), date.getMinutes(), date.getSeconds()]
                    .map((part) => _padStartWidthZeros(part, 2))
                    .join(':');
    }
    return serialised;
}
exports._serialiseDate = _serialiseDate;
/**
 * Helper function to get the date parts of a date. Used in set filter.
 * @param d The date to get the parts from
 * @param includeTime Whether to include the time in the returned array
 * @returns The date parts as an array of strings or null if the date is null or undefined
 */
function _getDateParts(d, includeTime = true) {
    if (!d) {
        return null;
    }
    if (includeTime) {
        return [
            String(d.getFullYear()),
            String(d.getMonth() + 1),
            _padStartWidthZeros(d.getDate(), 2),
            _padStartWidthZeros(d.getHours(), 2),
            `:${_padStartWidthZeros(d.getMinutes(), 2)}`,
            `:${_padStartWidthZeros(d.getSeconds(), 2)}`,
        ];
    }
    return [d.getFullYear(), d.getMonth() + 1, _padStartWidthZeros(d.getDate(), 2)].map(String);
}
exports._getDateParts = _getDateParts;
const calculateOrdinal = (value) => {
    if (value > 3 && value < 21) {
        return 'th';
    }
    const remainder = value % 10;
    switch (remainder) {
        case 1:
            return 'st';
        case 2:
            return 'nd';
        case 3:
            return 'rd';
    }
    return 'th';
};
exports.MONTHS = [
    'January',
    'February',
    'March',
    'April',
    'May',
    'June',
    'July',
    'August',
    'September',
    'October',
    'November',
    'December',
];
const DAYS = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
/**
 * Serialises a Date to a string of format the defined format, does not include time.
 * @param date The date to serialise
 * @param format The string to format the date to, defaults to YYYY-MM-DD
 */
function _dateToFormattedString(date, format) {
    if (format == null) {
        // returns YYYY-MM-DD, but is more efficient
        return _serialiseDate(date, false);
    }
    const fullYear = _padStartWidthZeros(date.getFullYear(), 4);
    const replace = {
        YYYY: () => fullYear.slice(fullYear.length - 4, fullYear.length),
        YY: () => fullYear.slice(fullYear.length - 2, fullYear.length),
        Y: () => `${date.getFullYear()}`,
        MMMM: () => exports.MONTHS[date.getMonth()],
        MMM: () => exports.MONTHS[date.getMonth()].slice(0, 3),
        MM: () => _padStartWidthZeros(date.getMonth() + 1, 2),
        Mo: () => `${date.getMonth() + 1}${calculateOrdinal(date.getMonth() + 1)}`,
        M: () => `${date.getMonth() + 1}`,
        Do: () => `${date.getDate()}${calculateOrdinal(date.getDate())}`,
        DD: () => _padStartWidthZeros(date.getDate(), 2),
        D: () => `${date.getDate()}`,
        dddd: () => DAYS[date.getDay()],
        ddd: () => DAYS[date.getDay()].slice(0, 3),
        dd: () => DAYS[date.getDay()].slice(0, 2),
        do: () => `${date.getDay()}${calculateOrdinal(date.getDay())}`,
        d: () => `${date.getDay()}`,
    };
    const regexp = new RegExp(Object.keys(replace).join('|'), 'g');
    return format.replace(regexp, (match) => {
        if (match in replace) {
            return replace[match]();
        }
        return match;
    });
}
exports._dateToFormattedString = _dateToFormattedString;
/**
 * Helper function to check if a date is valid. Use isValidDateTime() to check if a date is valid and has time parts.
 */
function _isValidDate(value, bailIfInvalidTime = false) {
    return !!_parseDateTimeFromString(value, bailIfInvalidTime);
}
exports._isValidDate = _isValidDate;
// check if dateTime is a valid date and has time parts
function _isValidDateTime(value) {
    return _isValidDate(value, true);
}
exports._isValidDateTime = _isValidDateTime;
/**
 * Parses a date and time from a string. Expected format is ISO-compatible `yyyy-MM-dd` or `yyyy-MM-ddTHH:mm:ssZ`.
 *
 * Because of javascript historical reasons, we need to parse the datetime manually:
 * Per MDN:
 *   When the time zone offset is absent, **date-only** forms are interpreted as a UTC time and **date-time** forms are interpreted as a local time.
 *   The interpretation as a UTC time is due to a historical spec error that was not consistent with ISO 8601 but could not be changed due to web compatibility.
 */
function _parseDateTimeFromString(value, bailIfInvalidTime = false, skipValidation) {
    if (!value) {
        return null;
    }
    if (!skipValidation && !DATE_TIME_REGEXP.test(value)) {
        return null;
    }
    const [dateStr, timeStr] = value.split(DATE_TIME_SEPARATOR_REGEXP);
    if (!dateStr) {
        return null;
    }
    const fields = dateStr.split('-').map((f) => parseInt(f, 10));
    if (fields.filter((f) => !isNaN(f)).length !== 3) {
        return null;
    }
    const [year, month, day] = fields;
    const date = new Date(year, month - 1, day);
    if (date.getFullYear() !== year || date.getMonth() !== month - 1 || date.getDate() !== day) {
        // date was not parsed as expected so must have been invalid
        return null;
    }
    if (!timeStr && bailIfInvalidTime) {
        return null;
    }
    if (!timeStr || timeStr === '00:00:00') {
        return date;
    }
    const [hours, minutes, seconds] = timeStr.split(':').map((part) => parseInt(part, 10)); // if last part includes Z, it is dropped here
    if (hours >= 0 && hours < 24) {
        date.setHours(hours);
    }
    else if (bailIfInvalidTime) {
        return null;
    }
    if (minutes >= 0 && minutes < 60) {
        date.setMinutes(minutes);
    }
    else if (bailIfInvalidTime) {
        return null;
    }
    if (seconds >= 0 && seconds < 60) {
        date.setSeconds(seconds);
    }
    else if (bailIfInvalidTime) {
        return null;
    }
    return date;
}
exports._parseDateTimeFromString = _parseDateTimeFromString;


/***/ }),

/***/ 80011:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getBodyHeight = exports._getBodyWidth = exports._getPageBody = exports._getWindow = exports._isNothingFocused = exports._getDocument = exports._getActiveDomElement = exports._getRootNode = void 0;
const generic_1 = __webpack_require__(89097);
function _getRootNode(beans) {
    return beans.eRootDiv.getRootNode();
}
exports._getRootNode = _getRootNode;
function _getActiveDomElement(beans) {
    return _getRootNode(beans).activeElement;
}
exports._getActiveDomElement = _getActiveDomElement;
function _getDocument(beans) {
    // if user is providing document, we use the users one,
    // otherwise we use the document on the global namespace.
    const { gos, eRootDiv } = beans;
    let result = null;
    const optionsGetDocument = gos.get('getDocument');
    if (optionsGetDocument && (0, generic_1._exists)(optionsGetDocument)) {
        result = optionsGetDocument();
    }
    else if (eRootDiv) {
        result = eRootDiv.ownerDocument;
    }
    if (result && (0, generic_1._exists)(result)) {
        return result;
    }
    return document;
}
exports._getDocument = _getDocument;
function _isNothingFocused(beans) {
    const activeEl = _getActiveDomElement(beans);
    return activeEl === null || activeEl === _getDocument(beans).body;
}
exports._isNothingFocused = _isNothingFocused;
function _getWindow(beans) {
    const eDocument = _getDocument(beans);
    return eDocument.defaultView || window;
}
exports._getWindow = _getWindow;
function _getPageBody(beans) {
    let rootNode = null;
    let targetEl = null;
    try {
        rootNode = _getDocument(beans).fullscreenElement;
    }
    catch (e) {
        // some environments like SalesForce will throw errors
        // simply by trying to read the fullscreenElement property
    }
    finally {
        if (!rootNode) {
            rootNode = _getRootNode(beans);
        }
        const body = rootNode.querySelector('body');
        if (body) {
            targetEl = body;
        }
        else if (rootNode instanceof ShadowRoot) {
            targetEl = rootNode;
        }
        else if (rootNode instanceof Document) {
            targetEl = rootNode?.documentElement;
        }
        else {
            targetEl = rootNode;
        }
    }
    return targetEl;
}
exports._getPageBody = _getPageBody;
function _getBodyWidth(beans) {
    const body = _getPageBody(beans);
    return body?.clientWidth ?? (window.innerWidth || -1);
}
exports._getBodyWidth = _getBodyWidth;
function _getBodyHeight(beans) {
    const body = _getPageBody(beans);
    return body?.clientHeight ?? (window.innerHeight || -1);
}
exports._getBodyHeight = _getBodyHeight;


/***/ }),

/***/ 1956:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._createAgElement = exports.DataRefAttribute = exports._requestAnimationFrame = exports._observeResize = exports._addOrRemoveAttribute = exports._isNodeOrElement = exports._formatSize = exports._setFixedHeight = exports._setFixedWidth = exports._setElementWidth = exports._isVerticalScrollShowing = exports._isHorizontalScrollShowing = exports._isElementOverflowingCallback = exports._addStylesToElement = exports._setDomChildOrder = exports._ensureDomOrder = exports._loadTemplate = exports._isVisible = exports._isInDOM = exports._removeFromParent = exports._clearElement = exports._setScrollLeft = exports._getScrollLeft = exports._getElementRectWithOffset = exports._getAbsoluteWidth = exports._getAbsoluteHeight = exports._getInnerWidth = exports._getInnerHeight = exports._getElementSize = exports._isElementChildOfClass = exports._setDisabled = exports._setVisible = exports._setDisplayed = exports._isFocusableFormField = exports.FOCUSABLE_EXCLUDE = exports.FOCUSABLE_SELECTOR = exports._radioCssClass = void 0;
const aria_1 = __webpack_require__(91623);
const document_1 = __webpack_require__(80011);
/**
 * This method adds a class to an element and remove that class from all siblings.
 * Useful for toggling state.
 * @param {HTMLElement} element The element to receive the class
 * @param {string} elementClass The class to be assigned to the element
 * @param {boolean} otherElementClass The class to be assigned to siblings of the element, but not the element itself
 */
function _radioCssClass(element, elementClass, otherElementClass) {
    const parent = element.parentElement;
    let sibling = parent && parent.firstChild;
    while (sibling) {
        if (elementClass) {
            sibling.classList.toggle(elementClass, sibling === element);
        }
        if (otherElementClass) {
            sibling.classList.toggle(otherElementClass, sibling !== element);
        }
        sibling = sibling.nextSibling;
    }
}
exports._radioCssClass = _radioCssClass;
exports.FOCUSABLE_SELECTOR = '[tabindex], input, select, button, textarea, [href]';
exports.FOCUSABLE_EXCLUDE = '[disabled], .ag-disabled:not(.ag-button), .ag-disabled *';
function _isFocusableFormField(element) {
    const matches = Element.prototype.matches || Element.prototype.msMatchesSelector;
    const inputSelector = 'input, select, button, textarea';
    const isFocusable = matches.call(element, inputSelector);
    const isNotFocusable = matches.call(element, exports.FOCUSABLE_EXCLUDE);
    const isElementVisible = _isVisible(element);
    const focusable = isFocusable && !isNotFocusable && isElementVisible;
    return focusable;
}
exports._isFocusableFormField = _isFocusableFormField;
function _setDisplayed(element, displayed, options = {}) {
    const { skipAriaHidden } = options;
    element.classList.toggle('ag-hidden', !displayed);
    if (!skipAriaHidden) {
        (0, aria_1._setAriaHidden)(element, !displayed);
    }
}
exports._setDisplayed = _setDisplayed;
function _setVisible(element, visible, options = {}) {
    const { skipAriaHidden } = options;
    element.classList.toggle('ag-invisible', !visible);
    if (!skipAriaHidden) {
        (0, aria_1._setAriaHidden)(element, !visible);
    }
}
exports._setVisible = _setVisible;
function _setDisabled(element, disabled) {
    const attributeName = 'disabled';
    const addOrRemoveDisabledAttribute = disabled
        ? (e) => e.setAttribute(attributeName, '')
        : (e) => e.removeAttribute(attributeName);
    addOrRemoveDisabledAttribute(element);
    const inputs = element.querySelectorAll('input') ?? [];
    for (const input of inputs) {
        addOrRemoveDisabledAttribute(input);
    }
}
exports._setDisabled = _setDisabled;
function _isElementChildOfClass(element, cls, maxNest) {
    let counter = 0;
    while (element) {
        if (element.classList.contains(cls)) {
            return true;
        }
        element = element.parentElement;
        if (typeof maxNest == 'number') {
            if (++counter > maxNest) {
                break;
            }
        }
        else if (element === maxNest) {
            break;
        }
    }
    return false;
}
exports._isElementChildOfClass = _isElementChildOfClass;
// returns back sizes as doubles instead of strings. similar to
// getBoundingClientRect, however getBoundingClientRect does not:
// a) work with fractions (eg browser is zooming)
// b) has CSS transitions applied (eg CSS scale, browser zoom), which we don't want, we want the un-transitioned values
function _getElementSize(el) {
    const { height, width, borderTopWidth, borderRightWidth, borderBottomWidth, borderLeftWidth, paddingTop, paddingRight, paddingBottom, paddingLeft, marginTop, marginRight, marginBottom, marginLeft, boxSizing, } = window.getComputedStyle(el);
    return {
        height: parseFloat(height || '0'),
        width: parseFloat(width || '0'),
        borderTopWidth: parseFloat(borderTopWidth || '0'),
        borderRightWidth: parseFloat(borderRightWidth || '0'),
        borderBottomWidth: parseFloat(borderBottomWidth || '0'),
        borderLeftWidth: parseFloat(borderLeftWidth || '0'),
        paddingTop: parseFloat(paddingTop || '0'),
        paddingRight: parseFloat(paddingRight || '0'),
        paddingBottom: parseFloat(paddingBottom || '0'),
        paddingLeft: parseFloat(paddingLeft || '0'),
        marginTop: parseFloat(marginTop || '0'),
        marginRight: parseFloat(marginRight || '0'),
        marginBottom: parseFloat(marginBottom || '0'),
        marginLeft: parseFloat(marginLeft || '0'),
        boxSizing,
    };
}
exports._getElementSize = _getElementSize;
function _getInnerHeight(el) {
    const size = _getElementSize(el);
    if (size.boxSizing === 'border-box') {
        return size.height - size.paddingTop - size.paddingBottom;
    }
    return size.height;
}
exports._getInnerHeight = _getInnerHeight;
function _getInnerWidth(el) {
    const size = _getElementSize(el);
    if (size.boxSizing === 'border-box') {
        return size.width - size.paddingLeft - size.paddingRight;
    }
    return size.width;
}
exports._getInnerWidth = _getInnerWidth;
function _getAbsoluteHeight(el) {
    const { height, marginBottom, marginTop } = _getElementSize(el);
    return Math.floor(height + marginBottom + marginTop);
}
exports._getAbsoluteHeight = _getAbsoluteHeight;
function _getAbsoluteWidth(el) {
    const { width, marginLeft, marginRight } = _getElementSize(el);
    return Math.floor(width + marginLeft + marginRight);
}
exports._getAbsoluteWidth = _getAbsoluteWidth;
function _getElementRectWithOffset(el) {
    const offsetElementRect = el.getBoundingClientRect();
    const { borderTopWidth, borderLeftWidth, borderRightWidth, borderBottomWidth } = _getElementSize(el);
    return {
        top: offsetElementRect.top + (borderTopWidth || 0),
        left: offsetElementRect.left + (borderLeftWidth || 0),
        right: offsetElementRect.right + (borderRightWidth || 0),
        bottom: offsetElementRect.bottom + (borderBottomWidth || 0),
    };
}
exports._getElementRectWithOffset = _getElementRectWithOffset;
function _getScrollLeft(element, rtl) {
    let scrollLeft = element.scrollLeft;
    if (rtl) {
        scrollLeft = Math.abs(scrollLeft);
    }
    return scrollLeft;
}
exports._getScrollLeft = _getScrollLeft;
function _setScrollLeft(element, value, rtl) {
    if (rtl) {
        value *= -1;
    }
    element.scrollLeft = value;
}
exports._setScrollLeft = _setScrollLeft;
function _clearElement(el) {
    while (el && el.firstChild) {
        el.removeChild(el.firstChild);
    }
}
exports._clearElement = _clearElement;
function _removeFromParent(node) {
    if (node && node.parentNode) {
        node.parentNode.removeChild(node);
    }
}
exports._removeFromParent = _removeFromParent;
function _isInDOM(element) {
    return !!element.offsetParent;
}
exports._isInDOM = _isInDOM;
function _isVisible(element) {
    const el = element;
    if (el.checkVisibility) {
        return el.checkVisibility({ checkVisibilityCSS: true });
    }
    const isHidden = !_isInDOM(element) || window.getComputedStyle(element).visibility !== 'visible';
    return !isHidden;
}
exports._isVisible = _isVisible;
/**
 * Loads the template and returns it as an element.
 * NOTE: Prefer _createElement
 * @param {string} template
 * @returns {HTMLElement}
 */
function _loadTemplate(template) {
    const tempDiv = document.createElement('div');
    // eslint-disable-next-line no-restricted-properties -- no other way to parse custom HTML strings from the user
    tempDiv.innerHTML = (template || '').trim();
    return tempDiv.firstChild;
}
exports._loadTemplate = _loadTemplate;
function _ensureDomOrder(eContainer, eChild, eChildBefore) {
    // if already in right order, do nothing
    if (eChildBefore && eChildBefore.nextSibling === eChild) {
        return;
    }
    if (!eContainer.firstChild) {
        eContainer.appendChild(eChild);
    }
    else if (eChildBefore) {
        if (eChildBefore.nextSibling) {
            // insert between the eRowBefore and the row after it
            eContainer.insertBefore(eChild, eChildBefore.nextSibling);
        }
        else {
            // if nextSibling is missing, means other row is at end, so just append new row at the end
            eContainer.appendChild(eChild);
        }
    }
    else if (eContainer.firstChild && eContainer.firstChild !== eChild) {
        // otherwise put at start
        // insert it at the first location
        eContainer.insertAdjacentElement('afterbegin', eChild);
    }
}
exports._ensureDomOrder = _ensureDomOrder;
function _setDomChildOrder(eContainer, orderedChildren) {
    for (let i = 0; i < orderedChildren.length; i++) {
        const correctCellAtIndex = orderedChildren[i];
        const actualCellAtIndex = eContainer.children[i];
        if (actualCellAtIndex !== correctCellAtIndex) {
            eContainer.insertBefore(correctCellAtIndex, actualCellAtIndex);
        }
    }
}
exports._setDomChildOrder = _setDomChildOrder;
/**
 * Converts a camelCase string into hyphenated string
 * @param {string} camelCase
 * @returns {string}
 */
function _camelCaseToHyphenated(camelCase) {
    return camelCase.replace(/[A-Z]/g, (s) => `-${s.toLocaleLowerCase()}`);
}
function _addStylesToElement(eElement, styles) {
    if (!styles) {
        return;
    }
    for (const key of Object.keys(styles)) {
        const value = styles[key];
        if (!key || !key.length || value == null) {
            continue;
        }
        // changes the key from camelCase into a hyphenated-string
        const parsedKey = _camelCaseToHyphenated(key);
        const valueAsString = value.toString();
        const parsedValue = valueAsString.replace(/\s*!important/g, '');
        const priority = parsedValue.length != valueAsString.length ? 'important' : undefined;
        eElement.style.setProperty(parsedKey, parsedValue, priority);
    }
}
exports._addStylesToElement = _addStylesToElement;
function _isElementOverflowingCallback(getElement) {
    return () => {
        const element = getElement();
        if (!element) {
            // defaults to true
            return true;
        }
        return _isHorizontalScrollShowing(element) || _isVerticalScrollShowing(element);
    };
}
exports._isElementOverflowingCallback = _isElementOverflowingCallback;
function _isHorizontalScrollShowing(element) {
    return element.clientWidth < element.scrollWidth;
}
exports._isHorizontalScrollShowing = _isHorizontalScrollShowing;
function _isVerticalScrollShowing(element) {
    return element.clientHeight < element.scrollHeight;
}
exports._isVerticalScrollShowing = _isVerticalScrollShowing;
function _setElementWidth(element, width) {
    if (width === 'flex') {
        element.style.removeProperty('width');
        element.style.removeProperty('minWidth');
        element.style.removeProperty('maxWidth');
        element.style.flex = '1 1 auto';
    }
    else {
        _setFixedWidth(element, width);
    }
}
exports._setElementWidth = _setElementWidth;
function _setFixedWidth(element, width) {
    width = _formatSize(width);
    element.style.width = width;
    element.style.maxWidth = width;
    element.style.minWidth = width;
}
exports._setFixedWidth = _setFixedWidth;
function _setFixedHeight(element, height) {
    height = _formatSize(height);
    element.style.height = height;
    element.style.maxHeight = height;
    element.style.minHeight = height;
}
exports._setFixedHeight = _setFixedHeight;
function _formatSize(size) {
    return typeof size === 'number' ? `${size}px` : size;
}
exports._formatSize = _formatSize;
function _isNodeOrElement(o) {
    return o instanceof Node || o instanceof HTMLElement;
}
exports._isNodeOrElement = _isNodeOrElement;
function _addOrRemoveAttribute(element, name, value) {
    if (value == null || value === '') {
        element.removeAttribute(name);
    }
    else {
        element.setAttribute(name, value.toString());
    }
}
exports._addOrRemoveAttribute = _addOrRemoveAttribute;
function _observeResize(beans, element, callback) {
    const win = (0, document_1._getWindow)(beans);
    const ResizeObserverImpl = win.ResizeObserver;
    const resizeObserver = ResizeObserverImpl ? new ResizeObserverImpl(callback) : null;
    resizeObserver?.observe(element);
    return () => resizeObserver?.disconnect();
}
exports._observeResize = _observeResize;
function _requestAnimationFrame(beans, callback) {
    const win = (0, document_1._getWindow)(beans);
    if (win.requestAnimationFrame) {
        win.requestAnimationFrame(callback);
    }
    else if (win.webkitRequestAnimationFrame) {
        win.webkitRequestAnimationFrame(callback);
    }
    else {
        win.setTimeout(callback, 0);
    }
}
exports._requestAnimationFrame = _requestAnimationFrame;
/** AG Grid attribute used to automatically assign DOM Elements to class properties */
exports.DataRefAttribute = 'data-ref';
let whitespaceNode;
function getWhitespaceNode() {
    // Cloning is slightly faster than creating a new node each time
    whitespaceNode ?? (whitespaceNode = document.createTextNode(' '));
    return whitespaceNode.cloneNode();
}
function _createAgElement(params) {
    const { attrs, children, cls, ref, role, tag } = params;
    const element = document.createElement(tag);
    if (cls) {
        element.className = cls;
    }
    if (ref) {
        element.setAttribute(exports.DataRefAttribute, ref);
    }
    if (role) {
        element.setAttribute('role', role);
    }
    if (attrs) {
        for (const key of Object.keys(attrs)) {
            element.setAttribute(key, attrs[key]);
        }
    }
    if (children) {
        if (typeof children === 'string') {
            element.textContent = children;
        }
        else {
            let addFirstWhitespace = true;
            for (const child of children) {
                if (child) {
                    if (typeof child === 'string') {
                        element.appendChild(document.createTextNode(child));
                        addFirstWhitespace = false;
                    }
                    else if (typeof child === 'function') {
                        element.appendChild(child());
                    }
                    else {
                        // NOTE: To match the previous behaviour of when component templates where defined on multi line strings we need
                        // to add a whitespace node before and after each child element.
                        // Ideally we would not do this but this reduces the chance of breaking changes.
                        if (addFirstWhitespace) {
                            element.appendChild(getWhitespaceNode());
                            addFirstWhitespace = false;
                        }
                        element.append(_createAgElement(child));
                        element.appendChild(getWhitespaceNode());
                    }
                }
            }
        }
    }
    return element;
}
exports._createAgElement = _createAgElement;


/***/ }),

/***/ 7356:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._anchorElementToMouseMoveEvent = exports._isEventFromThisInstance = exports._areEventsNear = exports._addSafePassiveEventListener = exports._isElementInEventPath = exports._isEventSupported = void 0;
const document_1 = __webpack_require__(80011);
const dom_1 = __webpack_require__(1956);
const PASSIVE_EVENTS = ['touchstart', 'touchend', 'touchmove', 'touchcancel', 'scroll'];
const NON_PASSIVE_EVENTS = ['wheel'];
const supports = {};
exports._isEventSupported = (() => {
    const tags = {
        select: 'input',
        change: 'input',
        submit: 'form',
        reset: 'form',
        error: 'img',
        load: 'img',
        abort: 'img',
    };
    const eventChecker = (eventName) => {
        if (typeof supports[eventName] === 'boolean') {
            return supports[eventName];
        }
        const el = document.createElement(tags[eventName] || 'div');
        eventName = 'on' + eventName;
        return (supports[eventName] = eventName in el);
    };
    return eventChecker;
})();
function _isElementInEventPath(element, event) {
    if (!event || !element) {
        return false;
    }
    return _getEventPath(event).indexOf(element) >= 0;
}
exports._isElementInEventPath = _isElementInEventPath;
function _createEventPath(event) {
    const res = [];
    let pointer = event.target;
    while (pointer) {
        res.push(pointer);
        pointer = pointer.parentElement;
    }
    return res;
}
/**
 * Gets the path for a browser Event or from the target on an AG Grid Event
 * https://developer.mozilla.org/en-US/docs/Web/API/Event
 * @param {Event| { target: EventTarget }} event
 * @returns {EventTarget[]}
 */
function _getEventPath(event) {
    // This can be called with either a browser event or an AG Grid Event that has a target property.
    const eventNoType = event;
    if (eventNoType.path) {
        return eventNoType.path;
    }
    if (eventNoType.composedPath) {
        return eventNoType.composedPath();
    }
    // If this is an AG Grid event build the path ourselves
    return _createEventPath(eventNoType);
}
function _addSafePassiveEventListener(eElement, event, listener) {
    const passive = getPassiveStateForEvent(event);
    let options;
    if (passive != null) {
        options = { passive };
    }
    eElement.addEventListener(event, listener, options);
}
exports._addSafePassiveEventListener = _addSafePassiveEventListener;
const getPassiveStateForEvent = (event) => {
    const isPassive = PASSIVE_EVENTS.includes(event);
    const isNonPassive = NON_PASSIVE_EVENTS.includes(event);
    if (isPassive) {
        return true;
    }
    if (isNonPassive) {
        return false;
    }
};
/**
 * `True` if the event is close to the original event by X pixels either vertically or horizontally.
 * we only start dragging after X pixels so this allows us to know if we should start dragging yet.
 * @param {MouseEvent | TouchEvent} e1
 * @param {MouseEvent | TouchEvent} e2
 * @param {number} pixelCount
 * @returns {boolean}
 */
function _areEventsNear(e1, e2, pixelCount) {
    // by default, we wait 4 pixels before starting the drag
    if (pixelCount === 0) {
        return false;
    }
    const diffX = Math.abs(e1.clientX - e2.clientX);
    const diffY = Math.abs(e1.clientY - e2.clientY);
    return Math.max(diffX, diffY) <= pixelCount;
}
exports._areEventsNear = _areEventsNear;
// walks the path of the event, and returns true if this instance is the first one that it finds. if doing things like
// master / detail grids, and a child grid is found, then it returns false. this stops things like copy/paste
// getting executed on many grids at the same time.
function _isEventFromThisInstance(beans, event) {
    return beans.gos.isElementInThisInstance(event.target);
}
exports._isEventFromThisInstance = _isEventFromThisInstance;
function _anchorElementToMouseMoveEvent(element, mouseMoveEvent, beans) {
    const eRect = element.getBoundingClientRect();
    const height = eRect.height;
    const browserWidth = (0, document_1._getBodyWidth)(beans) - 2; // 2px for 1px borderLeft and 1px borderRight
    const browserHeight = (0, document_1._getBodyHeight)(beans) - 2; // 2px for 1px borderTop and 1px borderBottom
    const offsetParent = element.offsetParent;
    if (!offsetParent) {
        return;
    }
    const offsetParentSize = (0, dom_1._getElementRectWithOffset)(element.offsetParent);
    const { clientY, clientX } = mouseMoveEvent;
    let top = clientY - offsetParentSize.top - height / 2;
    let left = clientX - offsetParentSize.left - 10;
    const eDocument = (0, document_1._getDocument)(beans);
    const win = eDocument.defaultView || window;
    const windowScrollY = win.pageYOffset || eDocument.documentElement.scrollTop;
    const windowScrollX = win.pageXOffset || eDocument.documentElement.scrollLeft;
    // check if the drag and drop image component is not positioned outside of the browser
    if (browserWidth > 0 && left + element.clientWidth > browserWidth + windowScrollX) {
        left = browserWidth + windowScrollX - element.clientWidth;
    }
    if (left < 0) {
        left = 0;
    }
    if (browserHeight > 0 && top + element.clientHeight > browserHeight + windowScrollY) {
        top = browserHeight + windowScrollY - element.clientHeight;
    }
    if (top < 0) {
        top = 0;
    }
    element.style.left = `${left}px`;
    element.style.top = `${top}px`;
}
exports._anchorElementToMouseMoveEvent = _anchorElementToMouseMoveEvent;


/***/ }),

/***/ 5088:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._findTabbableParent = exports._findNextFocusableElement = exports._focusInto = exports._findFocusableElements = exports._isKeyboardMode = exports._registerKeyboardFocusEvents = void 0;
const array_1 = __webpack_require__(79909);
const browser_1 = __webpack_require__(36916);
const document_1 = __webpack_require__(80011);
const dom_1 = __webpack_require__(1956);
let keyboardModeActive = false;
let instanceCount = 0;
function addKeyboardModeEvents(doc) {
    if (instanceCount > 0) {
        return;
    }
    doc.addEventListener('keydown', toggleKeyboardMode);
    doc.addEventListener('mousedown', toggleKeyboardMode);
}
function removeKeyboardModeEvents(doc) {
    if (instanceCount > 0)
        return;
    doc.removeEventListener('keydown', toggleKeyboardMode);
    doc.removeEventListener('mousedown', toggleKeyboardMode);
}
function toggleKeyboardMode(event) {
    const isKeyboardActive = keyboardModeActive;
    const isKeyboardEvent = event.type === 'keydown';
    if (isKeyboardEvent) {
        // the following keys should not toggle keyboard mode.
        if (event.ctrlKey || event.metaKey || event.altKey) {
            return;
        }
    }
    if (isKeyboardActive === isKeyboardEvent) {
        return;
    }
    keyboardModeActive = isKeyboardEvent;
}
function _registerKeyboardFocusEvents(beans) {
    const eDocument = (0, document_1._getDocument)(beans);
    addKeyboardModeEvents(eDocument);
    instanceCount++;
    return () => {
        instanceCount--;
        removeKeyboardModeEvents(eDocument);
    };
}
exports._registerKeyboardFocusEvents = _registerKeyboardFocusEvents;
function _isKeyboardMode() {
    return keyboardModeActive;
}
exports._isKeyboardMode = _isKeyboardMode;
function _findFocusableElements(rootNode, exclude, onlyUnmanaged = false) {
    const focusableString = dom_1.FOCUSABLE_SELECTOR;
    let excludeString = dom_1.FOCUSABLE_EXCLUDE;
    if (exclude) {
        excludeString += ', ' + exclude;
    }
    if (onlyUnmanaged) {
        excludeString += ', [tabindex="-1"]';
    }
    const nodes = Array.prototype.slice
        .apply(rootNode.querySelectorAll(focusableString))
        .filter((node) => {
        return (0, dom_1._isVisible)(node);
    });
    const excludeNodes = Array.prototype.slice.apply(rootNode.querySelectorAll(excludeString));
    if (!excludeNodes.length) {
        return nodes;
    }
    const diff = (a, b) => a.filter((element) => b.indexOf(element) === -1);
    return diff(nodes, excludeNodes);
}
exports._findFocusableElements = _findFocusableElements;
function _focusInto(rootNode, up = false, onlyUnmanaged = false, excludeTabGuards = false) {
    const focusableElements = _findFocusableElements(rootNode, excludeTabGuards ? '.ag-tab-guard' : null, onlyUnmanaged);
    const toFocus = up ? (0, array_1._last)(focusableElements) : focusableElements[0];
    if (toFocus) {
        toFocus.focus({ preventScroll: true });
        return true;
    }
    return false;
}
exports._focusInto = _focusInto;
function _findNextFocusableElement(beans, rootNode, onlyManaged, backwards) {
    const focusable = _findFocusableElements(rootNode, onlyManaged ? ':not([tabindex="-1"])' : null);
    const activeEl = (0, document_1._getActiveDomElement)(beans);
    let currentIndex;
    if (onlyManaged) {
        currentIndex = focusable.findIndex((el) => el.contains(activeEl));
    }
    else {
        currentIndex = focusable.indexOf(activeEl);
    }
    const nextIndex = currentIndex + (backwards ? -1 : 1);
    if (nextIndex < 0 || nextIndex >= focusable.length) {
        return null;
    }
    return focusable[nextIndex];
}
exports._findNextFocusableElement = _findNextFocusableElement;
function _findTabbableParent(node, limit = 5) {
    let counter = 0;
    while (node && (0, browser_1._getTabIndex)(node) === null && ++counter <= limit) {
        node = node.parentElement;
    }
    if ((0, browser_1._getTabIndex)(node) === null) {
        return null;
    }
    return node;
}
exports._findTabbableParent = _findTabbableParent;


/***/ }),

/***/ 44990:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._waitUntil = exports._throttle = exports._debounce = exports._batchCall = exports._doOnce = void 0;
const dom_1 = __webpack_require__(1956);
const doOnceFlags = {};
/**
 * If the key was passed before, then doesn't execute the func
 * @param {Function} func
 * @param {string} key
 */
function _doOnce(func, key) {
    if (doOnceFlags[key]) {
        return;
    }
    func();
    doOnceFlags[key] = true;
}
exports._doOnce = _doOnce;
const batchedCallsSetTimeout = {
    pending: false,
    funcs: [],
};
const batchedCallsRaf = {
    pending: false,
    funcs: [],
};
function _batchCall(func, mode = 'setTimeout', beans) {
    const batch = mode === 'raf' ? batchedCallsRaf : batchedCallsSetTimeout;
    batch.funcs.push(func);
    if (batch.pending) {
        return;
    }
    batch.pending = true;
    const runBatch = () => {
        const funcsCopy = batch.funcs.slice();
        batch.funcs.length = 0;
        batch.pending = false;
        funcsCopy.forEach((func) => func());
    };
    if (mode === 'raf') {
        (0, dom_1._requestAnimationFrame)(beans, runBatch);
    }
    else {
        window.setTimeout(runBatch, 0);
    }
}
exports._batchCall = _batchCall;
/**
 * Creates a debounced function a function, and attach it to a bean for lifecycle
 * @param {Function} func The function to be debounced
 * @param {number} delay The time in ms to debounce
 * @returns {Function} The debounced function
 */
function _debounce(bean, func, delay) {
    let timeout;
    // Calling debounce returns a new anonymous function
    return function (...args) {
        const context = this;
        window.clearTimeout(timeout);
        // Set the new timeout
        timeout = window.setTimeout(function () {
            // at the moment we just check if the bean is still alive, in the future the bean stub should
            // another option is to manage a list of active timers and clear them when the bean is destroyed.
            if (bean.isAlive()) {
                func.apply(context, args);
            }
        }, delay);
    };
}
exports._debounce = _debounce;
/**
 * @param {Function} func The function to be throttled
 * @param {number} wait The time in ms to throttle
 * @returns {Function} The throttled function
 */
function _throttle(func, wait) {
    let previousCall = 0;
    return function (...args) {
        //@ts-expect-error no implicit this
        const context = this;
        const currentCall = Date.now();
        if (currentCall - previousCall < wait) {
            return;
        }
        previousCall = currentCall;
        func.apply(context, args);
    };
}
exports._throttle = _throttle;
function _waitUntil(bean, condition, callback, timeout = 100) {
    const timeStamp = Date.now();
    let interval = null;
    let executed = false;
    const clearWait = () => {
        if (interval != null) {
            window.clearInterval(interval);
            interval = null;
        }
    };
    bean.addDestroyFunc(clearWait);
    const internalCallback = () => {
        const reachedTimeout = Date.now() - timeStamp > timeout;
        if (condition() || reachedTimeout) {
            callback();
            executed = true;
            clearWait();
        }
    };
    internalCallback();
    if (!executed) {
        interval = window.setInterval(internalCallback, 10);
    }
}
exports._waitUntil = _waitUntil;


/***/ }),

/***/ 85591:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getLevenshteinSimilarityDistance = exports._fuzzySuggestions = void 0;
/**
 * This function provides fuzzy matching suggestions based on the input value and a list of all suggestions.
 */
function _fuzzySuggestions(params) {
    const { inputValue, allSuggestions, hideIrrelevant, filterByPercentageOfBestMatch } = params;
    let thisSuggestions = (allSuggestions ?? []).map((text, idx) => ({
        value: text,
        relevance: _getLevenshteinSimilarityDistance(inputValue, text),
        idx,
    }));
    /** Lower values mean more similar strings. */
    thisSuggestions.sort((a, b) => a.relevance - b.relevance);
    if (hideIrrelevant) {
        thisSuggestions = thisSuggestions.filter((suggestion) => suggestion.relevance < Math.max(suggestion.value.length, inputValue.length));
    }
    if (thisSuggestions.length > 0 && filterByPercentageOfBestMatch && filterByPercentageOfBestMatch > 0) {
        const bestMatch = thisSuggestions[0].relevance;
        const limit = bestMatch * filterByPercentageOfBestMatch;
        thisSuggestions = thisSuggestions.filter((suggestion) => limit - suggestion.relevance < 0);
    }
    const values = [];
    const indices = [];
    for (const suggestion of thisSuggestions) {
        values.push(suggestion.value);
        indices.push(suggestion.idx);
    }
    return { values, indices };
}
exports._fuzzySuggestions = _fuzzySuggestions;
/**
 * This uses Levenshtein Distance to match strings.
 * Lower values mean more similar strings.
 */
function _getLevenshteinSimilarityDistance(inputText, suggestion) {
    // Always use the shorter string for columns to reduce space
    if (inputText.length < suggestion.length) {
        [inputText, suggestion] = [suggestion, inputText];
    }
    let previousRow = [];
    let currentRow = [];
    const sourceLength = inputText.length;
    const targetLength = suggestion.length;
    // Initialize previousRow with 0..targetLength
    for (let j = 0; j <= targetLength; j++) {
        previousRow[j] = j;
    }
    let secondaryScore = 0;
    for (let i = 1; i <= sourceLength; i++) {
        currentRow[0] = i;
        for (let j = 1; j <= targetLength; j++) {
            const sourceChar = inputText[i - 1];
            const targetChar = suggestion[j - 1];
            if (sourceChar.toLocaleLowerCase() === targetChar.toLocaleLowerCase()) {
                ++secondaryScore; // Favor case-insensitive matches;
                if (sourceChar === targetChar) {
                    ++secondaryScore; // Favor exact matches
                }
                if (i > 1 && j > 1) {
                    if (inputText[i - 2].toLocaleLowerCase() === suggestion[j - 2].toLocaleLowerCase()) {
                        ++secondaryScore; // Favor case-insensitive consecutive matches
                        if (inputText[i - 2] === suggestion[j - 2]) {
                            ++secondaryScore; // Favor case-sensitive consecutive matches
                        }
                    }
                }
                if (i < sourceLength / 2 - 10)
                    ++secondaryScore; // Favor matches at the start of the string
                currentRow[j] = previousRow[j - 1]; // No cost
            }
            else {
                const insertCost = currentRow[j - 1];
                const deleteCost = previousRow[j];
                const replaceCost = previousRow[j - 1];
                currentRow[j] = 1 + Math.min(insertCost, deleteCost, replaceCost);
            }
        }
        // Swap rows for next iteration
        [previousRow, currentRow] = [currentRow, previousRow];
    }
    return previousRow[targetLength] / (secondaryScore + 1); // negatives divided by positives, ensure no division by zero
}
exports._getLevenshteinSimilarityDistance = _getLevenshteinSimilarityDistance;


/***/ }),

/***/ 89097:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._defaultComparator = exports._jsonEquals = exports._toStringOrNull = exports._missing = exports._exists = exports._makeNull = void 0;
/**
 * If value is undefined, null or blank, returns null, otherwise returns the value
 * @param {T} value
 * @returns {T | null}
 */
function _makeNull(value) {
    if (value == null || value === '') {
        return null;
    }
    return value;
}
exports._makeNull = _makeNull;
function _exists(value) {
    return value != null && value !== '';
}
exports._exists = _exists;
function _missing(value) {
    return !_exists(value);
}
exports._missing = _missing;
function _toStringOrNull(value) {
    return value != null && typeof value.toString === 'function' ? value.toString() : null;
}
exports._toStringOrNull = _toStringOrNull;
function _jsonEquals(val1, val2) {
    const val1Json = val1 ? JSON.stringify(val1) : null;
    const val2Json = val2 ? JSON.stringify(val2) : null;
    return val1Json === val2Json;
}
exports._jsonEquals = _jsonEquals;
function _defaultComparator(valueA, valueB, accentedCompare = false) {
    const valueAMissing = valueA == null;
    const valueBMissing = valueB == null;
    // this is for aggregations sum and avg, where the result can be a number that is wrapped.
    // if we didn't do this, then the toString() value would be used, which would result in
    // the strings getting used instead of the numbers.
    if (valueA && valueA.toNumber) {
        valueA = valueA.toNumber();
    }
    if (valueB && valueB.toNumber) {
        valueB = valueB.toNumber();
    }
    if (valueAMissing && valueBMissing) {
        return 0;
    }
    if (valueAMissing) {
        return -1;
    }
    if (valueBMissing) {
        return 1;
    }
    function doQuickCompare(a, b) {
        return a > b ? 1 : a < b ? -1 : 0;
    }
    if (typeof valueA !== 'string') {
        return doQuickCompare(valueA, valueB);
    }
    if (!accentedCompare) {
        return doQuickCompare(valueA, valueB);
    }
    try {
        // using local compare also allows chinese comparisons
        return valueA.localeCompare(valueB);
    }
    catch (e) {
        // if something wrong with localeCompare, eg not supported
        // by browser, then just continue with the quick one
        return doQuickCompare(valueA, valueB);
    }
}
exports._defaultComparator = _defaultComparator;


/***/ }),

/***/ 93967:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._isEventFromPrintableCharacter = void 0;
function _isEventFromPrintableCharacter(event) {
    // no allowed printable chars have alt or ctrl key combinations
    if (event.altKey || event.ctrlKey || event.metaKey) {
        return false;
    }
    // if key is length 1, eg if it is 'a' for the a key, or '2' for the '2' key.
    // non-printable characters have names, eg 'Enter' or 'Backspace'.
    const printableCharacter = event.key?.length === 1;
    return printableCharacter;
}
exports._isEventFromPrintableCharacter = _isEventFromPrintableCharacter;


/***/ }),

/***/ 66352:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getLocaleTextFromMap = exports._getLocaleTextFromFunc = exports._translate = exports._getLocaleTextFunc = void 0;
function defaultLocaleTextFunc(_key, defaultValue) {
    return defaultValue;
}
function _getLocaleTextFunc(localeSvc) {
    return localeSvc?.getLocaleTextFunc() ?? defaultLocaleTextFunc;
}
exports._getLocaleTextFunc = _getLocaleTextFunc;
function _translate(bean, localeValues, key, variableValues) {
    const defaultValue = localeValues[key];
    return bean.getLocaleTextFunc()(key, typeof defaultValue === 'function' ? defaultValue(variableValues) : defaultValue, variableValues);
}
exports._translate = _translate;
function _getLocaleTextFromFunc(getLocaleText) {
    return (key, defaultValue, variableValues) => {
        return getLocaleText({
            key,
            defaultValue,
            variableValues,
        });
    };
}
exports._getLocaleTextFromFunc = _getLocaleTextFromFunc;
function _getLocaleTextFromMap(localeText) {
    return (key, defaultValue, variableValues) => {
        let localisedText = localeText && localeText[key];
        if (localisedText && variableValues && variableValues.length) {
            let found = 0;
            while (true) {
                if (found >= variableValues.length) {
                    break;
                }
                const idx = localisedText.indexOf('${variable}');
                if (idx === -1) {
                    break;
                }
                localisedText = localisedText.replace('${variable}', variableValues[found++]);
            }
        }
        return localisedText ?? defaultValue;
    };
}
exports._getLocaleTextFromMap = _getLocaleTextFromMap;


/***/ }),

/***/ 35269:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgPromise = exports._wrapInterval = exports._isPromise = void 0;
function _isPromise(fn) {
    if (typeof fn.then === 'function') {
        return true;
    }
    return false;
}
exports._isPromise = _isPromise;
function _wrapInterval(action, timeout) {
    return new AgPromise((resolve) => {
        resolve(window.setInterval(action, timeout));
    });
}
exports._wrapInterval = _wrapInterval;
var AgPromiseStatus;
(function (AgPromiseStatus) {
    AgPromiseStatus[AgPromiseStatus["IN_PROGRESS"] = 0] = "IN_PROGRESS";
    AgPromiseStatus[AgPromiseStatus["RESOLVED"] = 1] = "RESOLVED";
})(AgPromiseStatus || (AgPromiseStatus = {}));
class AgPromise {
    static all(promises) {
        return promises.length
            ? new AgPromise((resolve) => {
                let remainingToResolve = promises.length;
                const combinedValues = new Array(remainingToResolve);
                promises.forEach((promise, index) => {
                    promise.then((value) => {
                        combinedValues[index] = value;
                        remainingToResolve--;
                        if (remainingToResolve === 0) {
                            resolve(combinedValues);
                        }
                    });
                });
            })
            : AgPromise.resolve();
    }
    static resolve(value = null) {
        return new AgPromise((resolve) => resolve(value));
    }
    constructor(callback) {
        this.status = AgPromiseStatus.IN_PROGRESS;
        this.resolution = null;
        this.waiters = [];
        callback((value) => this.onDone(value), (params) => this.onReject(params));
    }
    then(func) {
        return new AgPromise((resolve) => {
            if (this.status === AgPromiseStatus.RESOLVED) {
                resolve(func(this.resolution));
            }
            else {
                this.waiters.push((value) => resolve(func(value)));
            }
        });
    }
    onDone(value) {
        this.status = AgPromiseStatus.RESOLVED;
        this.resolution = value;
        this.waiters.forEach((waiter) => waiter(value));
    }
    onReject(_) { }
}
exports.AgPromise = AgPromise;


/***/ }),

/***/ 31931:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._escapeString = exports._toString = void 0;
const reUnescapedHtml = /[&<>"']/g;
/**
 * HTML Escapes.
 */
const HTML_ESCAPES = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;',
};
/**
 * Calls toString() twice, in case value is an object, where user provides a toString() method.
 * The first call to toString() returns back something other than a string (eg a number to render)
 */
function _toString(toEscape) {
    return toEscape?.toString().toString() ?? null;
}
exports._toString = _toString;
function _escapeString(toEscape) {
    // in react we don't need to escape html characters, as it's done by the framework
    return _toString(toEscape)?.replace(reUnescapedHtml, (chr) => HTML_ESCAPES[chr]) ?? null;
}
exports._escapeString = _escapeString;


/***/ }),

/***/ 22989:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getValueUsingField = void 0;
function _getValueUsingField(data, field, fieldContainsDots) {
    if (!field || !data) {
        return;
    }
    // if no '.', then it's not a deep value
    if (!fieldContainsDots) {
        return data[field];
    }
    // otherwise it is a deep value, so need to dig for it
    const fields = field.split('.');
    let currentObject = data;
    for (let i = 0; i < fields.length; i++) {
        if (currentObject == null) {
            return undefined;
        }
        currentObject = currentObject[fields[i]];
    }
    return currentObject;
}
exports._getValueUsingField = _getValueUsingField;


/***/ }),

/***/ 54978:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgAbstractField = void 0;
const aria_1 = __webpack_require__(91623);
const dom_1 = __webpack_require__(1956);
const agAbstractLabel_1 = __webpack_require__(23776);
class AgAbstractField extends agAbstractLabel_1.AgAbstractLabel {
    constructor(config, template, components, className) {
        super(config, template, components);
        this.className = className;
    }
    postConstruct() {
        super.postConstruct();
        const { width, value, onValueChange } = this.config;
        if (width != null) {
            this.setWidth(width);
        }
        if (value != null) {
            this.setValue(value);
        }
        if (onValueChange != null) {
            this.onValueChange(onValueChange);
        }
        if (this.className) {
            this.addCss(this.className);
        }
        this.refreshAriaLabelledBy();
    }
    setLabel(label) {
        super.setLabel(label);
        this.refreshAriaLabelledBy();
        return this;
    }
    refreshAriaLabelledBy() {
        const ariaEl = this.getAriaElement();
        const labelId = this.getLabelId();
        const label = this.getLabel();
        if (label == null || label == '' || (0, aria_1._getAriaLabel)(ariaEl) !== null) {
            (0, aria_1._setAriaLabelledBy)(ariaEl, '');
        }
        else {
            (0, aria_1._setAriaLabelledBy)(ariaEl, labelId ?? '');
        }
    }
    setAriaLabel(label) {
        (0, aria_1._setAriaLabel)(this.getAriaElement(), label);
        this.refreshAriaLabelledBy();
        return this;
    }
    onValueChange(callbackFn) {
        this.addManagedListeners(this, { fieldValueChanged: () => callbackFn(this.getValue()) });
        return this;
    }
    getWidth() {
        return this.getGui().clientWidth;
    }
    setWidth(width) {
        (0, dom_1._setFixedWidth)(this.getGui(), width);
        return this;
    }
    getPreviousValue() {
        return this.previousValue;
    }
    getValue() {
        return this.value;
    }
    setValue(value, silent) {
        if (this.value === value) {
            return this;
        }
        this.previousValue = this.value;
        this.value = value;
        if (!silent) {
            this.dispatchLocalEvent({ type: 'fieldValueChanged' });
        }
        return this;
    }
}
exports.AgAbstractField = AgAbstractField;


/***/ }),

/***/ 71744:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgAbstractInputField = void 0;
const agComponent_1 = __webpack_require__(91668);
const aria_1 = __webpack_require__(91623);
const dom_1 = __webpack_require__(1956);
const agAbstractField_1 = __webpack_require__(54978);
function buildTemplate(displayFieldTag) {
    return {
        tag: 'div',
        role: 'presentation',
        children: [
            { tag: 'div', ref: 'eLabel', cls: 'ag-input-field-label' },
            {
                tag: 'div',
                ref: 'eWrapper',
                cls: 'ag-wrapper ag-input-wrapper',
                role: 'presentation',
                children: [{ tag: displayFieldTag, ref: 'eInput', cls: 'ag-input-field-input' }],
            },
        ],
    };
}
class AgAbstractInputField extends agAbstractField_1.AgAbstractField {
    constructor(config, className, inputType = 'text', displayFieldTag = 'input') {
        super(config, config?.template ?? buildTemplate(displayFieldTag), [], className);
        this.inputType = inputType;
        this.displayFieldTag = displayFieldTag;
        this.eLabel = agComponent_1.RefPlaceholder;
        this.eWrapper = agComponent_1.RefPlaceholder;
        this.eInput = agComponent_1.RefPlaceholder;
    }
    postConstruct() {
        super.postConstruct();
        this.setInputType(this.inputType);
        const { eLabel, eWrapper, eInput, className } = this;
        eLabel.classList.add(`${className}-label`);
        eWrapper.classList.add(`${className}-input-wrapper`);
        eInput.classList.add(`${className}-input`);
        this.addCss('ag-input-field');
        eInput.id = eInput.id || `ag-${this.getCompId()}-input`;
        const { inputName, inputWidth } = this.config;
        if (inputName != null) {
            this.setInputName(inputName);
        }
        if (inputWidth != null) {
            this.setInputWidth(inputWidth);
        }
        this.addInputListeners();
        this.activateTabIndex([eInput]);
    }
    addInputListeners() {
        this.addManagedElementListeners(this.eInput, {
            input: (e) => this.setValue(e.target.value),
        });
    }
    setInputType(inputType) {
        if (this.displayFieldTag === 'input') {
            this.inputType = inputType;
            (0, dom_1._addOrRemoveAttribute)(this.eInput, 'type', inputType);
        }
    }
    getInputElement() {
        return this.eInput;
    }
    setInputWidth(width) {
        (0, dom_1._setElementWidth)(this.eWrapper, width);
        return this;
    }
    setInputName(name) {
        this.getInputElement().setAttribute('name', name);
        return this;
    }
    getFocusableElement() {
        return this.eInput;
    }
    setMaxLength(length) {
        const eInput = this.eInput;
        eInput.maxLength = length;
        return this;
    }
    setInputPlaceholder(placeholder) {
        (0, dom_1._addOrRemoveAttribute)(this.eInput, 'placeholder', placeholder);
        return this;
    }
    setInputAriaLabel(label) {
        (0, aria_1._setAriaLabel)(this.eInput, label);
        this.refreshAriaLabelledBy();
        return this;
    }
    setDisabled(disabled) {
        (0, dom_1._setDisabled)(this.eInput, disabled);
        return super.setDisabled(disabled);
    }
    setAutoComplete(value) {
        if (value === true) {
            // Remove the autocomplete attribute if the value is explicitly set to true
            // to allow the default browser autocomplete/autofill behaviour.
            (0, dom_1._addOrRemoveAttribute)(this.eInput, 'autocomplete', null);
        }
        else {
            // When a string is provided, use it as the value of the autocomplete attribute.
            // This enables users to specify how they want to the browser to handle the autocomplete on the input, as per spec:
            // https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete#values
            const autoCompleteValue = typeof value === 'string' ? value : 'off';
            (0, dom_1._addOrRemoveAttribute)(this.eInput, 'autocomplete', autoCompleteValue);
        }
        return this;
    }
}
exports.AgAbstractInputField = AgAbstractInputField;


/***/ }),

/***/ 53805:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.agAbstractLabelCSS = void 0;
exports.agAbstractLabelCSS = `.ag-label{white-space:nowrap}:where(.ag-ltr) .ag-label{margin-right:var(--ag-spacing)}:where(.ag-rtl) .ag-label{margin-left:var(--ag-spacing)}:where(.ag-label-align-right) .ag-label{order:1}:where(.ag-ltr) :where(.ag-label-align-right) .ag-label{margin-left:var(--ag-spacing)}:where(.ag-rtl) :where(.ag-label-align-right) .ag-label{margin-right:var(--ag-spacing)}.ag-label-align-right>*{flex:none}.ag-label-align-top{align-items:flex-start;flex-direction:column;>*{align-self:stretch}}.ag-label-ellipsis{flex:1;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}:where(.ag-label-align-top) .ag-label{margin-bottom:calc(var(--ag-spacing)*.5)}`;


/***/ }),

/***/ 23776:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgAbstractLabel = void 0;
const agComponentStub_1 = __webpack_require__(7047);
const aria_1 = __webpack_require__(91623);
const dom_1 = __webpack_require__(1956);
const agAbstractLabel_css_GENERATED_1 = __webpack_require__(53805);
class AgAbstractLabel extends agComponentStub_1.AgComponentStub {
    constructor(config, template, components) {
        super(template, components);
        this.labelSeparator = '';
        this.labelAlignment = 'left';
        this.disabled = false;
        this.label = '';
        this.config = config || {};
        this.registerCSS(agAbstractLabel_css_GENERATED_1.agAbstractLabelCSS);
    }
    postConstruct() {
        this.addCss('ag-labeled');
        this.eLabel.classList.add('ag-label');
        const { labelSeparator, label, labelWidth, labelAlignment, disabled } = this.config;
        if (disabled != null) {
            this.setDisabled(disabled);
        }
        if (labelSeparator != null) {
            this.setLabelSeparator(labelSeparator);
        }
        if (label != null) {
            this.setLabel(label);
        }
        if (labelWidth != null) {
            this.setLabelWidth(labelWidth);
        }
        this.setLabelAlignment(labelAlignment || this.labelAlignment);
        this.refreshLabel();
    }
    refreshLabel() {
        const { label, eLabel } = this;
        (0, dom_1._clearElement)(eLabel);
        if (typeof label === 'string') {
            // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
            eLabel.innerText = label + this.labelSeparator;
        }
        else if (label) {
            eLabel.appendChild(label);
        }
        if (label === '') {
            (0, dom_1._setDisplayed)(eLabel, false);
            (0, aria_1._setAriaRole)(eLabel, 'presentation');
        }
        else {
            (0, dom_1._setDisplayed)(eLabel, true);
            (0, aria_1._setAriaRole)(eLabel, null);
        }
    }
    setLabelSeparator(labelSeparator) {
        if (this.labelSeparator === labelSeparator) {
            return this;
        }
        this.labelSeparator = labelSeparator;
        if (this.label != null) {
            this.refreshLabel();
        }
        return this;
    }
    getLabelId() {
        const eLabel = this.eLabel;
        eLabel.id = eLabel.id || `ag-${this.getCompId()}-label`;
        return eLabel.id;
    }
    getLabel() {
        return this.label;
    }
    setLabel(label) {
        if (this.label === label) {
            return this;
        }
        this.label = label;
        this.refreshLabel();
        return this;
    }
    setLabelAlignment(alignment) {
        const eGui = this.getGui();
        const eGuiClassList = eGui.classList;
        eGuiClassList.toggle('ag-label-align-left', alignment === 'left');
        eGuiClassList.toggle('ag-label-align-right', alignment === 'right');
        eGuiClassList.toggle('ag-label-align-top', alignment === 'top');
        return this;
    }
    setLabelEllipsis(hasEllipsis) {
        this.eLabel.classList.toggle('ag-label-ellipsis', hasEllipsis);
        return this;
    }
    setLabelWidth(width) {
        if (this.label == null) {
            return this;
        }
        (0, dom_1._setElementWidth)(this.eLabel, width);
        return this;
    }
    setDisabled(disabled) {
        disabled = !!disabled;
        const element = this.getGui();
        (0, dom_1._setDisabled)(element, disabled);
        element.classList.toggle('ag-disabled', disabled);
        this.disabled = disabled;
        return this;
    }
    isDisabled() {
        return !!this.disabled;
    }
}
exports.AgAbstractLabel = AgAbstractLabel;


/***/ }),

/***/ 18531:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgCheckboxSelector = exports.AgCheckbox = void 0;
const agAbstractInputField_1 = __webpack_require__(71744);
class AgCheckbox extends agAbstractInputField_1.AgAbstractInputField {
    constructor(config, className = 'ag-checkbox', inputType = 'checkbox') {
        super(config, className, inputType);
        this.labelAlignment = 'right';
        this.selected = false;
        this.readOnly = false;
        this.passive = false;
    }
    postConstruct() {
        super.postConstruct();
        const { readOnly, passive } = this.config;
        if (typeof readOnly === 'boolean')
            this.setReadOnly(readOnly);
        if (typeof passive === 'boolean')
            this.setPassive(passive);
    }
    addInputListeners() {
        this.addManagedElementListeners(this.eInput, { click: this.onCheckboxClick.bind(this) });
        this.addManagedElementListeners(this.eLabel, { click: this.toggle.bind(this) });
    }
    getNextValue() {
        return this.selected === undefined ? true : !this.selected;
    }
    setPassive(passive) {
        this.passive = passive;
    }
    isReadOnly() {
        return this.readOnly;
    }
    setReadOnly(readOnly) {
        this.eWrapper.classList.toggle('ag-disabled', readOnly);
        this.eInput.disabled = readOnly;
        this.readOnly = readOnly;
    }
    setDisabled(disabled) {
        this.eWrapper.classList.toggle('ag-disabled', disabled);
        return super.setDisabled(disabled);
    }
    toggle() {
        if (this.eInput.disabled) {
            return;
        }
        const previousValue = this.isSelected();
        const nextValue = this.getNextValue();
        if (this.passive) {
            this.dispatchChange(nextValue, previousValue);
        }
        else {
            this.setValue(nextValue);
        }
    }
    getValue() {
        return this.isSelected();
    }
    setValue(value, silent) {
        this.refreshSelectedClass(value);
        this.setSelected(value, silent);
        return this;
    }
    setName(name) {
        const input = this.getInputElement();
        input.name = name;
        return this;
    }
    isSelected() {
        return this.selected;
    }
    setSelected(selected, silent) {
        if (this.isSelected() === selected) {
            return;
        }
        this.previousValue = this.isSelected();
        selected = this.selected = typeof selected === 'boolean' ? selected : undefined;
        const eInput = this.eInput;
        eInput.checked = selected;
        eInput.indeterminate = selected === undefined;
        if (!silent) {
            this.dispatchChange(this.selected, this.previousValue);
        }
    }
    dispatchChange(selected, previousValue, event) {
        this.dispatchLocalEvent({ type: 'fieldValueChanged', selected, previousValue, event });
        const input = this.getInputElement();
        this.eventSvc.dispatchEvent({
            type: 'checkboxChanged',
            id: input.id,
            name: input.name,
            selected,
            previousValue,
        });
    }
    onCheckboxClick(e) {
        if (this.passive || this.eInput.disabled) {
            return;
        }
        const previousValue = this.isSelected();
        const selected = (this.selected = e.target.checked);
        this.refreshSelectedClass(selected);
        this.dispatchChange(selected, previousValue, e);
    }
    refreshSelectedClass(value) {
        const classList = this.eWrapper.classList;
        classList.toggle('ag-checked', value === true);
        classList.toggle('ag-indeterminate', value == null);
    }
}
exports.AgCheckbox = AgCheckbox;
exports.AgCheckboxSelector = {
    selector: 'AG-CHECKBOX',
    component: AgCheckbox,
};


/***/ }),

/***/ 65310:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgInputDateFieldSelector = exports.AgInputDateField = void 0;
const browser_1 = __webpack_require__(36916);
const date_1 = __webpack_require__(97066);
const date_2 = __webpack_require__(97066);
const document_1 = __webpack_require__(80011);
const dom_1 = __webpack_require__(1956);
const agInputTextField_1 = __webpack_require__(89863);
class AgInputDateField extends agInputTextField_1.AgInputTextField {
    constructor(config) {
        super(config, 'ag-date-field', 'date');
    }
    postConstruct() {
        super.postConstruct();
        // ensures that the input element is focussed when a clear button is clicked,
        // unless using safari as there is no clear button and focus does not work properly
        const usingSafari = (0, browser_1._isBrowserSafari)();
        this.addManagedListeners(this.eInput, {
            wheel: this.onWheel.bind(this),
            mousedown: () => {
                if (this.isDisabled() || usingSafari) {
                    return;
                }
                this.eInput.focus();
            },
        });
        this.eInput.step = 'any';
    }
    onWheel(e) {
        // Prevent default scroll events from incrementing / decrementing the input, since its inconsistent between browsers
        if ((0, document_1._getActiveDomElement)(this.beans) === this.eInput) {
            e.preventDefault();
        }
    }
    setMin(minDate) {
        const min = minDate instanceof Date ? (0, date_2._serialiseDate)(minDate ?? null, !!this.includeTime) ?? undefined : minDate;
        if (this.min === min) {
            return this;
        }
        this.min = min;
        (0, dom_1._addOrRemoveAttribute)(this.eInput, 'min', min);
        return this;
    }
    setMax(maxDate) {
        const max = maxDate instanceof Date ? (0, date_2._serialiseDate)(maxDate ?? null, !!this.includeTime) ?? undefined : maxDate;
        if (this.max === max) {
            return this;
        }
        this.max = max;
        (0, dom_1._addOrRemoveAttribute)(this.eInput, 'max', max);
        return this;
    }
    setStep(step) {
        if (this.step === step) {
            return this;
        }
        this.step = step;
        (0, dom_1._addOrRemoveAttribute)(this.eInput, 'step', step);
        return this;
    }
    setIncludeTime(includeTime) {
        if (this.includeTime === includeTime) {
            return this;
        }
        this.includeTime = includeTime;
        super.setInputType(includeTime ? 'datetime-local' : 'date');
        if (includeTime)
            this.setStep(1);
        return this;
    }
    getDate() {
        if (!this.eInput.validity.valid) {
            return undefined;
        }
        return (0, date_1._parseDateTimeFromString)(this.getValue()) ?? undefined;
    }
    setDate(date, silent) {
        this.setValue((0, date_2._serialiseDate)(date ?? null, this.includeTime), silent);
    }
}
exports.AgInputDateField = AgInputDateField;
exports.AgInputDateFieldSelector = {
    selector: 'AG-INPUT-DATE-FIELD',
    component: AgInputDateField,
};


/***/ }),

/***/ 25721:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgInputNumberFieldSelector = exports.AgInputNumberField = void 0;
const document_1 = __webpack_require__(80011);
const dom_1 = __webpack_require__(1956);
const generic_1 = __webpack_require__(89097);
const agInputTextField_1 = __webpack_require__(89863);
class AgInputNumberField extends agInputTextField_1.AgInputTextField {
    constructor(config) {
        super(config, 'ag-number-field', 'number');
    }
    postConstruct() {
        super.postConstruct();
        const eInput = this.eInput;
        this.addManagedListeners(eInput, {
            blur: () => {
                const floatedValue = parseFloat(eInput.value);
                const value = isNaN(floatedValue) ? '' : this.normalizeValue(floatedValue.toString());
                if (this.value !== value) {
                    this.setValue(value);
                }
            },
            wheel: this.onWheel.bind(this),
        });
        eInput.step = 'any';
        const { precision, min, max, step } = this.config;
        if (typeof precision === 'number')
            this.setPrecision(precision);
        if (typeof min === 'number')
            this.setMin(min);
        if (typeof max === 'number')
            this.setMax(max);
        if (typeof step === 'number')
            this.setStep(step);
    }
    onWheel(e) {
        // Prevent default scroll events from incrementing / decrementing the input, since its inconsistent between browsers
        if ((0, document_1._getActiveDomElement)(this.beans) === this.eInput) {
            e.preventDefault();
        }
    }
    normalizeValue(value) {
        if (value === '') {
            return '';
        }
        if (this.precision != null) {
            value = this.adjustPrecision(value);
        }
        return value;
    }
    adjustPrecision(value, isScientificNotation) {
        const precision = this.precision;
        if (precision == null) {
            return value;
        }
        if (isScientificNotation) {
            const floatString = parseFloat(value).toFixed(precision);
            return parseFloat(floatString).toString();
        }
        // can't use toFixed here because we don't want to round up
        const parts = String(value).split('.');
        if (parts.length > 1) {
            if (parts[1].length <= precision) {
                return value;
            }
            else if (precision > 0) {
                return `${parts[0]}.${parts[1].slice(0, precision)}`;
            }
        }
        return parts[0];
    }
    setMin(min) {
        if (this.min === min) {
            return this;
        }
        this.min = min;
        (0, dom_1._addOrRemoveAttribute)(this.eInput, 'min', min);
        return this;
    }
    setMax(max) {
        if (this.max === max) {
            return this;
        }
        this.max = max;
        (0, dom_1._addOrRemoveAttribute)(this.eInput, 'max', max);
        return this;
    }
    setPrecision(precision) {
        this.precision = precision;
        return this;
    }
    setStep(step) {
        if (this.step === step) {
            return this;
        }
        this.step = step;
        (0, dom_1._addOrRemoveAttribute)(this.eInput, 'step', step);
        return this;
    }
    setValue(value, silent) {
        return this.setValueOrInputValue((v) => super.setValue(v, silent), () => this, value);
    }
    setStartValue(value) {
        return this.setValueOrInputValue((v) => super.setValue(v, true), (v) => {
            this.eInput.value = v;
        }, value);
    }
    setValueOrInputValue(setValueFunc, setInputValueOnlyFunc, value) {
        if ((0, generic_1._exists)(value)) {
            // need to maintain the scientific notation format whilst typing (e.g. 1e10)
            let setInputValueOnly = this.isScientificNotation(value);
            if (setInputValueOnly && this.eInput.validity.valid) {
                return setValueFunc(value);
            }
            if (!setInputValueOnly) {
                value = this.adjustPrecision(value);
                const normalizedValue = this.normalizeValue(value);
                // outside of valid range
                setInputValueOnly = value != normalizedValue;
            }
            if (setInputValueOnly) {
                return setInputValueOnlyFunc(value);
            }
        }
        return setValueFunc(value);
    }
    getValue() {
        const eInput = this.eInput;
        if (!eInput.validity.valid) {
            return undefined;
        }
        const inputValue = eInput.value;
        if (this.isScientificNotation(inputValue)) {
            return this.adjustPrecision(inputValue, true);
        }
        return super.getValue();
    }
    isScientificNotation(value) {
        return typeof value === 'string' && value.includes('e');
    }
}
exports.AgInputNumberField = AgInputNumberField;
exports.AgInputNumberFieldSelector = {
    selector: 'AG-INPUT-NUMBER-FIELD',
    component: AgInputNumberField,
};


/***/ }),

/***/ 69878:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgInputTextAreaSelector = exports.AgInputTextArea = void 0;
const agAbstractInputField_1 = __webpack_require__(71744);
class AgInputTextArea extends agAbstractInputField_1.AgAbstractInputField {
    constructor(config) {
        super(config, 'ag-text-area', null, 'textarea');
    }
    setValue(value, silent) {
        const ret = super.setValue(value, silent);
        this.eInput.value = value;
        return ret;
    }
    setCols(cols) {
        this.eInput.cols = cols;
        return this;
    }
    setRows(rows) {
        this.eInput.rows = rows;
        return this;
    }
}
exports.AgInputTextArea = AgInputTextArea;
exports.AgInputTextAreaSelector = {
    selector: 'AG-INPUT-TEXT-AREA',
    component: AgInputTextArea,
};


/***/ }),

/***/ 89863:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgInputTextFieldSelector = exports.AgInputTextField = void 0;
const generic_1 = __webpack_require__(89097);
const keyboard_1 = __webpack_require__(93967);
const agAbstractInputField_1 = __webpack_require__(71744);
class AgInputTextField extends agAbstractInputField_1.AgAbstractInputField {
    constructor(config, className = 'ag-text-field', inputType = 'text') {
        super(config, className, inputType);
    }
    postConstruct() {
        super.postConstruct();
        if (this.config.allowedCharPattern) {
            this.preventDisallowedCharacters();
        }
    }
    setValue(value, silent) {
        const eInput = this.eInput;
        // update the input before we call super.setValue, so it's updated before the value changed event is fired
        if (eInput.value !== value) {
            eInput.value = (0, generic_1._exists)(value) ? value : '';
        }
        return super.setValue(value, silent);
    }
    /** Used to set an initial value into the input without necessarily setting `this.value` or triggering events (e.g. to set an invalid value) */
    setStartValue(value) {
        this.setValue(value, true);
    }
    preventDisallowedCharacters() {
        const pattern = new RegExp(`[${this.config.allowedCharPattern}]`);
        const preventCharacters = (event) => {
            if (!(0, keyboard_1._isEventFromPrintableCharacter)(event)) {
                return;
            }
            if (event.key && !pattern.test(event.key)) {
                event.preventDefault();
            }
        };
        this.addManagedListeners(this.eInput, {
            keydown: preventCharacters,
            paste: (e) => {
                const text = e.clipboardData?.getData('text');
                if (text && text.split('').some((c) => !pattern.test(c))) {
                    e.preventDefault();
                }
            },
        });
    }
}
exports.AgInputTextField = AgInputTextField;
exports.AgInputTextFieldSelector = {
    selector: 'AG-INPUT-TEXT-FIELD',
    component: AgInputTextField,
};


/***/ }),

/***/ 21355:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.agListCSS = void 0;
exports.agListCSS = `.ag-list-item{align-items:center;display:flex;height:var(--ag-list-item-height);overflow:hidden;text-overflow:ellipsis;white-space:nowrap;&.ag-active-item{background-color:var(--ag-row-hover-color)}}`;


/***/ }),

/***/ 26666:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgList = void 0;
const keyCode_1 = __webpack_require__(59926);
const agComponentStub_1 = __webpack_require__(7047);
const aria_1 = __webpack_require__(91623);
const array_1 = __webpack_require__(79909);
const dom_1 = __webpack_require__(1956);
const agList_css_GENERATED_1 = __webpack_require__(21355);
const agListItem_1 = __webpack_require__(52773);
class AgList extends agComponentStub_1.AgComponentStub {
    constructor(cssIdentifier = 'default') {
        super({ tag: 'div', cls: `ag-list ag-${cssIdentifier}-list` });
        this.cssIdentifier = cssIdentifier;
        this.options = [];
        this.listItems = [];
        this.highlightedItem = null;
        this.registerCSS(agList_css_GENERATED_1.agListCSS);
    }
    postConstruct() {
        const eGui = this.getGui();
        this.addManagedElementListeners(eGui, { mouseleave: () => this.clearHighlighted() });
    }
    handleKeyDown(e) {
        const key = e.key;
        switch (key) {
            case keyCode_1.KeyCode.ENTER:
                if (!this.highlightedItem) {
                    this.setValue(this.getValue());
                }
                else {
                    const pos = this.listItems.indexOf(this.highlightedItem);
                    this.setValueByIndex(pos);
                }
                break;
            case keyCode_1.KeyCode.DOWN:
            case keyCode_1.KeyCode.UP:
                e.preventDefault();
                this.navigate(key);
                break;
            case keyCode_1.KeyCode.PAGE_DOWN:
            case keyCode_1.KeyCode.PAGE_UP:
            case keyCode_1.KeyCode.PAGE_HOME:
            case keyCode_1.KeyCode.PAGE_END:
                e.preventDefault();
                this.navigateToPage(key);
                break;
        }
    }
    addOptions(listOptions) {
        listOptions.forEach((listOption) => this.addOption(listOption));
        return this;
    }
    addOption(listOption) {
        const { value, text } = listOption;
        const valueToRender = text ?? value;
        this.options.push({ value, text: valueToRender });
        this.renderOption(value, valueToRender);
        this.updateIndices();
        return this;
    }
    clearOptions() {
        this.options = [];
        this.reset(true);
        this.listItems.forEach((item) => {
            item.destroy();
        });
        (0, dom_1._clearElement)(this.getGui());
        this.listItems = [];
        this.refreshAriaRole();
    }
    setValue(value, silent) {
        if (this.value === value) {
            this.fireItemSelected();
            return this;
        }
        if (value == null) {
            this.reset(silent);
            return this;
        }
        const idx = this.options.findIndex((option) => option.value === value);
        if (idx !== -1) {
            const option = this.options[idx];
            this.value = option.value;
            this.displayValue = option.text;
            this.highlightItem(this.listItems[idx]);
            if (!silent) {
                this.fireChangeEvent();
            }
        }
        return this;
    }
    setValueByIndex(idx) {
        return this.setValue(this.options[idx].value);
    }
    getValue() {
        return this.value;
    }
    getDisplayValue() {
        return this.displayValue;
    }
    refreshHighlighted() {
        this.clearHighlighted();
        const idx = this.options.findIndex((option) => option.value === this.value);
        if (idx !== -1) {
            this.highlightItem(this.listItems[idx]);
        }
    }
    highlightItem(item) {
        const itemEl = item.getGui();
        if (!(0, dom_1._isVisible)(itemEl)) {
            return;
        }
        this.clearHighlighted();
        item.setHighlighted(true);
        this.highlightedItem = item;
        const eGui = this.getGui();
        const { scrollTop, clientHeight } = eGui;
        const { offsetTop, offsetHeight } = itemEl;
        if (offsetTop + offsetHeight > scrollTop + clientHeight || offsetTop < scrollTop) {
            itemEl.scrollIntoView({ block: 'nearest' });
        }
    }
    hideItemTooltip() {
        this.highlightedItem?.tooltipFeature?.attemptToHideTooltip();
    }
    destroy() {
        this.hideItemTooltip();
        super.destroy();
    }
    reset(silent) {
        this.value = null;
        this.displayValue = null;
        this.clearHighlighted();
        if (!silent) {
            this.fireChangeEvent();
        }
    }
    clearHighlighted() {
        this.highlightedItem?.setHighlighted(false);
        this.highlightedItem = null;
    }
    renderOption(value, text) {
        const item = new agListItem_1.AgListItem(this.cssIdentifier, text, value);
        item.setParentComponent(this);
        const listItem = this.createManagedBean(item);
        this.listItems.push(listItem);
        this.getGui().appendChild(listItem.getGui());
    }
    navigate(key) {
        const isDown = key === keyCode_1.KeyCode.DOWN;
        let itemToHighlight;
        const { listItems, highlightedItem } = this;
        if (!highlightedItem) {
            itemToHighlight = isDown ? listItems[0] : (0, array_1._last)(listItems);
        }
        else {
            const currentIdx = listItems.indexOf(highlightedItem);
            let nextPos = currentIdx + (isDown ? 1 : -1);
            nextPos = Math.min(Math.max(nextPos, 0), listItems.length - 1);
            itemToHighlight = listItems[nextPos];
        }
        this.highlightItem(itemToHighlight);
    }
    navigateToPage(key) {
        const { listItems, highlightedItem } = this;
        if (!highlightedItem || listItems.length === 0) {
            return;
        }
        const currentIdx = listItems.indexOf(highlightedItem);
        const rowCount = this.options.length - 1;
        const itemHeight = listItems[0].getHeight();
        const pageSize = Math.floor(this.getGui().clientHeight / itemHeight);
        let newIndex = -1;
        if (key === keyCode_1.KeyCode.PAGE_HOME) {
            newIndex = 0;
        }
        else if (key === keyCode_1.KeyCode.PAGE_END) {
            newIndex = rowCount;
        }
        else if (key === keyCode_1.KeyCode.PAGE_DOWN) {
            newIndex = Math.min(currentIdx + pageSize, rowCount);
        }
        else if (key === keyCode_1.KeyCode.PAGE_UP) {
            newIndex = Math.max(currentIdx - pageSize, 0);
        }
        if (newIndex === -1) {
            return;
        }
        this.highlightItem(listItems[newIndex]);
    }
    refreshAriaRole() {
        (0, aria_1._setAriaRole)(this.getGui(), this.options.length === 0 ? 'presentation' : 'listbox');
    }
    updateIndices() {
        this.refreshAriaRole();
        const listItems = this.listItems;
        const len = listItems.length;
        listItems.forEach((item, idx) => {
            item.setIndex(idx + 1, len);
        });
    }
    fireChangeEvent() {
        this.dispatchLocalEvent({ type: 'fieldValueChanged' });
        this.fireItemSelected();
    }
    fireItemSelected() {
        this.dispatchLocalEvent({ type: 'selectedItem' });
    }
}
exports.AgList = AgList;


/***/ }),

/***/ 52773:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgListItem = void 0;
const agComponentStub_1 = __webpack_require__(7047);
const agComponent_1 = __webpack_require__(91668);
const aria_1 = __webpack_require__(91623);
const dom_1 = __webpack_require__(1956);
const ACTIVE_CLASS = 'ag-active-item';
const getAgListElement = (cssIdentifier, label) => ({
    tag: 'div',
    cls: `ag-list-item ag-${cssIdentifier}-list-item`,
    attrs: { role: 'option' },
    children: [
        {
            tag: 'span',
            ref: 'eText',
            children: label,
        },
    ],
});
class AgListItem extends agComponentStub_1.AgComponentStub {
    constructor(cssIdentifier, label, value) {
        super(getAgListElement(cssIdentifier, label));
        this.label = label;
        this.value = value;
        this.eText = agComponent_1.RefPlaceholder;
    }
    postConstruct() {
        this.createTooltip();
        this.addEventListeners();
    }
    setHighlighted(highlighted) {
        const eGui = this.getGui();
        eGui.classList.toggle(ACTIVE_CLASS, highlighted);
        (0, aria_1._setAriaSelected)(eGui, highlighted);
        this.dispatchLocalEvent({
            type: 'itemHighlighted',
            highlighted,
        });
    }
    getHeight() {
        return this.getGui().clientHeight;
    }
    setIndex(idx, setSize) {
        const eGui = this.getGui();
        (0, aria_1._setAriaPosInSet)(eGui, idx);
        (0, aria_1._setAriaSetSize)(eGui, setSize);
    }
    createTooltip() {
        const tooltipCtrl = {
            getTooltipValue: () => this.label,
            getGui: () => this.getGui(),
            getLocation: () => 'UNKNOWN',
            // only show tooltips for items where the text cannot be fully displayed
            shouldDisplayTooltip: () => (0, dom_1._isHorizontalScrollShowing)(this.eText),
        };
        const tooltipFeature = this.createOptionalManagedBean(this.beans.registry.createDynamicBean('highlightTooltipFeature', false, tooltipCtrl, this));
        if (tooltipFeature) {
            this.tooltipFeature = tooltipFeature;
        }
    }
    addEventListeners() {
        const parentComponent = this.getParentComponent();
        if (!parentComponent) {
            return;
        }
        this.addGuiEventListener('mouseover', () => {
            parentComponent.highlightItem(this);
        });
        this.addGuiEventListener('mousedown', (e) => {
            e.preventDefault();
            // `setValue` will already close the list popup, without stopPropagation
            // the mousedown event will close popups that own AgSelect
            e.stopPropagation();
            parentComponent.setValue(this.value);
        });
    }
}
exports.AgListItem = AgListItem;


/***/ }),

/***/ 82395:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.agPickerFieldCSS = void 0;
exports.agPickerFieldCSS = `.ag-picker-field-display{flex:1 1 auto}.ag-picker-field{align-items:center;display:flex}.ag-picker-field-icon{border:0;cursor:pointer;display:flex;margin:0;padding:0}.ag-picker-field-wrapper{background-color:var(--ag-picker-button-background-color);border:var(--ag-picker-button-border);border-radius:5px;min-height:max(var(--ag-list-item-height),calc(var(--ag-spacing)*4));overflow:hidden;&:where(.ag-picker-has-focus),&:where(:focus-within){background-color:var(--ag-picker-button-focus-background-color);border:var(--ag-picker-button-focus-border);box-shadow:var(--ag-focus-shadow);&:where(.invalid){box-shadow:var(--ag-focus-error-shadow)}}&:where(.invalid){background-color:var(--ag-input-invalid-background-color);border:var(--ag-input-invalid-border);color:var(--ag-input-invalid-text-color)}&:disabled{opacity:.5}}`;


/***/ }),

/***/ 23898:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgPickerField = void 0;
const keyCode_1 = __webpack_require__(59926);
const agComponent_1 = __webpack_require__(91668);
const aria_1 = __webpack_require__(91623);
const document_1 = __webpack_require__(80011);
const dom_1 = __webpack_require__(1956);
const agAbstractField_1 = __webpack_require__(54978);
const agPickerField_css_GENERATED_1 = __webpack_require__(82395);
const AgPickerFieldElement = {
    tag: 'div',
    cls: 'ag-picker-field',
    role: 'presentation',
    children: [
        { tag: 'div', ref: 'eLabel' },
        {
            tag: 'div',
            ref: 'eWrapper',
            cls: 'ag-wrapper ag-picker-field-wrapper ag-picker-collapsed',
            children: [
                { tag: 'div', ref: 'eDisplayField', cls: 'ag-picker-field-display' },
                { tag: 'div', ref: 'eIcon', cls: 'ag-picker-field-icon', attrs: { 'aria-hidden': 'true' } },
            ],
        },
    ],
};
class AgPickerField extends agAbstractField_1.AgAbstractField {
    constructor(config) {
        super(config, config?.template || AgPickerFieldElement, config?.agComponents || [], config?.className);
        this.isPickerDisplayed = false;
        this.skipClick = false;
        this.pickerGap = 4;
        this.hideCurrentPicker = null;
        this.eLabel = agComponent_1.RefPlaceholder;
        this.eWrapper = agComponent_1.RefPlaceholder;
        this.eDisplayField = agComponent_1.RefPlaceholder;
        this.eIcon = agComponent_1.RefPlaceholder;
        this.registerCSS(agPickerField_css_GENERATED_1.agPickerFieldCSS);
        this.ariaRole = config?.ariaRole;
        this.onPickerFocusIn = this.onPickerFocusIn.bind(this);
        this.onPickerFocusOut = this.onPickerFocusOut.bind(this);
        if (!config) {
            return;
        }
        const { pickerGap, maxPickerHeight, variableWidth, minPickerWidth, maxPickerWidth } = config;
        if (pickerGap != null) {
            this.pickerGap = pickerGap;
        }
        this.variableWidth = !!variableWidth;
        if (maxPickerHeight != null) {
            this.setPickerMaxHeight(maxPickerHeight);
        }
        if (minPickerWidth != null) {
            this.setPickerMinWidth(minPickerWidth);
        }
        if (maxPickerWidth != null) {
            this.setPickerMaxWidth(maxPickerWidth);
        }
    }
    postConstruct() {
        super.postConstruct();
        this.setupAria();
        const displayId = `ag-${this.getCompId()}-display`;
        this.eDisplayField.setAttribute('id', displayId);
        const ariaEl = this.getAriaElement();
        this.addManagedElementListeners(ariaEl, { keydown: this.onKeyDown.bind(this) });
        this.addManagedElementListeners(this.eLabel, { mousedown: this.onLabelOrWrapperMouseDown.bind(this) });
        this.addManagedElementListeners(this.eWrapper, { mousedown: this.onLabelOrWrapperMouseDown.bind(this) });
        const { pickerIcon, inputWidth } = this.config;
        if (pickerIcon) {
            const icon = this.beans.iconSvc.createIconNoSpan(pickerIcon);
            if (icon) {
                this.eIcon.appendChild(icon);
            }
        }
        if (inputWidth != null) {
            this.setInputWidth(inputWidth);
        }
    }
    setupAria() {
        const ariaEl = this.getAriaElement();
        ariaEl.setAttribute('tabindex', this.gos.get('tabIndex').toString());
        (0, aria_1._setAriaExpanded)(ariaEl, false);
        if (this.ariaRole) {
            (0, aria_1._setAriaRole)(ariaEl, this.ariaRole);
        }
    }
    onLabelOrWrapperMouseDown(e) {
        if (e) {
            const focusableEl = this.getFocusableElement();
            // if the focusableEl is not the wrapper and the mousedown
            // targets the focusableEl, we should not expand/collapse the picker.
            // Note: this will happen when AgRichSelect is set with `allowTyping=true`
            if (focusableEl !== this.eWrapper && e?.target === focusableEl) {
                return;
            }
            // this prevents a BUG where MouseDown causes the element to be focused
            // after the picker is shown and focus ends up being lost.
            e.preventDefault();
            this.getFocusableElement().focus();
        }
        if (this.skipClick) {
            this.skipClick = false;
            return;
        }
        if (this.isDisabled()) {
            return;
        }
        if (this.isPickerDisplayed) {
            this.hidePicker();
        }
        else {
            this.showPicker();
        }
    }
    onKeyDown(e) {
        switch (e.key) {
            case keyCode_1.KeyCode.UP:
            case keyCode_1.KeyCode.DOWN:
            case keyCode_1.KeyCode.ENTER:
            case keyCode_1.KeyCode.SPACE:
                e.preventDefault();
                this.onLabelOrWrapperMouseDown();
                break;
            case keyCode_1.KeyCode.ESCAPE:
                if (this.isPickerDisplayed) {
                    e.preventDefault();
                    e.stopPropagation();
                    if (this.hideCurrentPicker) {
                        this.hideCurrentPicker();
                    }
                }
                break;
        }
    }
    showPicker() {
        this.isPickerDisplayed = true;
        if (!this.pickerComponent) {
            this.pickerComponent = this.createPickerComponent();
        }
        const pickerGui = this.pickerComponent.getGui();
        pickerGui.addEventListener('focusin', this.onPickerFocusIn);
        pickerGui.addEventListener('focusout', this.onPickerFocusOut);
        this.hideCurrentPicker = this.renderAndPositionPicker();
        this.toggleExpandedStyles(true);
    }
    renderAndPositionPicker() {
        const ePicker = this.pickerComponent.getGui();
        if (!this.gos.get('suppressScrollWhenPopupsAreOpen')) {
            [this.destroyMouseWheelFunc] = this.addManagedEventListeners({
                bodyScroll: () => {
                    this.hidePicker();
                },
            });
        }
        const translate = this.getLocaleTextFunc();
        const { config: { pickerAriaLabelKey, pickerAriaLabelValue, modalPicker = true }, maxPickerHeight, minPickerWidth, maxPickerWidth, variableWidth, beans, eWrapper, } = this;
        const popupParams = {
            modal: modalPicker,
            eChild: ePicker,
            closeOnEsc: true,
            closedCallback: () => {
                const shouldRestoreFocus = (0, document_1._isNothingFocused)(beans);
                this.beforeHidePicker();
                if (shouldRestoreFocus && this.isAlive()) {
                    this.getFocusableElement().focus();
                }
            },
            ariaLabel: translate(pickerAriaLabelKey, pickerAriaLabelValue),
            anchorToElement: eWrapper,
        };
        // need to set position before adding to the dom
        ePicker.style.position = 'absolute';
        const popupSvc = beans.popupSvc;
        const addPopupRes = popupSvc.addPopup(popupParams);
        if (variableWidth) {
            if (minPickerWidth) {
                ePicker.style.minWidth = minPickerWidth;
            }
            ePicker.style.width = (0, dom_1._formatSize)((0, dom_1._getAbsoluteWidth)(eWrapper));
            if (maxPickerWidth) {
                ePicker.style.maxWidth = maxPickerWidth;
            }
        }
        else {
            (0, dom_1._setElementWidth)(ePicker, maxPickerWidth ?? (0, dom_1._getAbsoluteWidth)(eWrapper));
        }
        const maxHeight = maxPickerHeight ?? `${(0, dom_1._getInnerHeight)(popupSvc.getPopupParent())}px`;
        ePicker.style.setProperty('max-height', maxHeight);
        this.alignPickerToComponent();
        return addPopupRes.hideFunc;
    }
    alignPickerToComponent() {
        if (!this.pickerComponent) {
            return;
        }
        const { pickerGap, config: { pickerType }, beans: { popupSvc, gos }, eWrapper, pickerComponent, } = this;
        const alignSide = gos.get('enableRtl') ? 'right' : 'left';
        popupSvc.positionPopupByComponent({
            type: pickerType,
            eventSource: eWrapper,
            ePopup: pickerComponent.getGui(),
            position: 'under',
            alignSide,
            keepWithinBounds: true,
            nudgeY: pickerGap,
        });
    }
    beforeHidePicker() {
        if (this.destroyMouseWheelFunc) {
            this.destroyMouseWheelFunc();
            this.destroyMouseWheelFunc = undefined;
        }
        this.toggleExpandedStyles(false);
        const pickerGui = this.pickerComponent.getGui();
        pickerGui.removeEventListener('focusin', this.onPickerFocusIn);
        pickerGui.removeEventListener('focusout', this.onPickerFocusOut);
        this.isPickerDisplayed = false;
        this.pickerComponent = undefined;
        this.hideCurrentPicker = null;
    }
    toggleExpandedStyles(expanded) {
        if (!this.isAlive()) {
            return;
        }
        const ariaEl = this.getAriaElement();
        (0, aria_1._setAriaExpanded)(ariaEl, expanded);
        const classList = this.eWrapper.classList;
        classList.toggle('ag-picker-expanded', expanded);
        classList.toggle('ag-picker-collapsed', !expanded);
    }
    onPickerFocusIn() {
        this.togglePickerHasFocus(true);
    }
    onPickerFocusOut(e) {
        if (!this.pickerComponent?.getGui().contains(e.relatedTarget)) {
            this.togglePickerHasFocus(false);
        }
    }
    togglePickerHasFocus(focused) {
        if (!this.pickerComponent) {
            return;
        }
        this.eWrapper.classList.toggle('ag-picker-has-focus', focused);
    }
    hidePicker() {
        if (this.hideCurrentPicker) {
            this.hideCurrentPicker();
            this.dispatchLocalEvent({
                type: 'pickerHidden',
            });
        }
    }
    setInputWidth(width) {
        (0, dom_1._setElementWidth)(this.eWrapper, width);
        return this;
    }
    getFocusableElement() {
        return this.eWrapper;
    }
    setPickerGap(gap) {
        this.pickerGap = gap;
        return this;
    }
    setPickerMinWidth(width) {
        if (typeof width === 'number') {
            width = `${width}px`;
        }
        this.minPickerWidth = width == null ? undefined : width;
        return this;
    }
    setPickerMaxWidth(width) {
        if (typeof width === 'number') {
            width = `${width}px`;
        }
        this.maxPickerWidth = width == null ? undefined : width;
        return this;
    }
    setPickerMaxHeight(height) {
        if (typeof height === 'number') {
            height = `${height}px`;
        }
        this.maxPickerHeight = height == null ? undefined : height;
        return this;
    }
    destroy() {
        this.hidePicker();
        super.destroy();
    }
}
exports.AgPickerField = AgPickerField;


/***/ }),

/***/ 6951:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgRadioButton = void 0;
const agCheckbox_1 = __webpack_require__(18531);
class AgRadioButton extends agCheckbox_1.AgCheckbox {
    constructor(config) {
        super(config, 'ag-radio-button', 'radio');
    }
    isSelected() {
        return this.eInput.checked;
    }
    toggle() {
        if (this.eInput.disabled) {
            return;
        }
        // do not allow an active radio button to be deselected
        if (!this.isSelected()) {
            this.setValue(true);
        }
    }
    addInputListeners() {
        super.addInputListeners();
        this.addManagedEventListeners({ checkboxChanged: this.onChange.bind(this) });
    }
    /**
     * This ensures that if another radio button in the same named group is selected, we deselect this radio button.
     * By default the browser does this for you, but we are managing classes ourselves in order to ensure input
     * elements are styled correctly in IE11, and the DOM 'changed' event is only fired when a button is selected,
     * not deselected, so we need to use our own event.
     */
    onChange(event) {
        const eInput = this.eInput;
        if (event.selected &&
            event.name &&
            eInput.name &&
            eInput.name === event.name &&
            event.id &&
            eInput.id !== event.id) {
            this.setValue(false, true);
        }
    }
}
exports.AgRadioButton = AgRadioButton;


/***/ }),

/***/ 7555:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.agSelectCSS = void 0;
exports.agSelectCSS = `.ag-select{align-items:center;display:flex;&.ag-disabled{opacity:.5}}:where(.ag-select){.ag-picker-field-wrapper{cursor:default}&.ag-disabled .ag-picker-field-wrapper:focus{box-shadow:none}&:not(.ag-cell-editor,.ag-label-align-top){min-height:var(--ag-list-item-height)}.ag-picker-field-display{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ag-picker-field-icon{align-items:center;display:flex}}:where(.ag-ltr) :where(.ag-select){.ag-picker-field-wrapper{padding-left:calc(var(--ag-cell-horizontal-padding)/2);padding-right:var(--ag-spacing)}}:where(.ag-rtl) :where(.ag-select){.ag-picker-field-wrapper{padding-left:var(--ag-spacing);padding-right:calc(var(--ag-cell-horizontal-padding)/2)}}.ag-select-list{background-color:var(--ag-picker-list-background-color);border:var(--ag-picker-list-border);border-radius:var(--ag-border-radius);box-shadow:var(--ag-dropdown-shadow);overflow:hidden auto}.ag-select-list-item{cursor:default;-webkit-user-select:none;-moz-user-select:none;user-select:none;:where(span){overflow:hidden;text-overflow:ellipsis;white-space:nowrap}}:where(.ag-ltr) .ag-select-list-item{padding-left:calc(var(--ag-cell-horizontal-padding)/2)}:where(.ag-rtl) .ag-select-list-item{padding-right:calc(var(--ag-cell-horizontal-padding)/2)}`;


/***/ }),

/***/ 69234:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgSelectSelector = exports.AgSelect = void 0;
const keyCode_1 = __webpack_require__(59926);
const aria_1 = __webpack_require__(91623);
const dom_1 = __webpack_require__(1956);
const agList_1 = __webpack_require__(26666);
const agPickerField_1 = __webpack_require__(23898);
const agSelect_css_GENERATED_1 = __webpack_require__(7555);
class AgSelect extends agPickerField_1.AgPickerField {
    constructor(config) {
        super({
            pickerAriaLabelKey: 'ariaLabelSelectField',
            pickerAriaLabelValue: 'Select Field',
            pickerType: 'ag-list',
            className: 'ag-select',
            pickerIcon: 'selectOpen',
            ariaRole: 'combobox',
            ...config,
        });
        this.registerCSS(agSelect_css_GENERATED_1.agSelectCSS);
    }
    postConstruct() {
        this.tooltipFeature = this.createOptionalManagedBean(this.beans.registry.createDynamicBean('tooltipFeature', false, {
            shouldDisplayTooltip: (0, dom_1._isElementOverflowingCallback)(() => this.eDisplayField),
            getGui: () => this.getGui(),
        }));
        super.postConstruct();
        this.createListComponent();
        this.eWrapper.tabIndex = this.gos.get('tabIndex');
        const { options, value, placeholder } = this.config;
        if (options != null) {
            this.addOptions(options);
        }
        if (value != null) {
            // need to reapply value after list component created
            this.setValue(value, true);
        }
        if (placeholder && value == null) {
            this.eDisplayField.textContent = placeholder;
        }
        this.addManagedElementListeners(this.eWrapper, { focusout: this.onWrapperFocusOut.bind(this) });
    }
    onWrapperFocusOut(e) {
        if (!this.eWrapper.contains(e.relatedTarget)) {
            this.hidePicker();
        }
    }
    createListComponent() {
        const listComponent = this.createBean(new agList_1.AgList('select'));
        this.listComponent = listComponent;
        listComponent.setParentComponent(this);
        const eListAriaEl = listComponent.getAriaElement();
        const listId = `ag-select-list-${listComponent.getCompId()}`;
        eListAriaEl.setAttribute('id', listId);
        (0, aria_1._setAriaControlsAndLabel)(this.getAriaElement(), eListAriaEl);
        listComponent.addManagedElementListeners(listComponent.getGui(), {
            mousedown: (e) => {
                e?.preventDefault();
            },
        });
        listComponent.addManagedListeners(listComponent, {
            selectedItem: () => {
                this.hidePicker();
                this.dispatchLocalEvent({ type: 'selectedItem' });
            },
            fieldValueChanged: () => {
                if (!this.listComponent) {
                    return;
                }
                this.setValue(this.listComponent.getValue(), false, true);
                this.hidePicker();
            },
        });
    }
    createPickerComponent() {
        // do not create the picker every time to save state
        return this.listComponent;
    }
    beforeHidePicker() {
        this.listComponent?.hideItemTooltip();
        super.beforeHidePicker();
    }
    onKeyDown(e) {
        const { key } = e;
        if (key === keyCode_1.KeyCode.TAB) {
            this.hidePicker();
        }
        switch (key) {
            case keyCode_1.KeyCode.ENTER:
            case keyCode_1.KeyCode.UP:
            case keyCode_1.KeyCode.DOWN:
            case keyCode_1.KeyCode.PAGE_UP:
            case keyCode_1.KeyCode.PAGE_DOWN:
            case keyCode_1.KeyCode.PAGE_HOME:
            case keyCode_1.KeyCode.PAGE_END:
                e.preventDefault();
                if (this.isPickerDisplayed) {
                    this.listComponent?.handleKeyDown(e);
                }
                else {
                    super.onKeyDown(e);
                }
                break;
            case keyCode_1.KeyCode.ESCAPE:
                super.onKeyDown(e);
                break;
            case keyCode_1.KeyCode.SPACE:
                if (this.isPickerDisplayed) {
                    e.preventDefault();
                }
                else {
                    super.onKeyDown(e);
                }
                break;
        }
    }
    showPicker() {
        const listComponent = this.listComponent;
        if (!listComponent) {
            return;
        }
        super.showPicker();
        listComponent.refreshHighlighted();
    }
    addOptions(options) {
        options.forEach((option) => this.addOption(option));
        return this;
    }
    addOption(option) {
        this.listComponent.addOption(option);
        return this;
    }
    clearOptions() {
        this.listComponent?.clearOptions();
        this.setValue(undefined, true);
        return this;
    }
    setValue(value, silent, fromPicker) {
        const { listComponent, config: { placeholder }, eDisplayField, tooltipFeature, } = this;
        if (this.value === value || !listComponent) {
            return this;
        }
        if (!fromPicker) {
            listComponent.setValue(value, true);
        }
        const newValue = listComponent.getValue();
        if (newValue === this.getValue()) {
            return this;
        }
        let displayValue = listComponent.getDisplayValue();
        if (displayValue == null && placeholder) {
            displayValue = placeholder;
        }
        eDisplayField.textContent = displayValue;
        tooltipFeature?.setTooltipAndRefresh(displayValue ?? null);
        return super.setValue(value, silent);
    }
    destroy() {
        this.listComponent = this.destroyBean(this.listComponent);
        super.destroy();
    }
}
exports.AgSelect = AgSelect;
exports.AgSelectSelector = {
    selector: 'AG-SELECT',
    component: AgSelect,
};


/***/ }),

/***/ 97999:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.agToggleButtonCSS = void 0;
exports.agToggleButtonCSS = `.ag-toggle-button{flex:none;min-width:unset;width:unset}.ag-toggle-button-input-wrapper{background-color:var(--ag-toggle-button-off-background-color);border-radius:calc(var(--ag-toggle-button-height)*.5);flex:none;height:var(--ag-toggle-button-height);max-width:var(--ag-toggle-button-width);min-width:var(--ag-toggle-button-width);position:relative;transition:background-color .1s;:where(.ag-toggle-button-input){-webkit-appearance:none;-moz-appearance:none;appearance:none;cursor:pointer;display:block;height:var(--ag-toggle-button-height);margin:0;max-width:var(--ag-toggle-button-width);min-width:var(--ag-toggle-button-width);opacity:0}&:before{background-color:var(--ag-toggle-button-switch-background-color);border-radius:100%;content:"";display:block;height:calc(var(--ag-toggle-button-height) - var(--ag-toggle-button-switch-inset)*2);left:var(--ag-toggle-button-switch-inset);pointer-events:none;position:absolute;top:var(--ag-toggle-button-switch-inset);transition:left .1s;width:calc(var(--ag-toggle-button-height) - var(--ag-toggle-button-switch-inset)*2)}&.ag-checked{background-color:var(--ag-toggle-button-on-background-color);&:before{left:calc(100% - var(--ag-toggle-button-height) + var(--ag-toggle-button-switch-inset))}}&:focus-within{box-shadow:var(--ag-focus-shadow)}&.ag-disabled{opacity:.5}}`;


/***/ }),

/***/ 26774:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgToggleButtonSelector = exports.AgToggleButton = void 0;
const agCheckbox_1 = __webpack_require__(18531);
const agToggleButton_css_GENERATED_1 = __webpack_require__(97999);
class AgToggleButton extends agCheckbox_1.AgCheckbox {
    constructor(config) {
        super(config, 'ag-toggle-button');
        this.registerCSS(agToggleButton_css_GENERATED_1.agToggleButtonCSS);
    }
    setValue(value, silent) {
        super.setValue(value, silent);
        this.toggleCss('ag-selected', this.getValue());
        return this;
    }
}
exports.AgToggleButton = AgToggleButton;
exports.AgToggleButtonSelector = {
    selector: 'AG-TOGGLE-BUTTON',
    component: AgToggleButton,
};


/***/ }),

/***/ 22074:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AlignedGridsModule = void 0;
const columnModule_1 = __webpack_require__(52027);
const version_1 = __webpack_require__(97205);
const alignedGridsService_1 = __webpack_require__(98963);
/**
 * @feature Other -> Aligned Grids
 * @gridOption alignedGrids
 */
exports.AlignedGridsModule = {
    moduleName: 'AlignedGrids',
    version: version_1.VERSION,
    beans: [alignedGridsService_1.AlignedGridsService],
    dependsOn: [columnModule_1.ColumnApiModule],
};


/***/ }),

/***/ 98963:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AlignedGridsService = void 0;
const columnStateUtils_1 = __webpack_require__(2885);
const beanStub_1 = __webpack_require__(68731);
const logging_1 = __webpack_require__(47764);
class AlignedGridsService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'alignedGridsSvc';
        // flag to mark if we are consuming. to avoid cyclic events (ie other grid firing back to master
        // while processing a master event) we mark this if consuming an event, and if we are, then
        // we don't fire back any events.
        this.consuming = false;
    }
    getAlignedGridApis() {
        let alignedGrids = this.gos.get('alignedGrids') ?? [];
        const isCallbackConfig = typeof alignedGrids === 'function';
        if (typeof alignedGrids === 'function') {
            alignedGrids = alignedGrids();
        }
        const apis = alignedGrids
            .map((alignedGrid) => {
            if (!alignedGrid) {
                (0, logging_1._error)(18);
                if (!isCallbackConfig) {
                    (0, logging_1._error)(20);
                }
                return;
            }
            if (this.isGridApi(alignedGrid)) {
                return alignedGrid;
            }
            // Extract the GridApi from a ref or component
            const refOrComp = alignedGrid;
            if ('current' in refOrComp) {
                return refOrComp.current?.api;
            }
            if (!refOrComp.api) {
                (0, logging_1._error)(19);
            }
            return refOrComp.api;
        })
            .filter((api) => !!api && !api.isDestroyed());
        return apis;
    }
    isGridApi(ref) {
        return !!ref && !!ref.dispatchEvent;
    }
    postConstruct() {
        const fireColumnEvent = this.fireColumnEvent.bind(this);
        this.addManagedEventListeners({
            columnMoved: fireColumnEvent,
            columnVisible: fireColumnEvent,
            columnPinned: fireColumnEvent,
            columnGroupOpened: fireColumnEvent,
            columnResized: fireColumnEvent,
            bodyScroll: this.fireScrollEvent.bind(this),
            alignedGridColumn: ({ event }) => this.onColumnEvent(event),
            alignedGridScroll: ({ event }) => this.onScrollEvent(event),
        });
    }
    // common logic across all the fire methods
    fireEvent(event) {
        // if we are already consuming, then we are acting on an event from a master,
        // so we don't cause a cyclic firing of events
        if (this.consuming) {
            return;
        }
        this.getAlignedGridApis().forEach((api) => {
            if (api.isDestroyed()) {
                return;
            }
            api.dispatchEvent(event);
        });
    }
    // common logic across all consume methods. very little common logic, however extracting
    // guarantees consistency across the methods.
    onEvent(callback) {
        this.consuming = true;
        callback();
        this.consuming = false;
    }
    fireColumnEvent(columnEvent) {
        this.fireEvent({
            type: 'alignedGridColumn',
            event: columnEvent,
        });
    }
    fireScrollEvent(scrollEvent) {
        if (scrollEvent.direction !== 'horizontal') {
            return;
        }
        this.fireEvent({
            type: 'alignedGridScroll',
            event: scrollEvent,
        });
    }
    onScrollEvent(event) {
        this.onEvent(() => {
            this.beans.ctrlsSvc.getScrollFeature().setHorizontalScrollPosition(event.left, true);
        });
    }
    extractDataFromEvent(event, func) {
        const result = [];
        if (event.columns) {
            event.columns.forEach((column) => {
                result.push(func(column));
            });
        }
        else if (event.column) {
            result.push(func(event.column));
        }
        return result;
    }
    getMasterColumns(event) {
        return this.extractDataFromEvent(event, (col) => col);
    }
    getColumnIds(event) {
        return this.extractDataFromEvent(event, (col) => col.getColId());
    }
    onColumnEvent(event) {
        this.onEvent(() => {
            switch (event.type) {
                case 'columnMoved':
                case 'columnVisible':
                case 'columnPinned':
                case 'columnResized': {
                    this.processColumnEvent(event);
                    break;
                }
                case 'columnGroupOpened': {
                    this.processGroupOpenedEvent(event);
                    break;
                }
                case 'columnPivotChanged':
                    // we cannot support pivoting with aligned grids as the columns will be out of sync as the
                    // grids will have columns created based on the row data of the grid.
                    (0, logging_1._warn)(21);
                    break;
            }
        });
    }
    processGroupOpenedEvent(groupOpenedEvent) {
        const { colGroupSvc } = this.beans;
        if (!colGroupSvc) {
            return;
        }
        groupOpenedEvent.columnGroups.forEach((masterGroup) => {
            // likewise for column group
            let otherColumnGroup = null;
            if (masterGroup) {
                otherColumnGroup = colGroupSvc.getProvidedColGroup(masterGroup.getGroupId());
            }
            if (masterGroup && !otherColumnGroup) {
                return;
            }
            colGroupSvc.setColumnGroupOpened(otherColumnGroup, masterGroup.isExpanded(), 'alignedGridChanged');
        });
    }
    processColumnEvent(colEvent) {
        // the column in the event is from the master grid. need to
        // look up the equivalent from this (other) grid
        const masterColumn = colEvent.column;
        let otherColumn = null;
        const beans = this.beans;
        const { colResize, ctrlsSvc, colModel } = beans;
        if (masterColumn) {
            otherColumn = colModel.getColDefCol(masterColumn.getColId());
        }
        // if event was with respect to a master column, that is not present in this
        // grid, then we ignore the event
        if (masterColumn && !otherColumn) {
            return;
        }
        // in time, all the methods below should use the column ids, it's a more generic way
        // of handling columns, and also allows for single or multi column events
        const masterColumns = this.getMasterColumns(colEvent);
        switch (colEvent.type) {
            case 'columnMoved':
                // when the user moves columns via applyColumnState, we can't depend on moving specific columns
                // to an index, as there maybe be many indexes columns moved to (as wasn't result of a mouse drag).
                // so only way to be sure is match the order of all columns using Column State.
                {
                    const srcColState = colEvent.api.getColumnState();
                    const destColState = srcColState.map((s) => ({ colId: s.colId }));
                    (0, columnStateUtils_1._applyColumnState)(beans, { state: destColState, applyOrder: true }, 'alignedGridChanged');
                }
                break;
            case 'columnVisible':
                // when the user changes visibility via applyColumnState, we can't depend on visibility flag in event
                // as there maybe be mix of true/false (as wasn't result of a mouse click to set visiblity).
                // so only way to be sure is match the visibility of all columns using Column State.
                {
                    const srcColState = colEvent.api.getColumnState();
                    const destColState = srcColState.map((s) => ({ colId: s.colId, hide: s.hide }));
                    (0, columnStateUtils_1._applyColumnState)(beans, { state: destColState }, 'alignedGridChanged');
                }
                break;
            case 'columnPinned':
                {
                    const srcColState = colEvent.api.getColumnState();
                    const destColState = srcColState.map((s) => ({ colId: s.colId, pinned: s.pinned }));
                    (0, columnStateUtils_1._applyColumnState)(beans, { state: destColState }, 'alignedGridChanged');
                }
                break;
            case 'columnResized': {
                const resizedEvent = colEvent;
                const columnWidths = {};
                masterColumns.forEach((column) => {
                    columnWidths[column.getId()] = { key: column.getColId(), newWidth: column.getActualWidth() };
                });
                // don't set flex columns width
                resizedEvent.flexColumns?.forEach((col) => {
                    if (columnWidths[col.getId()]) {
                        delete columnWidths[col.getId()];
                    }
                });
                colResize?.setColumnWidths(Object.values(columnWidths), false, resizedEvent.finished, 'alignedGridChanged');
                break;
            }
        }
        const gridBodyCon = ctrlsSvc.getGridBodyCtrl();
        const isVerticalScrollShowing = gridBodyCon.isVerticalScrollShowing();
        this.getAlignedGridApis().forEach((api) => {
            api.setGridOption('alwaysShowVerticalScroll', isVerticalScrollShowing);
        });
    }
}
exports.AlignedGridsService = AlignedGridsService;


/***/ }),

/***/ 51621:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AllCommunityModule = void 0;
const alignedGridsModule_1 = __webpack_require__(22074);
const apiModule_1 = __webpack_require__(59642);
const clientSideRowModelModule_1 = __webpack_require__(89722);
const clientSideRowModelModule_2 = __webpack_require__(89722);
const columnAutosizeModule_1 = __webpack_require__(63856);
const columnHoverModule_1 = __webpack_require__(41690);
const columnModule_1 = __webpack_require__(52027);
const csvExportModule_1 = __webpack_require__(59734);
const dragModule_1 = __webpack_require__(24388);
const editModule_1 = __webpack_require__(84652);
const filterModule_1 = __webpack_require__(45432);
const infiniteRowModelModule_1 = __webpack_require__(44002);
const apiEventModule_1 = __webpack_require__(99410);
const localeModule_1 = __webpack_require__(89519);
const stateModule_1 = __webpack_require__(6989);
const paginationModule_1 = __webpack_require__(71824);
const pinnedRowModule_1 = __webpack_require__(15423);
const highlightChangesModule_1 = __webpack_require__(83498);
const renderModule_1 = __webpack_require__(66964);
const rowAutoHeightModule_1 = __webpack_require__(4577);
const cellSpanModule_1 = __webpack_require__(4265);
const rowSelectionModule_1 = __webpack_require__(43352);
const stylingModule_1 = __webpack_require__(68594);
const tooltipModule_1 = __webpack_require__(34658);
const validationModule_1 = __webpack_require__(15010);
const valueModule_1 = __webpack_require__(76431);
const version_1 = __webpack_require__(97205);
/**
 * @feature All Community Features
 */
exports.AllCommunityModule = {
    moduleName: 'AllCommunity',
    version: version_1.VERSION,
    dependsOn: [
        clientSideRowModelModule_1.ClientSideRowModelModule,
        csvExportModule_1.CsvExportModule,
        infiniteRowModelModule_1.InfiniteRowModelModule,
        validationModule_1.ValidationModule,
        editModule_1.TextEditorModule,
        editModule_1.NumberEditorModule,
        editModule_1.DateEditorModule,
        editModule_1.CheckboxEditorModule,
        editModule_1.SelectEditorModule,
        editModule_1.LargeTextEditorModule,
        editModule_1.CustomEditorModule,
        editModule_1.UndoRedoEditModule,
        filterModule_1.TextFilterModule,
        filterModule_1.NumberFilterModule,
        filterModule_1.DateFilterModule,
        filterModule_1.CustomFilterModule,
        filterModule_1.QuickFilterModule,
        filterModule_1.ExternalFilterModule,
        stateModule_1.GridStateModule,
        alignedGridsModule_1.AlignedGridsModule,
        paginationModule_1.PaginationModule,
        columnModule_1.ColumnApiModule,
        apiModule_1.RowApiModule,
        apiModule_1.ScrollApiModule,
        renderModule_1.RenderApiModule,
        columnAutosizeModule_1.ColumnAutoSizeModule,
        dragModule_1.RowDragModule,
        pinnedRowModule_1.PinnedRowModule,
        rowSelectionModule_1.RowSelectionModule,
        valueModule_1.ValueCacheModule,
        stylingModule_1.CellStyleModule,
        columnHoverModule_1.ColumnHoverModule,
        stylingModule_1.RowStyleModule,
        apiEventModule_1.EventApiModule,
        valueModule_1.CellApiModule,
        highlightChangesModule_1.HighlightChangesModule,
        tooltipModule_1.TooltipModule,
        localeModule_1.LocaleModule,
        rowAutoHeightModule_1.RowAutoHeightModule,
        dragModule_1.DragAndDropModule,
        clientSideRowModelModule_2.ClientSideRowModelApiModule,
        cellSpanModule_1.CellSpanModule,
    ],
};


/***/ }),

/***/ 33907:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ApiFunctionService = void 0;
const beanStub_1 = __webpack_require__(68731);
const logging_1 = __webpack_require__(47764);
const gridApiFunctions_1 = __webpack_require__(87689);
const defaultFns = {
    isDestroyed: () => true,
    destroy() { },
    preConstruct() { },
    postConstruct() { },
    preWireBeans() { },
    wireBeans() { },
};
const dispatchEvent = (beans, event) => beans.eventSvc.dispatchEvent(event);
// We use a class for AGGridApi so in stack traces calling grid.api.xxx() if an error is thrown it will print "GridApi.xxx"
class GridApiClass {
}
Reflect.defineProperty(GridApiClass, 'name', { value: 'GridApi' });
class ApiFunctionService extends beanStub_1.BeanStub {
    constructor() {
        super();
        this.beanName = 'apiFunctionSvc';
        this.api = new GridApiClass();
        this.fns = {
            ...defaultFns,
            // dispatchEvent is used by frameworks, also used by aligned grids to identify a grid api instance
            dispatchEvent,
        };
        this.preDestroyLink = '';
        const { api } = this;
        for (const key of Object.keys(gridApiFunctions_1.gridApiFunctionsMap)) {
            api[key] = this.makeApi(key)[key];
        }
    }
    postConstruct() {
        this.preDestroyLink = this.beans.frameworkOverrides.getDocLink('grid-lifecycle/#grid-pre-destroyed');
    }
    addFunction(functionName, func) {
        const { fns, beans } = this;
        if (fns !== defaultFns) {
            fns[functionName] = beans?.validation?.validateApiFunction(functionName, func) ?? func;
        }
    }
    makeApi(apiName) {
        // We return an object here to be sure the function name is properly applied,
        // in this way error stack trace are correct and gridApi.xxx.name === 'xxx'
        // This is generally faster than using Object.defineProperty(gridApi, apiName, { value: apiName, configurable: true });
        // Keep this function as light and simple as possible.
        return {
            [apiName]: (...args) => {
                const { beans, fns: { [apiName]: fn }, } = this;
                return fn ? fn(beans, ...args) : this.apiNotFound(apiName);
            },
        };
    }
    apiNotFound(fnName) {
        const { beans, gos, preDestroyLink } = this;
        if (!beans) {
            (0, logging_1._warn)(26, { fnName, preDestroyLink });
        }
        else {
            const module = gridApiFunctions_1.gridApiFunctionsMap[fnName];
            if (gos.assertModuleRegistered(module, `api.${fnName}`)) {
                (0, logging_1._warn)(27, { fnName, module });
            }
        }
    }
    destroy() {
        super.destroy();
        this.fns = defaultFns;
        this.beans = null;
    }
}
exports.ApiFunctionService = ApiFunctionService;


/***/ }),

/***/ 59642:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScrollApiModule = exports.RowApiModule = void 0;
const version_1 = __webpack_require__(97205);
const rowApi_1 = __webpack_require__(18192);
const scrollApi_1 = __webpack_require__(11765);
/**
 * @feature Rows
 */
exports.RowApiModule = {
    moduleName: 'RowApi',
    version: version_1.VERSION,
    apiFunctions: {
        redrawRows: rowApi_1.redrawRows,
        setRowNodeExpanded: rowApi_1.setRowNodeExpanded,
        getRowNode: rowApi_1.getRowNode,
        addRenderedRowListener: rowApi_1.addRenderedRowListener,
        getRenderedNodes: rowApi_1.getRenderedNodes,
        forEachNode: rowApi_1.forEachNode,
        getFirstDisplayedRowIndex: rowApi_1.getFirstDisplayedRowIndex,
        getLastDisplayedRowIndex: rowApi_1.getLastDisplayedRowIndex,
        getDisplayedRowAtIndex: rowApi_1.getDisplayedRowAtIndex,
        getDisplayedRowCount: rowApi_1.getDisplayedRowCount,
    },
};
/**
 * @feature Scrolling
 */
exports.ScrollApiModule = {
    moduleName: 'ScrollApi',
    version: version_1.VERSION,
    apiFunctions: {
        getVerticalPixelRange: scrollApi_1.getVerticalPixelRange,
        getHorizontalPixelRange: scrollApi_1.getHorizontalPixelRange,
        ensureColumnVisible: scrollApi_1.ensureColumnVisible,
        ensureIndexVisible: scrollApi_1.ensureIndexVisible,
        ensureNodeVisible: scrollApi_1.ensureNodeVisible,
    },
};


/***/ }),

/***/ 46433:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createGridApi = void 0;
function createGridApi(context) {
    return {
        beanName: 'gridApi',
        bean: context.getBean('apiFunctionSvc').api,
    };
}
exports.createGridApi = createGridApi;


/***/ }),

/***/ 69875:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isModuleRegistered = exports.updateGridOptions = exports.setGridOption = exports.getGridOption = exports.isDestroyed = exports.destroy = exports.getGridId = void 0;
function getGridId(beans) {
    return beans.context.getId();
}
exports.getGridId = getGridId;
function destroy(beans) {
    beans.gridDestroySvc.destroy();
}
exports.destroy = destroy;
function isDestroyed(beans) {
    return beans.gridDestroySvc.destroyCalled;
}
exports.isDestroyed = isDestroyed;
function getGridOption(beans, key) {
    return beans.gos.get(key);
}
exports.getGridOption = getGridOption;
function setGridOption(beans, key, value) {
    updateGridOptions(beans, { [key]: value });
}
exports.setGridOption = setGridOption;
function updateGridOptions(beans, options) {
    // NOTE: The TDataUpdate generic is used to ensure that the update options match the generic passed into the GridApi above as TData.
    // This is required because if we just use TData directly then Typescript will get into an infinite loop due to callbacks which recursively include the GridApi.
    beans.gos.updateGridOptions({ options });
}
exports.updateGridOptions = updateGridOptions;
function isModuleRegistered(beans, moduleName) {
    const withoutSuffix = moduleName.replace(/Module$/, '');
    return beans.gos.isModuleRegistered(withoutSuffix);
}
exports.isModuleRegistered = isModuleRegistered;


/***/ }),

/***/ 87689:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.gridApiFunctionsMap = void 0;
const mod = (moduleName, input) => {
    for (const key of Object.keys(input)) {
        input[key] = moduleName;
    }
    return input;
};
exports.gridApiFunctionsMap = {
    dispatchEvent: 'CommunityCore',
    ...mod('CommunityCore', {
        destroy: 0,
        getGridId: 0,
        getGridOption: 0,
        isDestroyed: 0,
        setGridOption: 0,
        updateGridOptions: 0,
        isModuleRegistered: 0,
    }),
    ...mod('GridState', {
        getState: 0,
        setState: 0,
    }),
    ...mod('SharedRowSelection', {
        setNodesSelected: 0,
        selectAll: 0,
        deselectAll: 0,
        selectAllFiltered: 0,
        deselectAllFiltered: 0,
        selectAllOnCurrentPage: 0,
        deselectAllOnCurrentPage: 0,
        getSelectedNodes: 0,
        getSelectedRows: 0,
    }),
    ...mod('RowApi', {
        redrawRows: 0,
        setRowNodeExpanded: 0,
        getRowNode: 0,
        addRenderedRowListener: 0,
        getRenderedNodes: 0,
        forEachNode: 0,
        getFirstDisplayedRowIndex: 0,
        getLastDisplayedRowIndex: 0,
        getDisplayedRowAtIndex: 0,
        getDisplayedRowCount: 0,
    }),
    ...mod('ScrollApi', {
        getVerticalPixelRange: 0,
        getHorizontalPixelRange: 0,
        ensureColumnVisible: 0,
        ensureIndexVisible: 0,
        ensureNodeVisible: 0,
    }),
    ...mod('KeyboardNavigation', {
        getFocusedCell: 0,
        clearFocusedCell: 0,
        setFocusedCell: 0,
        tabToNextCell: 0,
        tabToPreviousCell: 0,
        setFocusedHeader: 0,
    }),
    ...mod('EventApi', {
        addEventListener: 0,
        addGlobalListener: 0,
        removeEventListener: 0,
        removeGlobalListener: 0,
    }),
    ...mod('ValueCache', {
        expireValueCache: 0,
    }),
    ...mod('CellApi', {
        getCellValue: 0,
    }),
    ...mod('SharedMenu', {
        showColumnMenu: 0,
        hidePopupMenu: 0,
    }),
    ...mod('Sort', {
        onSortChanged: 0,
    }),
    ...mod('PinnedRow', {
        getPinnedTopRowCount: 0,
        getPinnedBottomRowCount: 0,
        getPinnedTopRow: 0,
        getPinnedBottomRow: 0,
        forEachPinnedRow: 0,
    }),
    ...mod('Overlay', {
        showLoadingOverlay: 0,
        showNoRowsOverlay: 0,
        hideOverlay: 0,
    }),
    ...mod('RenderApi', {
        setGridAriaProperty: 0,
        refreshCells: 0,
        refreshHeader: 0,
        isAnimationFrameQueueEmpty: 0,
        flushAllAnimationFrames: 0,
        getSizesForCurrentTheme: 0,
        getCellRendererInstances: 0,
    }),
    ...mod('HighlightChanges', {
        flashCells: 0,
    }),
    ...mod('RowDrag', {
        addRowDropZone: 0,
        removeRowDropZone: 0,
        getRowDropZoneParams: 0,
        getRowDropPositionIndicator: 0,
        setRowDropPositionIndicator: 0,
    }),
    ...mod('ColumnApi', {
        getColumnDefs: 0,
        getColumnDef: 0,
        getDisplayNameForColumn: 0,
        getColumn: 0,
        getColumns: 0,
        applyColumnState: 0,
        getColumnState: 0,
        resetColumnState: 0,
        isPinning: 0,
        isPinningLeft: 0,
        isPinningRight: 0,
        getDisplayedColAfter: 0,
        getDisplayedColBefore: 0,
        setColumnsVisible: 0,
        setColumnsPinned: 0,
        getAllGridColumns: 0,
        getDisplayedLeftColumns: 0,
        getDisplayedCenterColumns: 0,
        getDisplayedRightColumns: 0,
        getAllDisplayedColumns: 0,
        getAllDisplayedVirtualColumns: 0,
    }),
    ...mod('ColumnAutoSize', {
        sizeColumnsToFit: 0,
        autoSizeColumns: 0,
        autoSizeAllColumns: 0,
    }),
    ...mod('ColumnGroup', {
        setColumnGroupOpened: 0,
        getColumnGroup: 0,
        getProvidedColumnGroup: 0,
        getDisplayNameForColumnGroup: 0,
        getColumnGroupState: 0,
        setColumnGroupState: 0,
        resetColumnGroupState: 0,
        getLeftDisplayedColumnGroups: 0,
        getCenterDisplayedColumnGroups: 0,
        getRightDisplayedColumnGroups: 0,
        getAllDisplayedColumnGroups: 0,
    }),
    ...mod('ColumnMove', {
        moveColumnByIndex: 0,
        moveColumns: 0,
    }),
    ...mod('ColumnResize', {
        setColumnWidths: 0,
    }),
    ...mod('ColumnHover', {
        isColumnHovered: 0,
    }),
    ...mod('EditCore', {
        getCellEditorInstances: 0,
        getEditingCells: 0,
        getEditRowValues: 0,
        stopEditing: 0,
        startEditingCell: 0,
        isEditing: 0,
        validateEdit: 0,
    }),
    ...mod('BatchEdit', {
        startBatchEdit: 0,
        cancelBatchEdit: 0,
        commitBatchEdit: 0,
        isBatchEditing: 0,
    }),
    ...mod('UndoRedoEdit', {
        undoCellEditing: 0,
        redoCellEditing: 0,
        getCurrentUndoSize: 0,
        getCurrentRedoSize: 0,
    }),
    ...mod('FilterCore', {
        isAnyFilterPresent: 0,
        onFilterChanged: 0,
    }),
    ...mod('ColumnFilter', {
        isColumnFilterPresent: 0,
        getColumnFilterInstance: 0,
        destroyFilter: 0,
        setFilterModel: 0,
        getFilterModel: 0,
        getColumnFilterModel: 0,
        setColumnFilterModel: 0,
        showColumnFilter: 0,
        hideColumnFilter: 0,
        getColumnFilterHandler: 0,
        doFilterAction: 0,
    }),
    ...mod('QuickFilter', {
        isQuickFilterPresent: 0,
        getQuickFilter: 0,
        resetQuickFilter: 0,
    }),
    ...mod('Find', {
        findGetActiveMatch: 0,
        findGetTotalMatches: 0,
        findGoTo: 0,
        findNext: 0,
        findPrevious: 0,
        findGetNumMatches: 0,
        findGetParts: 0,
        findClearActive: 0,
        findRefresh: 0,
    }),
    ...mod('Pagination', {
        paginationIsLastPageFound: 0,
        paginationGetPageSize: 0,
        paginationGetCurrentPage: 0,
        paginationGetTotalPages: 0,
        paginationGetRowCount: 0,
        paginationGoToNextPage: 0,
        paginationGoToPreviousPage: 0,
        paginationGoToFirstPage: 0,
        paginationGoToLastPage: 0,
        paginationGoToPage: 0,
    }),
    ...mod('CsrmSsrmSharedApi', {
        expandAll: 0,
        collapseAll: 0,
    }),
    ...mod('SsrmInfiniteSharedApi', {
        setRowCount: 0,
        getCacheBlockState: 0,
        isLastRowIndexKnown: 0,
    }),
    ...mod('ClientSideRowModelApi', {
        onGroupExpandedOrCollapsed: 0,
        refreshClientSideRowModel: 0,
        isRowDataEmpty: 0,
        forEachLeafNode: 0,
        forEachNodeAfterFilter: 0,
        forEachNodeAfterFilterAndSort: 0,
        applyTransaction: 0,
        applyTransactionAsync: 0,
        flushAsyncTransactions: 0,
        getBestCostNodeSelection: 0,
        onRowHeightChanged: 0,
        resetRowHeights: 0,
    }),
    ...mod('CsvExport', {
        getDataAsCsv: 0,
        exportDataAsCsv: 0,
    }),
    ...mod('InfiniteRowModel', {
        refreshInfiniteCache: 0,
        purgeInfiniteCache: 0,
        getInfiniteRowCount: 0,
    }),
    ...mod('AdvancedFilter', {
        getAdvancedFilterModel: 0,
        setAdvancedFilterModel: 0,
        showAdvancedFilterBuilder: 0,
        hideAdvancedFilterBuilder: 0,
    }),
    ...mod('IntegratedCharts', {
        getChartModels: 0,
        getChartRef: 0,
        getChartImageDataURL: 0,
        downloadChart: 0,
        openChartToolPanel: 0,
        closeChartToolPanel: 0,
        createRangeChart: 0,
        createPivotChart: 0,
        createCrossFilterChart: 0,
        updateChart: 0,
        restoreChart: 0,
    }),
    ...mod('Clipboard', {
        copyToClipboard: 0,
        cutToClipboard: 0,
        copySelectedRowsToClipboard: 0,
        copySelectedRangeToClipboard: 0,
        copySelectedRangeDown: 0,
        pasteFromClipboard: 0,
    }),
    ...mod('ExcelExport', {
        getDataAsExcel: 0,
        exportDataAsExcel: 0,
        getSheetDataForExcel: 0,
        getMultipleSheetsAsExcel: 0,
        exportMultipleSheetsAsExcel: 0,
    }),
    ...mod('SharedMasterDetail', {
        addDetailGridInfo: 0,
        removeDetailGridInfo: 0,
        getDetailGridInfo: 0,
        forEachDetailGridInfo: 0,
    }),
    ...mod('ContextMenu', {
        showContextMenu: 0,
    }),
    ...mod('ColumnMenu', {
        showColumnChooser: 0,
        hideColumnChooser: 0,
    }),
    ...mod('CellSelection', {
        getCellRanges: 0,
        addCellRange: 0,
        clearRangeSelection: 0,
        clearCellSelection: 0,
    }),
    ...mod('SharedRowGrouping', {
        setRowGroupColumns: 0,
        removeRowGroupColumns: 0,
        addRowGroupColumns: 0,
        getRowGroupColumns: 0,
        moveRowGroupColumn: 0,
    }),
    ...mod('SharedAggregation', {
        addAggFuncs: 0,
        clearAggFuncs: 0,
        setColumnAggFunc: 0,
    }),
    ...mod('SharedPivot', {
        isPivotMode: 0,
        getPivotResultColumn: 0,
        setValueColumns: 0,
        getValueColumns: 0,
        removeValueColumns: 0,
        addValueColumns: 0,
        setPivotColumns: 0,
        removePivotColumns: 0,
        addPivotColumns: 0,
        getPivotColumns: 0,
        setPivotResultColumns: 0,
        getPivotResultColumns: 0,
    }),
    ...mod('ServerSideRowModelApi', {
        getServerSideSelectionState: 0,
        setServerSideSelectionState: 0,
        applyServerSideTransaction: 0,
        applyServerSideTransactionAsync: 0,
        applyServerSideRowData: 0,
        retryServerSideLoads: 0,
        flushServerSideAsyncTransactions: 0,
        refreshServerSide: 0,
        getServerSideGroupLevelState: 0,
        onRowHeightChanged: 0,
        resetRowHeights: 0,
    }),
    ...mod('SideBar', {
        isSideBarVisible: 0,
        setSideBarVisible: 0,
        setSideBarPosition: 0,
        openToolPanel: 0,
        closeToolPanel: 0,
        getOpenedToolPanel: 0,
        refreshToolPanel: 0,
        isToolPanelShowing: 0,
        getToolPanelInstance: 0,
        getSideBar: 0,
    }),
    ...mod('StatusBar', {
        getStatusPanel: 0,
    }),
};


/***/ }),

/***/ 18192:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getDisplayedRowCount = exports.getDisplayedRowAtIndex = exports.getLastDisplayedRowIndex = exports.getFirstDisplayedRowIndex = exports.forEachNode = exports.getRenderedNodes = exports.addRenderedRowListener = exports.getRowNode = exports.setRowNodeExpanded = exports.redrawRows = void 0;
function redrawRows(beans, params = {}) {
    const rowNodes = params ? params.rowNodes : undefined;
    beans.frameworkOverrides.wrapIncoming(() => beans.rowRenderer.redrawRows(rowNodes));
}
exports.redrawRows = redrawRows;
function setRowNodeExpanded(beans, rowNode, expanded, expandParents, forceSync) {
    if (rowNode) {
        // expand all parents recursively, except root node.
        if (expandParents && rowNode.parent && rowNode.parent.level !== -1) {
            setRowNodeExpanded(beans, rowNode.parent, expanded, expandParents, forceSync);
        }
        rowNode.setExpanded(expanded, undefined, forceSync);
    }
}
exports.setRowNodeExpanded = setRowNodeExpanded;
function getRowNode(beans, id) {
    return beans.rowModel.getRowNode(id);
}
exports.getRowNode = getRowNode;
function addRenderedRowListener(beans, eventName, rowIndex, callback) {
    beans.rowRenderer.addRenderedRowListener(eventName, rowIndex, callback);
}
exports.addRenderedRowListener = addRenderedRowListener;
function getRenderedNodes(beans) {
    return beans.rowRenderer.getRenderedNodes();
}
exports.getRenderedNodes = getRenderedNodes;
function forEachNode(beans, callback, includeFooterNodes) {
    beans.rowModel.forEachNode(callback, includeFooterNodes);
}
exports.forEachNode = forEachNode;
function getFirstDisplayedRowIndex(beans) {
    return beans.rowRenderer.firstRenderedRow;
}
exports.getFirstDisplayedRowIndex = getFirstDisplayedRowIndex;
function getLastDisplayedRowIndex(beans) {
    return beans.rowRenderer.lastRenderedRow;
}
exports.getLastDisplayedRowIndex = getLastDisplayedRowIndex;
function getDisplayedRowAtIndex(beans, index) {
    return beans.rowModel.getRow(index);
}
exports.getDisplayedRowAtIndex = getDisplayedRowAtIndex;
function getDisplayedRowCount(beans) {
    return beans.rowModel.getRowCount();
}
exports.getDisplayedRowCount = getDisplayedRowCount;


/***/ }),

/***/ 66876:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getViewportRowModel = exports._getServerSideRowModel = exports._getInfiniteRowModel = exports._getClientSideRowModel = void 0;
function _getClientSideRowModel(beans) {
    const rowModel = beans.rowModel;
    return rowModel.getType() === 'clientSide' ? rowModel : undefined;
}
exports._getClientSideRowModel = _getClientSideRowModel;
function _getInfiniteRowModel(beans) {
    const rowModel = beans.rowModel;
    return rowModel.getType() === 'infinite' ? rowModel : undefined;
}
exports._getInfiniteRowModel = _getInfiniteRowModel;
function _getServerSideRowModel(beans) {
    const rowModel = beans.rowModel;
    return rowModel.getType() === 'serverSide' ? rowModel : undefined;
}
exports._getServerSideRowModel = _getServerSideRowModel;
function _getViewportRowModel(beans) {
    const rowModel = beans.rowModel;
    return rowModel.getType() === 'viewport' ? rowModel : undefined;
}
exports._getViewportRowModel = _getViewportRowModel;


/***/ }),

/***/ 74510:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.resetRowHeights = exports.onRowHeightChanged = exports.collapseAll = exports.expandAll = void 0;
const logging_1 = __webpack_require__(47764);
function expandAll(beans) {
    beans.expansionSvc?.expandAll(true);
}
exports.expandAll = expandAll;
function collapseAll(beans) {
    beans.expansionSvc?.expandAll(false);
}
exports.collapseAll = collapseAll;
function onRowHeightChanged(beans) {
    beans.rowModel?.onRowHeightChanged();
}
exports.onRowHeightChanged = onRowHeightChanged;
function resetRowHeights(beans) {
    if (beans.rowAutoHeight?.active) {
        (0, logging_1._warn)(3);
        return;
    }
    beans.rowModel?.resetRowHeights();
}
exports.resetRowHeights = resetRowHeights;


/***/ }),

/***/ 11765:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ensureNodeVisible = exports.ensureIndexVisible = exports.ensureColumnVisible = exports.getHorizontalPixelRange = exports.getVerticalPixelRange = void 0;
function getVerticalPixelRange(beans) {
    return beans.ctrlsSvc.getScrollFeature().getVScrollPosition();
}
exports.getVerticalPixelRange = getVerticalPixelRange;
function getHorizontalPixelRange(beans) {
    return beans.ctrlsSvc.getScrollFeature().getHScrollPosition();
}
exports.getHorizontalPixelRange = getHorizontalPixelRange;
function ensureColumnVisible(beans, key, position = 'auto') {
    beans.frameworkOverrides.wrapIncoming(() => beans.ctrlsSvc.getScrollFeature().ensureColumnVisible(key, position), 'ensureVisible');
}
exports.ensureColumnVisible = ensureColumnVisible;
function ensureIndexVisible(beans, index, position) {
    beans.frameworkOverrides.wrapIncoming(() => beans.ctrlsSvc.getScrollFeature().ensureIndexVisible(index, position), 'ensureVisible');
}
exports.ensureIndexVisible = ensureIndexVisible;
function ensureNodeVisible(beans, nodeSelector, position = null) {
    beans.frameworkOverrides.wrapIncoming(() => beans.ctrlsSvc.getScrollFeature().ensureNodeVisible(nodeSelector, position), 'ensureVisible');
}
exports.ensureNodeVisible = ensureNodeVisible;


/***/ }),

/***/ 36437:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SsrmInfiniteSharedApiModule = exports.RowModelSharedApiModule = exports.CsrmSsrmSharedApiModule = void 0;
const version_1 = __webpack_require__(97205);
const rowModelSharedApi_1 = __webpack_require__(74510);
const ssrmInfiniteSharedApi_1 = __webpack_require__(68496);
// these modules are not used in core, but are shared between multiple other modules
/**
 * @internal
 */
exports.CsrmSsrmSharedApiModule = {
    moduleName: 'CsrmSsrmSharedApi',
    version: version_1.VERSION,
    apiFunctions: { expandAll: rowModelSharedApi_1.expandAll, collapseAll: rowModelSharedApi_1.collapseAll },
};
/**
 * @internal
 */
exports.RowModelSharedApiModule = {
    moduleName: 'RowModelSharedApi',
    version: version_1.VERSION,
    apiFunctions: { onRowHeightChanged: rowModelSharedApi_1.onRowHeightChanged, resetRowHeights: rowModelSharedApi_1.resetRowHeights },
};
/**
 * @internal
 */
exports.SsrmInfiniteSharedApiModule = {
    moduleName: 'SsrmInfiniteSharedApi',
    version: version_1.VERSION,
    apiFunctions: {
        setRowCount: ssrmInfiniteSharedApi_1.setRowCount,
        getCacheBlockState: ssrmInfiniteSharedApi_1.getCacheBlockState,
        isLastRowIndexKnown: ssrmInfiniteSharedApi_1.isLastRowIndexKnown,
    },
};


/***/ }),

/***/ 68496:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isLastRowIndexKnown = exports.getCacheBlockState = exports.setRowCount = void 0;
const gridOptionsUtils_1 = __webpack_require__(67274);
const logging_1 = __webpack_require__(47764);
const rowModelApiUtils_1 = __webpack_require__(66876);
function setRowCount(beans, rowCount, maxRowFound) {
    const serverSideRowModel = (0, rowModelApiUtils_1._getServerSideRowModel)(beans);
    if (serverSideRowModel) {
        if (beans.rowGroupColsSvc?.columns.length === 0) {
            if (rowCount < 0) {
                (0, logging_1._error)(238);
                return;
            }
            serverSideRowModel.setRowCount(rowCount, maxRowFound);
            return;
        }
        (0, logging_1._error)(28);
        return;
    }
    const infiniteRowModel = (0, rowModelApiUtils_1._getInfiniteRowModel)(beans);
    if (infiniteRowModel) {
        infiniteRowModel.setRowCount(rowCount, maxRowFound);
        return;
    }
}
exports.setRowCount = setRowCount;
function getCacheBlockState(beans) {
    if ((0, gridOptionsUtils_1._isServerSideRowModel)(beans.gos)) {
        const ssrm = beans.rowModel;
        return ssrm.getBlockStates();
    }
    return beans.rowNodeBlockLoader?.getBlockState() ?? {};
}
exports.getCacheBlockState = getCacheBlockState;
function isLastRowIndexKnown(beans) {
    return beans.rowModel.isLastRowIndexKnown();
}
exports.isLastRowIndexKnown = isLastRowIndexKnown;


/***/ }),

/***/ 35628:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoScrollService = void 0;
class AutoScrollService {
    constructor(params) {
        this.tickingInterval = null;
        this.onScrollCallback = null;
        this.scrollContainer = params.scrollContainer;
        this.scrollHorizontally = params.scrollAxis.indexOf('x') !== -1;
        this.scrollVertically = params.scrollAxis.indexOf('y') !== -1;
        this.scrollByTick = params.scrollByTick != null ? params.scrollByTick : 20;
        if (params.onScrollCallback) {
            this.onScrollCallback = params.onScrollCallback;
        }
        if (this.scrollVertically) {
            this.getVerticalPosition = params.getVerticalPosition;
            this.setVerticalPosition = params.setVerticalPosition;
        }
        if (this.scrollHorizontally) {
            this.getHorizontalPosition = params.getHorizontalPosition;
            this.setHorizontalPosition = params.setHorizontalPosition;
        }
        this.shouldSkipVerticalScroll = params.shouldSkipVerticalScroll || (() => false);
        this.shouldSkipHorizontalScroll = params.shouldSkipHorizontalScroll || (() => false);
    }
    check(mouseEvent, forceSkipVerticalScroll = false) {
        const skipVerticalScroll = forceSkipVerticalScroll || this.shouldSkipVerticalScroll();
        if (skipVerticalScroll && this.shouldSkipHorizontalScroll()) {
            return;
        }
        const rect = this.scrollContainer.getBoundingClientRect();
        const scrollTick = this.scrollByTick;
        this.tickLeft = mouseEvent.clientX < rect.left + scrollTick;
        this.tickRight = mouseEvent.clientX > rect.right - scrollTick;
        this.tickUp = mouseEvent.clientY < rect.top + scrollTick && !skipVerticalScroll;
        this.tickDown = mouseEvent.clientY > rect.bottom - scrollTick && !skipVerticalScroll;
        if (this.tickLeft || this.tickRight || this.tickUp || this.tickDown) {
            this.ensureTickingStarted();
        }
        else {
            this.ensureCleared();
        }
    }
    ensureTickingStarted() {
        if (this.tickingInterval === null) {
            this.tickingInterval = window.setInterval(this.doTick.bind(this), 100);
            this.tickCount = 0;
        }
    }
    doTick() {
        this.tickCount++;
        const tickAmount = this.tickCount > 20 ? 200 : this.tickCount > 10 ? 80 : 40;
        if (this.scrollVertically) {
            const vScrollPosition = this.getVerticalPosition();
            if (this.tickUp) {
                this.setVerticalPosition(vScrollPosition - tickAmount);
            }
            if (this.tickDown) {
                this.setVerticalPosition(vScrollPosition + tickAmount);
            }
        }
        if (this.scrollHorizontally) {
            const hScrollPosition = this.getHorizontalPosition();
            if (this.tickLeft) {
                this.setHorizontalPosition(hScrollPosition - tickAmount);
            }
            if (this.tickRight) {
                this.setHorizontalPosition(hScrollPosition + tickAmount);
            }
        }
        if (this.onScrollCallback) {
            this.onScrollCallback();
        }
    }
    ensureCleared() {
        if (this.tickingInterval) {
            window.clearInterval(this.tickingInterval);
            this.tickingInterval = null;
        }
    }
}
exports.AutoScrollService = AutoScrollService;


/***/ }),

/***/ 83263:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BASE_URL = void 0;
// DO NOT UPDATE MANUALLY: Generated from script during build time
exports.BASE_URL = 'https://www.ag-grid.com';


/***/ }),

/***/ 31954:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AbstractClientSideNodeManager = void 0;
const beanStub_1 = __webpack_require__(68731);
const rowNode_1 = __webpack_require__(3373);
const gridOptionsUtils_1 = __webpack_require__(67274);
const logging_1 = __webpack_require__(47764);
const ROOT_NODE_ID = 'ROOT_NODE_ID';
class AbstractClientSideNodeManager extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.nextId = 0;
        this.allNodesMap = {};
        this.rootNode = null;
    }
    getRowNode(id) {
        return this.allNodesMap[id];
    }
    extractRowData() {
        return this.rootNode?.allLeafChildren?.map((node) => node.data);
    }
    activate(rootNode) {
        this.rootNode = rootNode;
        rootNode.group = true;
        rootNode.level = -1;
        rootNode.id = ROOT_NODE_ID;
        rootNode.allLeafChildren = [];
        rootNode.childrenAfterGroup = [];
        rootNode.childrenAfterSort = [];
        rootNode.childrenAfterAggFilter = [];
        rootNode.childrenAfterFilter = [];
        this.updateRootSiblingArrays(rootNode);
    }
    deactivate() {
        if (this.rootNode) {
            this.allNodesMap = {};
            this.rootNode = null;
        }
    }
    destroy() {
        super.destroy();
        // Forcefully deallocate memory
        this.allNodesMap = {};
        this.rootNode = null;
    }
    setNewRowData(rowData) {
        const rootNode = this.rootNode;
        if (!rootNode) {
            return;
        }
        this.dispatchRowDataUpdateStartedEvent(rowData);
        rootNode.childrenAfterFilter = null;
        rootNode.childrenAfterGroup = null;
        rootNode.childrenAfterAggFilter = null;
        rootNode.childrenAfterSort = null;
        rootNode.childrenMapped = null;
        rootNode.updateHasChildren();
        // Clear internal maps
        this.allNodesMap = {};
        this.nextId = 0;
        this.loadNewRowData(rowData);
        this.updateRootSiblingArrays(rootNode);
    }
    updateRootSiblingArrays(rootNode) {
        const sibling = rootNode.sibling;
        if (sibling) {
            sibling.childrenAfterFilter = rootNode.childrenAfterFilter;
            sibling.childrenAfterGroup = rootNode.childrenAfterGroup;
            sibling.childrenAfterAggFilter = rootNode.childrenAfterAggFilter;
            sibling.childrenAfterSort = rootNode.childrenAfterSort;
            sibling.childrenMapped = rootNode.childrenMapped;
            sibling.allLeafChildren = rootNode.allLeafChildren;
        }
    }
    loadNewRowData(rowData) {
        this.rootNode.allLeafChildren = rowData?.map((dataItem, index) => this.createRowNode(dataItem, index)) ?? [];
    }
    setImmutableRowData(params, rowData) {
        const getRowIdFunc = (0, gridOptionsUtils_1._getRowIdCallback)(this.gos);
        const reorder = !this.gos.get('suppressMaintainUnsortedOrder');
        const changedRowNodes = params.changedRowNodes;
        const processedNodes = new Set();
        const rootNode = this.rootNode;
        const oldAllLeafChildren = rootNode.allLeafChildren;
        const oldAllLeafChildrenLen = oldAllLeafChildren.length;
        let nodesAdded = false;
        let nodesRemoved = false;
        let nodesUpdated = false;
        let orderChanged = false;
        for (let i = 0, prevSourceRowIndex = -1, len = rowData.length; i < len; i++) {
            const data = rowData[i];
            let node = this.getRowNode(getRowIdFunc({ data, level: 0 }));
            if (!node) {
                nodesAdded = true;
                node = this.createRowNode(data, -1);
                changedRowNodes.add(node);
            }
            else {
                if (reorder) {
                    const sourceRowIndex = node.sourceRowIndex;
                    orderChanged || (orderChanged = sourceRowIndex <= prevSourceRowIndex || // A node was moved up, so order changed
                        nodesAdded); // A node was inserted not at the end
                    prevSourceRowIndex = sourceRowIndex;
                }
                if (node.data !== data) {
                    nodesUpdated = true;
                    node.updateData(data);
                    changedRowNodes.update(node);
                }
            }
            processedNodes.add(node);
        }
        // Destroy the remaining unprocessed node and collect the removed that were selected.
        const nodesToUnselect = [];
        for (let i = 0; i < oldAllLeafChildrenLen; i++) {
            const node = oldAllLeafChildren[i];
            if (!processedNodes.has(node)) {
                nodesRemoved = true;
                if (node.isSelected()) {
                    nodesToUnselect.push(node);
                }
                if (node.pinnedSibling) {
                    this.beans.pinnedRowModel?.pinRow(node.pinnedSibling, null);
                }
                this.rowNodeDeleted(node);
                changedRowNodes.remove(node);
            }
        }
        if (nodesAdded || nodesRemoved || orderChanged) {
            const newAllLeafChildren = new Array(processedNodes.size); // Preallocate
            let writeIdx = 0;
            if (!reorder) {
                // All the old nodes will be in the new array in the order they were in the old array
                // At the end of this loop, processedNodes will contain only the new appended nodes
                for (let i = 0; i < oldAllLeafChildrenLen; ++i) {
                    const node = oldAllLeafChildren[i];
                    if (processedNodes.delete(node)) {
                        node.sourceRowIndex = writeIdx;
                        newAllLeafChildren[writeIdx++] = node;
                    }
                }
            }
            for (const node of processedNodes) {
                node.sourceRowIndex = writeIdx;
                newAllLeafChildren[writeIdx++] = node;
            }
            rootNode.allLeafChildren = newAllLeafChildren;
            const sibling = rootNode.sibling;
            if (sibling) {
                sibling.allLeafChildren = newAllLeafChildren;
            }
            params.rowNodesOrderChanged || (params.rowNodesOrderChanged = orderChanged);
        }
        if (nodesAdded || nodesRemoved || orderChanged || nodesUpdated) {
            this.deselectNodes(nodesToUnselect);
            params.rowDataUpdated = true;
        }
    }
    /** Called when a node needs to be deleted */
    rowNodeDeleted(node) {
        node.clearRowTopAndRowIndex(); // so row renderer knows to fade row out (and not reposition it)
        const id = node.id;
        const allNodesMap = this.allNodesMap;
        if (allNodesMap[id] === node) {
            delete allNodesMap[id];
        }
    }
    updateRowData(rowDataTran, changedRowNodes) {
        this.dispatchRowDataUpdateStartedEvent(rowDataTran.add);
        const updateRowDataResult = {
            changedRowNodes,
            rowNodeTransaction: { remove: [], update: [], add: [] },
            rowsInserted: false,
        };
        const nodesToUnselect = [];
        const getRowIdFunc = (0, gridOptionsUtils_1._getRowIdCallback)(this.gos);
        this.executeRemove(getRowIdFunc, rowDataTran, updateRowDataResult, nodesToUnselect);
        this.executeUpdate(getRowIdFunc, rowDataTran, updateRowDataResult, nodesToUnselect);
        this.executeAdd(rowDataTran, updateRowDataResult);
        this.deselectNodes(nodesToUnselect);
        return updateRowDataResult;
    }
    executeAdd(rowDataTran, result) {
        const add = rowDataTran.add;
        if (!add?.length) {
            return;
        }
        let allLeafChildren = this.rootNode.allLeafChildren;
        let addIndex = allLeafChildren.length;
        if (typeof rowDataTran.addIndex === 'number') {
            addIndex = this.sanitizeAddIndex(rowDataTran.addIndex);
            if (addIndex > 0) {
                // TODO: this code should not be here, see AG-12602
                // This was a fix for AG-6231, but is not the correct fix
                // We enable it only for trees that use getDataPath and not the new children field
                const getDataPath = this.gos.get('treeData') && this.gos.get('getDataPath');
                if (getDataPath) {
                    for (let i = 0; i < allLeafChildren.length; i++) {
                        const node = allLeafChildren[i];
                        if (node?.rowIndex == addIndex - 1) {
                            addIndex = i + 1;
                            break;
                        }
                    }
                }
            }
        }
        const addLength = add.length;
        const changedRowNodes = result.changedRowNodes;
        // create new row nodes for each data item
        const newNodes = new Array(addLength);
        for (let i = 0; i < addLength; i++) {
            const newNode = this.createRowNode(add[i], addIndex + i);
            changedRowNodes.add(newNode);
            newNodes[i] = newNode;
        }
        const rootNode = this.rootNode;
        if (addIndex < allLeafChildren.length) {
            // Insert at the specified index
            const nodesBeforeIndex = allLeafChildren.slice(0, addIndex);
            const nodesAfterIndex = allLeafChildren.slice(addIndex, allLeafChildren.length);
            // update latter row indexes
            const nodesAfterIndexFirstIndex = nodesBeforeIndex.length + newNodes.length;
            for (let index = 0, length = nodesAfterIndex.length; index < length; ++index) {
                nodesAfterIndex[index].sourceRowIndex = nodesAfterIndexFirstIndex + index;
            }
            allLeafChildren = [...nodesBeforeIndex, ...newNodes, ...nodesAfterIndex];
            // Mark the result as rows inserted
            result.rowsInserted = true;
        }
        else {
            // Just append at the end
            allLeafChildren = allLeafChildren.concat(newNodes);
        }
        rootNode.allLeafChildren = allLeafChildren;
        const sibling = rootNode.sibling;
        if (sibling) {
            sibling.allLeafChildren = allLeafChildren;
        }
        // add new row nodes to the transaction add items
        result.rowNodeTransaction.add = newNodes;
    }
    executeRemove(getRowIdFunc, rowDataTran, { changedRowNodes, rowNodeTransaction }, nodesToUnselect) {
        const { remove } = rowDataTran;
        if (!remove?.length) {
            return;
        }
        const rowIdsRemoved = {};
        remove.forEach((item) => {
            const rowNode = this.lookupRowNode(getRowIdFunc, item);
            if (!rowNode) {
                return;
            }
            if (rowNode.isSelected()) {
                nodesToUnselect.push(rowNode);
            }
            // If a row has been manually pinned, ensure its sibling is also removed
            if (rowNode.pinnedSibling) {
                this.beans.pinnedRowModel?.pinRow(rowNode.pinnedSibling, null);
            }
            // so row renderer knows to fade row out (and not reposition it)
            rowNode.clearRowTopAndRowIndex();
            // NOTE: were we could remove from allLeaveChildren, however removeFromArray() is expensive, especially
            // if called multiple times (eg deleting lots of rows) and if allLeafChildren is a large list
            rowIdsRemoved[rowNode.id] = true;
            // removeFromArray(this.rootNode.allLeafChildren, rowNode);
            delete this.allNodesMap[rowNode.id];
            rowNodeTransaction.remove.push(rowNode);
            changedRowNodes.remove(rowNode);
        });
        const rootNode = this.rootNode;
        rootNode.allLeafChildren = rootNode.allLeafChildren?.filter((rowNode) => !rowIdsRemoved[rowNode.id]) ?? null;
        // after rows have been removed, all following rows need the position index updated
        rootNode.allLeafChildren?.forEach((node, idx) => {
            node.sourceRowIndex = idx;
        });
        const sibling = rootNode.sibling;
        if (sibling) {
            sibling.allLeafChildren = rootNode.allLeafChildren;
        }
    }
    executeUpdate(getRowIdFunc, rowDataTran, { changedRowNodes, rowNodeTransaction }, nodesToUnselect) {
        const { update } = rowDataTran;
        if (!update?.length) {
            return;
        }
        update.forEach((item) => {
            const rowNode = this.lookupRowNode(getRowIdFunc, item);
            if (!rowNode) {
                return;
            }
            rowNode.updateData(item);
            if (!rowNode.selectable && rowNode.isSelected()) {
                nodesToUnselect.push(rowNode);
            }
            rowNodeTransaction.update.push(rowNode);
            changedRowNodes.update(rowNode);
        });
    }
    dispatchRowDataUpdateStartedEvent(rowData) {
        this.eventSvc.dispatchEvent({
            type: 'rowDataUpdateStarted',
            firstRowData: rowData?.length ? rowData[0] : null,
        });
    }
    deselectNodes(nodesToUnselect) {
        const source = 'rowDataChanged';
        const selectionSvc = this.beans.selectionSvc;
        const selectionChanged = nodesToUnselect.length > 0;
        if (selectionChanged) {
            selectionSvc?.setNodesSelected({
                newValue: false,
                nodes: nodesToUnselect,
                suppressFinishActions: true,
                source,
            });
        }
        // we do this regardless of nodes to unselect or not, as it's possible
        // a new node was inserted, so a parent that was previously selected (as all
        // children were selected) should not be tri-state (as new one unselected against
        // all other selected children).
        selectionSvc?.updateGroupsFromChildrenSelections?.(source);
        if (selectionChanged) {
            this.eventSvc.dispatchEvent({
                type: 'selectionChanged',
                source: source,
                selectedNodes: selectionSvc?.getSelectedNodes() ?? null,
                serverSideState: null,
            });
        }
    }
    sanitizeAddIndex(addIndex) {
        const allChildrenCount = this.rootNode.allLeafChildren?.length ?? 0;
        if (addIndex < 0 || addIndex >= allChildrenCount || Number.isNaN(addIndex)) {
            return allChildrenCount; // Append. Also for negative values, as it was historically the behavior.
        }
        // Ensure index is a whole number and not a floating point.
        // Use case: the user want to add a row in the middle, doing addIndex = array.length / 2.
        // If the array has an odd number of elements, the addIndex need to be rounded up.
        // Consider that array.slice does round up internally, but we are setting this value to node.sourceRowIndex.
        return Math.ceil(addIndex);
    }
    createRowNode(data, sourceRowIndex) {
        const node = new rowNode_1.RowNode(this.beans);
        node.parent = this.rootNode;
        node.level = 0;
        node.group = false;
        node.expanded = false;
        node.sourceRowIndex = sourceRowIndex;
        node.setDataAndId(data, String(this.nextId));
        if (this.allNodesMap[node.id]) {
            (0, logging_1._warn)(2, { nodeId: node.id });
        }
        this.allNodesMap[node.id] = node;
        this.nextId++;
        return node;
    }
    lookupRowNode(getRowIdFunc, data) {
        let rowNode;
        if (getRowIdFunc) {
            // find rowNode using id
            const id = getRowIdFunc({ data, level: 0 });
            rowNode = this.allNodesMap[id];
            if (!rowNode) {
                (0, logging_1._error)(4, { id });
                return null;
            }
        }
        else {
            // find rowNode using object references
            rowNode = this.rootNode?.allLeafChildren?.find((node) => node.data === data);
            if (!rowNode) {
                (0, logging_1._error)(5, { data });
                return null;
            }
        }
        return rowNode || null;
    }
}
exports.AbstractClientSideNodeManager = AbstractClientSideNodeManager;


/***/ }),

/***/ 32106:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangedRowNodes = void 0;
class ChangedRowNodes {
    constructor() {
        this.removals = new Set();
        this.updates = new Set();
        this.adds = new Set();
    }
    /** Marks a row as removed. Order of operations is: remove, update, add */
    remove(node) {
        if (!this.adds.delete(node)) {
            this.updates.delete(node);
            this.removals.add(node);
        }
    }
    /** Marks a row as updated. Order of operations is: remove, update, add */
    update(node) {
        if (!this.adds.has(node)) {
            this.updates.add(node);
        }
    }
    /** Marks a row as added. Order of operation is: remove, update, add */
    add(node) {
        this.adds.add(node);
    }
}
exports.ChangedRowNodes = ChangedRowNodes;


/***/ }),

/***/ 28128:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientSideNodeManager = void 0;
const abstractClientSideNodeManager_1 = __webpack_require__(31954);
class ClientSideNodeManager extends abstractClientSideNodeManager_1.AbstractClientSideNodeManager {
    constructor() {
        super(...arguments);
        this.beanName = 'csrmNodeSvc';
    }
}
exports.ClientSideNodeManager = ClientSideNodeManager;


/***/ }),

/***/ 83278:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientSideRowModel = void 0;
const array_1 = __webpack_require__(79909);
const function_1 = __webpack_require__(44990);
const beanStub_1 = __webpack_require__(68731);
const rowNode_1 = __webpack_require__(3373);
const gridOptionsUtils_1 = __webpack_require__(67274);
const changedPath_1 = __webpack_require__(76800);
const logging_1 = __webpack_require__(47764);
const changedRowNodes_1 = __webpack_require__(32106);
const filterStage_1 = __webpack_require__(48287);
const sortStage_1 = __webpack_require__(19849);
class ClientSideRowModel extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'rowModel';
        // top most node of the tree. the children are the user provided data.
        this.rootNode = null;
        this.rowsToDisplay = []; // the rows mapped to rows to display
        /** Keep track if row data was updated. Important with suppressModelUpdateAfterUpdateTransaction and refreshModel api is called  */
        this.rowDataUpdatedPending = false;
        /** Has the start method been called */
        this.started = false;
        /**
         * This is to prevent refresh model being called when it's already being called.
         * E.g. the group stage can trigger initial state filter model to be applied. This fires onFilterChanged,
         * which then triggers the listener here that calls refresh model again but at the filter stage
         * (which is about to be run by the original call).
         */
        this.isRefreshingModel = false;
        this.rowNodesCountReady = false;
        this.rowCountReady = false;
        this.onRowHeightChanged_debounced = (0, function_1._debounce)(this, this.onRowHeightChanged.bind(this), 100);
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.valueCache = beans.valueCache;
        this.filterStage = beans.filterStage;
        this.sortStage = beans.sortStage;
        this.flattenStage = beans.flattenStage;
        this.groupStage = beans.groupStage;
        this.aggStage = beans.aggStage;
        this.pivotStage = beans.pivotStage;
        this.filterAggStage = beans.filterAggStage;
    }
    postConstruct() {
        this.orderedStages = [
            this.groupStage,
            this.filterStage,
            this.pivotStage,
            this.aggStage,
            this.sortStage,
            this.filterAggStage,
            this.flattenStage,
        ].filter((stage) => !!stage);
        const refreshEverythingFunc = this.refreshModel.bind(this, { step: 'group' });
        const refreshEverythingAfterColsChangedFunc = this.refreshModel.bind(this, {
            step: 'group',
            afterColumnsChanged: true,
            keepRenderedRows: true,
            // we want animations cos sorting or filtering could be applied
            animate: !this.gos.get('suppressAnimationFrame'),
        });
        this.addManagedEventListeners({
            newColumnsLoaded: refreshEverythingAfterColsChangedFunc,
            columnRowGroupChanged: refreshEverythingFunc,
            columnValueChanged: this.onValueChanged.bind(this),
            columnPivotChanged: this.refreshModel.bind(this, { step: 'pivot' }),
            filterChanged: this.onFilterChanged.bind(this),
            sortChanged: this.onSortChanged.bind(this),
            columnPivotModeChanged: refreshEverythingFunc,
            gridStylesChanged: this.onGridStylesChanges.bind(this),
            gridReady: this.onGridReady.bind(this),
            rowExpansionStateChanged: this.onRowGroupOpened.bind(this),
        });
        // doesn't need done if doing full reset
        // Property listeners which call `refreshModel` at different stages
        this.addPropertyListeners();
        this.rootNode = new rowNode_1.RowNode(this.beans);
        const nodeManager = this.getNewNodeManager();
        this.nodeManager = nodeManager;
        nodeManager.activate(this.rootNode);
    }
    getNewNodeManager() {
        const { gos, beans } = this;
        return ((0, gridOptionsUtils_1._getGroupingApproach)(gos) === 'treeNested' && beans.csrmChildrenTreeNodeSvc) || beans.csrmNodeSvc;
    }
    addPropertyListeners() {
        // Omitted Properties
        //
        // We do not act reactively on all functional properties, as it's possible the application is React and
        // has not memoised the property and it's getting set every render.
        //
        // ** LIST OF NON REACTIVE, NO ARGUMENT
        //
        // getDataPath, getRowId -- these are called once for each Node when the Node is created.
        //                       -- these are immutable Node properties (ie a Node ID cannot be changed)
        //
        // isRowMaster           -- called when masterDetail is true and the Node is created or the property was changed
        //
        // getRowHeight - this is called once when Node is created, if a new getRowHeight function is provided,
        //              - we do not revisit the heights of each node.
        //
        // pivotDefaultExpanded - relevant for initial pivot column creation, no impact on existing pivot columns.
        //
        // deltaSort - this changes the type of algorithm used only, it doesn't change the sort order. so no point
        //           - in doing the sort again as the same result will be got. the new Prop will be used next time we sort.
        //
        // ** LIST OF NON REACTIVE, SOME ARGUMENT
        // ** For these, they could be reactive, but not convinced the business argument is strong enough,
        // ** so leaving as non-reactive for now, and see if anyone complains.
        //
        // processPivotResultColDef, processPivotResultColGroupDef
        //                       - there is an argument for having these reactive, that if the application changes
        //                       - these props, we should re-create the Pivot Columns, however it's highly unlikely
        //                       - the application would change these functions, far more likely the functions were
        //                       - non memoised correctly.
        const allProps = [
            'treeData',
            'treeDataChildrenField',
            ...this.orderedStages.flatMap(({ refreshProps }) => [...refreshProps]),
        ];
        this.addManagedPropertyListeners(allProps, (params) => {
            const properties = params.changeSet?.properties;
            if (properties) {
                this.onPropChange(properties);
            }
        });
        // TODO: HACK: rowData should be in the list of allProps instead of being registered separately.
        // but due to AG-13498, the columnModel will execute AFTER the previous listeners if properties
        // the column model listen to together with the previous listener are changed together.
        // So this is a temporary solution to make sure rowData is processed after the columnModel is ready.
        // Unfortunately this can result in double refresh when multiple properties are changed together, as it was before version 33.
        this.addManagedPropertyListener('rowData', () => this.onPropChange(['rowData']));
        this.addManagedPropertyListener('rowHeight', () => this.resetRowHeights());
    }
    start() {
        this.started = true;
        if (this.rowNodesCountReady) {
            this.refreshModel({ step: 'group', rowDataUpdated: true, newData: true });
        }
        else {
            this.setInitialData();
        }
    }
    setInitialData() {
        const rowData = this.gos.get('rowData');
        if (rowData) {
            this.onPropChange(['rowData']);
        }
    }
    ensureRowHeightsValid(startPixel, endPixel, startLimitIndex, endLimitIndex) {
        let atLeastOneChange;
        let res = false;
        // we do this multiple times as changing the row heights can also change the first and last rows,
        // so the first pass can make lots of rows smaller, which means the second pass we end up changing
        // more rows.
        do {
            atLeastOneChange = false;
            const rowAtStartPixel = this.getRowIndexAtPixel(startPixel);
            const rowAtEndPixel = this.getRowIndexAtPixel(endPixel);
            // keep check to current page if doing pagination
            const firstRow = Math.max(rowAtStartPixel, startLimitIndex);
            const lastRow = Math.min(rowAtEndPixel, endLimitIndex);
            for (let rowIndex = firstRow; rowIndex <= lastRow; rowIndex++) {
                const rowNode = this.getRow(rowIndex);
                if (rowNode.rowHeightEstimated) {
                    const rowHeight = (0, gridOptionsUtils_1._getRowHeightForNode)(this.beans, rowNode);
                    rowNode.setRowHeight(rowHeight.height);
                    atLeastOneChange = true;
                    res = true;
                }
            }
            if (atLeastOneChange) {
                this.setRowTopAndRowIndex();
            }
        } while (atLeastOneChange);
        return res;
    }
    onPropChange(properties) {
        if (!this.rootNode) {
            return; // Destroyed.
        }
        const gos = this.gos;
        const changedProps = new Set(properties);
        const params = {
            step: 'nothing',
            changedProps,
        };
        const rowDataChanged = changedProps.has('rowData');
        const oldNodeManager = this.nodeManager;
        const nodeManager = this.getNewNodeManager();
        const reset = oldNodeManager !== nodeManager ||
            (rowDataChanged && changedProps.has('treeData') && gos.get('treeData')) ||
            (changedProps.has('treeDataChildrenField') && gos.get('treeData'));
        let newRowData;
        if (reset || rowDataChanged) {
            newRowData = gos.get('rowData');
            if (newRowData != null && !Array.isArray(newRowData)) {
                newRowData = null;
                (0, logging_1._warn)(1);
            }
        }
        if (reset) {
            // If we are here, it means that the row manager need to be changed or fully reloaded
            if (!rowDataChanged) {
                // No new rowData was passed, so to include user executed transaction we need to extract
                // the row data from the node manager as it might be different from the original rowData
                newRowData = oldNodeManager?.extractRowData() ?? newRowData;
            }
            if (oldNodeManager !== nodeManager) {
                oldNodeManager?.deactivate();
                this.nodeManager = nodeManager;
            }
            nodeManager.activate(this.rootNode);
        }
        if (newRowData) {
            const immutable = !reset &&
                !this.isEmpty() &&
                newRowData.length > 0 &&
                gos.exists('getRowId') &&
                // this property is a backwards compatibility property, for those who want
                // the old behaviour of Row IDs but NOT Immutable Data.
                !gos.get('resetRowDataOnUpdate');
            if (immutable) {
                params.keepRenderedRows = true;
                params.animate = !this.gos.get('suppressAnimationFrame');
                params.changedRowNodes = new changedRowNodes_1.ChangedRowNodes();
                nodeManager.setImmutableRowData(params, newRowData);
            }
            else {
                params.rowDataUpdated = true;
                params.newData = true;
                // no need to invalidate cache, as the cache is stored on the rowNode,
                // so new rowNodes means the cache is wiped anyway.
                const { selectionSvc, pinnedRowModel } = this.beans;
                // - clears selection, done before we set row data to ensure it isn't readded via `selectionSvc.syncInOldRowNode`
                selectionSvc?.reset('rowDataChanged');
                // only clear pinned rows if using manual pinning
                if (pinnedRowModel?.isManual()) {
                    pinnedRowModel.reset();
                }
                this.rowNodesCountReady = true;
                nodeManager.setNewRowData(newRowData);
            }
        }
        if (params.rowDataUpdated) {
            params.step = 'group';
        }
        else if (params.step === 'nothing') {
            for (const { refreshProps, step } of this.orderedStages) {
                if (properties.some((prop) => refreshProps.has(prop))) {
                    params.step = step;
                    break;
                }
            }
        }
        if (params.step !== 'nothing') {
            this.refreshModel(params);
        }
    }
    setRowTopAndRowIndex() {
        const { beans, rowsToDisplay } = this;
        const defaultRowHeight = beans.environment.getDefaultRowHeight();
        let nextRowTop = 0;
        // mapping displayed rows is not needed for this method, however it's used in
        // clearRowTopAndRowIndex(), and given we are looping through this.rowsToDisplay here,
        // we create the map here for performance reasons, so we don't loop a second time
        // in clearRowTopAndRowIndex()
        const displayedRowsMapped = new Set();
        // we don't estimate if doing fullHeight or autoHeight, as all rows get rendered all the time
        // with these two layouts.
        const allowEstimate = (0, gridOptionsUtils_1._isDomLayout)(this.gos, 'normal');
        for (let i = 0, len = rowsToDisplay.length; i < len; ++i) {
            const rowNode = rowsToDisplay[i];
            if (rowNode.id != null) {
                displayedRowsMapped.add(rowNode.id);
            }
            if (rowNode.rowHeight == null) {
                const rowHeight = (0, gridOptionsUtils_1._getRowHeightForNode)(beans, rowNode, allowEstimate, defaultRowHeight);
                rowNode.setRowHeight(rowHeight.height, rowHeight.estimated);
            }
            rowNode.setRowTop(nextRowTop);
            rowNode.setRowIndex(i);
            nextRowTop += rowNode.rowHeight;
        }
        return displayedRowsMapped;
    }
    clearRowTopAndRowIndex(changedPath, displayedRowsMapped) {
        const changedPathActive = changedPath.active;
        const clearIfNotDisplayed = (rowNode) => {
            if (rowNode && rowNode.id != null && !displayedRowsMapped.has(rowNode.id)) {
                rowNode.clearRowTopAndRowIndex();
            }
        };
        const recurse = (rowNode) => {
            if (rowNode === null) {
                return;
            }
            clearIfNotDisplayed(rowNode);
            clearIfNotDisplayed(rowNode.detailNode);
            clearIfNotDisplayed(rowNode.sibling);
            if (rowNode.hasChildren()) {
                if (rowNode.childrenAfterGroup) {
                    // if a changedPath is active, it means we are here because of a transaction update or
                    // a change detection. neither of these impacts the open/closed state of groups. so if
                    // a group is not open this time, it was not open last time. so we know all closed groups
                    // already have their top positions cleared. so there is no need to traverse all the way
                    // when changedPath is active and the rowNode is not expanded.
                    const isRootNode = rowNode.level == -1; // we need to give special consideration for root node,
                    // as expanded=undefined for root node
                    const skipChildren = changedPathActive && !isRootNode && !rowNode.expanded;
                    if (!skipChildren) {
                        rowNode.childrenAfterGroup.forEach(recurse);
                    }
                }
            }
        };
        recurse(this.rootNode);
    }
    isLastRowIndexKnown() {
        return true;
    }
    getRowCount() {
        if (this.rowsToDisplay) {
            return this.rowsToDisplay.length;
        }
        return 0;
    }
    /**
     * Returns the number of rows with level === 1
     */
    getTopLevelRowCount() {
        const rootNode = this.rootNode;
        if (!rootNode) {
            return 0;
        }
        if (this.rowsToDisplay.length === 0) {
            return 0;
        }
        // exception to func comment, if showing root node, then we return that
        const showingRootNode = this.rowsToDisplay && this.rowsToDisplay[0] === rootNode;
        if (showingRootNode) {
            return 1;
        }
        // we use the childrenAfterSort as postSortRows is occasionally used to reduce row count.
        const filteredChildren = rootNode.childrenAfterSort;
        const totalFooterInc = rootNode.sibling && rootNode.sibling.displayed ? 1 : 0;
        return (filteredChildren ? filteredChildren.length : 0) + totalFooterInc;
    }
    /**
     * Get the row display index by the top level index
     * top level index is the index of rows with level === 1
     */
    getTopLevelRowDisplayedIndex(topLevelIndex) {
        const { rootNode, rowsToDisplay } = this;
        const showingRootNode = !rootNode || !rowsToDisplay.length || rowsToDisplay[0] === rootNode;
        // exception to function comment, if showing footer node (level === -1) return 0.
        if (showingRootNode) {
            return topLevelIndex;
        }
        const { childrenAfterSort } = rootNode;
        const getDefaultIndex = (adjustedIndex) => {
            let rowNode = childrenAfterSort[adjustedIndex];
            if (this.gos.get('groupHideOpenParents')) {
                // if hideOpenParents, then get lowest displayed descendent
                while (rowNode.expanded && rowNode.childrenAfterSort && rowNode.childrenAfterSort.length > 0) {
                    rowNode = rowNode.childrenAfterSort[0];
                }
            }
            return rowNode.rowIndex;
        };
        const { footerSvc } = this.beans;
        if (footerSvc) {
            return footerSvc.getTopDisplayIndex(rowsToDisplay, topLevelIndex, childrenAfterSort, getDefaultIndex);
        }
        else {
            return getDefaultIndex(topLevelIndex);
        }
    }
    /**
     * The opposite of `getTopLevelRowDisplayedIndex`
     */
    getTopLevelIndexFromDisplayedIndex(displayedIndex) {
        const { rootNode, rowsToDisplay } = this;
        const showingRootNode = !rootNode || !rowsToDisplay.length || rowsToDisplay[0] === rootNode;
        if (showingRootNode) {
            return displayedIndex;
        }
        let node = this.getRow(displayedIndex);
        if (node.footer) {
            node = node.sibling;
        }
        // find the top level node
        while (node.parent && node.parent !== rootNode) {
            node = node.parent;
        }
        const topLevelIndex = rootNode.childrenAfterSort?.findIndex((childNode) => childNode === node);
        return topLevelIndex === -1 ? displayedIndex : topLevelIndex ?? displayedIndex;
    }
    getRowBounds(index) {
        const rowNode = this.rowsToDisplay[index];
        if (rowNode) {
            return {
                rowTop: rowNode.rowTop,
                rowHeight: rowNode.rowHeight,
            };
        }
        return null;
    }
    onRowGroupOpened() {
        const animate = (0, gridOptionsUtils_1._isAnimateRows)(this.gos);
        this.refreshModel({ step: 'map', keepRenderedRows: true, animate: animate });
    }
    onFilterChanged(event) {
        if (event.afterDataChange) {
            return;
        }
        const animate = (0, gridOptionsUtils_1._isAnimateRows)(this.gos);
        const primaryOrQuickFilterChanged = event.columns.length === 0 || event.columns.some((col) => col.isPrimary());
        const step = primaryOrQuickFilterChanged ? 'filter' : 'filter_aggregates';
        this.refreshModel({ step: step, keepRenderedRows: true, animate: animate });
    }
    onSortChanged() {
        const animate = (0, gridOptionsUtils_1._isAnimateRows)(this.gos);
        this.refreshModel({
            step: 'sort',
            keepRenderedRows: true,
            animate: animate,
        });
    }
    getType() {
        return 'clientSide';
    }
    onValueChanged() {
        this.refreshModel({ step: this.colModel.isPivotActive() ? 'pivot' : 'aggregate' });
    }
    createChangePath(enabled) {
        // for updates, if the row is updated at all, then we re-calc all the values
        // in that row. we could compare each value to each old value, however if we
        // did this, we would be calling the valueSvc twice, once on the old value
        // and once on the new value. so it's less valueGetter calls if we just assume
        // each column is different. that way the changedPath is used so that only
        // the impacted parent rows are recalculated, parents who's children have
        // not changed are not impacted.
        const changedPath = new changedPath_1.ChangedPath(false, this.rootNode);
        if (!enabled) {
            changedPath.active = false;
        }
        return changedPath;
    }
    isSuppressModelUpdateAfterUpdateTransaction(params) {
        if (!this.gos.get('suppressModelUpdateAfterUpdateTransaction')) {
            return false; // Not suppressed
        }
        const { changedRowNodes, newData, rowDataUpdated } = params;
        if (!changedRowNodes || newData || !rowDataUpdated) {
            return false; // Not a transaction update
        }
        if (changedRowNodes.removals.size || changedRowNodes.adds.size) {
            return false; // There are added rows or removed rows, not just updates
        }
        return true; // Nothing changed, or only updates with no new rows and no removals
    }
    refreshModel(params) {
        if (!this.rootNode) {
            return; // Destroyed
        }
        // this goes through the pipeline of stages. what's in my head is similar
        // to the diagram on this page:
        // http://commons.apache.org/sandbox/commons-pipeline/pipeline_basics.html
        // however we want to keep the results of each stage, hence we manually call
        // each step rather than have them chain each other.
        // fallthrough in below switch is on purpose,
        // eg if STEP_FILTER, then all steps below this
        // step get done
        // let start: number;
        // console.log('======= start =======');
        const beans = this.beans;
        let rowDataUpdated = !!params.rowDataUpdated;
        const changedPath = (params.changedPath ?? (params.changedPath = this.createChangePath(!params.newData && rowDataUpdated)));
        if (this.started && rowDataUpdated) {
            this.eventSvc.dispatchEvent({ type: 'rowDataUpdated' });
        }
        if (!this.started ||
            this.isRefreshingModel ||
            this.colModel.changeEventsDispatching ||
            this.isSuppressModelUpdateAfterUpdateTransaction(params)) {
            this.rowDataUpdatedPending || (this.rowDataUpdatedPending = rowDataUpdated);
            return;
        }
        if (this.rowDataUpdatedPending) {
            this.rowDataUpdatedPending = false;
            params.rowDataUpdated = rowDataUpdated = true;
            params.step = 'group'; // Ensure grouping runs
        }
        this.isRefreshingModel = true;
        beans.masterDetailSvc?.refreshModel(params);
        if (rowDataUpdated && params.step !== 'group') {
            beans.colFilter?.refreshModel();
        }
        /* eslint-disable no-fallthrough */
        switch (params.step) {
            case 'group': {
                const groupingChanged = this.doRowGrouping(params);
                if (groupingChanged || rowDataUpdated) {
                    beans.colFilter?.refreshModel();
                }
                if (!this.rowCountReady && this.rowNodesCountReady) {
                    this.rowCountReady = true; // only if row data has been set
                    this.eventSvc.dispatchEventOnce({ type: 'rowCountReady' });
                }
            }
            case 'filter':
                this.doFilter(changedPath);
            case 'pivot':
                this.doPivot(changedPath);
            case 'aggregate': // depends on agg fields
                this.doAggregate(changedPath);
            case 'filter_aggregates':
                this.doFilterAggregates(changedPath);
            case 'sort':
                this.doSort(params.changedRowNodes, changedPath);
            case 'map':
                this.doRowsToDisplay();
        }
        /* eslint-enable no-fallthrough */
        // set all row tops to null, then set row tops on all visible rows. if we don't
        // do this, then the algorithm below only sets row tops, old row tops from old rows
        // will still lie around
        const displayedNodesMapped = this.setRowTopAndRowIndex();
        this.clearRowTopAndRowIndex(changedPath, displayedNodesMapped);
        this.isRefreshingModel = false;
        this.eventSvc.dispatchEvent({
            type: 'modelUpdated',
            animate: params.animate,
            keepRenderedRows: params.keepRenderedRows,
            newData: params.newData,
            newPage: false,
            keepUndoRedoStack: params.keepUndoRedoStack,
        });
    }
    isEmpty() {
        return !this.rootNode?.allLeafChildren?.length || !this.colModel?.ready;
    }
    isRowsToRender() {
        return this.rowsToDisplay.length > 0;
    }
    getNodesInRangeForSelection(firstInRange, lastInRange) {
        let started = false;
        let finished = false;
        const result = [];
        const groupsSelectChildren = (0, gridOptionsUtils_1._getGroupSelectsDescendants)(this.gos);
        this.forEachNodeAfterFilterAndSort((rowNode) => {
            // range has been closed, skip till end
            if (finished) {
                return;
            }
            if (started) {
                if (rowNode === lastInRange || rowNode === firstInRange) {
                    // check if this is the last node we're going to be adding
                    finished = true;
                    // if the final node was a group node, and we're doing groupSelectsChildren
                    // make the exception to select all of it's descendants too
                    if (rowNode.group && groupsSelectChildren) {
                        result.push(...rowNode.allLeafChildren);
                        return;
                    }
                }
            }
            if (!started) {
                if (rowNode !== lastInRange && rowNode !== firstInRange) {
                    // still haven't hit a boundary node, keep searching
                    return;
                }
                started = true;
                // When the first and last node are the same we're already finished
                if (lastInRange === firstInRange) {
                    finished = true;
                }
            }
            // only select leaf nodes if groupsSelectChildren
            const includeThisNode = !rowNode.group || !groupsSelectChildren;
            if (includeThisNode) {
                result.push(rowNode);
                return;
            }
        });
        return result;
    }
    getTopLevelNodes() {
        return this.rootNode?.childrenAfterGroup ?? null;
    }
    getRow(index) {
        return this.rowsToDisplay[index];
    }
    isRowPresent(rowNode) {
        return this.rowsToDisplay.indexOf(rowNode) >= 0;
    }
    getRowIndexAtPixel(pixelToMatch) {
        const rowsToDisplay = this.rowsToDisplay;
        if (this.isEmpty() || rowsToDisplay.length === 0) {
            return -1;
        }
        // do binary search of tree
        // http://oli.me.uk/2013/06/08/searching-javascript-arrays-with-a-binary-search/
        let bottomPointer = 0;
        let topPointer = rowsToDisplay.length - 1;
        // quick check, if the pixel is out of bounds, then return last row
        if (pixelToMatch <= 0) {
            // if pixel is less than or equal zero, it's always the first row
            return 0;
        }
        const lastNode = (0, array_1._last)(rowsToDisplay);
        if (lastNode.rowTop <= pixelToMatch) {
            return rowsToDisplay.length - 1;
        }
        let oldBottomPointer = -1;
        let oldTopPointer = -1;
        while (true) {
            const midPointer = Math.floor((bottomPointer + topPointer) / 2);
            const currentRowNode = rowsToDisplay[midPointer];
            if (this.isRowInPixel(currentRowNode, pixelToMatch)) {
                return midPointer;
            }
            if (currentRowNode.rowTop < pixelToMatch) {
                bottomPointer = midPointer + 1;
            }
            else if (currentRowNode.rowTop > pixelToMatch) {
                topPointer = midPointer - 1;
            }
            // infinite loops happen when there is space between rows. this can happen
            // when Auto Height is active, cos we re-calculate row tops asynchronously
            // when row heights change, which can temporarily result in gaps between rows.
            const caughtInInfiniteLoop = oldBottomPointer === bottomPointer && oldTopPointer === topPointer;
            if (caughtInInfiniteLoop) {
                return midPointer;
            }
            oldBottomPointer = bottomPointer;
            oldTopPointer = topPointer;
        }
    }
    isRowInPixel(rowNode, pixelToMatch) {
        const topPixel = rowNode.rowTop;
        const bottomPixel = rowNode.rowTop + rowNode.rowHeight;
        const pixelInRow = topPixel <= pixelToMatch && bottomPixel > pixelToMatch;
        return pixelInRow;
    }
    forEachLeafNode(callback) {
        this.rootNode?.allLeafChildren?.forEach((rowNode, index) => callback(rowNode, index));
    }
    forEachNode(callback, includeFooterNodes = false) {
        this.depthFirstSearchRowNodes(callback, includeFooterNodes);
    }
    forEachDisplayedNode(callback) {
        this.rowsToDisplay.forEach(callback);
    }
    forEachNodeAfterFilter(callback, includeFooterNodes = false) {
        this.depthFirstSearchRowNodes(callback, includeFooterNodes, (node) => node.childrenAfterAggFilter);
    }
    forEachNodeAfterFilterAndSort(callback, includeFooterNodes = false) {
        this.depthFirstSearchRowNodes(callback, includeFooterNodes, (node) => node.childrenAfterSort);
    }
    forEachPivotNode(callback, includeFooterNodes = false, afterSort = false) {
        const { colModel, rowGroupColsSvc } = this.beans;
        if (!colModel.isPivotMode()) {
            return;
        }
        // if no row grouping, then only row is root node
        if (!rowGroupColsSvc?.columns.length) {
            callback(this.rootNode, 0);
            return;
        }
        const childrenField = afterSort ? 'childrenAfterSort' : 'childrenAfterGroup';
        // for pivot, we don't go below leafGroup levels
        this.depthFirstSearchRowNodes(callback, includeFooterNodes, (node) => !node.leafGroup ? node[childrenField] : null);
    }
    /**
     * Iterate through each node and all of its children
     * @param callback the function to execute for each node
     * @param includeFooterNodes whether to also iterate over footer nodes
     * @param nodes the nodes to start iterating over
     * @param getChildren a function to determine the recursion strategy
     * @param startIndex the index to start from
     * @returns the index ended at
     */
    depthFirstSearchRowNodes(callback, includeFooterNodes = false, getChildren = (node) => node.childrenAfterGroup, node = this.rootNode, startIndex = 0) {
        let index = startIndex;
        if (!node) {
            return index;
        }
        const isRootNode = node === this.rootNode;
        if (!isRootNode) {
            callback(node, index++);
        }
        const { footerSvc } = this.beans;
        if (node.hasChildren() && !node.footer) {
            const children = getChildren(node);
            if (children) {
                index = footerSvc?.addTotalRows(index, node, callback, includeFooterNodes, isRootNode, 'top') ?? index;
                for (const node of children) {
                    index = this.depthFirstSearchRowNodes(callback, includeFooterNodes, getChildren, node, index);
                }
                return (footerSvc?.addTotalRows(index, node, callback, includeFooterNodes, isRootNode, 'bottom') ?? index);
            }
        }
        return index;
    }
    // it's possible to recompute the aggregate without doing the other parts
    // + api.refreshClientSideRowModel('aggregate')
    doAggregate(changedPath) {
        const rootNode = this.rootNode;
        if (rootNode) {
            this.aggStage?.execute({ rowNode: rootNode, changedPath: changedPath });
        }
    }
    doFilterAggregates(changedPath) {
        const rootNode = this.rootNode;
        if (this.filterAggStage) {
            this.filterAggStage.execute({ rowNode: rootNode, changedPath: changedPath });
        }
        else {
            // If filterAggStage is undefined, then so is the grouping stage, so all children should be on the rootNode.
            rootNode.childrenAfterAggFilter = rootNode.childrenAfterFilter;
        }
    }
    doSort(changedRowNodes, changedPath) {
        if (this.sortStage) {
            this.sortStage.execute({
                rowNode: this.rootNode,
                changedRowNodes,
                changedPath: changedPath,
            });
        }
        else {
            changedPath.forEachChangedNodeDepthFirst((rowNode) => {
                rowNode.childrenAfterSort = rowNode.childrenAfterAggFilter.slice(0);
                (0, sortStage_1.updateRowNodeAfterSort)(rowNode);
            });
        }
    }
    doRowGrouping(params) {
        const rootNode = this.rootNode;
        const groupStageExecuted = this.groupStage?.execute({
            rowNode: rootNode,
            changedRowNodes: params.changedRowNodes,
            changedPath: params.changedPath,
            rowNodesOrderChanged: !!params.rowNodesOrderChanged,
            afterColumnsChanged: !!params.afterColumnsChanged,
        });
        if (groupStageExecuted !== undefined) {
            return groupStageExecuted;
        }
        const sibling = rootNode.sibling;
        rootNode.childrenAfterGroup = rootNode.allLeafChildren;
        if (sibling) {
            sibling.childrenAfterGroup = rootNode.childrenAfterGroup;
        }
        rootNode.updateHasChildren();
        return false;
    }
    doFilter(changedPath) {
        if (this.filterStage) {
            this.filterStage.execute({ rowNode: this.rootNode, changedPath: changedPath });
        }
        else {
            changedPath.forEachChangedNodeDepthFirst((rowNode) => {
                rowNode.childrenAfterFilter = rowNode.childrenAfterGroup;
                (0, filterStage_1.updateRowNodeAfterFilter)(rowNode);
            }, true);
        }
    }
    doPivot(changedPath) {
        this.pivotStage?.execute({ rowNode: this.rootNode, changedPath: changedPath });
    }
    getRowNode(id) {
        const found = this.nodeManager.getRowNode(id);
        if (typeof found === 'object') {
            return found; // we check for typeof object to avoid returning things from Object.prototype
        }
        // although id is typed a string, this could be called by the user, and they could have passed a number
        const idIsGroup = typeof id == 'string' && id.indexOf(rowNode_1.ROW_ID_PREFIX_ROW_GROUP) === 0;
        return idIsGroup ? this.groupStage?.getNode(id) : undefined;
    }
    batchUpdateRowData(rowDataTransaction, callback) {
        if (this.applyAsyncTransactionsTimeout == null) {
            this.rowDataTransactionBatch = [];
            const waitMillis = this.gos.get('asyncTransactionWaitMillis');
            this.applyAsyncTransactionsTimeout = window.setTimeout(() => {
                if (this.isAlive()) {
                    // Handle case where grid is destroyed before timeout is triggered
                    this.executeBatchUpdateRowData();
                }
            }, waitMillis);
        }
        this.rowDataTransactionBatch.push({ rowDataTransaction: rowDataTransaction, callback });
    }
    flushAsyncTransactions() {
        if (this.applyAsyncTransactionsTimeout != null) {
            clearTimeout(this.applyAsyncTransactionsTimeout);
            this.executeBatchUpdateRowData();
        }
    }
    executeBatchUpdateRowData() {
        this.valueCache?.onDataChanged();
        const callbackFuncsBound = [];
        const rowNodeTrans = [];
        const changedRowNodes = new changedRowNodes_1.ChangedRowNodes();
        let orderChanged = false;
        this.rowDataTransactionBatch?.forEach((tranItem) => {
            this.rowNodesCountReady = true;
            const { rowNodeTransaction, rowsInserted } = this.nodeManager.updateRowData(tranItem.rowDataTransaction, changedRowNodes);
            if (rowsInserted) {
                orderChanged = true;
            }
            rowNodeTrans.push(rowNodeTransaction);
            if (tranItem.callback) {
                callbackFuncsBound.push(tranItem.callback.bind(null, rowNodeTransaction));
            }
        });
        this.commitTransactions(orderChanged, changedRowNodes);
        // do callbacks in next VM turn so it's async
        if (callbackFuncsBound.length > 0) {
            window.setTimeout(() => {
                callbackFuncsBound.forEach((func) => func());
            }, 0);
        }
        if (rowNodeTrans.length > 0) {
            this.eventSvc.dispatchEvent({
                type: 'asyncTransactionsFlushed',
                results: rowNodeTrans,
            });
        }
        this.rowDataTransactionBatch = null;
        this.applyAsyncTransactionsTimeout = undefined;
    }
    /**
     * Used to apply transaction changes.
     * Called by gridApi & rowDragFeature
     */
    updateRowData(rowDataTran) {
        this.valueCache?.onDataChanged();
        this.rowNodesCountReady = true;
        const changedRowNodes = new changedRowNodes_1.ChangedRowNodes();
        const { rowNodeTransaction, rowsInserted } = this.nodeManager.updateRowData(rowDataTran, changedRowNodes);
        this.commitTransactions(rowsInserted, changedRowNodes);
        return rowNodeTransaction;
    }
    /**
     * Common to:
     * - executeBatchUpdateRowData (batch transactions)
     * - updateRowData (single transaction)
     * - setImmutableRowData (generated transaction)
     *
     * @param rowNodeTrans - the transactions to apply
     * @param orderChanged - whether the order of the rows has changed, either via generated transaction or user provided addIndex
     */
    commitTransactions(rowNodesOrderChanged, changedRowNodes) {
        this.refreshModel({
            step: 'group',
            rowDataUpdated: true,
            rowNodesOrderChanged,
            keepRenderedRows: true,
            animate: !this.gos.get('suppressAnimationFrame'),
            changedRowNodes,
            changedPath: this.createChangePath(true),
        });
    }
    doRowsToDisplay() {
        const { flattenStage, rootNode } = this;
        let rowsToDisplay;
        if (flattenStage) {
            rowsToDisplay = flattenStage.execute({ rowNode: rootNode });
        }
        else {
            rowsToDisplay = rootNode?.childrenAfterSort ?? [];
            for (const row of rowsToDisplay) {
                row.setUiLevel(0);
            }
        }
        this.rowsToDisplay = rowsToDisplay;
    }
    onRowHeightChanged() {
        this.refreshModel({
            step: 'map',
            keepRenderedRows: true,
            keepUndoRedoStack: true,
        });
    }
    resetRowHeights() {
        const rootNode = this.rootNode;
        if (!rootNode) {
            return;
        }
        const atLeastOne = this.resetRowHeightsForAllRowNodes();
        rootNode.setRowHeight(rootNode.rowHeight, true);
        if (rootNode.sibling) {
            rootNode.sibling.setRowHeight(rootNode.sibling.rowHeight, true);
        }
        // when pivotMode but pivot not active, root node is displayed on its own
        // because it's only ever displayed alone, refreshing the model (onRowHeightChanged) is not required
        if (atLeastOne) {
            this.onRowHeightChanged();
        }
    }
    resetRowHeightsForAllRowNodes() {
        let atLeastOne = false;
        this.forEachNode((rowNode) => {
            rowNode.setRowHeight(rowNode.rowHeight, true);
            // we keep the height each row is at, however we set estimated=true rather than clear the height.
            // this means the grid will not reset the row heights back to defaults, rather it will re-calc
            // the height for each row as the row is displayed. otherwise the scroll will jump when heights are reset.
            const detailNode = rowNode.detailNode;
            if (detailNode) {
                detailNode.setRowHeight(detailNode.rowHeight, true);
            }
            if (rowNode.sibling) {
                rowNode.sibling.setRowHeight(rowNode.sibling.rowHeight, true);
            }
            atLeastOne = true;
        });
        return atLeastOne;
    }
    onGridStylesChanges(e) {
        if (e.rowHeightChanged) {
            if (this.beans.rowAutoHeight?.active) {
                return;
            }
            this.resetRowHeights();
        }
    }
    onGridReady() {
        if (!this.started) {
            // App can start using API to add transactions, so need to add data into the node manager if not started
            this.setInitialData();
        }
    }
    isRowDataLoaded() {
        return this.rowCountReady;
    }
    destroy() {
        super.destroy();
        // Forcefully deallocate memory
        this.started = false;
        this.rootNode = null;
        this.nodeManager = null;
        this.rowDataTransactionBatch = null;
        this.orderedStages = array_1._EmptyArray;
        this.rowsToDisplay = array_1._EmptyArray;
    }
    /**
     * @deprecated v33.1
     */
    onRowHeightChangedDebounced() {
        this.onRowHeightChanged_debounced();
    }
}
exports.ClientSideRowModel = ClientSideRowModel;


/***/ }),

/***/ 34452:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getBestCostNodeSelection = exports.flushAsyncTransactions = exports.applyTransactionAsync = exports.applyTransaction = exports.forEachNodeAfterFilterAndSort = exports.forEachNodeAfterFilter = exports.forEachLeafNode = exports.isRowDataEmpty = exports.refreshClientSideRowModel = exports.onGroupExpandedOrCollapsed = void 0;
const rowModelApiUtils_1 = __webpack_require__(66876);
function onGroupExpandedOrCollapsed(beans) {
    beans.expansionSvc?.onGroupExpandedOrCollapsed();
}
exports.onGroupExpandedOrCollapsed = onGroupExpandedOrCollapsed;
function refreshClientSideRowModel(beans, step) {
    const clientSideRowModel = (0, rowModelApiUtils_1._getClientSideRowModel)(beans);
    if (clientSideRowModel) {
        if (!step || step === 'everything') {
            step = 'group';
        }
        clientSideRowModel.refreshModel({
            step,
            keepRenderedRows: true,
            animate: !beans.gos.get('suppressAnimationFrame'),
        });
    }
}
exports.refreshClientSideRowModel = refreshClientSideRowModel;
function isRowDataEmpty(beans) {
    return (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.isEmpty() ?? true;
}
exports.isRowDataEmpty = isRowDataEmpty;
function forEachLeafNode(beans, callback) {
    (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.forEachLeafNode(callback);
}
exports.forEachLeafNode = forEachLeafNode;
function forEachNodeAfterFilter(beans, callback) {
    (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.forEachNodeAfterFilter(callback);
}
exports.forEachNodeAfterFilter = forEachNodeAfterFilter;
function forEachNodeAfterFilterAndSort(beans, callback) {
    (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.forEachNodeAfterFilterAndSort(callback);
}
exports.forEachNodeAfterFilterAndSort = forEachNodeAfterFilterAndSort;
function applyTransaction(beans, rowDataTransaction) {
    return beans.frameworkOverrides.wrapIncoming(() => (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.updateRowData(rowDataTransaction));
}
exports.applyTransaction = applyTransaction;
function applyTransactionAsync(beans, rowDataTransaction, callback) {
    beans.frameworkOverrides.wrapIncoming(() => (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.batchUpdateRowData(rowDataTransaction, callback));
}
exports.applyTransactionAsync = applyTransactionAsync;
function flushAsyncTransactions(beans) {
    beans.frameworkOverrides.wrapIncoming(() => (0, rowModelApiUtils_1._getClientSideRowModel)(beans)?.flushAsyncTransactions());
}
exports.flushAsyncTransactions = flushAsyncTransactions;
function getBestCostNodeSelection(beans) {
    return beans.selectionSvc?.getBestCostNodeSelection();
}
exports.getBestCostNodeSelection = getBestCostNodeSelection;


/***/ }),

/***/ 89722:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientSideRowModelApiModule = exports.ClientSideRowModelModule = void 0;
const rowModelSharedApi_1 = __webpack_require__(74510);
const sharedApiModule_1 = __webpack_require__(36437);
const sortModule_1 = __webpack_require__(96620);
const version_1 = __webpack_require__(97205);
const clientSideNodeManager_1 = __webpack_require__(28128);
const clientSideRowModel_1 = __webpack_require__(83278);
const clientSideRowModelApi_1 = __webpack_require__(34452);
const sortStage_1 = __webpack_require__(19849);
/**
 * @feature Client-Side Row Model
 */
exports.ClientSideRowModelModule = {
    moduleName: 'ClientSideRowModel',
    version: version_1.VERSION,
    rowModels: ['clientSide'],
    beans: [clientSideNodeManager_1.ClientSideNodeManager, clientSideRowModel_1.ClientSideRowModel, sortStage_1.SortStage],
    dependsOn: [sortModule_1.SortModule],
};
/**
 * @feature Client-Side Row Model
 */
exports.ClientSideRowModelApiModule = {
    moduleName: 'ClientSideRowModelApi',
    version: version_1.VERSION,
    apiFunctions: {
        onGroupExpandedOrCollapsed: clientSideRowModelApi_1.onGroupExpandedOrCollapsed,
        refreshClientSideRowModel: clientSideRowModelApi_1.refreshClientSideRowModel,
        isRowDataEmpty: clientSideRowModelApi_1.isRowDataEmpty,
        forEachLeafNode: clientSideRowModelApi_1.forEachLeafNode,
        forEachNodeAfterFilter: clientSideRowModelApi_1.forEachNodeAfterFilter,
        forEachNodeAfterFilterAndSort: clientSideRowModelApi_1.forEachNodeAfterFilterAndSort,
        applyTransaction: clientSideRowModelApi_1.applyTransaction,
        applyTransactionAsync: clientSideRowModelApi_1.applyTransactionAsync,
        flushAsyncTransactions: clientSideRowModelApi_1.flushAsyncTransactions,
        getBestCostNodeSelection: clientSideRowModelApi_1.getBestCostNodeSelection,
        resetRowHeights: rowModelSharedApi_1.resetRowHeights,
        onRowHeightChanged: rowModelSharedApi_1.onRowHeightChanged,
    },
    dependsOn: [sharedApiModule_1.CsrmSsrmSharedApiModule, sharedApiModule_1.RowModelSharedApiModule],
};


/***/ }),

/***/ 48287:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterStage = exports.updateRowNodeAfterFilter = void 0;
const beanStub_1 = __webpack_require__(68731);
function updateRowNodeAfterFilter(rowNode) {
    if (rowNode.sibling) {
        rowNode.sibling.childrenAfterFilter = rowNode.childrenAfterFilter;
    }
}
exports.updateRowNodeAfterFilter = updateRowNodeAfterFilter;
class FilterStage extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'filterStage';
        this.refreshProps = new Set(['excludeChildrenWhenTreeDataFiltering']);
        this.step = 'filter';
    }
    wireBeans(beans) {
        this.filterManager = beans.filterManager;
    }
    execute(params) {
        const { changedPath } = params;
        this.filter(changedPath);
    }
    filter(changedPath) {
        const filterActive = !!this.filterManager?.isChildFilterPresent();
        this.filterNodes(filterActive, changedPath);
    }
    filterNodes(filterActive, changedPath) {
        const filterCallback = (rowNode, includeChildNodes) => {
            // recursively get all children that are groups to also filter
            if (rowNode.hasChildren()) {
                // result of filter for this node. when filtering tree data, includeChildNodes = true when parent passes
                if (filterActive && !includeChildNodes) {
                    rowNode.childrenAfterFilter = rowNode.childrenAfterGroup.filter((childNode) => {
                        // a group is included in the result if it has any children of it's own.
                        // by this stage, the child groups are already filtered
                        const passBecauseChildren = childNode.childrenAfterFilter && childNode.childrenAfterFilter.length > 0;
                        // both leaf level nodes and tree data nodes have data. these get added if
                        // the data passes the filter
                        const passBecauseDataPasses = childNode.data && this.filterManager.doesRowPassFilter({ rowNode: childNode });
                        // note - tree data nodes pass either if a) they pass themselves or b) any children of that node pass
                        return passBecauseChildren || passBecauseDataPasses;
                    });
                }
                else {
                    // if not filtering, the result is the original list
                    rowNode.childrenAfterFilter = rowNode.childrenAfterGroup;
                }
            }
            else {
                rowNode.childrenAfterFilter = rowNode.childrenAfterGroup;
            }
            updateRowNodeAfterFilter(rowNode);
        };
        if (this.doingTreeDataFiltering()) {
            const treeDataDepthFirstFilter = (rowNode, alreadyFoundInParent) => {
                // tree data filter traverses the hierarchy depth first and includes child nodes if parent passes
                // filter, and parent nodes will be include if any children exist.
                if (rowNode.childrenAfterGroup) {
                    for (let i = 0; i < rowNode.childrenAfterGroup.length; i++) {
                        const childNode = rowNode.childrenAfterGroup[i];
                        // first check if current node passes filter before invoking child nodes
                        const foundInParent = alreadyFoundInParent || this.filterManager.doesRowPassFilter({ rowNode: childNode });
                        if (childNode.childrenAfterGroup) {
                            treeDataDepthFirstFilter(rowNode.childrenAfterGroup[i], foundInParent);
                        }
                        else {
                            filterCallback(childNode, foundInParent);
                        }
                    }
                }
                filterCallback(rowNode, alreadyFoundInParent);
            };
            const treeDataFilterCallback = (rowNode) => treeDataDepthFirstFilter(rowNode, false);
            changedPath.executeFromRootNode(treeDataFilterCallback);
        }
        else {
            const defaultFilterCallback = (rowNode) => filterCallback(rowNode, false);
            changedPath.forEachChangedNodeDepthFirst(defaultFilterCallback, true);
        }
    }
    doingTreeDataFiltering() {
        return this.gos.get('treeData') && !this.gos.get('excludeChildrenWhenTreeDataFiltering');
    }
}
exports.FilterStage = FilterStage;


/***/ }),

/***/ 19849:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SortStage = exports.updateRowNodeAfterSort = void 0;
const beanStub_1 = __webpack_require__(68731);
const gridOptionsUtils_1 = __webpack_require__(67274);
const updateRowNodeAfterSort = (rowNode) => {
    const childrenAfterSort = rowNode.childrenAfterSort;
    const sibling = rowNode.sibling;
    if (sibling) {
        sibling.childrenAfterSort = childrenAfterSort;
    }
    if (!childrenAfterSort) {
        return;
    }
    for (let i = 0, lastIdx = childrenAfterSort.length - 1; i <= lastIdx; i++) {
        const child = childrenAfterSort[i];
        const first = i === 0;
        const last = i === lastIdx;
        if (child.firstChild !== first) {
            child.firstChild = first;
            child.dispatchRowEvent('firstChildChanged');
        }
        if (child.lastChild !== last) {
            child.lastChild = last;
            child.dispatchRowEvent('lastChildChanged');
        }
        if (child.childIndex !== i) {
            child.childIndex = i;
            child.dispatchRowEvent('childIndexChanged');
        }
    }
};
exports.updateRowNodeAfterSort = updateRowNodeAfterSort;
class SortStage extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'sortStage';
        this.refreshProps = new Set(['postSortRows', 'groupDisplayType', 'accentedSort']);
        this.step = 'sort';
    }
    execute(params) {
        const sortOptions = this.beans.sortSvc.getSortOptions();
        const deltaSort = sortOptions.length > 0 &&
            !!params.changedRowNodes &&
            // in time we can remove this check, so that delta sort is always
            // on if transactions are present. it's off for now so that we can
            // selectively turn it on and test it with some select users before
            // rolling out to everyone.
            this.gos.get('deltaSort');
        this.sort(sortOptions, deltaSort, params.changedRowNodes, params.changedPath);
    }
    sort(sortOptions, useDeltaSort, changedRowNodes, changedPath) {
        const { gos, colModel, rowGroupColsSvc, rowNodeSorter, rowRenderer, showRowGroupCols } = this.beans;
        const groupMaintainOrder = gos.get('groupMaintainOrder');
        const groupColumnsPresent = colModel.getCols().some((c) => c.isRowGroupActive());
        const groupCols = rowGroupColsSvc?.columns;
        const isPivotMode = colModel.isPivotMode();
        const postSortFunc = gos.getCallback('postSortRows');
        let hasAnyFirstChildChanged = false;
        let sortContainsGroupColumns;
        const callback = (rowNode) => {
            // It's pointless to sort rows which aren't being displayed. in pivot mode we don't need to sort the leaf group children.
            const skipSortingPivotLeafs = isPivotMode && rowNode.leafGroup;
            let skipSortingGroups = groupMaintainOrder && groupColumnsPresent && !rowNode.leafGroup;
            if (skipSortingGroups) {
                sortContainsGroupColumns ?? (sortContainsGroupColumns = this.shouldSortContainsGroupCols(sortOptions));
                skipSortingGroups && (skipSortingGroups = !sortContainsGroupColumns);
            }
            let newChildrenAfterSort = null;
            if (skipSortingGroups) {
                // Maintain previous visual order in O(n).
                let wasSortExplicitlyRemoved = false;
                if (groupCols) {
                    const nextGroupIndex = rowNode.level + 1;
                    if (nextGroupIndex < groupCols.length) {
                        // if the sort is null, then sort was explicitly removed, so remove sort from this group.
                        wasSortExplicitlyRemoved = groupCols[nextGroupIndex].getSort() === null;
                    }
                }
                if (!wasSortExplicitlyRemoved) {
                    newChildrenAfterSort = preserveGroupOrder(rowNode);
                }
            }
            else if (!sortOptions.length || skipSortingPivotLeafs) {
                // if there's no sort to make, skip this step
                newChildrenAfterSort = null;
            }
            else if (useDeltaSort && changedRowNodes) {
                newChildrenAfterSort = doDeltaSort(rowNodeSorter, rowNode, changedRowNodes, changedPath, sortOptions);
            }
            else {
                newChildrenAfterSort = rowNodeSorter.doFullSort(rowNode.childrenAfterAggFilter, sortOptions);
            }
            newChildrenAfterSort || (newChildrenAfterSort = rowNode.childrenAfterAggFilter?.slice(0) ?? []);
            hasAnyFirstChildChanged || (hasAnyFirstChildChanged = rowNode.childrenAfterSort?.[0] !== newChildrenAfterSort[0]);
            rowNode.childrenAfterSort = newChildrenAfterSort;
            (0, exports.updateRowNodeAfterSort)(rowNode);
            if (postSortFunc) {
                const params = { nodes: rowNode.childrenAfterSort };
                postSortFunc(params);
            }
        };
        changedPath?.forEachChangedNodeDepthFirst(callback);
        // if using group hide open parents and a sort has happened, refresh the group cells as the first child
        // displays the parent grouping - it's cheaper here to refresh all cells in col rather than fire events for every potential
        // child cell
        if (hasAnyFirstChildChanged && gos.get('groupHideOpenParents')) {
            const columns = showRowGroupCols?.getShowRowGroupCols();
            if (columns?.length) {
                rowRenderer.refreshCells({ columns, force: true });
            }
        }
    }
    shouldSortContainsGroupCols(sortOptions) {
        const sortOptionsLen = sortOptions.length;
        if (!sortOptionsLen) {
            return false;
        }
        if ((0, gridOptionsUtils_1._isColumnsSortingCoupledToGroup)(this.gos)) {
            for (let i = 0; i < sortOptionsLen; ++i) {
                const column = sortOptions[i].column;
                if (column.isPrimary() && column.isRowGroupActive()) {
                    return true;
                }
            }
            return false;
        }
        for (let i = 0; i < sortOptionsLen; ++i) {
            if (sortOptions[i].column.getColDef().showRowGroup) {
                return true;
            }
        }
        return false;
    }
}
exports.SortStage = SortStage;
const doDeltaSort = (rowNodeSorter, rowNode, changedRowNodes, changedPath, sortOptions) => {
    const unsortedRows = rowNode.childrenAfterAggFilter;
    const oldSortedRows = rowNode.childrenAfterSort;
    if (!oldSortedRows) {
        return rowNodeSorter.doFullSort(unsortedRows, sortOptions);
    }
    const untouchedRows = new Set();
    const touchedRows = [];
    const { updates, adds } = changedRowNodes;
    for (let i = 0, len = unsortedRows.length; i < len; ++i) {
        const row = unsortedRows[i];
        if (updates.has(row) || adds.has(row) || (changedPath && !changedPath.canSkip(row))) {
            touchedRows.push({
                currentPos: touchedRows.length,
                rowNode: row,
            });
        }
        else {
            untouchedRows.add(row);
        }
    }
    const sortedUntouchedRows = oldSortedRows
        .filter((child) => untouchedRows.has(child))
        .map((rowNode, currentPos) => ({ currentPos, rowNode }));
    touchedRows.sort((a, b) => rowNodeSorter.compareRowNodes(sortOptions, a, b));
    return mergeSortedArrays(rowNodeSorter, sortOptions, touchedRows, sortedUntouchedRows);
};
// Merge two sorted arrays into each other
const mergeSortedArrays = (rowNodeSorter, sortOptions, arr1, arr2) => {
    let i = 0;
    let j = 0;
    const arr1Length = arr1.length;
    const arr2Length = arr2.length;
    const res = new Array(arr1Length + arr2Length);
    let k = 0;
    // Traverse both arrays, adding them in order
    while (i < arr1Length && j < arr2Length) {
        const a = arr1[i];
        const b = arr2[j];
        if (rowNodeSorter.compareRowNodes(sortOptions, a, b) < 0) {
            res[k++] = a.rowNode;
            ++i;
        }
        else {
            res[k++] = b.rowNode;
            ++j;
        }
    }
    // add remaining from arr1
    while (i < arr1Length) {
        res[k++] = arr1[i++].rowNode;
    }
    // add remaining from arr2
    while (j < arr2Length) {
        res[k++] = arr2[j++].rowNode;
    }
    return res;
};
/**
 * O(n) merge preserving previous visual order and appending new items in current order.
 */
const preserveGroupOrder = (node) => {
    const childrenAfterSort = node.childrenAfterSort;
    const childrenAfterAggFilter = node.childrenAfterAggFilter;
    const childrenAfterSortLen = childrenAfterSort?.length;
    const childrenAfterAggFilterLen = childrenAfterAggFilter?.length;
    if (!childrenAfterSortLen || !childrenAfterAggFilterLen) {
        return null;
    }
    const result = new Array(childrenAfterAggFilterLen);
    // Track all present nodes.
    const processed = new Set();
    for (let i = 0; i < childrenAfterAggFilterLen; ++i) {
        processed.add(childrenAfterAggFilter[i]);
    }
    // Keep nodes that are still present, in previous visual order.
    let writeIdx = 0;
    for (let i = 0; i < childrenAfterSortLen; ++i) {
        const node = childrenAfterSort[i];
        if (processed.delete(node)) {
            result[writeIdx++] = node;
        }
    }
    if (processed.size === 0 && writeIdx === childrenAfterSortLen) {
        return childrenAfterSort; // No change, return the previous array
    }
    // Add new nodes
    for (const newNode of processed) {
        result[writeIdx++] = newNode;
    }
    result.length = writeIdx;
    return result;
};


/***/ }),

/***/ 43218:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.autoSizeAllColumns = exports.autoSizeColumns = exports.sizeColumnsToFit = void 0;
function sizeColumnsToFit(beans, paramsOrGridWidth) {
    if (typeof paramsOrGridWidth === 'number') {
        beans.colAutosize?.sizeColumnsToFit(paramsOrGridWidth, 'api');
    }
    else {
        beans.colAutosize?.sizeColumnsToFitGridBody(paramsOrGridWidth);
    }
}
exports.sizeColumnsToFit = sizeColumnsToFit;
function autoSizeColumns({ colAutosize, visibleCols }, keysOrParams, skipHeader) {
    if (Array.isArray(keysOrParams)) {
        colAutosize?.autoSizeCols({ colKeys: keysOrParams, skipHeader, source: 'api' });
    }
    else {
        colAutosize?.autoSizeCols({
            colKeys: keysOrParams.colIds ?? visibleCols.allCols,
            skipHeader: keysOrParams.skipHeader,
            defaultMaxWidth: keysOrParams.defaultMaxWidth,
            defaultMinWidth: keysOrParams.defaultMinWidth,
            columnLimits: keysOrParams.columnLimits,
            source: 'api',
        });
    }
}
exports.autoSizeColumns = autoSizeColumns;
function autoSizeAllColumns(beans, paramsOrSkipHeader) {
    if (paramsOrSkipHeader && typeof paramsOrSkipHeader === 'object') {
        autoSizeColumns(beans, paramsOrSkipHeader);
    }
    else {
        beans.colAutosize?.autoSizeAllColumns({ source: 'api', skipHeader: paramsOrSkipHeader });
    }
}
exports.autoSizeAllColumns = autoSizeAllColumns;


/***/ }),

/***/ 63856:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnAutoSizeModule = void 0;
const autoWidthModule_1 = __webpack_require__(40447);
const version_1 = __webpack_require__(97205);
const columnAutosizeApi_1 = __webpack_require__(43218);
const columnAutosizeService_1 = __webpack_require__(44817);
/**
 * @feature Columns -> Column Sizing
 * @gridOption autoSizeStrategy
 */
exports.ColumnAutoSizeModule = {
    moduleName: 'ColumnAutoSize',
    version: version_1.VERSION,
    beans: [columnAutosizeService_1.ColumnAutosizeService],
    apiFunctions: {
        sizeColumnsToFit: columnAutosizeApi_1.sizeColumnsToFit,
        autoSizeColumns: columnAutosizeApi_1.autoSizeColumns,
        autoSizeAllColumns: columnAutosizeApi_1.autoSizeAllColumns,
    },
    dependsOn: [autoWidthModule_1.AutoWidthModule],
};


/***/ }),

/***/ 44817:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnAutosizeService = void 0;
const array_1 = __webpack_require__(79909);
const dom_1 = __webpack_require__(1956);
const columnEventUtils_1 = __webpack_require__(72934);
const columnUtils_1 = __webpack_require__(73146);
const beanStub_1 = __webpack_require__(68731);
const logging_1 = __webpack_require__(47764);
const touchListener_1 = __webpack_require__(99644);
class ColumnAutosizeService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colAutosize';
        this.timesDelayed = 0;
        // when we're waiting for cell data types to be inferred, we need to defer column resizing
        this.shouldQueueResizeOperations = false;
        this.resizeOperationQueue = [];
    }
    postConstruct() {
        const autoSizeStrategy = this.gos.get('autoSizeStrategy');
        if (autoSizeStrategy) {
            let shouldHideColumns = false;
            const type = autoSizeStrategy.type;
            if (type === 'fitGridWidth' || type === 'fitProvidedWidth') {
                shouldHideColumns = true;
            }
            else if (type === 'fitCellContents') {
                this.addManagedEventListeners({ firstDataRendered: () => this.onFirstDataRendered(autoSizeStrategy) });
            }
            if (shouldHideColumns) {
                this.beans.colDelayRenderSvc?.hideColumns(type);
            }
        }
    }
    autoSizeCols(params) {
        if (this.shouldQueueResizeOperations) {
            this.pushResizeOperation(() => this.autoSizeCols(params));
            return;
        }
        const { colKeys, skipHeader, skipHeaderGroups, stopAtGroup, defaultMaxWidth, defaultMinWidth, columnLimits = [], source = 'api', } = params;
        // because of column virtualisation, we can only do this function on columns that are
        // actually rendered, as non-rendered columns (outside the viewport and not rendered
        // due to column virtualisation) are not present. this can result in all rendered columns
        // getting narrowed, which in turn introduces more rendered columns on the RHS which
        // did not get autoSized in the original run, leaving the visible grid with columns on
        // the LHS sized, but RHS no. so we keep looping through the visible columns until
        // no more cols are available (rendered) to be resized
        const { animationFrameSvc, renderStatus, colModel, autoWidthCalc, visibleCols } = this.beans;
        // we autosize after animation frames finish in case any cell renderers need to complete first. this can
        // happen eg if client code is calling api.autoSizeAllColumns() straight after grid is initialised, but grid
        // hasn't fully drawn out all the cells yet (due to cell renderers in animation frames).
        animationFrameSvc?.flushAllFrames();
        if (this.timesDelayed < 5 &&
            renderStatus &&
            (!renderStatus.areHeaderCellsRendered() || !renderStatus.areCellsRendered())) {
            // This is needed for React, as it doesn't render the headers or cells synchronously all the time.
            // Added a defensive check to avoid infinite loop in case headers or cells are never rendered.
            this.timesDelayed++;
            setTimeout(() => {
                if (this.isAlive()) {
                    this.autoSizeCols(params);
                }
            });
            return;
        }
        this.timesDelayed = 0;
        // keep track of which cols we have resized in here
        const columnsAutoSized = [];
        // initialise with anything except 0 so that while loop executes at least once
        let changesThisTimeAround = -1;
        const columnLimitsIndex = Object.fromEntries(columnLimits.map(({ colId, maxWidth, minWidth }) => [colId, { maxWidth, minWidth }]));
        const shouldSkipHeader = skipHeader != null ? skipHeader : this.gos.get('skipHeaderOnAutoSize');
        const shouldSkipHeaderGroups = skipHeaderGroups != null ? skipHeaderGroups : shouldSkipHeader;
        while (changesThisTimeAround !== 0) {
            changesThisTimeAround = 0;
            const updatedColumns = [];
            colKeys.forEach((key) => {
                if (!key || (0, columnUtils_1.isSpecialCol)(key)) {
                    return;
                }
                const column = colModel.getCol(key);
                if (!column) {
                    return;
                }
                // if already autoSized, skip it
                if (columnsAutoSized.indexOf(column) >= 0) {
                    return;
                }
                // get how wide this col should be
                const preferredWidth = autoWidthCalc.getPreferredWidthForColumn(column, shouldSkipHeader);
                // preferredWidth = -1 if this col is not on the screen
                if (preferredWidth > 0) {
                    const columnLimit = columnLimitsIndex[column.colId] ?? {};
                    columnLimit.minWidth ?? (columnLimit.minWidth = defaultMinWidth);
                    columnLimit.maxWidth ?? (columnLimit.maxWidth = defaultMaxWidth);
                    const newWidth = normaliseColumnWidth(column, preferredWidth, columnLimit);
                    column.setActualWidth(newWidth, source);
                    columnsAutoSized.push(column);
                    changesThisTimeAround++;
                }
                updatedColumns.push(column);
            });
            if (!updatedColumns.length) {
                continue;
            }
            visibleCols.refresh(source);
        }
        if (!shouldSkipHeaderGroups) {
            this.autoSizeColumnGroupsByColumns(colKeys, source, stopAtGroup);
        }
        (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, columnsAutoSized, true, 'autosizeColumns');
    }
    autoSizeColumn(key, source, skipHeader) {
        if (key) {
            this.autoSizeCols({ colKeys: [key], skipHeader, skipHeaderGroups: true, source });
        }
    }
    autoSizeColumnGroupsByColumns(keys, source, stopAtGroup) {
        const { colModel, ctrlsSvc } = this.beans;
        const columnGroups = new Set();
        const columns = colModel.getColsForKeys(keys);
        columns.forEach((col) => {
            let parent = col.getParent();
            while (parent && parent != stopAtGroup) {
                if (!parent.isPadding()) {
                    columnGroups.add(parent);
                }
                parent = parent.getParent();
            }
        });
        let headerGroupCtrl;
        const resizedColumns = [];
        for (const columnGroup of columnGroups) {
            for (const headerContainerCtrl of ctrlsSvc.getHeaderRowContainerCtrls()) {
                headerGroupCtrl = headerContainerCtrl.getHeaderCtrlForColumn(columnGroup);
                if (headerGroupCtrl) {
                    break;
                }
            }
            if (headerGroupCtrl) {
                headerGroupCtrl.resizeLeafColumnsToFit(source);
            }
        }
        return resizedColumns;
    }
    autoSizeAllColumns(params) {
        if (this.shouldQueueResizeOperations) {
            this.pushResizeOperation(() => this.autoSizeAllColumns(params));
            return;
        }
        const allDisplayedColumns = this.beans.visibleCols.allCols;
        this.autoSizeCols({ colKeys: allDisplayedColumns, ...params });
    }
    addColumnAutosize(element, column) {
        const skipHeaderOnAutoSize = this.gos.get('skipHeaderOnAutoSize');
        const autoSizeColListener = () => {
            this.autoSizeColumn(column, 'uiColumnResized', skipHeaderOnAutoSize);
        };
        element.addEventListener('dblclick', autoSizeColListener);
        const touchListener = new touchListener_1.TouchListener(element);
        touchListener.addEventListener('doubleTap', autoSizeColListener);
        return () => {
            element.removeEventListener('dblclick', autoSizeColListener);
            touchListener.removeEventListener('doubleTap', autoSizeColListener);
            touchListener.destroy();
        };
    }
    addColumnGroupResize(element, columnGroup, callback) {
        const skipHeaderOnAutoSize = this.gos.get('skipHeaderOnAutoSize');
        const listener = () => {
            // get list of all the column keys we are responsible for
            const keys = [];
            const leafCols = columnGroup.getDisplayedLeafColumns();
            leafCols.forEach((column) => {
                // not all cols in the group may be participating with auto-resize
                if (!column.getColDef().suppressAutoSize) {
                    keys.push(column.getColId());
                }
            });
            if (keys.length > 0) {
                this.autoSizeCols({
                    colKeys: keys,
                    skipHeader: skipHeaderOnAutoSize,
                    stopAtGroup: columnGroup,
                    source: 'uiColumnResized',
                });
            }
            callback();
        };
        element.addEventListener('dblclick', listener);
        return () => element.removeEventListener('dblclick', listener);
    }
    // method will call itself if no available width. this covers if the grid
    // isn't visible, but is just about to be visible.
    sizeColumnsToFitGridBody(params, nextTimeout) {
        if (!this.isAlive()) {
            return;
        }
        const { ctrlsSvc, scrollVisibleSvc } = this.beans;
        const gridBodyCtrl = ctrlsSvc.getGridBodyCtrl();
        const removeScrollWidth = gridBodyCtrl.isVerticalScrollShowing();
        const scrollWidthToRemove = removeScrollWidth ? scrollVisibleSvc.getScrollbarWidth() : 0;
        // bodyViewportWidth should be calculated from eGridBody, not eBodyViewport
        // because we change the width of the bodyViewport to hide the real browser scrollbar
        const bodyViewportWidth = (0, dom_1._getInnerWidth)(gridBodyCtrl.eGridBody);
        const availableWidth = bodyViewportWidth - scrollWidthToRemove;
        if (availableWidth > 0) {
            this.sizeColumnsToFit(availableWidth, 'sizeColumnsToFit', false, params);
            return;
        }
        if (nextTimeout === undefined) {
            window.setTimeout(() => {
                this.sizeColumnsToFitGridBody(params, 100);
            }, 0);
        }
        else if (nextTimeout === 100) {
            window.setTimeout(() => {
                this.sizeColumnsToFitGridBody(params, 500);
            }, 100);
        }
        else if (nextTimeout === 500) {
            window.setTimeout(() => {
                this.sizeColumnsToFitGridBody(params, -1);
            }, 500);
        }
        else {
            // Grid coming back with zero width, maybe the grid is not visible yet on the screen?
            (0, logging_1._warn)(29);
        }
    }
    // called from api
    sizeColumnsToFit(gridWidth, source = 'sizeColumnsToFit', silent, params) {
        if (this.shouldQueueResizeOperations) {
            this.pushResizeOperation(() => this.sizeColumnsToFit(gridWidth, source, silent, params));
            return;
        }
        const limitsMap = {};
        if (params) {
            params?.columnLimits?.forEach(({ key, ...dimensions }) => {
                limitsMap[typeof key === 'string' ? key : key.getColId()] = dimensions;
            });
        }
        // avoid divide by zero
        const allDisplayedColumns = this.beans.visibleCols.allCols;
        if (gridWidth <= 0 || !allDisplayedColumns.length) {
            return;
        }
        const doColumnsAlreadyFit = gridWidth === (0, columnUtils_1.getWidthOfColsInList)(allDisplayedColumns);
        if (doColumnsAlreadyFit) {
            // if all columns fit, check they are within the min and max widths - if so, can quit early.
            const doAllColumnsSatisfyConstraints = allDisplayedColumns.every((column) => {
                if (column.colDef.suppressSizeToFit) {
                    return true;
                }
                const widthOverride = limitsMap?.[column.getId()];
                const minWidth = widthOverride?.minWidth ?? params?.defaultMinWidth;
                const maxWidth = widthOverride?.maxWidth ?? params?.defaultMaxWidth;
                const colWidth = column.getActualWidth();
                return (minWidth == null || colWidth >= minWidth) && (maxWidth == null || colWidth <= maxWidth);
            });
            if (doAllColumnsSatisfyConstraints) {
                return;
            }
        }
        const colsToSpread = [];
        const colsToNotSpread = [];
        allDisplayedColumns.forEach((column) => {
            if (column.getColDef().suppressSizeToFit === true) {
                colsToNotSpread.push(column);
            }
            else {
                colsToSpread.push(column);
            }
        });
        // make a copy of the cols that are going to be resized
        const colsToDispatchEventFor = colsToSpread.slice(0);
        let finishedResizing = false;
        const moveToNotSpread = (column) => {
            (0, array_1._removeFromArray)(colsToSpread, column);
            colsToNotSpread.push(column);
        };
        // resetting cols to their original width makes the sizeColumnsToFit more deterministic,
        // rather than depending on the current size of the columns. most users call sizeColumnsToFit
        // immediately after grid is created, so will make no difference. however if application is calling
        // sizeColumnsToFit repeatedly (eg after column group is opened / closed repeatedly) we don't want
        // the columns to start shrinking / growing over time.
        //
        // NOTE: the process below will assign values to `this.actualWidth` of each column without firing events
        // for this reason we need to manually dispatch resize events after the resize has been done for each column.
        colsToSpread.forEach((column) => {
            column.resetActualWidth(source);
            const widthOverride = limitsMap?.[column.getId()];
            const minOverride = widthOverride?.minWidth ?? params?.defaultMinWidth;
            const maxOverride = widthOverride?.maxWidth ?? params?.defaultMaxWidth;
            const colWidth = column.getActualWidth();
            if (typeof minOverride === 'number' && colWidth < minOverride) {
                column.setActualWidth(minOverride, source, true);
            }
            else if (typeof maxOverride === 'number' && colWidth > maxOverride) {
                column.setActualWidth(maxOverride, source, true);
            }
        });
        while (!finishedResizing) {
            finishedResizing = true;
            const availablePixels = gridWidth - (0, columnUtils_1.getWidthOfColsInList)(colsToNotSpread);
            if (availablePixels <= 0) {
                // no width, set everything to minimum
                colsToSpread.forEach((column) => {
                    const widthOverride = limitsMap?.[column.getId()]?.minWidth ?? params?.defaultMinWidth;
                    if (typeof widthOverride === 'number') {
                        column.setActualWidth(widthOverride, source, true);
                        return;
                    }
                    column.setActualWidth(column.minWidth, source);
                });
            }
            else {
                const scale = availablePixels / (0, columnUtils_1.getWidthOfColsInList)(colsToSpread);
                // we set the pixels for the last col based on what's left, as otherwise
                // we could be a pixel or two short or extra because of rounding errors.
                let pixelsForLastCol = availablePixels;
                // backwards through loop, as we are removing items as we go
                for (let i = colsToSpread.length - 1; i >= 0; i--) {
                    const column = colsToSpread[i];
                    const widthOverride = limitsMap?.[column.getId()];
                    const minOverride = widthOverride?.minWidth ?? params?.defaultMinWidth;
                    const maxOverride = widthOverride?.maxWidth ?? params?.defaultMaxWidth;
                    const colMinWidth = column.getMinWidth();
                    const colMaxWidth = column.getMaxWidth();
                    const minWidth = typeof minOverride === 'number' && minOverride > colMinWidth ? minOverride : colMinWidth;
                    const maxWidth = typeof maxOverride === 'number' && maxOverride < colMaxWidth ? maxOverride : colMaxWidth;
                    let newWidth = Math.round(column.getActualWidth() * scale);
                    if (newWidth < minWidth) {
                        newWidth = minWidth;
                        moveToNotSpread(column);
                        finishedResizing = false;
                    }
                    else if (newWidth > maxWidth) {
                        newWidth = maxWidth;
                        moveToNotSpread(column);
                        finishedResizing = false;
                    }
                    else if (i === 0) {
                        // if this is the last column
                        newWidth = pixelsForLastCol;
                    }
                    column.setActualWidth(newWidth, source, true);
                    pixelsForLastCol -= newWidth;
                }
            }
        }
        // see notes above
        colsToDispatchEventFor.forEach((col) => {
            col.fireColumnWidthChangedEvent(source);
        });
        const visibleCols = this.beans.visibleCols;
        visibleCols.setLeftValues(source);
        visibleCols.updateBodyWidths();
        if (silent) {
            return;
        }
        (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, colsToDispatchEventFor, true, source);
    }
    applyAutosizeStrategy() {
        const { gos, colDelayRenderSvc } = this.beans;
        const autoSizeStrategy = gos.get('autoSizeStrategy');
        if (!autoSizeStrategy || autoSizeStrategy.type === 'fitCellContents') {
            return;
        }
        // ensure things like aligned grids have linked first
        setTimeout(() => {
            if (!this.isAlive()) {
                return;
            }
            const type = autoSizeStrategy.type;
            if (type === 'fitGridWidth') {
                const { columnLimits: propColumnLimits, defaultMinWidth, defaultMaxWidth } = autoSizeStrategy;
                const columnLimits = propColumnLimits?.map(({ colId: key, minWidth, maxWidth }) => ({
                    key,
                    minWidth,
                    maxWidth,
                }));
                this.sizeColumnsToFitGridBody({
                    defaultMinWidth,
                    defaultMaxWidth,
                    columnLimits,
                });
            }
            else if (type === 'fitProvidedWidth') {
                this.sizeColumnsToFit(autoSizeStrategy.width, 'sizeColumnsToFit');
            }
            colDelayRenderSvc?.revealColumns(type);
        });
    }
    onFirstDataRendered(strategy) {
        const { colIds: columns, skipHeader, defaultMaxWidth, defaultMinWidth, columnLimits } = strategy;
        // ensure render has finished
        setTimeout(() => {
            if (!this.isAlive()) {
                return;
            }
            const params = {
                skipHeader,
                source: 'autosizeColumns',
                defaultMaxWidth,
                defaultMinWidth,
                columnLimits,
            };
            if (columns) {
                this.autoSizeCols({ colKeys: columns, ...params });
            }
            else {
                this.autoSizeAllColumns(params);
            }
        });
    }
    processResizeOperations() {
        this.shouldQueueResizeOperations = false;
        this.resizeOperationQueue.forEach((resizeOperation) => resizeOperation());
        this.resizeOperationQueue = [];
    }
    pushResizeOperation(func) {
        this.resizeOperationQueue.push(func);
    }
    destroy() {
        this.resizeOperationQueue.length = 0;
        super.destroy();
    }
}
exports.ColumnAutosizeService = ColumnAutosizeService;
/** returns the width we can set to this col, taking into consideration min and max widths */
function normaliseColumnWidth(column, newWidth, limits = {}) {
    const minWidth = limits.minWidth ?? column.getMinWidth();
    if (newWidth < minWidth) {
        newWidth = minWidth;
    }
    const maxWidth = limits.maxWidth ?? column.getMaxWidth();
    if (newWidth > maxWidth) {
        newWidth = maxWidth;
    }
    return newWidth;
}


/***/ }),

/***/ 9607:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.columnMovingCSS = void 0;
exports.columnMovingCSS = `:where(.ag-ltr) :where(.ag-column-moving){.ag-cell,.ag-header-cell,.ag-spanned-cell-wrapper{transition:left .2s}.ag-header-group-cell{transition:left .2s,width .2s}}:where(.ag-rtl) :where(.ag-column-moving){.ag-cell,.ag-header-cell,.ag-spanned-cell-wrapper{transition:right .2s}.ag-header-group-cell{transition:right .2s,width .2s}}`;


/***/ }),

/***/ 19122:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnAnimationService = void 0;
const beanStub_1 = __webpack_require__(68731);
class ColumnAnimationService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colAnimation';
        this.executeNextFuncs = [];
        this.executeLaterFuncs = [];
        this.active = false;
        // activeNext starts with active but it is reset earlier after the nextFuncs are cleared
        // to prevent calls made to executeNextVMTurn from queuing functions after executeNextFuncs has already been flushed,
        this.activeNext = false;
        this.suppressAnimation = false;
        this.animationThreadCount = 0;
    }
    postConstruct() {
        this.beans.ctrlsSvc.whenReady(this, (p) => (this.gridBodyCtrl = p.gridBodyCtrl));
    }
    isActive() {
        return this.active && !this.suppressAnimation;
    }
    setSuppressAnimation(suppress) {
        this.suppressAnimation = suppress;
    }
    start() {
        if (this.active) {
            return;
        }
        const { gos } = this;
        if (gos.get('suppressColumnMoveAnimation')) {
            return;
        }
        // if doing RTL, we don't animate open / close as due to how the pixels are inverted,
        // the animation moves all the row the the right rather than to the left (ie it's the static
        // columns that actually get their coordinates updated)
        if (gos.get('enableRtl')) {
            return;
        }
        this.ensureAnimationCssClassPresent();
        this.active = true;
        this.activeNext = true;
    }
    finish() {
        if (!this.active) {
            return;
        }
        this.flush(() => (this.activeNext = false), () => (this.active = false));
    }
    executeNextVMTurn(func) {
        if (this.activeNext) {
            this.executeNextFuncs.push(func);
        }
        else {
            func();
        }
    }
    executeLaterVMTurn(func) {
        if (this.active) {
            this.executeLaterFuncs.push(func);
        }
        else {
            func();
        }
    }
    ensureAnimationCssClassPresent() {
        // up the count, so we can tell if someone else has updated the count
        // by the time the 'wait' func executes
        this.animationThreadCount++;
        const animationThreadCountCopy = this.animationThreadCount;
        const { gridBodyCtrl } = this;
        gridBodyCtrl.setColumnMovingCss(true);
        this.executeLaterFuncs.push(() => {
            // only remove the class if this thread was the last one to update it
            if (this.animationThreadCount === animationThreadCountCopy) {
                gridBodyCtrl.setColumnMovingCss(false);
            }
        });
    }
    flush(callbackNext, callbackLater) {
        const { executeNextFuncs, executeLaterFuncs } = this;
        if (executeNextFuncs.length === 0 && executeLaterFuncs.length === 0) {
            callbackNext();
            callbackLater();
            return;
        }
        const runFuncs = (queue) => {
            while (queue.length) {
                const func = queue.pop();
                if (func) {
                    func();
                }
            }
        };
        this.beans.frameworkOverrides.wrapIncoming(() => {
            window.setTimeout(() => {
                callbackNext();
                runFuncs(executeNextFuncs);
            }, 0);
            window.setTimeout(() => {
                // run the callback before executeLaterFuncs
                // because some functions being executed later
                // check if this service is `active`.
                callbackLater();
                runFuncs(executeLaterFuncs);
            }, 200);
        });
    }
}
exports.ColumnAnimationService = ColumnAnimationService;


/***/ }),

/***/ 43052:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BodyDropPivotTarget = void 0;
const beanStub_1 = __webpack_require__(68731);
class BodyDropPivotTarget extends beanStub_1.BeanStub {
    constructor(pinned) {
        super();
        this.pinned = pinned;
        this.columnsToAggregate = [];
        this.columnsToGroup = [];
        this.columnsToPivot = [];
    }
    /** Callback for when drag enters */
    onDragEnter(draggingEvent) {
        this.clearColumnsList();
        // in pivot mode, we don't accept any drops if functions are read only
        if (this.gos.get('functionsReadOnly')) {
            return;
        }
        const dragColumns = draggingEvent.dragItem.columns;
        if (!dragColumns) {
            return;
        }
        dragColumns.forEach((column) => {
            // we don't allow adding secondary columns
            if (!column.isPrimary()) {
                return;
            }
            if (column.isAnyFunctionActive()) {
                return;
            }
            if (column.isAllowValue()) {
                this.columnsToAggregate.push(column);
            }
            else if (column.isAllowRowGroup()) {
                this.columnsToGroup.push(column);
            }
            else if (column.isAllowPivot()) {
                this.columnsToPivot.push(column);
            }
        });
    }
    getIconName() {
        const totalColumns = this.columnsToAggregate.length + this.columnsToGroup.length + this.columnsToPivot.length;
        if (totalColumns > 0) {
            return this.pinned ? 'pinned' : 'move';
        }
        return null;
    }
    /** Callback for when drag leaves */
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onDragLeave(draggingEvent) {
        // if we are taking columns out of the center, then we remove them from the report
        this.clearColumnsList();
    }
    clearColumnsList() {
        this.columnsToAggregate.length = 0;
        this.columnsToGroup.length = 0;
        this.columnsToPivot.length = 0;
    }
    /** Callback for when dragging */
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onDragging(draggingEvent) { }
    /** Callback for when drag stops */
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onDragStop(draggingEvent) {
        const { valueColsSvc, rowGroupColsSvc, pivotColsSvc } = this.beans;
        if (this.columnsToAggregate.length > 0) {
            valueColsSvc?.addColumns(this.columnsToAggregate, 'toolPanelDragAndDrop');
        }
        if (this.columnsToGroup.length > 0) {
            rowGroupColsSvc?.addColumns(this.columnsToGroup, 'toolPanelDragAndDrop');
        }
        if (this.columnsToPivot.length > 0) {
            pivotColsSvc?.addColumns(this.columnsToPivot, 'toolPanelDragAndDrop');
        }
    }
    onDragCancel() {
        this.clearColumnsList();
    }
}
exports.BodyDropPivotTarget = BodyDropPivotTarget;


/***/ }),

/***/ 57912:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BodyDropTarget = void 0;
const beanStub_1 = __webpack_require__(68731);
const dragAndDropService_1 = __webpack_require__(12903);
const bodyDropPivotTarget_1 = __webpack_require__(43052);
const moveColumnFeature_1 = __webpack_require__(92909);
class BodyDropTarget extends beanStub_1.BeanStub {
    constructor(pinned, eContainer) {
        super();
        this.pinned = pinned;
        this.eContainer = eContainer;
    }
    postConstruct() {
        const { ctrlsSvc, dragAndDrop } = this.beans;
        const pinned = this.pinned;
        ctrlsSvc.whenReady(this, (p) => {
            let eSecondaryContainers;
            const eBodyViewport = p.gridBodyCtrl.eBodyViewport;
            switch (pinned) {
                case 'left':
                    eSecondaryContainers = [
                        [eBodyViewport, p.left.eContainer],
                        [p.bottomLeft.eContainer],
                        [p.topLeft.eContainer],
                    ];
                    break;
                case 'right':
                    eSecondaryContainers = [
                        [eBodyViewport, p.right.eContainer],
                        [p.bottomRight.eContainer],
                        [p.topRight.eContainer],
                    ];
                    break;
                default:
                    eSecondaryContainers = [
                        [eBodyViewport, p.center.eViewport],
                        [p.bottomCenter.eViewport],
                        [p.topCenter.eViewport],
                    ];
                    break;
            }
            this.eSecondaryContainers = eSecondaryContainers;
        });
        this.moveColumnFeature = this.createManagedBean(new moveColumnFeature_1.MoveColumnFeature(pinned));
        this.bodyDropPivotTarget = this.createManagedBean(new bodyDropPivotTarget_1.BodyDropPivotTarget(pinned));
        dragAndDrop.addDropTarget(this);
        this.addDestroyFunc(() => dragAndDrop.removeDropTarget(this));
    }
    isInterestedIn(type) {
        return (type === dragAndDropService_1.DragSourceType.HeaderCell ||
            (type === dragAndDropService_1.DragSourceType.ToolPanel && this.gos.get('allowDragFromColumnsToolPanel')));
    }
    getSecondaryContainers() {
        return this.eSecondaryContainers;
    }
    getContainer() {
        return this.eContainer;
    }
    getIconName() {
        return this.currentDropListener.getIconName();
    }
    // we want to use the bodyPivotTarget if the user is dragging columns in from the toolPanel
    // and we are in pivot mode, as it has to logic to set pivot/value/group on the columns when
    // dropped into the grid's body.
    isDropColumnInPivotMode(draggingEvent) {
        // in pivot mode, then if moving a column (ie didn't come from toolpanel) then it's
        // a standard column move, however if it came from the toolpanel, then we are introducing
        // dimensions or values to the grid
        return this.beans.colModel.isPivotMode() && draggingEvent.dragSource.type === dragAndDropService_1.DragSourceType.ToolPanel;
    }
    onDragEnter(draggingEvent) {
        // we pick the drop listener depending on whether we are in pivot mode are not. if we are
        // in pivot mode, then dropping cols changes the row group, pivot, value stats. otherwise
        // we change visibility state and position.
        this.currentDropListener = this.isDropColumnInPivotMode(draggingEvent)
            ? this.bodyDropPivotTarget
            : this.moveColumnFeature;
        this.currentDropListener.onDragEnter(draggingEvent);
    }
    onDragLeave(params) {
        this.currentDropListener.onDragLeave(params);
    }
    onDragging(params) {
        this.currentDropListener.onDragging(params);
    }
    onDragStop(params) {
        this.currentDropListener.onDragStop(params);
    }
    onDragCancel() {
        this.currentDropListener.onDragCancel();
    }
}
exports.BodyDropTarget = BodyDropTarget;


/***/ }),

/***/ 92909:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MoveColumnFeature = void 0;
const array_1 = __webpack_require__(79909);
const generic_1 = __webpack_require__(89097);
const beanStub_1 = __webpack_require__(68731);
const dragAndDropService_1 = __webpack_require__(12903);
const iColumn_1 = __webpack_require__(62783);
const internalColumnMoveUtils_1 = __webpack_require__(45446);
const MOVE_FAIL_THRESHOLD = 7;
const SCROLL_MOVE_WIDTH = 100;
const SCROLL_GAP_NEEDED_BEFORE_MOVE = SCROLL_MOVE_WIDTH / 2;
const SCROLL_ACCELERATION_RATE = 5;
const SCROLL_TIME_INTERVAL = 100;
class MoveColumnFeature extends beanStub_1.BeanStub {
    constructor(pinned) {
        super();
        this.pinned = pinned;
        this.needToMoveLeft = false;
        this.needToMoveRight = false;
        this.lastMovedInfo = null;
        this.isCenterContainer = !(0, generic_1._exists)(pinned);
    }
    postConstruct() {
        this.beans.ctrlsSvc.whenReady(this, (p) => {
            this.gridBodyCon = p.gridBodyCtrl;
        });
    }
    getIconName() {
        const { pinned, lastDraggingEvent } = this;
        const { dragItem } = lastDraggingEvent || {};
        const columns = dragItem?.columns ?? [];
        for (const col of columns) {
            const colPinned = col.getPinned();
            // when the column is lockPinned, only moves within pinned section
            if (col.getColDef().lockPinned) {
                if (colPinned == pinned) {
                    return 'move';
                }
                continue;
            }
            // if the column pinned state is the same as the container's, or
            // when `unpinning` a column, set the icon to move
            const initialPinnedState = dragItem?.containerType;
            if (initialPinnedState === pinned || !pinned) {
                return 'move';
            }
            // moving an unpinned column to a pinned container
            // set the icon to pinned
            if (pinned && (!colPinned || initialPinnedState !== pinned)) {
                return 'pinned';
            }
        }
        return 'notAllowed';
    }
    onDragEnter(draggingEvent) {
        // we do dummy drag, so make sure column appears in the right location when first placed
        const dragItem = draggingEvent.dragItem;
        const columns = dragItem.columns;
        const dragCameFromToolPanel = draggingEvent.dragSource.type === dragAndDropService_1.DragSourceType.ToolPanel;
        if (dragCameFromToolPanel) {
            // the if statement doesn't work if drag leaves grid, then enters again
            this.setColumnsVisible(columns, true, 'uiColumnDragged');
        }
        else {
            // restore previous state of visible columns upon re-entering. this means if the user drags
            // a group out, and then drags the group back in, only columns that were originally visible
            // will be visible again. otherwise a group with three columns (but only two visible) could
            // be dragged out, then when it's dragged in again, all three are visible. this stops that.
            const visibleState = dragItem.visibleState;
            const visibleColumns = (columns || []).filter((column) => visibleState[column.getId()] && !column.isVisible());
            this.setColumnsVisible(visibleColumns, true, 'uiColumnDragged');
        }
        if (!this.gos.get('suppressMoveWhenColumnDragging')) {
            this.attemptToPinColumns(columns, this.pinned);
        }
        this.onDragging(draggingEvent, true, true);
    }
    onDragging(draggingEvent = this.lastDraggingEvent, fromEnter = false, fakeEvent = false, finished = false) {
        const { gos, ctrlsSvc } = this.beans;
        const isSuppressMoveWhenDragging = gos.get('suppressMoveWhenColumnDragging');
        if (finished && !isSuppressMoveWhenDragging) {
            this.finishColumnMoving();
            return;
        }
        this.lastDraggingEvent = draggingEvent;
        // if moving up or down (ie not left or right) then do nothing
        if (!draggingEvent || (!finished && (0, generic_1._missing)(draggingEvent.hDirection))) {
            return;
        }
        const mouseX = (0, internalColumnMoveUtils_1.normaliseX)({
            x: draggingEvent.x,
            pinned: this.pinned,
            gos,
            ctrlsSvc,
        });
        // if the user is dragging into the panel, ie coming from the side panel into the main grid,
        // we don't want to scroll the grid this time, it would appear like the table is jumping
        // each time a column is dragged in.
        if (!fromEnter) {
            this.checkCenterForScrolling(mouseX);
        }
        if (isSuppressMoveWhenDragging) {
            this.handleColumnDragWhileSuppressingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished);
        }
        else {
            this.handleColumnDragWhileAllowingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished);
        }
    }
    onDragLeave() {
        this.ensureIntervalCleared();
        this.clearHighlighted();
        this.updateDragItemContainerType();
        this.lastMovedInfo = null;
    }
    onDragStop() {
        this.onDragging(this.lastDraggingEvent, false, true, true);
        this.ensureIntervalCleared();
        this.lastMovedInfo = null;
    }
    onDragCancel() {
        this.clearHighlighted();
        this.ensureIntervalCleared();
        this.lastMovedInfo = null;
    }
    setColumnsVisible(columns, visible, source) {
        if (!columns?.length) {
            return;
        }
        const allowedCols = columns.filter((c) => !c.getColDef().lockVisible);
        if (!allowedCols.length) {
            return;
        }
        this.beans.colModel.setColsVisible(allowedCols, visible, source);
    }
    finishColumnMoving() {
        this.clearHighlighted();
        const lastMovedInfo = this.lastMovedInfo;
        if (!lastMovedInfo) {
            return;
        }
        const { columns, toIndex } = lastMovedInfo;
        this.beans.colMoves.moveColumns(columns, toIndex, 'uiColumnMoved', true);
    }
    updateDragItemContainerType() {
        const { lastDraggingEvent } = this;
        if (this.gos.get('suppressMoveWhenColumnDragging') || !lastDraggingEvent) {
            return;
        }
        const dragItem = lastDraggingEvent.dragItem;
        if (!dragItem) {
            return;
        }
        dragItem.containerType = this.pinned;
    }
    handleColumnDragWhileSuppressingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished) {
        const allMovingColumns = this.getAllMovingColumns(draggingEvent, true);
        if (finished) {
            // first we handle pinning, then move columns
            const isAttemptingToPin = this.isAttemptingToPin(allMovingColumns);
            if (isAttemptingToPin) {
                this.attemptToPinColumns(allMovingColumns, undefined, true);
            }
            const { fromLeft, xPosition } = this.getNormalisedXPositionInfo(allMovingColumns, isAttemptingToPin) || {};
            if (fromLeft == null || xPosition == null) {
                this.finishColumnMoving();
                return;
            }
            this.moveColumnsAfterHighlight({
                allMovingColumns,
                xPosition,
                fromEnter,
                fakeEvent,
                fromLeft,
            });
        }
        else {
            if (!this.beans.dragAndDrop.isDropZoneWithinThisGrid(draggingEvent)) {
                return;
            }
            this.highlightHoveredColumn(allMovingColumns, mouseX);
        }
    }
    handleColumnDragWhileAllowingMovement(draggingEvent, fromEnter, fakeEvent, mouseX, finished) {
        const allMovingColumns = this.getAllMovingColumns(draggingEvent);
        const fromLeft = this.normaliseDirection(draggingEvent.hDirection) === 'right';
        const isFromHeader = draggingEvent.dragSource.type === dragAndDropService_1.DragSourceType.HeaderCell;
        const params = this.getMoveColumnParams({
            allMovingColumns,
            isFromHeader,
            xPosition: mouseX,
            fromLeft,
            fromEnter,
            fakeEvent,
        });
        const lastMovedInfo = (0, internalColumnMoveUtils_1.attemptMoveColumns)({ ...params, finished });
        if (lastMovedInfo) {
            this.lastMovedInfo = lastMovedInfo;
        }
    }
    getAllMovingColumns(draggingEvent, useSplit = false) {
        const dragItem = draggingEvent.dragSource.getDragItem();
        let columns = null;
        if (useSplit) {
            columns = dragItem.columnsInSplit;
            if (!columns) {
                columns = dragItem.columns;
            }
        }
        else {
            columns = dragItem.columns;
        }
        // if locked return true only if both col and container are same pin type.
        // double equals (==) here on purpose so that null==undefined is true (for not pinned options)
        // if not pin locked, then always allowed to be in this container
        const conditionCallback = (col) => col.getColDef().lockPinned ? col.getPinned() == this.pinned : true;
        if (!columns) {
            return [];
        }
        return columns.filter(conditionCallback);
    }
    getMoveColumnParams(params) {
        const { allMovingColumns, isFromHeader, xPosition, fromLeft, fromEnter, fakeEvent } = params;
        const { gos, colModel, colMoves, visibleCols } = this.beans;
        return {
            allMovingColumns,
            isFromHeader,
            fromLeft,
            xPosition,
            pinned: this.pinned,
            fromEnter,
            fakeEvent,
            gos,
            colModel,
            colMoves: colMoves,
            visibleCols,
        };
    }
    highlightHoveredColumn(movingColumns, mouseX) {
        const { gos, colModel } = this.beans;
        const isRtl = gos.get('enableRtl');
        const consideredColumns = colModel
            .getCols()
            .filter((col) => col.isVisible() && col.getPinned() === this.pinned);
        let start = null;
        let width = null;
        let targetColumn = null;
        for (const col of consideredColumns) {
            width = col.getActualWidth();
            start = this.getNormalisedColumnLeft(col, 0, isRtl);
            if (start != null) {
                const end = start + width;
                if (start <= mouseX && end >= mouseX) {
                    targetColumn = col;
                    break;
                }
            }
            start = null;
            width = null;
        }
        if (!targetColumn) {
            // we fall into this condition if no columns are being hover
            // (e.g. hovering an empty area of the column header beyond all columns)
            for (let i = consideredColumns.length - 1; i >= 0; i--) {
                const currentColumn = consideredColumns[i];
                const parent = consideredColumns[i].getParent();
                if (!parent) {
                    targetColumn = currentColumn;
                    break;
                }
                const leafDisplayedCols = parent?.getDisplayedLeafColumns();
                if (leafDisplayedCols.length) {
                    targetColumn = (0, array_1._last)(leafDisplayedCols);
                    break;
                }
            }
            if (!targetColumn) {
                return;
            }
            start = this.getNormalisedColumnLeft(targetColumn, 0, isRtl);
            width = targetColumn.getActualWidth();
        }
        else if (movingColumns.indexOf(targetColumn) !== -1) {
            targetColumn = null;
        }
        if (this.lastHighlightedColumn?.column !== targetColumn) {
            this.clearHighlighted();
        }
        if (targetColumn == null || start == null || width == null) {
            return;
        }
        let position;
        if (mouseX - start < width / 2 !== isRtl) {
            position = iColumn_1.ColumnHighlightPosition.Before;
        }
        else {
            position = iColumn_1.ColumnHighlightPosition.After;
        }
        setColumnHighlighted(targetColumn, position);
        this.lastHighlightedColumn = { column: targetColumn, position };
    }
    getNormalisedXPositionInfo(allMovingColumns, isAttemptingToPin) {
        const { gos, visibleCols } = this.beans;
        const isRtl = gos.get('enableRtl');
        const { firstMovingCol, column, position } = this.getColumnMoveAndTargetInfo(allMovingColumns, isAttemptingToPin, isRtl);
        if (!firstMovingCol || !column || position == null) {
            return;
        }
        const visibleColumns = visibleCols.allCols;
        const movingColIndex = visibleColumns.indexOf(firstMovingCol);
        const targetIndex = visibleColumns.indexOf(column);
        const isBefore = (position === iColumn_1.ColumnHighlightPosition.Before) !== isRtl;
        const fromLeft = movingColIndex < targetIndex || (movingColIndex === targetIndex && !isBefore);
        let diff = 0;
        if (isBefore) {
            if (fromLeft) {
                diff -= 1;
            }
        }
        else {
            if (!fromLeft) {
                diff += 1;
            }
        }
        if (targetIndex + diff === movingColIndex) {
            return;
        }
        const targetColumn = visibleColumns[targetIndex + diff];
        if (!targetColumn) {
            return;
        }
        const xPosition = this.getNormalisedColumnLeft(targetColumn, 20, isRtl);
        return { fromLeft, xPosition };
    }
    getColumnMoveAndTargetInfo(allMovingColumns, isAttemptingToPin, isRtl) {
        const lastHighlightedColumn = this.lastHighlightedColumn || {};
        const { firstMovingCol, lastMovingCol } = findFirstAndLastMovingColumns(allMovingColumns);
        if (!firstMovingCol || !lastMovingCol || lastHighlightedColumn.column || !isAttemptingToPin) {
            return {
                firstMovingCol,
                ...lastHighlightedColumn,
            };
        }
        const pinned = this.getPinDirection();
        const isLeft = pinned === 'left';
        return {
            firstMovingCol,
            position: isLeft ? iColumn_1.ColumnHighlightPosition.After : iColumn_1.ColumnHighlightPosition.Before,
            column: isLeft !== isRtl ? firstMovingCol : lastMovingCol,
        };
    }
    normaliseDirection(hDirection) {
        if (this.gos.get('enableRtl')) {
            switch (hDirection) {
                case 'left':
                    return 'right';
                case 'right':
                    return 'left';
            }
        }
        return hDirection;
    }
    getNormalisedColumnLeft(col, padding, isRtl) {
        const { gos, ctrlsSvc } = this.beans;
        const left = col.getLeft();
        if (left == null) {
            return null;
        }
        const width = col.getActualWidth();
        return (0, internalColumnMoveUtils_1.normaliseX)({
            x: isRtl ? left + width - padding : left + padding,
            pinned: col.getPinned(),
            useHeaderRow: isRtl,
            skipScrollPadding: true,
            gos,
            ctrlsSvc,
        });
    }
    isAttemptingToPin(columns) {
        const isMovingHorizontally = this.needToMoveLeft || this.needToMoveRight;
        const isFailedMoreThanThreshold = this.failedMoveAttempts > MOVE_FAIL_THRESHOLD;
        return ((isMovingHorizontally && isFailedMoreThanThreshold) ||
            columns.some((col) => col.getPinned() !== this.pinned));
    }
    moveColumnsAfterHighlight(params) {
        const { allMovingColumns, xPosition, fromEnter, fakeEvent, fromLeft } = params;
        const columnMoveParams = this.getMoveColumnParams({
            allMovingColumns,
            isFromHeader: true,
            xPosition,
            fromLeft,
            fromEnter,
            fakeEvent,
        });
        const { columns, toIndex } = (0, internalColumnMoveUtils_1.getBestColumnMoveIndexFromXPosition)(columnMoveParams) || {};
        if (columns && toIndex != null) {
            this.lastMovedInfo = {
                columns,
                toIndex,
            };
        }
        this.finishColumnMoving();
    }
    clearHighlighted() {
        const { lastHighlightedColumn } = this;
        if (!lastHighlightedColumn) {
            return;
        }
        setColumnHighlighted(lastHighlightedColumn.column, null);
        this.lastHighlightedColumn = null;
    }
    checkCenterForScrolling(xAdjustedForScroll) {
        if (!this.isCenterContainer) {
            return;
        }
        // scroll if the mouse has gone outside the grid (or just outside the scrollable part if pinning)
        // putting in 50 buffer, so even if user gets to edge of grid, a scroll will happen
        const centerCtrl = this.beans.ctrlsSvc.get('center');
        const firstVisiblePixel = centerCtrl.getCenterViewportScrollLeft();
        const lastVisiblePixel = firstVisiblePixel + centerCtrl.getCenterWidth();
        let needToMoveRight;
        let needToMoveLeft;
        if (this.gos.get('enableRtl')) {
            needToMoveRight = xAdjustedForScroll < firstVisiblePixel + SCROLL_GAP_NEEDED_BEFORE_MOVE;
            needToMoveLeft = xAdjustedForScroll > lastVisiblePixel - SCROLL_GAP_NEEDED_BEFORE_MOVE;
        }
        else {
            needToMoveLeft = xAdjustedForScroll < firstVisiblePixel + SCROLL_GAP_NEEDED_BEFORE_MOVE;
            needToMoveRight = xAdjustedForScroll > lastVisiblePixel - SCROLL_GAP_NEEDED_BEFORE_MOVE;
        }
        this.needToMoveRight = needToMoveRight;
        this.needToMoveLeft = needToMoveLeft;
        if (needToMoveLeft || needToMoveRight) {
            this.ensureIntervalStarted();
        }
        else {
            this.ensureIntervalCleared();
        }
    }
    ensureIntervalStarted() {
        if (this.movingIntervalId) {
            return;
        }
        this.intervalCount = 0;
        this.failedMoveAttempts = 0;
        this.movingIntervalId = window.setInterval(this.moveInterval.bind(this), SCROLL_TIME_INTERVAL);
        this.beans.dragAndDrop.setDragImageCompIcon(this.needToMoveLeft ? 'left' : 'right', true);
    }
    ensureIntervalCleared() {
        if (!this.movingIntervalId) {
            return;
        }
        window.clearInterval(this.movingIntervalId);
        this.movingIntervalId = null;
        this.failedMoveAttempts = 0;
        this.beans.dragAndDrop.setDragImageCompIcon(this.getIconName());
    }
    moveInterval() {
        // the amounts we move get bigger at each interval, so the speed accelerates, starting a bit slow
        // and getting faster. this is to give smoother user experience. we max at `SCROLL_MOVE_WIDTH` to limit the speed.
        let pixelsToMove;
        this.intervalCount++;
        pixelsToMove = 10 + this.intervalCount * SCROLL_ACCELERATION_RATE;
        if (pixelsToMove > SCROLL_MOVE_WIDTH) {
            pixelsToMove = SCROLL_MOVE_WIDTH;
        }
        let pixelsMoved = null;
        const scrollFeature = this.gridBodyCon.scrollFeature;
        if (this.needToMoveLeft) {
            pixelsMoved = scrollFeature.scrollHorizontally(-pixelsToMove);
        }
        else if (this.needToMoveRight) {
            pixelsMoved = scrollFeature.scrollHorizontally(pixelsToMove);
        }
        if (pixelsMoved !== 0) {
            this.onDragging(this.lastDraggingEvent);
            this.failedMoveAttempts = 0;
        }
        else {
            // we count the failed move attempts. if we fail to move `MOVE_FAIL_THRESHOLD` times, then we pin the column.
            // this is how we achieve pining by dragging the column to the edge of the grid.
            this.failedMoveAttempts++;
            const { pinnedCols, dragAndDrop, gos } = this.beans;
            if (this.failedMoveAttempts <= MOVE_FAIL_THRESHOLD + 1 || !pinnedCols) {
                return;
            }
            dragAndDrop.setDragImageCompIcon('pinned');
            if (!gos.get('suppressMoveWhenColumnDragging')) {
                const columns = this.lastDraggingEvent?.dragItem.columns;
                this.attemptToPinColumns(columns, undefined, true);
            }
        }
    }
    getPinDirection() {
        if (this.needToMoveLeft || this.pinned === 'left') {
            return 'left';
        }
        if (this.needToMoveRight || this.pinned === 'right') {
            return 'right';
        }
    }
    attemptToPinColumns(columns, pinned, fromMoving = false) {
        const allowedCols = (columns || []).filter((c) => !c.getColDef().lockPinned);
        if (!allowedCols.length) {
            return 0;
        }
        if (fromMoving) {
            pinned = this.getPinDirection();
        }
        const { pinnedCols, dragAndDrop } = this.beans;
        pinnedCols?.setColsPinned(allowedCols, pinned, 'uiColumnDragged');
        if (fromMoving) {
            dragAndDrop.nudge();
        }
        return allowedCols.length;
    }
    destroy() {
        super.destroy();
        this.lastDraggingEvent = null;
        this.clearHighlighted();
        this.lastMovedInfo = null;
    }
}
exports.MoveColumnFeature = MoveColumnFeature;
function setColumnHighlighted(column, highlighted) {
    if (column.highlighted === highlighted) {
        return;
    }
    column.highlighted = highlighted;
    column.dispatchColEvent('headerHighlightChanged', 'uiColumnMoved');
}
function findFirstAndLastMovingColumns(allMovingColumns) {
    const moveLen = allMovingColumns.length;
    let firstMovingCol;
    let lastMovingCol;
    for (let i = 0; i < moveLen; i++) {
        if (!firstMovingCol) {
            const leftCol = allMovingColumns[i];
            if (leftCol.getLeft() != null) {
                firstMovingCol = leftCol;
            }
        }
        if (!lastMovingCol) {
            const rightCol = allMovingColumns[moveLen - 1 - i];
            if (rightCol.getLeft() != null) {
                lastMovingCol = rightCol;
            }
        }
        if (firstMovingCol && lastMovingCol) {
            break;
        }
    }
    return { firstMovingCol, lastMovingCol };
}


/***/ }),

/***/ 10852:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.moveColumns = exports.moveColumnByIndex = void 0;
function moveColumnByIndex(beans, fromIndex, toIndex) {
    beans.colMoves?.moveColumnByIndex(fromIndex, toIndex, 'api');
}
exports.moveColumnByIndex = moveColumnByIndex;
function moveColumns(beans, columnsToMoveKeys, toIndex) {
    beans.colMoves?.moveColumns(columnsToMoveKeys, toIndex, 'api');
}
exports.moveColumns = moveColumns;


/***/ }),

/***/ 64074:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnMoveModule = void 0;
const dragModule_1 = __webpack_require__(24388);
const version_1 = __webpack_require__(97205);
const column_moving_css_GENERATED_1 = __webpack_require__(9607);
const columnAnimationService_1 = __webpack_require__(19122);
const columnMoveApi_1 = __webpack_require__(10852);
const columnMoveService_1 = __webpack_require__(24067);
/**
 * @feature Columns -> Column Moving
 */
exports.ColumnMoveModule = {
    moduleName: 'ColumnMove',
    version: version_1.VERSION,
    beans: [columnMoveService_1.ColumnMoveService, columnAnimationService_1.ColumnAnimationService],
    apiFunctions: {
        moveColumnByIndex: columnMoveApi_1.moveColumnByIndex,
        moveColumns: columnMoveApi_1.moveColumns,
    },
    dependsOn: [dragModule_1.SharedDragAndDropModule],
    css: [column_moving_css_GENERATED_1.columnMovingCSS],
};


/***/ }),

/***/ 24067:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnMoveService = void 0;
const array_1 = __webpack_require__(79909);
const beanStub_1 = __webpack_require__(68731);
const dragAndDropService_1 = __webpack_require__(12903);
const agColumnGroup_1 = __webpack_require__(56908);
const logging_1 = __webpack_require__(47764);
const bodyDropTarget_1 = __webpack_require__(57912);
const columnMoveUtils_1 = __webpack_require__(23505);
const internalColumnMoveUtils_1 = __webpack_require__(45446);
var MoveDirection;
(function (MoveDirection) {
    MoveDirection[MoveDirection["LEFT"] = -1] = "LEFT";
    MoveDirection[MoveDirection["NONE"] = 0] = "NONE";
    MoveDirection[MoveDirection["RIGHT"] = 1] = "RIGHT";
})(MoveDirection || (MoveDirection = {}));
class ColumnMoveService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colMoves';
    }
    moveColumnByIndex(fromIndex, toIndex, source) {
        const gridColumns = this.beans.colModel.getCols();
        if (!gridColumns) {
            return;
        }
        const column = gridColumns[fromIndex];
        this.moveColumns([column], toIndex, source);
    }
    moveColumns(columnsToMoveKeys, toIndex, source, finished = true) {
        const { colModel, colAnimation, visibleCols, eventSvc } = this.beans;
        const gridColumns = colModel.getCols();
        if (!gridColumns) {
            return;
        }
        if (toIndex > gridColumns.length - columnsToMoveKeys.length) {
            // Trying to insert in invalid position
            (0, logging_1._warn)(30, { toIndex });
            return;
        }
        colAnimation?.start();
        // we want to pull all the columns out first and put them into an ordered list
        const movedColumns = colModel.getColsForKeys(columnsToMoveKeys);
        if (this.doesMovePassRules(movedColumns, toIndex)) {
            (0, array_1._moveInArray)(colModel.getCols(), movedColumns, toIndex);
            visibleCols.refresh(source);
            eventSvc.dispatchEvent({
                type: 'columnMoved',
                columns: movedColumns,
                column: movedColumns.length === 1 ? movedColumns[0] : null,
                toIndex,
                finished,
                source,
            });
        }
        colAnimation?.finish();
    }
    doesMovePassRules(columnsToMove, toIndex) {
        // make a copy of what the grid columns would look like after the move
        const proposedColumnOrder = this.getProposedColumnOrder(columnsToMove, toIndex);
        return this.doesOrderPassRules(proposedColumnOrder);
    }
    doesOrderPassRules(gridOrder) {
        const { colModel, gos } = this.beans;
        if (!(0, columnMoveUtils_1.doesMovePassMarryChildren)(gridOrder, colModel.getColTree())) {
            return false;
        }
        const doesMovePassLockedPositions = (proposedColumnOrder) => {
            const lockPositionToPlacement = (position) => {
                if (!position) {
                    return MoveDirection.NONE;
                }
                return position === 'left' || position === true ? MoveDirection.LEFT : MoveDirection.RIGHT;
            };
            const isRtl = gos.get('enableRtl');
            let lastPlacement = isRtl ? MoveDirection.RIGHT : MoveDirection.LEFT;
            let rulePassed = true;
            proposedColumnOrder.forEach((col) => {
                const placement = lockPositionToPlacement(col.getColDef().lockPosition);
                if (isRtl) {
                    if (placement > lastPlacement) {
                        // If placement goes up, we're not in the correct order
                        rulePassed = false;
                    }
                }
                else {
                    if (placement < lastPlacement) {
                        // If placement goes down, we're not in the correct order
                        rulePassed = false;
                    }
                }
                lastPlacement = placement;
            });
            return rulePassed;
        };
        if (!doesMovePassLockedPositions(gridOrder)) {
            return false;
        }
        return true;
    }
    getProposedColumnOrder(columnsToMove, toIndex) {
        const gridColumns = this.beans.colModel.getCols();
        const proposedColumnOrder = gridColumns.slice();
        (0, array_1._moveInArray)(proposedColumnOrder, columnsToMove, toIndex);
        return proposedColumnOrder;
    }
    createBodyDropTarget(pinned, dropContainer) {
        return new bodyDropTarget_1.BodyDropTarget(pinned, dropContainer);
    }
    moveHeader(hDirection, eGui, column, pinned, bean) {
        const { ctrlsSvc, gos, colModel, visibleCols, focusSvc } = this.beans;
        const rect = eGui.getBoundingClientRect();
        const left = rect.left;
        const isGroup = (0, agColumnGroup_1.isColumnGroup)(column);
        const width = isGroup ? rect.width : column.getActualWidth();
        const isLeft = (hDirection === 'left') !== gos.get('enableRtl');
        const xPosition = (0, internalColumnMoveUtils_1.normaliseX)({
            x: isLeft ? left - 20 : left + width + 20,
            pinned,
            fromKeyboard: true,
            gos,
            ctrlsSvc,
        });
        const headerPosition = focusSvc.focusedHeader;
        (0, internalColumnMoveUtils_1.attemptMoveColumns)({
            allMovingColumns: isGroup ? column.getLeafColumns() : [column],
            isFromHeader: true,
            fromLeft: hDirection === 'right',
            xPosition,
            pinned,
            fromEnter: false,
            fakeEvent: false,
            gos,
            colModel,
            colMoves: this,
            visibleCols,
            finished: true,
        });
        let targetColumn;
        if (isGroup) {
            const displayedLeafColumns = column.getDisplayedLeafColumns();
            targetColumn = isLeft ? displayedLeafColumns[0] : (0, array_1._last)(displayedLeafColumns);
        }
        else {
            targetColumn = column;
        }
        ctrlsSvc.getScrollFeature().ensureColumnVisible(targetColumn, 'auto');
        if ((!bean.isAlive() || gos.get('ensureDomOrder')) && headerPosition) {
            let restoreFocusColumn;
            if (isGroup) {
                const groupId = column.getGroupId();
                const leafCols = column.getLeafColumns();
                if (!leafCols.length) {
                    return;
                }
                const parent = leafCols[0].getParent();
                if (!parent) {
                    return;
                }
                restoreFocusColumn = findGroupWidthId(parent, groupId);
            }
            else {
                restoreFocusColumn = column;
            }
            if (restoreFocusColumn) {
                focusSvc.focusHeaderPosition({
                    headerPosition: {
                        ...headerPosition,
                        column: restoreFocusColumn,
                    },
                });
            }
        }
    }
    setDragSourceForHeader(eSource, column, displayName) {
        const { gos, colModel, dragAndDrop, visibleCols } = this.beans;
        let hideColumnOnExit = !gos.get('suppressDragLeaveHidesColumns');
        const isGroup = (0, agColumnGroup_1.isColumnGroup)(column);
        const columns = isGroup ? column.getProvidedColumnGroup().getLeafColumns() : [column];
        const getDragItem = isGroup
            ? () => createDragItemForGroup(column, visibleCols.allCols)
            : () => createDragItem(column);
        const dragSource = {
            type: dragAndDropService_1.DragSourceType.HeaderCell,
            eElement: eSource,
            getDefaultIconName: () => (hideColumnOnExit ? 'hide' : 'notAllowed'),
            getDragItem,
            dragItemName: displayName,
            onDragStarted: () => {
                hideColumnOnExit = !gos.get('suppressDragLeaveHidesColumns');
                (0, internalColumnMoveUtils_1.setColumnsMoving)(columns, true);
            },
            onDragStopped: () => (0, internalColumnMoveUtils_1.setColumnsMoving)(columns, false),
            onDragCancelled: () => (0, internalColumnMoveUtils_1.setColumnsMoving)(columns, false),
            onGridEnter: (dragItem) => {
                if (hideColumnOnExit) {
                    const { columns = [], visibleState } = dragItem ?? {};
                    const hasVisibleState = isGroup
                        ? (col) => !visibleState || visibleState[col.getColId()]
                        : () => true;
                    const unlockedColumns = columns.filter((col) => !col.getColDef().lockVisible && hasVisibleState(col));
                    colModel.setColsVisible(unlockedColumns, true, 'uiColumnMoved');
                }
            },
            onGridExit: (dragItem) => {
                if (hideColumnOnExit) {
                    const unlockedColumns = dragItem?.columns?.filter((col) => !col.getColDef().lockVisible) || [];
                    colModel.setColsVisible(unlockedColumns, false, 'uiColumnMoved');
                }
            },
        };
        dragAndDrop.addDragSource(dragSource, true);
        return dragSource;
    }
}
exports.ColumnMoveService = ColumnMoveService;
function findGroupWidthId(columnGroup, id) {
    while (columnGroup) {
        if (columnGroup.getGroupId() === id) {
            return columnGroup;
        }
        columnGroup = columnGroup.getParent();
    }
    return undefined;
}
function createDragItem(column) {
    const visibleState = {};
    visibleState[column.getId()] = column.isVisible();
    return {
        columns: [column],
        visibleState: visibleState,
        containerType: column.pinned,
    };
}
// when moving the columns, we want to move all the columns (contained within the DragItem) in this group in one go,
// and in the order they are currently in the screen.
function createDragItemForGroup(columnGroup, allCols) {
    const allColumnsOriginalOrder = columnGroup.getProvidedColumnGroup().getLeafColumns();
    // capture visible state, used when re-entering grid to dictate which columns should be visible
    const visibleState = {};
    allColumnsOriginalOrder.forEach((column) => (visibleState[column.getId()] = column.isVisible()));
    const allColumnsCurrentOrder = [];
    allCols.forEach((column) => {
        if (allColumnsOriginalOrder.indexOf(column) >= 0) {
            allColumnsCurrentOrder.push(column);
            (0, array_1._removeFromArray)(allColumnsOriginalOrder, column);
        }
    });
    // we are left with non-visible columns, stick these in at the end
    allColumnsOriginalOrder.forEach((column) => allColumnsCurrentOrder.push(column));
    const columnsInSplit = [];
    const columnGroupColumns = columnGroup.getLeafColumns();
    for (const col of allColumnsCurrentOrder) {
        if (columnGroupColumns.indexOf(col) !== -1) {
            columnsInSplit.push(col);
        }
    }
    // create and return dragItem
    return {
        columns: allColumnsCurrentOrder,
        columnsInSplit,
        visibleState: visibleState,
        containerType: columnsInSplit[0]?.pinned,
    };
}


/***/ }),

/***/ 23505:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.doesMovePassMarryChildren = exports.placeLockedColumns = void 0;
const columnFactoryUtils_1 = __webpack_require__(82716);
const agProvidedColumnGroup_1 = __webpack_require__(79409);
function placeLockedColumns(cols, gos) {
    const left = [];
    const normal = [];
    const right = [];
    cols.forEach((col) => {
        const position = col.getColDef().lockPosition;
        if (position === 'right') {
            right.push(col);
        }
        else if (position === 'left' || position === true) {
            left.push(col);
        }
        else {
            normal.push(col);
        }
    });
    const isRtl = gos.get('enableRtl');
    if (isRtl) {
        return [...right, ...normal, ...left];
    }
    return [...left, ...normal, ...right];
}
exports.placeLockedColumns = placeLockedColumns;
function doesMovePassMarryChildren(allColumnsCopy, gridBalancedTree) {
    let rulePassed = true;
    (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, gridBalancedTree, (child) => {
        if (!(0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
            return;
        }
        const columnGroup = child;
        const colGroupDef = columnGroup.getColGroupDef();
        const marryChildren = colGroupDef && colGroupDef.marryChildren;
        if (!marryChildren) {
            return;
        }
        const newIndexes = [];
        columnGroup.getLeafColumns().forEach((col) => {
            const newColIndex = allColumnsCopy.indexOf(col);
            newIndexes.push(newColIndex);
        });
        // eslint-disable-next-line prefer-spread
        const maxIndex = Math.max.apply(Math, newIndexes);
        // eslint-disable-next-line prefer-spread
        const minIndex = Math.min.apply(Math, newIndexes);
        // spread is how far the first column in this group is away from the last column
        const spread = maxIndex - minIndex;
        const maxSpread = columnGroup.getLeafColumns().length - 1;
        // if the columns
        if (spread > maxSpread) {
            rulePassed = false;
        }
        // console.log(`maxIndex = ${maxIndex}, minIndex = ${minIndex}, spread = ${spread}, maxSpread = ${maxSpread}, fail = ${spread > (count-1)}`)
        // console.log(allColumnsCopy.map( col => col.getColDef().field).join(','));
    });
    return rulePassed;
}
exports.doesMovePassMarryChildren = doesMovePassMarryChildren;


/***/ }),

/***/ 45446:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.setColumnsMoving = exports.normaliseX = exports.attemptMoveColumns = exports.getBestColumnMoveIndexFromXPosition = void 0;
const array_1 = __webpack_require__(79909);
// returns the provided cols sorted in same order as they appear in this.cols, eg if this.cols
// contains [a,b,c,d,e] and col passed is [e,a] then the passed cols are sorted into [a,e]
function sortColsLikeCols(colsList, cols) {
    if (!cols || cols.length <= 1) {
        return;
    }
    const notAllColsPresent = cols.filter((c) => colsList.indexOf(c) < 0).length > 0;
    if (notAllColsPresent) {
        return;
    }
    cols.sort((a, b) => {
        const indexA = colsList.indexOf(a);
        const indexB = colsList.indexOf(b);
        return indexA - indexB;
    });
}
/**
 * If moving all of a groups visible columns, then adds the hidden columns
 * If marryChildren is true, then brings all the siblings.
 */
function getColsToMove(allMovingColumns) {
    // If the columns we're dragging are the only visible columns of their group, move the hidden ones too
    const newCols = [...allMovingColumns];
    allMovingColumns.forEach((col) => {
        let movingGroup = null;
        let parent = col.getParent();
        while (parent != null && parent.getDisplayedLeafColumns().length === 1) {
            movingGroup = parent;
            parent = parent.getParent();
        }
        if (movingGroup != null) {
            const isMarryChildren = !!movingGroup.getColGroupDef()?.marryChildren;
            const columnsToMove = isMarryChildren
                ? // when marry children is true, we also have to move hidden
                    // columns within the group, so grab them from the `providedColumnGroup`
                    movingGroup.getProvidedColumnGroup().getLeafColumns()
                : movingGroup.getLeafColumns();
            columnsToMove.forEach((newCol) => {
                if (!newCols.includes(newCol)) {
                    newCols.push(newCol);
                }
            });
        }
    });
    return newCols;
}
function getLowestFragMove(validMoves, allMovingColumnsOrdered, colMoves, visibleCols) {
    // From when we find a move that passes all the rules
    // Remember what that move would look like in terms of displayed cols
    // keep going with further moves until we find a different result in displayed output
    // In this way potentialMoves contains all potential moves over 'hidden' columns
    const displayedCols = visibleCols.allCols;
    let lowestFragMove = null;
    let targetOrder = null;
    for (let i = 0; i < validMoves.length; i++) {
        const move = validMoves[i];
        const order = colMoves.getProposedColumnOrder(allMovingColumnsOrdered, move);
        if (!colMoves.doesOrderPassRules(order)) {
            continue;
        }
        const displayedOrder = order.filter((col) => displayedCols.includes(col));
        if (targetOrder === null) {
            targetOrder = displayedOrder;
        }
        else if (!(0, array_1._areEqual)(displayedOrder, targetOrder)) {
            break; // Stop looking for potential moves if the displayed result changes from the target
        }
        const fragCount = groupFragCount(order);
        if (lowestFragMove === null || fragCount < lowestFragMove.fragCount) {
            lowestFragMove = { move, fragCount };
        }
    }
    return lowestFragMove;
}
function getBestColumnMoveIndexFromXPosition(params) {
    const { isFromHeader, fromLeft, xPosition, fromEnter, fakeEvent, pinned, gos, colModel, colMoves, visibleCols } = params;
    let { allMovingColumns } = params;
    if (isFromHeader) {
        // if moving the only visible col of the group, bring siblings and hidden cols
        allMovingColumns = getColsToMove(allMovingColumns);
    }
    // it is important to sort the moving columns as they are in grid columns, as the list of moving columns
    // could themselves be part of 'married children' groups, which means we need to maintain the order within
    // the moving list.
    const allMovingColumnsOrdered = allMovingColumns.slice();
    sortColsLikeCols(colModel.getCols(), allMovingColumnsOrdered);
    const validMoves = calculateValidMoves({
        movingCols: allMovingColumnsOrdered,
        draggingRight: fromLeft,
        xPosition,
        pinned,
        gos,
        colModel,
        visibleCols,
    });
    // if cols are not adjacent, then this returns null. when moving, we constrain the direction of the move
    // (ie left or right) to the mouse direction. however
    const oldIndex = calculateOldIndex(allMovingColumnsOrdered, colModel);
    if (validMoves.length === 0) {
        return;
    }
    const firstValidMove = validMoves[0];
    // the two check below stop an error when the user grabs a group my a middle column, then
    // it is possible the mouse pointer is to the right of a column while been dragged left.
    // so we need to make sure that the mouse pointer is actually left of the left most column
    // if moving left, and right of the right most column if moving right
    // we check 'fromEnter' below so we move the column to the new spot if the mouse is coming from
    // outside the grid, eg if the column is moving from side panel, mouse is moving left, then we should
    // place the column to the RHS even if the mouse is moving left and the column is already on
    // the LHS. otherwise we stick to the rule described above.
    // don't consider 'fromEnter' when dragging header cells, otherwise group can jump to opposite direction of drag
    const constrainDirection = oldIndex !== null && (isFromHeader || !fromEnter);
    // if the event was faked by a change in column pin state, then the original location of the column
    // is not reliable for dictating where the column may now be placed.
    if (constrainDirection && !fakeEvent) {
        // only allow left drag if this column is moving left
        if (!fromLeft && firstValidMove >= oldIndex) {
            return;
        }
        // only allow right drag if this column is moving right
        if (fromLeft && firstValidMove <= oldIndex) {
            return;
        }
    }
    const lowestFragMove = getLowestFragMove(validMoves, allMovingColumnsOrdered, colMoves, visibleCols);
    if (!lowestFragMove) {
        // No valid moves found
        return;
    }
    const toIndex = lowestFragMove.move;
    if (toIndex > colModel.getCols().length - allMovingColumnsOrdered.length) {
        return;
    }
    return { columns: allMovingColumnsOrdered, toIndex };
}
exports.getBestColumnMoveIndexFromXPosition = getBestColumnMoveIndexFromXPosition;
function attemptMoveColumns(params) {
    const { columns, toIndex } = getBestColumnMoveIndexFromXPosition(params) || {};
    const { finished, colMoves } = params;
    if (!columns || toIndex == null) {
        return null;
    }
    colMoves.moveColumns(columns, toIndex, 'uiColumnMoved', finished);
    return finished ? null : { columns, toIndex };
}
exports.attemptMoveColumns = attemptMoveColumns;
// returns the index of the first column in the list ONLY if the cols are all beside
// each other. if the cols are not beside each other, then returns null
function calculateOldIndex(movingCols, colModel) {
    const gridCols = colModel.getCols();
    const indexes = movingCols.map((col) => gridCols.indexOf(col)).sort((a, b) => a - b);
    const firstIndex = indexes[0];
    const lastIndex = (0, array_1._last)(indexes);
    const spread = lastIndex - firstIndex;
    const gapsExist = spread !== indexes.length - 1;
    return gapsExist ? null : firstIndex;
}
// A measure of how fragmented in terms of groups an order of columns is
function groupFragCount(columns) {
    function parents(col) {
        const result = [];
        let parent = col.getOriginalParent();
        while (parent != null) {
            result.push(parent);
            parent = parent.getOriginalParent();
        }
        return result;
    }
    let count = 0;
    for (let i = 0; i < columns.length - 1; i++) {
        let a = parents(columns[i]);
        let b = parents(columns[i + 1]);
        // iterate over the longest one
        [a, b] = a.length > b.length ? [a, b] : [b, a];
        a.forEach((parent) => {
            if (b.indexOf(parent) === -1) {
                count++; // More fragmented if other column doesn't share the parent
            }
        });
    }
    return count;
}
function getDisplayedColumns(visibleCols, type) {
    switch (type) {
        case 'left':
            return visibleCols.leftCols;
        case 'right':
            return visibleCols.rightCols;
        default:
            return visibleCols.centerCols;
    }
}
function calculateValidMoves(params) {
    const { movingCols, draggingRight, xPosition, pinned, gos, colModel, visibleCols } = params;
    const isMoveBlocked = gos.get('suppressMovableColumns') || movingCols.some((col) => col.getColDef().suppressMovable);
    if (isMoveBlocked) {
        return [];
    }
    // this is the list of cols on the screen, so it's these we use when comparing the x mouse position
    const allDisplayedCols = getDisplayedColumns(visibleCols, pinned);
    // but this list is the list of all cols, when we move a col it's the index within this list that gets used,
    // so the result we return has to be and index location for this list
    const allGridCols = colModel.getCols();
    const movingDisplayedCols = allDisplayedCols.filter((col) => movingCols.includes(col));
    const otherDisplayedCols = allDisplayedCols.filter((col) => !movingCols.includes(col));
    const otherGridCols = allGridCols.filter((col) => !movingCols.includes(col));
    // work out how many DISPLAYED columns fit before the 'x' position. this gives us the displayIndex.
    // for example, if cols are a,b,c,d and we find a,b fit before 'x', then we want to place the moving
    // col between b and c (so that it is under the mouse position).
    let displayIndex = 0;
    let availableWidth = xPosition;
    // if we are dragging right, then the columns will be to the left of the mouse, so we also want to
    // include the width of the moving columns
    if (draggingRight) {
        let widthOfMovingDisplayedCols = 0;
        movingDisplayedCols.forEach((col) => (widthOfMovingDisplayedCols += col.getActualWidth()));
        availableWidth -= widthOfMovingDisplayedCols;
    }
    if (availableWidth > 0) {
        // now count how many of the displayed columns will fit to the left
        for (let i = 0; i < otherDisplayedCols.length; i++) {
            const col = otherDisplayedCols[i];
            availableWidth -= col.getActualWidth();
            if (availableWidth < 0) {
                break;
            }
            displayIndex++;
        }
        // trial and error, if going right, we adjust by one, i didn't manage to quantify why, but it works
        if (draggingRight) {
            displayIndex++;
        }
    }
    // the display index is with respect to all the showing columns, however when we move, it's with
    // respect to all grid columns, so we need to translate from display index to grid index
    let firstValidMove;
    if (displayIndex > 0) {
        const leftColumn = otherDisplayedCols[displayIndex - 1];
        firstValidMove = otherGridCols.indexOf(leftColumn) + 1;
    }
    else {
        firstValidMove = otherGridCols.indexOf(otherDisplayedCols[0]);
        if (firstValidMove === -1) {
            firstValidMove = 0;
        }
    }
    const validMoves = [firstValidMove];
    const numberComparator = (a, b) => a - b;
    // add in other valid moves due to hidden columns and married children. for example, a particular
    // move might break a group that has married children (so move isn't valid), however there could
    // be hidden columns (not displayed) that we could jump over to make the move valid. because
    // they are hidden, user doesn't see any different, however it allows moves that would otherwise
    // not work. for example imagine a group with 9 columns and all columns are hidden except the
    // middle one (so 4 hidden to left, 4 hidden to right), then when moving 'firstValidMove' will
    // be relative to the not-shown column, however we need to consider the move jumping over all the
    // hidden children. if we didn't do this, then if the group just described was at the end (RHS) of the
    // grid, there would be no way to put a column after it (as the grid would only consider beside the
    // visible column, which would fail valid move rules).
    if (draggingRight) {
        // if dragging right, then we add all the additional moves to the right. so in other words
        // if the next move is not valid, find the next move to the right that is valid.
        let pointer = firstValidMove + 1;
        const lastIndex = allGridCols.length - 1;
        while (pointer <= lastIndex) {
            validMoves.push(pointer);
            pointer++;
        }
        // adding columns here means the order is now messed up
        validMoves.sort(numberComparator);
    }
    else {
        // if dragging left we do the reverse of dragging right, we add in all the valid moves to the
        // left. however we also have to consider moves to the right for all hidden columns first.
        // (this logic is hard to reason with, it was worked out with trial and error,
        // more observation rather than science).
        // add moves to the right
        let pointer = firstValidMove;
        const lastIndex = allGridCols.length - 1;
        let displacedCol = allGridCols[pointer];
        // takes into account visible=false and group=closed, ie it is not displayed
        while (pointer <= lastIndex && allDisplayedCols.indexOf(displacedCol) < 0) {
            pointer++;
            validMoves.push(pointer);
            displacedCol = allGridCols[pointer];
        }
        // add moves to the left
        pointer = firstValidMove - 1;
        const firstDisplayIndex = 0;
        while (pointer >= firstDisplayIndex) {
            validMoves.push(pointer);
            pointer--;
        }
        // adding columns here means the order is now messed up
        validMoves.sort(numberComparator).reverse();
    }
    return validMoves;
}
function normaliseX(params) {
    const { pinned, fromKeyboard, gos, ctrlsSvc, useHeaderRow, skipScrollPadding } = params;
    let eViewport = ctrlsSvc.getHeaderRowContainerCtrl(pinned)?.eViewport;
    let { x } = params;
    if (!eViewport) {
        return 0;
    }
    if (fromKeyboard) {
        x -= eViewport.getBoundingClientRect().left;
    }
    // flip the coordinate if doing RTL
    if (gos.get('enableRtl')) {
        if (useHeaderRow) {
            eViewport = eViewport.querySelector('.ag-header-row');
        }
        x = eViewport.clientWidth - x;
    }
    // adjust for scroll only if centre container (the pinned containers don't scroll)
    if (pinned == null && !skipScrollPadding) {
        x += ctrlsSvc.get('center').getCenterViewportScrollLeft();
    }
    return x;
}
exports.normaliseX = normaliseX;
function setColumnsMoving(columns, isMoving) {
    for (const column of columns) {
        column.moving = isMoving;
        column.dispatchColEvent('movingChanged', 'uiColumnMoved');
    }
}
exports.setColumnsMoving = setColumnsMoving;


/***/ }),

/***/ 19686:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.setColumnWidths = void 0;
function setColumnWidths(beans, columnWidths, finished = true, source = 'api') {
    beans.colResize?.setColumnWidths(columnWidths, false, finished, source);
}
exports.setColumnWidths = setColumnWidths;


/***/ }),

/***/ 96924:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnResizeModule = void 0;
const dragModule_1 = __webpack_require__(24388);
const autoWidthModule_1 = __webpack_require__(40447);
const version_1 = __webpack_require__(97205);
const columnResizeApi_1 = __webpack_require__(19686);
const columnResizeService_1 = __webpack_require__(69677);
/**
 * @feature Columns -> Column Sizing
 */
exports.ColumnResizeModule = {
    moduleName: 'ColumnResize',
    version: version_1.VERSION,
    beans: [columnResizeService_1.ColumnResizeService],
    apiFunctions: {
        setColumnWidths: columnResizeApi_1.setColumnWidths,
    },
    dependsOn: [dragModule_1.HorizontalResizeModule, autoWidthModule_1.AutoWidthModule],
};


/***/ }),

/***/ 69677:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnResizeService = void 0;
const columnEventUtils_1 = __webpack_require__(72934);
const beanStub_1 = __webpack_require__(68731);
const logging_1 = __webpack_require__(47764);
const groupResizeFeature_1 = __webpack_require__(79033);
const resizeFeature_1 = __webpack_require__(67438);
class ColumnResizeService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colResize';
    }
    setColumnWidths(columnWidths, shiftKey, // @takeFromAdjacent - if user has 'shift' pressed, then pixels are taken from adjacent column
    finished, // @finished - ends up in the event, tells the user if more events are to come
    source) {
        const sets = [];
        const { colModel, gos, visibleCols } = this.beans;
        columnWidths.forEach((columnWidth) => {
            const col = colModel.getColDefCol(columnWidth.key) || colModel.getCol(columnWidth.key);
            if (!col) {
                return;
            }
            sets.push({
                width: columnWidth.newWidth,
                ratios: [1],
                columns: [col],
            });
            // if user wants to do shift resize by default, then we invert the shift operation
            const defaultIsShift = gos.get('colResizeDefault') === 'shift';
            if (defaultIsShift) {
                shiftKey = !shiftKey;
            }
            if (shiftKey) {
                const otherCol = visibleCols.getColAfter(col);
                if (!otherCol) {
                    return;
                }
                const widthDiff = col.getActualWidth() - columnWidth.newWidth;
                const otherColWidth = otherCol.getActualWidth() + widthDiff;
                sets.push({
                    width: otherColWidth,
                    ratios: [1],
                    columns: [otherCol],
                });
            }
        });
        if (sets.length === 0) {
            return;
        }
        this.resizeColumnSets({
            resizeSets: sets,
            finished,
            source,
        });
    }
    // method takes sets of columns and resizes them. either all sets will be resized, or nothing
    // be resized. this is used for example when user tries to resize a group and holds shift key,
    // then both the current group (grows), and the adjacent group (shrinks), will get resized,
    // so that's two sets for this method.
    resizeColumnSets(params) {
        const { resizeSets, finished, source } = params;
        const passMinMaxCheck = !resizeSets || resizeSets.every((columnResizeSet) => checkMinAndMaxWidthsForSet(columnResizeSet));
        if (!passMinMaxCheck) {
            // even though we are not going to resize beyond min/max size, we still need to dispatch event when finished
            if (finished) {
                const columns = resizeSets && resizeSets.length > 0 ? resizeSets[0].columns : null;
                (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, columns, finished, source);
            }
            return; // don't resize!
        }
        const changedCols = [];
        const allResizedCols = [];
        resizeSets.forEach((set) => {
            const { width, columns, ratios } = set;
            // keep track of pixels used, and last column gets the remaining,
            // to cater for rounding errors, and min width adjustments
            const newWidths = {};
            const finishedCols = {};
            columns.forEach((col) => allResizedCols.push(col));
            // the loop below goes through each col. if a col exceeds it's min/max width,
            // it then gets set to its min/max width and the column is removed marked as 'finished'
            // and the calculation is done again leaving this column out. take for example columns
            // {A, width: 50, maxWidth: 100}
            // {B, width: 50}
            // {C, width: 50}
            // and then the set is set to width 600 - on the first pass the grid tries to set each column
            // to 200. it checks A and sees 200 > 100 and so sets the width to 100. col A is then marked
            // as 'finished' and the calculation is done again with the remaining cols B and C, which end up
            // splitting the remaining 500 pixels.
            let finishedColsGrew = true;
            let loopCount = 0;
            while (finishedColsGrew) {
                loopCount++;
                if (loopCount > 1000) {
                    // this should never happen, but in the future, someone might introduce a bug here,
                    // so we stop the browser from hanging and report bug properly
                    (0, logging_1._error)(31);
                    break;
                }
                finishedColsGrew = false;
                const subsetCols = [];
                let subsetRatioTotal = 0;
                let pixelsToDistribute = width;
                columns.forEach((col, index) => {
                    const thisColFinished = finishedCols[col.getId()];
                    if (thisColFinished) {
                        pixelsToDistribute -= newWidths[col.getId()];
                    }
                    else {
                        subsetCols.push(col);
                        const ratioThisCol = ratios[index];
                        subsetRatioTotal += ratioThisCol;
                    }
                });
                // because we are not using all of the ratios (cols can be missing),
                // we scale the ratio. if all columns are included, then subsetRatioTotal=1,
                // and so the ratioScale will be 1.
                const ratioScale = 1 / subsetRatioTotal;
                subsetCols.forEach((col, index) => {
                    const lastCol = index === subsetCols.length - 1;
                    let colNewWidth;
                    if (lastCol) {
                        colNewWidth = pixelsToDistribute;
                    }
                    else {
                        colNewWidth = Math.round(ratios[index] * width * ratioScale);
                        pixelsToDistribute -= colNewWidth;
                    }
                    const minWidth = col.getMinWidth();
                    const maxWidth = col.getMaxWidth();
                    if (colNewWidth < minWidth) {
                        colNewWidth = minWidth;
                        finishedCols[col.getId()] = true;
                        finishedColsGrew = true;
                    }
                    else if (maxWidth > 0 && colNewWidth > maxWidth) {
                        colNewWidth = maxWidth;
                        finishedCols[col.getId()] = true;
                        finishedColsGrew = true;
                    }
                    newWidths[col.getId()] = colNewWidth;
                });
            }
            columns.forEach((col) => {
                const newWidth = newWidths[col.getId()];
                const actualWidth = col.getActualWidth();
                if (actualWidth !== newWidth) {
                    col.setActualWidth(newWidth, source);
                    changedCols.push(col);
                }
            });
        });
        // if no cols changed, then no need to update more or send event.
        const atLeastOneColChanged = changedCols.length > 0;
        let flexedCols = [];
        if (atLeastOneColChanged) {
            const { colFlex, visibleCols, colViewport } = this.beans;
            flexedCols =
                colFlex?.refreshFlexedColumns({
                    resizingCols: allResizedCols,
                    skipSetLeft: true,
                }) ?? [];
            visibleCols.setLeftValues(source);
            visibleCols.updateBodyWidths();
            colViewport.checkViewportColumns();
        }
        // check for change first, to avoid unnecessary firing of events
        // however we always dispatch 'finished' events. this is important
        // when groups are resized, as if the group is changing slowly,
        // eg 1 pixel at a time, then each change will dispatch change events
        // in all the columns in the group, but only one with get the pixel.
        const colsForEvent = allResizedCols.concat(flexedCols);
        if (atLeastOneColChanged || finished) {
            (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, colsForEvent, finished, source, flexedCols);
        }
    }
    resizeHeader(column, delta, shiftKey) {
        if (!column.isResizable()) {
            return;
        }
        const actualWidth = column.getActualWidth();
        const minWidth = column.getMinWidth();
        const maxWidth = column.getMaxWidth();
        const newWidth = Math.min(Math.max(actualWidth + delta, minWidth), maxWidth);
        this.setColumnWidths([{ key: column, newWidth }], shiftKey, true, 'uiColumnResized');
    }
    createResizeFeature(pinned, column, eResize, comp, ctrl) {
        return new resizeFeature_1.ResizeFeature(pinned, column, eResize, comp, ctrl);
    }
    createGroupResizeFeature(comp, eResize, pinned, columnGroup) {
        return new groupResizeFeature_1.GroupResizeFeature(comp, eResize, pinned, columnGroup);
    }
}
exports.ColumnResizeService = ColumnResizeService;
function checkMinAndMaxWidthsForSet(columnResizeSet) {
    const { columns, width } = columnResizeSet;
    // every col has a min width, so sum them all up and see if we have enough room
    // for all the min widths
    let minWidthAccumulated = 0;
    let maxWidthAccumulated = 0;
    let maxWidthActive = true;
    columns.forEach((col) => {
        const minWidth = col.getMinWidth();
        minWidthAccumulated += minWidth || 0;
        const maxWidth = col.getMaxWidth();
        if (maxWidth > 0) {
            maxWidthAccumulated += maxWidth;
        }
        else {
            // if at least one columns has no max width, it means the group of columns
            // then has no max width, as at least one column can take as much width as possible
            maxWidthActive = false;
        }
    });
    const minWidthPasses = width >= minWidthAccumulated;
    const maxWidthPasses = !maxWidthActive || width <= maxWidthAccumulated;
    return minWidthPasses && maxWidthPasses;
}


/***/ }),

/***/ 79033:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GroupResizeFeature = void 0;
const beanStub_1 = __webpack_require__(68731);
class GroupResizeFeature extends beanStub_1.BeanStub {
    constructor(comp, eResize, pinned, columnGroup) {
        super();
        this.comp = comp;
        this.eResize = eResize;
        this.pinned = pinned;
        this.columnGroup = columnGroup;
    }
    postConstruct() {
        if (!this.columnGroup.isResizable()) {
            this.comp.setResizableDisplayed(false);
            return;
        }
        const { horizontalResizeSvc, gos, colAutosize } = this.beans;
        const finishedWithResizeFunc = horizontalResizeSvc.addResizeBar({
            eResizeBar: this.eResize,
            onResizeStart: this.onResizeStart.bind(this),
            onResizing: this.onResizing.bind(this, false),
            onResizeEnd: this.onResizing.bind(this, true),
        });
        this.addDestroyFunc(finishedWithResizeFunc);
        if (!gos.get('suppressAutoSize') && colAutosize) {
            this.addDestroyFunc(colAutosize.addColumnGroupResize(this.eResize, this.columnGroup, () => this.resizeLeafColumnsToFit('uiColumnResized')));
        }
    }
    onResizeStart(shiftKey) {
        const { columnsToResize, resizeStartWidth, resizeRatios, groupAfterColumns, groupAfterStartWidth, groupAfterRatios, } = this.getInitialValues(shiftKey);
        this.resizeCols = columnsToResize;
        this.resizeStartWidth = resizeStartWidth;
        this.resizeRatios = resizeRatios;
        this.resizeTakeFromCols = groupAfterColumns;
        this.resizeTakeFromStartWidth = groupAfterStartWidth;
        this.resizeTakeFromRatios = groupAfterRatios;
        this.toggleColumnResizing(true);
    }
    onResizing(finished, resizeAmount, source = 'uiColumnResized') {
        const resizeAmountNormalised = this.normaliseDragChange(resizeAmount);
        const width = this.resizeStartWidth + resizeAmountNormalised;
        this.resizeColumnsFromLocalValues(width, source, finished);
    }
    getInitialValues(shiftKey) {
        const getInitialSizeOfColumns = (columns) => columns.reduce((totalWidth, column) => totalWidth + column.getActualWidth(), 0);
        const getSizeRatiosOfColumns = (columns, initialSizeOfColumns) => columns.map((column) => column.getActualWidth() / initialSizeOfColumns);
        const columnsToResize = this.getColumnsToResize();
        const resizeStartWidth = getInitialSizeOfColumns(columnsToResize);
        const resizeRatios = getSizeRatiosOfColumns(columnsToResize, resizeStartWidth);
        const columnSizeAndRatios = {
            columnsToResize,
            resizeStartWidth,
            resizeRatios,
        };
        let groupAfter = null;
        if (shiftKey) {
            groupAfter = this.beans.colGroupSvc?.getGroupAtDirection(this.columnGroup, 'After') ?? null;
        }
        if (groupAfter) {
            const takeFromLeafCols = groupAfter.getDisplayedLeafColumns();
            const groupAfterColumns = (columnSizeAndRatios.groupAfterColumns = takeFromLeafCols.filter((col) => col.isResizable()));
            const groupAfterStartWidth = (columnSizeAndRatios.groupAfterStartWidth =
                getInitialSizeOfColumns(groupAfterColumns));
            columnSizeAndRatios.groupAfterRatios = getSizeRatiosOfColumns(groupAfterColumns, groupAfterStartWidth);
        }
        else {
            columnSizeAndRatios.groupAfterColumns = undefined;
            columnSizeAndRatios.groupAfterStartWidth = undefined;
            columnSizeAndRatios.groupAfterRatios = undefined;
        }
        return columnSizeAndRatios;
    }
    resizeLeafColumnsToFit(source) {
        const preferredSize = this.beans.autoWidthCalc.getPreferredWidthForColumnGroup(this.columnGroup);
        const initialValues = this.getInitialValues();
        if (preferredSize > initialValues.resizeStartWidth) {
            this.resizeColumns(initialValues, preferredSize, source, true);
        }
    }
    resizeColumnsFromLocalValues(totalWidth, source, finished = true) {
        if (!this.resizeCols || !this.resizeRatios) {
            return;
        }
        const initialValues = {
            columnsToResize: this.resizeCols,
            resizeStartWidth: this.resizeStartWidth,
            resizeRatios: this.resizeRatios,
            groupAfterColumns: this.resizeTakeFromCols,
            groupAfterStartWidth: this.resizeTakeFromStartWidth,
            groupAfterRatios: this.resizeTakeFromRatios,
        };
        this.resizeColumns(initialValues, totalWidth, source, finished);
    }
    resizeColumns(initialValues, totalWidth, source, finished = true) {
        const { columnsToResize, resizeStartWidth, resizeRatios, groupAfterColumns, groupAfterStartWidth, groupAfterRatios, } = initialValues;
        const resizeSets = [];
        resizeSets.push({
            columns: columnsToResize,
            ratios: resizeRatios,
            width: totalWidth,
        });
        if (groupAfterColumns) {
            const diff = totalWidth - resizeStartWidth;
            resizeSets.push({
                columns: groupAfterColumns,
                ratios: groupAfterRatios,
                width: groupAfterStartWidth - diff,
            });
        }
        this.beans.colResize?.resizeColumnSets({
            resizeSets,
            finished,
            source: source,
        });
        if (finished) {
            this.toggleColumnResizing(false);
        }
    }
    toggleColumnResizing(resizing) {
        this.comp.toggleCss('ag-column-resizing', resizing);
    }
    getColumnsToResize() {
        const leafCols = this.columnGroup.getDisplayedLeafColumns();
        return leafCols.filter((col) => col.isResizable());
    }
    // optionally inverts the drag, depending on pinned and RTL
    // note - this method is duplicated in RenderedHeaderCell - should refactor out?
    normaliseDragChange(dragChange) {
        let result = dragChange;
        if (this.gos.get('enableRtl')) {
            // for RTL, dragging left makes the col bigger, except when pinning left
            if (this.pinned !== 'left') {
                result *= -1;
            }
        }
        else if (this.pinned === 'right') {
            // for LTR (ie normal), dragging left makes the col smaller, except when pinning right
            result *= -1;
        }
        return result;
    }
    destroy() {
        super.destroy();
        this.resizeCols = undefined;
        this.resizeRatios = undefined;
        this.resizeTakeFromCols = undefined;
        this.resizeTakeFromRatios = undefined;
    }
}
exports.GroupResizeFeature = GroupResizeFeature;


/***/ }),

/***/ 67438:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ResizeFeature = void 0;
const dom_1 = __webpack_require__(1956);
const beanStub_1 = __webpack_require__(68731);
class ResizeFeature extends beanStub_1.BeanStub {
    constructor(pinned, column, eResize, comp, ctrl) {
        super();
        this.pinned = pinned;
        this.column = column;
        this.eResize = eResize;
        this.comp = comp;
        this.ctrl = ctrl;
    }
    postConstruct() {
        const destroyResizeFuncs = [];
        let canResize;
        let canAutosize;
        const addResize = () => {
            (0, dom_1._setDisplayed)(this.eResize, canResize);
            if (!canResize) {
                return;
            }
            const { horizontalResizeSvc, colAutosize } = this.beans;
            const finishedWithResizeFunc = horizontalResizeSvc.addResizeBar({
                eResizeBar: this.eResize,
                onResizeStart: this.onResizeStart.bind(this),
                onResizing: this.onResizing.bind(this, false),
                onResizeEnd: this.onResizing.bind(this, true),
            });
            destroyResizeFuncs.push(finishedWithResizeFunc);
            if (canAutosize && colAutosize) {
                destroyResizeFuncs.push(colAutosize.addColumnAutosize(this.eResize, this.column));
            }
        };
        const removeResize = () => {
            destroyResizeFuncs.forEach((f) => f());
            destroyResizeFuncs.length = 0;
        };
        const refresh = () => {
            const resize = this.column.isResizable();
            const autoSize = !this.gos.get('suppressAutoSize') && !this.column.getColDef().suppressAutoSize;
            const propertyChange = resize !== canResize || autoSize !== canAutosize;
            if (propertyChange) {
                canResize = resize;
                canAutosize = autoSize;
                removeResize();
                addResize();
            }
        };
        refresh();
        this.addDestroyFunc(removeResize);
        this.ctrl.setRefreshFunction('resize', refresh);
    }
    onResizing(finished, resizeAmount) {
        const { column: key, lastResizeAmount, resizeStartWidth, beans } = this;
        const resizeAmountNormalised = this.normaliseResizeAmount(resizeAmount);
        const newWidth = resizeStartWidth + resizeAmountNormalised;
        const columnWidths = [{ key, newWidth }];
        const { pinnedCols, ctrlsSvc, colResize } = beans;
        if (this.column.getPinned()) {
            const leftWidth = pinnedCols?.leftWidth ?? 0;
            const rightWidth = pinnedCols?.rightWidth ?? 0;
            const bodyWidth = (0, dom_1._getInnerWidth)(ctrlsSvc.getGridBodyCtrl().eBodyViewport) - 50;
            if (leftWidth + rightWidth + (resizeAmountNormalised - lastResizeAmount) > bodyWidth) {
                return;
            }
        }
        this.lastResizeAmount = resizeAmountNormalised;
        colResize?.setColumnWidths(columnWidths, this.resizeWithShiftKey, finished, 'uiColumnResized');
        if (finished) {
            this.toggleColumnResizing(false);
        }
    }
    onResizeStart(shiftKey) {
        this.resizeStartWidth = this.column.getActualWidth();
        this.lastResizeAmount = 0;
        this.resizeWithShiftKey = shiftKey;
        this.toggleColumnResizing(true);
    }
    toggleColumnResizing(resizing) {
        this.column.resizing = resizing;
        this.comp.toggleCss('ag-column-resizing', resizing);
    }
    // optionally inverts the drag, depending on pinned and RTL
    // note - this method is duplicated in RenderedHeaderGroupCell - should refactor out?
    normaliseResizeAmount(dragChange) {
        let result = dragChange;
        const notPinningLeft = this.pinned !== 'left';
        const pinningRight = this.pinned === 'right';
        if (this.gos.get('enableRtl')) {
            // for RTL, dragging left makes the col bigger, except when pinning left
            if (notPinningLeft) {
                result *= -1;
            }
        }
        else {
            // for LTR (ie normal), dragging left makes the col smaller, except when pinning right
            if (pinningRight) {
                result *= -1;
            }
        }
        return result;
    }
}
exports.ResizeFeature = ResizeFeature;


/***/ }),

/***/ 73600:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseColsService = void 0;
const array_1 = __webpack_require__(79909);
const generic_1 = __webpack_require__(89097);
const beanStub_1 = __webpack_require__(68731);
const columnEventUtils_1 = __webpack_require__(72934);
class BaseColsService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.dispatchColumnChangedEvent = columnEventUtils_1.dispatchColumnChangedEvent;
        this.columns = [];
        this.columnIndexMap = {};
        this.updateIndexMap = () => {
            this.columnIndexMap = {};
            this.columns.forEach((col, index) => (this.columnIndexMap[col.getId()] = index));
        };
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.aggFuncSvc = beans.aggFuncSvc;
        this.visibleCols = beans.visibleCols;
        this.groupHierarchCols = beans.groupHierarchyColSvc;
    }
    sortColumns(compareFn) {
        const { groupHierarchCols } = this;
        this.columns.sort((a, b) => groupHierarchCols?.compareVirtualColumns(a, b) ?? compareFn(a, b));
        this.updateIndexMap();
    }
    setColumns(colKeys, source) {
        this.setColList(colKeys, this.columns, this.eventName, true, true, this.columnProcessors.set, source);
    }
    addColumns(colKeys, source) {
        this.updateColList(colKeys, this.columns, true, true, this.columnProcessors.add, this.eventName, source);
    }
    removeColumns(colKeys, source) {
        this.updateColList(colKeys, this.columns, false, true, this.columnProcessors.remove, this.eventName, source);
    }
    getColumnIndex(colId) {
        return this.columnIndexMap[colId];
    }
    setColList(colKeys = [], masterList, eventName, detectOrderChange, autoGroupsNeedBuilding, columnCallback, source) {
        const gridColumns = this.colModel.getCols();
        if (!gridColumns || gridColumns.length === 0) {
            return;
        }
        const changes = new Map();
        // store all original cols and their index.
        masterList.forEach((col, idx) => changes.set(col, idx));
        masterList.length = 0;
        if ((0, generic_1._exists)(colKeys)) {
            colKeys.forEach((key) => {
                const column = this.colModel.getColDefCol(key);
                if (column) {
                    masterList.push(column);
                }
            });
        }
        masterList.forEach((col, idx) => {
            const oldIndex = changes.get(col);
            // if the column was not in the list, we add it as it's a change
            // idx is irrelevant now.
            if (oldIndex === undefined) {
                changes.set(col, 0);
                return;
            }
            if (detectOrderChange && oldIndex !== idx) {
                // if we're detecting order changes, and the indexes differ, we retain this as it's changed
                return;
            }
            // otherwise remove this col, as it's unchanged.
            changes.delete(col);
        });
        this.updateIndexMap();
        const primaryCols = this.colModel.getColDefCols();
        primaryCols?.forEach((column) => {
            const added = masterList.indexOf(column) >= 0;
            columnCallback(column, added, source);
        });
        autoGroupsNeedBuilding && this.colModel.refreshCols(false);
        this.visibleCols.refresh(source);
        this.dispatchColumnChangedEvent(this.eventSvc, eventName, [...changes.keys()], source);
    }
    updateColList(keys = [], masterList, actionIsAdd, autoGroupsNeedBuilding, columnCallback, eventType, source) {
        if (!keys || keys.length === 0) {
            return;
        }
        let atLeastOne = false;
        const updatedCols = new Set();
        keys.forEach((key) => {
            if (!key) {
                return;
            }
            const columnToAdd = this.colModel.getColDefCol(key);
            if (!columnToAdd) {
                return;
            }
            updatedCols.add(columnToAdd);
            if (actionIsAdd) {
                if (masterList.indexOf(columnToAdd) >= 0) {
                    return;
                }
                masterList.push(columnToAdd);
            }
            else {
                const currentIndex = masterList.indexOf(columnToAdd);
                if (currentIndex < 0) {
                    return;
                }
                for (let i = currentIndex + 1; i < masterList.length; i++) {
                    // row indexes of subsequent columns have changed
                    updatedCols.add(masterList[i]);
                }
                (0, array_1._removeFromArray)(masterList, columnToAdd);
            }
            columnCallback(columnToAdd, actionIsAdd, source);
            atLeastOne = true;
        });
        if (!atLeastOne) {
            return;
        }
        this.updateIndexMap();
        if (autoGroupsNeedBuilding) {
            this.colModel.refreshCols(false);
        }
        this.visibleCols.refresh(source);
        const eventColumns = Array.from(updatedCols);
        this.eventSvc.dispatchEvent({
            type: eventType,
            columns: eventColumns,
            column: eventColumns.length === 1 ? eventColumns[0] : null,
            source,
        });
    }
    extractCols(source, oldProvidedCols = []) {
        const previousCols = this.columns;
        const colsWithIndex = [];
        const colsWithValue = [];
        const { setFlagFunc, getIndexFunc, getInitialIndexFunc, getValueFunc, getInitialValueFunc } = this.columnExtractors;
        const primaryCols = this.colModel.getColDefCols();
        // go though all cols.
        // if value, change
        // if default only, change only if new
        primaryCols?.forEach((col) => {
            const colIsNew = !oldProvidedCols.includes(col);
            const colDef = col.getColDef();
            const value = getValueFunc(colDef);
            const initialValue = getInitialValueFunc(colDef);
            const index = getIndexFunc(colDef);
            const initialIndex = getInitialIndexFunc(colDef);
            let include;
            const valuePresent = value !== undefined;
            const indexPresent = index !== undefined;
            const initialValuePresent = initialValue !== undefined;
            const initialIndexPresent = initialIndex !== undefined;
            if (valuePresent) {
                include = value; // boolean value is guaranteed as attrToBoolean() is used above
            }
            else if (indexPresent) {
                if (index === null) {
                    // if col is new we don't want to use the default / initial if index is set to null. Similarly,
                    // we don't want to include the property for existing columns, i.e. we want to 'clear' it.
                    include = false;
                }
                else {
                    // note that 'null >= 0' evaluates to true which means 'rowGroupIndex = null' would enable row
                    // grouping if the null check didn't exist above.
                    include = index >= 0;
                }
            }
            else {
                if (colIsNew) {
                    // as no value or index is 'present' we use the default / initial when col is new
                    if (initialValuePresent) {
                        include = initialValue;
                    }
                    else if (initialIndexPresent) {
                        include = initialIndex != null && initialIndex >= 0;
                    }
                    else {
                        include = false;
                    }
                }
                else {
                    // otherwise include it if included last time, e.g. if we are extracting row group cols and this col
                    // is an existing row group col (i.e. it exists in 'previousCols') then we should include it.
                    include = previousCols.indexOf(col) >= 0;
                }
            }
            if (include) {
                const useIndex = colIsNew ? index != null || initialIndex != null : index != null;
                useIndex ? colsWithIndex.push(col) : colsWithValue.push(col);
            }
        });
        const getIndexForCol = (col) => {
            const colDef = col.getColDef();
            return getIndexFunc(colDef) ?? getInitialIndexFunc(colDef);
        };
        // sort cols with index, and add these first
        colsWithIndex.sort((colA, colB) => getIndexForCol(colA) - getIndexForCol(colB));
        const res = [...colsWithIndex];
        // next, add columns that were there before and in the same order as they were before,
        // so we are preserving order of current grouping of columns that simply have rowGroup=true...
        previousCols.forEach((col) => {
            if (colsWithValue.indexOf(col) >= 0) {
                // ...with the caveat that each column added also has any associated virtual columns added here
                // so they appear before it in the group hierarchy. This is purely a matter of ordering; adding the
                // virtual columns here means they will not be added below when iterating over `colsWithValue`.
                this.groupHierarchCols?.expandColumnInto(res, col);
            }
        });
        // lastly put in all remaining cols
        colsWithValue.forEach((col) => {
            if (res.indexOf(col) < 0) {
                res.push(col);
            }
        });
        // set flag=false for removed cols
        previousCols.forEach((col) => {
            if (res.indexOf(col) < 0) {
                setFlagFunc(col, false, source);
            }
        });
        // set flag=true for newly added cols
        res.forEach((col) => {
            if (previousCols.indexOf(col) < 0) {
                setFlagFunc(col, true, source);
            }
        });
        this.columns = res;
        this.updateIndexMap();
        return this.columns;
    }
    restoreColumnOrder(columnStateAccumulator, incomingColumnState) {
        const colList = this.columns;
        const primaryCols = this.colModel.getColDefCols();
        if (!colList.length || !primaryCols) {
            return columnStateAccumulator;
        }
        const updatedColIdArray = Object.keys(incomingColumnState);
        const updatedColIds = new Set(updatedColIdArray);
        const newColIds = new Set(updatedColIdArray);
        const allColIds = new Set(colList
            .map((column) => {
            const colId = column.getColId();
            newColIds.delete(colId);
            return colId;
        })
            .concat(updatedColIdArray));
        const colIdsInOriginalOrder = [];
        const originalOrderMap = {};
        let orderIndex = 0;
        for (let i = 0; i < primaryCols.length; i++) {
            const colId = primaryCols[i].getColId();
            if (allColIds.has(colId)) {
                colIdsInOriginalOrder.push(colId);
                originalOrderMap[colId] = orderIndex++;
            }
        }
        // follow approach in `resetColumnState`
        let index = 1000;
        let hasAddedNewCols = false;
        let lastIndex = 0;
        const enableProp = this.columnOrdering.enableProp;
        const initialEnableProp = this.columnOrdering.initialEnableProp;
        const indexProp = this.columnOrdering.indexProp;
        const initialIndexProp = this.columnOrdering.initialIndexProp;
        const processPrecedingNewCols = (colId) => {
            const originalOrderIndex = originalOrderMap[colId];
            for (let i = lastIndex; i < originalOrderIndex; i++) {
                const newColId = colIdsInOriginalOrder[i];
                if (newColIds.has(newColId)) {
                    incomingColumnState[newColId][indexProp] = index++;
                    newColIds.delete(newColId);
                }
            }
            lastIndex = originalOrderIndex;
        };
        colList.forEach((column) => {
            const colId = column.getColId();
            if (updatedColIds.has(colId)) {
                // New col already exists. Add any other new cols that should be before it.
                processPrecedingNewCols(colId);
                incomingColumnState[colId][indexProp] = index++;
            }
            else {
                const colDef = column.getColDef();
                const missingIndex = colDef[indexProp] === null || (colDef[indexProp] === undefined && colDef[initialIndexProp] == null);
                if (missingIndex) {
                    if (!hasAddedNewCols) {
                        const propEnabled = colDef[enableProp] || (colDef[enableProp] === undefined && colDef[initialEnableProp]);
                        if (propEnabled) {
                            processPrecedingNewCols(colId);
                        }
                        else {
                            // Reached the first manually added column. Add all the new columns now.
                            newColIds.forEach((newColId) => {
                                // Rather than increment the index, just use the original order index - doesn't need to be contiguous.
                                incomingColumnState[newColId][indexProp] = index + originalOrderMap[newColId];
                            });
                            index += colIdsInOriginalOrder.length;
                            hasAddedNewCols = true;
                        }
                    }
                    if (!columnStateAccumulator[colId]) {
                        columnStateAccumulator[colId] = { colId };
                    }
                    columnStateAccumulator[colId][indexProp] = index++;
                }
            }
        });
        return columnStateAccumulator;
    }
}
exports.BaseColsService = BaseColsService;


/***/ }),

/***/ 68763:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getAllDisplayedVirtualColumns = exports.getAllDisplayedColumns = exports.getDisplayedRightColumns = exports.getDisplayedCenterColumns = exports.getDisplayedLeftColumns = exports.getAllGridColumns = exports.setColumnsPinned = exports.setColumnsVisible = exports.getDisplayedColBefore = exports.getDisplayedColAfter = exports.isPinningRight = exports.isPinningLeft = exports.isPinning = exports.resetColumnState = exports.getColumnState = exports.applyColumnState = exports.getColumns = exports.getColumn = exports.getDisplayNameForColumn = exports.getColumnDefs = exports.getColumnDef = void 0;
const columnStateUtils_1 = __webpack_require__(2885);
function getColumnDef(beans, key) {
    const column = beans.colModel.getColDefCol(key);
    if (column) {
        return column.getColDef();
    }
    return null;
}
exports.getColumnDef = getColumnDef;
function getColumnDefs(beans) {
    return beans.colModel.getColumnDefs();
}
exports.getColumnDefs = getColumnDefs;
function getDisplayNameForColumn(beans, column, location) {
    return beans.colNames.getDisplayNameForColumn(column, location) || '';
}
exports.getDisplayNameForColumn = getDisplayNameForColumn;
function getColumn(beans, key) {
    return beans.colModel.getColDefCol(key);
}
exports.getColumn = getColumn;
function getColumns(beans) {
    return beans.colModel.getColDefCols();
}
exports.getColumns = getColumns;
function applyColumnState(beans, params) {
    return (0, columnStateUtils_1._applyColumnState)(beans, params, 'api');
}
exports.applyColumnState = applyColumnState;
function getColumnState(beans) {
    return (0, columnStateUtils_1._getColumnState)(beans);
}
exports.getColumnState = getColumnState;
function resetColumnState(beans) {
    (0, columnStateUtils_1._resetColumnState)(beans, 'api');
}
exports.resetColumnState = resetColumnState;
function isPinning(beans) {
    return beans.visibleCols.isPinningLeft() || beans.visibleCols.isPinningRight();
}
exports.isPinning = isPinning;
function isPinningLeft(beans) {
    return beans.visibleCols.isPinningLeft();
}
exports.isPinningLeft = isPinningLeft;
function isPinningRight(beans) {
    return beans.visibleCols.isPinningRight();
}
exports.isPinningRight = isPinningRight;
function getDisplayedColAfter(beans, col) {
    return beans.visibleCols.getColAfter(col);
}
exports.getDisplayedColAfter = getDisplayedColAfter;
function getDisplayedColBefore(beans, col) {
    return beans.visibleCols.getColBefore(col);
}
exports.getDisplayedColBefore = getDisplayedColBefore;
function setColumnsVisible(beans, keys, visible) {
    beans.colModel.setColsVisible(keys, visible, 'api');
}
exports.setColumnsVisible = setColumnsVisible;
function setColumnsPinned(beans, keys, pinned) {
    beans.pinnedCols?.setColsPinned(keys, pinned, 'api');
}
exports.setColumnsPinned = setColumnsPinned;
function getAllGridColumns(beans) {
    return beans.colModel.getCols();
}
exports.getAllGridColumns = getAllGridColumns;
function getDisplayedLeftColumns(beans) {
    return beans.visibleCols.leftCols;
}
exports.getDisplayedLeftColumns = getDisplayedLeftColumns;
function getDisplayedCenterColumns(beans) {
    return beans.visibleCols.centerCols;
}
exports.getDisplayedCenterColumns = getDisplayedCenterColumns;
function getDisplayedRightColumns(beans) {
    return beans.visibleCols.rightCols;
}
exports.getDisplayedRightColumns = getDisplayedRightColumns;
function getAllDisplayedColumns(beans) {
    return beans.visibleCols.allCols;
}
exports.getAllDisplayedColumns = getAllDisplayedColumns;
function getAllDisplayedVirtualColumns(beans) {
    return beans.colViewport.getViewportColumns();
}
exports.getAllDisplayedVirtualColumns = getAllDisplayedVirtualColumns;


/***/ }),

/***/ 44604:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnDefFactory = exports._deepCloneDefinition = void 0;
const beanStub_1 = __webpack_require__(68731);
const mergeDeep_1 = __webpack_require__(66021);
// returns copy of an object, doing a deep clone of any objects with that object.
// this is used for eg creating copies of Column Definitions, where we want to
// deep copy all objects, but do not want to deep copy functions (eg when user provides
// a function or class for colDef.cellRenderer)
function _deepCloneDefinition(object, keysToSkip) {
    if (!object) {
        return;
    }
    const obj = object;
    const res = {};
    Object.keys(obj).forEach((key) => {
        if ((keysToSkip && keysToSkip.indexOf(key) >= 0) || mergeDeep_1.SKIP_JS_BUILTINS.has(key)) {
            return;
        }
        const value = obj[key];
        // 'simple object' means a bunch of key/value pairs, eg {filter: 'myFilter'}. it does
        // NOT include the following:
        // 1) arrays
        // 2) functions or classes (eg api instance)
        const sourceIsSimpleObject = typeof value === 'object' && value !== null && value.constructor === Object;
        if (sourceIsSimpleObject) {
            res[key] = _deepCloneDefinition(value);
        }
        else {
            res[key] = value;
        }
    });
    return res;
}
exports._deepCloneDefinition = _deepCloneDefinition;
class ColumnDefFactory extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colDefFactory';
    }
    wireBeans(beans) {
        this.rowGroupColsSvc = beans.rowGroupColsSvc;
        this.pivotColsSvc = beans.pivotColsSvc;
    }
    getColumnDefs(colDefColsList, showingPivotResult, lastOrder, colsList) {
        const cols = colDefColsList.slice();
        if (showingPivotResult) {
            cols.sort((a, b) => lastOrder.indexOf(a) - lastOrder.indexOf(b));
        }
        else if (lastOrder) {
            cols.sort((a, b) => colsList.indexOf(a) - colsList.indexOf(b));
        }
        const rowGroupColumns = this.rowGroupColsSvc?.columns;
        const pivotColumns = this.pivotColsSvc?.columns;
        return this.buildColumnDefs(cols, rowGroupColumns, pivotColumns);
    }
    buildColumnDefs(cols, rowGroupColumns = [], pivotColumns = []) {
        const res = [];
        const colGroupDefs = {};
        cols.forEach((col) => {
            const colDef = this.createDefFromColumn(col, rowGroupColumns, pivotColumns);
            let addToResult = true;
            let childDef = colDef;
            let pointer = col.getOriginalParent();
            let lastPointer = null;
            while (pointer) {
                let parentDef = null;
                // we don't include padding groups, as the column groups provided
                // by application didn't have these. the whole point of padding groups
                // is to balance the column tree that the user provided.
                if (pointer.isPadding()) {
                    pointer = pointer.getOriginalParent();
                    continue;
                }
                // if colDef for this group already exists, use it
                const existingParentDef = colGroupDefs[pointer.getGroupId()];
                if (existingParentDef) {
                    existingParentDef.children.push(childDef);
                    // if we added to result, it would be the second time we did it
                    addToResult = false;
                    // we don't want to continue up the tree, as it has already been
                    // done for this group
                    break;
                }
                parentDef = this.createDefFromGroup(pointer);
                if (parentDef) {
                    parentDef.children = [childDef];
                    colGroupDefs[parentDef.groupId] = parentDef;
                    childDef = parentDef;
                    pointer = pointer.getOriginalParent();
                }
                if (pointer != null && lastPointer === pointer) {
                    addToResult = false;
                    break;
                }
                // Ensure we don't get stuck in an infinite loop
                lastPointer = pointer;
            }
            if (addToResult) {
                res.push(childDef);
            }
        });
        return res;
    }
    createDefFromGroup(group) {
        const defCloned = _deepCloneDefinition(group.getColGroupDef(), ['children']);
        if (defCloned) {
            defCloned.groupId = group.getGroupId();
        }
        return defCloned;
    }
    createDefFromColumn(col, rowGroupColumns, pivotColumns) {
        const colDefCloned = _deepCloneDefinition(col.getColDef());
        colDefCloned.colId = col.getColId();
        colDefCloned.width = col.getActualWidth();
        colDefCloned.rowGroup = col.isRowGroupActive();
        colDefCloned.rowGroupIndex = col.isRowGroupActive() ? rowGroupColumns.indexOf(col) : null;
        colDefCloned.pivot = col.isPivotActive();
        colDefCloned.pivotIndex = col.isPivotActive() ? pivotColumns.indexOf(col) : null;
        colDefCloned.aggFunc = col.isValueActive() ? col.getAggFunc() : null;
        colDefCloned.hide = col.isVisible() ? undefined : true;
        colDefCloned.pinned = col.isPinned() ? col.getPinned() : null;
        colDefCloned.sort = col.getSort() ? col.getSort() : null;
        colDefCloned.sortIndex = col.getSortIndex() != null ? col.getSortIndex() : null;
        return colDefCloned;
    }
}
exports.ColumnDefFactory = ColumnDefFactory;


/***/ }),

/***/ 72934:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.dispatchColumnResizedEvent = exports.dispatchColumnChangedEvent = exports.dispatchColumnVisibleEvent = exports.dispatchColumnPinnedEvent = void 0;
function getCommonValue(cols, valueGetter) {
    if (!cols || cols.length == 0) {
        return undefined;
    }
    // compare each value to the first value. if nothing differs, then value is common so return it.
    const firstValue = valueGetter(cols[0]);
    for (let i = 1; i < cols.length; i++) {
        if (firstValue !== valueGetter(cols[i])) {
            // values differ, no common value
            return undefined;
        }
    }
    return firstValue;
}
function dispatchColumnPinnedEvent(eventSvc, changedColumns, source) {
    if (!changedColumns.length) {
        return;
    }
    // if just one column, we use this, otherwise we don't include the col
    const column = changedColumns.length === 1 ? changedColumns[0] : null;
    // only include pinned if it's common in all columns
    const pinned = getCommonValue(changedColumns, (col) => col.getPinned());
    eventSvc.dispatchEvent({
        type: 'columnPinned',
        // mistake in typing, 'undefined' should be allowed, as 'null' means 'not pinned'
        pinned: pinned != null ? pinned : null,
        columns: changedColumns,
        column,
        source,
    });
}
exports.dispatchColumnPinnedEvent = dispatchColumnPinnedEvent;
function dispatchColumnVisibleEvent(eventSvc, changedColumns, source) {
    if (!changedColumns.length) {
        return;
    }
    // if just one column, we use this, otherwise we don't include the col
    const column = changedColumns.length === 1 ? changedColumns[0] : null;
    // only include visible if it's common in all columns
    const visible = getCommonValue(changedColumns, (col) => col.isVisible());
    eventSvc.dispatchEvent({
        type: 'columnVisible',
        visible,
        columns: changedColumns,
        column,
        source,
    });
}
exports.dispatchColumnVisibleEvent = dispatchColumnVisibleEvent;
function dispatchColumnChangedEvent(eventSvc, type, columns, source) {
    eventSvc.dispatchEvent({
        type,
        columns,
        column: columns && columns.length == 1 ? columns[0] : null,
        source,
    });
}
exports.dispatchColumnChangedEvent = dispatchColumnChangedEvent;
function dispatchColumnResizedEvent(eventSvc, columns, finished, source, flexColumns = null) {
    if (columns?.length) {
        eventSvc.dispatchEvent({
            type: 'columnResized',
            columns,
            column: columns.length === 1 ? columns[0] : null,
            flexColumns,
            finished,
            source,
        });
    }
}
exports.dispatchColumnResizedEvent = dispatchColumnResizedEvent;


/***/ }),

/***/ 82716:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.depthFirstOriginalTreeSearch = exports._addColumnDefaultAndTypes = exports._updateColumnState = exports.updateSomeColumnState = exports._recursivelyCreateColumns = exports._createColumnTree = exports._createColumnTreeWithIds = void 0;
const agColumn_1 = __webpack_require__(13355);
const agProvidedColumnGroup_1 = __webpack_require__(79409);
const defaultColumnTypes_1 = __webpack_require__(35449);
const gridOptionsUtils_1 = __webpack_require__(67274);
const mergeDeep_1 = __webpack_require__(66021);
const logging_1 = __webpack_require__(47764);
const columnGroupUtils_1 = __webpack_require__(70820);
const columnKeyCreator_1 = __webpack_require__(2294);
const columnUtils_1 = __webpack_require__(73146);
/**
 * A performant approach to _createColumnTree where the function assumes all defs have an ID.
 * Used for Pivoting.
 */
function _createColumnTreeWithIds(beans, defs = null, primaryColumns, existingTree, source) {
    const { existingCols, existingGroups } = extractExistingTreeData(existingTree);
    const colIdMap = new Map(existingCols.map((col) => [col.getId(), col]));
    const colGroupIdMap = new Map(existingGroups.map((group) => [group.getId(), group]));
    let maxDepth = 0;
    const recursivelyProcessColDef = (def, level) => {
        maxDepth = Math.max(maxDepth, level);
        if (isColumnGroupDef(def)) {
            if (!beans.colGroupSvc) {
                return null;
            }
            const groupId = def.groupId;
            const group = colGroupIdMap.get(groupId);
            const colGroupDef = (0, columnGroupUtils_1.createMergedColGroupDef)(beans, def, groupId);
            const newGroup = new agProvidedColumnGroup_1.AgProvidedColumnGroup(colGroupDef, groupId, false, level);
            beans.context.createBean(newGroup);
            if (group) {
                newGroup.setExpanded(group.isExpanded());
            }
            newGroup.setChildren(def.children.map((child) => recursivelyProcessColDef(child, level + 1)));
            return newGroup;
        }
        const colId = def.colId;
        let column = colIdMap.get(colId);
        const colDefMerged = _addColumnDefaultAndTypes(beans, def, column?.getColId() ?? colId);
        if (!column) {
            // no existing column, need to create one
            column = new agColumn_1.AgColumn(colDefMerged, def, colId, primaryColumns);
            beans.context.createBean(column);
        }
        else {
            column.setColDef(colDefMerged, def, source);
            _updateColumnState(beans, column, colDefMerged, source);
        }
        beans.dataTypeSvc?.addColumnListeners(column);
        return column;
    };
    const root = defs?.map((def) => recursivelyProcessColDef(def, 0)) ?? [];
    let counter = 0;
    const keyCreator = {
        getUniqueKey: (_colId, _field) => String(++counter),
    };
    const columnTree = beans.colGroupSvc ? beans.colGroupSvc.balanceColumnTree(root, 0, maxDepth, keyCreator) : root;
    const depthFirstCallback = (child, parent) => {
        if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
            child.setupExpandable();
        }
        // we set the original parents at the end, rather than when we go along, as balancing the tree
        // adds extra levels into the tree. so we can only set parents when balancing is done.
        child.originalParent = parent;
    };
    depthFirstOriginalTreeSearch(null, columnTree, depthFirstCallback);
    return {
        columnTree,
        treeDepth: maxDepth,
    };
}
exports._createColumnTreeWithIds = _createColumnTreeWithIds;
function _createColumnTree(beans, defs = null, primaryColumns, existingTree, source) {
    // column key creator dishes out unique column id's in a deterministic way,
    // so if we have two grids (that could be master/slave) with same column definitions,
    // then this ensures the two grids use identical id's.
    const columnKeyCreator = new columnKeyCreator_1.ColumnKeyCreator();
    const { existingCols, existingGroups, existingColKeys } = extractExistingTreeData(existingTree);
    columnKeyCreator.addExistingKeys(existingColKeys);
    // create am unbalanced tree that maps the provided definitions
    const unbalancedTree = _recursivelyCreateColumns(beans, defs, 0, primaryColumns, existingCols, columnKeyCreator, existingGroups, source);
    const { colGroupSvc } = beans;
    const treeDepth = colGroupSvc?.findMaxDepth(unbalancedTree, 0) ?? 0;
    const columnTree = colGroupSvc
        ? colGroupSvc.balanceColumnTree(unbalancedTree, 0, treeDepth, columnKeyCreator)
        : unbalancedTree;
    const depthFirstCallback = (child, parent) => {
        if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
            child.setupExpandable();
        }
        // we set the original parents at the end, rather than when we go along, as balancing the tree
        // adds extra levels into the tree. so we can only set parents when balancing is done.
        child.originalParent = parent;
    };
    depthFirstOriginalTreeSearch(null, columnTree, depthFirstCallback);
    return {
        columnTree,
        treeDepth,
    };
}
exports._createColumnTree = _createColumnTree;
function extractExistingTreeData(existingTree) {
    const existingCols = [];
    const existingGroups = [];
    const existingColKeys = [];
    if (existingTree) {
        depthFirstOriginalTreeSearch(null, existingTree, (item) => {
            if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(item)) {
                const group = item;
                existingGroups.push(group);
            }
            else {
                const col = item;
                existingColKeys.push(col.getId());
                existingCols.push(col);
            }
        });
    }
    return { existingCols, existingGroups, existingColKeys };
}
function _recursivelyCreateColumns(beans, defs, level, primaryColumns, existingColsCopy, columnKeyCreator, existingGroups, source) {
    if (!defs)
        return [];
    const { colGroupSvc } = beans;
    const result = new Array(defs.length);
    for (let i = 0; i < result.length; i++) {
        const def = defs[i];
        if (colGroupSvc && isColumnGroupDef(def)) {
            result[i] = colGroupSvc.createProvidedColumnGroup(primaryColumns, def, level, existingColsCopy, columnKeyCreator, existingGroups, source);
        }
        else {
            result[i] = createColumn(beans, primaryColumns, def, existingColsCopy, columnKeyCreator, source);
        }
    }
    return result;
}
exports._recursivelyCreateColumns = _recursivelyCreateColumns;
function createColumn(beans, primaryColumns, colDef, existingColsCopy, columnKeyCreator, source) {
    // see if column already exists
    const existingColAndIndex = findExistingColumn(colDef, existingColsCopy);
    // make sure we remove, so if user provided duplicate id, then we don't have more than
    // one column instance for colDef with common id
    if (existingColAndIndex) {
        existingColsCopy?.splice(existingColAndIndex.idx, 1);
    }
    let column = existingColAndIndex?.column;
    if (!column) {
        // no existing column, need to create one
        const colId = columnKeyCreator.getUniqueKey(colDef.colId, colDef.field);
        const colDefMerged = _addColumnDefaultAndTypes(beans, colDef, colId);
        column = new agColumn_1.AgColumn(colDefMerged, colDef, colId, primaryColumns);
        beans.context.createBean(column);
    }
    else {
        const colDefMerged = _addColumnDefaultAndTypes(beans, colDef, column.getColId());
        column.setColDef(colDefMerged, colDef, source);
        _updateColumnState(beans, column, colDefMerged, source);
    }
    beans.dataTypeSvc?.addColumnListeners(column);
    return column;
}
/** Updates hide, sort, sortIndex, pinned and flex */
function updateSomeColumnState(beans, column, hide, sort, sortIndex, pinned, flex, source) {
    const { sortSvc, pinnedCols, colFlex } = beans;
    // hide - anything but undefined, thus null will clear the hide
    if (hide !== undefined) {
        column.setVisible(!hide, source);
    }
    if (sortSvc) {
        // sort - anything but undefined will set sort, thus null or empty string will clear the sort
        sortSvc.updateColSort(column, sort, source);
        // sorted at - anything but undefined, thus null will clear the sortIndex
        if (sortIndex !== undefined) {
            sortSvc.setColSortIndex(column, sortIndex);
        }
    }
    // pinned - anything but undefined, thus null or empty string will remove pinned
    if (pinned !== undefined) {
        pinnedCols?.setColPinned(column, pinned);
    }
    // flex
    if (flex !== undefined) {
        colFlex?.setColFlex(column, flex);
    }
}
exports.updateSomeColumnState = updateSomeColumnState;
function _updateColumnState(beans, column, colDef, source) {
    updateSomeColumnState(beans, column, colDef.hide, colDef.sort, colDef.sortIndex, colDef.pinned, colDef.flex, source);
    const colFlex = column.getFlex();
    // width - we only set width if column is not flexing
    if (colFlex != null && colFlex > 0) {
        return;
    }
    // both null and undefined means we skip, as it's not possible to 'clear' width (a column must have a width)
    if (colDef.width != null) {
        column.setActualWidth(colDef.width, source);
    }
    else {
        // otherwise set the width again, in case min or max width has changed,
        // and width needs to be adjusted.
        const widthBeforeUpdate = column.getActualWidth();
        column.setActualWidth(widthBeforeUpdate, source);
    }
}
exports._updateColumnState = _updateColumnState;
function findExistingColumn(newColDef, existingColsCopy) {
    if (!existingColsCopy)
        return undefined;
    for (let i = 0; i < existingColsCopy.length; i++) {
        const def = existingColsCopy[i].getUserProvidedColDef();
        if (!def)
            continue;
        const newHasId = newColDef.colId != null;
        if (newHasId) {
            if (existingColsCopy[i].getId() === newColDef.colId) {
                return { idx: i, column: existingColsCopy[i] };
            }
            continue;
        }
        const newHasField = newColDef.field != null;
        if (newHasField) {
            if (def.field === newColDef.field) {
                return { idx: i, column: existingColsCopy[i] };
            }
            continue;
        }
        if (def === newColDef) {
            return { idx: i, column: existingColsCopy[i] };
        }
    }
    return undefined;
}
function _addColumnDefaultAndTypes(beans, colDef, colId, isAutoCol) {
    const { gos, dataTypeSvc } = beans;
    // start with empty merged definition
    const res = {};
    // merge properties from default column definitions
    const defaultColDef = gos.get('defaultColDef');
    (0, mergeDeep_1._mergeDeep)(res, defaultColDef, false, true);
    const columnType = updateColDefAndGetColumnType(beans, res, colDef, colId);
    if (columnType) {
        assignColumnTypes(beans, columnType, res);
    }
    const cellDataType = res.cellDataType;
    // merge properties from column definitions
    (0, mergeDeep_1._mergeDeep)(res, colDef, false, true);
    if (cellDataType !== undefined) {
        // `cellDataType: true` in provided def will overwrite inferred result type otherwise
        res.cellDataType = cellDataType;
    }
    const autoGroupColDef = gos.get('autoGroupColumnDef');
    const isSortingCoupled = (0, gridOptionsUtils_1._isColumnsSortingCoupledToGroup)(gos);
    if (colDef.rowGroup && autoGroupColDef && isSortingCoupled) {
        // override the sort for row group columns where the autoGroupColDef defines these values.
        (0, mergeDeep_1._mergeDeep)(res, { sort: autoGroupColDef.sort, initialSort: autoGroupColDef.initialSort }, false, true);
    }
    if (dataTypeSvc) {
        dataTypeSvc.postProcess(res);
        dataTypeSvc.validateColDef(res);
    }
    gos.validateColDef(res, colId, isAutoCol);
    return res;
}
exports._addColumnDefaultAndTypes = _addColumnDefaultAndTypes;
function updateColDefAndGetColumnType(beans, colDef, userColDef, colId) {
    const dataTypeDefinitionColumnType = beans.dataTypeSvc?.updateColDefAndGetColumnType(colDef, userColDef, colId);
    const columnTypes = userColDef.type ?? dataTypeDefinitionColumnType ?? colDef.type;
    colDef.type = columnTypes;
    return columnTypes ? (0, columnUtils_1.convertColumnTypes)(columnTypes) : undefined;
}
function assignColumnTypes(beans, typeKeys, colDefMerged) {
    if (!typeKeys.length) {
        return;
    }
    // merge user defined with default column types
    const allColumnTypes = Object.assign({}, defaultColumnTypes_1.DefaultColumnTypes);
    const userTypes = beans.gos.get('columnTypes') || {};
    for (const key of Object.keys(userTypes)) {
        const value = userTypes[key];
        if (key in allColumnTypes) {
            // default column types cannot be overridden
            (0, logging_1._warn)(34, { key });
        }
        else {
            const colType = value;
            if (colType.type) {
                // type should not be defined in column types
                (0, logging_1._warn)(35);
            }
            allColumnTypes[key] = value;
        }
    }
    typeKeys.forEach((t) => {
        const typeColDef = allColumnTypes[t.trim()];
        if (typeColDef) {
            (0, mergeDeep_1._mergeDeep)(colDefMerged, typeColDef, false, true);
        }
        else {
            (0, logging_1._warn)(36, { t });
        }
    });
}
// if object has children, we assume it's a group
function isColumnGroupDef(abstractColDef) {
    return abstractColDef.children !== undefined;
}
function depthFirstOriginalTreeSearch(parent, tree, callback) {
    if (!tree) {
        return;
    }
    for (let i = 0; i < tree.length; i++) {
        const child = tree[i];
        if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
            depthFirstOriginalTreeSearch(child, child.getChildren(), callback);
        }
        callback(child, parent);
    }
}
exports.depthFirstOriginalTreeSearch = depthFirstOriginalTreeSearch;


/***/ }),

/***/ 82849:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnFlexService = void 0;
const beanStub_1 = __webpack_require__(68731);
const columnEventUtils_1 = __webpack_require__(72934);
class ColumnFlexService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colFlex';
    }
    refreshFlexedColumns(params = {}) {
        const source = params.source ?? 'flex';
        if (params.viewportWidth != null) {
            this.flexViewportWidth = params.viewportWidth;
        }
        const totalSpace = this.flexViewportWidth;
        const { visibleCols, colDelayRenderSvc } = this.beans;
        const visibleCenterCols = visibleCols.centerCols;
        let flexAfterDisplayIndex = -1;
        if (params.resizingCols) {
            const allResizingCols = new Set(params.resizingCols);
            // find the last resizing col, as only cols after this one are affected by the resizing
            for (let i = visibleCenterCols.length - 1; i >= 0; i--) {
                if (allResizingCols.has(visibleCenterCols[i])) {
                    flexAfterDisplayIndex = i;
                    break;
                }
            }
        }
        // NOTE this is an implementation of the "Resolve Flexible Lengths" part
        // of the flex spec, simplified because we only support flex growing not
        // shrinking, and don't support flex-basis.
        // https://www.w3.org/TR/css-flexbox-1/#resolve-flexible-lengths
        let hasFlexItems = false;
        const items = visibleCenterCols.map((col, i) => {
            const flex = col.getFlex();
            const isFlex = flex != null && flex > 0 && i > flexAfterDisplayIndex;
            hasFlexItems || (hasFlexItems = isFlex);
            return {
                col,
                isFlex,
                flex: Math.max(0, flex ?? 0),
                initialSize: col.getActualWidth(),
                min: col.getMinWidth(),
                max: col.getMaxWidth(),
                targetSize: 0,
            };
        });
        // hide all columns and cells because we are going to flex them after they are displayed
        if (hasFlexItems) {
            colDelayRenderSvc?.hideColumns('colFlex');
        }
        if (!totalSpace || !hasFlexItems) {
            return [];
        }
        let unfrozenItemCount = items.length;
        let unfrozenFlex = items.reduce((acc, item) => acc + item.flex, 0);
        let unfrozenSpace = totalSpace;
        const freeze = (item, width) => {
            item.frozenSize = width;
            item.col.setActualWidth(width, source);
            unfrozenSpace -= width;
            unfrozenFlex -= item.flex;
            unfrozenItemCount -= 1;
        };
        const isFrozen = (item) => item.frozenSize != null;
        // Freeze inflexible columns
        for (const item of items) {
            if (!item.isFlex) {
                freeze(item, item.initialSize);
            }
        }
        // a. Check for flexible items. If all the flex items on the line are
        // frozen, free space has been distributed; exit this loop.
        while (unfrozenItemCount > 0) {
            // b. Calculate the remaining free space as for initial free space,
            // above. If the sum of the unfrozen flex items’ flex factors is
            // less than one, multiply the initial free space by this sum.
            const spaceToFill = Math.round(unfrozenFlex < 1 ? unfrozenSpace * unfrozenFlex : unfrozenSpace);
            // c. Distribute free space proportional to the flex factors.
            let lastUnfrozenItem;
            let actualLeft = 0;
            let idealRight = 0;
            for (const item of items) {
                if (isFrozen(item)) {
                    continue;
                }
                lastUnfrozenItem = item;
                idealRight += spaceToFill * (item.flex / unfrozenFlex);
                const idealSize = idealRight - actualLeft;
                const roundedSize = Math.round(idealSize);
                item.targetSize = roundedSize;
                actualLeft += roundedSize;
            }
            if (lastUnfrozenItem) {
                // Correct cumulative rounding errors: adjust the size of the
                // last item to fill any remaining space
                lastUnfrozenItem.targetSize += spaceToFill - actualLeft;
            }
            // d. Fix min/max violations. Clamp each non-frozen item’s target
            // main size by its used min and max main sizes... If the item’s
            // target main size was made smaller by this, it’s a max violation.
            // If the item’s target main size was made larger by this, it’s a
            // min violation.
            let totalViolation = 0;
            for (const item of items) {
                if (isFrozen(item)) {
                    continue;
                }
                const unclampedSize = item.targetSize;
                const clampedSize = Math.min(Math.max(unclampedSize, item.min), item.max);
                totalViolation += clampedSize - unclampedSize;
                item.violationType =
                    clampedSize === unclampedSize ? undefined : clampedSize < unclampedSize ? 'max' : 'min';
                item.targetSize = clampedSize;
            }
            // e. Freeze over-flexed items. The total violation is the sum of
            // the adjustments from the previous step.
            // If the total violation is:
            //     - Zero, Freeze all items
            //     - Positive, Freeze all the items with min violations
            //     - Negative, Freeze all the items with max violations
            const freezeType = totalViolation === 0 ? 'all' : totalViolation > 0 ? 'min' : 'max';
            for (const item of items) {
                if (isFrozen(item)) {
                    continue;
                }
                if (freezeType === 'all' || item.violationType === freezeType) {
                    freeze(item, item.targetSize);
                }
            }
        }
        if (!params.skipSetLeft) {
            visibleCols.setLeftValues(source);
        }
        if (params.updateBodyWidths) {
            visibleCols.updateBodyWidths();
        }
        const unconstrainedFlexColumns = items
            .filter((item) => item.isFlex && !item.violationType)
            .map((item) => item.col);
        if (params.fireResizedEvent) {
            const changedColumns = items.filter((item) => item.initialSize !== item.frozenSize).map((item) => item.col);
            const flexingColumns = items.filter((item) => item.flex).map((item) => item.col);
            (0, columnEventUtils_1.dispatchColumnResizedEvent)(this.eventSvc, changedColumns, true, source, flexingColumns);
        }
        colDelayRenderSvc?.revealColumns('colFlex');
        return unconstrainedFlexColumns;
    }
    initCol(column) {
        const { flex, initialFlex } = column.colDef;
        if (flex !== undefined) {
            column.flex = flex;
        }
        else if (initialFlex !== undefined) {
            column.flex = initialFlex;
        }
    }
    // this method should only be used by the colModel to
    // change flex when required by the applyColumnState method.
    setColFlex(column, flex) {
        column.flex = flex ?? null;
        column.dispatchStateUpdatedEvent('flex');
    }
}
exports.ColumnFlexService = ColumnFlexService;


/***/ }),

/***/ 66641:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getAllDisplayedColumnGroups = exports.getRightDisplayedColumnGroups = exports.getCenterDisplayedColumnGroups = exports.getLeftDisplayedColumnGroups = exports.resetColumnGroupState = exports.setColumnGroupState = exports.getColumnGroupState = exports.getDisplayNameForColumnGroup = exports.getProvidedColumnGroup = exports.getColumnGroup = exports.setColumnGroupOpened = void 0;
function setColumnGroupOpened(beans, group, newValue) {
    beans.colGroupSvc?.setColumnGroupOpened(group, newValue, 'api');
}
exports.setColumnGroupOpened = setColumnGroupOpened;
function getColumnGroup(beans, name, instanceId) {
    return beans.colGroupSvc?.getColumnGroup(name, instanceId) ?? null;
}
exports.getColumnGroup = getColumnGroup;
function getProvidedColumnGroup(beans, name) {
    return beans.colGroupSvc?.getProvidedColGroup(name) ?? null;
}
exports.getProvidedColumnGroup = getProvidedColumnGroup;
function getDisplayNameForColumnGroup(beans, columnGroup, location) {
    return beans.colNames.getDisplayNameForColumnGroup(columnGroup, location) || '';
}
exports.getDisplayNameForColumnGroup = getDisplayNameForColumnGroup;
function getColumnGroupState(beans) {
    return beans.colGroupSvc?.getColumnGroupState() ?? [];
}
exports.getColumnGroupState = getColumnGroupState;
function setColumnGroupState(beans, stateItems) {
    beans.colGroupSvc?.setColumnGroupState(stateItems, 'api');
}
exports.setColumnGroupState = setColumnGroupState;
function resetColumnGroupState(beans) {
    beans.colGroupSvc?.resetColumnGroupState('api');
}
exports.resetColumnGroupState = resetColumnGroupState;
function getLeftDisplayedColumnGroups(beans) {
    return beans.visibleCols.treeLeft;
}
exports.getLeftDisplayedColumnGroups = getLeftDisplayedColumnGroups;
function getCenterDisplayedColumnGroups(beans) {
    return beans.visibleCols.treeCenter;
}
exports.getCenterDisplayedColumnGroups = getCenterDisplayedColumnGroups;
function getRightDisplayedColumnGroups(beans) {
    return beans.visibleCols.treeRight;
}
exports.getRightDisplayedColumnGroups = getRightDisplayedColumnGroups;
function getAllDisplayedColumnGroups(beans) {
    return beans.visibleCols.getAllTrees();
}
exports.getAllDisplayedColumnGroups = getAllDisplayedColumnGroups;


/***/ }),

/***/ 66041:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnGroupModule = void 0;
const headerGroupCellCtrl_1 = __webpack_require__(60084);
const version_1 = __webpack_require__(97205);
const columnGroupApi_1 = __webpack_require__(66641);
const columnGroupService_1 = __webpack_require__(66266);
/**
 * @feature Columns -> Column Groups
 * @colGroupDef
 */
exports.ColumnGroupModule = {
    moduleName: 'ColumnGroup',
    version: version_1.VERSION,
    dynamicBeans: { headerGroupCellCtrl: headerGroupCellCtrl_1.HeaderGroupCellCtrl },
    beans: [columnGroupService_1.ColumnGroupService],
    apiFunctions: {
        getAllDisplayedColumnGroups: columnGroupApi_1.getAllDisplayedColumnGroups,
        getCenterDisplayedColumnGroups: columnGroupApi_1.getCenterDisplayedColumnGroups,
        getColumnGroup: columnGroupApi_1.getColumnGroup,
        getColumnGroupState: columnGroupApi_1.getColumnGroupState,
        getDisplayNameForColumnGroup: columnGroupApi_1.getDisplayNameForColumnGroup,
        getLeftDisplayedColumnGroups: columnGroupApi_1.getLeftDisplayedColumnGroups,
        getProvidedColumnGroup: columnGroupApi_1.getProvidedColumnGroup,
        getRightDisplayedColumnGroups: columnGroupApi_1.getRightDisplayedColumnGroups,
        resetColumnGroupState: columnGroupApi_1.resetColumnGroupState,
        setColumnGroupOpened: columnGroupApi_1.setColumnGroupOpened,
        setColumnGroupState: columnGroupApi_1.setColumnGroupState,
    },
};


/***/ }),

/***/ 66266:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnGroupService = void 0;
const array_1 = __webpack_require__(79909);
const generic_1 = __webpack_require__(89097);
const beanStub_1 = __webpack_require__(68731);
const agColumnGroup_1 = __webpack_require__(56908);
const agColumnGroup_2 = __webpack_require__(56908);
const agProvidedColumnGroup_1 = __webpack_require__(79409);
const agProvidedColumnGroup_2 = __webpack_require__(79409);
const columnFactoryUtils_1 = __webpack_require__(82716);
const visibleColsService_1 = __webpack_require__(6869);
const columnGroupUtils_1 = __webpack_require__(70820);
class ColumnGroupService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colGroupSvc';
    }
    getColumnGroupState() {
        const columnGroupState = [];
        const gridBalancedTree = this.beans.colModel.getColTree();
        (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, gridBalancedTree, (node) => {
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(node)) {
                columnGroupState.push({
                    groupId: node.getGroupId(),
                    open: node.isExpanded(),
                });
            }
        });
        return columnGroupState;
    }
    resetColumnGroupState(source) {
        const primaryColumnTree = this.beans.colModel.getColDefColTree();
        if (!primaryColumnTree) {
            return;
        }
        const stateItems = [];
        (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, primaryColumnTree, (child) => {
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(child)) {
                const colGroupDef = child.getColGroupDef();
                const groupState = {
                    groupId: child.getGroupId(),
                    open: !colGroupDef ? undefined : colGroupDef.openByDefault,
                };
                stateItems.push(groupState);
            }
        });
        this.setColumnGroupState(stateItems, source);
    }
    setColumnGroupState(stateItems, source) {
        const { colModel, colAnimation, visibleCols, eventSvc } = this.beans;
        const gridBalancedTree = colModel.getColTree();
        if (!gridBalancedTree.length) {
            return;
        }
        colAnimation?.start();
        const impactedGroups = [];
        stateItems.forEach((stateItem) => {
            const groupKey = stateItem.groupId;
            const newValue = stateItem.open;
            const providedColumnGroup = this.getProvidedColGroup(groupKey);
            if (!providedColumnGroup) {
                return;
            }
            if (providedColumnGroup.isExpanded() === newValue) {
                return;
            }
            providedColumnGroup.setExpanded(newValue);
            impactedGroups.push(providedColumnGroup);
        });
        visibleCols.refresh(source, true);
        if (impactedGroups.length) {
            eventSvc.dispatchEvent({
                type: 'columnGroupOpened',
                columnGroup: impactedGroups.length === 1 ? impactedGroups[0] : undefined,
                columnGroups: impactedGroups,
            });
        }
        colAnimation?.finish();
    }
    // called by headerRenderer - when a header is opened or closed
    setColumnGroupOpened(key, newValue, source) {
        let keyAsString;
        if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(key)) {
            keyAsString = key.getId();
        }
        else {
            keyAsString = key || '';
        }
        this.setColumnGroupState([{ groupId: keyAsString, open: newValue }], source);
    }
    getProvidedColGroup(key) {
        let res = null;
        (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, this.beans.colModel.getColTree(), (node) => {
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(node)) {
                if (node.getId() === key) {
                    res = node;
                }
            }
        });
        return res;
    }
    getGroupAtDirection(columnGroup, direction) {
        // pick the last displayed column in this group
        const requiredLevel = columnGroup.getProvidedColumnGroup().getLevel() + columnGroup.getPaddingLevel();
        const colGroupLeafColumns = columnGroup.getDisplayedLeafColumns();
        const col = direction === 'After' ? (0, array_1._last)(colGroupLeafColumns) : colGroupLeafColumns[0];
        const getDisplayColMethod = `getCol${direction}`;
        while (true) {
            // keep moving to the next col, until we get to another group
            const column = this.beans.visibleCols[getDisplayColMethod](col);
            if (!column) {
                return null;
            }
            const groupPointer = this.getColGroupAtLevel(column, requiredLevel);
            if (groupPointer !== columnGroup) {
                return groupPointer;
            }
        }
    }
    getColGroupAtLevel(column, level) {
        // get group at same level as the one we are looking for
        let groupPointer = column.getParent();
        let originalGroupLevel;
        let groupPointerLevel;
        while (true) {
            const groupPointerProvidedColumnGroup = groupPointer.getProvidedColumnGroup();
            originalGroupLevel = groupPointerProvidedColumnGroup.getLevel();
            groupPointerLevel = groupPointer.getPaddingLevel();
            if (originalGroupLevel + groupPointerLevel <= level) {
                break;
            }
            groupPointer = groupPointer.getParent();
        }
        return groupPointer;
    }
    updateOpenClosedVisibility() {
        const allColumnGroups = this.beans.visibleCols.getAllTrees();
        (0, visibleColsService_1.depthFirstAllColumnTreeSearch)(allColumnGroups, false, (child) => {
            if ((0, agColumnGroup_1.isColumnGroup)(child)) {
                child.calculateDisplayedColumns();
            }
        });
    }
    // returns the group with matching colId and instanceId. If instanceId is missing,
    // matches only on the colId.
    getColumnGroup(colId, partId) {
        if (!colId) {
            return null;
        }
        if ((0, agColumnGroup_1.isColumnGroup)(colId)) {
            return colId;
        }
        const allColumnGroups = this.beans.visibleCols.getAllTrees();
        const checkPartId = typeof partId === 'number';
        let result = null;
        (0, visibleColsService_1.depthFirstAllColumnTreeSearch)(allColumnGroups, false, (child) => {
            if ((0, agColumnGroup_1.isColumnGroup)(child)) {
                const columnGroup = child;
                let matched;
                if (checkPartId) {
                    matched = colId === columnGroup.getGroupId() && partId === columnGroup.getPartId();
                }
                else {
                    matched = colId === columnGroup.getGroupId();
                }
                if (matched) {
                    result = columnGroup;
                }
            }
        });
        return result;
    }
    createColumnGroups(params) {
        const { columns, idCreator, pinned, oldDisplayedGroups, isStandaloneStructure } = params;
        const oldColumnsMapped = this.mapOldGroupsById(oldDisplayedGroups);
        /**
         * The following logic starts at the leaf level of columns, iterating through them to build their parent
         * groups when the parents match.
         *
         * The created groups are then added to an array, and similarly iterated on until we reach the top level.
         *
         * When row groups have no original parent, it's added to the result.
         */
        const topLevelResultCols = [];
        // this is an array of cols or col groups at one level of depth, starting from leaf and ending at root
        let groupsOrColsAtCurrentLevel = columns;
        while (groupsOrColsAtCurrentLevel.length) {
            // store what's currently iterating so the function can build the next level of col groups
            const currentlyIterating = groupsOrColsAtCurrentLevel;
            groupsOrColsAtCurrentLevel = [];
            // store the index of the last row which was different from the previous row, this is used as a slice
            // index for finding the children to group together
            let lastGroupedColIdx = 0;
            // create a group of children from lastGroupedColIdx to the provided `to` parameter
            const createGroupToIndex = (to) => {
                const from = lastGroupedColIdx;
                lastGroupedColIdx = to;
                const previousNode = currentlyIterating[from];
                const previousNodeProvided = (0, agColumnGroup_1.isColumnGroup)(previousNode)
                    ? previousNode.getProvidedColumnGroup()
                    : previousNode;
                const previousNodeParent = previousNodeProvided.getOriginalParent();
                if (previousNodeParent == null) {
                    // if the last node was different, and had a null parent, then we add all the nodes to the final
                    // results)
                    for (let i = from; i < to; i++) {
                        topLevelResultCols.push(currentlyIterating[i]);
                    }
                    return;
                }
                // the parent differs from the previous node, so we create a group from the previous node
                // and add all to the result array, except the current node.
                const newGroup = this.createColumnGroup(previousNodeParent, idCreator, oldColumnsMapped, pinned, isStandaloneStructure);
                for (let i = from; i < to; i++) {
                    newGroup.addChild(currentlyIterating[i]);
                }
                groupsOrColsAtCurrentLevel.push(newGroup);
            };
            for (let i = 1; i < currentlyIterating.length; i++) {
                const thisNode = currentlyIterating[i];
                const thisNodeProvided = (0, agColumnGroup_1.isColumnGroup)(thisNode) ? thisNode.getProvidedColumnGroup() : thisNode;
                const thisNodeParent = thisNodeProvided.getOriginalParent();
                const previousNode = currentlyIterating[lastGroupedColIdx];
                const previousNodeProvided = (0, agColumnGroup_1.isColumnGroup)(previousNode)
                    ? previousNode.getProvidedColumnGroup()
                    : previousNode;
                const previousNodeParent = previousNodeProvided.getOriginalParent();
                if (thisNodeParent !== previousNodeParent) {
                    createGroupToIndex(i);
                }
            }
            if (lastGroupedColIdx < currentlyIterating.length) {
                createGroupToIndex(currentlyIterating.length);
            }
        }
        if (!isStandaloneStructure) {
            this.setupParentsIntoCols(topLevelResultCols, null);
        }
        return topLevelResultCols;
    }
    createProvidedColumnGroup(primaryColumns, colGroupDef, level, existingColumns, columnKeyCreator, existingGroups, source) {
        const groupId = columnKeyCreator.getUniqueKey(colGroupDef.groupId || null, null);
        const colGroupDefMerged = (0, columnGroupUtils_1.createMergedColGroupDef)(this.beans, colGroupDef, groupId);
        const providedGroup = new agProvidedColumnGroup_1.AgProvidedColumnGroup(colGroupDefMerged, groupId, false, level);
        this.createBean(providedGroup);
        const existingGroupAndIndex = this.findExistingGroup(colGroupDef, existingGroups);
        // make sure we remove, so if user provided duplicate id, then we don't have more than
        // one column instance for colDef with common id
        if (existingGroupAndIndex) {
            existingGroups.splice(existingGroupAndIndex.idx, 1);
        }
        const existingGroup = existingGroupAndIndex?.group;
        if (existingGroup) {
            providedGroup.setExpanded(existingGroup.isExpanded());
        }
        const children = (0, columnFactoryUtils_1._recursivelyCreateColumns)(this.beans, colGroupDefMerged.children, level + 1, primaryColumns, existingColumns, columnKeyCreator, existingGroups, source);
        providedGroup.setChildren(children);
        return providedGroup;
    }
    balanceColumnTree(unbalancedTree, currentDepth, columnDepth, columnKeyCreator) {
        const result = [];
        // go through each child, for groups, recurse a level deeper,
        // for columns we need to pad
        for (let i = 0; i < unbalancedTree.length; i++) {
            const child = unbalancedTree[i];
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(child)) {
                // child is a group, all we do is go to the next level of recursion
                const originalGroup = child;
                const newChildren = this.balanceColumnTree(originalGroup.getChildren(), currentDepth + 1, columnDepth, columnKeyCreator);
                originalGroup.setChildren(newChildren);
                result.push(originalGroup);
            }
            else {
                // child is a column - so here we add in the padded column groups if needed
                let firstPaddedGroup;
                let currentPaddedGroup;
                // this for loop will NOT run any loops if no padded column groups are needed
                for (let j = currentDepth; j < columnDepth; j++) {
                    const newColId = columnKeyCreator.getUniqueKey(null, null);
                    const colGroupDefMerged = (0, columnGroupUtils_1.createMergedColGroupDef)(this.beans, null, newColId);
                    const paddedGroup = new agProvidedColumnGroup_1.AgProvidedColumnGroup(colGroupDefMerged, newColId, true, j);
                    this.createBean(paddedGroup);
                    if (currentPaddedGroup) {
                        currentPaddedGroup.setChildren([paddedGroup]);
                    }
                    currentPaddedGroup = paddedGroup;
                    if (!firstPaddedGroup) {
                        firstPaddedGroup = currentPaddedGroup;
                    }
                }
                // likewise this if statement will not run if no padded groups
                if (firstPaddedGroup && currentPaddedGroup) {
                    result.push(firstPaddedGroup);
                    const hasGroups = unbalancedTree.some((leaf) => (0, agProvidedColumnGroup_2.isProvidedColumnGroup)(leaf));
                    if (hasGroups) {
                        currentPaddedGroup.setChildren([child]);
                        continue;
                    }
                    else {
                        currentPaddedGroup.setChildren(unbalancedTree);
                        break;
                    }
                }
                result.push(child);
            }
        }
        return result;
    }
    findDepth(balancedColumnTree) {
        let depth = 0;
        let pointer = balancedColumnTree;
        while (pointer && pointer[0] && (0, agProvidedColumnGroup_2.isProvidedColumnGroup)(pointer[0])) {
            depth++;
            pointer = pointer[0].getChildren();
        }
        return depth;
    }
    findMaxDepth(treeChildren, depth) {
        let maxDepthThisLevel = depth;
        for (let i = 0; i < treeChildren.length; i++) {
            const abstractColumn = treeChildren[i];
            if ((0, agProvidedColumnGroup_2.isProvidedColumnGroup)(abstractColumn)) {
                const originalGroup = abstractColumn;
                const newDepth = this.findMaxDepth(originalGroup.getChildren(), depth + 1);
                if (maxDepthThisLevel < newDepth) {
                    maxDepthThisLevel = newDepth;
                }
            }
        }
        return maxDepthThisLevel;
    }
    /**
     * Inserts dummy group columns in the hierarchy above auto-generated columns
     * in order to ensure auto-generated columns are leaf nodes (and therefore are
     * displayed correctly)
     */
    balanceTreeForAutoCols(autoCols, depth) {
        const tree = [];
        autoCols.forEach((col) => {
            // at the end, this will be the top of the tree item.
            let nextChild = col;
            for (let i = depth - 1; i >= 0; i--) {
                const autoGroup = new agProvidedColumnGroup_1.AgProvidedColumnGroup(null, `FAKE_PATH_${col.getId()}}_${i}`, true, i);
                this.createBean(autoGroup);
                autoGroup.setChildren([nextChild]);
                nextChild.originalParent = autoGroup;
                nextChild = autoGroup;
            }
            if (depth === 0) {
                col.originalParent = null;
            }
            // at this point, the nextChild is the top most item in the tree
            tree.push(nextChild);
        });
        return tree;
    }
    findExistingGroup(newGroupDef, existingGroups) {
        const newHasId = newGroupDef.groupId != null;
        if (!newHasId) {
            return undefined;
        }
        for (let i = 0; i < existingGroups.length; i++) {
            const existingGroup = existingGroups[i];
            const existingDef = existingGroup.getColGroupDef();
            if (!existingDef) {
                continue;
            }
            if (existingGroup.getId() === newGroupDef.groupId) {
                return { idx: i, group: existingGroup };
            }
        }
        return undefined;
    }
    createColumnGroup(providedGroup, groupInstanceIdCreator, oldColumnsMapped, pinned, isStandaloneStructure) {
        const groupId = providedGroup.getGroupId();
        const instanceId = groupInstanceIdCreator.getInstanceIdForKey(groupId);
        const uniqueId = (0, agColumnGroup_1.createUniqueColumnGroupId)(groupId, instanceId);
        let columnGroup = oldColumnsMapped[uniqueId];
        // if the user is setting new colDefs, it is possible that the id's overlap, and we
        // would have a false match from above. so we double check we are talking about the
        // same original column group.
        if (columnGroup && columnGroup.getProvidedColumnGroup() !== providedGroup) {
            columnGroup = null;
        }
        if ((0, generic_1._exists)(columnGroup)) {
            // clean out the old column group here, as we will be adding children into it again
            columnGroup.reset();
        }
        else {
            columnGroup = new agColumnGroup_2.AgColumnGroup(providedGroup, groupId, instanceId, pinned);
            if (!isStandaloneStructure) {
                this.createBean(columnGroup);
            }
        }
        return columnGroup;
    }
    // returns back a 2d map of ColumnGroup as follows: groupId -> instanceId -> ColumnGroup
    mapOldGroupsById(displayedGroups) {
        const result = {};
        const recursive = (columnsOrGroups) => {
            columnsOrGroups.forEach((columnOrGroup) => {
                if ((0, agColumnGroup_1.isColumnGroup)(columnOrGroup)) {
                    const columnGroup = columnOrGroup;
                    result[columnOrGroup.getUniqueId()] = columnGroup;
                    recursive(columnGroup.getChildren());
                }
            });
        };
        if (displayedGroups) {
            recursive(displayedGroups);
        }
        return result;
    }
    setupParentsIntoCols(columnsOrGroups, parent) {
        columnsOrGroups.forEach((columnsOrGroup) => {
            if (columnsOrGroup.parent !== parent) {
                // parent has explicitly changed - force viewport headers now needed.
                this.beans.colViewport.colsWithinViewportHash = '';
            }
            columnsOrGroup.parent = parent;
            if ((0, agColumnGroup_1.isColumnGroup)(columnsOrGroup)) {
                const columnGroup = columnsOrGroup;
                this.setupParentsIntoCols(columnGroup.getChildren(), columnGroup);
            }
        });
    }
}
exports.ColumnGroupService = ColumnGroupService;


/***/ }),

/***/ 70820:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createMergedColGroupDef = void 0;
function createMergedColGroupDef(beans, colGroupDef, groupId) {
    const colGroupDefMerged = {};
    const gos = beans.gos;
    Object.assign(colGroupDefMerged, gos.get('defaultColGroupDef'));
    Object.assign(colGroupDefMerged, colGroupDef);
    gos.validateColDef(colGroupDefMerged, groupId);
    return colGroupDefMerged;
}
exports.createMergedColGroupDef = createMergedColGroupDef;


/***/ }),

/***/ 3156:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isColumnHovered = void 0;
function isColumnHovered(beans, column) {
    return !!beans.colHover?.isHovered(column);
}
exports.isColumnHovered = isColumnHovered;


/***/ }),

/***/ 41690:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnHoverModule = void 0;
const version_1 = __webpack_require__(97205);
const columnHoverApi_1 = __webpack_require__(3156);
const columnHoverService_1 = __webpack_require__(57683);
/**
 * @feature Rows -> Styling Rows
 * @gridOption columnHoverHighlight
 */
exports.ColumnHoverModule = {
    moduleName: 'ColumnHover',
    version: version_1.VERSION,
    beans: [columnHoverService_1.ColumnHoverService],
    apiFunctions: {
        isColumnHovered: columnHoverApi_1.isColumnHovered,
    },
};


/***/ }),

/***/ 57683:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnHoverService = void 0;
const beanStub_1 = __webpack_require__(68731);
const hoverFeature_1 = __webpack_require__(75788);
const CSS_COLUMN_HOVER = 'ag-column-hover';
class ColumnHoverService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colHover';
    }
    postConstruct() {
        this.addManagedPropertyListener('columnHoverHighlight', ({ currentValue }) => {
            if (!currentValue) {
                this.clearMouseOver();
            }
        });
    }
    setMouseOver(columns) {
        this.updateState(columns);
    }
    clearMouseOver() {
        this.updateState(null);
    }
    isHovered(column) {
        if (!this.gos.get('columnHoverHighlight')) {
            return false;
        }
        const selectedColumns = this.selectedColumns;
        return !!selectedColumns && selectedColumns.indexOf(column) >= 0;
    }
    addHeaderColumnHoverListener(compBean, comp, column) {
        const listener = () => {
            const isHovered = this.isHovered(column);
            comp.toggleCss('ag-column-hover', isHovered);
        };
        compBean.addManagedEventListeners({ columnHoverChanged: listener });
        listener();
    }
    onCellColumnHover(column, cellComp) {
        if (!cellComp) {
            return;
        }
        const isHovered = this.isHovered(column);
        cellComp.toggleCss(CSS_COLUMN_HOVER, isHovered);
    }
    addHeaderFilterColumnHoverListener(compBean, comp, column, eGui) {
        this.createHoverFeature(compBean, [column], eGui);
        const listener = () => {
            const hovered = this.isHovered(column);
            comp.toggleCss('ag-column-hover', hovered);
        };
        compBean.addManagedEventListeners({ columnHoverChanged: listener });
        listener();
    }
    createHoverFeature(compBean, columns, eGui) {
        compBean.createManagedBean(new hoverFeature_1.HoverFeature(columns, eGui));
    }
    updateState(columns) {
        this.selectedColumns = columns;
        this.eventSvc.dispatchEvent({
            type: 'columnHoverChanged',
        });
    }
}
exports.ColumnHoverService = ColumnHoverService;


/***/ }),

/***/ 75788:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HoverFeature = void 0;
const beanStub_1 = __webpack_require__(68731);
class HoverFeature extends beanStub_1.BeanStub {
    constructor(columns, element) {
        super();
        this.columns = columns;
        this.element = element;
        this.destroyManagedListeners = [];
        this.enableFeature = (enabled) => {
            const { beans, gos, element, columns } = this;
            const colHover = beans.colHover;
            const active = enabled ?? !!gos.get('columnHoverHighlight');
            if (active) {
                this.destroyManagedListeners = this.addManagedElementListeners(element, {
                    mouseover: colHover.setMouseOver.bind(colHover, columns),
                    mouseout: colHover.clearMouseOver.bind(colHover),
                });
            }
            else {
                this.destroyManagedListeners.forEach((fn) => fn());
                this.destroyManagedListeners = [];
            }
        };
    }
    postConstruct() {
        this.addManagedPropertyListener('columnHoverHighlight', ({ currentValue }) => {
            this.enableFeature(currentValue);
        });
        this.enableFeature();
    }
    destroy() {
        super.destroy();
        this.destroyManagedListeners = null;
    }
}
exports.HoverFeature = HoverFeature;


/***/ }),

/***/ 2294:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnKeyCreator = void 0;
// class returns a unique id to use for the column. it checks the existing columns, and if the requested
// id is already taken, it will start appending numbers until it gets a unique id.
// eg, if the col field is 'name', it will try ids: {name, name_1, name_2...}
// if no field or id provided in the col, it will try the ids of natural numbers
const generic_1 = __webpack_require__(89097);
const logging_1 = __webpack_require__(47764);
class ColumnKeyCreator {
    constructor() {
        this.existingKeys = {};
    }
    addExistingKeys(keys) {
        for (let i = 0; i < keys.length; i++) {
            this.existingKeys[keys[i]] = true;
        }
    }
    getUniqueKey(colId, colField) {
        // in case user passed in number for colId, convert to string
        colId = (0, generic_1._toStringOrNull)(colId);
        let count = 0;
        while (true) {
            let idToTry = colId ?? colField;
            if (idToTry) {
                if (count !== 0) {
                    idToTry += '_' + count;
                }
            }
            else {
                // no point in stringing this, object treats it the same anyway.
                idToTry = count;
            }
            if (!this.existingKeys[idToTry]) {
                const usedId = String(idToTry);
                if (colId && count > 0) {
                    (0, logging_1._warn)(273, { providedId: colId, usedId });
                }
                this.existingKeys[usedId] = true;
                return usedId;
            }
            count++;
        }
    }
}
exports.ColumnKeyCreator = ColumnKeyCreator;


/***/ }),

/***/ 72986:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnModel = void 0;
const array_1 = __webpack_require__(79909);
const columnMoveUtils_1 = __webpack_require__(23505);
const beanStub_1 = __webpack_require__(68731);
const agColumn_1 = __webpack_require__(13355);
const gridOptionsUtils_1 = __webpack_require__(67274);
const columnFactoryUtils_1 = __webpack_require__(82716);
const columnStateUtils_1 = __webpack_require__(2885);
const columnUtils_1 = __webpack_require__(73146);
class ColumnModel extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colModel';
        // if pivotMode is on, however pivot results are NOT shown if no pivot columns are set
        this.pivotMode = false;
        this.ready = false;
        this.changeEventsDispatching = false;
    }
    postConstruct() {
        this.pivotMode = this.gos.get('pivotMode');
        this.addManagedPropertyListeners([
            'groupDisplayType',
            'treeData',
            'treeDataDisplayType',
            'groupHideOpenParents',
            'rowNumbers',
            'hidePaddedHeaderRows',
        ], (event) => this.refreshAll((0, columnUtils_1._convertColumnEventSourceType)(event.source)));
        this.addManagedPropertyListeners(['defaultColDef', 'defaultColGroupDef', 'columnTypes', 'suppressFieldDotNotation'], this.recreateColumnDefs.bind(this));
        this.addManagedPropertyListener('pivotMode', (event) => this.setPivotMode(this.gos.get('pivotMode'), (0, columnUtils_1._convertColumnEventSourceType)(event.source)));
    }
    // called from SyncService, when grid has finished initialising
    createColsFromColDefs(source) {
        const { beans } = this;
        const { valueCache, colAutosize, rowGroupColsSvc, pivotColsSvc, valueColsSvc, visibleCols, eventSvc, groupHierarchyColSvc, } = beans;
        // only need to dispatch before/after events if updating columns, never if setting columns for first time
        const dispatchEventsFunc = this.colDefs ? (0, columnStateUtils_1._compareColumnStatesAndDispatchEvents)(beans, source) : undefined;
        // always invalidate cache on changing columns, as the column id's for the new columns
        // could overlap with the old id's, so the cache would return old values for new columns.
        valueCache?.expire();
        const oldCols = this.colDefCols?.list;
        const oldTree = this.colDefCols?.tree;
        const newTree = (0, columnFactoryUtils_1._createColumnTree)(beans, this.colDefs, true, oldTree, source);
        (0, columnUtils_1._destroyColumnTree)(beans, this.colDefCols?.tree, newTree.columnTree);
        const tree = newTree.columnTree;
        const treeDepth = newTree.treeDepth;
        const list = (0, columnUtils_1._getColumnsFromTree)(tree);
        const map = {};
        list.forEach((col) => (map[col.getId()] = col));
        this.colDefCols = { tree, treeDepth, list, map };
        // Must create dateHierarchy columns before rowGroupSvc and pivotSvc run
        // so that any groupable date columns exist beforehand.
        this.createColumnsForService([groupHierarchyColSvc], this.colDefCols);
        rowGroupColsSvc?.extractCols(source, oldCols);
        pivotColsSvc?.extractCols(source, oldCols);
        valueColsSvc?.extractCols(source, oldCols);
        this.ready = true;
        this.refreshCols(true);
        visibleCols.refresh(source);
        // this event is not used by AG Grid, but left here for backwards compatibility,
        // in case applications use it
        eventSvc.dispatchEvent({
            type: 'columnEverythingChanged',
            source,
        });
        // Row Models react to all of these events as well as new columns loaded,
        // this flag instructs row model to ignore these events to reduce refreshes.
        if (dispatchEventsFunc) {
            this.changeEventsDispatching = true;
            dispatchEventsFunc();
            this.changeEventsDispatching = false;
        }
        eventSvc.dispatchEvent({
            type: 'newColumnsLoaded',
            source,
        });
        if (source === 'gridInitializing') {
            colAutosize?.applyAutosizeStrategy();
        }
    }
    // called from: buildAutoGroupColumns (events 'groupDisplayType', 'treeData', 'treeDataDisplayType', 'groupHideOpenParents')
    // createColsFromColDefs (recreateColumnDefs, setColumnsDefs),
    // setPivotMode, applyColumnState,
    // functionColsService.setPrimaryColList, functionColsService.updatePrimaryColList,
    // pivotResultCols.setPivotResultCols
    refreshCols(newColDefs) {
        if (!this.colDefCols) {
            return;
        }
        const prevColTree = this.cols?.tree;
        this.saveColOrder();
        const { autoColSvc, selectionColSvc, rowNumbersSvc, quickFilter, pivotResultCols, showRowGroupCols, rowAutoHeight, visibleCols, colViewport, eventSvc, } = this.beans;
        const cols = this.selectCols(pivotResultCols, this.colDefCols);
        this.createColumnsForService([autoColSvc, selectionColSvc, rowNumbersSvc], cols);
        const shouldSortNewColDefs = (0, gridOptionsUtils_1._shouldMaintainColumnOrder)(this.gos, this.showingPivotResult);
        if (!newColDefs || shouldSortNewColDefs) {
            this.restoreColOrder(cols);
        }
        this.positionLockedCols(cols);
        showRowGroupCols?.refresh();
        quickFilter?.refreshCols();
        this.setColSpanActive();
        rowAutoHeight?.setAutoHeightActive(cols);
        // make sure any part of the gui that tries to draw, eg the header,
        // will get empty lists of columns rather than stale columns.
        // for example, the header will received gridColumnsChanged event, so will try and draw,
        // but it will draw successfully when it acts on the virtualColumnsChanged event
        visibleCols.clear();
        colViewport.clear();
        const dispatchChangedEvent = !(0, array_1._areEqual)(prevColTree, this.cols.tree);
        if (dispatchChangedEvent) {
            eventSvc.dispatchEvent({
                type: 'gridColumnsChanged',
            });
        }
    }
    createColumnsForService(services, cols) {
        for (const service of services) {
            if (!service) {
                continue;
            }
            service.createColumns(cols, (updateOrder) => {
                this.lastOrder = updateOrder(this.lastOrder);
                this.lastPivotOrder = updateOrder(this.lastPivotOrder);
            });
            service.addColumns(cols);
        }
    }
    selectCols(pivotResultColsSvc, colDefCols) {
        const pivotResultCols = pivotResultColsSvc?.getPivotResultCols() ?? null;
        this.showingPivotResult = pivotResultCols != null;
        const { map, list, tree, treeDepth } = pivotResultCols ?? colDefCols;
        this.cols = {
            list: list.slice(),
            map: { ...map },
            tree: tree.slice(),
            treeDepth,
        };
        if (pivotResultCols) {
            // If the current columns are the same or a subset of the previous
            // we keep the previous order, otherwise we go back to the order the pivot
            // cols are generated in
            const hasSameColumns = pivotResultCols.list.some((col) => this.cols?.map[col.getColId()] !== undefined);
            if (!hasSameColumns) {
                this.lastPivotOrder = null;
            }
        }
        return this.cols;
    }
    getColsToShow() {
        if (!this.cols) {
            return [];
        }
        // pivot mode is on, but we are not pivoting, so we only
        // show columns we are aggregating on and possibly the selection/row numbers column
        const { valueColsSvc, selectionColSvc, gos } = this.beans;
        const showAutoGroupAndValuesOnly = this.isPivotMode() && !this.showingPivotResult;
        const showSelectionColumn = selectionColSvc?.isSelectionColumnEnabled();
        const showRowNumbers = gos.get('rowNumbers');
        const valueColumns = valueColsSvc?.columns;
        const res = this.cols.list.filter((col) => {
            const isAutoGroupCol = (0, columnUtils_1.isColumnGroupAutoCol)(col);
            if (showAutoGroupAndValuesOnly) {
                const isValueCol = valueColumns?.includes(col);
                return (isAutoGroupCol ||
                    isValueCol ||
                    (showSelectionColumn && (0, columnUtils_1.isColumnSelectionCol)(col)) ||
                    (showRowNumbers && (0, columnUtils_1.isRowNumberCol)(col)));
            }
            else {
                // keep col if a) it's auto-group or b) it's visible
                return isAutoGroupCol || col.isVisible();
            }
        });
        return res;
    }
    // on events 'groupDisplayType', 'treeData', 'treeDataDisplayType', 'groupHideOpenParents'
    refreshAll(source) {
        if (!this.ready) {
            return;
        }
        this.refreshCols(false);
        this.beans.visibleCols.refresh(source);
    }
    setColsVisible(keys, visible = false, source) {
        (0, columnStateUtils_1._applyColumnState)(this.beans, {
            state: keys.map((key) => ({
                colId: typeof key === 'string' ? key : key.getColId(),
                hide: !visible,
            })),
        }, source);
    }
    /**
     * Restores provided columns order to the previous order in this.lastPivotOrder / this.lastOrder
     * If columns are not in the last order:
     *  - Check column groups, and apply column after the last column in the lowest shared group
     *  - If no sibling is found, apply the column at the end of the cols
     */
    restoreColOrder(cols) {
        const lastOrder = this.showingPivotResult ? this.lastPivotOrder : this.lastOrder;
        if (!lastOrder) {
            return;
        }
        // get the cols present in both new list and last order, according to the last order
        const preservedOrder = lastOrder.filter((col) => cols.map[col.getId()] != null);
        // if no cols in last order are in the new, then order is already correct
        if (preservedOrder.length === 0) {
            return;
        }
        // if after removing all the cols that are not in the new set, we have no cols left,
        // then we don't need to do anything further, as the new order is correct.
        if (preservedOrder.length === cols.list.length) {
            cols.list = preservedOrder;
            return;
        }
        const hasSiblings = (col) => {
            const ancestor = col.getOriginalParent();
            if (!ancestor) {
                return false;
            }
            const children = ancestor.getChildren();
            if (children.length > 1) {
                return true;
            }
            return hasSiblings(ancestor);
        };
        // if none of the preserved cols have siblings; shortcut, as all new cols can be added to the end
        // this is a common scenario due to generated cols.
        if (!preservedOrder.some((col) => hasSiblings(col))) {
            const preservedOrderSet = new Set(preservedOrder);
            for (const col of cols.list) {
                if (!preservedOrderSet.has(col)) {
                    preservedOrder.push(col);
                }
            }
            cols.list = preservedOrder;
            return;
        }
        // create map of known col positions and their indices
        const colPositionMap = new Map();
        for (let i = 0; i < preservedOrder.length; i++) {
            const col = preservedOrder[i];
            colPositionMap.set(col, i);
        }
        // find any cols that have been introduced that are not in the last order
        const additionalCols = cols.list.filter((col) => !colPositionMap.has(col));
        // no additional cols to be inserted, probably means cols were removed, but preserved order is correct.
        if (additionalCols.length === 0) {
            cols.list = preservedOrder;
            return;
        }
        // Function finds the sibling with the lowest shared parent and highest index in last order
        const getPreviousSibling = (col, group) => {
            const parent = group ? group.getOriginalParent() : col.getOriginalParent();
            if (!parent) {
                return null;
            }
            let highestIdx = null;
            let highestSibling = null;
            for (const child of parent.getChildren()) {
                // shortcut - skip the group that has already been processed
                if (child === group || child === col) {
                    continue;
                }
                if (child instanceof agColumn_1.AgColumn) {
                    const colIdx = colPositionMap.get(child);
                    // if col does not exist in last order, skip
                    if (colIdx == null) {
                        continue;
                    }
                    if (highestIdx == null || highestIdx < colIdx) {
                        highestIdx = colIdx;
                        highestSibling = child;
                    }
                    continue;
                }
                child.forEachLeafColumn((leafCol) => {
                    const colIdx = colPositionMap.get(leafCol);
                    // if col does not exist in last order, skip
                    if (colIdx == null) {
                        return;
                    }
                    if (highestIdx == null || highestIdx < colIdx) {
                        highestIdx = colIdx;
                        highestSibling = leafCol;
                    }
                });
            }
            if (highestSibling == null) {
                return getPreviousSibling(col, parent);
            }
            return highestSibling;
        };
        // array of cols that have no siblings in the last order, to be added at the tail of the results
        const noSiblingsAvailable = [];
        // map is keyed by cols in last order, and values are the cols that should be added after them
        // in results array
        const previousSiblingPosMap = new Map();
        // for each new col, find the col it needs inserted after and store for when array is constructed
        for (const col of additionalCols) {
            const prevSiblingIdx = getPreviousSibling(col, null);
            if (prevSiblingIdx == null) {
                noSiblingsAvailable.push(col);
                continue;
            }
            const prev = previousSiblingPosMap.get(prevSiblingIdx);
            if (prev === undefined) {
                previousSiblingPosMap.set(prevSiblingIdx, col);
            }
            else if (Array.isArray(prev)) {
                prev.push(col);
            }
            else {
                // if we have a single col, then we need to add the new col to the array
                previousSiblingPosMap.set(prevSiblingIdx, [prev, col]);
            }
        }
        // the following code starts at the tail of the array and works backwards.
        // first it applies all of the cols with no siblings (so no location in last order)
        // then it works backwards through the preserved order - when a col has siblings, it adds
        // them to the array and then adds the col itself.
        const result = new Array(cols.list.length);
        let resultPointer = result.length - 1;
        // work backwards, first adding no siblings to end
        for (let i = noSiblingsAvailable.length - 1; i >= 0; i--) {
            result[resultPointer--] = noSiblingsAvailable[i];
        }
        for (let i = preservedOrder.length - 1; i >= 0; i--) {
            const nextCol = preservedOrder[i];
            const extraCols = previousSiblingPosMap.get(nextCol);
            if (extraCols) {
                if (Array.isArray(extraCols)) {
                    // add the extra cols backwards.
                    for (let x = extraCols.length - 1; x >= 0; x--) {
                        const col = extraCols[x];
                        result[resultPointer--] = col;
                    }
                }
                else {
                    result[resultPointer--] = extraCols;
                }
            }
            result[resultPointer--] = nextCol;
        }
        cols.list = result;
    }
    positionLockedCols(cols) {
        cols.list = (0, columnMoveUtils_1.placeLockedColumns)(cols.list, this.gos);
    }
    saveColOrder() {
        if (this.showingPivotResult) {
            this.lastPivotOrder = this.cols?.list ?? null;
        }
        else {
            this.lastOrder = this.cols?.list ?? null;
        }
    }
    getColumnDefs() {
        return this.colDefCols
            ? this.beans.colDefFactory?.getColumnDefs(this.colDefCols.list, this.showingPivotResult, this.lastOrder, this.cols?.list ?? [])
            : undefined;
    }
    setColSpanActive() {
        this.colSpanActive = !!this.cols?.list.some((col) => col.getColDef().colSpan != null);
    }
    isPivotMode() {
        return this.pivotMode;
    }
    setPivotMode(pivotMode, source) {
        if (pivotMode === this.pivotMode) {
            return;
        }
        this.pivotMode = pivotMode;
        if (!this.ready) {
            return;
        }
        // we need to update grid columns to cover the scenario where user has groupDisplayType = 'custom', as
        // this means we don't use auto group column UNLESS we are in pivot mode (it's mandatory in pivot mode),
        // so need to updateCols() to check it autoGroupCol needs to be added / removed
        this.refreshCols(false);
        const { visibleCols, eventSvc } = this.beans;
        visibleCols.refresh(source);
        eventSvc.dispatchEvent({
            type: 'columnPivotModeChanged',
        });
    }
    // + clientSideRowModel
    isPivotActive() {
        const pivotColumns = this.beans.pivotColsSvc?.columns;
        return this.pivotMode && !!pivotColumns?.length;
    }
    // called when dataTypes change
    recreateColumnDefs(e) {
        if (!this.cols) {
            return;
        }
        // if we aren't going to force, update the auto cols in place
        this.beans.autoColSvc?.updateColumns(e);
        const source = (0, columnUtils_1._convertColumnEventSourceType)(e.source);
        this.createColsFromColDefs(source);
    }
    setColumnDefs(columnDefs, source) {
        this.colDefs = columnDefs;
        this.createColsFromColDefs(source);
    }
    destroy() {
        (0, columnUtils_1._destroyColumnTree)(this.beans, this.colDefCols?.tree);
        super.destroy();
    }
    getColTree() {
        return this.cols?.tree ?? [];
    }
    // + columnSelectPanel
    getColDefColTree() {
        return this.colDefCols?.tree ?? [];
    }
    // + clientSideRowController -> sorting, building quick filter text
    // + headerRenderer -> sorting (clearing icon)
    getColDefCols() {
        return this.colDefCols?.list ?? null;
    }
    // + moveColumnController
    getCols() {
        return this.cols?.list ?? [];
    }
    forAllCols(callback) {
        const { pivotResultCols, autoColSvc, selectionColSvc, groupHierarchyColSvc } = this.beans;
        (0, array_1._forAll)(this.colDefCols?.list, callback);
        (0, array_1._forAll)(autoColSvc?.columns?.list, callback);
        (0, array_1._forAll)(selectionColSvc?.columns?.list, callback);
        (0, array_1._forAll)(groupHierarchyColSvc?.columns?.list, callback);
        (0, array_1._forAll)(pivotResultCols?.getPivotResultCols()?.list, callback);
    }
    getColsForKeys(keys) {
        if (!keys) {
            return [];
        }
        return keys.map((key) => this.getCol(key)).filter((col) => col != null);
    }
    getColDefCol(key) {
        if (!this.colDefCols?.list) {
            return null;
        }
        return this.getColFromCollection(key, this.colDefCols);
    }
    getCol(key) {
        if (key == null) {
            return null;
        }
        return this.getColFromCollection(key, this.cols);
    }
    /**
     * Get column exclusively by ID.
     *
     * Note getCol/getColFromCollection have poor performance when col has been removed.
     */
    getColById(key) {
        return this.cols?.map[key] ?? null;
    }
    getColFromCollection(key, cols) {
        if (cols == null) {
            return null;
        }
        const { map, list } = cols;
        // most of the time this method gets called the key is a string, so we put this shortcut in
        // for performance reasons, to see if we can match for ID (it doesn't do auto columns, that's done below)
        if (typeof key == 'string' && map[key]) {
            return map[key];
        }
        for (let i = 0; i < list.length; i++) {
            if ((0, columnUtils_1._columnsMatch)(list[i], key)) {
                return list[i];
            }
        }
        const { autoColSvc, selectionColSvc, groupHierarchyColSvc } = this.beans;
        return (autoColSvc?.getColumn(key) ??
            selectionColSvc?.getColumn(key) ??
            groupHierarchyColSvc?.getColumn(key) ??
            null);
    }
}
exports.ColumnModel = ColumnModel;


/***/ }),

/***/ 52027:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnApiModule = exports.ColumnFlexModule = exports.DataTypeModule = void 0;
const cellRendererModule_1 = __webpack_require__(37358);
const version_1 = __webpack_require__(97205);
const columnApi_1 = __webpack_require__(68763);
const columnDefFactory_1 = __webpack_require__(44604);
const columnFlexService_1 = __webpack_require__(82849);
const dataTypeService_1 = __webpack_require__(96350);
/**
 * @internal
 */
exports.DataTypeModule = {
    moduleName: 'DataType',
    version: version_1.VERSION,
    beans: [dataTypeService_1.DataTypeService],
    dependsOn: [cellRendererModule_1.CheckboxCellRendererModule],
};
/**
 * @internal
 */
exports.ColumnFlexModule = {
    moduleName: 'ColumnFlex',
    version: version_1.VERSION,
    beans: [columnFlexService_1.ColumnFlexService],
};
/**
 * @feature Columns
 */
exports.ColumnApiModule = {
    moduleName: 'ColumnApi',
    version: version_1.VERSION,
    beans: [columnDefFactory_1.ColumnDefFactory],
    apiFunctions: {
        getColumnDef: columnApi_1.getColumnDef,
        getDisplayNameForColumn: columnApi_1.getDisplayNameForColumn,
        getColumn: columnApi_1.getColumn,
        getColumns: columnApi_1.getColumns,
        applyColumnState: columnApi_1.applyColumnState,
        getColumnState: columnApi_1.getColumnState,
        resetColumnState: columnApi_1.resetColumnState,
        isPinning: columnApi_1.isPinning,
        isPinningLeft: columnApi_1.isPinningLeft,
        isPinningRight: columnApi_1.isPinningRight,
        getDisplayedColAfter: columnApi_1.getDisplayedColAfter,
        getDisplayedColBefore: columnApi_1.getDisplayedColBefore,
        setColumnsVisible: columnApi_1.setColumnsVisible,
        setColumnsPinned: columnApi_1.setColumnsPinned,
        getAllGridColumns: columnApi_1.getAllGridColumns,
        getDisplayedLeftColumns: columnApi_1.getDisplayedLeftColumns,
        getDisplayedCenterColumns: columnApi_1.getDisplayedCenterColumns,
        getDisplayedRightColumns: columnApi_1.getDisplayedRightColumns,
        getAllDisplayedColumns: columnApi_1.getAllDisplayedColumns,
        getAllDisplayedVirtualColumns: columnApi_1.getAllDisplayedVirtualColumns,
        getColumnDefs: columnApi_1.getColumnDefs,
    },
};


/***/ }),

/***/ 48997:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnNameService = void 0;
const beanStub_1 = __webpack_require__(68731);
const gridOptionsUtils_1 = __webpack_require__(67274);
/**
 * Converts a camelCase string into startCase
 * @param {string} camelCase
 * @returns {string}
 */
function _camelCaseToHumanText(camelCase) {
    if (!camelCase || camelCase == null) {
        return null;
    }
    // either split on a lowercase followed by uppercase ie  asHereTo -> as Here To
    const rex = /([a-z])([A-Z])/g;
    // or starts with uppercase and we take all expect the last which is assumed to be part of next word if followed by lowercase HEREToThere -> HERE To There
    const rexCaps = /([A-Z]+)([A-Z])([a-z])/g;
    const words = camelCase.replace(rex, '$1 $2').replace(rexCaps, '$1 $2$3').replace(/\./g, ' ').split(' ');
    return words
        .map((word) => word.substring(0, 1).toUpperCase() + (word.length > 1 ? word.substring(1, word.length) : ''))
        .join(' ');
}
class ColumnNameService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colNames';
    }
    getDisplayNameForColumn(column, location, includeAggFunc = false) {
        if (!column) {
            return null;
        }
        const headerName = this.getHeaderName(column.getColDef(), column, null, null, location);
        const { aggColNameSvc } = this.beans;
        if (includeAggFunc && aggColNameSvc) {
            return aggColNameSvc.getHeaderName(column, headerName);
        }
        return headerName;
    }
    getDisplayNameForProvidedColumnGroup(columnGroup, providedColumnGroup, location) {
        const colGroupDef = providedColumnGroup?.getColGroupDef();
        if (colGroupDef) {
            return this.getHeaderName(colGroupDef, null, columnGroup, providedColumnGroup, location);
        }
        return null;
    }
    getDisplayNameForColumnGroup(columnGroup, location) {
        return this.getDisplayNameForProvidedColumnGroup(columnGroup, columnGroup.getProvidedColumnGroup(), location);
    }
    // location is where the column is going to appear, ie who is calling us
    getHeaderName(colDef, column, columnGroup, providedColumnGroup, location) {
        const headerValueGetter = colDef.headerValueGetter;
        if (headerValueGetter) {
            const params = (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
                colDef: colDef,
                column: column,
                columnGroup: columnGroup,
                providedColumnGroup: providedColumnGroup,
                location: location,
            });
            if (typeof headerValueGetter === 'function') {
                // valueGetter is a function, so just call it
                return headerValueGetter(params);
            }
            else if (typeof headerValueGetter === 'string') {
                // valueGetter is an expression, so execute the expression
                return this.beans.expressionSvc?.evaluate(headerValueGetter, params) ?? null;
            }
            return '';
        }
        else if (colDef.headerName != null) {
            return colDef.headerName;
        }
        else if (colDef.field) {
            return _camelCaseToHumanText(colDef.field);
        }
        return '';
    }
}
exports.ColumnNameService = ColumnNameService;


/***/ }),

/***/ 2885:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getColumnStateFromColDef = exports._getColumnState = exports._compareColumnStatesAndDispatchEvents = exports._resetColumnState = exports._applyColumnState = void 0;
const array_1 = __webpack_require__(79909);
const generic_1 = __webpack_require__(89097);
const columnMoveUtils_1 = __webpack_require__(23505);
const gridOptionsUtils_1 = __webpack_require__(67274);
const logging_1 = __webpack_require__(47764);
const columnEventUtils_1 = __webpack_require__(72934);
const columnFactoryUtils_1 = __webpack_require__(82716);
const columnUtils_1 = __webpack_require__(73146);
function _applyColumnState(beans, params, source) {
    const { colModel, rowGroupColsSvc, pivotColsSvc, autoColSvc, selectionColSvc, colAnimation, visibleCols, pivotResultCols, environment, valueColsSvc, eventSvc, gos, } = beans;
    const providedCols = colModel.getColDefCols() ?? [];
    const selectionCols = selectionColSvc?.getColumns();
    if (!providedCols.length && !selectionCols?.length) {
        return false;
    }
    if (params?.state && !params.state.forEach) {
        // state is not an array
        (0, logging_1._warn)(32);
        return false;
    }
    const syncColumnWithStateItem = (column, stateItem, rowGroupIndexes, pivotIndexes, autoCol) => {
        if (!column) {
            return;
        }
        const getValue = (0, columnUtils_1.getValueFactory)(stateItem, params.defaultState);
        const flex = getValue('flex').value1;
        (0, columnFactoryUtils_1.updateSomeColumnState)(beans, column, getValue('hide').value1, getValue('sort').value1, getValue('sortIndex').value1, getValue('pinned').value1, flex, source);
        // if flex is null or undefined, fall back to setting width
        if (flex == null) {
            // if no flex, then use width if it's there
            const width = getValue('width').value1;
            if (width != null) {
                // if width provided and valid, use it, otherwise stick with the old width
                const minColWidth = column.getColDef().minWidth ?? environment.getDefaultColumnMinWidth();
                if (minColWidth != null && width >= minColWidth) {
                    column.setActualWidth(width, source);
                }
            }
        }
        // we do not do aggFunc, rowGroup or pivot for auto cols or secondary cols
        if (autoCol || !column.isPrimary()) {
            return;
        }
        valueColsSvc?.syncColumnWithState(column, source, getValue);
        rowGroupColsSvc?.syncColumnWithState(column, source, getValue, rowGroupIndexes);
        pivotColsSvc?.syncColumnWithState(column, source, getValue, pivotIndexes);
    };
    const applyStates = (states, existingColumns, getById) => {
        const dispatchEventsFunc = _compareColumnStatesAndDispatchEvents(beans, source);
        // at the end below, this list will have all columns we got no state for
        const columnsWithNoState = existingColumns.slice();
        const rowGroupIndexes = {};
        const pivotIndexes = {};
        const autoColStates = [];
        const selectionColStates = [];
        // If pivoting is modified, these are the states we try to reapply after
        // the pivot result cols are re-generated
        const unmatchedAndAutoStates = [];
        let unmatchedCount = 0;
        const previousRowGroupCols = rowGroupColsSvc?.columns.slice() ?? [];
        const previousPivotCols = pivotColsSvc?.columns.slice() ?? [];
        states.forEach((state) => {
            const colId = state.colId;
            // auto group columns are re-created so deferring syncing with ColumnState
            const isAutoGroupColumn = colId.startsWith(columnUtils_1.GROUP_AUTO_COLUMN_ID);
            if (isAutoGroupColumn) {
                autoColStates.push(state);
                unmatchedAndAutoStates.push(state);
                return;
            }
            if ((0, columnUtils_1.isColumnSelectionCol)(colId)) {
                selectionColStates.push(state);
                unmatchedAndAutoStates.push(state);
                return;
            }
            const column = getById(colId);
            if (!column) {
                unmatchedAndAutoStates.push(state);
                unmatchedCount += 1;
            }
            else {
                syncColumnWithStateItem(column, state, rowGroupIndexes, pivotIndexes, false);
                (0, array_1._removeFromArray)(columnsWithNoState, column);
            }
        });
        // anything left over, we got no data for, so add in the column as non-value, non-rowGroup and hidden
        const applyDefaultsFunc = (col) => syncColumnWithStateItem(col, null, rowGroupIndexes, pivotIndexes, false);
        columnsWithNoState.forEach(applyDefaultsFunc);
        rowGroupColsSvc?.sortColumns(comparatorByIndex.bind(rowGroupColsSvc, rowGroupIndexes, previousRowGroupCols));
        pivotColsSvc?.sortColumns(comparatorByIndex.bind(pivotColsSvc, pivotIndexes, previousPivotCols));
        colModel.refreshCols(false);
        const syncColStates = (getCol, colStates, columns = []) => {
            colStates.forEach((stateItem) => {
                const col = getCol(stateItem.colId);
                (0, array_1._removeFromArray)(columns, col);
                syncColumnWithStateItem(col, stateItem, null, null, true);
            });
            columns.forEach(applyDefaultsFunc);
        };
        // sync newly created auto group columns with ColumnState
        syncColStates((colId) => autoColSvc?.getColumn(colId) ?? null, autoColStates, autoColSvc?.getColumns()?.slice());
        // sync selection columns with ColumnState
        syncColStates((colId) => selectionColSvc?.getColumn(colId) ?? null, selectionColStates, selectionColSvc?.getColumns()?.slice());
        orderLiveColsLikeState(params, colModel, gos);
        visibleCols.refresh(source);
        eventSvc.dispatchEvent({
            type: 'columnEverythingChanged',
            source,
        });
        dispatchEventsFunc(); // Will trigger pivot result col changes if pivoting modified
        return { unmatchedAndAutoStates, unmatchedCount };
    };
    colAnimation?.start();
    let { unmatchedAndAutoStates, unmatchedCount } = applyStates(params.state || [], providedCols, (id) => colModel.getColDefCol(id));
    // If there are still states left over, see if we can apply them to newly generated
    // pivot result cols or auto cols. Also if defaults exist, ensure they are applied to pivot resul cols
    if (unmatchedAndAutoStates.length > 0 || (0, generic_1._exists)(params.defaultState)) {
        const pivotResultColsList = pivotResultCols?.getPivotResultCols()?.list ?? [];
        unmatchedCount = applyStates(unmatchedAndAutoStates, pivotResultColsList, (id) => pivotResultCols?.getPivotResultCol(id) ?? null).unmatchedCount;
    }
    colAnimation?.finish();
    return unmatchedCount === 0; // Successful if no states unaccounted for
}
exports._applyColumnState = _applyColumnState;
function _resetColumnState(beans, source) {
    const { colModel, autoColSvc, selectionColSvc, eventSvc, gos } = beans;
    const primaryCols = colModel.getColDefCols();
    if (!primaryCols?.length) {
        return;
    }
    // NOTE = there is one bug here that no customer has noticed - if a column has colDef.lockPosition,
    // this is ignored  below when ordering the cols. to work, we should always put lockPosition cols first.
    // As a work around, developers should just put lockPosition columns first in their colDef list.
    // we can't use 'allColumns' as the order might of messed up, so get the primary ordered list
    const primaryColumnTree = colModel.getColDefColTree();
    const primaryColumns = (0, columnUtils_1._getColumnsFromTree)(primaryColumnTree);
    const columnStates = [];
    // we start at 1000, so if user has mix of rowGroup and group specified, it will work with both.
    // eg IF user has ColA.rowGroupIndex=0, ColB.rowGroupIndex=1, ColC.rowGroup=true,
    // THEN result will be ColA.rowGroupIndex=0, ColB.rowGroupIndex=1, ColC.rowGroup=1000
    let letRowGroupIndex = 1000;
    let letPivotIndex = 1000;
    const addColState = (col) => {
        const stateItem = getColumnStateFromColDef(col);
        if ((0, generic_1._missing)(stateItem.rowGroupIndex) && stateItem.rowGroup) {
            stateItem.rowGroupIndex = letRowGroupIndex++;
        }
        if ((0, generic_1._missing)(stateItem.pivotIndex) && stateItem.pivot) {
            stateItem.pivotIndex = letPivotIndex++;
        }
        columnStates.push(stateItem);
    };
    autoColSvc?.getColumns()?.forEach(addColState);
    selectionColSvc?.getColumns()?.forEach(addColState);
    primaryColumns?.forEach(addColState);
    // apply state before ordering, as changes in row grouping will introduce new columns
    _applyColumnState(beans, { state: columnStates }, source);
    const autoCols = autoColSvc?.getColumns() ?? [];
    const selectionCols = selectionColSvc?.getColumns() ?? [];
    const orderedCols = [...selectionCols, ...autoCols, ...primaryCols];
    const orderedColState = orderedCols.map((col) => ({ colId: col.colId }));
    // apply the new order when all the cols have been created & are available
    _applyColumnState(beans, { state: orderedColState, applyOrder: true }, source);
    eventSvc.dispatchEvent((0, gridOptionsUtils_1._addGridCommonParams)(gos, { type: 'columnsReset', source }));
}
exports._resetColumnState = _resetColumnState;
/**
 * calculates what events to fire between column state changes. gets used when:
 * a) apply column state
 * b) apply new column definitions (so changes from old cols)
 */
function _compareColumnStatesAndDispatchEvents(beans, source) {
    const { rowGroupColsSvc, pivotColsSvc, valueColsSvc, colModel, sortSvc, eventSvc } = beans;
    const startState = {
        rowGroupColumns: rowGroupColsSvc?.columns.slice() ?? [],
        pivotColumns: pivotColsSvc?.columns.slice() ?? [],
        valueColumns: valueColsSvc?.columns.slice() ?? [],
    };
    const columnStateBefore = _getColumnState(beans);
    const columnStateBeforeMap = {};
    columnStateBefore.forEach((col) => {
        columnStateBeforeMap[col.colId] = col;
    });
    return () => {
        // dispatches generic ColumnEvents where all columns are returned rather than what has changed
        const dispatchWhenListsDifferent = (eventType, colsBefore, colsAfter, idMapper) => {
            const beforeList = colsBefore.map(idMapper);
            const afterList = colsAfter.map(idMapper);
            const unchanged = (0, array_1._areEqual)(beforeList, afterList);
            if (unchanged) {
                return;
            }
            const changes = new Set(colsBefore);
            colsAfter.forEach((id) => {
                // if the first list had it, delete it, as it's unchanged.
                if (!changes.delete(id)) {
                    // if the second list has it, and first doesn't, add it.
                    changes.add(id);
                }
            });
            const changesArr = [...changes];
            eventSvc.dispatchEvent({
                type: eventType,
                columns: changesArr,
                column: changesArr.length === 1 ? changesArr[0] : null,
                source: source,
            });
        };
        // determines which columns have changed according to supplied predicate
        const getChangedColumns = (changedPredicate) => {
            const changedColumns = [];
            colModel.forAllCols((column) => {
                const colStateBefore = columnStateBeforeMap[column.getColId()];
                if (colStateBefore && changedPredicate(colStateBefore, column)) {
                    changedColumns.push(column);
                }
            });
            return changedColumns;
        };
        const columnIdMapper = (c) => c.getColId();
        dispatchWhenListsDifferent('columnRowGroupChanged', startState.rowGroupColumns, rowGroupColsSvc?.columns ?? [], columnIdMapper);
        dispatchWhenListsDifferent('columnPivotChanged', startState.pivotColumns, pivotColsSvc?.columns ?? [], columnIdMapper);
        const valueChangePredicate = (cs, c) => {
            const oldActive = cs.aggFunc != null;
            const activeChanged = oldActive != c.isValueActive();
            // we only check aggFunc if the agg is active
            const aggFuncChanged = oldActive && cs.aggFunc != c.getAggFunc();
            return activeChanged || aggFuncChanged;
        };
        const changedValues = getChangedColumns(valueChangePredicate);
        if (changedValues.length > 0) {
            (0, columnEventUtils_1.dispatchColumnChangedEvent)(eventSvc, 'columnValueChanged', changedValues, source);
        }
        const resizeChangePredicate = (cs, c) => cs.width != c.getActualWidth();
        (0, columnEventUtils_1.dispatchColumnResizedEvent)(eventSvc, getChangedColumns(resizeChangePredicate), true, source);
        const pinnedChangePredicate = (cs, c) => cs.pinned != c.getPinned();
        (0, columnEventUtils_1.dispatchColumnPinnedEvent)(eventSvc, getChangedColumns(pinnedChangePredicate), source);
        const visibilityChangePredicate = (cs, c) => cs.hide == c.isVisible();
        (0, columnEventUtils_1.dispatchColumnVisibleEvent)(eventSvc, getChangedColumns(visibilityChangePredicate), source);
        const sortChangePredicate = (cs, c) => cs.sort != c.getSort() || cs.sortIndex != c.getSortIndex();
        const changedColumns = getChangedColumns(sortChangePredicate);
        if (changedColumns.length > 0) {
            sortSvc?.dispatchSortChangedEvents(source, changedColumns);
        }
        const colStateAfter = _getColumnState(beans);
        // special handling for moved column events
        normaliseColumnMovedEventForColumnState(columnStateBefore, colStateAfter, source, colModel, eventSvc);
    };
}
exports._compareColumnStatesAndDispatchEvents = _compareColumnStatesAndDispatchEvents;
function _getColumnState(beans) {
    const { colModel, rowGroupColsSvc, pivotColsSvc } = beans;
    const primaryCols = colModel.getColDefCols();
    if ((0, generic_1._missing)(primaryCols) || !colModel.isAlive()) {
        return [];
    }
    const rowGroupColumns = rowGroupColsSvc?.columns;
    const pivotColumns = pivotColsSvc?.columns;
    const res = [];
    const createStateItemFromColumn = (column) => {
        const rowGroupIndex = column.isRowGroupActive() && rowGroupColumns ? rowGroupColumns.indexOf(column) : null;
        const pivotIndex = column.isPivotActive() && pivotColumns ? pivotColumns.indexOf(column) : null;
        const aggFunc = column.isValueActive() ? column.getAggFunc() : null;
        const sort = column.getSort() != null ? column.getSort() : null;
        const sortIndex = column.getSortIndex() != null ? column.getSortIndex() : null;
        res.push({
            colId: column.getColId(),
            width: column.getActualWidth(),
            hide: !column.isVisible(),
            pinned: column.getPinned(),
            sort,
            sortIndex,
            aggFunc,
            rowGroup: column.isRowGroupActive(),
            rowGroupIndex,
            pivot: column.isPivotActive(),
            pivotIndex: pivotIndex,
            flex: column.getFlex() ?? null,
        });
    };
    colModel.forAllCols((col) => createStateItemFromColumn(col));
    // for fast looking, store the index of each column
    const colIdToGridIndexMap = new Map(colModel.getCols().map((col, index) => [col.getColId(), index]));
    res.sort((itemA, itemB) => {
        const posA = colIdToGridIndexMap.has(itemA.colId) ? colIdToGridIndexMap.get(itemA.colId) : -1;
        const posB = colIdToGridIndexMap.has(itemB.colId) ? colIdToGridIndexMap.get(itemB.colId) : -1;
        return posA - posB;
    });
    return res;
}
exports._getColumnState = _getColumnState;
function getColumnStateFromColDef(column) {
    const getValueOrNull = (a, b) => (a != null ? a : b != null ? b : null);
    const colDef = column.getColDef();
    const sort = getValueOrNull(colDef.sort, colDef.initialSort);
    const sortIndex = getValueOrNull(colDef.sortIndex, colDef.initialSortIndex);
    const hide = getValueOrNull(colDef.hide, colDef.initialHide);
    const pinned = getValueOrNull(colDef.pinned, colDef.initialPinned);
    const width = getValueOrNull(colDef.width, colDef.initialWidth);
    const flex = getValueOrNull(colDef.flex, colDef.initialFlex);
    let rowGroupIndex = getValueOrNull(colDef.rowGroupIndex, colDef.initialRowGroupIndex);
    let rowGroup = getValueOrNull(colDef.rowGroup, colDef.initialRowGroup);
    if (rowGroupIndex == null && (rowGroup == null || rowGroup == false)) {
        rowGroupIndex = null;
        rowGroup = null;
    }
    let pivotIndex = getValueOrNull(colDef.pivotIndex, colDef.initialPivotIndex);
    let pivot = getValueOrNull(colDef.pivot, colDef.initialPivot);
    if (pivotIndex == null && (pivot == null || pivot == false)) {
        pivotIndex = null;
        pivot = null;
    }
    const aggFunc = getValueOrNull(colDef.aggFunc, colDef.initialAggFunc);
    return {
        colId: column.getColId(),
        sort,
        sortIndex,
        hide,
        pinned,
        width,
        flex,
        rowGroup,
        rowGroupIndex,
        pivot,
        pivotIndex,
        aggFunc,
    };
}
exports.getColumnStateFromColDef = getColumnStateFromColDef;
function orderLiveColsLikeState(params, colModel, gos) {
    if (!params.applyOrder || !params.state) {
        return;
    }
    const colIds = [];
    params.state.forEach((item) => {
        if (item.colId != null) {
            colIds.push(item.colId);
        }
    });
    sortColsLikeKeys(colModel.cols, colIds, colModel, gos);
}
function sortColsLikeKeys(cols, colIds, colModel, gos) {
    if (cols == null) {
        return;
    }
    let newOrder = [];
    const processedColIds = {};
    colIds.forEach((colId) => {
        if (processedColIds[colId]) {
            return;
        }
        const col = cols.map[colId];
        if (col) {
            newOrder.push(col);
            processedColIds[colId] = true;
        }
    });
    // add in all other columns
    let autoGroupInsertIndex = 0;
    cols.list.forEach((col) => {
        const colId = col.getColId();
        const alreadyProcessed = processedColIds[colId] != null;
        if (alreadyProcessed) {
            return;
        }
        const isAutoGroupCol = colId.startsWith(columnUtils_1.GROUP_AUTO_COLUMN_ID);
        if (isAutoGroupCol) {
            // auto group columns, if missing from state list, are added to the start.
            // it's common to have autoGroup missing, as grouping could be on by default
            // on a column, but the user could of since removed the grouping via the UI.
            // if we don't inc the insert index, autoGroups will be inserted in reverse order
            newOrder.splice(autoGroupInsertIndex++, 0, col);
        }
        else {
            // normal columns, if missing from state list, are added at the end
            newOrder.push(col);
        }
    });
    // this is already done in updateCols, however we changed the order above (to match the order of the state
    // columns) so we need to do it again. we could of put logic into the order above to take into account fixed
    // columns, however if we did then we would have logic for updating fixed columns twice. reusing the logic here
    // is less sexy for the code here, but it keeps consistency.
    newOrder = (0, columnMoveUtils_1.placeLockedColumns)(newOrder, gos);
    if (!(0, columnMoveUtils_1.doesMovePassMarryChildren)(newOrder, colModel.getColTree())) {
        (0, logging_1._warn)(39);
        return;
    }
    cols.list = newOrder;
}
function normaliseColumnMovedEventForColumnState(colStateBefore, colStateAfter, source, colModel, eventSvc) {
    // we are only interested in columns that were both present and visible before and after
    const colStateAfterMapped = {};
    colStateAfter.forEach((s) => (colStateAfterMapped[s.colId] = s));
    // get id's of cols in both before and after lists
    const colsIntersectIds = {};
    colStateBefore.forEach((s) => {
        if (colStateAfterMapped[s.colId]) {
            colsIntersectIds[s.colId] = true;
        }
    });
    // filter state lists, so we only have cols that were present before and after
    const beforeFiltered = colStateBefore.filter((c) => colsIntersectIds[c.colId]);
    const afterFiltered = colStateAfter.filter((c) => colsIntersectIds[c.colId]);
    // see if any cols are in a different location
    const movedColumns = [];
    afterFiltered.forEach((csAfter, index) => {
        const csBefore = beforeFiltered && beforeFiltered[index];
        if (csBefore && csBefore.colId !== csAfter.colId) {
            const gridCol = colModel.getCol(csBefore.colId);
            if (gridCol) {
                movedColumns.push(gridCol);
            }
        }
    });
    if (!movedColumns.length) {
        return;
    }
    eventSvc.dispatchEvent({
        type: 'columnMoved',
        columns: movedColumns,
        column: movedColumns.length === 1 ? movedColumns[0] : null,
        finished: true,
        source,
    });
}
// sort the lists according to the indexes that were provided
const comparatorByIndex = (indexes, oldList, colA, colB) => {
    const indexA = indexes[colA.getId()];
    const indexB = indexes[colB.getId()];
    const aHasIndex = indexA != null;
    const bHasIndex = indexB != null;
    if (aHasIndex && bHasIndex) {
        // both a and b are new cols with index, so sort on index
        return indexA - indexB;
    }
    if (aHasIndex) {
        // a has an index, so it should be before a
        return -1;
    }
    if (bHasIndex) {
        // b has an index, so it should be before a
        return 1;
    }
    const oldIndexA = oldList.indexOf(colA);
    const oldIndexB = oldList.indexOf(colB);
    const aHasOldIndex = oldIndexA >= 0;
    const bHasOldIndex = oldIndexB >= 0;
    if (aHasOldIndex && bHasOldIndex) {
        // both a and b are old cols, so sort based on last order
        return oldIndexA - oldIndexB;
    }
    if (aHasOldIndex) {
        // a is old, b is new, so b is first
        return -1;
    }
    // this bit does matter, means both are new cols
    // but without index or that b is old and a is new
    return 1;
};


/***/ }),

/***/ 73146:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getValueFactory = exports._columnsMatch = exports._convertColumnEventSourceType = exports._updateColsMap = exports._areColIdsEqual = exports.convertColumnTypes = exports.isSpecialCol = exports.isRowNumberCol = exports.isColumnSelectionCol = exports.isColumnGroupAutoCol = exports._destroyColumnTree = exports.getWidthOfColsInList = exports._getColumnsFromTree = exports.GROUP_HIERARCHY_COLUMN_ID_PREFIX = exports.ROW_NUMBERS_COLUMN_ID = exports.SELECTION_COLUMN_ID = exports.GROUP_AUTO_COLUMN_ID = void 0;
const array_1 = __webpack_require__(79909);
const generic_1 = __webpack_require__(89097);
const agColumn_1 = __webpack_require__(13355);
const agProvidedColumnGroup_1 = __webpack_require__(79409);
const columnFactoryUtils_1 = __webpack_require__(82716);
exports.GROUP_AUTO_COLUMN_ID = 'ag-Grid-AutoColumn';
exports.SELECTION_COLUMN_ID = 'ag-Grid-SelectionColumn';
exports.ROW_NUMBERS_COLUMN_ID = 'ag-Grid-RowNumbersColumn';
exports.GROUP_HIERARCHY_COLUMN_ID_PREFIX = 'ag-Grid-HierarchyColumn';
// Possible candidate for reuse (alot of recursive traversal duplication)
function _getColumnsFromTree(rootColumns) {
    const result = [];
    const recursiveFindColumns = (childColumns) => {
        for (let i = 0; i < childColumns.length; i++) {
            const child = childColumns[i];
            if ((0, agColumn_1.isColumn)(child)) {
                result.push(child);
            }
            else if ((0, agProvidedColumnGroup_1.isProvidedColumnGroup)(child)) {
                recursiveFindColumns(child.getChildren());
            }
        }
    };
    recursiveFindColumns(rootColumns);
    return result;
}
exports._getColumnsFromTree = _getColumnsFromTree;
function getWidthOfColsInList(columnList) {
    return columnList.reduce((width, col) => width + col.getActualWidth(), 0);
}
exports.getWidthOfColsInList = getWidthOfColsInList;
function _destroyColumnTree(beans, oldTree, newTree) {
    const oldObjectsById = {};
    if (!oldTree) {
        return;
    }
    // add in all old columns to be destroyed
    (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, oldTree, (child) => {
        oldObjectsById[child.getInstanceId()] = child;
    });
    // however we don't destroy anything in the new tree. if destroying the grid, there is no new tree
    if (newTree) {
        (0, columnFactoryUtils_1.depthFirstOriginalTreeSearch)(null, newTree, (child) => {
            oldObjectsById[child.getInstanceId()] = null;
        });
    }
    // what's left can be destroyed
    const colsToDestroy = Object.values(oldObjectsById).filter((item) => item != null);
    beans.context.destroyBeans(colsToDestroy);
}
exports._destroyColumnTree = _destroyColumnTree;
function isColumnGroupAutoCol(col) {
    const colId = col.getId();
    return colId.startsWith(exports.GROUP_AUTO_COLUMN_ID);
}
exports.isColumnGroupAutoCol = isColumnGroupAutoCol;
function isColumnSelectionCol(col) {
    const id = typeof col === 'string' ? col : 'getColId' in col ? col.getColId() : col.colId;
    return id?.startsWith(exports.SELECTION_COLUMN_ID) ?? false;
}
exports.isColumnSelectionCol = isColumnSelectionCol;
function isRowNumberCol(col) {
    const id = typeof col === 'string' ? col : 'getColId' in col ? col.getColId() : col.colId;
    return id?.startsWith(exports.ROW_NUMBERS_COLUMN_ID) ?? false;
}
exports.isRowNumberCol = isRowNumberCol;
function isSpecialCol(col) {
    return isColumnSelectionCol(col) || isRowNumberCol(col);
}
exports.isSpecialCol = isSpecialCol;
function convertColumnTypes(type) {
    let typeKeys = [];
    if (type instanceof Array) {
        typeKeys = type;
    }
    else if (typeof type === 'string') {
        typeKeys = type.split(',');
    }
    return typeKeys;
}
exports.convertColumnTypes = convertColumnTypes;
function _areColIdsEqual(colsA, colsB) {
    return (0, array_1._areEqual)(colsA, colsB, (a, b) => a.getColId() === b.getColId());
}
exports._areColIdsEqual = _areColIdsEqual;
function _updateColsMap(cols) {
    cols.map = {};
    cols.list.forEach((col) => (cols.map[col.getId()] = col));
}
exports._updateColsMap = _updateColsMap;
function _convertColumnEventSourceType(source) {
    // unfortunately they do not match so need to perform conversion
    return source === 'optionsUpdated' ? 'gridOptionsChanged' : source;
}
exports._convertColumnEventSourceType = _convertColumnEventSourceType;
function _columnsMatch(column, key) {
    const columnMatches = column === key;
    const colDefMatches = column.getColDef() === key;
    const idMatches = column.getColId() == key;
    return columnMatches || colDefMatches || idMatches;
}
exports._columnsMatch = _columnsMatch;
const getValueFactory = (stateItem, defaultState) => (key1, key2) => {
    const obj = {
        value1: undefined,
        value2: undefined,
    };
    let calculated = false;
    if (stateItem) {
        if (stateItem[key1] !== undefined) {
            obj.value1 = stateItem[key1];
            calculated = true;
        }
        if ((0, generic_1._exists)(key2) && stateItem[key2] !== undefined) {
            obj.value2 = stateItem[key2];
            calculated = true;
        }
    }
    if (!calculated && defaultState) {
        if (defaultState[key1] !== undefined) {
            obj.value1 = defaultState[key1];
        }
        if ((0, generic_1._exists)(key2) && defaultState[key2] !== undefined) {
            obj.value2 = defaultState[key2];
        }
    }
    return obj;
};
exports.getValueFactory = getValueFactory;


/***/ }),

/***/ 5034:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnViewportService = void 0;
const generic_1 = __webpack_require__(89097);
const beanStub_1 = __webpack_require__(68731);
class ColumnViewportService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colViewport';
        // cols in center that are in the viewport
        this.colsWithinViewport = [];
        // same as colsWithinViewport, except we always include columns with headerAutoHeight
        this.headerColsWithinViewport = [];
        // A hash key to keep track of changes in viewport columns
        this.colsWithinViewportHash = '';
        // all columns & groups to be rendered, index by row.
        // used by header rows to get all items to render for that row.
        this.rowsOfHeadersToRenderLeft = {};
        this.rowsOfHeadersToRenderRight = {};
        this.rowsOfHeadersToRenderCenter = {};
        this.columnsToRenderLeft = [];
        this.columnsToRenderRight = [];
        this.columnsToRenderCenter = [];
    }
    wireBeans(beans) {
        this.visibleCols = beans.visibleCols;
        this.colModel = beans.colModel;
    }
    postConstruct() {
        this.suppressColumnVirtualisation = this.gos.get('suppressColumnVirtualisation');
    }
    setScrollPosition(scrollWidth, scrollPosition, afterScroll = false) {
        const { visibleCols } = this;
        const bodyWidthDirty = visibleCols.isBodyWidthDirty;
        const noChange = scrollWidth === this.scrollWidth && scrollPosition === this.scrollPosition && !bodyWidthDirty;
        if (noChange) {
            return;
        }
        this.scrollWidth = scrollWidth;
        this.scrollPosition = scrollPosition;
        // we need to call setVirtualViewportLeftAndRight() at least once after the body width changes,
        // as the viewport can stay the same, but in RTL, if body width changes, we need to work out the
        // virtual columns again
        visibleCols.isBodyWidthDirty = true;
        if (this.gos.get('enableRtl')) {
            const bodyWidth = visibleCols.bodyWidth;
            this.viewportLeft = bodyWidth - scrollPosition - scrollWidth;
            this.viewportRight = bodyWidth - scrollPosition;
        }
        else {
            this.viewportLeft = scrollPosition;
            this.viewportRight = scrollWidth + scrollPosition;
        }
        if (this.colModel.ready) {
            this.checkViewportColumns(afterScroll);
        }
    }
    /**
     * Returns the columns that are currently rendered in the viewport.
     */
    getColumnHeadersToRender(type) {
        switch (type) {
            case 'left':
                return this.columnsToRenderLeft;
            case 'right':
                return this.columnsToRenderRight;
            default:
                return this.columnsToRenderCenter;
        }
    }
    /**
     * Returns the column groups that are currently rendered in the viewport at a specific header row index.
     */
    getHeadersToRender(type, depth) {
        let result;
        switch (type) {
            case 'left':
                result = this.rowsOfHeadersToRenderLeft[depth];
                break;
            case 'right':
                result = this.rowsOfHeadersToRenderRight[depth];
                break;
            default:
                result = this.rowsOfHeadersToRenderCenter[depth];
                break;
        }
        return result ?? [];
    }
    extractViewportColumns() {
        const displayedColumnsCenter = this.visibleCols.centerCols;
        if (this.isColumnVirtualisationSuppressed()) {
            // no virtualisation, so don't filter
            this.colsWithinViewport = displayedColumnsCenter;
            this.headerColsWithinViewport = displayedColumnsCenter;
        }
        else {
            // filter out what should be visible
            this.colsWithinViewport = displayedColumnsCenter.filter(this.isColumnInRowViewport.bind(this));
            this.headerColsWithinViewport = displayedColumnsCenter.filter(this.isColumnInHeaderViewport.bind(this));
        }
    }
    isColumnVirtualisationSuppressed() {
        // When running within jsdom the viewportRight is always 0, so we need to return true to allow
        // tests to validate all the columns.
        return this.suppressColumnVirtualisation || this.viewportRight === 0;
    }
    clear() {
        this.rowsOfHeadersToRenderLeft = {};
        this.rowsOfHeadersToRenderRight = {};
        this.rowsOfHeadersToRenderCenter = {};
        this.colsWithinViewportHash = '';
    }
    isColumnInHeaderViewport(col) {
        // for headers, we never filter out autoHeaderHeight columns, if calculating
        if (col.isAutoHeaderHeight() || isAnyParentAutoHeaderHeight(col)) {
            return true;
        }
        return this.isColumnInRowViewport(col);
    }
    isColumnInRowViewport(col) {
        // we never filter out autoHeight columns, as we need them in the DOM for calculating Auto Height
        if (col.isAutoHeight()) {
            return true;
        }
        const columnLeft = col.getLeft() || 0;
        const columnRight = columnLeft + col.getActualWidth();
        // adding 200 for buffer size, so some cols off viewport are rendered.
        // this helps horizontal scrolling so user rarely sees white space (unless
        // they scroll horizontally fast). however we are conservative, as the more
        // buffer the slower the vertical redraw speed
        const leftBounds = this.viewportLeft - 200;
        const rightBounds = this.viewportRight + 200;
        const columnToMuchLeft = columnLeft < leftBounds && columnRight < leftBounds;
        const columnToMuchRight = columnLeft > rightBounds && columnRight > rightBounds;
        return !columnToMuchLeft && !columnToMuchRight;
    }
    // used by Grid API only
    getViewportColumns() {
        const { leftCols, rightCols } = this.visibleCols;
        const res = this.colsWithinViewport.concat(leftCols).concat(rightCols);
        return res;
    }
    // + rowRenderer
    // if we are not column spanning, this just returns back the virtual centre columns,
    // however if we are column spanning, then different rows can have different virtual
    // columns, so we have to work out the list for each individual row.
    getColsWithinViewport(rowNode) {
        if (!this.colModel.colSpanActive) {
            return this.colsWithinViewport;
        }
        const emptySpaceBeforeColumn = (col) => {
            const left = col.getLeft();
            return (0, generic_1._exists)(left) && left > this.viewportLeft;
        };
        // if doing column virtualisation, then we filter based on the viewport.
        const inViewportCallback = this.isColumnVirtualisationSuppressed()
            ? undefined
            : this.isColumnInRowViewport.bind(this);
        const { visibleCols } = this;
        const displayedColumnsCenter = visibleCols.centerCols;
        return visibleCols.getColsForRow(rowNode, displayedColumnsCenter, inViewportCallback, emptySpaceBeforeColumn);
    }
    // checks what columns are currently displayed due to column virtualisation. dispatches an event
    // if the list of columns has changed.
    // + setColumnWidth(), setViewportPosition(), setColumnDefs(), sizeColumnsToFit()
    checkViewportColumns(afterScroll = false) {
        const viewportColumnsChanged = this.extractViewport();
        if (viewportColumnsChanged) {
            this.eventSvc.dispatchEvent({
                type: 'virtualColumnsChanged',
                afterScroll,
            });
        }
    }
    calculateHeaderRows() {
        const { leftCols, rightCols } = this.visibleCols;
        this.columnsToRenderLeft = leftCols;
        this.columnsToRenderRight = rightCols;
        this.columnsToRenderCenter = this.colsWithinViewport;
        const workOutGroupsToRender = (cols) => {
            const groupsToRenderSet = new Set();
            const groupsToRender = {};
            for (const col of cols) {
                let group = col.getParent();
                const skipFillers = col.isSpanHeaderHeight();
                while (group) {
                    if (groupsToRenderSet.has(group)) {
                        // if we already have this group, then we don't need to add it again
                        // or traverse up the tree
                        break;
                    }
                    const skipFillerGroup = skipFillers && group.isPadding();
                    if (skipFillerGroup) {
                        group = group.getParent();
                        continue;
                    }
                    const level = group.getProvidedColumnGroup().getLevel();
                    groupsToRender[level] ?? (groupsToRender[level] = []);
                    groupsToRender[level].push(group);
                    groupsToRenderSet.add(group);
                    group = group.getParent();
                }
            }
            return groupsToRender;
        };
        this.rowsOfHeadersToRenderLeft = workOutGroupsToRender(leftCols);
        this.rowsOfHeadersToRenderRight = workOutGroupsToRender(rightCols);
        this.rowsOfHeadersToRenderCenter = workOutGroupsToRender(this.headerColsWithinViewport);
    }
    extractViewport() {
        const hashColumn = (c) => `${c.getId()}-${c.getPinned() || 'normal'}`;
        this.extractViewportColumns();
        const newHash = this.getViewportColumns().map(hashColumn).join('#');
        const changed = this.colsWithinViewportHash !== newHash;
        if (changed) {
            this.colsWithinViewportHash = newHash;
            this.calculateHeaderRows();
        }
        return changed;
    }
}
exports.ColumnViewportService = ColumnViewportService;
function isAnyParentAutoHeaderHeight(col) {
    while (col) {
        if (col.isAutoHeaderHeight()) {
            return true;
        }
        col = col.getParent();
    }
    return false;
}


/***/ }),

/***/ 96350:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataTypeService = void 0;
const keyCode_1 = __webpack_require__(59926);
const date_1 = __webpack_require__(97066);
const generic_1 = __webpack_require__(89097);
const value_1 = __webpack_require__(22989);
const beanStub_1 = __webpack_require__(68731);
const gridOptionsUtils_1 = __webpack_require__(67274);
const logging_1 = __webpack_require__(47764);
const columnFactoryUtils_1 = __webpack_require__(82716);
const columnStateUtils_1 = __webpack_require__(2885);
const columnUtils_1 = __webpack_require__(73146);
/**
 *  We are missing object and dateTime here.
 *  This is because dateTime has a lower priority than date and gives us no way to distinguish between the two, and
 *  object type is the default type for all other types.
 *
 *  dateTimeString has higher priority than dateString, since it includes serialized time and isValidDate() considers datetime a valid date.
 */
const SORTED_CELL_DATA_TYPES_FOR_MATCHING = [
    'dateTimeString',
    'dateString',
    'text',
    'number',
    'boolean',
    'date',
];
class DataTypeService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'dataTypeSvc';
        this.dataTypeDefinitions = {};
        this.isPendingInference = false;
        this.isColumnTypeOverrideInDataTypeDefinitions = false;
        // keep track of any column state updates whilst waiting for data types to be inferred
        this.columnStateUpdatesPendingInference = {};
        this.columnStateUpdateListenerDestroyFuncs = [];
        // using an object here to enforce dev to not forget to implement new types as they are added
        this.columnDefinitionPropsPerDataType = {
            number() {
                return { cellEditor: 'agNumberCellEditor' };
            },
            boolean() {
                return {
                    cellEditor: 'agCheckboxCellEditor',
                    cellRenderer: 'agCheckboxCellRenderer',
                    getFindText: () => null,
                    suppressKeyboardEvent: (params) => !!params.colDef.editable && params.event.key === keyCode_1.KeyCode.SPACE,
                };
            },
            date({ formatValue }) {
                return { cellEditor: 'agDateCellEditor', keyCreator: formatValue };
            },
            dateString({ formatValue }) {
                return { cellEditor: 'agDateStringCellEditor', keyCreator: formatValue };
            },
            dateTime(args) {
                return this.date(args);
            },
            dateTimeString(args) {
                return this.dateString(args);
            },
            object({ formatValue, colModel, colId }) {
                return {
                    cellEditorParams: {
                        useFormatter: true,
                    },
                    comparator: (a, b) => {
                        const column = colModel.getColDefCol(colId);
                        const colDef = column?.getColDef();
                        if (!column || !colDef) {
                            return 0;
                        }
                        const valA = a == null ? '' : formatValue({ column, node: null, value: a });
                        const valB = b == null ? '' : formatValue({ column, node: null, value: b });
                        if (valA === valB)
                            return 0;
                        return valA > valB ? 1 : -1;
                    },
                    keyCreator: formatValue,
                };
            },
            text() {
                return {};
            },
        };
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
    }
    postConstruct() {
        this.processDataTypeDefinitions();
        this.addManagedPropertyListener('dataTypeDefinitions', (event) => {
            this.processDataTypeDefinitions();
            this.colModel.recreateColumnDefs(event);
        });
    }
    processDataTypeDefinitions() {
        const defaultDataTypes = this.getDefaultDataTypes();
        const newDataTypeDefinitions = {};
        const newFormatValueFuncs = {};
        const generateFormatValueFunc = (dataTypeDefinition) => {
            return (params) => {
                const { column, node, value } = params;
                let valueFormatter = column.getColDef().valueFormatter;
                if (valueFormatter === dataTypeDefinition.groupSafeValueFormatter) {
                    valueFormatter = dataTypeDefinition.valueFormatter;
                }
                return this.beans.valueSvc.formatValue(column, node, value, valueFormatter);
            };
        };
        for (const cellDataType of Object.keys(defaultDataTypes)) {
            const defaultDataTypeDef = defaultDataTypes[cellDataType];
            const mergedDataTypeDefinition = {
                ...defaultDataTypeDef,
                groupSafeValueFormatter: createGroupSafeValueFormatter(defaultDataTypeDef, this.gos),
            };
            newDataTypeDefinitions[cellDataType] = mergedDataTypeDefinition;
            newFormatValueFuncs[cellDataType] = generateFormatValueFunc(mergedDataTypeDefinition);
        }
        const userDataTypeDefs = this.gos.get('dataTypeDefinitions') ?? {};
        const newDataTypeMatchers = {};
        for (const cellDataType of Object.keys(userDataTypeDefs)) {
            const userDataTypeDef = userDataTypeDefs[cellDataType];
            const mergedDataTypeDefinition = this.processDataTypeDefinition(userDataTypeDef, userDataTypeDefs, [cellDataType], defaultDataTypes);
            if (mergedDataTypeDefinition) {
                newDataTypeDefinitions[cellDataType] = mergedDataTypeDefinition;
                if (userDataTypeDef.dataTypeMatcher) {
                    newDataTypeMatchers[cellDataType] = userDataTypeDef.dataTypeMatcher;
                }
                newFormatValueFuncs[cellDataType] = generateFormatValueFunc(mergedDataTypeDefinition);
            }
        }
        const { valueParser: defaultValueParser, valueFormatter: defaultValueFormatter } = defaultDataTypes.object;
        const { valueParser: userValueParser, valueFormatter: userValueFormatter } = newDataTypeDefinitions.object;
        this.hasObjectValueParser = userValueParser !== defaultValueParser;
        this.hasObjectValueFormatter = userValueFormatter !== defaultValueFormatter;
        this.formatValueFuncs = newFormatValueFuncs;
        this.dataTypeDefinitions = newDataTypeDefinitions;
        this.dataTypeMatchers = this.sortKeysInMatchers(newDataTypeMatchers, defaultDataTypes);
    }
    /**
     * Sorts the keys in the matchers object.
     * Does not mutate the original object, creates a copy of it with sorted keys instead.
     */
    sortKeysInMatchers(matchers, dataTypes) {
        const sortedMatchers = { ...matchers };
        for (const cellDataType of SORTED_CELL_DATA_TYPES_FOR_MATCHING) {
            delete sortedMatchers[cellDataType];
            sortedMatchers[cellDataType] = matchers[cellDataType] ?? dataTypes[cellDataType].dataTypeMatcher;
        }
        return sortedMatchers;
    }
    processDataTypeDefinition(userDataTypeDef, userDataTypeDefs, alreadyProcessedDataTypes, defaultDataTypes) {
        let mergedDataTypeDefinition;
        const extendsCellDataType = userDataTypeDef.extendsDataType;
        if (userDataTypeDef.columnTypes) {
            this.isColumnTypeOverrideInDataTypeDefinitions = true;
        }
        if (userDataTypeDef.extendsDataType === userDataTypeDef.baseDataType) {
            let baseDataTypeDefinition = defaultDataTypes[extendsCellDataType];
            const overriddenBaseDataTypeDefinition = userDataTypeDefs[extendsCellDataType];
            if (baseDataTypeDefinition && overriddenBaseDataTypeDefinition) {
                // only if it's valid do we override with a provided one
                baseDataTypeDefinition = overriddenBaseDataTypeDefinition;
            }
            if (!validateDataTypeDefinition(userDataTypeDef, baseDataTypeDefinition, extendsCellDataType)) {
                return undefined;
            }
            mergedDataTypeDefinition = mergeDataTypeDefinitions(baseDataTypeDefinition, userDataTypeDef);
        }
        else {
            if (alreadyProcessedDataTypes.includes(extendsCellDataType)) {
                (0, logging_1._warn)(44);
                return undefined;
            }
            const extendedDataTypeDefinition = userDataTypeDefs[extendsCellDataType];
            if (!validateDataTypeDefinition(userDataTypeDef, extendedDataTypeDefinition, extendsCellDataType)) {
                return undefined;
            }
            const mergedExtendedDataTypeDefinition = this.processDataTypeDefinition(extendedDataTypeDefinition, userDataTypeDefs, [...alreadyProcessedDataTypes, extendsCellDataType], defaultDataTypes);
            if (!mergedExtendedDataTypeDefinition) {
                return undefined;
            }
            mergedDataTypeDefinition = mergeDataTypeDefinitions(mergedExtendedDataTypeDefinition, userDataTypeDef);
        }
        return {
            ...mergedDataTypeDefinition,
            groupSafeValueFormatter: createGroupSafeValueFormatter(mergedDataTypeDefinition, this.gos),
        };
    }
    updateColDefAndGetColumnType(colDef, userColDef, colId) {
        let { cellDataType } = userColDef;
        const { field } = userColDef;
        if (cellDataType === undefined) {
            cellDataType = colDef.cellDataType;
        }
        if (cellDataType == null || cellDataType === true) {
            cellDataType = this.canInferCellDataType(colDef, userColDef) ? this.inferCellDataType(field, colId) : false;
        }
        if (!cellDataType) {
            colDef.cellDataType = false;
            return undefined;
        }
        const dataTypeDefinition = this.dataTypeDefinitions[cellDataType];
        if (!dataTypeDefinition) {
            (0, logging_1._warn)(47, { cellDataType });
            return undefined;
        }
        colDef.cellDataType = cellDataType;
        if (dataTypeDefinition.groupSafeValueFormatter) {
            colDef.valueFormatter = dataTypeDefinition.groupSafeValueFormatter;
        }
        if (dataTypeDefinition.valueParser) {
            colDef.valueParser = dataTypeDefinition.valueParser;
        }
        if (!dataTypeDefinition.suppressDefaultProperties) {
            this.setColDefPropertiesForBaseDataType(colDef, cellDataType, dataTypeDefinition, colId);
        }
        return dataTypeDefinition.columnTypes;
    }
    addColumnListeners(column) {
        if (!this.isPendingInference) {
            return;
        }
        const columnStateUpdates = this.columnStateUpdatesPendingInference[column.getColId()];
        if (!columnStateUpdates) {
            return;
        }
        const columnListener = (event) => {
            columnStateUpdates.add(event.key);
        };
        column.__addEventListener('columnStateUpdated', columnListener);
        this.columnStateUpdateListenerDestroyFuncs.push(() => column.__removeEventListener('columnStateUpdated', columnListener));
    }
    canInferCellDataType(colDef, userColDef) {
        const { gos } = this;
        if (!(0, gridOptionsUtils_1._isClientSideRowModel)(gos)) {
            return false;
        }
        const propsToCheckForInference = { cellRenderer: true, valueGetter: true, valueParser: true, refData: true };
        if (doColDefPropsPreventInference(userColDef, propsToCheckForInference)) {
            return false;
        }
        const columnTypes = userColDef.type === null ? colDef.type : userColDef.type;
        if (columnTypes) {
            const columnTypeDefs = gos.get('columnTypes') ?? {};
            const hasPropsPreventingInference = (0, columnUtils_1.convertColumnTypes)(columnTypes).some((columnType) => {
                const columnTypeDef = columnTypeDefs[columnType.trim()];
                return columnTypeDef && doColDefPropsPreventInference(columnTypeDef, propsToCheckForInference);
            });
            if (hasPropsPreventingInference) {
                return false;
            }
        }
        return !doColDefPropsPreventInference(colDef, propsToCheckForInference);
    }
    inferCellDataType(field, colId) {
        if (!field) {
            return undefined;
        }
        let value;
        const initialData = this.getInitialData();
        if (initialData) {
            const fieldContainsDots = field.indexOf('.') >= 0 && !this.gos.get('suppressFieldDotNotation');
            value = (0, value_1._getValueUsingField)(initialData, field, fieldContainsDots);
        }
        else {
            this.initWaitForRowData(colId);
        }
        if (value == null) {
            return undefined;
        }
        const matchedType = Object.keys(this.dataTypeMatchers).find((_cellDataType) => this.dataTypeMatchers[_cellDataType](value));
        return matchedType ?? 'object';
    }
    getInitialData() {
        const rowData = this.gos.get('rowData');
        if (rowData?.length) {
            return rowData[0];
        }
        else if (this.initialData) {
            return this.initialData;
        }
        else {
            const rowNodes = this.beans.rowModel.rootNode?.allLeafChildren;
            if (rowNodes?.length) {
                return rowNodes[0].data;
            }
        }
        return null;
    }
    initWaitForRowData(colId) {
        this.columnStateUpdatesPendingInference[colId] = new Set();
        if (this.isPendingInference) {
            return;
        }
        this.isPendingInference = true;
        const columnTypeOverridesExist = this.isColumnTypeOverrideInDataTypeDefinitions;
        const { colAutosize, eventSvc } = this.beans;
        if (columnTypeOverridesExist && colAutosize) {
            colAutosize.shouldQueueResizeOperations = true;
        }
        const [destroyFunc] = this.addManagedEventListeners({
            rowDataUpdateStarted: (event) => {
                const { firstRowData } = event;
                if (!firstRowData) {
                    return;
                }
                destroyFunc?.();
                this.isPendingInference = false;
                this.processColumnsPendingInference(firstRowData, columnTypeOverridesExist);
                this.columnStateUpdatesPendingInference = {};
                if (columnTypeOverridesExist) {
                    colAutosize?.processResizeOperations();
                }
                eventSvc.dispatchEvent({
                    type: 'dataTypesInferred',
                });
            },
        });
    }
    processColumnsPendingInference(firstRowData, columnTypeOverridesExist) {
        this.initialData = firstRowData;
        const state = [];
        this.destroyColumnStateUpdateListeners();
        const newRowGroupColumnStateWithoutIndex = {};
        const newPivotColumnStateWithoutIndex = {};
        for (const colId of Object.keys(this.columnStateUpdatesPendingInference)) {
            const columnStateUpdates = this.columnStateUpdatesPendingInference[colId];
            const column = this.colModel.getCol(colId);
            if (!column) {
                return;
            }
            const oldColDef = column.getColDef();
            if (!this.resetColDefIntoCol(column, 'cellDataTypeInferred')) {
                return;
            }
            const newColDef = column.getColDef();
            if (columnTypeOverridesExist && newColDef.type && newColDef.type !== oldColDef.type) {
                const updatedColumnState = getUpdatedColumnState(column, columnStateUpdates);
                if (updatedColumnState.rowGroup && updatedColumnState.rowGroupIndex == null) {
                    newRowGroupColumnStateWithoutIndex[colId] = updatedColumnState;
                }
                if (updatedColumnState.pivot && updatedColumnState.pivotIndex == null) {
                    newPivotColumnStateWithoutIndex[colId] = updatedColumnState;
                }
                state.push(updatedColumnState);
            }
        }
        if (columnTypeOverridesExist) {
            state.push(...this.generateColumnStateForRowGroupAndPivotIndexes(newRowGroupColumnStateWithoutIndex, newPivotColumnStateWithoutIndex));
        }
        if (state.length) {
            (0, columnStateUtils_1._applyColumnState)(this.beans, { state }, 'cellDataTypeInferred');
        }
        this.initialData = null;
    }
    generateColumnStateForRowGroupAndPivotIndexes(updatedRowGroupColumnState, updatedPivotColumnState) {
        // Generally columns should appear in the order they were before. For any new columns, these should appear in the original col def order.
        // The exception is for columns that were added via `addGroupColumns`. These should appear at the end.
        // We don't have to worry about full updates, as in this case the arrays are correct, and they won't appear in the updated lists.
        const existingColumnStateUpdates = {};
        const { rowGroupColsSvc, pivotColsSvc } = this.beans;
        rowGroupColsSvc?.restoreColumnOrder(existingColumnStateUpdates, updatedRowGroupColumnState);
        pivotColsSvc?.restoreColumnOrder(existingColumnStateUpdates, updatedPivotColumnState);
        return Object.values(existingColumnStateUpdates);
    }
    resetColDefIntoCol(column, source) {
        const userColDef = column.getUserProvidedColDef();
        if (!userColDef) {
            return false;
        }
        const newColDef = (0, columnFactoryUtils_1._addColumnDefaultAndTypes)(this.beans, userColDef, column.getColId());
        column.setColDef(newColDef, userColDef, source);
        return true;
    }
    getDateStringTypeDefinition(column) {
        const { dateString } = this.dataTypeDefinitions;
        if (!column) {
            return dateString;
        }
        return (this.getDataTypeDefinition(column) ?? dateString);
    }
    getDateParserFunction(column) {
        return this.getDateStringTypeDefinition(column).dateParser;
    }
    getDateFormatterFunction(column) {
        return this.getDateStringTypeDefinition(column).dateFormatter;
    }
    getDateIncludesTimeFlag(cellDataType) {
        return cellDataType === 'dateTime' || cellDataType === 'dateTimeString';
    }
    getDataTypeDefinition(column) {
        const colDef = column.getColDef();
        if (!colDef.cellDataType) {
            return undefined;
        }
        return this.dataTypeDefinitions[colDef.cellDataType];
    }
    getBaseDataType(column) {
        return this.getDataTypeDefinition(column)?.baseDataType;
    }
    checkType(column, value) {
        if (value == null) {
            return true;
        }
        const dataTypeMatcher = this.getDataTypeDefinition(column)?.dataTypeMatcher;
        if (!dataTypeMatcher) {
            return true;
        }
        return dataTypeMatcher(value);
    }
    validateColDef(colDef) {
        const warning = (property) => (0, logging_1._warn)(48, { property });
        if (colDef.cellDataType === 'object') {
            const { object } = this.dataTypeDefinitions;
            if (colDef.valueFormatter === object.groupSafeValueFormatter && !this.hasObjectValueFormatter) {
                warning('Formatter');
            }
            if (colDef.editable && colDef.valueParser === object.valueParser && !this.hasObjectValueParser) {
                warning('Parser');
            }
        }
    }
    postProcess(colDef) {
        const cellDataType = colDef.cellDataType;
        if (!cellDataType || typeof cellDataType !== 'string') {
            return;
        }
        const { dataTypeDefinitions, beans, formatValueFuncs } = this;
        const dataTypeDefinition = dataTypeDefinitions[cellDataType];
        if (!dataTypeDefinition) {
            return;
        }
        beans.colFilter?.setColDefPropsForDataType(colDef, dataTypeDefinition, formatValueFuncs[cellDataType]);
    }
    // noinspection JSUnusedGlobalSymbols
    getFormatValue(cellDataType) {
        return this.formatValueFuncs[cellDataType];
    }
    isColPendingInference(colId) {
        return this.isPendingInference && !!this.columnStateUpdatesPendingInference[colId];
    }
    setColDefPropertiesForBaseDataType(colDef, cellDataType, dataTypeDefinition, colId) {
        const formatValue = this.formatValueFuncs[cellDataType];
        const partialColDef = this.columnDefinitionPropsPerDataType[dataTypeDefinition.baseDataType]({
            colDef,
            cellDataType,
            colModel: this.colModel,
            dataTypeDefinition,
            colId,
            formatValue,
        });
        Object.assign(colDef, partialColDef);
    }
    getDateObjectTypeDef(baseDataType) {
        const translate = this.getLocaleTextFunc();
        const includeTime = this.getDateIncludesTimeFlag(baseDataType);
        return {
            baseDataType,
            valueParser: (params) => (0, date_1._parseDateTimeFromString)(params.newValue && String(params.newValue)),
            valueFormatter: (params) => {
                if (params.value == null) {
                    return '';
                }
                if (!(params.value instanceof Date) || isNaN(params.value.getTime())) {
                    return translate('invalidDate', 'Invalid Date');
                }
                return (0, date_1._serialiseDate)(params.value, includeTime) ?? '';
            },
            dataTypeMatcher: (value) => value instanceof Date,
        };
    }
    getDateStringTypeDef(baseDataType) {
        const includeTime = this.getDateIncludesTimeFlag(baseDataType);
        return {
            baseDataType,
            dateParser: (value) => (0, date_1._parseDateTimeFromString)(value) ?? undefined,
            dateFormatter: (value) => (0, date_1._serialiseDate)(value ?? null, includeTime) ?? undefined,
            valueParser: (params) => (0, date_1._isValidDate)(String(params.newValue)) ? params.newValue : null,
            valueFormatter: (params) => (0, date_1._isValidDate)(String(params.value)) ? String(params.value) : '',
            dataTypeMatcher: (value) => typeof value === 'string' && (0, date_1._isValidDate)(value),
        };
    }
    getDefaultDataTypes() {
        const translate = this.getLocaleTextFunc();
        return {
            number: {
                baseDataType: 'number',
                // can be empty space with legacy copy
                valueParser: (params) => params.newValue?.trim?.() === '' ? null : Number(params.newValue),
                valueFormatter: (params) => {
                    if (params.value == null) {
                        return '';
                    }
                    if (typeof params.value !== 'number' || isNaN(params.value)) {
                        return translate('invalidNumber', 'Invalid Number');
                    }
                    return String(params.value);
                },
                dataTypeMatcher: (value) => typeof value === 'number',
            },
            text: {
                baseDataType: 'text',
                valueParser: (params) => params.newValue === '' ? null : (0, generic_1._toStringOrNull)(params.newValue),
                dataTypeMatcher: (value) => typeof value === 'string',
            },
            boolean: {
                baseDataType: 'boolean',
                valueParser: (params) => {
                    if (params.newValue == null) {
                        return params.newValue;
                    }
                    // can be empty space with legacy copy
                    return params.newValue?.trim?.() === '' ? null : String(params.newValue).toLowerCase() === 'true';
                },
                valueFormatter: (params) => params.value == null ? '' : String(params.value),
                dataTypeMatcher: (value) => typeof value === 'boolean',
            },
            date: this.getDateObjectTypeDef('date'),
            dateString: this.getDateStringTypeDef('dateString'),
            dateTime: this.getDateObjectTypeDef('dateTime'),
            dateTimeString: {
                ...this.getDateStringTypeDef('dateTimeString'),
                dataTypeMatcher: (value) => typeof value === 'string' && (0, date_1._isValidDateTime)(value),
            },
            object: {
                baseDataType: 'object',
                valueParser: () => null,
                valueFormatter: (params) => (0, generic_1._toStringOrNull)(params.value) ?? '',
            },
        };
    }
    destroyColumnStateUpdateListeners() {
        this.columnStateUpdateListenerDestroyFuncs.forEach((destroyFunc) => destroyFunc());
        this.columnStateUpdateListenerDestroyFuncs = [];
    }
    destroy() {
        this.dataTypeDefinitions = {};
        this.dataTypeMatchers = {};
        this.formatValueFuncs = {};
        this.columnStateUpdatesPendingInference = {};
        this.destroyColumnStateUpdateListeners();
        super.destroy();
    }
}
exports.DataTypeService = DataTypeService;
function mergeDataTypeDefinitions(parentDataTypeDefinition, childDataTypeDefinition) {
    const mergedDataTypeDefinition = {
        ...parentDataTypeDefinition,
        ...childDataTypeDefinition,
    };
    if (parentDataTypeDefinition.columnTypes &&
        childDataTypeDefinition.columnTypes &&
        childDataTypeDefinition.appendColumnTypes) {
        mergedDataTypeDefinition.columnTypes = [
            ...(0, columnUtils_1.convertColumnTypes)(parentDataTypeDefinition.columnTypes),
            ...(0, columnUtils_1.convertColumnTypes)(childDataTypeDefinition.columnTypes),
        ];
    }
    return mergedDataTypeDefinition;
}
function validateDataTypeDefinition(dataTypeDefinition, parentDataTypeDefinition, parentCellDataType) {
    if (!parentDataTypeDefinition) {
        (0, logging_1._warn)(45, { parentCellDataType });
        return false;
    }
    if (parentDataTypeDefinition.baseDataType !== dataTypeDefinition.baseDataType) {
        (0, logging_1._warn)(46);
        return false;
    }
    return true;
}
function createGroupSafeValueFormatter(dataTypeDefinition, gos) {
    if (!dataTypeDefinition.valueFormatter) {
        return undefined;
    }
    return (params) => {
        if (params.node?.group) {
            const aggFunc = (params.colDef.pivotValueColumn ?? params.column).getAggFunc();
            if (aggFunc) {
                // the resulting type of these will be the same, so we call valueFormatter anyway
                if (aggFunc === 'first' || aggFunc === 'last') {
                    return dataTypeDefinition.valueFormatter(params);
                }
                if (dataTypeDefinition.baseDataType === 'number' && aggFunc !== 'count') {
                    if (typeof params.value === 'number') {
                        return dataTypeDefinition.valueFormatter(params);
                    }
                    if (typeof params.value === 'object') {
                        if (!params.value) {
                            return undefined;
                        }
                        if ('toNumber' in params.value) {
                            return dataTypeDefinition.valueFormatter({
                                ...params,
                                value: params.value.toNumber(),
                            });
                        }
                        if ('value' in params.value) {
                            return dataTypeDefinition.valueFormatter({
                                ...params,
                                value: params.value.value,
                            });
                        }
                    }
                }
                // by default don't use value formatter for agg func as type may have changed
                return undefined;
            }
        }
        else if (gos.get('groupHideOpenParents') && params.column.isRowGroupActive()) {
            // `groupHideOpenParents` passes leaf values in the group column, so need to format still.
            // If it's not a string, we know it hasn't been formatted. Otherwise check the data type matcher.
            if (typeof params.value === 'string' && !dataTypeDefinition.dataTypeMatcher?.(params.value)) {
                return undefined;
            }
        }
        return dataTypeDefinition.valueFormatter(params);
    };
}
function doesColDefPropPreventInference(colDef, checkProps, prop, comparisonValue) {
    if (!checkProps[prop]) {
        return false;
    }
    const value = colDef[prop];
    if (value === null) {
        checkProps[prop] = false;
        return false;
    }
    else {
        return comparisonValue === undefined ? !!value : value === comparisonValue;
    }
}
function doColDefPropsPreventInference(colDef, propsToCheckForInference) {
    return [
        ['cellRenderer', 'agSparklineCellRenderer'],
        ['valueGetter', undefined],
        ['valueParser', undefined],
        ['refData', undefined],
    ].some(([prop, comparisonValue]) => doesColDefPropPreventInference(colDef, propsToCheckForInference, prop, comparisonValue));
}
function getUpdatedColumnState(column, columnStateUpdates) {
    const columnState = (0, columnStateUtils_1.getColumnStateFromColDef)(column);
    columnStateUpdates.forEach((key) => {
        // if the column state has been updated, don't update again
        delete columnState[key];
        if (key === 'rowGroup') {
            delete columnState.rowGroupIndex;
        }
        else if (key === 'pivot') {
            delete columnState.pivotIndex;
        }
    });
    return columnState;
}


/***/ }),

/***/ 96034:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GroupInstanceIdCreator = void 0;
// class returns unique instance id's for columns.
// eg, the following calls (in this order) will result in:
//
// getInstanceIdForKey('country') => 0
// getInstanceIdForKey('country') => 1
// getInstanceIdForKey('country') => 2
// getInstanceIdForKey('country') => 3
// getInstanceIdForKey('age') => 0
// getInstanceIdForKey('age') => 1
// getInstanceIdForKey('country') => 4
class GroupInstanceIdCreator {
    constructor() {
        // this map contains keys to numbers, so we remember what the last call was
        this.existingIds = {};
    }
    getInstanceIdForKey(key) {
        const lastResult = this.existingIds[key];
        let result;
        if (typeof lastResult !== 'number') {
            // first time this key
            result = 0;
        }
        else {
            result = lastResult + 1;
        }
        this.existingIds[key] = result;
        return result;
    }
}
exports.GroupInstanceIdCreator = GroupInstanceIdCreator;


/***/ }),

/***/ 75626:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectionColService = void 0;
const array_1 = __webpack_require__(79909);
const beanStub_1 = __webpack_require__(68731);
const agColumn_1 = __webpack_require__(13355);
const gridOptionsUtils_1 = __webpack_require__(67274);
const columnStateUtils_1 = __webpack_require__(2885);
const columnUtils_1 = __webpack_require__(73146);
class SelectionColService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'selectionColSvc';
    }
    postConstruct() {
        this.addManagedPropertyListener('rowSelection', (event) => {
            this.onSelectionOptionsChanged(event.currentValue, event.previousValue, (0, columnUtils_1._convertColumnEventSourceType)(event.source));
        });
        this.addManagedPropertyListener('selectionColumnDef', this.updateColumns.bind(this));
    }
    addColumns(cols) {
        const selectionCols = this.columns;
        if (selectionCols == null) {
            return;
        }
        cols.list = selectionCols.list.concat(cols.list);
        cols.tree = selectionCols.tree.concat(cols.tree);
        (0, columnUtils_1._updateColsMap)(cols);
    }
    createColumns(cols, updateOrders) {
        const destroyCollection = () => {
            (0, columnUtils_1._destroyColumnTree)(this.beans, this.columns?.tree);
            this.columns = null;
        };
        const newTreeDepth = cols.treeDepth;
        const oldTreeDepth = this.columns?.treeDepth ?? -1;
        const treeDepthSame = oldTreeDepth == newTreeDepth;
        const list = this.generateSelectionCols();
        const areSame = (0, columnUtils_1._areColIdsEqual)(list, this.columns?.list ?? []);
        if (areSame && treeDepthSame) {
            return;
        }
        destroyCollection();
        const { colGroupSvc } = this.beans;
        const treeDepth = colGroupSvc?.findDepth(cols.tree) ?? 0;
        const tree = colGroupSvc?.balanceTreeForAutoCols(list, treeDepth) ?? [];
        this.columns = {
            list,
            tree,
            treeDepth,
            map: {},
        };
        const putSelectionColsFirstInList = (cols) => {
            if (!cols) {
                return null;
            }
            // we use colId, and not instance, to remove old selectionCols
            const colsFiltered = cols.filter((col) => !(0, columnUtils_1.isColumnSelectionCol)(col));
            return [...list, ...colsFiltered];
        };
        updateOrders(putSelectionColsFirstInList);
    }
    updateColumns(event) {
        const source = (0, columnUtils_1._convertColumnEventSourceType)(event.source);
        this.columns?.list.forEach((col) => {
            const newColDef = this.createSelectionColDef(event.currentValue);
            col.setColDef(newColDef, null, source);
            (0, columnStateUtils_1._applyColumnState)(this.beans, { state: [{ ...newColDef, colId: col.getColId() }] }, source);
        });
    }
    getColumn(key) {
        return this.columns?.list.find((col) => (0, columnUtils_1._columnsMatch)(col, key)) ?? null;
    }
    getColumns() {
        return this.columns?.list ?? null;
    }
    isSelectionColumnEnabled() {
        const { gos, beans } = this;
        const rowSelection = gos.get('rowSelection');
        if (typeof rowSelection !== 'object' || !(0, gridOptionsUtils_1._isRowSelection)(gos)) {
            return false;
        }
        const hasAutoCols = (beans.autoColSvc?.getColumns()?.length ?? 0) > 0;
        if (rowSelection.checkboxLocation === 'autoGroupColumn' && hasAutoCols) {
            return false;
        }
        const checkboxes = !!(0, gridOptionsUtils_1._getCheckboxes)(rowSelection);
        const headerCheckbox = (0, gridOptionsUtils_1._getHeaderCheckbox)(rowSelection);
        return checkboxes || headerCheckbox;
    }
    createSelectionColDef(def) {
        const { gos } = this;
        const selectionColumnDef = def ?? gos.get('selectionColumnDef');
        const enableRTL = gos.get('enableRtl');
        // We don't support row spanning in the selection column
        const { rowSpan: _, spanRows: __, ...filteredSelColDef } = (selectionColumnDef ?? {});
        return {
            // overridable properties
            width: 50,
            resizable: false,
            suppressHeaderMenuButton: true,
            sortable: false,
            suppressMovable: true,
            lockPosition: enableRTL ? 'right' : 'left',
            comparator(valueA, valueB, nodeA, nodeB) {
                const aSelected = nodeA.isSelected();
                const bSelected = nodeB.isSelected();
                return aSelected === bSelected ? 0 : aSelected ? 1 : -1;
            },
            editable: false,
            suppressFillHandle: true,
            pinned: null,
            // overrides
            ...filteredSelColDef,
            // non-overridable properties
            colId: columnUtils_1.SELECTION_COLUMN_ID,
            chartDataType: 'excluded',
        };
    }
    generateSelectionCols() {
        if (!this.isSelectionColumnEnabled()) {
            return [];
        }
        const colDef = this.createSelectionColDef();
        const colId = colDef.colId;
        this.gos.validateColDef(colDef, colId, true);
        const col = new agColumn_1.AgColumn(colDef, null, colId, false);
        this.createBean(col);
        return [col];
    }
    onSelectionOptionsChanged(current, prev, source) {
        const prevCheckbox = prev && typeof prev !== 'string' ? (0, gridOptionsUtils_1._getCheckboxes)(prev) : undefined;
        const currCheckbox = current && typeof current !== 'string' ? (0, gridOptionsUtils_1._getCheckboxes)(current) : undefined;
        const checkboxHasChanged = prevCheckbox !== currCheckbox;
        const prevHeaderCheckbox = prev && typeof prev !== 'string' ? (0, gridOptionsUtils_1._getHeaderCheckbox)(prev) : undefined;
        const currHeaderCheckbox = current && typeof current !== 'string' ? (0, gridOptionsUtils_1._getHeaderCheckbox)(current) : undefined;
        const headerCheckboxHasChanged = prevHeaderCheckbox !== currHeaderCheckbox;
        const currLocation = (0, gridOptionsUtils_1._getCheckboxLocation)(current);
        const prevLocation = (0, gridOptionsUtils_1._getCheckboxLocation)(prev);
        const locationChanged = currLocation !== prevLocation;
        if (checkboxHasChanged || headerCheckboxHasChanged || locationChanged) {
            this.beans.colModel.refreshAll(source);
        }
    }
    destroy() {
        (0, columnUtils_1._destroyColumnTree)(this.beans, this.columns?.tree);
        super.destroy();
    }
    /**
     * Refreshes visibility of the selection column based on which columns are currently visible.
     * Called by the VisibleColsService with the columns that are currently visible in left/center/right
     * containers. This method *MUTATES* those arrays directly.
     *
     * The selection column should be visible if all of the following are true
     * - The selection column is not disabled
     * - The number of visible columns excluding the selection column and row numbers column is greater than 0
     * @param leftCols Visible columns in the left-pinned container
     * @param centerCols Visible columns in the center viewport
     * @param rightCols Visible columns in the right-pinned container
     */
    refreshVisibility(leftCols, centerCols, rightCols) {
        // columns list will only be populated if selection column is enabled
        if (!this.columns?.list.length) {
            return;
        }
        const numVisibleCols = leftCols.length + centerCols.length + rightCols.length;
        if (numVisibleCols === 0) {
            return;
        }
        // There's only one selection column
        const column = this.columns.list[0];
        // If it's deliberately hidden, we needn't do anything
        if (!column.isVisible())
            return;
        const hideSelectionCol = () => {
            let cols;
            switch (column.pinned) {
                case 'left':
                case true:
                    cols = leftCols;
                    break;
                case 'right':
                    cols = rightCols;
                    break;
                default:
                    cols = centerCols;
            }
            cols && (0, array_1._removeFromArray)(cols, column);
        };
        const rowNumbersCol = this.beans.rowNumbersSvc?.getColumn(columnUtils_1.ROW_NUMBERS_COLUMN_ID);
        // two conditions for which we hide selection column:
        //   1. Only selection column and row numbers column are visible
        //   2. Only selection column is visible
        const expectedNumCols = rowNumbersCol ? 2 : 1;
        if (expectedNumCols === numVisibleCols) {
            hideSelectionCol();
        }
    }
}
exports.SelectionColService = SelectionColService;


/***/ }),

/***/ 6869:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.depthFirstAllColumnTreeSearch = exports.VisibleColsService = void 0;
const array_1 = __webpack_require__(79909);
const beanStub_1 = __webpack_require__(68731);
const agColumn_1 = __webpack_require__(13355);
const agColumnGroup_1 = __webpack_require__(56908);
const columnUtils_1 = __webpack_require__(73146);
const groupInstanceIdCreator_1 = __webpack_require__(96034);
function _removeAllFromUnorderedArray(array, toRemove) {
    for (let i = 0; i < toRemove.length; i++) {
        const index = array.indexOf(toRemove[i]);
        if (index >= 0) {
            // preserve the last element, then shorten array length by 1 to delete index
            array[index] = array[array.length - 1];
            array.pop();
        }
    }
}
// takes in a list of columns, as specified by the column definitions, and returns column groups
class VisibleColsService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'visibleCols';
        // for fast lookup, to see if a column or group is still visible
        this.colsAndGroupsMap = {};
        // leave level columns of the displayed trees
        this.leftCols = [];
        this.rightCols = [];
        this.centerCols = [];
        // all three lists above combined
        this.allCols = [];
        this.headerGroupRowCount = 0; // number of header rows to render
        // used by:
        // + angularGrid -> for setting body width
        // + rowController -> setting main row widths (when inserting and resizing)
        // need to cache this
        this.bodyWidth = 0;
        this.leftWidth = 0;
        this.rightWidth = 0;
        this.isBodyWidthDirty = true;
    }
    refresh(source, skipTreeBuild = false) {
        const { colFlex, colModel, colGroupSvc, colViewport, selectionColSvc } = this.beans;
        // when we open/close col group, skipTreeBuild=false, as we know liveCols haven't changed
        if (!skipTreeBuild) {
            this.buildTrees(colModel, colGroupSvc);
        }
        colGroupSvc?.updateOpenClosedVisibility();
        this.leftCols = pickDisplayedCols(this.treeLeft);
        this.centerCols = pickDisplayedCols(this.treeCenter);
        this.rightCols = pickDisplayedCols(this.treeRight);
        selectionColSvc?.refreshVisibility(this.leftCols, this.centerCols, this.rightCols);
        this.joinColsAriaOrder(colModel);
        this.joinCols();
        this.headerGroupRowCount = this.getHeaderRowCount();
        this.setLeftValues(source);
        this.autoHeightCols = this.allCols.filter((col) => col.isAutoHeight());
        colFlex?.refreshFlexedColumns();
        this.updateBodyWidths();
        this.setFirstRightAndLastLeftPinned(colModel, this.leftCols, this.rightCols, source);
        colViewport.checkViewportColumns(false);
        this.eventSvc.dispatchEvent({
            type: 'displayedColumnsChanged',
            source,
        });
    }
    getHeaderRowCount() {
        if (!this.gos.get('hidePaddedHeaderRows')) {
            return this.beans.colModel.cols.treeDepth;
        }
        let headerGroupRowCount = 0;
        for (const col of this.allCols) {
            let parent = col.getParent();
            while (parent) {
                if (!parent.isPadding()) {
                    const level = parent.getProvidedColumnGroup().getLevel() + 1;
                    if (level > headerGroupRowCount) {
                        headerGroupRowCount = level;
                    }
                    break;
                }
                parent = parent.getParent();
            }
        }
        return headerGroupRowCount;
    }
    // after setColumnWidth or updateGroupsAndPresentedCols
    updateBodyWidths() {
        const newBodyWidth = (0, columnUtils_1.getWidthOfColsInList)(this.centerCols);
        const newLeftWidth = (0, columnUtils_1.getWidthOfColsInList)(this.leftCols);
        const newRightWidth = (0, columnUtils_1.getWidthOfColsInList)(this.rightCols);
        // this is used by virtual col calculation, for RTL only, as a change to body width can impact displayed
        // columns, due to RTL inverting the y coordinates
        this.isBodyWidthDirty = this.bodyWidth !== newBodyWidth;
        const atLeastOneChanged = this.bodyWidth !== newBodyWidth || this.leftWidth !== newLeftWidth || this.rightWidth !== newRightWidth;
        if (atLeastOneChanged) {
            this.bodyWidth = newBodyWidth;
            this.leftWidth = newLeftWidth;
            this.rightWidth = newRightWidth;
            // this event is fired to allow the grid viewport to resize before the
            // scrollbar tries to update its visibility.
            this.eventSvc.dispatchEvent({
                type: 'columnContainerWidthChanged',
            });
            // when this fires, it is picked up by the gridPanel, which ends up in
            // gridPanel calling setWidthAndScrollPosition(), which in turn calls setViewportPosition()
            this.eventSvc.dispatchEvent({
                type: 'displayedColumnsWidthChanged',
            });
        }
    }
    // sets the left pixel position of each column
    setLeftValues(source) {
        this.setLeftValuesOfCols(source);
        this.setLeftValuesOfGroups();
    }
    setFirstRightAndLastLeftPinned(colModel, leftCols, rightCols, source) {
        let lastLeft;
        let firstRight;
        if (this.gos.get('enableRtl')) {
            lastLeft = leftCols ? leftCols[0] : null;
            firstRight = rightCols ? (0, array_1._last)(rightCols) : null;
        }
        else {
            lastLeft = leftCols ? (0, array_1._last)(leftCols) : null;
            firstRight = rightCols ? rightCols[0] : null;
        }
        colModel.getCols().forEach((col) => {
            col.setLastLeftPinned(col === lastLeft, source);
            col.setFirstRightPinned(col === firstRight, source);
        });
    }
    buildTrees(colModel, columnGroupSvc) {
        const cols = colModel.getColsToShow();
        const leftCols = cols.filter((col) => col.getPinned() == 'left');
        const rightCols = cols.filter((col) => col.getPinned() == 'right');
        const centerCols = cols.filter((col) => col.getPinned() != 'left' && col.getPinned() != 'right');
        const idCreator = new groupInstanceIdCreator_1.GroupInstanceIdCreator();
        const createGroups = (params) => {
            return columnGroupSvc ? columnGroupSvc.createColumnGroups(params) : params.columns;
        };
        this.treeLeft = createGroups({
            columns: leftCols,
            idCreator,
            pinned: 'left',
            oldDisplayedGroups: this.treeLeft,
        });
        this.treeRight = createGroups({
            columns: rightCols,
            idCreator,
            pinned: 'right',
            oldDisplayedGroups: this.treeRight,
        });
        this.treeCenter = createGroups({
            columns: centerCols,
            idCreator,
            pinned: null,
            oldDisplayedGroups: this.treeCenter,
        });
        this.updateColsAndGroupsMap();
    }
    clear() {
        this.leftCols = [];
        this.rightCols = [];
        this.centerCols = [];
        this.allCols = [];
        this.ariaOrderColumns = [];
    }
    joinColsAriaOrder(colModel) {
        const allColumns = colModel.getCols();
        const pinnedLeft = [];
        const center = [];
        const pinnedRight = [];
        for (const col of allColumns) {
            const pinned = col.getPinned();
            if (!pinned) {
                center.push(col);
            }
            else if (pinned === true || pinned === 'left') {
                pinnedLeft.push(col);
            }
            else {
                pinnedRight.push(col);
            }
        }
        this.ariaOrderColumns = pinnedLeft.concat(center).concat(pinnedRight);
    }
    getAriaColIndex(colOrGroup) {
        let col;
        if ((0, agColumnGroup_1.isColumnGroup)(colOrGroup)) {
            col = colOrGroup.getLeafColumns()[0];
        }
        else {
            col = colOrGroup;
        }
        return this.ariaOrderColumns.indexOf(col) + 1;
    }
    setLeftValuesOfGroups() {
        // a groups left value is the lest left value of it's children
        [this.treeLeft, this.treeRight, this.treeCenter].forEach((columns) => {
            columns.forEach((column) => {
                if ((0, agColumnGroup_1.isColumnGroup)(column)) {
                    const columnGroup = column;
                    columnGroup.checkLeft();
                }
            });
        });
    }
    setLeftValuesOfCols(source) {
        const { colModel } = this.beans;
        const primaryCols = colModel.getColDefCols();
        if (!primaryCols) {
            return;
        }
        // go through each list of displayed columns
        const allColumns = colModel.getCols().slice(0);
        // let totalColumnWidth = this.getWidthOfColsInList()
        const doingRtl = this.gos.get('enableRtl');
        [this.leftCols, this.rightCols, this.centerCols].forEach((columns) => {
            if (doingRtl) {
                // when doing RTL, we start at the top most pixel (ie RHS) and work backwards
                let left = (0, columnUtils_1.getWidthOfColsInList)(columns);
                columns.forEach((column) => {
                    left -= column.getActualWidth();
                    column.setLeft(left, source);
                });
            }
            else {
                // otherwise normal LTR, we start at zero
                let left = 0;
                columns.forEach((column) => {
                    column.setLeft(left, source);
                    left += column.getActualWidth();
                });
            }
            _removeAllFromUnorderedArray(allColumns, columns);
        });
        // items left in allColumns are columns not displayed, so remove the left position. this is
        // important for the rows, as if a col is made visible, then taken out, then made visible again,
        // we don't want the animation of the cell floating in from the old position, whatever that was.
        allColumns.forEach((column) => {
            column.setLeft(null, source);
        });
    }
    joinCols() {
        if (this.gos.get('enableRtl')) {
            this.allCols = this.rightCols.concat(this.centerCols).concat(this.leftCols);
        }
        else {
            this.allCols = this.leftCols.concat(this.centerCols).concat(this.rightCols);
        }
    }
    getAllTrees() {
        if (this.treeLeft && this.treeRight && this.treeCenter) {
            return this.treeLeft.concat(this.treeCenter).concat(this.treeRight);
        }
        return null;
    }
    // gridPanel -> ensureColumnVisible
    isColDisplayed(column) {
        return this.allCols.indexOf(column) >= 0;
    }
    getLeftColsForRow(rowNode) {
        const { leftCols, beans: { colModel }, } = this;
        const colSpanActive = colModel.colSpanActive;
        if (!colSpanActive) {
            return leftCols;
        }
        return this.getColsForRow(rowNode, leftCols);
    }
    getRightColsForRow(rowNode) {
        const { rightCols, beans: { colModel }, } = this;
        const colSpanActive = colModel.colSpanActive;
        if (!colSpanActive) {
            return rightCols;
        }
        return this.getColsForRow(rowNode, rightCols);
    }
    getColsForRow(rowNode, displayedColumns, filterCallback, emptySpaceBeforeColumn) {
        const result = [];
        let lastConsideredCol = null;
        for (let i = 0; i < displayedColumns.length; i++) {
            const col = displayedColumns[i];
            const maxAllowedColSpan = displayedColumns.length - i;
            const colSpan = Math.min(col.getColSpan(rowNode), maxAllowedColSpan);
            const columnsToCheckFilter = [col];
            if (colSpan > 1) {
                const colsToRemove = colSpan - 1;
                for (let j = 1; j <= colsToRemove; j++) {
                    columnsToCheckFilter.push(displayedColumns[i + j]);
                }
                i += colsToRemove;
            }
            // see which cols we should take out for column virtualisation
            let filterPasses;
            if (filterCallback) {
                // if user provided a callback, means some columns may not be in the viewport.
                // the user will NOT provide a callback if we are talking about pinned areas,
                // as pinned areas have no horizontal scroll and do not virtualise the columns.
                // if lots of columns, that means column spanning, and we set filterPasses = true
                // if one or more of the columns spanned pass the filter.
                filterPasses = false;
                columnsToCheckFilter.forEach((colForFilter) => {
                    if (filterCallback(colForFilter)) {
                        filterPasses = true;
                    }
                });
            }
            else {
                filterPasses = true;
            }
            if (filterPasses) {
                if (result.length === 0 && lastConsideredCol) {
                    const gapBeforeColumn = emptySpaceBeforeColumn ? emptySpaceBeforeColumn(col) : false;
                    if (gapBeforeColumn) {
                        result.push(lastConsideredCol);
                    }
                }
                result.push(col);
            }
            lastConsideredCol = col;
        }
        return result;
    }
    getContainerWidth(pinned) {
        switch (pinned) {
            case 'left':
                return this.leftWidth;
            case 'right':
                return this.rightWidth;
            default:
                return this.bodyWidth;
        }
    }
    getColBefore(col) {
        const allDisplayedColumns = this.allCols;
        const oldIndex = allDisplayedColumns.indexOf(col);
        if (oldIndex > 0) {
            return allDisplayedColumns[oldIndex - 1];
        }
        return null;
    }
    isPinningLeft() {
        return this.leftCols.length > 0;
    }
    isPinningRight() {
        return this.rightCols.length > 0;
    }
    updateColsAndGroupsMap() {
        this.colsAndGroupsMap = {};
        const func = (child) => {
            this.colsAndGroupsMap[child.getUniqueId()] = child;
        };
        depthFirstAllColumnTreeSearch(this.treeCenter, false, func);
        depthFirstAllColumnTreeSearch(this.treeLeft, false, func);
        depthFirstAllColumnTreeSearch(this.treeRight, false, func);
    }
    isVisible(item) {
        const fromMap = this.colsAndGroupsMap[item.getUniqueId()];
        // check for reference, in case new column / group with same id is now present
        return fromMap === item;
    }
    getFirstColumn() {
        const isRtl = this.gos.get('enableRtl');
        const queryOrder = ['leftCols', 'centerCols', 'rightCols'];
        if (isRtl) {
            queryOrder.reverse();
        }
        for (let i = 0; i < queryOrder.length; i++) {
            const container = this[queryOrder[i]];
            if (container.length) {
                return isRtl ? (0, array_1._last)(container) : container[0];
            }
        }
        return null;
    }
    // used by:
    // + rowRenderer -> for navigation
    getColAfter(col) {
        const allDisplayedColumns = this.allCols;
        const oldIndex = allDisplayedColumns.indexOf(col);
        if (oldIndex < allDisplayedColumns.length - 1) {
            return allDisplayedColumns[oldIndex + 1];
        }
        return null;
    }
    // used by:
    // + angularGrid -> setting pinned body width
    // note: this should be cached
    getColsLeftWidth() {
        return (0, columnUtils_1.getWidthOfColsInList)(this.leftCols);
    }
    // note: this should be cached
    getDisplayedColumnsRightWidth() {
        return (0, columnUtils_1.getWidthOfColsInList)(this.rightCols);
    }
    isColAtEdge(col, edge) {
        const allColumns = this.allCols;
        if (!allColumns.length) {
            return false;
        }
        const isFirst = edge === 'first';
        let columnToCompare;
        if ((0, agColumnGroup_1.isColumnGroup)(col)) {
            const leafColumns = col.getDisplayedLeafColumns();
            if (!leafColumns.length) {
                return false;
            }
            columnToCompare = isFirst ? leafColumns[0] : (0, array_1._last)(leafColumns);
        }
        else {
            columnToCompare = col;
        }
        return (isFirst ? allColumns[0] : (0, array_1._last)(allColumns)) === columnToCompare;
    }
}
exports.VisibleColsService = VisibleColsService;
function depthFirstAllColumnTreeSearch(tree, useDisplayedChildren, callback) {
    if (!tree) {
        return;
    }
    for (let i = 0; i < tree.length; i++) {
        const child = tree[i];
        if ((0, agColumnGroup_1.isColumnGroup)(child)) {
            const childTree = useDisplayedChildren ? child.getDisplayedChildren() : child.getChildren();
            depthFirstAllColumnTreeSearch(childTree, useDisplayedChildren, callback);
        }
        callback(child);
    }
}
exports.depthFirstAllColumnTreeSearch = depthFirstAllColumnTreeSearch;
function pickDisplayedCols(tree) {
    const res = [];
    depthFirstAllColumnTreeSearch(tree, true, (child) => {
        if ((0, agColumn_1.isColumn)(child)) {
            res.push(child);
        }
    });
    return res;
}


/***/ }),

/***/ 33789:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.setupCompBean = exports.EmptyBean = void 0;
const beanStub_1 = __webpack_require__(68731);
/**
 * An EmptyBean can be used to manage the lifecycle of event handlers that are tied to a component instead of a controller.
 * Used in React to avoid duplicating listeners and setup logic while React is running in StrictMode where setComp will be called multiple times.
 * This is only required for the Components where the ctrl is managed by AG Grid and passed into the React component.
 * Both React and the Ctrl can decide to destroy the EmptyBean which will clean up listeners setup against it.
 */
class EmptyBean extends beanStub_1.BeanStub {
}
exports.EmptyBean = EmptyBean;
/**
 * Sets up the logic for managing the lifecycle of a compBean against a ctrl so that we always cleanup
 * our listeners and destroy the compBean when the ctrl is destroyed no matter which is destroyed first.
 * Closely related to React StrictMode as the compBean is provided from React so it can double render
 * and correctly cleanup listeners from the first render.
 * @param ctrl Ctrl that has setComp called against it
 * @param ctx  Context to use to destroy the compBean
 * @param compBean Optional compBean to use, if not provided, the ctrl will be used
 * @returns The compBean if provided, otherwise the ctrl
 */
function setupCompBean(ctrl, ctx, compBean) {
    if (compBean) {
        // If the ctrl is destroyed first, we need to destroy the compBean
        ctrl.addDestroyFunc(() => ctx.destroyBean(compBean));
    }
    return compBean ?? ctrl;
}
exports.setupCompBean = setupCompBean;


/***/ }),

/***/ 54309:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgComponentUtils = void 0;
const dom_1 = __webpack_require__(1956);
const beanStub_1 = __webpack_require__(68731);
const element_1 = __webpack_require__(73151);
class AgComponentUtils extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'agCompUtils';
    }
    adaptFunction(type, jsCompFunc) {
        if (!type.cellRenderer) {
            return null;
        }
        class Adapter {
            refresh() {
                return false;
            }
            getGui() {
                return this.eGui;
            }
            init(params) {
                const callbackResult = jsCompFunc(params);
                const type = typeof callbackResult;
                if (type === 'string' || type === 'number' || type === 'boolean') {
                    this.eGui = (0, dom_1._loadTemplate)('<span>' + callbackResult + '</span>');
                    return;
                }
                if (callbackResult == null) {
                    this.eGui = (0, element_1._createElement)({ tag: 'span' });
                    return;
                }
                this.eGui = callbackResult;
            }
        }
        return Adapter;
    }
}
exports.AgComponentUtils = AgComponentUtils;


/***/ }),

/***/ 28414:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CellRendererFunctionModule = void 0;
const version_1 = __webpack_require__(97205);
const agComponentUtils_1 = __webpack_require__(54309);
/**
 * @internal
 */
exports.CellRendererFunctionModule = {
    moduleName: 'CellRendererFunction',
    version: version_1.VERSION,
    beans: [agComponentUtils_1.AgComponentUtils],
};


/***/ }),

/***/ 8759:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseComponentWrapper = void 0;
const logging_1 = __webpack_require__(47764);
class BaseComponentWrapper {
    wrap(OriginalConstructor, mandatoryMethods, optionalMethods, componentType) {
        const wrapper = this.createWrapper(OriginalConstructor, componentType);
        mandatoryMethods?.forEach((methodName) => {
            this.createMethod(wrapper, methodName, true);
        });
        optionalMethods?.forEach((methodName) => {
            this.createMethod(wrapper, methodName, false);
        });
        return wrapper;
    }
    createMethod(wrapper, methodName, mandatory) {
        wrapper.addMethod(methodName, this.createMethodProxy(wrapper, methodName, mandatory));
    }
    createMethodProxy(wrapper, methodName, mandatory) {
        return function () {
            if (wrapper.hasMethod(methodName)) {
                // eslint-disable-next-line
                return wrapper.callMethod(methodName, arguments);
            }
            if (mandatory) {
                (0, logging_1._warn)(49, { methodName });
            }
            // multiple features rely on this returning `null` rather than `undefined`,
            // so that they can differentiate whether the underlying component has implemented a void method or not
            return null;
        };
    }
}
exports.BaseComponentWrapper = BaseComponentWrapper;


/***/ }),

/***/ 34110:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Registry = void 0;
const baseRegistry_1 = __webpack_require__(34232);
const context_1 = __webpack_require__(62342);
const logging_1 = __webpack_require__(47764);
class Registry extends baseRegistry_1.BaseRegistry {
    constructor() {
        super(...arguments);
        this.agGridDefaults = {};
        this.agGridDefaultOverrides = {};
        this.jsComps = {};
        this.selectors = {};
        this.icons = {};
    }
    postConstruct() {
        const comps = this.gos.get('components');
        if (comps != null) {
            for (const key of Object.keys(comps)) {
                this.jsComps[key] = comps[key];
            }
        }
    }
    registerModule(module) {
        const { icons, userComponents, dynamicBeans, selectors } = module;
        if (userComponents) {
            const registerUserComponent = (name, component, params, processParams) => {
                this.agGridDefaults[name] = component;
                if (params || processParams) {
                    this.agGridDefaultOverrides[name] = { params, processParams };
                }
            };
            for (const name of Object.keys(userComponents)) {
                let comp = userComponents[name];
                if ((0, context_1.isComponentMetaFunc)(comp)) {
                    comp = comp.getComp(this.beans);
                }
                if (typeof comp === 'object') {
                    const { classImp, params, processParams } = comp;
                    registerUserComponent(name, classImp, params, processParams);
                }
                else {
                    registerUserComponent(name, comp);
                }
            }
        }
        this.registerDynamicBeans(dynamicBeans);
        selectors?.forEach((selector) => {
            this.selectors[selector.selector] = selector;
        });
        if (icons) {
            for (const name of Object.keys(icons)) {
                this.icons[name] = icons[name];
            }
        }
    }
    getUserComponent(propertyName, name) {
        const createResult = (component, componentFromFramework, params, processParams) => ({
            componentFromFramework,
            component,
            params,
            processParams,
        });
        const { frameworkOverrides } = this.beans;
        // FrameworkOverrides.frameworkComponent() is used in two locations:
        // 1) for Vue, user provided components get registered via a framework specific way.
        // 2) for React, it's how the React UI provides alternative default components (eg GroupCellRenderer and DetailCellRenderer)
        const registeredViaFrameworkComp = frameworkOverrides.frameworkComponent(name, this.gos.get('components'));
        if (registeredViaFrameworkComp != null) {
            return createResult(registeredViaFrameworkComp, true);
        }
        const jsComponent = this.jsComps[name];
        if (jsComponent) {
            const isFwkComp = frameworkOverrides.isFrameworkComponent(jsComponent);
            return createResult(jsComponent, isFwkComp);
        }
        const defaultComponent = this.agGridDefaults[name];
        if (defaultComponent) {
            const overrides = this.agGridDefaultOverrides[name];
            return createResult(defaultComponent, false, overrides?.params, overrides?.processParams);
        }
        this.beans.validation?.missingUserComponent(propertyName, name, this.agGridDefaults, this.jsComps);
        return null;
    }
    getSelector(name) {
        return this.selectors[name];
    }
    getIcon(name) {
        return this.icons[name];
    }
    getDynamicError(name, init) {
        if (init) {
            return (0, logging_1._errMsg)(279, { name });
        }
        return this.beans.validation?.missingDynamicBean(name) ?? (0, logging_1._errMsg)(256);
    }
}
exports.Registry = Registry;


/***/ }),

/***/ 54126:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._unwrapUserComp = void 0;
function _unwrapUserComp(comp) {
    const compAsAny = comp;
    const isProxy = compAsAny != null && compAsAny.getFrameworkComponentInstance != null;
    return isProxy ? compAsAny.getFrameworkComponentInstance() : comp;
}
exports._unwrapUserComp = _unwrapUserComp;


/***/ }),

/***/ 12036:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._mergeFilterParamsWithApplicationProvidedParams = exports._getFilterCompKeys = exports._getFloatingFilterCompDetails = exports._getTooltipCompDetails = exports._getNoRowsOverlayCompDetails = exports._getLoadingOverlayCompDetails = exports._getDateCompDetails = exports._getFilterDetails = exports._getCellEditorDetails = exports._getLoadingCellRendererDetails = exports._getEditorRendererDetails = exports._getCellRendererDetails = exports._getFullWidthDetailCellRendererDetails = exports._getFullWidthGroupCellRendererDetails = exports._getFullWidthLoadingCellRendererDetails = exports._getFullWidthCellRendererDetails = exports._getInnerHeaderGroupCompDetails = exports._getHeaderGroupCompDetails = exports._getInnerHeaderCompDetails = exports._getHeaderCompDetails = exports._getInnerCellRendererDetails = exports._getDragAndDropImageCompDetails = void 0;
const iFilter_1 = __webpack_require__(25679);
const userComponentFactory_1 = __webpack_require__(31585);
const DateComponent = {
    name: 'dateComponent',
    mandatoryMethods: ['getDate', 'setDate'],
    optionalMethods: ['afterGuiAttached', 'setInputPlaceholder', 'setInputAriaLabel', 'setDisabled', 'refresh'],
};
const DragAndDropImageComponent = {
    name: 'dragAndDropImageComponent',
    mandatoryMethods: ['setIcon', 'setLabel'],
};
const HeaderComponent = { name: 'headerComponent', optionalMethods: ['refresh'] };
const InnerHeaderComponent = { name: 'innerHeaderComponent' };
const InnerHeaderGroupComponent = { name: 'innerHeaderGroupComponent' };
const HeaderGroupComponent = { name: 'headerGroupComponent' };
const InnerCellRendererComponent = {
    name: 'innerRenderer',
    cellRenderer: true,
    optionalMethods: ['afterGuiAttached'],
};
const CellRendererComponent = {
    name: 'cellRenderer',
    optionalMethods: ['refresh', 'afterGuiAttached'],
    cellRenderer: true,
};
const EditorRendererComponent = {
    name: 'cellRenderer',
    optionalMethods: ['refresh', 'afterGuiAttached'],
};
const LoadingCellRendererComponent = { name: 'loadingCellRenderer', cellRenderer: true };
const CellEditorComponent = {
    name: 'cellEditor',
    mandatoryMethods: ['getValue'],
    optionalMethods: [
        'isPopup',
        'isCancelBeforeStart',
        'isCancelAfterEnd',
        'getPopupPosition',
        'focusIn',
        'focusOut',
        'afterGuiAttached',
        'refresh',
    ],
};
const LoadingOverlayComponent = { name: 'loadingOverlayComponent', optionalMethods: ['refresh'] };
const NoRowsOverlayComponent = { name: 'noRowsOverlayComponent', optionalMethods: ['refresh'] };
const TooltipComponent = { name: 'tooltipComponent' };
const FilterComponent = {
    name: 'filter',
    mandatoryMethods: ['isFilterActive', 'doesFilterPass', 'getModel', 'setModel'],
    optionalMethods: [
        'afterGuiAttached',
        'afterGuiDetached',
        'onNewRowsLoaded',
        'getModelAsString',
        'onFloatingFilterChanged',
        'onAnyFilterChanged',
        'refresh',
    ],
};
const FloatingFilterComponent = {
    name: 'floatingFilterComponent',
    mandatoryMethods: ['onParentModelChanged'],
    optionalMethods: ['afterGuiAttached', 'refresh'],
};
const FullWidth = {
    name: 'fullWidthCellRenderer',
    optionalMethods: ['refresh', 'afterGuiAttached'],
    cellRenderer: true,
};
const FullWidthLoading = { name: 'loadingCellRenderer', cellRenderer: true };
const FullWidthGroup = {
    name: 'groupRowRenderer',
    optionalMethods: ['afterGuiAttached'],
    cellRenderer: true,
};
const FullWidthDetail = { name: 'detailCellRenderer', optionalMethods: ['refresh'], cellRenderer: true };
function _getDragAndDropImageCompDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(DragAndDropImageComponent, 'agDragAndDropImage', params, true);
}
exports._getDragAndDropImageCompDetails = _getDragAndDropImageCompDetails;
function _getInnerCellRendererDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, InnerCellRendererComponent, undefined, params);
}
exports._getInnerCellRendererDetails = _getInnerCellRendererDetails;
function _getHeaderCompDetails(userCompFactory, colDef, params) {
    return userCompFactory.getCompDetails(colDef, HeaderComponent, 'agColumnHeader', params);
}
exports._getHeaderCompDetails = _getHeaderCompDetails;
function _getInnerHeaderCompDetails(userCompFactory, headerCompParams, params) {
    return userCompFactory.getCompDetails(headerCompParams, InnerHeaderComponent, undefined, params);
}
exports._getInnerHeaderCompDetails = _getInnerHeaderCompDetails;
function _getHeaderGroupCompDetails(userCompFactory, params) {
    const colGroupDef = params.columnGroup.getColGroupDef();
    return userCompFactory.getCompDetails(colGroupDef, HeaderGroupComponent, 'agColumnGroupHeader', params);
}
exports._getHeaderGroupCompDetails = _getHeaderGroupCompDetails;
function _getInnerHeaderGroupCompDetails(userCompFactory, headerGroupCompParams, params) {
    return userCompFactory.getCompDetails(headerGroupCompParams, InnerHeaderGroupComponent, undefined, params);
}
exports._getInnerHeaderGroupCompDetails = _getInnerHeaderGroupCompDetails;
// this one is unusual, as it can be LoadingCellRenderer, DetailCellRenderer, FullWidthCellRenderer or GroupRowRenderer.
// so we have to pass the type in.
function _getFullWidthCellRendererDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(FullWidth, undefined, params, true);
}
exports._getFullWidthCellRendererDetails = _getFullWidthCellRendererDetails;
function _getFullWidthLoadingCellRendererDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(FullWidthLoading, 'agLoadingCellRenderer', params, true);
}
exports._getFullWidthLoadingCellRendererDetails = _getFullWidthLoadingCellRendererDetails;
function _getFullWidthGroupCellRendererDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(FullWidthGroup, 'agGroupRowRenderer', params, true);
}
exports._getFullWidthGroupCellRendererDetails = _getFullWidthGroupCellRendererDetails;
function _getFullWidthDetailCellRendererDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(FullWidthDetail, 'agDetailCellRenderer', params, true);
}
exports._getFullWidthDetailCellRendererDetails = _getFullWidthDetailCellRendererDetails;
// CELL RENDERER
function _getCellRendererDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, CellRendererComponent, undefined, params);
}
exports._getCellRendererDetails = _getCellRendererDetails;
function _getEditorRendererDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, EditorRendererComponent, undefined, params);
}
exports._getEditorRendererDetails = _getEditorRendererDetails;
function _getLoadingCellRendererDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, LoadingCellRendererComponent, 'agSkeletonCellRenderer', params, true);
}
exports._getLoadingCellRendererDetails = _getLoadingCellRendererDetails;
// CELL EDITOR
function _getCellEditorDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, CellEditorComponent, 'agCellEditor', params, true);
}
exports._getCellEditorDetails = _getCellEditorDetails;
// FILTER
/**
 * @param defaultFilter provided filters only
 */
function _getFilterDetails(userCompFactory, def, params, defaultFilter) {
    const filter = def.filter;
    if ((0, iFilter_1.isColumnFilterComp)(filter)) {
        def = {
            filter: filter.component,
            filterParams: def.filterParams,
        };
    }
    return userCompFactory.getCompDetails(def, FilterComponent, defaultFilter, params, true);
}
exports._getFilterDetails = _getFilterDetails;
function _getDateCompDetails(userCompFactory, def, params) {
    return userCompFactory.getCompDetails(def, DateComponent, 'agDateInput', params, true);
}
exports._getDateCompDetails = _getDateCompDetails;
function _getLoadingOverlayCompDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(LoadingOverlayComponent, 'agLoadingOverlay', params, true);
}
exports._getLoadingOverlayCompDetails = _getLoadingOverlayCompDetails;
function _getNoRowsOverlayCompDetails(userCompFactory, params) {
    return userCompFactory.getCompDetailsFromGridOptions(NoRowsOverlayComponent, 'agNoRowsOverlay', params, true);
}
exports._getNoRowsOverlayCompDetails = _getNoRowsOverlayCompDetails;
function _getTooltipCompDetails(userCompFactory, params) {
    return userCompFactory.getCompDetails(params.colDef, TooltipComponent, 'agTooltipComponent', params, true);
}
exports._getTooltipCompDetails = _getTooltipCompDetails;
/**
 * @param defaultFloatingFilter provided floating filters only
 */
function _getFloatingFilterCompDetails(userCompFactory, def, params, defaultFloatingFilter) {
    return userCompFactory.getCompDetails(def, FloatingFilterComponent, defaultFloatingFilter, params);
}
exports._getFloatingFilterCompDetails = _getFloatingFilterCompDetails;
function _getFilterCompKeys(frameworkOverrides, def) {
    return (0, userComponentFactory_1._getUserCompKeys)(frameworkOverrides, def, FilterComponent);
}
exports._getFilterCompKeys = _getFilterCompKeys;
function _mergeFilterParamsWithApplicationProvidedParams(userCompFactory, defObject, paramsFromGrid) {
    return userCompFactory.mergeParams(defObject, FilterComponent, paramsFromGrid);
}
exports._mergeFilterParamsWithApplicationProvidedParams = _mergeFilterParamsWithApplicationProvidedParams;


/***/ }),

/***/ 31585:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserComponentFactory = exports._getUserCompKeys = void 0;
const promise_1 = __webpack_require__(35269);
const beanStub_1 = __webpack_require__(68731);
const mergeDeep_1 = __webpack_require__(66021);
const logging_1 = __webpack_require__(47764);
function doesImplementIComponent(candidate) {
    if (!candidate) {
        return false;
    }
    return candidate.prototype && 'getGui' in candidate.prototype;
}
function _getUserCompKeys(frameworkOverrides, defObject, type, params) {
    const { name } = type;
    let compName;
    let jsComp;
    let fwComp;
    let paramsFromSelector;
    let popupFromSelector;
    let popupPositionFromSelector;
    // there are two types of js comps, class based and func based. we can only check for
    // class based, by checking if getGui() exists. no way to differentiate js func based vs eg react func based
    // const isJsClassComp = (comp: any) => doesImplementIComponent(comp);
    // const fwActive = this.frameworkCompWrapper != null;
    // pull from defObject if available
    if (defObject) {
        const defObjectAny = defObject;
        // if selector, use this
        const selectorFunc = defObjectAny[name + 'Selector'];
        const selectorRes = selectorFunc ? selectorFunc(params) : null;
        const assignComp = (providedJsComp) => {
            if (typeof providedJsComp === 'string') {
                compName = providedJsComp;
            }
            else if (providedJsComp != null && providedJsComp !== true) {
                const isFwkComp = frameworkOverrides.isFrameworkComponent(providedJsComp);
                if (isFwkComp) {
                    fwComp = providedJsComp;
                }
                else {
                    jsComp = providedJsComp;
                }
            }
        };
        if (selectorRes) {
            assignComp(selectorRes.component);
            paramsFromSelector = selectorRes.params;
            popupFromSelector = selectorRes.popup;
            popupPositionFromSelector = selectorRes.popupPosition;
        }
        else {
            // if no selector, or result of selector is empty, take from defObject
            assignComp(defObjectAny[name]);
        }
    }
    return { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector };
}
exports._getUserCompKeys = _getUserCompKeys;
class UserComponentFactory extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'userCompFactory';
    }
    wireBeans(beans) {
        this.agCompUtils = beans.agCompUtils;
        this.registry = beans.registry;
        this.frameworkCompWrapper = beans.frameworkCompWrapper;
        this.gridOptions = beans.gridOptions;
    }
    getCompDetailsFromGridOptions(type, defaultName, params, mandatory = false) {
        return this.getCompDetails(this.gridOptions, type, defaultName, params, mandatory);
    }
    getCompDetails(defObject, type, defaultName, params, mandatory = false) {
        const { name, cellRenderer } = type;
        let { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector } = _getUserCompKeys(this.beans.frameworkOverrides, defObject, type, params);
        // for grid-provided comps only
        let defaultCompParams;
        let defaultCompProcessParams;
        const lookupFromRegistry = (key) => {
            const item = this.registry.getUserComponent(name, key);
            if (item) {
                jsComp = !item.componentFromFramework ? item.component : undefined;
                fwComp = item.componentFromFramework ? item.component : undefined;
                defaultCompParams = item.params;
                defaultCompProcessParams = item.processParams;
            }
        };
        // if compOption is a string, means we need to look the item up
        if (compName != null) {
            lookupFromRegistry(compName);
        }
        // if lookup brought nothing back, and we have a default, lookup the default
        if (jsComp == null && fwComp == null && defaultName != null) {
            lookupFromRegistry(defaultName);
        }
        // if we have a comp option, and it's a function, replace it with an object equivalent adaptor
        if (jsComp && cellRenderer && !doesImplementIComponent(jsComp)) {
            jsComp = this.agCompUtils?.adaptFunction(type, jsComp);
        }
        if (!jsComp && !fwComp) {
            const { validation } = this.beans;
            if (mandatory && (compName !== defaultName || !defaultName)) {
                // expecting the user to provide a component with this name
                if (compName) {
                    // If we have validation and this is a grid comp without a default (e.g. filters tool panel),
                    // we will have already warned about this
                    if (!validation?.isProvidedUserComp(compName)) {
                        (0, logging_1._error)(50, { compName });
                    }
                }
                else {
                    if (defaultName) {
                        // validation will have already warned about this
                        if (!validation) {
                            (0, logging_1._error)(260, {
                                ...this.gos.getModuleErrorParams(),
                                propName: name,
                                compName: defaultName,
                            });
                        }
                    }
                    else {
                        (0, logging_1._error)(216, { name });
                    }
                }
            }
            else if (defaultName && !validation) {
                // Grid should be providing this component.
                // Validation service will have already warned about this with the correct module name if it was present.
                (0, logging_1._error)(146, { comp: defaultName });
            }
            return;
        }
        const paramsMerged = this.mergeParams(defObject, type, params, paramsFromSelector, defaultCompParams, defaultCompProcessParams);
        const componentFromFramework = jsComp == null;
        const componentClass = jsComp ?? fwComp;
        return {
            componentFromFramework,
            componentClass,
            params: paramsMerged,
            type: type,
            popupFromSelector,
            popupPositionFromSelector,
            newAgStackInstance: () => this.newAgStackInstance(componentClass, componentFromFramework, paramsMerged, type),
        };
    }
    newAgStackInstance(ComponentClass, componentFromFramework, params, type) {
        const jsComponent = !componentFromFramework;
        // using javascript component
        let instance;
        if (jsComponent) {
            instance = new ComponentClass();
        }
        else {
            // Using framework component
            instance = this.frameworkCompWrapper.wrap(ComponentClass, type.mandatoryMethods, type.optionalMethods, type);
        }
        this.createBean(instance);
        const deferredInit = instance.init?.(params);
        if (deferredInit == null) {
            return promise_1.AgPromise.resolve(instance);
        }
        return deferredInit.then(() => instance);
    }
    /**
     * merges params with application provided params
     * used by Floating Filter
     */
    mergeParams(defObject, type, paramsFromGrid, paramsFromSelector = null, defaultCompParams, defaultCompProcessParams) {
        const params = { ...paramsFromGrid, ...defaultCompParams };
        // pull user params from the defObject
        const defObjectAny = defObject;
        const userParams = defObjectAny && defObjectAny[type.name + 'Params'];
        if (typeof userParams === 'function') {
            const userParamsFromFunc = userParams(paramsFromGrid);
            (0, mergeDeep_1._mergeDeep)(params, userParamsFromFunc);
        }
        else if (typeof userParams === 'object') {
            (0, mergeDeep_1._mergeDeep)(params, userParams);
        }
        (0, mergeDeep_1._mergeDeep)(params, paramsFromSelector);
        return defaultCompProcessParams ? defaultCompProcessParams(params) : params;
    }
}
exports.UserComponentFactory = UserComponentFactory;


/***/ }),

/***/ 68731:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BeanStub = void 0;
const agBeanStub_1 = __webpack_require__(74856);
class BeanStub extends agBeanStub_1.AgBeanStub {
}
exports.BeanStub = BeanStub;


/***/ }),

/***/ 62342:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isComponentMetaFunc = void 0;
function isComponentMetaFunc(componentMeta) {
    return typeof componentMeta === 'object' && !!componentMeta.getComp;
}
exports.isComponentMetaFunc = isComponentMetaFunc;


/***/ }),

/***/ 23943:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.gridBeanDestroyComparator = exports.gridBeanInitComparator = void 0;
/**
 * We know that there is a risk in a change of behaviour if beans are registered in a different order due to the way
 * that this means that their event listeners will be registered in a different order. If they fire in a different order
 * there is a risk that behaviour will be inconsistent.
 * As core beans are going to become optional and could be registered in unpredictable orders via feature modules,
 * we need to provide a consistent order for them to be registered in.
 *
 * We have not included beans from modules as they will be registered after the core beans in the order they are provided.
 */
const orderedCoreBeans = [
    // Validate license first
    'licenseManager',
    // core beans only
    'environment',
    'eventSvc',
    'gos',
    'paginationAutoPageSizeSvc',
    'apiFunctionSvc',
    'gridApi',
    'registry',
    'agCompUtils',
    'userCompFactory',
    'rowContainerHeight',
    'horizontalResizeSvc',
    'localeSvc',
    'pinnedRowModel',
    'dragSvc',
    'colGroupSvc',
    'visibleCols',
    'popupSvc',
    'selectionSvc',
    'colFilter',
    'quickFilter',
    'filterManager',
    'colModel',
    'headerNavigation',
    'pageBounds',
    'pagination',
    'pageBoundsListener',
    'rowSpanSvc',
    'stickyRowSvc',
    'rowRenderer',
    'expressionSvc',
    'alignedGridsSvc',
    'navigation',
    'valueCache',
    'valueSvc',
    'autoWidthCalc',
    'filterMenuFactory',
    'dragAndDrop',
    'focusSvc',
    'cellNavigation',
    'cellStyles',
    'scrollVisibleSvc',
    'sortSvc',
    'colHover',
    'colAnimation',
    'autoColSvc',
    'selectionColSvc',
    'changeDetectionSvc',
    'animationFrameSvc',
    'undoRedo',
    'colDefFactory',
    'rowStyleSvc',
    'rowNodeBlockLoader',
    'rowNodeSorter',
    'ctrlsSvc',
    'pinnedCols',
    'dataTypeSvc',
    'syncSvc',
    'overlays',
    'stateSvc',
    'expansionSvc',
    'apiEventSvc',
    'ariaAnnounce',
    'menuSvc',
    'colMoves',
    'colAutosize',
    'colFlex',
    'colResize',
    'pivotColsSvc',
    'valueColsSvc',
    'rowGroupColsSvc',
    'colNames',
    'colViewport',
    'pivotResultCols',
    'showRowGroupCols',
    'validation', // Have validations run last
];
const beanNamePosition = Object.fromEntries(orderedCoreBeans.map((beanName, index) => [beanName, index]));
function gridBeanInitComparator(bean1, bean2) {
    // if the beans are not in the ordered list, just ensure they are after the ordered beans and stable to provided order
    const index1 = (bean1.beanName ? beanNamePosition[bean1.beanName] : undefined) ?? Number.MAX_SAFE_INTEGER;
    const index2 = (bean2.beanName ? beanNamePosition[bean2.beanName] : undefined) ?? Number.MAX_SAFE_INTEGER;
    return index1 - index2;
}
exports.gridBeanInitComparator = gridBeanInitComparator;
function gridBeanDestroyComparator(bean1, bean2) {
    if (bean1?.beanName === 'gridDestroySvc') {
        return -1;
    }
    if (bean2?.beanName === 'gridDestroySvc') {
        return 1;
    }
    return 0;
}
exports.gridBeanDestroyComparator = gridBeanDestroyComparator;


/***/ }),

/***/ 1310:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CsvCreator = void 0;
const baseCreator_1 = __webpack_require__(47331);
const downloader_1 = __webpack_require__(3885);
const gridOptionsUtils_1 = __webpack_require__(67274);
const logging_1 = __webpack_require__(47764);
const csvSerializingSession_1 = __webpack_require__(32927);
class CsvCreator extends baseCreator_1.BaseCreator {
    constructor() {
        super(...arguments);
        this.beanName = 'csvCreator';
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.colNames = beans.colNames;
        this.rowGroupColsSvc = beans.rowGroupColsSvc;
        this.valueSvc = beans.valueSvc;
    }
    getMergedParams(params) {
        const baseParams = this.gos.get('defaultCsvExportParams');
        return Object.assign({}, baseParams, params);
    }
    export(userParams) {
        if (this.isExportSuppressed()) {
            // Export cancelled.
            (0, logging_1._warn)(51);
            return;
        }
        const mergedParams = this.getMergedParams(userParams);
        const data = this.getData(mergedParams);
        const packagedFile = new Blob(['\ufeff', data], { type: 'text/plain' });
        const fileName = typeof mergedParams.fileName === 'function'
            ? mergedParams.fileName((0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {}))
            : mergedParams.fileName;
        (0, downloader_1._downloadFile)(this.getFileName(fileName), packagedFile);
    }
    exportDataAsCsv(params) {
        this.export(params);
    }
    getDataAsCsv(params, skipDefaultParams = false) {
        const mergedParams = skipDefaultParams ? Object.assign({}, params) : this.getMergedParams(params);
        return this.getData(mergedParams);
    }
    getDefaultFileExtension() {
        return 'csv';
    }
    createSerializingSession(params) {
        const { colModel, colNames, rowGroupColsSvc, valueSvc, gos } = this;
        const { processCellCallback, processHeaderCallback, processGroupHeaderCallback, processRowGroupCallback, suppressQuotes, columnSeparator, } = params;
        return new csvSerializingSession_1.CsvSerializingSession({
            colModel,
            colNames,
            valueSvc,
            gos,
            processCellCallback: processCellCallback || undefined,
            processHeaderCallback: processHeaderCallback || undefined,
            processGroupHeaderCallback: processGroupHeaderCallback || undefined,
            processRowGroupCallback: processRowGroupCallback || undefined,
            suppressQuotes: suppressQuotes || false,
            columnSeparator: columnSeparator || ',',
            rowGroupColsSvc,
        });
    }
    isExportSuppressed() {
        return this.gos.get('suppressCsvExport');
    }
}
exports.CsvCreator = CsvCreator;


/***/ }),

/***/ 72984:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.exportDataAsCsv = exports.getDataAsCsv = void 0;
function getDataAsCsv(beans, params) {
    return beans.csvCreator?.getDataAsCsv(params);
}
exports.getDataAsCsv = getDataAsCsv;
function exportDataAsCsv(beans, params) {
    beans.csvCreator?.exportDataAsCsv(params);
}
exports.exportDataAsCsv = exportDataAsCsv;


/***/ }),

/***/ 59734:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CsvExportModule = void 0;
const exportModule_1 = __webpack_require__(92728);
const version_1 = __webpack_require__(97205);
const csvCreator_1 = __webpack_require__(1310);
const csvExportApi_1 = __webpack_require__(72984);
/**
 * @feature Import & Export -> CSV Export
 */
exports.CsvExportModule = {
    moduleName: 'CsvExport',
    version: version_1.VERSION,
    beans: [csvCreator_1.CsvCreator],
    apiFunctions: {
        getDataAsCsv: csvExportApi_1.getDataAsCsv,
        exportDataAsCsv: csvExportApi_1.exportDataAsCsv,
    },
    dependsOn: [exportModule_1.SharedExportModule],
};


/***/ }),

/***/ 32927:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CsvSerializingSession = void 0;
const baseGridSerializingSession_1 = __webpack_require__(68376);
const logging_1 = __webpack_require__(47764);
const LINE_SEPARATOR = '\r\n';
class CsvSerializingSession extends baseGridSerializingSession_1.BaseGridSerializingSession {
    constructor(config) {
        super(config);
        this.config = config;
        this.isFirstLine = true;
        this.result = '';
        const { suppressQuotes, columnSeparator } = config;
        this.suppressQuotes = suppressQuotes;
        this.columnSeparator = columnSeparator;
    }
    addCustomContent(content) {
        if (!content) {
            return;
        }
        if (typeof content === 'string') {
            if (!/^\s*\n/.test(content)) {
                this.beginNewLine();
            }
            // replace whatever newlines are supplied with the style we're using
            content = content.replace(/\r?\n/g, LINE_SEPARATOR);
            this.result += content;
        }
        else {
            content.forEach((row) => {
                this.beginNewLine();
                row.forEach((cell, index) => {
                    if (index !== 0) {
                        this.result += this.columnSeparator;
                    }
                    this.result += this.putInQuotes(cell.data.value || '');
                    if (cell.mergeAcross) {
                        this.appendEmptyCells(cell.mergeAcross);
                    }
                });
            });
        }
    }
    onNewHeaderGroupingRow() {
        this.beginNewLine();
        return {
            onColumn: this.onNewHeaderGroupingRowColumn.bind(this),
        };
    }
    onNewHeaderGroupingRowColumn(columnGroup, header, index, span) {
        if (index != 0) {
            this.result += this.columnSeparator;
        }
        this.result += this.putInQuotes(header);
        this.appendEmptyCells(span);
    }
    appendEmptyCells(count) {
        for (let i = 1; i <= count; i++) {
            this.result += this.columnSeparator + this.putInQuotes('');
        }
    }
    onNewHeaderRow() {
        this.beginNewLine();
        return {
            onColumn: this.onNewHeaderRowColumn.bind(this),
        };
    }
    onNewHeaderRowColumn(column, index) {
        if (index != 0) {
            this.result += this.columnSeparator;
        }
        this.result += this.putInQuotes(this.extractHeaderValue(column));
    }
    onNewBodyRow() {
        this.beginNewLine();
        return {
            onColumn: this.onNewBodyRowColumn.bind(this),
        };
    }
    onNewBodyRowColumn(column, index, node) {
        if (index != 0) {
            this.result += this.columnSeparator;
        }
        const rowCellValue = this.extractRowCellValue(column, index, index, 'csv', node);
        this.result += this.putInQuotes(rowCellValue.valueFormatted ?? rowCellValue.value);
    }
    putInQuotes(value) {
        if (this.suppressQuotes) {
            return value;
        }
        if (value === null || value === undefined) {
            return '""';
        }
        let stringValue;
        if (typeof value === 'string') {
            stringValue = value;
        }
        else if (typeof value.toString === 'function') {
            stringValue = value.toString();
        }
        else {
            (0, logging_1._warn)(53);
            stringValue = '';
        }
        // replace each " with "" (ie two sets of double quotes is how to do double quotes in csv)
        const valueEscaped = stringValue.replace(/"/g, '""');
        return '"' + valueEscaped + '"';
    }
    parse() {
        return this.result;
    }
    beginNewLine() {
        if (!this.isFirstLine) {
            this.result += LINE_SEPARATOR;
        }
        this.isFirstLine = false;
    }
}
exports.CsvSerializingSession = CsvSerializingSession;


/***/ }),

/***/ 80020:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CtrlsService = void 0;
const beanStub_1 = __webpack_require__(68731);
/**
 * This is the number of controls defined above in `ReadyParams`.
 * This allows us to quickly know when all controls have been registered.
 */
const NUM_CTRLS = 23;
// for all controllers that are singletons, they can register here so other parts
// of the application can access them.
class CtrlsService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'ctrlsSvc';
        this.params = {};
        this.ready = false;
        this.readyCallbacks = [];
    }
    postConstruct() {
        // With React 19 StrictMode, ctrlService can be ready twice.
        // The first time after the first render cycle, and the second time after the second render cycle which is only done in StrictMode.
        // By making the local events async, we effectively debounce the first ready event until after the second render cycle has completed.
        // This means that the ready logic across the grid will run against the currently rendered components and controllers.
        // We make this async only for React 19 as StrictMode in React 19 double fires ref callbacks whereas previous versions of React do not.
        this.addEventListener('ready', () => {
            this.updateReady();
            if (this.ready) {
                this.readyCallbacks.forEach((c) => c(this.params));
                this.readyCallbacks.length = 0;
            }
        }, this.beans.frameworkOverrides.runWhenReadyAsync?.() ?? false);
    }
    updateReady() {
        const values = Object.values(this.params);
        // ready when all ctrls have been registered and are alive
        this.ready =
            values.length === NUM_CTRLS &&
                values.every((ctrl) => {
                    return ctrl?.isAlive() ?? false;
                });
    }
    whenReady(caller, callback) {
        if (this.ready) {
            callback(this.params);
        }
        else {
            this.readyCallbacks.push(callback);
        }
        caller.addDestroyFunc(() => {
            // remove the callback if the caller is destroyed so that we don't call it against a destroyed component
            const index = this.readyCallbacks.indexOf(callback);
            if (index >= 0) {
                this.readyCallbacks.splice(index, 1);
            }
        });
    }
    register(ctrlType, ctrl) {
        this.params[ctrlType] = ctrl;
        this.updateReady();
        if (this.ready) {
            this.dispatchLocalEvent({ type: 'ready' });
        }
        ctrl.addDestroyFunc(() => {
            // Ensure ready is false when a controller is destroyed
            // We do not clear them as a lot of code still runs during destroy logic which may need access to the controllers
            // NOTE: This is not ideal and we should look to stop logic using controllers during destroy
            this.updateReady();
        });
    }
    get(ctrlType) {
        return this.params[ctrlType];
    }
    getGridBodyCtrl() {
        return this.params.gridBodyCtrl;
    }
    getHeaderRowContainerCtrls() {
        const { leftHeader, centerHeader, rightHeader } = this.params;
        return [leftHeader, rightHeader, centerHeader];
    }
    getHeaderRowContainerCtrl(pinned) {
        const params = this.params;
        switch (pinned) {
            case 'left':
                return params.leftHeader;
            case 'right':
                return params.rightHeader;
            default:
                return params.centerHeader;
        }
    }
    getScrollFeature() {
        return this.getGridBodyCtrl().scrollFeature;
    }
}
exports.CtrlsService = CtrlsService;


/***/ }),

/***/ 82671:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.dragAndDropImageComponentCSS = void 0;
exports.dragAndDropImageComponentCSS = `.ag-dnd-ghost{align-items:center;background-color:var(--ag-drag-and-drop-image-background-color);border:var(--ag-drag-and-drop-image-border);border-radius:var(--ag-border-radius);box-shadow:var(--ag-drag-and-drop-image-shadow);color:var(--ag-text-color);cursor:move;display:flex;font-weight:500;gap:var(--ag-cell-widget-spacing);height:var(--ag-header-height);overflow:hidden;padding-left:var(--ag-cell-horizontal-padding);padding-right:var(--ag-cell-horizontal-padding);text-overflow:ellipsis;transform:translateY(calc(var(--ag-spacing)*2));white-space:nowrap}.ag-dnd-ghost-not-allowed{border:var(--ag-drag-and-drop-image-not-allowed-border)}`;


/***/ }),

/***/ 33814:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragAndDropImageComponent = void 0;
const agComponent_1 = __webpack_require__(91668);
const dom_1 = __webpack_require__(1956);
const icon_1 = __webpack_require__(59970);
const component_1 = __webpack_require__(78020);
const dragAndDropImageComponent_css_GENERATED_1 = __webpack_require__(82671);
// the wrapper div has no class - the drag and drop service adds the theme class to it
const DragAndDropElement = {
    tag: 'div',
    children: [
        {
            tag: 'div',
            ref: 'eGhost',
            cls: 'ag-dnd-ghost ag-unselectable',
            children: [
                { tag: 'span', ref: 'eIcon', cls: 'ag-dnd-ghost-icon ag-shake-left-to-right' },
                { tag: 'div', ref: 'eLabel', cls: 'ag-dnd-ghost-label' },
            ],
        },
    ],
};
class DragAndDropImageComponent extends component_1.Component {
    constructor() {
        super();
        this.dragSource = null;
        this.eIcon = agComponent_1.RefPlaceholder;
        this.eLabel = agComponent_1.RefPlaceholder;
        this.eGhost = agComponent_1.RefPlaceholder;
        this.registerCSS(dragAndDropImageComponent_css_GENERATED_1.dragAndDropImageComponentCSS);
    }
    postConstruct() {
        const create = (iconName) => (0, icon_1._createIcon)(iconName, this.beans, null);
        this.dropIconMap = {
            pinned: create('columnMovePin'),
            hide: create('columnMoveHide'),
            move: create('columnMoveMove'),
            left: create('columnMoveLeft'),
            right: create('columnMoveRight'),
            group: create('columnMoveGroup'),
            aggregate: create('columnMoveValue'),
            pivot: create('columnMovePivot'),
            notAllowed: create('dropNotAllowed'),
        };
    }
    init(params) {
        this.dragSource = params.dragSource;
        this.setTemplate(DragAndDropElement);
        // also apply theme class to the ghost element for backwards compatibility
        // with themes that use .ag-theme-classname.ag-dnd-ghost, which used to be
        // required before the theme class was also set on the wrapper.
        this.beans.environment.applyThemeClasses(this.eGhost);
    }
    destroy() {
        this.dragSource = null;
        super.destroy();
    }
    setIcon(iconName, shake) {
        const { eGhost, eIcon, dragSource, dropIconMap, gos } = this;
        (0, dom_1._clearElement)(eIcon);
        let eIconChild = null;
        if (!iconName) {
            iconName = dragSource?.getDefaultIconName ? dragSource.getDefaultIconName() : 'notAllowed';
        }
        eIconChild = dropIconMap[iconName];
        eGhost.classList.toggle('ag-dnd-ghost-not-allowed', iconName === 'notAllowed');
        eIcon.classList.toggle('ag-shake-left-to-right', shake);
        if (eIconChild === dropIconMap['hide'] && gos.get('suppressDragLeaveHidesColumns')) {
            return;
        }
        if (eIconChild) {
            eIcon.appendChild(eIconChild);
        }
    }
    setLabel(label) {
        this.eLabel.textContent = label;
    }
}
exports.DragAndDropImageComponent = DragAndDropImageComponent;


/***/ }),

/***/ 12903:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragAndDropService = exports.DragSourceType = void 0;
const baseDragAndDropService_1 = __webpack_require__(54646);
const userCompUtils_1 = __webpack_require__(12036);
const gridOptionsUtils_1 = __webpack_require__(67274);
const logging_1 = __webpack_require__(47764);
var DragSourceType;
(function (DragSourceType) {
    DragSourceType[DragSourceType["ToolPanel"] = 0] = "ToolPanel";
    DragSourceType[DragSourceType["HeaderCell"] = 1] = "HeaderCell";
    DragSourceType[DragSourceType["RowDrag"] = 2] = "RowDrag";
    DragSourceType[DragSourceType["ChartPanel"] = 3] = "ChartPanel";
    DragSourceType[DragSourceType["AdvancedFilterBuilder"] = 4] = "AdvancedFilterBuilder";
})(DragSourceType || (exports.DragSourceType = DragSourceType = {}));
class DragAndDropService extends baseDragAndDropService_1.BaseDragAndDropService {
    createEvent(event) {
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, event);
    }
    createDragImageComp(dragSource) {
        const { gos, beans } = this;
        const userCompDetails = (0, userCompUtils_1._getDragAndDropImageCompDetails)(beans.userCompFactory, (0, gridOptionsUtils_1._addGridCommonParams)(gos, {
            dragSource,
        }));
        return userCompDetails?.newAgStackInstance();
    }
    handleEnter(dragSource, dragItem) {
        dragSource?.onGridEnter?.(dragItem);
    }
    handleExit(dragSource, dragItem) {
        dragSource?.onGridExit?.(dragItem);
    }
    warnNoBody() {
        (0, logging_1._warn)(54);
    }
    isDropZoneWithinThisGrid(draggingEvent) {
        return this.beans.ctrlsSvc.getGridBodyCtrl().eGridBody.contains(draggingEvent.dropZoneTarget);
    }
    registerGridDropTarget(elementFn, ctrl) {
        // this drop target is just used to see if the drop event is inside the grid
        const dropTarget = {
            getContainer: elementFn,
            isInterestedIn: (type) => type === DragSourceType.HeaderCell || type === DragSourceType.ToolPanel,
            getIconName: () => 'notAllowed',
        };
        this.addDropTarget(dropTarget);
        ctrl.addDestroyFunc(() => this.removeDropTarget(dropTarget));
    }
}
exports.DragAndDropService = DragAndDropService;


/***/ }),

/***/ 72830:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.setRowDropPositionIndicator = exports.getRowDropPositionIndicator = exports.getRowDropZoneParams = exports.removeRowDropZone = exports.addRowDropZone = void 0;
function addRowDropZone(beans, params) {
    beans.rowDragSvc?.rowDragFeature?.addRowDropZone(params);
}
exports.addRowDropZone = addRowDropZone;
function removeRowDropZone(beans, params) {
    const activeDropTarget = beans.dragAndDrop?.findExternalZone(params.getContainer());
    if (activeDropTarget) {
        beans.dragAndDrop?.removeDropTarget(activeDropTarget);
    }
}
exports.removeRowDropZone = removeRowDropZone;
function getRowDropZoneParams(beans, events) {
    return beans.rowDragSvc?.rowDragFeature?.getRowDropZone(events);
}
exports.getRowDropZoneParams = getRowDropZoneParams;
function getRowDropPositionIndicator(beans) {
    const rowDropHighlightSvc = beans.rowDropHighlightSvc;
    return rowDropHighlightSvc
        ? { row: rowDropHighlightSvc.row, dropIndicatorPosition: rowDropHighlightSvc.position }
        : { row: null, dropIndicatorPosition: 'none' };
}
exports.getRowDropPositionIndicator = getRowDropPositionIndicator;
function setRowDropPositionIndicator(beans, params) {
    const rowDropHighlightSvc = beans.rowDropHighlightSvc;
    if (!rowDropHighlightSvc) {
        return;
    }
    const rowNode = params?.row;
    let position = params?.dropIndicatorPosition;
    if (position !== 'above' && position !== 'below' && position !== 'inside') {
        position = 'none';
    }
    const rowIndex = rowNode?.rowIndex;
    if (rowIndex === null || rowIndex === undefined || position === 'none') {
        rowDropHighlightSvc.clear();
    }
    else {
        rowDropHighlightSvc.set(rowNode, position);
    }
}
exports.setRowDropPositionIndicator = setRowDropPositionIndicator;


/***/ }),

/***/ 24388:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HorizontalResizeModule = exports.RowDragModule = exports.SharedDragAndDropModule = exports.DragAndDropModule = exports.DragModule = void 0;
const dndSourceComp_1 = __webpack_require__(60714);
const version_1 = __webpack_require__(97205);
const dragAndDropImageComponent_1 = __webpack_require__(33814);
const dragAndDropService_1 = __webpack_require__(12903);
const dragApi_1 = __webpack_require__(72830);
const dragApi_2 = __webpack_require__(72830);
const dragService_1 = __webpack_require__(52165);
const horizontalResizeService_1 = __webpack_require__(26843);
const rowDragService_1 = __webpack_require__(92895);
const rowDropHighlightService_1 = __webpack_require__(37406);
/**
 * @internal
 */
exports.DragModule = {
    moduleName: 'Drag',
    version: version_1.VERSION,
    beans: [dragService_1.DragService],
};
/**
 * @feature Import & Export -> Drag & Drop
 * @colDef dndSource, dndSourceOnRowDrag
 */
exports.DragAndDropModule = {
    moduleName: 'DragAndDrop',
    version: version_1.VERSION,
    dynamicBeans: {
        dndSourceComp: dndSourceComp_1.DndSourceComp,
    },
    icons: {
        // drag handle used to pick up draggable rows
        rowDrag: 'grip',
    },
};
/**
 * @internal
 */
exports.SharedDragAndDropModule = {
    moduleName: 'SharedDragAndDrop',
    version: version_1.VERSION,
    beans: [dragAndDropService_1.DragAndDropService],
    dependsOn: [exports.DragModule],
    userComponents: {
        agDragAndDropImage: dragAndDropImageComponent_1.DragAndDropImageComponent,
    },
    icons: {
        // shown on drag and drop image component icon while dragging column to the side of the grid to pin
        columnMovePin: 'pin',
        // shown on drag and drop image component icon while dragging over part of the page that is not a drop zone
        columnMoveHide: 'eye-slash',
        // shown on drag and drop image component icon while dragging columns to reorder
        columnMoveMove: 'arrows',
        // animating icon shown when dragging a column to the right of the grid causes horizontal scrolling
        columnMoveLeft: 'left',
        // animating icon shown when dragging a column to the left of the grid causes horizontal scrolling
        columnMoveRight: 'right',
        // shown on drag and drop image component icon while dragging over Row Groups drop zone
        columnMoveGroup: 'group',
        // shown on drag and drop image component icon while dragging over Values drop zone
        columnMoveValue: 'aggregation',
        // shown on drag and drop image component icon while dragging over pivot drop zone
        columnMovePivot: 'pivot',
        // shown on drag and drop image component icon while dragging over drop zone that doesn't support it, e.g.
        // string column over aggregation drop zone
        dropNotAllowed: 'not-allowed',
        // drag handle used to pick up draggable rows
        rowDrag: 'grip',
    },
};
/**
 * @feature Rows -> Row Dragging
 * @colDef rowDrag
 */
exports.RowDragModule = {
    moduleName: 'RowDrag',
    version: version_1.VERSION,
    beans: [rowDropHighlightService_1.RowDropHighlightService, rowDragService_1.RowDragService],
    apiFunctions: {
        addRowDropZone: dragApi_1.addRowDropZone,
        removeRowDropZone: dragApi_1.removeRowDropZone,
        getRowDropZoneParams: dragApi_1.getRowDropZoneParams,
        getRowDropPositionIndicator: dragApi_2.getRowDropPositionIndicator,
        setRowDropPositionIndicator: dragApi_2.setRowDropPositionIndicator,
    },
    dependsOn: [exports.SharedDragAndDropModule],
};
/**
 * @internal
 */
exports.HorizontalResizeModule = {
    moduleName: 'HorizontalResize',
    version: version_1.VERSION,
    beans: [horizontalResizeService_1.HorizontalResizeService],
    dependsOn: [exports.DragModule],
};


/***/ }),

/***/ 52165:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragService = void 0;
const baseDragService_1 = __webpack_require__(21726);
/** Adds drag listening onto an element. In AG Grid this is used twice, first is resizing columns,
 * second is moving the columns and column groups around (ie the 'drag' part of Drag and Drop. */
class DragService extends baseDragService_1.BaseDragService {
    shouldPreventMouseEvent(mouseEvent) {
        const isEnableCellTextSelect = this.gos.get('enableCellTextSelection');
        // when `isEnableCellTextSelect` is `true`, we need to preventDefault on mouseMove
        // to avoid the grid text being selected while dragging components.
        return isEnableCellTextSelect && super.shouldPreventMouseEvent(mouseEvent);
    }
}
exports.DragService = DragService;


/***/ }),

/***/ 26843:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HorizontalResizeService = void 0;
const direction_1 = __webpack_require__(72213);
const beanStub_1 = __webpack_require__(68731);
class HorizontalResizeService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'horizontalResizeSvc';
    }
    addResizeBar(params) {
        const dragSource = {
            dragStartPixels: params.dragStartPixels || 0,
            eElement: params.eResizeBar,
            onDragStart: this.onDragStart.bind(this, params),
            onDragStop: this.onDragStop.bind(this, params),
            onDragging: this.onDragging.bind(this, params),
            onDragCancel: this.onDragStop.bind(this, params),
            includeTouch: true,
            stopPropagationForTouch: true,
        };
        const { dragSvc } = this.beans;
        dragSvc.addDragSource(dragSource);
        // we pass remove func back to the caller, so call can tell us when they
        // are finished, and then we remove the listener from the drag source
        const finishedWithResizeFunc = () => dragSvc.removeDragSource(dragSource);
        return finishedWithResizeFunc;
    }
    onDragStart(params, mouseEvent) {
        this.dragStartX = mouseEvent.clientX;
        this.setResizeIcons();
        const shiftKey = mouseEvent instanceof MouseEvent && mouseEvent.shiftKey === true;
        params.onResizeStart(shiftKey);
    }
    setResizeIcons() {
        const ctrl = this.beans.ctrlsSvc.get('gridCtrl');
        // change the body cursor, so when drag moves out of the drag bar, the cursor is still 'resize' (or 'move'
        ctrl.setResizeCursor(direction_1.Direction.Horizontal);
        // we don't want text selection outside the grid (otherwise it looks weird as text highlights when we move)
        ctrl.disableUserSelect(true);
    }
    onDragStop(params) {
        params.onResizeEnd(this.resizeAmount);
        this.resetIcons();
    }
    resetIcons() {
        const ctrl = this.beans.ctrlsSvc.get('gridCtrl');
        ctrl.setResizeCursor(false);
        ctrl.disableUserSelect(false);
    }
    onDragging(params, mouseEvent) {
        this.resizeAmount = mouseEvent.clientX - this.dragStartX;
        params.onResizing(this.resizeAmount);
    }
}
exports.HorizontalResizeService = HorizontalResizeService;


/***/ }),

/***/ 21633:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowDragComp = void 0;
const icon_1 = __webpack_require__(59970);
const component_1 = __webpack_require__(78020);
const dragAndDropService_1 = __webpack_require__(12903);
const RowDragElement = {
    tag: 'div',
    cls: 'ag-drag-handle ag-row-drag',
    attrs: { 'aria-hidden': 'true' },
};
class RowDragComp extends component_1.Component {
    constructor(cellValueFn, rowNode, column, customGui, dragStartPixels, alwaysVisible = false) {
        super();
        this.cellValueFn = cellValueFn;
        this.rowNode = rowNode;
        this.column = column;
        this.customGui = customGui;
        this.dragStartPixels = dragStartPixels;
        this.alwaysVisible = alwaysVisible;
        this.dragSource = null;
    }
    isCustomGui() {
        return this.customGui != null;
    }
    postConstruct() {
        const { beans, customGui } = this;
        if (customGui) {
            this.setDragElement(customGui, this.dragStartPixels);
        }
        else {
            this.setTemplate(RowDragElement);
            this.getGui().appendChild((0, icon_1._createIconNoSpan)('rowDrag', beans, null));
            this.addDragSource();
        }
        if (!this.alwaysVisible) {
            this.initCellDrag();
        }
    }
    initCellDrag() {
        const { beans, gos, rowNode } = this;
        const refreshVisibility = this.refreshVisibility.bind(this);
        this.addManagedPropertyListener('suppressRowDrag', refreshVisibility);
        // in case data changes, then we need to update visibility of drag item
        this.addManagedListeners(rowNode, {
            dataChanged: refreshVisibility,
            cellChanged: refreshVisibility,
        });
        this.addManagedListeners(beans.eventSvc, 
        // For managed row drag, we do not show the component if sort, filter or grouping is active
        gos.get('rowDragManaged')
            ? {
                sortChanged: refreshVisibility,
                filterChanged: refreshVisibility,
                columnRowGroupChanged: refreshVisibility,
                newColumnsLoaded: refreshVisibility,
            }
            : { newColumnsLoaded: refreshVisibility });
    }
    setDragElement(dragElement, dragStartPixels) {
        // We set suppressDataRefValidation as the drag element could contain AG Grid comps with data references
        // that are not part of this row dragger's context. Maybe this should just setGui and not setTemplateFromElement?
        this.setTemplateFromElement(dragElement, undefined, undefined, true);
        this.addDragSource(dragStartPixels);
    }
    refreshVisibility() {
        if (this.alwaysVisible) {
            return; // Always visible row draggers do not refresh visibility
        }
        const displayedOptions = { skipAriaHidden: true };
        if (this.isNeverDisplayed()) {
            this.setDisplayed(false, displayedOptions);
            return;
        }
        const column = this.column;
        // if shown sometimes, them some rows can have drag handle while other don't,
        // so we use setVisible to keep the handles horizontally aligned (as _setVisible
        // keeps the empty space, whereas setDisplayed looses the space)
        let shownSometimes = typeof column?.getColDef().rowDrag === 'function';
        let visible = !column || this.isCustomGui() || column.isRowDrag(this.rowNode);
        if (visible && this.rowNode.footer && this.gos.get('rowDragManaged')) {
            visible = false; // We hide footer rows in row drag managed mode
            shownSometimes = true;
        }
        this.setDisplayed(shownSometimes || visible, displayedOptions);
        this.setVisible(visible, displayedOptions);
    }
    isNeverDisplayed() {
        const { gos, beans } = this;
        if (gos.get('suppressRowDrag')) {
            return true; // Row dragging is suppressed
        }
        if (gos.get('rowDragManaged') &&
            !!beans.rowDragSvc.rowDragFeature?.shouldPreventRowMove() &&
            !beans.dragAndDrop?.hasExternalDropZones()) {
            return true; // Managed: only show if not prevented and not suppressed, or if there are external drop zones
        }
        return false;
    }
    getSelectedNodes() {
        const rowNode = this.rowNode;
        const isRowDragMultiRow = this.gos.get('rowDragMultiRow');
        if (!isRowDragMultiRow) {
            return [rowNode];
        }
        const selection = this.beans.selectionSvc?.getSelectedNodes() ?? [];
        return selection.indexOf(rowNode) !== -1 ? selection : [rowNode];
    }
    getDragItem() {
        const { column, rowNode } = this;
        return {
            rowNode,
            rowNodes: this.getSelectedNodes(),
            columns: column ? [column] : undefined,
            defaultTextValue: this.cellValueFn(),
        };
    }
    getRowDragText(column) {
        if (column) {
            const colDef = column.getColDef();
            if (colDef.rowDragText) {
                return colDef.rowDragText;
            }
        }
        return this.gos.get('rowDragText');
    }
    addDragSource(dragStartPixels = 4) {
        // if this is changing the drag element, delete the previous dragSource
        if (this.dragSource) {
            this.removeDragSource();
        }
        if (this.gos.get('rowDragManaged') && this.rowNode.footer) {
            return; // Footer nodes in row drag managed mode are not draggable
        }
        const eGui = this.getGui();
        if (this.gos.get('enableCellTextSelection')) {
            this.removeMouseDownListener();
            this.mouseDownListener = this.addManagedElementListeners(eGui, {
                mousedown: (e) => {
                    e?.preventDefault();
                },
            })[0];
        }
        const translate = this.getLocaleTextFunc();
        this.dragSource = {
            type: dragAndDropService_1.DragSourceType.RowDrag,
            eElement: eGui,
            dragItemName: (draggingEvent) => {
                const dragItem = draggingEvent?.dragItem || this.getDragItem();
                const dragItemCount = (draggingEvent?.dropTarget?.rows.length ?? dragItem.rowNodes?.length) || 1;
                const rowDragText = this.getRowDragText(this.column);
                if (rowDragText) {
                    return rowDragText(dragItem, dragItemCount);
                }
                return dragItemCount === 1
                    ? this.cellValueFn()
                    : `${dragItemCount} ${translate('rowDragRows', 'rows')}`;
            },
            getDragItem: () => this.getDragItem(),
            dragStartPixels,
            dragSourceDomDataKey: this.gos.getDomDataKey(),
        };
        this.beans.dragAndDrop.addDragSource(this.dragSource, true);
    }
    destroy() {
        this.removeDragSource();
        this.removeMouseDownListener();
        super.destroy();
    }
    removeDragSource() {
        if (!this.dragSource) {
            return;
        }
        this.beans.dragAndDrop.removeDragSource(this.dragSource);
        this.dragSource = null;
    }
    removeMouseDownListener() {
        if (!this.mouseDownListener) {
            return;
        }
        this.mouseDownListener();
        this.mouseDownListener = undefined;
    }
}
exports.RowDragComp = RowDragComp;


/***/ }),

/***/ 12254:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowDragFeature = void 0;
const array_1 = __webpack_require__(79909);
const rowModelApiUtils_1 = __webpack_require__(66876);
const beanStub_1 = __webpack_require__(68731);
const positionUtils_1 = __webpack_require__(6257);
const mouseEventUtils_1 = __webpack_require__(8399);
const gridOptionsUtils_1 = __webpack_require__(67274);
const changedPath_1 = __webpack_require__(76800);
const logging_1 = __webpack_require__(47764);
const dragAndDropService_1 = __webpack_require__(12903);
const rowDragFeatureNudger_1 = __webpack_require__(84397);
class RowDragFeature extends beanStub_1.BeanStub {
    constructor(eContainer) {
        super();
        this.eContainer = eContainer;
        this.lastDraggingEvent = null;
        this.nudger = null;
    }
    postConstruct() {
        const beans = this.beans;
        this.clientSideRowModel = (0, rowModelApiUtils_1._getClientSideRowModel)(beans);
        beans.ctrlsSvc.whenReady(this, (p) => {
            this.nudger = new rowDragFeatureNudger_1.RowDragFeatureNudger(beans, p.gridBodyCtrl);
        });
    }
    destroy() {
        super.destroy();
        this.nudger?.clear();
        this.nudger = null;
        this.lastDraggingEvent = null;
        this.eContainer = null;
    }
    getContainer() {
        return this.eContainer;
    }
    isInterestedIn(type) {
        return type === dragAndDropService_1.DragSourceType.RowDrag;
    }
    getIconName(draggingEvent) {
        if (draggingEvent?.dropTarget?.allowed === false) {
            return 'notAllowed';
        }
        if (this.gos.get('rowDragManaged') && this.shouldPreventRowMove()) {
            return 'notAllowed';
        }
        return 'move';
    }
    shouldPreventRowMove() {
        const { rowGroupColsSvc, filterManager, sortSvc } = this.beans;
        const rowGroupCols = rowGroupColsSvc?.columns ?? [];
        if (rowGroupCols.length) {
            return true;
        }
        const isFilterPresent = filterManager?.isAnyFilterPresent();
        if (isFilterPresent) {
            return true;
        }
        const isSortActive = sortSvc?.isSortActive();
        if (isSortActive) {
            return true;
        }
        return false;
    }
    getRowNodes(draggingEvent) {
        if (!this.isFromThisGrid(draggingEvent)) {
            return (draggingEvent.dragItem.rowNodes || []);
        }
        const currentNode = draggingEvent.dragItem.rowNode;
        if (this.gos.get('rowDragMultiRow')) {
            const selectedNodes = this.beans.selectionSvc?.getSelectedNodes();
            if (selectedNodes && selectedNodes.indexOf(currentNode) >= 0) {
                return selectedNodes.slice().sort(compareRowIndex);
            }
        }
        return [currentNode];
    }
    onDragEnter(draggingEvent) {
        this.dragging(draggingEvent, true);
    }
    onDragging(draggingEvent) {
        this.dragging(draggingEvent, false);
    }
    dragging(draggingEvent, enter) {
        const { lastDraggingEvent, beans } = this;
        if (enter) {
            const rowNodes = this.getRowNodes(draggingEvent);
            draggingEvent.dragItem.rowNodes = rowNodes;
            setRowNodesDragging(rowNodes, true);
        }
        this.lastDraggingEvent = draggingEvent;
        const fromNudge = draggingEvent.fromNudge;
        const rowsDrop = this.makeRowsDrop(lastDraggingEvent, draggingEvent, fromNudge, false);
        beans.rowDropHighlightSvc?.fromDrag(draggingEvent);
        if (enter) {
            this.dispatchGridEvent('rowDragEnter', draggingEvent); // we fire both the enter and move.
        }
        this.dispatchGridEvent('rowDragMove', draggingEvent);
        if (!fromNudge &&
            rowsDrop?.rowDragManaged &&
            rowsDrop.moved &&
            rowsDrop.allowed &&
            rowsDrop.sameGrid &&
            !rowsDrop.suppressMoveWhenRowDragging) {
            this.dropRows(rowsDrop); // Drop the rows while dragging
        }
        this.nudger?.autoScroll.check(draggingEvent.event);
    }
    isFromThisGrid(draggingEvent) {
        return draggingEvent.dragSource.dragSourceDomDataKey === this.gos.getDomDataKey();
    }
    makeRowsDrop(lastDraggingEvent, draggingEvent, moving, dropping) {
        const { beans, gos, clientSideRowModel } = this;
        const rowsDrop = this.newRowsDrop(draggingEvent, dropping);
        draggingEvent.dropTarget = rowsDrop;
        draggingEvent.changed = false;
        if (!rowsDrop) {
            return null;
        }
        let { sameGrid, rootNode, source, target, rows } = rowsDrop;
        target ?? (target = clientSideRowModel.getRow(clientSideRowModel.getRowCount() - 1) ?? null);
        const groupingApproach = (0, gridOptionsUtils_1._getGroupingApproach)(gos);
        const canSetParent = 
        // We don't yet support drag and drop with grouping
        groupingApproach !== 'group' &&
            // We don't yet support moving tree rows from a different grid in a structured way
            sameGrid;
        let newParent = null;
        if (target?.footer) {
            // Footer row. Get the real parent, that is the sibling of the footer
            const found = getPrevOrNext(clientSideRowModel, -1, target) ?? getPrevOrNext(clientSideRowModel, 1, target);
            newParent = target.sibling ?? rootNode;
            target = found ?? null;
        }
        if (target?.detail) {
            // Detail row, we chose the master row instead.
            target = target.parent;
        }
        rowsDrop.moved && (rowsDrop.moved = source !== target);
        let yDelta = 0.5;
        if (target) {
            if (sameGrid && rowsDrop.moved && (newParent || !canSetParent)) {
                yDelta = source.rowIndex > target.rowIndex ? -0.5 : 0.5; // Flat same grid row dragging - use row index
            }
            else {
                yDelta = (rowsDrop.y - target.rowTop - target.rowHeight / 2) / target.rowHeight || 0; // Use relative mouse position
            }
        }
        if (!canSetParent && sameGrid && target && rowsDrop.moved) {
            const newTarget = deltaDraggingTarget(clientSideRowModel, rowsDrop);
            if (newTarget) {
                yDelta = source.rowIndex > newTarget.rowIndex ? -0.5 : 0.5;
                target = newTarget;
                rowsDrop.moved && (rowsDrop.moved = source !== target);
            }
        }
        const nudger = this.nudger;
        nudger?.updateGroup(target, moving);
        if (canSetParent && !newParent && nudger) {
            if (!target || (yDelta >= 0.5 && target.rowIndex === beans.pageBounds.getLastRow())) {
                newParent = rootNode; // Dragging outside of the rows, move to last row at the root level
            }
            else if (rowsDrop.moved && this.targetShouldBeParent(target, yDelta, rows)) {
                if (nudger.groupThrottled) {
                    newParent = target;
                }
                if (!moving && (!newParent || (target && !target.expanded && !!target.childrenAfterSort?.length))) {
                    nudger.startGroup(target);
                }
            }
            newParent ?? (newParent = target?.parent ?? rootNode);
        }
        let inside = false;
        if (newParent) {
            if (newParent === target && newParent !== rootNode) {
                const firstRow = newParent.expanded ? getPrevOrNext(clientSideRowModel, 1, target) : null;
                if (firstRow?.parent === newParent) {
                    target = firstRow; // Instead of showing "inside" style, we can show "above" by using first child as target
                    yDelta = -0.5;
                }
                else {
                    inside = true; // Dragging as child
                }
            }
            if (target && !inside) {
                // Set target to the first group that is not the root node or the new parent
                let current = target;
                while (current && current !== rootNode && current !== newParent) {
                    target = current;
                    current = current.parent;
                }
            }
        }
        rowsDrop.target = target;
        rowsDrop.newParent = newParent;
        rowsDrop.moved && (rowsDrop.moved = source !== target);
        const aboveOrBelow = yDelta < 0 ? 'above' : 'below';
        rowsDrop.position = rowsDrop.moved ? (inside ? 'inside' : aboveOrBelow) : 'none';
        this.validateRowsDrop(rowsDrop, canSetParent, aboveOrBelow, dropping);
        draggingEvent.changed || (draggingEvent.changed = rowsDropChanged(lastDraggingEvent?.dropTarget, rowsDrop));
        return rowsDrop;
    }
    newRowsDrop(draggingEvent, dropping) {
        const { beans, gos, clientSideRowModel } = this;
        const rootNode = clientSideRowModel.rootNode;
        const rowDragManaged = gos.get('rowDragManaged');
        const suppressMoveWhenRowDragging = gos.get('suppressMoveWhenRowDragging');
        const sameGrid = this.isFromThisGrid(draggingEvent);
        let { rowNode: source, rowNodes: rows } = draggingEvent.dragItem;
        rows || (rows = source ? [source] : []);
        source || (source = rows[0]);
        if (!source || !rootNode) {
            return null;
        }
        const withinGrid = this.beans.dragAndDrop.isDropZoneWithinThisGrid(draggingEvent);
        let allowed = true;
        if (rowDragManaged &&
            (!rows.length || this.shouldPreventRowMove() || ((suppressMoveWhenRowDragging || !sameGrid) && !withinGrid))) {
            allowed = false;
        }
        const y = (0, mouseEventUtils_1._getNormalisedMousePosition)(beans, draggingEvent).y;
        const overNode = this.getOverNode(y);
        return {
            api: beans.gridApi,
            context: beans.gridOptions.context,
            draggingEvent,
            rowDragManaged,
            suppressMoveWhenRowDragging,
            sameGrid,
            withinGrid,
            rootNode,
            moved: source !== overNode,
            y,
            overNode: overNode,
            overIndex: overNode?.rowIndex ?? -1,
            position: 'none',
            source,
            target: overNode ?? null,
            newParent: null,
            rows,
            allowed,
            highlight: !dropping && rowDragManaged && suppressMoveWhenRowDragging && (withinGrid || !sameGrid),
        };
    }
    validateRowsDrop(rowsDrop, canSetParent, aboveOrBelow, dropping) {
        const { rowDragManaged, suppressMoveWhenRowDragging } = rowsDrop;
        if (!canSetParent) {
            rowsDrop.newParent = null;
        }
        if (suppressMoveWhenRowDragging && !rowsDrop.moved) {
            rowsDrop.allowed = false;
        }
        const isRowValidDropPosition = (!rowDragManaged || rowsDrop.allowed) && this.gos.get('isRowValidDropPosition');
        if (isRowValidDropPosition) {
            if (canSetParent && rowsDrop.newParent && rowsHaveSameParent(rowsDrop.rows, rowsDrop.newParent)) {
                rowsDrop.newParent = null; // No need to set parent if all rows have the same parent
            }
            const canDropResult = isRowValidDropPosition(rowsDrop);
            if (!canDropResult) {
                rowsDrop.allowed = false; // No rows to drop
            }
            else if (typeof canDropResult === 'object') {
                // Custom result, override the default values
                if (canDropResult.rows !== undefined) {
                    rowsDrop.rows = canDropResult.rows ?? [];
                }
                if (canSetParent && canDropResult.newParent !== undefined) {
                    rowsDrop.newParent = canDropResult.newParent;
                }
                if (canDropResult.target !== undefined) {
                    rowsDrop.target = canDropResult.target;
                }
                if (canDropResult.position) {
                    rowsDrop.position = canDropResult.position;
                }
                if (canDropResult.allowed !== undefined) {
                    rowsDrop.allowed = canDropResult.allowed;
                }
                else if (!rowDragManaged) {
                    rowsDrop.allowed = true; // If not managed, we always allow the drop if it was not explicitly disallowed
                }
                const draggingEvent = rowsDrop.draggingEvent;
                if (canDropResult.changed && draggingEvent) {
                    draggingEvent.changed = true;
                }
                if (!dropping && canDropResult.highlight !== undefined) {
                    rowsDrop.highlight = canDropResult.highlight;
                }
            }
        }
        if (rowDragManaged) {
            rowsDrop.rows = this.filterRows(rowsDrop);
        }
        if (canSetParent && rowsDrop.newParent && rowsHaveSameParent(rowsDrop.rows, rowsDrop.newParent)) {
            rowsDrop.newParent = null; // No need to set parent if all rows have the same parent
        }
        if (suppressMoveWhenRowDragging && (!rowsDrop.rows.length || rowsDrop.position === 'none')) {
            rowsDrop.allowed = false;
        }
        if ((!rowsDrop.allowed || !rowsDrop.newParent) && rowsDrop.position === 'inside') {
            rowsDrop.position = aboveOrBelow; // Remove 'inside' if no new parent
        }
    }
    targetShouldBeParent(target, yDelta, rows) {
        const targetRowIndex = target.rowIndex;
        const INSIDE_THRESHOLD = 0.25;
        if (yDelta < -0.5 + INSIDE_THRESHOLD) {
            return false; // Definitely above
        }
        if (yDelta < 0.5 - INSIDE_THRESHOLD) {
            return true; // Definitely inside
        }
        let nextRow;
        let nextRowIndex = targetRowIndex + 1;
        const clientSideRowModel = this.clientSideRowModel;
        do {
            nextRow = clientSideRowModel.getRow(nextRowIndex++);
        } while (nextRow && nextRow.footer);
        const childrenAfterGroup = target.childrenAfterGroup;
        if (nextRow && nextRow.parent === target && childrenAfterGroup?.length) {
            const rowsSet = new Set(rows);
            for (const child of childrenAfterGroup) {
                if (child.rowIndex !== null && !rowsSet.has(child)) {
                    return true; // The group has children, so we can move inside
                }
            }
        }
        return false;
    }
    addRowDropZone(params) {
        if (!params.getContainer()) {
            (0, logging_1._warn)(55);
            return;
        }
        const dragAndDrop = this.beans.dragAndDrop;
        if (dragAndDrop.findExternalZone(params.getContainer())) {
            (0, logging_1._warn)(56);
            return;
        }
        const processedParams = params.fromGrid
            ? params
            : {
                getContainer: params.getContainer,
                onDragEnter: params.onDragEnter && ((e) => params.onDragEnter(this.rowDragEvent('rowDragEnter', e))),
                onDragLeave: params.onDragLeave && ((e) => params.onDragLeave(this.rowDragEvent('rowDragLeave', e))),
                onDragging: params.onDragging && ((e) => params.onDragging(this.rowDragEvent('rowDragMove', e))),
                onDragStop: params.onDragStop && ((e) => params.onDragStop(this.rowDragEvent('rowDragEnd', e))),
                onDragCancel: params.onDragCancel &&
                    ((e) => params.onDragCancel(this.rowDragEvent('rowDragCancel', e))),
            };
        const dropTarget = {
            isInterestedIn: (type) => type === dragAndDropService_1.DragSourceType.RowDrag,
            getIconName: () => 'move',
            external: true,
            ...processedParams,
        };
        dragAndDrop.addDropTarget(dropTarget);
        this.addDestroyFunc(() => dragAndDrop.removeDropTarget(dropTarget));
    }
    getRowDropZone(events) {
        const result = {
            getContainer: this.getContainer.bind(this),
            onDragEnter: (e) => {
                this.onDragEnter(e);
                events?.onDragEnter?.(this.rowDragEvent('rowDragEnter', e));
            },
            onDragLeave: (e) => {
                this.onDragLeave(e);
                events?.onDragLeave?.(this.rowDragEvent('rowDragLeave', e));
            },
            onDragging: (e) => {
                this.onDragging(e);
                events?.onDragging?.(this.rowDragEvent('rowDragMove', e));
            },
            onDragStop: (e) => {
                this.onDragStop(e);
                events?.onDragStop?.(this.rowDragEvent('rowDragEnd', e));
            },
            onDragCancel: (e) => {
                this.onDragCancel(e);
                events?.onDragCancel?.(this.rowDragEvent('rowDragCancel', e));
            },
            fromGrid: true /* @private */,
        };
        return result; // Cast to hide the internal properties
    }
    getOverNode(y) {
        const { pageBounds, rowModel } = this.beans;
        const mouseIsPastLastRow = y > pageBounds.getCurrentPagePixelRange().pageLastPixel;
        const overIndex = mouseIsPastLastRow ? -1 : rowModel.getRowIndexAtPixel(y);
        return overIndex >= 0 ? rowModel.getRow(overIndex) : undefined;
    }
    rowDragEvent(type, draggingEvent) {
        const beans = this.beans;
        const { dragItem, dropTarget: rowsDrop, event, vDirection } = draggingEvent;
        const withRowsDrop = rowsDrop?.rootNode === this.clientSideRowModel.rootNode;
        const y = withRowsDrop ? rowsDrop.y : (0, mouseEventUtils_1._getNormalisedMousePosition)(beans, draggingEvent).y;
        const overNode = withRowsDrop ? rowsDrop.overNode : this.getOverNode(y);
        const overIndex = withRowsDrop ? rowsDrop.overIndex : overNode?.rowIndex ?? -1;
        return {
            api: beans.gridApi,
            context: beans.gridOptions.context,
            type,
            event,
            node: dragItem.rowNode,
            nodes: dragItem.rowNodes,
            overIndex,
            overNode,
            y,
            vDirection,
            rowsDrop,
        };
    }
    dispatchGridEvent(type, draggingEvent) {
        const event = this.rowDragEvent(type, draggingEvent);
        this.eventSvc.dispatchEvent(event);
    }
    onDragLeave(draggingEvent) {
        this.dispatchGridEvent('rowDragLeave', draggingEvent);
        this.stopDragging(draggingEvent);
    }
    onDragStop(draggingEvent) {
        const rowsDrop = this.makeRowsDrop(this.lastDraggingEvent, draggingEvent, false, true);
        this.dispatchGridEvent('rowDragEnd', draggingEvent);
        if (rowsDrop?.allowed &&
            rowsDrop.rowDragManaged &&
            (rowsDrop.suppressMoveWhenRowDragging || !rowsDrop.sameGrid)) {
            this.dropRows(rowsDrop); // Drop the rows after dragging
        }
        this.stopDragging(draggingEvent);
    }
    onDragCancel(draggingEvent) {
        this.dispatchGridEvent('rowDragCancel', draggingEvent);
        this.stopDragging(draggingEvent);
    }
    stopDragging(draggingEvent) {
        this.nudger?.clear();
        this.beans.rowDropHighlightSvc?.fromDrag(null);
        setRowNodesDragging(draggingEvent.dragItem.rowNodes, false);
    }
    /** Drag and drop. Returns false if at least a row was moved, otherwise true */
    dropRows(rowsDrop) {
        return rowsDrop.sameGrid ? this.moveRows(rowsDrop) : this.addRows(rowsDrop);
    }
    addRows({ position, target, rows }) {
        const getRowIdFunc = (0, gridOptionsUtils_1._getRowIdCallback)(this.gos);
        const clientSideRowModel = this.clientSideRowModel;
        const add = rows
            .filter(({ data, rowPinned }) => !clientSideRowModel.getRowNode(getRowIdFunc?.({ data, level: 0, rowPinned }) ?? data.id))
            .map(({ data }) => data);
        if (add.length === 0) {
            return false; // Nothing to add
        }
        const addIndex = target ? getLeafSourceRowIndex(target) + (position === 'above' ? 0 : 1) : undefined;
        clientSideRowModel.updateRowData({ add, addIndex });
        return true;
    }
    filterRows({ newParent, rows }) {
        const clientSideRowModel = this.clientSideRowModel;
        let filtered;
        for (let i = 0, len = rows.length; i < len; ++i) {
            let valid = true;
            const row = rows[i];
            if (!row || row.footer || (row.rowTop === null && row !== clientSideRowModel.getRowNode(row.id))) {
                valid = false; // This row cannot be dragged, not in allLeafChildren and not a filler
            }
            else if (newParent && row.parent !== newParent && wouldFormCycle(row, newParent)) {
                valid = false; // Cannot move to a parent that would create a cycle
            }
            else if (!getLeafRow(row)) {
                valid = false; // No leaf to move, so nothing to do
            }
            if (valid) {
                filtered?.push(row);
            }
            else {
                filtered ?? (filtered = rows.slice(0, i)); // Lazy initialization of the filtered array
            }
        }
        return filtered ?? rows; // If all rows are valid, return the original array
    }
    moveRows({ position, target, rows, newParent, rootNode }) {
        let changed = false;
        const leafs = new Set();
        for (const row of rows) {
            if (newParent && row.parent !== newParent) {
                row.treeParent = newParent;
                changed = true;
            }
            const leafRow = getLeafRow(row);
            if (leafRow) {
                leafs.add(leafRow);
            }
        }
        if (!changed && leafs.size === 0) {
            return false; // Nothing to move
        }
        // Get the focussed cell so we can ensure it remains focussed after the move
        const focusSvc = this.beans.focusSvc;
        const cellPosition = focusSvc.getFocusedCell();
        const cellCtrl = cellPosition && (0, positionUtils_1._getCellByPosition)(this.beans, cellPosition);
        if (leafs.size &&
            this.reorderLeafChildren(leafs, ...this.getMoveRowsBounds(leafs, target, position === 'above'))) {
            changed = true;
        }
        if (!changed) {
            return false;
        }
        this.clientSideRowModel.refreshModel({
            step: 'group',
            keepRenderedRows: true,
            animate: !this.gos.get('suppressAnimationFrame'),
            changedPath: new changedPath_1.ChangedPath(false, rootNode),
            rowNodesOrderChanged: true,
        });
        // Get the focussed cell so we can ensure it remains focussed after the move
        if (cellCtrl) {
            cellCtrl.focusCell();
        }
        else {
            focusSvc.clearFocusedCell();
        }
        return true;
    }
    /** For reorderLeafChildren, returns min index of the rows to move, the target index and the max index of the rows to move. */
    getMoveRowsBounds(leafs, target, above) {
        const totalRows = this.clientSideRowModel.rootNode?.allLeafChildren.length ?? 0;
        let targetPositionIdx = getLeafSourceRowIndex(target);
        if (targetPositionIdx < 0 || targetPositionIdx >= totalRows) {
            targetPositionIdx = totalRows;
        }
        else if (!above) {
            ++targetPositionIdx;
        }
        let firstAffectedLeafIdx = targetPositionIdx;
        let lastAffectedLeafIndex = Math.min(targetPositionIdx, totalRows - 1);
        for (const row of leafs) {
            const sourceRowIndex = row.sourceRowIndex;
            if (sourceRowIndex < firstAffectedLeafIdx)
                firstAffectedLeafIdx = sourceRowIndex;
            if (sourceRowIndex > lastAffectedLeafIndex)
                lastAffectedLeafIndex = sourceRowIndex;
        }
        return [firstAffectedLeafIdx, targetPositionIdx, lastAffectedLeafIndex];
    }
    /** Reorders the children of the root node, so that the rows to move are in the correct order.
     * @param leafs The valid set of rows to move, as returned by getValidRowsToMove
     * @param firstAffectedLeafIdx The first index of the rows to move
     * @param targetPositionIdx The target index, where the rows will be moved
     * @param lastAffectedLeafIndex The last index of the rows to move
     * @returns True if the order of the rows changed, false otherwise
     */
    reorderLeafChildren(leafs, firstAffectedLeafIdx, targetPositionIdx, lastAffectedLeafIndex) {
        let orderChanged = false;
        const allLeafChildren = this.clientSideRowModel.rootNode?.allLeafChildren;
        if (!leafs.size || !allLeafChildren) {
            return false;
        }
        // First partition. Filter from left to right, so the middle can be overwritten
        let writeIdxLeft = firstAffectedLeafIdx;
        for (let readIdx = firstAffectedLeafIdx; readIdx < targetPositionIdx; ++readIdx) {
            const row = allLeafChildren[readIdx];
            if (!leafs.has(row)) {
                if (row.sourceRowIndex !== writeIdxLeft) {
                    row.sourceRowIndex = writeIdxLeft;
                    allLeafChildren[writeIdxLeft] = row;
                    orderChanged = true;
                }
                ++writeIdxLeft;
            }
        }
        // Third partition. Filter from right to left, so the middle can be overwritten
        let writeIdxRight = lastAffectedLeafIndex;
        for (let readIdx = lastAffectedLeafIndex; readIdx >= targetPositionIdx; --readIdx) {
            const row = allLeafChildren[readIdx];
            if (!leafs.has(row)) {
                if (row.sourceRowIndex !== writeIdxRight) {
                    row.sourceRowIndex = writeIdxRight;
                    allLeafChildren[writeIdxRight] = row;
                    orderChanged = true;
                }
                --writeIdxRight;
            }
        }
        // Second partition. Overwrites the middle between the other two filtered partitions
        for (const row of leafs) {
            if (row.sourceRowIndex !== writeIdxLeft) {
                row.sourceRowIndex = writeIdxLeft;
                allLeafChildren[writeIdxLeft] = row;
                orderChanged = true;
            }
            ++writeIdxLeft;
        }
        return orderChanged;
    }
}
exports.RowDragFeature = RowDragFeature;
/** When dragging multiple rows, we want the user to be able to drag to the prev or next in the group if dragging on one of the selected rows. */
const getPrevOrNext = (clientSideRowModel, direction, initial) => {
    if (initial) {
        const rowCount = clientSideRowModel.getRowCount();
        let rowIndex = initial.rowIndex + direction;
        while (rowIndex >= 0 && rowIndex < rowCount) {
            const row = clientSideRowModel.getRow(rowIndex);
            if (!row || (!row.footer && !row.detail)) {
                return row;
            }
            rowIndex += direction;
        }
    }
    return undefined; // Out of bounds
};
const wouldFormCycle = (row, newParent) => {
    let parent = newParent;
    while (parent) {
        if (parent === row) {
            return true;
        }
        parent = parent.parent;
    }
    return false;
};
const rowsHaveSameParent = (rows, newParent) => {
    for (let i = 0, len = rows.length; i < len; ++i) {
        if (rows[i].parent !== newParent) {
            return false;
        }
    }
    return true;
};
const getLeafSourceRowIndex = (row) => {
    const leaf = getLeafRow(row);
    return leaf !== undefined ? leaf.sourceRowIndex : -1;
};
const getLeafRow = (row) => {
    while (row) {
        if (row.sourceRowIndex >= 0) {
            return row;
        }
        const childrenAfterGroup = row.childrenAfterGroup;
        if (!childrenAfterGroup?.length) {
            return undefined;
        }
        row = childrenAfterGroup[0];
    }
};
const rowsDropChanged = (a, b) => a !== b &&
    (!a ||
        a.sameGrid !== b.sameGrid ||
        a.allowed !== b.allowed ||
        a.position !== b.position ||
        a.target !== b.target ||
        a.source !== b.source ||
        a.newParent !== b.newParent ||
        !(0, array_1._areEqual)(a.rows, b.rows));
const compareRowIndex = ({ rowIndex: a }, { rowIndex: b }) => a !== null && b !== null ? a - b : 0;
const setRowNodesDragging = (rowNodes, dragging) => {
    for (let i = 0, len = rowNodes?.length || 0; i < len; ++i) {
        const rowNode = rowNodes[i];
        if (rowNode.dragging !== dragging) {
            rowNode.dragging = dragging;
            rowNode.dispatchRowEvent('draggingChanged');
        }
    }
};
const deltaDraggingTarget = (clientSideRowModel, rowsDrop) => {
    let bestTarget = null;
    let current = rowsDrop.target;
    if (current && rowsDrop.rows.indexOf(current) < 0) {
        return null;
    }
    const source = rowsDrop.source;
    if (!current || !source) {
        return null;
    }
    let count = current.rowIndex - source.rowIndex;
    const increment = count < 0 ? -1 : 1;
    count = rowsDrop.suppressMoveWhenRowDragging ? Math.abs(count) : 1;
    const rowsSet = new Set(rowsDrop.rows);
    do {
        const candidate = getPrevOrNext(clientSideRowModel, increment, current);
        if (!candidate) {
            break;
        }
        if (!rowsSet.has(candidate)) {
            bestTarget = candidate;
            --count;
        }
        current = candidate;
    } while (count > 0);
    return bestTarget;
};


/***/ }),

/***/ 84397:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowDragFeatureNudger = void 0;
const autoScrollService_1 = __webpack_require__(35628);
/**
 * Used to handle the auto-scrolling and the throttled make new group and expand logic while dragging rows.
 */
class RowDragFeatureNudger {
    constructor(beans, gridBodyCtrl) {
        this.beans = beans;
        this.groupThrottled = false;
        this.oldVScroll = null;
        this.groupTimer = null;
        this.groupTarget = null;
        this.onGroupThrottle = () => {
            this.groupTimer = null;
            this.groupThrottled = true;
            this.beans.dragAndDrop?.nudge();
        };
        const getScrollY = () => gridBodyCtrl.scrollFeature.getVScrollPosition().top;
        this.autoScroll = new autoScrollService_1.AutoScrollService({
            scrollContainer: gridBodyCtrl.eBodyViewport,
            scrollAxis: 'y',
            getVerticalPosition: getScrollY,
            setVerticalPosition: (position) => gridBodyCtrl.scrollFeature.setVerticalScrollPosition(position),
            onScrollCallback: () => {
                const newVScroll = getScrollY();
                const oldVScroll = this.oldVScroll;
                this.oldVScroll = newVScroll;
                if (oldVScroll !== null && oldVScroll !== newVScroll) {
                    this.beans.dragAndDrop?.nudge();
                }
            },
        });
    }
    updateGroup(target, canExpand) {
        if (this.groupTarget && this.groupTarget !== target) {
            this.clearGroup();
        }
        if (target) {
            if (canExpand &&
                this.groupThrottled &&
                !target.expanded &&
                target.childrenAfterSort?.length &&
                target.isExpandable()) {
                target.setExpanded(true, undefined, true);
            }
            if (target.expanded && target.childrenAfterSort?.length) {
                this.groupThrottled = true;
                this.groupTarget = target;
            }
        }
    }
    startGroup(target) {
        this.groupTarget = target;
        if (this.groupTimer === null) {
            this.groupTimer = window.setTimeout(this.onGroupThrottle, this.beans.gos.get('rowDragInsertDelay'));
        }
    }
    clearGroup() {
        this.groupThrottled = false;
        this.groupTarget = null;
        const timer = this.groupTimer;
        if (timer !== null) {
            this.groupTimer = null;
            window.clearTimeout(timer);
        }
    }
    clear() {
        this.clearGroup();
        this.autoScroll.ensureCleared();
        this.oldVScroll = null;
    }
}
exports.RowDragFeatureNudger = RowDragFeatureNudger;


/***/ }),

/***/ 92895:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowDragService = void 0;
const beanStub_1 = __webpack_require__(68731);
const gridOptionsUtils_1 = __webpack_require__(67274);
const rowDragComp_1 = __webpack_require__(21633);
const rowDragFeature_1 = __webpack_require__(12254);
class RowDragService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'rowDragSvc';
    }
    setupRowDrag(element, ctrl) {
        const rowDragFeature = ctrl.createManagedBean(new rowDragFeature_1.RowDragFeature(element));
        const dragAndDrop = this.beans.dragAndDrop;
        dragAndDrop.addDropTarget(rowDragFeature);
        ctrl.addDestroyFunc(() => dragAndDrop.removeDropTarget(rowDragFeature));
        this.rowDragFeature = rowDragFeature;
    }
    createRowDragComp(cellValueFn, rowNode, column, customGui, dragStartPixels, alwaysVisible) {
        return new rowDragComp_1.RowDragComp(cellValueFn, rowNode, column, customGui, dragStartPixels, alwaysVisible);
    }
    createRowDragCompForRow(rowNode, element) {
        if ((0, gridOptionsUtils_1._isCellSelectionEnabled)(this.gos)) {
            return undefined;
        }
        const translate = this.getLocaleTextFunc();
        return this.createRowDragComp(() => `1 ${translate('rowDragRow', 'row')}`, rowNode, undefined, element, undefined, true);
    }
    createRowDragCompForCell(rowNode, column, cellValueFn, element, dragStartPixels, alwaysVisible) {
        const gos = this.gos;
        if (gos.get('rowDragManaged')) {
            // row dragging only available in default row model and when not using pagination
            if (!(0, gridOptionsUtils_1._isClientSideRowModel)(gos) || gos.get('pagination')) {
                return undefined;
            }
        }
        // otherwise (normal case) we are creating a RowDraggingComp for the first time
        const rowDragComp = this.createRowDragComp(cellValueFn, rowNode, column, element, dragStartPixels, alwaysVisible);
        return rowDragComp;
    }
}
exports.RowDragService = RowDragService;


/***/ }),

/***/ 37406:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowDropHighlightService = void 0;
const beanStub_1 = __webpack_require__(68731);
class RowDropHighlightService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'rowDropHighlightSvc';
        this.uiLevel = 0;
        this.dragging = false;
        this.row = null;
        this.position = 'none';
    }
    postConstruct() {
        this.addManagedEventListeners({
            modelUpdated: this.onModelUpdated.bind(this),
        });
    }
    onModelUpdated() {
        const row = this.row;
        const oldDragging = this.dragging;
        if (!row || row.rowIndex === null || this.position === 'none') {
            this.clear();
        }
        else {
            this.set(row, this.position);
        }
        this.dragging = oldDragging;
    }
    destroy() {
        this.clear();
        super.destroy();
    }
    clear() {
        const last = this.row;
        this.dragging = false;
        if (last) {
            this.uiLevel = 0;
            this.position = 'none';
            this.row = null;
            last.dispatchRowEvent('rowHighlightChanged');
        }
    }
    set(row, dropIndicatorPosition) {
        const nodeChanged = row !== this.row;
        const uiLevel = row.uiLevel;
        const highlightChanged = dropIndicatorPosition !== this.position;
        const uiLevelChanged = uiLevel !== this.uiLevel;
        this.dragging = false;
        if (nodeChanged || highlightChanged || uiLevelChanged) {
            if (nodeChanged) {
                this.clear();
            }
            this.uiLevel = uiLevel;
            this.position = dropIndicatorPosition;
            this.row = row;
            row.dispatchRowEvent('rowHighlightChanged');
        }
    }
    fromDrag(draggingEvent) {
        const rowsDrop = draggingEvent?.dropTarget;
        if (rowsDrop) {
            const { highlight, target, position } = rowsDrop;
            if (highlight && target && position !== 'none') {
                this.set(target, position);
                this.dragging = true;
                return;
            }
        }
        if (this.dragging) {
            this.clear();
        }
    }
}
exports.RowDropHighlightService = RowDropHighlightService;


/***/ }),

/***/ 26564:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.cellEditingCSS = void 0;
exports.cellEditingCSS = `.ag-cell-inline-editing{border:var(--ag-cell-editing-border)!important;border-radius:var(--ag-border-radius);box-shadow:var(--ag-cell-editing-shadow);padding:0;z-index:1;.ag-cell-edit-wrapper,.ag-cell-editor,.ag-cell-wrapper,:where(.ag-cell-editor) .ag-input-field-input,:where(.ag-cell-editor) .ag-wrapper{height:100%;line-height:normal;min-height:100%;width:100%}&.ag-cell-editing-error{border-color:var(--ag-invalid-color)!important}}:where(.ag-popup-editor) .ag-large-text{background-color:var(--ag-background-color);border-radius:var(--ag-border-radius);box-shadow:var(--ag-dropdown-shadow);padding:0}.ag-large-text-input{display:block;height:auto;padding:var(--ag-cell-horizontal-padding)}:where(.ag-rtl .ag-large-text-input) textarea{resize:none}:where(.ag-ltr) .ag-checkbox-edit{padding-left:var(--ag-cell-horizontal-padding)}:where(.ag-rtl) .ag-checkbox-edit{padding-right:var(--ag-cell-horizontal-padding)}:where(.ag-row.ag-row-editing-invalid .ag-cell-inline-editing){opacity:.8}.ag-popup-editor{position:absolute;-webkit-user-select:none;-moz-user-select:none;user-select:none}`;


/***/ }),

/***/ 3336:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgAbstractCellEditor = void 0;
const agPopupComponent_1 = __webpack_require__(75298);
class AgAbstractCellEditor extends agPopupComponent_1.AgPopupComponent {
    constructor() {
        super(...arguments);
        this.errorMessages = null;
    }
    init(params) {
        this.params = params;
        this.initialiseEditor(params);
        this.eEditor.onValueChange(() => params.validate());
    }
    destroy() {
        this.errorMessages = null;
    }
}
exports.AgAbstractCellEditor = AgAbstractCellEditor;


/***/ }),

/***/ 50227:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CheckboxCellEditor = void 0;
const agComponent_1 = __webpack_require__(91668);
const aria_1 = __webpack_require__(91623);
const agCheckbox_1 = __webpack_require__(18531);
const agAbstractCellEditor_1 = __webpack_require__(3336);
const CheckboxCellEditorElement = {
    tag: 'div',
    cls: 'ag-cell-wrapper ag-cell-edit-wrapper ag-checkbox-edit',
    children: [
        {
            tag: 'ag-checkbox',
            ref: 'eEditor',
            role: 'presentation',
        },
    ],
};
class CheckboxCellEditor extends agAbstractCellEditor_1.AgAbstractCellEditor {
    constructor() {
        super(CheckboxCellEditorElement, [agCheckbox_1.AgCheckboxSelector]);
        this.eEditor = agComponent_1.RefPlaceholder;
    }
    initialiseEditor(params) {
        const isSelected = params.value ?? undefined;
        const eEditor = this.eEditor;
        eEditor.setValue(isSelected);
        const inputEl = eEditor.getInputElement();
        inputEl.setAttribute('tabindex', '-1');
        this.setAriaLabel(isSelected);
        this.addManagedListeners(eEditor, {
            fieldValueChanged: (event) => this.setAriaLabel(event.selected),
        });
    }
    getValue() {
        return this.eEditor.getValue();
    }
    focusIn() {
        this.eEditor.getFocusableElement().focus();
    }
    afterGuiAttached() {
        if (this.params.cellStartedEdit) {
            this.focusIn();
        }
    }
    isPopup() {
        return false;
    }
    setAriaLabel(isSelected) {
        const translate = this.getLocaleTextFunc();
        const stateName = (0, aria_1._getAriaCheckboxStateName)(translate, isSelected);
        const ariaLabel = translate('ariaToggleCellValue', 'Press SPACE to toggle cell value');
        this.eEditor.setInputAriaLabel(`${ariaLabel} (${stateName})`);
    }
    getValidationElement(tooltip) {
        return tooltip ? this.params.eGridCell : this.eEditor.getInputElement();
    }
    getValidationErrors() {
        const { params } = this;
        const { getValidationErrors } = params;
        const value = this.getValue();
        if (!getValidationErrors) {
            return null;
        }
        return getValidationErrors({
            value,
            internalErrors: null,
            cellEditorParams: params,
        });
    }
}
exports.CheckboxCellEditor = CheckboxCellEditor;


/***/ }),

/***/ 65314:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DateCellEditor = void 0;
const date_1 = __webpack_require__(97066);
const generic_1 = __webpack_require__(89097);
const agInputDateField_1 = __webpack_require__(65310);
const simpleCellEditor_1 = __webpack_require__(65336);
const DateCellElement = {
    tag: 'ag-input-date-field',
    ref: 'eEditor',
    cls: 'ag-cell-editor',
};
class DateCellEditorInput {
    constructor(getDataTypeService, getLocaleTextFunc) {
        this.getDataTypeService = getDataTypeService;
        this.getLocaleTextFunc = getLocaleTextFunc;
    }
    getTemplate() {
        return DateCellElement;
    }
    getAgComponents() {
        return [agInputDateField_1.AgInputDateFieldSelector];
    }
    init(eEditor, params) {
        this.eEditor = eEditor;
        this.params = params;
        const { min, max, step, colDef } = params;
        if (min != null) {
            eEditor.setMin(min);
        }
        if (max != null) {
            eEditor.setMax(max);
        }
        if (step != null) {
            eEditor.setStep(step);
        }
        this.includeTime =
            params.includeTime ?? this.getDataTypeService()?.getDateIncludesTimeFlag?.(colDef.cellDataType);
        if (this.includeTime != null) {
            eEditor.setIncludeTime(this.includeTime);
        }
    }
    getValidationErrors() {
        const eInput = this.eEditor.getInputElement();
        const value = eInput.valueAsDate;
        const { params } = this;
        const { min, max, getValidationErrors } = params;
        let internalErrors = [];
        const translate = this.getLocaleTextFunc();
        if (value instanceof Date && !isNaN(value.getTime())) {
            if (min) {
                const minValue = min instanceof Date ? min : new Date(min);
                if (value < minValue) {
                    const minDateString = minValue.toLocaleDateString();
                    internalErrors.push(translate('minDateValidation', `Date must be after ${minDateString}`, [minDateString]));
                }
            }
            if (max) {
                const maxValue = max instanceof Date ? max : new Date(max);
                if (value > maxValue) {
                    const maxDateString = maxValue.toLocaleDateString();
                    internalErrors.push(translate('maxDateValidation', `Date must be before ${maxDateString}`, [maxDateString]));
                }
            }
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({ value, cellEditorParams: params, internalErrors });
        }
        return internalErrors;
    }
    getValue() {
        const { eEditor, params } = this;
        const value = eEditor.getDate();
        if (!(0, generic_1._exists)(value) && !(0, generic_1._exists)(params.value)) {
            return params.value;
        }
        return value ?? null;
    }
    getStartValue() {
        const { value } = this.params;
        if (!(value instanceof Date)) {
            return undefined;
        }
        return (0, date_1._serialiseDate)(value, this.includeTime ?? false);
    }
}
class DateCellEditor extends simpleCellEditor_1.SimpleCellEditor {
    constructor() {
        super(new DateCellEditorInput(() => this.beans.dataTypeSvc, () => this.getLocaleTextFunc()));
    }
}
exports.DateCellEditor = DateCellEditor;


/***/ }),

/***/ 72059:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DateStringCellEditor = void 0;
const date_1 = __webpack_require__(97066);
const generic_1 = __webpack_require__(89097);
const agInputDateField_1 = __webpack_require__(65310);
const simpleCellEditor_1 = __webpack_require__(65336);
const DateStringCellElement = {
    tag: 'ag-input-date-field',
    ref: 'eEditor',
    cls: 'ag-cell-editor',
};
class DateStringCellEditorInput {
    constructor(getDataTypeService, getLocaleTextFunc) {
        this.getDataTypeService = getDataTypeService;
        this.getLocaleTextFunc = getLocaleTextFunc;
    }
    getTemplate() {
        return DateStringCellElement;
    }
    getAgComponents() {
        return [agInputDateField_1.AgInputDateFieldSelector];
    }
    init(eEditor, params) {
        this.eEditor = eEditor;
        this.params = params;
        const { min, max, step, colDef } = params;
        if (min != null) {
            eEditor.setMin(min);
        }
        if (max != null) {
            eEditor.setMax(max);
        }
        if (step != null) {
            eEditor.setStep(step);
        }
        this.includeTime =
            params.includeTime ?? this.getDataTypeService()?.getDateIncludesTimeFlag?.(colDef.cellDataType);
        if (this.includeTime != null) {
            eEditor.setIncludeTime(this.includeTime);
        }
    }
    getValidationErrors() {
        const { eEditor, params } = this;
        const raw = eEditor.getInputElement().value;
        const value = this.formatDate(this.parseDate(raw ?? undefined));
        const { min, max, getValidationErrors } = params;
        let internalErrors = [];
        if (value) {
            const date = new Date(value);
            const translate = this.getLocaleTextFunc();
            if (min) {
                const minDate = new Date(min);
                if (date < minDate) {
                    const minDateString = minDate.toLocaleDateString();
                    internalErrors.push(translate('minDateValidation', `Date must be after ${minDateString}`, [minDateString]));
                }
            }
            if (max) {
                const maxDate = new Date(max);
                if (date > maxDate) {
                    const maxDateString = maxDate.toLocaleDateString();
                    internalErrors.push(translate('maxDateValidation', `Date must be before ${maxDateString}`, [maxDateString]));
                }
            }
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({
                value: this.getValue(),
                cellEditorParams: params,
                internalErrors,
            });
        }
        return internalErrors;
    }
    getValue() {
        const { params, eEditor } = this;
        const value = this.formatDate(eEditor.getDate());
        if (!(0, generic_1._exists)(value) && !(0, generic_1._exists)(params.value)) {
            return params.value;
        }
        return params.parseValue(value ?? '');
    }
    getStartValue() {
        return (0, date_1._serialiseDate)(this.parseDate(this.params.value ?? undefined) ?? null, this.includeTime ?? false);
    }
    parseDate(value) {
        const dataTypeSvc = this.getDataTypeService();
        return dataTypeSvc
            ? dataTypeSvc.getDateParserFunction(this.params.column)(value)
            : (0, date_1._parseDateTimeFromString)(value) ?? undefined;
    }
    formatDate(value) {
        const dataTypeSvc = this.getDataTypeService();
        return dataTypeSvc
            ? dataTypeSvc.getDateFormatterFunction(this.params.column)(value)
            : (0, date_1._serialiseDate)(value ?? null, this.includeTime ?? false) ?? undefined;
    }
}
class DateStringCellEditor extends simpleCellEditor_1.SimpleCellEditor {
    constructor() {
        super(new DateStringCellEditorInput(() => this.beans.dataTypeSvc, () => this.getLocaleTextFunc()));
    }
}
exports.DateStringCellEditor = DateStringCellEditor;


/***/ }),

/***/ 74578:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LargeTextCellEditor = void 0;
const keyCode_1 = __webpack_require__(59926);
const agComponent_1 = __webpack_require__(91668);
const generic_1 = __webpack_require__(89097);
const agInputTextArea_1 = __webpack_require__(69878);
const agAbstractCellEditor_1 = __webpack_require__(3336);
const LargeTextCellElement = {
    tag: 'div',
    cls: 'ag-large-text',
    children: [
        {
            tag: 'ag-input-text-area',
            ref: 'eEditor',
            cls: 'ag-large-text-input',
        },
    ],
};
class LargeTextCellEditor extends agAbstractCellEditor_1.AgAbstractCellEditor {
    constructor() {
        super(LargeTextCellElement, [agInputTextArea_1.AgInputTextAreaSelector]);
        this.eEditor = agComponent_1.RefPlaceholder;
    }
    initialiseEditor(params) {
        const { eEditor } = this;
        const { cellStartedEdit, eventKey, maxLength, cols, rows } = params;
        this.focusAfterAttached = cellStartedEdit;
        // disable initial tooltips added to the input field
        // let the validation handle tooltips.
        eEditor.getInputElement().setAttribute('title', '');
        eEditor
            .setMaxLength(maxLength || 200)
            .setCols(cols || 60)
            .setRows(rows || 10);
        let startValue;
        // cellStartedEdit is only false if we are doing fullRow editing
        if (cellStartedEdit) {
            this.focusAfterAttached = true;
            if (eventKey === keyCode_1.KeyCode.BACKSPACE || eventKey === keyCode_1.KeyCode.DELETE) {
                startValue = '';
            }
            else if (eventKey && eventKey.length === 1) {
                startValue = eventKey;
            }
            else {
                startValue = this.getStartValue(params);
                if (eventKey !== keyCode_1.KeyCode.F2) {
                    this.highlightAllOnFocus = true;
                }
            }
        }
        else {
            this.focusAfterAttached = false;
            startValue = this.getStartValue(params);
        }
        if (startValue != null) {
            eEditor.setValue(startValue, true);
        }
        this.addGuiEventListener('keydown', this.onKeyDown.bind(this));
        this.activateTabIndex();
    }
    getStartValue(params) {
        const { value } = params;
        return value?.toString() ?? value;
    }
    onKeyDown(event) {
        const key = event.key;
        if (key === keyCode_1.KeyCode.LEFT ||
            key === keyCode_1.KeyCode.UP ||
            key === keyCode_1.KeyCode.RIGHT ||
            key === keyCode_1.KeyCode.DOWN ||
            (event.shiftKey && key === keyCode_1.KeyCode.ENTER)) {
            // shift+enter allows for newlines
            event.stopPropagation();
        }
    }
    afterGuiAttached() {
        const { eEditor, focusAfterAttached, highlightAllOnFocus } = this;
        const translate = this.getLocaleTextFunc();
        eEditor.setInputAriaLabel(translate('ariaInputEditor', 'Input Editor'));
        if (focusAfterAttached) {
            eEditor.getFocusableElement().focus();
            if (highlightAllOnFocus) {
                eEditor.getInputElement().select();
            }
        }
    }
    getValue() {
        const { eEditor, params } = this;
        const { value } = params;
        const editorValue = eEditor.getValue();
        if (!(0, generic_1._exists)(editorValue) && !(0, generic_1._exists)(value)) {
            return value;
        }
        return params.parseValue(editorValue);
    }
    getValidationElement() {
        return this.eEditor.getInputElement();
    }
    getValidationErrors() {
        const { params } = this;
        const { maxLength, getValidationErrors } = params;
        const translate = this.getLocaleTextFunc();
        const value = this.getValue();
        let internalErrors = [];
        if (typeof value === 'string' && maxLength != null && value.length > maxLength) {
            internalErrors.push(translate('maxLengthValidation', `Must be ${maxLength} characters or fewer.`, [String(maxLength)]));
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({
                value,
                internalErrors,
                cellEditorParams: params,
            });
        }
        return internalErrors;
    }
}
exports.LargeTextCellEditor = LargeTextCellEditor;


/***/ }),

/***/ 44371:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NumberCellEditor = void 0;
const keyCode_1 = __webpack_require__(59926);
const browser_1 = __webpack_require__(36916);
const generic_1 = __webpack_require__(89097);
const agInputNumberField_1 = __webpack_require__(25721);
const simpleCellEditor_1 = __webpack_require__(65336);
const NumberCellElement = {
    tag: 'ag-input-number-field',
    ref: 'eEditor',
    cls: 'ag-cell-editor',
};
class NumberCellEditorInput {
    constructor(getLocaleTextFunc) {
        this.getLocaleTextFunc = getLocaleTextFunc;
    }
    getTemplate() {
        return NumberCellElement;
    }
    getAgComponents() {
        return [agInputNumberField_1.AgInputNumberFieldSelector];
    }
    init(eEditor, params) {
        this.eEditor = eEditor;
        this.params = params;
        const { max, min, precision, step } = params;
        if (max != null) {
            eEditor.setMax(max);
        }
        if (min != null) {
            eEditor.setMin(min);
        }
        if (precision != null) {
            eEditor.setPrecision(precision);
        }
        if (step != null) {
            eEditor.setStep(step);
        }
        const editorEl = eEditor.getInputElement();
        if (params.preventStepping) {
            eEditor.addManagedElementListeners(editorEl, { keydown: this.preventStepping });
        }
        else if (params.showStepperButtons) {
            editorEl.classList.add('ag-number-field-input-stepper');
        }
    }
    getValidationErrors() {
        const { params } = this;
        const { min, max, getValidationErrors } = params;
        const eInput = this.eEditor.getInputElement();
        const value = eInput.valueAsNumber;
        const translate = this.getLocaleTextFunc();
        let internalErrors = [];
        if (typeof value === 'number') {
            if (min != null && value < min) {
                internalErrors.push(translate('minValueValidation', `Must be greater than or equal to ${min}.`, [String(min)]));
            }
            if (max != null && value > max) {
                internalErrors.push(translate('maxValueValidation', `Must be less than or equal to ${max}.`, [String(max)]));
            }
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({
                value,
                cellEditorParams: params,
                internalErrors,
            });
        }
        return internalErrors;
    }
    preventStepping(e) {
        if (e.key === keyCode_1.KeyCode.UP || e.key === keyCode_1.KeyCode.DOWN) {
            e.preventDefault();
        }
    }
    getValue() {
        const { eEditor, params } = this;
        const value = eEditor.getValue();
        if (!(0, generic_1._exists)(value) && !(0, generic_1._exists)(params.value)) {
            return params.value;
        }
        let parsedValue = params.parseValue(value);
        if (parsedValue == null) {
            return parsedValue;
        }
        if (typeof parsedValue === 'string') {
            if (parsedValue === '') {
                return null;
            }
            parsedValue = Number(parsedValue);
        }
        return isNaN(parsedValue) ? null : parsedValue;
    }
    getStartValue() {
        return this.params.value;
    }
    setCaret() {
        if ((0, browser_1._isBrowserSafari)()) {
            // If not safari, input is already focused.
            // For safari we need to focus only for this use case to avoid AG-3238,
            // but still ensure the input has focus.
            this.eEditor.getInputElement().focus({ preventScroll: true });
        }
    }
}
class NumberCellEditor extends simpleCellEditor_1.SimpleCellEditor {
    constructor() {
        super(new NumberCellEditorInput(() => this.getLocaleTextFunc()));
    }
}
exports.NumberCellEditor = NumberCellEditor;


/***/ }),

/***/ 55609:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PopupEditorWrapper = void 0;
const agPopupComponent_1 = __webpack_require__(75298);
const gridOptionsUtils_1 = __webpack_require__(67274);
const keyboardEvent_1 = __webpack_require__(83552);
const PopupEditorElement = { tag: 'div', cls: 'ag-popup-editor', attrs: { tabindex: '-1' } };
class PopupEditorWrapper extends agPopupComponent_1.AgPopupComponent {
    constructor(params) {
        super(PopupEditorElement);
        this.params = params;
    }
    postConstruct() {
        (0, gridOptionsUtils_1._setDomData)(this.gos, this.getGui(), 'popupEditorWrapper', true);
        this.addKeyDownListener();
    }
    addKeyDownListener() {
        const eGui = this.getGui();
        const params = this.params;
        const listener = (event) => {
            if (!(0, keyboardEvent_1._isUserSuppressingKeyboardEvent)(this.gos, event, params.node, params.column, true)) {
                params.onKeyDown(event);
            }
        };
        this.addManagedElementListeners(eGui, { keydown: listener });
    }
}
exports.PopupEditorWrapper = PopupEditorWrapper;


/***/ }),

/***/ 28774:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectCellEditor = void 0;
const keyCode_1 = __webpack_require__(59926);
const agComponent_1 = __webpack_require__(91668);
const generic_1 = __webpack_require__(89097);
const agSelect_1 = __webpack_require__(69234);
const logging_1 = __webpack_require__(47764);
const agAbstractCellEditor_1 = __webpack_require__(3336);
const SelectCellElement = {
    tag: 'div',
    cls: 'ag-cell-edit-wrapper',
    children: [
        {
            tag: 'ag-select',
            ref: 'eEditor',
            cls: 'ag-cell-editor',
        },
    ],
};
class SelectCellEditor extends agAbstractCellEditor_1.AgAbstractCellEditor {
    wireBeans(beans) {
        this.valueSvc = beans.valueSvc;
    }
    constructor() {
        super(SelectCellElement, [agSelect_1.AgSelectSelector]);
        this.eEditor = agComponent_1.RefPlaceholder;
        this.startedByEnter = false;
    }
    initialiseEditor(params) {
        this.focusAfterAttached = params.cellStartedEdit;
        const { eEditor, valueSvc, gos } = this;
        const { values, value, eventKey } = params;
        if ((0, generic_1._missing)(values)) {
            (0, logging_1._warn)(58);
            return;
        }
        this.startedByEnter = eventKey != null ? eventKey === keyCode_1.KeyCode.ENTER : false;
        let hasValue = false;
        values.forEach((currentValue) => {
            const option = { value: currentValue };
            const valueFormatted = valueSvc.formatValue(params.column, null, currentValue);
            const valueFormattedExits = valueFormatted !== null && valueFormatted !== undefined;
            option.text = valueFormattedExits ? valueFormatted : currentValue;
            eEditor.addOption(option);
            hasValue = hasValue || value === currentValue;
        });
        if (hasValue) {
            eEditor.setValue(params.value, true);
        }
        else if (params.values.length) {
            eEditor.setValue(params.values[0], true);
        }
        const { valueListGap, valueListMaxWidth, valueListMaxHeight } = params;
        if (valueListGap != null) {
            eEditor.setPickerGap(valueListGap);
        }
        if (valueListMaxHeight != null) {
            eEditor.setPickerMaxHeight(valueListMaxHeight);
        }
        if (valueListMaxWidth != null) {
            eEditor.setPickerMaxWidth(valueListMaxWidth);
        }
        // we don't want to add this if full row editing, otherwise selecting will stop the
        // full row editing.
        if (gos.get('editType') !== 'fullRow') {
            this.addManagedListeners(this.eEditor, { selectedItem: () => params.stopEditing() });
        }
    }
    afterGuiAttached() {
        if (this.focusAfterAttached) {
            this.eEditor.getFocusableElement().focus();
        }
        if (this.startedByEnter) {
            setTimeout(() => {
                if (this.isAlive()) {
                    this.eEditor.showPicker();
                }
            });
        }
    }
    focusIn() {
        this.eEditor.getFocusableElement().focus();
    }
    getValue() {
        return this.eEditor.getValue();
    }
    isPopup() {
        return false;
    }
    getValidationElement() {
        return this.eEditor.getAriaElement();
    }
    getValidationErrors() {
        const { params } = this;
        const { values, getValidationErrors } = params;
        const value = this.getValue();
        let internalErrors = [];
        if (values && !values.includes(value)) {
            const translate = this.getLocaleTextFunc();
            internalErrors.push(translate('invalidSelectionValidation', 'Invalid selection.'));
        }
        else {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({
                value,
                internalErrors,
                cellEditorParams: params,
            });
        }
        return internalErrors;
    }
}
exports.SelectCellEditor = SelectCellEditor;


/***/ }),

/***/ 65336:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleCellEditor = void 0;
const keyCode_1 = __webpack_require__(59926);
const agComponent_1 = __webpack_require__(91668);
const browser_1 = __webpack_require__(36916);
const agAbstractCellEditor_1 = __webpack_require__(3336);
class SimpleCellEditor extends agAbstractCellEditor_1.AgAbstractCellEditor {
    constructor(cellEditorInput) {
        super();
        this.cellEditorInput = cellEditorInput;
        this.eEditor = agComponent_1.RefPlaceholder;
    }
    initialiseEditor(params) {
        const { cellEditorInput } = this;
        this.setTemplate({ tag: 'div', cls: 'ag-cell-edit-wrapper', children: [cellEditorInput.getTemplate()] }, cellEditorInput.getAgComponents());
        const { eEditor } = this;
        const { cellStartedEdit, eventKey, suppressPreventDefault } = params;
        // disable initial tooltips added to the input field
        // let the validation handle tooltips.
        eEditor.getInputElement().setAttribute('title', '');
        cellEditorInput.init(eEditor, params);
        let startValue;
        let shouldSetStartValue = true;
        // cellStartedEdit is only false if we are doing fullRow editing
        if (cellStartedEdit) {
            this.focusAfterAttached = true;
            if (eventKey === keyCode_1.KeyCode.BACKSPACE || eventKey === keyCode_1.KeyCode.DELETE) {
                startValue = '';
            }
            else if (eventKey && eventKey.length === 1) {
                if (suppressPreventDefault) {
                    shouldSetStartValue = false;
                }
                else {
                    startValue = eventKey;
                }
            }
            else {
                startValue = cellEditorInput.getStartValue();
                if (eventKey !== keyCode_1.KeyCode.F2) {
                    this.highlightAllOnFocus = true;
                }
            }
        }
        else {
            this.focusAfterAttached = false;
            startValue = cellEditorInput.getStartValue();
        }
        if (shouldSetStartValue && startValue != null) {
            eEditor.setStartValue(startValue);
        }
        this.addGuiEventListener('keydown', (event) => {
            const { key } = event;
            if (key === keyCode_1.KeyCode.PAGE_UP || key === keyCode_1.KeyCode.PAGE_DOWN) {
                event.preventDefault();
            }
        });
    }
    afterGuiAttached() {
        const translate = this.getLocaleTextFunc();
        const eInput = this.eEditor;
        eInput.setInputAriaLabel(translate('ariaInputEditor', 'Input Editor'));
        if (!this.focusAfterAttached) {
            return;
        }
        // Added for AG-3238. We can't remove this explicit focus() because Chrome requires an input
        // to be focused before setSelectionRange will work. But it triggers a bug in Safari where
        // explicitly focusing then blurring an empty field will cause the parent container to scroll.
        if (!(0, browser_1._isBrowserSafari)()) {
            eInput.getFocusableElement().focus();
        }
        const inputEl = eInput.getInputElement();
        if (this.highlightAllOnFocus) {
            inputEl.select();
        }
        else {
            this.cellEditorInput.setCaret?.();
        }
    }
    // gets called when tabbing through cells and in full row edit mode
    focusIn() {
        const { eEditor } = this;
        const focusEl = eEditor.getFocusableElement();
        const inputEl = eEditor.getInputElement();
        focusEl.focus();
        inputEl.select();
    }
    getValue() {
        return this.cellEditorInput.getValue();
    }
    isPopup() {
        return false;
    }
    getValidationElement() {
        return this.eEditor.getInputElement();
    }
    getValidationErrors() {
        return this.cellEditorInput.getValidationErrors();
    }
}
exports.SimpleCellEditor = SimpleCellEditor;


/***/ }),

/***/ 15457:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextCellEditor = void 0;
const browser_1 = __webpack_require__(36916);
const generic_1 = __webpack_require__(89097);
const agInputTextField_1 = __webpack_require__(89863);
const simpleCellEditor_1 = __webpack_require__(65336);
const TextCellEditorElement = {
    tag: 'ag-input-text-field',
    ref: 'eEditor',
    cls: 'ag-cell-editor',
};
class TextCellEditorInput {
    constructor(getLocaleTextFunc) {
        this.getLocaleTextFunc = getLocaleTextFunc;
    }
    getTemplate() {
        return TextCellEditorElement;
    }
    getAgComponents() {
        return [agInputTextField_1.AgInputTextFieldSelector];
    }
    init(eEditor, params) {
        this.eEditor = eEditor;
        this.params = params;
        const maxLength = params.maxLength;
        if (maxLength != null) {
            eEditor.setMaxLength(maxLength);
        }
    }
    getValidationErrors() {
        const { params } = this;
        const { maxLength, getValidationErrors } = params;
        const value = this.getValue();
        const translate = this.getLocaleTextFunc();
        let internalErrors = [];
        if (maxLength != null && typeof value === 'string' && value.length > maxLength) {
            internalErrors.push(translate('maxLengthValidation', `Must be ${maxLength} characters or fewer.`, [String(maxLength)]));
        }
        if (!internalErrors.length) {
            internalErrors = null;
        }
        if (getValidationErrors) {
            return getValidationErrors({ value, cellEditorParams: params, internalErrors });
        }
        return internalErrors;
    }
    getValue() {
        const { eEditor, params } = this;
        const value = eEditor.getValue();
        if (!(0, generic_1._exists)(value) && !(0, generic_1._exists)(params.value)) {
            return params.value;
        }
        return params.parseValue(value);
    }
    getStartValue() {
        const params = this.params;
        const formatValue = params.useFormatter || params.column.getColDef().refData;
        return formatValue ? params.formatValue(params.value) : params.value;
    }
    setCaret() {
        if ((0, browser_1._isBrowserSafari)()) {
            // If not safari, input is already focused.
            // For safari we need to focus only for this use case to avoid AG-3238,
            // but still ensure the input has focus.
            this.eEditor.getInputElement().focus({ preventScroll: true });
        }
        // when we started editing, we want the caret at the end, not the start.
        // this comes into play in two scenarios:
        //   a) when user hits F2
        //   b) when user hits a printable character
        const eInput = this.eEditor;
        const value = eInput.getValue();
        const len = ((0, generic_1._exists)(value) && value.length) || 0;
        if (len) {
            eInput.getInputElement().setSelectionRange(len, len);
        }
    }
}
class TextCellEditor extends simpleCellEditor_1.SimpleCellEditor {
    constructor() {
        super(new TextCellEditorInput(() => this.getLocaleTextFunc()));
    }
}
exports.TextCellEditor = TextCellEditor;


/***/ }),

/***/ 52470:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getCurrentRedoSize = exports.getCurrentUndoSize = exports.validateEdit = exports.startEditingCell = exports.isEditing = exports.stopEditing = exports.getEditingCells = exports.getEditRowValues = exports.redoCellEditing = exports.undoCellEditing = void 0;
const scrollApi_1 = __webpack_require__(11765);
const positionUtils_1 = __webpack_require__(6257);
const logging_1 = __webpack_require__(47764);
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(78994);
function undoCellEditing(beans) {
    beans.undoRedo?.undo('api');
}
exports.undoCellEditing = undoCellEditing;
function redoCellEditing(beans) {
    beans.undoRedo?.redo('api');
}
exports.redoCellEditing = redoCellEditing;
function getEditRowValues(beans, rowNode) {
    return beans.editModelSvc?.getEditRowDataValue(rowNode, { checkSiblings: true });
}
exports.getEditRowValues = getEditRowValues;
function getEditingCells(beans) {
    const edits = beans.editModelSvc?.getEditMap();
    const positions = [];
    edits?.forEach((editRow, rowNode) => {
        const { rowIndex, rowPinned } = rowNode;
        editRow.forEach((editValue, column) => {
            const { editorValue, pendingValue, sourceValue: oldValue, state } = editValue;
            const diff = (0, editors_1._sourceAndPendingDiffer)(editValue);
            let newValue = editorValue ?? pendingValue;
            if (newValue === editors_1.UNEDITED) {
                newValue = undefined;
            }
            const edit = {
                newValue,
                oldValue,
                state,
                column,
                colId: column.getColId(),
                colKey: column.getColId(),
                rowIndex: rowIndex,
                rowPinned,
            };
            const changed = state === 'changed' && diff;
            const editing = state === 'editing';
            if (editing || changed) {
                positions.push(edit);
            }
        });
    });
    return positions;
}
exports.getEditingCells = getEditingCells;
function stopEditing(beans, cancel = false) {
    const { editSvc } = beans;
    if (editSvc?.isBatchEditing()) {
        if (cancel) {
            beans.editModelSvc?.getEditPositions().forEach((cellPosition) => {
                if (cellPosition.state === 'editing') {
                    editSvc.revertSingleCellEdit(cellPosition);
                }
            });
        }
        else {
            (0, editors_1._syncFromEditors)(beans, { persist: true });
        }
        (0, editors_1._destroyEditors)(beans, undefined, { cancel });
    }
    else {
        editSvc?.stopEditing(undefined, { cancel, source: 'edit', forceStop: !cancel, forceCancel: cancel });
    }
}
exports.stopEditing = stopEditing;
function isEditing(beans, cellPosition) {
    const cellCtrl = (0, controllers_1._getCellCtrl)(beans, cellPosition);
    return beans.editSvc?.isEditing(cellCtrl) ?? false;
}
exports.isEditing = isEditing;
function startEditingCell(beans, params) {
    const { key, colKey, rowIndex, rowPinned } = params;
    const { editSvc, colModel } = beans;
    const column = colModel.getCol(colKey);
    if (!column) {
        (0, logging_1._warn)(12, { colKey });
        return;
    }
    const cellPosition = {
        rowIndex,
        rowPinned: rowPinned || null,
        column,
    };
    const rowNode = (0, positionUtils_1._getRowNode)(beans, cellPosition);
    if (!rowNode) {
        (0, logging_1._warn)(290, { rowIndex, rowPinned });
        return;
    }
    if (!column.isCellEditable(rowNode)) {
        return;
    }
    const notPinned = rowPinned == null;
    if (notPinned) {
        (0, scrollApi_1.ensureIndexVisible)(beans, rowIndex);
    }
    (0, scrollApi_1.ensureColumnVisible)(beans, colKey);
    editSvc?.startEditing({
        rowNode,
        column,
    }, {
        event: key ? new KeyboardEvent('keydown', { key }) : undefined,
        source: 'api',
    });
}
exports.startEditingCell = startEditingCell;
function validateEdit(beans) {
    return beans.editSvc?.validateEdit() || null;
}
exports.validateEdit = validateEdit;
function getCurrentUndoSize(beans) {
    return beans.undoRedo?.getCurrentUndoStackSize() ?? 0;
}
exports.getCurrentUndoSize = getCurrentUndoSize;
function getCurrentRedoSize(beans) {
    return beans.undoRedo?.getCurrentRedoStackSize() ?? 0;
}
exports.getCurrentRedoSize = getCurrentRedoSize;


/***/ }),

/***/ 68544:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditRowValidationModel = exports.EditCellValidationModel = exports.EditModelService = void 0;
const beanStub_1 = __webpack_require__(68731);
const editors_1 = __webpack_require__(78994);
class EditModelService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'editModelSvc';
        this.edits = new Map();
        this.cellValidations = new EditCellValidationModel();
        this.rowValidations = new EditRowValidationModel();
        // during some operations, we want to always return false from `hasEdits`
        this.suspendEdits = false;
    }
    suspend(suspend) {
        this.suspendEdits = suspend;
    }
    removeEdits({ rowNode, column }) {
        if (!this.hasEdits({ rowNode }) || !rowNode) {
            return;
        }
        const editRow = this.getEditRow(rowNode);
        if (column) {
            editRow.delete(column);
        }
        else {
            editRow.clear();
        }
        if (editRow.size === 0) {
            this.edits.delete(rowNode);
        }
    }
    getEditRow(rowNode, params = {}) {
        if (this.suspendEdits) {
            return undefined;
        }
        if (this.edits.size === 0) {
            return undefined;
        }
        const edits = rowNode && this.edits.get(rowNode);
        if (edits) {
            return edits;
        }
        if (params.checkSiblings) {
            const pinnedSibling = rowNode.pinnedSibling;
            if (pinnedSibling) {
                return this.getEditRow(pinnedSibling);
            }
        }
        return undefined;
    }
    getEditRowDataValue(rowNode, { checkSiblings } = {}) {
        if (!rowNode || this.edits.size === 0) {
            return undefined;
        }
        // don't check siblings via getEditRow parameter, as we want to combine edits from the row and its siblings
        const editRow = this.getEditRow(rowNode);
        const pinnedSibling = rowNode.pinnedSibling;
        const siblingRow = checkSiblings && pinnedSibling && this.getEditRow(pinnedSibling);
        if (!editRow && !siblingRow) {
            return undefined;
        }
        const data = Object.assign({}, rowNode.data);
        const applyEdits = (edits, data) => edits.forEach(({ pendingValue }, column) => {
            if (pendingValue !== editors_1.UNEDITED) {
                data[column.getColId()] = pendingValue;
            }
        });
        if (editRow) {
            applyEdits(editRow, data);
        }
        if (siblingRow) {
            applyEdits(siblingRow, data);
        }
        return data;
    }
    getEdit(position, copy) {
        const edit = this._getEdit(position);
        return copy && edit ? { ...edit } : edit;
    }
    _getEdit(position) {
        if (this.suspendEdits) {
            return undefined;
        }
        if (this.edits.size === 0) {
            return undefined;
        }
        return position.rowNode && position.column && this.getEditRow(position.rowNode)?.get(position.column);
    }
    getEditMap(copy = true) {
        if (this.suspendEdits || this.edits.size === 0) {
            return new Map();
        }
        if (!copy) {
            return this.edits;
        }
        const map = new Map();
        this.edits.forEach((editRow, rowNode) => {
            const newEditRow = new Map();
            editRow.forEach(({ editorState: _, ...cellData }, column) => 
            // Ensure we copy the cell data to avoid reference issues
            newEditRow.set(column, { ...cellData }));
            map.set(rowNode, newEditRow);
        });
        return map;
    }
    setEditMap(newEdits) {
        this.edits.clear();
        newEdits.forEach((editRow, rowNode) => {
            const newRow = new Map();
            editRow.forEach((cellData, column) => 
            // Ensure we copy the cell data to avoid reference issues
            newRow.set(column, { ...cellData }));
            this.edits.set(rowNode, newRow);
        });
    }
    setEdit(position, edit) {
        (this.edits.size === 0 || !this.edits.has(position.rowNode)) && this.edits.set(position.rowNode, new Map());
        const currentEdit = this._getEdit(position);
        const updatedEdit = Object.assign({
            editorState: {
                isCancelAfterEnd: undefined,
                isCancelBeforeStart: undefined,
            },
            ...currentEdit,
            ...edit,
        });
        this.getEditRow(position.rowNode).set(position.column, updatedEdit);
        return updatedEdit;
    }
    clearEditValue(position) {
        const { rowNode, column } = position;
        if (rowNode) {
            if (column) {
                const edit = this._getEdit(position);
                if (edit) {
                    edit.editorValue = undefined;
                    edit.pendingValue = edit.sourceValue;
                    edit.state = 'changed';
                }
            }
            else {
                this.getEditRow(rowNode)?.forEach((cellData) => {
                    cellData.editorValue = undefined;
                    cellData.pendingValue = cellData.sourceValue;
                    cellData.state = 'changed';
                });
            }
        }
    }
    getState(position) {
        if (this.suspendEdits) {
            return undefined;
        }
        return this.getEdit(position)?.state;
    }
    getEditPositions(editMap) {
        if (this.suspendEdits || (editMap ?? this.edits).size === 0) {
            return [];
        }
        const positions = [];
        (editMap ?? this.edits).forEach((editRow, rowNode) => {
            for (const column of editRow.keys()) {
                const { editorState: _, ...rest } = editRow.get(column);
                positions.push({
                    rowNode,
                    column,
                    ...rest,
                });
            }
        });
        return positions;
    }
    hasRowEdits(rowNode, params) {
        if (this.suspendEdits) {
            return false;
        }
        if (this.edits.size === 0) {
            return false;
        }
        const rowEdits = this.getEditRow(rowNode, params);
        return !!rowEdits;
    }
    hasEdits(position = {}, params = {}) {
        if (this.suspendEdits) {
            return false;
        }
        if (this.edits.size === 0) {
            return false;
        }
        const { rowNode, column } = position;
        const { withOpenEditor } = params;
        if (rowNode) {
            const rowEdits = this.getEditRow(rowNode, params);
            if (!rowEdits) {
                return false;
            }
            if (column) {
                if (withOpenEditor) {
                    return this.getEdit(position)?.state === 'editing';
                }
                return rowEdits.has(column) ?? false;
            }
            if (rowEdits.size !== 0) {
                if (withOpenEditor) {
                    return Array.from(rowEdits.values()).some(({ state }) => state === 'editing');
                }
                return true;
            }
            return false;
        }
        if (withOpenEditor) {
            return this.getEditPositions().some(({ state }) => state === 'editing');
        }
        return this.edits.size > 0;
    }
    start(position) {
        const map = this.getEditRow(position.rowNode) ?? new Map();
        const { rowNode, column } = position;
        if (column && !map.has(column)) {
            map.set(column, {
                editorValue: undefined,
                pendingValue: editors_1.UNEDITED,
                sourceValue: this.beans.valueSvc.getValue(column, rowNode, false, 'api'),
                state: 'editing',
                editorState: {
                    isCancelAfterEnd: undefined,
                    isCancelBeforeStart: undefined,
                },
            });
        }
        this.edits.set(rowNode, map);
    }
    stop(position) {
        if (!this.hasEdits(position)) {
            return;
        }
        if (position) {
            this.removeEdits(position);
        }
        else {
            this.clear();
        }
        return;
    }
    clear() {
        for (const pendingRowEdits of this.edits.values()) {
            pendingRowEdits.clear();
        }
        this.edits.clear();
    }
    getCellValidationModel() {
        return this.cellValidations;
    }
    getRowValidationModel() {
        return this.rowValidations;
    }
    setCellValidationModel(model) {
        this.cellValidations = model;
    }
    setRowValidationModel(model) {
        this.rowValidations = model;
    }
    destroy() {
        super.destroy();
        this.clear();
    }
}
exports.EditModelService = EditModelService;
class EditCellValidationModel {
    constructor() {
        this.cellValidations = new Map();
    }
    getCellValidation(position) {
        const { rowNode, column } = position || {};
        return this.cellValidations?.get(rowNode)?.get(column);
    }
    hasCellValidation(position) {
        if (!position || !position.rowNode || !position.column) {
            return this.cellValidations.size > 0;
        }
        return !!this.getCellValidation(position);
    }
    setCellValidation(position, validation) {
        const { rowNode, column } = position;
        if (!this.cellValidations.has(rowNode)) {
            this.cellValidations.set(rowNode, new Map());
        }
        this.cellValidations.get(rowNode).set(column, validation);
    }
    clearCellValidation(position) {
        const { rowNode, column } = position;
        this.cellValidations.get(rowNode)?.delete(column);
    }
    setCellValidationMap(validationMap) {
        this.cellValidations = validationMap;
    }
    getCellValidationMap() {
        return this.cellValidations;
    }
    clearCellValidationMap() {
        this.cellValidations.clear();
    }
}
exports.EditCellValidationModel = EditCellValidationModel;
class EditRowValidationModel {
    constructor() {
        this.rowValidations = new Map();
    }
    getRowValidation(position) {
        const { rowNode } = position || {};
        return this.rowValidations.get(rowNode);
    }
    hasRowValidation(position) {
        if (!position || !position.rowNode) {
            return this.rowValidations.size > 0;
        }
        return !!this.getRowValidation(position);
    }
    setRowValidation({ rowNode }, rowValidation) {
        this.rowValidations.set(rowNode, rowValidation);
    }
    clearRowValidation({ rowNode }) {
        this.rowValidations.delete(rowNode);
    }
    setRowValidationMap(validationMap) {
        this.rowValidations = validationMap;
    }
    getRowValidationMap() {
        return this.rowValidations;
    }
    clearRowValidationMap() {
        this.rowValidations.clear();
    }
}
exports.EditRowValidationModel = EditRowValidationModel;


/***/ }),

/***/ 84652:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CustomEditorModule = exports.LargeTextEditorModule = exports.SelectEditorModule = exports.CheckboxEditorModule = exports.DateEditorModule = exports.NumberEditorModule = exports.TextEditorModule = exports.UndoRedoEditModule = exports.EditCoreModule = void 0;
const tooltipModule_1 = __webpack_require__(34658);
const undoRedoService_1 = __webpack_require__(57113);
const version_1 = __webpack_require__(97205);
const popupModule_1 = __webpack_require__(3137);
const cell_editing_css_GENERATED_1 = __webpack_require__(26564);
const checkboxCellEditor_1 = __webpack_require__(50227);
const dateCellEditor_1 = __webpack_require__(65314);
const dateStringCellEditor_1 = __webpack_require__(72059);
const largeTextCellEditor_1 = __webpack_require__(74578);
const numberCellEditor_1 = __webpack_require__(44371);
const selectCellEditor_1 = __webpack_require__(28774);
const textCellEditor_1 = __webpack_require__(15457);
const editApi_1 = __webpack_require__(52470);
const editModelService_1 = __webpack_require__(68544);
const editService_1 = __webpack_require__(61277);
const fullRowEditStrategy_1 = __webpack_require__(40104);
const singleCellEditStrategy_1 = __webpack_require__(30149);
const editors_1 = __webpack_require__(78994);
/**
 * @internal
 */
exports.EditCoreModule = {
    moduleName: 'EditCore',
    version: version_1.VERSION,
    beans: [editModelService_1.EditModelService, editService_1.EditService],
    apiFunctions: {
        getEditingCells: editApi_1.getEditingCells,
        getEditRowValues: editApi_1.getEditRowValues,
        getCellEditorInstances: editors_1.getCellEditorInstances,
        startEditingCell: editApi_1.startEditingCell,
        stopEditing: editApi_1.stopEditing,
        isEditing: editApi_1.isEditing,
        validateEdit: editApi_1.validateEdit,
    },
    dynamicBeans: {
        singleCell: singleCellEditStrategy_1.SingleCellEditStrategy,
        fullRow: fullRowEditStrategy_1.FullRowEditStrategy,
    },
    dependsOn: [popupModule_1.PopupModule, tooltipModule_1.TooltipModule],
    css: [cell_editing_css_GENERATED_1.cellEditingCSS],
};
/**
 * @feature Editing -> Undo / Redo Edits
 */
exports.UndoRedoEditModule = {
    moduleName: 'UndoRedoEdit',
    version: version_1.VERSION,
    beans: [undoRedoService_1.UndoRedoService],
    apiFunctions: {
        undoCellEditing: editApi_1.undoCellEditing,
        redoCellEditing: editApi_1.redoCellEditing,
        getCurrentUndoSize: editApi_1.getCurrentUndoSize,
        getCurrentRedoSize: editApi_1.getCurrentRedoSize,
    },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Text Editor
 */
exports.TextEditorModule = {
    moduleName: 'TextEditor',
    version: version_1.VERSION,
    userComponents: { agCellEditor: textCellEditor_1.TextCellEditor, agTextCellEditor: textCellEditor_1.TextCellEditor },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Number Editor
 */
exports.NumberEditorModule = {
    moduleName: 'NumberEditor',
    version: version_1.VERSION,
    userComponents: {
        agNumberCellEditor: {
            classImp: numberCellEditor_1.NumberCellEditor,
        },
    },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Date Editor
 */
exports.DateEditorModule = {
    moduleName: 'DateEditor',
    version: version_1.VERSION,
    userComponents: {
        agDateCellEditor: dateCellEditor_1.DateCellEditor,
        agDateStringCellEditor: dateStringCellEditor_1.DateStringCellEditor,
    },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Checkbox Editor
 */
exports.CheckboxEditorModule = {
    moduleName: 'CheckboxEditor',
    version: version_1.VERSION,
    userComponents: {
        agCheckboxCellEditor: checkboxCellEditor_1.CheckboxCellEditor,
    },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Select Editor
 */
exports.SelectEditorModule = {
    moduleName: 'SelectEditor',
    version: version_1.VERSION,
    userComponents: { agSelectCellEditor: selectCellEditor_1.SelectCellEditor },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing -> Large Text Editor
 */
exports.LargeTextEditorModule = {
    moduleName: 'LargeTextEditor',
    version: version_1.VERSION,
    userComponents: { agLargeTextCellEditor: largeTextCellEditor_1.LargeTextCellEditor },
    dependsOn: [exports.EditCoreModule],
};
/**
 * @feature Editing
 */
exports.CustomEditorModule = {
    moduleName: 'CustomEditor',
    version: version_1.VERSION,
    dependsOn: [exports.EditCoreModule],
};


/***/ }),

/***/ 61277:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditService = void 0;
const keyCode_1 = __webpack_require__(59926);
const beanStub_1 = __webpack_require__(68731);
const positionUtils_1 = __webpack_require__(6257);
const gridOptionsUtils_1 = __webpack_require__(67274);
const cellCtrl_1 = __webpack_require__(60814);
const popupEditorWrapper_1 = __webpack_require__(55609);
const strategyUtils_1 = __webpack_require__(86040);
const cellEditStyleFeature_1 = __webpack_require__(46904);
const rowEditStyleFeature_1 = __webpack_require__(13536);
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(78994);
const refresh_1 = __webpack_require__(11539);
// these are event sources for setDataValue that will not cause the editors to close
const KEEP_EDITOR_SOURCES = new Set(['undo', 'redo', 'paste', 'bulk', 'rangeSvc']);
const INTERNAL_EDITOR_SOURCES = new Set(['ui', 'api']);
// stop editing sources that we treat as UI-originated so we follow standard processing.
const STOP_EDIT_SOURCE_TRANSFORM = {
    paste: 'api',
    rangeSvc: 'api',
    fillHandle: 'api',
    cellClear: 'api',
    bulk: 'api',
};
const STOP_EDIT_SOURCE_TRANSFORM_KEYS = new Set(Object.keys(STOP_EDIT_SOURCE_TRANSFORM));
// These are sources that we treat as API-originated so we presume API behaviour.
const SET_DATA_SOURCE_AS_API = new Set([
    'paste',
    'rangeSvc',
    'renderer',
    'cellClear',
    'redo',
    'undo',
]);
const CANCEL_PARAMS = { cancel: true, source: 'api' };
const COMMIT_PARAMS = { cancel: false, source: 'api' };
const CHECK_SIBLING = { checkSiblings: true };
const FORCE_REFRESH = { force: true, suppressFlash: true };
class EditService extends beanStub_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'editSvc';
        this.batch = false;
        this.stopping = false;
        this.committing = false;
    }
    postConstruct() {
        const { beans } = this;
        this.model = beans.editModelSvc;
        this.valueSvc = beans.valueSvc;
        this.rangeSvc = beans.rangeSvc;
        this.addManagedPropertyListener('editType', ({ currentValue }) => {
            this.stopEditing(undefined, CANCEL_PARAMS);
            // will re-create if different
            this.createStrategy(currentValue);
        });
        const handler = (0, refresh_1._refreshEditCells)(beans);
        const stopInvalidEdits = () => {
            const hasCellValidation = this.model.getCellValidationModel().getCellValidationMap().size > 0;
            const hasRowValidation = this.model.getRowValidationModel().getRowValidationMap().size > 0;
            if (hasCellValidation || hasRowValidation) {
                this.stopEditing(undefined, CANCEL_PARAMS);
            }
            else {
                if (this.isEditing()) {
                    if (this.isBatchEditing()) {
                        (0, editors_1._destroyEditors)(beans, this.model.getEditPositions());
                    }
                    else {
                        this.stopEditing(undefined, COMMIT_PARAMS);
                    }
                }
            }
            return false;
        };
        this.addManagedEventListeners({
            columnPinned: handler,
            columnVisible: handler,
            columnRowGroupChanged: handler,
            rowExpansionStateChanged: handler,
            pinnedRowsChanged: handler,
            displayedRowsChanged: handler,
            sortChanged: stopInvalidEdits,
            filterChanged: stopInvalidEdits,
            cellFocused: this.onCellFocused.bind(this),
        });
    }
    isBatchEditing() {
        return this.batch;
    }
    setBatchEditing(enabled) {
        if (enabled) {
            this.batch = true;
            this.stopEditing(undefined, CANCEL_PARAMS);
        }
        else {
            this.stopEditing(undefined, CANCEL_PARAMS);
            this.batch = false;
        }
    }
    createStrategy(editType) {
        const { beans, gos, strategy } = this;
        const name = getEditType(gos, editType);
        if (strategy) {
            if (strategy.beanName === name) {
                return strategy;
            }
            this.destroyStrategy();
        }
        return (this.strategy = this.createOptionalManagedBean(beans.registry.createDynamicBean(name, true)));
    }
    destroyStrategy() {
        if (!this.strategy) {
            return;
        }
        this.strategy.destroy();
        this.strategy = this.destroyBean(this.strategy);
    }
    shouldStartEditing(position, event, cellStartedEdit, source = 'ui') {
        const shouldStart = (0, strategyUtils_1.shouldStartEditing)(this.beans, position, event, cellStartedEdit, source);
        if (shouldStart) {
            this.strategy ?? (this.strategy = this.createStrategy());
        }
        return shouldStart;
    }
    shouldStopEditing(position, event, source = 'ui') {
        return this.strategy?.shouldStop(position, event, source) ?? null;
    }
    shouldCancelEditing(position, event, source = 'ui') {
        return this.strategy?.shouldCancel(position, event, source) ?? null;
    }
    validateEdit() {
        return (0, editors_1._validateEdit)(this.beans);
    }
    isEditing(position, params) {
        return this.model.hasEdits(position, params ?? CHECK_SIBLING);
    }
    isRowEditing(rowNode, params) {
        return (rowNode && this.model.hasRowEdits(rowNode, params)) ?? false;
    }
    /** @returns whether to prevent default on event */
    startEditing(position, params) {
        const { startedEdit = true, event = null, source = 'ui', ignoreEventKey = false, silent } = params;
        this.strategy ?? (this.strategy = this.createStrategy());
        if (!this.isCellEditable(position, 'api')) {
            return;
        }
        // because of async in React, the cellComp may not be set yet, if no cellComp then we are
        // yet to initialise the cell, so we re-schedule this operation for when celLComp is attached
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, position);
        if (cellCtrl && !cellCtrl.comp) {
            cellCtrl.onCompAttachedFuncs.push(() => this.startEditing(position, params));
            return;
        }
        const res = this.shouldStartEditing(position, event, startedEdit, source);
        if (res === false && source !== 'api') {
            this.isEditing(position) && this.stopEditing();
            return;
        }
        if (!this.batch && this.shouldStopEditing(position, undefined, source) && !params.continueEditing) {
            this.stopEditing(undefined, { source });
        }
        if (res && this.isBatchEditing()) {
            this.dispatchBatchEvent('batchEditingStarted', new Map());
        }
        this.strategy.start({
            position,
            event,
            source,
            ignoreEventKey,
            startedEdit,
            silent,
        });
        return;
    }
    stopEditing(position, params) {
        const { event, cancel, source = 'ui', suppressNavigateAfterEdit, forceCancel, forceStop } = params || {};
        const { beans, model } = this;
        if (STOP_EDIT_SOURCE_TRANSFORM_KEYS.has(source)) {
            if (this.isBatchEditing()) {
                // if we are in batch editing, we do not stop editing on paste
                this.bulkRefresh(position);
                return false;
            }
        }
        const treatAsSource = this.committing ? STOP_EDIT_SOURCE_TRANSFORM[source] : source;
        const isEditingOrBatchWithEdits = this.committing ||
            this.isEditing(position) ||
            (this.isBatchEditing() && model.hasEdits(position, CHECK_SIBLING));
        if (!isEditingOrBatchWithEdits || !this.strategy || this.stopping) {
            return false;
        }
        this.stopping = true;
        const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
        if (cellCtrl) {
            cellCtrl.onEditorAttachedFuncs = [];
        }
        let edits = model.getEditMap(true);
        let res = false;
        const willStop = (!cancel &&
            (!!this.shouldStopEditing(position, event, treatAsSource) || (this.committing && !this.batch))) ||
            (forceStop ?? false);
        const willCancel = (cancel && !!this.shouldCancelEditing(position, event, treatAsSource)) || (forceCancel ?? false);
        if (willStop || willCancel) {
            (0, editors_1._syncFromEditors)(beans, { persist: true, isCancelling: willCancel || cancel, isStopping: willStop });
            const freshEdits = model.getEditMap();
            const editsToDelete = this.processEdits(freshEdits, cancel, source);
            this.strategy?.stop(cancel, event);
            // clear any dangling edits, after editor destruction
            editsToDelete.forEach((position) => {
                model.clearEditValue(position);
            });
            this.bulkRefresh(undefined, edits);
            // refresh previously edited cells
            model.getEditPositions(freshEdits).forEach((pos) => {
                const cellCtrl = (0, controllers_1._getCellCtrl)(beans, pos);
                const valueChanged = (0, editors_1._sourceAndPendingDiffer)(pos);
                cellCtrl?.refreshCell({ force: true, suppressFlash: !valueChanged });
            });
            edits = freshEdits;
            res || (res = willStop);
        }
        else if (event instanceof KeyboardEvent &&
            this.batch &&
            this.strategy?.midBatchInputsAllowed(position) &&
            this.isEditing(position, { withOpenEditor: true })) {
            const key = event.key;
            const isEnter = key === keyCode_1.KeyCode.ENTER;
            const isEscape = key === keyCode_1.KeyCode.ESCAPE;
            const isTab = key === keyCode_1.KeyCode.TAB;
            if (isEnter || isTab || isEscape) {
                if (isEnter || isTab) {
                    (0, editors_1._syncFromEditors)(beans, { persist: true });
                }
                else if (isEscape) {
                    // only if ESC is pressed while in the editor for this cell
                    this.revertSingleCellEdit(cellCtrl);
                }
                if (this.isBatchEditing()) {
                    this.strategy?.cleanupEditors();
                }
                else {
                    (0, editors_1._destroyEditors)(beans, model.getEditPositions(), { event, cancel: isEscape });
                }
                event.preventDefault();
                this.bulkRefresh(position, edits, { suppressFlash: true });
                edits = model.getEditMap();
            }
        }
        else {
            (0, editors_1._syncFromEditors)(beans, { persist: true });
            edits = model.getEditMap();
        }
        if (res && position) {
            this.model.removeEdits(position);
        }
        // Suppress navigation is required for bulk activities like pasting or fill handle via setDataValue,
        // otherwise navigateAfterEdit will cause the grid to redundantly scan for the next available cell
        // to edit, which causes focus and rendering changes, for each cell in the bulk operation
        if (!suppressNavigateAfterEdit && cellCtrl) {
            this.navigateAfterEdit(event instanceof KeyboardEvent && event.shiftKey, cellCtrl.cellPosition);
        }
        (0, editors_1._purgeUnchangedEdits)(beans);
        if (!this.model.hasEdits()) {
            this.model.getCellValidationModel().clearCellValidationMap();
            this.model.getRowValidationModel().clearRowValidationMap();
        }
        this.bulkRefresh();
        if (willCancel) {
            // if we cancelled the edit, we need to refresh the rows to remove the pending value and editing styles
            this.beans.rowRenderer.refreshRows({ rowNodes: Array.from(edits.keys()) });
        }
        if (this.isBatchEditing()) {
            this.beans.rowRenderer.refreshRows({ suppressFlash: true, force: true });
            if (res && willStop) {
                this.dispatchBatchEvent('batchEditingStopped', edits);
            }
        }
        this.stopping = false;
        return res;
    }
    navigateAfterEdit(shiftKey, cellPosition) {
        const navAfterEdit = this.gos.get('enterNavigatesVerticallyAfterEdit');
        if (navAfterEdit) {
            const key = shiftKey ? keyCode_1.KeyCode.UP : keyCode_1.KeyCode.DOWN;
            this.beans.navigation?.navigateToNextCell(null, key, cellPosition, false);
        }
    }
    processEdits(edits, cancel = false, source) {
        const rowNodes = Array.from(edits.keys());
        const hasValidationErrors = this.model.getCellValidationModel().getCellValidationMap().size > 0 ||
            this.model.getRowValidationModel().getRowValidationMap().size > 0;
        const editsToDelete = [];
        for (const rowNode of rowNodes) {
            const editRow = edits.get(rowNode);
            for (const column of editRow.keys()) {
                const editValue = editRow.get(column);
                const position = { rowNode, column };
                const valueChanged = (0, editors_1._sourceAndPendingDiffer)(editValue);
                if (!cancel && valueChanged && !hasValidationErrors) {
                    const success = this.setNodeDataValue(rowNode, column, editValue.pendingValue, undefined, source);
                    if (!success) {
                        editsToDelete.push(position);
                    }
                }
            }
        }
        return editsToDelete;
    }
    setNodeDataValue(rowNode, column, newValue, refreshCell, originalSource = 'edit') {
        const { beans } = this;
        const cellCtrl = (0, controllers_1._getCellCtrl)(beans, { rowNode, column });
        const translatedSource = INTERNAL_EDITOR_SOURCES.has(originalSource) ? 'edit' : originalSource;
        // we suppressRefreshCell because the call to rowNode.setDataValue() results in change detection
        // getting triggered, which results in all cells getting refreshed. we do not want this refresh
        // to happen on this call as we want to call it explicitly below. otherwise refresh gets called twice.
        // if we only did this refresh (and not the one below) then the cell would flash and not be forced.
        if (cellCtrl) {
            cellCtrl.suppressRefreshCell = true;
        }
        this.commitNextEdit();
        const success = rowNode.setDataValue(column, newValue, translatedSource);
        if (cellCtrl) {
            cellCtrl.suppressRefreshCell = false;
        }
        if (refreshCell) {
            cellCtrl?.refreshCell(FORCE_REFRESH);
        }
        return success;
    }
    setEditMap(edits, params) {
        this.strategy ?? (this.strategy = this.createStrategy());
        this.strategy?.setEditMap(edits, params);
        this.bulkRefresh();
        // force refresh of all row cells as custom renderers may depend on multiple cell values
        let refreshParams = FORCE_REFRESH;
        if (params?.forceRefreshOfEditCellsOnly) {
            // Only refresh the cells for the current edits
            refreshParams = {
                ...getRowColumnsFromMap(edits),
                ...FORCE_REFRESH,
            };
        }
        this.beans.rowRenderer.refreshCells(refreshParams);
    }
    dispatchEditValuesChanged({ rowNode, column }, edit = {}) {
        if (!rowNode || !column || !edit) {
            return;
        }
        const { pendingValue, sourceValue } = edit;
        const { rowIndex, rowPinned, data } = rowNode;
        this.beans.eventSvc.dispatchEvent({
            type: 'cellEditValuesChanged',
            node: rowNode,
            rowIndex,
            rowPinned,
            column,
            source: 'api',
            data,
            newValue: pendingValue,
            oldValue: sourceValue,
            value: pendingValue,
            colDef: column.getColDef(),
        });
    }
    bulkRefresh(position = {}, editMap, params = {}) {
        const { beans, gos } = this;
        const { editModelSvc, rowModel } = beans;
        if ((0, gridOptionsUtils_1._isClientSideRowModel)(gos, rowModel)) {
            if (position.rowNode && position.column) {
                this.refCell(position, this.model.getEdit(position), params);
            }
            else if (editMap) {
                editModelSvc?.getEditMap(false)?.forEach((editRow, rowNode) => {
                    for (const column of editRow.keys()) {
                        this.refCell({ rowNode, column }, editRow.get(column), params);
                    }
                });
            }
        }
    }
    refCell({ rowNode, column }, edit, params = {}) {
        const { beans, gos } = this;
        const updatedNodes = new Set([rowNode]);
        const refreshNodes = new Set();
        const pinnedSibling = rowNode.pinnedSibling;
        if (pinnedSibling) {
            updatedNodes.add(pinnedSibling);
        }
        const sibling = rowNode.sibling;
        if (sibling) {
            refreshNodes.add(sibling);
        }
        let parent = rowNode.parent;
        while (parent) {
            if (parent.sibling?.footer && gos.get('groupTotalRow')) {
                refreshNodes.add(parent.sibling);
            }
            else if (!parent.parent && parent.sibling && gos.get('grandTotalRow')) {
                refreshNodes.add(parent.sibling);
            }
            else {
                refreshNodes.add(parent);
            }
            parent = parent.parent;
        }
        updatedNodes.forEach((node) => this.dispatchEditValuesChanged({ rowNode: node, column }, edit));
        updatedNodes.forEach((node) => (0, controllers_1._getCellCtrl)(beans, { rowNode: node, column })?.refreshCell(params));
        refreshNodes.forEach((node) => (0, controllers_1._getCellCtrl)(beans, { rowNode: node, column })?.refreshCell(params));
    }
    stopAllEditing(cancel = false, source = 'ui') {
        if (this.isEditing()) {
            this.stopEditing(undefined, { cancel, source });
        }
    }
    isCellEditable(position, source = 'ui') {
        const { rowNode } = position;
        const { gos, beans } = this;
        if (rowNode.group) {
            // This is a group - it could be a tree group or a grouping group...
            if (gos.get('treeData')) {
                // tree - allow editing of groups with data by default.
                // Allow editing filler nodes (node without data) only if enableGroupEdit is true.
                if (!rowNode.data && !gos.get('enableGroupEdit')) {
                    return false;
                }
            }
            else {
                // grouping - allow editing of groups if the user has enableGroupEdit option enabled
                if (!gos.get('enableGroupEdit')) {
                    return false;
                }
            }
        }
        const isEditable = getEditType(gos) === 'fullRow'
            ? (0, strategyUtils_1.isFullRowCellEditable)(beans, position, source)
            : (0, strategyUtils_1.isCellEditable)(beans, position, source);
        if (isEditable) {
            this.strategy ?? (this.strategy = this.createStrategy());
        }
        return isEditable;
    }
    cellEditingInvalidCommitBlocks() {
        return this.gos.get('invalidEditValueMode') === 'block';
    }
    checkNavWithValidation(position, event, focus = true) {
        if (this.hasValidationErrors(position)) {
            const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, position);
            if (this.cellEditingInvalidCommitBlocks()) {
                event?.preventDefault?.();
                if (focus) {
                    !cellCtrl?.hasBrowserFocus() && cellCtrl?.focusCell();
                    cellCtrl?.comp?.getCellEditor()?.focusIn?.();
                }
                return 'block-stop';
            }
            cellCtrl && this.revertSingleCellEdit(cellCtrl);
            return 'revert-continue';
        }
        return 'continue';
    }
    revertSingleCellEdit(cellPosition, focus = false) {
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, cellPosition);
        if (!cellCtrl?.comp?.getCellEditor()) {
            // don't cancel/revert if there is no editor
            return;
        }
        (0, editors_1._destroyEditors)(this.beans, [cellPosition], { silent: true });
        this.model.clearEditValue(cellPosition);
        (0, editors_1._setupEditor)(this.beans, cellPosition, { silent: true });
        (0, editors_1._populateModelValidationErrors)(this.beans);
        cellCtrl?.refreshCell(FORCE_REFRESH);
        // refresh the styles directly rather than through refreshRow as that causes the group cell renderer to
        // be recreated and would discard future mouse click events
        cellCtrl.rowCtrl.rowEditStyleFeature?.applyRowStyles();
        if (!focus) {
            return;
        }
        cellCtrl?.focusCell();
        cellCtrl?.comp?.getCellEditor()?.focusIn?.();
    }
    hasValidationErrors(position) {
        (0, editors_1._populateModelValidationErrors)(this.beans);
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, position);
        if (cellCtrl) {
            cellCtrl.refreshCell(FORCE_REFRESH);
            // refresh the styles directly rather than through refreshRow as that causes the group cell renderer to
            // be recreated and would discard future mouse click events
            cellCtrl.rowCtrl.rowEditStyleFeature?.applyRowStyles();
        }
        let invalid = false;
        if (position?.rowNode) {
            invalid || (invalid = this.model.getRowValidationModel().hasRowValidation({ rowNode: position.rowNode }));
            if (position.column) {
                invalid || (invalid = this.model
                    .getCellValidationModel()
                    .hasCellValidation({ rowNode: position.rowNode, column: position.column }));
            }
        }
        else {
            invalid || (invalid = this.model.getCellValidationModel().getCellValidationMap().size > 0);
            invalid || (invalid = this.model.getRowValidationModel().getRowValidationMap().size > 0);
        }
        return invalid;
    }
    moveToNextCell(prev, backwards, event, source = 'ui') {
        let res;
        const editing = this.isEditing();
        // check for validation errors
        const preventNavigation = editing && this.checkNavWithValidation(undefined, event) === 'block-stop';
        if (prev instanceof cellCtrl_1.CellCtrl && editing) {
            // if we are editing, we know it's not a Full Width Row (RowComp)
            res = this.strategy?.moveToNextEditingCell(prev, backwards, event, source, preventNavigation);
        }
        if (res === null) {
            return res;
        }
        // if a cell wasn't found, it's possible that focus was moved to the header
        res = res || !!this.beans.focusSvc.focusedHeader;
        if (res === false && !preventNavigation) {
            // not a header and not the table
            this.stopEditing();
        }
        return res;
    }
    getCellDataValue({ rowNode, column }, preferEditor = true) {
        if (!rowNode || !column) {
            return undefined;
        }
        let edit = this.model.getEdit({ rowNode, column });
        const pinnedSibling = rowNode.pinnedSibling;
        if (pinnedSibling) {
            const siblingEdit = this.model.getEdit({ rowNode: pinnedSibling, column });
            if (siblingEdit) {
                edit = siblingEdit;
            }
        }
        const newValue = preferEditor ? edit?.editorValue ?? edit?.pendingValue : edit?.pendingValue;
        return newValue === editors_1.UNEDITED || !edit
            ? edit?.sourceValue ?? this.valueSvc.getValue(column, rowNode, false, 'api')
            : newValue;
    }
    addStopEditingWhenGridLosesFocus(viewports) {
        // TODO: find a better place for this
        (0, controllers_1._addStopEditingWhenGridLosesFocus)(this, this.beans, viewports);
    }
    createPopupEditorWrapper(params) {
        // TODO: find a better place for this
        return new popupEditorWrapper_1.PopupEditorWrapper(params);
    }
    commitNextEdit() {
        this.committing = true;
    }
    setDataValue(position, newValue, eventSource) {
        try {
            if ((!this.isEditing() || this.committing) && !SET_DATA_SOURCE_AS_API.has(eventSource)) {
                return;
            }
            const { beans } = this;
            this.strategy ?? (this.strategy = this.createStrategy());
            const source = this.isBatchEditing() ? 'ui' : this.committing ? eventSource ?? 'api' : 'api';
            if (!eventSource || KEEP_EDITOR_SOURCES.has(eventSource)) {
                // editApi or undoRedoApi apply change without involving the editor
                (0, editors_1._syncFromEditor)(beans, position, newValue, eventSource, undefined, { persist: true });
                // a truthy return here indicates the operation succeeded, and if invoked from rowNode.setDataValue, will not result in a cell value change event
                return this.setNodeDataValue(position.rowNode, position.column, newValue, true, eventSource);
            }
            const existing = this.model.getEdit(position);
            if (existing) {
                if (existing.pendingValue === newValue) {
                    return false;
                }
                if (existing.sourceValue !== newValue) {
                    (0, editors_1._syncFromEditor)(beans, position, newValue, eventSource, undefined, { persist: true });
                    this.stopEditing(position, { source: source, suppressNavigateAfterEdit: true });
                    return true;
                }
                if (existing.sourceValue === newValue) {
                    beans.editModelSvc?.removeEdits(position);
                    this.dispatchEditValuesChanged(position, {
                        ...existing,
                        pendingValue: newValue,
                    });
                    return true;
                }
            }
            (0, editors_1._syncFromEditor)(beans, position, newValue, eventSource, undefined, { persist: true });
            this.stopEditing(position, { source: source, suppressNavigateAfterEdit: true });
            return true;
        }
        finally {
            this.committing = false;
        }
    }
    handleColDefChanged(cellCtrl) {
        (0, editors_1._refreshEditorOnColDefChanged)(this.beans, cellCtrl);
    }
    destroy() {
        this.model.clear();
        this.destroyStrategy();
        super.destroy();
    }
    prepDetailsDuringBatch(position, params) {
        if (!this.batch) {
            return;
        }
        const hasEdits = this.model.hasRowEdits(position.rowNode, CHECK_SIBLING);
        if (!hasEdits) {
            return;
        }
        const { rowNode, column } = position;
        const { compDetails, valueToDisplay } = params;
        if (compDetails) {
            const { params } = compDetails;
            params.data = this.model.getEditRowDataValue(rowNode, CHECK_SIBLING);
            return { compDetails };
        }
        const editRow = this.model.getEditRow(position.rowNode, CHECK_SIBLING);
        if (valueToDisplay !== undefined && editRow?.has(column)) {
            return { valueToDisplay: this.valueSvc.getValue(column, rowNode) };
        }
    }
    cleanupEditors() {
        this.strategy?.cleanupEditors();
    }
    dispatchCellEvent(position, event, type, payload) {
        this.strategy?.dispatchCellEvent(position, event, type, payload);
    }
    dispatchBatchEvent(type, edits) {
        this.eventSvc.dispatchEvent(this.createBatchEditEvent(type, edits));
    }
    createBatchEditEvent(type, edits) {
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            type,
            ...(type === 'batchEditingStopped'
                ? {
                    changes: this.toEventChangeList(edits),
                }
                : {}),
        });
    }
    toEventChangeList(edits) {
        return this.model.getEditPositions(edits).map((edit) => ({
            rowIndex: edit.rowNode.rowIndex,
            rowPinned: edit.rowNode.rowPinned,
            columnId: edit.column.getColId(),
            newValue: edit.pendingValue,
            oldValue: edit.sourceValue,
        }));
    }
    applyBulkEdit({ rowNode, column }, ranges) {
        if (!ranges || ranges.length === 0) {
            return;
        }
        const { beans, rangeSvc, valueSvc } = this;
        (0, editors_1._syncFromEditors)(beans, { persist: true });
        const edits = this.model.getEditMap(true);
        const editValue = edits.get(rowNode)?.get(column)?.pendingValue;
        if (!this.batch) {
            // bulk edits occurring during batch are handled as a batch set of changes
            this.eventSvc.dispatchEvent({ type: 'bulkEditingStarted' });
        }
        ranges.forEach((range) => {
            rangeSvc?.forEachRowInRange(range, (position) => {
                const rowNode = (0, positionUtils_1._getRowNode)(beans, position);
                if (rowNode === undefined) {
                    return;
                }
                const editRow = edits.get(rowNode) ?? new Map();
                for (const column of range.columns) {
                    if (!column) {
                        continue;
                    }
                    if (this.isCellEditable({ rowNode, column }, 'api')) {
                        const sourceValue = valueSvc.getValue(column, rowNode, true, 'api');
                        let pendingValue = valueSvc.parseValue(column, rowNode ?? null, editValue, sourceValue);
                        if (Number.isNaN(pendingValue)) {
                            // non-number was bulk edited into a number column
                            pendingValue = null;
                        }
                        editRow.set(column, {
                            editorValue: undefined,
                            pendingValue,
                            sourceValue,
                            state: 'changed',
                            editorState: {
                                isCancelAfterEnd: undefined,
                                isCancelBeforeStart: undefined,
                            },
                        });
                    }
                }
                if (editRow.size > 0) {
                    edits.set(rowNode, editRow);
                }
            });
            this.setEditMap(edits);
            if (this.batch) {
                this.cleanupEditors();
                (0, editors_1._purgeUnchangedEdits)(beans);
                // force refresh of all row cells as custom renderers may depend on multiple cell values
                this.bulkRefresh();
                return;
            }
            this.commitNextEdit();
            this.stopEditing(undefined, { source: 'bulk' });
            this.eventSvc.dispatchEvent({ type: 'bulkEditingStopped', changes: this.toEventChangeList(edits) });
        });
        this.bulkRefresh();
        // focus the first cell in the range
        const cellCtrl = (0, controllers_1._getCellCtrl)(beans, { rowNode, column });
        if (cellCtrl) {
            cellCtrl.focusCell(true);
        }
    }
    createCellStyleFeature(cellCtrl, beans) {
        return new cellEditStyleFeature_1.CellEditStyleFeature(cellCtrl, beans);
    }
    createRowStyleFeature(rowCtrl, beans) {
        return new rowEditStyleFeature_1.RowEditStyleFeature(rowCtrl, beans);
    }
    setEditingCells(cells, params) {
        const { beans } = this;
        const { colModel, valueSvc } = beans;
        const edits = new Map();
        cells.forEach(({ colId, column, colKey, rowIndex, rowPinned, newValue: pendingValue, state }) => {
            const col = colId ? colModel.getCol(colId) : colKey ? colModel.getCol(colKey) : column;
            if (!col) {
                return;
            }
            const rowNode = (0, positionUtils_1._getRowNode)(beans, { rowIndex, rowPinned });
            if (!rowNode) {
                return;
            }
            const sourceValue = valueSvc.getValue(col, rowNode, true, 'api');
            if (!params?.forceRefreshOfEditCellsOnly &&
                !(0, editors_1._sourceAndPendingDiffer)({ pendingValue, sourceValue }) &&
                state !== 'editing') {
                // If the new value is the same as the old value, we don't need to update
                // Unless forceRefreshOfEditCellsOnly is true, in which case we don't short-circuit
                return;
            }
            let editRow = edits.get(rowNode);
            if (!editRow) {
                editRow = new Map();
                edits.set(rowNode, editRow);
            }
            // translate undefined to unedited, don't translate null as that means cell was cleared
            if (pendingValue === undefined) {
                pendingValue = editors_1.UNEDITED;
            }
            editRow.set(col, {
                editorValue: undefined,
                pendingValue,
                sourceValue,
                state: state ?? 'changed',
                editorState: {
                    isCancelAfterEnd: undefined,
                    isCancelBeforeStart: undefined,
                },
            });
        });
        this.setEditMap(edits, params);
    }
    onCellFocused(event) {
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, event);
        if (!cellCtrl || !this.isEditing(cellCtrl, CHECK_SIBLING)) {
            return;
        }
        const edit = this.model.getEdit(cellCtrl);
        if (!edit || !(0, editors_1._sourceAndPendingDiffer)(edit)) {
            return;
        }
        const translate = this.getLocaleTextFunc();
        const label = translate('ariaPendingChange', 'Pending Change');
        this.beans.ariaAnnounce?.announceValue(label, 'pendingChange');
    }
    allowedFocusTargetOnValidation(cellPosition) {
        return (0, controllers_1._getCellCtrl)(this.beans, cellPosition);
    }
}
exports.EditService = EditService;
function getRowColumnsFromMap(edits) {
    return {
        rowNodes: edits ? Array.from(edits.keys()) : undefined,
        columns: edits
            ? [...new Set(Array.from(edits.values()).flatMap((er) => Array.from(er.keys())))]
            : undefined,
    };
}
function getEditType(gos, editType) {
    return editType ?? gos.get('editType') ?? 'singleCell';
}


/***/ }),

/***/ 13448:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseEditStrategy = void 0;
const keyCode_1 = __webpack_require__(59926);
const beanStub_1 = __webpack_require__(68731);
const positionUtils_1 = __webpack_require__(6257);
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(78994);
class BaseEditStrategy extends beanStub_1.BeanStub {
    postConstruct() {
        this.model = this.beans.editModelSvc;
        this.editSvc = this.beans.editSvc;
        this.addManagedEventListeners({
            cellFocused: this.onCellFocusChanged?.bind(this),
            cellFocusCleared: this.onCellFocusChanged?.bind(this),
        });
    }
    clearEdits(position) {
        this.model.clearEditValue(position);
    }
    onCellFocusChanged(event) {
        let cellCtrl;
        const previous = event['previousParams'];
        const { editSvc, beans } = this;
        const sourceEvent = event.type === 'cellFocused' ? event.sourceEvent : null;
        if (previous) {
            cellCtrl = (0, controllers_1._getCellCtrl)(beans, previous);
        }
        const { gos, editModelSvc } = beans;
        const isFocusCleared = event.type === 'cellFocusCleared';
        // check if any editors open
        if (editSvc.isEditing(undefined, { withOpenEditor: true })) {
            // if focus is clearing, we should stop editing
            // or cancel the editing if `block` and `hasErrors`
            const { column, rowIndex, rowPinned } = event;
            const cellPositionFromEvent = {
                column: column,
                rowNode: (0, positionUtils_1._getRowNode)(beans, { rowIndex: rowIndex, rowPinned }),
            };
            const isBlock = gos.get('invalidEditValueMode') === 'block';
            if (isBlock) {
                // if we are blocking on invalid edits, focus changes don't stop current editing
                return;
            }
            const shouldRevert = !isBlock;
            const hasError = !!editModelSvc?.getCellValidationModel().hasCellValidation(cellPositionFromEvent);
            const shouldCancel = shouldRevert && hasError;
            // if we don't have a previous cell, we don't need to force stopEditing
            const result = previous || isFocusCleared
                ? editSvc.stopEditing(undefined, {
                    cancel: shouldCancel,
                    source: isFocusCleared && shouldRevert ? 'api' : undefined,
                    event: sourceEvent,
                })
                : true;
            // editSvc didn't handle the stopEditing, we need to do more ourselves
            if (!result) {
                if (editSvc.isBatchEditing()) {
                    // close editors, but don't stop editing in batch mode
                    editSvc.cleanupEditors();
                }
                else {
                    // if not batch editing, then we stop editing the cell
                    editSvc.stopEditing(undefined, { source: 'api' });
                }
            }
        }
        cellCtrl?.refreshCell({ suppressFlash: true, force: true });
    }
    stop(cancel, event) {
        const editingCells = this.model.getEditPositions();
        const results = { all: [], pass: [], fail: [] };
        editingCells.forEach((cell) => {
            results.all.push(cell);
            const validation = this.model.getCellValidationModel().getCellValidation(cell);
            // check if the cell is valid
            if ((validation?.errorMessages?.length ?? 0) > 0) {
                results.fail.push(cell);
                return;
            }
            results.pass.push(cell);
        });
        if (cancel) {
            editingCells.forEach((cell) => {
                (0, editors_1._destroyEditor)(this.beans, cell, { cancel });
                this.model.stop(cell);
            });
            return true;
        }
        const actions = this.processValidationResults(results);
        if (actions.destroy.length > 0) {
            actions.destroy.forEach((cell) => {
                (0, editors_1._destroyEditor)(this.beans, cell, { event, cancel });
                this.model.stop(cell);
            });
        }
        if (actions.keep.length > 0) {
            actions.keep.forEach((cell) => {
                const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, cell);
                if (!this.editSvc?.cellEditingInvalidCommitBlocks()) {
                    cellCtrl && this.editSvc.revertSingleCellEdit(cellCtrl);
                }
            });
        }
        return true;
    }
    cleanupEditors({ rowNode } = {}, includeEditing) {
        (0, editors_1._syncFromEditors)(this.beans, { persist: false });
        const positions = this.model.getEditPositions();
        const discard = [];
        if (rowNode) {
            positions.forEach((pos) => {
                // if the rowNode is provided, we only keep positions that match it
                if (!(!rowNode || pos.rowNode === rowNode)) {
                    discard.push(pos);
                }
            });
        }
        else {
            positions.forEach((pos) => {
                // if no rowNode is provided, we keep all positions
                discard.push(pos);
            });
        }
        // clean up any dangling editors
        (0, editors_1._destroyEditors)(this.beans, discard);
        (0, editors_1._purgeUnchangedEdits)(this.beans, includeEditing);
    }
    setFocusOutOnEditor(cellCtrl) {
        cellCtrl.comp?.getCellEditor()?.focusOut?.();
    }
    setFocusInOnEditor(cellCtrl) {
        const comp = cellCtrl.comp;
        const editor = comp?.getCellEditor();
        if (editor?.focusIn) {
            // if the editor is present, then we just focus it
            editor.focusIn();
        }
        else {
            // if the editor is not present, it means async cell editor (e.g. React)
            // and we are trying to set focus before the cell editor is present, so we
            // focus the cell instead
            const isFullRow = this.beans.gos.get('editType') === 'fullRow';
            cellCtrl.focusCell(isFullRow);
            cellCtrl.onEditorAttachedFuncs.push(() => comp?.getCellEditor()?.focusIn?.());
        }
    }
    setupEditors(params) {
        const { event, ignoreEventKey = false, startedEdit, position, cells = this.model.getEditPositions() } = params;
        const key = (event instanceof KeyboardEvent && !ignoreEventKey && event.key) || undefined;
        (0, editors_1._setupEditors)(this.beans, cells, position, key, event, startedEdit);
    }
    dispatchCellEvent(position, event, type, payload) {
        const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, position);
        if (cellCtrl) {
            this.eventSvc.dispatchEvent({ ...cellCtrl.createEvent(event ?? null, type), ...payload });
        }
    }
    dispatchRowEvent(position, type, silent) {
        if (silent) {
            return;
        }
        const rowCtrl = (0, controllers_1._getRowCtrl)(this.beans, position);
        if (rowCtrl) {
            this.eventSvc.dispatchEvent(rowCtrl.createRowEvent(type));
        }
    }
    shouldStop(_position, event, source = 'ui') {
        const batch = this.editSvc.isBatchEditing();
        if (batch && source === 'api') {
            // we always defer to the API
            return true;
        }
        if (batch && (source === 'ui' || source === 'edit')) {
            // we always defer to the UI
            return false;
        }
        if (source === 'api') {
            return true;
        }
        if (event instanceof KeyboardEvent && !batch) {
            return event.key === keyCode_1.KeyCode.ENTER;
        }
        return null;
    }
    shouldCancel(_position, event, source = 'ui') {
        const batch = this.editSvc.isBatchEditing();
        if (event instanceof KeyboardEvent && !batch) {
            const result = event.key === keyCode_1.KeyCode.ESCAPE;
            if (result) {
                return true;
            }
        }
        if (batch && source === 'api') {
            // we always defer to the API
            return true;
        }
        if (source === 'api') {
            return true;
        }
        return false;
    }
    setEditMap(edits, params) {
        if (!params?.update) {
            this.editSvc.stopEditing(undefined, { cancel: true, source: 'api' });
        }
        // Identify incoming editing cells
        const cells = [];
        edits.forEach((editRow, rowNode) => {
            editRow.forEach((cellData, column) => {
                if (cellData.state === 'editing') {
                    cells.push({ ...cellData, rowNode, column });
                }
            });
        });
        if (params?.update) {
            edits = new Map([...this.model.getEditMap(), ...edits]);
        }
        this.model?.setEditMap(edits);
        if (cells.length > 0) {
            const position = cells.at(-1);
            const key = position.pendingValue === editors_1.UNEDITED ? undefined : position.pendingValue;
            this.start({ position, event: new KeyboardEvent('keydown', { key }), source: 'api' });
            const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, position);
            if (cellCtrl) {
                this.setFocusInOnEditor(cellCtrl);
            }
        }
    }
    destroy() {
        this.cleanupEditors();
        super.destroy();
    }
}
exports.BaseEditStrategy = BaseEditStrategy;


/***/ }),

/***/ 40104:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FullRowEditStrategy = void 0;
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(78994);
const baseEditStrategy_1 = __webpack_require__(13448);
class FullRowEditStrategy extends baseEditStrategy_1.BaseEditStrategy {
    constructor() {
        super(...arguments);
        this.beanName = 'fullRow';
        this.startedRows = [];
    }
    shouldStop(position, event, _source = 'ui') {
        const { rowNode } = position || {};
        const oldRowCtrl = (0, controllers_1._getRowCtrl)(this.beans, {
            rowNode: this.rowNode,
        });
        if (!oldRowCtrl) {
            return true;
        }
        const res = super.shouldStop({ rowNode: this.rowNode }, event, _source);
        if (res !== null) {
            return res;
        }
        if (!this.rowNode) {
            return false;
        }
        // stop editing if we've changed rows
        return rowNode !== this.rowNode;
    }
    midBatchInputsAllowed({ rowNode }) {
        if (!rowNode) {
            return false;
        }
        return this.model.hasEdits({ rowNode });
    }
    clearEdits(position) {
        this.model.clearEditValue(position);
    }
    start(params) {
        const { position, silent, startedEdit, event, ignoreEventKey } = params;
        const { rowNode } = position;
        if (this.rowNode !== rowNode) {
            super.cleanupEditors(position);
        }
        this.dispatchRowEvent({ rowNode }, 'rowEditingStarted', silent);
        this.startedRows.push(rowNode);
        const columns = this.beans.visibleCols.allCols;
        const cells = [];
        columns.forEach((column) => {
            if (!column.isCellEditable(rowNode)) {
                return;
            }
            const position = {
                rowNode,
                column,
            };
            cells.push(position);
            if (!this.model.hasEdits(position)) {
                this.model.start(position);
            }
        });
        this.rowNode = rowNode;
        this.setupEditors({ cells, position, startedEdit, event, ignoreEventKey });
    }
    processValidationResults(results) {
        const anyFailed = results.fail.length > 0;
        // if any of the cells failed, keep those editors
        if (anyFailed && this.editSvc.cellEditingInvalidCommitBlocks()) {
            return {
                destroy: [],
                keep: results.all,
            };
        }
        // if no cells failed, we destroy all editors
        return {
            destroy: results.all,
            keep: [],
        };
    }
    stop(cancel, event) {
        const { rowNode } = this;
        if (rowNode && !this.model.hasRowEdits(rowNode)) {
            return false;
        }
        const changedRows = [];
        if (!cancel) {
            this.model.getEditMap().forEach((rowEdits, rowNode) => {
                if (!rowEdits || rowEdits.size === 0) {
                    return;
                }
                for (const edit of rowEdits.values()) {
                    if ((0, editors_1._sourceAndPendingDiffer)(edit)) {
                        changedRows.push(rowNode);
                        // early return, we only need to know if there are any edits
                        break;
                    }
                }
            });
        }
        // rerun validation, new values might have triggered row validations
        (0, editors_1._populateModelValidationErrors)(this.beans);
        if (!cancel && this.editSvc?.checkNavWithValidation({ rowNode }) === 'block-stop') {
            return false;
        }
        super.stop(cancel, event);
        changedRows.forEach((rowNode) => this.dispatchRowEvent({ rowNode }, 'rowValueChanged'));
        this.cleanupEditors({ rowNode }, true);
        this.rowNode = undefined;
        return true;
    }
    onCellFocusChanged(event) {
        const { rowIndex } = event;
        const prev = event['previousParams'];
        if (prev?.rowIndex === rowIndex || event.sourceEvent instanceof KeyboardEvent) {
            return;
        }
        const prevCell = (0, controllers_1._getCellCtrl)(this.beans, prev);
        const isBlock = this.gos.get('invalidEditValueMode') === 'block';
        if (isBlock &&
            prevCell &&
            (this.model.getCellValidationModel().getCellValidation(prevCell) ||
                this.model.getRowValidationModel().getRowValidation(prevCell))) {
            return;
        }
        super.onCellFocusChanged(event);
    }
    cleanupEditors(position = {}, includeEditing) {
        super.cleanupEditors(position, includeEditing);
        this.startedRows.forEach((rowNode) => this.dispatchRowEvent({ rowNode }, 'rowEditingStopped'));
        this.startedRows.length = 0;
    }
    // returns null if no navigation should be performed
    moveToNextEditingCell(prevCell, backwards, event, source = 'ui', preventNavigation = false) {
        const prevPos = prevCell.cellPosition;
        // find the next cell to start editing
        let nextCell;
        // fineNextCell in fullRow mode causes CellComps to initialise editors, this is
        // undesirable so we suspend the model while we find the next cell.
        this.model.suspend(true);
        try {
            nextCell = this.beans.navigation?.findNextCellToFocusOn(prevPos, {
                backwards,
                startEditing: true,
                // Default behaviour for fullRow is skip to the next cell,
                // editable or not. FullRow editing might have some editable
                // and some not editable cells in the row.
                // More complex logic needed to skip to the
                // next FullRow editable cell,
                skipToNextEditableCell: false,
            });
        }
        finally {
            this.model.suspend(false);
        }
        if (nextCell === false) {
            return null;
        }
        if (nextCell == null) {
            return false;
        }
        const nextPos = nextCell.cellPosition;
        const prevEditable = prevCell.isCellEditable();
        const nextEditable = nextCell.isCellEditable();
        const rowsMatch = nextPos && prevPos.rowIndex === nextPos.rowIndex && prevPos.rowPinned === nextPos.rowPinned;
        if (prevEditable) {
            this.setFocusOutOnEditor(prevCell);
        }
        this.restoreEditors();
        const suppressStartEditOnTab = this.gos.get('suppressStartEditOnTab');
        if (nextEditable && !preventNavigation) {
            if (suppressStartEditOnTab) {
                nextCell.focusCell(true, event);
            }
            else {
                if (!nextCell.comp?.getCellEditor()) {
                    // editor missing because it was outside the viewport during creating phase,
                    // create it now
                    (0, editors_1._setupEditor)(this.beans, nextCell, { event, cellStartedEdit: true });
                }
                this.setFocusInOnEditor(nextCell);
                nextCell.focusCell(false, event);
            }
        }
        else {
            if (nextEditable && preventNavigation) {
                this.setFocusInOnEditor(nextCell);
            }
            nextCell.focusCell(true, event);
        }
        if (!rowsMatch && !preventNavigation) {
            this.editSvc?.stopEditing({ rowNode: prevCell.rowNode }, { event });
            this.cleanupEditors(nextCell, true);
            if (suppressStartEditOnTab) {
                nextCell.focusCell(true, event);
            }
            else {
                this.editSvc.startEditing(nextCell, { startedEdit: true, event, source, ignoreEventKey: true });
            }
        }
        prevCell.rowCtrl?.refreshRow({ suppressFlash: true, force: true });
        return true;
    }
    restoreEditors() {
        // check all cells that should have an editor have one - in the case of small viewports,
        // editors might have been destroyed along with their corresponding cellCtrl
        this.model.getEditMap().forEach((rowEdits, rowNode) => rowEdits.forEach(({ state }, column) => {
            if (state !== 'editing') {
                return;
            }
            const cellCtrl = (0, controllers_1._getCellCtrl)(this.beans, {
                rowNode,
                column,
            });
            if (cellCtrl && !cellCtrl.comp?.getCellEditor()) {
                (0, editors_1._setupEditor)(this.beans, cellCtrl, { silent: true });
            }
        }));
    }
    destroy() {
        super.destroy();
        this.rowNode = undefined;
        this.startedRows.length = 0;
    }
}
exports.FullRowEditStrategy = FullRowEditStrategy;


/***/ }),

/***/ 30149:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SingleCellEditStrategy = void 0;
const positionUtils_1 = __webpack_require__(6257);
const controllers_1 = __webpack_require__(1081);
const editors_1 = __webpack_require__(78994);
const baseEditStrategy_1 = __webpack_require__(13448);
class SingleCellEditStrategy extends baseEditStrategy_1.BaseEditStrategy {
    constructor() {
        super(...arguments);
        this.beanName = 'singleCell';
    }
    shouldStop(position, event, source = 'ui') {
        const res = super.shouldStop(position, event, source);
        if (res !== null) {
            return res;
        }
        const { rowNode, column } = position || {};
        if ((!this.rowNode || !this.column) && rowNode && column) {
            return null;
        }
        return this.rowNode !== rowNode || this.column !== column;
    }
    midBatchInputsAllowed(position) {
        return this.model.hasEdits(position);
    }
    start(params) {
        const { position, startedEdit, event, ignoreEventKey } = params;
        if (this.rowNode !== position.rowNode || this.column !== position.column) {
            super.cleanupEditors();
        }
        this.rowNode = position.rowNode;
        this.column = position.column;
        this.model.start(position);
        this.setupEditors({ cells: [position], position, startedEdit, event, ignoreEventKey });
    }
    dispatchRowEvent(_position, _type, _silent) {
        // NOP - single cell edit strategy does not dispatch row events
    }
    processValidationResults(results) {
        const anyFailed = results.fail.length > 0;
        // if any of the cells failed, keep those editors
        if (anyFailed && this.editSvc.cellEditingInvalidCommitBlocks()) {
            return {
                destroy: [],
                keep: results.all,
            };
        }
        // if no cells failed, we destroy all editors
        return {
            destroy: results.all,
            keep: [],
        };
    }
    stop(cancel, event) {
        super.stop(cancel, event);
        this.rowNode = undefined;
        this.column = undefined;
        return true;
    }
    onCellFocusChanged(event) {
        const { colModel, editSvc } = this.beans;
        const { rowIndex, column, rowPinned } = event;
        const rowNode = (0, positionUtils_1._getRowNode)(this.beans, { rowIndex: rowIndex, rowPinned });
        const curColId = (0, controllers_1._getColId)(column);
        const curCol = colModel.getCol(curColId);
        const previous = event['previousParams'];
        if (previous) {
            const prevColId = (0, controllers_1._getColId)(previous.column);
            if (previous?.rowIndex === rowIndex && prevColId === curColId && previous?.rowPinned === rowPinned) {
                return;
            }
        }
        if (editSvc?.isEditing({ rowNode, column: curCol }, { withOpenEditor: true }) &&
            event.type === 'cellFocused') {
            // editor is already active, so we don't need to do anything
            return;
        }
        super.onCellFocusChanged(event);
    }
    // returns null if no navigation should be performed
    moveToNextEditingCell(prevCell, backwards, event, source = 'ui', preventNavigation = false) {
        const focusedCell = this.beans.focusSvc.getFocusedCell();
        if (focusedCell) {
            // When we're tabbing into a virtualised column in an async setting,
            // prevCell should be the same as focused Cell, but isn't.
            // Force lookup of the cell.
            // We can only enter moveToNextEditingCell from a keyboard event
            // on a focused cell so this is safe to assume
            prevCell = (0, positionUtils_1._getCellByPosition)(this.beans, focusedCell) ?? prevCell;
        }
        const prevPos = prevCell.cellPosition;
        // find the next cell to start editing
        let nextCell;
        const shouldSuspend = this.beans.gos.get('editType') === 'fullRow';
        if (shouldSuspend) {
            // fineNextCell in fullRow mode causes CellComps to initialise editors, this is
            // undesirable so we suspend the model while we find the next cell.
            this.model.suspend(true);
        }
        if (!preventNavigation) {
            // before we stop editing, we need to focus the cell element
            // so the grid doesn't detect that focus has left the grid
            prevCell.eGui.focus();
            // need to do this before getting next cell to edit, in case the next cell
            // has editable function (eg colDef.editable=func() ) and it depends on the
            // result of this cell, so need to save updates from the first edit, in case
            // the value is referenced in the function.
            this.editSvc?.stopEditing(prevCell, { source: this.editSvc?.isBatchEditing() ? 'ui' : 'api', event });
        }
        try {
            nextCell = this.beans.navigation?.findNextCellToFocusOn(prevPos, {
                backwards,
                startEditing: true,
                // Default behaviour for fullRow is skip to the next cell,
                // editable or not. FullRow editing might have some editable
                // and some not editable cells in the row.
                // More complex logic needed to skip to the
                // next FullRow editable cell,
                // skipToNextEditableCell: false,
            });
        }
        finally {
            if (shouldSuspend) {
                this.model.suspend(false);
            }
        }
        if (nextCell === false) {
            return null;
        }
        if (nextCell == null) {
            return false;
        }
        const nextPos = nextCell.cellPosition;
        const prevEditable = prevCell.isCellEditable();
        const nextEditable = nextCell.isCellEditable();
        const rowsMatch = nextPos && prevPos.rowIndex === nextPos.rowIndex && prevPos.rowPinned === nextPos.rowPinned;
        if (prevEditable && !preventNavigation) {
            this.setFocusOutOnEditor(prevCell);
        }
        // Don't start editing the next cell, focus only
        const suppressStartEditOnTab = this.gos.get('suppressStartEditOnTab');
        if (!rowsMatch && !preventNavigation) {
            super.cleanupEditors(nextCell, true);
            if (suppressStartEditOnTab) {
                nextCell.focusCell(true, event);
            }
            else {
                this.editSvc.startEditing(nextCell, { startedEdit: true, event, source, ignoreEventKey: true });
            }
        }
        if (nextEditable && !preventNavigation) {
            // need to focus the cell before setting the editor, otherwise the focus handler won't cause previous editor cleanups
            nextCell.focusCell(false, event);
            if (suppressStartEditOnTab) {
                nextCell.focusCell(true, event);
            }
            else if (!nextCell.comp?.getCellEditor()) {
                // Two possibilities:
                // * Editor should be visible (but was destroyed due to column virtualisation)
                //   = we shouldn't re-emit a startEdit event, so stay silent
                // * Editor wasn't created because edit came from API and didn't trigger EditService.startEditing
                //   = shouldn't be silent
                const alreadyEditing = this.editSvc?.isEditing(nextCell, { withOpenEditor: true });
                (0, editors_1._setupEditor)(this.beans, nextCell, { event, cellStartedEdit: true, silent: alreadyEditing });
                this.setFocusInOnEditor(nextCell);
                this.cleanupEditors(nextCell);
            }
        }
        else {
            if (nextEditable && preventNavigation) {
                this.setFocusInOnEditor(nextCell);
            }
            nextCell.focusCell(true, event);
        }
        prevCell.rowCtrl?.refreshRow({ suppressFlash: true, force: true });
        return true;
    }
    destroy() {
        super.destroy();
        this.rowNode = undefined;
        this.column = undefined;
    }
}
exports.SingleCellEditStrategy = SingleCellEditStrategy;


/***/ }),

/***/ 86040:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isFullRowCellEditable = exports.isCellEditable = exports.shouldStartEditing = void 0;
const keyCode_1 = __webpack_require__(59926);
/** File is used to contain logic about whether a strategy is required.
 * This enables us to perform editing related checks without the overhead of creating the strategies and their event listeners.
 */
function shouldStartEditing(beans, { column }, event, cellStartedEdit, source = 'ui') {
    if (event instanceof KeyboardEvent &&
        (event.key === keyCode_1.KeyCode.TAB ||
            event.key === keyCode_1.KeyCode.ENTER ||
            event.key === keyCode_1.KeyCode.F2 ||
            (event.key === keyCode_1.KeyCode.BACKSPACE && cellStartedEdit))) {
        return true;
    }
    const extendingRange = event?.shiftKey && beans.rangeSvc?.getCellRanges().length != 0;
    if (extendingRange) {
        return false;
    }
    const colDef = column?.getColDef();
    const clickCount = deriveClickCount(beans.gos, colDef);
    const type = event?.type;
    if (type === 'click' && event?.detail === 1 && clickCount === 1) {
        return true;
    }
    if (type === 'dblclick' && event?.detail === 2 && clickCount === 2) {
        return true;
    }
    if (source === 'api') {
        return cellStartedEdit ?? false;
    }
    return false;
}
exports.shouldStartEditing = shouldStartEditing;
function deriveClickCount(gos, colDef) {
    if (gos.get('suppressClickEdit') === true) {
        return 0;
    }
    if (gos.get('singleClickEdit') === true) {
        return 1;
    }
    if (colDef?.singleClickEdit) {
        return 1;
    }
    return 2;
}
function isCellEditable(beans, { rowNode, column }, _source = 'ui') {
    const editable = column.getColDef().editable;
    const editModelSvc = beans.editModelSvc;
    return (column.isColumnFunc(rowNode, editable) ||
        (!!editModelSvc && editModelSvc.hasEdits({ rowNode, column }, { withOpenEditor: true })));
}
exports.isCellEditable = isCellEditable;
function isFullRowCellEditable(beans, position, source = 'ui') {
    const editable = isCellEditable(beans, position, source);
    if (editable === true || source === 'ui') {
        return editable;
    }
    // check if other cells in row are editable, so starting edit on uneditable cell will still work
    const columns = beans.colModel.getCols();
    return columns.some((col) => isCellEditable(beans, { rowNode: position.rowNode, column: col }, source));
}
exports.isFullRowCellEditable = isFullRowCellEditable;


/***/ }),

/***/ 46904:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CellEditStyleFeature = void 0;
const beanStub_1 = __webpack_require__(68731);
const style_utils_1 = __webpack_require__(89320);
class CellEditStyleFeature extends beanStub_1.BeanStub {
    constructor(cellCtrl, beans) {
        super();
        this.cellCtrl = cellCtrl;
        this.beans = beans;
        this.editSvc = beans.editSvc;
        this.editModelSvc = beans.editModelSvc;
    }
    setComp(comp) {
        this.cellComp = comp;
        this.applyCellStyles();
    }
    applyCellStyles() {
        const { cellCtrl, editSvc, beans } = this;
        if (editSvc?.isBatchEditing() && editSvc.isEditing()) {
            const state = (0, style_utils_1._hasEdits)(beans, cellCtrl) || (0, style_utils_1._hasLeafEdits)(beans, cellCtrl) || (0, style_utils_1._hasPinnedEdits)(beans, cellCtrl);
            this.applyBatchingStyle(state);
        }
        else {
            this.applyBatchingStyle(false);
        }
        const hasErrors = !!this.editModelSvc?.getCellValidationModel().hasCellValidation(this.cellCtrl);
        this.cellComp.toggleCss('ag-cell-editing-error', hasErrors);
    }
    applyBatchingStyle(newState) {
        this.cellComp.toggleCss('ag-cell-editing', newState ?? false);
        this.cellComp.toggleCss('ag-cell-batch-edit', (newState && this.editSvc?.isBatchEditing()) ?? false);
    }
}
exports.CellEditStyleFeature = CellEditStyleFeature;


/***/ }),

/***/ 13536:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RowEditStyleFeature = void 0;
const beanStub_1 = __webpack_require__(68731);
const style_utils_1 = __webpack_require__(89320);
class RowEditStyleFeature extends beanStub_1.BeanStub {
    constructor(rowCtrl, beans) {
        super();
        this.rowCtrl = rowCtrl;
        this.beans = beans;
        this.gos = beans.gos;
        this.editSvc = beans.editSvc;
        this.editModelSvc = beans.editModelSvc;
    }
    applyRowStyles() {
        const { rowCtrl, editModelSvc, beans } = this;
        let rowNode = rowCtrl.rowNode;
        let edits = editModelSvc?.getEditRow(rowNode);
        const hasErrors = this.editModelSvc?.getRowValidationModel().hasRowValidation({ rowNode });
        if (!edits && rowNode.pinnedSibling) {
            rowNode = rowNode.pinnedSibling;
            edits = editModelSvc?.getEditRow(rowNode);
        }
        if (edits) {
            const editing = Array.from(edits.keys()).some((column) => {
                const position = { rowNode, column };
                return ((0, style_utils_1._hasEdits)(beans, position, true) ||
                    (0, style_utils_1._hasLeafEdits)(beans, position) ||
                    (0, style_utils_1._hasPinnedEdits)(beans, position));
            });
            this.applyStyle(hasErrors, editing);
            return;
        }
        this.applyStyle(hasErrors);
    }
    applyStyle(hasErrors = false, editing = false) {
        const batchEdit = this.editSvc?.isBatchEditing() ?? false;
        const fullRow = this.gos.get('editType') === 'fullRow';
        this.rowCtrl?.forEachGui(undefined, ({ rowComp }) => {
            rowComp.toggleCss('ag-row-editing', fullRow && editing);
            rowComp.toggleCss('ag-row-batch-edit', fullRow && editing && batchEdit);
            // required for Material theme
            rowComp.toggleCss('ag-row-inline-editing', editing);
            rowComp.toggleCss('ag-row-not-inline-editing', !editing);
            rowComp.toggleCss('ag-row-editing-invalid', fullRow && editing && hasErrors);
        });
    }
}
exports.RowEditStyleFeature = RowEditStyleFeature;


/***/ }),

/***/ 89320:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._hasPinnedEdits = exports._hasLeafEdits = exports._hasEdits = void 0;
const editors_1 = __webpack_require__(78994);
const editHighlightFn = (edit, includeEditing = false) => {
    if (edit !== undefined) {
        return (0, editors_1._sourceAndPendingDiffer)(edit) || (includeEditing && edit.state === 'editing');
    }
};
function _hasEdits(beans, position, includeEditing = false) {
    return editHighlightFn(beans.editModelSvc?.getEdit(position), includeEditing);
}
exports._hasEdits = _hasEdits;
function _hasLeafEdits(beans, position) {
    const { editModelSvc } = beans;
    const { column, rowNode } = position;
    // if we have group total rows, we should decorate them, rather than agg nodes
    if (beans.gos.get('groupTotalRow') && !rowNode?.footer) {
        return false;
    }
    for (const node of rowNode?.allLeafChildren ?? []) {
        const highlight = editHighlightFn(editModelSvc?.getEdit({ rowNode: node, column })) ||
            editHighlightFn(editModelSvc?.getEdit({ rowNode: node.pinnedSibling, column }));
        if (highlight) {
            return true;
        }
    }
}
exports._hasLeafEdits = _hasLeafEdits;
function _hasPinnedEdits(beans, { rowNode, column }) {
    rowNode = rowNode.pinnedSibling;
    if (!rowNode) {
        return;
    }
    return editHighlightFn(beans.editModelSvc?.getEdit({
        rowNode,
        column,
    }));
}
exports._hasPinnedEdits = _hasPinnedEdits;


/***/ }),

/***/ 1081:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getColId = exports._addStopEditingWhenGridLosesFocus = exports._getCellCtrl = exports._getRowCtrl = void 0;
const browser_1 = __webpack_require__(36916);
const positionUtils_1 = __webpack_require__(6257);
const editors_1 = __webpack_require__(78994);
function _getRowCtrl(beans, inputs = {}) {
    const { rowIndex, rowId, rowCtrl, rowPinned } = inputs;
    if (rowCtrl) {
        return rowCtrl;
    }
    const { rowModel, rowRenderer } = beans;
    let { rowNode } = inputs;
    if (!rowNode) {
        if (rowId) {
            rowNode = (0, positionUtils_1._getRowById)(beans, rowId, rowPinned);
        }
        else if (rowIndex != null) {
            rowNode = rowModel.getRow(rowIndex);
        }
    }
    return rowRenderer.getRowCtrls(rowNode ? [rowNode] : [])?.[0];
}
exports._getRowCtrl = _getRowCtrl;
function _getCellCtrl(beans, inputs = {}) {
    const { cellCtrl, colId, columnId, column } = inputs;
    if (cellCtrl) {
        return cellCtrl;
    }
    const actualColumn = beans.colModel.getCol(colId ?? columnId ?? _getColId(column));
    const rowCtrl = inputs.rowCtrl ?? _getRowCtrl(beans, inputs);
    const result = rowCtrl?.getCellCtrl(actualColumn) ?? undefined;
    if (result) {
        // if we found a cellCtrl, return it
        return result;
    }
    const rowNode = inputs.rowNode ?? rowCtrl?.rowNode;
    if (rowNode) {
        // can occur in spannedRow settings
        return beans.rowRenderer.getCellCtrls([rowNode], [actualColumn])?.[0];
    }
    return undefined;
}
exports._getCellCtrl = _getCellCtrl;
function _stopEditing(beans) {
    const { editSvc } = beans;
    if (editSvc?.isBatchEditing()) {
        (0, editors_1._destroyEditors)(beans);
    }
    else {
        editSvc?.stopEditing(undefined, { source: 'api' });
    }
}
function _addStopEditingWhenGridLosesFocus(bean, beans, viewports) {
    const { gos, popupSvc } = beans;
    if (!gos.get('stopEditingWhenCellsLoseFocus')) {
        return;
    }
    const focusOutListener = (event) => {
        // this is the element the focus is moving to
        const elementWithFocus = event.relatedTarget;
        if ((0, browser_1._getTabIndex)(elementWithFocus) === null) {
            _stopEditing(beans);
            return;
        }
        let clickInsideGrid = 
        // see if click came from inside the viewports
        viewports.some((viewport) => viewport.contains(elementWithFocus)) &&
            // and also that it's not from a detail grid
            gos.isElementInThisInstance(elementWithFocus);
        if (!clickInsideGrid) {
            clickInsideGrid =
                !!popupSvc &&
                    (popupSvc.getActivePopups().some((popup) => popup.contains(elementWithFocus)) ||
                        popupSvc.isElementWithinCustomPopup(elementWithFocus));
        }
        if (!clickInsideGrid) {
            _stopEditing(beans);
        }
    };
    viewports.forEach((viewport) => bean.addManagedElementListeners(viewport, { focusout: focusOutListener }));
}
exports._addStopEditingWhenGridLosesFocus = _addStopEditingWhenGridLosesFocus;
function _getColId(column) {
    if (!column) {
        return undefined;
    }
    if (typeof column === 'string') {
        return column;
    }
    return column.getColId();
}
exports._getColId = _getColId;


/***/ }),

/***/ 78994:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._validateEdit = exports._populateModelValidationErrors = exports._destroyEditor = exports._destroyEditors = exports._syncFromEditor = exports._syncFromEditors = exports._refreshEditorOnColDefChanged = exports._purgeUnchangedEdits = exports._setupEditor = exports._sourceAndPendingDiffer = exports._setupEditors = exports.getCellEditorInstances = exports.UNEDITED = void 0;
const aria_1 = __webpack_require__(91623);
const locale_1 = __webpack_require__(66352);
const unwrapUserComp_1 = __webpack_require__(54126);
const userCompUtils_1 = __webpack_require__(12036);
const gridOptionsUtils_1 = __webpack_require__(67274);
const editModelService_1 = __webpack_require__(68544);
const controllers_1 = __webpack_require__(1081);
exports.UNEDITED = Symbol('unedited');
function getCellEditorInstanceMap(beans, params = {}) {
    const res = [];
    const ctrls = beans.rowRenderer.getCellCtrls(params.rowNodes, params.columns);
    for (const ctrl of ctrls) {
        const cellEditor = ctrl.comp?.getCellEditor();
        if (cellEditor) {
            res.push({
                ctrl,
                editor: (0, unwrapUserComp_1._unwrapUserComp)(cellEditor),
            });
        }
    }
    return res;
}
const getCellEditorInstances = (beans, params = {}) => getCellEditorInstanceMap(beans, params).map((res) => res.editor);
exports.getCellEditorInstances = getCellEditorInstances;
function _setupEditors(beans, editingCells, position, key, event, cellStartedEdit) {
    if (editingCells.length === 0 && position?.rowNode && position?.column) {
        _setupEditor(beans, position, { key, event, cellStartedEdit });
    }
    const { valueSvc, editSvc, editModelSvc } = beans;
    const { rowNode, column } = position ?? {};
    for (const cellPosition of editingCells) {
        const { rowNode: cellRowNode, column: cellColumn } = cellPosition;
        const curCellCtrl = (0, controllers_1._getCellCtrl)(beans, cellPosition);
        if (!curCellCtrl) {
            if (cellRowNode && cellColumn) {
                const oldValue = valueSvc.getValue(cellColumn, cellRowNode, undefined, 'api');
                const isNewValueCell = position?.rowNode === cellRowNode && position?.column === cellColumn;
                const cellStartValue = (isNewValueCell && key) || undefined;
                const newValue = cellStartValue ??
                    editSvc?.getCellDataValue(cellPosition, false) ??
                    valueSvc.getValueForDisplay(cellColumn, cellRowNode)?.value ??
                    oldValue ??
                    exports.UNEDITED;
                editModelSvc?.setEdit(cellPosition, {
                    pendingValue: newValue,
                    sourceValue: oldValue,
                    state: 'editing',
                });
            }
            continue;
        }
        const shouldStartEditing = cellStartedEdit && rowNode === curCellCtrl.rowNode && curCellCtrl.column === column;
        _setupEditor(beans, { rowNode: rowNode, column: curCellCtrl.column }, {
            key: shouldStartEditing ? key : null,
            event: shouldStartEditing ? event : null,
            cellStartedEdit: shouldStartEditing && cellStartedEdit,
        });
    }
    return;
}
exports._setupEditors = _setupEditors;
function _sourceAndPendingDiffer({ pendingValue, sourceValue, }) {
    if (pendingValue === exports.UNEDITED) {
        pendingValue = sourceValue;
    }
    return pendingValue !== sourceValue;
}
exports._sourceAndPendingDiffer = _sourceAndPendingDiffer;
function _setupEditor(beans, position, params) {
    const enableGroupEditing = beans.gos.get('enableGroupEdit');
    const { key, event, cellStartedEdit, silent } = params ?? {};
    const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
    const editorComp = cellCtrl?.comp?.getCellEditor();
    const editorParams = _createEditorParams(beans, position, key, cellStartedEdit && !silent);
    const previousEdit = beans.editModelSvc?.getEdit(position);
    let newValue = editorParams.value;
    if (newValue === undefined) {
        newValue = previousEdit?.sourceValue;
    }
    beans.editModelSvc?.setEdit(position, {
        editorValue: newValue,
        state: 'editing',
    });
    if (editorComp) {
        // don't reinitialise, just refresh if possible
        editorComp.refresh?.(editorParams);
        return;
    }
    const colDef = position.column.getColDef();
    const compDetails = (0, userCompUtils_1._getCellEditorDetails)(beans.userCompFactory, colDef, editorParams);
    // if cellEditorSelector was used, we give preference to popup and popupPosition from the selector
    const popup = compDetails?.popupFromSelector != null ? compDetails.popupFromSelector : !!colDef.cellEditorPopup;
    const popupLocation = compDetails?.popupPositionFromSelector != null
        ? compDetails.popupPositionFromSelector
        : colDef.cellEditorPopupPosition;
    checkAndPreventDefault(compDetails.params, event);
    if (cellCtrl) {
        cellCtrl.editCompDetails = compDetails;
        cellCtrl.comp?.setEditDetails(compDetails, popup, popupLocation, beans.gos.get('reactiveCustomComponents'));
        cellCtrl?.rowCtrl?.refreshRow({ suppressFlash: true });
        const edit = beans.editModelSvc?.getEdit(position, true);
        if (!silent && !edit?.editorState?.cellStartedEditing) {
            beans.editSvc?.dispatchCellEvent(position, event, 'cellEditingStarted', enableGroupEditing ? { value: newValue } : {});
            beans.editModelSvc?.setEdit(position, { editorState: { cellStartedEditing: true } });
        }
    }
    return;
}
exports._setupEditor = _setupEditor;
function _valueFromEditor(beans, cellEditor, params) {
    const noValueResult = { editorValueExists: false };
    if (_hasValidationRules(beans)) {
        const validationErrors = cellEditor.getValidationErrors?.();
        if ((validationErrors?.length ?? 0) > 0) {
            return noValueResult;
        }
    }
    if (params?.isCancelling) {
        return noValueResult;
    }
    if (params?.isStopping) {
        const isCancelAfterEnd = cellEditor?.isCancelAfterEnd?.();
        if (isCancelAfterEnd) {
            return { ...noValueResult, isCancelAfterEnd };
        }
    }
    const editorValue = cellEditor.getValue();
    return {
        editorValue,
        editorValueExists: true,
    };
}
function _createEditorParams(beans, position, key, cellStartedEdit) {
    const { valueSvc, gos, editSvc } = beans;
    const enableGroupEditing = beans.gos.get('enableGroupEdit');
    const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
    const rowIndex = position.rowNode?.rowIndex ?? undefined;
    const batchEdit = editSvc?.isBatchEditing();
    const agColumn = beans.colModel.getCol(position.column.getId());
    const { rowNode, column } = position;
    const editor = cellCtrl.comp?.getCellEditor();
    const initialNewValue = editSvc?.getCellDataValue(position, false) ??
        (editor ? _valueFromEditor(beans, editor)?.editorValue : undefined);
    const value = initialNewValue === exports.UNEDITED ? valueSvc.getValueForDisplay(agColumn, rowNode)?.value : initialNewValue;
    return (0, gridOptionsUtils_1._addGridCommonParams)(gos, {
        value: enableGroupEditing ? initialNewValue : value,
        eventKey: key ?? null,
        column,
        colDef: column.getColDef(),
        rowIndex,
        node: rowNode,
        data: rowNode.data,
        cellStartedEdit: cellStartedEdit ?? false,
        onKeyDown: cellCtrl?.onKeyDown.bind(cellCtrl),
        stopEditing: (suppressNavigateAfterEdit) => {
            editSvc.stopEditing(position, { source: batchEdit ? 'ui' : 'api', suppressNavigateAfterEdit });
            _destroyEditor(beans, position);
        },
        eGridCell: cellCtrl?.eGui,
        parseValue: (newValue) => valueSvc.parseValue(agColumn, rowNode, newValue, cellCtrl?.value),
        formatValue: cellCtrl?.formatValue.bind(cellCtrl),
        validate: () => {
            editSvc?.validateEdit();
        },
    });
}
function _purgeUnchangedEdits(beans, includeEditing) {
    const { editModelSvc } = beans;
    editModelSvc?.getEditMap().forEach((editRow, rowNode) => {
        editRow.forEach((edit, column) => {
            if (!includeEditing && (edit.state === 'editing' || edit.pendingValue === exports.UNEDITED)) {
                return;
            }
            if (!_sourceAndPendingDiffer(edit) && (edit.state !== 'editing' || includeEditing)) {
                // remove edits where the pending is equal to the old value
                editModelSvc?.removeEdits({ rowNode, column });
            }
        });
    });
}
exports._purgeUnchangedEdits = _purgeUnchangedEdits;
function _refreshEditorOnColDefChanged(beans, cellCtrl) {
    const editor = cellCtrl.comp?.getCellEditor();
    if (!editor?.refresh) {
        return;
    }
    const { eventKey, cellStartedEdit } = cellCtrl.editCompDetails.params;
    const { column } = cellCtrl;
    const editorParams = _createEditorParams(beans, cellCtrl, eventKey, cellStartedEdit);
    const colDef = column.getColDef();
    const compDetails = (0, userCompUtils_1._getCellEditorDetails)(beans.userCompFactory, colDef, editorParams);
    editor.refresh(checkAndPreventDefault(compDetails.params, eventKey));
}
exports._refreshEditorOnColDefChanged = _refreshEditorOnColDefChanged;
function checkAndPreventDefault(params, event) {
    if (event instanceof KeyboardEvent && params.column.getColDef().cellEditor === 'agNumberCellEditor') {
        // `-`, `+`, `.`, `e` need suppressPreventDefault to prevent the editor from ignoring the keypress
        params.suppressPreventDefault =
            ['-', '+', '.', 'e'].includes(event?.key ?? '') || params.suppressPreventDefault;
    }
    else {
        event?.preventDefault?.();
    }
    return params;
}
function _syncFromEditors(beans, params) {
    beans.editModelSvc?.getEditPositions().forEach((cellId) => {
        const cellCtrl = (0, controllers_1._getCellCtrl)(beans, cellId);
        if (!cellCtrl) {
            return;
        }
        const editor = cellCtrl.comp?.getCellEditor();
        if (!editor) {
            return;
        }
        const { editorValue, editorValueExists, isCancelAfterEnd } = _valueFromEditor(beans, editor, params);
        if (isCancelAfterEnd) {
            beans.editModelSvc?.setEdit(cellId, { editorState: { isCancelAfterEnd } });
        }
        _syncFromEditor(beans, cellId, editorValue, undefined, !editorValueExists, params);
    });
}
exports._syncFromEditors = _syncFromEditors;
function _syncFromEditor(beans, position, editorValue, _source, valueSameAsSource, params) {
    const { editModelSvc, valueSvc } = beans;
    if (!editModelSvc) {
        return;
    }
    const { rowNode, column } = position;
    if (!(rowNode && column)) {
        return;
    }
    let edit = editModelSvc.getEdit(position, true);
    if (!edit?.sourceValue) {
        // sourceValue not set means sync called without corresponding startEdit - from API call
        edit = editModelSvc.setEdit(position, {
            sourceValue: valueSvc.getValue(column, rowNode, undefined, 'api'),
            pendingValue: edit ? edit.editorValue : exports.UNEDITED,
        });
    }
    // Note: we don't clear the edit state here (even if new===old) as this is also called from the stop editing flow.
    // Note: editorValue should be in the correct target format already, so no need to parse it again - this is done in the editor, via the colDef parseValue function.
    editModelSvc.setEdit(position, {
        editorValue: valueSameAsSource ? edit.sourceValue : editorValue,
    });
    if (params?.persist) {
        _persistEditorValue(beans, position);
    }
}
exports._syncFromEditor = _syncFromEditor;
function _persistEditorValue(beans, position) {
    const { editModelSvc } = beans;
    const edit = editModelSvc?.getEdit(position, true);
    // propagate the editor value to pending.
    editModelSvc?.setEdit(position, {
        pendingValue: edit?.editorValue,
    });
}
function _destroyEditors(beans, edits, params) {
    if (!edits) {
        edits = beans.editModelSvc?.getEditPositions();
    }
    edits.forEach((cellPosition) => _destroyEditor(beans, cellPosition, params));
}
exports._destroyEditors = _destroyEditors;
function _destroyEditor(beans, position, params) {
    const enableGroupEditing = beans.gos.get('enableGroupEdit');
    const { editModelSvc } = beans;
    const cellCtrl = (0, controllers_1._getCellCtrl)(beans, position);
    const edit = editModelSvc?.getEdit(position, true);
    if (!cellCtrl) {
        if (edit) {
            editModelSvc?.setEdit(position, { state: 'changed' });
        }
        return;
    }
    const { comp } = cellCtrl;
    if (comp && !comp.getCellEditor()) {
        // editor already cleaned up, refresh cell
        cellCtrl?.refreshCell();
        if (edit) {
            editModelSvc?.setEdit(position, { state: 'changed' });
            const args = enableGroupEditing
                ? groupEditOverrides(params, edit)
                : {
                    valueChanged: false,
                    newValue: undefined,
                    oldValue: edit.sourceValue,
                };
            dispatchEditingStopped(beans, position, args, params);
        }
        return;
    }
    if (_hasValidationRules(beans)) {
        const errorMessages = comp?.getCellEditor()?.getValidationErrors?.();
        const cellValidationModel = editModelSvc?.getCellValidationModel();
        if (errorMessages?.length) {
            cellValidationModel?.setCellValidation(position, { errorMessages });
        }
        else {
            cellValidationModel?.clearCellValidation(position);
        }
    }
    editModelSvc?.setEdit(position, { state: 'changed' });
    comp?.setEditDetails(); // passing nothing stops editing
    comp?.refreshEditStyles(false, false);
    cellCtrl?.refreshCell({ force: true, suppressFlash: true });
    const latest = editModelSvc?.getEdit(position);
    if (latest && latest.state === 'changed') {
        const args = enableGroupEditing
            ? groupEditOverrides(params, latest)
            : {
                valueChanged: _sourceAndPendingDiffer(latest) && !params?.cancel,
                newValue: params?.cancel || latest.editorState.isCancelAfterEnd
                    ? undefined
                    : latest?.editorValue ?? edit?.pendingValue,
                oldValue: latest?.sourceValue,
            };
        dispatchEditingStopped(beans, position, args, params);
    }
}
exports._destroyEditor = _destroyEditor;
function groupEditOverrides(params, latest) {
    return params?.cancel
        ? {
            valueChanged: false,
            oldValue: latest.sourceValue,
            newValue: undefined,
            value: latest.sourceValue,
        }
        : {
            valueChanged: false,
            oldValue: latest.sourceValue,
            newValue: latest.pendingValue,
            value: latest.sourceValue,
        };
}
function dispatchEditingStopped(beans, position, args, { silent, event } = {}) {
    const { editSvc, editModelSvc } = beans;
    const latest = editModelSvc?.getEdit(position);
    const { editorState } = latest || {};
    const { isCancelBeforeStart } = editorState || {};
    if (!silent && !isCancelBeforeStart) {
        editSvc?.dispatchCellEvent(position, event, 'cellEditingStopped', args);
        editModelSvc?.setEdit(position, { editorState: { cellStoppedEditing: true } });
    }
}
function _hasValidationRules(beans) {
    const { gos, colModel } = beans;
    const getFullRowEditValidationErrors = !!gos.get('getFullRowEditValidationErrors');
    const columnsHaveRules = colModel
        .getColumnDefs()
        ?.filter((c) => c.editable)
        .some(({ cellEditorParams }) => {
        const { minLength, maxLength, getValidationErrors, min, max } = cellEditorParams || {};
        return (minLength !== undefined ||
            maxLength !== undefined ||
            getValidationErrors !== undefined ||
            min !== undefined ||
            max !== undefined);
    });
    const editorsHaveRules = beans.gridApi
        .getCellEditorInstances()
        // Check if either method was provided in the editor
        .some((editor) => editor.getValidationElement || editor.getValidationErrors);
    return columnsHaveRules || getFullRowEditValidationErrors || editorsHaveRules;
}
function _populateModelValidationErrors(beans, force) {
    if (!(force || _hasValidationRules(beans))) {
        return;
    }
    const mappedEditors = getCellEditorInstanceMap(beans);
    const cellValidationModel = new editModelService_1.EditCellValidationModel();
    const { ariaAnnounce, localeSvc, editModelSvc, gos } = beans;
    const includeRows = gos.get('editType') === 'fullRow';
    const translate = (0, locale_1._getLocaleTextFunc)(localeSvc);
    const ariaValidationErrorPrefix = translate('ariaValidationErrorPrefix', 'Cell Editor Validation');
    for (const mappedEditor of mappedEditors) {
        const { ctrl, editor } = mappedEditor;
        const { rowNode, column } = ctrl;
        const errorMessages = editor.getValidationErrors?.() ?? [];
        const el = editor.getValidationElement?.(false) || (!editor.isPopup?.() && ctrl.eGui);
        if (el) {
            const isInvalid = errorMessages != null && errorMessages.length > 0;
            const invalidMessage = isInvalid ? errorMessages.join('. ') : '';
            (0, aria_1._setAriaInvalid)(el, isInvalid);
            if (isInvalid) {
                ariaAnnounce.announceValue(`${ariaValidationErrorPrefix} ${errorMessages}`, 'editorValidation');
            }
            if (el instanceof HTMLInputElement) {
                el.setCustomValidity(invalidMessage);
            }
            else {
                el.classList.toggle('invalid', isInvalid);
            }
        }
        if (errorMessages?.length > 0) {
            cellValidationModel.setCellValidation({
                rowNode,
                column,
            }, {
                errorMessages,
            });
        }
    }
    _syncFromEditors(beans, { persist: false });
    // the cellValidationModel should probably be reused to avoid
    // the second loop over mappedEditor below
    editModelSvc?.setCellValidationModel(cellValidationModel);
    const rowCtrlSet = new Set();
    for (const { ctrl } of mappedEditors) {
        rowCtrlSet.add(ctrl.rowCtrl);
    }
    if (includeRows) {
        const rowValidations = _generateRowValidationErrors(beans);
        editModelSvc?.setRowValidationModel(rowValidations);
    }
    for (const rowCtrl of rowCtrlSet.values()) {
        rowCtrl.rowEditStyleFeature?.applyRowStyles();
        for (const cellCtrl of rowCtrl.getAllCellCtrls()) {
            cellCtrl.tooltipFeature?.refreshTooltip(true);
            cellCtrl.editorTooltipFeature?.refreshTooltip(true);
            cellCtrl.editStyleFeature?.applyCellStyles?.();
        }
    }
}
exports._populateModelValidationErrors = _populateModelValidationErrors;
const _generateRowValidationErrors = (beans) => {
    const rowValidationModel = new editModelService_1.EditRowValidationModel();
    const getFullRowEditValidationErrors = beans.gos.get('getFullRowEditValidationErrors');
    // populate row-level errors
    const editMap = beans.editModelSvc?.getEditMap();
    if (!editMap) {
        return rowValidationModel;
    }
    for (const rowNode of editMap.keys()) {
        const rowEditMap = editMap.get(rowNode);
        if (!rowEditMap) {
            continue;
        }
        const editorsState = [];
        const { rowIndex, rowPinned } = rowNode;
        for (const column of rowEditMap.keys()) {
            const editValue = rowEditMap.get(column);
            if (!editValue) {
                continue;
            }
            const { editorValue, pendingValue, sourceValue } = editValue;
            const newValue = editorValue ?? (pendingValue === exports.UNEDITED ? undefined : pendingValue) ?? sourceValue;
            editorsState.push({
                column,
                colId: column.getColId(),
                rowIndex: rowIndex,
                rowPinned,
                oldValue: sourceValue,
                newValue,
            });
        }
        const errorMessages = getFullRowEditValidationErrors?.({ editorsState }) ?? [];
        if (errorMessages.length > 0) {
            rowValidationModel.setRowValidation({
                rowNode,
            }, { errorMessages });
        }
    }
    return rowValidationModel;
};
function _validateEdit(beans) {
    _populateModelValidationErrors(beans, true);
    const map = beans.editModelSvc?.getCellValidationModel().getCellValidationMap();
    if (!map) {
        return null;
    }
    const validations = [];
    map.forEach((rowValidations, rowNode) => {
        rowValidations.forEach(({ errorMessages }, column) => {
            validations.push({
                column,
                rowIndex: rowNode.rowIndex,
                rowPinned: rowNode.rowPinned,
                messages: errorMessages ?? null,
            });
        });
    });
    return validations;
}
exports._validateEdit = _validateEdit;


/***/ }),

/***/ 11539:
/***/ (function(__unused_webpack_module, exports) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._refreshEditCells = void 0;
const purgeRows = ({ rowModel, pinnedRowModel, editModelSvc }, rowNodes) => {
    const found = new Set();
    rowModel.forEachNode((node) => rowNodes.has(node) && found.add(node));
    pinnedRowModel?.forEachPinnedRow('top', (node) => rowNodes.has(node) && found.add(node));
    pinnedRowModel?.forEachPinnedRow('bottom', (node) => rowNodes.has(node) && found.add(node));
    rowNodes.forEach((rowNode) => {
        if (!found.has(rowNode)) {
            editModelSvc.removeEdits({ rowNode });
        }
    });
    return found;
};
const purgeCells = ({ editModelSvc }, rowNodes, columns) => {
    rowNodes.forEach((rowNode) => editModelSvc
        ?.getEditRow(rowNode)
        ?.forEach((_, column) => !columns.has(column) && editModelSvc.removeEdits({ rowNode, column })));
};
const _refreshEditCells = (beans) => () => {
    const columns = new Set(beans.colModel.getCols());
    const updates = beans.editModelSvc.getEditMap(true);
    const rowNodes = new Set(updates.keys());
    purgeCells(beans, purgeRows(beans, rowNodes), columns);
};
exports._refreshEditCells = _refreshEditCells;


/***/ }),

/***/ 13355:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgColumn = exports.isColumn = exports.getNextColInstanceId = void 0;
const localEventService_1 = __webpack_require__(19378);
const generic_1 = __webpack_require__(89097);
const string_1 = __webpack_require__(31931);
const beanStub_1 = __webpack_require__(68731);
const gridOptionsUtils_1 = __webpack_require__(67274);
const mergeDeep_1 = __webpack_require__(66021);
const logging_1 = __webpack_require__(47764);
const COL_DEF_DEFAULTS = {
    resizable: true,
    sortable: true,
};
let instanceIdSequence = 0;
function getNextColInstanceId() {
    return instanceIdSequence++;
}
exports.getNextColInstanceId = getNextColInstanceId;
function isColumn(col) {
    return col instanceof AgColumn;
}
exports.isColumn = isColumn;
// Wrapper around a user provide column definition. The grid treats the column definition as ready only.
// This class contains all the runtime information about a column, plus some logic (the definition has no logic).
// This class implements both interfaces ColumnGroupChild and ProvidedColumnGroupChild as the class can
// appear as a child of either the original tree or the displayed tree. However the relevant group classes
// for each type only implements one, as each group can only appear in it's associated tree (eg ProvidedColumnGroup
// can only appear in OriginalColumn tree).
class AgColumn extends beanStub_1.BeanStub {
    constructor(colDef, 
    // We do NOT use this anywhere, we just keep a reference. this is to check object equivalence
    // when the user provides an updated list of columns - so we can check if we have a column already
    // existing for a col def. we cannot use the this.colDef as that is the result of a merge.
    // This is used in ColumnFactory
    userProvidedColDef, colId, primary) {
        super();
        this.colDef = colDef;
        this.userProvidedColDef = userProvidedColDef;
        this.colId = colId;
        this.primary = primary;
        this.isColumn = true;
        // used by React (and possibly other frameworks) as key for rendering. also used to
        // identify old vs new columns for destroying cols when no longer used.
        this.instanceId = getNextColInstanceId();
        // The measured height of this column's header when autoHeaderHeight is enabled
        this.autoHeaderHeight = null;
        this.moving = false;
        this.resizing = false;
        this.menuVisible = false;
        this.lastLeftPinned = false;
        this.firstRightPinned = false;
        this.filterActive = false;
        this.colEventSvc = new localEventService_1.LocalEventService();
        this.tooltipEnabled = false;
        this.rowGroupActive = false;
        this.pivotActive = false;
        this.aggregationActive = false;
        this.flex = null;
        this.colIdSanitised = (0, string_1._escapeString)(colId);
    }
    destroy() {
        super.destroy();
        this.beans.rowSpanSvc?.deregister(this);
    }
    getInstanceId() {
        return this.instanceId;
    }
    setState() {
        const { colDef, beans: { sortSvc, pinnedCols, colFlex }, } = this;
        sortSvc?.initCol(this);
        const hide = colDef.hide;
        if (hide !== undefined) {
            this.visible = !hide;
        }
        else {
            this.visible = !colDef.initialHide;
        }
        pinnedCols?.initCol(this);
        colFlex?.initCol(this);
    }
    // gets called when user provides an alternative colDef, eg
    setColDef(colDef, userProvidedColDef, source) {
        const colSpanChanged = colDef.spanRows !== this.colDef.spanRows;
        this.colDef = colDef;
        this.userProvidedColDef = userProvidedColDef;
        this.initMinAndMaxWidths();
        this.initDotNotation();
        this.initTooltip();
        if (colSpanChanged) {
            this.beans.rowSpanSvc?.deregister(this);
            this.initRowSpan();
        }
        this.dispatchColEvent('colDefChanged', source);
    }
    getUserProvidedColDef() {
        return this.userProvidedColDef;
    }
    getParent() {
        return this.parent;
    }
    getOriginalParent() {
        return this.originalParent;
    }
    // this is done after constructor as it uses gridOptionsService
    postConstruct() {
        this.setState();
        this.initMinAndMaxWidths();
        this.resetActualWidth('gridInitializing');
        this.initDotNotation();
        this.initTooltip();
        this.initRowSpan();
        this.addPivotListener();
    }
    initDotNotation() {
        const { gos, colDef: { field, tooltipField }, } = this;
        const suppressDotNotation = gos.get('suppressFieldDotNotation');
        this.fieldContainsDots = (0, generic_1._exists)(field) && field.indexOf('.') >= 0 && !suppressDotNotation;
        this.tooltipFieldContainsDots = (0, generic_1._exists)(tooltipField) && tooltipField.indexOf('.') >= 0 && !suppressDotNotation;
    }
    initMinAndMaxWidths() {
        const colDef = this.colDef;
        this.minWidth = colDef.minWidth ?? this.beans.environment.getDefaultColumnMinWidth();
        this.maxWidth = colDef.maxWidth ?? Number.MAX_SAFE_INTEGER;
    }
    initTooltip() {
        this.beans.tooltipSvc?.initCol(this);
    }
    initRowSpan() {
        if (this.colDef.spanRows) {
            this.beans.rowSpanSvc?.register(this);
        }
    }
    addPivotListener() {
        const pivotColDefSvc = this.beans.pivotColDefSvc;
        const pivotValueColumn = this.colDef.pivotValueColumn;
        if (!pivotColDefSvc || !pivotValueColumn) {
            return;
        }
        this.addManagedListeners(pivotValueColumn, {
            colDefChanged: (evt) => {
                const colDef = pivotColDefSvc.recreateColDef(this.colDef);
                this.setColDef(colDef, colDef, evt.source);
            },
        });
    }
    resetActualWidth(source) {
        const initialWidth = this.calculateColInitialWidth(this.colDef);
        this.setActualWidth(initialWidth, source, true);
    }
    calculateColInitialWidth(colDef) {
        let width;
        const colDefWidth = colDef.width;
        const colDefInitialWidth = colDef.initialWidth;
        if (colDefWidth != null) {
            width = colDefWidth;
        }
        else if (colDefInitialWidth != null) {
            width = colDefInitialWidth;
        }
        else {
            width = 200;
        }
        return Math.max(Math.min(width, this.maxWidth), this.minWidth);
    }
    isEmptyGroup() {
        return false;
    }
    isRowGroupDisplayed(colId) {
        return this.beans.showRowGroupCols?.isRowGroupDisplayed(this, colId) ?? false;
    }
    isPrimary() {
        return this.primary;
    }
    isFilterAllowed() {
        // filter defined means it's a string, class or true.
        // if its false, null or undefined then it's false.
        const filterDefined = !!this.colDef.filter;
        return filterDefined;
    }
    isFieldContainsDots() {
        return this.fieldContainsDots;
    }
    isTooltipEnabled() {
        return this.tooltipEnabled;
    }
    isTooltipFieldContainsDots() {
        return this.tooltipFieldContainsDots;
    }
    getHighlighted() {
        return this.highlighted;
    }
    __addEventListener(eventType, listener) {
        this.colEventSvc.addEventListener(eventType, listener);
    }
    __removeEventListener(eventType, listener) {
        this.colEventSvc.removeEventListener(eventType, listener);
    }
    /**
     * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
     */
    addEventListener(eventType, userListener) {
        this.frameworkEventListenerService = this.beans.frameworkOverrides.createLocalEventListenerWrapper?.(this.frameworkEventListenerService, this.colEventSvc);
        const listener = this.frameworkEventListenerService?.wrap(eventType, userListener) ?? userListener;
        this.colEventSvc.addEventListener(eventType, listener);
    }
    /**
     * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
     */
    removeEventListener(eventType, userListener) {
        const listener = this.frameworkEventListenerService?.unwrap(eventType, userListener) ?? userListener;
        this.colEventSvc.removeEventListener(eventType, listener);
    }
    createColumnFunctionCallbackParams(rowNode) {
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            node: rowNode,
            data: rowNode.data,
            column: this,
            colDef: this.colDef,
        });
    }
    isSuppressNavigable(rowNode) {
        return this.beans.cellNavigation?.isSuppressNavigable(this, rowNode) ?? false;
    }
    isCellEditable(rowNode) {
        return this.beans.editSvc?.isCellEditable({ rowNode, column: this }) ?? false;
    }
    isSuppressFillHandle() {
        return !!this.colDef.suppressFillHandle;
    }
    isAutoHeight() {
        return !!this.colDef.autoHeight;
    }
    isAutoHeaderHeight() {
        return !!this.colDef.autoHeaderHeight;
    }
    isRowDrag(rowNode) {
        return this.isColumnFunc(rowNode, this.colDef.rowDrag);
    }
    isDndSource(rowNode) {
        return this.isColumnFunc(rowNode, this.colDef.dndSource);
    }
    isCellCheckboxSelection(rowNode) {
        return this.beans.selectionSvc?.isCellCheckboxSelection(this, rowNode) ?? false;
    }
    isSuppressPaste(rowNode) {
        return this.isColumnFunc(rowNode, this.colDef?.suppressPaste ?? null);
    }
    isResizable() {
        return !!this.getColDefValue('resizable');
    }
    /** Get value from ColDef or default if it exists. */
    getColDefValue(key) {
        return this.colDef[key] ?? COL_DEF_DEFAULTS[key];
    }
    isColumnFunc(rowNode, value) {
        // if boolean set, then just use it
        if (typeof value === 'boolean') {
            return value;
        }
        // if function, then call the function to find out
        if (typeof value === 'function') {
            const params = this.createColumnFunctionCallbackParams(rowNode);
            const editableFunc = value;
            return editableFunc(params);
        }
        return false;
    }
    createColumnEvent(type, source) {
        return (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            type,
            column: this,
            columns: [this],
            source,
        });
    }
    isMoving() {
        return this.moving;
    }
    getSort() {
        return this.sort;
    }
    isSortable() {
        return !!this.getColDefValue('sortable');
    }
    /** @deprecated v32 use col.getSort() === 'asc */
    isSortAscending() {
        return this.sort === 'asc';
    }
    /** @deprecated v32 use col.getSort() === 'desc */
    isSortDescending() {
        return this.sort === 'desc';
    }
    /** @deprecated v32 use col.getSort() === undefined */
    isSortNone() {
        return (0, generic_1._missing)(this.sort);
    }
    /** @deprecated v32 use col.getSort() !== undefined */
    isSorting() {
        return (0, generic_1._exists)(this.sort);
    }
    getSortIndex() {
        return this.sortIndex;
    }
    isMenuVisible() {
        return this.menuVisible;
    }
    getAggFunc() {
        return this.aggFunc;
    }
    getLeft() {
        return this.left;
    }
    getOldLeft() {
        return this.oldLeft;
    }
    getRight() {
        return this.left + this.actualWidth;
    }
    setLeft(left, source) {
        this.oldLeft = this.left;
        if (this.left !== left) {
            this.left = left;
            this.dispatchColEvent('leftChanged', source);
        }
    }
    isFilterActive() {
        return this.filterActive;
    }
    /** @deprecated v33 Use `api.isColumnHovered(column)` instead. */
    isHovered() {
        (0, logging_1._warn)(261);
        return !!this.beans.colHover?.isHovered(this);
    }
    setFirstRightPinned(firstRightPinned, source) {
        if (this.firstRightPinned !== firstRightPinned) {
            this.firstRightPinned = firstRightPinned;
            this.dispatchColEvent('firstRightPinnedChanged', source);
        }
    }
    setLastLeftPinned(lastLeftPinned, source) {
        if (this.lastLeftPinned !== lastLeftPinned) {
            this.lastLeftPinned = lastLeftPinned;
            this.dispatchColEvent('lastLeftPinnedChanged', source);
        }
    }
    isFirstRightPinned() {
        return this.firstRightPinned;
    }
    isLastLeftPinned() {
        return this.lastLeftPinned;
    }
    isPinned() {
        return this.pinned === 'left' || this.pinned === 'right';
    }
    isPinnedLeft() {
        return this.pinned === 'left';
    }
    isPinnedRight() {
        return this.pinned === 'right';
    }
    getPinned() {
        return this.pinned;
    }
    setVisible(visible, source) {
        const newValue = visible === true;
        if (this.visible !== newValue) {
            this.visible = newValue;
            this.dispatchColEvent('visibleChanged', source);
        }
        this.dispatchStateUpdatedEvent('hide');
    }
    isVisible() {
        return this.visible;
    }
    isSpanHeaderHeight() {
        const colDef = this.getColDef();
        return !colDef.suppressSpanHeaderHeight;
    }
    /**
     * Returns the first parent that is not a padding group.
     */
    getFirstRealParent() {
        let parent = this.getOriginalParent();
        while (parent && parent.isPadding()) {
            parent = parent.getOriginalParent();
        }
        return parent;
    }
    getColumnGroupPaddingInfo() {
        let parent = this.getParent();
        if (!parent || !parent.isPadding()) {
            return { numberOfParents: 0, isSpanningTotal: false };
        }
        const numberOfParents = parent.getPaddingLevel() + 1;
        let isSpanningTotal = true;
        while (parent) {
            if (!parent.isPadding()) {
                isSpanningTotal = false;
                break;
            }
            parent = parent.getParent();
        }
        return { numberOfParents, isSpanningTotal };
    }
    getColDef() {
        return this.colDef;
    }
    getDefinition() {
        return this.colDef;
    }
    getColumnGroupShow() {
        return this.colDef.columnGroupShow;
    }
    getColId() {
        return this.colId;
    }
    getId() {
        return this.colId;
    }
    getUniqueId() {
        return this.colId;
    }
    getActualWidth() {
        return this.actualWidth;
    }
    getAutoHeaderHeight() {
        return this.autoHeaderHeight;
    }
    /** Returns true if the header height has changed */
    setAutoHeaderHeight(height) {
        const changed = height !== this.autoHeaderHeight;
        this.autoHeaderHeight = height;
        return changed;
    }
    createBaseColDefParams(rowNode) {
        const params = (0, gridOptionsUtils_1._addGridCommonParams)(this.gos, {
            node: rowNode,
            data: rowNode.data,
            colDef: this.colDef,
            column: this,
        });
        return params;
    }
    getColSpan(rowNode) {
        if ((0, generic_1._missing)(this.colDef.colSpan)) {
            return 1;
        }
        const params = this.createBaseColDefParams(rowNode);
        const colSpan = this.colDef.colSpan(params);
        // colSpan must be number equal to or greater than 1
        return Math.max(colSpan, 1);
    }
    getRowSpan(rowNode) {
        if ((0, generic_1._missing)(this.colDef.rowSpan)) {
            return 1;
        }
        const params = this.createBaseColDefParams(rowNode);
        const rowSpan = this.colDef.rowSpan(params);
        // rowSpan must be number equal to or greater than 1
        return Math.max(rowSpan, 1);
    }
    setActualWidth(actualWidth, source, silent = false) {
        actualWidth = Math.max(actualWidth, this.minWidth);
        actualWidth = Math.min(actualWidth, this.maxWidth);
        if (this.actualWidth !== actualWidth) {
            // disable flex for this column if it was manually resized.
            this.actualWidth = actualWidth;
            if (this.flex != null && source !== 'flex' && source !== 'gridInitializing') {
                this.flex = null;
            }
            if (!silent) {
                this.fireColumnWidthChangedEvent(source);
            }
        }
        this.dispatchStateUpdatedEvent('width');
    }
    fireColumnWidthChangedEvent(source) {
        this.dispatchColEvent('widthChanged', source);
    }
    isGreaterThanMax(width) {
        return width > this.maxWidth;
    }
    getMinWidth() {
        return this.minWidth;
    }
    getMaxWidth() {
        return this.maxWidth;
    }
    getFlex() {
        return this.flex;
    }
    isRowGroupActive() {
        return this.rowGroupActive;
    }
    isPivotActive() {
        return this.pivotActive;
    }
    isAnyFunctionActive() {
        return this.isPivotActive() || this.isRowGroupActive() || this.isValueActive();
    }
    isAnyFunctionAllowed() {
        return this.isAllowPivot() || this.isAllowRowGroup() || this.isAllowValue();
    }
    isValueActive() {
        return this.aggregationActive;
    }
    isAllowPivot() {
        return this.colDef.enablePivot === true;
    }
    isAllowValue() {
        return this.colDef.enableValue === true;
    }
    isAllowRowGroup() {
        return this.colDef.enableRowGroup === true;
    }
    dispatchColEvent(type, source, additionalEventAttributes) {
        const colEvent = this.createColumnEvent(type, source);
        if (additionalEventAttributes) {
            (0, mergeDeep_1._mergeDeep)(colEvent, additionalEventAttributes);
        }
        this.colEventSvc.dispatchEvent(colEvent);
    }
    dispatchStateUpdatedEvent(key) {
        this.colEventSvc.dispatchEvent({
            type: 'columnStateUpdated',
            key,
        });
    }
}
exports.AgColumn = AgColumn;


/***/ }),

/***/ 56908:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgColumnGroup = exports.isColumnGroup = exports.createUniqueColumnGroupId = void 0;
const array_1 = __webpack_require__(79909);
const string_1 = __webpack_require__(31931);
const beanStub_1 = __webpack_require__(68731);
const agColumn_1 = __webpack_require__(13355);
function createUniqueColumnGroupId(groupId, instanceId) {
    return (groupId + '_' + instanceId);
}
exports.createUniqueColumnGroupId = createUniqueColumnGroupId;
function isColumnGroup(col) {
    return col instanceof AgColumnGroup;
}
exports.isColumnGroup = isColumnGroup;
class AgColumnGroup extends beanStub_1.BeanStub {
    constructor(providedColumnGroup, groupId, partId, pinned) {
        super();
        this.providedColumnGroup = providedColumnGroup;
        this.groupId = groupId;
        this.partId = partId;
        this.pinned = pinned;
        this.isColumn = false;
        // depends on the open/closed state of the group, only displaying columns are stored here
        this.displayedChildren = [];
        // The measured height of this column's header when autoHeaderHeight is enabled
        this.autoHeaderHeight = null;
        this.parent = null;
        this.colIdSanitised = (0, string_1._escapeString)(this.getUniqueId());
    }
    // as the user is adding and removing columns, the groups are recalculated.
    // this reset clears out all children, ready for children to be added again
    reset() {
        this.parent = null;
        this.children = null;
        this.displayedChildren = null;
    }
    getParent() {
        return this.parent;
    }
    getUniqueId() {
        return createUniqueColumnGroupId(this.groupId, this.partId);
    }
    isEmptyGroup() {
        return this.displayedChildren.length === 0;
    }
    isMoving() {
        const allLeafColumns = this.getProvidedColumnGroup().getLeafColumns();
        if (!allLeafColumns || allLeafColumns.length === 0) {
            return false;
        }
        return allLeafColumns.every((col) => col.isMoving());
    }
    checkLeft() {
        // first get all children to setLeft, as it impacts our decision below
        this.displayedChildren.forEach((child) => {
            if (isColumnGroup(child)) {
                child.checkLeft();
            }
        });
        // set our left based on first displayed column
        if (this.displayedChildren.length > 0) {
            if (this.gos.get('enableRtl')) {
                const lastChild = (0, array_1._last)(this.displayedChildren);
                const lastChildLeft = lastChild.getLeft();
                this.setLeft(lastChildLeft);
            }
            else {
                const firstChildLeft = this.displayedChildren[0].getLeft();
                this.setLeft(firstChildLeft);
            }
        }
        else {
            // this should never happen, as if we have no displayed columns, then
            // this groups should not even exist.
            this.setLeft(null);
        }
    }
    getLeft() {
        return this.left;
    }
    getOldLeft() {
        return this.oldLeft;
    }
    setLeft(left) {
        this.oldLeft = this.left;
        if (this.left !== left) {
            this.left = left;
            this.dispatchLocalEvent({ type: 'leftChanged' });
        }
    }
    getPinned() {
        return this.pinned;
    }
    getGroupId() {
        return this.groupId;
    }
    getPartId() {
        return this.partId;
    }
    getActualWidth() {
        let groupActualWidth = 0;
        this.displayedChildren?.forEach((child) => {
            groupActualWidth += child.getActualWidth();
        });
        return groupActualWidth;
    }
    isResizable() {
        if (!this.displayedChildren) {
            return false;
        }
        // if at least one child is resizable, then the group is resizable
        let result = false;
        this.displayedChildren.forEach((child) => {
            if (child.isResizable()) {
                result = true;
            }
        });
        return result;
    }
    getMinWidth() {
        let result = 0;
        this.displayedChildren.forEach((groupChild) => {
            result += groupChild.getMinWidth();
        });
        return result;
    }
    addChild(child) {
        if (!this.children) {
            this.children = [];
        }
        this.children.push(child);
    }
    getDisplayedChildren() {
        return this.displayedChildren;
    }
    getLeafColumns() {
        const result = [];
        this.addLeafColumns(result);
        return result;
    }
    getDisplayedLeafColumns() {
        const result = [];
        this.addDisplayedLeafColumns(result);
        return result;
    }
    getDefinition() {
        return this.providedColumnGroup.getColGroupDef();
    }
    getColGroupDef() {
        return this.providedColumnGroup.getColGroupDef();
    }
    isPadding() {
        return this.providedColumnGroup.isPadding();
    }
    isExpandable() {
        return this.providedColumnGroup.isExpandable();
    }
    isExpanded() {
        return this.providedColumnGroup.isExpanded();
    }
    setExpanded(expanded) {
        this.providedColumnGroup.setExpanded(expanded);
    }
    isAutoHeaderHeight() {
        return !!this.getColGroupDef()?.autoHeaderHeight;
    }
    getAutoHeaderHeight() {
        return this.autoHeaderHeight;
    }
    /** Returns true if the header height has changed */
    setAutoHeaderHeight(height) {
        const changed = height !== this.autoHeaderHeight;
        this.autoHeaderHeight = height;
        return changed;
    }
    addDisplayedLeafColumns(leafColumns) {
        this.displayedChildren.forEach((child) => {
            if ((0, agColumn_1.isColumn)(child)) {
                leafColumns.push(child);
            }
            else if (isColumnGroup(child)) {
                child.addDisplayedLeafColumns(leafColumns);
            }
        });
    }
    addLeafColumns(leafColumns) {
        this.children.forEach((child) => {
            if ((0, agColumn_1.isColumn)(child)) {
                leafColumns.push(child);
            }
            else if (isColumnGroup(child)) {
                child.addLeafColumns(leafColumns);
            }
        });
    }
    getChildren() {
        return this.children;
    }
    getColumnGroupShow() {
        return this.providedColumnGroup.getColumnGroupShow();
    }
    getProvidedColumnGroup() {
        return this.providedColumnGroup;
    }
    getPaddingLevel() {
        const parent = this.getParent();
        if (!this.isPadding() || !parent || !parent.isPadding()) {
            return 0;
        }
        return 1 + parent.getPaddingLevel();
    }
    calculateDisplayedColumns() {
        // clear out last time we calculated
        this.displayedChildren = [];
        // find the column group that is controlling expandable. this is relevant when we have padding (empty)
        // groups, where the expandable is actually the first parent that is not a padding group.
        let parentWithExpansion = this;
        while (parentWithExpansion != null && parentWithExpansion.isPadding()) {
            parentWithExpansion = parentWithExpansion.getParent();
        }
        const isExpandable = parentWithExpansion ? parentWithExpansion.getProvidedColumnGroup().isExpandable() : false;
        // it not expandable, everything is visible
        if (!isExpandable) {
            this.displayedChildren = this.children;
            this.dispatchLocalEvent({ type: 'displayedChildrenChanged' });
            return;
        }
        // Add cols based on columnGroupShow
        // Note - the below also adds padding groups, these are always added because they never have
        // colDef.columnGroupShow set.
        this.children.forEach((child) => {
            // never add empty groups
            const emptyGroup = isColumnGroup(child) && !child.displayedChildren?.length;
            if (emptyGroup) {
                return;
            }
            const headerGroupShow = child.getColumnGroupShow();
            switch (headerGroupShow) {
                case 'open':
                    // when set to open, only show col if group is open
                    if (parentWithExpansion.getProvidedColumnGroup().isExpanded()) {
                        this.displayedChildren.push(child);
                    }
                    break;
                case 'closed':
                    // when set to open, only show col if group is open
                    if (!parentWithExpansion.getProvidedColumnGroup().isExpanded()) {
                        this.displayedChildren.push(child);
                    }
                    break;
                default:
                    this.displayedChildren.push(child);
                    break;
            }
        });
        this.dispatchLocalEvent({ type: 'displayedChildrenChanged' });
    }
}
exports.AgColumnGroup = AgColumnGroup;


/***/ }),

/***/ 79409:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgProvidedColumnGroup = exports.isProvidedColumnGroup = void 0;
const beanStub_1 = __webpack_require__(68731);
const agColumn_1 = __webpack_require__(13355);
function isProvidedColumnGroup(col) {
    return col instanceof AgProvidedColumnGroup;
}
exports.isProvidedColumnGroup = isProvidedColumnGroup;
class AgProvidedColumnGroup extends beanStub_1.BeanStub {
    constructor(colGroupDef, groupId, padding, level) {
        super();
        this.colGroupDef = colGroupDef;
        this.groupId = groupId;
        this.padding = padding;
        this.level = level;
        this.isColumn = false;
        this.expandable = false;
        // used by React (and possibly other frameworks) as key for rendering. also used to
        // identify old vs new columns for destroying cols when no longer used.
        this.instanceId = (0, agColumn_1.getNextColInstanceId)();
        this.expandableListenerRemoveCallback = null;
        this.expanded = !!colGroupDef?.openByDefault;
    }
    destroy() {
        if (this.expandableListenerRemoveCallback) {
            this.reset(null, undefined);
        }
        super.destroy();
    }
    reset(colGroupDef, level) {
        this.colGroupDef = colGroupDef;
        this.level = level;
        this.originalParent = null;
        if (this.expandableListenerRemoveCallback) {
            this.expandableListenerRemoveCallback();
        }
        // we use ! below, as we want to set the object back to the
        // way it was when it was first created
        this.children = undefined;
        this.expandable = undefined;
    }
    getInstanceId() {
        return this.instanceId;
    }
    getOriginalParent() {
        return this.originalParent;
    }
    getLevel() {
        return this.level;
    }
    isVisible() {
        // return true if at least one child is visible
        if (this.children) {
            return this.children.some((child) => child.isVisible());
        }
        return false;
    }
    isPadding() {
        return this.padding;
    }
    setExpanded(expanded) {
        this.expanded = expanded === undefined ? false : expanded;
        this.dispatchLocalEvent({ type: 'expandedChanged' });
    }
    isExpandable() {
        return this.expandable;
    }
    isExpanded() {
        return this.expanded;
    }
    getGroupId() {
        return this.groupId;
    }
    getId() {
        return this.getGroupId();
    }
    setChildren(children) {
        this.children = children;
    }
    getChildren() {
        return this.children;
    }
    getColGroupDef() {
        return this.colGroupDef;
    }
    getLeafColumns() {
        const result = [];
        this.addLeafColumns(result);
        return result;
    }
    forEachLeafColumn(callback) {
        if (!this.children) {
            return;
        }
        for (const child of this.children) {
            if ((0, agColumn_1.isColumn)(child)) {
                callback(child);
            }
            else if (isProvidedColumnGroup(child)) {
                child.forEachLeafColumn(callback);
            }
        }
    }
    addLeafColumns(leafColumns) {
        if (!this.children) {
            return;
        }
        this.children.forEach((child) => {
            if ((0, agColumn_1.isColumn)(child)) {
                leafColumns.push(child);
            }
            else if (isProvidedColumnGroup(child)) {
                child.addLeafColumns(leafColumns);
            }
        });
    }
    getColumnGroupShow() {
        const colGroupDef = this.colGroupDef;
        if (!colGroupDef) {
            return;
        }
        return colGroupDef.columnGroupShow;
    }
    // need to check that this group has at least one col showing when both expanded and contracted.
    // if not, then we don't allow expanding and contracting on this group
    setupExpandable() {
        this.setExpandable();
        if (this.expandableListenerRemoveCallback) {
            this.expandableListenerRemoveCallback();
        }
        const listener = this.onColumnVisibilityChanged.bind(this);
        this.getLeafColumns().forEach((col) => col.__addEventListener('visibleChanged', listener));
        this.expandableListenerRemoveCallback = () => {
            this.getLeafColumns().forEach((col) => col.__removeEventListener('visibleChanged', listener));
            this.expandableListenerRemoveCallback = null;
        };
    }
    setExpandable() {
        if (this.isPadding()) {
        