import type { AgCoreBeanCollection } from '../interfaces/agCoreBeanCollection';
import type { BaseEvents } from '../interfaces/baseEvents';
import type { BaseProperties } from '../interfaces/baseProperties';
import type { IComponent } from '../interfaces/iComponent';
import type { AgDragSource, AgDraggingEvent, AgDropTarget, IDragAndDropImage } from '../interfaces/iDragAndDrop';
import type { IPropertiesService } from '../interfaces/iProperties';
import type { AgPromise } from '../utils/promise';
import { AgBeanStub } from './agBeanStub';
export declare abstract class BaseDragAndDropService<TBeanCollection extends AgCoreBeanCollection<TProperties, TGlobalEvents, TCommon, TPropertiesService>, TProperties extends BaseProperties, TGlobalEvents extends BaseEvents, TCommon, TPropertiesService extends IPropertiesService<TProperties, TCommon>, TDragSourceType extends number, TDragItem, TDragAndDropIcon extends string, TDraggingEvent extends AgDraggingEvent<TDragSourceType, TDragItem, TDragAndDropIcon, TDraggingEvent>, TDragSource extends AgDragSource<TDragSourceType, TDragItem, TDragAndDropIcon, TDraggingEvent>> extends AgBeanStub<TBeanCollection, TProperties, TGlobalEvents, TCommon, TPropertiesService> {
    beanName: "dragAndDrop";
    private dragSourceAndParamsList;
    private dragItem;
    private lastMouseEvent;
    private lastDraggingEvent;
    private dragSource;
    private dragImageParent;
    private dragImageCompPromise;
    private dragImageComp;
    private dragImageLastIcon;
    private dragImageLastLabel;
    private dropTargets;
    private lastDropTarget;
    protected abstract createEvent(event: AgDraggingEvent<TDragSourceType, TDragItem, TDragAndDropIcon, TDraggingEvent>): TDraggingEvent;
    protected abstract createDragImageComp(dragSource: TDragSource): AgPromise<IDragAndDropImage & IComponent<any>> | undefined;
    protected abstract handleEnter(dragSource: TDragSource | null, dragItem: TDragItem | null): void;
    protected abstract handleExit(dragSource: TDragSource | null, dragItem: TDragItem | null): void;
    protected abstract warnNoBody(): void;
    addDragSource(dragSource: TDragSource, allowTouch?: boolean): void;
    setDragImageCompIcon(iconName: TDragAndDropIcon | null, shake?: boolean): void;
    removeDragSource(dragSource: TDragSource): void;
    destroy(): void;
    nudge(): void;
    private onDragStart;
    private onDragStop;
    private onDragCancel;
    private onDragging;
    private clearDragAndDropProperties;
    private getAllContainersFromDropTarget;
    private isMouseOnDropTarget;
    private findCurrentDropTarget;
    addDropTarget(dropTarget: AgDropTarget<TDragSourceType, TDragItem, TDragAndDropIcon, TDraggingEvent>): void;
    removeDropTarget(dropTarget: AgDropTarget<TDragSourceType, TDragItem, TDragAndDropIcon, TDraggingEvent>): void;
    hasExternalDropZones(): boolean;
    findExternalZone(container: HTMLElement): AgDropTarget<TDragSourceType, TDragItem, TDragAndDropIcon, TDraggingEvent> | null;
    dropTargetEvent(dropTarget: AgDropTarget<TDragSourceType, TDragItem, TDragAndDropIcon, TDraggingEvent>, mouseEvent: MouseEvent, fromNudge: boolean): TDraggingEvent;
    private positionDragImageComp;
    private removeDragImageComp;
    private createAndUpdateDragImageComp;
    private appendDragImageComp;
    private updateDragImageComp;
}
