/**
 * This function provides fuzzy matching suggestions based on the input value and a list of all suggestions.
 */
export declare function _fuzzySuggestions(params: {
    inputValue: string;
    allSuggestions: string[];
    hideIrrelevant?: boolean;
    filterByPercentageOfBestMatch?: number;
}): {
    values: string[];
    indices: number[];
};
/**
 * This uses Levenshtein Distance to match strings.
 * Lower values mean more similar strings.
 */
export declare function _getLevenshteinSimilarityDistance(inputText: string, suggestion: string): number;
