import { BeanStub } from '../../context/beanStub';
import type { DragAndDropIcon, GridDraggingEvent } from '../../dragAndDrop/dragAndDropService';
import type { AgColumn } from '../../entities/agColumn';
import type { ColumnEventType } from '../../events';
import type { ColumnPinnedType } from '../../interfaces/iColumn';
import type { DropListener } from './bodyDropTarget';
export declare class MoveColumnFeature extends BeanStub implements DropListener {
    private readonly pinned;
    private gridBodyCon;
    private needToMoveLeft;
    private needToMoveRight;
    private movingIntervalId;
    private intervalCount;
    private isCenterContainer;
    private lastDraggingEvent;
    private lastHighlightedColumn;
    private lastMovedInfo;
    private failedMoveAttempts;
    constructor(pinned: ColumnPinnedType);
    postConstruct(): void;
    getIconName(): DragAndDropIcon;
    onDragEnter(draggingEvent: GridDraggingEvent): void;
    onDragging(draggingEvent?: GridDraggingEvent | null, fromEnter?: boolean, fakeEvent?: boolean, finished?: boolean): void;
    onDragLeave(): void;
    onDragStop(): void;
    onDragCancel(): void;
    setColumnsVisible(columns: AgColumn[] | null | undefined, visible: boolean, source: ColumnEventType): void;
    private finishColumnMoving;
    private updateDragItemContainerType;
    private handleColumnDragWhileSuppressingMovement;
    private handleColumnDragWhileAllowingMovement;
    private getAllMovingColumns;
    private getMoveColumnParams;
    private highlightHoveredColumn;
    private getNormalisedXPositionInfo;
    private getColumnMoveAndTargetInfo;
    private normaliseDirection;
    private getNormalisedColumnLeft;
    private isAttemptingToPin;
    private moveColumnsAfterHighlight;
    private clearHighlighted;
    private checkCenterForScrolling;
    private ensureIntervalStarted;
    private ensureIntervalCleared;
    private moveInterval;
    private getPinDirection;
    private attemptToPinColumns;
    destroy(): void;
}
