/**
 * @ag-grid-enterprise/clipboard - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components * @version v26.2.0
 * @link http://www.ag-grid.com/
' * @license Commercial
 */

/**
 * @ag-grid-enterprise/clipboard - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components * @version v26.2.0
 * @link http://www.ag-grid.com/
' * @license Commercial
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var e,t=require("@ag-grid-community/core"),o=require("@ag-grid-enterprise/core"),r=require("@ag-grid-community/csv-export"),i=(e=function(t,o){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var o in t)t.hasOwnProperty(o)&&(e[o]=t[o])})(t,o)},function(t,o){function r(){this.constructor=t}e(t,o),t.prototype=null===o?Object.create(o):(r.prototype=o.prototype,new r)}),n=function(e,t,o,r){var i,n=arguments.length,a=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,o):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(e,t,o,r);else for(var s=e.length-1;s>=0;s--)(i=e[s])&&(a=(n<3?i(a):n>3?i(t,o,a):i(t,o))||a);return n>3&&a&&Object.defineProperty(t,o,a),a},a=function(e){function o(){var t=null!==e&&e.apply(this,arguments)||this;return t.navigatorApiFailed=!1,t}return i(o,e),o.prototype.init=function(){var e=this;this.logger=this.loggerFactory.create("ClipboardService"),this.rowModel.getType()===t.Constants.ROW_MODEL_TYPE_CLIENT_SIDE&&(this.clientSideRowModel=this.rowModel),this.ctrlsService.whenReady((function(t){e.gridCtrl=t.gridCtrl}))},o.prototype.pasteFromClipboard=function(){var e=this;this.logger.log("pasteFromClipboard"),!this.gridOptionsWrapper.isSuppressClipboardApi()&&!this.navigatorApiFailed&&navigator.clipboard&&navigator.clipboard.readText?navigator.clipboard.readText().then(this.processClipboardData.bind(this)).catch((function(o){t._.doOnce((function(){console.warn(o),console.warn("AG Grid: Unable to use the Clipboard API (navigator.clipboard.readText()). The reason why it could not be used has been logged in the previous line. For this reason the grid has defaulted to using a workaround which doesn't perform as well. Either fix why Clipboard API is blocked, OR stop this message from appearing by setting grid property suppressClipboardApi=true (which will default the grid to using the workaround rather than the API")}),"clipboardApiError"),e.navigatorApiFailed=!0,e.pasteFromClipboardLegacy()})):this.pasteFromClipboardLegacy()},o.prototype.pasteFromClipboardLegacy=function(){var e=this;this.executeOnTempElement((function(e){return e.focus({preventScroll:!0})}),(function(t){var o=t.value;e.processClipboardData(o)}))},o.prototype.processClipboardData=function(e){var o=this;if(null!=e){var r=t._.stringToArray(e,this.gridOptionsWrapper.getClipboardDeliminator()),i=this.gridOptionsWrapper.getProcessDataFromClipboardFunc();if(i&&(r=i({data:r})),null!=r){this.gridOptionsWrapper.isSuppressLastEmptyLineOnPaste()&&this.removeLastLineIfBlank(r);this.doPasteOperation((function(e,t,i,n){o.rangeService&&o.rangeService.isMoreThanOneCell()&&!o.hasOnlyOneValueToPaste(r)?o.pasteIntoActiveRange(r,e,t,n):o.pasteStartingFromFocusedCell(r,e,t,i,n)}))}}},o.prototype.doPasteOperation=function(e){var o,r=this.gridOptionsWrapper.getApi(),i=this.gridOptionsWrapper.getColumnApi();if(this.eventService.dispatchEvent({type:t.Events.EVENT_PASTE_START,api:r,columnApi:i,source:"clipboard"}),this.clientSideRowModel){var n=this.gridOptionsWrapper.isAggregateOnlyChangedColumns();o=new t.ChangedPath(n,this.clientSideRowModel.getRootNode())}var a={},s=[],p=this.focusService.getFocusedCell();e(a,s,p,o),o&&this.clientSideRowModel.doAggregate(o),this.rowRenderer.refreshCells(),this.dispatchFlashCells(a),this.fireRowChanged(s),p&&this.focusService.setFocusedCell(p.rowIndex,p.column,p.rowPinned,!0),this.eventService.dispatchEvent({type:t.Events.EVENT_PASTE_END,api:r,columnApi:i,source:"clipboard"})},o.prototype.pasteIntoActiveRange=function(e,o,r,i){var n=this,a=this.getRangeSize()%e.length!=0,s=0,p=0;this.iterateActiveRanges(!1,(function(l,c,d,u){if(u-s>=e.length){if(a)return;s+=p,p=0}var g=e[u-s];r.push(c);var h=n.gridOptionsWrapper.getProcessCellFromClipboardFunc();d.forEach((function(e,r){if(e.isCellEditable(c)&&!e.isSuppressPaste(c)){r>=g.length&&(r%=g.length);var a=n.processCell(c,e,g[r],t.Constants.EXPORT_TYPE_DRAG_COPY,h);c.setDataValue(e,a,t.Constants.SOURCE_PASTE),i&&i.addParentNode(c.parent,[e]);var s=n.cellPositionUtils.createIdFromValues(l.rowIndex,e,l.rowPinned);o[s]=!0}})),p++}))},o.prototype.pasteStartingFromFocusedCell=function(e,o,r,i,n){if(i){var a={rowIndex:i.rowIndex,rowPinned:i.rowPinned},s=this.columnModel.getDisplayedColumnsStartingAt(i.column);this.isPasteSingleValueIntoRange(e)?this.pasteSingleValueIntoRange(e,r,o,n):this.pasteMultipleValues(e,a,r,s,o,t.Constants.EXPORT_TYPE_CLIPBOARD,n)}},o.prototype.isPasteSingleValueIntoRange=function(e){return this.hasOnlyOneValueToPaste(e)&&null!=this.rangeService&&!this.rangeService.isEmpty()},o.prototype.pasteSingleValueIntoRange=function(e,o,r,i){var n=this,a=e[0][0];this.iterateActiveRanges(!1,(function(e,s,p){o.push(s),p.forEach((function(e){return n.updateCellValue(s,e,a,r,t.Constants.EXPORT_TYPE_CLIPBOARD,i)}))}))},o.prototype.hasOnlyOneValueToPaste=function(e){return 1===e.length&&1===e[0].length},o.prototype.copyRangeDown=function(){var e=this;if(this.rangeService&&!this.rangeService.isEmpty()){var o=[];this.doPasteOperation((function(r,i,n,a){var s=e.gridOptionsWrapper.getProcessCellForClipboardFunc(),p=e.gridOptionsWrapper.getProcessCellFromClipboardFunc();e.iterateActiveRanges(!0,(function(n,l,c){o.length?(i.push(l),c.forEach((function(i,s){if(i.isCellEditable(l)&&!i.isSuppressPaste(l)){var c=e.processCell(l,i,o[s],t.Constants.EXPORT_TYPE_DRAG_COPY,p);l.setDataValue(i,c,t.Constants.SOURCE_PASTE),a&&a.addParentNode(l.parent,[i]);var d=e.cellPositionUtils.createIdFromValues(n.rowIndex,i,n.rowPinned);r[d]=!0}}))):c.forEach((function(r){var i=e.processCell(l,r,e.valueService.getValue(r,l),t.Constants.EXPORT_TYPE_DRAG_COPY,s);o.push(i)}))}))}))}},o.prototype.removeLastLineIfBlank=function(e){var o=t._.last(e);o&&1===o.length&&""===o[0]&&t._.removeFromArray(e,o)},o.prototype.fireRowChanged=function(e){var o=this;this.gridOptionsWrapper.isFullRowEdit()&&e.forEach((function(e){var r={type:t.Events.EVENT_ROW_VALUE_CHANGED,node:e,data:e.data,rowIndex:e.rowIndex,rowPinned:e.rowPinned,context:o.gridOptionsWrapper.getContext(),api:o.gridOptionsWrapper.getApi(),columnApi:o.gridOptionsWrapper.getColumnApi()};o.eventService.dispatchEvent(r)}))},o.prototype.pasteMultipleValues=function(e,t,o,r,i,n,a){var s=this,p=t,l=null!=this.clientSideRowModel&&!this.gridOptionsWrapper.isTreeData();e.forEach((function(e){var t=function(){for(;;){if(!p)return null;var e=s.rowPositionUtils.getRowNode(p);if(p=s.cellNavigationService.getRowBelow({rowPinned:p.rowPinned,rowIndex:p.rowIndex}),null==e)return null;if(!(e.detail||e.footer||l&&e.group))return e}}();t&&(e.forEach((function(e,o){return s.updateCellValue(t,r[o],e,i,n,a)})),o.push(t))}))},o.prototype.updateCellValue=function(e,o,r,i,n,a){if(e&&o&&o.isCellEditable(e)&&!o.isSuppressPaste(e)){var s=this.processCell(e,o,r,n,this.gridOptionsWrapper.getProcessCellFromClipboardFunc());e.setDataValue(o,s,t.Constants.SOURCE_PASTE),i[this.cellPositionUtils.createIdFromValues(e.rowIndex,o,e.rowPinned)]=!0,a&&a.addParentNode(e.parent,[o])}},o.prototype.copyToClipboard=function(e){this.logger.log("copyToClipboard: includeHeaders = "+e),null==e&&(e=this.gridOptionsWrapper.isCopyHeadersToClipboard());var t=!this.selectionService.isEmpty()&&!this.gridOptionsWrapper.isSuppressCopyRowsToClipboard();this.rangeService&&this.rangeService.isMoreThanOneCell()?this.copySelectedRangeToClipboard(e):t?this.copySelectedRowsToClipboard(e):this.focusService.isAnyCellFocused()?this.copyFocusedCellToClipboard(e):this.copySelectedRangeToClipboard(e)},o.prototype.iterateActiveRanges=function(e,t,o){var r=this;if(this.rangeService&&!this.rangeService.isEmpty()){var i=this.rangeService.getCellRanges();e?this.iterateActiveRange(i[0],t,o,!0):i.forEach((function(e,n){return r.iterateActiveRange(e,t,o,n===i.length-1)}))}},o.prototype.iterateActiveRange=function(e,t,o,r){if(this.rangeService){var i=this.rangeService.getRangeStartRow(e),n=this.rangeService.getRangeEndRow(e);o&&e.columns&&o(e.columns);for(var a=0,s=!1;!s&&null!=i;){var p=this.rowPositionUtils.getRowNode(i);s=this.rowPositionUtils.sameRow(i,n),t(i,p,e.columns,a++,s&&r),i=this.cellNavigationService.getRowBelow(i)}}},o.prototype.copySelectedRangeToClipboard=function(e){var o=this;if(void 0===e&&(e=!1),this.rangeService&&!this.rangeService.isEmpty()){var r=this.gridOptionsWrapper.getClipboardDeliminator(),i="",n={};this.iterateActiveRanges(!1,(function(e,a,s,p,l){var c=o.gridOptionsWrapper.getProcessCellForClipboardFunc();s.forEach((function(s,p){var l=o.valueService.getValue(s,a),d=o.processCell(a,s,l,t.Constants.EXPORT_TYPE_CLIPBOARD,c);0!=p&&(i+=r),t._.exists(d)&&(i+=d);var u=o.cellPositionUtils.createIdFromValues(e.rowIndex,s,e.rowPinned);n[u]=!0})),l||(i+="\r\n")}),(function(t){if(e){var n=o.gridOptionsWrapper.getProcessHeaderForClipboardFunc(),a=t.map((function(e){var t=o.columnModel.getDisplayNameForColumn(e,"clipboard",!0);return o.processHeader(e,t,n)||""}));i+=a.join(r)+"\r\n"}})),this.copyDataToClipboard(i),this.dispatchFlashCells(n)}},o.prototype.copyFocusedCellToClipboard=function(e){var o;void 0===e&&(e=!1);var r=this.focusService.getFocusedCell();if(null!=r){var i,n=this.cellPositionUtils.createId(r),a={rowPinned:r.rowPinned,rowIndex:r.rowIndex},s=this.rowPositionUtils.getRowNode(a),p=r.column,l=this.valueService.getValue(p,s),c=this.processCell(s,p,l,t.Constants.EXPORT_TYPE_CLIPBOARD,this.gridOptionsWrapper.getProcessCellForClipboardFunc());if(c=t._.missing(c)?"":c.toString(),e){var d=this.columnModel.getDisplayNameForColumn(p,"clipboard",!0);i=this.processHeader(p,d,this.gridOptionsWrapper.getProcessHeaderForClipboardFunc())+"\r\n"+c}else i=c;this.copyDataToClipboard(i),this.dispatchFlashCells(((o={})[n]=!0,o))}},o.prototype.dispatchFlashCells=function(e){var o=this;window.setTimeout((function(){var r={type:t.Events.EVENT_FLASH_CELLS,cells:e,api:o.gridApi,columnApi:o.columnApi};o.eventService.dispatchEvent(r)}),0)},o.prototype.processCell=function(e,t,o,r,i){return i?i({column:t,node:e,value:o,api:this.gridOptionsWrapper.getApi(),columnApi:this.gridOptionsWrapper.getColumnApi(),context:this.gridOptionsWrapper.getContext(),type:r}):o},o.prototype.processHeader=function(e,t,o){return o?o({column:e,api:this.gridOptionsWrapper.getApi(),columnApi:this.gridOptionsWrapper.getColumnApi(),context:this.gridOptionsWrapper.getContext()}):t},o.prototype.copySelectedRowsToClipboard=function(e,t){void 0===e&&(e=!1);var o={columnKeys:t,skipColumnHeaders:!e,suppressQuotes:!0,columnSeparator:this.gridOptionsWrapper.getClipboardDeliminator(),onlySelected:!0,processCellCallback:this.gridOptionsWrapper.getProcessCellForClipboardFunc(),processHeaderCallback:this.gridOptionsWrapper.getProcessHeaderForClipboardFunc()},r=this.csvCreator.getDataAsCsv(o);this.copyDataToClipboard(r)},o.prototype.copyDataToClipboard=function(e){var o=this,r=this.gridOptionsWrapper.getSendToClipboardFunc();r?r({data:e}):!this.gridOptionsWrapper.isSuppressClipboardApi()&&navigator.clipboard?navigator.clipboard.writeText(e).catch((function(r){t._.doOnce((function(){console.warn(r),console.warn("AG Grid: Unable to use the Clipboard API (navigator.clipboard.writeText()). The reason why it could not be used has been logged in the previous line. For this reason the grid has defaulted to using a workaround which doesn't perform as well. Either fix why Clipboard API is blocked, OR stop this message from appearing by setting grid property suppressClipboardApi=true (which will default the grid to using the workaround rather than the API.")}),"clipboardApiError"),o.copyDataToClipboardLegacy(e)})):this.copyDataToClipboardLegacy(e)},o.prototype.copyDataToClipboardLegacy=function(e){var t=this;this.executeOnTempElement((function(o){var r=t.gridOptionsWrapper.getDocument().activeElement;o.value=e||" ",o.select(),o.focus({preventScroll:!0}),document.execCommand("copy")||console.warn("ag-grid: Browser did not allow document.execCommand('copy'). Ensure api.copySelectedRowsToClipboard() is invoked via a user event, i.e. button click, otherwise the browser will prevent it for security reasons."),null!=r&&null!=r.focus&&r.focus({preventScroll:!0})}))},o.prototype.executeOnTempElement=function(e,t){var o=this.gridOptionsWrapper.getDocument(),r=o.createElement("textarea");r.style.width="1px",r.style.height="1px",r.style.top=o.documentElement.scrollTop+"px",r.style.left=o.documentElement.scrollLeft+"px",r.style.position="absolute",r.style.opacity="0";var i=this.gridCtrl.getGui();i.appendChild(r);try{e(r)}catch(e){console.warn("ag-grid: Browser does not support document.execCommand('copy') for clipboard operations")}t?window.setTimeout((function(){t(r),i.removeChild(r)}),100):i.removeChild(r)},o.prototype.getRangeSize=function(){var e=this.rangeService.getCellRanges(),t=0,o=0;return e.length>0&&(t=this.rangeService.getRangeStartRow(e[0]).rowIndex,o=this.rangeService.getRangeEndRow(e[0]).rowIndex),t-o+1},n([t.Autowired("csvCreator")],o.prototype,"csvCreator",void 0),n([t.Autowired("loggerFactory")],o.prototype,"loggerFactory",void 0),n([t.Autowired("selectionService")],o.prototype,"selectionService",void 0),n([t.Optional("rangeService")],o.prototype,"rangeService",void 0),n([t.Autowired("rowModel")],o.prototype,"rowModel",void 0),n([t.Autowired("ctrlsService")],o.prototype,"ctrlsService",void 0),n([t.Autowired("valueService")],o.prototype,"valueService",void 0),n([t.Autowired("focusService")],o.prototype,"focusService",void 0),n([t.Autowired("rowRenderer")],o.prototype,"rowRenderer",void 0),n([t.Autowired("columnModel")],o.prototype,"columnModel",void 0),n([t.Autowired("cellNavigationService")],o.prototype,"cellNavigationService",void 0),n([t.Autowired("columnApi")],o.prototype,"columnApi",void 0),n([t.Autowired("gridApi")],o.prototype,"gridApi",void 0),n([t.Autowired("cellPositionUtils")],o.prototype,"cellPositionUtils",void 0),n([t.Autowired("rowPositionUtils")],o.prototype,"rowPositionUtils",void 0),n([t.PostConstruct],o.prototype,"init",null),o=n([t.Bean("clipboardService")],o)}(t.BeanStub),s={moduleName:t.ModuleNames.ClipboardModule,beans:[a],dependantModules:[o.EnterpriseCoreModule,r.CsvExportModule]};exports.ClipboardModule=s;