// Type definitions for ag-grid v16.0.1
// Project: http://www.ag-grid.com/
// Definitions by: Niall Crosby <https://github.com/ag-grid/>
import { Column } from "../entities/column";
import { RowNode } from "../entities/rowNode";
import { GridCell } from "../entities/gridCell";
import { Component } from "../widgets/component";
import { Beans } from "./beans";
import { RowComp } from "./rowComp";
export declare class CellComp extends Component {
    static DOM_DATA_KEY_CELL_COMP: string;
    private eCellWrapper;
    private eParentOfValue;
    private beans;
    private column;
    private rowNode;
    private eParentRow;
    private gridCell;
    private rangeCount;
    private usingWrapper;
    private includeSelectionComponent;
    private includeRowDraggingComponent;
    private cellFocused;
    private editingCell;
    private cellEditorInPopup;
    private hideEditorPopup;
    private lastIPadMouseClickEvent;
    private usingCellRenderer;
    private cellRendererType;
    private cellRenderer;
    private cellRendererGui;
    private cellEditor;
    private firstRightPinned;
    private lastLeftPinned;
    private rowComp;
    private rangeSelectionEnabled;
    private value;
    private valueFormatted;
    private colsSpanning;
    private scope;
    private cellEditorVersion;
    private cellRendererVersion;
    constructor(scope: any, beans: Beans, column: Column, rowNode: RowNode, rowComp: RowComp);
    getCreateTemplate(): string;
    afterAttached(): void;
    private onColumnHover();
    private onCellChanged(event);
    private getCellLeft();
    private getCellWidth();
    private onFlashCells(event);
    private setupColSpan();
    private getColSpanningList();
    private onDisplayColumnsChanged();
    private getInitialCssClasses();
    getInitialValueToRender(): string;
    getRenderedRow(): RowComp;
    isSuppressNavigable(): boolean;
    refreshCell(params?: {
        suppressFlash?: boolean;
        newData?: boolean;
        forceRefresh?: boolean;
    }): void;
    private flashCell();
    private animateCell(cssName);
    private replaceContentsAfterRefresh();
    private angular1Compile();
    private postProcessStylesFromColDef();
    private preProcessStylesFromColDef();
    private processStylesFromColDef();
    private postProcessClassesFromColDef();
    private preProcessClassesFromColDef();
    private processClassesFromColDef(onApplicableClass);
    private putDataIntoCellAfterRefresh();
    attemptCellRendererRefresh(): boolean;
    private refreshToolTip();
    private valuesAreEqual(val1, val2);
    private getToolTip();
    private processCellClassRules(onApplicableClass, onNotApplicableClass?);
    private postProcessCellClassRules();
    private preProcessCellClassRules();
    setUsingWrapper(): void;
    private chooseCellRenderer();
    private createCellRendererInstance();
    private afterCellRendererCreated(cellRendererVersion, cellRenderer);
    private attachCellRenderer();
    private createCellRendererParams();
    private formatValue(value);
    private getValueToUse();
    private getValueAndFormat();
    private getValue();
    onMouseEvent(eventName: string, mouseEvent: MouseEvent): void;
    dispatchCellContextMenuEvent(event: Event): void;
    private createEvent(domEvent, eventType);
    private onMouseOut(mouseEvent);
    private onMouseOver(mouseEvent);
    private onCellDoubleClicked(mouseEvent);
    startRowOrCellEdit(keyPress?: number, charPress?: string): void;
    isCellEditable(): boolean;
    startEditingIfEnabled(keyPress?: number, charPress?: string, cellStartedEdit?: boolean): void;
    private afterCellEditorCreated(cellEditorVersion, cellEditor);
    private addInCellEditor();
    private addPopupCellEditor();
    private onPopupEditorClosed();
    private setInlineEditingClass();
    private createCellEditorParams(keyPress, charPress, cellStartedEdit);
    private stopEditingAndFocus();
    private parseValue(newValue);
    focusCell(forceBrowserFocus?: boolean): void;
    setFocusInOnEditor(): void;
    isEditing(): boolean;
    onKeyDown(event: KeyboardEvent): void;
    doesUserWantToCancelKeyboardEvent(event: KeyboardEvent): boolean;
    setFocusOutOnEditor(): void;
    private onNavigationKeyPressed(event, key);
    private onTabKeyDown(event);
    private onBackspaceOrDeleteKeyPressed(key);
    private onEnterKeyDown();
    private navigateAfterEdit();
    private onF2KeyDown();
    private onEscapeKeyDown();
    onKeyPress(event: KeyboardEvent): void;
    private onSpaceKeyPressed(event);
    private onMouseDown();
    private isDoubleClickOnIPad();
    private onCellClicked(mouseEvent);
    private doIeFocusHack();
    private createGridCellVo();
    getGridCell(): GridCell;
    getParentRow(): HTMLElement;
    setParentRow(eParentRow: HTMLElement): void;
    getColumn(): Column;
    detach(): void;
    destroy(): void;
    private onLeftChanged();
    private onWidthChanged();
    private getRangeClasses();
    private onRowIndexChanged();
    private onRangeSelectionChanged();
    private onFirstRightPinnedChanged();
    private onLastLeftPinnedChanged();
    private populateTemplate();
    private addRowDragging();
    private addSelectionCheckbox();
    private addDomData();
    private onCellFocused(event?);
    stopRowOrCellEdit(cancel?: boolean): void;
    stopEditing(cancel?: boolean): void;
}
