// Type definitions for ag-grid v4.2.7
// Project: http://www.ag-grid.com/
// Definitions by: Niall Crosby <https://github.com/ceolter/>
// Definitions: https://github.com/borisyankov/DefinitelyTyped
import { ColumnGroup } from "../entities/columnGroup";
import { Column } from "../entities/column";
import { ColDef, AbstractColDef } from "../entities/colDef";
import { ColumnGroupChild } from "../entities/columnGroupChild";
import { OriginalColumnGroupChild } from "../entities/originalColumnGroupChild";
export declare class ColumnApi {
    private _columnController;
    sizeColumnsToFit(gridWidth: any): void;
    setColumnGroupOpened(group: ColumnGroup | string, newValue: boolean, instanceId?: number): void;
    getColumnGroup(name: string, instanceId?: number): ColumnGroup;
    getDisplayNameForCol(column: any): string;
    getColumn(key: any): Column;
    setColumnState(columnState: any): boolean;
    getColumnState(): [any];
    resetColumnState(): void;
    isPinning(): boolean;
    isPinningLeft(): boolean;
    isPinningRight(): boolean;
    getDisplayedColAfter(col: Column): Column;
    getDisplayedColBefore(col: Column): Column;
    setColumnVisible(key: Column | ColDef | String, visible: boolean): void;
    setColumnsVisible(keys: (Column | ColDef | String)[], visible: boolean): void;
    setColumnPinned(key: Column | ColDef | String, pinned: string): void;
    setColumnsPinned(keys: (Column | ColDef | String)[], pinned: string): void;
    getAllColumns(): Column[];
    getDisplayedLeftColumns(): Column[];
    getDisplayedCenterColumns(): Column[];
    getDisplayedRightColumns(): Column[];
    getAllDisplayedColumns(): Column[];
    getRowGroupColumns(): Column[];
    getValueColumns(): Column[];
    moveColumn(fromIndex: number, toIndex: number): void;
    moveRowGroupColumn(fromIndex: number, toIndex: number): void;
    setColumnAggFunction(column: Column, aggFunc: string): void;
    setColumnWidth(key: Column | string | ColDef, newWidth: number, finished?: boolean): void;
    removeValueColumn(column: Column): void;
    addValueColumn(column: Column): void;
    setRowGroupColumns(colKeys: (Column | ColDef | String)[]): void;
    removeRowGroupColumn(colKey: Column | ColDef | String): void;
    removeRowGroupColumns(colKeys: (Column | ColDef | String)[]): void;
    addRowGroupColumn(colKey: Column | ColDef | String): void;
    addRowGroupColumns(colKeys: (Column | ColDef | String)[]): void;
    setPivotColumns(colKeys: (Column | ColDef | String)[]): void;
    removePivotColumn(colKey: Column | ColDef | String): void;
    removePivotColumns(colKeys: (Column | ColDef | String)[]): void;
    addPivotColumn(colKey: Column | ColDef | String): void;
    addPivotColumns(colKeys: (Column | ColDef | String)[]): void;
    getLeftDisplayedColumnGroups(): ColumnGroupChild[];
    getCenterDisplayedColumnGroups(): ColumnGroupChild[];
    getRightDisplayedColumnGroups(): ColumnGroupChild[];
    getAllDisplayedColumnGroups(): ColumnGroupChild[];
    autoSizeColumn(key: Column | ColDef | String): void;
    autoSizeColumns(keys: (Column | ColDef | String)[]): void;
    columnGroupOpened(group: ColumnGroup | string, newValue: boolean): void;
    hideColumns(colIds: any, hide: any): void;
    hideColumn(colId: any, hide: any): void;
    setState(columnState: any): boolean;
    getState(): [any];
    resetState(): void;
}
export declare class ColumnController {
    private gridOptionsWrapper;
    private expressionService;
    private balancedColumnTreeBuilder;
    private displayedGroupCreator;
    private autoWidthCalculator;
    private eventService;
    private columnUtils;
    private gridPanel;
    private context;
    private pivotService;
    private originalBalancedTree;
    private originalHeaderRowCount;
    private originalColumns;
    private gridBalancedTree;
    private gridColumns;
    private gridHeaderRowCount;
    private displayedLeftColumnTree;
    private displayedRightColumnTree;
    private displayedCentreColumnTree;
    private displayedLeftColumns;
    private displayedRightColumns;
    private displayedCenterColumns;
    private rowGroupColumns;
    private groupAutoColumn;
    private groupAutoColumnActive;
    private valueColumns;
    private pivotColumns;
    private ready;
    private logger;
    init(): void;
    isReduce(): boolean;
    private setBeans(loggerFactory);
    private setFirstRightAndLastLeftPinned();
    autoSizeColumns(keys: (Column | ColDef | String)[]): void;
    autoSizeColumn(key: Column | String | ColDef): void;
    autoSizeAllColumns(): void;
    private getColumnsFromTree(rootColumns);
    getAllDisplayedColumnGroups(): ColumnGroupChild[];
    getOriginalColumnTree(): OriginalColumnGroupChild[];
    getHeaderRowCount(): number;
    getLeftDisplayedColumnGroups(): ColumnGroupChild[];
    getRightDisplayedColumnGroups(): ColumnGroupChild[];
    getCenterDisplayedColumnGroups(): ColumnGroupChild[];
    getDisplayedColumnGroups(type: string): ColumnGroupChild[];
    isColumnDisplayed(column: Column): boolean;
    getAllDisplayedColumns(): Column[];
    getPinnedLeftContainerWidth(): number;
    getPinnedRightContainerWidth(): number;
    addRowGroupColumns(keys: (Column | ColDef | String)[]): void;
    setRowGroupColumns(keys: (Column | ColDef | String)[]): void;
    addRowGroupColumn(key: Column | ColDef | String): void;
    removeRowGroupColumns(keys: (Column | ColDef | String)[]): void;
    removeRowGroupColumn(key: Column | ColDef | String): void;
    addPivotColumns(keys: (Column | ColDef | String)[]): void;
    setPivotColumns(keys: (Column | ColDef | String)[]): void;
    addPivotColumn(key: Column | ColDef | String): void;
    removePivotColumns(keys: (Column | ColDef | String)[]): void;
    removePivotColumn(key: Column | ColDef | String): void;
    addValueColumn(column: Column): void;
    removeValueColumn(column: Column): void;
    private normaliseColumnWidth(column, newWidth);
    setColumnWidth(key: Column | string | ColDef, newWidth: number, finished: boolean): void;
    setColumnAggFunction(column: Column, aggFunc: string): void;
    moveRowGroupColumn(fromIndex: number, toIndex: number): void;
    moveColumns(columnsToMoveKeys: (Column | ColDef | String)[], toIndex: number): void;
    private doesMovePassRules(columnsToMove, toIndex);
    moveColumn(key: string | Column | ColDef, toIndex: number): void;
    moveColumnByIndex(fromIndex: number, toIndex: number): void;
    getBodyContainerWidth(): number;
    getValueColumns(): Column[];
    getPivotColumns(): Column[];
    getRowGroupColumns(): Column[];
    isColumnRowGrouped(column: Column): boolean;
    isColumnPivoted(column: Column): boolean;
    getDisplayedCenterColumns(): Column[];
    getDisplayedLeftColumns(): Column[];
    getDisplayedRightColumns(): Column[];
    getDisplayedColumns(type: string): Column[];
    getAllOriginalColumns(): Column[];
    getAllGridColumns(): Column[];
    isEmpty(): boolean;
    isRowGroupEmpty(): boolean;
    setColumnVisible(key: Column | ColDef | String, visible: boolean): void;
    setColumnsVisible(keys: (Column | ColDef | String)[], visible: boolean): void;
    setColumnPinned(key: Column | ColDef | String, pinned: string | boolean): void;
    setColumnsPinned(keys: (Column | ColDef | String)[], pinned: string | boolean): void;
    private actionOnColumns(keys, action, createEvent);
    getDisplayedColBefore(col: any): Column;
    getDisplayedColAfter(col: Column): Column;
    isPinningLeft(): boolean;
    isPinningRight(): boolean;
    getAllColumnsIncludingAuto(): Column[];
    getColumnState(): [any];
    resetColumnState(): void;
    setColumnState(columnState: any[]): boolean;
    getGridColumns(keys: any[]): Column[];
    getColumns(keys: any[], columnLookupCallback: (key: string | ColDef | Column) => Column): Column[];
    getColumnWithValidation(key: string | ColDef | Column): Column;
    getOriginalColumn(key: string | ColDef | Column): Column;
    getGridColumn(key: string | ColDef | Column): Column;
    private getColumn(key, columnList);
    getDisplayNameForCol(column: any): string;
    getColumnGroup(colId: string | ColumnGroup, instanceId?: number): ColumnGroup;
    getColumnDept(): number;
    setColumnDefs(columnDefs: AbstractColDef[]): void;
    isReady(): boolean;
    private extractRowGroupColumns();
    private extractPivotColumns();
    setColumnGroupOpened(passedGroup: ColumnGroup | string, newValue: boolean, instanceId?: number): void;
    private getColumnGroupState();
    private setColumnGroupState(groupState);
    private updateModel();
    onPivotValueChanged(): void;
    private setupGridColumns();
    private updateGroupsAndDisplayedColumns();
    private updateDisplayedColumnsFromGroups();
    private setLeftValues();
    private addToDisplayedColumns(displayedColumnTree, displayedColumns);
    sizeColumnsToFit(gridWidth: any): void;
    private buildAllGroups(visibleColumns);
    private updateGroups();
    private createGroupAutoColumn();
    private createValueColumns();
    private getWithOfColsInList(columnList);
}
