// Type definitions for ag-grid v6.0.1
// Project: http://www.ag-grid.com/
// Definitions by: Niall Crosby <https://github.com/ceolter/>
// Definitions: https://github.com/borisyankov/DefinitelyTyped
import { RenderedCell } from "./renderedCell";
import { RowNode } from "../entities/rowNode";
import { RowRenderer } from "./rowRenderer";
import { Column } from "../entities/column";
import { GridCell } from "../entities/gridCell";
export declare class RenderedRow {
    static EVENT_RENDERED_ROW_REMOVED: string;
    private gridOptionsWrapper;
    private columnController;
    private $compile;
    private mainEventService;
    private context;
    private focusedCellController;
    private cellRendererService;
    private gridPanel;
    private ePinnedLeftRow;
    private ePinnedRightRow;
    private eBodyRow;
    private eFullWidthRow;
    private eAllRowContainers;
    private fullWidthRowComponent;
    private renderedCells;
    private scope;
    private rowNode;
    private rowIndex;
    private fullWidthRow;
    private fullWidthCellRenderer;
    private fullWidthCellRendererParams;
    private parentScope;
    private rowRenderer;
    private eBodyContainer;
    private eFullWidthContainer;
    private ePinnedLeftContainer;
    private ePinnedRightContainer;
    private destroyFunctions;
    private renderedRowEventService;
    private initialised;
    constructor(parentScope: any, rowRenderer: RowRenderer, eBodyContainer: HTMLElement, eFullWidthContainer: HTMLElement, ePinnedLeftContainer: HTMLElement, ePinnedRightContainer: HTMLElement, node: RowNode, rowIndex: number);
    private setupRowContainers();
    private setupFullWidthContainers();
    private addMouseWheelListenerToFullWidthRow();
    private setupFullWidthGroupContainers();
    private setupNormalContainers();
    init(): void;
    private addDataChangedListener();
    private angular1Compile(element);
    private addColumnListener();
    private onDisplayedColumnsChanged(event);
    private onVirtualColumnsChanged(event);
    private onGridColumnsChanged();
    private refreshCellsIntoRow();
    private removeRenderedCells(colIds);
    private ensureCellInCorrectRow(renderedCell);
    private getOrCreateCell(column);
    private onRowSelected();
    private addRowSelectedListener();
    private addHoverFunctionality();
    private addHoverClass(hover);
    private addCellFocusedListener();
    forEachRenderedCell(callback: (renderedCell: RenderedCell) => void): void;
    private addNodeDataChangedListener();
    onMouseEvent(eventName: string, mouseEvent: MouseEvent, cell: GridCell): void;
    private setTopAndHeightCss();
    private addRowIds();
    addEventListener(eventType: string, listener: Function): void;
    removeEventListener(eventType: string, listener: Function): void;
    getRenderedCellForColumn(column: Column): RenderedCell;
    getCellForCol(column: Column): HTMLElement;
    destroy(): void;
    private destroyScope();
    isDataInList(rows: any[]): boolean;
    isGroup(): boolean;
    private refreshFullWidthComponent();
    private createFullWidthComponent();
    private destroyFullWidthComponent();
    private createFullWidthParams(eRow);
    private createGroupSpanningEntireRowCell(padding);
    private createChildScopeOrNull(data);
    private addStyleFromRowStyle();
    private addStyleFromRowStyleFunc();
    private createParams();
    private createEvent(event, eventSource);
    private createRowContainer(eParent);
    private onRowDblClick(event);
    onRowClick(event: MouseEvent): void;
    getRowNode(): any;
    refreshCells(colIds: string[], animate: boolean): void;
    private addClassesFromRowClassFunc();
    private addGridClasses();
    private addClassesFromRowClass();
}
