export class Events {

    /** A new set of columns has been entered, everything has potentially changed. */
    public static EVENT_COLUMN_EVERYTHING_CHANGED = 'columnEverythingChanged';
    public static EVENT_NEW_COLUMNS_LOADED = 'newColumnsLoaded';

    /** The reduce flag was changed */
    public static EVENT_COLUMN_PIVOT_MODE_CHANGED = 'columnPivotModeChanged';
    
    /** A row group column was added, removed or order changed. */
    public static EVENT_COLUMN_ROW_GROUP_CHANGED = 'columnRowGroupChanged';

    /** A pivot column was added, removed or order changed. */
    public static EVENT_COLUMN_PIVOT_CHANGED = 'columnPivotChanged';

    /** The list of grid columns has changed. */
    public static EVENT_GRID_COLUMNS_CHANGED = 'gridColumnsChanged';

    /** A value column was added, removed or agg function was changed. */
    public static EVENT_COLUMN_VALUE_CHANGED = 'columnValueChanged';

    /** A column was moved */
    public static EVENT_COLUMN_MOVED = 'columnMoved';

    /** One or more columns was shown / hidden */
    public static EVENT_COLUMN_VISIBLE = 'columnVisible';

    /** One or more columns was pinned / unpinned*/
    public static EVENT_COLUMN_PINNED = 'columnPinned';

    /** A column group was opened / closed */
    public static EVENT_COLUMN_GROUP_OPENED = 'columnGroupOpened';

    /** One or more columns was resized. If just one, the column in the event is set. */
    public static EVENT_COLUMN_RESIZED = 'columnResized';

    /** The list of displayed columns has changed, can result from columns open / close, column move, pivot, group, etc */
    public static EVENT_DISPLAYED_COLUMNS_CHANGED = 'displayedColumnsChanged';

    /** The list of virtual columns has changed, results from viewport changing */
    public static EVENT_VIRTUAL_COLUMNS_CHANGED = 'virtualColumnsChanged';

    /** A row group was opened / closed */
    public static EVENT_ROW_GROUP_OPENED = 'rowGroupOpened';

    public static EVENT_ROW_DATA_CHANGED = 'rowDataChanged';

    public static EVENT_FLOATING_ROW_DATA_CHANGED = 'floatingRowDataChanged';

    public static EVENT_RANGE_SELECTION_CHANGED = 'rangeSelectionChanged';

    public static EVENT_COLUMN_ROW_GROUP_CHANGE_REQUEST = 'columnRowGroupChangeRequest';
    public static EVENT_COLUMN_PIVOT_CHANGE_REQUEST = 'columnPivotChangeRequest';
    public static EVENT_COLUMN_VALUE_CHANGE_REQUEST = 'columnValueChangeRequest';

    public static EVENT_COLUMN_AGG_FUNC_CHANGE_REQUEST = 'columnAggFuncChangeRequest';

    public static EVENT_FLASH_CELLS = 'clipboardPaste';
    public static EVENT_MODEL_UPDATED = 'modelUpdated';
    public static EVENT_CELL_CLICKED = 'cellClicked';
    public static EVENT_CELL_DOUBLE_CLICKED = 'cellDoubleClicked';
    public static EVENT_CELL_CONTEXT_MENU = 'cellContextMenu';
    public static EVENT_CELL_VALUE_CHANGED = 'cellValueChanged';
    public static EVENT_ROW_VALUE_CHANGED = 'rowValueChanged';
    public static EVENT_CELL_FOCUSED = 'cellFocused';
    public static EVENT_ROW_SELECTED = 'rowSelected';
    public static EVENT_SELECTION_CHANGED = 'selectionChanged';
    public static EVENT_BEFORE_FILTER_CHANGED = 'beforeFilterChanged';
    public static EVENT_FILTER_CHANGED = 'filterChanged';
    public static EVENT_AFTER_FILTER_CHANGED = 'afterFilterChanged';
    public static EVENT_FILTER_MODIFIED = 'filterModified';
    public static EVENT_BEFORE_SORT_CHANGED = 'beforeSortChanged';
    public static EVENT_SORT_CHANGED = 'sortChanged';
    public static EVENT_AFTER_SORT_CHANGED = 'afterSortChanged';
    public static EVENT_VIRTUAL_ROW_REMOVED = 'virtualRowRemoved';
    public static EVENT_ROW_CLICKED = 'rowClicked';
    public static EVENT_ROW_DOUBLE_CLICKED = 'rowDoubleClicked';
    public static EVENT_GRID_READY = 'gridReady';
    public static EVENT_GRID_SIZE_CHANGED = 'gridSizeChanged';
    public static EVENT_VIEWPORT_CHANGED = 'viewportChanged';
    public static EVENT_DRAG_STARTED = 'dragStarted';
    public static EVENT_DRAG_STOPPED = 'dragStopped';

    public static EVENT_ITEMS_ADDED = 'itemsAdded';
    public static EVENT_ITEMS_REMOVED = 'itemsRemoved';

    public static EVENT_BODY_SCROLL = 'bodyScroll';
}

export interface ModelUpdatedEvent {
    /** If true, the grid will try and animate the rows to the new positions */
    animate: boolean;
    /** If true, the grid has new data loaded, eg user called setRowData(), otherwise
     * it's the same data but sorted or filtered, in which case this is true, and rows
     * can animate around (eg rowNode id 24 is the same row node as last time). */
    keepRenderedRows: boolean;
}