import { AxiosRequestConfig } from 'axios';
import type { SessionDescription } from 'sdp-parser2';
import { default as UAParser_2 } from 'ua-parser-js';

export declare enum AgoraAPIName {
    CREATE_CLIENT = "createClient",
    CHECK_SYSTEM_REQUIREMENTS = "checkSystemRequirements",
    SET_AREA = "setArea",
    PRELOAD = "PRELOAD",
    CHECK_VIDEO_TRACK_IS_ACTIVE = "checkVideoTrackIsActive",
    CHECK_AUDIO_TRACK_IS_ACTIVE = "checkAudioTrackIsActive",
    CREATE_MIC_AUDIO_TRACK = "createMicrophoneAudioTrack",
    CREATE_CUSTOM_AUDIO_TRACK = "createCustomAudioTrack",
    CREATE_BUFFER_AUDIO_TRACK = "createBufferSourceAudioTrack",
    CREATE_CAM_VIDEO_TRACK = "createCameraVideoTrack",
    CREATE_CUSTOM_VIDEO_TRACK = "createCustomVideoTrack",
    CREATE_MIC_AND_CAM_TRACKS = "createMicrophoneAndCameraTracks",
    CREATE_SCREEN_VIDEO_TRACK = "createScreenVideoTrack",
    SET_ENCRYPTION_CONFIG = "Client.setEncryptionConfig",
    START_PROXY_SERVER = "Client.startProxyServer",
    STOP_PROXY_SERVER = "Client.stopProxyServer",
    SET_PROXY_SERVER = "Client.setProxyServer",
    SET_TURN_SERVER = "Client.setTurnServer",
    SET_CLIENT_ROLE = "Client.setClientRole",
    SET_LOW_STREAM_PARAMETER = "Client.setLowStreamParameter",
    ENABLE_DUAL_STREAM = "Client.enableDualStream",
    DISABLE_DUAL_STREAM = "Client.disableDualStream",
    JOIN = "Client.join",
    LEAVE = "Client.leave",
    PUBLISH = "Client.publish",
    UNPUBLISH = "Client.unpublish",
    SUBSCRIBE = "Client.subscribe",
    MASS_SUBSCRIBE = "Client.massSubscribe",
    MASS_UNSUBSCRIBE = "Client.massUnsubscribe",
    UNSUBSCRIBE = "Client.unsubscribe",
    RENEW_TOKEN = "Client.renewToken",
    SET_REMOTE_VIDEO_STREAM_TYPE = "Client.setRemoteVideoStreamType",
    SET_STREAM_FALLBACK_OPTION = "Client.setStreamFallbackOption",
    ENABLE_AUDIO_VOLUME_INDICATOR = "Client.enableAudioVolumeIndicator",
    SEND_CUSTOM_REPORT_MESSAGE = "Client.sendCustomReportMessage",
    INSPECT_VIDEO_CONTENT = "Client.inspectVideoContent",
    STOP_INSPECT_VIDEO_CONTENT = "Client.stopInspectVideoContent",
    JOIN_FALLBACK_TO_PROXY = "Client._joinFallbackToProxy",
    ON_LIVE_STREAM_WARNING = "Client.onLiveStreamWarning",
    ON_LIVE_STREAM_ERROR = "Client.onLiveStreamingError",
    START_LIVE_STREAMING = "Client.startLiveStreaming",
    SET_LIVE_TRANSCODING = "Client.setLiveTranscoding",
    STOP_LIVE_STREAMING = "Client.stopLiveStreaming",
    START_CHANNEL_MEDIA_RELAY = "Client.startChannelMediaRelay",
    UPDATE_CHANNEL_MEDIA_RELAY = "Client.updateChannelMediaRelay",
    STOP_CHANNEL_MEDIA_RELAY = "Client.stopChannelMediaRelay",
    REQUEST_CONFIG_DISTRIBUTE = "_config-distribute-request",
    SET_CONFIG_DISTRIBUTE = "_configDistribute",
    LOCAL_TRACK_SET_MUTED = "LocalTrack.setMute",
    LOCAL_AUDIO_TRACK_PLAY = "LocalAudioTrack.play",
    LOCAL_AUDIO_TRACK_PLAY_IN_ELEMENT = "LocalAudioTrack.playInElement",
    LOCAL_AUDIO_TRACK_STOP = "LocalAudioTrack.stop",
    LOCAL_AUDIO_TRACK_SET_VOLUME = "LocalAudioTrack.setVolume",
    MIC_AUDIO_TRACK_SET_DEVICE = "MicrophoneAudioTrack.setDevice",
    BUFFER_AUDIO_TRACK_START = "BufferSourceAudioTrack.startProcessAudioBuffer",
    BUFFER_AUDIO_TRACK_STOP = "BufferSourceAudioTrack.stopProcessAudioBuffer",
    BUFFER_AUDIO_TRACK_PAUSE = "BufferSourceAudioTrack.pauseProcessAudioBuffer",
    BUFFER_AUDIO_TRACK_RESUME = "BufferSourceAudioTrack.resumeProcessAudioBuffer",
    BUFFER_AUDIO_TRACK_SEEK = "BufferSourceAudioTrack.seekAudioBuffer",
    LOCAL_VIDEO_TRACK_PLAY = "LocalVideoTrack.play",
    LOCAL_VIDEO_TRACK_STOP = "LocalVideoTrack.stop",
    LOCAL_VIDEO_TRACK_GET_VIDEO_VISIBLE = "LocalVideoTrack.getVideoElementVisibleStatus",
    LOCAL_VIDEO_TRACK_BEAUTY = "LocalVideoTrack.setBeautyEffect",
    LOCAL_VIDEO_SEND_SEI_DATA = "LocalVideoTrack.sendSeiData",
    CAM_VIDEO_TRACK_SET_DEVICE = "CameraVideoTrack.setDevice",
    CAM_VIDEO_TRACK_SET_ENCODER_CONFIG = "CameraVideoTrack.setEncoderConfiguration",
    REMOTE_VIDEO_TRACK_PLAY = "RemoteVideoTrack.play",
    REMOTE_VIDEO_TRACK_STOP = "RemoteVideoTrack.stop",
    REMOTE_VIDEO_TRACK_GET_VIDEO_VISIBLE = "RemoteVideoTrack.getVideoElementVisibleStatus",
    REMOTE_AUDIO_TRACK_PLAY = "RemoteAudioTrack.play",
    REMOTE_AUDIO_TRACK_STOP = "RemoteAudioTrack.stop",
    REMOTE_AUDIO_SET_VOLUME = "RemoteAudioTrack.setVolume",
    REMOTE_AUDIO_SET_OUTPUT_DEVICE = "RemoteAudioTrack.setOutputDevice",
    GET_MEDIA_STREAM_TRACK = "Track.getMediaStreamTrack",
    STREAM_TYPE_CHANGE = "streamTypeChange",
    CONNECTION_STATE_CHANGE = "connectionStateChange",
    LOAD_CONFIG_FROM_LOCALSTORAGE = "loadConfigFromLocalStorage",
    IMAGE_MODERATION_UPLOAD = "imageModerationUpload",
    REPUB_AFTER_PC_CONNECTED = "repubAfterPCConnected",
    PRELOAD_MEDIA_FAILED = "preloadMediaFailed",
    MISMATCH_DTLS_PARAMETERS = "mismatchDtlsParameters"
}

export declare enum AgoraAPITag {
    TRACER = "tracer"
}

export declare interface AgoraAudioReceiverStats extends ReceiverStats {
    codec?: string;
    outputLevel?: number;
    decodingCNG?: number;
    decodingCTN?: number;
    decodingCTSG?: number;
    decodingNormal?: number;
    decodingPLC?: number;
    decodingPLCCNG?: number;
    expandRate?: number;
    preemptiveExpandRate?: number;
    secondaryDecodedRate?: number;
    speechExpandRate?: number;
    preferredJitterBufferMs?: number;
    jitterBufferMs: number;
    jitterMs: number;
    accelerateRate?: number;
    receivedFrames: number;
    droppedFrames: number;
    bytes: number;
    packets: number;
    packetsLost: number;
    packetsDiscarded: number;
    packetLostRate: number;
    ssrc: number;
    concealedSamples: number;
    totalSamplesReceived: number;
    silentConcealedSamples: number;
    concealmentEvents: number;
    freezeSamples80: number;
    freezeMs80: number;
    freezeSamples200: number;
    freezeMs200: number;
    totalProcessingDelay?: number;
    jitterBufferEmittedCount?: number;
    avgProcessingDelayMs?: number;
}

export declare interface AgoraAudioSenderStats extends SenderStats {
    codec?: string;
    inputLevel?: number;
    aecReturnLoss?: number;
    aecReturnLossEnhancement?: number;
    residualEchoLikelihood?: number;
    residualEchoLikelihoodRecentMax?: number;
    bytes: number;
    packets: number;
    packetsLost: number;
    packetLostRate: number;
    ssrc: number;
    rttMs: number;
    jitterMs: number;
    timestamp?: DOMHighResTimeStamp;
}

export declare interface AgoraBitrateStats {
    actualEncoded: number;
    transmit: number;
    targetEncoded?: number;
    retransmit?: number;
}

export declare class AgoraLegacyStatsFilter extends AgoraWebRTCStatsFilter {
    private _stats;
    private lastDecodeVideoReceiverStats;
    protected updateStats(): Promise<void>;
    private processBandwidthStats;
    private processSSRCStats;
    private _getStats;
    private statsResponsesToObjects;
}

export declare interface AgoraPCStats {
    timestamp: number;
    bitrate: AgoraBitrateStats;
    sendBandwidth?: number;
    rtt?: number;
    selectedCandidatePair: SelectedCandidatePairStats;
    sendPacketLossRate: number;
    recvPacketLossRate: number;
    videoSend: AgoraVideoSenderStats[];
    audioSend: AgoraAudioSenderStats[];
    videoRecv: AgoraVideoReceiverStats[];
    audioRecv: AgoraAudioReceiverStats[];
    qualityLimitationReason?: QualityLimitationReason;
    updateInterval?: number;
}

/**
 * @ignore
 */
export declare class AgoraRTCError extends Error implements IAgoraRTCError {
    readonly code: AgoraRTCErrorCode;
    readonly message: string;
    readonly data?: any;
    readonly name: string;
    constructor(code: AgoraRTCErrorCode, message?: string, data?: any);
    toString(): string;
    print(level?: "error" | "warning", logger?: any): AgoraRTCError;
    throw(logger?: any): never;
}

/**
 * @ignore
 */
export declare enum AgoraRTCErrorCode {
    UNEXPECTED_ERROR = "UNEXPECTED_ERROR",
    UNEXPECTED_RESPONSE = "UNEXPECTED_RESPONSE",
    TIMEOUT = "TIMEOUT",
    INVALID_PARAMS = "INVALID_PARAMS",
    NOT_READABLE = "NOT_READABLE",
    NOT_SUPPORTED = "NOT_SUPPORTED",
    INVALID_OPERATION = "INVALID_OPERATION",
    OPERATION_ABORTED = "OPERATION_ABORTED",
    WEB_SECURITY_RESTRICT = "WEB_SECURITY_RESTRICT",
    EXCHANGE_SDP_FAILED = "EXCHANGE_SDP_FAILED",
    ADD_CANDIDATE_FAILED = "ADD_CANDIDATE_FAILED",
    DATACHANNEL_FAILED = "DATACHANNEL_FAILED",
    NETWORK_ERROR = "NETWORK_ERROR",
    NETWORK_TIMEOUT = "NETWORK_TIMEOUT",
    NETWORK_RESPONSE_ERROR = "NETWORK_RESPONSE_ERROR",
    API_INVOKE_TIMEOUT = "API_INVOKE_TIMEOUT",
    ENUMERATE_DEVICES_FAILED = "ENUMERATE_DEVICES_FAILED",
    DEVICE_NOT_FOUND = "DEVICE_NOT_FOUND",
    ELECTRON_IS_NULL = "ELECTRON_IS_NULL",
    ELECTRON_DESKTOP_CAPTURER_GET_SOURCES_ERROR = "ELECTRON_DESKTOP_CAPTURER_GET_SOURCES_ERROR",
    CHROME_PLUGIN_NO_RESPONSE = "CHROME_PLUGIN_NO_RESPONSE",
    CHROME_PLUGIN_NOT_INSTALL = "CHROME_PLUGIN_NOT_INSTALL",
    MEDIA_OPTION_INVALID = "MEDIA_OPTION_INVALID",
    PERMISSION_DENIED = "PERMISSION_DENIED",
    CONSTRAINT_NOT_SATISFIED = "CONSTRAINT_NOT_SATISFIED",
    TRACK_IS_DISABLED = "TRACK_IS_DISABLED",
    GET_VIDEO_ELEMENT_VISIBLE_ERROR = "GET_VIDEO_ELEMENT_VISIBLE_ERROR",
    SHARE_AUDIO_NOT_ALLOWED = "SHARE_AUDIO_NOT_ALLOWED",
    LOW_STREAM_ENCODING_ERROR = "LOW_STREAM_ENCODING_ERROR",
    SET_ENCODING_PARAMETER_ERROR = "SET_ENCODING_PARAMETER_ERROR",
    TRACK_STATE_UNREACHABLE = "TRACK_STATE_UNREACHABLE",
    INVALID_UINT_UID_FROM_STRING_UID = "INVALID_UINT_UID_FROM_STRING_UID",
    CAN_NOT_GET_PROXY_SERVER = "CAN_NOT_GET_PROXY_SERVER",
    CAN_NOT_GET_GATEWAY_SERVER = "CAN_NOT_GET_GATEWAY_SERVER",
    VOID_GATEWAY_ADDRESS = "VOID_GATEWAY_ADDRESS",
    UID_CONFLICT = "UID_CONFLICT",
    MULTI_UNILBS_RESPONSE_ERROR = "MULTI_UNILBS_RESPONSE_ERROR",
    UPDATE_TICKET_FAILED = "UPDATE_TICKET_FAILED",
    TOKEN_EXPIRE = "TOKEN_EXPIRE",
    INVALID_LOCAL_TRACK = "INVALID_LOCAL_TRACK",
    INVALID_TRACK = "INVALID_TRACK",
    SENDER_NOT_FOUND = "SENDER_NOT_FOUND",
    CREATE_OFFER_FAILED = "CREATE_OFFER_FAILED",
    SET_ANSWER_FAILED = "SET_ANSWER_FAILED",
    ICE_FAILED = "ICE_FAILED",
    PC_CLOSED = "PC_CLOSED",
    SENDER_REPLACE_FAILED = "SENDER_REPLACE_FAILED",
    GET_LOCAL_CAPABILITIES_FAILED = "GET_LOCAL_CAPABILITIES_FAILED",
    GET_LOCAL_CONNECTION_PARAMS_FAILED = "GET_LOCAL_CONNECTION_PARAMS_FAILED",
    SUBSCRIBE_FAILED = "SUBSCRIBE_FAILED",
    UNSUBSCRIBE_FAILED = "UNSUBSCRIBE_FAILED",
    GATEWAY_P2P_LOST = "GATEWAY_P2P_LOST",
    NO_ICE_CANDIDATE = "NO_ICE_CANDIDATE",
    CAN_NOT_PUBLISH_MULTIPLE_VIDEO_TRACKS = "CAN_NOT_PUBLISH_MULTIPLE_VIDEO_TRACKS",
    EXIST_DISABLED_VIDEO_TRACK = "EXIST_DISABLED_VIDEO_TRACK",
    INVALID_REMOTE_USER = "INVALID_REMOTE_USER",
    REMOTE_USER_IS_NOT_PUBLISHED = "REMOTE_USER_IS_NOT_PUBLISHED",
    CUSTOM_REPORT_SEND_FAILED = "CUSTOM_REPORT_SEND_FAILED",
    CUSTOM_REPORT_FREQUENCY_TOO_HIGH = "CUSTOM_REPORT_FREQUENCY_TOO_HIGH",
    FETCH_AUDIO_FILE_FAILED = "FETCH_AUDIO_FILE_FAILED",
    READ_LOCAL_AUDIO_FILE_ERROR = "READ_LOCAL_AUDIO_FILE_ERROR",
    DECODE_AUDIO_FILE_FAILED = "DECODE_AUDIO_FILE_FAILED",
    WS_ABORT = "WS_ABORT",
    WS_DISCONNECT = "WS_DISCONNECT",
    WS_ERR = "WS_ERR",
    EXTERNAL_SIGNAL_ABORT = "EXTERNAL_SIGNAL_ABORT",
    LIVE_STREAMING_TASK_CONFLICT = "LIVE_STREAMING_TASK_CONFLICT",
    LIVE_STREAMING_INVALID_ARGUMENT = "LIVE_STREAMING_INVALID_ARGUMENT",
    LIVE_STREAMING_INTERNAL_SERVER_ERROR = "LIVE_STREAMING_INTERNAL_SERVER_ERROR",
    LIVE_STREAMING_PUBLISH_STREAM_NOT_AUTHORIZED = "LIVE_STREAMING_PUBLISH_STREAM_NOT_AUTHORIZED",
    LIVE_STREAMING_TRANSCODING_NOT_SUPPORTED = "LIVE_STREAMING_TRANSCODING_NOT_SUPPORTED",
    LIVE_STREAMING_CDN_ERROR = "LIVE_STREAMING_CDN_ERROR",
    LIVE_STREAMING_INVALID_RAW_STREAM = "LIVE_STREAMING_INVALID_RAW_STREAM",
    LIVE_STREAMING_WARN_STREAM_NUM_REACH_LIMIT = "LIVE_STREAMING_WARN_STREAM_NUM_REACH_LIMIT",
    LIVE_STREAMING_WARN_FAILED_LOAD_IMAGE = "LIVE_STREAMING_WARN_FAILED_LOAD_IMAGE",
    LIVE_STREAMING_WARN_FREQUENT_REQUEST = "LIVE_STREAMING_WARN_FREQUENT_REQUEST",
    WEBGL_INTERNAL_ERROR = "WEBGL_INTERNAL_ERROR",
    BEAUTY_PROCESSOR_INTERNAL_ERROR = "BEAUTY_PROCESSOR_INTERNAL_ERROR",
    CROSS_CHANNEL_WAIT_STATUS_ERROR = "CROSS_CHANNEL_WAIT_STATUS_ERROR",
    CROSS_CHANNEL_FAILED_JOIN_SRC = "CROSS_CHANNEL_FAILED_JOIN_SEC",
    CROSS_CHANNEL_FAILED_JOIN_DEST = "CROSS_CHANNEL_FAILED_JOIN_DEST",
    CROSS_CHANNEL_FAILED_PACKET_SENT_TO_DEST = "CROSS_CHANNEL_FAILED_PACKET_SENT_TO_DEST",
    CROSS_CHANNEL_SERVER_ERROR_RESPONSE = "CROSS_CHANNEL_SERVER_ERROR_RESPONSE",
    METADATA_OUT_OF_RANGE = "METADATA_OUT_OF_RANGE",
    LOCAL_AEC_ERROR = "LOCAL_AEC_ERROR",
    INVALID_PLUGIN = "INVALID_PLUGIN",
    DISCONNECT_P2P = "DISCONNECT_P2P",
    CONVERTING_IMAGEDATA_TO_BLOB_FAILED = "CONVERTING_IMAGEDATA_TO_BLOB_FAILED",
    CONVERTING_VIDEO_FRAME_TO_BLOB_FAILED = "CONVERTING_VIDEO_FRAME_TO_BLOB_FAILED",
    INIT_DATACHANNEL_TIMEOUT = "INIT_DATACHANNEL_TIMEOUT",
    CREATE_DATACHANNEL_ERROR = "CREATE_DATACHANNEL_ERROR",
    DATACHANNEL_CONNECTION_TIMEOUT = "DATACHANNEL_CONNECTION_TIMEOUT",
    PROHIBITED_OPERATION = "PROHIBITED_OPERATION",
    IMAGE_MODERATION_UPLOAD_FAILED = "IMAGE_MODERATION_UPLOAD_FAILED",
    P2P_MESSAGE_FAILED = "P2P_MESSAGE_FAILED"
}

export declare class AgoraSpecStatsFilter extends AgoraWebRTCStatsFilter {
    private _stats;
    private report;
    private lastDecodeVideoReceiverStats;
    private lastVideoFramesRecv;
    private lastVideoFramesSent;
    private lastVideoFramesDecode;
    private lastVideoFramesOutput;
    private lastVideoJBDelay;
    private lastAudioJBDelay;
    private mediaBytesSent;
    private mediaBytesRetransmit;
    private mediaBytesTargetEncode;
    private lastDecodeAudioReceiverStats;
    private lastAudioConcealment;
    private lastEncoderMs;
    protected updateStats(): Promise<void>;
    getSelectedCandidatePair(): Promise<IceCandidatePair>;
    private processCandidatePairStats;
    private processCandidateStats;
    private processAudioInboundStats;
    private calculateAudioFreeze;
    private processVideoInboundStats;
    private processVideoOutboundStats;
    private processAudioOutboundStats;
    private findRemoteStatsId;
    private processVideoMediaSource;
    private processAudioMediaSource;
    private processVideoTrackSenderStats;
    private processVideoTrackReceiverStats;
    private processAudioTrackSenderStats;
    private processAudioTrackReceiverStats;
    private processRemoteInboundStats;
    private getCodecFromCodecStats;
    private updateSendBitrate;
}

export declare interface AgoraVideoReceiverStats extends ReceiverStats {
    codec?: string;
    targetDelayMs?: number;
    renderDelayMs?: number;
    currentDelayMs?: number;
    minPlayoutDelayMs?: number;
    maxDecodeMs?: number;
    decodeMs?: number;
    receivedFrame?: VideoFrameState;
    decodedFrame?: VideoFrameState;
    outputFrame?: VideoFrameState;
    jitterBufferMs?: number;
    firsCount: number;
    nacksCount: number;
    plisCount: number;
    framesDecodeCount: number;
    framesDroppedCount: number;
    totalFreezesDuration?: number;
    framesDecodeInterval: number;
    framesDecodeFreezeTime: number;
    decodeFrameRate: number;
    outputFrameRate: number;
    framesReceivedCount?: number;
    framesRateFirefox?: number;
    bytes: number;
    packets: number;
    packetsLost: number;
    packetLostRate: number;
    ssrc: number;
    qpSumPerFrame: number;
    totalInterFrameDelay?: number;
    totalSquaredInterFrameDelay?: number;
    packetsDiscarded?: number;
    framesAssembledFromMultiplePackets?: number;
    totalProcessingDelay?: number;
    avgDecodeMs?: number;
    avgFramesAssembledFromMultiplePacketsMs?: number;
    avgProcessingDelayMs?: number;
    avgInterFrameDelayMs?: number;
    totalAssemblyTime?: number;
    keyFramesDecoded?: number;
}

export declare interface AgoraVideoSenderStats extends SenderStats {
    codec?: string;
    avgEncodeMs?: number;
    adaptionChangeReason?: "none" | "cpu" | "bandwidth" | "other";
    inputFrame?: VideoFrameState;
    sentFrame?: VideoFrameState;
    firsCount: number;
    nacksCount: number;
    plisCount: number;
    frameCount: number;
    bytes: number;
    packets: number;
    packetsLost: number;
    packetLostRate: number;
    ssrc: number;
    rttMs: number;
    jitterMs: number;
    qpSumPerFrame: number;
    timestamp?: DOMHighResTimeStamp;
    scalabilityMode?: ScalabilityMode;
    hugeFramesSent?: number;
    keyFramesEncoded?: number;
    targetBitrate?: number;
}

export declare abstract class AgoraWebRTCStatsFilter {
    onFirstVideoReceived?: (ssrcId: number) => void;
    onFirstVideoDecoded?: (ssrcId: number, width: number, height: number) => void;
    onFirstAudioReceived?: (ssrcId: number) => void;
    onFirstVideoDecodedTimeout?: (ssrcId: number) => void;
    onFirstAudioDecoded?: (ssrcId: number) => void;
    onSelectedLocalCandidateChanged?: (cur: CandidateStats, prev: CandidateStats) => void;
    onSelectedRemoteCandidateChanged?: (cur: CandidateStats, prev: CandidateStats) => void;
    videoIsReady: boolean;
    videoIsReady2: Record<number, boolean>;
    protected pc?: RTCPeerConnection;
    protected options: StatsFilterOptions;
    protected intervalTimer: number;
    protected stats: AgoraPCStats;
    protected isFirstVideoReceived: Record<number, boolean>;
    protected isFirstVideoDecoded: Record<number, boolean>;
    protected isFirstAudioReceived: Record<number, boolean>;
    protected isFirstAudioDecoded: Record<number, boolean>;
    protected isFirstVideoDecodedTimeout: Record<number, boolean>;
    private lossRateWindowStats;
    constructor(pc: RTCPeerConnection, options: StatsFilterOptions);
    getStats(): AgoraPCStats;
    getSelectedCandidatePair(): Promise<IceCandidatePair>;
    setVideoIsReady(isReady: boolean): void;
    setVideoIsReady2(ssrcId: number, isReady: boolean): void;
    getVideoIsReady(ssrcId: number): boolean;
    setIsFirstAudioDecoded(isFirstAudioDecoded: boolean): void;
    destroy(): void;
    protected calcLossRate(stats: AgoraPCStats): void;
    protected abstract updateStats(): Promise<void>;
}

export declare const appendBuffer: (buffer1: Uint8Array, buffer2: Uint8Array) => Uint8Array<ArrayBuffer>;

export declare function atom(className: string, mutexPropertyKey: string): <T extends Record<string, any>>(target: T, propertyKey: string, descriptor: TypedPropertyDescriptor<any>) => TypedPropertyDescriptor<any>;

/**
 *
 * The latency level of an audience member in a live interactive streaming. Takes effect only when the user role is `"audience"`.
 * - `1`: Low latency.
 * - `2`: (Default) Ultra low latency.
 */
export declare enum AudienceLatencyLevelType {
    /**
     * Low latency.
     */
    AUDIENCE_LEVEL_LOW_LATENCY = 1,
    /**
     * Ultra-low latency.
     */
    AUDIENCE_LEVEL_ULTRA_LOW_LATENCY = 2,
    /**
     * @ignore
     */
    AUDIENCE_LEVEL_SYNC_LATENCY = 3
}

export declare enum AudioCodec {
    opus = "opus",
    pcma = "pcma",
    pcmu = "pcmu",
    g722 = "g722"
}

export declare function base64ToUint8Array(base64Str: string): Uint8Array;

export declare interface BrowserInfo {
    name: BrowserName | string;
    os: BrowserOS | string | null;
    version: string;
    browserVersion?: string;
    osVersion?: string;
    deviceType?: string;
}

export declare enum BrowserName {
    CHROME = "Chrome",
    SAFARI = "Safari",
    EDGE = "Edge",
    FIREFOX = "Firefox",
    OPERA = "OPR",
    QQ = "QQBrowser",
    WECHAT = "MicroMessenger"
}

export declare enum BrowserOS {
    WIN_10 = "Windows 10",
    WIN_81 = "Windows 8.1",
    WIN_8 = "Windows 8",
    WIN_7 = "Windows 7",
    WIN_VISTA = "Windows Vista",
    WIN_SERVER_2003 = "Windows Server 2003",
    WIN_XP = "Windows XP",
    WIN_2000 = "Windows 2000",
    ANDROID = "Android",
    HARMONY_OS = "HarmonyOS",
    OPEN_BSD = "Open BSD",
    SUN_OS = "Sun OS",
    LINUX = "Linux",
    IOS = "iOS",
    MAC_OS = "Mac OS",
    CHROMIUM_OS = "Chromium OS",
    QNX = "QNX",
    UNIX = "UNIX",
    BEOS = "BeOS",
    OS_2 = "OS/2",
    SEARCH_BOT = "Search Bot"
}

export declare function bufferToStr(buffer: ArrayBuffer, base: number): string;

export declare const BUILD: string;

export declare interface CancelablePromise<T> extends Promise<T> {
    cancel: () => void;
}

export declare interface CandidateStats {
    address: string;
    candidateType: RTCIceCandidateType | "unknown";
    id: string;
    port: number;
    priority: number;
    protocol: string;
    type: string;
    relayProtocol?: string;
}

export declare function checkIsEqual(a: any, b: any): boolean;

export declare function checkValidArray(array: any, name: string): void;

export declare function checkValidBoolean(value: any, name: string): void;

export declare function checkValidConstrainLong(num: any, name: string): void;

export declare function checkValidEnum<T>(value: any, name: string, list: T[]): void;

export declare function checkValidNumber(num: any, name: string, min?: number, max?: number, forceInteger?: boolean): void;

export declare function checkValidString(string: any, name: string, lenMin?: number, lenMax?: number, ascii?: boolean): void;

/**
 * @ignore
 */
export declare type CheckVisibleResult = VisibleResultInner | VisibleHiddenResult;

declare type CheckVisibleResultInner = VisibleResultInner | VisibleHiddenResultInner;

/**
 * Interface for defining the behavior of a web client.
 *
 * You need to configure it when calling the {@link createClient} method to create a web client.
 *
 * > The [mode]{@link ClientConfig.mode} and [codec]{@link ClientConfig.codec} properties are required.
 */
export declare interface ClientConfig {
    /**
     * The codec that the Web browser uses for encoding.
     * - `"vp8"`: Use VP8 for encoding.
     * - `"h264"`: Use H.264 for encoding.
     * - `"vp9"`: (Beta) Use VP9 for encoding.
     * - `"av1"`: (Beta) Use AV1 for encoding.
     *
     * > Safari 12.1 or earlier does not support the VP8 codec.
     */
    codec: SDK_CODEC;
    /**
     * @ignore
     */
    audioCodec?: SDK_AUDIO_CODEC;
    /**
     * The channel profile.
     *
     * The SDK differentiates channel profiles and applies different optimization algorithms accordingly. For example, it prioritizes smoothness and low latency for a video call, and prioritizes video quality for a video streaming.
     *
     * The SDK supports the following channel profiles:
     * - `"live"`: Sets the channel profile as live streaming. You need to go on to call [setClientRole]{@link IAgoraRTCClient.setClientRole} to set the client as either a host or an audience. A host can send and receive audio or video, while an audience can only receive audio or video.
     * - `"rtc"`: Sets the channel profile as communication. It is used for a one-on-one call or a group call where all users in the channel can converse freely.
     */
    mode: SDK_MODE;
    /**
     * The user role in a live interactive streaming (when [mode]{@link ClientConfig.mode} is `"live"`).
     *
     * The user role determines the permissions that the SDK grants to a user, such as permission to publish local streams, subscribe to remote streams, and push streams to a CDN address. You can set the user role as `"host"` or `"audience"`. A host can publish and subscribe to tracks, while an audience member can only subscribe to tracks. The default role in a live streaming is `"audience"`. Before publishing tracks, you must set the user role as `"host"`.
     *
     * After creating a client, you can call {@link setClientRole} to switch the user role.
     */
    role?: ClientRole;
    /**
     * The detailed options of the user role, including user level.
     *
     * The user level determines the level of services that a user can enjoy within the permissions of the user's role. For example, an audience can choose to receive remote streams with low latency or ultra low latency. Levels affect prices.
     */
    clientRoleOptions?: ClientRoleOptions;
    /**
     * @ignore
     */
    proxyServer?: string;
    /**
     * @ignore
     */
    turnServer?: TurnServerConfig;
    /**
     * @ignore
     */
    httpRetryConfig?: RetryConfiguration;
    /**
     * @ignore
     */
    websocketRetryConfig?: RetryConfiguration;
    forceWaitGatewayResponse?: boolean;
}

export declare enum ClientEvents {
    PEERCONNECTION_STATE_CHANGE = "peerconnection-state-change",
    AUDIO_METADATA = "audio-metadata",
    AUDIO_PTS = "audio-pts",
    CONNECTION_STATE_CHANGE = "connection-state-change",
    MEDIA_RECONNECT_START = "media-reconnect-start",
    MEDIA_RECONNECT_END = "media-reconnect-end",
    IS_USING_CLOUD_PROXY = "is-using-cloud-proxy",
    USER_JOINED = "user-joined",
    USER_LEAVED = "user-left",
    USER_PUBLISHED = "user-published",
    USER_UNPUBLISHED = "user-unpublished",
    USER_INFO_UPDATED = "user-info-updated",
    CLIENT_BANNED = "client-banned",
    CHANNEL_MEDIA_RELAY_STATE = "channel-media-relay-state",
    CHANNEL_MEDIA_RELAY_EVENT = "channel-media-relay-event",
    VOLUME_INDICATOR = "volume-indicator",
    CRYPT_ERROR = "crypt-error",
    ON_TOKEN_PRIVILEGE_WILL_EXPIRE = "token-privilege-will-expire",
    ON_TOKEN_PRIVILEGE_DID_EXPIRE = "token-privilege-did-expire",
    NETWORK_QUALITY = "network-quality",
    STREAM_TYPE_CHANGED = "stream-type-changed",
    STREAM_FALLBACK = "stream-fallback",
    RECEIVE_METADATA = "receive-metadata",
    STREAM_MESSAGE = "stream-message",
    LIVE_STREAMING_ERROR = "live-streaming-error",
    LIVE_STREAMING_WARNING = "live-streaming-warning",
    EXCEPTION = "exception",
    ERROR = "error",
    P2P_LOST = "p2p_lost",
    JOIN_FALLBACK_TO_PROXY = "join-fallback-to-proxy",
    CHANNEL_FALLBACK_TO_WEBSOCKET = "channel-fallback-to-websocket",
    MEDIA_CONNECTION_TYPE_CHANGE = "media-connection-type-change",
    PUBLISHED_USER_LIST = "published-user-list",
    /** @internal */
    CONTENT_INSPECT_CONNECTION_STATE_CHANGE = "content-inspect-connection-state-change",
    /** @internal */
    CONTENT_INSPECT_ERROR = "content-inspect-error",
    /** @internal */
    CONTENT_INSPECT_RESULT = "content-inspect-result",
    IMAGE_MODERATION_CONNECTION_STATE_CHANGE = "image-moderation-connection-state-change"
}

/**
 * The user role in a live broadcast channel.
 * - `"host"`: Host. A host can both publish tracks and subscribe to tracks.
 * - `"audience"`: Audience. An audience can only subscribe to tracks.
 */
export declare type ClientRole = "audience" | "host";

export declare interface ClientRoleOptions {
    /**
     * The latency level of an audience member in a live interactive streaming.
     *
     * > Note:
     * > - Takes effect only when the user role is `"audience"`.
     * > - Levels affect prices.
     */
    level: AudienceLatencyLevelType;
    /**
     * @ignore
     */
    delay?: number;
}

export declare type CloudProxyServerMode = "disabled" | "proxy3" | "proxy4" | "proxy5" | "proxy6" | "fallback";

export declare function compareArray<T>(a: T[], b: T[]): boolean;

export declare function concurrent<T = void>(uuid: string, concurrency: number, method: Function, ...params: any[]): Promise<T>;

export declare enum CONFIG_DISTRIBUTE_TYPE {
    REALTIME = 1
}

/**
 * Reason for the disconnection.
 */
export declare enum ConnectionDisconnectedReason {
    /**
     * The user has left the channel.
     */
    LEAVE = "LEAVE",
    /**
     * The network is down, and cannot recover after retry.
     */
    NETWORK_ERROR = "NETWORK_ERROR",
    /**
     * The server returns an error. This is usually caused by incorrect parameter settings.
     */
    SERVER_ERROR = "SERVER_ERROR",
    /**
     * The user is banned.
     */
    UID_BANNED = "UID_BANNED",
    /**
     * @ignore
     */
    FALLBACK = "FALLBACK",
    /**
     * The IP is banned.
     */
    IP_BANNED = "IP_BANNED",
    /**
     * The channel is banned.
     */
    CHANNEL_BANNED = "CHANNEL_BANNED",
    /**
     * @ignore
     */
    LICENSE_MISSING = "LICENSE_MISSING",
    /**
     * @ignore
     */
    LICENSE_EXPIRED = "LICENSE_EXPIRED",
    /**
     * @ignore
     */
    LICENSE_MINUTES_EXCEEDED = "LICENSE_MINUTES_EXCEEDED",
    /**
     * @ignore
     */
    LICENSE_PERIOD_INVALID = "LICENSE_PERIOD_INVALID",
    /**
     * @ignore
     */
    LICENSE_MULTIPLE_SDK_SERVICE = "LICENSE_MULTIPLE_SDK_SERVICE",
    /**
     * @ignore
     */
    LICENSE_ILLEGAL = "LICENSE_ILLEGAL",
    /**
     * The user's token expires.
     */
    TOKEN_EXPIRE = "TOKEN_EXPIRE"
}

/**
 * Connection state between the SDK and Agora's edge server.
 *
 * You can get the connection state through [connectionState]{@link IAgoraRTCClient.connectionState}.
 *
 * The connection between the SDK and the edge server has the following states:
 * - `"DISCONNECTED"`: The SDK is disconnected from the server.
 *  - This is the initial state until you call [join]{@link IAgoraRTCClient.join}.
 *  - The SDK also enters this state after you call [leave]{@link IAgoraRTCClient.leave}, when the user is banned, or when the connection fails.
 * - `"CONNECTING"`: The SDK is connecting to the server. The SDK enters this state when you call [join]{@link IAgoraRTCClient.join}.
 * - `"CONNECTED"`: The SDK is connected to the server and joins a channel. The user can now publish streams or subscribe to streams in the channel.
 * - `"RECONNECTING"`: The SDK is reconnecting to the server. If the connection is lost because the network is down or switched, the SDK enters this state.
 * - `"DISCONNECTING"`: The SDK is disconnecting from the server. The SDK enters this state when you call [leave]{@link IAgoraRTCClient.leave}.
 */
export declare type ConnectionState = "DISCONNECTED" | "CONNECTING" | "RECONNECTING" | "CONNECTED" | "DISCONNECTING";

export declare function constrainLongToNumber(value: ConstrainULong): number;

export declare function convertStringToFixedLengthUint8Array(input: string, length?: number): Uint8Array;

export declare function createDefer<T = void>(): Deferred<T>;

export declare function createInternalUnexpectedError(message: string, data?: any): AgoraRTCError;

export declare function createResolvedDefer<T = void>(value: T): Deferred<T>;

export declare function createTimeoutDefer(duration?: number): Deferred<void>;

export declare function createWebRTCStatsFilter(pc: RTCPeerConnection, updateInterval?: number, lossRateInterval?: number, freezeRateLimit?: number, firstVideoDecodedTimeout?: number): AgoraWebRTCStatsFilter;

export declare const CRYPTO_HEADER_LENGTH = 10;

export declare const CRYPTO_ITERATIONS = 1000;

export declare const CRYPTO_IV_LENGTH: number;

export declare const CRYPTO_TAG_LENGTH: number;

declare type CryptoMode = "aes-128-gcm2" | "aes-256-gcm2";

export declare interface DataChannelMessage {
    uid: number;
    stream_id: number;
    ordered: boolean;
    max_retrans_times: number;
    metadata: string;
}

export declare function decryptAesGcm(iv: Uint8Array, key: CryptoKey, payload: Uint8Array): Promise<Uint8Array>;

export declare const DEFAULT_AREAS: string[];

export declare const DEFAULT_AUDIO_RECV_STATS: AgoraAudioReceiverStats;

export declare const DEFAULT_AUDIO_SEND_STATS: AgoraAudioSenderStats;

export declare const DEFAULT_CANDIDATE_STATS: CandidateStats;

export declare const DEFAULT_PC_STATS: AgoraPCStats;

export declare const DEFAULT_RETRY_CONFIG: RetryConfiguration;

export declare const DEFAULT_TURN_CONFIG: TurnServerConfig;

export declare const DEFAULT_VIDEO_RECV_STATS: AgoraVideoReceiverStats;

export declare const DEFAULT_VIDEO_SEND_STATS: AgoraVideoSenderStats;

export declare interface Deferred<T = void> {
    promise: Promise<T>;
    isResolved: boolean;
    isRejected: boolean;
    isFinished: boolean;
    value?: T;
    resolve: (value: T) => void;
    reject: (reason: unknown) => void;
    cancel: (reason?: unknown) => void;
}

export declare function deprecatedGetBrowserInfo(userAgent?: string): BrowserInfo;

export declare function detectSecureContext(): boolean;

export declare function dividePackage<T>(source: T, key: string, mtu: number): T[];

export declare function domLoadedPromise(): Promise<void>;

declare type Electron = any;

/**
 * Information of the sharing screen source on Electron, which is retrieved by calling {@link getElectronScreenSources}.
 *
 * See [DesktopCapturerSource](https://www.electronjs.org/docs/api/structures/desktop-capturer-source) in the Electron API documentation for details.
 */
export declare interface ElectronDesktopCapturerSource {
    /**
     * The ID of the screen source.
     */
    id: string;
    /**
     * The name of the screen source.
     */
    name: string;
    /**
     * The thumbnail of the screen source.
     *
     * See [ElectronNativeImage](https://electronjs.org/docs/api/native-image#nativeimage) for details.
     */
    thumbnail: IElectronNativeImage;
}

declare class ElementVisibleChecker {
    private _clientSize;
    private getClientWidth;
    private getClientHeight;
    private getStyle;
    private checkCssVisibleProperty;
    private checkPropertyUpToAllParentNodes;
    private checkActualCssVisibleIncludeInherit;
    private getSizeAboutClient;
    private checkActualSize;
    private elementFromPoint;
    private checkCoverForAPoint;
    private getPointPositionList;
    private checkElementCover;
    private checkSizeIsVisible;
    private checkSizeOfPartInClient;
    private returnHiddenResult;
    checkOneElementVisible: (element?: HTMLElement) => CheckVisibleResultInner;
    private checkElementIsMountedOnDom;
}

export declare const elementVisibleChecker: ElementVisibleChecker;

export declare function emitAsInvoker<T = any, E = AgoraRTCError>(emitter: EventEmitter, event: string, ...args: any[]): T;

export declare function emitAsInvokerNoResponse<T = any, E = AgoraRTCError>(emitter: EventEmitter, event: string, ...args: any[]): T | null;

export declare function emitAsPromise<T = any>(emitter: EventEmitter, event: string, ...args: any[]): Promise<T>;

export declare function emitAsPromiseNoResponse(emitter: EventEmitter, event: string, ...args: any[]): Promise<void>;

export declare function encryptAesGcm(iv: Uint8Array, key: CryptoKey, payload: Uint8Array): Promise<Uint8Array>;

/**
 * The encryption mode, which is used in the {@link setEncryptionConfig} method call.
 * - `"aes-128-xts"`: 128-bit AES encryption, XTS mode.
 * - `"aes-256-xts"`: 256-bit AES encryption, XTS mode.
 * - `"aes-128-gcm"`: 128-bit AES encryption, GCM mode.
 * - `"aes-256-gcm"`: 256-bit AES encryption, GCM mode.
 * - `"aes-128-gcm2"`: 128-bit AES encryption, GCM mode, with salt.
 * - `"aes-256-gcm2"`: 256-bit AES encryption, GCM mode, with salt.
 * - `"aes-128-ecb"`: 128-bit AES encryption, ECB mode.
 * - `"sm4-128-ecb"`: 128-bit SM4 encryption, ECB mode.
 * - `"none"`: No encryption.
 */
export declare type EncryptionMode = "aes-128-xts" | "aes-256-xts" | "aes-128-ecb" | "sm4-128-ecb" | "aes-128-gcm" | "aes-256-gcm" | "aes-128-gcm2" | "aes-256-gcm2" | "none";

export declare const encryptRSA: (secret: string) => Promise<string>;

/**
 * The `EventEmitter` class provides a way to define, emit, and handle events.
 */
export declare class EventEmitter {
    private _events;
    /**
     * Gets all the listeners for a specified event.
     *
     * @param event The event name.
     */
    getListeners(event: string): Function[];
    /**
     * Listens for a specified event.
     *
     * When the specified event happens, the SDK triggers the callback that you pass.
     * @param event The event name.
     * @param listener The callback to trigger.
     */
    on(event: string, listener: Function): void;
    /** @internal */
    addListener: (event: string, listener: Function) => void;
    /**
     * Listens for a specified event once.
     *
     * When the specified event happens, the SDK triggers the callback that you pass and then removes the listener.
     * @param event The event name.
     * @param listener The callback to trigger.
     */
    once(event: string, listener: Function): void;
    /**
     * Removes the listener for a specified event.
     *
     * @param event The event name.
     * @param listener The callback that corresponds to the event listener.
     */
    off(event: string, listener: Function): void;
    /**
     * Removes all listeners for a specified event.
     *
     * @param event The event name. If left empty, all listeners for all events are removed.
     */
    removeAllListeners(event?: string): void;
    /** @internal */
    emit(event: string, ...args: any[]): void;
    /** @internal */
    safeEmit(event: string, ...args: any[]): void;
    private _indexOfListener;
}

/**
 * The detailed options of the user role, including the user level.
 *
 * Used by the {@link ClientConfig.clientRoleOptions} property or the [AgoraRTCClient.setClientRole]{@link IAgoraRTCClient.setClientRole} method.
 */
/**
 * Extended user role options, used to set user role delay.
 * @internal
 */
export declare interface ExtendedClientRoleOptions {
    delayCadence: number;
    delayStep: number;
    delayMax: number;
}

export declare function findIndexs<T>(list: T[], predicate: (item: T) => boolean): number[];

export declare function generateIv(mode: CryptoMode, password: Uint8Array, salt: Uint8Array): Promise<Uint8Array>;

export declare function generateKey(mode: CryptoMode, password: Uint8Array, salt: Uint8Array): Promise<CryptoKey>;

export declare function generateProcessID(): string;

export declare function generateSessionID(): string;

export declare function getBigInt64(dataView: DataView, byteOffset: number, littleEndian: boolean | undefined): bigint;

export declare function getBigUint64(dataView: DataView, byteOffset: number, littleEndian?: boolean): bigint;

export declare function getBrowserInfo(userAgent?: string): Readonly<BrowserInfo>;

export declare function getBrowserOS(): BrowserOS | string | null;

export declare function getBrowserVersion(): string;

export declare function getChangedKeysFromObject<T extends object>(a: T, b: T): (keyof T)[];

export declare function getChromeKernelVersion(): string | null;

export declare function getElectronInstance(): Electron | null;

export declare function getHTTPRecvBytes(): number;

export declare function getHTTPSendBytes(): number;

export declare function getMessageEncoding(text: string): Uint8Array;

export declare function getMultiUnilbsFormDataByteLength(data: FormData): number;

export declare function getOSWithVersion(): string;

export declare function getParameter(key: keyof typeof MUTABLE_PARAMS): any;

export declare function getRandomString(length: number, prefix: string): string;

export declare function getRetryWaitTime(retryCount: number, config: RetryConfiguration): number;

export declare function getUniqueList<T>(list: T[]): T[];

export declare function getUTF8StringByteLength(str: string): number;

export declare function hexToBytes(hex: string): Uint8Array;

/**
 * @ignore
 */
export declare interface IAgoraRTCError extends Error {
    readonly code: AgoraRTCErrorCode;
    readonly message: string;
    readonly data?: any;
    readonly name: string;
    toString(): string;
    print(level?: "error" | "warning", logger?: any): IAgoraRTCError;
    throw(logger?: any): never;
}

export declare interface IceCandidatePair {
    local: CandidateStats;
    remote: CandidateStats;
}

/**
 * @ignore
 */
export declare interface IElectronNativeImage {
    toDataURL(): string;
    getSize(): {
        width: number;
        height: number;
    };
    resize(options: {
        width: number;
    }): IElectronNativeImage;
}

export declare const IMMUTABLE_PARAMS: {
    INSTALL_ID: string;
};

export declare const IS_GLOBAL_VERSION: boolean;

export declare function isAboveChrome(minVersion: number): boolean;

export declare function isAboveEdge(minVersion: number): boolean;

export declare function isAboveFirefox(minVersion: number): boolean;

export declare function isAboveIOS(maxVersion: number, subVersion?: number, isExcluded?: boolean): boolean;

export declare function isAboveIOS13(): boolean;

export declare function isAboveIOS15_1(): boolean;

export declare function isAboveIOS15_2(): boolean;

export declare function isAboveIOS16_0(): boolean;

export declare function isAboveOpera(minVersion: number): boolean;

export declare function isAboveSafari(minVersion: number): boolean;

export declare function isAboveSafari15_4(): boolean;

export declare function isAboveSafari18_4(): boolean;

export declare function isAndroid(): boolean;

export declare function isAndroidChromium(): boolean;

export declare function isBelowChrome(maxVersion: number): boolean;

export declare function isBelowIOS(maxVersion: number, subVersion?: number, isExcluded?: boolean): boolean;

export declare function isBelowIOS14_6(): boolean;

export declare function isBelowSafari(maxVersion: number, subVersion?: number, isExcluded?: boolean): boolean;

export declare function isBetweenBrowser(browser: BrowserName, minVersion: number, maxVersion?: number): boolean;

export declare function isChrome(): boolean;

export declare function isChromeBelow90(): boolean;

export declare function isChromeKernel(): boolean;

export declare function isClientConfig(config: ClientConfig): config is ClientConfig;

export declare function isClientRole(role: any): role is ClientRole;

export declare function isClientRoleOptions(options: any): options is ClientRoleOptions;

export declare function isEdge(): boolean;

export declare function isElectron(): boolean;

export declare function isEmpty(n: any): boolean;

export declare function isEncryptionMode(encryptionMode: any): encryptionMode is EncryptionMode;

export declare function isFirefox(): boolean;

export declare function isFirefoxVersion(version: number): boolean;

export declare function isHarmonyOS(): boolean;

export declare const isHttpsEnv: () => boolean;

export declare function isInPage(node: Node): boolean;

export declare function isIOS(): boolean;

export declare function isIOS13(): boolean;

export declare function isIOS15(): boolean;

export declare function isIOS15_0(): boolean;

export declare function isIOS16(): boolean;

export declare function isIpadOS(): boolean;

export declare function isJsonEqual(obj1: any, obj2: any): boolean;

export declare function isLegacyChrome(): boolean;

export declare function isMacOS(): boolean;

export declare function isMobile(): boolean;

export declare function isMobileAndTabletType(): boolean;

export declare function isOpera(): boolean;

export declare function isP2PTransport(transport: P2PTransportType): transport is P2PTransportType;

export declare function isPageRecording(): boolean;

export declare function isPromise(obj: any): boolean;

export declare function isQQBrowser(): boolean;

export declare function isRetryConfiguration(config: RetryConfiguration): config is RetryConfiguration;

export declare function isRTCIceServerList(iceServers: any): iceServers is RTCIceServer[];

export declare function isSafari(): boolean;

export declare function isSupportedPC(): boolean;

export declare function isSupportedWkWebview(): boolean;

export declare function isTurnServerConfig(turnServer: any): turnServer is TurnServerConfig;

export declare function isValidString(string: any, lenMin?: number, lenMax?: number, ascii?: boolean): boolean;

export declare function isWebKit(): boolean;

export declare function isWechatBrowser(): boolean;

export declare function isWindows(): boolean;

export declare function isWkWebview(): boolean;

export declare interface JoinChannelServiceRecord {
    urls: string[];
    startTs: number;
    endTs: number | undefined;
    sessionId: string;
    errors?: Error[];
    uid?: UID;
    status: "pending" | "success" | "error" | "timeout" | "aborted";
    service: "stringUID" | "chooseServer" | "gateway";
    cloudProxyMode: "disabled" | "normal" | "443only" | "proxy3" | "proxy4" | "proxy5" | "proxy6" | "fallback";
}

export declare function jsonClone<T>(obj: T): T;

export declare interface KeyMetrics {
    clientCreated?: number;
    joinStart?: number;
    preloadStart?: number;
    preloadEnd?: number;
    joinEnd?: number;
    requestAPStart?: number;
    requestAPEnd?: number;
    requestSUAEnd?: number;
    beforeConnect?: number;
    peerReceiver?: number;
    signalConnected?: number;
    joinReq?: number;
    joinRep?: number;
    joinGatewayStart?: number;
    joinGatewayEnd?: number;
    peerConnectionStart?: number;
    peerConnectionEnd?: number;
    descriptionStart?: number;
    iceConnectionEnd?: number;
    datachannelOpen?: number;
    publish: {
        trackId: string;
        type: "video" | "audio";
        publishStart?: number;
        publishEnd?: number;
    }[];
    subscribe: {
        userId: UID;
        type: "video" | "audio";
        subscribeStart?: number;
        subscribeEnd?: number;
        firstFrame?: number;
        streamAdded?: number;
        firstDecoded?: number;
    }[];
    firstVideoFrameDecoded: {
        userId?: UID;
        peerPublishDuration?: number;
        peerPubStatusMs?: number;
        userJoinNotify?: number;
        videoAddNotify?: number;
        subscribeDelay?: number;
        subscribeStart?: number;
        subscribeEnd?: number;
        firstReceived?: number;
        firstDecoded?: number;
        firstPreRender?: number;
        firstRender?: number;
        playStart?: number;
        playEnd?: number;
        isInternalUpload?: boolean;
        isExternalUpload?: boolean;
    }[];
}

export declare function loadInstallId(): any;

/**
 * @ignore
 *
 * -----暂不对外的备用内容-----
 * - `cds`：（可选）配置下发服务。默认关闭。包含可选属性 `hostname` 和 `port`。
 *
 * 默认值
 *   |`cds.hostname`| `accessPoints` 所包含的 hostname 列表|
 *   |`cds.port`|443|
 */
export declare type LocalAccessPointConfig = {
    [serve in "log" | "report" | "cds"]?: {
        hostname?: string[];
        port?: number;
    };
} & {
    accessPoints: {
        serverList: string[];
        domain: string;
        port?: number;
    };
};

export declare function md5(inputString: string): string;

export declare const MUTABLE_GATEWAY_PARAMS: {
    ENABLE_PUBLISHED_USER_LIST: boolean;
    MAX_SUBSCRIPTION: number;
    SUBSCRIBE_AUDIO_FILTER_TOPN: any;
    ENABLE_PUBLISH_AUDIO_FILTER: any;
    ENABLE_USER_LICENSE_CHECK: boolean;
    DISABLE_FEC: any;
    ENABLE_NTP_REPORT: boolean;
    ENABLE_INSTANT_VIDEO: boolean;
    ENABLE_USER_AUTO_REBALANCE_CHECK: boolean;
    ENABLE_LOSSBASED_BWE: boolean;
    ENABLE_AUT_CC: boolean;
    FORCE_ENABLE_AUT_CC: boolean;
    ENABLE_CC_FALLBACK: any;
    SUBSCRIBE_TWCC: boolean;
    PUBLISH_TWCC: boolean;
    ENABLE_SVC_DEFAULT_CODECS: string[];
    SVC: any[];
    ENABLE_FULL_LINK_AV_SYNC: boolean;
    SVC_MODE: any;
    PRE_SUB_NUM: number;
    ENABLE_AUT_FEEDBACK: boolean;
    SVC_EXTENDED: string[];
};

export declare const MUTABLE_PARAMS: {
    K_MIN_RENDER_DELAY: number;
    USE_STANDARD_BITRATE_DEFAULT: boolean;
    VIDEO_NEW_BITRATE_RATIO: any;
    VIDEO_STANDARD_BITRATE_VERSION: number;
    BASELINE_MORE_H264_BITRATE_RATIO: number;
    INSTALL_ID: string;
    USE_CANDIDATE_FROM_AP_DETAIL: boolean;
    AP_REQUEST_DETAIL: any;
    ENABLE_ROLE_SELECT_EDGE: boolean;
    CLIENT_ROLE_OPTIONS: any;
    COMPATIBLE_SDP_EXTENSION: string[];
    LIMIT_BITRATE: any;
    EXPERIMENTS: {};
    USE_PUB_RTX: boolean;
    USE_SUB_RTX: boolean;
    ENABLE_DATASTREAM_2: boolean;
    USE_XR: boolean;
    ENABLE_PREALLOC_PC: boolean;
    ENABLE_PRE_SUB: boolean;
    ENABLE_SVC: boolean;
    ENABLE_PRE_RENDER: boolean;
    FORCE_DISABLE_AUTO_SUB: boolean;
    ENABLE_PRE_SUB_WITH_PRE_PC: boolean;
    PRE_USE_LOCAL_CODECS: boolean;
    ENABLE_PUBLISHED_USER_LIST: boolean;
    MAX_SUBSCRIPTION: number;
    SUBSCRIBE_AUDIO_FILTER_TOPN: any;
    ENABLE_PUBLISH_AUDIO_FILTER: any;
    ENABLE_USER_LICENSE_CHECK: boolean;
    DISABLE_FEC: any;
    ENABLE_NTP_REPORT: boolean;
    ENABLE_INSTANT_VIDEO: boolean;
    ENABLE_USER_AUTO_REBALANCE_CHECK: boolean;
    ENABLE_LOSSBASED_BWE: boolean;
    ENABLE_AUT_CC: boolean;
    FORCE_ENABLE_AUT_CC: boolean;
    ENABLE_CC_FALLBACK: any;
    SUBSCRIBE_TWCC: boolean;
    PUBLISH_TWCC: boolean;
    ENABLE_SVC_DEFAULT_CODECS: string[];
    SVC: any[];
    ENABLE_FULL_LINK_AV_SYNC: boolean;
    SVC_MODE: any;
    PRE_SUB_NUM: number;
    ENABLE_AUT_FEEDBACK: boolean;
    SVC_EXTENDED: string[];
    PROCESS_ID: string;
    ENCRYPT_AES: boolean;
    AREAS: string[];
    WEBCS_DOMAIN: string[];
    WEBCS_DOMAIN_BACKUP_LIST: string[];
    PROXY_CS: string[];
    CDS_AP: string[];
    ACCOUNT_REGISTER: string[];
    UAP_AP: string[];
    LOG_UPLOAD_SERVER: string;
    EVENT_REPORT_DOMAIN: string;
    EVENT_REPORT_BACKUP_DOMAIN: string;
    GATEWAY_ADDRESS: any[];
    GATEWAY_WSS_ADDRESS: string;
    LIVE_STREAMING_ADDRESS: string;
    HTTP_CONNECT_TIMEOUT: number;
    SIGNAL_REQUEST_TIMEOUT: number;
    REPORT_STATS: boolean;
    NOT_REPORT_EVENT: any[];
    PING_PONG_TIME_OUT: number;
    WEBSOCKET_TIMEOUT_MIN: number;
    EVENT_REPORT_SEND_INTERVAL: number;
    CONFIG_DISTRIBUTE_INTERVAL: number;
    ENABLE_CONFIG_DISTRIBUTE: boolean;
    CANDIDATE_TIMEOUT: number;
    SHOW_REPORT_INVOKER_LOG: boolean;
    SHOW_REPORT_USER_INVOKER_LOG: boolean;
    JOIN_EXTEND: string;
    PUB_EXTEND: string;
    SUB_EXTEND: string;
    FORCE_TURN: boolean;
    TURN_ENABLE_TCP: boolean;
    TURN_ENABLE_UDP: boolean;
    MAX_UPLOAD_CACHE: number;
    UPLOAD_CACHE_INTERVAL: number;
    AJAX_REQUEST_CONCURRENT: number;
    REPORT_APP_SCENARIO: any;
    GATEWAY_DOMAINS: string[];
    CONNECT_GATEWAY_WITHOUT_DOMAIN: boolean;
    WORKER_DOMAIN: string;
    EVENT_REPORT_RETRY: boolean;
    CHROME_FORCE_PLAN_B: boolean;
    AUDIO_SOURCE_VOLUME_UPDATE_INTERVAL: number;
    AUDIO_SOURCE_AVG_VOLUME_DURATION: number;
    AUDIO_VOLUME_INDICATION_INTERVAL: number;
    VOLUME_VOICE_WEIGHT: number;
    GET_VOLUME_OF_MUTED_AUDIO_TRACK: boolean;
    STATS_UPDATE_INTERVAL: number;
    NORMAL_EVENT_QUEUE_CAPACITY: number;
    CUSTOM_REPORT: boolean;
    CUSTOM_REPORT_LIMIT: number;
    PROXY_SERVER_TYPE2: string;
    PROXY_SERVER_TYPE3: string | string[];
    CUSTOM_PUB_ANSWER_MODIFIER: any;
    CUSTOM_SUB_ANSWER_MODIFIER: any;
    CUSTOM_PUB_OFFER_MODIFIER: any;
    CUSTOM_SUB_OFFER_MODIFIER: any;
    DSCP_TYPE: string;
    REMOVE_NEW_CODECS: boolean;
    FRAGEMENT_LENGTH: number;
    WEBSOCKET_COMPRESS: boolean;
    SIMULCAST: boolean;
    CHECK_VIDEO_VISIBLE_INTERVAL: number;
    CHECK_LOCAL_STATS_INTERVAL: number;
    PROFILE_SWITCH_INTERVAL: number;
    UNSUPPORTED_VIDEO_CODEC: any[];
    ENUMERATE_DEVICES_INTERVAL: boolean;
    ENUMERATE_DEVICES_INTERVAL_TIME: number;
    USE_NEW_TOKEN: boolean;
    CLOSE_AFB_FOR_LOCAL_AP: boolean;
    JOIN_MAX_CONCURRENCY: number;
    JOIN_WITH_FALLBACK_SIGNAL_PROXY: boolean;
    JOIN_WITH_FALLBACK_MEDIA_PROXY: boolean;
    JOIN_WITH_FALLBACK_MEDIA_PROXY_FORCE: boolean;
    JOIN_GATEWAY_TRY_443PORT_DURATION: number;
    JOIN_GATEWAY_USE_443PORT_ONLY: boolean;
    JOIN_GATEWAY_USE_DUAL_DOMAIN: boolean;
    JOIN_GATEWAY_FALLBACK_PORT: number;
    USE_TURN_SERVER_OF_GATEWAY: boolean;
    H264_PROFILE_LEVEL_ID: string;
    USE_NEW_LOG: boolean;
    LOG_VERSION: number;
    MEDIA_DEVICE_CONSTRAINTS: any;
    ENCRYPT_PROXY_USERNAME_AND_PSW: boolean;
    SDP_LOGGING: boolean;
    CSP_DETECTED_HOSTNAME_LIST: string[];
    REMOTE_AUDIO_TRACK_USES_WEB_AUDIO: boolean;
    LOCAL_AUDIO_TRACK_USES_WEB_AUDIO: boolean;
    BITRATE_ADAPTER_TYPE: string;
    AI_DENOISER_PARAMETERS: {
        excludedLinks: any[];
    };
    ADJUST_3A_FROM_PLUGINS: boolean;
    RAISE_H264_BASELINE_PRIORITY: boolean;
    FILTER_SEND_H264_BASELINE: boolean;
    FIRST_H264_PROFILE_LEVEL_ID: string;
    FIRST_PACKETIZATION_MODE: string;
    X_GOOGLE_START_BITRATE: any;
    NEW_REPORT_SERVER: boolean;
    NEW_REPORT_SERVER_DOMAINS: string[];
    VIDEO_INSPECT_WORKER_MESSAGE_LENGTH_LIMIT: number;
    VIDEO_INSPECT_INTERVAL_MINIMUM: number;
    VIDEO_INSPECT_QUALITY_RATIO: number;
    VIDEO_INSPECT_WORKER_MANAGER_HOST: string;
    VIDEO_INSPECT_WORKER_MANAGER_PORT: string;
    VIDEO_INSPECT_WORKER_PORT: string;
    SHOW_VIDEO_INSPECT_WORKER_MESSAGE: boolean;
    STATS_COLLECTOR_PORT: number;
    FORCE_TURN_TCP: boolean;
    WEBAUDIO_INIT_OPTIONS: any;
    FILTER_VIDEO_FEC: boolean;
    FILTER_AUDIO_FEC: boolean;
    CHROME_DUAL_STREAM_USE_ENCODING: boolean;
    DISABLE_DUAL_STREAM_USE_ENCODING: boolean;
    EXTENSION_USAGE_UPLOAD_INTERVAL: number;
    ICE_RESTART: boolean;
    FINGERPRINT: any;
    ENABLE_VIDEO_FRAME_CALLBACK: boolean;
    VIDEO_FREEZE_DURATION: number;
    SPATIALIZER_PARAMETERS: {};
    UPLOAD_LOG_INTERVAL: number;
    UPLOAD_LOG_REQUEST_RETRY_INTERVAL: number;
    UPLOAD_LOG_REQUEST_MAX_RETRY_INTERVAL: number;
    UPLOAD_LOG_TRY_INTERVAL_WHILE_OFF: number;
    UPLOAD_LOG_RETRY_INTERVAL_V1: number;
    UPLOAD_LOG_TWICE_RETRY_INTERVAL_V1: number;
    UPLOAD_LOG_LENGTH_EACH_TIME: number;
    APP_TYPE: number;
    DISABLE_WEBAUDIO: boolean;
    CHANNEL_MEDIA_RELAY_SERVERS: {
        address: string;
        wss: number;
    }[] | undefined;
    KEEP_LAST_FRAME: boolean;
    FORWARD_P2P_CREATION: boolean;
    SYNC_GROUP: boolean;
    BLOCK_LOCAL_CLIENT: boolean;
    ENABLE_AUDIO_TOPN: boolean;
    ENABLE_AUDIO_METADATA: boolean;
    ENABLE_AUDIO_PTS: boolean;
    TOPN_SMOOTH_LEVEL: any;
    TOPN_NEW_SPEAKER_DELAY: any;
    TOPN_SWITCH_HOLD_MS: any;
    TOPN_AUDIO_GAIN: any;
    TOPN_SILENCE_THRESHOLD: number;
    AP_AREA: boolean;
    ENABLE_ENCODED_TRANSFORM: boolean;
    ENABLE_VIDEO_SEI: boolean;
    IMAGE_MODERATION_WORKER_HOST: string;
    IMAGE_MODERATION_WORKER_MESSAGE_LENGTH_LIMIT: number;
    IMAGE_MODERATION_INTERVAL_MINIMUM: number;
    SHOW_IMAGE_MODERATION_WORKER_MESSAGE: boolean;
    IMAGE_MODERATION_QUALITY_RATIO: number;
    IMAGE_MODERATION_UPLOAD_REPORT_INTERVAL: number;
    SHOW_GLOBAL_CLIENT_LIST: boolean;
    DATASTREAM_MAX_RETRANSMITS: number;
    TCP_CANDIDATE_ONLY: boolean;
    EXTERNAL_SIGNAL_REQUEST_TIMEOUT: number;
    SHOW_P2P_LOG: boolean;
    MAX_P2P_TIMEOUT: number;
    P2P_TOKEN_INTERVAL: number;
    SHOW_DATASTREAM2_LOG: boolean;
    RESTRICTION_SET_PLAYBACK_DEVICE: boolean;
    USE_PURE_ENCRYPTION_MASTER_KEY: boolean;
    ENABLE_AUDIO_RED: boolean;
    OPUS_PTIME: any;
    AUDIO_DUPLICATE_NUM: any;
    ENABLE_ABSSENDTIME_AS_SENTTS: boolean;
    ACCOUNT_REGISTER_RETRY_TIMEOUT: number;
    ACCOUNT_REGISTER_RETRY_RATIO: number;
    ACCOUNT_REGISTER_RETRY_TIMEOUT_MAX: number;
    ACCOUNT_REGISTER_RETRY_COUNT_MAX: number;
    AUDIO_CONTEXT: any;
    WEBCS_BACKUP_CONNECT_TIMEOUT: number;
    PLAYER_STATE_DEFER: number;
    SIGNAL_REQUEST_WATCH_INTERVAL: number;
    FILEPATH_LENMAX: number;
    DUALSTREAM_OPERATION_CHECK: boolean;
    MEDIA_ELEMENT_EXISTS_DEPTH: number;
    SHIM_CANDIDATE: boolean;
    LEAVE_MSG_TIMEOUT: number;
    STATS_FILTER: {
        transportId: boolean;
        googTrackId: boolean;
    };
    FILTER_VIDEO_CODEC: any[];
    UNSUPPORTED_VIDEO_UPLINK_CODEC: any[];
    UNSUPPORTED_VIDEO_DOWNLINK_CODEC: any[];
    USE_NEW_NETWORK_CONFIG: boolean;
    AUTO_RESET_AUDIO_ROUTE: boolean;
    PLUGIN_INFO: any[];
    OVERUSE_DETECTOR_PARAMS: {
        MIN_FRAME_RATE: number;
        MAX_FRAME_RATE: number;
        MAX_THRESHOLD_FRAMERATE: number;
        BITRATE_MIN_THRESHOLD: number;
        BITRATE_MAX_THRESHOLD: number;
        MAX_SCALE: number;
        BWE_SCALE_UP_THRESHOLD: number;
        BWE_SCALE_DOWN_THRESHOLD: number;
        PERF_SCALE_UP_THRESHOLD: number;
        PERF_SCALE_DOWN_THRESHOLD: number;
        MOTION_RESOLUTION_FACTOR: number;
        MOTION_BITRATE_FACTOR: number;
        DETAIL_FRAMERATE_FACTOR: number;
        DETAIL_BITRATE_FACTOR: number;
        BALANCE_RESOLUTION_FACTOR: number;
        BALANCE_FRAMERATE_FACTOR: number;
        BALANCE_BITRATE_FACTOR: number;
        OVERUSE_TIMES_THRESHOLD: number;
        UNDERUSE_TIMES_THRESHOLD: number;
    };
    CUSTOM_ADAPTATION_DEFAULT_MODE: string;
    HIDE_NO_POSTER: boolean;
    AP_CACHE_NUM: number;
    AP_UPDATE_INTERVAL: number;
    AP_CACHE_LIFETIME: number;
    MAX_PRELOAD_ASYNC_LENGTH: number;
    DISABLE_SCREEN_SHARE_REMB: boolean;
    ENABLE_EVENT_REPORT: boolean;
    UPLOAD_LOG: boolean;
    ENABLE_AG_ADAPTATION: boolean;
    FORCE_AG_HIGH_FRAMERATE: boolean;
    FORCE_SUPPORT_AG_ADAPTATION: boolean;
    ENCODER_CONFIG_LIMIT: {};
    CAMERA_CAPTURE_CONFIG: any;
    ENABLE_PRELOAD: boolean;
    NEW_ICE_RESTART: boolean;
    ICE_RESTART_INTERVAL: number;
    RESTART_SEQUENCE: string[];
    FIRST_TCP_CANDIDATE: boolean;
    FIRST_TCP_CANDIDATE_INTERVAL: number;
    TURN_DOMAIN: string;
    USE_TURN_IP: boolean;
    NEW_TURN_MODE: number;
    NEW_FORCE_TURN: boolean;
    USE_NEW_RENDER_FREEZE_TIME: boolean;
    ENCODE_EXCEPTION_TIMES: number;
    ENABLE_ENCODE_EXCEPTION: boolean;
    ENCODE_EXCEPTION_VALIDATE_CODEC: string[];
    VIDEO_ENCODER_CONFIG_LIST: {
        width: number;
        height: number;
    }[];
    DELETE_NEQ_AFTER_USER_LEAVE: boolean;
};

export declare const MUTABLE_PARAMS_LOCAL_CACHE: MutableParamsCache;

export declare const MUTABLE_REALTIME_PARAMS: {
    ENABLE_EVENT_REPORT: boolean;
    UPLOAD_LOG: boolean;
    ENABLE_AG_ADAPTATION: boolean;
    FORCE_AG_HIGH_FRAMERATE: boolean;
    FORCE_SUPPORT_AG_ADAPTATION: boolean;
    ENCODER_CONFIG_LIMIT: {};
    CAMERA_CAPTURE_CONFIG: any;
    ENABLE_PRELOAD: boolean;
    NEW_ICE_RESTART: boolean;
    ICE_RESTART_INTERVAL: number;
    RESTART_SEQUENCE: string[];
    FIRST_TCP_CANDIDATE: boolean;
    FIRST_TCP_CANDIDATE_INTERVAL: number;
    TURN_DOMAIN: string;
    USE_TURN_IP: boolean;
    NEW_TURN_MODE: number;
    NEW_FORCE_TURN: boolean;
    USE_NEW_RENDER_FREEZE_TIME: boolean;
    ENCODE_EXCEPTION_TIMES: number;
    ENABLE_ENCODE_EXCEPTION: boolean;
    ENCODE_EXCEPTION_VALIDATE_CODEC: string[];
    VIDEO_ENCODER_CONFIG_LIST: {
        width: number;
        height: number;
    }[];
    DELETE_NEQ_AFTER_USER_LEAVE: boolean;
};

export declare type MutableParamsCache = {
    [key in keyof PartialMutableParams]: {
        value: any;
        type?: CONFIG_DISTRIBUTE_TYPE;
        expires?: number;
    };
};

export declare interface MutableParamsConfig extends PartialMutableParams {
    __id?: number;
    __type?: CONFIG_DISTRIBUTE_TYPE;
    __expires?: number;
    __priority?: number;
}

export declare enum NETWORK_INDICATOR_EVENTS {
    NETWORK_STATE_CHANGE = "NETWORK_STATE_CHANGE",
    ONLINE = "ONLINE",
    OFFLINE = "OFFLINE"
}

export declare enum NETWORK_STATE {
    ONLINE = "ONLINE",
    OFFLINE = "OFFLINE"
}

declare class NetworkIndicator extends EventEmitter {
    private _moduleName;
    private _networkState;
    onlineWaiter?: Promise<string>;
    set networkState(state: NETWORK_STATE);
    get networkState(): NETWORK_STATE;
    get isOnline(): boolean;
    constructor();
}

export declare const networkIndicator: NetworkIndicator;

/**
 * The last-mile network quality.
 *
 * Last mile refers to the connection between the local device and Agora edge server.
 *
 * - After the local user joins the channel, the SDK triggers the [AgoraRTCClient.on("network-quality")]{@link IAgoraRTCClient.event_network_quality} callback once every two seconds and provides the uplink and downlink last-mile network conditions of the user through this interface.
 * - You can call [AgoraRTCClient.getRemoteNetworkQuality]{@link IAgoraRTCClient.getRemoteNetworkQuality} to get the network quality of all remote users to whom the local user subscribes.
 *
 * > The returned network quality is a relative value and is for reference only.
 */
export declare interface NetworkQuality {
    /**
     * The uplink network quality.
     *
     * It is calculated based on the uplink transmission bitrate, uplink packet loss rate, RTT (round-trip time) and jitter.
     *
     * - 0: The quality is unknown.
     * - 1: The quality is excellent.
     * - 2: The quality is good, but the bitrate is less than optimal.
     * - 3: Users experience slightly impaired communication.
     * - 4: Users can communicate with each other, but not very smoothly.
     * - 5: The quality is so poor that users can barely communicate.
     * - 6: The network is disconnected and users cannot communicate.
     */
    uplinkNetworkQuality: 0 | 1 | 2 | 3 | 4 | 5 | 6;
    /**
     * The downlink network quality.
     *
     * It is calculated based on the uplink transmission bitrate, uplink packet loss rate, RTT (round-trip time) and jitter.
     *
     * - 0: The quality is unknown.
     * - 1: The quality is excellent.
     * - 2: The quality is good, but the bitrate is less than optimal.
     * - 3: Users experience slightly impaired communication.
     * - 4: Users can communicate with each other, but not very smoothly.
     * - 5: The quality is so poor that users can barely communicate.
     * - 6: The network is disconnected and users cannot communicate.
     */
    downlinkNetworkQuality: 0 | 1 | 2 | 3 | 4 | 5 | 6;
}

export declare function nextTick(func: () => any): void;

export declare const noop: () => void;

export declare const OVERUSE_DETECTOR_PARAMS: {
    MIN_FRAME_RATE: number;
    MAX_FRAME_RATE: number;
    MAX_THRESHOLD_FRAMERATE: number;
    BITRATE_MIN_THRESHOLD: number;
    BITRATE_MAX_THRESHOLD: number;
    MAX_SCALE: number;
    BWE_SCALE_UP_THRESHOLD: number;
    BWE_SCALE_DOWN_THRESHOLD: number;
    PERF_SCALE_UP_THRESHOLD: number;
    PERF_SCALE_DOWN_THRESHOLD: number;
    MOTION_RESOLUTION_FACTOR: number;
    MOTION_BITRATE_FACTOR: number;
    DETAIL_FRAMERATE_FACTOR: number;
    DETAIL_BITRATE_FACTOR: number;
    BALANCE_RESOLUTION_FACTOR: number;
    BALANCE_FRAMERATE_FACTOR: number;
    BALANCE_BITRATE_FACTOR: number;
    OVERUSE_TIMES_THRESHOLD: number;
    UNDERUSE_TIMES_THRESHOLD: number;
};

export declare enum P2PTransportType {
    Default = "default",
    Auto = "auto",
    Relay = "relay",
    SdRtn = "sd-rtn"
}

export declare function parseSdp(sdp: string): SessionDescription;

export declare type PartialMutableParams = Partial<typeof MUTABLE_PARAMS>;

export declare enum PeerConnectionState {
    "new" = 0,
    "connecting" = 1,
    "connected" = 2,
    "disconnected" = 3,
    "failed" = 4,
    "closed" = 5
}

export declare function post<T>(url: string, options: AxiosRequestConfig, notJson: boolean, withHeaders: true): Promise<{
    data: T;
    headers: any;
}>;

export declare function post<T>(url: string, options: AxiosRequestConfig, notJson?: boolean, withHeaders?: false): Promise<T>;

export declare function postProtobuf<T>(url: string, options: AxiosRequestConfig): Promise<T>;

export declare function printSdp(sdp: SessionDescription, EOL?: string): string;

export declare class PromiseMutex {
    static setLogger(_logger: any): void;
    private id;
    private lockingPromise;
    private locks;
    private name;
    private lockId;
    constructor(name?: string, id?: number | string);
    private logger;
    setId(id: number | string): void;
    get isLocked(): boolean;
    lock(info?: string): Promise<() => void>;
}

export declare enum QualityLimitationReason {
    BANDWIDTH = "bandwidth",
    CPU = "cpu",
    NONE = "none",
    OTHER = "other"
}

declare interface ReceiverStats {
    retransmittedBytesReceived?: number;
    retransmittedPacketsReceived?: number;
}

export declare function recursiveMerge(target: unknown, source: unknown): unknown;

export declare function releaseStream(stream: MediaStream): void;

export declare function removeItemFromList<T>(list: T[], item: T): void;

export declare type RequiredOnlyOneOf<T, K extends keyof T = keyof T> = {
    [P in K]: {
        [S in P]: T[S];
    } & {
        [U in keyof Omit<T, P>]?: never;
    };
}[K] extends infer O ? {
    [K in keyof O]: O[K];
} : never;

export declare function resetHTTPBytesCount(): void;

export declare function retryable<T, E = any>(operation: () => Promise<T>, handleResult?: (result: T, count: number) => boolean, handleError?: (error: E, count: number) => boolean, config?: Partial<RetryConfiguration>): CancelablePromise<T>;

/**
 * @ignore
 */
export declare interface RetryConfiguration {
    timeout: number;
    timeoutFactor: number;
    maxRetryCount: number;
    maxRetryTimeout: number;
}

export declare class Rolling {
    private input;
    private size;
    constructor(size: number);
    add(num: number): void;
    mean(): number;
}

export declare interface RTCLegacyStatsObject {
    id: string;
    timestamp: string;
    type: string;
    [name: string]: string;
}

export declare interface RTCLegacyStatsReport {
    names: () => string[];
    stat: (name: string) => string;
    id: string;
    timestamp: Date;
    type: string;
}

declare interface RTCStats_2 {
    timestamp: DOMHighResTimeStamp;
    type: RTCStatsType_2;
    id: string;
    [name: string]: any;
}
export { RTCStats_2 as RTCStats }

declare type RTCStatsReport_2 = Map<string, RTCStats_2>;
export { RTCStatsReport_2 as RTCStatsReport }

export declare interface RTCStatsResponse {
    result: () => RTCLegacyStatsReport[];
}

declare enum RTCStatsType_2 {
    CERTIFICATE = "certificate",
    CODEC = "codec",
    CANDIDATE_PAIR = "candidate-pair",
    LOCAL_CANDIDATE = "local-candidate",
    REMOTE_CANDIDATE = "remote-candidate",
    INBOUND = "inbound-rtp",
    TRACK = "track",
    OUTBOUND = "outbound-rtp",
    PC = "peer-connection",
    REMOTE_INBOUND = "remote-inbound-rtp",
    REMOTE_OUTBOUND = "remote-outbound-rtp",
    TRANSPORT = "transport",
    CSRC = "csrc",
    DATA_CHANNEL = "data-channel",
    STREAM = "stream",
    SENDER = "sender",
    RECEIVER = "receiver"
}
export { RTCStatsType_2 as RTCStatsType }

export declare interface RTMConfiguration {
    apRTM: boolean;
    rtmFlag: number;
}

export declare function runOnce(func: () => void, key: string): void;

export declare function safeCloneJson<T>(obj: T): T;

export declare enum ScalabilityMode {
    L1T1 = "L1T1",
    L1T2 = "L1T2",
    L1T3 = "L1T3",
    L1T3_KEY = "L1T3_KEY",
    L2T1_KEY = "L2T1_KEY",
    L2T2_KEY = "L2T2_KEY",
    L2T3_KEY = "L2T3_KEY",
    L3T1_KEY = "L3T1_KEY",
    L3T2_KEY = "L3T2_KEY",
    L3T3_KEY = "L3T3_KEY"
}

/**
 * @ignore
 */
export declare type SDK_AUDIO_CODEC = keyof typeof AudioCodec;

/**
 * The codec that the Web browser uses for encoding.
 * - `"vp8"`: Use VP8 for encoding.
 * - `"h264"`: Use H.264 for encoding.
 * - `"vp9"`: (Beta) Use VP9 for encoding.
 * - `"av1"`: (Beta) Use AV1 for encoding.
 *
 * > Safari 12.1 or earlier does not support the VP8 codec.
 */
export declare type SDK_CODEC = keyof typeof VideoCodec;

/**
 * The channel profile.
 *
 * The SDK differentiates channel profiles and applies different optimization algorithms accordingly. For example, it prioritizes smoothness and low latency for a video call, and prioritizes video quality for a video broadcast.
 *
 * The SDK supports the following channel profiles:
 * - `"live"`: Sets the channel profile as live broadcast. You need to go on to call [setClientRole]{@link IAgoraRTCClient.setClientRole} to set the client as either a host or an audience. A host can send and receive audio or video, while an audience can only receive audio or video.
 * - `"rtc"`: Sets the channel profile as communication. It is used for a one-on-one call or a group call where all users in the channel can converse freely.
 */
export declare type SDK_MODE = "live" | "rtc" | "p2p";

export declare class SDKStore {
    private state;
    constructor(codec: SDK_CODEC, audioCodec: SDK_AUDIO_CODEC, mode: SDK_MODE, clientId: string);
    private dispatch;
    set autoSubscribe(val: boolean);
    get autoSubscribe(): boolean;
    set enableInstantMuteRestore(val: boolean);
    get enableInstantMuteRestore(): boolean;
    set sessionId(sessionId: string | null);
    get sessionId(): string | null;
    set cid(cid: number);
    get cid(): number | undefined;
    set codec(codec: SDK_CODEC);
    get codec(): SDK_CODEC;
    get mode(): SDK_MODE;
    get audioCodec(): SDK_AUDIO_CODEC;
    get clientId(): string;
    set p2pId(p2pId: number);
    get p2pId(): number;
    set dcId(dcId: number);
    get dcId(): number;
    set uid(uid: UID | undefined);
    get uid(): UID | undefined;
    set intUid(intUid: number | undefined);
    get intUid(): number | undefined;
    set pubId(pubId: number);
    get pubId(): number;
    set cloudProxyServerMode(mode: CloudProxyServerMode);
    get cloudProxyServerMode(): CloudProxyServerMode;
    set useP2P(val: boolean);
    get useP2P(): boolean;
    set p2pTransport(val: P2PTransportType);
    get p2pTransport(): P2PTransportType;
    set hasStartJoinChannel(val: boolean);
    get hasStartJoinChannel(): boolean;
    set isABTestSuccess(val: boolean);
    get isABTestSuccess(): boolean;
    clientCreated(): void;
    joinStart(): void;
    preloadStart(): void;
    preloadEnd(): void;
    joinEnd(): void;
    requestAPStart(): void;
    requestAPEnd(): void;
    requestSUAEnd(): void;
    beforeConnect(): void;
    peerReceiver(): void;
    signalConnected(): void;
    joinReq(): void;
    joinRep(): void;
    joinGatewayStart(): void;
    joinGatewayEnd(): void;
    peerConnectionStart(): void;
    peerConnectionEnd(): void;
    firstVideoFrameDecoded(userId: UID, params: {
        peerPublishDuration?: number;
        peerPubStatusMs?: number;
        userJoinNotify?: number;
        videoAddNotify?: number;
        subscribeStart?: number;
        subscribeEnd?: number;
        firstReceived?: number;
        firstDecoded?: number;
        firstPreRender?: number;
        firstRender?: number;
        playStart?: number;
        playEnd?: number;
    }): void;
    descriptionStart(): void;
    signalChannelOpen(): void;
    iceConnectionEnd(): void;
    publish(trackId: string, type: "video" | "audio" | "datachannel", publishStart?: number, publishEnd?: number): void;
    subscribe(userId: UID, type: "video" | "audio", subscribeStart?: number, subscribeEnd?: number, firstFrame?: number, streamAdded?: number, firstDecoded?: number): void;
    massSubscribe(userList: {
        userId: UID;
        type: "video" | "audio";
    }[], subscribeStart?: number, subscribeEnd?: number, firstFrame?: number): void;
    get keyMetrics(): KeyMetrics;
    recordJoinChannelService(record: Partial<JoinChannelServiceRecord>, index?: number): number;
    resetJoinChannelServiceRecords(): void;
    resetKeyMetrics(): void;
    resetFirstVideoFrameDecoded(): void;
    get joinChannelServiceRecords(): JoinChannelServiceRecord[];
}

export declare interface SelectedCandidatePairStats {
    localCandidate: CandidateStats;
    remoteCandidate: CandidateStats;
    id: string;
}

declare interface SenderStats {
    retransmittedBytesSent?: number;
    retransmittedPacketsSent?: number;
}

export declare function setBigInt64(dataView: DataView, byteOffset: number, value: bigint, littleEndian: boolean | undefined): void;

export declare function setBigUint64(dataView: DataView, byteOffset: number, value: bigint, littleEndian?: boolean): void;

export declare function setParameter(key: keyof typeof MUTABLE_PARAMS, value: any, _force?: boolean): void;

export declare const SHA256: (text: string) => Promise<string>;

export declare function shiftAndPush(data: number, length?: number): number[];

export declare function showElectronSelectSourceWindow(sources: ElectronDesktopCapturerSource[], captureAudio?: boolean): Promise<{
    sourceId: string;
    audio: boolean;
}>;

export declare interface StatsFilterOptions {
    updateInterval: number;
    lossRateInterval: number;
    freezeRateLimit: number;
    firstVideoDecodedTimeout: number;
}

export declare interface StreamInfo {
    audio: boolean;
    video: boolean;
    muteAudio: boolean;
    muteVideo: boolean;
}

export declare function sumArray(numbers: number[]): number;

export declare const supportIsSecureContext: () => boolean;

export declare const throttleByKey: any;

export declare function timeout<T>(timeout: number): Promise<T>;

export declare function toCamelCase(snakeStr: string): string;

export declare function transferVersion(version: string): string;

export declare function transformBrowserName(result: UAParser_2.IResult): string;

export declare function transformBrowserVersion(result: UAParser_2.IResult, isMajor?: boolean): string;

export declare function transformOSName(result: UAParser_2.IResult): string;

export declare class TransformStreamAdapter<T> {
    private _transformStream;
    private _readable;
    private _writable;
    private _reader;
    private _writer;
    constructor(transform?: TransformerTransformCallback<T, any>);
    get reader(): ReadableStreamDefaultReader<T>;
    get writer(): WritableStreamDefaultWriter<T>;
    close(): void;
}

export declare interface TransportStats {
    connectState: RTCPeerConnectionState;
}

/**
 * @ignore
 * The configuration of your TURN server. Used when calling [setTurnServer]{@link IAgoraRTCClient.setTurnServer}.
 */
export declare interface TurnServerConfig {
    /**
     * The URL of your TURN server. ASCII characters only.
     */
    turnServerURL: string;
    /**
     * The password of Your TURN server. ASCII characters only.
     */
    password: string;
    /**
     * The TCP port(s) you want add to your TURN server.
     */
    udpport?: number;
    /**
     * The username of your TURN server. ASCII characters only.
     */
    username: string;
    /**
     * Whether to force data transfer by the TURN Server:
     * - `true`: Force data transfer.
     * - `false`: (default) Do not force data transfer.
     */
    forceturn?: boolean;
    /**
     * The UDP port(s) you want to add to your TURN server.
     */
    tcpport?: number;
    security?: boolean;
}

export declare interface TurnServerConfigWithMode {
    mode: TurnServerMode;
    servers: TurnServerConfig[] | RTCIceServer[];
    serversFromGateway?: TurnServerConfig[];
}

export declare type TurnServerMode = "auto" | "manual" | "off" | "original-manual";

/**
 * The user ID to identify a user in the channel.
 *
 * Each user in the same channel should have a unique user ID with the same data type (number or string).
 *
 * To ensure a better end-user experience, Agora recommends using a number as the user ID. See {@link join} for details.
 */
export declare type UID = number | string;

export declare function uint8ArrayConcat(...arrays: Uint8Array[]): Uint8Array;

export declare function uint8ArrayToBase64(array: Uint8Array): string;

export declare function updateConcurrentNumber(uuid: string, num: number): void;

export declare const VERSION: string;

export declare enum VideoCodec {
    h264 = "h264",
    h265 = "h265",
    vp8 = "vp8",
    vp9 = "vp9",
    av1 = "av1"
}

export declare interface VideoFrameState {
    width: number;
    height: number;
    frameRate: number;
}

/**
 * @ignore
 */
declare enum VisibleHiddenReason {
    COVERED = "COVERED",
    POSITION = "POSITION",
    SIZE = "SIZE",
    STYLE = "STYLE"
}

declare enum VisibleHiddenReasonInner {
    UNMOUNTED = "UNMOUNTED",
    INVALID_HTML_ELEMENT = "INVALID_HTML_ELEMENT"
}

export declare interface VisibleHiddenResult {
    visible: false;
    reason: keyof typeof VisibleHiddenReason;
}

/**
 * @ignore
 */
declare interface VisibleHiddenResultInner {
    visible: false;
    reason: keyof typeof VisibleHiddenReason | keyof typeof VisibleHiddenReasonInner;
}

/**
 * @ignore
 */
declare interface VisibleResultInner {
    visible: true;
}

export declare function wait(timeout: number): Promise<void>;

export declare enum WebSocketQuitReason {
    NETWORK_ERROR = "NETWORK_ERROR",
    SERVER_ERROR = "SERVER_ERROR",
    MULTI_IP = "MULTI_IP",
    TIMEOUT = "TIMEOUT",
    OFFLINE = "OFFLINE",
    LEAVE = "LEAVE",
    P2P_FAILED = "P2P_FAILED",
    FALLBACK = "FALLBACK",
    REGIONAL_DISTRIBUTION = "REGIONAL_DISTRIBUTION"
}

export declare function withTimeout<T>(promise: Promise<T>, time: number): Promise<T>;


export * from "sdp-parser2";

export { }
