import { InterceptLocalAudioFrameOptions, InterceptRemoteAudioFrameOptions, LocalVideoTrack, InterceptVideoFrameOptions } from '@agora-js/media';

type TRteServiceName = "ChannelMediaRelay" | "LiveStreaming" | "ImageModeration" | "ContentInspect" | "DataStream" | "P2PChannel" | "PlanBConnection" | "InterceptFrame";
interface IRteService<T = any, R = any> {
    name: TRteServiceName;
    create: (...args: any[]) => T;
    createSubmodule?: (...args: any[]) => R;
}

interface InterceptFrame {
    interceptLocalAudioFrame: (sender: RTCRtpSender, options: InterceptLocalAudioFrameOptions) => Promise<void>;
    interceptRemoteAudioFrame: (receiver: RTCRtpReceiver, options?: InterceptRemoteAudioFrameOptions) => Promise<void>;
    interceptLocalVideoFrame: (sender: RTCRtpSender, localVideoTrack: LocalVideoTrack) => Promise<void>;
    interceptRemoteVideoFrame: (receiver: RTCRtpReceiver, options: InterceptVideoFrameOptions) => Promise<void>;
}
declare const interceptFrame: InterceptFrame;
declare const InterceptFrameService: IRteService<typeof interceptFrame>;

export { InterceptFrameService };
export type { InterceptFrame };
