"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _tslib = require("tslib");
var _react = require("react");
var _useEventListener = _interopRequireDefault(require("../useEventListener"));
var _useMemoizedFn = _interopRequireDefault(require("../useMemoizedFn"));
var _useRequest = _interopRequireDefault(require("../useRequest"));
var _useUpdateEffect = _interopRequireDefault(require("../useUpdateEffect"));
var _domTarget = require("../utils/domTarget");
var _rect = require("../utils/rect");
var useInfiniteScroll = function useInfiniteScroll(service, options) {
  if (options === void 0) {
    options = {};
  }
  var target = options.target,
    isNoMore = options.isNoMore,
    _a = options.threshold,
    threshold = _a === void 0 ? 100 : _a,
    _b = options.reloadDeps,
    reloadDeps = _b === void 0 ? [] : _b,
    manual = options.manual,
    _onBefore = options.onBefore,
    _onSuccess = options.onSuccess,
    _onError = options.onError,
    _onFinally = options.onFinally;
  var _c = (0, _tslib.__read)((0, _react.useState)(), 2),
    finalData = _c[0],
    setFinalData = _c[1];
  var _d = (0, _tslib.__read)((0, _react.useState)(false), 2),
    loadingMore = _d[0],
    setLoadingMore = _d[1];
  var noMore = (0, _react.useMemo)(function () {
    if (!isNoMore) return false;
    return isNoMore(finalData);
  }, [finalData]);
  var _e = (0, _useRequest["default"])(function (lastData) {
      return (0, _tslib.__awaiter)(void 0, void 0, void 0, function () {
        var currentData;
        var _a, _b;
        return (0, _tslib.__generator)(this, function (_c) {
          switch (_c.label) {
            case 0:
              return [4 /*yield*/, service(lastData)];
            case 1:
              currentData = _c.sent();
              if (!lastData) {
                setFinalData((0, _tslib.__assign)((0, _tslib.__assign)({}, currentData), {
                  list: (0, _tslib.__spreadArray)([], (0, _tslib.__read)((_a = currentData.list) !== null && _a !== void 0 ? _a : []), false)
                }));
              } else {
                setFinalData((0, _tslib.__assign)((0, _tslib.__assign)({}, currentData), {
                  list: (0, _tslib.__spreadArray)((0, _tslib.__spreadArray)([], (0, _tslib.__read)((_b = lastData.list) !== null && _b !== void 0 ? _b : []), false), (0, _tslib.__read)(currentData.list), false)
                }));
              }
              return [2 /*return*/, currentData];
          }
        });
      });
    }, {
      manual: manual,
      onFinally: function onFinally(_, d, e) {
        setLoadingMore(false);
        _onFinally === null || _onFinally === void 0 ? void 0 : _onFinally(d, e);
      },
      onBefore: function onBefore() {
        return _onBefore === null || _onBefore === void 0 ? void 0 : _onBefore();
      },
      onSuccess: function onSuccess(d) {
        setTimeout(function () {
          // eslint-disable-next-line @typescript-eslint/no-use-before-define
          scrollMethod();
        });
        _onSuccess === null || _onSuccess === void 0 ? void 0 : _onSuccess(d);
      },
      onError: function onError(e) {
        return _onError === null || _onError === void 0 ? void 0 : _onError(e);
      }
    }),
    loading = _e.loading,
    error = _e.error,
    run = _e.run,
    runAsync = _e.runAsync,
    cancel = _e.cancel;
  var loadMore = (0, _useMemoizedFn["default"])(function () {
    if (noMore) return;
    setLoadingMore(true);
    run(finalData);
  });
  var loadMoreAsync = (0, _useMemoizedFn["default"])(function () {
    if (noMore) return Promise.reject();
    setLoadingMore(true);
    return runAsync(finalData);
  });
  var reload = function reload() {
    setLoadingMore(false);
    return run();
  };
  var reloadAsync = function reloadAsync() {
    setLoadingMore(false);
    return runAsync();
  };
  var scrollMethod = function scrollMethod() {
    var el = (0, _domTarget.getTargetElement)(target);
    if (!el) {
      return;
    }
    el = el === document ? document.documentElement : el;
    var scrollTop = (0, _rect.getScrollTop)(el);
    var scrollHeight = (0, _rect.getScrollHeight)(el);
    var clientHeight = (0, _rect.getClientHeight)(el);
    if (scrollHeight - scrollTop <= clientHeight + threshold) {
      loadMore();
    }
  };
  (0, _useEventListener["default"])('scroll', function () {
    if (loading || loadingMore) {
      return;
    }
    scrollMethod();
  }, {
    target: target
  });
  (0, _useUpdateEffect["default"])(function () {
    run();
  }, (0, _tslib.__spreadArray)([], (0, _tslib.__read)(reloadDeps), false));
  return {
    data: finalData,
    loading: !loadingMore && loading,
    error: error,
    loadingMore: loadingMore,
    noMore: noMore,
    loadMore: loadMore,
    loadMoreAsync: loadMoreAsync,
    reload: (0, _useMemoizedFn["default"])(reload),
    reloadAsync: (0, _useMemoizedFn["default"])(reloadAsync),
    mutate: setFinalData,
    cancel: cancel
  };
};
var _default = useInfiniteScroll;
exports["default"] = _default;