"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ajv_1 = require("ajv");
const _util_1 = require("./_util");
const regexpMetaSchema = {
    type: "object",
    properties: {
        pattern: { type: "string" },
        flags: { type: "string", nullable: true },
    },
    required: ["pattern"],
    additionalProperties: false,
};
const metaRegexp = /^\/(.*)\/([gimuy]*)$/;
function getDef() {
    return {
        keyword: "regexp",
        type: "string",
        schemaType: ["string", "object"],
        code(cxt) {
            const { gen, data, schema } = cxt;
            const regx = getRegExp(schema);
            cxt.pass(ajv_1._ `${regx}.test(${data})`);
            function getRegExp(sch) {
                if (typeof sch == "object")
                    return _util_1.usePattern(gen, sch.pattern, sch.flags);
                const rx = metaRegexp.exec(sch);
                if (rx)
                    return _util_1.usePattern(gen, rx[1], rx[2]);
                throw new Error("cannot parse string into RegExp");
            }
        },
        metaSchema: {
            anyOf: [{ type: "string" }, regexpMetaSchema],
        },
    };
}
exports.default = getDef;
module.exports = getDef;
//# sourceMappingURL=regexp.js.map