/**
 * Properties for the `del` method.
 */
export declare type DelProps = {
    /**
     * The path of the API endpoint to target, anything after the /1 needs to be specified.
     */
    path: string;
    /**
     * Query parameters to be applied to the current query.
     */
    parameters?: Record<string, any>;
};
/**
 * Properties for the `deleteABTest` method.
 */
export declare type DeleteABTestProps = {
    /**
     * The A/B test ID.
     */
    id: number;
};
/**
 * Properties for the `get` method.
 */
export declare type GetProps = {
    /**
     * The path of the API endpoint to target, anything after the /1 needs to be specified.
     */
    path: string;
    /**
     * Query parameters to be applied to the current query.
     */
    parameters?: Record<string, any>;
};
/**
 * Properties for the `getABTest` method.
 */
export declare type GetABTestProps = {
    /**
     * The A/B test ID.
     */
    id: number;
};
/**
 * Properties for the `listABTests` method.
 */
export declare type ListABTestsProps = {
    /**
     * Position of the starting record. Used for paging. 0 is the first record.
     */
    offset?: number;
    /**
     * Number of records to return. Limit is the size of the page.
     */
    limit?: number;
};
/**
 * Properties for the `post` method.
 */
export declare type PostProps = {
    /**
     * The path of the API endpoint to target, anything after the /1 needs to be specified.
     */
    path: string;
    /**
     * Query parameters to be applied to the current query.
     */
    parameters?: Record<string, any>;
    /**
     * The parameters to send with the custom request.
     */
    body?: Record<string, any>;
};
/**
 * Properties for the `put` method.
 */
export declare type PutProps = {
    /**
     * The path of the API endpoint to target, anything after the /1 needs to be specified.
     */
    path: string;
    /**
     * Query parameters to be applied to the current query.
     */
    parameters?: Record<string, any>;
    /**
     * The parameters to send with the custom request.
     */
    body?: Record<string, any>;
};
/**
 * Properties for the `stopABTest` method.
 */
export declare type StopABTestProps = {
    /**
     * The A/B test ID.
     */
    id: number;
};
//# sourceMappingURL=clientMethodProps.d.ts.map