import type { CreateClientOptions, RequestOptions } from '@algolia/client-common';
import type { ABTest } from '../model/aBTest';
import type { ABTestResponse } from '../model/aBTestResponse';
import type { AddABTestsRequest } from '../model/addABTestsRequest';
import type { DelProps, DeleteABTestProps, GetProps, GetABTestProps, ListABTestsProps, PostProps, PutProps, StopABTestProps } from '../model/clientMethodProps';
import type { ListABTestsResponse } from '../model/listABTestsResponse';
export declare const apiClientVersion = "5.0.0-alpha.9";
export declare const REGIONS: readonly ["de", "us"];
export declare type Region = typeof REGIONS[number];
export declare function createAbtestingClient({ appId: appIdOption, apiKey: apiKeyOption, authMode, algoliaAgents, region: regionOption, ...options }: CreateClientOptions & {
    region?: Region;
}): {
    transporter: import("@algolia/client-common").Transporter;
    /**
     * The `appId` currently in use.
     */
    appId: string;
    /**
     * Clears the cache of the transporter for the `requestsCache` and `responsesCache` properties.
     */
    clearCache(): Promise<void>;
    /**
     * Get the value of the `algoliaAgent`, used by our libraries internally and telemetry system.
     */
    readonly _ua: string;
    /**
     * Adds a `segment` to the `x-algolia-agent` sent with every requests.
     *
     * @param segment - The algolia agent (user-agent) segment to add.
     * @param version - The version of the agent.
     */
    addAlgoliaAgent(segment: string, version?: string): void;
    /**
     * Creates a new A/B test with provided configuration. You can set an A/B test on two different indices with different settings, or on the same index with different search parameters by providing a customSearchParameters setting on one of the variants.
     *
     * @summary Create a test.
     * @param addABTestsRequest - The addABTestsRequest object.
     * @param requestOptions - The requestOptions to send along with the query, they will be merged with the transporter requestOptions.
     */
    addABTests(addABTestsRequest: AddABTestsRequest, requestOptions?: RequestOptions): Promise<ABTestResponse>;
    /**
     * This method allow you to send requests to the Algolia REST API.
     *
     * @summary Send requests to the Algolia REST API.
     * @param del - The del object.
     * @param del.path - The path of the API endpoint to target, anything after the /1 needs to be specified.
     * @param del.parameters - Query parameters to be applied to the current query.
     * @param requestOptions - The requestOptions to send along with the query, they will be merged with the transporter requestOptions.
     */
    del({ path, parameters }: DelProps, requestOptions?: RequestOptions): Promise<Record<string, any>>;
    /**
     * Delete a test.
     *
     * @summary Delete a test.
     * @param deleteABTest - The deleteABTest object.
     * @param deleteABTest.id - The A/B test ID.
     * @param requestOptions - The requestOptions to send along with the query, they will be merged with the transporter requestOptions.
     */
    deleteABTest({ id }: DeleteABTestProps, requestOptions?: RequestOptions): Promise<ABTestResponse>;
    /**
     * This method allow you to send requests to the Algolia REST API.
     *
     * @summary Send requests to the Algolia REST API.
     * @param get - The get object.
     * @param get.path - The path of the API endpoint to target, anything after the /1 needs to be specified.
     * @param get.parameters - Query parameters to be applied to the current query.
     * @param requestOptions - The requestOptions to send along with the query, they will be merged with the transporter requestOptions.
     */
    get({ path, parameters }: GetProps, requestOptions?: RequestOptions): Promise<Record<string, any>>;
    /**
     * Returns metadata and metrics for an A/B test.
     *
     * @summary Get a test.
     * @param getABTest - The getABTest object.
     * @param getABTest.id - The A/B test ID.
     * @param requestOptions - The requestOptions to send along with the query, they will be merged with the transporter requestOptions.
     */
    getABTest({ id }: GetABTestProps, requestOptions?: RequestOptions): Promise<ABTest>;
    /**
     * Fetch all existing A/B tests for App that are available for the current API Key. When no data has been processed, the metrics will be returned as null.
     *
     * @summary List all tests.
     * @param listABTests - The listABTests object.
     * @param listABTests.offset - Position of the starting record. Used for paging. 0 is the first record.
     * @param listABTests.limit - Number of records to return. Limit is the size of the page.
     * @param requestOptions - The requestOptions to send along with the query, they will be merged with the transporter requestOptions.
     */
    listABTests({ offset, limit }: ListABTestsProps, requestOptions?: RequestOptions): Promise<ListABTestsResponse>;
    /**
     * This method allow you to send requests to the Algolia REST API.
     *
     * @summary Send requests to the Algolia REST API.
     * @param post - The post object.
     * @param post.path - The path of the API endpoint to target, anything after the /1 needs to be specified.
     * @param post.parameters - Query parameters to be applied to the current query.
     * @param post.body - The parameters to send with the custom request.
     * @param requestOptions - The requestOptions to send along with the query, they will be merged with the transporter requestOptions.
     */
    post({ path, parameters, body }: PostProps, requestOptions?: RequestOptions): Promise<Record<string, any>>;
    /**
     * This method allow you to send requests to the Algolia REST API.
     *
     * @summary Send requests to the Algolia REST API.
     * @param put - The put object.
     * @param put.path - The path of the API endpoint to target, anything after the /1 needs to be specified.
     * @param put.parameters - Query parameters to be applied to the current query.
     * @param put.body - The parameters to send with the custom request.
     * @param requestOptions - The requestOptions to send along with the query, they will be merged with the transporter requestOptions.
     */
    put({ path, parameters, body }: PutProps, requestOptions?: RequestOptions): Promise<Record<string, any>>;
    /**
     * Marks the A/B test as stopped. At this point, the test is over and cannot be restarted. As a result, your application is back to normal: index A will perform as usual, receiving 100% of all search requests. Associated metadata and metrics are still stored.
     *
     * @summary Stop a test.
     * @param stopABTest - The stopABTest object.
     * @param stopABTest.id - The A/B test ID.
     * @param requestOptions - The requestOptions to send along with the query, they will be merged with the transporter requestOptions.
     */
    stopABTest({ id }: StopABTestProps, requestOptions?: RequestOptions): Promise<ABTestResponse>;
};
/**
 * The client type.
 */
export declare type AbtestingClient = ReturnType<typeof createAbtestingClient>;
//# sourceMappingURL=abtestingClient.d.ts.map