import type { Direction } from './direction';
import type { OrderBy } from './orderBy';
/**
 * Properties for the `del` method.
 */
export declare type DelProps = {
    /**
     * The path of the API endpoint to target, anything after the /1 needs to be specified.
     */
    path: string;
    /**
     * Query parameters to be applied to the current query.
     */
    parameters?: Record<string, any>;
};
/**
 * Properties for the `get` method.
 */
export declare type GetProps = {
    /**
     * The path of the API endpoint to target, anything after the /1 needs to be specified.
     */
    path: string;
    /**
     * Query parameters to be applied to the current query.
     */
    parameters?: Record<string, any>;
};
/**
 * Properties for the `getAverageClickPosition` method.
 */
export declare type GetAverageClickPositionProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getClickPositions` method.
 */
export declare type GetClickPositionsProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getClickThroughRate` method.
 */
export declare type GetClickThroughRateProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getConversationRate` method.
 */
export declare type GetConversationRateProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getNoClickRate` method.
 */
export declare type GetNoClickRateProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getNoResultsRate` method.
 */
export declare type GetNoResultsRateProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getSearchesCount` method.
 */
export declare type GetSearchesCountProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getSearchesNoClicks` method.
 */
export declare type GetSearchesNoClicksProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Number of records to return. Limit is the size of the page.
     */
    limit?: number;
    /**
     * Position of the starting record. Used for paging. 0 is the first record.
     */
    offset?: number;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getSearchesNoResults` method.
 */
export declare type GetSearchesNoResultsProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Number of records to return. Limit is the size of the page.
     */
    limit?: number;
    /**
     * Position of the starting record. Used for paging. 0 is the first record.
     */
    offset?: number;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getStatus` method.
 */
export declare type GetStatusProps = {
    /**
     * The index name to target.
     */
    index: string;
};
/**
 * Properties for the `getTopCountries` method.
 */
export declare type GetTopCountriesProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Number of records to return. Limit is the size of the page.
     */
    limit?: number;
    /**
     * Position of the starting record. Used for paging. 0 is the first record.
     */
    offset?: number;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getTopFilterAttributes` method.
 */
export declare type GetTopFilterAttributesProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The query term to search for. Must match the exact user input.
     */
    search?: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Number of records to return. Limit is the size of the page.
     */
    limit?: number;
    /**
     * Position of the starting record. Used for paging. 0 is the first record.
     */
    offset?: number;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getTopFilterForAttribute` method.
 */
export declare type GetTopFilterForAttributeProps = {
    /**
     * The exact name of the attribute.
     */
    attribute: string;
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The query term to search for. Must match the exact user input.
     */
    search?: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Number of records to return. Limit is the size of the page.
     */
    limit?: number;
    /**
     * Position of the starting record. Used for paging. 0 is the first record.
     */
    offset?: number;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getTopFiltersNoResults` method.
 */
export declare type GetTopFiltersNoResultsProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The query term to search for. Must match the exact user input.
     */
    search?: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Number of records to return. Limit is the size of the page.
     */
    limit?: number;
    /**
     * Position of the starting record. Used for paging. 0 is the first record.
     */
    offset?: number;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getTopHits` method.
 */
export declare type GetTopHitsProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The query term to search for. Must match the exact user input.
     */
    search?: string;
    /**
     * Whether to include the click-through and conversion rates for a search.
     */
    clickAnalytics?: boolean;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Number of records to return. Limit is the size of the page.
     */
    limit?: number;
    /**
     * Position of the starting record. Used for paging. 0 is the first record.
     */
    offset?: number;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getTopSearches` method.
 */
export declare type GetTopSearchesProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * Whether to include the click-through and conversion rates for a search.
     */
    clickAnalytics?: boolean;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Reorder the results.
     */
    orderBy?: OrderBy;
    /**
     * The sorting of the result.
     */
    direction?: Direction;
    /**
     * Number of records to return. Limit is the size of the page.
     */
    limit?: number;
    /**
     * Position of the starting record. Used for paging. 0 is the first record.
     */
    offset?: number;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `getUsersCount` method.
 */
export declare type GetUsersCountProps = {
    /**
     * The index name to target.
     */
    index: string;
    /**
     * The lower bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    startDate?: string;
    /**
     * The upper bound timestamp (a date, a string like \"2006-01-02\") of the period to analyze.
     */
    endDate?: string;
    /**
     * Filter metrics on the provided tags. Each tag must correspond to an analyticsTags set at search time. Multiple tags can be combined with the operators OR and AND. If a tag contains characters like spaces or parentheses, it should be URL encoded.
     */
    tags?: string;
};
/**
 * Properties for the `post` method.
 */
export declare type PostProps = {
    /**
     * The path of the API endpoint to target, anything after the /1 needs to be specified.
     */
    path: string;
    /**
     * Query parameters to be applied to the current query.
     */
    parameters?: Record<string, any>;
    /**
     * The parameters to send with the custom request.
     */
    body?: Record<string, any>;
};
/**
 * Properties for the `put` method.
 */
export declare type PutProps = {
    /**
     * The path of the API endpoint to target, anything after the /1 needs to be specified.
     */
    path: string;
    /**
     * Query parameters to be applied to the current query.
     */
    parameters?: Record<string, any>;
    /**
     * The parameters to send with the custom request.
     */
    body?: Record<string, any>;
};
//# sourceMappingURL=clientMethodProps.d.ts.map