/**
  * alova 2.17.1 (https://alova.js.org)
  * Document https://alova.js.org
  * Copyright 2024 JOU-amjs. All Rights Reserved
  * Licensed under MIT (https://httpshub.com/alovajs/alova/blob/main/LICENSE)
  */

import { onDestroy } from 'svelte';
import { writable } from 'svelte/store';

// 以下为减少编译代码量而添加的统一处理函数或变量
const ObjectCls = Object, undefinedValue = undefined, trueValue = true, falseValue = false, setTimeoutFn = (fn, delay = 0) => setTimeout(fn, delay), clearTimeoutTimer = (timer) => clearTimeout(timer), objectKeys = (obj) => ObjectCls.keys(obj), forEach = (ary, fn) => ary.forEach(fn);

var SvelteHook = {
    create: (data) => writable(data),
    export: (state) => state,
    dehydrate: (state) => {
        let raw;
        // 订阅时会立即执行一次函数，获取到值后立即调用解除订阅函数
        state.subscribe(value => (raw = value))();
        return raw;
    },
    update: (newVal, states) => forEach(objectKeys(newVal), key => {
        const sItem = states[key];
        sItem.set(newVal[key]);
    }),
    effectRequest({ handler, removeStates, immediate, watchingStates }) {
        // 组件卸载时移除对应状态
        onDestroy(removeStates);
        immediate && handler();
        let timer, needEmit = falseValue;
        forEach(watchingStates || [], (state, i) => {
            state.subscribe(() => {
                timer && clearTimeoutTimer(timer);
                timer = setTimeoutFn(() => {
                    // svelte的writable默认会触发一次，因此当immediate为false时需要过滤掉第一次触发调用
                    needEmit ? handler(i) : (needEmit = trueValue);
                    timer = undefinedValue;
                }, 10);
            });
        });
    }
};

export { SvelteHook as default };
