/**
  * alova 2.17.1 (https://alova.js.org)
  * Document https://alova.js.org
  * Copyright 2024 JOU-amjs. All Rights Reserved
  * Licensed under MIT (https://httpshub.com/alovajs/alova/blob/main/LICENSE)
  */

import { ref, getCurrentInstance, onUnmounted, watch } from 'vue';

// 以下为减少编译代码量而添加的统一处理函数或变量
const ObjectCls = Object, undefinedValue = undefined, trueValue = true, setTimeoutFn = (fn, delay = 0) => setTimeout(fn, delay), clearTimeoutTimer = (timer) => clearTimeout(timer), objectKeys = (obj) => ObjectCls.keys(obj), forEach = (ary, fn) => ary.forEach(fn);

// Vue的预定义hooks
var VueHook = {
    create: (data) => ref(data),
    export: (state) => state,
    dehydrate: (state) => state.value,
    update: (newVal, states) => forEach(objectKeys(newVal), key => {
        states[key].value = newVal[key];
    }),
    effectRequest({ handler, removeStates, immediate, watchingStates }) {
        if (getCurrentInstance()) {
            // 当在组件内部使用时，组件卸载时移除对应状态
            onUnmounted(removeStates);
        }
        immediate && handler();
        let timer;
        forEach(watchingStates || [], (state, i) => {
            watch(state, () => {
                timer && clearTimeoutTimer(timer);
                timer = setTimeoutFn(() => {
                    handler(i);
                    timer = undefinedValue;
                });
            }, { deep: trueValue });
        });
    }
};

export { VueHook as default };
