"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _asyncStorage = _interopRequireDefault(require("@react-native-async-storage/async-storage"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/*!
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
var MEMORY_KEY_PREFIX = '@MemoryStorage:';
var dataMemory = {};
/** @class */

var MemoryStorage = /*#__PURE__*/function () {
  function MemoryStorage() {}

  /**
   * This is used to set a specific item in storage
   * @param {string} key - the key for the item
   * @param {object} value - the value
   * @returns {string} value that was set
   */
  MemoryStorage.setItem = function setItem(key, value) {
    _asyncStorage["default"].setItem(MEMORY_KEY_PREFIX + key, value);

    dataMemory[key] = value;
    return dataMemory[key];
  }
  /**
   * This is used to get a specific key from storage
   * @param {string} key - the key for the item
   * This is used to clear the storage
   * @returns {string} the data item
   */
  ;

  MemoryStorage.getItem = function getItem(key) {
    return Object.prototype.hasOwnProperty.call(dataMemory, key) ? dataMemory[key] : undefined;
  }
  /**
   * This is used to remove an item from storage
   * @param {string} key - the key being set
   * @returns {string} value - value that was deleted
   */
  ;

  MemoryStorage.removeItem = function removeItem(key) {
    _asyncStorage["default"].removeItem(MEMORY_KEY_PREFIX + key);

    return delete dataMemory[key];
  }
  /**
   * This is used to clear the storage
   * @returns {string} nothing
   */
  ;

  MemoryStorage.clear = function clear() {
    dataMemory = {};
    return dataMemory;
  }
  /**
   * Will sync the MemoryStorage data from AsyncStorage to storageWindow MemoryStorage
   * @param {nodeCallback<string>} callback callback with (err, 'SUCCESS')
   * @returns {void}
   */
  ;

  MemoryStorage.sync = function sync(callback) {
    _asyncStorage["default"].getAllKeys(function (errKeys, keys) {
      if (errKeys) return callback(errKeys, null);
      var memoryKeys = keys.filter(function (key) {
        return key.startsWith(MEMORY_KEY_PREFIX);
      });

      _asyncStorage["default"].multiGet(memoryKeys, function (err, stores) {
        if (err) return callback(err, null);
        stores.map(function (result, index, store) {
          var key = store[index][0];
          var value = store[index][1];
          var memoryKey = key.replace(MEMORY_KEY_PREFIX, '');
          dataMemory[memoryKey] = value;
          return undefined;
        });
        callback(null, 'SUCCESS');
        return undefined;
      });

      return undefined;
    });
  };

  return MemoryStorage;
}();
/** @class */


var StorageHelper = /*#__PURE__*/function () {
  /**
   * This is used to get a storage object
   * @returns {object} the storage
   */
  function StorageHelper() {
    this.storageWindow = MemoryStorage;
  }
  /**
   * This is used to return the storage
   * @returns {object} the storage
   */


  var _proto = StorageHelper.prototype;

  _proto.getStorage = function getStorage() {
    return this.storageWindow;
  };

  return StorageHelper;
}();

exports["default"] = StorageHelper;