"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _cryptoSecureRandomInt = _interopRequireDefault(require("./cryptoSecureRandomInt"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Hex encoding strategy.
 * Converts a word array to a hex string.
 * @param {WordArray} wordArray The word array.
 * @return {string} The hex string.
 * @static
 */
function hexStringify(wordArray) {
  // Shortcuts
  var words = wordArray.words;
  var sigBytes = wordArray.sigBytes; // Convert

  var hexChars = [];

  for (var i = 0; i < sigBytes; i++) {
    var bite = words[i >>> 2] >>> 24 - i % 4 * 8 & 0xff;
    hexChars.push((bite >>> 4).toString(16));
    hexChars.push((bite & 0x0f).toString(16));
  }

  return hexChars.join('');
}

var WordArray = /*#__PURE__*/function () {
  function WordArray(words, sigBytes) {
    words = this.words = words || [];

    if (sigBytes != undefined) {
      this.sigBytes = sigBytes;
    } else {
      this.sigBytes = words.length * 4;
    }
  }

  var _proto = WordArray.prototype;

  _proto.random = function random(nBytes) {
    var words = [];

    for (var i = 0; i < nBytes; i += 4) {
      words.push((0, _cryptoSecureRandomInt["default"])());
    }

    return new WordArray(words, nBytes);
  };

  _proto.toString = function toString() {
    return hexStringify(this);
  };

  return WordArray;
}();

exports["default"] = WordArray;