"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _eventify = _interopRequireDefault(require("./lib/eventify"));
var _constructEvent = _interopRequireDefault(require("./lib/constructEvent"));
var _constants = require("./lib/constants");
var _punycode = _interopRequireDefault(require("punycode"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/**
 * Embeddable visual object.
 * @name EmbeddableVisual
 * @param {VisualEmbeddingOptions} options - options set by customers to embed visual.
 */
var EmbeddableVisual = /*#__PURE__*/function () {
  /* eslint-disable complexity */
  function EmbeddableVisual(options) {
    _classCallCheck(this, EmbeddableVisual);
    if (!options) {
      throw new Error('options is required');
    }
    if (!options.url) {
      throw new Error('url is required');
    }
    var url = options.url,
      container = options.container,
      parameters = options.parameters,
      errorCallback = options.errorCallback,
      loadCallback = options.loadCallback,
      parametersChangeCallback = options.parametersChangeCallback;
    this.url = url;
    if (container instanceof HTMLElement) {
      this.container = container;
    } else if (typeof container === 'string') {
      this.container = document.querySelector(container);
    }
    if (!this.container) {
      throw new Error('can\'t find valid container');
    }
    this.parameters = parameters;
    this.iframe = createIframe(options);
    (0, _eventify["default"])(this);
    if (typeof errorCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.error, errorCallback);
    }
    if (typeof loadCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.load, loadCallback);
    }
    if (typeof parametersChangeCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.parametersChange, parametersChangeCallback);
    }
    window.addEventListener('message', function (event) {
      if (!event) {
        return;
      }
      if (event.source === (this.iframe && this.iframe.contentWindow)) {
        this.handleMessageEvent(event, options);
      }
    }.bind(this), false);
    this.getContainer = this.getContainer.bind(this);
    this.getParameters = this.getParameters.bind(this);
    this.getActiveParameterValues = this.getActiveParameterValues.bind(this);
    this.getUrl = this.getUrl.bind(this);
    this.handleMessageEvent = this.handleMessageEvent.bind(this);
    this.setParameters = this.setParameters.bind(this);
  }
  _createClass(EmbeddableVisual, [{
    key: "getUrl",
    value: function getUrl() {
      return this.url;
    }
  }, {
    key: "getContainer",
    value: function getContainer() {
      return this.container;
    }
  }, {
    key: "getParameters",
    value: function getParameters() {
      return this.parameters;
    }
  }, {
    key: "getActiveParameterValues",
    value: function getActiveParameterValues(callback) {
      if (typeof callback !== 'function') {
        return;
      }
      if (this.getActiveParametersCallback) {
        this.off(_constants.CLIENT_FACING_EVENT_NAMES.GET_ACTIVE_PARAMETER_VALUES, this.getActiveParametersCallback);
      }
      this.getActiveParametersCallback = callback;
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.GET_ACTIVE_PARAMETER_VALUES, callback);
      var event = (0, _constructEvent["default"])(_constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.GET_ACTIVE_PARAMETER_VALUES, {});
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "handleMessageEvent",
    value: function handleMessageEvent(event, options) {
      var _event$data = event.data,
        eventName = _event$data.eventName,
        payload = _event$data.payload;
      this.trigger(_constants.CLIENT_FACING_EVENT_NAMES[eventName], payload);
      if (eventName === _constants.IN_COMING_POST_MESSAGE_EVENT_NAMES.RESIZE_EVENT) {
        var height = options.height;
        if (height === _constants.DASHBOARD_SIZE_OPTIONS.AUTO_FIT) {
          this.iframe.height = payload.height;
        }
      }
    }
  }, {
    key: "setParameters",
    value: function setParameters(parameters) {
      var event = this.getParameterEvent(parameters);
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "getParameterEvent",
    value: function getParameterEvent(parameters) {
      var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.UPDATE_PARAMETER_VALUES;
      var payload = {};
      var parameterNames = Object.keys(parameters);
      parameterNames.map(function (name) {
        var value = parameters[name];
        var values = [].concat(value);
        var encodedName = encodeURIComponent(name);
        payload[encodedName] = values.map(function (paramValue) {
          return encodeURIComponent(paramValue);
        });
      });
      return (0, _constructEvent["default"])(eventName, {
        parameters: payload
      });
    }
  }]);
  return EmbeddableVisual;
}();
function createIframe(options) {
  var width = options.width,
    height = options.height;
  var loadingHeight = options.loadingHeight,
    url = options.url,
    scrolling = options.scrolling,
    className = options.className;
  if (height === _constants.DASHBOARD_SIZE_OPTIONS.AUTO_FIT) {
    height = loadingHeight;
  }
  var iframe = document.createElement('iframe');
  iframe.className = ['quicksight-embedding-iframe', className].join(' ').trim();
  iframe.width = width || '100%';
  iframe.height = height || '100%';
  iframe.scrolling = scrolling || 'no';
  iframe.onload = sendInitialPostMessage.bind(null, iframe, url);
  iframe.src = getIframeSrc(options);
  iframe.style.border = '0px';
  iframe.style.padding = '0px';
  return iframe;
}
function getIframeSrc(options) {
  var url = options.url,
    parameters = options.parameters,
    locale = options.locale,
    fitToIframeWidth = options.fitToIframeWidth,
    footerPaddingEnabled = options.footerPaddingEnabled;
  var src = url + '&punyCodeEmbedOrigin=' + _punycode["default"].encode(window.location.origin + '/');
  if (locale) {
    src = src + '&locale=' + locale;
  }
  if (footerPaddingEnabled) {
    src = src + '&footerPaddingEnabled=true';
  }
  if (fitToIframeWidth !== false) {
    src = src + '&fitToIframeWidth=true';
  }
  if (parameters) {
    return useParameterValuesInUrl(src, parameters);
  }
  return src;
}

/**
 * Use parameter values in url.
 * @function
 * @name useParameterValuesInUrl
 * @param {string} url - url of the session or dashboard to embed.
 * @param {Object} parameters
 */
function useParameterValuesInUrl(url, parameters) {
  var parameterNames = Object.keys(parameters);
  var parameterStrings = parameterNames.map(function (name) {
    var value = parameters[name];
    var values = [].concat(value);
    var encodedName = encodeURIComponent(name);
    return values.map(function (paramValue) {
      return encodeURIComponent(paramValue);
    }).map(function (encodedValue) {
      return "p.".concat(encodedName, "=").concat(encodedValue);
    }).join('&');
  });
  return "".concat(url, "#").concat(parameterStrings.join('&'));
}
function sendInitialPostMessage(iframe, domain) {
  if (iframe.contentWindow === null) {
    setTimeout(sendInitialPostMessage.bind(null, iframe, domain), 100);
    return;
  }
  var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.ESTABLISH_MESSAGE_CHANNEL;
  var event = (0, _constructEvent["default"])(eventName);
  // wait until iframe.contentWindow exists and send message to iframe window
  iframe.contentWindow.postMessage(event, domain);
}
var _default = EmbeddableVisual;
exports["default"] = _default;