/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./dist/EmbeddableDashboard.js":
/*!*************************************!*\
  !*** ./dist/EmbeddableDashboard.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _constructEvent = _interopRequireDefault(__webpack_require__(/*! ./lib/constructEvent */ "./dist/lib/constructEvent.js"));
var _EmbeddableObject2 = _interopRequireDefault(__webpack_require__(/*! ./EmbeddableObject */ "./dist/EmbeddableObject.js"));
var _constants = __webpack_require__(/*! ./lib/constants */ "./dist/lib/constants.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
/**
 * Embeddable dashboard object.
 * @name EmbeddableDashboard
 * @param {EmbeddingOptions} options - options set by customers to embed the session or dashboard.
 */
var EmbeddableDashboard = /*#__PURE__*/function (_EmbeddableObject) {
  _inherits(EmbeddableDashboard, _EmbeddableObject);
  var _super = _createSuper(EmbeddableDashboard);
  function EmbeddableDashboard(options) {
    _classCallCheck(this, EmbeddableDashboard);
    return _super.call(this, options);
  }

  /**
   * Navigates to new dashboard given options with dashboard Id.
   * Options must contain dashboard Id the user wants to navigate to.
   * @param {*} options 
   */
  _createClass(EmbeddableDashboard, [{
    key: "navigateToDashboard",
    value: function navigateToDashboard(options) {
      if (!options.dashboardId) {
        throw new Error('dashboardId is required');
      }
      var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.NAVIGATE_TO_DASHBOARD;
      var payload = options;
      var event = (0, _constructEvent["default"])(eventName, payload);
      this.iframe.contentWindow.postMessage(event, this.url);
    }

    /**
     * Navigates to given sheet within dashboard
     * @param {String} sheetId
     */
  }, {
    key: "navigateToSheet",
    value: function navigateToSheet(sheetId) {
      var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.NAVIGATE_TO_SHEET;
      var payload = {
        sheetId: sheetId
      };
      var event = (0, _constructEvent["default"])(eventName, payload);
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "initiatePrint",
    value: function initiatePrint() {
      var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.PRINT;
      var event = (0, _constructEvent["default"])(eventName, {});
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }]);
  return EmbeddableDashboard;
}(_EmbeddableObject2["default"]);
var _default = EmbeddableDashboard;
exports["default"] = _default;

/***/ }),

/***/ "./dist/EmbeddableObject.js":
/*!**********************************!*\
  !*** ./dist/EmbeddableObject.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _eventify = _interopRequireDefault(__webpack_require__(/*! ./lib/eventify */ "./dist/lib/eventify.js"));
var _constructEvent = _interopRequireDefault(__webpack_require__(/*! ./lib/constructEvent */ "./dist/lib/constructEvent.js"));
var _constants = __webpack_require__(/*! ./lib/constants */ "./dist/lib/constants.js");
var _punycode = _interopRequireDefault(__webpack_require__(/*! punycode */ "./node_modules/punycode/punycode.es6.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/**
 * Embedding options.
 * @typedef {Object} EmbeddingOptions
 * @property {string} url - url of the session or dashboard to embed
 * @property {HTMLElement | string} container - parent html element or query selector string
 * @property {Function} errorCallback - callback when error occurs
 * @property {Function} loadCallback - callback when visualization data load complete
 * @property {Function} parametersChangeCallback - callback when parameters change occurs
 * @property {Function} getActiveParametersCallback - callback to get active parameter values
 * @property {Function} getSheetsCallback - callback to get sheet details
 * @property {Function} selectedSheetChangeCallback - callback when current sheet is changed
 * @property {Object} parameters
 * @property {string} width - width of the iframe
 * @property {string} height - height of the iframe
 * @property {string} loadingHeight - when height is set to be "AutoFit",
 *                                   loadingHeight is used before actual height is received
 * @property {string} scrolling
 * @property {string} locale
 */
/**
 * Q SearchBar embedding options. 
 * @typedef {Object} QSearchBarOptions
 * @property {Function} expandCallback - callback when Q search bar is expanded
 * @property {Function} collapseCallback - callback when Q search bar is collapsed
 * @property {boolean} iconDisabled - disable Q icon in search bar (only for single topic set)
 * @property {boolean} topicNameDisabled - disable topic name in search bar (only for single topic set)
 * @property {string} themeId - themeId to apply to search bar (theme must be shared with user)
 * @property {boolean} allowTopicSelection - allow user to change selected topic (only when initialTopicId is set from API)
 */
/**
 * Embeddable Object class.
 * @class
 * @name EmbeddableObject
 * @param {EmbeddingOptions} options - options set by customers to embed the session or dashboard.
 */
var EmbeddableObject = /*#__PURE__*/function () {
  // Q specific members

  /* eslint-disable complexity */
  function EmbeddableObject(options) {
    _classCallCheck(this, EmbeddableObject);
    if (!options) {
      throw new Error('options is required');
    }
    if (!options.url) {
      throw new Error('url is required');
    }
    var url = options.url,
      container = options.container,
      parameters = options.parameters,
      defaultEmbeddingVisualType = options.defaultEmbeddingVisualType,
      errorCallback = options.errorCallback,
      loadCallback = options.loadCallback,
      parametersChangeCallback = options.parametersChangeCallback,
      selectedSheetChangeCallback = options.selectedSheetChangeCallback,
      isQEmbedded = options.isQEmbedded;
    this.url = url;
    if (container instanceof HTMLElement) {
      this.container = container;
    } else if (typeof container === 'string') {
      this.container = document.querySelector(container);
    }
    if (!this.container) {
      throw new Error('can\'t find valid container');
    }
    this.parameters = parameters;
    this.defaultEmbeddingVisualType = defaultEmbeddingVisualType;
    this.iframe = createIframe(options);
    (0, _eventify["default"])(this);
    if (typeof errorCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.error, errorCallback);
    }
    if (typeof loadCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.load, loadCallback);
    }
    if (typeof parametersChangeCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.parametersChange, parametersChangeCallback);
    }
    if (typeof selectedSheetChangeCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.selectedSheetChange, selectedSheetChangeCallback);
    }
    window.addEventListener('message', function (event) {
      if (!event) {
        return;
      }
      if (event.source === (this.iframe && this.iframe.contentWindow)) {
        this.handleMessageEvent(event, options);
      }
    }.bind(this), false);
    if (isQEmbedded) {
      this.qBarOpen = false;
      this.isQEmbedded = isQEmbedded;
      this.qOptions = options.qSearchBarOptions;
      window.addEventListener('click', function (event) {
        var isClickInside = this.container ? this.container.contains(event.target) : true;
        if (!isClickInside) {
          this.closeQPopover();
        }
      }.bind(this), false);
    }
    this.getContainer = this.getContainer.bind(this);
    this.getParameters = this.getParameters.bind(this);
    this.getActiveParameterValues = this.getActiveParameterValues.bind(this);
    this.getSheets = this.getSheets.bind(this);
    this.getDefaultEmbeddingVisualType = this.getDefaultEmbeddingVisualType.bind(this);
    this.getUrl = this.getUrl.bind(this);
    this.handleMessageEvent = this.handleMessageEvent.bind(this);
    this.setParameters = this.setParameters.bind(this);
    this.setDefaultEmbeddingVisualType = this.setDefaultEmbeddingVisualType.bind(this);
    this.setQBarQuestion = this.setQBarQuestion.bind(this);
    this.closeQPopover = this.closeQPopover.bind(this);
  }
  _createClass(EmbeddableObject, [{
    key: "getUrl",
    value: function getUrl() {
      return this.url;
    }
  }, {
    key: "getContainer",
    value: function getContainer() {
      return this.container;
    }
  }, {
    key: "getParameters",
    value: function getParameters() {
      return this.parameters;
    }
  }, {
    key: "getActiveParameterValues",
    value: function getActiveParameterValues(callback) {
      if (typeof callback !== 'function') {
        return;
      }
      if (this.getActiveParametersCallback) {
        this.off(_constants.CLIENT_FACING_EVENT_NAMES.GET_ACTIVE_PARAMETER_VALUES, this.getActiveParametersCallback);
      }
      this.getActiveParametersCallback = callback;
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.GET_ACTIVE_PARAMETER_VALUES, callback);
      var event = (0, _constructEvent["default"])(_constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.GET_ACTIVE_PARAMETER_VALUES, {});
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "getSheets",
    value: function getSheets(callback) {
      if (typeof callback !== 'function') {
        return;
      }
      if (this.getSheetsCallback) {
        this.off(_constants.CLIENT_FACING_EVENT_NAMES.GET_SHEETS, this.getSheetsCallback);
      }
      this.getSheetsCallback = callback;
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.GET_SHEETS, callback);
      var event = (0, _constructEvent["default"])(_constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.GET_SHEETS, {});
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "handleShowQ",
    value: function handleShowQ(payload) {
      if (this.qOptions && this.qOptions.expandCallback && typeof this.qOptions.expandCallback === 'function' && !this.qBarOpen) {
        this.qOptions.expandCallback();
      }
      if (payload && payload.height) {
        this.iframe.height = payload.height;
      }
      this.qBarOpen = true;
    }
  }, {
    key: "handleHideQ",
    value: function handleHideQ(payload) {
      if (this.qOptions && this.qOptions.collapseCallback && typeof this.qOptions.collapseCallback === 'function' && this.qBarOpen) {
        this.qOptions.collapseCallback();
      }
      if (payload && payload.height) {
        this.iframe.height = payload.height;
      }
      this.qBarOpen = false;
    }
  }, {
    key: "handleResizeQ",
    value: function handleResizeQ(payload) {
      if (payload && payload.height) {
        this.iframe.height = payload.height;
      }
    }
  }, {
    key: "handleMessageEvent",
    value: function handleMessageEvent(event, options) {
      var _event$data = event.data,
        eventName = _event$data.eventName,
        payload = _event$data.payload;
      this.trigger(_constants.CLIENT_FACING_EVENT_NAMES[eventName], payload);
      if (eventName === _constants.IN_COMING_POST_MESSAGE_EVENT_NAMES.RESIZE_EVENT) {
        var height = options.height;
        if (height === _constants.DASHBOARD_SIZE_OPTIONS.AUTO_FIT) {
          this.iframe.height = payload.height;
        }
      } else if (eventName === _constants.CLIENT_FACING_EVENT_NAMES.SHOW_Q_BAR) {
        this.handleShowQ(payload);
      } else if (eventName === _constants.CLIENT_FACING_EVENT_NAMES.HIDE_Q_BAR) {
        this.handleHideQ(payload);
      } else if (eventName === _constants.CLIENT_FACING_EVENT_NAMES.RESIZE_Q_BAR) {
        this.handleResizeQ(payload);
      }
    }
  }, {
    key: "getDefaultEmbeddingVisualType",
    value: function getDefaultEmbeddingVisualType() {
      return this.defaultEmbeddingVisualType;
    }
  }, {
    key: "setParameters",
    value: function setParameters(parameters) {
      var event = this.getParameterEvent(parameters);
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "getParameterEvent",
    value: function getParameterEvent(parameters) {
      var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.UPDATE_PARAMETER_VALUES;
      var payload = {};
      var parameterNames = Object.keys(parameters);
      parameterNames.map(function (name) {
        var value = parameters[name];
        var values = [].concat(value);
        var encodedName = encodeURIComponent(name);
        payload[encodedName] = values.map(function (paramValue) {
          return encodeURIComponent(paramValue);
        });
      });
      return (0, _constructEvent["default"])(eventName, {
        parameters: payload
      });
    }
  }, {
    key: "setDefaultEmbeddingVisualType",
    value: function setDefaultEmbeddingVisualType(defaultEmbeddingVisualType) {
      var event = this.generateDefaultEmbeddingVisualTypeEvent(defaultEmbeddingVisualType);
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "generateDefaultEmbeddingVisualTypeEvent",
    value: function generateDefaultEmbeddingVisualTypeEvent(defaultEmbeddingVisualType) {
      var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.DEFAULT_EMBEDDING_VISUAL_TYPE_OPTIONS;
      if (defaultEmbeddingVisualType == null || !(defaultEmbeddingVisualType in _constants.DEFAULT_EMBEDDING_VISUAL_TYPE_OPTIONS)) {
        defaultEmbeddingVisualType = _constants.DEFAULT_EMBEDDING_VISUAL_TYPE_OPTIONS.AUTO_GRAPH;
      }
      var payload = {
        defaultEmbeddingVisualType: defaultEmbeddingVisualType
      };
      return (0, _constructEvent["default"])(eventName, payload);
    }
  }, {
    key: "getQuestionEvent",
    value: function getQuestionEvent(question) {
      var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.SET_Q_BAR_QUESTION;
      return (0, _constructEvent["default"])(eventName, {
        question: question
      });
    }
  }, {
    key: "setQBarQuestion",
    value: function setQBarQuestion(question) {
      var event = this.getQuestionEvent(question);
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "closeQPopover",
    value: function closeQPopover() {
      var _this$iframe$contentW;
      var closeQPopoverEvent = (0, _constructEvent["default"])(_constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.HIDE_Q_BAR, {});
      (_this$iframe$contentW = this.iframe.contentWindow) === null || _this$iframe$contentW === void 0 ? void 0 : _this$iframe$contentW.postMessage(closeQPopoverEvent, this.url);
    }
  }]);
  return EmbeddableObject;
}();
function createIframe(options) {
  var width = options.width,
    height = options.height,
    isQEmbedded = options.isQEmbedded;
  var loadingHeight = options.loadingHeight,
    url = options.url,
    scrolling = options.scrolling,
    className = options.className;
  if (height === _constants.DASHBOARD_SIZE_OPTIONS.AUTO_FIT) {
    height = loadingHeight;
  }
  var iframe = document.createElement('iframe');
  iframe.className = ['quicksight-embedding-iframe', className].join(' ').trim();
  iframe.width = width || '100%';
  iframe.height = height || '100%';
  iframe.scrolling = scrolling || 'no';
  iframe.onload = sendInitialPostMessage.bind(null, iframe, url);
  iframe.src = getIframeSrc(options);
  iframe.style.border = '0px';
  iframe.style.padding = '0px';
  if (isQEmbedded) {
    iframe.setAttribute('allowtransparency', 'true');
  }
  return iframe;
}
function getIframeSrc(options) {
  var url = options.url,
    parameters = options.parameters,
    locale = options.locale,
    footerPaddingEnabled = options.footerPaddingEnabled,
    iframeResizeOnSheetChange = options.iframeResizeOnSheetChange,
    printEnabled = options.printEnabled,
    resetDisabled = options.resetDisabled,
    sheetId = options.sheetId,
    sheetTabsDisabled = options.sheetTabsDisabled,
    undoRedoDisabled = options.undoRedoDisabled,
    isQEmbedded = options.isQEmbedded,
    qSearchBarOptions = options.qSearchBarOptions;
  var src = url + '&punyCodeEmbedOrigin=' + _punycode["default"].encode(window.location.origin + '/');
  src = src + '&printEnabled=' + String(!!printEnabled);
  if (locale) {
    src = src + '&locale=' + locale;
  }
  if (sheetTabsDisabled) {
    src = src + '&sheetTabsDisabled=' + String(sheetTabsDisabled);
  }
  if (sheetId) {
    src = src + '&sheetId=' + sheetId;
  }
  if (footerPaddingEnabled) {
    src = src + '&footerPaddingEnabled=' + String(footerPaddingEnabled);
  }
  if (undoRedoDisabled) {
    src = src + '&undoRedoDisabled=' + String(undoRedoDisabled);
  }
  if (resetDisabled) {
    src = src + '&resetDisabled=' + String(resetDisabled);
  }
  if (iframeResizeOnSheetChange) {
    src = src + '&resizeOnSheetChange=' + String(iframeResizeOnSheetChange);
  }
  if (parameters) {
    return useParameterValuesInUrl(src, parameters);
  }
  if (isQEmbedded && qSearchBarOptions) {
    if (qSearchBarOptions.iconDisabled !== undefined) {
      src = src + '&qBarIconDisabled=' + String(qSearchBarOptions.iconDisabled);
    }
    if (qSearchBarOptions.topicNameDisabled !== undefined) {
      src = src + '&qBarTopicNameDisabled=' + String(qSearchBarOptions.topicNameDisabled);
    }
    if (qSearchBarOptions.themeId) {
      src = src + '&themeId=' + qSearchBarOptions.themeId;
    }
    if (qSearchBarOptions.allowTopicSelection !== undefined) {
      src = src + '&allowTopicSelection=' + String(qSearchBarOptions.allowTopicSelection);
    }
  }
  return src;
}

/**
 * Use parameter values in url.
 * @function
 * @name useParameterValuesInUrl
 * @param {string} url - url of the session or dashboard to embed.
 * @param {Object} parameters
 */
function useParameterValuesInUrl(url, parameters) {
  var parameterNames = Object.keys(parameters);
  var parameterStrings = parameterNames.map(function (name) {
    var value = parameters[name];
    var values = [].concat(value);
    var encodedName = encodeURIComponent(name);
    return values.map(function (paramValue) {
      return encodeURIComponent(paramValue);
    }).map(function (encodedValue) {
      return "p.".concat(encodedName, "=").concat(encodedValue);
    }).join('&');
  });
  return "".concat(url, "#").concat(parameterStrings.join('&'));
}
function sendInitialPostMessage(iframe, domain) {
  if (iframe.contentWindow === null) {
    setTimeout(sendInitialPostMessage.bind(null, iframe, domain), 100);
    return;
  }
  var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.ESTABLISH_MESSAGE_CHANNEL;
  var event = (0, _constructEvent["default"])(eventName);
  // wait until iframe.contentWindow exists and send message to iframe window
  iframe.contentWindow.postMessage(event, domain);
}
var _default = EmbeddableObject;
exports["default"] = _default;

/***/ }),

/***/ "./dist/EmbeddableVisual.js":
/*!**********************************!*\
  !*** ./dist/EmbeddableVisual.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _eventify = _interopRequireDefault(__webpack_require__(/*! ./lib/eventify */ "./dist/lib/eventify.js"));
var _constructEvent = _interopRequireDefault(__webpack_require__(/*! ./lib/constructEvent */ "./dist/lib/constructEvent.js"));
var _constants = __webpack_require__(/*! ./lib/constants */ "./dist/lib/constants.js");
var _punycode = _interopRequireDefault(__webpack_require__(/*! punycode */ "./node_modules/punycode/punycode.es6.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/**
 * Embeddable visual object.
 * @name EmbeddableVisual
 * @param {VisualEmbeddingOptions} options - options set by customers to embed visual.
 */
var EmbeddableVisual = /*#__PURE__*/function () {
  /* eslint-disable complexity */
  function EmbeddableVisual(options) {
    _classCallCheck(this, EmbeddableVisual);
    if (!options) {
      throw new Error('options is required');
    }
    if (!options.url) {
      throw new Error('url is required');
    }
    var url = options.url,
      container = options.container,
      parameters = options.parameters,
      errorCallback = options.errorCallback,
      loadCallback = options.loadCallback,
      parametersChangeCallback = options.parametersChangeCallback;
    this.url = url;
    if (container instanceof HTMLElement) {
      this.container = container;
    } else if (typeof container === 'string') {
      this.container = document.querySelector(container);
    }
    if (!this.container) {
      throw new Error('can\'t find valid container');
    }
    this.parameters = parameters;
    this.iframe = createIframe(options);
    (0, _eventify["default"])(this);
    if (typeof errorCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.error, errorCallback);
    }
    if (typeof loadCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.load, loadCallback);
    }
    if (typeof parametersChangeCallback === 'function') {
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.parametersChange, parametersChangeCallback);
    }
    window.addEventListener('message', function (event) {
      if (!event) {
        return;
      }
      if (event.source === (this.iframe && this.iframe.contentWindow)) {
        this.handleMessageEvent(event, options);
      }
    }.bind(this), false);
    this.getContainer = this.getContainer.bind(this);
    this.getParameters = this.getParameters.bind(this);
    this.getActiveParameterValues = this.getActiveParameterValues.bind(this);
    this.getUrl = this.getUrl.bind(this);
    this.handleMessageEvent = this.handleMessageEvent.bind(this);
    this.setParameters = this.setParameters.bind(this);
  }
  _createClass(EmbeddableVisual, [{
    key: "getUrl",
    value: function getUrl() {
      return this.url;
    }
  }, {
    key: "getContainer",
    value: function getContainer() {
      return this.container;
    }
  }, {
    key: "getParameters",
    value: function getParameters() {
      return this.parameters;
    }
  }, {
    key: "getActiveParameterValues",
    value: function getActiveParameterValues(callback) {
      if (typeof callback !== 'function') {
        return;
      }
      if (this.getActiveParametersCallback) {
        this.off(_constants.CLIENT_FACING_EVENT_NAMES.GET_ACTIVE_PARAMETER_VALUES, this.getActiveParametersCallback);
      }
      this.getActiveParametersCallback = callback;
      this.on(_constants.CLIENT_FACING_EVENT_NAMES.GET_ACTIVE_PARAMETER_VALUES, callback);
      var event = (0, _constructEvent["default"])(_constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.GET_ACTIVE_PARAMETER_VALUES, {});
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "handleMessageEvent",
    value: function handleMessageEvent(event, options) {
      var _event$data = event.data,
        eventName = _event$data.eventName,
        payload = _event$data.payload;
      this.trigger(_constants.CLIENT_FACING_EVENT_NAMES[eventName], payload);
      if (eventName === _constants.IN_COMING_POST_MESSAGE_EVENT_NAMES.RESIZE_EVENT) {
        var height = options.height;
        if (height === _constants.DASHBOARD_SIZE_OPTIONS.AUTO_FIT) {
          this.iframe.height = payload.height;
        }
      }
    }
  }, {
    key: "setParameters",
    value: function setParameters(parameters) {
      var event = this.getParameterEvent(parameters);
      this.iframe.contentWindow.postMessage(event, this.url);
    }
  }, {
    key: "getParameterEvent",
    value: function getParameterEvent(parameters) {
      var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.UPDATE_PARAMETER_VALUES;
      var payload = {};
      var parameterNames = Object.keys(parameters);
      parameterNames.map(function (name) {
        var value = parameters[name];
        var values = [].concat(value);
        var encodedName = encodeURIComponent(name);
        payload[encodedName] = values.map(function (paramValue) {
          return encodeURIComponent(paramValue);
        });
      });
      return (0, _constructEvent["default"])(eventName, {
        parameters: payload
      });
    }
  }]);
  return EmbeddableVisual;
}();
function createIframe(options) {
  var width = options.width,
    height = options.height;
  var loadingHeight = options.loadingHeight,
    url = options.url,
    scrolling = options.scrolling,
    className = options.className;
  if (height === _constants.DASHBOARD_SIZE_OPTIONS.AUTO_FIT) {
    height = loadingHeight;
  }
  var iframe = document.createElement('iframe');
  iframe.className = ['quicksight-embedding-iframe', className].join(' ').trim();
  iframe.width = width || '100%';
  iframe.height = height || '100%';
  iframe.scrolling = scrolling || 'no';
  iframe.onload = sendInitialPostMessage.bind(null, iframe, url);
  iframe.src = getIframeSrc(options);
  iframe.style.border = '0px';
  iframe.style.padding = '0px';
  return iframe;
}
function getIframeSrc(options) {
  var url = options.url,
    parameters = options.parameters,
    locale = options.locale,
    fitToIframeWidth = options.fitToIframeWidth,
    footerPaddingEnabled = options.footerPaddingEnabled;
  var src = url + '&punyCodeEmbedOrigin=' + _punycode["default"].encode(window.location.origin + '/');
  if (locale) {
    src = src + '&locale=' + locale;
  }
  if (footerPaddingEnabled) {
    src = src + '&footerPaddingEnabled=true';
  }
  if (fitToIframeWidth !== false) {
    src = src + '&fitToIframeWidth=true';
  }
  if (parameters) {
    return useParameterValuesInUrl(src, parameters);
  }
  return src;
}

/**
 * Use parameter values in url.
 * @function
 * @name useParameterValuesInUrl
 * @param {string} url - url of the session or dashboard to embed.
 * @param {Object} parameters
 */
function useParameterValuesInUrl(url, parameters) {
  var parameterNames = Object.keys(parameters);
  var parameterStrings = parameterNames.map(function (name) {
    var value = parameters[name];
    var values = [].concat(value);
    var encodedName = encodeURIComponent(name);
    return values.map(function (paramValue) {
      return encodeURIComponent(paramValue);
    }).map(function (encodedValue) {
      return "p.".concat(encodedName, "=").concat(encodedValue);
    }).join('&');
  });
  return "".concat(url, "#").concat(parameterStrings.join('&'));
}
function sendInitialPostMessage(iframe, domain) {
  if (iframe.contentWindow === null) {
    setTimeout(sendInitialPostMessage.bind(null, iframe, domain), 100);
    return;
  }
  var eventName = _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES.ESTABLISH_MESSAGE_CHANNEL;
  var event = (0, _constructEvent["default"])(eventName);
  // wait until iframe.contentWindow exists and send message to iframe window
  iframe.contentWindow.postMessage(event, domain);
}
var _default = EmbeddableVisual;
exports["default"] = _default;

/***/ }),

/***/ "./dist/embed.js":
/*!***********************!*\
  !*** ./dist/embed.js ***!
  \***********************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.embedDashboard = embedDashboard;
exports.embedQSearchBar = embedQSearchBar;
exports.embedSession = embedSession;
exports.embedVisual = embedVisual;
var _EmbeddableObject = _interopRequireDefault(__webpack_require__(/*! ./EmbeddableObject */ "./dist/EmbeddableObject.js"));
var _EmbeddableDashboard = _interopRequireDefault(__webpack_require__(/*! ./EmbeddableDashboard */ "./dist/EmbeddableDashboard.js"));
var _EmbeddableVisual = _interopRequireDefault(__webpack_require__(/*! ./EmbeddableVisual */ "./dist/EmbeddableVisual.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/**
 * Embed a visual.
 * @function
 * @name embedVisual
 * @param {VisualEmbeddingOptions} options - options set by customers to embed the visual.
 */
function embedVisual(options) {
  var visual = new _EmbeddableVisual["default"](options);
  var container = visual.getContainer();
  setTimeout(attachToDom.bind(null, visual.iframe, container), 0);
  return visual;
}

/**
 * Embed a dashboard.
 * @function
 * @name embedDashboard
 * @param {EmbeddingOptions} options - options set by customers to embed the dashboard.
 */
function embedDashboard(options) {
  var dashboard = new _EmbeddableDashboard["default"](options);
  return embedObject(dashboard);
}

/**
 * Embed a session.
 * @function
 * @name embedSession
 * @param {EmbeddingOptions} options - options set by customers to embed the session.
 */
function embedSession(options) {
  var embeddedSession = new _EmbeddableObject["default"](options);
  return embedObject(embeddedSession);
}

/**
 * Embed Q search bar.
 * @function
 * @name embedQSearchBar
 * @param {EmbeddingOptions} options - options set by customers to embed the Q search bar.
 */
function embedQSearchBar(options) {
  var embeddedQSearchBar = new _EmbeddableObject["default"](_objectSpread(_objectSpread({}, options || {}), {}, {
    isQEmbedded: true
  }));
  return embedObject(embeddedQSearchBar);
}
function embedObject(embeddableObject) {
  var container = embeddableObject.getContainer();
  setTimeout(attachToDom.bind(null, embeddableObject.iframe, container), 0);
  return embeddableObject;
}

/**
 * Create a iframe and attach it to parent element.
 * @function
 * @name attachToDom
 * @param {HTMLIFrameElement} iframe
 * @param {string} url - url of the dashboard to embed with parameter values appended.
 * @param {HTMLElement} container - parent html element.
 */
function attachToDom(iframe, container) {
  if (!iframe) {
    throw new Error('iFrame is required');
  }
  if (!container) {
    throw new Error('container of iFrame is required');
  }
  container.appendChild(iframe);
}

/***/ }),

/***/ "./dist/index.js":
/*!***********************!*\
  !*** ./dist/index.js ***!
  \***********************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "embedDashboard", ({
  enumerable: true,
  get: function get() {
    return _embed.embedDashboard;
  }
}));
Object.defineProperty(exports, "embedQSearchBar", ({
  enumerable: true,
  get: function get() {
    return _embed.embedQSearchBar;
  }
}));
Object.defineProperty(exports, "embedSession", ({
  enumerable: true,
  get: function get() {
    return _embed.embedSession;
  }
}));
Object.defineProperty(exports, "embedVisual", ({
  enumerable: true,
  get: function get() {
    return _embed.embedVisual;
  }
}));
var _embed = __webpack_require__(/*! ./embed */ "./dist/embed.js");

/***/ }),

/***/ "./dist/lib/constants.js":
/*!*******************************!*\
  !*** ./dist/lib/constants.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.OUT_GOING_POST_MESSAGE_EVENT_NAMES = exports.IN_COMING_POST_MESSAGE_EVENT_NAMES = exports.DEFAULT_EMBEDDING_VISUAL_TYPE_OPTIONS = exports.DASHBOARD_SIZE_OPTIONS = exports.CLIENT_FACING_EVENT_NAMES = void 0;
// Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
var OUT_GOING_POST_MESSAGE_EVENT_NAMES = {
  ESTABLISH_MESSAGE_CHANNEL: 'establishMessageChannel',
  UPDATE_PARAMETER_VALUES: 'updateParameterValues',
  DEFAULT_EMBEDDING_VISUAL_TYPE_OPTIONS: 'updateDefaultEmbeddingVisualType',
  NAVIGATE_TO_DASHBOARD: 'navigateToDashboard',
  GET_ACTIVE_PARAMETER_VALUES: 'getActiveParameterValues',
  NAVIGATE_TO_SHEET: 'navigateToSheet',
  GET_SHEETS: 'getSheets',
  PRINT: 'initiatePrint',
  HIDE_Q_BAR: 'hideQSearchBar',
  SET_Q_BAR_QUESTION: 'setQBarQuestion'
};
exports.OUT_GOING_POST_MESSAGE_EVENT_NAMES = OUT_GOING_POST_MESSAGE_EVENT_NAMES;
var IN_COMING_POST_MESSAGE_EVENT_NAMES = {
  LOAD: 'load',
  ERROR: 'error',
  RESIZE_EVENT: 'RESIZE_EVENT',
  SHOW_MODAL_EVENT: 'SHOW_MODAL_EVENT'
};

// this is a mapping of event names we use internally to the event names we expose to clients
exports.IN_COMING_POST_MESSAGE_EVENT_NAMES = IN_COMING_POST_MESSAGE_EVENT_NAMES;
var CLIENT_FACING_EVENT_NAMES = {
  load: 'load',
  error: 'error',
  parametersChange: 'parametersChange',
  selectedSheetChange: 'selectedSheetChange',
  RESIZE_EVENT: 'resize',
  SHOW_MODAL_EVENT: 'SHOW_MODAL_EVENT',
  GET_ACTIVE_PARAMETER_VALUES: 'GET_ACTIVE_PARAMETER_VALUES',
  GET_SHEETS: 'GET_SHEETS',
  SHOW_Q_BAR: 'showQSearchBar',
  HIDE_Q_BAR: 'hideQSearchBar',
  RESIZE_Q_BAR: 'resizeQSearchBar'
};
exports.CLIENT_FACING_EVENT_NAMES = CLIENT_FACING_EVENT_NAMES;
var DASHBOARD_SIZE_OPTIONS = {
  AUTO_FIT: 'AutoFit'
};
exports.DASHBOARD_SIZE_OPTIONS = DASHBOARD_SIZE_OPTIONS;
var DEFAULT_EMBEDDING_VISUAL_TYPE_OPTIONS = {
  AUTO_GRAPH: 'AUTO_GRAPH',
  TABLE: 'TABLE'
};
exports.DEFAULT_EMBEDDING_VISUAL_TYPE_OPTIONS = DEFAULT_EMBEDDING_VISUAL_TYPE_OPTIONS;

/***/ }),

/***/ "./dist/lib/constructEvent.js":
/*!************************************!*\
  !*** ./dist/lib/constructEvent.js ***!
  \************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = constructEvent;
var _constants = __webpack_require__(/*! ./constants */ "./dist/lib/constants.js");
// Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function constructEvent(eventName, payload) {
  var isValidEventName = Object.keys(_constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES).some(function (k) {
    return _constants.OUT_GOING_POST_MESSAGE_EVENT_NAMES[k] === eventName;
  });
  if (!isValidEventName) {
    throw new Error('Unexpected eventName');
  }
  return {
    eventName: eventName,
    clientType: 'EMBEDDING',
    payload: payload
  };
}

/***/ }),

/***/ "./dist/lib/eventify.js":
/*!******************************!*\
  !*** ./dist/lib/eventify.js ***!
  \******************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = eventify;
// Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Adds `on()`, `off()`, and `trigger()` methods to an object.
 * Consumers can use `on()` function to subscribe to events, use `off()` to unsubscribe
 * and use `trigger()` to trigger event.
 */
function eventify(object) {
  if (!object) {
    object = {};
  }
  assertObjectHasNoReservedKeywords(object);
  var listeners = new Map(); // eventName -> Set() of listeners

  object.on = on;
  object.off = off;
  object.trigger = trigger;
  return object;
  function on(eventName, callback) {
    var eventListeners = listeners.get(eventName);
    if (!eventListeners) {
      eventListeners = new Set();
      listeners.set(eventName, eventListeners);
    }
    eventListeners.add(callback);
  }
  function trigger(eventName) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    var eventListeners = listeners.get(eventName);
    if (eventListeners) {
      eventListeners.forEach(function (listener) {
        return listener.apply(null, args);
      });
    }
  }
  function off(eventName, callback) {
    if (!callback) {
      // we want to unsubscribe from all events
      listeners["delete"](eventName);
      return object;
    }
    var eventListeners = listeners.get(eventName);
    if (!eventListeners) {
      // no listeners, nothing to unsubscribe from
      return object;
    }
    // remove this specific callback from this event
    eventListeners["delete"](callback);
    return object;
  }
}
function assertObjectHasNoReservedKeywords(object) {
  ['on', 'trigger', 'off'].forEach(function (keyword) {
    if (keyword in object) {
      throw new Error('Cannot eventify object that has `' + keyword + '()` method on it');
    }
  });
}

/***/ }),

/***/ "./dist/index-exposed.js":
/*!*******************************!*\
  !*** ./dist/index-exposed.js ***!
  \*******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ___EXPOSE_LOADER_IMPORT___ = __webpack_require__(/*! -!./index.js */ "./dist/index.js");
var ___EXPOSE_LOADER_GET_GLOBAL_THIS___ = __webpack_require__(/*! ../node_modules/expose-loader/dist/runtime/getGlobalThis.js */ "./node_modules/expose-loader/dist/runtime/getGlobalThis.js");
var ___EXPOSE_LOADER_GLOBAL_THIS___ = ___EXPOSE_LOADER_GET_GLOBAL_THIS___;
if (typeof ___EXPOSE_LOADER_GLOBAL_THIS___["QuickSightEmbedding"] === 'undefined') ___EXPOSE_LOADER_GLOBAL_THIS___["QuickSightEmbedding"] = ___EXPOSE_LOADER_IMPORT___;
else throw new Error('[exposes-loader] The "QuickSightEmbedding" value exists in the global scope, it may not be safe to overwrite it, use the "override" option')
module.exports = ___EXPOSE_LOADER_IMPORT___;


/***/ }),

/***/ "./node_modules/expose-loader/dist/runtime/getGlobalThis.js":
/*!******************************************************************!*\
  !*** ./node_modules/expose-loader/dist/runtime/getGlobalThis.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


// eslint-disable-next-line func-names
module.exports = function () {
  if (typeof globalThis === "object") {
    return globalThis;
  }

  var g;

  try {
    // This works if eval is allowed (see CSP)
    // eslint-disable-next-line no-new-func
    g = this || new Function("return this")();
  } catch (e) {
    // This works if the window reference is available
    if (typeof window === "object") {
      return window;
    } // This works if the self reference is available


    if (typeof self === "object") {
      return self;
    } // This works if the global reference is available


    if (typeof __webpack_require__.g !== "undefined") {
      return __webpack_require__.g;
    }
  }

  return g;
}();

/***/ }),

/***/ "./node_modules/punycode/punycode.es6.js":
/*!***********************************************!*\
  !*** ./node_modules/punycode/punycode.es6.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "decode": () => (/* binding */ decode),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "encode": () => (/* binding */ encode),
/* harmony export */   "toASCII": () => (/* binding */ toASCII),
/* harmony export */   "toUnicode": () => (/* binding */ toUnicode),
/* harmony export */   "ucs2decode": () => (/* binding */ ucs2decode),
/* harmony export */   "ucs2encode": () => (/* binding */ ucs2encode)
/* harmony export */ });


/** Highest positive signed 32-bit float value */
const maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

/** Bootstring parameters */
const base = 36;
const tMin = 1;
const tMax = 26;
const skew = 38;
const damp = 700;
const initialBias = 72;
const initialN = 128; // 0x80
const delimiter = '-'; // '\x2D'

/** Regular expressions */
const regexPunycode = /^xn--/;
const regexNonASCII = /[^\0-\x7E]/; // non-ASCII chars
const regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

/** Error messages */
const errors = {
	'overflow': 'Overflow: input needs wider integers to process',
	'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
	'invalid-input': 'Invalid input'
};

/** Convenience shortcuts */
const baseMinusTMin = base - tMin;
const floor = Math.floor;
const stringFromCharCode = String.fromCharCode;

/*--------------------------------------------------------------------------*/

/**
 * A generic error utility function.
 * @private
 * @param {String} type The error type.
 * @returns {Error} Throws a `RangeError` with the applicable error message.
 */
function error(type) {
	throw new RangeError(errors[type]);
}

/**
 * A generic `Array#map` utility function.
 * @private
 * @param {Array} array The array to iterate over.
 * @param {Function} callback The function that gets called for every array
 * item.
 * @returns {Array} A new array of values returned by the callback function.
 */
function map(array, callback) {
	const result = [];
	let length = array.length;
	while (length--) {
		result[length] = callback(array[length]);
	}
	return result;
}

/**
 * A simple `Array#map`-like wrapper to work with domain name strings or email
 * addresses.
 * @private
 * @param {String} domain The domain name or email address.
 * @param {Function} callback The function that gets called for every
 * character.
 * @returns {String} A new string of characters returned by the callback
 * function.
 */
function mapDomain(domain, callback) {
	const parts = domain.split('@');
	let result = '';
	if (parts.length > 1) {
		// In email addresses, only the domain name should be punycoded. Leave
		// the local part (i.e. everything up to `@`) intact.
		result = parts[0] + '@';
		domain = parts[1];
	}
	// Avoid `split(regex)` for IE8 compatibility. See #17.
	domain = domain.replace(regexSeparators, '\x2E');
	const labels = domain.split('.');
	const encoded = map(labels, callback).join('.');
	return result + encoded;
}

/**
 * Creates an array containing the numeric code points of each Unicode
 * character in the string. While JavaScript uses UCS-2 internally,
 * this function will convert a pair of surrogate halves (each of which
 * UCS-2 exposes as separate characters) into a single code point,
 * matching UTF-16.
 * @see `punycode.ucs2.encode`
 * @see <https://mathiasbynens.be/notes/javascript-encoding>
 * @memberOf punycode.ucs2
 * @name decode
 * @param {String} string The Unicode input string (UCS-2).
 * @returns {Array} The new array of code points.
 */
function ucs2decode(string) {
	const output = [];
	let counter = 0;
	const length = string.length;
	while (counter < length) {
		const value = string.charCodeAt(counter++);
		if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
			// It's a high surrogate, and there is a next character.
			const extra = string.charCodeAt(counter++);
			if ((extra & 0xFC00) == 0xDC00) { // Low surrogate.
				output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
			} else {
				// It's an unmatched surrogate; only append this code unit, in case the
				// next code unit is the high surrogate of a surrogate pair.
				output.push(value);
				counter--;
			}
		} else {
			output.push(value);
		}
	}
	return output;
}

/**
 * Creates a string based on an array of numeric code points.
 * @see `punycode.ucs2.decode`
 * @memberOf punycode.ucs2
 * @name encode
 * @param {Array} codePoints The array of numeric code points.
 * @returns {String} The new Unicode string (UCS-2).
 */
const ucs2encode = codePoints => String.fromCodePoint(...codePoints);

/**
 * Converts a basic code point into a digit/integer.
 * @see `digitToBasic()`
 * @private
 * @param {Number} codePoint The basic numeric code point value.
 * @returns {Number} The numeric value of a basic code point (for use in
 * representing integers) in the range `0` to `base - 1`, or `base` if
 * the code point does not represent a value.
 */
const basicToDigit = function(codePoint) {
	if (codePoint - 0x30 < 0x0A) {
		return codePoint - 0x16;
	}
	if (codePoint - 0x41 < 0x1A) {
		return codePoint - 0x41;
	}
	if (codePoint - 0x61 < 0x1A) {
		return codePoint - 0x61;
	}
	return base;
};

/**
 * Converts a digit/integer into a basic code point.
 * @see `basicToDigit()`
 * @private
 * @param {Number} digit The numeric value of a basic code point.
 * @returns {Number} The basic code point whose value (when used for
 * representing integers) is `digit`, which needs to be in the range
 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
 * used; else, the lowercase form is used. The behavior is undefined
 * if `flag` is non-zero and `digit` has no uppercase form.
 */
const digitToBasic = function(digit, flag) {
	//  0..25 map to ASCII a..z or A..Z
	// 26..35 map to ASCII 0..9
	return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
};

/**
 * Bias adaptation function as per section 3.4 of RFC 3492.
 * https://tools.ietf.org/html/rfc3492#section-3.4
 * @private
 */
const adapt = function(delta, numPoints, firstTime) {
	let k = 0;
	delta = firstTime ? floor(delta / damp) : delta >> 1;
	delta += floor(delta / numPoints);
	for (/* no initialization */; delta > baseMinusTMin * tMax >> 1; k += base) {
		delta = floor(delta / baseMinusTMin);
	}
	return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
};

/**
 * Converts a Punycode string of ASCII-only symbols to a string of Unicode
 * symbols.
 * @memberOf punycode
 * @param {String} input The Punycode string of ASCII-only symbols.
 * @returns {String} The resulting string of Unicode symbols.
 */
const decode = function(input) {
	// Don't use UCS-2.
	const output = [];
	const inputLength = input.length;
	let i = 0;
	let n = initialN;
	let bias = initialBias;

	// Handle the basic code points: let `basic` be the number of input code
	// points before the last delimiter, or `0` if there is none, then copy
	// the first basic code points to the output.

	let basic = input.lastIndexOf(delimiter);
	if (basic < 0) {
		basic = 0;
	}

	for (let j = 0; j < basic; ++j) {
		// if it's not a basic code point
		if (input.charCodeAt(j) >= 0x80) {
			error('not-basic');
		}
		output.push(input.charCodeAt(j));
	}

	// Main decoding loop: start just after the last delimiter if any basic code
	// points were copied; start at the beginning otherwise.

	for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; /* no final expression */) {

		// `index` is the index of the next character to be consumed.
		// Decode a generalized variable-length integer into `delta`,
		// which gets added to `i`. The overflow checking is easier
		// if we increase `i` as we go, then subtract off its starting
		// value at the end to obtain `delta`.
		let oldi = i;
		for (let w = 1, k = base; /* no condition */; k += base) {

			if (index >= inputLength) {
				error('invalid-input');
			}

			const digit = basicToDigit(input.charCodeAt(index++));

			if (digit >= base || digit > floor((maxInt - i) / w)) {
				error('overflow');
			}

			i += digit * w;
			const t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);

			if (digit < t) {
				break;
			}

			const baseMinusT = base - t;
			if (w > floor(maxInt / baseMinusT)) {
				error('overflow');
			}

			w *= baseMinusT;

		}

		const out = output.length + 1;
		bias = adapt(i - oldi, out, oldi == 0);

		// `i` was supposed to wrap around from `out` to `0`,
		// incrementing `n` each time, so we'll fix that now:
		if (floor(i / out) > maxInt - n) {
			error('overflow');
		}

		n += floor(i / out);
		i %= out;

		// Insert `n` at position `i` of the output.
		output.splice(i++, 0, n);

	}

	return String.fromCodePoint(...output);
};

/**
 * Converts a string of Unicode symbols (e.g. a domain name label) to a
 * Punycode string of ASCII-only symbols.
 * @memberOf punycode
 * @param {String} input The string of Unicode symbols.
 * @returns {String} The resulting Punycode string of ASCII-only symbols.
 */
const encode = function(input) {
	const output = [];

	// Convert the input in UCS-2 to an array of Unicode code points.
	input = ucs2decode(input);

	// Cache the length.
	let inputLength = input.length;

	// Initialize the state.
	let n = initialN;
	let delta = 0;
	let bias = initialBias;

	// Handle the basic code points.
	for (const currentValue of input) {
		if (currentValue < 0x80) {
			output.push(stringFromCharCode(currentValue));
		}
	}

	let basicLength = output.length;
	let handledCPCount = basicLength;

	// `handledCPCount` is the number of code points that have been handled;
	// `basicLength` is the number of basic code points.

	// Finish the basic string with a delimiter unless it's empty.
	if (basicLength) {
		output.push(delimiter);
	}

	// Main encoding loop:
	while (handledCPCount < inputLength) {

		// All non-basic code points < n have been handled already. Find the next
		// larger one:
		let m = maxInt;
		for (const currentValue of input) {
			if (currentValue >= n && currentValue < m) {
				m = currentValue;
			}
		}

		// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
		// but guard against overflow.
		const handledCPCountPlusOne = handledCPCount + 1;
		if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
			error('overflow');
		}

		delta += (m - n) * handledCPCountPlusOne;
		n = m;

		for (const currentValue of input) {
			if (currentValue < n && ++delta > maxInt) {
				error('overflow');
			}
			if (currentValue === n) {
				// Represent delta as a generalized variable-length integer.
				let q = delta;
				for (let k = base; /* no condition */; k += base) {
					const t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
					if (q < t) {
						break;
					}
					const qMinusT = q - t;
					const baseMinusT = base - t;
					output.push(
						stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
					);
					q = floor(qMinusT / baseMinusT);
				}

				output.push(stringFromCharCode(digitToBasic(q, 0)));
				bias = adapt(delta, handledCPCountPlusOne, handledCPCount === basicLength);
				delta = 0;
				++handledCPCount;
			}
		}

		++delta;
		++n;

	}
	return output.join('');
};

/**
 * Converts a Punycode string representing a domain name or an email address
 * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
 * it doesn't matter if you call it on a string that has already been
 * converted to Unicode.
 * @memberOf punycode
 * @param {String} input The Punycoded domain name or email address to
 * convert to Unicode.
 * @returns {String} The Unicode representation of the given Punycode
 * string.
 */
const toUnicode = function(input) {
	return mapDomain(input, function(string) {
		return regexPunycode.test(string)
			? decode(string.slice(4).toLowerCase())
			: string;
	});
};

/**
 * Converts a Unicode string representing a domain name or an email address to
 * Punycode. Only the non-ASCII parts of the domain name will be converted,
 * i.e. it doesn't matter if you call it with a domain that's already in
 * ASCII.
 * @memberOf punycode
 * @param {String} input The domain name or email address to convert, as a
 * Unicode string.
 * @returns {String} The Punycode representation of the given domain name or
 * email address.
 */
const toASCII = function(input) {
	return mapDomain(input, function(string) {
		return regexNonASCII.test(string)
			? 'xn--' + encode(string)
			: string;
	});
};

/*--------------------------------------------------------------------------*/

/** Define the public API */
const punycode = {
	/**
	 * A string representing the current Punycode.js version number.
	 * @memberOf punycode
	 * @type String
	 */
	'version': '2.1.0',
	/**
	 * An object of methods to convert from JavaScript's internal character
	 * representation (UCS-2) to Unicode code points, and back.
	 * @see <https://mathiasbynens.be/notes/javascript-encoding>
	 * @memberOf punycode
	 * @type Object
	 */
	'ucs2': {
		'decode': ucs2decode,
		'encode': ucs2encode
	},
	'decode': decode,
	'encode': encode,
	'toASCII': toASCII,
	'toUnicode': toUnicode
};


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (punycode);


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./dist/index-exposed.js");
/******/ 	
/******/ })()
;
//# sourceMappingURL=quicksight-embedding-js-sdk.js.map