import { SimpleLineSeries, ISimpleLineSeriesSettings, ISimpleLineSeriesPrivate, ISimpleLineSeriesDataItem } from "./SimpleLineSeries";
import { ListTemplate } from "../../../core/util/List";
import { Triangle } from "../../../core/render/Triangle";
import type { IPoint } from "../../../core/util/IPoint";
export interface ILineArrowSeriesDataItem extends ISimpleLineSeriesDataItem {
}
export interface ILineArrowSeriesSettings extends ISimpleLineSeriesSettings {
    /**
     * Show a dotted line extending from both ends of the drawn line.
     *
     * @default true
     */
    showExtension?: boolean;
}
export interface ILineArrowSeriesPrivate extends ISimpleLineSeriesPrivate {
}
/**
 * Used for Line Arrow drawing tool in [[StockChart]].
 *
 * @since 5.10.5
 */
export declare class LineArrowSeries extends SimpleLineSeries {
    static className: string;
    static classNames: Array<string>;
    _settings: ILineArrowSeriesSettings;
    _privateSettings: ILineArrowSeriesPrivate;
    _dataItemSettings: ILineArrowSeriesDataItem;
    protected _arrows: Array<Triangle>;
    protected _afterNew(): void;
    clearDrawings(): void;
    _changed(): void;
    protected _applySettings(index: number, settings: {
        [index: string]: any;
    }): void;
    /**
     * @ignore
     */
    makeArrow(): Triangle;
    readonly arrows: ListTemplate<Triangle>;
    protected _updateLine(index: number, p11: IPoint, p22: IPoint, p1: IPoint, p2: IPoint): void;
}
//# sourceMappingURL=LineArrowSeries.d.ts.map