import * as $array from "../../../core/util/Array";
import { SimpleLineSeries } from "./SimpleLineSeries";
export class HorizontalRaySeries extends SimpleLineSeries {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "_tag", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "ray"
        });
    }
    _afterNew() {
        super._afterNew();
        this.lines.template.set("forceHidden", true);
    }
    _handleBulletDragged(event) {
        super._handleBulletDragged(event);
        const dataItem = event.target.dataItem;
        const dataContext = dataItem.dataContext;
        if (dataContext) {
            const index = dataContext.index;
            const diP1 = this._di[index]["p1"];
            const diP2 = this._di[index]["p2"];
            const movePoint = this._movePointerPoint;
            if (diP1 && diP2 && movePoint) {
                const yAxis = this.get("yAxis");
                const xAxis = this.get("xAxis");
                const valueX = this._getXValue(xAxis.positionToValue(xAxis.coordinateToPosition(movePoint.x)));
                const valueY = this._getYValue(yAxis.positionToValue(yAxis.coordinateToPosition(movePoint.y)), valueX);
                const min = xAxis.getPrivate("min", 0);
                const max = xAxis.getPrivate("max", 1);
                this._setContext(diP1, "valueY", valueY, true);
                this._setContext(diP2, "valueY", valueY, true);
                this._setContext(diP1, "valueX", valueX);
                this._setContext(diP2, "valueX", max + (max - min));
                this._setXLocation(diP1, diP1.get("valueX", 0));
                this._positionBullets(diP1);
            }
        }
    }
    _prepareChildren() {
        const xAxis = this.get("xAxis");
        const min = xAxis.getPrivate("min", 0);
        const max = xAxis.getPrivate("max", 1);
        $array.each(this._di, (di) => {
            if (di) {
                this._setContext(di["p2"], "valueX", max + (max - min), true);
            }
        });
        super._prepareChildren();
    }
    _handlePointerMoveReal() {
    }
    _updateSegment(index) {
        if (this._di[index]) {
            const diP2 = this._di[index]["p2"];
            if (diP2) {
                const xAxis = this.get("xAxis");
                const min = xAxis.getPrivate("min", 0);
                const max = xAxis.getPrivate("max", 1);
                this._setContext(diP2, "valueX", max + (max - min), true);
            }
        }
    }
    _handlePointerClickReal(event) {
        if (this._drawingEnabled) {
            if (!this._isDragging) {
                if (this.unselectAllDrawings() == 0) {
                    this._increaseIndex();
                    this._addPoints(event, this._index);
                    this.isDrawing(false);
                    this._hideResizer();
                    this._updateSegment(this._index);
                    this._dispatchStockEvent("drawingadded", this._drawingId, this._index);
                }
            }
        }
    }
}
Object.defineProperty(HorizontalRaySeries, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "HorizontalRaySeries"
});
Object.defineProperty(HorizontalRaySeries, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: SimpleLineSeries.classNames.concat([HorizontalRaySeries.className])
});
//# sourceMappingURL=HorizontalRaySeries.js.map