/**
 * amis-formula v6.1.0
 * Copyright 2021-2024 fex
 */

'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var tslib = require('tslib');
var evalutor = require('./evalutor.js');
var evalutorForAsync = require('./evalutorForAsync.js');
var parser = require('./parser.js');
var lexer = require('./lexer.js');
var filter = require('./filter.js');
var _function = require('./function.js');

function evaluate(astOrString, data, options) {
    var ast = astOrString;
    if (typeof astOrString === 'string') {
        ast = parser.parse(astOrString, options);
    }
    return new evalutor.Evaluator(data, options).evalute(ast);
}
function evaluateForAsync(astOrString, data, options) {
    return tslib.__awaiter(this, void 0, void 0, function () {
        var ast;
        return tslib.__generator(this, function (_a) {
            ast = astOrString;
            if (typeof astOrString === 'string') {
                ast = parser.parse(astOrString, options);
            }
            return [2 /*return*/, new evalutorForAsync.AsyncEvaluator(data, options).evalute(ast)];
        });
    });
}
evalutor.Evaluator.setDefaultFilters(filter.getFilters());
evalutorForAsync.AsyncEvaluator.setDefaultFilters(filter.getFilters());

exports.Evaluator = evalutor.Evaluator;
exports.AsyncEvaluator = evalutorForAsync.AsyncEvaluator;
exports.parse = parser.parse;
exports.lexer = lexer.lexer;
exports.extendsFilters = filter.extendsFilters;
exports.filters = filter.filters;
exports.getFilters = filter.getFilters;
exports.registerFilter = filter.registerFilter;
exports.functionDocs = _function.functionDocs;
exports.registerFunction = _function.registerFunction;
exports.registerFunctionDoc = _function.registerFunctionDoc;
exports.evaluate = evaluate;
exports.evaluateForAsync = evaluateForAsync;
